/* show-semaphore.c: shows semaphores */
/*

Copyright (C) 2007 by Daigo Tomono <tomono at subaru.naoj.org>

Permission is granted for use, copying, modification, distribution,
and distribution of modified versions of this work under the terms of
GPL version 2 or later.

*/

/* If we're not using GNU C, elide __attribute__ */
#ifndef __GNUC__
#define  __attribute__(x)  /*NOTHING*/
#endif

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#define __USE_XOPEN
#include <sys/ipc.h>
#include <sys/sem.h>

union semun {
	struct semid_ds *buf;
};

int
main(int argc, char *argv[])
{
	int id, key;
	unsigned int i;
	union semun semctl_arg;
	struct semid_ds buf;

	if (2 != argc)
		{
			fprintf(stderr, "usage: %s semaphore-key-number - shows info of the semaphore\n", argv[0]);
			exit(EXIT_FAILURE);
		}

	key = atoi(argv[1]);
	id = semget(key, 0, 0);
	if (id < 0)
		{
			perror("semget()");
			exit(EXIT_FAILURE);
		}

	semctl_arg.buf = &buf;
	if (semctl(id, 0, IPC_STAT, semctl_arg))
		{
			perror("semctl()");
			exit(EXIT_FAILURE);
		}

	fprintf(stdout, "uid: %d\n", semctl_arg.buf->sem_perm.uid);
	fprintf(stdout, "gid: %d\n", semctl_arg.buf->sem_perm.gid);
	fprintf(stdout, "cuid: %d\n", semctl_arg.buf->sem_perm.cuid);
	fprintf(stdout, "cgid: %d\n", semctl_arg.buf->sem_perm.cgid);
	fprintf(stdout, "permission: %o\n", semctl_arg.buf->sem_perm.mode);
	fprintf(stdout, "number of semaphores: %lu\n", semctl_arg.buf->sem_nsems);

	for(i = 0; i < semctl_arg.buf->sem_nsems; i++)
		{
			fprintf(stdout, "value of No.%d: %d\n", i, semctl(id, i, GETVAL, 0));
		}

	return EXIT_SUCCESS;
}
