/* tws_tsc_short_svc_proc.c: copies status into legacy shared memory */
/* copied from tws4:/home/morino/test and edited */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <errno.h>
#include <stdio.h>
#include <fcntl.h>
#include <sys/mman.h>
#include <sys/ipc.h>
#include <sys/sem.h>
#include <unistd.h>
#include <sys/types.h>

#include "tws_tsc_shm.h"

/* include path to be specified in Makefile */
#include "tws_tsc_short.h"

#define TSCS_SHM_NAME "/tscs"
#define TSCS_BUFFER_SIZE 1292
#define TSCS_SEMAPHORE_KEY 129

/*
 * No.0: 0:writable 1:not writable to the shared memory
 * No.1: 0:no new data 1:new data
 */
static int shm_fd = -1;
static int sem_id = -1;
union semun
{
  int val;
};

static char *sm;

void
init_tscs_shm(void)
{
  int shmid;

  if ((shmid = shmget(0x100, TSCS_BUFFER_SIZE, 0666 | IPC_CREAT)) < 0)
		{
			perror("shmget() for legacy TSCS");
			return;
		}
  if ((sm = (char *) shmat(shmid, (char *) 0, 0)) == (char *) -1)
		{
			perror("shmat() for legacy TSCS");
			return;
		}

  shm_fd = shm_open(TSCS_SHM_NAME, O_CREAT | O_RDWR, 0644);
  if (shm_fd < 0)
		{
			perror("shm_open() for legacy TSCS");
			return;
		}

	sem_id = semget(TSCS_SEMAPHORE_KEY, 2, IPC_CREAT | 0666);
	if (sem_id < 0)
		{
			perror("semget(,,IPC_CREAT) for legacy TSCS");
			shm_fd = -1;
			return;
		}
}

void copy_tscs_shm(char *data, size_t length)
{
	memcpy(sm, data, TSCS_BUFFER_SIZE);

  if (shm_fd > 0)
    {
      int not_writable;
      struct sembuf sops;
			union semun arg;

			/* check if writable */
			sops.sem_num = 0;
			sops.sem_op = 0;
			sops.sem_flg = IPC_NOWAIT;
			not_writable = semop (sem_id, &sops, 1);
			if (not_writable) return;
				
      if (ftruncate(shm_fd, TSCS_BUFFER_SIZE) < 0)
				{
					perror("ftruncate() for legacy TSCS");
					return;
				}
			if (lseek(shm_fd, 0, SEEK_SET) < 0)
				{
					perror("lseek() for legacy TSCS");
					return;
				}
			if (write (shm_fd, data, length) < length)
				{
					perror("write() for legacy TSCS");
					return;
				}
			arg.val = 1;
			if (semctl (sem_id, 1, SETVAL, arg) < 0)
				{
					perror ("semctl(,,SETVAL) for legacy TSCS");
				}
    }
}
