/* command-delegator.h : delegates command from local applications */
/*

Copyright (C) 2005 by Daigo Tomono <tomono at subaru.naoj.org>

Permission is granted for use, copying, modification, distribution,
and distribution of modified versions of this work under the terms of
GPL version 2 or later.

*/

#ifndef COMMAND_DELEGATOR_H
#define COMMAND_DELEGATOR_H

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

#include <melco/tsc-message.h>
#include <tws4/command-delegation.h>

#define RESPONSE_TIMEOUT 1	/* seconds before suspending to send commands */
#define FD_FORGET_AFTER 5	/* secnods after response should have been received before forgetting seqnum - fd connection */
#define LOOP_PERIOD 1	/* every - seconds checking timeout for completion */
#define ERROR_LINE_SIZE 161	/* max length of error */

/* call back functions to log the activities */
typedef void (*command_logger_callback_t)(CommandMessage* message);
typedef void (*reception_logger_callback_t)(ReceptionResponseMessage* message);
typedef void (*completion_logger_callback_t)(CompletionResponseMessage* message);
typedef void (*error_logger_callback_t)(char *string);

typedef struct {
	command_logger_callback_t command;
	reception_logger_callback_t reception;
	completion_logger_callback_t completion;
	error_logger_callback_t error;
} logger_functions_s;

/* functions to send and receive messages */
/* send the Command Message and return number bytes sent or -1 for an error */
typedef ssize_t (*CommandMessage_send_t)(const CommandMessage *message, int uid, int gid, void *args);
/* receive Response Messages and write to fd, must not return */
typedef void (*message_waiter_t)(int outputfd, void *args);

/* returns number of messages processed before receiving ^D or -1 for error */
long command_delegator(
	struct sockaddr_in *myaddr,
	/* worker functions to send and receive commands */
	CommandMessage_send_t sender,
	void *sender_args,
	message_waiter_t waiter,
	void *waiter_args,
	/* callbacks for log: this or some member can be NULL */
	logger_functions_s *logger_functions
);

#endif	/* COMMAND_DELEGATOR_H */
