/* dummy-tsc.c : dummy tsc */
/*

Copyright (C) 2005 by Daigo Tomono <tomono at subaru.naoj.org>

Permission is granted for use, copying, modification, distribution,
and distribution of modified versions of this work under the terms of
GPL version 2 or later.

*/

#define CMDBUFLEN 1024

/* If we're not using GNU C, elide __attribute__ */
#ifndef __GNUC__
#define  __attribute__(x)  /*NOTHING*/
#endif

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <string.h>

#include <melco/tsc-message.h>
#include <test-tsc/command-dispatcher.h>

#ifdef COUNT_MALLOC
#include <count-malloc.h>
#endif

int
main(void)
{
	int waitsec = 2;
	int success = 1;
	int child_status;

	fputs("waiting for commands from stdin ...\n", stderr);
	while(1)
		{
			ReceptionResponseMessage *r;
			char buf[CMDBUFLEN];

			fgets(buf, sizeof(buf), stdin);
			if (feof(stdin)) break;
			if (buf[strlen(buf)-1] == '\n') buf[strlen(buf)-1] = '\0';

			r = tsc_execute(buf, NULL, NULL, response_ok, response_complete, waitsec, waitsec, 0, -1);
			if (r->result != response_ok) success = 0;
			ReceptionResponseMessage_decref(r);
		}

	fputs("waiting for unfinished commands ...\n", stderr);
	while(wait(&child_status) != -1)
		{
			if (!WIFEXITED(child_status) || WEXITSTATUS(child_status) != EXIT_SUCCESS) success = 0;
		}
	fputs("... done\n", stderr);
	return success ? EXIT_SUCCESS : EXIT_FAILURE;
}
