/* command-dispatcher.h : pretends command interface of TSC */
/*

Copyright (C) 2005 by Daigo Tomono <tomono at subaru.naoj.org>

Permission is granted for use, copying, modification, distribution,
and distribution of modified versions of this work under the terms of
GPL version 2 or later.

*/

#ifndef COMMAND_DISPATCHER_H
#define COMMAND_DISPATCHER_H

#include <melco/tsc-message.h>

#define TSC_COMM_FORMAT "TSC:%-8.8s "	/* command/received/complete */

typedef void (*tsc_completion_callback_t)(const CompletionResponseMessage *message);

/* receives a command, returns a response with RECEPTION, and fork(2)s */
/* child process waits for WAIT second and calls CALLBACK with COMPLETION */
/* caller has to take care of the children */
ReceptionResponseMessage* tsc_execute(char *command, void (*command_free)(void* ptr), tsc_completion_callback_t callback, response_message_t reception, response_message_t completion, int headerwait, int realwait, int responsewait, int fd);

/* results will be random if waitsec < 0 (to be used as random seed) */
/* children are taken care of within the function */
void tsc_server(int output_fd, int input_fd, int waitsec);

/* selections in random mode */
#define REC_RES {response_ok, response_ok, response_ok, response_ng, response_locked}
#define COM_RES {response_complete, response_complete,response_complete,  response_complete, response_complete, response_timeout, response_cancel, response_err_comm}
#define RANDOM_WAIT_MAX 1

/* dummy login information */
typedef struct _tsc_login {
	char *username;
	char *password;
	int uid;
	int gid;
	int level;
	int lang;
} tsc_login_s;

#endif
