/* test-status-ids.c: test cases for status-ids.c */
/*

Copyright (C) 2005 by Daigo Tomono <tomono at subaru.naoj.org>

Permission is granted for use, copying, modification, distribution,
and distribution of modified versions of this work under the terms of
GPL version 2 or later.

*/

/* If we're not using GNU C, elide __attribute__ */
#ifndef __GNUC__
#define  __attribute__(x)  /*NOTHING*/
#endif

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#include <melco/status-ids.h>

#ifdef COUNT_MALLOC
#include <count-malloc.h>
#endif

void test_melco_status_from_id(void);

void
test_melco_status_from_id(void)
{
	struct melco_status_s* t;
	assert(NULL == melco_status_from_id(0x0));
	t = melco_status_from_id(0x00A1043);
	assert(t);
	assert(!strcmp("Right Ascention", t->name));
	t = melco_status_from_id(0x0001016);
	assert(t);
	assert(!strcmp("Dome Cable Overlap +", t->name));
}

int
main(int argc __attribute__ ((unused)), char *argv[])
{ 
  fprintf(stderr, "%s running\n", argv[0]);
	test_melco_status_from_id();
	return EXIT_SUCCESS;
}
