/* test-status-hash.c: test cases for status-hash.c */
/*

Copyright (C) 2005 by Daigo Tomono <tomono at subaru.naoj.org>

Permission is granted for use, copying, modification, distribution,
and distribution of modified versions of this work under the terms of
GPL version 2 or later.

*/

/* If we're not using GNU C, elide __attribute__ */
#ifndef __GNUC__
#define  __attribute__(x)  /*NOTHING*/
#endif

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#include <melco/status-hash.h>
#ifndef TOTAL_KEYWORDS
#define TOTAL_KEYWORDS 27335 
/* this number has to be copied from status-hash.c */
#endif

#ifdef COUNT_MALLOC
#include <count-malloc.h>
#endif

#define FIRST_ENTRY_NAME "Dome Real Angle"
#define LAST_ENTRY_NAME "Actuator8-69 Alarm Reset"
/* these should be copied from first and last entry of _status_entry_array[] in status-hash.c */

void test_melco_status_total(void);
void test_melco_status_ith(void);
void test_melco_status_info(void);

void
test_melco_status_total(void)
{
	assert(TOTAL_KEYWORDS == melco_status_total());
}

void
test_melco_status_ith(void)
{
	assert(NULL == melco_status_ith(-1));
	assert(NULL == melco_status_ith(TOTAL_KEYWORDS));
	assert(!strcmp(FIRST_ENTRY_NAME, melco_status_ith(0)->name));
	assert(!strcmp(LAST_ENTRY_NAME, melco_status_ith(TOTAL_KEYWORDS-1)->name));
}

void
test_melco_status_info(void)
{
	int i;
	struct melco_status_s* info;
	struct {
		char *name;
		char *type;
		unsigned int shortid;
		unsigned int id;
		unsigned isalarm:1;
		unsigned iswarning:1;
		unsigned isfault:1;
	} names[] = {
		{"Dome - MLP1 Fault", "E", 0x00B1, 0x00B1001, 1, 0, 0},
		{"InR/ImR SYNC Mode", "E", 0x00B1, 0X00B1013, 0, 0, 0},
		{"MLP1 Fault on MLP1", "E", 0x00B1, 0x00B1033, 1, 0, 1},
		{"SH Test A00 Warning", "E", 0x00A1, 0x00A1262, 0, 1, 0},
		{NULL, NULL, 0, 0, 0, 0, 0},
	};

	for(i = 0; names[i].name; i++)
		{
			info = melco_status_lookup(names[i].name, strlen(names[i].name));
			fprintf(stderr, "%s -> %p: ", names[i].name, info);
			assert(info);
			//fprintf(stderr, "%s %04X %07X %d %d %d\n", info->type, info->shortid, info->id, info->isalarm, info->iswarning, info->isfault);
			assert(!strcmp(names[i].type, info->type));
			assert(names[i].shortid == info->shortid);
			assert(names[i].id == info->id);
			assert(names[i].isalarm == info->isalarm);
			assert(names[i].iswarning == info->iswarning);
			assert(names[i].isfault == info->isfault);
		}
}

int
main(int argc __attribute__ ((unused)), char *argv[])
{ 
  fprintf(stderr, "%s running\n", argv[0]);
	test_melco_status_total();
	test_melco_status_ith();
	test_melco_status_info();
	return EXIT_SUCCESS;
}
