/* test-status-bank.c : test cases for status-bank.c */
/*

Copyright (C) 2005 by Daigo Tomono <tomono at subaru.naoj.org>

Permission is granted for use, copying, modification, distribution,
and distribution of modified versions of this work under the terms of
GPL version 2 or later.

*/

/* If we're not using GNU C, elide __attribute__ */
#ifndef __GNUC__
#define  __attribute__(x)  /*NOTHING*/
#endif

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#include <melco/tsc-message.h>
#include <count-malloc.h>

int
main(int argc __attribute__ ((unused)), char *argv[])
{
	StatusBank db;
	MonitorDataMessage *m;
	int i, j;
	char l = '2';

	fprintf(stderr, "%s running\n", argv[0]);
	assert(m = MonitorDataMessage_alloc());	/* dummy message */
	assert(StatusBank_init(&db));
	l = 2;
	for(i = 0; i < MELCO_TREE_LENGTH; i++)
		{
			InstrumentStatus *s;
			s = InstrumentStatus_alloc(m);	/* dummy status */
			s->shortid = melco_tree_shortid[i];
			strncpy(s->type, melco_tree_type[i], sizeof(s->type));
			s->type[sizeof(s->type)] = '\0';
			assert(StatusBank_register_inst(&db, s) == s);
		}
	for(i = MELCO_TREE_LENGTH/3, j = 0; i < MELCO_TREE_LENGTH/2; i++)
		{
			assert(StatusBank_get_inst(&db, melco_tree_type[i], melco_tree_shortid[i]));
			assert(StatusBank_discard_inst(&db, melco_tree_type[i], melco_tree_shortid[i]));
			j++;
		}
	assert(StatusBank_discard_all_inst(&db) == MELCO_TREE_LENGTH);

	return EXIT_SUCCESS;
}
