/* test-snprintf-compat.c: test cases for snprintf-compat.c */
/*

Copyright (C) 2005 by Daigo Tomono <tomono at subaru.naoj.org>

Permission is granted for use, copying, modification, distribution,
and distribution of modified versions of this work under the terms of
GPL version 2 or later.

*/

/* If we're not using GNU C, elide __attribute__ */
#ifndef __GNUC__
#define  __attribute__(x)  /*NOTHING*/
#endif

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

#include <melco/snprintf-compat.h>

#ifdef COUNT_MALLOC
#include <count-malloc.h>
#endif

int
main(int argc __attribute__ ((unused)), char *argv[])
{ 
	fprintf(stderr, "%s running\n", argv[0]);
	assert(11 == snprintf_length("%s", "hello world"));
	assert(3 == snprintf_length("%d", 100));
	assert(10 == snprintf_length("%10g", 100.0));

	return EXIT_SUCCESS;
}

