/* test-message-header.c: test cases for message_header.c */
/*

Copyright (C) 2005 by Daigo Tomono <tomono at subaru.naoj.org>

Permission is granted for use, copying, modification, distribution,
and distribution of modified versions of this work under the terms of
GPL version 2 or later.

*/

/* If we're not using GNU C, elide __attribute__ */
#ifndef __GNUC__
#define  __attribute__(x)  /*NOTHING*/
#endif

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#include <melco/status-types.h>
#include <melco/tsc-message.h>

#ifdef COUNT_MALLOC
#include <count-malloc.h>
#endif

int
main(void)
{
	char data[] = "MOOBS%TSC%00002005020910000051255";
	char buf[5];
	message_header_s* t;

	t = (message_header_s*) data;

	assert(!strcmp(message_header_type(t, buf), "MO"));
	assert(!strcmp(message_header_dst(t, buf), "OBS%"));
	assert(!strcmp(message_header_src(t, buf), "TSC%"));
	assert(message_header_pid(t) == 0);
	assert(!memcmp((char *)message_header_txtime(t), "200502091000005", sizeof(ASC15_TIME)));
	assert(message_header_length(t) == 1255);
	return EXIT_SUCCESS;
}

