/* test-message.c: test cases for tsc-message.c */
/*

Copyright (C) 2005 by Daigo Tomono <tomono at subaru.naoj.org>

Permission is granted for use, copying, modification, distribution,
and distribution of modified versions of this work under the terms of
GPL version 2 or later.

*/

/* If we're not using GNU C, elide __attribute__ */
#ifndef __GNUC__
#define  __attribute__(x)  /*NOTHING*/
#endif

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#include <melco/tsc-message.h>
#include <count-malloc.h>

void test_MonitorDataMessage(void);
void test_InstrumentStatus(void);
void test_StatusEntry(void);

void
test_MonitorDataMessage(void)
{
	MonitorDataMessage s;
	MonitorDataMessage *p1, *p2;

	p1 = &s;
	MonitorDataMessage_init(p1);
	assert(p2 = MonitorDataMessage_alloc());
	assert(p1 = MonitorDataMessage_incref(p1));
	assert(p1 = MonitorDataMessage_incref(p1));
	assert(p2 = MonitorDataMessage_incref(p2));
	assert(!(p2 = MonitorDataMessage_decref(p2)));
	MonitorDataMessage_free(p1);
	MonitorDataMessage_free(p2);
}

void
test_InstrumentStatus(void)
{
	InstrumentStatus s;
	InstrumentStatus *p1, *p2;

	/* no parent */
	p1 = &s;
	InstrumentStatus_init(p1, NULL);
	assert(p2 = InstrumentStatus_alloc(NULL));
	assert(p1 = InstrumentStatus_incref(p1));
	assert(p1 = InstrumentStatus_incref(p1));
	assert(p2 = InstrumentStatus_incref(p2));
	assert(!(p2 = InstrumentStatus_decref(p2)));
	InstrumentStatus_free(p1);
	InstrumentStatus_free(p2);

	/* with a parent */
	{
		MonitorDataMessage *p;
		assert(p = MonitorDataMessage_alloc());
		assert(p1 = InstrumentStatus_alloc(p));
		assert(p1 = InstrumentStatus_incref(p1));
		assert(!(p1 = InstrumentStatus_decref(p1)));
	}
}

void
test_StatusEntry(void)
{
	StatusEntry s;
	StatusEntry *p1, *p2;

	/* no parent */
	p1 = &s;
	StatusEntry_init(p1, NULL);
	assert(p2 = StatusEntry_alloc(NULL));
	assert(p1 = StatusEntry_incref(p1));
	assert(p1 = StatusEntry_incref(p1));
	assert(p2 = StatusEntry_incref(p2));
	assert(!(p2 = StatusEntry_decref(p2)));
	StatusEntry_free(p1);
	StatusEntry_free(p2);

	/* with parents */
	{
		MonitorDataMessage *g;
		InstrumentStatus *p;
		assert(g = MonitorDataMessage_alloc());
		assert(p = InstrumentStatus_alloc(g));
		assert(p1 = StatusEntry_alloc(p));
		assert(!(p1 = StatusEntry_decref(p1)));
	}
}

int
main(void)
{ 
	test_MonitorDataMessage();
	test_InstrumentStatus();
	test_StatusEntry();
	return EXIT_SUCCESS;
}
