/* status-ids.c: handling of status entries by their IDs */
/*

Copyright (C) 2005 by Daigo Tomono <tomono at subaru.naoj.org>

Permission is granted for use, copying, modification, distribution,
and distribution of modified versions of this work under the terms of
GPL version 2 or later.

*/

#include <stdio.h>
#include <stdlib.h>
#include <melco/status-hash.h>
#include <melco/status-ids.h>

int _compar_status_id(const void *key, const void *member);

int
_compar_status_id(const void *key, const void *member)
{
	if (*((unsigned int *) key) < ((struct melco_status_s*) member)->id) return -1;
	if (*((unsigned int *) key) > ((struct melco_status_s*) member)->id) return 1;
	return 0;
}

struct melco_status_s*
melco_status_from_id(const unsigned int id)
{
	return (struct melco_status_s*) bsearch((void *) &id, (void *) melco_status_ith(0), melco_status_total(), sizeof(struct melco_status_s), _compar_status_id);
}

