/* tsc-message.h: header file for tsc-message.c */
/*

Copyright (C) 2005 by Daigo Tomono <tomono at subaru.naoj.org>

Permission is granted for use, copying, modification, distribution,
and distribution of modified versions of this work under the terms of
GPL version 2 or later.

 */

#ifndef TSCSTATUS_H
#define TSCSTATUS_H

#include <Python.h>
#include <structmember.h>

#include <melco/tsc-message.h>

/* Exceptions */
extern PyObject *P_FileFormatError;	/* tsc_error_malformed */

/* StatusBank - status from files */
typedef struct {
	PyObject_HEAD
	StatusBank *cdata;
} P_StatusBank;

void P_StatusBank_dealloc(P_StatusBank *self);
PyObject *P_StatusBank_new(PyTypeObject *type, PyObject *args);
PyObject *P_StatusBank_scan(P_StatusBank *self, PyObject *args);
PyObject *P_StatusBank_get_entry(P_StatusBank *self, PyObject *args);

extern PyMemberDef P_StatusBank_members[];
extern PyMethodDef P_StatusBank_methods[];
extern PyTypeObject P_StatusBankType;

/* SharedStatus - status on the POSIX shared memory */
typedef struct {
	PyObject_HEAD
} P_SharedStatus;

void P_SharedStatus_dealloc(P_SharedStatus *self);
PyObject *P_SharedStatus_new(PyTypeObject *type, PyObject *args);
PyObject *P_SharedStatus_get_entry(P_SharedStatus *self, PyObject *args);

extern PyMemberDef P_SharedStatus_members[];
extern PyMethodDef P_SharedStatus_methods[];
extern PyTypeObject P_SharedStatusType;

/* StatusEntry */
typedef struct {
	PyObject_HEAD
	StatusEntry* cdata;
} P_StatusEntry;

void P_StatusEntry_dealloc(P_StatusEntry *self);
PyObject *P_StatusEntry_new(PyTypeObject *type, PyObject *args);

PyObject *P_StatusEntry_info(P_StatusEntry *self, PyObject *args);
PyObject *P_StatusEntry_float(P_StatusEntry *self, PyObject *args);
PyObject *P_StatusEntry_long(P_StatusEntry *self, PyObject *args);
PyObject *P_StatusEntry_str(P_StatusEntry *self, PyObject *args);
PyObject *P_StatusEntry_time(P_StatusEntry *self, PyObject *args);
PyObject *P_StatusEntry_val(P_StatusEntry *self, PyObject *args);
PyObject *P_StatusEntry_rxtime(P_StatusEntry *self, PyObject *args);

/* only in C */
void P_StatusEntry_set(P_StatusEntry* self, StatusEntry *data);

extern PyMemberDef P_StatusEntry_members[];
extern PyMethodDef P_StatusEntry_methods[];
extern PyTypeObject P_StatusEntryType;

/* melco_status_s - known as entryinfo in Python */
typedef struct {
	PyObject_HEAD
	const struct melco_status_s* cdata;	/* always static */
} P_EntryInfo;

void P_EntryInfo_dealloc(P_EntryInfo *self);
PyObject *P_EntryInfo_new(PyTypeObject *type, PyObject *args);
int P_EntryInfo_init(P_EntryInfo *self, PyObject *args);

PyObject *P_EntryInfo_name(P_EntryInfo *self, PyObject *args);
PyObject *P_EntryInfo_type(P_EntryInfo *self, PyObject *args);
PyObject *P_EntryInfo_shortid(P_EntryInfo *self, PyObject *args);
PyObject *P_EntryInfo_id(P_EntryInfo *self, PyObject *args);
PyObject *P_EntryInfo_offset(P_EntryInfo *self, PyObject *args);
PyObject *P_EntryInfo_length(P_EntryInfo *self, PyObject *args);
PyObject *P_EntryInfo_mask(P_EntryInfo *self, PyObject *args);

PyObject *P_EntryInfo_parentid(P_EntryInfo *self, PyObject *args);

PyObject *P_EntryInfo_is_flag(P_EntryInfo *self, PyObject *args);
PyObject *P_EntryInfo_is_numeric(P_EntryInfo *self, PyObject *args);
PyObject *P_EntryInfo_is_string(P_EntryInfo *self, PyObject *args);
PyObject *P_EntryInfo_is_time(P_EntryInfo *self, PyObject *args);

/* only in C */
void P_EntryInfo_set(P_EntryInfo* self, const struct melco_status_s *info);

extern PyMemberDef P_EntryInfo_members[];
extern PyMethodDef P_EntryInfo_methods[];
extern PyTypeObject P_EntryInfoType;

#endif	/* TSCSTATUS_H */
