#!/usr/bin/python

# default source directory
top_srcdir = '..'

# add module paths
import os
import sys
import glob
for d in glob.glob(os.path.join('.', 'build', 'lib*')):
	sys.path.insert(0, d)

# prepare for test
import unittest
import tscstatus

class EntryInfoTestCase(unittest.TestCase):
	def testNew(self):
		self.assertRaises(TypeError, tscstatus.entryinfo)
	def testRegistered(self):
		assert(27335 == tscstatus.entries)
		# should be TOTAL_KEYWORDS in ../status-hash.c
	def testInit(self):
		self.assertRaises(KeyError, tscstatus.entryinfo, -1)
		self.assertRaises(KeyError, tscstatus.entryinfo, "foo")
		print tscstatus.entryinfo(0)
		print tscstatus.entryinfo("Dome Position Mode")
		print tscstatus.entryinfo("Auto Guide EL Error Correct Angle in S")
	def testMethods(self):
		t = tscstatus.entryinfo("Dome Position Mode")
		assert("Dome Position Mode" == t.name())
		assert("0001E" == t.parentid())
		assert("E" == t.type())
		assert(0x0001 == t.shortid())
		assert(0x000100D == t.id())
		assert(0 == t.offset())
		assert(1 == t.length())
		assert(0x01 == t.mask())
		assert(t.is_flag())
		assert(not t.is_numeric())
		assert(not t.is_string())
		assert(not t.is_time())
		t = tscstatus.entryinfo("AG Binning Pattern")
		assert(not t.is_flag())
		assert(t.is_numeric())
		assert(not t.is_string())
		assert(not t.is_time())
		t = tscstatus.entryinfo("Observer")
		assert(not t.is_flag())
		assert(not t.is_numeric())
		assert(t.is_string())
		assert(not t.is_time())
		t = tscstatus.entryinfo("Alarm Detected Time")
		assert(not t.is_flag())
		assert(not t.is_numeric())
		assert(not t.is_string())
		assert(t.is_time())
		t = tscstatus.entryinfo("Dome - MLP1 Fault")
		assert(t.is_alarm())
		assert(not t.is_warning())
		assert(not t.is_fault())
		t = tscstatus.entryinfo("InR/ImR SYNC Mode")
		assert(not t.is_alarm())
		assert(not t.is_warning())
		assert(not t.is_fault())
		t = tscstatus.entryinfo("MLP1 Fault on MLP1")
		assert(t.is_alarm())
		assert(not t.is_warning())
		assert(t.is_fault())
		t = tscstatus.entryinfo("SH Test A00 Warning")
		assert(not t.is_alarm())
		assert(t.is_warning())
		assert(not t.is_fault())

class StatusBankTestCase(unittest.TestCase):
	def testFind(self):
		d = tscstatus.statusbank()
		for f in [ 'TSCL20050209-L1-L7.bin', 'TSCS20050209-2sets.bin', 'TSCV20050209-10sets.bin' ]:
			file = open(os.path.join(top_srcdir, 'test-data', f))
			while 1:
				try:
					d.scan(file, 'fujitsu')
				except EOFError:
					break
			file.close()
		e = d.entry("TSC Outdoor Wind Velocity")
		assert(0 == e.val())
		assert(0.0 == e.float())
		assert("0.00000000" == e.str())
		assert(1107943200.4 == e.rxtime())
		self.assertRaises(KeyError, d.entry, "no entry")
		assert("Sugai" == d.e("Observer").val())

if __name__ == "__main__":
	top_srcdir = sys.argv.pop(1)
	unittest.main(testRunner=unittest.TextTestRunner(verbosity=2))
