/* sharedstatus.c: tscstatus.sharedstatus */
/*

Copyright (C) 2005 by Daigo Tomono <tomono at subaru.naoj.org>

Permission is granted for use, copying, modification, distribution,
and distribution of modified versions of this work under the terms of
GPL version 2 or later.

 */

#ifndef __GNUC__
#define  __attribute__(x)  /*NOTHING*/
#endif

#include <Python.h>

#include <assert.h>

#include <tscstatus.h>
#include <melco/tsc-message.h>
#include <melco/shm-interface.h>
#include <melco/status-hash.h>

/* this is a singleton class */
P_SharedStatus* _P_SharedStatus = NULL;

void
P_SharedStatus_dealloc(P_SharedStatus *self)
{
	instrumentstatus_shm_unmap_all();
	self->ob_type->tp_free((PyObject*)self);
}

PyObject*
P_SharedStatus_new(PyTypeObject *type, PyObject *args __attribute__ ((unused)))
{
	if (!_P_SharedStatus)
		{
			_P_SharedStatus = (P_SharedStatus *)type->tp_alloc(type, 0);
			if (!_P_SharedStatus) return (PyObject*) _P_SharedStatus;
		}
	else
		{
			Py_XINCREF(_P_SharedStatus);
		}

	return (PyObject*) _P_SharedStatus;
}

PyObject *
P_SharedStatus_get_entry(P_SharedStatus *self __attribute__ ((unused)), PyObject *args)
{
	PyObject *p_name, *r;
	StatusEntry *e;
	char *name;

	/* parse arguments - name of the requested entry */
	if (!PyArg_ParseTuple(args, "S", &p_name)) return NULL;
	Py_XINCREF(p_name);
	name = PyString_AsString(p_name);

	/* check name */
	if (!melco_status_lookup(name, strlen(name)))
		{
			PyErr_Format(PyExc_KeyError, "no status entry named \"%s\"", name);
			Py_XDECREF(p_name);
			return NULL;
		}

	/* look up */
	e = shm_get_status_entry(name);
	if (!e)
		{
			PyErr_Format(PyExc_KeyError, "have not received \"%s\"", name);
			Py_XDECREF(p_name);
			return NULL;
		}
	Py_XDECREF(p_name);

	r = (PyObject*) P_StatusEntry_new(&P_StatusEntryType, Py_None);
	if (!r)
		{
			PyErr_NoMemory();
			return NULL;
		}
	P_StatusEntry_set((P_StatusEntry*) r, e);
	Py_XINCREF(r);

	return r;
}


PyMemberDef P_SharedStatus_members[] = {
	{NULL, 0, 0, 0, NULL}	/* Sentinel */
};

PyMethodDef P_SharedStatus_methods[] = {
	{"entry", (PyCFunction)P_SharedStatus_get_entry, METH_VARARGS,
	 "retrieves a statusentry"},
	{"e", (PyCFunction)P_SharedStatus_get_entry, METH_VARARGS,
	 "retrieves a statusentry"},
	{NULL, NULL, 0, NULL}	/* Sentinel */
};

PyTypeObject P_SharedStatusType = {
	PyObject_HEAD_INIT(NULL)
	0,                                   /* ob_size */
	"tscstatus.sharedstatus",            /* tp_name */
	sizeof(P_SharedStatus),              /* tp_basicsize */
	0,                                   /* tp_itemsize */
	(destructor)P_SharedStatus_dealloc,  /* tp_dealloc */
	0,                                   /* tp_print */
	0,                                   /* tp_getattr */
	0,                                   /* tp_setattr */
	0,                                   /* tp_compare */
	0,                                   /* tp_repr */
	0,                                   /* tp_as_number */
	0,                                   /* tp_as_sequence */
	0,                                   /* tp_as_mapping */
	0,                                   /* tp_hash */
	0,                                   /* tp_call */
	0,                                   /* tp_str */
	0,                                   /* tp_getattro */
	0,                                   /* tp_setattro */
	0,                                   /* tp_as_buffer */
	Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	                                     /* tp_flags */
	"statns entries from a stream",      /* tp_doc */
	0,                                   /* tp_traverse */
	0,                                   /* tp_clear */
	0,                                   /* tp_richcompare */
	0,                                   /* tp_weaklistoffset */
	0,                                   /* tp_iter */
	0,                                   /* tp_iternext */
	P_SharedStatus_methods,              /* tp_methods */
	P_SharedStatus_members,              /* tp_members */
	0,                                   /* tp_getset */
	0,                                   /* tp_base */
	0,                                   /* tp_dict */
	0,                                   /* tp_descr_get */
	0,                                   /* tp_descr_set */
	0,                                   /* tp_dictoffset */
	0,                                   /* tp_init */
	0,                                   /* tp_alloc */
	(newfunc)P_SharedStatus_new,         /* tp_new */
	0,                                   /* tp_free */
	0,                                   /* tp_is_gc */
	0,                                   /* tp_bases */
	0,                                   /* tp_mro */
	0,                                   /* tp_cache */
	0,                                   /* tp_subclasses */
	0,                                   /* tp_weaklist */
	0,                                   /* tp_del */
};

