#include <stdlib.h>
#include <cstring>
#include "tsc_extract.h"

double extract_xx(char *a,int offset, int bytes, bool with_sign_flag)
{
  char len[bytes*2+1];
  int l=0;
  for(int i=offset;i<offset+bytes;i++){
    len[l]=len[l+1]=a[i];

    len[l] >>= 4;
    len[l]   &= 0x0f;
    len[l]   |= 0x30;

    len[l+1] &= 0x0f;
    len[l+1] |= 0x30;

    l+=2;
  }

  len[bytes*2]=0x00;

  if(with_sign_flag){
    if(len[0]==0x38){
      len[0]='-';
    }else if(len[0]==0x30){
      len[0]='+';
    }else{
      len[0]=0x30;
    }
  }
  return(atof(len));
}

int extract_int(char *a,int offset, int bytes, bool with_sign_flag)
{
  char len[bytes*2+1];
  int l=0;
  for(int i=offset;i<offset+bytes;i++){
    len[l]=len[l+1]=a[i];

    len[l] >>= 4;
    len[l]   &= 0x0f;
    len[l]   |= 0x30;

    len[l+1] &= 0x0f;
    len[l+1] |= 0x30;

    l+=2;
  }

  len[bytes*2]=0x00;

  if(with_sign_flag){
    if(len[0]==0x38){
      len[0]='-';
    }else if(len[0]==0x30){
      len[0]='+';
    }else{
      len[0]=0x30;
    }
  }
  return(atoi(len));
}
