#include "tsc_common.h"

double BCD6_DEC::dd()
{
  return(extract_xx(a,1,1,false));
}
double BCD6_DEC::mm()
{
  return(extract_xx(a,2,1,false));
}

double BCD6_DEC::ss()
{
  return(extract_xx(a,3,3,false)*1e-4);
}

double BCD6_DEC::flag()
{
  double ret=1.0;
  if((a[0] & 0x80)==0x80) ret= -1.0;
  return(ret);
}

char BCD6_DEC::char_flag()
{
  char ret='+';
  if((a[0] & 0x80)==0x80) ret='-';
  return(ret);
}

double BCD6_DEC::degree()
{
  return(flag()*(dd()+mm()/60.0+ss()/3600.0));
}

double BCD6_DEC::rad()
{
  return(degree()/180.0*PI);
}
