//ID=0001 data/DCUMON.csv DRDR
struct S_DRDR {
  BCD6 Dome_Real_Angle;	// 0
  BCD6 Dome_CMD_Angle;	// 6
  BCD6 Dome_Angle_Error;	// 12
  #include "tsclib/tsc_appendix.h"
};

//ID=0002 data/MCUMON.csv MTDR
struct S_MTDR {
  BCD6 AZ_Real_Angle;	// 0
  BCD6 EL_Real_Angle;	// 6
  BCD6 AZ_CMD_Angle_ANS;	// 12
  BCD6 EL_CMD_Angle_ANS;	// 18
  BCD6 AZ_Position_Error;	// 24
  BCD6 EL_Position_Error;	// 30
  BCD6 AZ_Auto_Guide_Offset_CMD;	// 36
  BCD6 EL_Auto_Guide_Offset_CMD;	// 42
  BCD6 AZ_Auto_Guide_Offset_Real;	// 48
  BCD6 EL_Auto_Guide_Offset_Real;	// 54
  #include "tsclib/tsc_appendix.h"
};

//ID=0004 data/FRCUMON.csv FRAD
struct S_FRAD {
  BCD6 Rotator_Real_Angle;	// 0
  BCD6 Rotator_CMD_ANS;	// 6
  // added by morino
  union {
    BIT focus_select;
    char b;
    struct {
      unsigned char : 1;
      unsigned char : 1;
      unsigned char : 1;

      unsigned char pfvsbl_sel : 1;

      unsigned char pfir_sel   : 1;
      unsigned char cs_sel     : 1;
      unsigned char nsop_sel   : 1;
      unsigned char nsir_sel   : 1;
    };
  #include "tsclib/tsc_appendix.h"
};

//ID=00A1 data/TSCMON.csv TSC
struct S_TSC {
  BCD6_RA Right_Ascention;	// 0 // morino
  BCD6_DEC Declination;	// 6 //morino
  BCD6_Epoch Epoch;	// 12 // morino
  BCD6 _1000_Right_Ascention;	// 18
  BCD6 _1000_Declination;	// 24
  BCD6 Parallax;	// 30
  union {
    BIT bit_36;
    struct {
      unsigned char  :1; // 36-7
      unsigned char AZ_Drive_Direction_TSC :1; // 36-6
      unsigned char AZ_Drive_Direction_MINUS :1; // 36-5
      unsigned char AZ_Drive_Direction_PLUS :1; // 36-4
      unsigned char  :1; // 36-3
      unsigned char  :1; // 36-2
      unsigned char E_Term_Off :1; // 36-1
      unsigned char E_Term_On :1; // 36-0
    };
  };
  BCD6_RA   Error_Right_Ascention;	// 37 //morino
  BCD6_DEC Error_Declination;	// 43 //morino
  BCD6 AZ_Instrumental_Error_Correction;	// 49
  BCD6 EL_Instrumental_Error_Correction;	// 55
  BCD6 AZ_Index_Error;	// 61
  BCD6 EL_Index_Error;	// 67
  BCD6_RA AZ_Offset_Angle;	// 73 //morino
  BCD6_DEC EL_Offset_Angle;	// 79 //morino
  char nofill_85;
  char nofill_86;
  char nofill_87;
  char nofill_88;
  char nofill_89;
  char nofill_90;
  char nofill_91;
  char nofill_92;
  char nofill_93;
  char nofill_94;
  char nofill_95;
  char nofill_96;
  char nofill_97;
  ASC7_TIME7 LST_TSC_Calculate;	// 98 // morino
  BCD6_RA Right_Ascention_CMD;	// 105 //morino
  BCD6_DEC Declination_CMD;	// 111 //morino
  #include "tsclib/tsc_appendix.h"
};

//ID=0036 data/RTADCPFMON.csv FRAD_PF
struct S_FRAD_PF {
  BCD6 P_Rotator_Real_Angle;	// 0
  BCD6 P_Rotator_CMD_ANS;	// 6
  #include "tsclib/tsc_appendix.h"
};


  //
class TSC_HEAD {
public:
  char a[10];
};


class TSCShort {
public:
  TSC_HEAD head;
  BCDHEX4 index0000;
  ASC15_TIME time0000;
  BCDHEX4 indexqqqq;
  char data_format[1];

  // 0001 
  BCDHEX4 index0001;
  ASC15_TIME time0001;
  S_DRDR drdr;

  // 0002 
  BCDHEX4 index0002;
  ASC15_TIME time0002;
  S_MTDR mtdr;

  // 0004 FRAD
  BCDHEX4 index0004;
  ASC15_TIME time0004;
  S_FRAD frad;

  // 00A1 TSC
  BCDHEX4 index00A1;
  ASC15_TIME time00A1;
  S_TSC tsc;

  // FRAD-PF
  // 0036 FRAD-PF
  BCDHEX4 index0036;
  ASC15_TIME time0036;
  S_FRAD_PF frad_pf;

  #include "tsclib/tsc_appendix.h"
};
