/* instrument_status_header.c : handles information from instrument status header */
/*

See JNLT Requirement Specification for F-M Interface
  http://siroan.naoj.org/Tsc/Fujitsu-Mitsubishi-Interface-Specifications.pdf
for a detailed description.

Copyright (C) 2005 by Daigo Tomono <tomono at subaru.naoj.org>

Permission is granted for use, copying, modification, distribution,
and distribution of modified versions of this work under the terms of
GPL version 2 or later.

*/

/* If we're not using GNU C, elide __attribute__ */
#ifndef __GNUC__
#define  __attribute__(x)  /*NOTHING*/
#endif

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <string.h>
#include <stdlib.h>
#include <melco/tsc-message.h>
#include <melco/status-types.h>

#ifdef COUNT_MALLOC
#include <count-malloc.h>
#endif

unsigned int
instrument_status_header_shortid(const instrument_status_header_s* ptr)
{
	char buf[sizeof(ptr->s.shortid)+1];
	memcpy(buf, ptr->s.shortid, sizeof(ptr->s.shortid));
	buf[sizeof(ptr->s.shortid)] = '\0';
	return strtol(buf, NULL, 16);
}

const ASC15_TIME*
instrument_status_header_rxtime(const instrument_status_header_s* ptr)
{
	return &(ptr->s.rxtime);
}
