#!/usr/bin/python
# This file explains usage of the new telescope status API on TWS4
#
# Copyright (C) 2010 by Daigo Tomono <tomono at subaru.naoj.org>
#
# Permission is granted for use, copying, modification, distribution,
# and distribution of modified versions of this work under the terms of
# GPL version 2 or later.
#
# Basic use
import tscstatus

# Pull telescope status from the shared memories
stat = tscstatus.sharedstatus()

# Look into a status entry by its name defined by Mitsubishi:
# /usr/local/share/doc/tsc-status/status-entries.txt
ra = stat.entry('Right Ascention')

# str() method returns the value in string, formatted for human beings
print "RA:" + ra.str()

# use the Python standard libraries to deal with time
# rxtime() returns time stamp as number of seconds since `the' epoch
import time
print "Status is received at " + time.strftime('%c', time.localtime(ra.rxtime()))

# val() method on flags returns True or False
if stat.entry('Telescope Pointing').val():
	print 'Telescope is pointing.'
else:
	print 'Telescope is not pointing.'

# float() method returns floting point numbers for applicable stauses
# angles are returned in radians
ra1 = stat.entry('Right Ascention').float()
ra2 = stat.entry('Right Ascention CMD').float()
dec1 = stat.entry('Declination').float()
dec2 = stat.entry('Declination CMD').float()

import math
ddec1 = math.pi/2 - dec1
ddec2 = math.pi/2 - dec2
dra = ra1 - ra2
distance = math.acos(
	math.cos(ddec1)*math.cos(ddec2) + \
	math.sin(ddec1)*math.sin(ddec2)*math.cos(dra) \
)
print "Pointing error on sky: %f arcsec" % (distance*180*3600/math.pi)
