#!/usr/bin/env ruby
#
# usage: ruby separate-time.rb threshold(sec) srcfile >| dstfile
#
# puts empty lines between entries with big intervals
#
# format of logfiles: date\ttime\tdata\t....
#

thresh = ARGV.shift.to_f
src = ARGV.shift
unless ARGV.empty? then
	$stderr.puts "usage: ruby separate-time.rb threshold(sec) srcfile >| dstfile"
	exit 1
end

prev = nil
File.open( src ) do |s|
	s.each do |l|
		if /^#/ =~ l
			print l
		else
			t = l.strip.split( /\s+/ )[0..1].join(" ").split( /[ \-:]/ )
			fsec = t[5] ? Float( t[5] ) : 0
			t[5] = fsec.floor
			t[6] = t[5] ? (fsec*1e6 - t[5]*1e6) : 0
			cur = Time.gm( *t )
			if not prev or cur - prev > thresh
				puts
			end
			print l
			prev = cur
		end
	end
end

