#!/usr/bin/env ruby
#
# usage: ruby separate-date.rb dstdir files, ...
#
# separates each line of the log files into separate files according to the date
#
# format of logfiles: date\ttime\tsec\tdata\t....
#

dstdir = ARGV.shift
d = nil
ARGV.each do |src|
	comments = Array.new
	File.open( src ) do |s|
		s.each do |l|
			if /^#/ =~ l
				comments.push( l ) unless comments.include?( l )
			else
				unless /\A\Z/ =~ l then
					date = l.split( /\t/ )[0]
					dst = File::join( dstdir, date + '.log' )
					if not d or d.path != dst then
						d.close if d
						$stderr.puts "creating #{dst}"
						d = File.open( dst, 'w' )
						d.print comments.join( '' )
					end
				end
			end
			d.print l if d
		end
	end
end
d.close if d
