#!/usr/bin/python
# usage: dump-tsc-log -l | grep SOMETHING | python monitor.py

import sys
import time
import tscstatus

entries_str = sys.stdin.read()
interval = 2

entryformat = "%-30.30s"
historycols = 40

entries = [line.split("\t")[0] for line in entries_str.split("\n")]
while '' in entries:
	entries.remove('')

stat = tscstatus.sharedstatus()
prevstat = {}
count = {}
history = {}
for entry in entries:
	prevstat[entry] = stat.entry(entry).val()
	count[entry] = 0
	history[entry] = ""

while True:
	print "-----------------------------------------------------" + time.strftime("%H:%M:%S")
	for entry in entries:
		curentry = stat.entry(entry)
		if curentry.info().is_flag():
			flag = curentry.val()
			c = "X" if flag else " "
			history[entry] += "+" if flag else "-"
			history[entry] = history[entry][-historycols:]
			if prevstat[entry] != flag:
				count[entry] = 60
			if count[entry] > 0:
				n = "!"
				count[entry] -= 1
			else:
				n = " "
			print n + c + " " + entryformat % entry + " " + history[entry]
			prevstat[entry] = flag
		else:
			print "   " + entryformat % entry + " " + curentry.str()
	time.sleep(interval)

