#!/usr/local/bin/python
import curses, traceback, string, os, tel, shm,re,math
import tscsdraw, tscldraw,tscvdraw
import reg_alarmdraw,reg_faultdraw,reg_emergencydraw     #-- don't forget
import cus_UH88draw,cus_HeatExhdraw,cus_pyodraw,cus_checkvstatdraw
import cus_test01draw,cus_Coverdraw
import cus_TWS12convdraw,cus_SH
import cus_autozchkdraw,cus_caldraw

ms = shm.memory(shm.getshmid(0x100));
tscs=tel.TSCShort();
ms.attach(); 
tscs.set(ms.read(1292))

ml = shm.memory(shm.getshmid(0x101));
tscl=tel.TSCLong();
ml.attach(); 
tscl.set(ml.read(1292*7))

mv = shm.memory(shm.getshmid(0x102));
tscv=tel.TSCVstat();
mv.attach(); 
tscv.vset(mv.read(12931))
stamp0=mv.read(29)[27:29]
stamp_index=0
stamp_num=0

#-- Define the appearance of some interface elements
hotkey_attr = curses.A_BOLD | curses.A_UNDERLINE
menu_attr = curses.A_NORMAL

#-- Define additional constants
EXIT = 0
CONTINUE = 1
SCR = 0
SMALL_WINDOW ="Please set window larger than 80x24!"
#-- Define default conversion dictionary

#-- Give screen module scope
screen = None
draw_function = None

draw_function = tscsdraw.s_mtdr
draw_function = cus_pyodraw.cus_pyo01  #--- temporary
counter = 0

#-- Create the topbar menu
def topbar_menu(menus):
    left = 1
    for menu in menus:
        menu_name = menu[0]
        menu_hotkey = menu_name[0]
        menu_no_hot = menu_name[1:]
        screen.addstr(0, left, menu_hotkey, hotkey_attr)
        screen.addstr(0, left+1, menu_no_hot, menu_attr)
        left = left + len(menu_name) + 3
        # Add key handlers for this hotkey
        topbar_key_handler((string.upper(menu_hotkey), menu[1]))
        topbar_key_handler((string.lower(menu_hotkey), menu[1]))
    screen.refresh()

def scr_clear():
    global screen
    screen.move(2,0)
    screen.clrtobot() 

#-- Magic key handler both loads and processes keys strokes
def topbar_key_handler(key_assign=None, key_dict={}):
    global stamp_index,stamp0,stamp_num
    if key_assign:
        key_dict[ord(key_assign[0])] = key_assign[1]
    else:
	curses.halfdelay(10)
        stamp=mv.read(29)[27:29]
        at=curses.A_NORMAL
        screen.addstr(0, 57, " "*19,curses.A_NORMAL)
        if stamp!=stamp0:
            stamp0=stamp
            stamp_index+=1
            stamp_num=0
            if stamp_index==4: stamp_index=0
        else:
            stamp_num+=1
            if stamp_num>=600: #-- 10 minutes
                at=curses.A_REVERSE | curses.A_BLINK
                screen.addstr(0, 57, "Request TSC Vstat!",at)
        screen.addstr(0, 43, ("Stat","sTat","stAt","staT")[stamp_index],at)
#        screen.addstr(0, 48, ("|","/","-","\\")[stamp_index],curses.A_REVERSE)
        screen.addstr(0, 48, ("|","/","-","\\")[stamp_index],curses.A_NORMAL)
        screen.addstr( 0, 77, "", curses.A_STANDOUT)

        rest=[]
        c = screen.getch()
        if (c == 27):
            curses.cbreak()
            screen.timeout(20)
            while (-1):
                try:
                    next_key = screen.getch()
                except (KeyboardInterrupt):
                    return curses.KEY_CANCEL,[]
                if (next_key != -1):
                    rest.append(next_key)
                else:
                    break
            screen.timeout(-1)

        if c ==-1:               #-- no key input
            curses.nocbreak()
            return 1
        elif c in (curses.KEY_END, ord('!')):
            curses.nocbreak()
            return 0
        elif c in (ord('n'),14) or rest==[91,66]: #--- next page n or ctrl-n
            curses.nocbreak()
            tscsdraw.page+=1
            tscldraw.page+=1
            tscvdraw.page+=1
            reg_alarmdraw.page+=1   #-- dont' forget
            reg_faultdraw.page+=1   #-- dont' forget
            reg_emergencydraw.page+=1   #-- dont' forget
            cus_UH88draw.page+=1   #-- dont' forget
            cus_HeatExhdraw.page+=1   #-- dont' forget
            cus_pyodraw.page+=1   #-- dont' forget
            cus_checkvstatdraw.page+=1 #-- dont' forget
            cus_test01draw.page+=1 #-- dont' forget
            cus_Coverdraw.page+=1 #-- dont' forget
            cus_TWS12convdraw.page+=1 #-- dont' forget
            cus_SH.page+=1 #-- dont' forget
            cus_autozchkdraw.page+=1 #-- dont' forget
            cus_caldraw.page+=1 #-- dont' forget
            scr_clear()
            return 1
        elif c in (ord('p'),16) or rest==[91,65]: #--- next page p or ctrl-p
            curses.nocbreak()
            tscsdraw.page-=1
            tscldraw.page-=1
            tscvdraw.page-=1
            reg_alarmdraw.page-=1   #-- dont' forget
            reg_faultdraw.page-=1   #-- dont' forget
            reg_emergencydraw.page-=1   #-- dont' forget
            cus_UH88draw.page-=1   #-- dont' forget
            cus_HeatExhdraw.page-=1   #-- dont' forget
            cus_pyodraw.page-=1   #-- dont' forget
            cus_checkvstatdraw.page-=1 #-- dont' forget
            cus_test01draw.page-=1 #-- dont' forget
            cus_Coverdraw.page-=1 #-- dont' forget
            cus_TWS12convdraw.page-=1 #-- dont' forget
            cus_SH.page-=1 #-- dont' forget
            cus_autozchkdraw.page-=1 #-- dont' forget
            cus_caldraw.page-=1 #-- dont' forget
            scr_clear()
            return 1
        elif c not in key_dict.keys():
            curses.beep()
            curses.nocbreak()
            return 1
        else:
            curses.nocbreak()
            return eval(key_dict[c])

def scr_change_param(name):
    screen.move(2,0)
    screen.clrtobot() 
#    screen.hline(1, 0, curses.ACS_HLINE, 79)
    screen.hline(1, 0, "-", 79)
        #LST_TSC_Calculate
#    screen.addstr( 1,3, "Test version. LST=%02.0lf:%02.0lf:%04.1lf" %(tscs.LST_TSC_Calculate.hh(),tscs.LST_TSC_Calculate.mm(),tscs.LST_TSC_Calculate.ss()),curses.A_NORMAL)
#    screen.addstr( 1,3, "Test version. LST=%7s" %tscs.LST_TSC_Calculate.a[:7],curses.A_NORMAL)
    screen.addstr(1, 3 ,"<<<<<<<<<<<<<<<->>>>>>>>>>>>>>>>>>",curses.A_NORMAL)
    screen.addstr(1, 54-len(name) ," "+name+" ",curses.A_BOLD)
    screen.addstr(1, 67 ,"(Prev/Next)",curses.A_NORMAL)
    screen.addstr(1, 68 ,"P",hotkey_attr)
    screen.addstr(1, 73 ,"N",hotkey_attr)
    tscsdraw.page=1
    tscldraw.page=1
    tscvdraw.page=1
    reg_alarmdraw.page=1 #-- don't forget
    reg_faultdraw.page=1 #-- don't forget
    reg_emergencydraw.page=1 #-- don't forget
    cus_UH88draw.page=1 #-- don't forget
    cus_HeatExhdraw.page=1 #-- don't forget
    cus_pyodraw.page=1 #-- don't forget
    cus_checkvstatdraw.page=1 #-- dont' forget
    cus_test01draw.page=1 #-- dont' forget
    cus_Coverdraw.page=1 #-- dont' forget
    cus_TWS12convdraw.page=1 #-- dont' forget
    cus_SH.page=1 #-- dont' forget
    cus_autozchkdraw.page=1 #-- dont' forget
    cus_caldraw.page=1 #-- dont' forget

#-- Handlers for the topbar menus
def help_func():
    help_lines = []
    offset = 0
    fh_help = open('txt2html.txt')
    for line in fh_help.readlines():
        help_lines.append(string.rstrip(line))
    s = curses.newwin(19, 77, 1, 1)
    s.border(ord('|'),ord('|'),ord('-'),ord('-'),ord('+'),ord('+'),ord('+'),ord('+'))
    num_lines = len(help_lines)
    end = 0
    while not end:
        for i in range(1,18):
            if i+offset < num_lines:
                line = string.ljust(help_lines[i+offset],74)[:74]
            else:
                line = " "*74
                end = 1
            if i<3 and offset>0: s.addstr(i, 2, line, curses.A_BOLD)
            else: s.addstr(i, 2, line, curses.A_NORMAL)
        s.refresh()
        c = s.getch()
        offset = offset+15
    s.erase()
    return CONTINUE

def menu_match(group,input):
    num_of_match=0
    hit=0
    px=0
    py=0
    y=0
    target_key=""
    s=group.keys()
    s.sort()
    input.upper()
    for meth in s:
        if re.match("^"+input,meth) !=None:
            num_of_match=num_of_match+1
            if (hit==0):
                px=len(input)
                py=y
                hit=1
                target_key=meth
        y=y+1
    return(num_of_match,px,py,target_key)

def str_com(s1,s2):
  l=0
  le=range(min(s1.__len__(),s2.__len__()))
  while (l<le) and (s1[l]==s2[l]): l=l+1
#  if(s1[0]!=s2[0]): l=0
  return(s1[0:l+1],s1[l+1:],s2[0:l+1],s2[l+1:],l)

def menu_split(s):
  s.sort()
  result = []
  num=s.__len__()
  if(num==1):
#    print s[0],"/",""
     result.append((s[0],""))
  if(num>1):
    m=str_com(s[0],s[1])
#    print m[0],"/",m[1],":",m[2],"/",m[3]
    result.append((m[0],m[1]))
  if(num>2):
    for k in range(s.__len__()-2):
      i=k+1
      m=str_com(s[i],s[i-1])
      n=str_com(s[i],s[i+1])
      if(m[4]<n[4]):
        m=n
#      print m[0],"/",m[1],":",m[2],"/",m[3]
      result.append((m[0],m[1]))
  if(num>1):
    m=str_com(s[num-1],s[num-2])
#    print m[0],"/",m[1],":",m[2],"/",m[3]
    result.append((m[0],m[1]))
  return(result)

def short_func(): 
    global draw_function,screen
    s_menu_items={
        "DRDR:Dome": tscsdraw.s_drdr,
        "FRAD:Field Rotation": tscsdraw.s_frad,
        "FRCU:Field Rotation(PF)": tscsdraw.s_frcu,
        "MTDR:Mount": tscsdraw.s_mtdr,
        "TSC :TSC": tscsdraw.s_tsc ,
        "TTCU:Tip Tilt": tscsdraw.s_ttcu,
    }
    list=s_menu_items.keys()
    list2=menu_split(list)
    s = curses.newwin(8,30,1,25)
    s.border(ord('|'),ord('|'),ord('-'),ord('-'),ord('+'),ord('+'),ord('+'),ord('+'))
    y=1
    for item in list2:
        s.addstr(y,2, item[0], hotkey_attr)
        s.addstr(y,2+len(item[0]), item[1], menu_attr)
        y=y+1
    s.addstr(1,2, "", hotkey_attr)
    s.refresh()
    curses.cbreak()

    word=""
    fin=0
    while fin==0:
        c = s.getch()
        if (c>=ord('a')) and (c<=ord('z')): c=c-32
        word=word+chr(c)
        rep=menu_match(s_menu_items,word)
        if(rep[0]==1):
            s.erase()
            draw_function = s_menu_items[rep[3]]
            fin=1;
            scr_change_param("Short:"+rep[3])
        elif(rep[0]>=2):
            s.move(rep[2]+1,rep[1]+2-1)
            fin=0
        else:
            fin=1
            curses.beep()
    s.erase()
    return CONTINUE


def long_func(): 
    global draw_function,screen
    l_menu_items={
        "AG:": tscldraw.l_ag,
        "AO:": tscldraw.l_ao,
        "ASCU_PF:": tscldraw.l_ascu,
        "BLCU:": tscldraw.l_blcu,
        "BOLT:": tscldraw.l_bolt,
        "CAL:": tscldraw.l_cal,
        "CIAX:": tscldraw.l_ciax,
        "CLOCK:": tscldraw.l_clock,
        "CRYOGEN_HEAT_EXH:": tscldraw.l_cryogen_heat_exh,
        "DCT2 (DOME_CT2):": tscldraw.l_dome_ct2,
        "DFLAT(DOME_FLAT):": tscldraw.l_domeflat,
        "DTEMP(DOME_TEMP):": tscldraw.l_dome_temp,
        "DRDR:": tscldraw.l_drdr,
        "FPCI:": tscldraw.l_fpci,
        "FRAD:": tscldraw.l_frad,
        "FRCU(FRAD_PF):": tscldraw.l_frcu,
        "HSBC:": tscldraw.l_hsbc,
        "HT_EXH:": tscldraw.l_ht_exh,
        "MCP2:": tscldraw.l_mcp2,
        "MLP1:": tscldraw.l_mlp1,
        "MLP21(MLP2-1):": tscldraw.l_mlp2_1,
        "MLP22(MLP2-2):": tscldraw.l_mlp2_2,
        "MLP3:": tscldraw.l_mlp3,
        "MTDR:": tscldraw.l_mtdr,
        "OBE:": tscldraw.l_obe,
        "PUMP-D:": tscldraw.l_red_exh,
        "SH:": tscldraw.l_sh,
        "SMCU:": tscldraw.l_smcu,
        "SV:": tscldraw.l_sv,
        "THRM:": tscldraw.l_thrm,
        "TCT2(TLSCP_CT2):": tscldraw.l_tlscp_ct2,
        "TTEMP(TLSCP_TEMP):": tscldraw.l_tlscp_temp,
        "TSC:": tscldraw.l_tsc,
        "TTCU:": tscldraw.l_ttcu,
        "WMON:": tscldraw.l_wmon,
    }
    list=l_menu_items.keys()
    list2=menu_split(list)

    s = curses.newwin(20,60,1,8)
    s.border(ord('|'),ord('|'),ord('-'),ord('-'),ord('+'),ord('+'),ord('+'),ord('+'))
    y=1
    x=2
    for item in list2:
        s.addstr(y,x, item[0], hotkey_attr)
        s.addstr(y,x+len(item[0]), item[1], menu_attr)
        y=y+1
        if(y==19): y=1;x=30;

    s.addstr(1,2, "", hotkey_attr)
    s.refresh()
    curses.cbreak()

    word=""
    fin=0
    while fin==0:
        c = s.getch()
        if (c>=ord('a')) and (c<=ord('z')): c=c-32
        word=word+chr(c)
        rep=menu_match(l_menu_items,word)
        if(rep[0]==1):
            s.erase()
            draw_function = l_menu_items[rep[3]]
            fin=1;
            scr_change_param("Long :"+rep[3])
        elif(rep[0]>=2):
            x=rep[1]+2-1;y=rep[2]+1
            if(y>18): y=y-18;x=30;
            s.move(y,x)
            fin=0
        else:
            fin=1
            curses.beep()
    s.erase()
    return CONTINUE



def vstat_func(): 
    global draw_function,screen
    v_menu_items={
        "AG:":  tscvdraw.v_ag,
        "AO:":  tscvdraw.v_ao,
        "ASCU:":  tscvdraw.v_ascu,
        "BLCU:":  tscvdraw.v_blcu,
        "BOLT:":  tscvdraw.v_bolt,
        "CAL:":  tscvdraw.v_cal,
        "CIAX:":  tscvdraw.v_ciax,
        "CLOCK:":  tscvdraw.v_clock,
        "CRYOGEN_HEAT_EXH:":  tscvdraw.v_cryogen_heat_exh,
        "CVCV:":  tscvdraw.v_cvcv,
        "DOME_CT2:":  tscvdraw.v_dome_ct2,
        "DOMEFLAT:":  tscvdraw.v_domeflat,
        "DOME_TEMP:":  tscvdraw.v_dome_temp,
        "DRDR:":  tscvdraw.v_drdr,
        "FPCI:":  tscvdraw.v_fpci,
        "FRAD:":  tscvdraw.v_frad,
        "FRCU:":  tscvdraw.v_frcu,
        "HSBC:":  tscvdraw.v_hsbc,
        "HT_EXH:":  tscvdraw.v_ht_exh,
        "MCP1:":  tscvdraw.v_mcp1,
        "MCP2:":  tscvdraw.v_mcp2,
        "MIRROR_HT_EXH:":  tscvdraw.v_mirror_ht_exh,
        "MLP1:":  tscvdraw.v_mlp1,
        "MLP2:":  tscvdraw.v_mlp2,
        "MLP3:":  tscvdraw.v_mlp3,
        "MTDR:":  tscvdraw.v_mtdr,
        "OBE:":  tscvdraw.v_obe,
        "PMFXS1:":  tscvdraw.v_pmfxs1,
        "PMFXS2:":  tscvdraw.v_pmfxs2,
        "PMFXS3:":  tscvdraw.v_pmfxs3,
        "PMA:":  tscvdraw.v_pma,
        "PUMP_D:":  tscvdraw.v_pump_d,
        "SH:":  tscvdraw.v_sh,
        "SHTEST(SH_TEST):":  tscvdraw.v_sh_test,
        "SMCU:":  tscvdraw.v_smcu,
        "SPU4:":  tscvdraw.v_spu4,
        "SPU5:":  tscvdraw.v_spu5,
        "SPU6:":  tscvdraw.v_spu6,
        "SV:":  tscvdraw.v_sv,
        "THRM:":  tscvdraw.v_thrm,
        "TCT2(TLSCP_CT2):":  tscvdraw.v_tlscp_ct2,
        "TTE(TLSCP_TEMP)":  tscvdraw.v_tlscp_temp,
        "TMCU:":  tscvdraw.v_tmcu,
        "TSC:":  tscvdraw.v_tsc,
        "TTCU:":  tscvdraw.v_ttcu,
    }
    list=v_menu_items.keys()
    list2=menu_split(list)

    s = curses.newwin(23,70,1,2)
    s.border(ord('|'),ord('|'),ord('-'),ord('-'),ord('+'),ord('+'),ord('+'),ord('+'))
    y=1
    x=2
    for item in list2:
        s.addstr(y,x, item[0], hotkey_attr)
        s.addstr(y,x+len(item[0]), item[1], menu_attr)
        y=y+1
        if(y==22):
            if(x==28): y=1;x=54;
            if(x==2): y=1;x=28;

    s.addstr(1,2, "", hotkey_attr)
    s.refresh()
    curses.cbreak()
    word=""
    fin=0
    while fin==0:
        c = s.getch()
        if (c>=ord('a')) and (c<=ord('z')): c=c-32
        word=word+chr(c)
        rep=menu_match(v_menu_items,word)
        if(rep[0]==1):
            s.erase()
            draw_function = v_menu_items[rep[3]]
            fin=1;
            scr_change_param("Vstat:"+rep[3])
        elif(rep[0]>=2):
            x=rep[1]+2-1;y=rep[2]+1
            if(y>=22+22):
                y=y-22-22+1+1
                x=x+54-2
            elif(y>=22):
                y=y-22+1
                x=x+28-2
            s.move(y,x)
            fin=0
        else:
            fin=1
            curses.beep()
    s.erase()
    return CONTINUE

def file_func(): 
    return CONTINUE

def custom_func(): 
    global draw_function,screen
    c_menu_items={  #-- don't forget
        "UH88style": cus_UH88draw.cus_UH88,
        "HEat Exhaust": cus_HeatExhdraw.cus_HeatExh, #-- module.function
        "HOME": cus_pyodraw.cus_pyo01,
        "Vstat-check": cus_checkvstatdraw.cus_vstatchk,
        "TEst01-style": cus_test01draw.cus_test01,
        "MIrrorCover": cus_Coverdraw.cus_Cover,
        "OCW ObservationCondionWindow": cus_TWS12convdraw.cus_OCW,
        "2MW 2ndMirrorWindow": cus_TWS12convdraw.cus_2ndMirrorWindow,
        "3MW 3rdMirrorWindow": cus_TWS12convdraw.cus_3rdMirrorWindow,
        "TIpTiltWindow": cus_TWS12convdraw.cus_TipTiltWindow,
        "DomeFlatWindow": cus_TWS12convdraw.cus_noumaru02,
        "HYdroStaticBearing": cus_TWS12convdraw.cus_kanzawa01,
        "Balancer": cus_TWS12convdraw.cus_Balancer,
        "TOpScreen": cus_TWS12convdraw.cus_TopScreen,
        "WIndScreen": cus_TWS12convdraw.cus_WindScreen,
        "WEtherMonitor": cus_TWS12convdraw.cus_WeatherMonitor,
        "MAinShutter": cus_TWS12convdraw.cus_Shutter,
        "SHtest": cus_SH.cus_SH,
        "AutoZCheck": cus_autozchkdraw.cus_autoz,
        "CAL source": cus_caldraw.cus_cal,
#        "T2pTiltWindow": cus_TWS12convdraw.cus_test,
    }
    list=c_menu_items.keys()
    list2=menu_split(list)
    s = curses.newwin(20+2,36,1,2)  #--Don't forget menu box(size y(=items+2),x, pos y,x)
    s.border(ord('|'),ord('|'),ord('-'),ord('-'),ord('+'),ord('+'),ord('+'),ord('+'))
    y=1
    for item in list2:
        s.addstr(y,2, item[0], hotkey_attr)
        s.addstr(y,2+len(item[0]), item[1], menu_attr)
        y=y+1
    s.addstr(1,2, "", hotkey_attr)
    s.refresh()
    curses.cbreak()

    word=""
    fin=0
    while fin==0:
        c = s.getch()
        if (c>=ord('a')) and (c<=ord('z')): c=c-32  #-- lower case change to uppaer case
        word=word+chr(c)
        rep=menu_match(c_menu_items,word)
        if(rep[0]==1):
            s.erase()
            draw_function = c_menu_items[rep[3]]
            fin=1;
            scr_change_param("Custom:"+rep[3])
        elif(rep[0]>=2):
            s.move(rep[2]+1,rep[1]+2-1)
            fin=0
        else:
            fin=1
            curses.beep()
    s.erase()
    return CONTINUE


def regular_func(): 
    global draw_function,screen
    r_menu_items={
        "Alarm": reg_alarmdraw.reg_alarm01,
        "Fault": reg_faultdraw.reg_fault01,
        "Emergency": reg_emergencydraw.reg_emergency01,
    }
    list=r_menu_items.keys()
    list2=menu_split(list)
    s = curses.newwin(5,30,1,2)  #--Don't forget menu box(size y,x, pos y,x)
    s.border(ord('|'),ord('|'),ord('-'),ord('-'),ord('+'),ord('+'),ord('+'),ord('+'))
    y=1
    for item in list2:
        s.addstr(y,2, item[0], hotkey_attr)
        s.addstr(y,2+len(item[0]), item[1], menu_attr)
        y=y+1
    s.addstr(1,2, "", hotkey_attr)
    s.refresh()
    curses.cbreak()

    word=""
    fin=0
    while fin==0:
        c = s.getch()
        if (c>=ord('a')) and (c<=ord('z')): c=c-32  #-- lower case change to uppaer case
        word=word+chr(c)
        rep=menu_match(r_menu_items,word)
        if(rep[0]==1):
            s.erase()
            draw_function = r_menu_items[rep[3]]
            fin=1;
            scr_change_param("Regular:"+rep[3])
        elif(rep[0]>=2):
            s.move(rep[2]+1,rep[1]+2-1)
            fin=0
        else:
            fin=1
            curses.beep()
    s.erase()
    return CONTINUE




#-- Top level function call (everything except [curses] setup/cleanup)
def main(stdscr):
    # Frame the interface area at fixed VT100 size
    global screen
    global tscs
    global ms

    screen = stdscr.subwin(24, 79, 0, 0)
#    screen.box()
#    screen.hline(2, 1, curses.ACS_HLINE, 77)
    screen.hline(1, 1, "-", 77)
    screen.refresh()

    # Define the topbar menus
    file_menu = ("File", "file_func()")
    regular_menu = ("Regular", "regular_func()")
    custom_menu = ("Custom", "custom_func()")
    short_menu = ("Short", "short_func()")
    long_menu = ("Long", "long_func()")
    vstat_menu = ("Vstat: ", "vstat_func()")
#    help_menu = ("Help", "help_func()")
    exit_menu = ("Quit", "EXIT")

    # Add the topbar menus to screen object
#    topbar_menu((file_menu, regular_menu, custom_menu, short_menu, long_menu, vstat_menu,  exit_menu))
    topbar_menu((regular_menu, custom_menu, short_menu, long_menu, vstat_menu,  exit_menu))

    # Draw the onscreen field titles
#--    scr_change_param("Short:MTDR:Mount")
    scr_change_param("+- SUMMARY --+")
    draw_function(screen,tscs,ms,tscl,ml,tscv,mv)

    # Enter the topbar menu loop
    while topbar_key_handler():
	draw_function(screen,tscs,ms,tscl,ml,tscv,mv)

if __name__=='__main__':
    try:
        # Initialize curses
        stdscr=curses.initscr()
        # check the size
        (y,x)=stdscr.getmaxyx()
        if x<79 or y<24  : raise SMALL_WINDOW
        #curses.start_color()
        # Turn off echoing of keys, and enter cbreak mode,
        # where no buffering is performed on keyboard input
        curses.noecho() ; curses.cbreak()

        # In keypad mode, escape sequences for special keys
        # (like the cursor keys) will be interpreted and
        # a special value like curses.KEY_LEFT will be returned
        stdscr.keypad(1)
        main(stdscr)                    # Enter the main loop
        # Set everything back to normal
        stdscr.keypad(0)
        curses.echo() ; curses.nocbreak()
        curses.endwin()                 # Terminate curses
    except:
        # In the event of an error, restore the terminal
        # to a sane state.
        stdscr.keypad(0)
        curses.echo() ; curses.nocbreak()
        curses.endwin()
        traceback.print_exc()           # Print the exception

