#!/usr/local/bin/python

# -- modules
import tel
import shm
import time
import math

# -- Initialization to take value from UNIX shared memory
ms = shm.memory(shm.getshmid(0x100));
tscs=tel.TSCShort();
ms.attach(); 

ml = shm.memory(shm.getshmid(0x101));
tscl=tel.TSCLong();
ml.attach();

mv = shm.memory(shm.getshmid(0x102));
tscv=tel.TSCVstat();
mv.attach(); 

# -- read shared memory and set to the class-objects (like C-languade structures) 
tscs.set(ms.read(1292))
tscl.set(ml.read(1292*7))
tscv.vset(mv.read(12931))

it = -1
# -- for initial condition, AG, SV, Offset-Z
exp_SH_0=tscv.SH_Exposure_On
exp_AG_0=tscv.AG_Exposure_On
exp_SV_0=tscv.SV_Exposure_On
guide_AG_0=tscv.AG1_Auto_Guide + tscv.AG2_Auto_Guide
off_Z_0=tscv.SM_z_axis_Offset.val()
#guide_SV_0=tscv.SV1_Auto_Guide + tscv.SV2_Auto_Guide

print "#say# Hello %s.  Welcome to Subaru Telescope!"%tscv.Observer[:20]
time.sleep(10)
# -- main Loop
while 1:
    tscs.set(ms.read(1292))
    tscl.set(ml.read(1292*7))
    tscv.vset(mv.read(12931))

    print "%04.0lf/%02.0lf/%02.0lf %02.0lf:%02.0lf:%04.1lf" %(tscl.time0000.year(),tscl.time0000.month(),tscl.time0000.day(),tscl.time0000.hh(),tscl.time0000.mm(),tscl.time0000.ss())

    # -- Telescope Mount moving
    if abs(tscs.AZ_Position_Error.val())>1.0 or abs( tscs.EL_Position_Error.val())>1.0:
        tt=max(abs(tscs.AZ_Position_Error.val())/0.5,abs( tscs.EL_Position_Error.val())/0.5)

        ss=tt % 60 
        mm= (tt - ss) / 60
        if mm==0:
            print "#say# %.0lf seconds to arrive. " %ss
        else:
            print "#say# %.0lf minutes %.0lf seconds to arrive. " %(mm,ss)
        time.sleep(10)

        #        print "#say# Azimuth is %.0lf degrees." %(-1.0*tscs.AZ_Real_Angle.val())
        # time.sleep(10)

    # -- PF rotator arrive
    if tscv.TSC_Focus_PIR_Selected==1 or tscv.TSC_Focus_POpt_Selected==1:
        r0=tscs.P_Rotator_Real_Angle.val()
        r1=tscs.P_Rotator_CMD_ANS.val()
        dr=abs(r1-r0)
        sp=abs(tscl.P_Rotator_Rate_REF.val())
        if dr> 1.0 and sp > 0.1:
            dr /= sp
            ss=dr % 60 
            mm= (dr - ss) / 60
            if mm==0:
                print "#say# Needs %3.0lf seconds for Rotator."%dr 
                time.sleep(4)
            else:
                print "#say# Needs %.0lf minutes %2.0lf seconds for Rotator."%(mm,ss)
                time.sleep(6)

    #-- Auto-Z failure check(bug)        
    T01=tscl.U_TRS_Opt_Temp2_Data.val();#--//// TEMPS24 :390:TSCL(4712:6:D)
    T02=tscl.U_TRS_Opt_Temp1_Data.val();#--//// TEMPS23 :384:TSCL(4706:6:D)
    T03=tscl.U_TRS_R_Temp1_Data.val();#--//// TEMPS22 :378:TSCL(4700:6:D)
    T04=tscl.U_TRS_R_Temp2_Data.val();#--//// TEMPS29 :420:TSCL(4742:6:D)
    T05=tscl.U_TRS_IR_Temp1_Data.val();#--//// TEMPS28 :414:TSCL(4736:6:D)
    T06=tscl.U_TRS_IR_Temp2_Data.val();#--//// TEMPS27 :408:TSCL(4730:6:D)
    T07=tscl.U_TRS_F_Temp2_Data.val();#--//// TEMPS26 :402:TSCL(4724:6:D)
    T08=tscl.U_TRS_F_Temp1_Data.val();#--//// TEMPS25 :396:TSCL(4718:6:D)

    T09a=tscl.CSCT_Opt_U_Temp_Data.val();#--//// TEMPS31 :432:TSCL(4754:6:D)
    T09b=tscl.CSCT_Opt_L_Temp_Data.val();#--//// TEMPS32 :438:TSCL(4760:6:D)
    T10=tscl.CSCT_R_Temp_Data.val();#--//// TEMPS30 :426:TSCL(4748:6:D)
    T11a=tscl.CSCT_IR_U_Temp_Data.val();#--//// TEMPS34 :450:TSCL(4772:6:D)
    T11b=tscl.CSCT_IR_L_Temp_Data.val();#--//// TEMPS35 :456:TSCL(4778:6:D)
    T12=tscl.CSCT_F_Temp_Data.val();#--//// TEMPS33 :444:TSCL(4766:6:D)

    T09=(T09a+T09b)/2.0;
    T11=(T11a+T11b)/2.0;
    T09=T09a; #--+T09b)/2.0;
    T11=T11a; #--+T11b)/2.0;

    T13=tscl.L_TRS_Opt_Temp4_Data.val();#--//// TEMPS40 :486:TSCL(4808:6:D)
    T14=tscl.L_TRS_Opt_Temp3_Data.val();#--//// TEMPS39 :480:TSCL(4802:6:D)
    T15=tscl.L_TRS_Opt_Temp2_Data.val();#--//// TEMPS38 :474:TSCL(4796:6:D)
    T16=tscl.L_TRS_Opt_Temp1_Data.val();#--//// TEMPS37 :468:TSCL(4790:6:D)
    T17=tscl.L_TRS_R_Temp1_Data.val();#--//// TEMPS36 :462:TSCL(4784:6:D)
    T18=tscl.L_TRS_R_Temp2_Data.val();#--//// TEMPS47 :528:TSCL(4850:6:D)
    T19=tscl.L_TRS_IR_Temp1_Data.val();#--//// TEMPS46 :522:TSCL(4844:6:D)
    T20=tscl.L_TRS_IR_Temp2_Data.val();#--//// TEMPS45 :516:TSCL(4838:6:D)
    T21=tscl.L_TRS_IR_Temp3_Data.val();#--//// TEMPS44 :510:TSCL(4832:6:D)
    T22=tscl.L_TRS_IR_Temp4_Data.val();#--//// TEMPS43 :504:TSCL(4826:6:D)
    T23=tscl.L_TRS_F_Temp2_Data.val();#--//// TEMPS42 :498:TSCL(4820:6:D)
    T24=tscl.L_TRS_F_Temp1_Data.val();#--//// TEMPS41 :492:TSCL(4814:6:D)

    T01-=-0.9
    T02-=-0.9
    T03-=-0.5
    T04-= 0.0
    T05-=-0.9
    T06-=-0.8
    T07-=-0.7
    T08-=-0.2
    T09-=-0.9
    T10-=-0.8
    T11-=-0.7
    T12-=-0.8
    T13-=-0.8
    T14-=-1.0
    T15-=0.4
    T16-=-0.4
    T17-=-0.7
    T18-=-0.5
    T19-=-0.4
    T20-=-1.1
    T21-=-1.0
    T22-=-0.7
    T23-=-1.1
    T24-=-0.7

    calZ=-0.0154*T01+ -0.0147*T02+ -0.0124*T03+ -0.0132*T04+ -0.0154*T05+ -0.0147*T06+ -0.0124*T07+ -0.0132*T08+ -0.00082*T09+ 0.01956*T10+ -0.00082*T11+ 0.01446*T12+ -0.00294*T13+ -0.00342*T14+ -0.00207*T15+ -0.00163*T16+ -0.00862*T17+ -0.00861*T18+ -0.00163*T19+ -0.00208*T20+ -0.00342*T21+ -0.00294*T22+ -0.00468*T23+ -0.00467*T24
    d=0.025
    if tscv.TSC_Focus_PIR_Selected==1 or tscv.TSC_Focus_POpt_Selected==1:
        d=0.025
    if tscv.SM_Auto_Focus_Adjustment_On==1 and abs(tscv.SM_Auto_Focus_Z_Offset_Position.val()-calZ)>=d:
        print "#say#  Attention. Auto Zet is not synchronized. The difference is %+.3lf millimeters. "%((tscv.SM_Auto_Focus_Z_Offset_Position.val()-calZ)*1.0)
        time.sleep(10)

    # -- offset-Z change 
    off_Z=tscv.SM_z_axis_Offset.val()
    if off_Z!=off_Z_0:
        print "#say#  Offset Z changed to %.3lf millimeters. "%off_Z
        time.sleep(4)
        off_Z_0=off_Z

    # -- Wind speed check       
    if tscl.Weather_Wind_Velocity_Max.val() >= 14.0:
        name_E="";name_Etalk="";name_J=""; 
        d=(int)(tscl.Weather_Wind_Direction_Max.val()/360*16+0.5)
        if d>=16: d=16
        name_E=("N  ","NNE","NE ","ENE","E  ","ESE","SE ","SSE","S  ","SSW","SW ","WSW","W  ","WNW","NW ","NNW","N  ")[d]
        name_Etalk=("North  ","North North East ","North East  ","East North East ","East   ","East South East ","South East  ","South South East ","South   ","South South West ","South West  ","West South West ","West   ","West North West ","North West  ","North North West ","North   ")[d]
        name_J=("Kita       ","HokuHokuToh","HokuToh    ","TohHokuToh ","Higashi    ","TohNanToh  ","NanToh     ","NanNanToh  ","Minami     ","NanNannSei ","NanSei     ","SeiNanSei  ","Nishi      ","SeiHokuSei ","HokuSei    ","HokuHokuSei","Kita       ")[d]
        print "#say#Maximum Wind speed is %4.0lf meters from the %s." %(tscl.Weather_Wind_Velocity_Max.val(),name_Etalk)
        time.sleep(10)

    # --   Wind screen Async sheck
    if tscv.Wind_Screen_EL_ASYNC_Mode==1 and tscl.Wind_Screen_CMD_Position.val() >= 0.10:
        print "#say#Wind Screen is not synchronized. Please make a check."
        time.sleep(10)

    # --   Wind screen Vignetting (hiding) the light path ( Only moving lower elevation)
    el=tscs.EL_CMD_Angle_ANS.val()
    el_rad=el*math.pi/180.0
    if(el < 70.0) :
        H_wscrn= 14.3 * math.tan(el_rad) - 6.5 / math.cos(el_rad) + 2.0
    else :
        H_wscrn= 14.5
    if H_wscrn < 0.05 :  H_wscrn=0.05
    if H_wscrn > 14.5 :  H_wscrn=14.5
    diff_wscrn = H_wscrn - tscl.Wind_Screen_Real_Position.val()
    if tscl.Wind_Screen_Real_Position.val() >= 0.10 and abs(tscl.Wind_Screen_CMD_Position.val() - tscl.Wind_Screen_Real_Position.val()) > 0.20 and diff_wscrn < -0.10 :
       #-- ( "not at the rest postion" and "moving" and "hide more than 10cm ( diff_wscrn is minus)" ) regardless of "(Async or  Sync)"
        tt=(int)(abs(diff_wscrn)/0.0583) # -- estimate 2004/01 morino m / sec
        ss=tt % 60 
        mm= (tt - ss) / 60
        if mm==0:
            print "#say# %.0lf seconds for wind screen to clear view. " %ss
            time.sleep(5)
        else:
            print "#say# %.0lf minutes %.0lf seconds for wind screen to clear view. " %(mm,ss)
            time.sleep(6)

    # -- wind velocity at the Primary mirror
    if abs(tscl.CSCT_R_WVEL_Z_Data.val())>=2.0 or abs(tscl.CSCT_F_WVEL_Z_Data.val())>=2.0:
        print "#say#Center Section wind speed is %.0lf meter."%(max(abs(tscl.CSCT_R_WVEL_Z_Data.val()),abs(tscl.CSCT_F_WVEL_Z_Data.val())))
        time.sleep(10)

    # -- AG, SV, SH
    exp_SH=tscv.SH_Exposure_On
    if exp_SH != exp_SH_0 :
        if exp_SH==1: print "#say# Shack Hartmann exposure begins."
        if exp_SH==0: print "#say# Shack Hartmann exposure has finished."
        time.sleep(5)
            
    exp_AG=tscv.AG_Exposure_On
    guide_AG=tscv.AG1_Auto_Guide + tscv.AG2_Auto_Guide
    if guide_AG != guide_AG_0 :
        if guide_AG ==1: print "#say# Start Auto Guiding."
        if guide_AG ==0: print "#say# Stop Auto Guiding."
        time.sleep(3)
        exp_AG_0=tscv.AG_Exposure_On #-- for reading time

    if exp_AG != exp_AG_0 :
        if exp_AG==1: print "#say# A G exposure is turned ON."
        if exp_AG==0: print "#say# A G exposure is turned OFF."
        time.sleep(5)

    exp_SV=tscv.SV_Exposure_On
    if exp_SV != exp_SV_0 :
        if exp_SV==1: print "#say# S V guiding exposure begins."
        if exp_SV==0: print "#say# S V guiding exposure has finished."
        time.sleep(5)

#        guide_SV=tscv.SV1_Auto_Guide + tscv.SV2_Auto_Guide
#        if guide_SV != guide_SV_0 :
#            if guide_SV ==1: print "#say# I will start Slit View Guiding."
#            if guide_SV ==0: print "#say# I will stop Slit View Guiding."
#            time.sleep(5)

    exp_SH_0=exp_SH
    exp_AG_0=exp_AG
    exp_SV_0=exp_SV
    guide_AG_0=guide_AG
#        guide_SV_0=guide_SV

    time.sleep(1) 
        
