#!/usr/local/bin/python

import tel
import shm
import time

ms = shm.memory(shm.getshmid(0x100));
tscs=tel.TSCShort();
ms.attach(); 

ml = shm.memory(shm.getshmid(0x101));
tscl=tel.TSCLong();
ml.attach();

mv = shm.memory(shm.getshmid(0x102));
tscv=tel.TSCVstat();
mv.attach(); 

tscs.set(ms.read(1292))
tscl.set(ml.read(1292*7))
tscv.vset(mv.read(12931))

head=""

head="#say# "
print head+"Summit condition summary."
time.sleep(4)

print head+"Air temperature is %.1lf degree in cersius."%tscl.Weather_Temperature.val()
time.sleep(6)
print head+"Humidity: %.0lf %%."%tscl.Weather_Humidity.val()
time.sleep(5)
name_E="";name_Etalk="";name_J=""; 
d=(int)(tscl.Weather_Wind_Direction_AVG.val()/360*16+0.5)
if d>=16: d=16
name_E=("N  ","NNE","NE ","ENE","E  ","ESE","SE ","SSE","S  ","SSW","SW ","WSW","W  ","WNW","NW ","NNW","N  ")[d]
name_Etalk=("North  ","North North East ","North East  ","East North East ","East   ","East South East ","South East  ","South South East ","South   ","South South West ","South West  ","West South West ","West   ","West North West ","North West  ","North North West ","North   ")[d]
name_J=("Kita       ","HokuHokuToh","HokuToh    ","TohHokuToh ","Higashi    ","TohNanToh  ","NanToh     ","NanNanToh  ","Minami     ","NanNannSei ","NanSei     ","SeiNanSei  ","Nishi      ","SeiHokuSei ","HokuSei    ","HokuHokuSei","Kita       ")[d]
print head+"Average Wind speed is %4.0lf meters from the %s." %(tscl.Weather_Wind_Velocity_Max.val(),name_Etalk)
time.sleep(8)
print head+"Azimuth is %.0lf degrees." %tscs.AZ_Real_Angle.val()
time.sleep(5)
print head+"Elevation is %.0lf degrees." %tscs.EL_Real_Angle.val()
time.sleep(5)

res="off"
if tscv.AG_Exposure_On==1 and (tscv.AG1_Auto_Guide==1  or tscv.AG2_Auto_Guide==1):res="on"
print head+"Auto Guide mode is %s."%res
time.sleep(4)

SyMode=""
if tscv.Wind_Screen_EL_ASYNC_Mode==1: SyMode="not "
if tscv.Wind_Screen_EL_SYNC_Mode==1: SyMode=""
print head+"Wind screen is %s synchronized" %SyMode
time.sleep(4)
name=tscv.OBE_Name[:20]
if name=="": name="invalid . It is not detected"
print head+"Observation Instrument at selected focus is %s."%name
time.sleep(8)


sh_opt="not detected"
if tscv.Opt_Shutter_Full_Close==1 : sh_opt="Full Close"
if tscv.Opt_Shutter_Full_Open==1 : sh_opt="Full Open "
sh_ir="not detected"
if tscv.IR_Shutter_Full_Close==1 : sh_ir="Full Close"
if tscv.IR_Shutter_Full_Open==1 : sh_ir="Full Open "

if sh_opt==sh_ir:
    print head+"Main shutter is %s."%sh_opt
    time.sleep(4)
else:
    if(sh_opt=="not detected"):
        print head+"Main shutter of IR side is %s, but Optical side is %s."%(sh_ir,sh_opt)
        time.sleep(8)
    elif(sh_ir=="not detected"):
        print head+"Main shutter of Optical side is %s, but IR side is %s."%(sh_opt,sh_ir)
        time.sleep(8)
    else:
        print head+"Main shutter of Optical side is %s, and IR side is %s."%(sh_opt,sh_ir)
        time.sleep(10)

