import curses,math,string
#------initial----
page=1
mode=0
smode=1
prev_page=1
prev_mm=-1.0
prev_ss=-1.0
prev_test=0
#----------
def cus_SH(screen,tscs,ms,tscl,ml,tscv,mv):
    tscs.set(ms.read(1292))
    tscl.set(ml.read(9044))
    tscv.vset(mv.read(12931))
    maxpage=7  #--- Do not forget to modify
    global page
    global prev_page,prev_mm,prev_ss,prev_test
    if page>maxpage : page=maxpage
    if page<1 : page=1
    if page==1:
        screen.addstr( 2,0, "SH measurement:", curses.A_REVERSE)

        screen.addstr( 1+2,0, " Zernike ", curses.A_NORMAL) #--morino
        screen.addstr( 1+2,10, "  %4.0lf terms " %tscv.MLP2_Zernike_Count.val(), curses.A_NORMAL)

        screen.addstr( 2+2,0, "   RMS Total      : %.3g [micron]" %tscv.Zernike_Data_RMS_Total.val(), curses.A_NORMAL) #--morino
        screen.addstr( 3+2,0, "       without A20: %.3g [micron]" %tscv.Zernike_Data_RMS_without_A20.val(), curses.A_NORMAL)
        screen.addstr( 5+2,0, " SH Error RMS   : %.3g " %tscv.SH_Error_RMS.val(), curses.A_NORMAL)
        screen.addstr( 6+2,0, " EL of Calc.    :%6.2lf [deg] " % tscv.EL_Angle_Zernike_Calculate.val(), curses.A_NORMAL)
        screen.addstr( 7+2,0, " data  (UT)     : %04.0lf/%02.0lf/%02.0lf %02.0lf:%02.0lf:%04.1lf" %(tscv.time0040.year(),tscv.time0040.month(),tscv.time0040.day(),tscv.time0040.hh(),tscv.time0040.mm(),tscv.time0040.ss()),curses.A_NORMAL)

        screen.addstr( 1+2,40," MLP2_Zernike_Input_SH: %1d " %tscv.MLP2_Zernike_Input_SH, curses.A_NORMAL)
        screen.addstr( 2+2,40," MLP2_Zernike_Input_TSC: %1d " %tscv.MLP2_Zernike_Input_TSC, curses.A_NORMAL)
        screen.addstr( 3+2,41,"    Zernike_RMS_Alarm: %1d " %tscv.Zernike_RMS_Alarm, curses.A_NORMAL)
        screen.addstr( 4+2,40," Mirror_Support_Correction_Limit: %1d " %tscv.Mirror_Support_Correction_Limit, curses.A_NORMAL)
        screen.addstr( 5+2,40," Mirror_Support_Alarm_IND: %1d " %tscv.Mirror_Support_Alarm_IND, curses.A_NORMAL)
        #  TIME4 MLP2_Zernike_Time;	// 138
        screen.addstr( 6+2,40,"      MLP2_Zernike_SH: %1d " %tscv.MLP2_Zernike_SH, curses.A_NORMAL)
        screen.addstr( 7+2,40,"     MLP2_Zernike_TSC: %1d " %tscv.MLP2_Zernike_TSC, curses.A_NORMAL)
        #Estimate
        screen.addstr( 9+2,0, "Estimate of Strehl ratio by optics", curses.A_NORMAL)
        screen.addstr(10+2,0, "     at 0.35 micron (U): %8.6lf " %math.exp(-pow(tscv.Zernike_Data_RMS_without_A20.val()/0.35*math.pi,2.0)), curses.A_NORMAL)
        screen.addstr(11+2,0, "     at 0.55 micron (V): %8.6lf " %math.exp(-pow(tscv.Zernike_Data_RMS_without_A20.val()/0.55*math.pi,2.0)), curses.A_NORMAL)
        screen.addstr(12+2,0, "     at 0.72 micron (R): %8.6lf " %math.exp(-pow(tscv.Zernike_Data_RMS_without_A20.val()/0.72*math.pi,2.0)), curses.A_NORMAL)
        screen.addstr(13+2,0, "     at 1.25 micron (J): %5.3lf " %math.exp(-pow(tscv.Zernike_Data_RMS_without_A20.val()/1.25*math.pi,2.0)), curses.A_NORMAL)
        screen.addstr(14+2,0, "     at 1.5  micron (H): %5.3lf " %math.exp(-pow(tscv.Zernike_Data_RMS_without_A20.val()/1.5 *math.pi,2.0)), curses.A_NORMAL)
        screen.addstr(15+2,0, "     at 2.2  micron (K): %5.3lf " %math.exp(-pow(tscv.Zernike_Data_RMS_without_A20.val()/2.2 *math.pi,2.0)), curses.A_NORMAL)

        screen.addstr(16+2,0, "     at 3.6  micron (L): %5.3lf " %math.exp(-pow(tscv.Zernike_Data_RMS_without_A20.val()/3.6 *math.pi,2.0)), curses.A_NORMAL)
        screen.addstr(17+2,0, "     at 10   micron (N): %5.3lf " %math.exp(-pow(tscv.Zernike_Data_RMS_without_A20.val()/10.0 *math.pi,2.0)), curses.A_NORMAL)
        screen.addstr(18+2,0, "     at 20   micron (Q): %5.3lf " %math.exp(-pow(tscv.Zernike_Data_RMS_without_A20.val()/20.0 *math.pi,2.0)), curses.A_NORMAL)
        screen.vline(   0+2, 39, "|", 20)
        #    };
        #  };
        #  char MLP2_Zernike_Data[560];	// 146 //morino offset bbit def strange cvs
        #     screen.addstr( 4,0, " Actuator_Force_Of_Eigen_Data[384]: %.8g " %tscv.Actuator_Force_Of_Eigen_Data[384].val(), curses.A_NORMAL)
        screen.addstr( 9+2,40," SM_Position_Of_Zernike_Offset", curses.A_NORMAL)
        screen.addstr(10+2,45," U      : %+10.6lf " % tscv.SM_U_Position_Of_Zernike_Offset.val(), curses.A_NORMAL)
        screen.addstr(11+2,45," V      : %+10.6lf " % tscv.SM_V_Position_Of_Zernike_Offset.val(), curses.A_NORMAL)
        screen.addstr(12+2,45," Z_CC   : %+10.6lf " % tscv.SM_Z_Position_Of_Zernike_Offset_CC.val(), curses.A_NORMAL)
        screen.addstr(13+2,45," X      : %+10.6lf " % tscv.SM_X_Position_Of_Zernike_Offset.val(), curses.A_NORMAL)
        screen.addstr(14+2,45," Y      : %+10.6lf " % tscv.SM_Y_Position_Of_Zernike_Offset.val(), curses.A_NORMAL)
        screen.addstr(15+2,45," Z_SP   : %+10.6lf " % tscv.SM_Z_Position_Of_Zernike_Offset_SP.val(), curses.A_NORMAL)
        screen.addstr(16+2,45," theta-X: %+10.6lf " % tscv.SM_X_Angle_Of_Zernike_Offset.val(), curses.A_NORMAL)
        screen.addstr(17+2,45," theta-Y: %+10.6lf " % tscv.SM_Y_Angle_Of_Zernike_Offset.val(), curses.A_NORMAL)

    if page==2:
#        screen.addstr( 0,0, ": %.8g " %tscv.SH_Error_RMS.val(), curses.A_NORMAL)
        screen.addstr( 0+2, 0, "#00_A00   :%6.3lf "%tscv.MLP2_Zernike_Data_00_A00.val(), curses.A_NORMAL)
        screen.addstr( 1+2, 0, "#01_A11   :%6.3lf "%tscv.MLP2_Zernike_Data_01_A11.val(),curses.A_NORMAL)
        screen.addstr( 2+2, 0, "#02_A1m1  :%6.3lf "%tscv.MLP2_Zernike_Data_02_A1m1.val(),curses.A_NORMAL)
        screen.addstr( 3+2, 0, "#03_A20   :%6.3lf "%tscv.MLP2_Zernike_Data_03_A20.val(),curses.A_NORMAL)
        screen.addstr( 4+2, 0, "#04_A31   :%6.3lf "%tscv.MLP2_Zernike_Data_04_A31.val(),curses.A_NORMAL)
        screen.addstr( 5+2, 0, "#05_A3m1  :%6.3lf "%tscv.MLP2_Zernike_Data_05_A3m1.val(),curses.A_NORMAL)
        screen.addstr( 6+2, 0, "#06_A22   :%6.3lf "%tscv.MLP2_Zernike_Data_06_A22.val(),curses.A_NORMAL)
        screen.addstr( 7+2, 0, "#07_A2m2  :%6.3lf "%tscv.MLP2_Zernike_Data_07_A2m2.val(),curses.A_NORMAL)
        screen.addstr( 8+2, 0, "#08_A33   :%6.3lf "%tscv.MLP2_Zernike_Data_08_A33.val(),curses.A_NORMAL)
        screen.addstr( 9+2, 0, "#09_A3m3  :%6.3lf "%tscv.MLP2_Zernike_Data_09_A3m3.val(),curses.A_NORMAL)
        screen.addstr(10+2, 0, "#10_A40   :%6.3lf "%tscv.MLP2_Zernike_Data_10_A40.val(),curses.A_NORMAL)
        screen.addstr(11+2, 0, "#11_A42   :%6.3lf "%tscv.MLP2_Zernike_Data_11_A42.val(),curses.A_NORMAL)
        screen.addstr(12+2, 0, "#12_A4m2  :%6.3lf "%tscv.MLP2_Zernike_Data_12_A4m2.val(),curses.A_NORMAL)
        screen.addstr(13+2, 0, "#13_A44   :%6.3lf "%tscv.MLP2_Zernike_Data_13_A44.val(),curses.A_NORMAL)
        screen.addstr(14+2, 0, "#14_A4m4  :%6.3lf "%tscv.MLP2_Zernike_Data_14_A4m4.val(),curses.A_NORMAL)
        screen.addstr(15+2, 0, "#15_A51   :%6.3lf "%tscv.MLP2_Zernike_Data_15_A51.val(),curses.A_NORMAL)
        screen.addstr(16+2, 0, "#16_A5m1  :%6.3lf "%tscv.MLP2_Zernike_Data_16_A5m1.val(),curses.A_NORMAL)
        screen.addstr(17+2, 0, "#17_A53   :%6.3lf "%tscv.MLP2_Zernike_Data_17_A53.val(),curses.A_NORMAL)
        screen.addstr(18+2, 0, "#18_A5m3  :%6.3lf "%tscv.MLP2_Zernike_Data_18_A5m3.val(),curses.A_NORMAL)
        screen.addstr(19+2, 0, "#19_A55   :%6.3lf "%tscv.MLP2_Zernike_Data_19_A55.val(),curses.A_NORMAL)
        screen.addstr( 0+2,20, "#20_A5m5  :%6.3lf "%tscv.MLP2_Zernike_Data_20_A5m5.val(),curses.A_NORMAL)
        screen.addstr( 1+2,20, "#21_A60   :%6.3lf "%tscv.MLP2_Zernike_Data_21_A60.val(),curses.A_NORMAL)
        screen.addstr( 2+2,20, "#22_A62   :%6.3lf "%tscv.MLP2_Zernike_Data_22_A62.val(),curses.A_NORMAL)
        screen.addstr( 3+2,20, "#23_A6m2  :%6.3lf "%tscv.MLP2_Zernike_Data_23_A6m2.val(),curses.A_NORMAL)
        screen.addstr( 4+2,20, "#24_A64   :%6.3lf "%tscv.MLP2_Zernike_Data_24_A64.val(),curses.A_NORMAL)
        screen.addstr( 5+2,20, "#25_A6m4  :%6.3lf "%tscv.MLP2_Zernike_Data_25_A6m4.val(),curses.A_NORMAL)
        screen.addstr( 6+2,20, "#26_A66   :%6.3lf "%tscv.MLP2_Zernike_Data_26_A66.val(),curses.A_NORMAL)
        screen.addstr( 7+2,20, "#27_A6m6  :%6.3lf "%tscv.MLP2_Zernike_Data_27_A6m6.val(),curses.A_NORMAL)
        screen.addstr( 8+2,20, "#28_A71   :%6.3lf "%tscv.MLP2_Zernike_Data_28_A71.val(),curses.A_NORMAL)
        screen.addstr( 9+2,20, "#29_A7m1  :%6.3lf "%tscv.MLP2_Zernike_Data_29_A7m1.val(),curses.A_NORMAL)
        screen.addstr(10+2,20, "#30_A73   :%6.3lf "%tscv.MLP2_Zernike_Data_30_A73.val(),curses.A_NORMAL)
        screen.addstr(11+2,20, "#31_A7m3  :%6.3lf "%tscv.MLP2_Zernike_Data_31_A7m3.val(),curses.A_NORMAL)
        screen.addstr(12+2,20, "#32_A75   :%6.3lf "%tscv.MLP2_Zernike_Data_32_A75.val(),curses.A_NORMAL)
        screen.addstr(13+2,20, "#33_A7m5  :%6.3lf "%tscv.MLP2_Zernike_Data_33_A7m5.val(),curses.A_NORMAL)
        screen.addstr(14+2,20, "#34_A77   :%6.3lf "%tscv.MLP2_Zernike_Data_34_A77.val(),curses.A_NORMAL)
        screen.addstr(15+2,20, "#35_A7m7  :%6.3lf "%tscv.MLP2_Zernike_Data_35_A7m7.val(),curses.A_NORMAL)
        screen.addstr(16+2,20, "#36_A80   :%6.3lf "%tscv.MLP2_Zernike_Data_36_A80.val(),curses.A_NORMAL)
        screen.addstr(17+2,20, "#37_A82   :%6.3lf "%tscv.MLP2_Zernike_Data_37_A82.val(),curses.A_NORMAL)
        screen.addstr(18+2,20, "#38_A8m2  :%6.3lf "%tscv.MLP2_Zernike_Data_38_A8m2.val(),curses.A_NORMAL)
        screen.addstr(19+2,20, "#39_A84   :%6.3lf "%tscv.MLP2_Zernike_Data_39_A84.val(),curses.A_NORMAL)
        screen.addstr( 0+2,40, "#40_A8m4  :%6.3lf "%tscv.MLP2_Zernike_Data_40_A8m4.val(),curses.A_NORMAL)
        screen.addstr( 1+2,40, "#41_A86   :%6.3lf "%tscv.MLP2_Zernike_Data_41_A86.val(),curses.A_NORMAL)
        screen.addstr( 2+2,40, "#42_A8m6  :%6.3lf "%tscv.MLP2_Zernike_Data_42_A8m6.val(),curses.A_NORMAL)
        screen.addstr( 3+2,40, "#43_A88   :%6.3lf "%tscv.MLP2_Zernike_Data_43_A88.val(),curses.A_NORMAL)
        screen.addstr( 4+2,40, "#44_A8m8  :%6.3lf "%tscv.MLP2_Zernike_Data_44_A8m8.val(),curses.A_NORMAL)
        screen.addstr( 5+2,40, "#45_A91   :%6.3lf "%tscv.MLP2_Zernike_Data_45_A91.val(),curses.A_NORMAL)
        screen.addstr( 6+2,40, "#46_A9m1  :%6.3lf "%tscv.MLP2_Zernike_Data_46_A9m1.val(),curses.A_NORMAL)
        screen.addstr( 7+2,40, "#47_A93   :%6.3lf "%tscv.MLP2_Zernike_Data_47_A93.val(),curses.A_NORMAL)
        screen.addstr( 8+2,40, "#48_A9m3  :%6.3lf "%tscv.MLP2_Zernike_Data_48_A9m3.val(),curses.A_NORMAL)
        screen.addstr( 9+2,40, "#49_A95   :%6.3lf "%tscv.MLP2_Zernike_Data_49_A95.val(),curses.A_NORMAL)
        screen.addstr(10+2,40, "#50_A9m5  :%6.3lf "%tscv.MLP2_Zernike_Data_50_A9m5.val(),curses.A_NORMAL)
        screen.addstr(11+2,40, "#51_A97   :%6.3lf "%tscv.MLP2_Zernike_Data_51_A97.val(),curses.A_NORMAL)
        screen.addstr(12+2,40, "#52_A9m7  :%6.3lf "%tscv.MLP2_Zernike_Data_52_A9m7.val(),curses.A_NORMAL)
        screen.addstr(13+2,40, "#53_A99   :%6.3lf "%tscv.MLP2_Zernike_Data_53_A99.val(),curses.A_NORMAL)
        screen.addstr(14+2,40, "#54_A9m9  :%6.3lf "%tscv.MLP2_Zernike_Data_54_A9m9.val(),curses.A_NORMAL)
        screen.addstr(15+2,40, "#55_A100  :%6.3lf "%tscv.MLP2_Zernike_Data_55_A100.val(),curses.A_NORMAL)
        screen.addstr(16+2,40, "#56_A102  :%6.3lf "%tscv.MLP2_Zernike_Data_56_A102.val(),curses.A_NORMAL)
        screen.addstr(17+2,40, "#57_A10m2 :%6.3lf "%tscv.MLP2_Zernike_Data_57_A10m2.val(),curses.A_NORMAL)
        screen.addstr(18+2,40, "#58_A104  :%6.3lf "%tscv.MLP2_Zernike_Data_58_A104.val(),curses.A_NORMAL)
        screen.addstr(19+2,40, "#59_A10m4 :%6.3lf "%tscv.MLP2_Zernike_Data_59_A10m4.val(),curses.A_NORMAL)
        screen.addstr( 0+2,60, "#60_A106  :%6.3lf "%tscv.MLP2_Zernike_Data_60_A106.val(),curses.A_NORMAL)
        screen.addstr( 1+2,60, "#61_A10m6 :%6.3lf "%tscv.MLP2_Zernike_Data_61_A10m6.val(),curses.A_NORMAL)
        screen.addstr( 2+2,60, "#62_A108  :%6.3lf "%tscv.MLP2_Zernike_Data_62_A108.val(),curses.A_NORMAL)
        screen.addstr( 3+2,60, "#63_A10m8 :%6.3lf "%tscv.MLP2_Zernike_Data_63_A10m8.val(),curses.A_NORMAL)
        screen.addstr( 4+2,60, "#64_A1010 :%6.3lf "%tscv.MLP2_Zernike_Data_64_A1010.val(),curses.A_NORMAL)
        screen.addstr( 5+2,60, "#65_A10m10:%6.3lf "%tscv.MLP2_Zernike_Data_65_A10m10.val(),curses.A_NORMAL)
        screen.addstr( 6+2,60, "#66:%6.3lf "%tscv.MLP2_Zernike_Data_66.val(),curses.A_NORMAL)
        screen.addstr( 7+2,60, "#67:%6.3lf "%tscv.MLP2_Zernike_Data_67.val(),curses.A_NORMAL)
        screen.addstr( 8+2,60, "#68:%6.3lf "%tscv.MLP2_Zernike_Data_68.val(),curses.A_NORMAL)
        screen.addstr( 9+2,60, "#69:%6.3lf "%tscv.MLP2_Zernike_Data_69.val(),curses.A_NORMAL)
        screen.addstr( 18+2,60, "Zernike", curses.A_REVERSE)
        screen.addstr( 19+2,60, "[micron]",curses.A_NORMAL)
        screen.vline(   0+2, 18, "|", 20)
        screen.vline(   0+2, 38, "|", 20)
        screen.vline(   0+2, 58, "|", 20)

   
    if page==4:
#        screen.addstr( 0,0, ": %.8g " %tscv.SH_Error_RMS.val(), curses.A_NORMAL)
        screen.addstr( 0+2, 0, "Offset Zernike", curses.A_REVERSE)
        screen.addstr( 1+2, 0, "#01_A11   :%6.3lf "%tscv.Zernike_Offset_Data_01_A11.val(),curses.A_NORMAL)
        screen.addstr( 2+2, 0, "#02_A1m1  :%6.3lf "%tscv.Zernike_Offset_Data_02_A1m1.val(),curses.A_NORMAL)
        screen.addstr( 3+2, 0, "#03_A20   :%6.3lf "%tscv.Zernike_Offset_Data_03_A20.val(),curses.A_NORMAL)
        screen.addstr( 4+2, 0, "#04_A31   :%6.3lf "%tscv.Zernike_Offset_Data_04_A31.val(),curses.A_NORMAL)
        screen.addstr( 5+2, 0, "#05_A3m1  :%6.3lf "%tscv.Zernike_Offset_Data_05_A3m1.val(),curses.A_NORMAL)
        screen.addstr( 6+2, 0, "#06_A22   :%6.3lf "%tscv.Zernike_Offset_Data_06_A22.val(),curses.A_NORMAL)
        screen.addstr( 7+2, 0, "#07_A2m2  :%6.3lf "%tscv.Zernike_Offset_Data_07_A2m2.val(),curses.A_NORMAL)
        screen.addstr( 8+2, 0, "#08_A33   :%6.3lf "%tscv.Zernike_Offset_Data_08_A33.val(),curses.A_NORMAL)
        screen.addstr( 9+2, 0, "#09_A3m3  :%6.3lf "%tscv.Zernike_Offset_Data_09_A3m3.val(),curses.A_NORMAL)
        screen.addstr(10+2, 0, "#10_A40   :%6.3lf "%tscv.Zernike_Offset_Data_10_A40.val(),curses.A_NORMAL)
        screen.addstr(11+2, 0, "#11_A42   :%6.3lf "%tscv.Zernike_Offset_Data_11_A42.val(),curses.A_NORMAL)
        screen.addstr(12+2, 0, "#12_A4m2  :%6.3lf "%tscv.Zernike_Offset_Data_12_A4m2.val(),curses.A_NORMAL)
        screen.addstr(13+2, 0, "#13_A44   :%6.3lf "%tscv.Zernike_Offset_Data_13_A44.val(),curses.A_NORMAL)
        screen.addstr(14+2, 0, "#14_A4m4  :%6.3lf "%tscv.Zernike_Offset_Data_14_A4m4.val(),curses.A_NORMAL)
        screen.addstr(15+2, 0, "#15_A51   :%6.3lf "%tscv.Zernike_Offset_Data_15_A51.val(),curses.A_NORMAL)
        screen.addstr(16+2, 0, "#16_A5m1  :%6.3lf "%tscv.Zernike_Offset_Data_16_A5m1.val(),curses.A_NORMAL)
        screen.addstr(17+2, 0, "#17_A53   :%6.3lf "%tscv.Zernike_Offset_Data_17_A53.val(),curses.A_NORMAL)
        screen.addstr(18+2, 0, "#18_A5m3  :%6.3lf "%tscv.Zernike_Offset_Data_18_A5m3.val(),curses.A_NORMAL)
        screen.addstr(19+2, 0, "#19_A55   :%6.3lf "%tscv.Zernike_Offset_Data_19_A55.val(),curses.A_NORMAL)
        screen.addstr( 0+2,20, "#20_A5m5  :%6.3lf "%tscv.Zernike_Offset_Data_20_A5m5.val(),curses.A_NORMAL)
        screen.addstr( 1+2,20, "#21_A60   :%6.3lf "%tscv.Zernike_Offset_Data_21_A60.val(),curses.A_NORMAL)
        screen.addstr( 2+2,20, "#22_A62   :%6.3lf "%tscv.Zernike_Offset_Data_22_A62.val(),curses.A_NORMAL)
        screen.addstr( 3+2,20, "#23_A6m2  :%6.3lf "%tscv.Zernike_Offset_Data_23_A6m2.val(),curses.A_NORMAL)
        screen.addstr( 4+2,20, "#24_A64   :%6.3lf "%tscv.Zernike_Offset_Data_24_A64.val(),curses.A_NORMAL)
        screen.addstr( 5+2,20, "#25_A6m4  :%6.3lf "%tscv.Zernike_Offset_Data_25_A6m4.val(),curses.A_NORMAL)
        screen.addstr( 6+2,20, "#26_A66   :%6.3lf "%tscv.Zernike_Offset_Data_26_A66.val(),curses.A_NORMAL)
        screen.addstr( 7+2,20, "#27_A6m6  :%6.3lf "%tscv.Zernike_Offset_Data_27_A6m6.val(),curses.A_NORMAL)
        screen.addstr( 8+2,20, "#28_A71   :%6.3lf "%tscv.Zernike_Offset_Data_28_A71.val(),curses.A_NORMAL)
        screen.addstr( 9+2,20, "#29_A7m1  :%6.3lf "%tscv.Zernike_Offset_Data_29_A7m1.val(),curses.A_NORMAL)
        screen.addstr(10+2,20, "#30_A73   :%6.3lf "%tscv.Zernike_Offset_Data_30_A73.val(),curses.A_NORMAL)
        screen.addstr(11+2,20, "#31_A7m3  :%6.3lf "%tscv.Zernike_Offset_Data_31_A7m3.val(),curses.A_NORMAL)
        screen.addstr(12+2,20, "#32_A75   :%6.3lf "%tscv.Zernike_Offset_Data_32_A75.val(),curses.A_NORMAL)
        screen.addstr(13+2,20, "#33_A7m5  :%6.3lf "%tscv.Zernike_Offset_Data_33_A7m5.val(),curses.A_NORMAL)
        screen.addstr(14+2,20, "#34_A77   :%6.3lf "%tscv.Zernike_Offset_Data_34_A77.val(),curses.A_NORMAL)
        screen.addstr(15+2,20, "#35_A7m7  :%6.3lf "%tscv.Zernike_Offset_Data_35_A7m7.val(),curses.A_NORMAL)
        screen.addstr(16+2,20, "#36_A80   :%6.3lf "%tscv.Zernike_Offset_Data_36_A80.val(),curses.A_NORMAL)
        screen.addstr(17+2,20, "#37_A82   :%6.3lf "%tscv.Zernike_Offset_Data_37_A82.val(),curses.A_NORMAL)
        screen.addstr(18+2,20, "#38_A8m2  :%6.3lf "%tscv.Zernike_Offset_Data_38_A8m2.val(),curses.A_NORMAL)  #--- miss type
        screen.addstr(19+2,20, "#39_A84   :%6.3lf "%tscv.Zernike_Offset_Data_39_A84.val(),curses.A_NORMAL)
        screen.addstr( 0+2,40, "#40_A8m4  :%6.3lf "%tscv.Zernike_Offset_Data_40_A8m4.val(),curses.A_NORMAL)
        screen.addstr( 1+2,40, "#41_A86   :%6.3lf "%tscv.Zernike_Offset_Data_41_A86.val(),curses.A_NORMAL)
        screen.addstr( 2+2,40, "#42_A8m6  :%6.3lf "%tscv.Zernike_Offset_Data_42_A8m6.val(),curses.A_NORMAL)
        screen.addstr( 3+2,40, "#43_A88   :%6.3lf "%tscv.Zernike_Offset_Data_43_A88.val(),curses.A_NORMAL)
        screen.addstr( 4+2,40, "#44_A8m8  :%6.3lf "%tscv.Zernike_Offset_Data_44_A8m8.val(),curses.A_NORMAL)
        screen.addstr( 5+2,40, "#45_A91   :%6.3lf "%tscv.Zernike_Offset_Data_45_A91.val(),curses.A_NORMAL)
        screen.addstr( 6+2,40, "#46_A9m1  :%6.3lf "%tscv.Zernike_Offset_Data_46_A9m1.val(),curses.A_NORMAL)
        screen.addstr( 7+2,40, "#47_A93   :%6.3lf "%tscv.Zernike_Offset_Data_47_A93.val(),curses.A_NORMAL)
        screen.addstr( 8+2,40, "#48_A9m3  :%6.3lf "%tscv.Zernike_Offset_Data_48_A9m3.val(),curses.A_NORMAL)
        screen.addstr( 9+2,40, "#49_A95   :%6.3lf "%tscv.Zernike_Offset_Data_49_A95.val(),curses.A_NORMAL)
        screen.addstr(10+2,40, "#50_A9m5  :%6.3lf "%tscv.Zernike_Offset_Data_50_A9m5.val(),curses.A_NORMAL)
        screen.addstr(11+2,40, "#51_A97   :%6.3lf "%tscv.Zernike_Offset_Data_51_A97.val(),curses.A_NORMAL)
        screen.addstr(12+2,40, "#52_A9m7  :%6.3lf "%tscv.Zernike_Offset_Data_52_A9m7.val(),curses.A_NORMAL)
        screen.addstr(13+2,40, "#53_A99   :%6.3lf "%tscv.Zernike_Offset_Data_53_A99.val(),curses.A_NORMAL)
        screen.addstr(14+2,40, "#54_A9m9  :%6.3lf "%tscv.Zernike_Offset_Data_54_A9m9.val(),curses.A_NORMAL)
        screen.addstr(15+2,40, "#55_A100  :%6.3lf "%tscv.Zernike_Offset_Data_55_A100.val(),curses.A_NORMAL)
        screen.addstr(16+2,40, "#56_A102  :%6.3lf "%tscv.Zernike_Offset_Data_56_A102.val(),curses.A_NORMAL)
        screen.addstr(17+2,40, "#57_A10m2 :%6.3lf "%tscv.Zernike_Offset_Data_57_A10m2.val(),curses.A_NORMAL)
        screen.addstr(18+2,40, "#58_A104  :%6.3lf "%tscv.Zernike_Offset_Data_58_A104.val(),curses.A_NORMAL)
        screen.addstr(19+2,40, "#59_A10m4 :%6.3lf "%tscv.Zernike_Offset_Data_59_A10m4.val(),curses.A_NORMAL)
        screen.addstr( 0+2,60, "#60_A106  :%6.3lf "%tscv.Zernike_Offset_Data_60_A106.val(),curses.A_NORMAL)
        screen.addstr( 1+2,60, "#61_A10m6 :%6.3lf "%tscv.Zernike_Offset_Data_61_A10m6.val(),curses.A_NORMAL)
        screen.addstr( 2+2,60, "#62_A108  :%6.3lf "%tscv.Zernike_Offset_Data_62_A108.val(),curses.A_NORMAL)
        screen.addstr( 3+2,60, "#63_A10m8 :%6.3lf "%tscv.Zernike_Offset_Data_63_A10m8.val(),curses.A_NORMAL)
        screen.addstr( 4+2,60, "#64_A1010 :%6.3lf "%tscv.Zernike_Offset_Data_64_A1010.val(),curses.A_NORMAL)
        screen.addstr( 5+2,60, "#65_A10m10:%6.3lf "%tscv.Zernike_Offset_Data_65_A10m10.val(),curses.A_NORMAL)

        screen.vline(   0+2, 18, "|", 20)
        screen.vline(   0+2, 38, "|", 20)
        screen.vline(   0+2, 58, "|", 20)

   
    if page==5:
#        screen.addstr( 0,0, ": %.8g " %tscv.SH_Error_RMS.val(), curses.A_NORMAL)
        screen.addstr( 0+2, 0, "Eigen Data(micron)", curses.A_REVERSE)
        screen.addstr( 1+2, 0, "#01:%6.3lf "%tscv.Eigen_Data_q01.val(),curses.A_NORMAL)
        screen.addstr( 2+2, 0, "#02:%6.3lf "%tscv.Eigen_Data_q02.val(),curses.A_NORMAL)
        screen.addstr( 3+2, 0, "#03:%6.3lf "%tscv.Eigen_Data_q03.val(),curses.A_NORMAL)
        screen.addstr( 4+2, 0, "#04:%6.3lf "%tscv.Eigen_Data_q04.val(),curses.A_NORMAL)
        screen.addstr( 5+2, 0, "#05:%6.3lf "%tscv.Eigen_Data_q05.val(),curses.A_NORMAL)
        screen.addstr( 6+2, 0, "#06:%6.3lf "%tscv.Eigen_Data_q06.val(),curses.A_NORMAL)
        screen.addstr( 7+2, 0, "#07:%6.3lf "%tscv.Eigen_Data_q07.val(),curses.A_NORMAL)
        screen.addstr( 8+2, 0, "#08:%6.3lf "%tscv.Eigen_Data_q08.val(),curses.A_NORMAL)
        screen.addstr( 9+2, 0, "#09:%6.3lf "%tscv.Eigen_Data_q09.val(),curses.A_NORMAL)
        screen.addstr(10+2, 0, "#10:%6.3lf "%tscv.Eigen_Data_q10.val(),curses.A_NORMAL)
        screen.addstr(11+2, 0, "#11:%6.3lf "%tscv.Eigen_Data_q11.val(),curses.A_NORMAL)
        screen.addstr(12+2, 0, "#12:%6.3lf "%tscv.Eigen_Data_q12.val(),curses.A_NORMAL)
        screen.addstr(13+2, 0, "#13:%6.3lf "%tscv.Eigen_Data_q13.val(),curses.A_NORMAL)
        screen.addstr(14+2, 0, "#14:%6.3lf "%tscv.Eigen_Data_q14.val(),curses.A_NORMAL)
        screen.addstr(15+2, 0, "#15:%6.3lf "%tscv.Eigen_Data_q15.val(),curses.A_NORMAL)
        screen.addstr(16+2, 0, "#16:%6.3lf "%tscv.Eigen_Data_q16.val(),curses.A_NORMAL)
        screen.addstr(17+2, 0, "#17:%6.3lf "%tscv.Eigen_Data_q17.val(),curses.A_NORMAL)
        screen.addstr(18+2, 0, "#18:%6.3lf "%tscv.Eigen_Data_q18.val(),curses.A_NORMAL)
        screen.addstr(19+2, 0, "#19:%6.3lf "%tscv.Eigen_Data_q19.val(),curses.A_NORMAL)
        screen.addstr( 0+2,20, "#20:%6.3lf "%tscv.Eigen_Data_q20.val(),curses.A_NORMAL)
        screen.addstr( 1+2,20, "#21:%6.3lf "%tscv.Eigen_Data_q21.val(),curses.A_NORMAL)
        screen.addstr( 2+2,20, "#22:%6.3lf "%tscv.Eigen_Data_q22.val(),curses.A_NORMAL)
        screen.addstr( 3+2,20, "#23:%6.3lf "%tscv.Eigen_Data_q23.val(),curses.A_NORMAL)
        screen.addstr( 4+2,20, "#24:%6.3lf "%tscv.Eigen_Data_q24.val(),curses.A_NORMAL)
        screen.addstr( 5+2,20, "#25:%6.3lf "%tscv.Eigen_Data_q25.val(),curses.A_NORMAL)
        screen.addstr( 6+2,20, "#26:%6.3lf "%tscv.Eigen_Data_q26.val(),curses.A_NORMAL)
        screen.addstr( 7+2,20, "#27:%6.3lf "%tscv.Eigen_Data_q27.val(),curses.A_NORMAL)
        screen.addstr( 8+2,20, "#28:%6.3lf "%tscv.Eigen_Data_q28.val(),curses.A_NORMAL)
        screen.addstr( 9+2,20, "#29:%6.3lf "%tscv.Eigen_Data_q29.val(),curses.A_NORMAL)
        screen.addstr(10+2,20, "#30:%6.3lf "%tscv.Eigen_Data_q30.val(),curses.A_NORMAL)
        screen.addstr(11+2,20, "#31:%6.3lf "%tscv.Eigen_Data_q31.val(),curses.A_NORMAL)
        screen.addstr(12+2,20, "#32:%6.3lf "%tscv.Eigen_Data_q32.val(),curses.A_NORMAL)

    if page==3 :


        #-- Please Do Not to change this page to 1 for Recalculation Preventing Algorith (Morino).
        if prev_mm!=tscv.time0040.mm() or  prev_ss!=tscv.time0040.ss() or prev_page!=page :

            if prev_page!=page :
                screen.move(2,0)
                screen.clrtobot() 
                screen.addstr( 12, 20, "...... Now Calculating ......", curses.A_NORMAL)
                screen.hline(1, 59, "-", 7)
                screen.addstr(1, 59 ,"(%ld/%ld)" %(page,maxpage),curses.A_NORMAL)
                screen.addstr( 0, 77, "", curses.A_STANDOUT)
                screen.refresh()
            prev_mm=tscv.time0040.mm()
            prev_ss=tscv.time0040.ss()
            screen.addstr(0+2,40, "data(UT):%04.0lf/%02.0lf/%02.0lf %02.0lf:%02.0lf:%04.1lf" %(tscv.time0040.year(),tscv.time0040.month(),tscv.time0040.day(),tscv.time0040.hh(),tscv.time0040.mm(),tscv.time0040.ss()),curses.A_NORMAL)
            prev_test+=1 #-- for debug

            y=-8.0
            while y<=8.0:
                x=-8.0
                ys=pow(y,2.0)
                while x<=8.0:
                    r=pow(x*x+ys,0.5)/8.0
                    theta=math.atan2(y,x)
                    r2=r*r; r3=r2*r; r4=r2*r2;r5=r2*r3;r6=r3*r3;r7=r4*r3;r8=r4*r4;r9=r4*r5;r10=r5*r5;
                    val=0.0; t_val=0.0;
                    if (r<=1.0) :
                        #--fact=1.0/sqrt(n+1) #-- for m!=0
                        #--fact=1.0/sqrt(2*(n+1)) #-- for m=0
                        # 2,3
                        fact=r/math.sqrt(2.0)
                        t_val+= math.cos(theta) * fact * tscv.MLP2_Zernike_Data_01_A11.val() 
                        t_val+= math.sin(theta) * fact * tscv.MLP2_Zernike_Data_02_A1m1.val()
                        # fact=1.0/sqrt(6.0) #-- for n=2 m=0 -- focus
                        # val+=(2.0 *pow(r,2.0) -1.0)   * fact * tscv.MLP2_Zernike_Data_03_A20.val() #--- focus
                        # 5,6
                        fact=r2/math.sqrt(3.0) #-- for n=2 m!=0
                        val+= math.cos(2.0*theta) * fact * tscv.MLP2_Zernike_Data_06_A22.val()
                        val+= math.sin(2.0*theta) * fact * tscv.MLP2_Zernike_Data_07_A2m2.val()
                        # 7,8
                        fact=(3.0*r2 -2.0) * r/2.0 #-- for n=3 m!=0
                        val+= math.cos(theta) * fact *tscv.MLP2_Zernike_Data_04_A31.val()
                        val+= math.sin(theta) * fact *tscv.MLP2_Zernike_Data_05_A3m1.val()
                        # 09
                        fact=(6.0*r4-r2+1.0)/math.sqrt(10.0) #-- for n=4 m=0
                        val+= fact *tscv.Zernike_Offset_Data_10_A40.val()
                        # 10,11
                        fact=r3/2.0 #-- for n=3 m!=0
                        val+=math.cos(3.0*theta) * fact *tscv.MLP2_Zernike_Data_08_A33.val()
                        val+=math.sin(3.0*theta) * fact *tscv.MLP2_Zernike_Data_09_A3m3.val()
                        # 12,13
                        fact=(4.0*r2-3.0)*r2/math.sqrt(7.0) #-- for n=3 m!=0
                        val+=math.cos(2.0*theta) * fact *tscv.MLP2_Zernike_Data_22_A62.val()
                        val+=math.sin(2.0*theta) * fact *tscv.MLP2_Zernike_Data_23_A6m2.val()
                        # 14,15
                        fact=(10.0*r4-12.0*r2+3.0)*r/math.sqrt(6.0) #-- for n=5 m!=0
                        val+=math.cos(theta) * fact * tscv.Zernike_Offset_Data_15_A51.val()
                        val+=math.sin(theta) * fact * tscv.Zernike_Offset_Data_16_A5m1.val()
                        # 16
                        fact=(20.0*r6-30.0*r4 + 12.0*r2-1.0)/math.sqrt(14.0) #-- for n=6 m=0
                        val+=fact *tscv.Zernike_Offset_Data_21_A60.val()
                        # 17,18
                        fact=r4/math.sqrt(5.0) #-- for n=4 m!=0
                        val+=math.cos(4.0*theta) * fact * tscv.Zernike_Offset_Data_13_A44.val()
                        val+=math.sin(4.0*theta) * fact * tscv.Zernike_Offset_Data_14_A4m4.val()
                        # 19,20
                        fact=(5.0*r2-4.0)*r3/math.sqrt(6.0) #-- for n=5 m!=0
                        val+=math.cos(3.0*theta) * fact * tscv.Zernike_Offset_Data_17_A53.val()
                        val+=math.sin(3.0*theta) * fact * tscv.Zernike_Offset_Data_18_A5m3.val()
                        #  21,22
                        fact=(15*r4-20.0*r2+6)*r2/math.sqrt(7.0) # -- for n=6 m!=0
                        val+=math.cos(2.0*theta) * fact * tscv.Zernike_Offset_Data_22_A62.val()
                        val+=math.sin(2.0*theta) * fact * tscv.Zernike_Offset_Data_23_A6m2.val()
                        # 23,24
                        fact=(35.0*r6-60.0*r4+30.0*r2-4.0)*r /math.sqrt(8.0) # -- for n=7 m!=0
                        val+=math.cos(theta) * fact * tscv.Zernike_Offset_Data_28_A71.val()
                        val+=math.sin(theta) * fact * tscv.Zernike_Offset_Data_29_A7m1.val()
                        # 25
                        fact=(70.0*r8-140.0*r6+90.0*r4-20.0*r2+1.0)/math.sqrt(2.0)/3.0 # -- for n=8 m=0
                        val+=fact *tscv.Zernike_Offset_Data_36_A80.val()
                        # 26,27
                        fact=r5 /math.sqrt(6.0) # -- for n=5 m!=0
                        val+=math.cos(5.0*theta) * fact * tscv.Zernike_Offset_Data_19_A55.val()
                        val+=math.sin(5.0*theta) * fact * tscv.Zernike_Offset_Data_20_A5m5.val()
                        # 28,29
                        fact=(6.0*r2-5.0)*r4 /math.sqrt(7.0) # -- for n=6 m!=0
                        val+=math.cos(4.0*theta) * fact * tscv.Zernike_Offset_Data_24_A64.val()
                        val+=math.sin(4.0*theta) * fact * tscv.Zernike_Offset_Data_25_A6m4.val()
                        # 30,31
                        fact=(21.0*r4-30.0*r2+10.0)*r3 /math.sqrt(8.0) # -- for n=7 m!=0
                        val+=math.cos(3.0*theta) * fact * tscv.Zernike_Offset_Data_30_A73.val()
                        val+=math.sin(3.0*theta) * fact * tscv.Zernike_Offset_Data_31_A7m3.val()
                        # 32,33
                        fact=(56.0*r6-105.0*r4+60.0*r2-10.0)*r2 /3.0 # -- for n=8 m!=0
                        val+=math.cos(2.0*theta) * fact * tscv.Zernike_Offset_Data_37_A82.val()
                        val+=math.sin(2.0*theta) * fact * tscv.Zernike_Offset_Data_38_A8m2.val() # --- miss type
                        # 34,35
                        fact=(126.0*r8-280.0*r6+210.0*r4-60.0*r2+5.0)*r / math.sqrt(10.0) # -- for n=9 m!=0
                        val+=math.cos(theta) * fact * tscv.Zernike_Offset_Data_45_A91.val()
                        val+=math.sin(theta) * fact * tscv.Zernike_Offset_Data_46_A9m1.val()
                        # 36
                        fact=(252.0*r10-630.0*r8+560*r6-210.0*r4+30.0+r2-1.0)/math.sqrt(22.0) # --for n=10,m=0
                        val+=fact *tscv.Zernike_Offset_Data_55_A100.val()


                        fact=(-3.0*r2 + 4.0*r4) / math.sqrt(5.0)
                        val+= math.cos(2.0*theta)*fact *tscv.MLP2_Zernike_Data_11_A42.val()
                        val+= math.cos(2.0*theta)*fact *tscv.MLP2_Zernike_Data_12_A4m2.val()
                        
                        fact=r6 / math.sqrt(7.0)
                        val+= math.cos(6.0*theta) * fact *tscv.MLP2_Zernike_Data_26_A66.val()
                        val+= math.sin(6.0*theta) * fact *tscv.MLP2_Zernike_Data_27_A6m6.val()
                        
                        fact=(-6.0*r5 + 7.0*r7) / math.sqrt(8.0)
                        val+= math.cos(5.0*theta) * fact *tscv.MLP2_Zernike_Data_32_A75.val()
                        val+= math.sin(5.0*theta) * fact *tscv.MLP2_Zernike_Data_33_A7m5.val()
                        
                        fact=r7 / math.sqrt(8.0)
                        val+= math.cos(7.0*theta) *fact *tscv.MLP2_Zernike_Data_34_A77.val()
                        val+= math.sin(7.0*theta) *fact *tscv.MLP2_Zernike_Data_35_A7m7.val()
                        
                        fact=(15.0*r4 - 42.0*r6 + 28.0*r8) / 3.0
                        val+= math.cos(4.0*theta) * fact *tscv.MLP2_Zernike_Data_39_A84.val()
                        val+= math.sin(4.0*theta) * fact *tscv.MLP2_Zernike_Data_40_A8m4.val()
                        
                        fact=(-7.0*r6 + 8.0*r8) / 3.0
                        val+= math.cos(6.0*theta) * fact *tscv.MLP2_Zernike_Data_41_A86.val()
                        val+= math.sin(6.0*theta) * fact *tscv.MLP2_Zernike_Data_42_A8m6.val()
                        
                        fact=r8 / 3.0
                        val+= math.cos(8.0*theta) * fact *tscv.MLP2_Zernike_Data_43_A88.val()
                        val+= math.sin(8.0*theta) * fact *tscv.MLP2_Zernike_Data_44_A8m8.val()
                        
                        (-20.0*r3 + 105.0*r5 - 168.0*r7 + 84.0*r9) / math.sqrt(10.0)
                        val+= math.cos(3.0*theta) * fact *tscv.MLP2_Zernike_Data_47_A93.val()
                        val+= math.sin(3.0*theta) * fact *tscv.MLP2_Zernike_Data_48_A9m3.val()
                        
                        fact=(21.0*r5 - 56.0*r7 + 36.0*r9) / math.sqrt(10.0)
                        val+= math.cos(5.0*theta) *fact *tscv.MLP2_Zernike_Data_49_A95.val()
                        val+= math.sin(5.0*theta) *fact *tscv.MLP2_Zernike_Data_50_A9m5.val()
                        
                        fact=(-8.0*r7 + 9.0*r9) / math.sqrt(10.0)
                        val+= math.cos(7.0*theta) * fact *tscv.MLP2_Zernike_Data_51_A97.val()
                        val+= math.sin(7.0*theta) * fact *tscv.MLP2_Zernike_Data_52_A9m7.val()
                        
                        fact=r9 / math.sqrt(10.0) 
                        val+= math.cos(9.0*theta) * fact *tscv.MLP2_Zernike_Data_53_A99.val()
                        val+= math.sin(9.0*theta) * fact *tscv.MLP2_Zernike_Data_54_A9m9.val()
                        
                        fact=(15.0*r2 - 140.0*r4 + 420.0*r6 - 504.0*r8 + 210.0*r10) / math.sqrt(11.0)
                        val+= math.cos(2.0*theta) * fact *tscv.MLP2_Zernike_Data_56_A102.val()
                        val+= math.sin(2.0*theta) * fact *tscv.MLP2_Zernike_Data_57_A10m2.val() # -- miss type
                        
                        fact=(-35.0*r4 + 168.0*r6 - 252.0*r8 + 120.0*r10) / math.sqrt(11.0)
                        val+= math.cos(4.0*theta) * fact *tscv.MLP2_Zernike_Data_58_A104.val()
                        val+= math.sin(4.0*theta) * fact *tscv.MLP2_Zernike_Data_59_A10m4.val()
                        
                        fact=(28.0*r6 - 72.0*r8 + 45.0*r10) / math.sqrt(11.0) 
                        val+= math.cos(6.0*theta) * fact *tscv.MLP2_Zernike_Data_60_A106.val()
                        val+= math.sin(6.0*theta) * fact *tscv.MLP2_Zernike_Data_61_A10m6.val()
                        
                        fact=(-9.0*r8 + 10.0*r10) / math.sqrt(11.0)
                        val+= math.cos(8.0*theta) * fact *tscv.MLP2_Zernike_Data_62_A108.val()
                        val+= math.sin(8.0*theta) * fact *tscv.MLP2_Zernike_Data_63_A10m8.val()
                        
                        fact=r10 / math.sqrt(11.0)
                        val+= math.cos(10.0*theta) * fact *tscv.MLP2_Zernike_Data_64_A1010.val()
                        val+= math.cos(10.0*theta) * fact *tscv.MLP2_Zernike_Data_65_A10m10.val()
                        
                        at=curses.A_NORMAL
                        ch="%2.0lf"%(val*10.0)
                        if val<0.0: at=curses.A_BOLD
                        if string.atoi(ch)>=10:
                            # at |=curses.A_REVERSE
                            ch=" +"
                        elif string.atoi(ch)<=-10:
                            # at |=curses.A_REVERSE
                            ch=" -"
                        screen.addstr( (int)((-y+8.0))+4, (int)(2*(x+8.0)+2),ch, at)

                        at=curses.A_NORMAL
                        ch="%2.0lf"%(val*20.0)
                        if val<0.0: at=curses.A_BOLD
                        if string.atoi(ch)>=10:
                            # at |=curses.A_REVERSE
                            ch=" +"
                        elif string.atoi(ch)<=-10:
                            # at |=curses.A_REVERSE
                            ch=" -"
                        screen.addstr( (int)((-y+8.0))+4, (int)(2*(x+8.0)+36),ch, at)
                    x+=1.0
                y+=1.0
            curses.beep()
        screen.addstr( 2, 0, "SH Exp %3s"%('Off','On ')[tscv.SH_Exposure_On], (curses.A_NORMAL,curses.A_REVERSE)[tscv.SH_Exposure_On])
        screen.addstr( 2, 8*2+2-7, "Without A20,A11,A1-1", curses.A_REVERSE)
#        screen.addstr( 2, 8*2+36-3, "[wide range]", curses.A_NORMAL)
        screen.addstr( 3, 8*2-5, "(w/o focus,tilt)", curses.A_NORMAL)
        screen.addstr( 21, 8*2+2+10, "[x0.1 micron]", curses.A_NORMAL)
        screen.addstr( 21, 8*2+36+10, "[x0.05 micron]", curses.A_NORMAL)
        screen.addstr( 2, 74, "%4d" %prev_test, curses.A_NORMAL) # -- for debug
        screen.addstr( 23,25, "RMS without A20 (and A11,A1-1??): %.3g [micron]" %tscv.Zernike_Data_RMS_without_A20.val(), curses.A_NORMAL)
        screen.addstr( 1+2,59, "EL of Calc.:%6.2lf" % tscv.EL_Angle_Zernike_Calculate.val(), curses.A_NORMAL)
        screen.addstr( 2+2,65, "real :%6.2lf" % tscs.EL_Real_Angle.val(), curses.A_NORMAL)
        if tscv.TSC_Focus_PIR_Selected==1 or tscv.TSC_Focus_POpt_Selected==1:
            screen.addstr( 3+2,64, "P rot :%+4.0lf d" % tscs.P_Rotator_Real_Angle.val(), curses.A_NORMAL)

    if page==6:
        screen.addstr( 2,  0, "Actuator_Force_Of_Eigen_Data ?? # 0-" , curses.A_REVERSE)
        screen.addstr(  0+3,  0, "000:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_000.val() , curses.A_NORMAL)
        screen.addstr(  1+3,  0, "001:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_001.val() , curses.A_NORMAL)
        screen.addstr(  2+3,  0, "002:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_002.val() , curses.A_NORMAL)
        screen.addstr(  3+3,  0, "003:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_003.val() , curses.A_NORMAL)
        screen.addstr(  4+3,  0, "004:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_004.val() , curses.A_NORMAL)
        screen.addstr(  5+3,  0, "005:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_005.val() , curses.A_NORMAL)
        screen.addstr(  6+3,  0, "006:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_006.val() , curses.A_NORMAL)
        screen.addstr(  7+3,  0, "007:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_007.val() , curses.A_NORMAL)
        screen.addstr(  8+3,  0, "008:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_008.val() , curses.A_NORMAL)
        screen.addstr(  9+3,  0, "009:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_009.val() , curses.A_NORMAL)
        screen.addstr( 10+3,  0, "010:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_010.val() , curses.A_NORMAL)
        screen.addstr( 11+3,  0, "011:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_011.val() , curses.A_NORMAL)
        screen.addstr( 12+3,  0, "012:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_012.val() , curses.A_NORMAL)
        screen.addstr( 13+3,  0, "013:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_013.val() , curses.A_NORMAL)
        screen.addstr( 14+3,  0, "014:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_014.val() , curses.A_NORMAL)
        screen.addstr( 15+3,  0, "015:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_015.val() , curses.A_NORMAL)
        screen.addstr( 16+3,  0, "016:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_016.val() , curses.A_NORMAL)
        screen.addstr( 17+3,  0, "017:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_017.val() , curses.A_NORMAL)
        screen.addstr( 18+3,  0, "018:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_018.val() , curses.A_NORMAL)
        screen.addstr( 19+3,  0, "019:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_019.val() , curses.A_NORMAL)

        screen.addstr( 20+3-20, 11, "020:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_020.val() , curses.A_NORMAL)
        screen.addstr( 21+3-20, 11, "021:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_021.val() , curses.A_NORMAL)
        screen.addstr( 22+3-20, 11, "022:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_022.val() , curses.A_NORMAL)
        screen.addstr( 23+3-20, 11, "023:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_023.val() , curses.A_NORMAL)
        screen.addstr( 24+3-20, 11, "024:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_024.val() , curses.A_NORMAL)
        screen.addstr( 25+3-20, 11, "025:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_025.val() , curses.A_NORMAL)
        screen.addstr( 26+3-20, 11, "026:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_026.val() , curses.A_NORMAL)
        screen.addstr( 27+3-20, 11, "027:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_027.val() , curses.A_NORMAL)
        screen.addstr( 28+3-20, 11, "028:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_028.val() , curses.A_NORMAL)
        screen.addstr( 29+3-20, 11, "029:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_029.val() , curses.A_NORMAL)
        screen.addstr( 30+3-20, 11, "030:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_030.val() , curses.A_NORMAL)
        screen.addstr( 31+3-20, 11, "031:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_031.val() , curses.A_NORMAL)
        screen.addstr( 32+3-20, 11, "032:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_032.val() , curses.A_NORMAL)
        screen.addstr( 33+3-20, 11, "033:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_033.val() , curses.A_NORMAL)
        screen.addstr( 34+3-20, 11, "034:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_034.val() , curses.A_NORMAL)
        screen.addstr( 35+3-20, 11, "035:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_035.val() , curses.A_NORMAL)
        screen.addstr( 36+3-20, 11, "036:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_036.val() , curses.A_NORMAL)
        screen.addstr( 37+3-20, 11, "037:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_037.val() , curses.A_NORMAL)
        screen.addstr( 38+3-20, 11, "038:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_038.val() , curses.A_NORMAL)
        screen.addstr( 39+3-20, 11, "039:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_039.val() , curses.A_NORMAL)

        screen.addstr( 40+3-40, 22, "040:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_040.val() , curses.A_NORMAL)
        screen.addstr( 41+3-40, 22, "041:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_041.val() , curses.A_NORMAL)
        screen.addstr( 42+3-40, 22, "042:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_042.val() , curses.A_NORMAL)
        screen.addstr( 43+3-40, 22, "043:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_043.val() , curses.A_NORMAL)
        screen.addstr( 44+3-40, 22, "044:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_044.val() , curses.A_NORMAL)
        screen.addstr( 45+3-40, 22, "045:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_045.val() , curses.A_NORMAL)
        screen.addstr( 46+3-40, 22, "046:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_046.val() , curses.A_NORMAL)
        screen.addstr( 47+3-40, 22, "047:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_047.val() , curses.A_NORMAL)
        screen.addstr( 48+3-40, 22, "048:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_048.val() , curses.A_NORMAL)
        screen.addstr( 49+3-40, 22, "049:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_049.val() , curses.A_NORMAL)
        screen.addstr( 50+3-40, 22, "050:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_050.val() , curses.A_NORMAL)
        screen.addstr( 51+3-40, 22, "051:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_051.val() , curses.A_NORMAL)
        screen.addstr( 52+3-40, 22, "052:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_052.val() , curses.A_NORMAL)
        screen.addstr( 53+3-40, 22, "053:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_053.val() , curses.A_NORMAL)
        screen.addstr( 54+3-40, 22, "054:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_054.val() , curses.A_NORMAL)
        screen.addstr( 55+3-40, 22, "055:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_055.val() , curses.A_NORMAL)
        screen.addstr( 56+3-40, 22, "056:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_056.val() , curses.A_NORMAL)
        screen.addstr( 57+3-40, 22, "057:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_057.val() , curses.A_NORMAL)
        screen.addstr( 58+3-40, 22, "058:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_058.val() , curses.A_NORMAL)
        screen.addstr( 59+3-40, 22, "059:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_059.val() , curses.A_NORMAL)

        screen.addstr( 60+3-60, 33, "060:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_060.val() , curses.A_NORMAL)
        screen.addstr( 61+3-60, 33, "061:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_061.val() , curses.A_NORMAL)
        screen.addstr( 62+3-60, 33, "062:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_062.val() , curses.A_NORMAL)
        screen.addstr( 63+3-60, 33, "063:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_063.val() , curses.A_NORMAL)
        screen.addstr( 64+3-60, 33, "064:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_064.val() , curses.A_NORMAL)
        screen.addstr( 65+3-60, 33, "065:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_065.val() , curses.A_NORMAL)
        screen.addstr( 66+3-60, 33, "066:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_066.val() , curses.A_NORMAL)
        screen.addstr( 67+3-60, 33, "067:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_067.val() , curses.A_NORMAL)
        screen.addstr( 68+3-60, 33, "068:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_068.val() , curses.A_NORMAL)
        screen.addstr( 69+3-60, 33, "069:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_069.val() , curses.A_NORMAL)
        screen.addstr( 70+3-60, 33, "070:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_070.val() , curses.A_NORMAL)
        screen.addstr( 71+3-60, 33, "071:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_071.val() , curses.A_NORMAL)
        screen.addstr( 72+3-60, 33, "072:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_072.val() , curses.A_NORMAL)
        screen.addstr( 73+3-60, 33, "073:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_073.val() , curses.A_NORMAL)
        screen.addstr( 74+3-60, 33, "074:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_074.val() , curses.A_NORMAL)
        screen.addstr( 75+3-60, 33, "075:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_075.val() , curses.A_NORMAL)
        screen.addstr( 76+3-60, 33, "076:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_076.val() , curses.A_NORMAL)
        screen.addstr( 77+3-60, 33, "077:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_077.val() , curses.A_NORMAL)
        screen.addstr( 78+3-60, 33, "078:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_078.val() , curses.A_NORMAL)
        screen.addstr( 79+3-60, 33, "079:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_079.val() , curses.A_NORMAL)

        screen.addstr( 80+3-80, 44, "080:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_080.val() , curses.A_NORMAL)
        screen.addstr( 81+3-80, 44, "081:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_081.val() , curses.A_NORMAL)
        screen.addstr( 82+3-80, 44, "082:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_082.val() , curses.A_NORMAL)
        screen.addstr( 83+3-80, 44, "083:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_083.val() , curses.A_NORMAL)
        screen.addstr( 84+3-80, 44, "084:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_084.val() , curses.A_NORMAL)
        screen.addstr( 85+3-80, 44, "085:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_085.val() , curses.A_NORMAL)
        screen.addstr( 86+3-80, 44, "086:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_086.val() , curses.A_NORMAL)
        screen.addstr( 87+3-80, 44, "087:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_087.val() , curses.A_NORMAL)
        screen.addstr( 88+3-80, 44, "088:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_088.val() , curses.A_NORMAL)
        screen.addstr( 89+3-80, 44, "089:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_089.val() , curses.A_NORMAL)
        screen.addstr( 90+3-80, 44, "090:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_090.val() , curses.A_NORMAL)
        screen.addstr( 91+3-80, 44, "091:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_091.val() , curses.A_NORMAL)
        screen.addstr( 92+3-80, 44, "092:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_092.val() , curses.A_NORMAL)
        screen.addstr( 93+3-80, 44, "093:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_093.val() , curses.A_NORMAL)
        screen.addstr( 94+3-80, 44, "094:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_094.val() , curses.A_NORMAL)
        screen.addstr( 95+3-80, 44, "095:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_095.val() , curses.A_NORMAL)
        screen.addstr( 96+3-80, 44, "096:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_096.val() , curses.A_NORMAL)
        screen.addstr( 97+3-80, 44, "097:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_097.val() , curses.A_NORMAL)
        screen.addstr( 98+3-80, 44, "098:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_098.val() , curses.A_NORMAL)
        screen.addstr( 99+3-80, 44, "099:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_099.val() , curses.A_NORMAL)

        screen.addstr(  0+3, 55, "100:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_100.val() , curses.A_NORMAL)
        screen.addstr(  1+3, 55, "101:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_101.val() , curses.A_NORMAL)
        screen.addstr(  2+3, 55, "102:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_102.val() , curses.A_NORMAL)
        screen.addstr(  3+3, 55, "103:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_103.val() , curses.A_NORMAL)
        screen.addstr(  4+3, 55, "104:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_104.val() , curses.A_NORMAL)
        screen.addstr(  5+3, 55, "105:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_105.val() , curses.A_NORMAL)
        screen.addstr(  6+3, 55, "106:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_106.val() , curses.A_NORMAL)
        screen.addstr(  7+3, 55, "107:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_107.val() , curses.A_NORMAL)
        screen.addstr(  8+3, 55, "108:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_108.val() , curses.A_NORMAL)
        screen.addstr(  9+3, 55, "109:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_109.val() , curses.A_NORMAL)
        screen.addstr( 10+3, 55, "110:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_110.val() , curses.A_NORMAL)
        screen.addstr( 11+3, 55, "111:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_111.val() , curses.A_NORMAL)
        screen.addstr( 12+3, 55, "112:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_112.val() , curses.A_NORMAL)
        screen.addstr( 13+3, 55, "113:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_113.val() , curses.A_NORMAL)
        screen.addstr( 14+3, 55, "114:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_114.val() , curses.A_NORMAL)
        screen.addstr( 15+3, 55, "115:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_115.val() , curses.A_NORMAL)
        screen.addstr( 16+3, 55, "116:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_116.val() , curses.A_NORMAL)
        screen.addstr( 17+3, 55, "117:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_117.val() , curses.A_NORMAL)
        screen.addstr( 18+3, 55, "118:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_118.val() , curses.A_NORMAL)
        screen.addstr( 19+3, 55, "119:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_119.val() , curses.A_NORMAL)

        screen.addstr( 20+3-20, 66, "120:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_120.val() , curses.A_NORMAL)
        screen.addstr( 21+3-20, 66, "121:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_121.val() , curses.A_NORMAL)
        screen.addstr( 22+3-20, 66, "122:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_122.val() , curses.A_NORMAL)
        screen.addstr( 23+3-20, 66, "123:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_123.val() , curses.A_NORMAL)
        screen.addstr( 24+3-20, 66, "124:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_124.val() , curses.A_NORMAL)
        screen.addstr( 25+3-20, 66, "125:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_125.val() , curses.A_NORMAL)
        screen.addstr( 26+3-20, 66, "126:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_126.val() , curses.A_NORMAL)
        screen.addstr( 27+3-20, 66, "127:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_127.val() , curses.A_NORMAL)
        screen.addstr( 28+3-20, 66, "128:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_128.val() , curses.A_NORMAL)
        screen.addstr( 29+3-20, 66, "129:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_129.val() , curses.A_NORMAL)
        screen.addstr( 30+3-20, 66, "130:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_130.val() , curses.A_NORMAL)
        screen.addstr( 31+3-20, 66, "131:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_131.val() , curses.A_NORMAL)
        screen.addstr( 32+3-20, 66, "132:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_132.val() , curses.A_NORMAL)
        screen.addstr( 33+3-20, 66, "133:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_133.val() , curses.A_NORMAL)
        screen.addstr( 34+3-20, 66, "134:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_134.val() , curses.A_NORMAL)
        screen.addstr( 35+3-20, 66, "135:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_135.val() , curses.A_NORMAL)
        screen.addstr( 36+3-20, 66, "136:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_136.val() , curses.A_NORMAL)
        screen.addstr( 37+3-20, 66, "137:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_137.val() , curses.A_NORMAL)
        screen.addstr( 38+3-20, 66, "138:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_138.val() , curses.A_NORMAL)
        screen.addstr( 39+3-20, 66, "139:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_139.val() , curses.A_NORMAL)
    if page==7:
        screen.addstr( 2,  0, "Actuator_Force_Of_Eigen_Data ?? # 140-" , curses.A_REVERSE)


        screen.addstr( 40+3-40,  0, "140:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_140.val() , curses.A_NORMAL)
        screen.addstr( 41+3-40,  0, "141:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_141.val() , curses.A_NORMAL)
        screen.addstr( 42+3-40,  0, "142:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_142.val() , curses.A_NORMAL)
        screen.addstr( 43+3-40,  0, "143:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_143.val() , curses.A_NORMAL)
        screen.addstr( 44+3-40,  0, "144:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_144.val() , curses.A_NORMAL)
        screen.addstr( 45+3-40,  0, "145:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_145.val() , curses.A_NORMAL)
        screen.addstr( 46+3-40,  0, "146:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_146.val() , curses.A_NORMAL)
        screen.addstr( 47+3-40,  0, "147:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_147.val() , curses.A_NORMAL)
        screen.addstr( 48+3-40,  0, "148:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_148.val() , curses.A_NORMAL)
        screen.addstr( 49+3-40,  0, "149:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_149.val() , curses.A_NORMAL)
        screen.addstr( 50+3-40,  0, "150:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_150.val() , curses.A_NORMAL)
        screen.addstr( 51+3-40,  0, "151:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_151.val() , curses.A_NORMAL)
        screen.addstr( 52+3-40,  0, "152:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_152.val() , curses.A_NORMAL)
        screen.addstr( 53+3-40,  0, "153:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_153.val() , curses.A_NORMAL)
        screen.addstr( 54+3-40,  0, "154:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_154.val() , curses.A_NORMAL)
        screen.addstr( 55+3-40,  0, "155:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_155.val() , curses.A_NORMAL)
        screen.addstr( 56+3-40,  0, "156:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_156.val() , curses.A_NORMAL)
        screen.addstr( 57+3-40,  0, "157:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_157.val() , curses.A_NORMAL)
        screen.addstr( 58+3-40,  0, "158:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_158.val() , curses.A_NORMAL)
        screen.addstr( 59+3-40,  0, "159:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_159.val() , curses.A_NORMAL)


        screen.addstr( 60+3-60, 11, "160:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_160.val() , curses.A_NORMAL)
        screen.addstr( 61+3-60, 11, "161:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_161.val() , curses.A_NORMAL)
        screen.addstr( 62+3-60, 11, "162:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_162.val() , curses.A_NORMAL)
        screen.addstr( 63+3-60, 11, "163:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_163.val() , curses.A_NORMAL)
        screen.addstr( 64+3-60, 11, "164:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_164.val() , curses.A_NORMAL)
        screen.addstr( 65+3-60, 11, "165:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_165.val() , curses.A_NORMAL)
        screen.addstr( 66+3-60, 11, "166:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_166.val() , curses.A_NORMAL)
        screen.addstr( 67+3-60, 11, "167:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_167.val() , curses.A_NORMAL)
        screen.addstr( 68+3-60, 11, "168:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_168.val() , curses.A_NORMAL)
        screen.addstr( 69+3-60, 11, "169:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_169.val() , curses.A_NORMAL)
        screen.addstr( 70+3-60, 11, "170:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_170.val() , curses.A_NORMAL)
        screen.addstr( 71+3-60, 11, "171:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_171.val() , curses.A_NORMAL)
        screen.addstr( 72+3-60, 11, "172:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_172.val() , curses.A_NORMAL)
        screen.addstr( 73+3-60, 11, "173:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_173.val() , curses.A_NORMAL)
        screen.addstr( 74+3-60, 11, "174:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_174.val() , curses.A_NORMAL)
        screen.addstr( 75+3-60, 11, "175:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_175.val() , curses.A_NORMAL)
        screen.addstr( 76+3-60, 11, "176:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_176.val() , curses.A_NORMAL)
        screen.addstr( 77+3-60, 11, "177:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_177.val() , curses.A_NORMAL)
        screen.addstr( 78+3-60, 11, "178:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_178.val() , curses.A_NORMAL)
        screen.addstr( 79+3-60, 11, "179:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_179.val() , curses.A_NORMAL)

        screen.addstr( 80+3-80, 22, "180:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_180.val() , curses.A_NORMAL)
        screen.addstr( 81+3-80, 22, "181:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_181.val() , curses.A_NORMAL)
        screen.addstr( 82+3-80, 22, "182:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_182.val() , curses.A_NORMAL)
        screen.addstr( 83+3-80, 22, "183:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_183.val() , curses.A_NORMAL)
        screen.addstr( 84+3-80, 22, "184:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_184.val() , curses.A_NORMAL)
        screen.addstr( 85+3-80, 22, "185:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_185.val() , curses.A_NORMAL)
        screen.addstr( 86+3-80, 22, "186:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_186.val() , curses.A_NORMAL)
        screen.addstr( 87+3-80, 22, "187:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_187.val() , curses.A_NORMAL)
        screen.addstr( 88+3-80, 22, "188:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_188.val() , curses.A_NORMAL)
        screen.addstr( 89+3-80, 22, "189:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_189.val() , curses.A_NORMAL)
        screen.addstr( 90+3-80, 22, "190:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_190.val() , curses.A_NORMAL)
        screen.addstr( 91+3-80, 22, "191:%5.2lf " %tscv.Actuator_Force_Of_Eigen_Data_191.val() , curses.A_NORMAL)

   
    screen.hline(1, 59, "-", 7)
    screen.addstr(1, 59 ,"(%ld/%ld)" %(page,maxpage),curses.A_NORMAL)
    screen.addstr( 0, 77, "", curses.A_STANDOUT)
    screen.refresh()

    # -- to save CPU power for calc zernike
    prev_page=page
