#!/usr/local/bin/python

import sys
import string
import urllib


############################### C O N S T A N T S ###############################
DEBUG = False
SUBWXURL = 'http://133.40.174.41/CATWALK/index.html'

answer = ["BAD", "BAD", "BAD", "BAD", "BAD"] 

def stripChar(inStr) :

    if inStr.find(">") <> -1:
        inStr = inStr[0:len(inStr)-1]
    if inStr.find("b") <> -1:
        inStr = inStr[0:len(inStr)-1]
    if inStr.find("/") <> -1 :
        inStr = inStr[0:len(inStr)-1]
    if inStr.find("<") <> -1 :
        inStr = inStr[0:len(inStr)-1]
            
    return inStr



# Function to check if Subaru Weather webpage is operating correctly and returns catwalk temp.
#     and humidities
# Input: None
# Returns: vector containing [Temp, NW-RH, NE-RH, SW-RH, SE-RH]
def getWx() :
    
    try:
        urlResp = urllib.urlopen(SUBWXURL)     
    except IOError, e:
        ### setCheck("Subaru Catwalk WX  ", 1, 0, "NoURL", "NoURL", errNoTime)
        if DEBUG == False :
            print "getSubaruWX: Unable to connect to Subaru Catwalk Wx. web page.",e
        return answer
    else:

        headers = urlResp.info()
        
        data = urlResp.read()

        if DEBUG :
            print 'getSubaruWx'
            print 'URL     :', urlResp.geturl()
            print 'DATE    :', headers['date']
            print 'HEADERS :'
            print '---------'
            print headers
            print 'LENGTH  :', len(data)
            print 'DATA    :'
            print '---------'
            print data


        idx = data.find("Catwalk Temperature")
        catTemp = stripChar(data[idx+26:idx+35])
        if DEBUG :
            print "CatTmpIdx = ", idx, " CtWkTmp = ", catTemp
        
        idx = data.find("NW</b> Humidity")
        NWHumid = stripChar(data[idx+19:idx+23])
        if NWHumid.find("-") <> -1 :
            NWHumid = "N/A"
        if DEBUG : 
            print "NW HumIdx = ", idx, " NWHumid =", NWHumid
                
        idx = data.find("NE</b> Humidity")
        NEHumid = stripChar(data[idx+19:idx+23])
        ### REMOVE this line and the next line!!!  Temporary fix due to malfunctioning NE Humidity sensor.
        NEHumid = "-10.0"
        if NEHumid.find("-") <> -1 :
            NEHumid = "N/A"
        if DEBUG : 
            print "NE HumIdx = ", idx, " NEHumid =", NEHumid

        idx = data.find("SW</b> Humidity")
        SWHumid = stripChar(data[idx+19:idx+23])
        if SWHumid.find("-") <> -1 :
            SWHumid = "N/A"
        if DEBUG :
            print "SW HumIdx = ", idx, " SWHumid =", SWHumid

        idx = data.find("SE</b> Humidity")
        SEHumid = stripChar(data[idx+19:idx+23])
        if SEHumid.find("-") <> -1 :
            SEHumid = "N/A"
        if DEBUG :
            print "SE HumIdx = ", idx, " SEHumid =", SEHumid

        answer = [catTemp,["CNW", NWHumid], ["CNE",NEHumid], ["CSW", SWHumid], ["CSE", SEHumid]]
        
    return answer

# end of catWalkWx #





 
