#!/usr/local/bin/python

import sys
import tel
import shm
import time
import commands
import string
import urllib
###import urllib2


# String variables and constants
locTime=""
ERR="ERROR - "
WRNG="WARNING -"
BELL="\a\a\a\a\a\a\a"
ALM_ON=[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]


def printUsage() :
    print
    print
    print "USAGE: ./TestSupCamSysChkr.py"
    print "or     ./TestSupCamSysChkr.py -[h|H]"
    print "or     ./SysChkr.py -[s|S] [DISABLE_STRING]"
    print
    print "OPTIONS"
    print "     -h or -H   prints this help and exits."
    print "     -s or -S   silence alarm(s) for items specified in the DISABLE_STRING."
    print
    print "DISABLE_STRING"
    print "     string of numbers corresponding to the number to the left of the alarm"
    print "     that is to be silenced.  More than one alarm can be silence by separating the"
    print "     numbers by commas."
    print
    print "     e.g. ./TestSupCamSysChkr.py -s  0,3,10"
    print
    print "     would result in item zero (EL Drive), third item (Dome Drive), seventh item"
    print "     (IRM2 Tip/Tilt) to have their respective alarms silenced."
    print

# Checking to see that this is the first instance of this Python script running.
#print commands.getoutput('ps -e | grep SysChkr | wc -l | cut -c 7-9' )
#numInst = commands.getoutput('ps -e | grep SysChkr | wc -l | cut -c 7-9')
#if numInst[0] != '1' :
#    print "TestSupCamSysChkr.py: Another SysChkr1py Python script is currently running."
#    print "TestSupCamSysChkr.py: Only one TestSupCamSysChkr.py is allowed to run at any given time."
#    print "TestSupCamSysChkr.py: Kill the currently running TestSupCamSysChkr.py script before starting again."
#    sys.exit(0)



def setAlmOff(idx) :
    
    global ALM_ON
    
    if idx > -1 and idx < len(ALM_ON) :
        ALM_ON[idx] = 0


        
    
# A function to parse -s/S (silence alarm) into tokens and then validate the
# tokens into valid index entries into the ALM_ON alarm list.
# Input:  inStr - input string containing indices into DISABLE_MODE string.
# Returns: 1 (check was successful)/
def parseSilStr(inStr) :

    strLen = len(inStr)
    aIStr = ""
    almIdx = -1

#    print inStr+" len = %d" %strLen
    idx = 0
    while idx < strLen :
        if inStr[idx].isdigit() == True :
#            print "inStr[%d] = %s is a digit" %(idx, inStr[idx])
            aIStr = aIStr + inStr[idx]
#            print "aIStr = " + aIStr
            almIdx = int(aIStr)
#            print "almIdx = %d" %almIdx
        elif inStr[idx] == "," :
#            print "inStr[%d] = %s is a comma" %(idx, inStr[idx])
            if len(aIStr) > 0 :
                almIdx = int(aIStr)
            aIStr = ""
#            print "almIdx = %d" %almIdx
            setAlmOff(almIdx)
            almIdx = -1
        else :
            print ERR+"invalid alphabetic character in alarm silence field."
            sys.exit(0)
        idx = idx + 1

    # Set the ALM_ON list for the last index which is not delimited by a comma.
    setAlmOff(almIdx)
    


# Checking for command line parameters.
if len(sys.argv) > 1 :
    if sys.argv[1] == "-h" or sys.argv[1] == "-H" :
        printUsage()
        sys.exit(0)
    elif sys.argv[1] == "-s" or sys.argv[1] == "-S" :
         if len(sys.argv) > 2 :
             DISABLE_STRING = sys.argv[2]
#             print "DISABLE_STRING = " + DISABLE_STRING
             parseSilStr(DISABLE_STRING)
         else :
             print ERR+"Missing silence alarm field"
             sys.exit(0)
    else :
        if sys.argv[1] == "-SCam" :
            SCamFlg = True
        else :
            print "TestSupCamSysChkr.py : Invalid option %s selected." %sys.argv[1]
            printUsage()
            sys.exit(0)

if "-SCam" in sys.argv :
    print "-SCam switch selected."


# Setting up shared memory for type short
ms = shm.memory(shm.getshmid(0x100));
tscs=tel.TSCShort();
ms.attach(); 


# Setting up shared memory for type long
ml = shm.memory(shm.getshmid(0x101));
tscl=tel.TSCLong();
ml.attach();


# Setting up shared memory for type vstat
mv = shm.memory(shm.getshmid(0x102));
tscv=tel.TSCVstat();
mv.attach(); 


# Initial read of shared memory from TSC
tscs.set(ms.read(1292))
tscl.set(ml.read(1292*7))
tscv.vset(mv.read(12931))


# Check if Vstat connection between TSC-TWS4 is working.
print "Checking Vstat TSC-TWS4 connection."
prev_ss = tscv.time0000.ss()
t_cnt = 0
ss = prev_ss
# 600 iterations * 0.2 sec = 120 second timeout period.
while (ss == prev_ss and t_cnt < 600) :
    tscv.vset(mv.read(12391))
    prev_ss = ss
    ss = tscv.time0000.ss()
    t_cnt = t_cnt + 1
    if (ss == prev_ss) :
        time.sleep(0.2)
if (ss == prev_ss) :
    print ERR+"Vstat timestamp is not updating.  ABORTING!" 
    print "At the command prompt, type the following: /home/naoj/bin/after_reboot_tsc"
    print "Then re-run this script."
    sys.exit()  # Aborting program.


# ANSI Color Codes for terminals.
#print '\x1b[1;32m%s\x1b[0m'% ('I am bold green')
#print '\x1b[1;31m%s\x1b[0m'% ('I am bold red')
#print '\x1b[4;31m%s\x1b[0m'% ('I am underlined red')
#print '\x1b[1;4;31m%s\x1b[0m'% ('I am bold underlined red')
#print '\x1b[7;31m%s\x1b[0m'% ('I am reverse red')
print '\x1b[6;31m%s\x1b[0m'% ('I am fast blinking reverse red')
#print '\x1b[1;41m%s\x1b[0m'% ('I am bold white on red background')
#print '\x1b[5;1;41m%s\x1b[0m'% ('I am blinking bold white on red bkgd.')


# TSC V variable checking function
# Input:  prefText - prefix text string to report.
#         tscvName - Name of tscv variable i.e. tscv.Dome_Drive_Off
#         state - Correct State 1 (True) 0 (False)
#         goodSufText - good suffix text string to report.
#         badSufText - bad suffix text string to report.
#         idx - index into DISABLE_MODE string
# Returns: 1 (check was successful)
def vcheck(prefText, tscvName, state, goodSufText, badSufText, disable, idx) :

    idxStr = "%d: " %idx
    idxStr = string.rjust(idxStr, 4)

    if tscvName == state :
        if disable == 0 :
            print idxStr+prefText+" \x1b[1;32m %s\x1b[0m" %goodSufText
        else:
            print idxStr+prefText+" \x1b[1;34m %s\x1b[0m" %goodSufText
    else:
        if disable == 0 :
            print "\x1b[1;41m"+idxStr+prefText+"  %s\x1b[0m%s" %(badSufText, BELL)
        else:
            print idxStr+prefText+" \x1b[1;34m %s\x1b[0m" %badSufText
    return 1



# Item checking function for v variables
#         Determines if item should be checked or not depending upon
#         char [d|D] in DISABLE_MODE string
# Input:  prefText - prefix text string to report.
#         tscvName - Name of tscv variable i.e. tscv.Dome_Drive_Off
#         state - Correct State 1 (True) 0 (False)
#         goodSufText - good suffix text string to report.
#         badSufText - bad suffix text string to report.
#         idx - index into DISABLE_MODE string
# Returns: 1 (check was successful)/
def setCheck(prefText, tscvName, state, goodSufText, badSufText, idx) :

    if ALM_ON[idx] == 0 :
        vcheck(prefText, tscvName, state, goodSufText, badSufText, 1, idx) 
    else :
        vcheck(prefText, tscvName, state, goodSufText, badSufText, 0, idx)
    return 1



# TSC L variable checking function
# Input:  prefText - prefix text string to print out.
#         tsclName - Name of tscv variable i.e. tscl.Weather_Humidity.val()
#         value - desired value
#         error - acceptable error (+/- error)
#         sufText - suffix text string to print out.
#         idx - index into DISABLE MODE string
# Returns: 1 (check was successful)
def lcheck(prefText, tsclName, value, error, sufText, idx) :

    lowValue = value - error
    hiValue = value + error
    tscValue = tsclName

    strVal = "%7.4f" %tscValue
    strVal = string.rjust(strVal, 5)
    idxStr = "%d: " %idx
    idxStr = string.rjust(idxStr, 4)
    
    if tscValue > lowValue and tscValue < hiValue :
        print idxStr+prefText+"\x1b[1;32m  %s%s\x1b[0m" %(strVal, sufText)
    else:
#        print "\x1b[1;41m"+idxStr+prefText+"  %s%s%s\x1b[0m" %(strVal, sufText, BELL )
         print "\x1b[5;1;41m" + idxStr+prefText+"  %s%s%s\x1b[0m" %(strVal, sufText, BELL )
    return 1



# Item checking function for long variables.
#         Determines if item should be checked or not depending upon
#         char [d|D] in DISABLE_MODE string
# Input:  prefText - prefix text string to report.
#         tsclName - Name of tscl variable i.e. tscl.Heat_Exh_TLSCP_Coolant_Temp.val(
#         value - desired value
#         error - acceptable error (+/- error)
#         sufText - suffix text string to print out.
#         idx - index into DISABLE_MODE string
# Returns: 1 (check was successful)/
def longCheck(prefText, tsclName, value, error, SufText, idx) :

    strVal = "%7.4f" %tsclName
    strVal = string.rjust(strVal, 5)
    idxStr = "%d: " %idx
    idxStr = string.rjust(idxStr, 4)
    
    if ALM_ON[idx] == 0 :
        print idxStr+prefText+"\x1b[1;34m  %s%s\x1b[0m" %(strVal,SufText)
    else :
        lcheck(prefText, tsclName, value, error, SufText, idx);
    return 1



# TSC S (Short) variable checking function
# Input:  prefText - prefix text string to print out.
#         tsclName - Name of tscv variable i.e. tscl.Weather_Humidity.val()
#         value - desired value
#         error - acceptable error (+/- error)
#         sufText - suffix text string to print out.
# Returns: 1 (check was successful)
def scheck(prefText, tscsName, value, error, sufText, idx) :

    lowValue = value - error
    hiValue = value + error
    tscValue = tscsName

    strVal = "%5.2f" %tscValue
    strVal = string.rjust(strVal, 5)
    idxStr = "%d: " %idx
    idxStr = string.rjust(idxStr, 4)
    
    if tscValue > lowValue and tscValue < hiValue :
        print idxStr+prefText+"\x1b[1;32m  %s%s\x1b[0m" %(strVal, sufText)
    else:
#        print "\x1b[1;41m"+idxStr+prefText+"  %s%s%s\x1b[0m" %(strVal, sufText, BELL )
         print "\x1b[5;1;41m" + idxStr+prefText+"  %s%s%s\x1b[0m" %(strVal, sufText, BELL )
    return 1



# Item checking function for short variables.
#         Determines if item should be checked or not depending upon
#         char [d|D] in DISABLE_MODE string
# Input:  prefText - prefix text string to report.
#         tscsName - Name of tscs variable i.e. tscs.Tip_Tilt_X_Real_Angle.val()
#         value - desired value
#         error - acceptable error (+/- error)
#         sufText - suffix text string to print out.
#         idx - index into DISABLE_MODE string
# Returns: 1 (check was successful)/
def shortCheck(prefText, tscsName, value, error, SufText, idx) :

    strVal = "%5.2f" %tscsName
    strVal = string.rjust(strVal, 5)
    idxStr = "%d: " %idx
    idxStr = string.rjust(idxStr, 4)
    
    if ALM_ON[idx] == 0 :
        print idxStr+prefText+"\x1b[1;34m  %s%s\x1b[0m" %(strVal,SufText)
    else :
        scheck(prefText, tscsName, value, error, SufText, idx);
    return 1

print
print "Ringing the bell.  Adjust volume so that bell is audible" +  BELL
print "Control-C to quit this program."
print "** Results not valid if TSC is rebooted after this script has started!"
print
time.sleep(2)

# !!!!!!!!!!!!!!!!!!!!!!  Update condensation condition parameters here.   !!!!!!!!!!!!!!!!!!!!!!!!!!!!!
SCAM_HMD_LIMIT = 50.00
SCAM_WIND_LIMIT = 5.00
SCAM_WINDTEL_DIFANG = 20.00
SLEW_PCT = 0.035945
SCAM_AZ_SLEWRATE = 0.5564 * SLEW_PCT
SCAM_EL_SLEWRATE = 0.5564 * SLEW_PCT
SCAM_EL_LIMIT = 40.00
TEL_NORMAL_OFFSET = 180.00
ZENITH = 89.85
OK_Ctr = 0
Bad_Ctr = 0
ALARM_CYCLE = 20
DEBUG = False
YESINDEX = 313
oldtimestamp = -10000000

while True :
    # Get latest data from tscv shared memory.
    tscv.vset(mv.read(12931))

    # Get latest data from tscs shared memory
    tscs.set(ms.read(1292))
    
    # Get latest data from tscl shared memory
    tscl.set(ml.read(1292*7))
    
    # Get and format the timestamp for this computer not TSC timestamp.
    locTime = time.strftime("%d%b%Y %H:%M:%S ", time.localtime())
    print locTime

    # When adding items to be monitored don't forget to add the index as the last entry in setCheck or
    # longCheck.  Also, add a "1" to the ALM_ON list for each item added.
    HigHumid = 99.9
    MidHumid = 50.0
    LowHumid = 0.1

    if DEBUG == False :
        print "EL_Real_Angle       ", tscs.EL_Real_Angle.val()
        print "Wind Dir. Avg.      ", tscl.Weather_Wind_Direction_AVG.val()
        print "WindDir_WSCRN_CONT  ", tscl.Wind_Direction_WSCRN_CONT.val()
        print "Wind Velocity Avg.  ", tscl.Weather_Wind_Velocity_AVG.val()
        print "Top_Ring_F_WVEL_Data", tscl.Top_Ring_F_WVEL_Data.val()
        print "Top_Ring_R_WVEL_Data", tscl.Top_Ring_R_WVEL_Data.val()
        ###print "WindVel_WSCRN_CONT  ", tscl.Wind_Velocity_WSCRN_CONT.val(), "\n"
        print "Mt_Auto_Guiding_Mode", tscv.Mount_Auto_Guiding_Mode
        print "Mount_Pointing_Mode ", tscv.Mount_Pointing_Mode
        print "Mount_Slew_Mode     ", tscv.Mount_Slew_Mode
        print "Dome_Slew_Mode      ", tscv.Dome_Slew_Mode
        print "MtOPenTrackingMode  ", tscv.Mount_Open_Tracking_Mode
        print "Telescope_Tracking  ", tscv.Telescope_Tracking, "\n"
        print "TpRg_F_Temp_Air_Data", tscl.Top_Ring_F_Temp_Air_Data.val()
        print "TpRg_R_Temp_Air_Data", tscl.Top_Ring_R_Temp_Air_Data.val(), "\n"
        ###print "Right_Ascencion hh  ", tscs.Right_Ascention.hh()
        ###print "Right_Ascencion mm  ", tscs.Right_Ascention.mm()
        ###print "Right_Ascencion ss  ", tscs.Right_Ascention.ss()
        ###print "Declination Char Flg", tscs.Declination.char_flag()
        ###print "Declination dd      ", tscs.Declination.dd()
        ###print "Declination mm      ", tscs.Declination.mm()
        ###print "Declination ss      ", tscs.Declination.ss(), "\n"
        ###print "AZ_Rate_REF         ", tscl.AZ_Rate_REF.val()
        ###print "TSCL_AZ_SPEED       ", tscl.TSCL_AZ_SPEED()
        ###print "EL_Rate_REF         ", tscl.EL_Rate_REF.val()
        ###print "TSCL_EL_SPEED       ", tscl.TSCL_EL_SPEED()

    rgtAs = 0.0
    rgtAs = tscs.Right_Ascention.hh()
    rgtAs = rgtAs + (tscs.Right_Ascention.mm() / 60.00)
    rgtAs = rgtAs + (tscs.Right_Ascention.ss() / 3600.00)
    ###print "rgtAs = ", rgtAs
    declin = 0.0
    declin = declin + tscs.Declination.dd()
    declin = declin + (tscs.Declination.mm() / 60.00)
    declin = declin + (tscs.Declination.ss() / 3600.00)
    if '-' in tscs.Declination.char_flag() :
        declin = declin * -1.00
    ###print "declin = ", declin
    
    if tscl.AZ_Rate_REF.val() > -SCAM_AZ_SLEWRATE and tscl.AZ_Rate_REF.val() < SCAM_AZ_SLEWRATE :
        if DEBUG == False :
            print "AZ NOT SLEWING at ", tscl.AZ_Rate_REF.val()
        isAZSlew = False
    else :
        if DEBUG == False:
            print "AZ SLEWING at ", tscl.AZ_Rate_REF.val()
        isAZSlew = True
        Bad_Ctr = 0

    if tscl.EL_Rate_REF.val() > -SCAM_EL_SLEWRATE and tscl.EL_Rate_REF.val() < SCAM_EL_SLEWRATE :
        if DEBUG == False:
            print "EL NOT SLEWING at ", tscl.EL_Rate_REF.val(), "\n"
        isELSlew = False
    else :
        if DEBUG == False:
            print "EL SLEWING at ", tscl.EL_Rate_REF.val(), "\n"
        isELSlew = True
        Bad_Ctr = 0
        
    if  (not tscv.Opt_Shutter_Full_Close) or (not tscv.IR_Shutter_Full_Close) :
        if DEBUG == False :
            print "Dome: OPEN"
        Dome_Open = 1
    else :
        if DEBUG == False :
            print "Dome: CLOSED"
        Dome_Open = 0

    if tscl.Weather_Wind_Velocity_AVG.val() < SCAM_WIND_LIMIT :
        Wind_Above = 0
    else :
        Wind_Above = 1
        if DEBUG == False :
            print "Wind speed: ", tscl.Weather_Wind_Velocity_AVG.val(), " vs. ", SCAM_WIND_LIMIT
    
    # Find the middle or median humidity among three humidity sensors.
    if DEBUG == False :
        ###print "Top_Ring_HMD_Data  ", tscl.Top_Ring_HMD_Data.val()
        longCheck("Top_Ring_Humidity", tscl.Top_Ring_HMD_Data.val(), 0.0, 79.9, "%",1)
        ###print "Cell_CNTR_HMD_Data ", tscl.Cell_CNTR_HMD_Data.val()
        longCheck("Cell_CTR_Humidity", tscl.Cell_CNTR_HMD_Data.val() , 0.0, 79.9, "%",2)
        ###print "Cell_F_HMD_Data    ", tscl.Cell_F_HMD_Data.val()
        longCheck("Cell_F_Humidity  ", tscl.Cell_F_HMD_Data.val() , 0.0, 79.9, "%",3)     
        ###print "Cell_Opt_HMD       ", tscl.Cell_Opt_HMD_Data.val()
        longCheck("Cell_Opt_Humidity", tscl.Cell_Opt_HMD_Data.val() , 0.0, 79.9, "%",4)
        ###print "Cell_IR_HMD        ", tscl.Cell_IR_HMD_Data.val()
        longCheck("Cell_IR_Humidity ", tscl.Cell_IR_HMD_Data.val() , 0.0, 79.9, "%",5)        
        ###print "Weather_Humidity   ", tscl.Weather_Humidity.val()
        longCheck("Weather_Humidity ", tscl.Weather_Humidity.val() , 0.0, 79.9, "%",6)

    ###if tscl.Top_Ring_HMD_Data.val() > tscl.Weather_Humidity.val() :
        ###HiHumid = tscl.Top_Ring_HMD_Data.val()
        ###LoHumid = tscl.Weather_Humidity.val()
    ###else :
        ###HiHumid = tscl.Weather_Humidity.val()
        ###LoHumid = tscl.Top_Ring_HMD_Data.val()

    ###if tscl.Cell_CNTR_HMD_Data.val() > HiHumid :
        ###MidHumid = HiHumid
        ###HiHumid = tscl.Cell_CNTR_HMD_Data.val()
    ###elif tscl.Cell_CNTR_HMD_Data.val() > LoHumid :
        ###MidHumid = tscl.Cell_CNTR_HMD_Data.val()
    ###else :
        ###MidHumid = LoHumid
        ###LoHumid = tscl.Cell_CNTR_HMD_Data.val()

    MidHumid = tscl.Top_Ring_HMD_Data.val()
    
    if MidHumid < SCAM_HMD_LIMIT :
        if DEBUG == False :
            print "Humidity: ", MidHumid, " < ", SCAM_HMD_LIMIT, "\n"
        Humid_Above = 0
    else :
        if DEBUG == False :
            print "Humidity: ", MidHumid, " >= ", SCAM_HMD_LIMIT, "\n"
        Humid_Above = 1

    # Calculate the normalized telescope azimuth.
    normal_AZ=tscs.AZ_Real_Angle.val() + TEL_NORMAL_OFFSET
    if normal_AZ > 360.00 :
        normal_AZ = normal_AZ - 360.00
    elif normal_AZ < 0.00 :
        normal_AZ = normal_AZ + 360.00

    # Calculate the wind offset angle and adjust if it's greater than 180
    windTel_offset = normal_AZ - tscl.Weather_Wind_Direction_AVG.val()
    if windTel_offset > 180.00 :
        windTel_offset = 360.00 - windTel_offset
    elif windTel_offset < -180.00 :
        windTel_offset = windTel_offset + 360.00
    if DEBUG == False :
        print "AZ: ", tscs.AZ_Real_Angle.val(), "   NAZ: ", normal_AZ, "   windOffset: ", windTel_offset

    if not isAZSlew and not isELSlew and Dome_Open and Wind_Above and Humid_Above :   
        # Check wind/Telescope offset is less than absval 20 and that elevation is less than 40
        if windTel_offset > -SCAM_WINDTEL_DIFANG and windTel_offset < SCAM_WINDTEL_DIFANG and tscs.EL_Real_Angle.val() < SCAM_EL_LIMIT :
            if DEBUG :
                print "Condensation Risk: Yes"
            SCam_Condensation = 1
            Bad_Ctr+=1
            OK_Ctr = 0
        else :
            if DEBUG :
                print "Condensation Risk: No"
            SCam_Condensation = 0
            OK_Ctr+=1
    else :
        if DEBUG == False:
            print "AZ/EL Slew, Dome Closed, Wind<5, RH<50, Windoffset>20, or EL>40"
        SCam_Condensation = 0
        OK_Ctr+=1        

    if OK_Ctr > 0 and (OK_Ctr % 20) == 0 :
        if DEBUG :
            print "20 consecutive OK, resetting Alarm State to NORMAL. Bad_Ctr = ",Bad_Ctr, "  OK_Ctr = ",OK_Ctr
        Bad_Ctr = 0
        ALM_ON[7] = 1
        setCheck("SCam Condensation  ",SCam_Condensation, 0, "NO ", "YES",7)
    elif Bad_Ctr < ALARM_CYCLE :
        if DEBUG :
            print "Alarm State: WARNING.   Bad_Ctr = ",Bad_Ctr, "  OK_Ctr = ",OK_Ctr
        setCheck("SCam Condensation  ",SCam_Condensation, 0, "NO ", "YES",7)
    elif (Bad_Ctr % ALARM_CYCLE) > 0 :
        if DEBUG :
            print "Alarm state QUIET.  Warning every ", ALARM_CYCLE * 7.0, " seconds Bad_Ctr = ",Bad_Ctr, "  OK_Ctr = ",OK_Ctr
        ALM_ON[7] = 0
        setCheck("SCam Condensation  ",SCam_Condensation, 0, "NO ", "YES",7)
    else :
        if DEBUG :
            print "Alarm State: ONE WARNING. Bad_Ctr = ",Bad_Ctr, "  OK_Ctr = ",OK_Ctr
        ALM_ON[7] = 1
        setCheck("SCam Condensation  ",SCam_Condensation, 0, "NO ", "YES",7)
        ALM_ON[7] = 0
        
        
    ### setCheck("SCam Condensation  ",SCam_Condensation, 0, "No", "Yes",4)
    ### print "KEY: "+"\x1b[1;42m  OK  "+"\x1b[0m"+"  "+"\x1b[1;41m BAD "+"\x1b[0m"+"  "+"\x1b[1;44mALMOFF"+"\x1b[0m"
        
    try:
        
        urlResp = urllib.urlopen('http://ltcs.naoj.hawaii.edu:8011/ltcs.html/')     
    except IOError, e:
        
        print "Unable to connect to LTCS web page. IOError:",e
    else:
        
        headers = urlResp.info()
        data = urlResp.read()
        if DEBUG :
            print 'URL     :', urlResp.geturl()
            print 'DATE    :', headers['date']
            print 'HEADERS :'
            print '---------'
            print headers
            print 'LENGTH  :', len(data)
            print 'DATA    :'
            print '---------'
            print data

        ###data = urlResp.readlines()
        ###i=0
        ###for line in data :
        ###    print "Line ", i, ": ", line, 'YES index: ', line.find("YES") 
        ###    i=i+1

        # Timestamp updating checking.
        ###timeIdx = data.find("TIMESTAMP1")
        ###if timeIdx > -1 :
        ###    newtimestamp = data[timeIdx+16:timeIdx+26]
        ###    if DEBUG == False :
        ###        ###print 'TIMESTAMP1 index: ', timeIdx
        ###        print 'new: ',newtimestamp, "old: ", oldtimestamp
      
        ###    if (newtimestamp == oldtimestamp or not newtimestamp.isdigit()) :
        ###        ###print "TIMESTAMP: BAD"
        ###        tmStpOK = 0
        ###    else :
        ###        ###print "TIMESTAMP: OK "
        ###        tmStpOK = 1
        ###else :
        ###    tmStpOK = 0
        ###setCheck("LTCS Timestamp1    ", tmStpOK, 1, "OK ", "BAD",34)                
        ###oldtimestamp = newtimestamp

        # Subaru LASER_STATE Flag checking
        ###lasOnIdx = data.find("LASER_STATE")
        ###if lasOnIdx > -1 :
        ###    lasOnStr = data[lasOnIdx+16:lasOnIdx+19]
        ###    if DEBUG == False :
        ###        print 'LASER_STATE: ', lasOnStr, '   lasOnIdx: ', lasOnIdx 
        ###else :
        ###    if DEBUG == FALSE :
        ###        print 'LASER_STATE: ', lasOnStr, '   lasOnIdx: ', lasOnIdx
                # Checking RA & DEC from LTCS versus real RA & DEC

        rgtAs = 0.0
        rgtAs = tscs.Right_Ascention.hh()
        rgtAs = rgtAs + (tscs.Right_Ascention.mm() / 60.00)
        rgtAs = rgtAs + (tscs.Right_Ascention.ss() / 3600.00)
        RAIdx = data.find("RA")
        ###print "RA index = ", RAIdx
        RAStr = data[RAIdx+16: RAIdx+23]
        RAFlt = float(RAStr)
        ###print "TSC-RA = ", rgtAs, "  LTCS-RA = ", RAFlt
        ###if abs(rgtAs - RAFlt) > 0.0005 :
        ###    print "LTCS RA and Telescope RA differ by more than five arcseconds"

        declin = 0.0
        declin = declin + tscs.Declination.dd()
        declin = declin + (tscs.Declination.mm() / 60.00)
        declin = declin + (tscs.Declination.ss() / 3600.00)
        if '-' in tscs.Declination.char_flag() :
            declin = declin * -1.00
        DECIdx = data.find("DEC")
        ###print "DEC index = ", DECIdx
        DECStr = data[DECIdx+16: DECIdx+23]
        DECFlt = float(DECStr)
        ###print "TSC-DEC = ", declin, "  LTCS-DEC = ", DECFlt
        ###if abs(declin - DECFlt) > 0.0005 :
        ###    print "LTCS DEC and Telescope DEC differ by more than five arcseconds"
            


        # LASER_IMPACTED Flag checking
        ###if data.find("YES") <> YESINDEX :
        ###    errStr = ""
        ###    isLasImpFlgOK = 0
        ###    if isAZSlew or isELSlew :
        ###        ###if len(errStr) > 0 :
        ###        ###    errStr = errStr + "/"
        ###        errStr = errStr + "Slw"
        ###        isLasImpFlgOK = 1
        ###    if not Dome_Open :
        ###        errStr = errStr + "Cld"
        ###        isLasImpFlgOK = 1
        ###    if tscs.EL_Real_Angle.val() > ZENITH :
        ###        errStr = errStr + "Zen"
        ###        isLasImpFlgOK =1
        ###    if "ON" in lasOnStr :
        ###        errStr = errStr + "Las"
        ###        isLasImpFlgOK = 1                   
        ###    print "errStr : ", errStr    
        ###    setCheck("LTCS Laser_Impacted", isLasImpFlgOK, 1, errStr, "NO?",35)

        ###else :
        ###    isLasImpFlgOK = 1
        ###    ###print 'LASER_IMPACTED: YES (OK)'
        ###    setCheck("LTCS Laser_Impacted", isLasImpFlgOK, 1, "YES", "NO?",35)

    ###try:
        ###str = "!8lekIGCqn9aaKCdvrrnqayfk19OKnaaOvnbXtoEUnSafmj0l027uOrdaTrEbnSaAm4nudee080C9afrUnSmoObdO07v6ln2ztoEMToafm2nbdovrOrdmT6"
        ###stsURLResp = urllib.urlopen("http://sts.subaru.nao.ac.jp/cgi-bin/sts?%s" %str)
        ###stsURLResp = urllib.urlopen("http://sts.subaru.nao.ac.jp")
    ###except IOError, e:
        
        ###print "Unable to connect to LTCS web page. IOError:",e
    ###else :
        ###print stsURLResp.read()
        
    time.sleep(7)
    print
    print
    print

 
