#!/usr/local/bin/python

import sys
import tel
import shm
import time
import commands
import string
import urllib
import dewpt


############################### C O N S T A N T S ###############################
ERR="ERROR - "
WRNG="WARNING -"
BELL="\a\a\a\a\a\a\a"
ALM_ON=[1,1,1,1,1, 1,1,1,1,1, 1,1,1,1,1, 1,1,1,1,1, 1,1,1,1,1, 1,1,1,1,1, 1,1,1,1,1, 1,1,1,1,1, 1,1,1,1,1]
DEBUG = False
# LTCS Constants -- CHANGE HERE
SLEW_PCT = 0.035945
SCAM_AZ_SLEWRATE = 0.5564 * SLEW_PCT
SCAM_EL_SLEWRATE = 0.5564 * SLEW_PCT
LTCSURL = 'http://ltcs.naoj.hawaii.edu:8011/ltcs.html/'
LTCSSTRG = "TIMESTAMP1"
SUBWXURL = 'http://133.40.174.41/CATWALK/index.html'
SUBWXSTRG = 'Humidity'
RADiffLim = 0.002
DECDiffLim = 0.002
ZENITH = 89.85
YESINDEX = 313



locTime=""
oldtimestamp = -10000000


def printUsage() :
    print
    print
    print "USAGE: ./SysChkr.py"
    print "or     ./SysChkr.py -[h|H]"
    print "or     ./SysChkr.py -[s|S] [DISABLE_STRING]"
    print
    print "OPTIONS"
    print "     -h or -H   prints this help and exits."
    print "     -s or -S   silence alarm(s) for items specified in the DISABLE_STRING."
    print
    print "DISABLE_STRING"
    print "     string of numbers corresponding to the number to the left of the alarm"
    print "     that is to be silenced.  More than one alarm can be silence by separating the"
    print "     numbers by commas."
    print
    print "     e.g. ./SysChkr.py -s  0,3,10"
    print
    print "     would result in item zero (EL Drive), third item (Dome Drive), seventh item"
    print "     (IRM2 Tip/Tilt) to have their respective alarms silenced."
    print

# Checking to see that this is the first instance of this Python script running.
#print commands.getoutput('ps -e | grep SysChkr | wc -l | cut -c 7-9' )
#numInst = commands.getoutput('ps -e | grep SysChkr | wc -l | cut -c 7-9')
#if numInst[0] != '1' :
#    print "SysChkr.py: Another SysChkr1py Python script is currently running."
#    print "SysChkr.py: Only one SysChkr.py is allowed to run at any given time."
#    print "SysChkr.py: Kill the currently running SysChkr.py script before starting again."
#    sys.exit(0)
def setAlmOff(idx) :
    
    global ALM_ON
    
    if idx > -1 and idx < len(ALM_ON) :
        ALM_ON[idx] = 0


     
# A function to parse -s/S (silence alarm) into tokens and then validate the
# tokens into valid index entries into the ALM_ON alarm list.
# Input:  inStr - input string containing indices into DISABLE_MODE string.
# Returns: 1 (check was successful)/
def parseSilStr(inStr) :

    strLen = len(inStr)
    aIStr = ""
    almIdx = -1

#    print inStr+" len = %d" %strLen
    idx = 0
    while idx < strLen :
        if inStr[idx].isdigit() == True :
#            print "inStr[%d] = %s is a digit" %(idx, inStr[idx])
            aIStr = aIStr + inStr[idx]
#            print "aIStr = " + aIStr
            almIdx = int(aIStr)
#            print "almIdx = %d" %almIdx
        elif inStr[idx] == "," :
#            print "inStr[%d] = %s is a comma" %(idx, inStr[idx])
            if len(aIStr) > 0 :
                almIdx = int(aIStr)
            aIStr = ""
#            print "almIdx = %d" %almIdx
            setAlmOff(almIdx)
            almIdx = -1
        else :
            print ERR+"invalid alphabetic character in alarm silence field."
            sys.exit(0)
        idx = idx + 1

    # Set the ALM_ON list for the last index which is not delimited by a comma.
    setAlmOff(almIdx)
    


# Checking for command line parameters.
if len(sys.argv) > 1 :
    if sys.argv[1] == "-h" or sys.argv[1] == "-H" :
        printUsage()
        sys.exit(0)
    elif sys.argv[1] == "-s" or sys.argv[1] == "-S" :
         if len(sys.argv) > 2 :
             DISABLE_STRING = sys.argv[2]
#             print "DISABLE_STRING = " + DISABLE_STRING
             parseSilStr(DISABLE_STRING)
         else :
             print ERR+"Missing silence alarm field"
             sys.exit(0)
    else :
        print "SysChkr.py : Invalid option %s selected." %sys.argv[1]
        printUsage()
        sys.exit(0)


# Setting up shared memory for type short
ms = shm.memory(shm.getshmid(0x100));
tscs=tel.TSCShort();
ms.attach(); 


# Setting up shared memory for type long
ml = shm.memory(shm.getshmid(0x101));
tscl=tel.TSCLong();
ml.attach();


# Setting up shared memory for type vstat
mv = shm.memory(shm.getshmid(0x102));
tscv=tel.TSCVstat();
mv.attach(); 


# Initial read of shared memory from TSC
tscs.set(ms.read(1292))
tscl.set(ml.read(1292*7))
tscv.vset(mv.read(12931))


# Check if Vstat connection between TSC-TWS4 is working.
print "Checking Vstat TSC-TWS4 connection."
prev_ss = tscv.time0000.ss()
t_cnt = 0
ss = prev_ss
# 600 iterations * 0.2 sec = 120 second timeout period.
while (ss == prev_ss and t_cnt < 600) :
    tscv.vset(mv.read(12391))
    prev_ss = ss
    ss = tscv.time0000.ss()
    t_cnt = t_cnt + 1
    if (ss == prev_ss) :
        time.sleep(0.2)
if (ss == prev_ss) :
    print ERR+"Vstat timestamp is not updating.  ABORTING!" 
    print "At the command prompt, type the following: /home/naoj/bin/after_reboot_tsc"
    print "Then re-run this script."
    sys.exit()  # Aborting program.


# ANSI Color Codes for terminals.
#print '\x1b[1;32m%s\x1b[0m'% ('I am bold green')
#print '\x1b[1;31m%s\x1b[0m'% ('I am bold red')
#print '\x1b[4;31m%s\x1b[0m'% ('I am underlined red')
print '\x1b[1;33m%s\x1b[0m'% ('I am bold yellow')
#print '\x1b[1;4;31m%s\x1b[0m'% ('I am bold underlined red')
#print '\x1b[7;31m%s\x1b[0m'% ('I am reverse red')
print '\x1b[6;31m%s\x1b[0m'% ('I am fast blinking reverse red')
#print '\x1b[1;41m%s\x1b[0m'% ('I am bold white on red background')
#print '\x1b[5;1;41m%s\x1b[0m'% ('I am blinking bold white on red bkgd.')


def stripChar(inStr) :

    if inStr.find(">") <> -1:
        inStr = inStr[0:len(inStr)-1]
    if inStr.find("b") <> -1:
        inStr = inStr[0:len(inStr)-1]
    if inStr.find("/") <> -1 :
        inStr = inStr[0:len(inStr)-1]
    if inStr.find("<") <> -1 :
        inStr = inStr[0:len(inStr)-1]
            
    return inStr



# Function to if Subaru LTCS webpage is operating correctly: timestamp updating and LASER_IMPACTED
# Input: oldtimestamp - value of the previously recorded timestamp
#        errNoTime - Line number used by SysChkr.py for LTCS timestamp checking
#        errNoImpact - Line number used by SysChkr.py for LTCS laser impacted checking.
# Returns: 1 if LTCS is operating normally. 0 otherwise
def getSubaruWx() :
    
    try:
        urlResp = urllib.urlopen(SUBWXURL)     
    except IOError, e:
        setCheck("Subaru Catwalk WX  ", 1, 0, "NoURL", "NoURL", errNoTime)
        if DEBUG == False :
            print "getSubaruWX: Unable to connect to Subaru Catwalk Wx. web page.",e
    else:

        headers = urlResp.info()
        
        data = urlResp.read()

        if DEBUG :
            print 'getSubaruWx'
            print 'URL     :', urlResp.geturl()
            print 'DATE    :', headers['date']
            print 'HEADERS :'
            print '---------'
            print headers
            print 'LENGTH  :', len(data)
            print 'DATA    :'
            print '---------'
            print data


        idx = data.find("Catwalk Temperature")
        catTemp = stripChar(data[idx+27:idx+35])
        #print "CatTemp = ", catTemp
        fltCatTemp = float(catTemp)
        print "CatTmpIdx = ", idx, " CtWkTmp = %6.2f" %fltCatTemp
        
        idx = data.find("NW</b> Humidity")
        humid = stripChar(data[idx+19:idx+23])
        if humid.find("-") == -1 :
            intHum = int(humid)
            print "NW HumIdx = ", idx, " NWHumid = %3i" %intHum
        else :
            humid = "N/A"
            print "NW HumIdx = ", idx, " NWHumid =", humid
                
        idx = data.find("NE</b> Humidity")
        humid = stripChar(data[idx+19:idx+23])
        if humid.find("-") == -1 :
            intHum = int(humid)
            print "NE HumIdx = ", idx, " NEHumid = %3i" %intHum
        else :
            humid = "N/A"
            print "NE HumIdx = ", idx, " NEHumid =", humid

        idx = data.find("SW</b> Humidity")
        humid = stripChar(data[idx+19:idx+23])
        if humid.find("-") == -1 :
            intHum = int(humid)
            print "SW HumIdx = ", idx, " SWHumid = %3i" %intHum
        else :
            humid = "N/A"
            print "SW HumIdx = ", idx, " SWHumid =", humid

        idx = data.find("SE</b> Humidity")
        humid = stripChar(data[idx+19:idx+23])
        if humid.find("-") == -1 :
            intHum = int(humid)
            print "SE HumIdx = ", idx, " SEHumid = %3i" %humid
        else :
            humid = "N/A"
            print "SE HumIdx = ", idx, " SEHumid =", humid

    return   # end of getSubaruWx #



print
print "Ringing the bell.  Adjust volume so that bell is audible" +  BELL
print "Control-C to quit this program."
print "** Results not valid if TSC is rebooted after this script has started!"
print
time.sleep(2)


while True :
    # Get latest data from tscv shared memory.
    tscv.vset(mv.read(12931))

    # Get latest data from tscs shared memory
    tscs.set(ms.read(1292))
    
    # Get latest data from tscl shared memory
    tscl.set(ml.read(1292*7))
    
    # Get and format the timestamp for this computer not TSC timestamp.
    locTime = time.strftime("%d%b%Y %H:%M:%S ", time.localtime())
    print locTime

    junk = getSubaruWx()
    
    print "KEY: "+"\x1b[1;42m  OK  "+"\x1b[0m"+"  "+"\x1b[1;41m BAD "+"\x1b[0m"+"  "+"\x1b[1;44mALMOFF"+"\x1b[0m"
    print 
    time.sleep(6.5)



 
