#!/usr/local/bin/python

# -- modules
import tel
import shm
import time
import math
import sys
import string

# -- Initialization to take value from UNIX shared memory
ms = shm.memory(shm.getshmid(0x100));
tscs=tel.TSCShort();
ms.attach(); 

ml = shm.memory(shm.getshmid(0x101));
tscl=tel.TSCLong();
ml.attach();

mv = shm.memory(shm.getshmid(0x102));
tscv=tel.TSCVstat();
mv.attach(); 


# -- read shared memory and set to the class-objects (like C-languade structures) 
m_interval=10 #-- please use 1 (min), 2(min),3(min), 4(min),5(min),6(min),10(min),12(min),15(min),(20min),(30min)
it = -1
it_m= -1
stamp0="**"
stamp_num=0
while 1:
    tscs.set(ms.read(1292))
    tscl.set(ml.read(1292*7))
    tscv.vset(mv.read(12931))
    L67_len=ms.read(32)
    if string.atof(L67_len[29:32])>= 566:
        iL7="7"
    else:
        iL7="6"
        

    it =int(tscs.time0000.ss())
    if it_m!=tscs.time0000.mm() : #-- every 1 minutes
        it_m=tscs.time0000.mm()

        #-- vstat check
        #stamp=mv.read(29)[27:29]
        stamp=tscv.time0000.a[10:15]
        if stamp!=stamp0:
            stamp0=stamp
            stamp_num=0
            vst=1
        else:
            stamp_num+=1
            if stamp_num>=2: #-- 10 minutes to check Vstat #2004.06.24 change from 10 to 1, because this loop will be done for every 10 minutes. 10 * 10 -> 100 minutes, 10* 1 -> 10 minutes ; changes to 20 minutes
                vst=0

        out=""
        out=out+ "%04.0lf/%02.0lf/%02.0lf %02.0lf:%02.0lf:%02.0lf (HST)" %(tscs.time0000.HSTyear(),tscs.time0000.HSTmonth(),tscs.time0000.HSTday(),tscs.time0000.HSThh(),tscs.time0000.mm(),math.floor(tscs.time0000.ss()))
        # math.floor is added to represent 59.9 -> :59 instead of -> :60


        out=out+"|T_Sup(Atel,Amir,Bcry,Dtel,Dmir) "
        out=out+ "%.1lf "%tscl.Heat_Exh_TLSCP_Coolant_Temp.val();
        out=out+ "%.1lf "%tscl.Heat_Exh_Mirror_Coolant_Temp.val();
        out=out+ "%.1lf "%tscl.Cryogenics_Exh_Coolant_Temp.val();
        out=out+ "%.1lf "%tscl.Rdn_Exh_A_TLSCPB_Coolant_Temp.val();
        out=out+ "%.1lf "%tscl.Rdn_Exh_A_MirrorC_Coolant_Temp.val();

        out=out+"|T_Ret "

        out=out+ "%.1lf "%tscl.Heat_Exh_TLSCP_Coolant_Return_Temp.val();
        out=out+ "%.1lf "%tscl.Heat_Exh_Mirror_Coolant_Return_Temp.val();
        out=out+ "%.1lf "%tscl.Cryogenics_Exh_Coolant_Return_Temp.val();
        out=out+ "%.1lf "%tscl.Rdn_Exh_A_TLSCPB_Return_Temp.val();
        out=out+ "%.1lf "%tscl.Rdn_Exh_A_MirrorC_Return_Temp.val();

        out=out+"|T_CMD "

        out=out+ "%.1lf "%tscl.Heat_Exh_TLSCP_Coolant_Temp_CMD.val();
        out=out+ "%.1lf "%tscl.Heat_Exh_Mirror_Coolant_Temp_CMD_HT_EXH.val();
        out=out+ "%.1lf "%tscl.Cryogenics_Exh_Coolant_Temp.val();
        out=out+ "%.1lf "%tscl.Rdn_Exh_A_TLSCP_Coolant_Temp_CMD.val();
        out=out+ "%.1lf "%tscl.Rdn_Exh_A_Mirror_Coolant_Temp_CMD.val();

        out=out+"|Pump_DRV(Atel,Amir,Bcry,Dtel,Dmir) "

        if vst==1:
            out=out+ "%s "%('off','on ')[tscv.Heat_Exh_TLSCP_Pump_OPN];  #@  6+2,   16+8*0,
            out=out+ "%s "%('off','on ')[tscv.Heat_Exh_Mirror_Pump_OPN];  #@  6+2,   16+8*1,
            out=out+ "%s "%('off','on ')[tscv.Cryogenics_Exh_Pump_OPN];  #@  6+2,   16+8*2,
            out=out+ "%s "%('off','on ')[tscv.Rdn_Exh_A_TLSCPB_Pump_OPN];  #@  6+2,   16+8*4,
            out=out+ "%s "%('off','on ')[tscv.Rdn_Exh_A_MirrorC_Pump_OPN];  #@  6+2,   16+8*5,
        else:
            out=out+ "- - - - - " 
    

        out=out+"|Flow "
        out=out+ "%.2lf "%tscl.Heat_Exh_TLSCP_Coolant_Flow.val();  #@  7+2,   17+8*0,
        out=out+ "%.2lf "%tscl.Heat_Exh_Mirror_Coolant_Flow.val();  #@  7+2,   17+8*1,
        out=out+ "%.2lf "%tscl.Cryogenics_Exh_Coolant_Flow.val();  #@  7+2,   17+8*2,
        out=out+ "%.2lf "%tscl.Rdn_Exh_A_TLSCPB_Flow.val();  #@  7+2,   17+8*4,
        out=out+ "%.2lf "%tscl.Rdn_Exh_A_MirrorC_Flow.val();  #@  7+2,   17+8*5,

        out=out+"|Pressure(Atel,Amir,Bcry,Dtel,Dmir,Dcry) "

        out=out+ "%.2lf "%tscl.Heat_Exh_TLSCP_Coolant_Pressure.val();  #@  8+2,   17+8*0,
        out=out+ "%.2lf "%tscl.Heat_Exh_Mirror_Coolant_Pressure.val();  #@  8+2,   17+8*1,
        out=out+ "%.2lf "%tscl.Cryogenics_Exh_Coolant_Pressure.val();  #@  8+2,   17+8*2,
        out=out+ "%.2lf "%tscl.Rdn_Exh_A_TLSCP_Pressure.val();  #@  8+2,   17+8*4,
        out=out+ "%.2lf "%tscl.Rdn_Exh_A_Mirror_Pressure.val();  #@  8+2,   17+8*5,
        out=out+ "%.2lf "%tscl.Rdn_Exh_B_Pressure.val();  #@  8+2,   17+8*6,

        out=out+"|ChillerDrv(A,B,C,D) "

        if vst==1:
            out=out+ "%3s "%('off','on ')[tscv.Heat_Exh_Pump_Chiller_A_OPN];  #@ 10+2,   14+6   +8*0,
            out=out+ "%3s "%('off','on ')[tscv.Cryogenics_Exh_Chiller_B_OPN];  #@ 10+2,   14+2   +8*2,
            if iL7!="7": #-- only old L6 status 
                out=out+"- "
            else:
                out=out+"%s "%('off','on ')[tscv.HYDRST_EXH_Chiller_Start];            #@ 10+2,   14+2   +8*3,

            out=out+"%s "%('off','on ')[tscv.Rdn_Exh_Chiller_OPN];      #@ 10+2,   14+6   +8*5,
        else:
            out=out+ "- - - - "

        out=out+"|T_In(A,B,D) "
        #screen.addstr( 11+2,   0,    " Temp Inward ",curses.A_NORMAL)
        out=out+ "%.1lf "%tscl.Heat_Exh_Chiller_In_Temp.val();  #@ 11+2,   14+6   +8*0,
        out=out+ "%.1lf "%tscl.Cryogenics_Exh_Chiller_In_Temp.val();  #@ 11+2,   14+1   +8*2,
        out=out+ "%.1lf "%tscl.Rdn_Exh_Chiller_In_Temp.val();  #@ 11+2,   14+6   +8*5,

        out=out+"|T_Out(A,B,D) "

        #screen.addstr( 12+2,   0,    "      Outward",curses.A_NORMAL)
        out=out+ "%.1lf "%tscl.Heat_Exh_Chiller_Out_Temp.val();  #@ 12+2,   14+6   +8*0,
        out=out+ "%.1lf "%tscl.Cryogenics_Exh_Chiller_Out_Temp.val();  #@ 12+2,   14+1   +8*2,
        out=out+ "%.1lf "%tscl.Rdn_Exh_Chiller_Out_Temp.val();  #@ 12+2,   14+6   +8*5,

        out=out+"|ChillerPump(A,B,C,D) "

        if vst==1:
            #        screen.addstr( 13+2,   0,    " Chiller Pump",curses.A_NORMAL)
            out=out+ "%s "%('off','on ')[tscv.Heat_Exh_Chiller_Pump_OPN];  #@ 13+2,   14+6   +8*0,
            out=out+ "%s "%('off','on ')[tscv.Cryogenics_Exh_Chiller_Pump_OPN] #@ 13+2,   14+2   +8*2,
            
            if iL7!="7": #-- only old L6 status 
                out=out+"- "
            else:
                out=out+ "%s "%('off','on ')[tscv.HYDRST_EXH_Chiller_Pump_Start];      #@ 13+2,   14+2   +8*3,
            out=out+ "%s "%('off','on ')[tscv.Rdn_Exh_Chiller_Pump_OPN];      #@ 13+2,   14+6   +8*5,
        else:
            out=out+"- - - - "

        out=out+"|D-Backup_auto_mode= "

        if vst==1:
            if tscv.Rdn_Exh_Unit_A_Backup_Auto==1:
                out=out+ 'A';

            if tscv.Rdn_Exh_Unit_B_Backup_Auto==1:
                out=out+ 'B';

            if tscv.Rdn_Exh_Unit_C_Backup_Auto==1:
                out=out+ 'C';
        else:
            out=out+"- "

        out=out+" D-current-work-as "
        if vst==1:
            if tscv.Rdn_Exh_A_Selected==1:
                out=out+ "A "
            elif tscv.Rdn_Exh_B_Selected==1:
                out=out+ "B "
            elif tscv.Rdn_Exh_C_Selected:
                out=out+ "C "
            else:
                out=out+"none "
        else:
            out=out+"- "
            

        out=out+ "|Environment "
        out=out+"T_Dew_Point= "
        out=out+"%+.1lf "%tscl.Heat_Exh_Dew_Point_Mirror.val()

        out=out+"T_OpenAir= "
        out=out+"%+.1lf "%tscl.Heat_Exh_Open_Air_Temp_TLSCP.val()

        out=out+"Humid= "
        out=out+"%.1lf "%tscl.Heat_Exh_Open_Air_HMD_TLSCP.val()

        print out
        sys.stdout.flush()

    time.sleep(1) #--
    tscs.set(ms.read(1292))
    time.sleep(60*m_interval-tscs.time0000.ss()-(tscs.time0000.mm() % m_interval) * 60+0.1)

