#!/usr/local/bin/python

import sys
import math

# Murphy Koop 2005 water vapor pressure over water
def eMurKool(T) :

    a = 54.842763
    b = 6763.22
    c = 4.210
    d = 0.000367
    e = 0.0415
    f = 218.8
    g = 53.878
    h = 1331.22
    i = 9.44523
    j = 0.014025
    
    lognT = math.log(T)
    
    ans = math.exp(a - b/T - c*lognT + d*T + math.tanh(e*(T - f)) * (g - h/T - i*lognT + j*T))

    return ans



# Murphy Koop 2005 water vapor pressure over plane of ice
def eMurKooi(T):

    a = 9.500426
    b = 5723.265
    c = 3.53068
    d = 0.00728332

    ans = math.exp(a - b/T + c*math.log(T) - d*T)

    return ans



# Sonntag 1990 water vapor pressure over water
def eSonl(T):

    a = -6096.9385
    b = 16.635764
    c = 0.02711193
    d = 0.00001673952
    e = 2.433502

    ans = math.exp(a/T + b - c*T + d*T*T + e*math.log(T))

    return ans



# Sonntag 1990 water vapor pressure over plane of ice
def eSoni(T):

    a = 24.7219
    b = 6024.5282
    c = 0.010613868
    d = 0.000013198825
    e = 0.49382577

    ans = math.exp(a - b/T + c*T - d*T*T - e*math.log(T))

    return ans



# Alduchov Enhanced August-Roche-Magnus(dry air) water vapor pressure over water
def eAldl(RH, T):

    e = 0.61094
    a = 17.625
    b = 243.04
    a2 = 17.271
    b2 = 237.7

    alpha = math.log(RH) + (a * T) / (b + T)
    ans = (b * alpha) / (a - alpha) 

    return ans



# Alduchov Enhanced August-Roche-Magnus(dry air) water vapor pressure over ice
def eAldi(RH,T):

    e = 0.61121
    a = 22.587
    b = 273.86

    alpha = math.log(RH) + (a * T) / (b + T)
    ans = (b * alpha) / (a - alpha) 

    return ans



RH = float(sys.argv[1]) / 100.0
Tc = float(sys.argv[2])
Tk = 273.15 + Tc
print "RH = ", RH, " Tc = ", Tc, "C", "  Tk = ", Tk, "K"

#print "Murphy-Koop liquid vapor pressure = ", eMurKool(Tk), "pa"
#print "Murphy-Koop ice vapor pressure    = ", eMurKooi(Tk), "pa"
#print "Sonntag liquid vapor pressure     = ", eSonl(Tk), "hpa"
#print "Sonntag ice vapor pressure        = ", eSoni(Tk), "hpa"
#print "August-Roche-Magnus liquid v.p.   = ", eAuRoMa(Tc), "kpa"
#print "Alduchov Enhanced ARM liquid v.p. = ", eAld(Tc), "kpa"



es = eMurKool(Tk) * RH
t = Tk - 0.01
ed = eMurKool(t)
###print "t = ", t, "  ed = ", ed, "  es = ", es 

while (ed > es) :

    t = t - 0.01
    ed = eMurKool(t)
    ###print "t = ", t, "  ed = ", ed
dewpt = t + 0.1 - 273.15
print "eMurKool dewpoint = %6.2f" %dewpt


es1 = eSonl(Tk) * RH
t = Tk - 0.01
ed1 = eSonl(t)
###print "t = ", t, "  ed1 = ", ed1, "  es1 = ", es1
while (ed1 > es1) :

    t = t - 0.01
    ed1 = eSonl(t)
    ###print "t = ", t, "  ed1 = ", ed1
dewpt = t + 0.1 - 273.15  
print "eSonl dewpoint =    %6.2f" %dewpt

dewpt = eAldl(RH,Tc)
print "A-R-Magnusl dewpt.= %6.2f" %dewpt

daycrew = math.pow(RH,1.0/8.0) * (112.0 + 0.9*Tc) + 0.1*Tc - 112
print "daycrew dewpoint =  %6.2f" %daycrew

esi = eMurKooi(Tk) * RH
t = Tk - 0.01
edi = eMurKooi(t)
###print "t = ", t, "  edi = ", edi, "  esi = ", esi 
while (edi > esi) :
    t = t - 0.01
    edi = eMurKooi(t)
    ###print "t = ", t, "  ed = ", edi
dewpt = t + 0.01 - 273.15
print "eMurKooi dewpoint = %6.2f" %dewpt



es1i = eSoni(Tk) * RH
t = Tk - 0.01
ed1i = eSoni(t)
###print "t = ", t, "  ed1i = ", ed1i, "  es1i = ", es1i 
while (ed1i > es1i) :
    t = t - 0.01
    ed1i = eSoni(t)
    ###print "t = ", t, "  ed1i = ", ed1i
dewpt = t + 0.01 - 273.15
print "eSoni dewpoint =    %6.2f" %dewpt

dewpt = eAldi(RH,Tc) 
print "A-R-Magnusi dewpt.= %6.2f" %dewpt

###lnPw = math.log(eMurKool(Tk))
###fpt = (1.814625 * lnPw + 6190.134) / (29.120 - lnPw)
##print "MurKoo frostpoint = ", fpt - 273.15

tsimple = Tc - (100 - (RH * 100.0)) / 5.0
print "simple dewpoint =   %6.2f" %tsimple

