/* reset-semaphore.c: resets semaphores - you might have to run this as root */
/*

Copyright (C) 2007 by Daigo Tomono <tomono at subaru.naoj.org>

Permission is granted for use, copying, modification, distribution,
and distribution of modified versions of this work under the terms of
GPL version 2 or later.

*/

/* If we're not using GNU C, elide __attribute__ */
#ifndef __GNUC__
#define  __attribute__(x)  /*NOTHING*/
#endif

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#define __USE_XOPEN
#include <sys/ipc.h>
#include <sys/sem.h>


int
main(int argc, char *argv[])
{
	int id, key;

	if (2 != argc)
		{
			fprintf(stderr, "usage: %s semaphore-key - removes the semaphore\n", argv[0]);
			exit(EXIT_FAILURE);
		}

	key = atoi(argv[1]);
	id = semget(key, 0, 0);
	if (id >= 0)
		{
			fprintf(stderr, "Removing key: %d ... ", key);
			if (semctl(id, 0, IPC_RMID))
				{
					perror("semctl()");
					exit(EXIT_FAILURE);
				}
			fputs("done\n", stderr);
		}
	else
		{
			perror("semget()");
			exit(EXIT_FAILURE);
		}
	return EXIT_SUCCESS;
}
