/* tws_tsc_stat_svc_proc.c: copies status into legacy shared memory */
/* copied from tws4:/home/morino/test and edited */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <errno.h>
#include <stdio.h>
#include <fcntl.h>
#include <sys/mman.h>
#include <sys/ipc.h>
#include <sys/sem.h>
#include <unistd.h>
#include <sys/types.h>

#include "tws_tsc_shm.h"

/* include path to be specified in Makefile */
#include "tws_tsc_stat.h"

#define TSCV_SHM_NAME "/tscv"
#define TSCV_BUFFER_SIZE 12931
#define TSCV_SEMAPHORE_KEY 129

/*
 * No.0: 0:writable 1:not writable to the shared memory
 * No.1: 0:no new data 1:new data
 */
static int shm_fd = -1;
static int sem_id = -1;
union semun
{
  int val;
};

static char *sm;

static void set (char *target, char *buf, int tot);

void
init_tscv_shm(void)
{
  int shmid;

  if ((shmid = shmget(0x102, TSCV_BUFFER_SIZE, 0666 | IPC_CREAT)) < 0)
		{
			perror("shmget() for legacy TSCV");
			return;
		}
  if ((sm = (char *) shmat(shmid, (char *) 0, 0)) == (char *) -1)
		{
			perror("shmat() for legacy TSCV");
			return;
		}

  shm_fd = shm_open(TSCV_SHM_NAME, O_CREAT | O_RDWR, 0644);
  if (shm_fd < 0)
		{
			perror("shm_open() for legacy TSCV");
			return;
		}

	sem_id = semget(TSCV_SEMAPHORE_KEY, 2, IPC_CREAT | 0666);
	if (sem_id < 0)
		{
			perror("semget(,,IPC_CREAT) for legacy TSCV");
			shm_fd = -1;
			return;
		}
}

void copy_tscv_shm(char *data, size_t length)
{
	set(sm, data, length);

  if (shm_fd > 0)
    {
      int not_writable;
      struct sembuf sops;
			union semun arg;

			/* check if writable */
			sops.sem_num = 0;
			sops.sem_op = 0;
			sops.sem_flg = IPC_NOWAIT;
			not_writable = semop (sem_id, &sops, 1);
			if (not_writable) return;
				
      if (ftruncate(shm_fd, TSCV_BUFFER_SIZE) < 0)
				{
					perror("ftruncate() for legacy TSCV");
					return;
				}
			if (lseek(shm_fd, 0, SEEK_SET) < 0)
				{
					perror("lseek() for legacy TSCV");
					return;
				}
			if (write (shm_fd, data, length) < length)
				{
					perror("write() for legacy TSCV");
					return;
				}
			arg.val = 1;
			if (semctl (sem_id, 1, SETVAL, arg) < 0)
				{
					perror ("semctl(,,SETVAL) for legacy TSCV");
				}
    }
}

void
set (char *target, char *buf, int tot) 
{
  long po;
  long shortid;
	char shortidstr[5] = "\0\0\0\0\0";

	memcpy(target, buf, 34);
  po = 0;
  while(po < tot -34)
    {	
			memcpy(shortidstr, buf + 34 + po, sizeof(shortidstr) - 1);
			shortid = strtol(shortidstr, NULL, 16);
			switch (shortid)
				{
				case 0x0006:
					memcpy(target + 34, buf + 34 + po, 139);
					po += 139;
					break;
				case 0x0008:
					memcpy(target + 173, buf + 34 + po, 29);
					po += 29;
					break;
				case 0x0051:
					memcpy(target + 202, buf + 34 + po, 29);
					po += 29;
					break;
				case 0x0037:
					memcpy(target + 231, buf + 34 + po, 50);
					po += 50;
					break;
				case 0x0027:
					memcpy(target + 281, buf + 34 + po, 73);
					po += 73;
					break;
				case 0x0032:
					memcpy(target + 354, buf + 34 + po, 52);
					po += 52;
					break;
				case 0x000E:
					memcpy(target + 406, buf + 34 + po, 95);
					po += 95;
					break;
				case 0x003A:
					memcpy(target + 501, buf + 34 + po, 87);
					po += 87;
					break;
				case 0x002E:
					memcpy(target + 588, buf + 34 + po, 20);
					po += 20;
					break;
				case 0x0038:
					memcpy(target + 608, buf + 34 + po, 28);
					po += 28;
					break;
				case 0x0024:
					memcpy(target + 636, buf + 34 + po, 115);
					po += 115;
					break;
				case 0x002B:
					memcpy(target + 751, buf + 34 + po, 83);
					po += 83;
					break;
				case 0x0061:
					memcpy(target + 834, buf + 34 + po, 46);
					po += 46;
					break;
				case 0x002A:
					memcpy(target + 880, buf + 34 + po, 179);
					po += 179;
					break;
				case 0x0001:
					memcpy(target + 1059, buf + 34 + po, 68);
					po += 68;
					break;
				case 0x000D:
					memcpy(target + 1127, buf + 34 + po, 49);
					po += 49;
					break;
				case 0x0004:
					memcpy(target + 1176, buf + 34 + po, 61);
					po += 61;
					break;
				case 0x0036:
					memcpy(target + 1237, buf + 34 + po, 59);
					po += 59;
					break;
				case 0x0029:
					memcpy(target + 1296, buf + 34 + po, 25);
					po += 25;
					break;
				case 0x0031:
					memcpy(target + 1321, buf + 34 + po, 29);
					po += 29;
					break;
				case 0x000B:
					memcpy(target + 1350, buf + 34 + po, 69);
					po += 69;
					break;
				case 0x0010:
					memcpy(target + 1419, buf + 34 + po, 52);
					po += 52;
					break;
				case 0x000A:
					memcpy(target + 1471, buf + 34 + po, 30);
					po += 30;
					break;
				case 0x00B1:
					memcpy(target + 1501, buf + 34 + po, 178);
					po += 178;
					break;
				case 0x00B2:
					memcpy(target + 1679, buf + 34 + po, 979);
					po += 1119;
					break;
				case 0x00B3:
					memcpy(target + 2658, buf + 34 + po, 93);
					po += 93;
					break;
				case 0x0002:
					memcpy(target + 2751, buf + 34 + po, 259);
					po += 259;
					break;
				case 0x0858:
					memcpy(target + 3010, buf + 34 + po, 21);
					po += 21;
					break;
				case 0x0859:
					memcpy(target + 3031, buf + 34 + po, 21);
					po += 21;
					break;
				case 0x0860:
					memcpy(target + 3052, buf + 34 + po, 21);
					po += 21;
					break;
				case 0x0039:
					memcpy(target + 3073, buf + 34 + po, 44);
					po += 44;
					break;
				case 0x0009:
					memcpy(target + 3117, buf + 34 + po, 119);
					po += 119;
					break;
				case 0x0040:
					memcpy(target + 3236, buf + 34 + po, 1019);
					po += 1019;
					break;
				case 0x0003:
					memcpy(target + 4255, buf + 34 + po, 115);
					po += 115;
					break;
				case 0x0033:
					memcpy(target + 4370, buf + 34 + po, 72);
					po += 72;
					break;
				case 0x0034:
					memcpy(target + 4442, buf + 34 + po, 42);
					po += 42;
					break;
				case 0x0035:
					memcpy(target + 4484, buf + 34 + po, 41);
					po += 41;
					break;
				case 0x0007:
					memcpy(target + 4525, buf + 34 + po, 141);
					po += 181;
					break;
				case 0x0030:
					memcpy(target + 4666, buf + 34 + po, 97);
					po += 97;
					break;
				case 0x002D:
					memcpy(target + 4763, buf + 34 + po, 63);
					po += 63;
					break;
				case 0x002C:
					memcpy(target + 4826, buf + 34 + po, 199);
					po += 199;
					break;
				case 0x0025:
					memcpy(target + 5025, buf + 34 + po, 55);
					po += 55;
					break;
				case 0x00A1:
					memcpy(target + 5080, buf + 34 + po, 1576);
					po += 1576;
					break;
				case 0x0028:
					memcpy(target + 6656, buf + 34 + po, 72);
					po += 72;
					break;
				case 0x0101:
					memcpy(target + 6728, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0102:
					memcpy(target + 6751, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0103:
					memcpy(target + 6774, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0104:
					memcpy(target + 6797, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0105:
					memcpy(target + 6820, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0106:
					memcpy(target + 6843, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0107:
					memcpy(target + 6866, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0108:
					memcpy(target + 6889, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0109:
					memcpy(target + 6912, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0110:
					memcpy(target + 6935, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0111:
					memcpy(target + 6958, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0112:
					memcpy(target + 6981, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0201:
					memcpy(target + 7004, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0202:
					memcpy(target + 7027, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0203:
					memcpy(target + 7050, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0204:
					memcpy(target + 7073, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0205:
					memcpy(target + 7096, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0206:
					memcpy(target + 7119, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0207:
					memcpy(target + 7142, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0208:
					memcpy(target + 7165, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0209:
					memcpy(target + 7188, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0210:
					memcpy(target + 7211, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0211:
					memcpy(target + 7234, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0212:
					memcpy(target + 7257, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0213:
					memcpy(target + 7280, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0214:
					memcpy(target + 7303, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0215:
					memcpy(target + 7326, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0216:
					memcpy(target + 7349, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0217:
					memcpy(target + 7372, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0218:
					memcpy(target + 7395, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0301:
					memcpy(target + 7418, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0302:
					memcpy(target + 7441, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0303:
					memcpy(target + 7464, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0304:
					memcpy(target + 7487, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0305:
					memcpy(target + 7510, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0306:
					memcpy(target + 7533, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0307:
					memcpy(target + 7556, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0308:
					memcpy(target + 7579, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0309:
					memcpy(target + 7602, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0310:
					memcpy(target + 7625, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0311:
					memcpy(target + 7648, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0312:
					memcpy(target + 7671, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0313:
					memcpy(target + 7694, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0314:
					memcpy(target + 7717, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0315:
					memcpy(target + 7740, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0316:
					memcpy(target + 7763, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0317:
					memcpy(target + 7786, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0318:
					memcpy(target + 7809, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0319:
					memcpy(target + 7832, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0320:
					memcpy(target + 7855, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0321:
					memcpy(target + 7878, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0322:
					memcpy(target + 7901, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0323:
					memcpy(target + 7924, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0324:
					memcpy(target + 7947, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0401:
					memcpy(target + 7970, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0402:
					memcpy(target + 7993, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0403:
					memcpy(target + 8016, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0404:
					memcpy(target + 8039, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0405:
					memcpy(target + 8062, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0406:
					memcpy(target + 8085, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0407:
					memcpy(target + 8108, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0408:
					memcpy(target + 8131, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0409:
					memcpy(target + 8154, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0410:
					memcpy(target + 8177, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0411:
					memcpy(target + 8200, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0412:
					memcpy(target + 8223, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0413:
					memcpy(target + 8246, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0414:
					memcpy(target + 8269, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0415:
					memcpy(target + 8292, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0416:
					memcpy(target + 8315, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0417:
					memcpy(target + 8338, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0418:
					memcpy(target + 8361, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0419:
					memcpy(target + 8384, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0420:
					memcpy(target + 8407, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0421:
					memcpy(target + 8430, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0422:
					memcpy(target + 8453, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0423:
					memcpy(target + 8476, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0424:
					memcpy(target + 8499, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0425:
					memcpy(target + 8522, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0426:
					memcpy(target + 8545, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0427:
					memcpy(target + 8568, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0428:
					memcpy(target + 8591, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0429:
					memcpy(target + 8614, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0430:
					memcpy(target + 8637, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0501:
					memcpy(target + 8660, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0502:
					memcpy(target + 8683, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0503:
					memcpy(target + 8706, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0504:
					memcpy(target + 8729, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0505:
					memcpy(target + 8752, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0506:
					memcpy(target + 8775, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0507:
					memcpy(target + 8798, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0508:
					memcpy(target + 8821, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0509:
					memcpy(target + 8844, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0510:
					memcpy(target + 8867, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0511:
					memcpy(target + 8890, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0512:
					memcpy(target + 8913, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0513:
					memcpy(target + 8936, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0514:
					memcpy(target + 8959, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0515:
					memcpy(target + 8982, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0516:
					memcpy(target + 9005, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0517:
					memcpy(target + 9028, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0518:
					memcpy(target + 9051, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0519:
					memcpy(target + 9074, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0520:
					memcpy(target + 9097, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0521:
					memcpy(target + 9120, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0522:
					memcpy(target + 9143, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0523:
					memcpy(target + 9166, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0524:
					memcpy(target + 9189, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0525:
					memcpy(target + 9212, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0526:
					memcpy(target + 9235, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0527:
					memcpy(target + 9258, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0528:
					memcpy(target + 9281, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0529:
					memcpy(target + 9304, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0530:
					memcpy(target + 9327, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0531:
					memcpy(target + 9350, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0532:
					memcpy(target + 9373, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0533:
					memcpy(target + 9396, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0534:
					memcpy(target + 9419, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0535:
					memcpy(target + 9442, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0536:
					memcpy(target + 9465, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0601:
					memcpy(target + 9488, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0602:
					memcpy(target + 9511, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0603:
					memcpy(target + 9534, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0604:
					memcpy(target + 9557, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0605:
					memcpy(target + 9580, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0606:
					memcpy(target + 9603, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0607:
					memcpy(target + 9626, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0608:
					memcpy(target + 9649, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0609:
					memcpy(target + 9672, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0610:
					memcpy(target + 9695, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0611:
					memcpy(target + 9718, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0612:
					memcpy(target + 9741, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0613:
					memcpy(target + 9764, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0614:
					memcpy(target + 9787, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0615:
					memcpy(target + 9810, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0616:
					memcpy(target + 9833, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0617:
					memcpy(target + 9856, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0618:
					memcpy(target + 9879, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0619:
					memcpy(target + 9902, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0620:
					memcpy(target + 9925, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0621:
					memcpy(target + 9948, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0622:
					memcpy(target + 9971, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0623:
					memcpy(target + 9994, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0624:
					memcpy(target + 10017, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0625:
					memcpy(target + 10040, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0626:
					memcpy(target + 10063, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0627:
					memcpy(target + 10086, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0628:
					memcpy(target + 10109, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0629:
					memcpy(target + 10132, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0630:
					memcpy(target + 10155, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0631:
					memcpy(target + 10178, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0632:
					memcpy(target + 10201, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0633:
					memcpy(target + 10224, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0634:
					memcpy(target + 10247, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0635:
					memcpy(target + 10270, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0636:
					memcpy(target + 10293, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0637:
					memcpy(target + 10316, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0638:
					memcpy(target + 10339, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0639:
					memcpy(target + 10362, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0640:
					memcpy(target + 10385, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0641:
					memcpy(target + 10408, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0642:
					memcpy(target + 10431, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0701:
					memcpy(target + 10454, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0702:
					memcpy(target + 10477, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0703:
					memcpy(target + 10500, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0704:
					memcpy(target + 10523, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0705:
					memcpy(target + 10546, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0706:
					memcpy(target + 10569, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0707:
					memcpy(target + 10592, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0708:
					memcpy(target + 10615, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0709:
					memcpy(target + 10638, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0710:
					memcpy(target + 10661, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0711:
					memcpy(target + 10684, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0712:
					memcpy(target + 10707, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0713:
					memcpy(target + 10730, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0714:
					memcpy(target + 10753, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0715:
					memcpy(target + 10776, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0716:
					memcpy(target + 10799, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0717:
					memcpy(target + 10822, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0718:
					memcpy(target + 10845, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0719:
					memcpy(target + 10868, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0720:
					memcpy(target + 10891, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0721:
					memcpy(target + 10914, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0722:
					memcpy(target + 10937, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0723:
					memcpy(target + 10960, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0724:
					memcpy(target + 10983, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0725:
					memcpy(target + 11006, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0726:
					memcpy(target + 11029, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0727:
					memcpy(target + 11052, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0728:
					memcpy(target + 11075, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0729:
					memcpy(target + 11098, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0730:
					memcpy(target + 11121, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0731:
					memcpy(target + 11144, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0732:
					memcpy(target + 11167, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0733:
					memcpy(target + 11190, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0734:
					memcpy(target + 11213, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0735:
					memcpy(target + 11236, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0736:
					memcpy(target + 11259, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0737:
					memcpy(target + 11282, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0738:
					memcpy(target + 11305, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0739:
					memcpy(target + 11328, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0740:
					memcpy(target + 11351, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0741:
					memcpy(target + 11374, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0742:
					memcpy(target + 11397, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0743:
					memcpy(target + 11420, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0744:
					memcpy(target + 11443, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0745:
					memcpy(target + 11466, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0746:
					memcpy(target + 11489, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0747:
					memcpy(target + 11512, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0748:
					memcpy(target + 11535, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0801:
					memcpy(target + 11558, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0802:
					memcpy(target + 11581, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0803:
					memcpy(target + 11604, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0804:
					memcpy(target + 11627, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0805:
					memcpy(target + 11650, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0806:
					memcpy(target + 11673, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0807:
					memcpy(target + 11696, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0808:
					memcpy(target + 11719, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0809:
					memcpy(target + 11742, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0810:
					memcpy(target + 11765, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0811:
					memcpy(target + 11788, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0812:
					memcpy(target + 11811, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0813:
					memcpy(target + 11834, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0814:
					memcpy(target + 11857, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0815:
					memcpy(target + 11880, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0816:
					memcpy(target + 11903, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0817:
					memcpy(target + 11926, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0818:
					memcpy(target + 11949, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0819:
					memcpy(target + 11972, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0820:
					memcpy(target + 11995, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0821:
					memcpy(target + 12018, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0822:
					memcpy(target + 12041, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0823:
					memcpy(target + 12064, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0824:
					memcpy(target + 12087, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0825:
					memcpy(target + 12110, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0826:
					memcpy(target + 12133, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0827:
					memcpy(target + 12156, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0828:
					memcpy(target + 12179, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0829:
					memcpy(target + 12202, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0830:
					memcpy(target + 12225, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0831:
					memcpy(target + 12248, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0832:
					memcpy(target + 12271, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0833:
					memcpy(target + 12294, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0834:
					memcpy(target + 12317, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0835:
					memcpy(target + 12340, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0836:
					memcpy(target + 12363, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0837:
					memcpy(target + 12386, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0838:
					memcpy(target + 12409, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0839:
					memcpy(target + 12432, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0840:
					memcpy(target + 12455, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0841:
					memcpy(target + 12478, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0842:
					memcpy(target + 12501, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0843:
					memcpy(target + 12524, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0844:
					memcpy(target + 12547, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0845:
					memcpy(target + 12570, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0846:
					memcpy(target + 12593, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0847:
					memcpy(target + 12616, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0848:
					memcpy(target + 12639, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0849:
					memcpy(target + 12662, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0850:
					memcpy(target + 12685, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0851:
					memcpy(target + 12708, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0861:
					memcpy(target + 12731, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0862:
					memcpy(target + 12754, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x0863:
					memcpy(target + 12777, buf + 34 + po, 23);
					po += 23;
					break;
				case 0x003B:
					memcpy(target + 12800, buf + 34 + po, 77);
					po += 211;
					break;
				case 0x003C:
					memcpy(target + 12877, buf + 34 + po, 54);
					po += 54;
					break;
				case 0x0000:
					po += 8192;
					break;
				default:
					fprintf(stderr, "Unknown short ID:0x%4.4X in message %34.34s\n", shortid, buf);
					po = tot;
					break;
				}
    }
}

