/* tws_tsc_long_svc_proc.c: copies status into legacy shared memory */
/* copied from tws4:/home/morino/test and edited */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <errno.h>
#include <stdio.h>
#include <fcntl.h>
#include <sys/mman.h>
#include <sys/ipc.h>
#include <sys/sem.h>
#include <unistd.h>
#include <sys/types.h>

#include "tws_tsc_shm.h"

/* include path to be specified in Makefile */
#include "tws_tsc_long.h"

#define TSCL_SLOTS 7
#define TSCL_SHM_NAME "/tscl%d"	/* slot number (1-) */
#define TSCL_BUFFER_SIZE 1292
#define TSCL_SEMAPHORE_KEY 292	/* plus slot number - 1 */

static char *sm;
static char *sm_flag;
static char prev_flag[2];

/*
 * No.0: 0:writable 1:not writable to the shared memory
 * No.1: 0:no new data 1:new data
 */
static int shm_fd[TSCL_SLOTS] = {-1, -1, -1, -1, -1, -1, -1};
static int sem_id[TSCL_SLOTS] = {-1, -1, -1, -1, -1, -1, -1};
union semun
{
  int val;
};

void
init_tscl_shm(void)
{
  int shmid;
	int l;
	char shm_name [sizeof(TSCL_SHM_NAME)];

  if ((shmid = shmget(0x101, TSCL_BUFFER_SIZE * TSCL_SLOTS, 0666 | IPC_CREAT)) < 0)
		{
			perror("shmget() for legacy TSCL");
			return;
		}
  if ((sm = (char *) shmat(shmid, (char *) 0, 0)) == (char *) -1)
		{
			perror("shmat() for legacy TSCL");
			return;
		}

	if ((shmid = shmget(0x110, 2, 0666 | IPC_CREAT)) < 0)
		{
			perror("shmget() for legacy TSCL flag");
			return;
		}
	if ((sm_flag = (char *) shmat(shmid, (char *) 0, 0)) == (char *) -1)
		{
			perror("shmat() for legacy TSCL");
			return;
		}
	memcpy(sm_flag, "0", 1);
	memcpy(prev_flag, "0", 1);

	for(l = 0; l < TSCL_SLOTS; l++)
		{
			snprintf(shm_name, sizeof(shm_name), TSCL_SHM_NAME, l + 1);
			shm_fd[l] = shm_open(shm_name, O_CREAT | O_RDWR, 0644);
			if (shm_fd[l] < 0)
				{
					perror("shm_open() for legacy TSCL");
					continue;
				}
			sem_id[l] = semget(TSCL_SEMAPHORE_KEY + l, 2, IPC_CREAT | 0666);
			if (sem_id[l] < 0)
				{
					perror("semget(,,IPC_CREAT) for TSCL");
					continue;
				}
		}
}

void copy_tscl_shm(char *data, size_t length)
{
	int slot;

	slot = *(data + 34) - '0';
	if (slot > TSCL_SLOTS) return;

	if (slot == 1) memcpy(sm_flag, prev_flag, 1);
	memcpy(sm_flag, data + 34, 1);
	memcpy(sm + TSCL_BUFFER_SIZE*(slot - 1), data, length);

  if (shm_fd[slot - 1] > 0)
    {
      int not_writable = 0;
      struct sembuf sops;
			union semun arg;

			/* check if writable */
			sops.sem_num = 0;
			sops.sem_op = 0;
			sops.sem_flg = IPC_NOWAIT;
			not_writable = semop(sem_id[slot - 1], &sops, 1);
			if (not_writable) return;

      if (ftruncate(shm_fd[slot - 1], TSCL_BUFFER_SIZE) < 0)
				{
					perror("ftruncate() for legacy TSCL");
					return;
				}
			if (lseek(shm_fd[slot - 1], 0, SEEK_SET) < 0)
				{
					perror("lseek() for legacy TSCL");
					return;
				}
			if (write (shm_fd[slot - 1], data, length) < length)
				{
					perror("write() for legacy TSCL");
					return;
				}
			arg.val = 1;
			if (semctl (sem_id[slot - 1], 1, SETVAL, arg) < 0)
				{
					perror ("semctl(,,SETVAL) for legacy TSCL");
				}
    }
}
