/* dummy-command-delegator.c : dummy command-delegator */
/*

Copyright (C) 2005 by Daigo Tomono <tomono at subaru.naoj.org>

Permission is granted for use, copying, modification, distribution,
and distribution of modified versions of this work under the terms of
GPL version 2 or later.

*/

/* If we're not using GNU C, elide __attribute__ */
#ifndef __GNUC__
#define  __attribute__(x)  /*NOTHING*/
#endif

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <assert.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <string.h>

#include <melco/tsc-message.h>
#include <test-tsc/command-dispatcher.h>
#include <tws4/command-delegation.h>
#include <tws4/command-delegator.h>

#ifdef COUNT_MALLOC
#include <count-malloc.h>
#endif

/* functions for tws4/command-delegator.h */
void usage(FILE *stream);
void show_command(CommandMessage* message);
void show_reception(ReceptionResponseMessage* message);
void show_completion(CompletionResponseMessage* message);
void show_error(char *string);
void start_tsc(int fd, void *args);
ssize_t sender(CommandMessage *message, int uid, int gid, void *args);

struct _start_tsc_args {
	int input_fd;
	int waitsec;
};

void
usage(FILE *stream)
{
	fputs("usage: dummy-command-dispatcher [options]\n", stream);
  fputs("\treads TSC commands from socket and sends back random responses from\n", stream);
	fprintf(stream, "\tthe dummy TSC. (%s)\n\n", PACKAGE_STRING);
	fputs("Telnet to 127.0.0.1 and send command like:\n", stream);
	fputs("CDTSC%TWS4000020031222092442600270000001A1901naoj **** % % %\n\n", stream);
	fputs("Commands, responses, and warnings are displayed as well as sent to client.\n", stream);
	fputs("Responses are created randomly but in a fixed sequence.\n\n", stream);
	fputs("OPTIONS:\n", stream);
	fprintf(stream, "-p port : listen to PORT (default:%d)\n", COMMMAND_DELGATOR_PORT);
}

void
show_command(CommandMessage* message)
{
	fputs("TWS4: sending ", stderr);
	fwrite(CommandMessage_tostr(message), CommandMessage_strlen(message), 1, stderr);
	fputc('\n', stderr);
}

void
show_reception(ReceptionResponseMessage* message)
{
	fputs("TWS4: got     ", stderr);
	fwrite(ReceptionResponseMessage_tostr(message), ReceptionResponseMessage_strlen(message), 1, stderr);
	fputc('\n', stderr);
}

void
show_completion(CompletionResponseMessage* message)
{
	fputs("TWS4: got     ", stderr);
	fwrite(CompletionResponseMessage_tostr(message), CompletionResponseMessage_strlen(message), 1, stderr);
	fputc('\n', stderr);
}

void
show_error(char *string)
{
	fprintf(stderr, "%s\n", string);
}

ssize_t
sender(CommandMessage *message, int uid, int gid, void *args)
{
	ssize_t r;
	r = write(*((int*) args), CommandMessage_tostr(message), CommandMessage_strlen(message));
	fprintf(stderr, "sent command with uid:%d gid:%d\n", uid, gid);
	/*fprintf(stderr, "%d bytes wrote to fd:%d\n", r, *((int*) args));*/
	return r;
}

void
start_tsc(int fd, void *args)
{
	tsc_server(((struct _start_tsc_args*) args)->input_fd, fd, ((struct _start_tsc_args*) args)->waitsec);
}

int
main(int argc, char *argv[])
{
	long r;
	int waitsec = -1;
	int pipe_to_tsc[2];
	struct sockaddr_in myaddr;
	struct _start_tsc_args tsc_args;
	logger_functions_s loggers;
	short port;

	/* command line options */
	port = COMMMAND_DELGATOR_PORT;
	{
		int o;
		while((o = getopt(argc, argv, "hp:")) != -1)
			{
				switch(o)
					{
					case 'h':	/* help */
						usage(stdout);
						return EXIT_SUCCESS;
					case 'p':	/* port */
						port = atoi(optarg);
						break;
					default:
						usage(stderr);
						return EXIT_FAILURE;
					}
			}
	}
	
	/* loggers */
	loggers.command = (command_logger_callback_t) show_command;
	loggers.reception = (reception_logger_callback_t) show_reception;
	loggers.completion =(completion_logger_callback_t) show_completion;
	loggers.error = (error_logger_callback_t) show_error;

	/* tws4 server setting */
	memset(&myaddr, 0, sizeof(myaddr));
	myaddr.sin_family = AF_INET;
	myaddr.sin_port = htons(port);
	myaddr.sin_addr.s_addr = htonl(0x7f000001);	/* 127.0.0.1 */

	/* tsc server setting */
	assert(!pipe(pipe_to_tsc));
	tsc_args.input_fd = pipe_to_tsc[0];
	tsc_args.waitsec = waitsec;

	fprintf(stdout, "waiting for commands at 127.0.0.1 port %d ...\n", port);
	r = command_delegator(
				&myaddr,
				(CommandMessage_send_t) sender,
				(void *) &(pipe_to_tsc[1]),
				(message_waiter_t) start_tsc,
				(void *) &tsc_args,
				&loggers);
	if (r >= 0)
		fprintf(stdout, "%ld messages processed\n", r);
	else
		perror("");

	return EXIT_SUCCESS;
}
