/* command-delegation.h : delegates command from local applications */
/*

Copyright (C) 2005 by Daigo Tomono <tomono at subaru.naoj.org>

Permission is granted for use, copying, modification, distribution,
and distribution of modified versions of this work under the terms of
GPL version 2 or later.

*/

#ifndef COMMAND_DELEGATION_H
#define COMMAND_DELEGATION_H

/* default tcp port of delegator */
#define COMMMAND_DELGATOR_PORT 8301

/* server prints status when receiving this charactor */
#define DELEGATOR_SHOW_STATUS 0x01 /* ^A */

/* server sets IDs to be used in RPC receiving 'u' or 'g' and decimal number following this */
#define DELEGATOR_SET_ID 0x02 /* ^b */
#define DELEGATOR_SET_UID 'u'
#define DELEGATOR_SET_GID 'g'
#define DELEGATOR_ID_BUF_LEN 16

/* server terminates when receiving this charactor */
#define DELEGATOR_EOT 0x04	/* ^D */

/* telnet on Solaris uses telnet protocol commands to send ^D */
/* telnet on RH8.0 getting ^D from stdin sends IAC */
#define IAC 255
#define IACBUFLEN 16
#define IAC_EOTS "\xEC\xF5"
/* IAC_EOF:236  IAC_AO:245 */

/* server ignores charactors which telnet client sends */
#define DELEGATOR_IGNORE "\r\n"

#endif	/* COMMAND_DELEGATION_H */
