/* dummy-tsc-behind-rpc.c : dummy tsc waiting for commands */
/*

Copyright (C) 2010 by Daigo Tomono <tomono at subaru.naoj.org>

Permission is granted for use, copying, modification, distribution,
and distribution of modified versions of this work under the terms of
GPL version 2 or later.

*/

#define CMDBUFLEN 1024

/* If we're not using GNU C, elide __attribute__ */
#ifndef __GNUC__
#define  __attribute__(x)  /*NOTHING*/
#endif

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <string.h>
#include <rpc/rpc.h>
#include <rpc/pmap_clnt.h>

#include <melco/tsc-message.h>
#include <test-tsc/command-dispatcher.h>

/* include path to be specified in Makefile */
#include "tws_tsc_command.h"
#include "tws_tsc_reply.h"

#ifdef COUNT_MALLOC
#include <count-malloc.h>
#endif

#define WAITSEC 5

static void sigchld(int x);

bool_t* from_tsc_1(MF_NetForm *argp, CLIENT *clnt);
extern bool_t* toward_tsc_1_svc(FM_NetForm* cmd_form, struct svc_req* svcdata);
tsc_completion_callback_t from_tsc_completion(const CompletionResponseMessage *message);
static void toward_tsc_prog_1(struct svc_req *rqstp, register SVCXPRT *transp);

static void
sigchld(int x __attribute__ ((unused)))
{
  while(waitpid(-1, NULL, WNOHANG) > 0);
	signal(SIGCHLD, sigchld);
}

/* Cioued from test-rpc/tws_tsc_reply_clnt.c */
static struct timeval DEFAULT_TIMEOUT = {25, 0};

bool_t*
from_tsc_1(MF_NetForm *argp, CLIENT *clnt)
{
	static bool_t clnt_res;

	memset((char *)&clnt_res, 0, sizeof(clnt_res));
	if (clnt_call(clnt, FROM_TSC, (xdrproc_t) xdr_MF_NetForm, (caddr_t) argp, (xdrproc_t) xdr_bool, (caddr_t) &clnt_res, DEFAULT_TIMEOUT) != RPC_SUCCESS)
		{
			return NULL;
		}
	return &clnt_res;
}

/* Copied from test-rpc/tws_tsc_command_svc_proc.c */
extern bool_t*
toward_tsc_1_svc(FM_NetForm* cmd_form, struct svc_req* svcdata)
{
	static bool_t result;
	struct authunix_parms* cred;
	u_int i;
	int uid;
	int gid;
	MF_NetForm reception_form;

	ReceptionResponseMessage *r;
	CLIENT* cl;

	if (!cmd_form || !svcdata)
		{
			result = FALSE;
			return &result;
		}

	cred = (struct authunix_parms*) svcdata->rq_clntcred;
	uid = cred->aup_uid;
	gid = cred->aup_gid;
	fprintf(stderr, "uid:%d gid:%d message:", uid, gid);
	for(i = 0; i < cmd_form->FM_NetForm_len; i++) fputc(cmd_form->FM_NetForm_val[i], stderr);
	fputc('\n', stderr);

	r = tsc_execute(cmd_form->FM_NetForm_val, NULL, from_tsc_completion, response_ok, response_complete, WAITSEC, 0, 0, -1);
	if (!r)
		{
			result = FALSE;
			return &result;
		}
	
	reception_form.MF_NetForm_val = ReceptionResponseMessage_tostr(r);
	reception_form.MF_NetForm_len = ReceptionResponseMessage_strlen(r);

	cl = clnt_create("localhost", FROM_TSC_PROG, FROM_TSC_VERS, "tcp");
	if (!cl)
		{
			ReceptionResponseMessage_decref(r);
			result = FALSE;
			return &result;
		}
	
	result = from_tsc_1(&reception_form, cl);
	ReceptionResponseMessage_decref(r);

	clnt_destroy(cl);
	return &result;
}

tsc_completion_callback_t
from_tsc_completion(const CompletionResponseMessage *message)
{
	static bool_t result;
	MF_NetForm completion_form;
	CLIENT* cl;

	completion_form.MF_NetForm_val = CompletionResponseMessage_tostr(message);
	completion_form.MF_NetForm_len = CompletionResponseMessage_strlen(message);

	cl = clnt_create("localhost", FROM_TSC_PROG, FROM_TSC_VERS, "tcp");
	if (!cl)
		{
			result = FALSE;
			return &result;
		}
	
	result = from_tsc_1(&completion_form, cl);

	clnt_destroy(cl);
	return &result;
}

/* Copied from test-rpc/tws_tsc_command_svc.c */
static void
toward_tsc_prog_1(struct svc_req *rqstp, register SVCXPRT *transp)
{
	union {
		FM_NetForm toward_tsc_1_arg;
	} argument;
	char *result;
	xdrproc_t _xdr_argument, _xdr_result;
	char *(*local)(char *, struct svc_req *);

	switch(rqstp->rq_proc)
		{
			case NULLPROC:
				(void) svc_sendreply(transp, (xdrproc_t) xdr_void, (char *)NULL);
				return;
			case TOWARD_TSC:
				_xdr_argument = (xdrproc_t) xdr_FM_NetForm;
				_xdr_result = (xdrproc_t) xdr_bool;
				local = (char *(*)(char *, struct svc_req *)) toward_tsc_1_svc;
				break;
			default:
				svcerr_noproc(transp);
				return;
		}
	memset((char *)&argument, 0, sizeof(argument));
	if (!svc_getargs(transp, (xdrproc_t) _xdr_argument, (caddr_t) &argument))
		{
			svcerr_decode(transp);
			return;
		}
	result = (*local)((char *)&argument, rqstp);
	if (result != NULL && !svc_sendreply(transp, (xdrproc_t) _xdr_result, result))
		{
			svcerr_systemerr(transp);
		}
	if (!svc_freeargs(transp, (xdrproc_t) _xdr_argument, (caddr_t) &argument))
		{
			fprintf(stderr, "%s", "unable to free arguments");
			exit(1);
		}
	return;
}

int
main(void)
{
	register SVCXPRT *transp;
	pmap_unset(TOWARD_TSC_PROG, TOWARD_TSC_VERS);

	transp = svctcp_create(RPC_ANYSOCK, 0, 0);
	if (!transp)
		{
			perror("svctcp_create()");
			exit(EXIT_FAILURE);
		}

	if (!svc_register(transp, TOWARD_TSC_PROG, TOWARD_TSC_VERS, toward_tsc_prog_1, IPPROTO_TCP))
		{
			perror("svc_register()");
			exit(EXIT_FAILURE);
		}

	fputs("waiting for commands from RPC ...\n", stderr);
	signal(SIGCHLD, sigchld);
	svc_run();
	perror("svc_run()");
	exit(EXIT_FAILURE);
}
