/* test-tree-lookup.c: test cases to be used to decrypt Fujitsu nomenclature */
/*

Copyright (C) 2007 by Daigo Tomono <tomono at subaru.naoj.org>

Permission is granted for use, copying, modification, distribution,
and distribution of modified versions of this work under the terms of
GPL version 2 or later.

*/

/* If we're not using GNU C, elide __attribute__ */
#ifndef __GNUC__
#define  __attribute__(x)  /*NOTHING*/
#endif

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#include <melco/tree-hash.h>
#include <count-malloc.h>

struct status_length {
	char *name;
	int bytes;
};

int
main(int argc __attribute__ ((unused)), char *argv[])
{
	int i;
	struct melco_tree_s *status;
	struct status_length lengths[] = {
		{"0001S", 18},
		{"0028S", 60},
		{"00A1L", 260},
		{"00B2L2", 1160},
		{"0009L", 7},
		{"00B2L3", 1100},
		{"0003L", 198},
		{"0007L", 64},	/* FY2005: S0501902A00 */
		{"0007E", 162},	/* FY2005: S0501902A00 */
		{NULL, 0},
	};

	fprintf(stderr, "%s running ... ", argv[0]);

	i = 0;
	while(lengths[i].name)
		{
			fprintf(stderr, "%s", lengths[i].name);
			status = melco_tree_lookup(lengths[i].name, strlen(lengths[i].name));
			assert(status);
			fprintf(stderr, ":%d ", status->bytes);
			assert(lengths[i].bytes == status->bytes);
			i++;
		}
	fprintf(stderr, "\n");

	return EXIT_SUCCESS;
}
