/* test-status-hash.c: test cases for status-hash.c */
/*

Copyright (C) 2005 by Daigo Tomono <tomono at subaru.naoj.org>

Permission is granted for use, copying, modification, distribution,
and distribution of modified versions of this work under the terms of
GPL version 2 or later.

*/

/* If we're not using GNU C, elide __attribute__ */
#ifndef __GNUC__
#define  __attribute__(x)  /*NOTHING*/
#endif

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#include <melco/status-hash.h>
#ifndef TOTAL_KEYWORDS
#define TOTAL_KEYWORDS 27335 
/* this number has to be copied from status-hash.c */
#endif

#ifdef COUNT_MALLOC
#include <count-malloc.h>
#endif

#define FIRST_ENTRY_NAME "Dome Real Angle"
#define LAST_ENTRY_NAME "Actuator8-69 Alarm Reset"
/* these should be copied from first and last entry of _status_entry_array[] in status-hash.c */

void test_melco_status_total(void);
void test_melco_status_ith(void);

void
test_melco_status_total(void)
{
	assert(TOTAL_KEYWORDS == melco_status_total());
}

void
test_melco_status_ith(void)
{
	assert(NULL == melco_status_ith(-1));
	assert(NULL == melco_status_ith(TOTAL_KEYWORDS));
	assert(!strcmp(FIRST_ENTRY_NAME, melco_status_ith(0)->name));
	assert(!strcmp(LAST_ENTRY_NAME, melco_status_ith(TOTAL_KEYWORDS-1)->name));
}

int
main(int argc __attribute__ ((unused)), char *argv[])
{ 
  fprintf(stderr, "%s running\n", argv[0]);
	test_melco_status_total();
	test_melco_status_ith();
	return EXIT_SUCCESS;
}
