/* test-shm-speed.c: measure speed of shm access */
/*

Copyright (C) 2005 by Daigo Tomono <tomono at subaru.naoj.org>

Permission is granted for use, copying, modification, distribution,
and distribution of modified versions of this work under the terms of
GPL version 2 or later.

*/

/* If we're not using GNU C, elide __attribute__ */
#ifndef __GNUC__
#define  __attribute__(x)  /*NOTHING*/
#endif

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <ctype.h>
#include <math.h>
#include <sys/time.h>
#include <sys/resource.h>

#include <melco/tsc-message.h>
#include <melco/shm-interface.h>

#ifdef COUNT_MALLOC
#include <count-malloc.h>
extern int malloc_count;
#endif

int test_to_shm(void);

int
test_to_shm(void)
{
	int i, result;
	char *files[] = {
		/* 1 set/sec */
		"test-data/TSCL20050209-L1-L7.bin",
		/* 10 sets/sec */
		"test-data/TSCS20050209-2sets.bin",
		"test-data/TSCS20050209-2sets.bin",
		"test-data/TSCS20050209-2sets.bin",
		"test-data/TSCS20050209-2sets.bin",
		"test-data/TSCS20050209-2sets.bin",
		/* 1 set/sec */
		"test-data/TSCV20050209-1set.bin",
		NULL
	};

	int j;
	struct timeval tv_before, tv_after;
#ifdef COUNT_MALLOC
	int malloc_count_orig;
	malloc_count_orig = malloc_count;
#endif

	/* fprintf(stderr, "%s\n", __func__); */

	gettimeofday(&tv_before, NULL);
	for(j = 0; j < 500; j++)
		{
			for(i = 0; files[i]; i++)
				{
					FILE *file;
					int c;

					file = fopen(files[i], "r");
					assert(file);
					c = 0;
					while(!feof(file))
						{
							int r;
							MonitorDataMessage *msg;
							msg = MonitorDataMessage_alloc();
							if(!msg)
								{
									fputs("memory exhausted\n", stderr);
									exit(EXIT_FAILURE);
								}
							r = fread_MonitorDataMessage(msg, file, block_fujitsu, 0);
							assert(r == tsc_success || r == tsc_error_nostream);
							if (feof(file)) break;
							c++;
							/* fprintf(stderr, "%s #%d ... ", files[i], c); */
							r = MonitorDataMessage_scan_to_shm(msg, scan_guess_and_all);
							/* fprintf(stderr, "%d insts\n", r); */
							if (r < 0) perror("MonitorDataMessage_scan_to_shm()");
							assert(r >= 0);
						}
					fclose(file);
				}
		}
	gettimeofday(&tv_after, NULL);
	{
		double dt;
		dt = (double) (tv_after.tv_sec - tv_before.tv_sec) + (double) (tv_after.tv_usec - tv_before.tv_usec) * 1e-6;
		fprintf(stderr, "spent %g sec on wall clock: %g writes/sec\n", dt, j/dt);
		result = (10.0*10 < j/dt);	/* 10 samples/sec with 10% CPU usage */
	}
#ifdef COUNT_MALLOC
	assert(malloc_count == malloc_count_orig);
#endif
	return result;
}

int
main(int argc __attribute__((unused)), char *argv[])
{ 
	int r;
  fprintf(stderr, "%s running\n", argv[0]);

	r = test_to_shm();
	instrumentstatus_shm_unlink_all();
	return r ? EXIT_SUCCESS : EXIT_FAILURE;
}
