/* test-message-header.c: test cases for message_header.c */
/*

Copyright (C) 2005 by Daigo Tomono <tomono at subaru.naoj.org>

Permission is granted for use, copying, modification, distribution,
and distribution of modified versions of this work under the terms of
GPL version 2 or later.

*/

/* If we're not using GNU C, elide __attribute__ */
#ifndef __GNUC__
#define  __attribute__(x)  /*NOTHING*/
#endif

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#include <melco/status-types.h>
#include <melco/tsc-message.h>

#ifdef COUNT_MALLOC
#include <count-malloc.h>
#endif

int
main(void)
{
	char data[] = "00A1200502091000004";
	instrument_status_header_s* t;

	t = (instrument_status_header_s*) data;

	assert(instrument_status_header_shortid(t) == 0x00A1);
	assert(!memcmp((char *)instrument_status_header_rxtime(t), "200502091000004", sizeof(ASC15_TIME)));
	return EXIT_SUCCESS;
}

