/* snprintf-compat.c: a function to get length of formatted string */
/*

Copyright (C) 2005 by Daigo Tomono <tomono at subaru.naoj.org>

Permission is granted for use, copying, modification, distribution,
and distribution of modified versions of this work under the terms of
GPL version 2 or later.

*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdarg.h>
#include <malloc.h>
#include <melco/snprintf-compat.h>

#ifdef COUNT_MALLOC
#include <count-malloc.h>
#endif

#define DEF_BUFSIZE 64

int
snprintf_length(const char *format, ...)
{
	int r;
	va_list ap;
	char empty[0], *buf;

	/* try the C99 style */
	va_start(ap, format);
	r = vsnprintf(empty, 0, format, ap);
	va_end(ap);

	/* if it fails, we have to really make the string */
	if (r < 1)
		{
			int bufsize;
			bufsize = DEF_BUFSIZE / 2;
			r = bufsize;
			buf = NULL;
			while(r >= bufsize)
				{
					bufsize *= 2;
					buf = realloc(buf, bufsize);
					if (!buf)	/* memory error */
						{
							r = -1;
							break;
						}
					va_start(ap, format);
					r = vsnprintf(buf, bufsize, format, ap);
					va_end(ap);
				}
			if (buf) free(buf);
		}

	return r;
}
