#
# a python module to handle status data list from bcdpy09
#
# Copyright (C) 2005 by Daigo Tomono <tomono at subaru.naoj.org>
#
# Permission is granted for use, copying, modification, distribution,
# and distribution of modified versions of this work under the terms of
# GPL version 2 or later.
#
# vim: set ts=2 sw=2 ai noet:
#

import re

import mitsubishi

class SwigEntry:
	def __init__(self, name, bits, type, byteoffset, bitoffset, shortid):
		self.name = name
		self.bits = bits
		self.type = type
		self.byteoffset = byteoffset
		self.bitoffset = bitoffset
		self.shortid = shortid

class SwigDevice:
	def __init__(self, type, shortid, data):
		self.type = type
		self.shortid = shortid
		self.data = re.compile(r'//.*').sub('', data)

	def entries(self):
		normalized = self.data
		normalized = re.compile(r'\s*\(.*?\)\s*{[^{]*?}', re.S).sub(' ---CODE---;', normalized)
		normalized = re.compile(r'\s*}\s*;\s*').sub('', normalized)
		normalized = re.compile(r'unsigned\s+').sub('', normalized)
		normalized = re.compile(r':\s+1').sub(':1', normalized)

		byteoffset = 0
		bitoffset = -1
		for line in re.compile(r'\s*(.*?)\s*;', re.S).findall(normalized):
			if line.find('---CODE---') >= 0:
				continue

			# array of char?
			nbytes = 0
			re_brace = re.compile(r'\[(.*?)\]', re.S)
			m = re_brace.search( line )
			if m:
				if m.groups().__len__() > 1:
					raise RuntimeError, 'more than one arrays in %s' % line
				nbytes = eval( m.groups()[0] )
				if nbytes < 1:
					raise RuntimeError, 'strange array length in %s' % line
				line = re_brace.sub( '', line )
				if line.lstrip().find( 'char' ) != 0:
					raise RuntimeError, 'array of non-char in %s' % line

			words = re.compile(r'\s+', re.S | re.M).split(line)
			if len(words) < 2:
				continue
			if words[-1] == ':1':
				# bit field
				words = words[:-1]
				nbytes = 0
				if bitoffset < 0:
					bitoffset = 0
			elif words[0] == 'BIT':
				# bit field of type BIT
				nbytes = 0
				if bitoffset < 0:
					bitoffset = 0
			else:
				# usual data
				if bitoffset > -1:
					byteoffset += 1
				bitoffset = -1
				if nbytes < 1:
					if words[0] == 'char':
						nbytes = 1
					else:
						nbytes = int(re.compile(r'(\d+)').search( words[0] ).groups()[0])

			if len(words) > 1:
				name = words[1]
			else:
				name = None

			if name and name.find('nofill') != 0 and name.find('spare') !=0 and name.find('no_use') < 0:
				if bitoffset < 0:
					nbits = nbytes*8
				else:
					nbits = 1
				yield SwigEntry(name, nbits, self.type, byteoffset, bitoffset, self.shortid)

			if bitoffset < 0:
				byteoffset += nbytes
			else:
				bitoffset += 1
				if bitoffset > 7:
					bitoffset = -1
					byteoffset += 1

class SwigHeader:
	def __init__(self, type, path):
		self.type = type
		self.path = path
		file = open(self.path, 'r')
		s = file.read()
		s = re.compile(r'\s*BCDHEX4\s+indexfin\s+;.*', re.S).sub('', s)
		s = re.compile(r'\s*TSC_HEAD\s+.*?;\s*', re.S).sub('', s)
		self.data = s
		file.close()

	def shortids(self):
		re_shortid_block = re.compile(r'\s*BCDHEX4\s+index([0-9A-F]{4}(?:_\d)?)\s*;\s*ASC15_TIME\s+time\1\s*;\s*', re.S)
		shortid = None
		for x in re_shortid_block.split(self.data):
			if re.compile(r'[0-9A-F]{4}(_\d)?\Z').match(x):
				shortid = re.compile(r'_').sub('-', x)
				skip = True
			elif shortid and shortid.find('0000') != 0:
				yield shortid, SwigDevice(self.type, shortid, x)
				shortid = None

# main
if __name__ == "__main__":
	types = {
		'L':'bcdpy09/tsc_tsclong.swig1.h',
		'S':'bcdpy09/tsc_tscshort.swig1.h',
		'V':'bcdpy09/tsc_tscvstat.swig1.h'
	}
	for type in types.keys():
		path = types[type]
		for shortid, data in SwigHeader(type, path).shortids():
			print "-- %s:%s --" % (type, shortid)
			for entry in data.entries():
				if entry.bitoffset < 0:
					print "%s at %s:%d" % (entry.name, entry.shortid, entry.byteoffset)
				else:
					print "%s at %s:%d:%d" % (entry.name, entry.shortid, entry.byteoffset, entry.bitoffset)


