/* tscstatus.c: a Python module */
/*

Copyright (C) 2005 by Daigo Tomono <tomono at subaru.naoj.org>

Permission is granted for use, copying, modification, distribution,
and distribution of modified versions of this work under the terms of
GPL version 2 or later.

 */

#include <Python.h>

#include <tscstatus.h>
#include <melco/status-hash.h>

static PyMethodDef module_methods[] = {
	{NULL, NULL, 0, NULL}	/* Sentinel */
};

PyObject *P_FileFormatError;	/* malformed header, etc. in input stream */

#ifndef PyMODINIT_FUNC	/* declarations for DLL import/export */
#define PyMODINIT_FUNC void
#endif
PyMODINIT_FUNC inittscstatus(void);

PyMODINIT_FUNC
inittscstatus(void)
{
	PyObject *m;

	m = Py_InitModule3("tscstatus", module_methods, "A module to handle Subaru Telescope Status");
	if (m == NULL) return;

	P_FileFormatError = PyErr_NewException("tscstatus.FileFormatError", NULL, NULL);
	if (P_FileFormatError)
		{
			Py_XINCREF(P_FileFormatError);
			PyModule_AddObject(m, "FileFormatError", P_FileFormatError);
		}

	if (PyType_Ready(&P_StatusBankType) >= 0)
		{
			Py_INCREF(&P_StatusBankType);
			PyModule_AddObject(m, "statusbank", (PyObject *)&P_StatusBankType);
		}
	if (PyType_Ready(&P_SharedStatusType) >= 0)
		{
			Py_INCREF(&P_SharedStatusType);
			PyModule_AddObject(m, "sharedstatus", (PyObject *)&P_SharedStatusType);
		}
	if (PyType_Ready(&P_StatusEntryType) >= 0)
		{
			Py_INCREF(&P_StatusEntryType);
			PyModule_AddObject(m, "statusentry", (PyObject *)&P_StatusEntryType);
		}
	if (PyType_Ready(&P_EntryInfoType) >= 0)
		{
			Py_INCREF(&P_EntryInfoType);
			PyModule_AddObject(m, "entryinfo", (PyObject *)&P_EntryInfoType);
			PyModule_AddIntConstant(m, "entries", melco_status_total());
		}
}
