#!/usr/bin/python

# default source directory
top_srcdir = '..'

# add module paths
import os
import sys
import glob
for d in glob.glob(os.path.join('.', 'build', 'lib*')):
	sys.path.insert(0, d)

# prepare for test
import unittest
import tscstatus

class SharedStatusTestCase(unittest.TestCase):
	def testFind(self):
		d = tscstatus.sharedstatus()
		e = d.entry("TSC Outdoor Wind Velocity")
		assert(0 == e.val())
		assert(0.0 == e.float())
		assert("0.00000000" == e.str())
		assert(1107943200.4 == e.rxtime())
		self.assertRaises(KeyError, d.entry, "no entry")
		assert("Sugai" == d.e("Observer").val())
	def testSingleton(self):
		d = tscstatus.sharedstatus()
		e = tscstatus.sharedstatus()
		f = tscstatus.sharedstatus()
		g = tscstatus.sharedstatus()

if __name__ == "__main__":
	top_srcdir = sys.argv.pop(1)
	unittest.main(testRunner=unittest.TextTestRunner(verbosity=2))
