/* melco/tree-hash.h: header file for status tree generated by makekeywords.py */

#ifndef TREE_HASH_H
#define TREE_HASH_H

/* telescope status index */
struct melco_tree_s {
	/* name/keyword of entry: e.g. 0006E or 00B2L2 */
	char *name;
	/* length in bytes without the 19-byte header */
	int bytes;
	/* data pointer array index */
	int index;
};
struct melco_tree_s *melco_tree_lookup(const char *str, unsigned int len);

#define MELCO_TREE_LENGTH 645
#define MELCO_TREE_MAX_WORD_LENGTH 6

/* short IDs and types of MELCO_TREE_LENGTH elements */
extern unsigned int melco_tree_shortid[];
extern char *melco_tree_type[];

#endif	/* TREE_HASH_H */

