/* melco/status-hash.h: header file for status hash generated by makekeywords.py */

#ifndef STATUS_HASH_H
#define STATUS_HASH_H

/* telescope status entry */
struct melco_status_s {
	/* name/keyword of entry */
	char *name;
	/* E, S, L, L2, or L3 */
	char *type;
	/* instrument ID */
	unsigned int shortid;
	/* status ID */
	unsigned int id;
	/* offset in bytes from the instrument data head */
	int offset;
	/* length of data (1 for a bitfield) */
	int bytes;
	/* mask to extract bitfield information (0 otherwise) */
	unsigned char mask;
	/* function to extract the double value */
	void* (*to_d)(const void *addr, const unsigned char mask, const size_t length, void *dst);
	/* function to extract the int value */
	void* (*to_i)(const void *addr, const unsigned char mask, const size_t length, void *dst);
	/* function to extract the char* string, and its length (add 1 for buffer) */
	void* (*to_s)(const void *addr, const unsigned char mask, const size_t length, void *dst);
	int (*to_s_length)(const void *addr, const unsigned char mask, const size_t length, void *dst);
	/* function to extract the struct timeval value */
	void* (*to_t)(const void *addr, const unsigned char mask, const size_t length, void *dst);
};
struct melco_status_s* melco_status_lookup(const char *str, unsigned int len);
struct melco_status_s* melco_status_ith(const int i);
int melco_status_word_len_max(void);
int melco_status_total(void);

#endif	/* STATUS_HASH_H */

/* available keywords: keyword	[type-shortid byte:bit-offset id (format)] */
/*
  Dome Position Mode	[E-0001 0:0 000100D]
  Dome Test Mode	[E-0001 0:1 000100E]
  Dome Slew Mode	[E-0001 0:2 0001066]
  Dome S/W Slave Limit +	[E-0001 3:0 0001011]
  Dome Drive On	[E-0001 3:1 0001012]
  Dome Drive Off	[E-0001 3:2 0001013]
  DCDLCL Power On	[E-0001 3:3 0001014]
  DCDLCL Power Off	[E-0001 3:4 0001015]
  Dome Drive On Ready	[E-0001 3:5 0001057]
  Dome S/W Slave Limit -	[E-0001 3:6 0001067]
  Dome Cable Overlap +	[E-0001 4:0 0001016]
  Dome Cable Overlap -	[E-0001 4:1 0001017]
  Dome 1st Limit +	[E-0001 4:2 0001018]
  Dome 1st Limit -	[E-0001 4:3 0001019]
  Dome 2nd Limit +	[E-0001 4:4 000101A]
  Dome 2nd Limit -	[E-0001 4:5 000101B]
  Dome Limit Reset +	[E-0001 5:0 000101C]
  Dome Limit Reset -	[E-0001 5:1 000101D]
  Safety SW1(SS1)	[E-0001 6:0 000101E]
  Safety SW2(SS2)	[E-0001 6:1 000101F]
  Safety SW3(SS3)	[E-0001 6:2 0001020]
  Safety SW4(SS4)	[E-0001 6:3 0001021]
  Safety SW5(SS5)	[E-0001 7:0 0001022]
  Safety SW6(SS6)	[E-0001 7:1 0001023]
  Safety SW7(SS7)	[E-0001 7:2 0001024]
  Safety SW8(SS8)	[E-0001 7:3 0001025]
  Safety SW9(SS9)	[E-0001 8:0 0001026]
  Safety SW10(SS10)	[E-0001 8:1 0001027]
  Safety SW11(SS11)	[E-0001 8:2 0001028]
  Safety SW12(SS12)	[E-0001 8:3 0001029]
  Safety SW13(SS13)	[E-0001 9:0 000102A]
  Safety SW14(SS14)	[E-0001 9:1 000102B]
  Safety SW15(SS15)	[E-0001 9:2 000102C]
  Exit Door(IR) Open(DL51)	[E-0001 10:0 000102D]
  Exit Door(Opt) Open(DL52)	[E-0001 10:1 000102E]
  EMER SW1(ES1)	[E-0001 11:0 000102F]
  EMER SW2(ES2)	[E-0001 11:1 0001030]
  EMER SW3(ES3)	[E-0001 11:2 0001031]
  EMER SW4(ES4)	[E-0001 11:3 0001032]
  EMER SW5(ES5)	[E-0001 11:4 0001033]
  Mirror Hatch Open	[E-0001 12:0 0001034]
  Crane Not Hook Up	[E-0001 12:1 0001035]
  Hoist Not Hook Up	[E-0001 12:2 0001036]
  DCDLCL IR DPA Fault	[E-0001 13:0 0001068]
  DCDLCL Opt DPA Fault	[E-0001 14:0 0001037]
  Dome ENCDR Alarm	[E-0001 15:0 000103D]
  CP1 Master Local Selected	[E-0001 16:0 000103E]
  CP1 Master Off Selected	[E-0001 16:1 000103F]
  CP1 Master Remote Selected	[E-0001 16:2 0001040]
  CP1 Master Ready	[E-0001 17:0 0001041]
  CP1 Dome Rotation Local	[E-0001 18:0 0001042]
  CP1 Dome Rotation Off	[E-0001 18:1 0001043]
  CP1 Dome Rotation Remote	[E-0001 18:2 0001044]
  CP1 Dome Rotation Ready	[E-0001 19:0 0001045]
  CP1 DRPU VEL Selected	[E-0001 20:0 0001046]
  CP1 DRPU TRQ Selected	[E-0001 20:1 0001047]
  CP1 EXT CMPTR VEL Selected	[E-0001 20:2 0001048]
  DCDCU Drive Safety	[E-0001 21:0 0001049]
  DRPU Fault	[E-0001 22:0 000104A]
  DRPU Total Fan Alarm	[E-0001 22:1 000104B]
  DLCL-DRPU Alarm	[E-0001 22:2 000104C]
  DRPU Local	[E-0001 22:3 000104D]
  DRPU MAINT	[E-0001 22:4 000104E]
  DCDCU-DRPU Alarm	[E-0001 22:5 0001038]
  MLP1-Dome Alarm	[E-0001 23:0 000104F]
  Mount-Dome Alarm	[E-0001 23:1 0001050]
  Dome Fault	[E-0001 24:0 0001055]
  DCDCU Total Fan Alarm	[E-0001 24:1 0001056]
  DRPU-Dome Alarm	[E-0001 24:2 0001052]
  Dome Local	[E-0001 24:3 0001053]
  Dome MAINT	[E-0001 24:4 0001054]
  Dome 1st Slave Limit +	[E-0001 25:0 0001058]
  Dome 1st Slave Limit -	[E-0001 25:1 0001059]
  AZ MAINT Door1	[E-0001 25:2 000105A]
  AZ MAINT Door2	[E-0001 25:3 000105B]
  IR VME Door Open on DRDR	[E-0001 25:4 000105C]
  Opt VME Door Open on DRDR	[E-0001 25:5 000105D]
  AZ Fix Pin On(From Dome)	[E-0001 25:6 000105E]
  AZ Fix Pin Handle(From Dome)	[E-0001 25:7 000105F]
  Dome EMER Stop	[E-0001 26:0 0001060]
  DCDLCL PLC Alarm	[E-0001 26:1 0001061]
  COML PWR Fault on DRDR	[E-0001 26:2 0001062]
  Dome 2nd Slave Limit +	[E-0001 26:3 0001063]
  Dome 2nd Slave Limit -	[E-0001 26:4 0001064]
  DCDRPU EMER Stop	[E-0001 26:6 0001065]
  DCDCU EXT CLK Alarm	[E-0001 27:0 0001039]
  DCDRPU EXT CLK Alarm	[E-0001 27:1 0001075]
  Dome Control MLP1 Master	[E-0001 28:0 000103A]
  Dome Control Dome Master	[E-0001 28:1 000103B]
  Dome Control DRPU Master	[E-0001 28:2 000103C]
  Dome Control DLCL Master	[E-0001 28:3 0001051]
  Dome Control Mount Master	[E-0001 28:4 0001070]
  Mount-Dome Local SYNC on DRDR	[E-0001 29:0 0001071]
  Mount-Dome Local ASYNC on DRDR	[E-0001 29:1 0001072]
  Mount-Dome Remote SYNC on DRDR	[E-0001 29:2 0001073]
  Mount-Dome Remote ASYNC on DRDR	[E-0001 29:3 0001074]
  Dome Interlock	[E-0001 30:0 0001076]
  Hydrostatic Alarm	[E-0001 30:1 0001077]
  Dome Test Pattern	[E-0001 47 000100F BCD1]
  Dome Test Result	[E-0001 48 0001010 BCD1]
  Dome Loop Test Ready	[E-0001 48:0 000106C]
  Dome Loop Testing	[E-0001 48:1 000106D]
  Dome Loop Test Data Send	[E-0001 48:2 000106E]
  Dome Loop Test Last Data	[E-0001 48:3 000106F]
  Dome Rate REF	[L-0001 12 0001004 BCD6]
  Dome Rate FDBK-1	[L-0001 18 0001005 BCD6]
  Dome Rate FDBK-2	[L-0001 24 0001006 BCD6]
  Dome Rate FDBK-3	[L-0001 30 0001007 BCD6]
  Dome Rate FDBK-4	[L-0001 36 0001008 BCD6]
  Dome Current REF-1	[L-0001 42 0001009 BCD6]
  Dome Current REF-2	[L-0001 48 000100A BCD6]
  Dome Current REF-3	[L-0001 54 000100B BCD6]
  Dome Current REF-4	[L-0001 60 000100C BCD6]
  Dome Data SMPLG Time ANS	[L-0001 66 0001069 BCD6]
  Dome CMD VEL ANS	[L-0001 72 000106A BCD6]
  Dome Data SMPLG INTVL	[L-0001 78 000106B BCD6]
  Dome Real Angle	[S-0001 0 0001001 BCD6]
  Dome CMD Angle	[S-0001 6 0001002 BCD6]
  Dome Angle Error	[S-0001 12 0001003 BCD6]
  Mount Pointing Mode	[E-0002 0:0 0002022]
  Mount Open Tracking Mode	[E-0002 0:1 0002023]
  Mount Auto Guiding Mode	[E-0002 0:2 0002024]
  Mount Slew Mode	[E-0002 0:3 0002025]
  Mount Test Mode	[E-0002 0:4 0002026]
  AZ Drive On	[E-0002 3:0 0002029]
  AZ Drive Off	[E-0002 3:1 000202A]
  AZ Drive On Ready	[E-0002 3:2 0002028]
  EL Drive On	[E-0002 3:3 000202C]
  EL Drive Off	[E-0002 3:4 000202D]
  EL Drive On Ready	[E-0002 3:5 000202B]
  AZ Single Drive	[E-0002 4:0 00020F7]
  EL Single Drive	[E-0002 4:1 00020F8]
  Mount-Dome Local SYNC on MTDR	[E-0002 5:0 00020F2]
  Mount-Dome Local ASYNC on MTDR	[E-0002 5:1 00020F3]
  Mount-Dome Remote SYNC on MTDR	[E-0002 5:2 0002061]
  Mount-Dome Remote ASYNC on MTDR	[E-0002 5:3 0002062]
  AZ/EL Limit Reset	[E-0002 6:0 00020F9]
  TSC COML PWR Fault on MTDR	[E-0002 6:4 000202E]
  AZ Fix Pin Position	[E-0002 7:0 0002037]
  AZ Fix Pin On	[E-0002 7:1 0002030]
  AZ Fix Pin Off	[E-0002 7:2 0002032]
  AZ Fix Pin  On Ready	[E-0002 7:3 000202F]
  AZ Fix Pin  Off Ready	[E-0002 7:4 0002031]
  AZ Fix Pin Alarm	[E-0002 7:5 000203A]
  EL Stow Pins Position(90) Selected	[E-0002 8:0 0002038]
  EL Stow Pins Position(15) Selected	[E-0002 8:1 0002039]
  EL Stow Pins On(From Mount)	[E-0002 8:2 0002034]
  EL Stow Pins Off(From Mount)	[E-0002 8:3 0002036]
  EL Stow Pins On Ready(From Mount)	[E-0002 8:4 0002033]
  EL Stow Pins Off Ready(From Mount)	[E-0002 8:5 0002035]
  EL Stow Pins Alarm	[E-0002 8:6 000203B]
  AZ 1st Limit +	[E-0002 9:0 000203C]
  AZ 1st Limit -	[E-0002 9:1 000203D]
  AZ 2nd Limit +	[E-0002 9:2 000203E]
  AZ 2nd Limit -	[E-0002 9:3 000203F]
  AZ Cable Overlap + 1	[E-0002 9:4 0002040]
  AZ Cable Overlap - 1	[E-0002 9:5 0002041]
  AZ 3rd Limit +	[E-0002 9:6 0002130]
  AZ 3rd Limit -	[E-0002 9:7 0002131]
  EL 1st Limit Up	[E-0002 10:0 0002042]
  EL 1st Limit Down	[E-0002 10:1 0002043]
  EL 2nd Limit Up	[E-0002 10:2 0002044]
  EL 2nd Limit Down	[E-0002 10:3 0002045]
  Mount Drive Safety	[E-0002 11:0 0002046]
  Mount Safety2	[E-0002 11:1 00020EA]
  Mount Safety3	[E-0002 11:2 00020EB]
  Mount Safety4	[E-0002 11:3 00020EC]
  Mount Safety5	[E-0002 11:4 00020ED]
  Mount Safety6	[E-0002 11:5 00020EE]
  Mount Safety7	[E-0002 11:6 00020EF]
  Mount Safety8	[E-0002 11:7 00020F0]
  AZ DCPA Fault	[E-0002 12:0 0002047]
  TCDCPA Fault	[E-0002 12:1 00020B3]
  TCDPA2(MCU) Fault	[E-0002 12:2 00020B4]
  AZ DPA-1A Alarm	[E-0002 13:0 0002048]
  AZ DPA-1B Alarm	[E-0002 13:1 0002049]
  AZ DPA-2A Alarm	[E-0002 13:2 000204A]
  AZ DPA-2B Alarm	[E-0002 13:3 000204B]
  EL DCPA Fault	[E-0002 14:0 000204C]
  EL DPA-1A Alarm	[E-0002 15:0 000204D]
  EL DPA-1B Alarm	[E-0002 15:1 000204E]
  EL DPA-2A Alarm	[E-0002 15:2 000204F]
  EL DPA-2B Alarm	[E-0002 15:3 0002050]
  EL DPA-3A Alarm	[E-0002 15:4 0002051]
  EL DPA-3B Alarm	[E-0002 15:5 0002052]
  EL DPA-4A Alarm	[E-0002 15:6 0002053]
  EL DPA-4B Alarm	[E-0002 15:7 0002054]
  AZ DPA-1A Not Used	[E-0002 16:0 0002055]
  AZ DPA-1B Not Used	[E-0002 16:1 0002056]
  AZ DPA-2A Not Used	[E-0002 16:2 0002057]
  AZ DPA-2B Not Used	[E-0002 16:3 0002058]
  EL DPA-1A Not Used	[E-0002 17:0 0002059]
  EL DPA-1B Not Used	[E-0002 17:1 000205A]
  EL DPA-2A Not Used	[E-0002 17:2 000205B]
  EL DPA-2B Not Used	[E-0002 17:3 000205C]
  EL DPA-3A Not Used	[E-0002 17:4 000205D]
  EL DPA-3B Not Used	[E-0002 17:5 000205E]
  EL DPA-4A Not Used	[E-0002 17:6 000205F]
  EL DPA-4B Not Used	[E-0002 17:7 0002060]
  Mount Local	[E-0002 18:0 0002065]
  Mount Total Fan Alarm	[E-0002 19:0 0002063]
  TRQ Total Fan Alarm	[E-0002 19:1 0002064]
  AZ ABS ENCDR-1 Alarm	[E-0002 20:0 0002066]
  AZ ABS ENCDR-2 Alarm	[E-0002 20:1 0002067]
  AZ ABS ENCDR-3 Alarm	[E-0002 20:2 0002068]
  AZ ABS ENCDR-4 Alarm	[E-0002 20:3 0002069]
  AZ ABS ENCDR-5 Alarm	[E-0002 20:4 000206A]
  AZ ABS ENCDR-6 Alarm	[E-0002 20:5 000206B]
  AZ ABS ENCDR-7 Alarm	[E-0002 20:6 000206C]
  AZ ABS ENCDR-8 Alarm	[E-0002 20:7 000206D]
  AZ INC ENCDR-1 Alarm	[E-0002 21:0 0002076]
  AZ INC ENCDR-2 Alarm	[E-0002 21:1 0002077]
  AZ INC ENCDR-3 Alarm	[E-0002 21:2 0002078]
  AZ INC ENCDR-4 Alarm	[E-0002 21:3 0002079]
  AZ INC ENCDR-5 Alarm	[E-0002 21:4 000207A]
  AZ INC ENCDR-6 Alarm	[E-0002 21:5 000207B]
  AZ INC ENCDR-7 Alarm	[E-0002 21:6 000207C]
  AZ INC ENCDR-8 Alarm	[E-0002 21:7 000207D]
  EL ABS ENCDR-1 Alarm	[E-0002 22:0 0002086]
  EL ABS ENCDR-2 Alarm	[E-0002 22:1 0002087]
  EL ABS ENCDR-3 Alarm	[E-0002 22:2 0002088]
  EL ABS ENCDR-4 Alarm	[E-0002 22:3 0002089]
  EL ABS ENCDR-5 Alarm	[E-0002 22:4 000208A]
  EL ABS ENCDR-6 Alarm	[E-0002 22:5 000208B]
  EL ABS ENCDR-7 Alarm	[E-0002 22:6 000208C]
  EL ABS ENCDR-8 Alarm	[E-0002 22:7 000208D]
  EL INC ENCDR-1 Alarm	[E-0002 23:0 0002096]
  EL INC ENCDR-2 Alarm	[E-0002 23:1 0002097]
  EL INC ENCDR-3 Alarm	[E-0002 23:2 0002098]
  EL INC ENCDR-4 Alarm	[E-0002 23:3 0002099]
  EL INC ENCDR-5 Alarm	[E-0002 23:4 000209A]
  EL INC ENCDR-6 Alarm	[E-0002 23:5 000209B]
  EL INC ENCDR-7 Alarm	[E-0002 23:6 000209C]
  EL INC ENCDR-8 Alarm	[E-0002 23:7 000209D]
  Mount MAINT	[E-0002 24:0 00020A6]
  Opt VME Door Open on MTDR	[E-0002 24:1 00020A7]
  IR VME Door Open on MTDR	[E-0002 24:2 00020A8]
  AZ MAINT Door1 Open	[E-0002 24:3 00020A9]
  AZ MAINT Door2 Open	[E-0002 24:4 00020AA]
  TCDCPA MAINT	[E-0002 24:5 00020AB]
  TORQUE MAINT	[E-0002 24:6 00020AC]
  AZ 1st Slave Limit +	[E-0002 25:0 00020AD]
  AZ 1st Slave Limit -	[E-0002 25:1 00020AE]
  AZ 2nd Slave Limit +	[E-0002 25:2 00020AF]
  AZ 2nd Slave Limit -	[E-0002 25:3 00020B0]
  Mount EMER Stop ANS	[E-0002 26:2 00020B9]
  MLP1-Mount Alarm	[E-0002 27:0 00020B5]
  MLP2-Mount Alarm	[E-0002 27:1 00020B6]
  Dome-Mount Alarm	[E-0002 27:2 00020B7]
  TRQ-Mount Alarm	[E-0002 27:3 00020B8]
  Balancer-Torque Alarm on MTDR	[E-0002 27:4 00020BB]
  Mount-Torque Alarm	[E-0002 27:5 00020BC]
  SPU5(NsIR)-Mount Alarm	[E-0002 27:6 00020FA]
  AZ Cable Drive On	[E-0002 28:0 00020C8]
  AZ Cable Drive Off	[E-0002 28:1 00020CB]
  AZ Cable Drive On Ready	[E-0002 28:2 00020C5]
  EL Cable(IR) Drive On	[E-0002 28:4 00020C9]
  EL Cable(IR) Drive Off	[E-0002 28:5 00020CC]
  EL Cable(IR) Drive On Ready	[E-0002 28:6 00020C6]
  AZ Cable Slave Warning +	[E-0002 29:0 00020D6]
  AZ Cable Slave Warning -	[E-0002 29:1 00020D7]
  AZ Cable 1st Slave Limit +	[E-0002 29:2 00020B1]
  AZ Cable 1st Slave Limit -	[E-0002 29:3 00020B2]
  AZ Cable 2nd Slave Limit +	[E-0002 29:4 00020DC]
  AZ Cable 2nd Slave Limit -	[E-0002 29:5 00020DD]
  AZ Cable S/W Slave Limit +	[E-0002 29:6 00020CE]
  AZ Cable S/W Slave Limit -	[E-0002 29:7 00020CF]
  EL Cable(IR) Slave Warning Up	[E-0002 30:0 00020D0]
  EL Cable(IR) Slave Warning Down	[E-0002 30:1 00020D1]
  EL Cable(IR) 1st Slave Limit Up	[E-0002 30:2 00020DA]
  EL Cable(IR) 1st Slave Limit Down	[E-0002 30:3 00020DB]
  EL Cable(IR) 2nd Slave Limit Up	[E-0002 30:4 00020E0]
  EL Cable(IR) 2nd Slave Limit Down	[E-0002 30:5 00020E1]
  EL Cable(IR) S/W SL Limit Up	[E-0002 30:6 00020D2]
  EL Cable(IR) S/W Slave Limit Down	[E-0002 30:7 00020D3]
  EL Cable(Opt) Slave Warning Up	[E-0002 31:0 00020D4]
  EL Cable(Opt) Slave Warning Down	[E-0002 31:1 00020D5]
  EL Cable(Opt) 1st Slave Limit Up	[E-0002 31:2 00020D8]
  EL Cable(Opt) 1st Slave Limit Down	[E-0002 31:3 00020D9]
  EL Cable(Opt) 2nd Slave Limit Up	[E-0002 31:4 00020DE]
  EL Cable(Opt) 2nd Slave Limit Down	[E-0002 31:5 00020DF]
  EL Cable(Opt) S/W Slave Limit Up	[E-0002 31:6 00020E9]
  EL Cable(Opt) S/W Slave Limit Down	[E-0002 31:7 00020F1]
  Torque Slave Warning Up	[E-0002 32:0 00020F4]
  Torque Slave Warning Down	[E-0002 32:1 00020FB]
  AZ Twister DPA Fault	[E-0002 33:0 00020E2]
  EL Twister(IR) DPA Fault	[E-0002 33:1 00020FC]
  EL Twister(Opt) DPA Fault	[E-0002 33:2 00020E3]
  Torque DPA Fault	[E-0002 33:3 0002133]
  Torque Fault	[E-0002 33:4 0002134]
  TCDPA1(Torque) Fault	[E-0002 33:5 0002135]
  Torque Panel Alarm	[E-0002 33:6 00020BA]
  Torque Local on MTDR	[E-0002 34:0 00020E7]
  Balancer Test on MTDR	[E-0002 34:1 00020E8]
  Torque Limit Reset	[E-0002 34:2 00020FD]
  AZ ABS ENCDR-1 Not Used	[E-0002 35:0 000206E]
  AZ ABS ENCDR-2 Not Used	[E-0002 35:1 000206F]
  AZ ABS ENCDR-3 Not Used	[E-0002 35:2 0002070]
  AZ ABS ENCDR-4 Not Used	[E-0002 35:3 0002071]
  AZ ABS ENCDR-5 Not Used	[E-0002 35:4 0002072]
  AZ ABS ENCDR-6 Not Used	[E-0002 35:5 0002073]
  AZ ABS ENCDR-7 Not Used	[E-0002 35:6 0002074]
  AZ ABS ENCDR-8 Not Used	[E-0002 35:7 0002075]
  AZ INC ENCDR-1 Not Used	[E-0002 36:0 000207E]
  AZ INC ENCDR-2 Not Used	[E-0002 36:1 000207F]
  AZ INC ENCDR-3 Not Used	[E-0002 36:2 0002080]
  AZ INC ENCDR-4 Not Used	[E-0002 36:3 0002081]
  AZ INC ENCDR-5 Not Used	[E-0002 36:4 0002082]
  AZ INC ENCDR-6 Not Used	[E-0002 36:5 0002083]
  AZ INC ENCDR-7 Not Used	[E-0002 36:6 0002084]
  AZ INC ENCDR-8 Not Used	[E-0002 36:7 0002085]
  EL ABS ENCDR-1 Not Used	[E-0002 37:0 000208E]
  EL ABS ENCDR-2 Not Used	[E-0002 37:1 000208F]
  EL ABS ENCDR-3 Not Used	[E-0002 37:2 0002090]
  EL ABS ENCDR-4 Not Used	[E-0002 37:3 0002091]
  EL ABS ENCDR-5 Not Used	[E-0002 37:4 0002092]
  EL ABS ENCDR-6 Not Used	[E-0002 37:5 0002093]
  EL ABS ENCDR-7 Not Used	[E-0002 37:6 0002094]
  EL ABS ENCDR-8 Not Used	[E-0002 37:7 0002095]
  EL INC ENCDR-1 Not Used	[E-0002 38:0 000209E]
  EL INC ENCDR-2 Not Used	[E-0002 38:1 000209F]
  EL INC ENCDR-3 Not Used	[E-0002 38:2 00020A0]
  EL INC ENCDR-4 Not Used	[E-0002 38:3 00020A1]
  EL INC ENCDR-5 Not Used	[E-0002 38:4 00020A2]
  EL INC ENCDR-6 Not Used	[E-0002 38:5 00020A3]
  EL INC ENCDR-7 Not Used	[E-0002 38:6 00020A4]
  EL INC ENCDR-8 Not Used	[E-0002 38:7 00020A5]
  AZ ABS ENCDR Not INIT	[E-0002 160:0 00020FF]
  AZ ABS ENCDR Not Zeroed	[E-0002 160:1 0002100]
  AZ ABS ENCDR Zeroing	[E-0002 160:2 0002101]
  AZ ABS ENCDR Not COMPEN PROC	[E-0002 160:3 0002102]
  AZ ABS ENCDR COMPEN PROC RUN	[E-0002 160:4 0002103]
  EL ABS ENCDR Not INIT	[E-0002 161:0 0002104]
  EL ABS ENCDR Not Zeroed	[E-0002 161:1 0002105]
  EL ABS ENCDR Zeroing	[E-0002 161:2 0002106]
  EL ABS ENCDR Not COMPEN PROC	[E-0002 161:3 0002107]
  EL ABS ENCDR COMPEN PROC RUN	[E-0002 161:4 0002108]
  EL Stow Pins1 Handle	[E-0002 162:0 00020FE]
  EL Stow Pins2 Handle	[E-0002 162:1 0002109]
  AZ Fix Pin Handle	[E-0002 162:2 000210A]
  Oil Pressure CB Off	[E-0002 162:3 000210B]
  Low Pressure Alarm	[E-0002 162:4 000210C]
  Mount Fault	[E-0002 163:0 000210D]
  Mount OEU Fault	[E-0002 163:1 000210E]
  TCADU1(Mount) Fault	[E-0002 163:2 000210F]
  TCADU2(Mount) Fault	[E-0002 163:3 0002110]
  TCADU3(ASCU) Fault	[E-0002 163:4 0002111]
  TCSPU2/5(NsIR) Fault (Mount IND)	[E-0002 163:5 0002112]
  TCSPU3/6(NsOpt) Fault (Mount IND)	[E-0002 163:6 0002113]
  TCMCU EXT CLK Alarm	[E-0002 163:7 0002114]
  EL Cable(Opt) Drive On	[E-0002 164:0 0002115]
  EL Cable(Opt) Drive Off	[E-0002 164:1 0002116]
  EL Cable(Opt) Drive On Ready	[E-0002 164:2 0002117]
  TRQ Detector Drive On	[E-0002 164:4 00020CA]
  TRQ Detecotr Drive Off	[E-0002 164:5 00020CD]
  TRQ Detector Drive On Ready	[E-0002 164:6 00020C7]
  EL Cable-Torque SYNC	[E-0002 165:0 0002118]
  AZ Cable Overlap + 2	[E-0002 165:1 0002119]
  AZ Cable Overlap - 2	[E-0002 165:2 000211A]
  Torque Drive Safety	[E-0002 166:0 000211B]
  AZ Cable Handle	[E-0002 166:1 000211C]
  EL Cable(IR) Handle	[E-0002 166:2 000211D]
  EL Cable(Opt) Handle	[E-0002 166:3 000211E]
  Torque Handle	[E-0002 166:4 000211F]
  Torque Alarm	[E-0002 166:5 0002120]
  Cover Position Alarm	[E-0002 166:6 0002121]
  AZ/EL Not Drive Permissive	[E-0002 166:7 0002132]
  TCCTCU EMER Stop	[E-0002 167:0 0002122]
  COML PWR Fault	[E-0002 167:1 0002123]
  TCSPU2/5(NsIR) Fault (CTCU IND)	[E-0002 167:2 0002124]
  TCSPU3/6(NsOpt) Fault (CTCU IND)	[E-0002 167:3 0002125]
  TCCTCU EXT CLK Alarm	[E-0002 167:4 0002126]
  UPS1 Alarm (Mount IND)	[E-0002 167:5 0002136]
  UPS2 Alarm (Mount IND)	[E-0002 167:6 0002137]
  MLP1 Master	[E-0002 168:0 0002127]
  DCU Master	[E-0002 168:1 0002128]
  DRPU Master	[E-0002 168:2 0002129]
  DLCL Master	[E-0002 168:3 000212A]
  Mount Master	[E-0002 168:4 000212B]
  Mount S/D REF Alarm	[E-0002 169:0 000213A]
  AZ CRS Alarm	[E-0002 169:1 000213B]
  AZ FINE Alarm	[E-0002 169:2 000213C]
  EL CRS Alarm	[E-0002 169:3 000213D]
  EL FINE Alarm	[E-0002 169:4 000213E]
  AZ S/D ENCDR Selected	[E-0002 170:0 000213F]
  EL S/D ENCDR Selected	[E-0002 170:1 0002140]
  AZ BIT3 I/F Fault	[E-0002 171:0 0002141]
  AZ BIT3 PT INT	[E-0002 171:1 0002142]
  AZ BIT3 I/F TImeout	[E-0002 171:2 0002143]
  AZ BIT3 LRC Error	[E-0002 171:3 0002144]
  AZ BIT3 PR INT	[E-0002 171:5 0002145]
  AZ BIT3 BUS Error	[E-0002 171:6 0002146]
  AZ BIT3 Parity Error	[E-0002 171:7 0002147]
  EL BIT3 I/F Fault	[E-0002 172:0 0002148]
  EL BIT3 PT INT	[E-0002 172:1 0002149]
  EL BIT3 I/F Timeout	[E-0002 172:2 000214A]
  EL BIT3 LRC Error	[E-0002 172:3 000214B]
  EL BIT3 PR INT	[E-0002 172:5 000214C]
  EL BIT3 BUS Error	[E-0002 172:6 000214D]
  EL BIT3 Parity Error	[E-0002 172:7 000214F]
  AZ ABS ENCDR COMPEN Write	[E-0002 173:0 0002151]
  AZ ABS ENCDR COMPEN Read	[E-0002 173:1 0002150]
  AZ ABS ENCDR COMPEN Save	[E-0002 173:2 0002152]
  ABS ENCDR Terminal I/F	[E-0002 173:3 0002153]
  EL ABS ENCDR COMPEN Write	[E-0002 174:0 0002155]
  EL ABS ENCDR COMPEN Read	[E-0002 174:1 0002154]
  EL ABS ENCDR COMPEN Save	[E-0002 174:2 0002166]
  AZ ABS CH1 COMPEN RAM Data Invalid	[E-0002 175:0 0002156]
  AZ ABS CH2 COMPEN RAM Data Invalid	[E-0002 175:1 0002157]
  AZ ABS CH3 COMPEN RAM Data Invalid	[E-0002 175:2 0002158]
  AZ ABS CH4 COMPEN RAM Data Invalid	[E-0002 175:3 0002159]
  AZ ABS CH5 COMPEN RAM Data Invalid	[E-0002 175:4 000215A]
  AZ ABS CH6 COMPEN RAM Data Invalid	[E-0002 175:5 000215B]
  AZ ABS CH7 COMPEN RAM Data Invalid	[E-0002 175:6 000215C]
  AZ ABS CH8 COMPEN RAM Data Invalid	[E-0002 175:7 000215D]
  EL ABS CH1 COMPEN RAM Data Invalid	[E-0002 176:0 000215E]
  EL ABS CH2 COMPEN RAM Data Invalid	[E-0002 176:1 000215F]
  EL ABS CH3 COMPEN RAM Data Invalid	[E-0002 176:2 0002160]
  EL ABS CH4 COMPEN RAM Data Invalid	[E-0002 176:3 0002161]
  EL ABS CH5 COMPEN RAM Data Invalid	[E-0002 176:4 0002162]
  EL ABS CH6 COMPEN RAM Data Invalid	[E-0002 176:5 0002163]
  EL ABS CH7 COMPEN RAM Data Invalid	[E-0002 176:6 0002164]
  EL ABS CH8 COMPEN RAM Data Invalid	[E-0002 176:7 0002165]
  Mount Test Pattern ANS	[E-0002 238 000212C BCD1]
  Mount Test Result	[E-0002 239 0002027 BCD1]
  Mount Test Ready	[E-0002 239:0 000212E]
  Mount Test	[E-0002 239:1 000212F]
  Mount Test Data Send	[E-0002 239:2 00020E4]
  Mount Test Data End	[E-0002 239:3 00020E5]
  AZ Rate REF	[L-0002 24 0002007 BCD6]
  EL Rate REF	[L-0002 30 0002008 BCD6]
  AZ Rate FDBK-1A	[L-0002 48 000200A BCD6]
  AZ Rate FDBK-1B	[L-0002 54 000200B BCD6]
  AZ Rate FDBK-2A	[L-0002 60 000200C BCD6]
  AZ Rate FDBK-2B	[L-0002 66 000200D BCD6]
  EL Rate FDBK-1A	[L-0002 72 000200E BCD6]
  EL Rate FDBK-1B	[L-0002 78 000200F BCD6]
  EL Rate FDBK-2A	[L-0002 84 0002010 BCD6]
  EL Rate FDBK-2B	[L-0002 90 0002011 BCD6]
  EL Rate FDBK-3A	[L-0002 96 0002012 BCD6]
  EL Rate FDBK-3B	[L-0002 102 0002013 BCD6]
  EL Rate FDBK-4A	[L-0002 108 0002014 BCD6]
  EL Rate FDBK-4B	[L-0002 114 0002015 BCD6]
  AZ Current REF-1A	[L-0002 120 0002016 BCD6]
  AZ Current REF-1B	[L-0002 126 0002017 BCD6]
  AZ Current REF-2A	[L-0002 132 0002018 BCD6]
  AZ Current REF-2B	[L-0002 138 0002019 BCD6]
  EL Current REF-1A	[L-0002 144 000201A BCD6]
  EL Current REF-1B	[L-0002 150 000201B BCD6]
  EL Current REF-2A	[L-0002 156 000201C BCD6]
  EL Current REF-2B	[L-0002 162 000201D BCD6]
  EL Current REF-3A	[L-0002 168 000201E BCD6]
  EL Current REF-3B	[L-0002 174 000201F BCD6]
  EL Current REF-4A	[L-0002 180 0002020 BCD6]
  EL Current REF-4B	[L-0002 186 0002021 BCD6]
  AZ Cable Real Angle	[L-0002 198 00020BD BCD6]
  EL Cable(IR) Real Angle	[L-0002 204 00020BE BCD6]
  EL Cable(Opt) Real Angle	[L-0002 210 00020BF BCD6]
  Torque Detector Real Angle	[L-0002 216 00020C0 BCD6]
  AZ Cable Position Error	[L-0002 222 00020C1 BCD6]
  EL Cable(IR) Position Error	[L-0002 228 00020C2 BCD6]
  EL Cable(Opt) Position Error	[L-0002 234 00020C3 BCD6]
  TRQ Detector Position Error	[L-0002 240 00020C4 BCD6]
  Mount Data SMPLG Time ANS	[L-0002 246 0002009 BCD6]
  Mount CMD VEL ANS	[L-0002 252 000212D BCD6]
  Mount Data SMPLG INTVL	[L-0002 258 00020E6 BCD6]
  AZ Real Angle	[S-0002 0 0002001 BCD6]
  EL Real Angle	[S-0002 6 0002002 BCD6]
  AZ CMD Angle ANS	[S-0002 12 0002003 BCD6]
  EL CMD Angle ANS	[S-0002 18 0002004 BCD6]
  AZ Position Error	[S-0002 24 0002005 BCD6]
  EL Position Error	[S-0002 30 0002006 BCD6]
  AZ Auto Guide Offset CMD	[S-0002 36 00020F5 BCD6]
  EL Auto Guide Offset CMD	[S-0002 42 00020F6 BCD6]
  AZ Auto Guide Offset Real	[S-0002 48 0002138 BCD6]
  EL Auto Guide Offset Real	[S-0002 54 0002139 BCD6]
  SP Drive On	[E-0003 0:0 000301D]
  SP Drive Off	[E-0003 0:1 000301E]
  L1 Drive On	[E-0003 1:0 000301F]
  L1 Drive Off	[E-0003 1:1 0003020]
  L2 Drive On	[E-0003 1:2 0003021]
  L2 Drive Off	[E-0003 1:3 0003022]
  L3 Drive On	[E-0003 1:4 0003023]
  L3 Drive Off	[E-0003 1:5 0003024]
  L4 Drive On	[E-0003 2:0 0003025]
  L4 Drive Off	[E-0003 2:1 0003026]
  L5 Drive On	[E-0003 2:2 0003027]
  L5 Drive Off	[E-0003 2:3 0003028]
  L6 Drive On	[E-0003 2:4 0003029]
  L6 Drive Off	[E-0003 2:5 000302A]
  2nd Mirror Pointing Mode	[E-0003 3:0 000302B]
  2nd Mirror Test Mode	[E-0003 3:1 000302C]
  2nd Mirror Slewing Mode	[E-0003 3:2 0003047]
  L1 1st Limit Up	[E-0003 6:0 0003035]
  L1 1st Limit Down	[E-0003 6:1 0003036]
  L2 1st Limit Up	[E-0003 6:2 0003037]
  L2 1st Limit Down	[E-0003 6:3 0003038]
  L3 1st Limit Up	[E-0003 6:4 0003039]
  L3 1st Limit Down	[E-0003 6:5 000303A]
  L4 1st Limit Up	[E-0003 7:0 000303B]
  L4 1st Limit Down	[E-0003 7:1 000303C]
  L5 1st Limit Up	[E-0003 7:2 000303D]
  L5 1st Limit Down	[E-0003 7:3 000303E]
  L6 1st Limit Up	[E-0003 7:4 000303F]
  L6 1st Limit Down	[E-0003 7:5 0003040]
  L1 2nd Limit Up	[E-0003 8:0 0003041]
  L1 2nd Limit Down	[E-0003 8:1 0003085]
  L2 2nd Limit Up	[E-0003 8:2 0003042]
  L2 2nd Limit Down	[E-0003 8:3 0003086]
  L3 2nd Limit Up	[E-0003 8:4 0003043]
  L3 2nd Limit Down	[E-0003 8:5 0003087]
  L4 2nd Limit Up	[E-0003 9:0 0003044]
  L4 2nd Limit Down	[E-0003 9:1 0003088]
  L5 2nd Limit Up	[E-0003 9:2 0003045]
  L5 2nd Limit Down	[E-0003 9:3 0003089]
  L6 2nd Limit Up	[E-0003 9:4 0003046]
  L6 2nd Limit Down	[E-0003 9:5 000308A]
  PFU X 1st +	[E-0003 12:0 00030B7]
  PFU X 1st -	[E-0003 12:1 00030B8]
  PFU Y 1st +	[E-0003 12:2 00030B9]
  PFU Y 1st -	[E-0003 12:3 00030BA]
  PFU Z 1st +	[E-0003 12:4 00030BB]
  PFU Z 1st -	[E-0003 12:5 00030BC]
  PFU X 2nd +	[E-0003 13:0 00030BD]
  PFU X 2nd -	[E-0003 13:1 00030BE]
  PFU Y 2nd +	[E-0003 13:2 00030BF]
  PFU Y 2nd -	[E-0003 13:3 00030C0]
  PFU Z 2nd +	[E-0003 13:4 00030C1]
  PFU Z 2nd -	[E-0003 13:5 00030C2]
  L1 L/S ENCDR Alarm	[E-0003 14:0 0003067]
  L2 L/S ENCDR Alarm	[E-0003 14:1 0003068]
  L3 L/S ENCDR Alarm	[E-0003 14:2 0003069]
  L4 L/S ENCDR Alarm	[E-0003 14:3 000306A]
  L5 L/S ENCDR Alarm	[E-0003 14:4 000306B]
  L6 L/S ENCDR Alarm	[E-0003 14:5 000306C]
  2nd Mirror Fault	[E-0003 15:0 000306D]
  MLP2-2nd Mirror Alarm	[E-0003 15:1 000306E]
  2nd Mirror Local	[E-0003 15:4 0003071]
  2nd Mirror Total Fan Alarm	[E-0003 15:5 0003070]
  2nd Mirror MAINT	[E-0003 15:6 0003048]
  2nd Mirror EMER Stop	[E-0003 15:7 0003049]
  2nd Mirror DPA1 Power On	[E-0003 16:0 0003072]
  2nd Mirror DPA1 Power Off	[E-0003 16:1 0003073]
  2nd Mirror DPA2 Power On	[E-0003 16:2 0003074]
  2nd Mirror DPA2 Power Off	[E-0003 16:3 0003075]
  2nd Mirror L/S CONV1 Power On	[E-0003 17:0 000307E]
  2nd Mirror L/S CONV1 Power Off	[E-0003 17:1 000307F]
  2nd Mirror L/S CONV2 Power On	[E-0003 17:2 0003080]
  2nd Mirror L/S CONV2 Power Off	[E-0003 17:3 0003081]
  2nd Mirror Link Mode Selected	[E-0003 18:0 0003076]
  2nd Mirror SP Mode Selected(SPACE)	[E-0003 18:1 0003084]
  2nd Mirror SP Mode Selected(BASE)	[E-0003 18:2 0003054]
  Link Selected Ready	[E-0003 18:3 000309D]
  SP Selected Ready	[E-0003 18:4 000309E]
  Top Unit Code on SMCU	[E-0003 19 0003077 BCD1]
  2nd Mirror Link Not Zeroed	[E-0003 20:0 0003083]
  2nd Mirror Link Zeroing Stop	[E-0003 21:0 0003082]
  2nd Mirror Link Zeroing	[E-0003 21:1 000308B]
  2nd Mirror L1 Drive On Ready	[E-0003 22:0 0003078]
  2nd Mirror L2 Drive On Ready	[E-0003 22:1 0003079]
  2nd Mirror L3 Drive On Ready	[E-0003 22:2 000307A]
  2nd Mirror L4 Drive On Ready	[E-0003 22:3 000307B]
  2nd Mirror L5 Drive On Ready	[E-0003 22:4 000307C]
  2nd Mirror L6 Drive On Ready	[E-0003 22:5 000307D]
  2nd Mirror SP Real Valid	[E-0003 23:0 000304D]
  2nd Mirror Limit Reset	[E-0003 24:0 000304A]
  2nd Mirror COML PWR Fault	[E-0003 25:0 000304B]
  OEU Fault	[E-0003 26:0 000304E]
  SPU1/4(Cs) Fault	[E-0003 26:1 000304F]
  ADU1(SMCU) Fault on SMCU	[E-0003 26:2 0003050]
  2nd Mirror EXT CLK Alarm	[E-0003 27:0 000304C]
  L1 DPA Fault	[E-0003 28:0 0003055]
  L2 DPA Fault	[E-0003 28:1 0003056]
  L3 DPA Fault	[E-0003 28:2 0003057]
  L4 DPA Fault	[E-0003 28:3 0003058]
  L5 DPA Fault	[E-0003 28:4 0003059]
  L6 DPA Fault	[E-0003 28:5 0003060]
  2nd Mirror DPA1 Fault	[E-0003 28:6 0003061]
  2nd Mirror DPA2 Fault	[E-0003 28:7 0003062]
  Top Unit Disconnect	[E-0003 29:0 0003095]
  Pretorque Fault	[E-0003 29:1 0003096]
  IR-Spring1 Limit Up	[E-0003 30:0 0003097]
  IR-Spring1 Limit Down	[E-0003 30:1 0003098]
  IR-Spring2 Limit Up	[E-0003 30:2 0003099]
  IR-Spring2 Limit Down	[E-0003 30:3 000309A]
  IR-Spring3 Limit Up	[E-0003 30:4 000309B]
  IR-Spring3 Limit Down	[E-0003 30:5 000309C]
  2nd Mirror Opt/IR Selected	[E-0003 31:0 00030C3]
  2nd Mirror Cs Selected	[E-0003 31:1 00030C4]
  2nd Mirror Ns Selected	[E-0003 31:2 00030C5]
  2nd Mirror Ns(ImR) Selected	[E-0003 31:3 00030C6]
  2nd Mirror Ns(AO) Selected	[E-0003 31:4 00030C7]
  TS1 Temperature	[E-0003 46 0003063 BCD6]
  TS2 Temperature	[E-0003 52 0003064 BCD6]
  TS3 Temperature	[E-0003 58 0003065 BCD6]
  TS4 Temperature	[E-0003 64 0003066 BCD6]
  TS5 Temperature	[E-0003 70 000306F BCD6]
  TS6 Temperature	[E-0003 76 000308E BCD6]
  TS7 Temperature	[E-0003 82 0003093 BCD6]
  TS8 Temperature	[E-0003 88 0003094 BCD6]
  2nd Mirror Test Pattern	[E-0003 94 000302D BCD1]
  2nd Mirror Test Result	[E-0003 95 000302E BCD1]
  2nd Mirror Test Ready	[E-0003 95:0 000308F]
  2nd Mirror Test	[E-0003 95:1 0003090]
  2nd Mirror Test Data Send	[E-0003 95:2 0003091]
  2nd Mirror Test Data End	[E-0003 95:3 0003092]
  X Real Position	[L-0003 0 0003001 BCD6]
  Y Real Position	[L-0003 6 0003002 BCD6]
  Z Real Position	[L-0003 12 0003003 BCD6]
  X Real Angle	[L-0003 18 0003004 BCD6]
  Y Real Angle	[L-0003 24 0003005 BCD6]
  L1 Real Position	[L-0003 30 0003006 BCD6]
  L2 Real Position	[L-0003 36 0003007 BCD6]
  L3 Real Position	[L-0003 42 0003008 BCD6]
  L4 Real Position	[L-0003 48 0003009 BCD6]
  L5 Real Position	[L-0003 54 000300A BCD6]
  L6 Real Position	[L-0003 60 000300B BCD6]
  X CMD Position	[L-0003 66 000300C BCD6]
  Y CMD Position	[L-0003 72 000300D BCD6]
  Z CMD Position	[L-0003 78 000300E BCD6]
  X CMD Angle	[L-0003 84 000300F BCD6]
  Y CMD Angle	[L-0003 90 0003010 BCD6]
  L1 CMD Position	[L-0003 96 0003011 BCD6]
  L2 CMD Position	[L-0003 102 0003012 BCD6]
  L3 CMD Position	[L-0003 108 0003013 BCD6]
  L4 CMD Position	[L-0003 114 0003014 BCD6]
  L5 CMD Position	[L-0003 120 0003015 BCD6]
  L6 CMD Position	[L-0003 126 0003016 BCD6]
  L1 Position Error	[L-0003 132 0003017 BCD6]
  L2 Position Error	[L-0003 138 0003018 BCD6]
  L3 Position Error	[L-0003 144 0003019 BCD6]
  L4 Position Error	[L-0003 150 000301A BCD6]
  L5 Position Error	[L-0003 156 000301B BCD6]
  L6 Position Error	[L-0003 162 000301C BCD6]
  Z Real Angle	[L-0003 168 000308C BCD6]
  Z CMD Angle	[L-0003 174 000308D BCD6]
  2nd Mirror Data SMPLG Time ANS	[L-0003 180 0003051 BCD6]
  2nd Mirror CMD Velocity ANS	[L-0003 186 0003052 BCD6]
  2nd Mirror Data SMPLG INTVL	[L-0003 192 0003053 BCD6]
  Rotator Position(Mount Real SYNC) Mode	[E-0004 0:0 000402F]
  Rotator Position Mode	[E-0004 0:1 000402E]
  Rotator Test Mode	[E-0004 0:2 0004008]
  Rotator Slew Mode	[E-0004 0:3 0004007]
  Rotator Limit Reset	[E-0004 0:4 000401D]
  Rotator MAINT	[E-0004 0:5 000401E]
  Rotator NsOpt 1st Limit +	[E-0004 1:0 0004043]
  Rotator NsOpt 1st Limit -	[E-0004 1:1 0004044]
  Rotator NsOpt 2nd Limit +	[E-0004 1:2 0004045]
  Rotator NsOpt 2nd Limit -	[E-0004 1:3 0004046]
  Rotator NsIR 1st Limit +	[E-0004 2:0 0004047]
  Rotator NsIR 1st Limit -	[E-0004 2:1 0004048]
  Rotator NsIR 2nd Limit +	[E-0004 2:2 0004049]
  Rotator NsIR 2nd Limit -	[E-0004 2:3 000404A]
  Rotator Drive On	[E-0004 3:0 000400B]
  Rotator Drive Off	[E-0004 3:1 000400C]
  Rotator POpt Selected	[E-0004 4:0 000400D]
  Rotator PIR Selected	[E-0004 4:1 000400E]
  Rotator Cs Selected	[E-0004 4:2 000400F]
  Rotator NsOpt Selected	[E-0004 4:3 0004010]
  Rotator NsIR Selected	[E-0004 4:4 0004011]
  Rotator Cs Safety SW	[E-0004 5:0 0004012]
  Rotator Cs Handle SW	[E-0004 5:1 0004013]
  Rotator NsOpt Safety SW	[E-0004 5:2 000401F]
  Rotator NsOpt Handle	[E-0004 5:3 0004026]
  Rotator NsIR Safety SW	[E-0004 5:4 0004028]
  Rotator NsIR Handle	[E-0004 5:5 000403C]
  Rotator Drive Safety	[E-0004 5:6 000403D]
  Rotator Drive RDY	[E-0004 6:0 000402C]
  Rotator Fault	[E-0004 6:1 0004014]
  TCSPU1/4 (Cs) Alarm	[E-0004 6:5 0004033]
  MLP1-Rotator Alarm	[E-0004 7:0 0004015]
  Rotator Total Fan Alarm	[E-0004 7:1 0004016]
  Rotator Local	[E-0004 7:2 0004017]
  TCADU2(Rotator) Fault	[E-0004 7:3 0004018]
  Rotator EXT CLK Alarm	[E-0004 7:4 0004027]
  ADC-Rotator Alarm	[E-0004 7:5 0004069]
  Rotator Cs 1st Limit +	[E-0004 8:0 0004019]
  Rotator Cs 1st Limit -	[E-0004 8:1 000401A]
  Rotator Cs 2nd Limit +	[E-0004 8:2 000401B]
  Rotator Cs 2nd Limit -	[E-0004 8:3 000401C]
  ImR SW CONT NsOpt Selected	[E-0004 9:3 000406A]
  ImR SW CONT NsIR Selected	[E-0004 9:4 000406B]
  COML PWR Fault on FRAD	[E-0004 10:0 0004020]
  ImR Switching Stop	[E-0004 11:0 0004021]
  ImR Blue In	[E-0004 11:1 0004022]
  ImR Blue Out	[E-0004 11:2 0004023]
  ImR Red In	[E-0004 11:3 0004024]
  ImR Red Out	[E-0004 11:4 0004025]
  ImR Blue Selected	[E-0004 11:5 0004030]
  ImR Red Selected	[E-0004 11:6 0004031]
  ImR None Selected	[E-0004 11:7 0004032]
  Switch ImR Local	[E-0004 12:0 0004029]
  Switch ImR Fault	[E-0004 12:1 000402A]
  Rotator Cs DPA Fault	[E-0004 13:0 000403E]
  Rotator NsOpt DPA Fault	[E-0004 13:1 000403F]
  Rotator NsIR DPA Fault	[E-0004 13:2 0004040]
  TCDPA1(Rotator) Fault	[E-0004 13:3 0004041]
  TCDPA2(Rotator) Fault	[E-0004 13:4 0004042]
  Rotator EMER Stop	[E-0004 14:0 000402D]
  Rotator Cs ABS ENCDR-1 Alarm	[E-0004 15:0 000404B]
  Rotator Cs ABS ENCDR-2 Alarm	[E-0004 15:1 000404C]
  Rotator Cs ABS ENCDR-3 Alarm	[E-0004 15:2 000404D]
  Rotator Cs ABS ENCDR-4 Alarm	[E-0004 15:3 000404E]
  Rotator Cs ABS ENCDR-1 Not Used	[E-0004 15:4 000404F]
  Rotator Cs ABS ENCDR-2 Not Used	[E-0004 15:5 0004050]
  Rotator Cs ABS ENCDR-3 Not Used	[E-0004 15:6 0004051]
  Rotator Cs ABS ENCDR-4 Not Used	[E-0004 15:7 0004052]
  Rotator NsOpt ABS ENCDR-1 Alarm	[E-0004 16:0 0004053]
  Rotator NsOpt ABS ENCDR-2 Alarm	[E-0004 16:1 0004054]
  Rotator NsOpt ABS ENCDR-3 Alarm	[E-0004 16:2 0004055]
  Rotator NsOpt ABS ENCDR-4 Alarm	[E-0004 16:3 0004056]
  Rotator NsOpt ABS ENCDR-1 Not Used	[E-0004 16:4 0004057]
  Rotator NsOpt ABS ENCDR-2 Not Used	[E-0004 16:5 0004058]
  Rotator NsOpt ABS ENCDR-3 Not Used	[E-0004 16:6 0004059]
  Rotator NsOpt ABS ENCDR-4 Not Used	[E-0004 16:7 000405A]
  Rotator NsIR ABS ENCDR-1 Alarm	[E-0004 17:0 000405B]
  Rotator NsIR ABS ENCDR-2 Alarm	[E-0004 17:1 000405C]
  Rotator NsIR ABS ENCDR-3 Alarm	[E-0004 17:2 000405D]
  Rotator NsIR ABS ENCDR-4 Alarm	[E-0004 17:3 000405E]
  Rotator NsIR ABS ENCDR-1 Not Used	[E-0004 17:4 000405F]
  Rotator NsIR ABS ENCDR-2 Not Used	[E-0004 17:5 0004060]
  Rotator NsIR ABS ENCDR-3 Not Used	[E-0004 17:6 0004061]
  Rotator NsIR ABS ENCDR-4 Not Used	[E-0004 17:7 0004062]
  ADC Position Mode	[E-0004 21:1 0004107]
  ADC Test Mode	[E-0004 21:2 0004108]
  ADC Slew Mode	[E-0004 21:3 0004139]
  ADC Limit Reset	[E-0004 21:4 0004124]
  ADC MAINT	[E-0004 21:5 0004127]
  ADC NsOpt 1st Limit +	[E-0004 22:0 000412E]
  ADC NsOpt 1st Limit -	[E-0004 22:1 000412F]
  ADC NsOpt 2nd Limit +	[E-0004 22:2 0004130]
  ADC NsOpt 2nd Limit -	[E-0004 22:3 0004131]
  ADC COML PWR Fault	[E-0004 23:0 0004138]
  ADC Drive On	[E-0004 24:0 000410B]
  ADC Drive Off	[E-0004 24:1 000410C]
  ADC POpt Selected	[E-0004 25:0 000410D]
  ADC PIR Selected	[E-0004 25:1 000410E]
  ADC Cs Selected	[E-0004 25:2 000410F]
  ADC NsOpt Selected	[E-0004 25:3 0004110]
  ADC Cs 1st Limit +	[E-0004 26:0 0004111]
  ADC Cs 1st Limit -	[E-0004 26:1 0004112]
  ADC Cs 2nd Limit +	[E-0004 26:2 0004113]
  ADC Cs 2nd Limit -	[E-0004 26:3 0004114]
  ADC Drive Ready	[E-0004 27:0 0004125]
  ADC Fault	[E-0004 27:1 0004115]
  TCSPU1/4(Cs) Fault on FRAD	[E-0004 27:5 0004119]
  Rotator-ADC Alarm	[E-0004 28:0 0004116]
  ADC Total Fan Alarm	[E-0004 28:1 0004117]
  ADC Local	[E-0004 28:2 0004118]
  ADC EXT CLK Alarm	[E-0004 28:4 0004128]
  ADC Switching Stop	[E-0004 29:0 000411A]
  ADC In	[E-0004 29:3 0004122]
  ADC Out	[E-0004 29:4 0004123]
  ADC Selected	[E-0004 29:6 0004120]
  ADC None Selected	[E-0004 29:7 0004121]
  ADC Cs Safety SW	[E-0004 30:0 000411B]
  ADC Cs Handle SW	[E-0004 30:1 000411C]
  ADC NsOpt Safety SW	[E-0004 30:2 000411D]
  ADC NsOpt Handle SW	[E-0004 30:3 000411E]
  ADC Drive Safety	[E-0004 30:6 000411F]
  ADC SW CONT Cs Selected	[E-0004 31:2 000413A]
  ADC SW CONT NsOpt Selected	[E-0004 31:3 000413B]
  ADC Cs DPA Fault	[E-0004 32:0 0004129]
  ADC NsOpt DPA Fault	[E-0004 32:1 000412C]
  TCDPA1(ADC) Fault	[E-0004 32:2 000412D]
  ADC EMER Stop	[E-0004 33:0 0004126]
  Switch ADC Local	[E-0004 34:0 000412A]
  Switch ADC Fault	[E-0004 34:1 000412B]
  Rotator Cs ABS ENCDR Not Zeroed	[E-0004 35:1 0004036]
  Rotator Cs ABS ENCDR Zeroing	[E-0004 35:2 0004037]
  Rotator NsOpt ABS ENCDR Not Zeroed	[E-0004 35:3 0004038]
  Rotator NsOpt ABS ENCDR Zeroing	[E-0004 35:4 0004039]
  Rotator NsIR ABS ENCDR Not Zeroed	[E-0004 35:5 000403A]
  Rotator NsIR ABS ENCDR Zeroing	[E-0004 35:6 000403B]
  Rotator Cs ABS ENCDR Not INIT	[E-0004 36:0 0004035]
  Rotator NsOpt ABS ENCDR Not INIT	[E-0004 36:1 000406C]
  Rotator NsIR ABS ENCDR Not INIT	[E-0004 36:2 000406D]
  Rotator Test Pattern	[E-0004 38 0004009 BCD1]
  Rotator Test Result	[E-0004 39 000400A BCD1]
  Rotator Test Ready	[E-0004 39:0 0004063]
  Rotator Test	[E-0004 39:1 0004064]
  Rotator Test Data Send	[E-0004 39:2 0004065]
  Rotator Test Data End	[E-0004 39:3 0004066]
  ADC Test Number	[E-0004 40 0004109 BCD1]
  ADC Test Result	[E-0004 41 000410A BCD1]
  ADC Test RDY	[E-0004 41:0 0004134]
  ADC Test	[E-0004 41:1 0004135]
  ADC Test Data Send	[E-0004 41:2 0004136]
  ADC Test Data End	[E-0004 41:3 0004137]
  Rotator Rate REF	[L-0004 12 0004003 BCD6]
  Rotator Rate FDBK-A	[L-0004 18 0004004 BCD6]
  Rotator Current REF-A	[L-0004 24 0004005 BCD6]
  Rotator Rate FDBK-B	[L-0004 30 000402B BCD6]
  ADC Real Angle	[L-0004 36 0004101 BCD6]
  ADC CMD Angle	[L-0004 42 0004102 BCD6]
  ADC Rate REF	[L-0004 48 0004103 BCD6]
  ADC Rate FDBK	[L-0004 54 0004104 BCD6]
  ADC Current REF	[L-0004 60 0004105 BCD6]
  Rotator Current REF-B	[L-0004 66 0004034 BCD6]
  Rotator Data SMPLG Time	[L-0004 72 0004006 BCD6]
  Rotator CMD VEL	[L-0004 78 0004067 BCD6]
  Rotator Data SMPLG INTVL	[L-0004 84 0004068 BCD6]
  ADC Data SMPLG Time ANS	[L-0004 90 0004132 BCD6]
  ADC CMD VEL ANS	[L-0004 96 0004133 BCD6]
  ADC Data SMPLG INTVL	[L-0004 102 0004106 BCD6]
  Rotator Real Angle	[S-0004 0 0004001 BCD6]
  Rotator CMD ANS	[S-0004 6 0004002 BCD6]
  AG POpt Selected	[E-0006 0:0 000602C]
  AG PIR Selected	[E-0006 0:1 000602D]
  AG Cs Selected	[E-0006 0:2 000602E]
  AG NsOpt Selected	[E-0006 0:3 0006030]
  AG NsIR Selected	[E-0006 0:4 000602F]
  AG CCD AMP Gain High	[E-0006 1:0 0006057]
  AG CCD AMP Gain Low	[E-0006 1:1 0006058]
  AG Normal Mode	[E-0006 1:2 0006048]
  AG Test Mode	[E-0006 1:3 000604C]
  AG Star Image Size Default Set ANS	[E-0006 1:4 000603F]
  AG CCD Clock Speed High	[E-0006 1:5 0006059]
  AG CCD Clock Speed Medium	[E-0006 1:6 000605A]
  AG CCD Clock Speed Low	[E-0006 1:7 000605B]
  AG Test Pattern	[E-0006 2 000604D BCD1]
  AG Test Result	[E-0006 3 000604E BCD1]
  AG Exposure Time	[E-0006 4 0006005 BINARY4_1]
  AG CCD Exposure Count	[E-0006 8 000605C BINARY2_1]
  AG Lower Limit1	[E-0006 10 0006016 BINARY2_1]
  AG Upper Limit1	[E-0006 12 0006017 BINARY2_1]
  AG Lower Limit2	[E-0006 14 0006018 BINARY2_1]
  AG Upper Limit2	[E-0006 16 0006019 BINARY2_1]
  AG CCD Shutter Open	[E-0006 18:0 0006003]
  AG CCD Shutter Close	[E-0006 18:1 0006004]
  AG Star Position1 Detect Start on AG	[E-0006 18:2 0006021]
  AG Star Position1 Detect Stop on AG	[E-0006 18:3 0006022]
  AG Star Position2 Detect Start on AG	[E-0006 18:4 0006023]
  AG Star Position2 Detect Stop on AG	[E-0006 18:5 0006024]
  AG Exposure On	[E-0006 18:6 0006083]
  AG Exposure Off	[E-0006 18:7 0006084]
  AG Gravity of Center Mode	[E-0006 19:0 000601C]
  AG Bisection Mode	[E-0006 19:1 000601D]
  AG Peak Mode	[E-0006 19:2 000601E]
  AG Data Time Set ANS	[E-0006 19:3 000605E]
  AG Video Area Set ANS	[E-0006 19:4 000605F]
  AG Exposure Time Set ANS	[E-0006 19:5 0006060]
  AG Star Position1 DET Area Set ANS	[E-0006 19:6 0006061]
  AG Star Position2 DET Area Set ANS	[E-0006 19:7 0006062]
  AG CCD Limit1 Set ANS	[E-0006 20:0 0006063]
  AG CCD LimitT2 Set ANS	[E-0006 20:1 0006064]
  AG Star Position1 Set ANS	[E-0006 20:2 0006065]
  AG Star Position2 Set ANS	[E-0006 20:3 0006066]
  AG Diaphram Out	[E-0006 20:4 0006020]
  AG Diaphram Full Open	[E-0006 20:5 0006001]
  AG Diaphram Close	[E-0006 20:6 0006002]
  AG Diaphram Open	[E-0006 20:7 000605D]
  AG Video Area X	[E-0006 21 0006006 BINARY2_1]
  AG Video Area Y	[E-0006 23 0006007 BINARY2_1]
  AG Video Area Width X	[E-0006 25 0006008 BINARY2_1]
  AG Video Area Width Y	[E-0006 27 0006009 BINARY2_1]
  AG Star Position1 DET Area X	[E-0006 29 000600A BINARY2_1]
  AG Star Position1 DET Area Y	[E-0006 31 000600B BINARY2_1]
  AG Star Position1 DET Area Width X	[E-0006 33 000600C BINARY2_1]
  AG Star Position1 DET Area Width Y	[E-0006 35 000600D BINARY2_1]
  AG Star Position2 DET Area X	[E-0006 37 000600E BINARY2_1]
  AG Star Position2 DET Area Y	[E-0006 39 000600F BINARY2_1]
  AG Star Position2 DET Area Width X	[E-0006 41 0006010 BINARY2_1]
  AG Star Position2 DET Area Width Y	[E-0006 43 0006011 BINARY2_1]
  AG Star Position1 X	[E-0006 45 0006012 BINARY4_0p01]
  AG Star Position1 Y	[E-0006 49 0006013 BINARY4_0p01]
  AG Star Position2 X	[E-0006 53 0006014 BINARY4_0p01]
  AG Star Position2 Y	[E-0006 57 0006015 BINARY4_0p01]
  AG Sky Data Exposure Time	[E-0006 61 0006054 BINARY4_1]
  AG Sky Data Used	[E-0006 65:0 0006031]
  AG Sky Data Not Used	[E-0006 65:1 0006032]
  AG Sky Data Get Start	[E-0006 65:2 0006039]
  AG Sky Data Get Stop	[E-0006 65:3 000603C]
  AG Sky Send For OBS	[E-0006 65:4 0006068]
  AG Sky Send For TWS1	[E-0006 65:5 0006069]
  AG Sky Send For TWS2	[E-0006 65:6 000606A]
  AG Sky Get End	[E-0006 65:7 0006071]
  AG Dark Data Exposure Time	[E-0006 66 0006055 BINARY4_1]
  AG Dark Data Used	[E-0006 70:0 0006033]
  AG Dark Data Not Used	[E-0006 70:1 0006034]
  AG Dark Data Get Start	[E-0006 70:2 000603B]
  AG Dark Data Get Stop	[E-0006 70:3 000603E]
  AG Dark Send For OBS	[E-0006 70:4 000606B]
  AG Dark Send For TWS1	[E-0006 70:5 000606C]
  AG Dark Send For TWS2	[E-0006 70:6 000606D]
  AG Dark Get End	[E-0006 70:7 0006085]
  AG Flat Data Exposure Time	[E-0006 71 0006056 BINARY4_1]
  AG Flat Data Used	[E-0006 75:0 0006035]
  AG Flat Data Not Used	[E-0006 75:1 0006036]
  AG Flat Data Get Start	[E-0006 75:2 000603A]
  AG Flat Data Get Stop	[E-0006 75:3 000603D]
  AG Flat Send For OBS	[E-0006 75:4 000606E]
  AG Flat Send For TWS1	[E-0006 75:5 000606F]
  AG Flat Send For TWS2	[E-0006 75:6 0006070]
  AG Flat Get End	[E-0006 75:7 00060A7]
  AG Binning Pattern	[E-0006 76 000601F BINARY1_1]
  AG Local	[E-0006 77:0 0006050]
  MLP1-AG I/F Alarm	[E-0006 77:1 0006051]
  AG VME Rack Fan Alarm	[E-0006 77:2 0006052]
  AG Heavy Load Setting Alarm	[E-0006 77:3 00060AE]
  AG Camera Idle	[E-0006 77:4 0006072]
  AG Camera Busy	[E-0006 77:5 0006073]
  AG COML PWR FLT DET	[E-0006 77:6 0006074]
  AG TSC FLT IND	[E-0006 77:7 0006075]
  AG Video Output OBS On	[E-0006 78:0 0006076]
  AG Video Output OBS Off	[E-0006 78:1 0006077]
  AG Video Output TWS1 On	[E-0006 78:2 0006078]
  AG Video Output TWS1 Off	[E-0006 78:3 0006079]
  AG Video Output TWS2 On	[E-0006 78:4 000607A]
  AG Video Output TWS2 Off	[E-0006 78:5 000607B]
  AG Auto CCD Limit Set On	[E-0006 78:6 00060A8]
  AG Auto CCD Limit Set Off	[E-0006 78:7 00060A9]
  AG Star1 Position Set ANS	[E-0006 79:0 0006040]
  AG Star2 Position Set ANS	[E-0006 79:1 0006041]
  AG Star1 Position Reset ANS	[E-0006 79:2 0006042]
  AG Star2 Position Reset ANS	[E-0006 79:3 0006043]
  AG Camera I/F Alarm	[E-0006 80:0 000607C]
  AG Shutter I/F Alarm	[E-0006 80:1 000607D]
  AG-VGW I/F Alarm	[E-0006 80:2 000607E]
  AG-TWS1 I/F Alarm	[E-0006 80:3 000607F]
  AG-TWS2 I/F Alarm	[E-0006 80:4 000604A]
  Imageboard-AG I/F Alarm	[E-0006 80:5 000604B]
  AG OBS Output Interval	[E-0006 81 0006080 BINARY1_1]
  AG TWS1 Output Interval	[E-0006 82 0006081 BINARY1_1]
  AG TWS2 Output Interval	[E-0006 83 0006082 BINARY1_1]
  AG OBS Output Interval Set ANS	[E-0006 84:0 0006087]
  AG TWS1 Output Interval Set ANS	[E-0006 84:1 0006088]
  AG TWS2 Output Interval Set ANS	[E-0006 84:2 0006089]
  AG Star1 Image Size Set	[E-0006 84:3 0006037]
  AG ImR Used	[E-0006 84:5 0006053]
  AG ImR Not Used	[E-0006 84:6 0006067]
  AG Exposure Count Set ANS	[E-0006 84:7 0006086]
  AG POpt Camera Chiller Alarm	[E-0006 85:0 000608A]
  AG POpt CCD Shutter Motor Alarm	[E-0006 85:1 000608B]
  AG POpt PM Shutter Motor Alarm	[E-0006 85:2 000608C]
  AG POpt Shutter PS Off	[E-0006 85:3 000608D]
  AG PIR Camera Chiller Alarm	[E-0006 86:0 000608F]
  AG PIR CCD Shutter Motor Alarm	[E-0006 86:1 0006090]
  AG PIR PM Shutter Motor Alarm	[E-0006 86:2 0006091]
  AG PIR Shutter PS Off	[E-0006 86:3 0006092]
  AG Cs Camera Chiller Alarm	[E-0006 87:0 0006094]
  AG Cs CCD Shutter Motor Alarm	[E-0006 87:1 0006095]
  AG Cs PM Shutter Motor Alarm	[E-0006 87:2 0006096]
  AG Cs Shutter PS Off	[E-0006 87:3 0006097]
  AG NsOpt Camera Chiller Alarm	[E-0006 88:0 0006099]
  AG NsOpt CCD Shutter Motor Alarm	[E-0006 88:1 000609A]
  AG NsOpt PM Shutter Motor Alarm	[E-0006 88:2 000609B]
  AG NsOpt Shutter PS Off	[E-0006 88:3 000609C]
  AG NsIR Camera Chiller Alarm	[E-0006 89:0 000609E]
  AG NsIR CCD Shutter Motor Alarm	[E-0006 89:1 000609F]
  AG NsIR PM Shutter Motor Alarm	[E-0006 89:2 00060A0]
  AG NsIR Shutter PS Off	[E-0006 89:3 00060A1]
  CAL Sky Binning on AG	[E-0006 90 0006045 BINARY1_1]
  CAL Dark Binning on AG	[E-0006 91 0006046 BINARY1_1]
  CAL Flat Binning on AG	[E-0006 92 0006047 BINARY1_1]
  AG Pixcel-Marcsec Change Value	[E-0006 93 0006038 BINARY4_0p01]
  AG Exposure Time(Tip-Tilt)	[E-0006 97 000608E BINARY4_1]
  AG CCD Lower Limit(Tip-Tilt)	[E-0006 101 0006093 BINARY2_1]
  AG CCD Upper Limit(Tip-Tilt)	[E-0006 103 0006098 BINARY2_1]
  AG Image Data Delay Time	[E-0006 105 000609D BINARY4_1]
  AG Exposure Time(Tip-Tilt) Set ANS	[E-0006 109:0 00060A2]
  AG CCD Limit(Tip-Tilt) Set ANS	[E-0006 109:1 0006044]
  AG Exposure Auto Guide Mode	[E-0006 110:0 00060AA]
  AG Exposure Tip-Tilt Mode	[E-0006 110:1 00060AB]
  AG Reference Offset X	[E-0006 111 00060AC BINARY4_0p01]
  AG Reference Offset Y	[E-0006 115 00060AD BINARY4_0p01]
  AG Data Time on AG	[L-0006 0 0006025 TIME8]
  AG Star Position1 Error X on AG	[L-0006 8 0006026 BINARY4_0p01]
  AG Star Position1 Error Y on AG	[L-0006 12 0006027 BINARY4_0p01]
  AG Star Position1 Intensity on AG	[L-0006 16 0006028 BINARY2_1]
  AG Star Position2 Error X on AG	[L-0006 18 0006029 BINARY4_0p01]
  AG Star Position2 Error Y on AG	[L-0006 22 000602A BINARY4_0p01]
  AG Star Position2 Intensity on AG	[L-0006 26 000602B BINARY2_1]
  AG CCD Temperature	[L-0006 28 000604F BINARY4_0p01]
  Guide Star1 Image Size on AG	[L-0006 32 000601A BINARY4_0p01]
  Guide Star2 Image Size on AG	[L-0006 36 000601B BINARY4_0p01]
  AG Star1 Gravity Position X	[L-0006 40 00060A3 BINARY4_0p01]
  AG Star1 Gravity Position Y	[L-0006 44 00060A4 BINARY4_0p01]
  AG Star2 Gravity Position X	[L-0006 48 00060A5 BINARY4_0p01]
  AG Star2 Gravity Position Y	[L-0006 52 00060A6 BINARY4_0p01]
  SV Cs Motor PS On	[E-0007 1:0 0007032]
  SV Cs Motor PS Off	[E-0007 1:1 0007033]
  SV NsOpt Motor PS On	[E-0007 1:2 0007034]
  SV NsOpt Motor PS Off	[E-0007 1:3 0007035]
  SV Cs Selected	[E-0007 2:2 0007012]
  SV NsOpt Selected	[E-0007 2:3 0007013]
  SV Cs Camera Chiller Alarm	[E-0007 3:0 0007005]
  SV Cs Shutter Motor Alarm	[E-0007 3:1 0007006]
  SV Cs Shutter PS On	[E-0007 3:2 0007007]
  SV Cs Shutter PS Off	[E-0007 3:3 0007008]
  SV NsOpt Camera Chiller Alarm	[E-0007 3:4 000702E]
  SV NsOpt Shutter Motor Alarm	[E-0007 3:5 000702F]
  SV NsOpt Shutter PS On	[E-0007 3:6 0007030]
  SV NsOpt Shutter PS Off	[E-0007 3:7 0007031]
  SV Normal Mode	[E-0007 4:2 0007014]
  SV Test Mode	[E-0007 4:3 0007015]
  SV Exposure Area Set ANS	[E-0007 4:4 000701D]
  SV Exposure On	[E-0007 4:6 000700B]
  SV Exposure Off	[E-0007 4:7 000700C]
  SV Test Pattern	[E-0007 5 0007016 BINARY1_1]
  SV Test Result	[E-0007 6 0007017 BINARY1_1]
  SV Exposure Time	[E-0007 7 000700E BINARY4_100]
  SV Exposure Area X	[E-0007 13 0007019 BINARY2_1]
  SV Exposure Area Y	[E-0007 15 000701A BINARY2_1]
  SV Exposure Area Width X	[E-0007 17 000701B BINARY2_1]
  SV Exposure Area Width Y	[E-0007 19 000701C BINARY2_1]
  SV Binning Pattern	[E-0007 21 000700D BINARY1_1]
  SV Filter Selected	[E-0007 22 0007010 BINARY1_1]
  SV Camera I/F Alarm	[E-0007 24:0 0007038]
  SV Shutter I/F Alarm	[E-0007 24:1 0007039]
  SV-VGW I/F Alarm	[E-0007 24:2 000703A]
  SV-TWS1 I/F Alarm	[E-0007 24:3 000703B]
  SV-TWS2 I/F Alarm	[E-0007 24:4 000703C]
  Imageboard-SV I/F Alarm	[E-0007 24:5 0007036]
  SV Shutter Open	[E-0007 25:0 0007009]
  SV Shutter Close	[E-0007 25:1 000700A]
  TSC Time Set ANS	[E-0007 25:2 0007026]
  SV Filter Selected ANS	[E-0007 25:3 0007011]
  SV Exposure Time Set ANS	[E-0007 25:5 000700F]
  SV Field Position Set ANS	[E-0007 25:6 0007004]
  SV Local	[E-0007 26:0 0007020]
  MLP1-SV I/F Alarm	[E-0007 26:1 0007021]
  SV VME Rack Fan Alarm	[E-0007 26:2 0007027]
  SV Heavy Load Setting Alarm	[E-0007 26:3 00071AB]
  SV Camera Idle	[E-0007 26:4 0007022]
  SV Camera Busy	[E-0007 26:5 0007023]
  TSC COMPL PWR FLT DET	[E-0007 26:6 0007025]
  TSC FLT IND	[E-0007 26:7 0007024]
  SV Video Output OBS On	[E-0007 27:0 0007028]
  SV Video Output OBS Off	[E-0007 27:1 0007029]
  SV Video Output TWS1 On	[E-0007 27:2 000702A]
  SV Video Output TWS1 Off	[E-0007 27:3 000702B]
  SV Video Output TWS2 On	[E-0007 27:4 000702C]
  SV Video Output TWS2 Off	[E-0007 27:5 000702D]
  SV Auto CCD Limit Set On	[E-0007 27:6 00071A9]
  SV Auto CCD Limit Set Off	[E-0007 27:7 00071AA]
  SV CCD AMP Gain High	[E-0007 28:0 000701E]
  SV CCD AMP Gain Low	[E-0007 28:1 000701F]
  SV CCD Clock Speed High	[E-0007 28:5 000703D]
  SV CCD Clock Speed Medium	[E-0007 28:6 000703E]
  SV CCD Clock Speed Low	[E-0007 28:7 000703F]
  SV Image Data Delay Time	[E-0007 31 00071A8 BINARY4_1]
  SV OBS Output Interval	[E-0007 46 0007041 BINARY1_1]
  SV TWS1 Output Interval	[E-0007 47 0007042 BINARY1_1]
  SV TWS2 Output Interval	[E-0007 48 0007043 BINARY1_1]
  SV OBS Output Interval Set ANS	[E-0007 49:0 0007044]
  SV TWS1 Output Interval Set ANS	[E-0007 49:1 0007045]
  SV TWS2 Output Interval Set ANS	[E-0007 49:2 0007046]
  SV Star Image Size Default Set ANS	[E-0007 51:4 000713F]
  SV CCD Exposure Count	[E-0007 52 000715C BINARY2_1]
  SV Lower Limit1	[E-0007 54 0007116 BINARY2_1]
  SV Upper Limit1	[E-0007 56 0007117 BINARY2_1]
  SV Lower Limit2	[E-0007 58 0007118 BINARY2_1]
  SV Upper Limit2	[E-0007 60 0007119 BINARY2_1]
  SV Star Position1 Detect Start on SV	[E-0007 62:2 0007121]
  SV Star Position1 Detect Stop on SV	[E-0007 62:3 0007122]
  SV Star Position2 Detect Start on SV	[E-0007 62:4 0007123]
  SV Star Position2 Detect Stop on SV	[E-0007 62:5 0007124]
  SV Gravity of Center Mode	[E-0007 63:0 000711C]
  SV Bisection Mode	[E-0007 63:1 000711D]
  SV Peak Mode	[E-0007 63:2 000711E]
  SV Slit Guide Mode	[E-0007 63:3 00071AC]
  SV Star Position1 DET Area Set ANS	[E-0007 63:6 0007161]
  SV Star Position2 DET Area Set ANS	[E-0007 63:7 0007162]
  SV CCD Limit1 Set ANS	[E-0007 64:0 0007163]
  SV CCD Limit2 Set ANS	[E-0007 64:1 0007164]
  SV Star Position1 Set ANS	[E-0007 64:2 0007165]
  SV Star Position2 Set ANS	[E-0007 64:3 0007166]
  SV Star Position1 DET Area X	[E-0007 65 000710A BINARY2_1]
  SV Star Position1 DET Area Y	[E-0007 67 000710B BINARY2_1]
  SV Star Position1 DET Area Width X	[E-0007 69 000710C BINARY2_1]
  SV Star Position1 DET Area Width Y	[E-0007 71 000710D BINARY2_1]
  SV Star Position2 DET Area X	[E-0007 73 000710E BINARY2_1]
  SV Star Position2 DET Area Y	[E-0007 75 000710F BINARY2_1]
  SV Star Position2 DET Area Width X	[E-0007 77 0007110 BINARY2_1]
  SV Star Position2 DET Area Width Y	[E-0007 79 0007111 BINARY2_1]
  SV Star Position1 X	[E-0007 81 0007112 BINARY4_0p01]
  SV Star Position1 Y	[E-0007 85 0007113 BINARY4_0p01]
  SV Star Position2 X	[E-0007 89 0007114 BINARY4_0p01]
  SV Star Position2 Y	[E-0007 93 0007115 BINARY4_0p01]
  SV Sky Data Exposure Time	[E-0007 97 0007154 BINARY4_1]
  SV Sky Data Used	[E-0007 101:0 0007131]
  SV Sky Data Not Used	[E-0007 101:1 0007132]
  SV Sky Data Get Start	[E-0007 101:2 0007139]
  SV Sky Data Get Stop	[E-0007 101:3 000713C]
  SV Sky Send For OBS	[E-0007 101:4 0007168]
  SV Sky Send For TWS1	[E-0007 101:5 0007169]
  SV Sky Send For TWS2	[E-0007 101:6 000716A]
  SV Sky Get End	[E-0007 101:7 0007171]
  SV Dark Data Exposure Time	[E-0007 102 0007155 BINARY4_1]
  SV Dark Data Used	[E-0007 106:0 0007133]
  SV Dark Data Not Used	[E-0007 106:1 0007134]
  SV Dark Data Get Start	[E-0007 106:2 000713B]
  SV Dark Data Get Stop	[E-0007 106:3 000713E]
  SV Dark Send For OBS	[E-0007 106:4 000716B]
  SV Dark Send For TWS1	[E-0007 106:5 000716C]
  SV Dark Send For TWS2	[E-0007 106:6 000716D]
  SV Dark Get End	[E-0007 106:7 0007185]
  SV Flat Data Exposure Time	[E-0007 107 0007156 BINARY4_1]
  SV Flat Data Used	[E-0007 111:0 0007135]
  SV Flat Data Not Used	[E-0007 111:1 0007136]
  SV Flat Data Get Start	[E-0007 111:2 000713A]
  SV Flat Data Get Stop	[E-0007 111:3 000713D]
  SV Flat Send For OBS	[E-0007 111:4 000716E]
  SV Flat Send For TWS1	[E-0007 111:5 000716F]
  SV Flat Send For TWS2	[E-0007 111:6 0007170]
  SV Flat Get End	[E-0007 111:7 00071A7]
  SV Star1 Position Set ANS	[E-0007 112:0 0007140]
  SV Star2 Position Set ANS	[E-0007 112:1 0007141]
  SV Star1 Position Reset ANS	[E-0007 112:2 0007142]
  SV Star2 Position Reset ANS	[E-0007 112:3 0007143]
  SV Slit Position X	[E-0007 112:4 00071B2]
  SV Slit Position Y	[E-0007 112:5 00071B3]
  SV Slit Direction	[E-0007 112:6 00071B4]
  SV Slit Width	[E-0007 112:7 00071B5]
  SV Star Image Size Set	[E-0007 113:3 0007137]
  SV ImR Used	[E-0007 113:5 0007153]
  SV ImR Not Used	[E-0007 113:6 0007167]
  SV Exposure Count Set ANS	[E-0007 113:7 0007186]
  CAL Sky Binning on SV	[E-0007 114 0007145 BINARY1_1]
  CAL Dark Binning on SV	[E-0007 115 0007146 BINARY1_1]
  CAL Flat Binning on SV	[E-0007 116 0007147 BINARY1_1]
  SV Pixcel-Marcsec Change Value	[E-0007 117 0007138 BINARY4_0p01]
  SV Slit Position X on SV	[E-0007 121 00071AD BINARY4_0p01]
  SV Slit Position Y on SV	[E-0007 125 00071AE BINARY4_0p01]
  SV Slit Direction on SV	[E-0007 129 00071AF BINARY4_0p01]
  SV Slit Width on SV	[E-0007 133 00071B0 BINARY4_0p01]
  SV Star1 Image Size CMD ANS	[E-0007 137 00071B1 BINARY4_0p01]
  SV Field Real Position	[L-0007 0 0007001 BINARY4_0p001]
  SV CCD Temperature	[L-0007 4 0007018 BINARY4_0p01]
  SV Data Time	[L-0007 8 0007040 TIME8]
  SV Field CMD Position ANS	[L-0007 16 0007047 BINARY4_0p001]
  SV Star Position1 Error X on SV	[L-0007 20 0007126 BINARY4_0p01]
  SV Star Position1 Error Y on SV	[L-0007 24 0007127 BINARY4_0p01]
  SV Star Position1 Intensity on SV	[L-0007 28 0007128 BINARY2_0p01]
  SV Star Position2 Error X on SV	[L-0007 30 0007129 BINARY4_0p01]
  SV Star Position2 Error Y on SV	[L-0007 34 000712A BINARY4_0p01]
  SV Star Position2 Intensity on SV	[L-0007 38 000712B BINARY2_1]
  Guide Star1 Image Size on SV	[L-0007 40 000711A BINARY4_0p01]
  Guide Star2 Image Size on SV	[L-0007 44 000711B BINARY4_0p01]
  SV Star1 Gravity Position X	[L-0007 48 00071A3 BINARY4_0p01]
  SV Star1 Gravity Position Y	[L-0007 52 00071A4 BINARY4_0p01]
  SV Star2 Gravity Position X	[L-0007 56 00071A5 BINARY4_0p01]
  SV Star2 Gravity Position Y	[L-0007 60 00071A6 BINARY4_0p01]
  AO Fault	[E-0008 0:0 0008007]
  AO Gravity Error X	[L-0008 0 0008001 BINARY4_0p01]
  AO Gravity Error Y	[L-0008 4 0008002 BINARY4_0p01]
  AO Intensity	[L-0008 8 0008003 BINARY2_1]
  AO R Position	[L-0008 10 0008004 BCD6]
  AO Angle	[L-0008 16 0008005 BCD6]
  AO Image SIZE	[L-0008 22 0008006 BINARY4_0p01]
  SH CCD AMP Gain High	[E-0009 0:0 0009001]
  SH CCD AMP Gain Low	[E-0009 0:1 0009002]
  SH Normal Mode	[E-0009 0:2 0009003]
  SH Test Mode	[E-0009 0:3 0009004]
  SH CCD Limit Set ANS	[E-0009 0:4 000903E]
  SH REF Lamp V Set ANS	[E-0009 0:5 000903F]
  SH Exposure On	[E-0009 0:6 000900E]
  SH Exposure Off	[E-0009 0:7 000900F]
  SH Test Pattern	[E-0009 1 0009005 BCD1]
  SH Exposure Time	[E-0009 2 000900D BINARY4_100]
  SH Exposure Count	[E-0009 6 000900C BINARY2_1]
  SH CCD Lower Limit	[E-0009 8 0009010 BINARY2_1]
  SH CCD Upper Limit	[E-0009 10 0009011 BINARY2_1]
  SH Sky Data Used	[E-0009 12:0 0009014]
  SH Sky Data Not Used	[E-0009 12:1 0009015]
  SH Sky Data Start	[E-0009 12:2 000901A]
  SH Sky Data Stop	[E-0009 12:3 000901B]
  SH Sky Send For OBS	[E-0009 12:4 000904B]
  SH Sky Send For TWS1	[E-0009 12:5 000904C]
  SH Sky Send For TWS2	[E-0009 12:6 000904D]
  SH Dark Data Used	[E-0009 13:0 0009016]
  SH Dark Data Not Used	[E-0009 13:1 0009017]
  SH Dark Data Start	[E-0009 13:2 000901C]
  SH Dark Data Stop	[E-0009 13:3 000901D]
  SH Dark Send For OBS	[E-0009 13:4 000904E]
  SH Dark Send For TWS1	[E-0009 13:5 000904F]
  SH Dark Send For TWS2	[E-0009 13:6 0009050]
  SH Test On	[E-0009 14:0 0009018]
  SH Test Off	[E-0009 14:1 0009019]
  SH REF Shutter Open	[E-0009 14:2 0009028]
  SH REF Shutter Close	[E-0009 14:3 0009029]
  SH CCD Shutter Open	[E-0009 14:4 000902A]
  SH CCD Shutter Close	[E-0009 14:5 000902B]
  SH POpt Shutter PS On	[E-0009 14:6 0009012]
  SH POpt Shutter PS Off	[E-0009 14:7 0009013]
  SH Exposure Time Set ANS	[E-0009 15:0 0009040]
  SH Exposure Count Set ANS	[E-0009 15:1 0009054]
  SH REF Position Detected Start	[E-0009 15:2 0009031]
  SH REF Position Detected Stop	[E-0009 15:3 0009032]
  SH REF Position Send REQ ANS	[E-0009 15:4 000903A]
  SH PIR Shutter PS On	[E-0009 15:5 000902C]
  SH PIR Shutter PS Off	[E-0009 15:6 000902D]
  AG/SH Drive RX Error	[E-0009 16 0009048 BINARY4_0p01]
  AG/SH Drive RY Error	[E-0009 20 0009049 BINARY4_0p01]
  SH CCD Gravity Error X	[E-0009 24 000904A BINARY4_0p01]
  SH Binning Pattern	[E-0009 28 0009041 BINARY1_1]
  SH Cs Shutter PS On	[E-0009 29:0 000908F]
  SH Cs Shutter PS Off	[E-0009 29:1 0009090]
  SH NsIR Shutter PS On	[E-0009 29:2 0009091]
  SH NsIR Shutter PS Off	[E-0009 29:3 0009092]
  SH Paring Data Send REQ	[E-0009 29:5 0009024]
  SH Pairing Data Set ANS	[E-0009 29:6 0009039]
  SH Auto Pairing ANS	[E-0009 29:7 0009038]
  SH Test Result	[E-0009 30 0009006 BCD1]
  SH Sky Exposure Time	[E-0009 31 000901E BINARY4_100]
  SH Dark Exposure Time	[E-0009 35 000901F BINARY4_100]
  SH POpt Selected	[E-0009 39:0 0009007]
  SH PIR Selected	[E-0009 39:1 0009008]
  SH Cs Selected	[E-0009 39:2 0009009]
  SH NsOpt Selected	[E-0009 39:3 000900B]
  SH NsIR Selected	[E-0009 39:4 000900A]
  SH NsOpt Shutter PS On	[E-0009 39:5 0009093]
  SH NsOpt Shutter PS Off	[E-0009 39:6 0009094]
  SH Data Time Set ANS	[E-0009 39:7 0009096]
  SH Video Out OBS On	[E-0009 40:0 0009042]
  SH Video Out OBS Off	[E-0009 40:1 0009043]
  SH Video Out TWS1 On	[E-0009 40:2 0009044]
  SH Video Out TWS1 Off	[E-0009 40:3 0009045]
  SH Video Out TWS2 On	[E-0009 40:4 0009046]
  SH Video Out TWS2 Off	[E-0009 40:5 0009047]
  SH Spot Number	[E-0009 41 0009037 BINARY2_1]
  SH CCD Gravity I	[E-0009 43 0009052 BINARY2_1]
  SH OBS Output Interval	[E-0009 45 000905F BINARY1_1]
  SH TWS1 Output Interval	[E-0009 46 0009060 BINARY1_1]
  SH TWS2 Output Interval	[E-0009 47 0009061 BINARY1_1]
  SH OBS Output Interval Set ANS	[E-0009 48:0 0009062]
  SH TWS1 Output Interval Set ANS	[E-0009 48:1 0009063]
  SH TWS2 Output Interval Set ANS	[E-0009 48:2 0009064]
  ImR Used	[E-0009 48:3 0009097]
  ImR Not Used	[E-0009 48:4 0009098]
  AG/SH Drive RX Error Set ANS	[E-0009 48:5 0009099]
  AG/SH Drive RY Error Set ANS	[E-0009 48:6 000909A]
  SH Local	[E-0009 49:0 0009033]
  MLP2-SH I/F Alarm	[E-0009 49:1 0009034]
  SH VME Rack Fan Alarm	[E-0009 49:2 0009025]
  SH Camera Idle	[E-0009 49:4 0009035]
  SH Camera Busy	[E-0009 49:5 0009036]
  SH COML PWR FLT DET	[E-0009 49:6 0009026]
  SH TSC FLT IND	[E-0009 49:7 0009027]
  SH Camera I/F Alarm	[E-0009 50:0 0009065]
  SH Shutter I/F Alarm	[E-0009 50:1 0009066]
  SH-VGW I/F Alarm	[E-0009 50:2 0009067]
  SH-TWS1 I/F Alarm	[E-0009 50:4 0009068]
  SH-TWS2 I/F Alarm	[E-0009 50:5 0009069]
  Imageboard-SH Alarm	[E-0009 50:6 000906A]
  SH POpt Camera Chiller Alarm	[E-0009 51:0 000906C]
  SH POpt CCD Shutter Motor Alarm	[E-0009 51:1 000906D]
  SH POpt REF Shutter Motor Alarm	[E-0009 51:2 000906E]
  SH POpt Shutter PS Alarm	[E-0009 51:3 000906F]
  SH POpt REF PS Alarm	[E-0009 51:4 0009070]
  SH POpt REF Light On	[E-0009 51:5 0009071]
  SH POpt REF Light Off	[E-0009 51:6 0009072]
  SH PIR Camera Chiller Alarm	[E-0009 52:0 0009073]
  SH PIR CCD Shutter Motor Alarm	[E-0009 52:1 0009074]
  SH PIR REF Shutter Motor Alarm	[E-0009 52:2 0009075]
  SH PIR Shutter PS Alarm	[E-0009 52:3 0009076]
  SH PIR REF PS Alarm	[E-0009 52:4 0009077]
  SH PIR REF Light On	[E-0009 52:5 0009078]
  SH PIR REF Light Off	[E-0009 52:6 0009079]
  SH Cs Camera Chiller Alarm	[E-0009 53:0 000907A]
  SH Cs CCD Shutter Motor Alarm	[E-0009 53:1 000907B]
  SH Cs REF Shutter Motor Alarm	[E-0009 53:2 000907C]
  SH Cs Shutter PS Alarm	[E-0009 53:3 000907D]
  SH Cs REF PS Alarm	[E-0009 53:4 000907E]
  SH Cs REF Light On	[E-0009 53:5 000907F]
  SH Cs REF Light Off	[E-0009 53:6 0009080]
  SH NsOpt Camera Chiller Alarm	[E-0009 54:0 0009081]
  SH NsOpt CCD Shutter Motor Alarm	[E-0009 54:1 0009082]
  SH NsOpt REF Shutter Motor Alarm	[E-0009 54:2 0009083]
  SH NsOpt Shutter PS Alarm	[E-0009 54:3 0009084]
  SH NsOpt REF PS Alarm	[E-0009 54:4 0009085]
  SH NsOpt REF Light On	[E-0009 54:5 0009086]
  SH NsOpt REF Light Off	[E-0009 54:6 0009087]
  SH NsIR Camera Chiller Alarm	[E-0009 55:0 0009088]
  SH NsIR CCD Shutter Motor Alarm	[E-0009 55:1 0009089]
  SH NsIR REF Shutter Motor Alarm	[E-0009 55:2 000908A]
  SH NsIR Shutter PS Alarm	[E-0009 55:3 000908B]
  SH NsIR REF PS Alarm	[E-0009 55:4 000908C]
  SH NsIR REF Light On	[E-0009 55:5 000908D]
  SH NsIR REF Light Off	[E-0009 55:6 000908E]
  SH Sky Binning Pattern	[E-0009 56 0009021 BINARY1_1]
  SH Dark Binning Pattern	[E-0009 57 0009022 BINARY1_1]
  SH Background Subtraction Yes	[E-0009 58:0 000909C]
  SH Background Subtraction No	[E-0009 58:1 000909D]
  Spot Calculation SH	[E-0009 58:4 000909E]
  Spot Calculation VGW	[E-0009 58:5 000909F]
  SH CCD Gravity Error Y	[E-0009 59 0009051 BINARY4_0p01]
  SH REF V	[L-0009 0 000902F BINARY2_0p01]
  SH REF I	[L-0009 2 000902E BINARY1_0p01]
  SH CCD Temperature	[L-0009 3 0009030 BINARY4_0p01]
  Heat Exh Fan On	[E-000A 0:0 000A001]
  Heat Exh Fan Off	[E-000A 0:1 000A002]
  Heat Exh Damper Circulate Mode	[E-000A 0:4 000A003]
  Heat Exh Damper Exhaust Mode	[E-000A 0:5 000A004]
  Heat Exh Defrost On	[E-000A 1:0 000A005]
  Heat Exh Defrost Off	[E-000A 1:1 000A006]
  Heat Exh Defrost Auto	[E-000A 1:2 000A007]
  Heat Exh Coolant Circulation On	[E-000A 1:4 000A008]
  Heat Exh Coolant Circulation Off	[E-000A 1:5 000A009]
  Heat Exh Coolant Auto	[E-000A 1:6 000A011]
  Heat Exh Defrost Heater On	[E-000A 2:4 000A00C]
  Heat Exh Defrost Heater Off	[E-000A 2:5 000A00D]
  Heat Exh Local	[E-000A 3:0 000A00E]
  Heat Exh Fan Speed High	[E-000A 3:4 000A00F]
  Heat Exh Fan Speed Low	[E-000A 3:5 000A010]
  Heat Exh(IR Mirror) Alarm	[E-000A 4:0 000A00A]
  Heat Exh(Opt Mirror) Alarm	[E-000A 4:4 000A00B]
  MLP3-Heat Exh(Mirror) Alarm	[E-000A 5:0 000A012]
  IR Elevator Cassegrain FL	[E-000B 0:0 000B004]
  IR Elevator Nasmyth FL	[E-000B 0:1 000B005]
  Opt Elevator Cassegrain FL	[E-000B 0:3 000B001]
  Opt Elevator Nasmyth FL	[E-000B 0:4 000B002]
  Opt Elevator Tertiary FL	[E-000B 0:5 000B003]
  Opt Elevator Top Unit FL	[E-000B 0:6 000B007]
  Vent FL IR Outside/Vent Room DR	[E-000B 1:0 000B009]
  Vent FL Opt Outside/Vent Room DR	[E-000B 1:1 000B00A]
  Cs FL IR Side V B1/Cryogenic DR	[E-000B 1:2 000B00C]
  Cs FL Opt Side V C1 Cryogenic DR	[E-000B 1:3 000B01D]
  Cs FL IR TLSCP/Side V B1 DR	[E-000B 1:4 000B00D]
  Cs FL Opt TLSCP/Side V C1 DR	[E-000B 1:5 000B01C]
  Cs FL IR TLSCP/Air Handling DR	[E-000B 1:6 000B00F]
  Cs FL Opt TLSCP/Air Handling DR	[E-000B 1:7 000B01A]
  Cs FL IR Outside/Heat Lock DR	[E-000B 2:0 000B010]
  Cs FL Opt Outside/Heat Lock DR	[E-000B 2:1 000B019]
  Cs FL IR Heat Lock/TLSCP Mount DR	[E-000B 2:2 000B011]
  Cs FL Opt Heat Lock/TLSCP Mount DR	[E-000B 2:3 000B018]
  Cs FL IR TLSCP/Chiller DR	[E-000B 2:4 000B012]
  Cs FL Opt TLSCP/Chiller DR	[E-000B 2:5 000B017]
  Cs FL IR TLSCP/Side V A1 DR	[E-000B 2:6 000B013]
  Cs FL Opt TLSCP/Side V D1 DR	[E-000B 2:7 000B016]
  Cs FL IR TLSCP/OBSV EQPT DR	[E-000B 3:0 000B014]
  Cs FL Opt TLSCP/OBSV EQPT DR	[E-000B 3:1 000B015]
  Cs FL IR TLSCP/Under Stairwell DR	[E-000B 3:2 000B00E]
  Cs FL Opt TLSCP/Under Stairwell DR	[E-000B 3:3 000B01B]
  Cs FL IR Walk/Rear V1 DR	[E-000B 3:4 000B00B]
  Cs FL Opt R Walk/Rear V1 DR	[E-000B 3:5 000B01E]
  Ns FL IR Walk/R Walk DR	[E-000B 3:6 000B020]
  Ns FL Opt Walk/R Walk DR	[E-000B 3:7 000B029]
  Ns FL IR Side V B2/R Walk DR	[E-000B 4:0 000B021]
  Ns FL Opt Side V C2/Walk DR	[E-000B 4:1 000B028]
  Ns FL IR Side V B2/Stairwell DR	[E-000B 4:2 000B022]
  Ns FL Opt Side V C2/Stairwell DR	[E-000B 4:3 000B027]
  Ns FL IR Side V A2/ELEV Room DR	[E-000B 4:4 000B023]
  Ns FL Opt Side V D2/ELEV Room DR	[E-000B 4:5 000B026]
  Ns FL IR Side V A2/ACS Walk DR	[E-000B 4:6 000B024]
  Ns FL Opt Side V D2/ACS Walk DR	[E-000B 4:7 000B025]
  Ns FL IR R Walk/Rear V2 DR	[E-000B 5:0 000B01F]
  Ns FL Opt REAR Walk/Vent R2 DR	[E-000B 5:1 000B02A]
  TER FL IR ACS Walk/R Walk DR	[E-000B 5:2 000B02C]
  TER FL Opt ACS Walk/Rear Walk DR	[E-000B 5:3 000B035]
  TER FL IR Side V B3/ACS Walk DR	[E-000B 5:4 000B02D]
  TER FL Side V C3/ACS Walk DR	[E-000B 5:5 000B034]
  TER FL IR Walk/Side V B3 DR	[E-000B 5:6 000B02E]
  TER FL Opt Walk/Side V C3 DR	[E-000B 5:7 000B033]
  TER FL IR Walk/ELEV Motor DR	[E-000B 6:0 000B02F]
  TER FL IR Walk/Seide V A3 DR	[E-000B 6:1 000B030]
  TER FL Opt Walk/Side V D3 DR	[E-000B 6:2 000B031]
  TER FL Opt Walk/Stairwell DR	[E-000B 6:3 000B032]
  TER FL IR Rear Walk/Rear V3 DR	[E-000B 6:4 000B02B]
  TER FL Opt R Walk/Rear V3 DR	[E-000B 6:5 000B036]
  TUE FL IR ACS Walk/R Walk DR	[E-000B 6:6 000B038]
  TUE FL Opt ACS Walk/R Walk DR	[E-000B 6:7 000B047]
  TUE FL IR Side V B4/ACS Walk DR	[E-000B 7:0 000B039]
  TUE FL Opt Side V C4/ACS Walk DR	[E-000B 7:1 000B046]
  TUE FL IR Walk/Side V B4 DR	[E-000B 7:2 000B03A]
  TUE FL Opt Walk/Side V C4 DR	[E-000B 7:3 000B045]
  TUE FL IR TLSCP/Walk DR	[E-000B 7:4 000B03B]
  TUE FL Opt TLSCP/Walk DR2	[E-000B 7:5 000B043]
  TUE FL IR Walk/Side V A4 DR	[E-000B 7:6 000B03C]
  TUE FL Opt Walk/Side V D4 DR	[E-000B 7:7 000B041]
  TUE FL IR ACS Walk/Side V A4 DR	[E-000B 8:0 000B03D]
  TUE FL Opt ACS Walk/Side V D4 DR	[E-000B 8:1 000B040]
  TUE FL IR TLSCP/ACS Walk DR	[E-000B 8:2 000B03E]
  TUE FL Opt TLSCP/ACS Walk DR	[E-000B 8:3 000B03F]
  TUE FL Opt TLSCP/EXCH DR	[E-000B 8:4 000B044]
  TUE FL Opt TLSCP/Walk DR1	[E-000B 8:5 000B042]
  TUE FL IR R Walk/Rear V3 DR	[E-000B 8:6 000B037]
  TUE FL Opt R Walk/Rear V4 DR	[E-000B 8:7 000B048]
  Crane FL IR Walk/EXIT Ladder DR	[E-000B 9:0 000B049]
  Crane FL Opt Walk/Stairwell DR	[E-000B 9:1 000B04E]
  Crane FL Opt Walk/ELEV Motor DR	[E-000B 9:2 000B04D]
  Crane FL Opt ELEV PLATF/Motor DR	[E-000B 9:3 000B04C]
  Crane FL Opt Walk/CANTRY Walk DR	[E-000B 9:4 000B04B]
  Crane FL IR Walk/CANTRY Walk DR	[E-000B 9:5 000B04A]
  IR Roof/Upper PLATF DR	[E-000B 9:6 000B04F]
  Opt Roof/Upper PLATF DR	[E-000B 9:7 000B050]
  TUE Clamp On	[E-000B 10:0 000B059]
  TUE Clamp Off	[E-000B 10:1 000B05A]
  TUE Pin In	[E-000B 10:2 000B05D]
  TUE Pin OUT	[E-000B 10:3 000B05E]
  TUE Clamp Up Limit	[E-000B 10:4 000B05B]
  TUE Clamp Down Limit	[E-000B 10:5 000B05C]
  TUE Pin Inner Limit	[E-000B 10:6 000B05F]
  TUE Pin Outer Limit	[E-000B 10:7 000B060]
  TUE Hand Clamp On	[E-000B 11:0 000B061]
  TUE Hand Clamp Out	[E-000B 11:1 000B062]
  TUE Hand/Unit Connect On	[E-000B 11:2 000B063]
  TUE Hand/Unit Connect Off	[E-000B 11:3 000B064]
  TUEEL Y1 Drive Up Limit	[E-000B 11:4 000B065]
  TUEEL Y2 Drive Up Limit	[E-000B 11:5 000B066]
  TUEEL X DRIVE Up Limit	[E-000B 11:6 000B067]
  TUEUL Y Precision Drive Up Limit	[E-000B 11:7 000B068]
  TUEUL Angle Drive Up Limit	[E-000B 12:0 000B069]
  TUEUL Z(Up) Drive Up Limit	[E-000B 12:1 000B06A]
  TUEUL Z(Down) Drive Up Limit	[E-000B 12:2 000B06B]
  TUEUL Handle1 Drive Up Limit	[E-000B 12:3 000B06C]
  TUEUL Handle2 Drive Up Limit	[E-000B 12:4 000B06D]
  TUEUL Handle3 Drive Up Limit	[E-000B 12:5 000B06E]
  TUEUS Angle Drive Up Limit	[E-000B 12:6 000B06F]
  TUEUT Y(Up) Drive Up Limit	[E-000B 12:7 000B070]
  TUEUT Y(Down) Drive Up Limit	[E-000B 13:0 000B071]
  TUEUT Angle Drive Up Limit	[E-000B 13:1 000B072]
  TUEUT Z Drive Up Limit	[E-000B 13:2 000B073]
  TUEUL Y1 Drive Down Limit	[E-000B 13:3 000B074]
  TUEUL Y2 Drive Down Limit	[E-000B 13:4 000B075]
  TUEUL X Drive Down Limit	[E-000B 13:5 000B076]
  TUEUL Y Precision Drive Down Limit	[E-000B 13:6 000B077]
  TUEUL Angle Drive Down Limit	[E-000B 13:7 000B078]
  TUEUL Z(Up) Drive Down Limit	[E-000B 14:0 000B079]
  TUEUL Z(Down) Drive Down Limit	[E-000B 14:1 000B07A]
  TUEUL Handle1 Drive Down Limit	[E-000B 14:2 000B07B]
  TUEUL Handle2 Drive Down Limit	[E-000B 14:3 000B07C]
  TUEUL Handle3 Drive Down Limit	[E-000B 14:4 000B07D]
  TUEUS Angle Drive Down Limit	[E-000B 14:5 000B07E]
  TUEUT Y(Up) Drive Down Limit	[E-000B 14:6 000B07F]
  TUEUT Y(Down) Drive Down Limit	[E-000B 14:7 000B080]
  TUEUT Angle Drive Down Limit	[E-000B 15:0 000B081]
  TUEUT Z Drive Down Limit	[E-000B 15:1 000B082]
  TUEUS Unit1 In	[E-000B 15:2 000B083]
  TUEUS Unit2 In	[E-000B 15:3 000B084]
  TUEUS Unit3 In	[E-000B 15:4 000B085]
  TUEUS Unit4 In	[E-000B 15:5 000B086]
  TUEUS Unit5 In	[E-000B 15:6 000B087]
  TUEUS Unit6 In	[E-000B 15:7 000B088]
  TUEUS Unit7 In	[E-000B 16:0 000B089]
  TUEUS Position1 Selected	[E-000B 16:1 000B08A]
  TUEUS Position2 Selected	[E-000B 16:2 000B08B]
  TUEUS Position3 Selected	[E-000B 16:3 000B08C]
  TUEUS Position4 Selected	[E-000B 16:4 000B08D]
  TUEUS Position5 Selected	[E-000B 16:5 000B08E]
  TUEUS Position6 Selected	[E-000B 16:6 000B08F]
  TUEUS Position7 Selected	[E-000B 16:7 000B090]
  TUE PRESET Position1	[E-000B 17:0 000B091]
  TUE PS Alarm	[E-000B 17:1 000B092]
  TUE Logic Fault	[E-000B 17:2 000B093]
  TUE Step1 Complete	[E-000B 17:3 000B094]
  TUE Step2 Complete	[E-000B 17:4 000B09A]
  TUE Step3 Complete	[E-000B 17:5 000B09B]
  TUE Step4 Complete	[E-000B 17:6 000B09C]
  TUE Step5 Complete	[E-000B 17:7 000B09D]
  TUE Step6 Complete	[E-000B 18:0 000B09E]
  TUE Step7 Complete	[E-000B 18:1 000B09F]
  TUE Inhibit	[E-000B 18:2 000B051]
  TUE Drive Enable Interlock Release	[E-000B 18:3 000B052]
  TUE Mode Selection1	[E-000B 18:4 000B053]
  TUE Mode Selection2	[E-000B 18:5 000B054]
  TUE Power Off	[E-000B 18:6 000B0A0]
  TUE Fault	[E-000B 18:7 000B0A1]
  WMON(TLSCP) Sensor PS On	[E-000B 19:4 000B057]
  WMON(Dome) Sensor PS On	[E-000B 19:5 000B055]
  WMON(Dome) Data Logger Alarm	[E-000B 19:6 000B056]
  WMON(Dome) Sensor REMOTE Scan Alarm	[E-000B 19:7 000B058]
  Dome CT2 Alarm	[E-000B 20:0 000B0A2]
  Telescope CT2 Alarm	[E-000B 20:1 000B0A3]
  Light On	[E-000B 20:2 000B0A4]
  Yoke Floor Light On	[E-000B 20:3 000B0A5]
  Opt Pratform Light On	[E-000B 20:4 000B0A6]
  IR Pratform Light On	[E-000B 20:5 000B0A7]
  Opt Room Light On	[E-000B 20:6 000B0A8]
  IR Room Light On	[E-000B 20:7 000B0A9]
  Opt Front Room Front Side Door Open	[E-000B 21:0 000B0AA]
  Opt Front Room Side Door Open	[E-000B 21:1 000B0AB]
  Opt Room Front Side Door Open	[E-000B 21:2 000B0AC]
  Opt Room Rear Side Door Open	[E-000B 21:3 000B0AD]
  Opt CONT Room Rear Side Door Open	[E-000B 21:4 000B0AE]
  Opt CONT Room Side Door Open	[E-000B 21:5 000B0AF]
  IR CONT Room Front Door Open	[E-000B 21:6 000B0B0]
  IR CONT Room Side Door Open	[E-000B 21:7 000B0B1]
  Cs MAINT NsOpt Side Door Open	[E-000B 22:0 000B0B2]
  IDF82  MAINT Door Open	[E-000B 22:1 000B0B3]
  CS Rack2 MAINT Door Open	[E-000B 22:2 000B0B4]
  Cs MAINT NsIR Side Door Open	[E-000B 22:3 000B0B5]
  IDF81 MAINT Door Open	[E-000B 22:4 000B0B6]
  Cs Rack1 MAINT Door Open	[E-000B 22:5 000B0B7]
  Telescope Room NsOpt Side Door Open	[E-000B 22:6 000B0B8]
  Telescope Room NsIR Side Door Open	[E-000B 22:7 000B0B9]
  MCP1 Fan Alarm	[E-000B 29:0 000B095]
  MCP1 DC+12V Alarm	[E-000B 29:1 000B096]
  MCP1 DC+24V Alarm	[E-000B 29:2 000B097]
  MCP2 Fuse Alarm	[E-000B 29:3 000B098]
  MLP3-MCP1 Alarm	[E-000B 30:0 000B099]
  Weather Wind Direction(AVG)	[L-000C 0 000C001 BCD6]
  Weather Wind Velocity(AVG)	[L-000C 6 000C002 BCD6]
  Weather Wind Direction(Max.)	[L-000C 12 000C003 BCD6]
  Weather Wind Velocity(Max.)	[L-000C 18 000C004 BCD6]
  Weather Temperature	[L-000C 24 000C005 BCD6]
  Weather Humidity	[L-000C 30 000C006 BCD6]
  Weather Accumulated RainFall	[L-000C 36 000C007 BCD6]
  Weather Atmospheric Pressure	[L-000C 42 000C008 BINARY4_0p1]
  AG/SH r Drive On	[E-000D 0:0 000D008]
  AG/SH r Drive Off	[E-000D 0:1 000D009]
  AG/SH Angle Drive On	[E-000D 0:2 000D00A]
  AG/SH Angle Drive Off	[E-000D 0:3 000D00B]
  AG/SH r Drive RDY	[E-000D 0:4 000D082]
  AG/SH Angle Drive RDY	[E-000D 0:5 000D083]
  AG/SH POpt Selected	[E-000D 1:0 000D00C]
  AG/SH PIR Selected	[E-000D 1:1 000D00D]
  AG/SH Cs Selected	[E-000D 1:2 000D00E]
  AG/SH NsOpt Selected	[E-000D 1:3 000D00F]
  AG/SH NsIR Selected	[E-000D 1:4 000D010]
  AG/SH Position(Mount SYNC) Mode	[E-000D 2:0 000D02A]
  AG/SH Test Mode	[E-000D 2:1 000D012]
  AG/SH Position(Mount ASYNC) Mode	[E-000D 2:2 000D011]
  AG/SH Slew Mode	[E-000D 2:3 000D02B]
  AG/SH Limit Reset	[E-000D 2:4 000D084]
  AG/SH Home Mode	[E-000D 2:5 000D024]
  AG/SH r Cs 1st Limit -	[E-000D 5:0 000D015]
  AG/SH r Cs 1st Limit +	[E-000D 5:1 000D016]
  AG/SH Angle Cs 1st Limit -	[E-000D 5:2 000D017]
  AG/SH Angle Cs 1st Limit +	[E-000D 5:3 000D018]
  AG/SH r Cs 2nd Limit -	[E-000D 5:4 000D030]
  AG/SH r Cs 2nd Limit +	[E-000D 5:5 000D031]
  AG/SH Angle Cs 2nd Limit -	[E-000D 5:6 000D032]
  AG/SH Angle Cs 2nd Limit +	[E-000D 5:7 000D033]
  AG/SH r Cs DPA Fault	[E-000D 6:0 000D01A]
  AG/SH Angle Cs DPA Fault	[E-000D 6:1 000D01B]
  AG/SH r NsOpt DPA Fault	[E-000D 6:2 000D01C]
  AG/SH Angle NsOpt DPA Fault	[E-000D 6:3 000D01D]
  AG/SH r NsIR DPA Fault	[E-000D 6:4 000D034]
  AG/SH Angle NsIR DPA Fault	[E-000D 6:5 000D035]
  AG/SH Fault	[E-000D 7:0 000D01E]
  MLP1-AG/SH Alarm	[E-000D 7:1 000D01F]
  AG/SH Total Fan Alarm	[E-000D 7:2 000D020]
  AG/SH Local	[E-000D 7:3 000D021]
  FCs COML PWR Fault	[E-000D 7:5 000D023]
  AG/SH MAINT	[E-000D 7:6 000D022]
  AG/SH Cs ENCDR Not INIT	[E-000D 8:0 000D027]
  AG/SH r Cs ENCDR Not Zeroed	[E-000D 8:1 000D028]
  AG/SH r Cs ENCDR Zeroing	[E-000D 8:2 000D029]
  AG/SH Angle Cs ENCDR Not Zeroed	[E-000D 8:4 000D025]
  AG/SH Angle Cs ENCDR Zeroing	[E-000D 8:5 000D026]
  AG/SH NsOpt ENCDR Not INIT	[E-000D 9:0 000D039]
  AG/SH r NsOpt ENCDR Not Zeroed	[E-000D 9:1 000D03A]
  AG/SH r NsOpt ENCDR Zeroing	[E-000D 9:2 000D03B]
  AG/SH Angle NsOpt ENCDR Not INIT	[E-000D 9:4 000D037]
  AG/SH Angle NsOpt ENCDR Not Zeroed	[E-000D 9:5 000D038]
  AG/SH NsIR ENCDR Not INIT	[E-000D 10:0 000D03F]
  AG/SH r NsIR ENCDR Not Zeroed	[E-000D 10:1 000D040]
  AG/SH r NsIR ENCDR Zeroing	[E-000D 10:2 000D041]
  AG/SH Angle NsIR ENCDR Not INIT	[E-000D 10:4 000D03D]
  AG/SH Angle NsIR ENCDR Not Zeroed	[E-000D 10:5 000D03E]
  AG/SH r Cs ENCDR-1 Alarm	[E-000D 11:0 000D042]
  AG/SH r Cs ENCDR-2 Alarm	[E-000D 11:1 000D043]
  AG/SH r Cs ENCDR-1 Not Used	[E-000D 11:2 000D044]
  AG/SH r Cs ENCDR-2 Not Used	[E-000D 11:3 000D045]
  AG/SH Angle Cs ENCDR-1 Alarm	[E-000D 12:0 000D046]
  AG/SH Angle Cs ENCDR-2 Alarm	[E-000D 12:1 000D047]
  AG/SH Angle Cs ENCDR-3 Alarm	[E-000D 12:2 000D048]
  AG/SH Angle Cs ENCDR-4 Alarm	[E-000D 12:3 000D049]
  AG/SH Angle Cs ENCDR-1 Not Used	[E-000D 12:4 000D04A]
  AG/SH Angle Cs ENCDR-2 Not Used	[E-000D 12:5 000D04B]
  AG/SH Angle Cs ENCDR-3 Not Used	[E-000D 12:6 000D04C]
  AG/SH Angle Cs ENCDR-4 Not Used	[E-000D 12:7 000D04D]
  AG/SH r NsOpt ENCDR-1 Alarm	[E-000D 13:0 000D04E]
  AG/SH r NsOpt ENCDR-2 Alarm	[E-000D 13:1 000D04F]
  AG/SH r NsOpt ENCDR-1 Not Used	[E-000D 13:2 000D050]
  AG/SH r NsOpt ENCDR-2 Not Used	[E-000D 13:3 000D051]
  AG/SH Angle NsOpt ENCDR-1 Alarm	[E-000D 14:0 000D052]
  AG/SH Angle NsOpt ENCDR-2 Alarm	[E-000D 14:1 000D053]
  AG/SH Angle NsOpt ENCDR-3 Alarm	[E-000D 14:2 000D054]
  AG/SH Angle NsOpt ENCDR-4 Alarm	[E-000D 14:3 000D055]
  AG/SH Angle NsOpt ENCDR-1 Not Used	[E-000D 14:4 000D056]
  AG/SH Angle NsOpt ENCDR-2 Not Used	[E-000D 14:5 000D057]
  AG/SH Angle NsOpt ENCDR-3 Not Used	[E-000D 14:6 000D058]
  AG/SH Angle NsOpt ENCDR-4 Not Used	[E-000D 14:7 000D059]
  AG/SH r NsIR ENCDR-1 Alarm	[E-000D 15:0 000D05A]
  AG/SH r NsIR ENCDR-2 Alarm	[E-000D 15:1 000D05B]
  AG/SH r NsIR ENCDR-1 Not Used	[E-000D 15:2 000D05C]
  AG/SH r NsIR ENCDR-2 Not Used	[E-000D 15:3 000D05D]
  AG/SH Angle NsIR ENCDR-1 Alarm	[E-000D 16:0 000D05E]
  AG/SH Angle NsIR ENCDR-2 Alarm	[E-000D 16:1 000D05F]
  AG/SH Angle NsIR ENCDR-3 Alarm	[E-000D 16:2 000D060]
  AG/SH Angle NsIR ENCDR-4 Alarm	[E-000D 16:3 000D061]
  AG/SH Angle NsIR ENCDR-1 Not Used	[E-000D 16:4 000D062]
  AG/SH Angle NsIR ENCDR-2 Not Used	[E-000D 16:5 000D063]
  AG/SH Angle NsIR ENCDR-3 Not Used	[E-000D 16:6 000D064]
  AG/SH Angle NsIR ENCDR-4 Not Used	[E-000D 16:7 000D065]
  AG/SH r NsOpt 1st Limit -	[E-000D 17:0 000D066]
  AG/SH r NsOpt 1st Limit +	[E-000D 17:1 000D067]
  AG/SH Angle NsOpt 1st Limit -	[E-000D 17:2 000D068]
  AG/SH Angle NsOpt 1st Limit +	[E-000D 17:3 000D069]
  AG/SH r NsOpt 2nd Limit -	[E-000D 17:4 000D06A]
  AG/SH r NsOpt 2nd Limit +	[E-000D 17:5 000D06B]
  AG/SH Angle NsOpt 2nd Limit -	[E-000D 17:6 000D06C]
  AG/SH Angle NsOpt 2nd Limit +	[E-000D 17:7 000D06D]
  AG/SH r NsIR 1st Limit -	[E-000D 18:0 000D06E]
  AG/SH r NsIR 1st Limit +	[E-000D 18:1 000D06F]
  AG/SH Angle NsIR 1st Limit -	[E-000D 18:2 000D070]
  AG/SH Angle NsIR 1st Limit +	[E-000D 18:3 000D071]
  AG/SH r NsIR 2nd Limit -	[E-000D 18:4 000D072]
  AG/SH r NsIR 2nd Limit +	[E-000D 18:5 000D073]
  AG/SH Angle NsIR 2nd Limit -	[E-000D 18:6 000D074]
  AG/SH Angle NsIR 2nd Limit +	[E-000D 18:7 000D075]
  AG/SH DPA(Cs) Fault	[E-000D 19:0 000D076]
  AG/SH DPA(NsOpt) Fault	[E-000D 19:1 000D077]
  AG/SH DPA(NsIR) Fault	[E-000D 19:2 000D078]
  TCSPU2/5(NsIR) Fault on FPCI	[E-000D 20:0 000D079]
  TCSPU3/6(NsOpt) Fault on FPCI	[E-000D 20:1 000D07A]
  TCSPU1/4(Cs) Fault on FPCI	[E-000D 20:2 000D07B]
  TCADU2(AG/SH) Fault	[E-000D 20:3 000D07C]
  TCADU3(AG/SH) Fault	[E-000D 20:4 000D07D]
  TCADU4(AG/SH) Fault	[E-000D 20:5 000D07E]
  AG/SH Safety SW	[E-000D 20:6 000D019]
  AG/SH EMER Stop	[E-000D 20:7 000D07F]
  AG/SH Test Pattern	[E-000D 28 000D013 BCD1]
  AG/SH Test Result	[E-000D 29 000D014 BCD1]
  AG/SH Test RDY	[E-000D 29:0 000D02C]
  AG/SH Test	[E-000D 29:1 000D02D]
  AG/SH Test Data Send	[E-000D 29:2 000D02E]
  AG/SH Test Data End	[E-000D 29:3 000D02F]
  AG/SH r Real Position	[L-000D 0 000D001 BCD6]
  AG/SH Real Angle	[L-000D 6 000D002 BCD6]
  AG/SH r CMD Position ANS	[L-000D 12 000D003 BCD6]
  AG/SH CMD Angle ANS	[L-000D 18 000D004 BCD6]
  AG/SH r Position Error	[L-000D 24 000D005 BCD6]
  AG/SH Angle Error	[L-000D 30 000D006 BCD6]
  AG/SH r Rate REF	[L-000D 42 000D085 BCD6]
  AG/SH Angle Rate REF	[L-000D 48 000D086 BCD6]
  AG/SH r Rate FDBK-A	[L-000D 54 000D087 BCD6]
  AG/SH r Rate FDBK-B	[L-000D 60 000D088 BCD6]
  AG/SH Angle Rate FDBK-A	[L-000D 66 000D089 BCD6]
  AG/SH Angle Rate FDBK-B	[L-000D 72 000D08A BCD6]
  AG/SH r Current REF-A	[L-000D 78 000D08B BCD6]
  AG/SH r Current REF-B	[L-000D 84 000D08C BCD6]
  AG/SH Angle Current REF-A	[L-000D 90 000D08D BCD6]
  AG/SH Angle Current REF-B	[L-000D 96 000D08E BCD6]
  AG/SH Data SMPLG Time	[L-000D 102 000D007 BCD6]
  AG/SH CMD VEL ANS	[L-000D 108 000D080 BCD6]
  AG/SH Data SMPLG INTVL	[L-000D 114 000D081 BCD6]
  Cal Source P1(Rear) Selected	[E-000E 24:0 000E00F]
  Cal Source P2(Front) Selected	[E-000E 24:1 000E010]
  Cal Source Cs Selected	[E-000E 24:2 000E011]
  Cal Source NsIR Selected	[E-000E 24:3 000E012]
  Cal Source NsOpt Selected	[E-000E 24:4 000E013]
  Cal Source Normal Mode	[E-000E 25:0 000E014]
  Cal Source Test Mode	[E-000E 25:1 000E015]
  Cal Source Test Pattern	[E-000E 26 000E016 BCD1]
  Cal Source Test Result	[E-000E 27 000E017 BCD1]
  Cal Source R Drive On	[E-000E 30:0 000E018]
  Cal Source R Drive Off	[E-000E 30:1 000E019]
  Cal Source Retract(Home Position)	[E-000E 30:2 000E01A]
  Cal Source Drive Ready	[E-000E 30:3 000E047]
  Cal Source H.C1 Selected	[E-000E 31:0 000E01B]
  Cal Source H.C2 Selected	[E-000E 31:1 000E01C]
  Cal Source H.C Retract	[E-000E 31:2 000E01D]
  Cal Source TurretA Holder1 Selected	[E-000E 32:0 000E01E]
  Cal Source TurretA Holder2 Selected	[E-000E 32:1 000E01F]
  Cal Source TurretA Holder3 Selected	[E-000E 32:2 000E020]
  Cal Source TurretA Holder4 Selected	[E-000E 32:3 000E021]
  Cal Source TurretB Holder1 Selected	[E-000E 33:0 000E022]
  Cal Source TurretB Holder2 Selected	[E-000E 33:1 000E023]
  Cal Source TurretB Holder3 Selected	[E-000E 33:2 000E024]
  Cal Source TurretB Holder4 Selected	[E-000E 33:3 000E025]
  Cal Source TurretC Holder1 Selected	[E-000E 34:0 000E026]
  Cal Source TurretC Holder2 Selected	[E-000E 34:1 000E027]
  Cal Source TurretC Holder3 Selected	[E-000E 34:2 000E028]
  Cal Source TurretC Holder4 Selected	[E-000E 34:3 000E029]
  Cal Source TurretD Holder1 Selected	[E-000E 35:0 000E02A]
  Cal Source TurretD Holder2 Selected	[E-000E 35:1 000E02B]
  Cal Source TurretD Holder3 Selected	[E-000E 35:2 000E02C]
  Cal Source TurretD Holder4 Selected	[E-000E 35:3 000E02D]
  Cal Source Cs H.C1 On	[E-000E 36:0 000E02E]
  Cal Source Cs H.C1 Off	[E-000E 36:1 000E02F]
  Cal Source NsOpt H.C1 On	[E-000E 36:2 000E050]
  Cal Source NsOpt H.C1 Off	[E-000E 36:3 000E051]
  Cal Source P1(Rear) H.C1 On	[E-000E 36:4 000E052]
  Cal Source P1(Rear) H.C1 Off	[E-000E 36:5 000E053]
  Cal Source P2(Front) H.C1 On	[E-000E 36:6 000E054]
  Cal Source P2(Front) H.C1 Off	[E-000E 36:7 000E055]
  Cal Source Cs H.C2 On	[E-000E 37:0 000E030]
  Cal Source Cs H.C2 Off	[E-000E 37:1 000E031]
  Cal Source NsOpt H.C2 On	[E-000E 37:2 000E056]
  Cal Source NsOpt H.C2 Off	[E-000E 37:3 000E057]
  Cal Source Cs Halogen1 On	[E-000E 38:0 000E032]
  Cal Source Cs Halogen1 Off	[E-000E 38:1 000E033]
  Cal Source NsOpt Halogen1 On	[E-000E 38:2 000E058]
  Cal Source NsOpt Halogen1 Off	[E-000E 38:3 000E059]
  Cal Source NsIR Halogen1 On	[E-000E 38:4 000E05A]
  Cal Source NsIR Halogen1 Off	[E-000E 38:5 000E05B]
  Cal Source Cs Halogen2 On	[E-000E 39:0 000E034]
  Cal Source Cs Halogen2 Off	[E-000E 39:1 000E035]
  Cal Source NsOpt Halogen2 On	[E-000E 39:2 000E05C]
  Cal Source NsOpt Halogen2 Off	[E-000E 39:3 000E05D]
  Cal Source NsIR Halogen2 On	[E-000E 39:4 000E05E]
  Cal Source NsIR Halogen2 Off	[E-000E 39:5 000E05F]
  Cal Source Cs Rare Gas1 On	[E-000E 40:0 000E036]
  Cal Source Cs Rare Gas1 Off	[E-000E 40:1 000E037]
  Cal Source NsIR Rare Gas1 On	[E-000E 40:4 000E060]
  Cal Source NsIR Rare Gas1 Off	[E-000E 40:5 000E061]
  Cal Source Cs Rare Gas2 On	[E-000E 41:0 000E038]
  Cal Source Cs Rare Gas2 Off	[E-000E 41:1 000E039]
  Cal Source NsIR Rare Gas2 On	[E-000E 41:4 000E062]
  Cal Source NsIR Rare Gas2 Off	[E-000E 41:5 000E063]
  Cal Source Cs Shutter Open	[E-000E 42:0 000E03A]
  Cal Source Cs Shutter Close	[E-000E 42:1 000E03B]
  Cal Source NsOpt Shutter Open	[E-000E 42:2 000E064]
  Cal Source NsOpt Shutter Close	[E-000E 42:3 000E065]
  Cal Source NsIR Shutter Open	[E-000E 42:4 000E066]
  Cal Source NsIR Shutter Close	[E-000E 42:5 000E067]
  Cal Source Cs Cooling Fan On	[E-000E 43:0 000E03C]
  Cal Source Cs Cooling Fan Off	[E-000E 43:1 000E03D]
  Cal Source NsOpt Cooling Fan On	[E-000E 43:2 000E068]
  Cal Source NsOpt Cooling Fan Off	[E-000E 43:3 000E069]
  Cal Source NsIR Cooling Fan On	[E-000E 43:4 000E06A]
  Cal Source NsIR Cooling Fan Off	[E-000E 43:5 000E06B]
  TSC Fault	[E-000E 44:0 000E03E]
  Cal Source CMPL PWR Fault DET	[E-000E 44:1 000E03F]
  Cal Source EMER Stop	[E-000E 44:7 000E042]
  Cal Source Cs R Limit +	[E-000E 45:0 000E040]
  Cal Source Cs R Limit -	[E-000E 45:1 000E041]
  Cal Source Cs ENCDR Alarm	[E-000E 45:2 000E06C]
  Cal Source Cs H.C Drive Limit INSR	[E-000E 45:3 000E043]
  Cal Source Cs H.C Drive Limit RETR	[E-000E 45:4 000E044]
  Cal Source Cs Shutter Open Limit	[E-000E 45:5 000E06D]
  Cal Source Cs Shutter Close Limit	[E-000E 45:6 000E06E]
  Cal Source Cs Cooling Fan Alarm	[E-000E 45:7 000E06F]
  Cal Source Cs INTLK SW	[E-000E 46:0 000E045]
  AO-Cal Cs INTLK SW	[E-000E 46:1 000E046]
  Cal Source NsOpt INTLK SW	[E-000E 46:2 000E072]
  AO-Cal NsOpt INTLK SW	[E-000E 46:3 000E073]
  Cal Source NsIR INTLK SW	[E-000E 46:4 000E070]
  AO-Cal NsIR INTLK SW	[E-000E 46:5 000E071]
  MLP3-Cal Source Alarm	[E-000E 47:0 000E048]
  Cal Source Panel No1 Fan Alarm	[E-000E 47:1 000E049]
  Cal Source Panel No2 Fan Alarm	[E-000E 47:2 000E04A]
  Cal Source Panel No2-No1 Alarm	[E-000E 47:4 000E04B]
  Cal Source Fault	[E-000E 48:0 000E04C]
  Cal Source PS(5/15V) Fault	[E-000E 48:1 000E04D]
  Cal Source PS(24V) Fault	[E-000E 48:2 000E04F]
  Cal Source Local	[E-000E 49:1 000E04E]
  Cal Source Cs ENCDR Not Zeroed	[E-000E 50:0 000E074]
  Cal Source NsOpt ENCDR Not Zeroed	[E-000E 50:1 000E075]
  Cal Source NsIR ENCDR Not Zeroed	[E-000E 50:2 000E076]
  Cal Source Cs ENCDR Zeroing	[E-000E 50:3 000E08A]
  Cal Source NsOpt ENCDR Zeroing	[E-000E 50:4 000E08B]
  Cal Source NsIR ENCDR Zeroing	[E-000E 50:5 000E08C]
  Cal Source NsOpt R Limit +	[E-000E 51:0 000E077]
  Cal Source NsOpt R Limit -	[E-000E 51:1 000E078]
  Cal Source NsOpt ENCDR Alarm	[E-000E 51:2 000E079]
  Cal Source NsOpt H.C Limit In	[E-000E 51:3 000E07A]
  Cal Source NsOpt H.C Limit Out	[E-000E 51:4 000E07B]
  Cal Source NsOpt Shutter Open LIM	[E-000E 51:5 000E07C]
  Cal Source NsOpt Shutter Close LIM	[E-000E 51:6 000E07D]
  Cal Source NsOpt Cooling Fan Alarm	[E-000E 51:7 000E07E]
  Cal Source NsIR R Limit +	[E-000E 52:0 000E07F]
  Cal Source NsIR R Limit -	[E-000E 52:1 000E080]
  Cal Source NsIR ENCDR Alarm	[E-000E 52:2 000E081]
  Cal Source NsIR Shutter Open Limit	[E-000E 52:5 000E082]
  Cal Source NsIR Shutter Close Limit	[E-000E 52:6 000E083]
  Cal Source NsIR Cooling Fan Alarm	[E-000E 52:7 000E084]
  Cal Source Cs Scan Overload	[E-000E 53:0 000E085]
  Cal Source NsOpt Scan Overload	[E-000E 53:1 000E086]
  Cal Source NsIR Scan Overload	[E-000E 53:2 000E087]
  Cal Source Cs Lamp Overload	[E-000E 53:3 000E088]
  Cal Source NsOpt Lamp Overload	[E-000E 53:4 000E089]
  Cal Source P1(Rear) Filter Out	[E-000E 54:0 000E08D]
  Cal Source P1(Rear) Filter In	[E-000E 54:1 000E08E]
  Cal Source P2(Front) Filter Out	[E-000E 54:2 000E08F]
  Cal Source P2(Front) Filter In	[E-000E 54:3 000E090]
  Cal Source CONT Busy	[E-000E 55:0 000E00B]
  Cal Source CONT R Drive Busy	[E-000E 55:1 000E00C]
  Cal Source CONT H.C Selected Busy	[E-000E 55:2 000E00D]
  POL Cs INTLK SW	[E-000E 56:0 000E091]
  POL NsIR INTLK SW	[E-000E 56:1 000E092]
  POL NsOpt INTLK SW	[E-000E 56:2 000E093]
  Cal Source R Real Position	[L-000E 0 000E001 BCD6]
  Cal Source R CMD Position	[L-000E 6 000E002 BCD6]
  Cal Source H.C1 Real Current	[L-000E 12 000E003 BCD6]
  Cal Source H.C1 CMD Current	[L-000E 18 000E004 BCD6]
  Cal Source H.C2 Real Current	[L-000E 24 000E005 BCD6]
  Cal Source H.C2 CMD Current	[L-000E 30 000E006 BCD6]
  Cal Source Halogen1 Real Current	[L-000E 36 000E007 BCD6]
  Cal Source Halogen1 CMD Current	[L-000E 42 000E008 BCD6]
  Cal Source Halogen2 Real Current	[L-000E 48 000E009 BCD6]
  Cal Source Halogen2 CMD Current	[L-000E 54 000E00A BCD6]
  Aluminizing Algon Pressure Alarm	[E-0010 0:0 001001F]
  Aluminizing Air Pressure  Alarm	[E-0010 0:1 0010020]
  Aluminizing LN2 Pressure Alarm	[E-0010 0:2 0010021]
  Aluminizing GN2 Chanber Press Alarm	[E-0010 0:3 0010022]
  Aluminizing GN2 Edge Seal Alarm	[E-0010 0:4 0010023]
  Aluminizing GN2 Cryopump Alarm	[E-0010 0:5 0010024]
  Aluminizing Plant Manual Mode	[E-0010 2:0 0010025]
  Aluminizing Plant Chanber Lift Mode	[E-0010 2:1 0010026]
  Aluminizing Plant Aluminizing Mode	[E-0010 2:3 0010027]
  Aluminizing Plant Storing Mode	[E-0010 2:4 0010028]
  Aluminizing Plant Filament Mode	[E-0010 2:5 0010029]
  Aluminizing Plant Testing Mode	[E-0010 2:6 001002A]
  Aluminizing CryopumpA Regeneration	[E-0010 2:7 001002B]
  Aluminizing CryopumpB Regeneration	[E-0010 3:0 001002C]
  Aluminizing CryopumpC Regeneration	[E-0010 3:1 001002D]
  Aluminizing CryopumpA Cooldown	[E-0010 3:2 001002E]
  Aluminizing CryopumpB Cooldown	[E-0010 3:3 001002F]
  Aluminizing CryopumpC Cooldown	[E-0010 3:4 0010030]
  Aluminizing Cooling Water Manual	[E-0010 4:0 0010031]
  Aluminizing Cooling Water Auto	[E-0010 4:1 0010032]
  Aluminizing Cooling Water Enabled	[E-0010 4:2 0010033]
  Aluminizing Cooling Water Start Up	[E-0010 4:4 0010034]
  Aluminizing Rough Vacuum Manual	[E-0010 4:7 0010035]
  Aluminizing Rough Vacuum Stanby	[E-0010 5:0 0010036]
  Aluminizing Rough Vacuum Pumping	[E-0010 5:1 0010037]
  Aluminizing Rough Vacuum Setup	[E-0010 5:3 0010038]
  Aluminizing High Vacuum Manual Mode	[E-0010 6:0 0010039]
  Aluminizing High Vacuum Pumping	[E-0010 6:1 001003A]
  Aluminizing High Vacuum Enabled	[E-0010 6:2 001003B]
  Aluminizing High Vacuum Cooldown	[E-0010 6:3 001003C]
  Aluminizing CryopumpA Valve Open	[E-0010 6:4 001003D]
  Aluminizing CryopumpB Valve Open	[E-0010 6:6 001003E]
  Aluminizing CryopumpC Valve Open	[E-0010 7:0 001003F]
  Aluminizing CryopumpA LN2 Level Low	[E-0010 7:3 0010040]
  Aluminizing CryopumpA LN2 High	[E-0010 7:4 0010041]
  Aluminizing CryopumpA LN2 Alarm	[E-0010 7:5 0010042]
  Aluminizing CryopumpB LN2 Low	[E-0010 7:6 0010043]
  Aluminizing CryopumpB LN2 High	[E-0010 7:7 0010044]
  Aluminizing CryopumpB LN2 Alarm	[E-0010 8:0 0010045]
  Aluminizing CryopumpC LN2 Low	[E-0010 8:1 0010046]
  Aluminizing CryopumpC LN2 High	[E-0010 8:2 0010047]
  Aluminizing CryopumpC LN2 Alarm	[E-0010 8:3 0010048]
  Aluminizing Meissner Coil LN2 Low	[E-0010 8:4 0010049]
  Aluminizing Meissner Coil LN2  High	[E-0010 8:5 001004A]
  Aluminizing Meissner Coil LN2 Alarm	[E-0010 8:6 001004B]
  Aluminizing Regen Manual Test Mode	[E-0010 8:7 001004C]
  Aluminizing Regen Auto Mode	[E-0010 9:0 001004D]
  Aluminizing Regen Enabled	[E-0010 9:1 001004E]
  Aluminizing Glow Discharge Manual	[E-0010 10:0 001004F]
  Aluminizing Glow Discharge Auto	[E-0010 10:1 0010050]
  Aluminizing Glow Discharge Enable	[E-0010 10:2 0010051]
  Aluminizing Glow Discharge Start Up	[E-0010 10:4 0010052]
  Aluminizing Filament Manual Mode	[E-0010 10:7 0010053]
  Aluminizing Filament Zone1	[E-0010 11:2 0010054]
  Aluminizing Filament Zone2	[E-0010 11:3 0010055]
  Aluminizing Filament Zone3	[E-0010 11:4 0010056]
  Aluminizing Filament Zone4	[E-0010 11:5 0010057]
  Aluminizing Filament Enabled	[E-0010 11:6 0010058]
  Aluminizing Filament Start Up	[E-0010 11:7 0010059]
  Aluminizing Lift Running Up	[E-0010 12:2 001005A]
  Aluminizing Lift Running Down	[E-0010 12:3 001005B]
  Aluminizing Lift Enabled	[E-0010 12:4 001005C]
  Aluminizing Lift Position Closed	[E-0010 12:5 001005D]
  Aluminizing Lift Position Open	[E-0010 12:6 001005E]
  Aluminizing Lift Position At 3 Inch	[E-0010 12:7 001005F]
  Aluminizing VENT Manual	[E-0010 13:1 0010060]
  Aluminizing VENT Auto	[E-0010 13:2 0010061]
  Aluminizing VENT Enabled	[E-0010 13:3 0010062]
  Aluminizing VENT Start Up	[E-0010 13:4 0010063]
  Oil PRESS CB Off	[E-0010 14:6 0010064]
  AZ Low Pressure Alarm	[E-0010 14:7 0010065]
  EL Low Pressure Alarm	[E-0010 15:0 0010073]
  MCP2 Normal Mode	[E-0010 24:0 0010001]
  MCP2 Test Mode	[E-0010 24:1 0010002]
  MCP2 Test Pattern	[E-0010 25:0 0010003]
  MCP2 Test Result	[E-0010 26:0 0010004]
  DCMOPU2 Fan Alarm	[E-0010 27:0 0010005]
  DCMOPU2 DC+12V Alarm	[E-0010 27:1 0010006]
  DCMOPU DC+24V Alarm	[E-0010 27:2 0010007]
  MOPU2 Fan Alarm	[E-0010 27:3 0010008]
  MLP3-MCP2 Alarm	[E-0010 28:0 0010009]
  Aluminizing-MCP2 Alarm(RS-422)	[E-0010 28:1 001000A]
  Aluminizing-MCP2 Alarm(RS-485)	[E-0010 28:2 001000B]
  Aluminizing Power On	[E-0010 28:3 001000C]
  Hydrostatic-MCP2 Alarm	[E-0010 28:4 001000D]
  Aluminizing Sensor Alarm	[E-0010 28:5 001000E]
  Aluminizing DIFF Sensor Alarm	[E-0010 28:6 001000F]
  Aluminizing Utility Alarm	[E-0010 28:7 0010010]
  Aluminizing Chanber Press1 Alarm	[E-0010 29:0 0010066]
  Aluminizing Storing Press Over	[E-0010 29:1 0010067]
  Aluminizing Chanber Press2 Alarm	[E-0010 29:2 0010068]
  Aluminizing Chanber DIFF Alarm	[E-0010 29:3 0010069]
  Aluminizing Storing Press Alarm	[E-0010 29:4 0010070]
  Aluminizing CryopumpA Tem Alarm	[E-0010 30:0 001006A]
  Aluminizing CryopumpB Temp Alarm	[E-0010 30:1 001006B]
  Aluminizing CryopumpC Temp Alarm	[E-0010 30:2 001006C]
  Aluminizing CryopumpA Press Alarm	[E-0010 30:3 001006D]
  Aluminizing CryopumpB Press Alarm	[E-0010 30:4 001006E]
  Aluminizing CryopumpC Press Alarm	[E-0010 30:5 001006F]
  Aluminizing Chanber Press1 Not Used	[E-0010 31:0 0010071]
  Aluminizing Chanber Press2 Not Used	[E-0010 31:1 0010072]
  Aluminizing Chanber Pressure1(Torr)	[L-0010 0 0010011 REAL8]
  Aluminizing Chanber Pressure1(pa)	[L-0010 8 0010012 REAL8]
  Aluminizing Chanber Pressure2	[L-0010 16 0010013 REAL8]
  Aluminizing Chanber DIFF Pressure	[L-0010 24 0010014 BCD6]
  Aluminizing Cryopump A Temperature	[L-0010 30 0010015 BCD6]
  Aluminizing Cryopump B Temperature	[L-0010 36 0010016 BCD6]
  Aluminizing Cryopump C Temperature	[L-0010 42 0010017 BCD6]
  Aluminizing Cryopump A Pressure	[L-0010 48 0010018 REAL8]
  Aluminizing Cryopump B Pressure	[L-0010 56 0010019 REAL8]
  Aluminizing Cryopump C Pressure	[L-0010 64 001001A REAL8]
  Aluminizing Hour Time	[L-0010 72 001001B BCD6]
  Aluminizing Minute Time	[L-0010 78 001001C BCD6]
  Aluminizing Second Time	[L-0010 84 001001D BCD6]
  Aluminizing Storing Pressure	[L-0010 96 001001E REAL8]
  Cover Test Mode	[E-0024 0:0 0024002]
  Cover Normal Mode	[E-0024 0:1 0024001]
  Cover Test Pattern	[E-0024 1 0024003 BCD1]
  Cover Test Result	[E-0024 2 0024004 BCD1]
  PM Cover Upper U-1A Open	[E-0024 3:0 0024007]
  PM Cover Upper U-1A Close	[E-0024 3:2 0024009]
  PM Cover Upper U-1B Open	[E-0024 3:4 002400B]
  PM Cover Upper U-1B Close	[E-0024 3:6 002400D]
  PM Cover Upper U-2A Open	[E-0024 4:0 002400F]
  PM Cover Upper U-2A Close	[E-0024 4:2 0024011]
  PM Cover Upper U-2B Open	[E-0024 4:4 0024013]
  PM Cover Upper U-2B Close	[E-0024 4:6 0024015]
  PM Cover Upper U-3A Open	[E-0024 5:0 0024017]
  PM Cover Upper U-3A Close	[E-0024 5:2 0024019]
  PM Cover Upper U-3B Open	[E-0024 5:4 002401B]
  PM Cover Upper U-3B Close	[E-0024 5:6 002401D]
  PM Cover Upper U-3C Open	[E-0024 6:0 002401F]
  PM Cover Upper U-3C Close	[E-0024 6:2 0024021]
  PM Cover Upper U-3D Open	[E-0024 6:4 0024023]
  PM Cover Upper U-3D Close	[E-0024 6:6 0024025]
  PM Cover Lower L-A Open	[E-0024 7:0 0024027]
  PM Cover Lower L-A Close	[E-0024 7:2 0024029]
  PM Cover Lower L-B Open	[E-0024 7:4 002402B]
  PM Cover Lower L-B Close	[E-0024 7:6 002402D]
  PM Cover Lower L-C Open	[E-0024 8:0 002402F]
  PM Cover Lower L-C Close	[E-0024 8:2 0024031]
  PM Cover Lower L-D Open	[E-0024 8:4 0024033]
  PM Cover Lower L-D Close	[E-0024 8:6 0024035]
  PM Cover Door U-1A-I Open	[E-0024 9:0 0024037]
  PM Cover Door U-1A-I Close	[E-0024 9:2 0024039]
  PM Cover Door U-1B-I Open	[E-0024 9:4 002403B]
  PM Cover Door U-1B-I Close	[E-0024 9:6 002403D]
  PM Cover Door U-2A-I-A Open	[E-0024 10:0 002403F]
  PM Cover Door U-2A-I-A Close	[E-0024 10:2 0024041]
  PM Cover Door U-2A-I-B Open	[E-0024 10:4 0024043]
  PM Cover Door U-2A-I-B Close	[E-0024 10:6 0024045]
  PM Cover Door U-2B-I-A Open	[E-0024 11:0 0024047]
  PM Cover Door U-2B-I-A Close	[E-0024 11:2 0024049]
  PM Cover Door U-2B-I-B Open	[E-0024 11:4 002404B]
  PM Cover Door U-2B-I-B Close	[E-0024 11:6 002404D]
  PM Cover Door U-3A-I Open	[E-0024 12:0 002404F]
  PM Cover Door U-3A-I Close	[E-0024 12:2 0024051]
  PM Cover Door U-3B-I Open	[E-0024 12:4 0024053]
  PM Cover Door U-3B-I Close	[E-0024 12:6 0024055]
  PM Cover Door U-3C-I Open	[E-0024 13:0 00240EB]
  PM Cover Door U-3C-I Close	[E-0024 13:2 00240ED]
  PM Cover Door U-3D-I Open	[E-0024 13:4 00240EF]
  PM Cover Door U-3D-I Close	[E-0024 13:6 00240F1]
  PM/M3 Cover Open OPN	[E-0024 14:0 0024005]
  PM/M3 Cover Close OPN	[E-0024 14:1 0024006]
  PM/M3 Cover Stop	[E-0024 14:2 0024057]
  Cell Cover Open OPN	[E-0024 15:0 002405A]
  Cell Cover Close OPN	[E-0024 15:1 002405B]
  Cell Cover Stop	[E-0024 15:2 0024059]
  Cover EMER Stop	[E-0024 16:0 002405C]
  Cover Drive Safety	[E-0024 16:1 0024058]
  Cover Local	[E-0024 17:4 0024062]
  Cover MAINT	[E-0024 17:5 0024008]
  M3 Cover Open	[E-0024 19:0 0024064]
  M3 Cover Close	[E-0024 19:2 0024066]
  Cell Cover Open	[E-0024 20:0 0024068]
  Cell Cover Close	[E-0024 20:2 002406A]
  PM/M3 Cover All Open RDY	[E-0024 26:0 0024074]
  PM Cover Cover Upper All Open RDY	[E-0024 27:0 0024075]
  PM Cover Upper U-1A Open RDY	[E-0024 28:0 0024076]
  PM Cover Upper U-1B Open RDY	[E-0024 28:1 0024077]
  PM Cover Upper U-2A Open RDY	[E-0024 28:2 0024078]
  PM Cover Upper U-2B Open RDY	[E-0024 28:3 0024079]
  PM Cover Upper U-3A Open RDY	[E-0024 29:0 002407A]
  PM Cover Upper U-3B Open RDY	[E-0024 29:1 002407B]
  PM Cover Upper U-3C Open RDY	[E-0024 29:2 002407C]
  PM Cover Upper U-3D Open RDY	[E-0024 29:3 002407D]
  PM Cover Lower All Open RDY	[E-0024 30:0 002407E]
  PM Cover Lower L-A Open RDY	[E-0024 31:0 002407F]
  PM Cover Lower L-B Open RDY	[E-0024 31:1 0024080]
  PM Cover Lower L-C Open RDY	[E-0024 31:2 0024081]
  PM Cover Lower L-D Open RDY	[E-0024 31:3 0024082]
  PM Cover Door All Open RDY	[E-0024 32:0 0024083]
  PM Cover Door U-1A-I Open RDY	[E-0024 33:0 0024084]
  PM Cover Door U-1B-I Open RDY	[E-0024 33:1 0024085]
  PM Cover Door U-2A-I Open RDY	[E-0024 33:2 0024086]
  PM Cover Door U-2B-I Open RDY	[E-0024 33:3 0024087]
  PM Cover Door U-3A-I Open RDY	[E-0024 34:0 0024088]
  PM Cover Door U-3B-I Open RDY	[E-0024 34:1 0024089]
  PM Cover Door U-3C-I Open RDY	[E-0024 34:2 002408A]
  PM Cover Door U-3D-I Open RDY	[E-0024 34:3 002408B]
  M3 Cover Open RDY	[E-0024 35:0 002408C]
  Cell Cover Open RDY	[E-0024 36:0 002408D]
  PM/M3 Cover All Close RDY	[E-0024 38:0 002408E]
  PM Cover Upper All Close RDY	[E-0024 39:0 002408F]
  PM Cover Upper U-1A Close RDY	[E-0024 40:0 0024090]
  PM Cover Upper U-1B Close RDY	[E-0024 40:1 0024091]
  PM Cover Upper U-2A Close RDY	[E-0024 40:2 0024092]
  PM Cover Upper U-2B Close RDY	[E-0024 40:3 0024093]
  PM Cover Upper U-3A Close RDY	[E-0024 41:0 0024094]
  PM Cover Upper U-3B Close RDY	[E-0024 41:1 0024095]
  PM Cover Upper U-3C Close RDY	[E-0024 41:2 0024096]
  PM Cover Upper U-3D Close RDY	[E-0024 41:3 0024097]
  PM Cover Lower All Close RDY	[E-0024 42:0 0024098]
  PM Cover Lower L-A Close RDY	[E-0024 43:0 0024099]
  PM LOSER Cover L-B Close RDY	[E-0024 43:1 002409A]
  PM Cover Lower L-C Close RDY	[E-0024 43:2 002409B]
  PM Cover Lower L-D Close RDY	[E-0024 43:3 002409C]
  PM Cover Door All Close RDY	[E-0024 44:0 002409D]
  PM Cover Door U-1A-I Close RDY	[E-0024 45:0 002409E]
  PM Cover Door U-1B-I Close RDY	[E-0024 45:1 002409F]
  PM Cover Door U-2A-I Close RDY	[E-0024 45:2 00240A0]
  PM Cover Door U-2B-I Close RDY	[E-0024 45:3 00240A1]
  PM Cover Door U-3A-I Close RDY	[E-0024 46:0 00240A2]
  PM Cover Door U-3B-I Close RDY	[E-0024 46:1 00240A3]
  PM Cover Door U-3C-I Close RDY	[E-0024 46:2 00240A4]
  PM Cover Door U-3D-I Close RDY	[E-0024 46:3 00240A5]
  M3 Cover Close RDY	[E-0024 47:0 00240A6]
  Cell Cover Close RDY	[E-0024 48:0 00240A7]
  PM/M3 Cover All Selected	[E-0024 64:0 00240C6]
  PM Cover Upper All Selected	[E-0024 65:0 00240C7]
  PM Cover Upper U-1A Selected	[E-0024 66:0 00240C8]
  PM Cover Upper U-1B Selected	[E-0024 66:2 00240CA]
  PM Cover Upper U-2A Selected	[E-0024 67:0 00240CC]
  PM Cover Upper U-2B Selected	[E-0024 67:2 00240CE]
  PM Cover Upper U-3A Selected	[E-0024 68:0 00240D0]
  PM Cover Upper U-3B Selected	[E-0024 68:2 00240D2]
  PM Cover Upper U-3C Selected	[E-0024 68:4 00240D4]
  PM Cover Upper U-3D Selected	[E-0024 68:6 00240D6]
  PM Cover Lower All Selected	[E-0024 69:0 00240D8]
  PM Cover Lower L-A Selected	[E-0024 70:0 00240D9]
  PM Cover Lower L-B Selected	[E-0024 70:2 00240DB]
  PM Cover Lower L-C Selected	[E-0024 70:4 00240DD]
  PM Cover Lower L-D Selected	[E-0024 70:6 00240DF]
  PM Cover Door All Selected	[E-0024 71:0 00240E1]
  PM Cover Door U-1A-I Selected	[E-0024 72:0 00240E2]
  PM Cover Door U-1B-I Selected	[E-0024 72:1 00240E3]
  PM Cover Door U-2A-I Selected	[E-0024 72:2 00240E4]
  PM Cover Door U-2B-I Selected	[E-0024 72:3 00240E5]
  PM Cover Door U-3A-I Selected	[E-0024 72:4 00240E6]
  PM Cover Door U-3B-I Selected	[E-0024 72:5 00240E7]
  PM Cover Door U-3C-I Selected	[E-0024 72:6 00240E8]
  PM Cover Door U-3D-I Selected	[E-0024 72:7 00240E9]
  M3 Cover Selected	[E-0024 73:0 00240EA]
  PM Cover U-1A-I DPA Fault	[E-0024 75:0 00240B8]
  PM Cover U-1B-I DPA Fault	[E-0024 75:1 00240B9]
  PM Cover U-2A-I DPA Fault	[E-0024 75:2 00240BA]
  PM Cover U-2B-I DPA Fault	[E-0024 75:3 00240BB]
  PM Cover U-3A-I DPA Fault	[E-0024 75:4 00240BC]
  PM Cover U-3B-I DPA Fault	[E-0024 75:5 00240BD]
  PM Cover U-3C-I DPA Fault	[E-0024 75:6 00240BE]
  PM Cover U-3D-I DPA Fault	[E-0024 75:7 00240BF]
  M3 Cover DPA Fault	[E-0024 76:0 00240C0]
  Cell Cover DPA Fault	[E-0024 76:1 00240C1]
  TCDPA1(Cover) Fault	[E-0024 76:2 00240A8]
  PM Cover U-1A DPA Fault	[E-0024 77:0 00240AC]
  PM Cover U-1B DPA Fault	[E-0024 77:1 00240AD]
  PM Cover U-2A DPA Fault	[E-0024 77:2 00240AE]
  PM Cover U-2B DPA Fault	[E-0024 77:3 00240AF]
  TCDPA2(Cover) Fault	[E-0024 77:4 00240A9]
  PM Cover U-3A DPA Fault	[E-0024 78:0 00240B0]
  PM Cover U-3B DPA Fault	[E-0024 78:1 00240B1]
  PM Cover U-3C DPA Fault	[E-0024 78:2 00240B2]
  PM Cover U-3D DPA Fault	[E-0024 78:3 00240B3]
  TCDPA3(Cover) Fault	[E-0024 78:4 00240AA]
  PM Cover L-A DPA Fault	[E-0024 79:0 00240B4]
  PM Cover L-B DPA Fault	[E-0024 79:1 00240B5]
  PM Cover L-C DPA Fault	[E-0024 79:2 00240B6]
  PM Cover L-D DPA Fault	[E-0024 79:3 00240B7]
  TCDPA4(Cover) Fault	[E-0024 79:4 00240AB]
  Cover Fault	[E-0024 80:0 002405F]
  TCSPU1/4(Cs) Fault on CVCU	[E-0024 80:1 002400A]
  TCSPU2/5(NsIR) Fault on CVCU	[E-0024 80:2 002400C]
  TCSPU3/6(NsOpt) Fault on CVCU	[E-0024 80:3 002400E]
  TCSPU4(Cs)-Cover Alarm	[E-0024 81:0 0024063]
  MLP3-Cover Alarm	[E-0024 81:1 0024061]
  Cover COML PWR Fault	[E-0024 82:0 002405E]
  Cover Total Fan Alarm	[E-0024 82:1 0024060]
  Cover EXT CLK Alarm	[E-0024 82:2 002405D]
  EL Stow Pins Off(CVCU IND)	[E-0024 82:4 0024040]
  PM Cover Upper U-1A SEQ Break	[E-0024 84:0 0024010]
  PM Cover Upper U-1B SEQ Break	[E-0024 84:1 0024012]
  PM Cover Upper U-2A SEQ Break	[E-0024 84:2 0024014]
  PM Cover Upper U-2B SEQ Break	[E-0024 84:3 0024016]
  PM Cover Upper U-3A SEQ Break	[E-0024 84:4 0024018]
  PM Cover Upper U-3B SEQ Break	[E-0024 84:5 002401A]
  PM Cover Upper U-3C SEQ Break	[E-0024 84:6 002401C]
  PM Cover Upper U-3D SEQ Break	[E-0024 84:7 002401E]
  PM Cover Lower L-A SEQ Break	[E-0024 85:0 0024020]
  PM Cover Lower L-B SEQ Break	[E-0024 85:1 0024022]
  PM Cover Lower L-C SEQ Break	[E-0024 85:2 0024024]
  PM Cover Lower L-D SEQ Break	[E-0024 85:3 0024026]
  PM Cover Upper U-1A-I SEQ Break	[E-0024 85:4 0024028]
  PM Cover Upper U-1B-I SEQ Break	[E-0024 85:5 002402A]
  PM Cover Upper U-2A-I-A SEQ Break	[E-0024 85:6 002402C]
  PM Cover Upper U-2A-I-B SEQ Break	[E-0024 85:7 002402E]
  PM Cover Upper U-2B-I-A SEQ Break	[E-0024 86:0 0024030]
  PM Cover Upper U-2B-I-B SEQ Break	[E-0024 86:1 0024032]
  PM Cover Upper U-3A-I SEQ Break	[E-0024 86:2 0024034]
  PM Cover Upper U-3B-I SEQ Break	[E-0024 86:3 0024036]
  PM Cover Upper U-3C-I SEQ Break	[E-0024 86:4 0024038]
  PM Cover Upper U-3D-I SEQ Break	[E-0024 86:5 002403A]
  PM Cover Upper M3 SEQ Break	[E-0024 86:6 002403C]
  PM Cover Upper Cell SEQ Break	[E-0024 86:7 002403E]
  3rd Mirror Opt In ANS	[E-0025 0:0 0025003]
  3rd Mirror Opt Out ANS	[E-0025 0:1 0025004]
  3rd Mirror IR In ANS	[E-0025 0:2 0025001]
  3rd Mirror IR Out ANS	[E-0025 0:3 0025002]
  3rd Mirror Opt In Driving CMD	[E-0025 1:0 0025006]
  3rd Mirror Opt Out Driving CMD	[E-0025 1:1 0025008]
  3rd Mirror IR In Driving CMD	[E-0025 1:2 0025005]
  3rd Mirror IR Out Driving CMD	[E-0025 1:3 0025007]
  3rd Mirror Opt All Clamp On	[E-0025 2:0 002500B]
  3rd Mirror Opt All Clamp Off	[E-0025 2:1 002500C]
  3rd Mirror IR All Clamp On	[E-0025 2:2 0025009]
  3rd Mirror IR All Clamp Off	[E-0025 2:3 002500A]
  3rd Mirror Opt Up Limit	[E-0025 3:0 002500E]
  3rd Mirror Opt Down Limit	[E-0025 3:1 002500F]
  3rd Mirror IR Up Limit	[E-0025 3:2 0025036]
  3rd Mirror IR Down Limit	[E-0025 3:3 002500D]
  3rd Mirror Total Fan Alarm	[E-0025 11:7 0025010]
  3rd Mirror MAINT	[E-0025 12:2 0025011]
  3rd Mirror COML PWR Fault	[E-0025 12:3 0025012]
  MLP3-3rd Mirror Alarm	[E-0025 12:4 0025013]
  3rd Mirror Fault	[E-0025 12:5 0025014]
  3rd Mirror EXT CLK Alarm	[E-0025 12:6 0025015]
  3rd Mirror Opt In Ready	[E-0025 13:0 0025034]
  3rd Mirror Opt Out Ready	[E-0025 13:1 0025035]
  3rd Mirror IR In Ready	[E-0025 13:2 0025032]
  3rd Mirror IR Out Ready	[E-0025 13:3 0025033]
  3rd Mirror Local	[E-0025 14:0 002502C]
  3rd Mirror Normal Mode	[E-0025 14:1 002502E]
  3rd Mirror Test Mode	[E-0025 14:2 002502F]
  TCSPU2/5(NsIR) Fault	[E-0025 18:1 002501C]
  TCSPU3/6(NsOpt) Fault	[E-0025 18:2 002501D]
  EL Stow Pins Off	[E-0025 18:4 002501E]
  Opt DPA Fault	[E-0025 19:0 0025016]
  IR DPA Fault	[E-0025 19:1 0025017]
  DPA1(3rd Mirror) Fault	[E-0025 19:2 0025018]
  DPA3(3rd Mirror) Fault	[E-0025 19:3 0025019]
  DPA4(3rd Mirror) Fault	[E-0025 19:4 002501A]
  3rd Mirror Test Number ANS	[E-0025 36:0 002501B]
  Torque Balancer Test Ready	[E-0027 0:4 0027012]
  EL Stow Pins On(From Balancer)	[E-0027 0:5 002700E]
  EL Stow Pins Off(From Balancer)	[E-0027 0:6 002700F]
  Torque EL Alarm(From Balancer)	[E-0027 1:0 0027013]
  Torque Busy	[E-0027 1:4 0027014]
  Torque/CA-EL Drive On	[E-0027 2:0 0027015]
  Torque/CA-EL Drive Off	[E-0027 2:1 0027016]
  Torque Alarm(From Balancer)	[E-0027 2:4 0027017]
  EL Stow Pins On RDY(From Balancer)	[E-0027 3:0 0027018]
  EL Stow Pins Off RDY(From Balancer)	[E-0027 3:1 0027019]
  Balancer Local	[E-0027 5:0 002701C]
  Torque Local on BLCU	[E-0027 5:1 0027029]
  Balancer Test on BLCU	[E-0027 6:0 002701D]
  Balancer Test Ready	[E-0027 7:0 002701E]
  CounterWeight Busy	[E-0027 8:0 002701F]
  Balancer Test Auto Ready	[E-0027 9:0 0027020]
  Balancer Test Position Ready	[E-0027 9:1 0027021]
  Balancer Test Start Ready	[E-0027 10:0 0027023]
  Balancer Test Auto Selected	[E-0027 15:0 0027034]
  Balancer Test Position Selected	[E-0027 15:1 0027035]
  CounterWeight Position Selected	[E-0027 15:2 0027036]
  CounterWeight Slew Selected	[E-0027 15:3 0027037]
  Balancer MAINT	[E-0027 15:4 002701A]
  Balancer Test Start	[E-0027 16:0 0027038]
  Balancer Test Stop	[E-0027 16:1 0027039]
  CounterWeight Drive On	[E-0027 16:2 002703A]
  CounterWeight Drive Off	[E-0027 16:3 002703B]
  CounterWeight All Selected	[E-0027 17:0 002703C]
  CounterWeight A Selected	[E-0027 17:1 002703D]
  CounterWeight B Selected	[E-0027 17:2 002703E]
  CounterWeight C Selected	[E-0027 17:3 002703F]
  CounterWeight D Selected	[E-0027 17:4 0027040]
  Top Unit Code on BLCU	[E-0027 18 0027041 BCD1]
  Balancer Test at Low EL	[E-0027 20:0 0027024]
  Balancer Test Completed	[E-0027 21:0 0027042]
  Balancer Test Position OK	[E-0027 21:1 0027043]
  CounterWeight A 1st Limit Up	[E-0027 22:0 0027044]
  CounterWeight A 1st Limit Down	[E-0027 22:1 0027045]
  CounterWeight B 1st Limit Up	[E-0027 23:0 0027046]
  CounterWeight B 1st Limit Down	[E-0027 23:1 0027047]
  CounterWeight C 1st Limit Up	[E-0027 24:0 0027048]
  CounterWeight C 1st Limit Down	[E-0027 24:1 0027049]
  CounterWeight D 1st Limit Up	[E-0027 25:0 002704A]
  CounterWeight D 1st Limit Down	[E-0027 25:1 002704B]
  Balancer EMER Stop	[E-0027 26:0 002704C]
  Balancer Drive Safety	[E-0027 26:1 0027022]
  Balancer DPA Alarm	[E-0027 27:0 002704D]
  Balancer Total Fan Alarm	[E-0027 27:1 002704E]
  Balancer Limit Reset	[E-0027 27:2 002701B]
  Balancer COML PWR Fault	[E-0027 27:3 0027025]
  Balancer Fault	[E-0027 28:0 002704F]
  Balancer EXT CLK Alarm	[E-0027 28:1 0027026]
  TCSPU1/4(Cs) Fault on BLCU	[E-0027 29:0 0027050]
  Torque-Balancer Alarm	[E-0027 29:1 0027027]
  Balancer-Torque Alarm on BLCU	[E-0027 29:2 0027051]
  MLP1-Balancer Alarm	[E-0027 29:3 0027028]
  Balancer Normal Mode	[E-0027 36:0 0027052]
  Balancer Test Mode	[E-0027 36:1 0027053]
  Balancer Test Pattern	[E-0027 37 0027054 BCD1]
  Balancer Test Result	[E-0027 38 0027055 BCD1]
  TRQ Real Angle(From Balancer)	[L-0027 0 0027001 BCD6]
  AVG. Unbal Torque	[L-0027 6 0027002 BCD6]
  CounterWeight AVG. Real Position	[L-0027 12 0027003 BCD6]
  CounterWeight A Real Position	[L-0027 18 0027004 BCD6]
  CounterWeight B Real Position	[L-0027 24 0027005 BCD6]
  CounterWeight C Real Position	[L-0027 30 0027006 BCD6]
  CounterWeight D Real Position	[L-0027 36 0027007 BCD6]
  Torque Angle CMD	[L-0027 42 0027008 BCD6]
  CounterWeight A CMD Position	[L-0027 48 002700A BCD6]
  CounterWeight B CMD Position	[L-0027 54 002700B BCD6]
  CounterWeight C CMD Position	[L-0027 60 002700C BCD6]
  CounterWeight D CMD Position	[L-0027 66 002700D BCD6]
  Tip-Tilt Chopping Mode	[E-0028 1:0 002800B]
  Tip-Tilt Tip-Tilt Mode	[E-0028 1:1 002800C]
  Tip-Tilt Position Mode	[E-0028 1:2 0028029]
  Tip-Tilt MAINT Mode	[E-0028 1:7 002800D]
  Tip-Tilt - Offset	[E-0028 2:0 0028004]
  Tip-Tilt No Offset	[E-0028 2:1 0028005]
  Tip-Tilt + Offset	[E-0028 2:2 0028006]
  Tip-Tilt Drive On	[E-0028 3:0 0028007]
  Tip-Tilt Drive Off	[E-0028 3:1 0028008]
  Tip-Tilt Drive On RDY	[E-0028 3:2 002802A]
  Tip-Tilt Not IR Selected	[E-0028 3:4 0028031]
  Tip-Tilt CsIR Selected	[E-0028 3:5 0028032]
  Tip-Tilt NsIR Selected	[E-0028 3:6 0028033]
  Tip-Tilt NsIR(ImR) Selected	[E-0028 3:7 0028034]
  Tip-Tilt SM EMA1A Fault	[E-0028 4:0 002800E]
  Tip-Tilt SM EMA1B Fault	[E-0028 4:1 002800F]
  Tip-Tilt SM EMA2A Fault	[E-0028 4:2 0028010]
  Tip-Tilt SM EMA2B Fault	[E-0028 4:3 0028011]
  Tip-Tilt SM EMA3A Fault	[E-0028 4:4 0028012]
  Tip-Tilt SM EMA3B Fault	[E-0028 4:5 0028013]
  Tip-Tilt SM EMA4A Fault	[E-0028 5:0 0028014]
  Tip-Tilt SM EMA4B Fault	[E-0028 5:1 0028015]
  Tip-Tilt SM EMA5A Fault	[E-0028 5:2 0028016]
  Tip-Tilt SM EMA5B Fault	[E-0028 5:3 0028017]
  Tip-Tilt SM EMA6A Fault	[E-0028 5:4 0028018]
  Tip-Tilt SM EMA6B Fault	[E-0028 5:5 0028019]
  Tip-Tilt RC EMA1A Fault	[E-0028 6:0 0028035]
  Tip-Tilt RC EMA1B Fault	[E-0028 6:1 0028036]
  Tip-Tilt RC EMA2A Fault	[E-0028 6:2 0028037]
  Tip-Tilt RC EMA2B Fault	[E-0028 6:3 0028038]
  Tip-Tilt RC EMA3A Fault	[E-0028 6:4 0028039]
  Tip-Tilt RC EMA3B Fault	[E-0028 6:5 002803A]
  Tip-Tilt RC EMA4A Fault	[E-0028 7:0 002803B]
  Tip-Tilt RC EMA4B Fault	[E-0028 7:1 002803C]
  Tip-Tilt RC EMA5A Fault	[E-0028 7:2 002803D]
  Tip-Tilt RC EMA5B Fault	[E-0028 7:3 002803E]
  Tip-Tilt RC EMA6A Fault	[E-0028 7:4 002803F]
  Tip-Tilt RC EMA6B Fault	[E-0028 7:5 0028040]
  Tip-Tilt Local	[E-0028 8:0 0028024]
  Tip-Tilt DSP1 Fault	[E-0028 9:0 0028020]
  Tip-Tilt DSP2 Fault	[E-0028 9:1 0028021]
  Tip-Tilt DSP3 Fault	[E-0028 9:2 0028022]
  Tip-Tilt DSP4 Fault	[E-0028 9:3 0028023]
  Tip-Tilt Fault	[E-0028 9:7 002802D]
  MLP1 DSP - Tip-Tilt DSP1 Alarm	[E-0028 10:0 0028041]
  MLP1 DSP - Tip-Tilt DSP2 Alarm	[E-0028 10:1 0028042]
  MLP1 DSP - Tip-Tilt DSP3 Alarm	[E-0028 10:2 0028043]
  MLP1 DSP - Tip-Tilt DSP4 Alarm	[E-0028 10:3 0028044]
  Tip-Tilt Data Available	[E-0028 11:0 0028045]
  TSC Fault IND on TTCU	[E-0028 12:0 0028027]
  MLP1 - Tip-Tilt Alarm	[E-0028 12:1 002802B]
  Tip-Tilt EL SYNC Ready	[E-0028 12:2 0028046]
  Tip-Tilt EXT CLK Alarm	[E-0028 12:3 002802C]
  Tip-Tilt Total Fan Alarm	[E-0028 12:4 002802F]
  TSC COMP PWR Fault DET ANS	[E-0028 13:0 0028028]
  TTCU Drive Safety	[E-0028 14:0 0028049]
  Tip-Tilt EMER Stop	[E-0028 14:1 002802E]
  UPS1 Alarm(Tip-Tilt IND)	[E-0028 15:0 002804A]
  Tip-Tilt Service Interruput	[E-0028 15:1 0028030]
  Tip-Tilt DPA1 Alarm	[E-0028 16:0 002804B]
  Tip-Tilt DPA2 Alarm	[E-0028 17:0 002804C]
  Tip-Tilt SM Sensor1 Alarm	[E-0028 18:0 002801A]
  Tip-Tilt SM Sensor2 Alarm	[E-0028 18:1 002801B]
  Tip-Tilt SM Sensor3 Alarm	[E-0028 18:2 002801C]
  Tip-Tilt RC Sensor1 Alarm	[E-0028 19:0 002801D]
  Tip-Tilt RC Sensor2 Alarm	[E-0028 19:1 002801E]
  Tip-Tilt RC Sensor3 Alarm	[E-0028 19:2 002801F]
  Tip-Tilt SM1 S/W Limit+	[E-0028 20:0 002804D]
  Tip-Tilt SM2 S/W Limit+	[E-0028 20:1 002804E]
  Tip-Tilt SM3 S/W Limit+	[E-0028 20:2 002804F]
  Tip-Tilt SM1 S/W Limit-	[E-0028 21:0 0028050]
  Tip-Tilt SM2 S/W Limit-	[E-0028 21:1 0028051]
  Tip-Tilt SM3 S/W Limit-	[E-0028 21:2 0028052]
  Tip-Tilt RC1 S/W Limit+	[E-0028 22:0 0028053]
  Tip-Tilt RC2 S/W Limit+	[E-0028 22:1 0028054]
  Tip-Tilt RC3 S/W Limit+	[E-0028 22:2 0028055]
  Tip-Tilt RC1 S/W Limit-	[E-0028 23:0 0028056]
  Tip-Tilt RC2 S/W Limit-	[E-0028 23:1 0028057]
  Tip-Tilt RC3 S/W Limit-	[E-0028 23:2 0028058]
  Tip-Tilt SM Z Velocity Limit	[E-0028 24:0 0028059]
  Tip-Tilt RC Z Velocity Limit	[E-0028 25:0 002805A]
  Chopping Pattern1 Selected	[E-0028 26:0 0028063]
  Chopping Pattern2 Selected	[E-0028 26:1 0028064]
  Chopping Pattern3 Selected	[E-0028 26:2 0028065]
  Chopping Start	[E-0028 27:0 0028066]
  Chopping Stop	[E-0028 27:1 0028067]
  Tip-Tilt Chopping Start Ready	[E-0028 27:2 0028026]
  Chopping SYNC Signal EXT Selected	[E-0028 28:0 0028048]
  Chopping SYNC Signal INT Selected	[E-0028 28:1 0028047]
  Chopping SYNC Signal EXT Ready	[E-0028 28:2 0028068]
  Tip-Tilt Chopping Frequency ANS	[L-0028 0 0028001 BCD6]
  Tip-Tilt Chopping Amplitude ANS	[L-0028 6 0028002 BCD6]
  Tip-Tilt Position ANS	[L-0028 12 0028003 BCD6]
  Tip-Tilt Chopping Mode Bias ANS	[L-0028 18 0028025 BCD6]
  Tip-Tilt X Real Angle	[S-0028 0 002805B BCD6]
  Tip-Tilt Y Real Angle	[S-0028 6 002805C BCD6]
  Tip-Tilt X CMD Angle	[S-0028 12 002805D BCD6]
  Tip-Tilt Y CMD Angle	[S-0028 18 002805E BCD6]
  Tip-Tilt Z(SM) CMD Position	[S-0028 24 002805F BCD6]
  Tip-Tilt Z(RC) CMD Position	[S-0028 30 0028060 BCD6]
  Tip-Tilt AZ Traverse Angle	[S-0028 36 0028009 BCD6]
  Tip-Tilt EL Angle	[S-0028 42 002800A BCD6]
  Tip-Tilt Z(SM) Real Position	[S-0028 48 0028061 BCD6]
  Tip-Tilt Z(RC) Real Position	[S-0028 54 0028062 BCD6]
  Hydrostatic Return Pump1 Driving	[E-0029 0:0 0029003]
  Hydrostatic Return Pump2 Driving	[E-0029 0:4 0029004]
  Hydrostatic Supply Pump1 Driving	[E-0029 1:0 0029005]
  Hydrostatic Supply Pump2 Driving	[E-0029 1:4 0029006]
  Hydrostatic Control Warning	[E-0029 2:0 0029007]
  Hydrostatic Control Alarm	[E-0029 2:4 0029008]
  Hydrostatic Driving	[E-0029 3:0 002900A]
  Hydrostatic Power Fault	[E-0029 3:4 0029009]
  Hydrostatic Temp Sensor Alarm	[E-0029 4:4 002900B]
  Hydrostatic Temperature(Axis)	[L-0029 0 0029001 BCD6]
  Hydrostatic Temperature CMD ANS	[L-0029 6 002900C BCD6]
  Hydrostatic Temperature(Pier)	[L-0029 12 0029002 BCD6]
  Roof(R) AVG WVEL Alarm	[E-002A 0:0 002A001]
  Roof(R) AVG WVEL NORM	[E-002A 0:1 002A002]
  Roof(R) AVG WVEL VAR	[E-002A 0:2 002A003]
  Roof(R) AVG WVEL Over RNG	[E-002A 0:3 002A004]
  Roof(R) AVG WVEL Skip	[E-002A 0:4 002A005]
  Roof(R) AVG WVEL Up LIM	[E-002A 1:0 002A006]
  Roof(R) AVG WVEL DN LIM	[E-002A 1:1 002A007]
  Roof(R) AVG WVEL VAR Up LIM	[E-002A 1:2 002A008]
  Roof(R) AVG WVEL VAR DN LIM	[E-002A 1:3 002A009]
  Roof(R) AVG WVEL RT Up	[E-002A 1:4 002A00A]
  Roof(R) AVG WVEL RT DN	[E-002A 1:5 002A00B]
  Roof(R) INST WVEL Alarm	[E-002A 2:0 002A00D]
  Roof(R) INST WVEL NORM	[E-002A 2:1 002A00E]
  Roof(R) INST WVEL VAR	[E-002A 2:2 002A00F]
  Roof(R) INST WVEL Over RNG	[E-002A 2:3 002A010]
  Roof(R) INST WVEL Skip	[E-002A 2:4 002A011]
  Roof(R) INST WVEL Up LIM	[E-002A 3:0 002A012]
  Roof(R) INST WVEL DN LIM	[E-002A 3:1 002A013]
  Roof(R) INST WVEL VAR Up LIM	[E-002A 3:2 002A014]
  Roof(R) INST WVEL VAR DN LIM	[E-002A 3:3 002A015]
  Roof(R) INST WVEL RT Up	[E-002A 3:4 002A016]
  Roof(R) INST WVEL RT DN	[E-002A 3:5 002A017]
  Roof(R) WDIR Alarm	[E-002A 4:0 002A019]
  Roof(R) WDIR NORM	[E-002A 4:1 002A01A]
  Roof(R) WDIR VAR	[E-002A 4:2 002A01B]
  Roof(R) WDIR Over RNG	[E-002A 4:3 002A01C]
  Roof(R) WDIR Skip	[E-002A 4:4 002A01D]
  Roof(R) WDIR Up LIM	[E-002A 5:0 002A01E]
  Roof(R) WDIR DN LIM	[E-002A 5:1 002A01F]
  Roof(R) WDIR VAR Up LIM	[E-002A 5:2 002A020]
  Roof(R) WDIR VAR DN LIM	[E-002A 5:3 002A021]
  Roof(R) WDIR RT Up	[E-002A 5:4 002A022]
  Roof(R) WDIR RT DN	[E-002A 5:5 002A023]
  Roof Opt(F) AVG WVEL Alarm	[E-002A 6:0 002A025]
  Roof Opt(F) AVG WVEL NORM	[E-002A 6:1 002A026]
  Roof Opt(F) AVG WVEL VAR	[E-002A 6:2 002A027]
  Roof Opt(F) AVG WVEL Over RNG	[E-002A 6:3 002A028]
  Roof Opt(F) AVG WVEL Skip	[E-002A 6:4 002A029]
  Roof Opt(F) AVG WVEL Up LIM	[E-002A 7:0 002A02A]
  Roof Opt(F) AVG WVEL DN LIM	[E-002A 7:1 002A02B]
  Roof Opt(F) AVG WVEL VAR Up LIM	[E-002A 7:2 002A02C]
  Roof Opt(F) AVG WVEL VAR DN LIM	[E-002A 7:3 002A02D]
  Roof Opt(F) AVG WVEL RT Up	[E-002A 7:4 002A02E]
  Roof Opt(F) AVG WVEL RT DN	[E-002A 7:5 002A02F]
  Roof Opt(F) INST WVEL Alarm	[E-002A 8:0 002A031]
  Roof Opt(F) INST WVEL NORM	[E-002A 8:1 002A032]
  Roof Opt(F) INST WVEL VAR	[E-002A 8:2 002A033]
  Roof Opt(F) INST WVEL Over RNG	[E-002A 8:3 002A034]
  Roof Opt(F) INST WVEL Skip	[E-002A 8:4 002A035]
  Roof Opt(F) INST WVEL Up LIM	[E-002A 9:0 002A036]
  Roof Opt(F) INST WVEL DN LIM	[E-002A 9:1 002A037]
  Roof Opt(F) INST WVEL VAR Up LIM	[E-002A 9:2 002A038]
  Roof Opt(F) INST WVEL VAR DN LIM	[E-002A 9:3 002A039]
  Roof Opt(F) INST WVEL RT Up	[E-002A 9:4 002A03A]
  Roof Opt(F) INST WVEL RT DN	[E-002A 9:5 002A03B]
  Roof Opt(F) WDIR Alarm	[E-002A 10:0 002A03D]
  Roof Opt(F) WDIR NORM	[E-002A 10:1 002A03E]
  Roof Opt(F) WDIR VAR	[E-002A 10:2 002A03F]
  Roof Opt(F) WDIR Over RNG	[E-002A 10:3 002A040]
  Roof Opt(F) WDIR Skip	[E-002A 10:4 002A041]
  Roof Opt(F) WDIR Up LIM	[E-002A 11:0 002A042]
  Roof Opt(F) WDIR DN LIM	[E-002A 11:1 002A043]
  Roof Opt(F) WDIR VAR Up LIM	[E-002A 11:2 002A044]
  Roof Opt(F) WDIR VAR DN LIM	[E-002A 11:3 002A045]
  Roof Opt(F) WDIR RT Up	[E-002A 11:4 002A046]
  Roof Opt(F) WDIR RT DN	[E-002A 11:5 002A047]
  Roof IR(F) AVG WVEL Alarm	[E-002A 12:0 002A049]
  Roof IR(F) AVG WVEL NORM	[E-002A 12:1 002A04A]
  Roof IR(F) AVG WVEL VAR	[E-002A 12:2 002A04B]
  Roof IR(F) AVG WVEL Over RNG	[E-002A 12:3 002A04C]
  Roof IR(F) AVG WVEL Skip	[E-002A 12:4 002A04D]
  Roof IR(F) AVG WVEL Up LIM	[E-002A 13:0 002A04E]
  Roof IR(F) AVG WVEL DN LIM	[E-002A 13:1 002A04F]
  Roof IR(F) AVG WVEL VAR Up LIM	[E-002A 13:2 002A050]
  Roof IR(F) AVG WVEL VAR DN LIM	[E-002A 13:3 002A051]
  Roof IR(F) AVG WVEL RT Up	[E-002A 13:4 002A052]
  Roof IR(F) AVG WVEL RT DN	[E-002A 13:5 002A053]
  Roof IR(F) INST WVEL Alarm	[E-002A 14:0 002A055]
  Roof IR(F) INST WVEL NORM	[E-002A 14:1 002A056]
  Roof IR(F) INST WVEL VAR	[E-002A 14:2 002A057]
  Roof IR(F) INST WVEL Over RNG	[E-002A 14:3 002A058]
  Roof IR(F) INST WVEL Skip	[E-002A 14:4 002A059]
  Roof IR(F) INST WVEL Up LIM	[E-002A 15:0 002A05A]
  Roof IR(F) INST WVEL DN LIM	[E-002A 15:1 002A05B]
  Roof IR(F) INST WVEL VAR Up LIM	[E-002A 15:2 002A05C]
  Roof IR(F) INST WVEL VAR DN LIM	[E-002A 15:3 002A05D]
  Roof IR(F) INST WVEL RT Up	[E-002A 15:4 002A05E]
  Roof IR(F) INST WVEL RT DN	[E-002A 15:5 002A05F]
  Roof IR(F) WDIR Alarm	[E-002A 16:0 002A061]
  Roof IR(F) WDIR NORM	[E-002A 16:1 002A062]
  Roof IR(F) WDIR VAR	[E-002A 16:2 002A063]
  Roof IR(F) WDIR Over RNG	[E-002A 16:3 002A064]
  Roof IR(F) WDIR Skip	[E-002A 16:4 002A065]
  Roof IR(F) WDIR Up LIM	[E-002A 17:0 002A066]
  Roof IR(F) WDIR DN LIM	[E-002A 17:1 002A067]
  Roof IR(F) WDIR VAR Up LIM	[E-002A 17:2 002A068]
  Roof IR(F) WDIR VAR DN LIM	[E-002A 17:3 002A069]
  Roof IR(F) WDIR RT Up	[E-002A 17:4 002A06A]
  Roof IR(F) WDIR RT DN	[E-002A 17:5 002A06B]
  Front V WDIR Alarm	[E-002A 18:0 002A06D]
  Front V WDIR NORM	[E-002A 18:1 002A06E]
  Front V WDIR VAR	[E-002A 18:2 002A06F]
  Front V WDIR Over RNG	[E-002A 18:3 002A070]
  Front V WDIR Skip	[E-002A 18:4 002A071]
  Front V WDIR Up LIM	[E-002A 19:0 002A072]
  Front V WDIR DN LIM	[E-002A 19:1 002A073]
  Front V WDIR VAR Up LIM	[E-002A 19:2 002A074]
  Front V WDIR VAR DN LIM	[E-002A 19:3 002A075]
  Front V WDIR RT Up	[E-002A 19:4 002A076]
  Front V WDIR RT DN	[E-002A 19:5 002A077]
  Ns FL Rear V1 WDIR Alarm	[E-002A 20:0 002A079]
  Ns FL Rear V1 WDIR NORM	[E-002A 20:1 002A07A]
  Ns FL Rear V1 WDIR VAR	[E-002A 20:2 002A07B]
  Ns FL Rear V1 WDIR Over RNG	[E-002A 20:3 002A07C]
  Ns FL Rear V1 WDIR Skip	[E-002A 20:4 002A07D]
  Ns FL Rear V1 WDIR Up LIM	[E-002A 21:0 002A07E]
  Ns FL Rear V1 WDIR DN LIM	[E-002A 21:1 002A07F]
  Ns FL Rear V1 WDIR VAR Up LIM	[E-002A 21:2 002A080]
  Ns FL Rear V1 WDIR VAR DN LIM	[E-002A 21:3 002A081]
  Ns FL Rear V1 WDIR RT Up	[E-002A 21:4 002A082]
  Ns FL Rear V1 WDIR RT DN	[E-002A 21:5 002A083]
  Ns FL Side VA WDIR Alarm	[E-002A 22:0 002A085]
  Ns FL Side VA WDIR NORM	[E-002A 22:1 002A086]
  Ns FL Side VA WDIR VAR	[E-002A 22:2 002A087]
  Ns FL Side VA WDIR Over RNG	[E-002A 22:3 002A088]
  Ns FL Side VA WDIR Skip	[E-002A 22:4 002A089]
  Ns FL Side VA WDIR Up LIM	[E-002A 23:0 002A08A]
  Ns FL Side VA WDIR DN LIM	[E-002A 23:1 002A08B]
  Ns FL Side VA WDIR VAR Up LIM	[E-002A 23:2 002A08C]
  Ns FL Side VA WDIR VAR DN LIM	[E-002A 23:3 002A08D]
  Ns FL Side VA WDIR RT Up	[E-002A 23:4 002A08E]
  Ns FL Side VA WDIR RT DN	[E-002A 23:5 002A08F]
  Ns FL Side VB WDIR Alarm	[E-002A 24:0 002A091]
  Ns FL Side VB WDIR NORM	[E-002A 24:1 002A092]
  Ns FL Side VB WDIR VAR	[E-002A 24:2 002A093]
  Ns FL Side VB WDIR Over RNG	[E-002A 24:3 002A094]
  Ns FL Side VB WDIR Skip	[E-002A 24:4 002A095]
  Ns FL Side VB WDIR Up LIM	[E-002A 25:0 002A096]
  Ns FL Side VB WDIR DN LIM	[E-002A 25:1 002A097]
  Ns FL Side VB WDIR VAR Up LIM	[E-002A 25:2 002A098]
  Ns FL Side VB WDIR VAR DN LIM	[E-002A 25:3 002A099]
  Ns FL Side VB WDIR RT Up	[E-002A 25:4 002A09A]
  Ns FL Side VB WDIR RT DN	[E-002A 25:5 002A09B]
  Ns FL Side VC WDIR Alarm	[E-002A 26:0 002A09D]
  Ns FL Side VC WDIR NORM	[E-002A 26:1 002A09E]
  Ns FL Side VC WDIR VAR	[E-002A 26:2 002A09F]
  Ns FL Side VC WDIR Over RNG	[E-002A 26:3 002A0A0]
  Ns FL Side VC WDIR Skip	[E-002A 26:4 002A0A1]
  Ns FL Side VC WDIR Up LIM	[E-002A 27:0 002A0A2]
  Ns FL Side VC WDIR DN LIM	[E-002A 27:1 002A0A3]
  Ns FL Side VC WDIR VAR Up LIM	[E-002A 27:2 002A0A4]
  Ns FL Side VC WDIR VAR DN LIM	[E-002A 27:3 002A0A5]
  Ns FL Side VC WDIR RT Up	[E-002A 27:4 002A0A6]
  Ns FL Side VC WDIR RT DN	[E-002A 27:5 002A0A7]
  Ns FL Side VD WDIR Alarm	[E-002A 28:0 002A0A9]
  Ns FL Side VD WDIR NORM	[E-002A 28:1 002A0AA]
  Ns FL Side VD WDIR VAR	[E-002A 28:2 002A0AB]
  Ns FL Side VD WDIR Over RNG	[E-002A 28:3 002A0AC]
  Ns FL Side VD WDIR Skip	[E-002A 28:4 002A0AD]
  Ns FL Side VD WDIR Up LIM	[E-002A 29:0 002A0AE]
  Ns FL Side VD WDIR DN LIM	[E-002A 29:1 002A0AF]
  Ns FL Side VD WDIR VAR Up LIM	[E-002A 29:2 002A0B0]
  Ns FL Side VD WDIR VAR DN LIM	[E-002A 29:3 002A0B1]
  Ns FL Side VD WDIR RT Up	[E-002A 29:4 002A0B2]
  Ns FL Side VD WDIR RT DN	[E-002A 29:5 002A0B3]
  TLSCP Room(NsIR) HMD Alarm	[E-002A 30:0 002A0B5]
  TLSCP Room(NsIR) HMD NORM	[E-002A 30:1 002A0B6]
  TLSCP Room(NsIR) HMD VAR	[E-002A 30:2 002A0B7]
  TLSCP Room(NsIR) HMD Over RNG	[E-002A 30:3 002A0B8]
  TLSCP Room(NsIR) HMD Skip	[E-002A 30:4 002A0B9]
  TLSCP Room(NsIR) HMD Up LIM	[E-002A 31:0 002A0BA]
  TLSCP Room(NsIR) HMD DN LIM	[E-002A 31:1 002A0BB]
  TLSCP Room(NsIR) HMD VAR Up LIM	[E-002A 31:2 002A0BC]
  TLSCP Room(NsIR) HMD VAR DN LIM	[E-002A 31:3 002A0BD]
  TLSCP Room(NsIR) HMD RT Up	[E-002A 31:4 002A0BE]
  TLSCP Room(NsIR) HMD RT DN	[E-002A 31:5 002A0BF]
  TLSCP Room HMD Alarm	[E-002A 32:0 002A0C1]
  TLSCP Room HMD NORM	[E-002A 32:1 002A0C2]
  TLSCP Room HMD VAR	[E-002A 32:2 002A0C3]
  TLSCP Room HMD Over RNG	[E-002A 32:3 002A0C4]
  TLSCP Room HMD Skip	[E-002A 32:4 002A0C5]
  TLSCP Room HMD Up LIM	[E-002A 33:0 002A0C6]
  TLSCP Room HMD DN LIM	[E-002A 33:1 002A0C7]
  TLSCP Room HMD VAR Up LIM	[E-002A 33:2 002A0C8]
  TLSCP Room HMD VAR DN LIM	[E-002A 33:3 002A0C9]
  TLSCP Room HMD RT Up	[E-002A 33:4 002A0CA]
  TLSCP Room HMD RT DN	[E-002A 33:5 002A0CB]
  TLSCP Room(NsOpt) HMD Alarm	[E-002A 34:0 002A0CD]
  TLSCP Room(NsOpt) HMD NORM	[E-002A 34:1 002A0CE]
  TLSCP Room(NsOpt) HMD VAR	[E-002A 34:2 002A0CF]
  TLSCP Room(NsOpt) HMD Over RNG	[E-002A 34:3 002A0D0]
  TLSCP Room(NsOpt) HMD Skip	[E-002A 34:4 002A0D1]
  TLSCP Room(NsOpt) HMD Up LIM	[E-002A 35:0 002A0D2]
  TLSCP Room(NsOpt) HMD DN LIM	[E-002A 35:1 002A0D3]
  TLSCP Room(NsOpt) HMD VAR Up LIM	[E-002A 35:2 002A0D4]
  TLSCP Room(NsOpt) HMD VAR DN LIM	[E-002A 35:3 002A0D5]
  TLSCP Room(NsOpt) HMD RT Up	[E-002A 35:4 002A0D6]
  TLSCP Room(NsOpt) HMD RT DN	[E-002A 35:5 002A0D7]
  Top Unit EXCH HMD Alarm	[E-002A 36:0 002A0D9]
  Top Unit EXCH HMD NORM	[E-002A 36:1 002A0DA]
  Top Unit EXCH HMD VAR	[E-002A 36:2 002A0DB]
  Top Unit EXCH HMD Over RNG	[E-002A 36:3 002A0DC]
  Top Unit EXCH HMD Skip	[E-002A 36:4 002A0DD]
  Top Unit EXCH HMD Up LIM	[E-002A 37:0 002A0DE]
  Top Unit EXCH HMD DN LIM	[E-002A 37:1 002A0DF]
  Top Unit EXCH HMD VAR Up LIM	[E-002A 37:2 002A0E0]
  Top Unit EXCH HMD VAR DN LIM	[E-002A 37:3 002A0E1]
  Top Unit EXCH HMD RT Up	[E-002A 37:4 002A0E2]
  Top Unit EXCH HMD RT DN	[E-002A 37:5 002A0E3]
  Front V WVEL Alarm	[E-002A 38:0 002A0E5]
  Front V WVEL NORM	[E-002A 38:1 002A0E6]
  Front V WVEL VAR	[E-002A 38:2 002A0E7]
  Front V WVEL Over RNG	[E-002A 38:3 002A0E8]
  Front V WVEL Skip	[E-002A 38:4 002A0E9]
  Front V WVEL Up LIM	[E-002A 39:0 002A0EA]
  Front V WVEL DN LIM	[E-002A 39:1 002A0EB]
  Front V WVEL VAR Up LIM	[E-002A 39:2 002A0EC]
  Front V WVEL VAR DN LIM	[E-002A 39:3 002A0ED]
  Front V WVEL RT Up	[E-002A 39:4 002A0EE]
  Front V WVEL RT DN	[E-002A 39:5 002A0EF]
  Ns FL Rear V1 WVEL Alarm	[E-002A 40:0 002A0F1]
  Ns FL Rear V1 WVEL NORM	[E-002A 40:1 002A0F2]
  Ns FL Rear V1 WVEL VAR	[E-002A 40:2 002A0F3]
  Ns FL Rear V1 WVEL Over RNG	[E-002A 40:3 002A0F4]
  Ns FL Rear V1 WVEL Skip	[E-002A 40:4 002A0F5]
  Ns FL Rear V1 WVEL Up LIM	[E-002A 41:0 002A0F6]
  Ns FL Rear V1 WVEL DN LIM	[E-002A 41:1 002A0F7]
  Ns FL Rear V1 WVEL VAR Up LIM	[E-002A 41:2 002A0F8]
  Ns FL Rear V1 WVEL VAR DN LIM	[E-002A 41:3 002A0F9]
  Ns FL Rear V1 WVEL RT Up	[E-002A 41:4 002A0FA]
  Ns FL Rear V1 WVEL RT DN	[E-002A 41:5 002A0FB]
  Ns FL Side VA WVEL Alarm 1	[E-002A 42:0 002A0FD]
  Ns FL Side VA WVEL NORM 1	[E-002A 42:1 002A0FE]
  Ns FL Side VA WVEL VAR 1	[E-002A 42:2 002A0FF]
  Ns FL Side VA WVEL Over RNG 1	[E-002A 42:3 002A100]
  Ns FL Side VA WVEL Skip 1	[E-002A 42:4 002A101]
  Ns FL Side VA WVEL Up LIM 1	[E-002A 43:0 002A102]
  Ns FL Side VA WVEL DN LIM 1	[E-002A 43:1 002A103]
  Ns FL Side VA WVEL VAR Up LIM 1	[E-002A 43:2 002A104]
  Ns FL Side VA WVEL VAR DN LIM 1	[E-002A 43:3 002A105]
  Ns FL Side VA WVEL RT Up 1	[E-002A 43:4 002A106]
  Ns FL Side VA WVEL RT DN 1	[E-002A 43:5 002A107]
  Ns FL Side VB WVEL Alarm 1	[E-002A 44:0 002A109]
  Ns FL Side VB WVEL NORM 1	[E-002A 44:1 002A10A]
  Ns FL Side VB WVEL VAR 1	[E-002A 44:2 002A10B]
  Ns FL Side VB WVEL Over RNG 1	[E-002A 44:3 002A10C]
  Ns FL Side VB WVEL Skip 1	[E-002A 44:4 002A10D]
  Ns FL Side VB WVEL Up LIM 1	[E-002A 45:0 002A10E]
  Ns FL Side VB WVEL DN LIM 1	[E-002A 45:1 002A10F]
  Ns FL Side VB WVEL VAR Up LIM 1	[E-002A 45:2 002A110]
  Ns FL Side VB WVEL VAR DN LIM 1	[E-002A 45:3 002A111]
  Ns FL Side VB WVEL RT Up 1	[E-002A 45:4 002A112]
  Ns FL Side VB WVEL RT DN 1	[E-002A 45:5 002A113]
  Ns FL Side VC WVEL Alarm 1	[E-002A 46:0 002A115]
  Ns FL Side VC WVEL NORM 1	[E-002A 46:1 002A116]
  Ns FL Side VC WVEL VAR 1	[E-002A 46:2 002A117]
  Ns FL Side VC WVEL Over RNG 1	[E-002A 46:3 002A118]
  Ns FL Side VC WVEL Skip 1	[E-002A 46:4 002A119]
  Ns FL Side VC WVEL Up LIM 1	[E-002A 47:0 002A11A]
  Ns FL Side VC WVEL DN LIM 1	[E-002A 47:1 002A11B]
  Ns FL Side VC WVEL VAR Up LIM 1	[E-002A 47:2 002A11C]
  Ns FL Side VC WVEL VAR DN LIM 1	[E-002A 47:3 002A11D]
  Ns FL Side VC WVEL RT Up 1	[E-002A 47:4 002A11E]
  Ns FL Side VC WVEL RT DN 1	[E-002A 47:5 002A11F]
  Ns FL Side VD WVEL Alarm 1	[E-002A 48:0 002A121]
  Ns FL Side VD WVEL NORM 1	[E-002A 48:1 002A122]
  Ns FL Side VD WVEL VAR 1	[E-002A 48:2 002A123]
  Ns FL Side VD WVEL Over RNG 1	[E-002A 48:3 002A124]
  Ns FL Side VD WVEL Skip 1	[E-002A 48:4 002A125]
  Ns FL Side VD WVEL Up LIM 1	[E-002A 49:0 002A126]
  Ns FL Side VD WVEL DN LIM 1	[E-002A 49:1 002A127]
  Ns FL Side VD WVEL VAR Up LIM 1	[E-002A 49:2 002A128]
  Ns FL Side VD WVEL VAR DN LIM 1	[E-002A 49:3 002A129]
  Ns FL Side VD WVEL RT Up 1	[E-002A 49:4 002A12A]
  Ns FL Side VD WVEL RT DN 1	[E-002A 49:5 002A12B]
  Ns FL Rear V WVEL Alarm 2	[E-002A 50:0 002A12D]
  Ns FL Rear V WVEL NORM 2	[E-002A 50:1 002A12E]
  Ns FL Rear V WVEL VAR 2	[E-002A 50:2 002A12F]
  Ns FL Rear V WVEL Over RNG 2	[E-002A 50:3 002A130]
  Ns FL Rear V WVEL Skip 2	[E-002A 50:4 002A131]
  Ns FL Rear V WVEL Up LIM 2	[E-002A 51:0 002A132]
  Ns FL Rear V WVEL DN LIM 2	[E-002A 51:1 002A133]
  Ns FL Rear V WVEL VAR Up LIM 2	[E-002A 51:2 002A134]
  Ns FL Rear V WVEL VAR DN LIM 2	[E-002A 51:3 002A135]
  Ns FL Rear V WVEL RT Up 2	[E-002A 51:4 002A136]
  Ns FL Rear V WVEL RT DN 2	[E-002A 51:5 002A137]
  Ns FL Side VA WVEL Alarm 2	[E-002A 52:0 002A139]
  Ns FL Side VA WVEL NORM 2	[E-002A 52:1 002A13A]
  Ns FL Side VA WVEL VAR 2	[E-002A 52:2 002A13B]
  Ns FL Side VA WVEL Over RNG 2	[E-002A 52:3 002A13C]
  Ns FL Side VA WVEL Skip 2	[E-002A 52:4 002A13D]
  Ns FL Side VA WVEL Up LIM 2	[E-002A 53:0 002A13E]
  Ns FL Side VA WVEL DN LIM 2	[E-002A 53:1 002A13F]
  Ns FL Side VA WVEL VAR Up LIM 2	[E-002A 53:2 002A140]
  Ns FL Side VA WVEL VAR DN LIM 2	[E-002A 53:3 002A141]
  Ns FL Side VA WVEL RT Up 2	[E-002A 53:4 002A142]
  Ns FL Side VA WVEL RT DN 2	[E-002A 53:5 002A143]
  Ns FL Side VB WVEL Alarm 2	[E-002A 54:0 002A145]
  Ns FL Side VB WVEL NORM 2	[E-002A 54:1 002A146]
  Ns FL Side VB WVEL VAR 2	[E-002A 54:2 002A147]
  Ns FL Side VB WVEL Over RNG 2	[E-002A 54:3 002A148]
  Ns FL Side VB WVEL Skip 2	[E-002A 54:4 002A149]
  Ns FL Side VB WVEL Up LIM 2	[E-002A 55:0 002A14A]
  Ns FL Side VB WVEL DN LIM 2	[E-002A 55:1 002A14B]
  Ns FL Side VB WVEL VAR Up LIM 2	[E-002A 55:2 002A14C]
  Ns FL Side VB WVEL VAR DN LIM 2	[E-002A 55:3 002A14D]
  Ns FL Side VB WVEL RT Up 2	[E-002A 55:4 002A14E]
  Ns FL Side VB WVEL RT DN 2	[E-002A 55:5 002A14F]
  Ns FL Side VC WVEL Alarm 2	[E-002A 56:0 002A151]
  Ns FL Side VC WVEL NORM 2	[E-002A 56:1 002A152]
  Ns FL Side VC WVEL VAR 2	[E-002A 56:2 002A153]
  Ns FL Side VC WVEL Over RNG 2	[E-002A 56:3 002A154]
  Ns FL Side VC WVEL Skip 2	[E-002A 56:4 002A155]
  Ns FL Side VC WVEL Up LIM 2	[E-002A 57:0 002A156]
  Ns FL Side VC WVEL DN LIM 2	[E-002A 57:1 002A157]
  Ns FL Side VC WVEL VAR Up LIM 2	[E-002A 57:2 002A158]
  Ns FL Side VC WVEL VAR DN LIM 2	[E-002A 57:3 002A159]
  Ns FL Side VC WVEL RT Up 2	[E-002A 57:4 002A15A]
  Ns FL Side VC WVEL RT DN 2	[E-002A 57:5 002A15B]
  Ns FL Side VD WVEL Alarm 2	[E-002A 58:0 002A15D]
  Ns FL Side VD WVEL NORM 2	[E-002A 58:1 002A15E]
  Ns FL Side VD WVEL VAR 2	[E-002A 58:2 002A15F]
  Ns FL Side VD WVEL Over RNG 2	[E-002A 58:3 002A160]
  Ns FL Side VD WVEL Skip 2	[E-002A 58:4 002A161]
  Ns FL Side VD WVEL Up LIM 2	[E-002A 59:0 002A162]
  Ns FL Side VD WVEL DN LIM 2	[E-002A 59:1 002A163]
  Ns FL Side VD WVEL VAR Up LIM 2	[E-002A 59:2 002A164]
  Ns FL Side VD WVEL VAR DN LIM 2	[E-002A 59:3 002A165]
  Ns FL Side VD WVEL RT Up 2	[E-002A 59:4 002A166]
  Ns FL Side VD WVEL RT DN 2	[E-002A 59:5 002A167]
  TEFL Rear V WVEL Alarm 1	[E-002A 60:0 002A169]
  TEFL Rear V WVEL NORM 1	[E-002A 60:1 002A16A]
  TEFL Rear V WVEL VAR 1	[E-002A 60:2 002A16B]
  TEFL Rear V WVEL Over RNG 1	[E-002A 60:3 002A16C]
  TEFL Rear V WVEL Skip 1	[E-002A 60:4 002A16D]
  TEFL Rear V WVEL Up LIM 1	[E-002A 61:0 002A16E]
  TEFL Rear V WVEL DN LIM 1	[E-002A 61:1 002A16F]
  TEFL Rear V WVEL VAR Up LIM 1	[E-002A 61:2 002A170]
  TEFL Rear V WVEL VAR DN LIM 1	[E-002A 61:3 002A171]
  TEFL Rear V WVEL RT Up 1	[E-002A 61:4 002A172]
  TEFL Rear V WVEL RT DN 1	[E-002A 61:5 002A173]
  Top FL Rear V WVEL Alarm 2	[E-002A 62:0 002A175]
  Top FL Rear V WVEL NORM 2	[E-002A 62:1 002A176]
  Top FL Rear V WVEL VAR 2	[E-002A 62:2 002A177]
  Top FL Rear V WVEL Over RNG 2	[E-002A 62:3 002A178]
  Top FL Rear V WVEL Skip 2	[E-002A 62:4 002A179]
  Top FL Rear V WVEL Up LIM 2	[E-002A 63:0 002A17A]
  Top FL Rear V WVEL DN LIM 2	[E-002A 63:1 002A17B]
  Top FL Rear V WVEL VAR Up LIM 2	[E-002A 63:2 002A17C]
  Top FL Rear V WVEL VAR DN LIM 2	[E-002A 63:3 002A17D]
  Top FL Rear V WVEL RT Up 2	[E-002A 63:4 002A17E]
  Top FL Rear V WVEL RT DN 2	[E-002A 63:5 002A17F]
  Top FL Side VA WVEL Alarm 1	[E-002A 64:0 002A181]
  Top FL Side VA WVEL NORM 1	[E-002A 64:1 002A182]
  Top FL Side VA WVEL VAR 1	[E-002A 64:2 002A183]
  Top FL Side VA WVEL Over RNG 1	[E-002A 64:3 002A184]
  Top FL Side VA WVEL Skip 1	[E-002A 64:4 002A185]
  Top FL Side VA WVEL Up LIM 1	[E-002A 65:0 002A186]
  Top FL Side VA WVEL DN LIM 1	[E-002A 65:1 002A187]
  Top FL Side VA WVEL VAR Up LIM 1	[E-002A 65:2 002A188]
  Top FL Side VA WVEL VAR DN LIM 1	[E-002A 65:3 002A189]
  Top FL Side VA WVEL RT Up 1	[E-002A 65:4 002A18A]
  Top FL Side VA WVEL RT DN 1	[E-002A 65:5 002A18B]
  Top FL Side VA WVEL Alarm 2	[E-002A 66:0 002A18D]
  Top FL Side VA WVEL NORM 2	[E-002A 66:1 002A18E]
  Top FL Side VA WVEL VAR 2	[E-002A 66:2 002A18F]
  Top FL Side VA WVEL Over RNG 2	[E-002A 66:3 002A190]
  Top FL Side VA WVEL Skip 2	[E-002A 66:4 002A191]
  Top FL Side VA WVEL Up LIM 2	[E-002A 67:0 002A192]
  Top FL Side VA WVEL DN LIM 2	[E-002A 67:1 002A193]
  Top FL Side VA WVEL VAR Up LIM 2	[E-002A 67:2 002A194]
  Top FL Side VA WVEL VAR DN LIM 2	[E-002A 67:3 002A195]
  Top FL Side VA WVEL RT Up 2	[E-002A 67:4 002A196]
  Top FL Side VA WVEL RT DN 2	[E-002A 67:5 002A197]
  Top FL Side VB WVEL Alarm 1	[E-002A 68:0 002A199]
  Top FL Side VB WVEL NORM 1	[E-002A 68:1 002A19A]
  Top FL Side VB WVEL VAR 1	[E-002A 68:2 002A19B]
  Top FL Side VB WVEL Over RNG 1	[E-002A 68:3 002A19C]
  Top FL Side VB WVEL Skip 1	[E-002A 68:4 002A19D]
  Top FL Side VB WVEL Up LIM 1	[E-002A 69:0 002A19E]
  Top FL Side VB WVEL DN LIM 1	[E-002A 69:1 002A19F]
  Top FL Side VB WVEL VAR Up LIM 1	[E-002A 69:2 002A1A0]
  Top FL Side VB WVEL VAR DN LIM 1	[E-002A 69:3 002A1A1]
  Top FL Side VB WVEL RT Up 1	[E-002A 69:4 002A1A2]
  Top FL Side VB WVEL RT DN 1	[E-002A 69:5 002A1A3]
  Top FL Side VB WVEL Alarm 2	[E-002A 70:0 002A1A5]
  Top FL Side VB WVEL NORM 2	[E-002A 70:1 002A1A6]
  Top FL Side VB WVEL VAR 2	[E-002A 70:2 002A1A7]
  Top FL Side VB WVEL Over RNG 2	[E-002A 70:3 002A1A8]
  Top FL Side VB WVEL Skip 2	[E-002A 70:4 002A1A9]
  Top FL Side VB WVEL Up LIM 2	[E-002A 71:0 002A1AA]
  Top FL Side VB WVEL DN LIM 2	[E-002A 71:1 002A1AB]
  Top FL Side VB WVEL VAR Up LIM 2	[E-002A 71:2 002A1AC]
  Top FL Side VB WVEL VAR DN LIM 2	[E-002A 71:3 002A1AD]
  Top FL Side VB WVEL RT Up 2	[E-002A 71:4 002A1AE]
  Top FL Side VB WVEL RT DN 2	[E-002A 71:5 002A1AF]
  Top FL Side VC WVEL Alarm 1	[E-002A 72:0 002A1B1]
  Top FL Side VC WVEL NORM 1	[E-002A 72:1 002A1B2]
  Top FL Side VC WVEL VAR 1	[E-002A 72:2 002A1B3]
  Top FL Side VC WVEL Over RNG 1	[E-002A 72:3 002A1B4]
  Top FL Side VC WVEL Skip 1	[E-002A 72:4 002A1B5]
  Top FL Side VC WVEL Up LIM 1	[E-002A 73:0 002A1B6]
  Top FL Side VC WVEL DN LIM 1	[E-002A 73:1 002A1B7]
  Top FL Side VC WVEL VAR Up LIM 1	[E-002A 73:2 002A1B8]
  Top FL Side VC WVEL VAR DN LIM 1	[E-002A 73:3 002A1B9]
  Top FL Side VC WVEL RT Up 1	[E-002A 73:4 002A1BA]
  Top FL Side VC WVEL RT DN 1	[E-002A 73:5 002A1BB]
  Top FL Side VC WVEL Alarm 2	[E-002A 74:0 002A1BD]
  Top FL Side VC WVEL NORM 2	[E-002A 74:1 002A1BE]
  Top FL Side VC WVEL  VAR 2	[E-002A 74:2 002A1BF]
  Top FL Side VC WVEL Over RNG 2	[E-002A 74:3 002A1C0]
  Top FL Side VC WVEL Skip 2	[E-002A 74:4 002A1C1]
  Top FL Side VC WVEL Up LIM 2	[E-002A 75:0 002A1C2]
  Top FL Side VC WVEL DN LIM 2	[E-002A 75:1 002A1C3]
  Top FL Side VC WVEL VAR Up LIM 2	[E-002A 75:2 002A1C4]
  Top FL Side VC WVEL VAR DN LIM 2	[E-002A 75:3 002A1C5]
  Top FL Side VC WVEL RT Up 2	[E-002A 75:4 002A1C6]
  Top FL Side VC WVEL RT DN 2	[E-002A 75:5 002A1C7]
  Top FL Side VD WVEL Alarm 1	[E-002A 76:0 002A1C9]
  Top FL Side VD WVEL NORM 1	[E-002A 76:1 002A1CA]
  Top FL Side VD WVEL VAR 1	[E-002A 76:2 002A1CB]
  Top FL Side VD WVEL Over RNG 1	[E-002A 76:3 002A1CC]
  Top FL Side VD WVEL Skip 1	[E-002A 76:4 002A1CD]
  Top FL Side VD WVEL Up LIM 1	[E-002A 77:0 002A1CE]
  Top FL Side VD WVEL DN LIM 1	[E-002A 77:1 002A1CF]
  Top FL Side VD WVEL VAR Up LIM 1	[E-002A 77:2 002A1D0]
  Top FL Side VD WVEL VAR DN LIM 1	[E-002A 77:3 002A1D1]
  Top FL Side VD WVEL RT Up 1	[E-002A 77:4 002A1D2]
  Top FL Side VD WVEL RT DN 1	[E-002A 77:5 002A1D3]
  Top FL Side VD WVEL Alarm 2	[E-002A 78:0 002A1D5]
  Top FL Side VD WVEL NORM 2	[E-002A 78:1 002A1D6]
  Top FL Side VD WVEL VAR 2	[E-002A 78:2 002A1D7]
  Top FL Side VD WVEL Over RNG 2	[E-002A 78:3 002A1D8]
  Top FL Side VD WVEL Skip 2	[E-002A 78:4 002A1D9]
  Top FL Side VD WVEL Up LIM 2	[E-002A 79:0 002A1DA]
  Top FL Side VD WVEL DN LIM 2	[E-002A 79:1 002A1DB]
  Top FL Side VD WVEL VAR Up LIM 2	[E-002A 79:2 002A1DC]
  Top FL Side VD WVEL VAR DN LIM 2	[E-002A 79:3 002A1DD]
  Top FL Side VD WVEL RT Up 2	[E-002A 79:4 002A1DE]
  Top FL Side VD WVEL RT DN 2	[E-002A 79:5 002A1DF]
  Wind Converter Alarm 1	[E-002A 80:0 002A1E1]
  Wind Converter NORM 1	[E-002A 80:1 002A1E2]
  Wind Converter VAR 1	[E-002A 80:2 002A1E3]
  Wind Converter Over RNG 1	[E-002A 80:3 002A1E4]
  Wind Converter Skip 1	[E-002A 80:4 002A1E5]
  Wind Converter Up LIM 1	[E-002A 81:0 002A1E6]
  Wind Converter DN LIM 1	[E-002A 81:1 002A1E7]
  Wind Converter VAR Up LIM 1	[E-002A 81:2 002A1E8]
  Wind Converter VAR DN LIM 1	[E-002A 81:3 002A1E9]
  Wind Converter RT Up 1	[E-002A 81:4 002A1EA]
  Wind Converter RT DN 1	[E-002A 81:5 002A1EB]
  Wind Converter Alarm 2	[E-002A 82:0 002A1ED]
  Wind Converter NORM 2	[E-002A 82:1 002A1EE]
  Wind Converter VAR 2	[E-002A 82:2 002A1EF]
  Wind Converter Over RNG 2	[E-002A 82:3 002A1F0]
  Wind Converter Skip 2	[E-002A 82:4 002A1F1]
  Wind Converter Up LIM 2	[E-002A 83:0 002A1F2]
  Wind Converter DN LIM 2	[E-002A 83:1 002A1F3]
  Wind Converter VAR Up LIM 2	[E-002A 83:2 002A1F4]
  Wind Converter VAR DN LIM 2	[E-002A 83:3 002A1F5]
  Wind Converter RT Up 2	[E-002A 83:4 002A1F6]
  Wind Converter RT DN 2	[E-002A 83:5 002A1F7]
  Wind Converter Alarm 3	[E-002A 84:0 002A1F9]
  Wind Converter NORM 3	[E-002A 84:1 002A1FA]
  Wind Converter VAR 3	[E-002A 84:2 002A1FB]
  Wind Converter Over RNG 3	[E-002A 84:3 002A1FC]
  Wind Converter Skip 3	[E-002A 84:4 002A1FD]
  Wind Converter Up LIM 3	[E-002A 85:0 002A1FE]
  Wind Converter DN LIM 3	[E-002A 85:1 002A1FF]
  Wind Converter VAR Up LIM 3	[E-002A 85:2 002A200]
  Wind Converter VAR DN LIM 3	[E-002A 85:3 002A201]
  Wind Converter RT Up 3	[E-002A 85:4 002A202]
  Wind Converter RT DN 3	[E-002A 85:5 002A203]
  Wind Converter Alarm 4	[E-002A 86:0 002A205]
  Wind Converter NORM 4	[E-002A 86:1 002A206]
  Wind Converter VAR 4	[E-002A 86:2 002A207]
  Wind Converter Over RNG 4	[E-002A 86:3 002A208]
  Wind Converter Skip 4	[E-002A 86:4 002A209]
  Wind Converter Up LIM 4	[E-002A 87:0 002A20A]
  Wind Converter DN LIM 4	[E-002A 87:1 002A20B]
  Wind Converter VAR Up LIM 4	[E-002A 87:2 002A20C]
  Wind Converter VAR DN LIM 4	[E-002A 87:3 002A20D]
  Wind Converter RT Up 4	[E-002A 87:4 002A20E]
  Wind Converter RT DN 4	[E-002A 87:5 002A20F]
  Wind Converter Alarm 5	[E-002A 88:0 002A211]
  Wind Converter NORM 5	[E-002A 88:1 002A212]
  Wind Converter VAR 5	[E-002A 88:2 002A213]
  Wind Converter Over RNG 5	[E-002A 88:3 002A214]
  Wind Converter Skip 5	[E-002A 88:4 002A215]
  Wind Converter Up LIM 5	[E-002A 89:0 002A216]
  Wind Converter DN LIM 5	[E-002A 89:1 002A217]
  Wind Converter VAR Up LIM 5	[E-002A 89:2 002A218]
  Wind Converter VAR DN LIM 5	[E-002A 89:3 002A219]
  Wind Converter RT Up 5	[E-002A 89:4 002A21A]
  Wind Converter RT DN 5	[E-002A 89:5 002A21B]
  Wind Converter Alarm 6	[E-002A 90:0 002A21D]
  Wind Converter NORM 6	[E-002A 90:1 002A21E]
  Wind Converter VAR 6	[E-002A 90:2 002A21F]
  Wind Converter Over RNG 6	[E-002A 90:3 002A220]
  Wind Converter Skip 6	[E-002A 90:4 002A221]
  Wind Converter Up LIM 6	[E-002A 91:0 002A222]
  Wind Converter DN LIM 6	[E-002A 91:1 002A223]
  Wind Converter VAR Up LIM 6	[E-002A 91:2 002A224]
  Wind Converter VAR DN LIM 6	[E-002A 91:3 002A225]
  Wind Converter RT Up 6	[E-002A 91:4 002A226]
  Wind Converter RT DN 6	[E-002A 91:5 002A227]
  Cs FL Side VA Temp Alarm	[E-002A 92:0 002A229]
  Cs FL Side VA Temp NORM	[E-002A 92:1 002A22A]
  Cs FL Side VA Temp VAR	[E-002A 92:2 002A22B]
  Cs FL Side VA Temp Over RNG	[E-002A 92:3 002A22C]
  Cs FL Side VA Temp Skip	[E-002A 92:4 002A22D]
  Cs FL Side VA Temp Up LIM	[E-002A 93:0 002A22E]
  Cs FL Side VA Temp DN LIM	[E-002A 93:1 002A22F]
  Cs FL Side VA Temp VAR Up LIM	[E-002A 93:2 002A230]
  Cs FL Side VA Temp VAR DN LIM	[E-002A 93:3 002A231]
  Cs FL Side VA Temp RT Up	[E-002A 93:4 002A232]
  Cs FL Side VA Temp RT DN	[E-002A 93:5 002A233]
  Cs FL Side VB Temp Alarm	[E-002A 94:0 002A235]
  Cs FL Side VB Temp NORM	[E-002A 94:1 002A236]
  Cs FL Side VB Temp VAR	[E-002A 94:2 002A237]
  Cs FL Side VB Temp Over RNG	[E-002A 94:3 002A238]
  Cs FL Side VB Temp Skip	[E-002A 94:4 002A239]
  Cs FL Side VB Temp Up LIM	[E-002A 95:0 002A23A]
  Cs FL Side VB Temp DN LIM	[E-002A 95:1 002A23B]
  Cs FL Side VB Temp VAR Up LIM	[E-002A 95:2 002A23C]
  Cs FL Side VB Temp VAR DN LIM	[E-002A 95:3 002A23D]
  Cs FL Side VB Temp RT Up	[E-002A 95:4 002A23E]
  Cs FL Side VB Temp RT DN	[E-002A 95:5 002A23F]
  Cs FL Side VC Temp Alarm	[E-002A 96:0 002A241]
  Cs FL Side VC Temp NORM	[E-002A 96:1 002A242]
  Cs FL Side VC Temp VAR	[E-002A 96:2 002A243]
  Cs FL Side VC Temp Over RNG	[E-002A 96:3 002A244]
  Cs FL Side VC Temp Skip	[E-002A 96:4 002A245]
  Cs FL Side VC Temp Up LIM	[E-002A 97:0 002A246]
  Cs FL Side VC Temp DN LIM	[E-002A 97:1 002A247]
  Cs FL Side VC Temp VAR Up LIM	[E-002A 97:2 002A248]
  Cs FL Side VC Temp VAR DN LIM	[E-002A 97:3 002A249]
  Cs FL Side VC Temp RT Up	[E-002A 97:4 002A24A]
  Cs FL Side VC Temp RT DN	[E-002A 97:5 002A24B]
  Cs FL Side VD Temp Alarm	[E-002A 98:0 002A24D]
  Cs FL Side VD Temp NORM	[E-002A 98:1 002A24E]
  Cs FL Side VD Temp VAR	[E-002A 98:2 002A24F]
  Cs FL Side VD Temp Over RNG	[E-002A 98:3 002A250]
  Cs FL Side VD Temp Skip	[E-002A 98:4 002A251]
  Cs FL Side VD Temp Up LIM	[E-002A 99:0 002A252]
  Cs FL Side VD Temp DN LIM	[E-002A 99:1 002A253]
  Cs FL Side VD Temp VAR Up LIM	[E-002A 99:2 002A254]
  Cs FL Side VD Temp VAR DN LIM	[E-002A 99:3 002A255]
  Cs FL Side VD Temp RT Up	[E-002A 99:4 002A256]
  Cs FL Side VD Temp RT DN	[E-002A 99:5 002A257]
  Ns FL Side VA Temp Alarm	[E-002A 100:0 002A259]
  Ns FL Side VA Temp NORM	[E-002A 100:1 002A25A]
  Ns FL Side VA Temp VAR	[E-002A 100:2 002A25B]
  Ns FL Side VA Temp Over RNG	[E-002A 100:3 002A25C]
  Ns FL Side VA Temp Skip	[E-002A 100:4 002A25D]
  Ns FL Side VA Temp Up LIM	[E-002A 101:0 002A25E]
  Ns FL Side VA Temp DN LIM	[E-002A 101:1 002A25F]
  Ns FL Side VA Temp VAR Up LIM	[E-002A 101:2 002A260]
  Ns FL Side VA Temp VAR DN LIM	[E-002A 101:3 002A261]
  Ns FL Side VA Temp RT Up	[E-002A 101:4 002A262]
  Ns FL Side VA Temp RT DN	[E-002A 101:5 002A263]
  Ns FL Side VB Temp Alarm	[E-002A 102:0 002A265]
  Ns FL Side VB Temp NORM	[E-002A 102:1 002A266]
  Ns FL Side VB Temp VAR	[E-002A 102:2 002A267]
  Ns FL Side VB Temp Over RNG	[E-002A 102:3 002A268]
  Ns FL Side VB Temp Skip	[E-002A 102:4 002A269]
  Ns FL Side VB Temp Up LIM	[E-002A 103:0 002A26A]
  Ns FL Side VB Temp DN LIM	[E-002A 103:1 002A26B]
  Ns FL Side VB Temp VAR Up LIM	[E-002A 103:2 002A26C]
  Ns FL Side VB Temp VAR DN LIM	[E-002A 103:3 002A26D]
  Ns FL Side VB Temp RT Up	[E-002A 103:4 002A26E]
  Ns FL Side VB Temp RT DN	[E-002A 103:5 002A26F]
  Ns FL Side VC Temp Alarm	[E-002A 104:0 002A271]
  Ns FL Side VC Temp NORM	[E-002A 104:1 002A272]
  Ns FL Side VC Temp VAR	[E-002A 104:2 002A273]
  Ns FL Side VC Temp Over RNG	[E-002A 104:3 002A274]
  Ns FL Side VC Temp Skip	[E-002A 104:4 002A275]
  Ns FL Side VC Temp Up LIM	[E-002A 105:0 002A276]
  Ns FL Side VC Temp DN LIM	[E-002A 105:1 002A277]
  Ns FL Side VC Temp VAR Up LIM	[E-002A 105:2 002A278]
  Ns FL Side VC Temp VAR DN LIM	[E-002A 105:3 002A279]
  Ns FL Side VC Temp RT Up	[E-002A 105:4 002A27A]
  Ns FL Side VC Temp RT DN	[E-002A 105:5 002A27B]
  Ns FL Side VD Temp Alarm	[E-002A 106:0 002A27D]
  Ns FL Side VD Temp NORM	[E-002A 106:1 002A27E]
  Ns FL Side VD Temp VAR	[E-002A 106:2 002A27F]
  Ns FL Side VD Temp Over RNG	[E-002A 106:3 002A280]
  Ns FL Side VD Temp Skip	[E-002A 106:4 002A281]
  Ns FL Side VD Temp Up LIM	[E-002A 107:0 002A282]
  Ns FL Side VD Temp DN LIM	[E-002A 107:1 002A283]
  Ns FL Side VD Temp VAR Up LIM	[E-002A 107:2 002A284]
  Ns FL Side VD Temp VAR DN LIM	[E-002A 107:3 002A285]
  Ns FL Side VD Temp RT Up	[E-002A 107:4 002A286]
  Ns FL Side VD Temp RT DN	[E-002A 107:5 002A287]
  TEFL Side VB Temp Alarm	[E-002A 108:0 002A289]
  TEFL Side VB Temp NORM	[E-002A 108:1 002A28A]
  TEFL Side VB Temp VAR	[E-002A 108:2 002A28B]
  TEFL Side VB Temp Over RNG	[E-002A 108:3 002A28C]
  TEFL Side VB Temp Skip	[E-002A 108:4 002A28D]
  TEFL Side VB Temp Up LIM	[E-002A 109:0 002A28E]
  TEFL Side VB Temp DN LIM	[E-002A 109:1 002A28F]
  TEFL Side VB Temp VAR Up LIM	[E-002A 109:2 002A290]
  TEFL Side VB Temp VAR DN LIM	[E-002A 109:3 002A291]
  TEFL Side VB Temp RT Up	[E-002A 109:4 002A292]
  TEFL Side VB Temp RT DN	[E-002A 109:5 002A293]
  TEFL Side VD Temp Alarm	[E-002A 110:0 002A295]
  TEFL Side VD Temp NORM	[E-002A 110:1 002A296]
  TEFL Side VD Temp VAR	[E-002A 110:2 002A297]
  TEFL Side VD Temp Over RNG	[E-002A 110:3 002A298]
  TEFL Side VD Temp Skip	[E-002A 110:4 002A299]
  TEFL Side VD Temp Up LIM	[E-002A 111:0 002A29A]
  TEFL Side VD Temp DN LIM	[E-002A 111:1 002A29B]
  TEFL Side VD Temp VAR Up LIM	[E-002A 111:2 002A29C]
  TEFL Side VD Temp VAR DN LIM	[E-002A 111:3 002A29D]
  TEFL Side VD Temp RT Up	[E-002A 111:4 002A29E]
  TEFL Side VD Temp RT DN	[E-002A 111:5 002A29F]
  Top FL Side VA Temp Alarm	[E-002A 112:0 002A2A1]
  Top FL Side VA Temp NORM	[E-002A 112:1 002A2A2]
  Top FL Side VA Temp VAR	[E-002A 112:2 002A2A3]
  Top FL Side VA Temp Over RNG	[E-002A 112:3 002A2A4]
  Top FL Side VA Temp Skip	[E-002A 112:4 002A2A5]
  Top FL Side VA Temp Up LIM	[E-002A 113:0 002A2A6]
  Top FL Side VA Temp DN LIM	[E-002A 113:1 002A2A7]
  Top FL Side VA Temp VAR Up LIM	[E-002A 113:2 002A2A8]
  Top FL Side VA Temp VAR DN LIM	[E-002A 113:3 002A2A9]
  Top FL Side VA Temp RT Up	[E-002A 113:4 002A2AA]
  Top FL Side VA Temp RT DN	[E-002A 113:5 002A2AB]
  Top FL Side VB Temp Alarm	[E-002A 114:0 002A2AD]
  Top FL Side VB Temp NORM	[E-002A 114:1 002A2AE]
  Top FL Side VB Temp VAR	[E-002A 114:2 002A2AF]
  Top FL Side VB Temp Over RNG	[E-002A 114:3 002A2B0]
  Top FL Side VB Temp Skip	[E-002A 114:4 002A2B1]
  Top FL Side VB Temp Up LIM	[E-002A 115:0 002A2B2]
  Top FL Side VB Temp DN LIM	[E-002A 115:1 002A2B3]
  Top FL Side VB Temp VAR Up LIM	[E-002A 115:2 002A2B4]
  Top FL Side VB Temp VAR DN LIM	[E-002A 115:3 002A2B5]
  Top FL Side VB Temp RT Up	[E-002A 115:4 002A2B6]
  Top FL Side VB Temp RT DN	[E-002A 115:5 002A2B7]
  Top FL Side VC Temp Alarm	[E-002A 116:0 002A2B9]
  Top FL Side VC Temp NORM	[E-002A 116:1 002A2BA]
  Top FL Side VC Temp VAR	[E-002A 116:2 002A2BB]
  Top FL Side VC Temp Over RNG	[E-002A 116:3 002A2BC]
  Top FL Side VC Temp Skip	[E-002A 116:4 002A2BD]
  Top FL Side VC Temp Up LIM	[E-002A 117:0 002A2BE]
  Top FL Side VC Temp DN LIM	[E-002A 117:1 002A2BF]
  Top FL Side VC Temp VAR Up LIM	[E-002A 117:2 002A2C0]
  Top FL Side VC Temp VAR DN LIM	[E-002A 117:3 002A2C1]
  Top FL Side VC Temp RT Up	[E-002A 117:4 002A2C2]
  Top FL Side VC Temp RT DN	[E-002A 117:5 002A2C3]
  Top FL Side VD Temp Alarm	[E-002A 118:0 002A2C5]
  Top FL Side VD Temp NORM	[E-002A 118:1 002A2C6]
  Top FL Side VD Temp VAR	[E-002A 118:2 002A2C7]
  Top FL Side VD Temp Over RNG	[E-002A 118:3 002A2C8]
  Top FL Side VD Temp Skip	[E-002A 118:4 002A2C9]
  Top FL Side VD Temp Up LIM	[E-002A 119:0 002A2CA]
  Top FL Side VD Temp DN LIM	[E-002A 119:1 002A2CB]
  Top FL Side VD Temp VAR Up LIM	[E-002A 119:2 002A2CC]
  Top FL Side VD Temp VAR DN LIM	[E-002A 119:3 002A2CD]
  Top FL Side VD Temp RT Up	[E-002A 119:4 002A2CE]
  Top FL Side VD Temp RT DN	[E-002A 119:5 002A2CF]
  Front V Temp(Air) Alarm	[E-002A 120:0 002A2D1]
  Front V Temp(Air) NORM	[E-002A 120:1 002A2D2]
  Front V Temp(Air) VAR	[E-002A 120:2 002A2D3]
  Front V Temp(Air) Over RNG	[E-002A 120:3 002A2D4]
  Front V Temp(Air) Skip	[E-002A 120:4 002A2D5]
  Front V Temp(Air) Up LIM	[E-002A 121:0 002A2D6]
  Front V Temp(Air) DN LIM	[E-002A 121:1 002A2D7]
  Front V Temp(Air) VAR Up LIM	[E-002A 121:2 002A2D8]
  Front V Temp(Air) VAR DN LIM	[E-002A 121:3 002A2D9]
  Front V Temp(Air) RT Up	[E-002A 121:4 002A2DA]
  Front V Temp(Air) RT DN	[E-002A 121:5 002A2DB]
  Cs Rear V Temp(Air) Alarm	[E-002A 122:0 002A2DD]
  Cs Rear V Temp(Air) NORM	[E-002A 122:1 002A2DE]
  Cs Rear V Temp(Air) VAR	[E-002A 122:2 002A2DF]
  Cs Rear V Temp(Air) Over RNG	[E-002A 122:3 002A2E0]
  Cs Rear V Temp(Air) Skip	[E-002A 122:4 002A2E1]
  Cs Rear V Temp(Air) Up LIM	[E-002A 123:0 002A2E2]
  Cs Rear V Temp(Air) DN LIM	[E-002A 123:1 002A2E3]
  Cs Rear V Temp(Air) VAR Up LIM	[E-002A 123:2 002A2E4]
  Cs Rear V Temp(Air) VAR DN LIM	[E-002A 123:3 002A2E5]
  Cs Rear V Temp(Air) RT Up	[E-002A 123:4 002A2E6]
  Cs Rear V Temp(Air) RT DN	[E-002A 123:5 002A2E7]
  Cs Side VA Temp(Air) Alarm	[E-002A 124:0 002A2E9]
  Cs Side VA Temp(Air) NORM	[E-002A 124:1 002A2EA]
  Cs Side VA Temp(Air) VAR	[E-002A 124:2 002A2EB]
  Cs Side VA Temp(Air) Over RNG	[E-002A 124:3 002A2EC]
  Cs Side VA Temp(Air) Skip	[E-002A 124:4 002A2ED]
  Cs Side VA Temp(Air) Up LIM	[E-002A 125:0 002A2EE]
  Cs Side VA Temp(Air) DN LIM	[E-002A 125:1 002A2EF]
  Cs Side VA Temp(Air) VAR Up LIM	[E-002A 125:2 002A2F0]
  Cs Side VA Temp(Air) VAR DN LIM	[E-002A 125:3 002A2F1]
  Cs Side VA Temp(Air) RT Up	[E-002A 125:4 002A2F2]
  Cs Side VA Temp(Air) RT DN	[E-002A 125:5 002A2F3]
  Cs Side VB Temp(Air) Alarm	[E-002A 126:0 002A2F5]
  Cs Side VB Temp(Air) NORM	[E-002A 126:1 002A2F6]
  Cs Side VB Temp(Air) VAR	[E-002A 126:2 002A2F7]
  Cs Side VB Temp(Air) Over RNG	[E-002A 126:3 002A2F8]
  Cs Side VB Temp(Air) Skip	[E-002A 126:4 002A2F9]
  Cs Side VB Temp(Air) Up LIM	[E-002A 127:0 002A2FA]
  Cs Side VB Temp(Air) DN LIM	[E-002A 127:1 002A2FB]
  Cs Side VB Temp(Air) VAR Up LIM	[E-002A 127:2 002A2FC]
  Cs Side VB Temp(Air) VAR DN LIM	[E-002A 127:3 002A2FD]
  Cs Side VB Temp(Air) RT Up	[E-002A 127:4 002A2FE]
  Cs Side VB Temp(Air) RT DN	[E-002A 127:5 002A2FF]
  Cs Side VC Temp(Air) Alarm	[E-002A 128:0 002A301]
  Cs Side VC Temp(Air) NORM	[E-002A 128:1 002A302]
  Cs Side VC Temp(Air) VAR	[E-002A 128:2 002A303]
  Cs Side VC Temp(Air) Over RNG	[E-002A 128:3 002A304]
  Cs Side VC Temp(Air) Skip	[E-002A 128:4 002A305]
  Cs Side VC Temp(Air) Up LIM	[E-002A 129:0 002A306]
  Cs Side VC Temp(Air) DN LIM	[E-002A 129:1 002A307]
  Cs Side VC Temp(Air) VAR Up LIM	[E-002A 129:2 002A308]
  Cs Side VC Temp(Air) VAR DN LIM	[E-002A 129:3 002A309]
  Cs Side VC Temp(Air) RT Up	[E-002A 129:4 002A30A]
  Cs Side VC Temp(Air) RT DN	[E-002A 129:5 002A30B]
  Cs Side VD Temp(Air) Alarm	[E-002A 130:0 002A30D]
  Cs Side VD Temp(Air) NORM	[E-002A 130:1 002A30E]
  Cs Side VD Temp(Air) VAR	[E-002A 130:2 002A30F]
  Cs Side VD Temp(Air) Over RNG	[E-002A 130:3 002A310]
  Cs Side VD Temp(Air) Skip	[E-002A 130:4 002A311]
  Cs Side VD Temp(Air) Up LIM	[E-002A 131:0 002A312]
  Cs Side VD Temp(Air) DN LIM	[E-002A 131:1 002A313]
  Cs Side VD Temp(Air) VAR Up LIM	[E-002A 131:2 002A314]
  Cs Side VD Temp(Air) VAR DN LIM	[E-002A 131:3 002A315]
  Cs Side VD Temp(Air) RT Up	[E-002A 131:4 002A316]
  Cs Side VD Temp(Air) RT DN	[E-002A 131:5 002A317]
  Ns FL Rear V Temp(Air) Alarm	[E-002A 132:0 002A319]
  Ns FL Rear V Temp(Air) NORM	[E-002A 132:1 002A31A]
  Ns FL Rear V Temp(Air) VAR	[E-002A 132:2 002A31B]
  Ns FL Rear V Temp(Air) Over RNG	[E-002A 132:3 002A31C]
  Ns FL Rear V Temp(Air) Skip	[E-002A 132:4 002A31D]
  Ns FL Rear V Temp(Air) Up LIM	[E-002A 133:0 002A31E]
  Ns FL Rear V Temp(Air) DN LIM	[E-002A 133:1 002A31F]
  Ns FL Rear V Temp(Air) VAR Up LIM	[E-002A 133:2 002A320]
  Ns FL Rear V Temp(Air) VAR DN LIM	[E-002A 133:3 002A321]
  Ns FL Rear V Temp(Air) RT Up	[E-002A 133:4 002A322]
  Ns FL Rear V Temp(Air) RT DN	[E-002A 133:5 002A323]
  Ns FL Side VA Temp(Air) Alarm	[E-002A 134:0 002A325]
  Ns FL Side VA Temp(Air) NORM	[E-002A 134:1 002A326]
  Ns FL Side VA Temp(Air) VAR	[E-002A 134:2 002A327]
  Ns FL Side VA Temp(Air) Over RNG	[E-002A 134:3 002A328]
  Ns FL Side VA Temp(Air) Skip	[E-002A 134:4 002A329]
  Ns FL Side VA Temp(Air) Up LIM	[E-002A 135:0 002A32A]
  Ns FL Side VA Temp(Air) DN LIM	[E-002A 135:1 002A32B]
  Ns FL Side VA Temp(Air) VAR Up LIM	[E-002A 135:2 002A32C]
  Ns FL Side VA Temp(Air) VAR DN LIM	[E-002A 135:3 002A32D]
  Ns FL Side VA Temp(Air) RT Up	[E-002A 135:4 002A32E]
  Ns FL Side VA Temp(Air) RT DN	[E-002A 135:5 002A32F]
  Ns FL Side VB Temp(Air) Alarm	[E-002A 136:0 002A331]
  Ns FL Side VB Temp(Air) NORM	[E-002A 136:1 002A332]
  Ns FL Side VB Temp(Air) VAR	[E-002A 136:2 002A333]
  Ns FL Side VB Temp(Air) Over RNG	[E-002A 136:3 002A334]
  Ns FL Side VB Temp(Air) Skip	[E-002A 136:4 002A335]
  Ns FL Side VB Temp(Air) Up LIM	[E-002A 137:0 002A336]
  Ns FL Side VB Temp(Air) DN LIM	[E-002A 137:1 002A337]
  Ns FL Side VB Temp(Air) VAR Up LIM	[E-002A 137:2 002A338]
  Ns FL Side VB Temp(Air) VAR DN LIM	[E-002A 137:3 002A339]
  Ns FL Side VB Temp(Air) RT Up	[E-002A 137:4 002A33A]
  Ns FL Side VB Temp(Air) RT DN	[E-002A 137:5 002A33B]
  Ns FL Side VC Temp(Air) Alarm	[E-002A 138:0 002A33D]
  Ns FL Side VC Temp(Air) NORM	[E-002A 138:1 002A33E]
  Ns FL Side VC Temp(Air) VAR	[E-002A 138:2 002A33F]
  Ns FL Side VC Temp(Air) Over RNG	[E-002A 138:3 002A340]
  Ns FL Side VC Temp(Air) Skip	[E-002A 138:4 002A341]
  Ns FL Side VC Temp(Air) Up LIM	[E-002A 139:0 002A342]
  Ns FL Side VC Temp(Air) DN LIM	[E-002A 139:1 002A343]
  Ns FL Side VC Temp(Air) VAR Up LIM	[E-002A 139:2 002A344]
  Ns FL Side VC Temp(Air) VAR DN LIM	[E-002A 139:3 002A345]
  Ns FL Side VC Temp(Air) RT Up	[E-002A 139:4 002A346]
  Ns FL Side VC Temp(Air) RT DN	[E-002A 139:5 002A347]
  Ns FL Side VD Temp(Air) Alarm	[E-002A 140:0 002A349]
  Ns FL Side VD Temp(Air) NORM	[E-002A 140:1 002A34A]
  Ns FL Side VD Temp(Air) VAR	[E-002A 140:2 002A34B]
  Ns FL Side VD Temp(Air) Over RNG	[E-002A 140:3 002A34C]
  Ns FL Side VD Temp(Air) Skip	[E-002A 140:4 002A34D]
  Ns FL Side VD Temp(Air) Up LIM	[E-002A 141:0 002A34E]
  Ns FL Side VD Temp(Air) DN LIM	[E-002A 141:1 002A34F]
  Ns FL Side VD Temp(Air) VAR Up LIM	[E-002A 141:2 002A350]
  Ns FL Side VD Temp(Air) VAR DN LIM	[E-002A 141:3 002A351]
  Ns FL Side VD Temp(Air) RT Up	[E-002A 141:4 002A352]
  Ns FL Side VD Temp(Air) RT DN	[E-002A 141:5 002A353]
  TEFL TSCRN(R) Temp(Air) Alarm	[E-002A 142:0 002A355]
  TEFL TSCRN(R) Temp(Air) NORM	[E-002A 142:1 002A356]
  TEFL TSCRN(R) Temp(Air) VAR	[E-002A 142:2 002A357]
  TEFL TSCRN(R) Temp(Air) Over RNG	[E-002A 142:3 002A358]
  TEFL TSCRN(R) Temp(Air) Skip	[E-002A 142:4 002A359]
  TEFL TSCRN(R) Temp(Air) Up LIM	[E-002A 143:0 002A35A]
  TEFL TSCRN(R) Temp(Air) DN LIM	[E-002A 143:1 002A35B]
  TEFL TSCRN(R) Temp(Air) VAR Up LIM	[E-002A 143:2 002A35C]
  TEFL TSCRN(R) Temp(Air) VAR DN LIM	[E-002A 143:3 002A35D]
  TEFL TSCRN(R) Temp(Air) RT Up	[E-002A 143:4 002A35E]
  TEFL TSCRN(R) Temp(Air) RT DN	[E-002A 143:5 002A35F]
  TEFL Side VB Temp(Air) Alarm	[E-002A 144:0 002A361]
  TEFL Side VB Temp(Air) NORM	[E-002A 144:1 002A362]
  TEFL Side VB Temp(Air) VAR	[E-002A 144:2 002A363]
  TEFL Side VB Temp(Air) Over RNG	[E-002A 144:3 002A364]
  TEFL Side VB Temp(Air) Skip	[E-002A 144:4 002A365]
  TEFL Side VB Temp(Air) Up LIM	[E-002A 145:0 002A366]
  TEFL Side VB Temp(Air) DN LIM	[E-002A 145:1 002A367]
  TEFL Side VB Temp(Air) VAR Up LIM	[E-002A 145:2 002A368]
  TEFL Side VB Temp(Air) VAR DN LIM	[E-002A 145:3 002A369]
  TEFL Side VB Temp(Air) RT Up	[E-002A 145:4 002A36A]
  TEFL Side VB Temp(Air) RT DN	[E-002A 145:5 002A36B]
  TEFL Side VC Temp(Air) Alarm	[E-002A 146:0 002A36D]
  TEFL Side VC Temp(Air) NORM	[E-002A 146:1 002A36E]
  TEFL Side VC Temp(Air) VAR	[E-002A 146:2 002A36F]
  TEFL Side VC Temp(Air) Over RNG	[E-002A 146:3 002A370]
  TEFL Side VC Temp(Air) Skip	[E-002A 146:4 002A371]
  TEFL Side VC Temp(Air) Up LIM	[E-002A 147:0 002A372]
  TEFL Side VC Temp(Air) DN LIM	[E-002A 147:1 002A373]
  TEFL Side VC Temp(Air) VAR Up LIM	[E-002A 147:2 002A374]
  TEFL Side VC Temp(Air) VAR DN LIM	[E-002A 147:3 002A375]
  TEFL Side VC Temp(Air) RT Up	[E-002A 147:4 002A376]
  TEFL Side VC Temp(Air) RT DN	[E-002A 147:5 002A377]
  Top FL Rear V Temp(Air) Alarm	[E-002A 148:0 002A379]
  Top FL Rear V Temp(Air) NORM	[E-002A 148:1 002A37A]
  Top FL Rear V Temp(Air) VAR	[E-002A 148:2 002A37B]
  Top FL Rear V Temp(Air) Over RNG	[E-002A 148:3 002A37C]
  Top FL Rear V Temp(Air) Skip	[E-002A 148:4 002A37D]
  Top FL Rear V Temp(Air) Up LIM	[E-002A 149:0 002A37E]
  Top FL Rear V Temp(Air) DN LIM	[E-002A 149:1 002A37F]
  Top FL Rear V Temp(Air) VAR Up LIM	[E-002A 149:2 002A380]
  Top FL Rear V Temp(Air) VAR DN LIM	[E-002A 149:3 002A381]
  Top FL Rear V Temp(Air) RT Up	[E-002A 149:4 002A382]
  Top FL Rear V Temp(Air) RT DN	[E-002A 149:5 002A383]
  Top FL Side VA Temp(Air) Alarm	[E-002A 150:0 002A385]
  Top FL Side VA Temp(Air) NORM	[E-002A 150:1 002A386]
  Top FL Side VA Temp(Air) VAR	[E-002A 150:2 002A387]
  Top FL Side VA Temp(Air) Over RNG	[E-002A 150:3 002A388]
  Top FL Side VA Temp(Air) Skip	[E-002A 150:4 002A389]
  Top FL Side VA Temp(Air) Up LIM	[E-002A 151:0 002A38A]
  Top FL Side VA Temp(Air) DN LIM	[E-002A 151:1 002A38B]
  Top FL Side VA Temp(Air) VAR Up LIM	[E-002A 151:2 002A38C]
  Top FL Side VA Temp(Air) VAR DN LIM	[E-002A 151:3 002A38D]
  Top FL Side VA Temp(Air) RT Up	[E-002A 151:4 002A38E]
  Top FL Side VA Temp(Air) RT DN	[E-002A 151:5 002A38F]
  Top FL Side VB Temp(Air) Alarm	[E-002A 152:0 002A391]
  Top FL Side VB Temp(Air) NORM	[E-002A 152:1 002A392]
  Top FL Side VB Temp(Air) VAR	[E-002A 152:2 002A393]
  Top FL Side VB Temp(Air) Over RNG	[E-002A 152:3 002A394]
  Top FL Side VB Temp(Air) Skip	[E-002A 152:4 002A395]
  Top FL Side VB Temp(Air) Up LIM	[E-002A 153:0 002A396]
  Top FL Side VB Temp(Air) DN LIM	[E-002A 153:1 002A397]
  Top FL Side VB Temp(Air) VAR Up LIM	[E-002A 153:2 002A398]
  Top FL Side VB Temp(Air) VAR DN LIM	[E-002A 153:3 002A399]
  Top FL Side VB Temp(Air) RT Up	[E-002A 153:4 002A39A]
  Top FL Side VB Temp(Air) RT DN	[E-002A 153:5 002A39B]
  Top FL Side VC Temp(Air) Alarm	[E-002A 154:0 002A39D]
  Top FL Side VC Temp(Air) NORM	[E-002A 154:1 002A39E]
  Top FL Side VC Temp(Air) VAR	[E-002A 154:2 002A39F]
  Top FL Side VC Temp(Air) Over RNG	[E-002A 154:3 002A3A0]
  Top FL Side VC Temp(Air) Skip	[E-002A 154:4 002A3A1]
  Top FL Side VC Temp(Air) Up LIM	[E-002A 155:0 002A3A2]
  Top FL Side VC Temp(Air) DN LIM	[E-002A 155:1 002A3A3]
  Top FL Side VC Temp(Air) VAR Up LIM	[E-002A 155:2 002A3A4]
  Top FL Side VC Temp(Air) VAR DN LIM	[E-002A 155:3 002A3A5]
  Top FL Side VC Temp(Air) RT Up	[E-002A 155:4 002A3A6]
  Top FL Side VC Temp(Air) RT DN	[E-002A 155:5 002A3A7]
  Top FL Side VD Temp(Air) Alarm	[E-002A 156:0 002A3A9]
  Top FL Side VD Temp(Air) NORM	[E-002A 156:1 002A3AA]
  Top FL Side VD Temp(Air) VAR	[E-002A 156:2 002A3AB]
  Top FL Side VD Temp(Air) Over RNG	[E-002A 156:3 002A3AC]
  Top FL Side VD Temp(Air) Skip	[E-002A 156:4 002A3AD]
  Top FL Side VD Temp(Air) Up LIM	[E-002A 157:0 002A3AE]
  Top FL Side VD Temp(Air) DN LIM	[E-002A 157:1 002A3AF]
  Top FL Side VD Temp(Air) VAR Up LIM	[E-002A 157:2 002A3B0]
  Top FL Side VD Temp(Air) VAR DN LIM	[E-002A 157:3 002A3B1]
  Top FL Side VD Temp(Air) RT Up	[E-002A 157:4 002A3B2]
  Top FL Side VD Temp(Air) RT DN	[E-002A 157:5 002A3B3]
  Top Unit EXCH Temp(Air) Alarm	[E-002A 158:0 002A3B5]
  Top Unit EXCH Temp(Air) NORM	[E-002A 158:1 002A3B6]
  Top Unit EXCH Temp(Air) VAR	[E-002A 158:2 002A3B7]
  Top Unit EXCH Temp(Air) Over RNG	[E-002A 158:3 002A3B8]
  Top Unit EXCH Temp(Air) Skip	[E-002A 158:4 002A3B9]
  Top Unit EXCH Temp(Air) Up LIM	[E-002A 159:0 002A3BA]
  Top Unit EXCH Temp(Air) DN LIM	[E-002A 159:1 002A3BB]
  Top Unit EXCH Temp(Air) VAR Up LIM	[E-002A 159:2 002A3BC]
  Top Unit EXCH Temp(Air) VAR DN LIM	[E-002A 159:3 002A3BD]
  Top Unit EXCH Temp(Air) RT Up	[E-002A 159:4 002A3BE]
  Top Unit EXCH Temp(Air) RT DN	[E-002A 159:5 002A3BF]
  Roof(R) AVG WVEL Data	[L-002A 0 002A00C BCD6]
  Roof(R) INST WVEL Data	[L-002A 6 002A018 BCD6]
  Roof(R) WDIR Data	[L-002A 12 002A024 BCD6]
  Roof Opt(F) AVG WVEL Data	[L-002A 18 002A030 BCD6]
  Roof Opt(F) INST WVEL Data	[L-002A 24 002A03C BCD6]
  Roof Opt(F) WDIR Data	[L-002A 30 002A048 BCD6]
  Roof IR(F) AVG WVEL Data	[L-002A 36 002A054 BCD6]
  Roof IR(F) INST WVEL Data	[L-002A 42 002A060 BCD6]
  Roof IR(F) WDIR Data	[L-002A 48 002A06C BCD6]
  Front V WDIR Data	[L-002A 54 002A078 BCD6]
  Ns FL Rear V1 WDIR Data	[L-002A 60 002A084 BCD6]
  Ns FL Side VA WDIR Data	[L-002A 66 002A090 BCD6]
  Ns FL Side VB WDIR Data	[L-002A 72 002A09C BCD6]
  Ns FL Side VC WDIR Data	[L-002A 78 002A0A8 BCD6]
  Ns FL Side VD WDIR Data	[L-002A 84 002A0B4 BCD6]
  TLSCP Room(NsIR) HMD Data	[L-002A 90 002A0C0 BCD6]
  TLSCP Room HMD Data	[L-002A 96 002A0CC BCD6]
  TLSCP Room(NsOpt) HMD Data	[L-002A 102 002A0D8 BCD6]
  Top Unit EXCH HMD Data	[L-002A 108 002A0E4 BCD6]
  Front V WVEL Data	[L-002A 114 002A0F0 BCD6]
  Ns FL Rear V WVEL Data	[L-002A 120 002A0FC BCD6]
  Ns FL Side VA WVEL Data 1	[L-002A 126 002A108 BCD6]
  Ns FL Side VB WVEL Data 1	[L-002A 132 002A114 BCD6]
  Ns FL Side VC WVEL Data 1	[L-002A 138 002A120 BCD6]
  Ns FL Side VD WVEL Data 1	[L-002A 144 002A12C BCD6]
  Ns FL Rear V WVEL Data 2	[L-002A 150 002A138 BCD6]
  Ns FL Side VA WVEL Data 2	[L-002A 156 002A144 BCD6]
  Ns FL Side VB WVEL Data 2	[L-002A 162 002A150 BCD6]
  Ns FL Side VC WVEL Data 2	[L-002A 168 002A15C BCD6]
  Ns FL Side VD WVEL Data 2	[L-002A 174 002A168 BCD6]
  Top FL Rear V WVEL Data 1	[L-002A 180 002A174 BCD6]
  Top FL Rear V WVEL Data 2	[L-002A 186 002A180 BCD6]
  Top FL Side VA WVEL Data 1	[L-002A 192 002A18C BCD6]
  Top FL Side VA WVEL Data 2	[L-002A 198 002A198 BCD6]
  Top FL Side VB WVEL Data 1	[L-002A 204 002A1A4 BCD6]
  Top FL Side VB WVEL Data 2	[L-002A 210 002A1B0 BCD6]
  Top FL Side VC WVEL Data 1	[L-002A 216 002A1BC BCD6]
  Top FL Side VC WVEL Data 2	[L-002A 222 002A1C8 BCD6]
  Top FL Side VD WVEL Data 1	[L-002A 228 002A1D4 BCD6]
  Top FL Side VD WVEL Data 2	[L-002A 234 002A1E0 BCD6]
  Wind Converter Data 1	[L-002A 240 002A1EC BCD6]
  Wind Converter Data 2	[L-002A 246 002A1F8 BCD6]
  Wind Converter Data 3	[L-002A 252 002A204 BCD6]
  Wind Converter Data 4	[L-002A 258 002A210 BCD6]
  Wind Converter Data 5	[L-002A 264 002A21C BCD6]
  Wind Converter Data 6	[L-002A 270 002A228 BCD6]
  Cs FL Side VA Temp Data	[L-002A 276 002A234 BCD6]
  Cs FL Side VB Temp Data	[L-002A 282 002A240 BCD6]
  Cs FL Side VC Temp Data	[L-002A 288 002A24C BCD6]
  Cs FL Side VD Temp Data	[L-002A 294 002A258 BCD6]
  Ns FL Side VA Temp Data	[L-002A 300 002A264 BCD6]
  Ns FL Side VB Temp Data	[L-002A 306 002A270 BCD6]
  Ns FL Side VC Temp Data	[L-002A 312 002A27C BCD6]
  Ns FL Side VD Temp Data	[L-002A 318 002A288 BCD6]
  TEFL Side VB Temp Data	[L-002A 324 002A294 BCD6]
  TEFL Side VD Temp Data	[L-002A 330 002A2A0 BCD6]
  Top FL Side VA Temp Data	[L-002A 336 002A2AC BCD6]
  Top FL Side VB Temp Data	[L-002A 342 002A2B8 BCD6]
  Top FL Side VC Temp Data	[L-002A 348 002A2C4 BCD6]
  Top FL Side VD Temp Data	[L-002A 354 002A2D0 BCD6]
  Front V Temp(Air) Data	[L-002A 360 002A2DC BCD6]
  Cs Rear V Temp(Air) Data	[L-002A 366 002A2E8 BCD6]
  Cs Side VA Temp(Air) Data	[L-002A 372 002A2F4 BCD6]
  Cs Side VB Temp(Air) Data	[L-002A 378 002A300 BCD6]
  Cs Side VC Temp(Air) Data	[L-002A 384 002A30C BCD6]
  Side VD Temp(Air) Data	[L-002A 390 002A318 BCD6]
  Ns FL Rear V Temp(Air) Data	[L-002A 396 002A324 BCD6]
  Ns FL Side VA Temp(Air) Data	[L-002A 402 002A330 BCD6]
  Ns FL Side VB Temp(Air) Data	[L-002A 408 002A33C BCD6]
  Ns FL Side VC Temp(Air) Data	[L-002A 414 002A348 BCD6]
  Ns FL Side VD Temp(Air) Data	[L-002A 420 002A354 BCD6]
  TEFL TSCRN(R) Temp(Air) Data	[L-002A 426 002A360 BCD6]
  TEFL Side VB Temp(Air) Data	[L-002A 432 002A36C BCD6]
  TEFL Side VC Temp(Air) Data	[L-002A 438 002A378 BCD6]
  Top FL Rear V Temp(Air) Data	[L-002A 444 002A384 BCD6]
  Top FL Side VA Temp(Air) Data	[L-002A 450 002A390 BCD6]
  Top FL Side VB Temp(Air) Data	[L-002A 456 002A39C BCD6]
  Top FL Side VC Temp(Air) Data	[L-002A 462 002A3A8 BCD6]
  Top FL Side VD Temp(Air) Data	[L-002A 468 002A3B4 BCD6]
  Top Unit EXCH Temp(Air) Data	[L-002A 474 002A3C0 BCD6]
  Front V CT2 Alarm Data	[E-002B 0:0 002B001]
  Front V CT2 Normal Data	[E-002B 0:1 002B002]
  Front V CT2 VAR Data	[E-002B 0:2 002B003]
  Front V CT2 Over Range	[E-002B 0:3 002B004]
  Front V CT2 Skip	[E-002B 0:4 002B005]
  Front V CT2 Up LIM	[E-002B 1:0 002B006]
  Front V CT2 DN LIM	[E-002B 1:1 002B007]
  Front V CT2 VAR Up LIM	[E-002B 1:2 002B008]
  Front V CT2 VAR DN LIM	[E-002B 1:3 002B009]
  Front V CT2 RT Up	[E-002B 1:4 002B00A]
  Front V CT2 RT DN	[E-002B 1:5 002B00B]
  Cs FL Side V A CT2 Alarm Data 1	[E-002B 2:0 002B00D]
  Cs FL Side V A CT2 Normal Data 1	[E-002B 2:1 002B00E]
  Cs FL Side V A CT2 VAR Data 1	[E-002B 2:2 002B00F]
  Cs FL Side V A CT2 Over Range 1	[E-002B 2:3 002B010]
  Cs FL Side V A CT2 Skip 1	[E-002B 2:4 002B011]
  Cs FL Side V A CT2 Up LIM 1	[E-002B 3:0 002B012]
  Cs FL Side V A CT2 DN LIM 1	[E-002B 3:1 002B013]
  Cs FL Side V A CT2 VAR Up LIM 1	[E-002B 3:2 002B014]
  Cs FL Side V A CT2 VAR DN LIM 1	[E-002B 3:3 002B015]
  Cs FL Side V A CT2 RT Up 1	[E-002B 3:4 002B016]
  Cs FL Side V A CT2 RT DN 1	[E-002B 3:5 002B017]
  Cs FL Side V B CT2 Alarm Data 1	[E-002B 4:0 002B019]
  Cs FL Side V B CT2 Normal Data 1	[E-002B 4:1 002B01A]
  Cs FL Side V B CT2 VAR Data 1	[E-002B 4:2 002B01B]
  Cs FL Side V B CT2 Over Range 1	[E-002B 4:3 002B01C]
  Cs FL Side V B CT2 Skip 1	[E-002B 4:4 002B01D]
  Cs FL Side V B CT2 Up LIM 1	[E-002B 5:0 002B01E]
  Cs FL Side V B CT2 DN LIM 1	[E-002B 5:1 002B01F]
  Cs FL Side V B CT2 VAR Up LIM 1	[E-002B 5:2 002B020]
  Cs FL Side V B CT2 VAR DN LIM 1	[E-002B 5:3 002B021]
  Cs FL Side V B CT2 RT Up 1	[E-002B 5:4 002B022]
  Cs FL Side V B CT2 RT DN 1	[E-002B 5:5 002B023]
  Cs FL Front V CT2 Alarm Data	[E-002B 6:0 002B025]
  Cs FL Front V CT2 Normal Data	[E-002B 6:1 002B026]
  Cs FL Front V CT2 VAR Data	[E-002B 6:2 002B027]
  Cs FL Front V CT2 Over Range	[E-002B 6:3 002B028]
  Cs FL Front V CT2 Skip	[E-002B 6:4 002B029]
  Cs FL Front V CT2 Up LIM	[E-002B 7:0 002B02A]
  Cs FL Front V CT2 DN LIM	[E-002B 7:1 002B02B]
  Cs FL Front V CT2 VAR Up LIM	[E-002B 7:2 002B02C]
  Cs FL Front V CT2 VAR DN LIM	[E-002B 7:3 002B02D]
  Cs FL Front V CT2 RT Up	[E-002B 7:4 002B02E]
  Cs FL Front V CT2 RT DN	[E-002B 7:5 002B02F]
  Cs FL Side V A CT2 Alarm Data 2	[E-002B 8:0 002B031]
  Cs FL Side V A CT2 Normal Data 2	[E-002B 8:1 002B032]
  Cs FL Side V A CT2 VAR Data 2	[E-002B 8:2 002B033]
  Cs FL Side V A CT2 Over Range 2	[E-002B 8:3 002B034]
  Cs FL Side V A CT2 Skip 2	[E-002B 8:4 002B035]
  Cs FL Side V A CT2 Up LIM 2	[E-002B 9:0 002B036]
  Cs FL Side V A CT2 DN LIM 2	[E-002B 9:1 002B037]
  Cs FL Side V A CT2 VAR Up LIM 2	[E-002B 9:2 002B038]
  Cs FL Side V A CT2 VAR DN LIM 2	[E-002B 9:3 002B039]
  Cs FL Side V A CT2 RT Up 2	[E-002B 9:4 002B03A]
  Cs FL Side V A CT2 RT DN 2	[E-002B 9:5 002B03B]
  Cs FL Side V B CT2 Alarm Data 2	[E-002B 10:0 002B03D]
  Cs FL Side V B CT2 Normal Data 2	[E-002B 10:1 002B03E]
  Cs FL Side V B CT2 VAR Data 2	[E-002B 10:2 002B03F]
  Cs FL Side V B CT2 Over Range 2	[E-002B 10:3 002B040]
  Cs FL Side V B CT2 Skip 2	[E-002B 10:4 002B041]
  Cs FL Side V B CT2 Up LIM 2	[E-002B 11:0 002B042]
  Cs FL Side V B CT2 DN LIM 2	[E-002B 11:1 002B043]
  Cs FL Side V B CT2 VAR Up LIM 2	[E-002B 11:2 002B044]
  Cs FL Side V B CT2 VAR DN LIM 2	[E-002B 11:3 002B045]
  Cs FL Side V B CT2 RT Up 2	[E-002B 11:4 002B046]
  Cs FL Side V B CT2 RT DN 2	[E-002B 11:5 002B047]
  Cs FL Side V C CT2 Alarm Data 1	[E-002B 12:0 002B049]
  Cs FL Side V C CT2 Normal Data 1	[E-002B 12:1 002B04A]
  Cs FL Side V C CT2 VAR Data 1	[E-002B 12:2 002B04B]
  Cs FL Side V C CT2 Over Range 1	[E-002B 12:3 002B04C]
  Cs FL Side V C CT2 Skip 1	[E-002B 12:4 002B04D]
  Cs FL Side V C CT2 Up LIM 1	[E-002B 13:0 002B04E]
  Cs FL Side V C CT2 DN LIM 1	[E-002B 13:1 002B04F]
  Cs FL Side V C CT2 VAR Up LIM 1	[E-002B 13:2 002B050]
  Cs FL Side V C CT2 VAR DN LIM 1	[E-002B 13:3 002B051]
  Cs FL Side V C CT2 RT Up 1	[E-002B 13:4 002B052]
  Cs FL Side V C CT2 RT DN 1	[E-002B 13:5 002B053]
  Cs FL Side V D CT2 Alarm Data 1	[E-002B 14:0 002B055]
  Cs FL Side V D CT2 Normal Data 1	[E-002B 14:1 002B056]
  Cs FL Side V D CT2 VAR Data 1	[E-002B 14:2 002B057]
  Cs FL Side V D CT2 Over Range 1	[E-002B 14:3 002B058]
  Cs FL Side V D CT2 Skip 1	[E-002B 14:4 002B059]
  Cs FL Side V D CT2 Up LIM 1	[E-002B 15:0 002B05A]
  Cs FL Side V D CT2 DN LIM 1	[E-002B 15:1 002B05B]
  Cs FL Side V D CT2 VAR Up LIM 1	[E-002B 15:2 002B05C]
  Cs FL Side V D CT2 VAR DN LIM 1	[E-002B 15:3 002B05D]
  Cs FL Side V D CT2 RT Up 1	[E-002B 15:4 002B05E]
  Cs FL Side V D CT2 RT DN 1	[E-002B 15:5 002B05F]
  Ns FL Side V A CT2 Alarm Data	[E-002B 16:0 002B061]
  Ns FL Side V A CT2 Normal Data	[E-002B 16:1 002B062]
  Ns FL Side V A CT2 VAR Data	[E-002B 16:2 002B063]
  Ns FL Side V A CT2 Over Range	[E-002B 16:3 002B064]
  Ns FL Side V A CT2 Skip	[E-002B 16:4 002B065]
  Ns FL Side V A CT2 Up LIM	[E-002B 17:0 002B066]
  Ns FL Side V A CT2 DN LIM	[E-002B 17:1 002B067]
  Ns FL Side V A CT2 VAR Up LIM	[E-002B 17:2 002B068]
  Ns FL Side V A CT2 VAR DN LIM	[E-002B 17:3 002B069]
  Ns FL Side V A CT2 RT Up	[E-002B 17:4 002B06A]
  Ns FL Side V A CT2 RT DN	[E-002B 17:5 002B06B]
  Cs FL Side V C CT2 Alarm Data 2	[E-002B 18:0 002B06D]
  Cs FL Side V C CT2 Normal Data 2	[E-002B 18:1 002B06E]
  Cs FL Side V C CT2 VAR Data 2	[E-002B 18:2 002B06F]
  Cs FL Side V C CT2 Over Range 2	[E-002B 18:3 002B070]
  Cs FL Side V C CT2 Skip 2	[E-002B 18:4 002B071]
  Cs FL Side V C CT2 Up LIM 2	[E-002B 19:0 002B072]
  Cs FL Side V C CT2 DN LIM 2	[E-002B 19:1 002B073]
  Cs FL Side V C CT2 VAR Up LIM 2	[E-002B 19:2 002B074]
  Cs FL Side V C CT2 VAR DN LIM 2	[E-002B 19:3 002B075]
  Cs FL Side V C CT2 RT Up 2	[E-002B 19:4 002B076]
  Cs FL Side V C CT2 RT DN 2	[E-002B 19:5 002B077]
  Cs FL Side V D CT2 Alarm Data 2	[E-002B 20:0 002B079]
  Cs FL Side V D CT2 Normal Data 2	[E-002B 20:1 002B07A]
  Cs FL Side V D CT2 VAR Data 2	[E-002B 20:2 002B07B]
  Cs FL Side V D CT2 Over Range 2	[E-002B 20:3 002B07C]
  Cs FL Side V D CT2 Skip 2	[E-002B 20:4 002B07D]
  Cs FL Side V D CT2 Up LIM 2	[E-002B 21:0 002B07E]
  Cs FL Side V D CT2 DN LIM 2	[E-002B 21:1 002B07F]
  Cs FL Side V D CT2 VAR Up LIM 2	[E-002B 21:2 002B080]
  Cs FL Side V D CT2 VAR DN LIM 2	[E-002B 21:3 002B081]
  Cs FL Side V D CT2 RT Up 2	[E-002B 21:4 002B082]
  Cs FL Side V D CT2 RT DN 2	[E-002B 21:5 002B083]
  Ns FL Side V A CT2 Alarm Data 1	[E-002B 22:0 002B085]
  Ns FL Side V A CT2 Normal Data 1	[E-002B 22:1 002B086]
  Ns FL Side V A CT2 VAR Data 1	[E-002B 22:2 002B087]
  Ns FL Side V A CT2 Over Range 1	[E-002B 22:3 002B088]
  Ns FL Side V A CT2 Skip 1	[E-002B 22:4 002B089]
  Ns FL Side V A CT2 Up LIM 1	[E-002B 23:0 002B08A]
  Ns FL Side V A CT2 DN LIM 1	[E-002B 23:1 002B08B]
  Ns FL Side V A CT2 VAR Up LIM 1	[E-002B 23:2 002B08C]
  Ns FL Side V A CT2 VAR DN LIM 1	[E-002B 23:3 002B08D]
  Ns FL Side V A CT2 RT Up 1	[E-002B 23:4 002B08E]
  Ns FL Side V A CT2 RT DN 1	[E-002B 23:5 002B08F]
  Ns FL Side V B CT2 Alarm Data 1	[E-002B 24:0 002B091]
  Ns FL Side V B CT2 Normal Data 1	[E-002B 24:1 002B092]
  Ns FL Side V B CT2 VAR Data 1	[E-002B 24:2 002B093]
  Ns FL Side V B CT2 Over Range 1	[E-002B 24:3 002B094]
  Ns FL Side V B CT2 Skip 1	[E-002B 24:4 002B095]
  Ns FL Side V B CT2 Up LIM 1	[E-002B 25:0 002B096]
  Ns FL Side V B CT2 DN LIM 1	[E-002B 25:1 002B097]
  Ns FL Side V B CT2 VAR Up LIM 1	[E-002B 25:2 002B098]
  Ns FL Side V B CT2 VAR DN LIM 1	[E-002B 25:3 002B099]
  Ns FL Side V B CT2 RT Up 1	[E-002B 25:4 002B09A]
  Ns FL Side V B CT2 RT DN 1	[E-002B 25:5 002B09B]
  Ns FL Side V C CT2 Alarm Data 1	[E-002B 26:0 002B09D]
  Ns FL Side V C CT2 Normal Data 1	[E-002B 26:1 002B09E]
  Ns FL Side V C CT2 VAR Data 1	[E-002B 26:2 002B09F]
  Ns FL Side V C CT2 Over Range 1	[E-002B 26:3 002B0A0]
  Ns FL Side V C CT2 Skip 1	[E-002B 26:4 002B0A1]
  Ns FL Side V C CT2 Up LIM 1	[E-002B 27:0 002B0A2]
  Ns FL Side V C CT2 DN LIM 1	[E-002B 27:1 002B0A3]
  Ns FL Side V C CT2 VAR Up LIM 1	[E-002B 27:2 002B0A4]
  Ns FL Side V C CT2 VAR DN LIM 1	[E-002B 27:3 002B0A5]
  Ns FL Side V C CT2 RT Up 1	[E-002B 27:4 002B0A6]
  Ns FL Side V C CT2 RT DN 1	[E-002B 27:5 002B0A7]
  Ns FL Side V D CT2 Alarm Data 1	[E-002B 28:0 002B0A9]
  Ns FL Side V D CT2 Normal Data 1	[E-002B 28:1 002B0AA]
  Ns FL Side V D CT2 VAR Data 1	[E-002B 28:2 002B0AB]
  Ns FL Side V D CT2 Over Range 1	[E-002B 28:3 002B0AC]
  Ns FL Side V D CT2 Skip 1	[E-002B 28:4 002B0AD]
  Ns FL Side V D CT2 Up LIM 1	[E-002B 29:0 002B0AE]
  Ns FL Side V D CT2 DN LIM 1	[E-002B 29:1 002B0AF]
  Ns FL Side V D CT2 VAR Up LIM 1	[E-002B 29:2 002B0B0]
  Ns FL Side V D CT2 VAR DN LIM 1	[E-002B 29:3 002B0B1]
  Ns FL Side V D CT2 RT Up 1	[E-002B 29:4 002B0B2]
  Ns FL Side V D CT2 RT DN 1	[E-002B 29:5 002B0B3]
  Ns FL Side V B CT2 Alarm Data 2	[E-002B 30:0 002B0B5]
  Ns FL Side V B CT2 Normal Data 2	[E-002B 30:1 002B0B6]
  Ns FL Side V B CT2 VAR Data 2	[E-002B 30:2 002B0B7]
  Ns FL Side V B CT2 Over Range 2	[E-002B 30:3 002B0B8]
  Ns FL Side V B CT2 Skip 2	[E-002B 30:4 002B0B9]
  Ns FL Side V B CT2 Up LIM 2	[E-002B 31:0 002B0BA]
  Ns FL Side V B CT2 DN LIM 2	[E-002B 31:1 002B0BB]
  Ns FL Side V B CT2 VAR Up LIM 2	[E-002B 31:2 002B0BC]
  Ns FL Side V B CT2 VAR DN LIM 2	[E-002B 31:3 002B0BD]
  Ns FL Side V B CT2 RT Up 2	[E-002B 31:4 002B0BE]
  Ns FL Side V B CT2 RT DN 2	[E-002B 31:5 002B0BF]
  Ns FL Side V C CT2 Alarm Data 2	[E-002B 32:0 002B0C1]
  Ns FL Side V C CT2 Normal Data 2	[E-002B 32:1 002B0C2]
  Ns FL Side V C CT2 VAR Data 2	[E-002B 32:2 002B0C3]
  Ns FL Side V C CT2 Over Range 2	[E-002B 32:3 002B0C4]
  Ns FL Side V C CT2 Skip 2	[E-002B 32:4 002B0C5]
  Ns FL Side V C CT2 Up LIM 2	[E-002B 33:0 002B0C6]
  Ns FL Side V C CT2 DN LIM 2	[E-002B 33:1 002B0C7]
  Ns FL Side V C CT2 VAR Up LIM 2	[E-002B 33:2 002B0C8]
  Ns FL Side V C CT2 VAR DN LIM 2	[E-002B 33:3 002B0C9]
  Ns FL Side V C CT2 RT Up 2	[E-002B 33:4 002B0CA]
  Ns FL Side V C CT2 RT DN 2	[E-002B 33:5 002B0CB]
  Ns FL Side V D CT2 Alarm Data 2	[E-002B 34:0 002B0CD]
  Ns FL Side V D CT2 Normal Data 2	[E-002B 34:1 002B0CE]
  Ns FL Side V D CT2 VAR Data 2	[E-002B 34:2 002B0CF]
  Ns FL Side V D CT2 Over Range 2	[E-002B 34:3 002B0D0]
  Ns FL Side V D CT2 Skip 2	[E-002B 34:4 002B0D1]
  Ns FL Side V D CT2 Up LIM 2	[E-002B 35:0 002B0D2]
  Ns FL Side V D CT2 DN LIM 2	[E-002B 35:1 002B0D3]
  Ns FL Side V D CT2 VAR Up LIM 2	[E-002B 35:2 002B0D4]
  Ns FL Side V D CT2 VAR DN LIM 2	[E-002B 35:3 002B0D5]
  Ns FL Side V D CT2 RT Up 2	[E-002B 35:4 002B0D6]
  Ns FL Side V D CT2 RT DN 2	[E-002B 35:5 002B0D7]
  TERT FL Side V B CT2 Alarm Data 1	[E-002B 36:0 002B0D9]
  TERT FL Side V B CT2 Normal Data 1	[E-002B 36:1 002B0DA]
  TERT FL Side V B CT2 VAR Data 1	[E-002B 36:2 002B0DB]
  TERT FL Side V B CT2 Over Range 1	[E-002B 36:3 002B0DC]
  TERT FL Side V B CT2 Skip 1	[E-002B 36:4 002B0DD]
  TERT FL Side V B CT2 Up LIM 1	[E-002B 37:0 002B0DE]
  TERT FL Side V B CT2 DN LIM 1	[E-002B 37:1 002B0DF]
  TERT FL Side V B CT2 VAR Up LIM 1	[E-002B 37:2 002B0E0]
  TERT FL Side V B CT2 VAR DN LIM 1	[E-002B 37:3 002B0E1]
  TERT FL Side V B CT2 RT Up 1	[E-002B 37:4 002B0E2]
  TERT FL Side V B CT2 RT DN 1	[E-002B 37:5 002B0E3]
  TERT FL Side V C CT2 Alarm Data 1	[E-002B 38:0 002B0E5]
  TERT FL Side V C CT2 Normal Data 1	[E-002B 38:1 002B0E6]
  TERT FL Side V C CT2 VAR Data 1	[E-002B 38:2 002B0E7]
  TERT FL Side V C CT2 Over Range 1	[E-002B 38:3 002B0E8]
  TERT FL Side V C CT2 Skip 1	[E-002B 38:4 002B0E9]
  TERT FL Side V C CT2 Up LIM 1	[E-002B 39:0 002B0EA]
  TERT FL Side V C CT2 DN LIM 1	[E-002B 39:1 002B0EB]
  TERT FL Side V C CT2 VAR Up LIM 1	[E-002B 39:2 002B0EC]
  TERT FL Side V C CT2 VAR DN LIM 1	[E-002B 39:3 002B0ED]
  TERT FL Side V C CT2 RT Up 1	[E-002B 39:4 002B0EE]
  TERT FL Side V C CT2 RT DN 1	[E-002B 39:5 002B0EF]
  TERT FL Side V A CT2 Alarm Data 2	[E-002B 40:0 002B0F1]
  TERT FL Side V A CT2 Normal Data 2	[E-002B 40:1 002B0F2]
  TERT FL Side V A CT2 VAR Data 2	[E-002B 40:2 002B0F3]
  TERT FL Side V A CT2 Over Range 2	[E-002B 40:3 002B0F4]
  TERT FL Side V A CT2 Skip 2	[E-002B 40:4 002B0F5]
  TERT FL Side V A CT2 Up LIM 2	[E-002B 41:0 002B0F6]
  TERT FL Side V A CT2 DN LIM 2	[E-002B 41:1 002B0F7]
  TERT FL Side V A CT2 VAR Up LIM 2	[E-002B 41:2 002B0F8]
  TERT FL Side V A CT2 VAR DN LIM 2	[E-002B 41:3 002B0F9]
  TERT FL Side V A CT2 RT Up 2	[E-002B 41:4 002B0FA]
  TERT FL Side V A CT2 RT DN 2	[E-002B 41:5 002B0FB]
  TERT FL Side V B CT2 Alarm Data 2	[E-002B 42:0 002B0FD]
  TERT FL Side V B CT2 Normal Data 2	[E-002B 42:1 002B0FE]
  TERT FL Side V B CT2 VAR Data 2	[E-002B 42:2 002B0FF]
  TERT FL Side V B CT2 Over Range 2	[E-002B 42:3 002B100]
  TERT FL Side V B CT2 Skip 2	[E-002B 42:4 002B101]
  TERT FL Side V B CT2 Up LIM 2	[E-002B 43:0 002B102]
  TERT FL Side V B CT2 DN LIM 2	[E-002B 43:1 002B103]
  TERT FL Side V B CT2 VAR Up LIM 2	[E-002B 43:2 002B104]
  TERT FL Side V B CT2 VAR DN LIM 2	[E-002B 43:3 002B105]
  TERT FL Side V B CT2 RT Up 2	[E-002B 43:4 002B106]
  TERT FL Side V B CT2 RT DN 2	[E-002B 43:5 002B107]
  TERT FL Side V C CT2 Alarm Data 2	[E-002B 44:0 002B109]
  TERT FL Side V C CT2 Normal Data 2	[E-002B 44:1 002B10A]
  TERT FL Side V C CT2 VAR Data 2	[E-002B 44:2 002B10B]
  TERT FL Side V C CT2 Over Range 2	[E-002B 44:3 002B10C]
  TERT FL Side V C CT2 Skip 2	[E-002B 44:4 002B10D]
  TERT FL Side V C CT2 Up LIM 2	[E-002B 45:0 002B10E]
  TERT FL Side V C CT2 DN LIM 2	[E-002B 45:1 002B10F]
  TERT FL Side V C CT2 VAR Up LIM 2	[E-002B 45:2 002B110]
  TERT FL Side V C CT2 VAR DN LIM 2	[E-002B 45:3 002B111]
  TERT FL Side V C CT2 RT Up 2	[E-002B 45:4 002B112]
  TERT FL Side V C CT2 RT DN 2	[E-002B 45:5 002B113]
  TERT FL Side V D CT2 Alarm Data 2	[E-002B 46:0 002B115]
  TERT FL Side V D CT2 Normal Data 2	[E-002B 46:1 002B116]
  TERT FL Side V D CT2 VAR Data 2	[E-002B 46:2 002B117]
  TERT FL Side V D CT2 Over Range 2	[E-002B 46:3 002B118]
  TERT FL Side V D CT2 Skip 2	[E-002B 46:4 002B119]
  TERT FL Side V D CT2 Up LIM 2	[E-002B 47:0 002B11A]
  TERT FL Side V D CT2 DN LIM 2	[E-002B 47:1 002B11B]
  TERT FL Side V D CT2 VAR Up LIM 2	[E-002B 47:2 002B11C]
  TERT FL Side V D CT2 VAR DN LIM 2	[E-002B 47:3 002B11D]
  TERT FL Side V D CT2 RT Up 2	[E-002B 47:4 002B11E]
  TERT FL Side V D CT2 RT DN 2	[E-002B 47:5 002B11F]
  Top FL Side V A CT2 Alarm Data 1	[E-002B 48:0 002B121]
  Top FL Side V A CT2 Normal Data 1	[E-002B 48:1 002B122]
  Top FL Side V A CT2 VAR Data 1	[E-002B 48:2 002B123]
  Top FL Side V A CT2 Over Range 1	[E-002B 48:3 002B124]
  Top FL Side V A CT2 Skip 1	[E-002B 48:4 002B125]
  Top FL Side V A CT2 Up LIM 1	[E-002B 49:0 002B126]
  Top FL Side V A CT2 DN LIM 1	[E-002B 49:1 002B127]
  Top FL Side V A CT2 VAR Up LIM 1	[E-002B 49:2 002B128]
  Top FL Side V A CT2 VAR DN LIM 1	[E-002B 49:3 002B129]
  Top FL Side V A CT2 RT Up 1	[E-002B 49:4 002B12A]
  Top FL Side V A CT2 RT DN 1	[E-002B 49:5 002B12B]
  Top FL Side V B CT2 Alarm Data 1	[E-002B 50:0 002B12D]
  Top FL Side V B CT2 Normal Data 1	[E-002B 50:1 002B12E]
  Top FL Side V B CT2 VAR Data 1	[E-002B 50:2 002B12F]
  Top FL Side V B CT2 Over Range 1	[E-002B 50:3 002B130]
  Top FL Side V B CT2 Skip 1	[E-002B 50:4 002B131]
  Top FL Side V B CT2 Up LIM 1	[E-002B 51:0 002B132]
  Top FL Side V B CT2 DN LIM 1	[E-002B 51:1 002B133]
  Top FL Side V B CT2 VAR Up LIM 1	[E-002B 51:2 002B134]
  Top FL Side V B CT2 VAR DN LIM 1	[E-002B 51:3 002B135]
  Top FL Side V B CT2 RT Up 1	[E-002B 51:4 002B136]
  Top FL Side V B CT2 RT DN 1	[E-002B 51:5 002B137]
  Top FL Side V A CT2 Alarm Data 2	[E-002B 52:0 002B139]
  Top FL Side V A CT2 Normal Data 2	[E-002B 52:1 002B13A]
  Top FL Side V A CT2 VAR Data 2	[E-002B 52:2 002B13B]
  Top FL Side V A CT2 Over Range 2	[E-002B 52:3 002B13C]
  Top FL Side V A CT2 Skip 2	[E-002B 52:4 002B13D]
  Top FL Side V A CT2 Up LIM 2	[E-002B 53:0 002B13E]
  Top FL Side V A CT2 DN LIM 2	[E-002B 53:1 002B13F]
  Top FL Side V A CT2 VAR Up LIM 2	[E-002B 53:2 002B140]
  Top FL Side V A CT2 VAR DN LIM 2	[E-002B 53:3 002B141]
  Top FL Side V A CT2 RT Up 2	[E-002B 53:4 002B142]
  Top FL Side V A CT2 RT DN 2	[E-002B 53:5 002B143]
  Top FL Side V B CT2 Alarm Data 2	[E-002B 54:0 002B145]
  Top FL Side V B CT2 Normal Data 2	[E-002B 54:1 002B146]
  Top FL Side V B CT2 VAR Data 2	[E-002B 54:2 002B147]
  Top FL Side V B CT2 Over Range 2	[E-002B 54:3 002B148]
  Top FL Side V B CT2 Skip 2	[E-002B 54:4 002B149]
  Top FL Side V B CT2 Up LIM 2	[E-002B 55:0 002B14A]
  Top FL Side V B CT2 DN LIM 2	[E-002B 55:1 002B14B]
  Top FL Side V B CT2 VAR Up LIM 2	[E-002B 55:2 002B14C]
  Top FL Side V B CT2 VAR DN LIM 2	[E-002B 55:3 002B14D]
  Top FL Side V B CT2 RT Up 2	[E-002B 55:4 002B14E]
  Top FL Side V B CT2 RT DN 2	[E-002B 55:5 002B14F]
  Top FL Side V C CT2 Alarm Data 1	[E-002B 56:0 002B151]
  Top FL Side V C CT2 Normal Data 1	[E-002B 56:1 002B152]
  Top FL Side V C CT2 VAR Data 1	[E-002B 56:2 002B153]
  Top FL Side V C CT2 Over Range 1	[E-002B 56:3 002B154]
  Top FL Side V C CT2 Skip 1	[E-002B 56:4 002B155]
  Top FL Side V C CT2 Up LIM 1	[E-002B 57:0 002B156]
  Top FL Side V C CT2 DN LIM 1	[E-002B 57:1 002B157]
  Top FL Side V C CT2 VAR Up LIM 1	[E-002B 57:2 002B158]
  Top FL Side V C CT2 VAR DN LIM 1	[E-002B 57:3 002B159]
  Top FL Side V C CT2 RT Up 1	[E-002B 57:4 002B15A]
  Top FL Side V C CT2 RT DN 1	[E-002B 57:5 002B15B]
  Top FL Side V D CT2 Alarm Data 1	[E-002B 58:0 002B15D]
  Top FL Side V D CT2 Normal Data 1	[E-002B 58:1 002B15E]
  Top FL Side V D CT2 VAR Data 1	[E-002B 58:2 002B15F]
  Top FL Side V D CT2 Over Range 1	[E-002B 58:3 002B160]
  Top FL Side V D CT2 Skip 1	[E-002B 58:4 002B161]
  Top FL Side V D CT2 Up LIM 1	[E-002B 59:0 002B162]
  Top FL Side V D CT2 DN LIM 1	[E-002B 59:1 002B163]
  Top FL Side V D CT2 VAR Up LIM 1	[E-002B 59:2 002B164]
  Top FL Side V D CT2 VAR DN LIM 1	[E-002B 59:3 002B165]
  Top FL Side V D CT2 RT Up 1	[E-002B 59:4 002B166]
  Top FL Side V D CT2 RT DN 1	[E-002B 59:5 002B167]
  Top FL Side V C CT2 Alarm Data 2	[E-002B 60:0 002B169]
  Top FL Side V C CT2 Normal Data 2	[E-002B 60:1 002B16A]
  Top FL Side V C CT2 VAR Data 2	[E-002B 60:2 002B16B]
  Top FL Side V C CT2 Over Range 2	[E-002B 60:3 002B16C]
  Top FL Side V C CT2 Skip 2	[E-002B 60:4 002B16D]
  Top FL Side V C CT2 Up LIM 2	[E-002B 61:0 002B16E]
  Top FL Side V C CT2 DN LIM 2	[E-002B 61:1 002B16F]
  Top FL Side V C CT2 VAR Up LIM 2	[E-002B 61:2 002B170]
  Top FL Side V C CT2 VAR DN LIM 2	[E-002B 61:3 002B171]
  Top FL Side V C CT2 RT Up 2	[E-002B 61:4 002B172]
  Top FL Side V C CT2 RT DN 2	[E-002B 61:5 002B173]
  Top FL Side V D CT2 Alarm Data 2	[E-002B 62:0 002B175]
  Top FL Side V D CT2 Normal Data 2	[E-002B 62:1 002B176]
  Top FL Side V D CT2 VAR Data 2	[E-002B 62:2 002B177]
  Top FL Side V D CT2 Over Range 2	[E-002B 62:3 002B178]
  Top FL Side V D CT2 Skip 2	[E-002B 62:4 002B179]
  Top FL Side V D CT2 Up LIM 2	[E-002B 63:0 002B17A]
  Top FL Side V D CT2 DN LIM 2	[E-002B 63:1 002B17B]
  Top FL Side V D CT2 VAR Up LIM 2	[E-002B 63:2 002B17C]
  Top FL Side V D CT2 VAR DN LIM 2	[E-002B 63:3 002B17D]
  Top FL Side V D CT2 RT Up 2	[E-002B 63:4 002B17E]
  Top FL Side V D CT2 RT DN 2	[E-002B 63:5 002B17F]
  Front V CT2 Data	[L-002B 0 002B00C BCD6]
  Cs FL Side V A CT2 Data 1	[L-002B 6 002B018 BCD6]
  Cs FL Side V B CT2 Data 1	[L-002B 12 002B024 BCD6]
  Cs FL Front V CT2 Data	[L-002B 18 002B030 BCD6]
  Cs FL Side V A CT2 Data 2	[L-002B 24 002B03C BCD6]
  Cs FL Side V B CT2 Data 2	[L-002B 30 002B048 BCD6]
  Cs FL Side V C CT2 Data 1	[L-002B 36 002B054 BCD6]
  Cs FL Side V D CT2 Data 1	[L-002B 42 002B060 BCD6]
  Ns FL Side V A CT2 Data	[L-002B 48 002B06C BCD6]
  Cs FL Side V C CT2 Data 2	[L-002B 54 002B078 BCD6]
  Cs FL Side V D CT2 Data 2	[L-002B 60 002B084 BCD6]
  Ns FL Side V A CT2 Data 1	[L-002B 66 002B090 BCD6]
  Ns FL Side V B CT2 Data 1	[L-002B 72 002B09C BCD6]
  Ns FL Side V C CT2 Data 1	[L-002B 78 002B0A8 BCD6]
  Ns FL Side V D CT2 Data 1	[L-002B 84 002B0B4 BCD6]
  Ns FL Side V B CT2 Data 2	[L-002B 90 002B0C0 BCD6]
  Ns FL Side V C CT2 Data 2	[L-002B 96 002B0CC BCD6]
  Ns FL Side V D CT2 Data 2	[L-002B 102 002B0D8 BCD6]
  TERT FL Side V B CT2 Data 1	[L-002B 108 002B0E4 BCD6]
  TERT FL Side V C CT2 Data 1	[L-002B 114 002B0F0 BCD6]
  TERT FL Side V A CT2 Data 2	[L-002B 120 002B0FC BCD6]
  TERT FL Side V B CT2 Data 2	[L-002B 126 002B108 BCD6]
  TERT FL Side V C CT2 Data 2	[L-002B 132 002B114 BCD6]
  TERT FL Side V D CT2 Data 2	[L-002B 138 002B120 BCD6]
  Top FL Side V A CT2 Data 1	[L-002B 144 002B12C BCD6]
  Top FL Side V B CT2 Data 1	[L-002B 150 002B138 BCD6]
  Top FL Side V A CT2 Data 2	[L-002B 156 002B144 BCD6]
  Top FL Side V B CT2 Data 2	[L-002B 162 002B150 BCD6]
  Top FL Side V C CT2 Data 1	[L-002B 168 002B15C BCD6]
  Top FL Side V D CT2 Data 1	[L-002B 174 002B168 BCD6]
  Top FL Side V C CT2 Data 2	[L-002B 180 002B174 BCD6]
  Top FL Side V D CT2 Data 2	[L-002B 186 002B180 BCD6]
  Top Ring(R) Temp(Air) Alarm Data	[E-002C 0:0 002C001]
  Top Ring(R) Temp(Air) NORM Data	[E-002C 0:1 002C002]
  Top Ring(R) Temp(Air) VAR Data	[E-002C 0:2 002C003]
  Top Ring(R) Temp(Air) Over RNG	[E-002C 0:3 002C004]
  Top Ring(R) Temp(Air) Skip	[E-002C 0:4 002C005]
  Top Ring(R) Temp(Air) Up LIM	[E-002C 1:0 002C006]
  Top Ring(R) Temp(Air) DN LIM	[E-002C 1:1 002C007]
  Top Ring(R) Temp(Air) VAR Up LIM	[E-002C 1:2 002C008]
  Top Ring(R) Temp(Air) VAR DN LIM	[E-002C 1:3 002C009]
  Top Ring(R) Temp(Air) CHNG RT Up	[E-002C 1:4 002C00A]
  Top Ring(R) Temp(Air) CHNG RT DN	[E-002C 1:5 002C00B]
  Top Ring(F) Temp(Air) Alarm Data	[E-002C 2:0 002C00D]
  Top Ring(F) Temp(Air) NORM Data	[E-002C 2:1 002C00E]
  Top Ring(F) Temp(Air) VAR Data	[E-002C 2:2 002C00F]
  Top Ring(F) Temp(Air) Over RNG	[E-002C 2:3 002C010]
  Top Ring(F) Temp(Air) Skip	[E-002C 2:4 002C011]
  Top Ring(F) Temp(Air) Up LIM	[E-002C 3:0 002C012]
  Top Ring(F) Temp(Air) DN LIM	[E-002C 3:1 002C013]
  Top Ring(F) Temp(Air) VAR Up LIM	[E-002C 3:2 002C014]
  Top Ring(F) Temp(Air) VAR DN LIM	[E-002C 3:3 002C015]
  Top Ring(F) Temp(Air) CHNG RT Up	[E-002C 3:4 002C016]
  Top Ring(F) Temp(Air) CHNG RT DN	[E-002C 3:5 002C017]
  U TRS(R) Temp(Air) Alarm Data	[E-002C 4:0 002C019]
  U TRS(R) Temp(Air) NORM Data	[E-002C 4:1 002C01A]
  U TRS(R) Temp(Air) VAR Data	[E-002C 4:2 002C01B]
  U TRS(R) Temp(Air) Over RNG	[E-002C 4:3 002C01C]
  U TRS(R) Temp(Air) Skip	[E-002C 4:4 002C01D]
  U TRS(R) Temp(Air) Up LIM	[E-002C 5:0 002C01E]
  U TRS(R) Temp(Air) DN LIM	[E-002C 5:1 002C01F]
  U TRS(R) Temp(Air) VAR Up LIM	[E-002C 5:2 002C020]
  U TRS(R) Temp(Air) VAR DN LIM	[E-002C 5:3 002C021]
  U TRS(R) Temp(Air) CHNG RT Up	[E-002C 5:4 002C022]
  U TRS(R) Temp(Air) CHNG RT DN	[E-002C 5:5 002C023]
  U TRS(F) Temp(Air) Alarm Data	[E-002C 6:0 002C025]
  U TRS(F) Temp(Air) NORM Data	[E-002C 6:1 002C026]
  U TRS(F) Temp(Air) VAR Data	[E-002C 6:2 002C027]
  U TRS(F) Temp(Air) Over RNG	[E-002C 6:3 002C028]
  U TRS(F) Temp(Air) Skip	[E-002C 6:4 002C029]
  U TRS(F) Temp(Air) Up LIM	[E-002C 7:0 002C02A]
  U TRS(F) Temp(Air) DN LIM	[E-002C 7:1 002C02B]
  U TRS(F) Temp(Air) VAR Up LIM	[E-002C 7:2 002C02C]
  U TRS(F) Temp(Air) VAR DN LIM	[E-002C 7:3 002C02D]
  U TRS(F) Temp(Air) CHNG RT Up	[E-002C 7:4 002C02E]
  U TRS(F) Temp(Air) CHNG RT DN	[E-002C 7:5 002C02F]
  CSCT(R) Temp(Air) Alarm Data	[E-002C 8:0 002C031]
  CSCT(R) Temp(Air) NORM Data	[E-002C 8:1 002C032]
  CSCT(R) Temp(Air) VAR Data	[E-002C 8:2 002C033]
  CSCT(R) Temp(Air) Over RNG	[E-002C 8:3 002C034]
  CSCT(R) Temp(Air) Skip	[E-002C 8:4 002C035]
  CSCT(R) Temp(Air) Up LIM	[E-002C 9:0 002C036]
  CSCT(R) Temp(Air) DN LIM	[E-002C 9:1 002C037]
  CSCT(R) Temp(Air) VAR Up LIM	[E-002C 9:2 002C038]
  CSCT(R) Temp(Air) VAR DN LIM	[E-002C 9:3 002C039]
  CSCT(R) Temp(Air) CHNG RT Up	[E-002C 9:4 002C03A]
  CSCT(R) Temp(Air) CHNG RT DN	[E-002C 9:5 002C03B]
  CSCT(F) Temp(Air) Alarm Data	[E-002C 10:0 002C03D]
  CSCT(F) Temp(Air) NORM Data	[E-002C 10:1 002C03E]
  CSCT(F) Temp(Air) VAR Data	[E-002C 10:2 002C03F]
  CSCT(F) Temp(Air) Over RNG	[E-002C 10:3 002C040]
  CSCT(F) Temp(Air) Skip	[E-002C 10:4 002C041]
  CSCT(F) Temp(Air) Up LIM	[E-002C 11:0 002C042]
  CSCT(F) Temp(Air) DN LIM	[E-002C 11:1 002C043]
  CSCT(F) Temp(Air) VAR Up LIM	[E-002C 11:2 002C044]
  CSCT(F) Temp(Air) VAR DN LIM	[E-002C 11:3 002C045]
  CSCT(F) Temp(Air) CHNG RT Up	[E-002C 11:4 002C046]
  CSCT(F) Temp(Air) CHNG RT DN	[E-002C 11:5 002C047]
  AZBR Temp(Air) Alarm Data	[E-002C 12:0 002C049]
  AZBR Temp(Air) NORM Data	[E-002C 12:1 002C04A]
  AZBR Temp(Air) VAR Data	[E-002C 12:2 002C04B]
  AZBR Temp(Air) Over RNG	[E-002C 12:3 002C04C]
  AZBR Temp(Air) Skip	[E-002C 12:4 002C04D]
  AZBR Temp(Air) Up LIM	[E-002C 13:0 002C04E]
  AZBR Temp(Air) DN LIM	[E-002C 13:1 002C04F]
  AZBR Temp(Air) VAR Up LIM	[E-002C 13:2 002C050]
  AZBR Temp(Air) VAR DN LIM	[E-002C 13:3 002C051]
  AZBR Temp(Air) CHNG RT Up	[E-002C 13:4 002C052]
  AZBR Temp(Air) CHNG RT DN	[E-002C 13:5 002C053]
  NsOpt Temp(Air)1 Alarm Data	[E-002C 14:0 002C055]
  NsOpt Temp(Air)1 NORM Data	[E-002C 14:1 002C056]
  NsOpt Temp(Air)1 VAR Data	[E-002C 14:2 002C057]
  NsOpt Temp(Air)1 Over RNG	[E-002C 14:3 002C058]
  NsOpt Temp(Air)1 Skip	[E-002C 14:4 002C059]
  NsOpt Temp(Air)1 Up LIM	[E-002C 15:0 002C05A]
  NsOpt Temp(Air)1 DN LIM	[E-002C 15:1 002C05B]
  NsOpt Temp(Air)1 VAR Up LIM	[E-002C 15:2 002C05C]
  NsOpt Temp(Air)1 VAR DN LIM	[E-002C 15:3 002C05D]
  NsOpt Temp(Air)1 CHNG RT Up	[E-002C 15:4 002C05E]
  NsOpt Temp(Air)1 CHNG RT DN	[E-002C 15:5 002C05F]
  NsOpt Temp(Air)2 Alarm Data	[E-002C 16:0 002C061]
  NsOpt Temp(Air)2 NORM Data	[E-002C 16:1 002C062]
  NsOpt Temp(Air)2 VAR Data	[E-002C 16:2 002C063]
  NsOpt Temp(Air)2 Over RNG	[E-002C 16:3 002C064]
  NsOpt Temp(Air)2 Skip	[E-002C 16:4 002C065]
  NsOpt Temp(Air)2 Up LIM	[E-002C 17:0 002C066]
  NsOpt Temp(Air)2 DN LIM	[E-002C 17:1 002C067]
  NsOpt Temp(Air)2 VAR Up LIM	[E-002C 17:2 002C068]
  NsOpt Temp(Air)2 VAR DN LIM	[E-002C 17:3 002C069]
  NsOpt Temp(Air)2 CHNG RT Up	[E-002C 17:4 002C06A]
  NsOpt Temp(Air)2 CHNG RT DN	[E-002C 17:5 002C06B]
  NsOpt Temp(Air)3 Alarm Data	[E-002C 18:0 002C06D]
  NsOpt Temp(Air)3 NORM Data	[E-002C 18:1 002C06E]
  NsOpt Temp(Air)3 VAR Data	[E-002C 18:2 002C06F]
  NsOpt Temp(Air)3 Over RNG	[E-002C 18:3 002C070]
  NsOpt Temp(Air)3 Skip	[E-002C 18:4 002C071]
  NsOpt Temp(Air)3 Up LIM	[E-002C 19:0 002C072]
  NsOpt Temp(Air)3 DN LIM	[E-002C 19:1 002C073]
  NsOpt Temp(Air)3 VAR Up LIM	[E-002C 19:2 002C074]
  NsOpt Temp(Air)3 VAR DN LIM	[E-002C 19:3 002C075]
  NsOpt Temp(Air)3 CHNG RT Up	[E-002C 19:4 002C076]
  NsOpt Temp(Air)3 CHNG RT DN	[E-002C 19:5 002C077]
  NsOpt Temp(Air)4 Alarm Data	[E-002C 20:0 002C079]
  NsOpt Temp(Air)4 NORM Data	[E-002C 20:1 002C07A]
  NsOpt Temp(Air)4 VAR Data	[E-002C 20:2 002C07B]
  NsOpt Temp(Air)4 Over RNG	[E-002C 20:3 002C07C]
  NsOpt Temp(Air)4 Skip	[E-002C 20:4 002C07D]
  NsOpt Temp(Air)4 Up LIM	[E-002C 21:0 002C07E]
  NsOpt Temp(Air)4 DN LIM	[E-002C 21:1 002C07F]
  NsOpt Temp(Air)4 VAR Up LIM	[E-002C 21:2 002C080]
  NsOpt Temp(Air)4 VAR DN LIM	[E-002C 21:3 002C081]
  NsOpt Temp(Air)4 CHNG RT Up	[E-002C 21:4 002C082]
  NsOpt Temp(Air)4 CHNG RT DN	[E-002C 21:5 002C083]
  NsIR Temp(Air) Alarm Data	[E-002C 22:0 002C085]
  NsIR Temp(Air) NORM Data	[E-002C 22:1 002C086]
  NsIR Temp(Air) VAR Data	[E-002C 22:2 002C087]
  NsIR Temp(Air) Over RNG	[E-002C 22:3 002C088]
  NsIR Temp(Air) Skip	[E-002C 22:4 002C089]
  NsIR Temp(Air) Up LIM	[E-002C 23:0 002C08A]
  NsIR Temp(Air) DN LIM	[E-002C 23:1 002C08B]
  NsIR Temp(Air) VAR Up LIM	[E-002C 23:2 002C08C]
  NsIR Temp(Air) VAR DN LIM	[E-002C 23:3 002C08D]
  NsIR Temp(Air) CHNG RT Up	[E-002C 23:4 002C08E]
  NsIR Temp(Air) CHNG RT DN	[E-002C 23:5 002C08F]
  Duct(IR) Temp(Air) Alarm Data	[E-002C 24:0 002C091]
  Duct(IR) Temp(Air) NORM Data	[E-002C 24:1 002C092]
  Duct(IR) Temp(Air) VAR Data	[E-002C 24:2 002C093]
  Duct(IR) Temp(Air) Over RNG	[E-002C 24:3 002C094]
  Duct(IR) Temp(Air) Skip	[E-002C 24:4 002C095]
  Duct(IR) Temp(Air) Up LIM	[E-002C 25:0 002C096]
  Duct(IR) Temp(Air) DN LIM	[E-002C 25:1 002C097]
  Duct(IR) Temp(Air) VAR Up LIM	[E-002C 25:2 002C098]
  Duct(IR) Temp(Air) VAR DN LIM	[E-002C 25:3 002C099]
  Duct(IR) Temp(Air) CHNG RT Up	[E-002C 25:4 002C09A]
  Duct(IR) Temp(Air) CHNG RT DN	[E-002C 25:5 002C09B]
  Duct(Opt) Temp(Air) Alarm Data	[E-002C 26:0 002C09D]
  Duct(Opt) Temp(Air) NORM Data	[E-002C 26:1 002C09E]
  Duct(Opt) Temp(Air) VAR Data	[E-002C 26:2 002C09F]
  Duct(Opt) Temp(Air) Over RNG	[E-002C 26:3 002C0A0]
  Duct(Opt) Temp(Air) Skip	[E-002C 26:4 002C0A1]
  Duct(Opt) Temp(Air) Up LIM	[E-002C 27:0 002C0A2]
  Duct(Opt) Temp(Air) DN LIM	[E-002C 27:1 002C0A3]
  Duct(Opt) Temp(Air) VAR Up LIM	[E-002C 27:2 002C0A4]
  Duct(Opt) Temp(Air) VAR DN LIM	[E-002C 27:3 002C0A5]
  Duct(Opt) Temp(Air) CHNG RT Up	[E-002C 27:4 002C0A6]
  Duct(Opt) Temp(Air) CHNG RT DN	[E-002C 27:5 002C0A7]
  Cell(R) Temp(Air) Alarm Data	[E-002C 28:0 002C0A9]
  Cell(R) Temp(Air) NORM Data	[E-002C 28:1 002C0AA]
  Cell(R) Temp(Air) VAR Data	[E-002C 28:2 002C0AB]
  Cell(R) Temp(Air) Over RNG	[E-002C 28:3 002C0AC]
  Cell(R) Temp(Air) Skip	[E-002C 28:4 002C0AD]
  Cell(R) Temp(Air) Up LIM	[E-002C 29:0 002C0AE]
  Cell(R) Temp(Air) DN LIM	[E-002C 29:1 002C0AF]
  Cell(R) Temp(Air) VAR Up LIM	[E-002C 29:2 002C0B0]
  Cell(R) Temp(Air) VAR DN LIM	[E-002C 29:3 002C0B1]
  Cell(R) Temp(Air) CHNG RT Up	[E-002C 29:4 002C0B2]
  Cell(R) Temp(Air) CHNG RT DN	[E-002C 29:5 002C0B3]
  Cell(Opt) Temp(Air) Alarm Data	[E-002C 30:0 002C0B5]
  Cell(Opt) Temp(Air) NORM Data	[E-002C 30:1 002C0B6]
  Cell(Opt) Temp(Air) VAR Data	[E-002C 30:2 002C0B7]
  Cell(Opt) Temp(Air) Over RNG	[E-002C 30:3 002C0B8]
  Cell(Opt) Temp(Air) Skip	[E-002C 30:4 002C0B9]
  Cell(Opt) Temp(Air) Up LIM	[E-002C 31:0 002C0BA]
  Cell(Opt) Temp(Air) DN LIM	[E-002C 31:1 002C0BB]
  Cell(Opt) Temp(Air) VAR Up LIM	[E-002C 31:2 002C0BC]
  Cell(Opt) Temp(Air) VAR DN LIM	[E-002C 31:3 002C0BD]
  Cell(Opt) Temp(Air) CHNG RT Up	[E-002C 31:4 002C0BE]
  Cell(Opt) Temp(Air) CHNG RT DN	[E-002C 31:5 002C0BF]
  Cell(F) Temp(Air) Alarm Data	[E-002C 32:0 002C0C1]
  Cell(F) Temp(Air) NORM Data	[E-002C 32:1 002C0C2]
  Cell(F) Temp(Air) VAR Data	[E-002C 32:2 002C0C3]
  Cell(F) Temp(Air) Over RNG	[E-002C 32:3 002C0C4]
  Cell(F) Temp(Air) Skip	[E-002C 32:4 002C0C5]
  Cell(F) Temp(Air) Up LIM	[E-002C 33:0 002C0C6]
  Cell(F) Temp(Air) DN LIM	[E-002C 33:1 002C0C7]
  Cell(F) Temp(Air) VAR Up LIM	[E-002C 33:2 002C0C8]
  Cell(F) Temp(Air) VAR DN LIM	[E-002C 33:3 002C0C9]
  Cell(F) Temp(Air) CHNG RT Up	[E-002C 33:4 002C0CA]
  Cell(F) Temp(Air) CHNG RT DN	[E-002C 33:5 002C0CB]
  Cell(IR) Temp(Air) Alarm Data	[E-002C 34:0 002C0CD]
  Cell(IR) Temp(Air) NORM Data	[E-002C 34:1 002C0CE]
  Cell(IR) Temp(Air) VAR Data	[E-002C 34:2 002C0CF]
  Cell(IR) Temp(Air) Over RNG	[E-002C 34:3 002C0D0]
  Cell(IR) Temp(Air) Skip	[E-002C 34:4 002C0D1]
  Cell(IR) Temp(Air) Up LIM	[E-002C 35:0 002C0D2]
  Cell(IR) Temp(Air) DN LIM	[E-002C 35:1 002C0D3]
  Cell(IR) Temp(Air) VAR Up LIM	[E-002C 35:2 002C0D4]
  Cell(IR) Temp(Air) VAR DN LIM	[E-002C 35:3 002C0D5]
  Cell(IR) Temp(Air) CHNG RT Up	[E-002C 35:4 002C0D6]
  Cell(IR) Temp(Air) CHNG RT DN	[E-002C 35:5 002C0D7]
  Cell(CNTR) Temp(Air) Alarm Data	[E-002C 36:0 002C0D9]
  Cell(CNTR) Temp(Air) NORM Data	[E-002C 36:1 002C0DA]
  Cell(CNTR) Temp(Air) VAR Data	[E-002C 36:2 002C0DB]
  Cell(CNTR) Temp(Air) Over RNG	[E-002C 36:3 002C0DC]
  Cell(CNTR) Temp(Air) Skip	[E-002C 36:4 002C0DD]
  Cell(CNTR) Temp(Air) Up LIM	[E-002C 37:0 002C0DE]
  Cell(CNTR) Temp(Air) DN LIM	[E-002C 37:1 002C0DF]
  Cell(CNTR) Temp(Air) VAR Up LIM	[E-002C 37:2 002C0E0]
  Cell(CNTR) Temp(Air) VAR DN LIM	[E-002C 37:3 002C0E1]
  Cell(CNTR) Temp(Air) CHNG RT Up	[E-002C 37:4 002C0E2]
  Cell(CNTR) Temp(Air) CHNG RT DN	[E-002C 37:5 002C0E3]
  Top Ring HMD Alarm Data	[E-002C 38:0 002C0E5]
  Top Ring HMD NORM Data	[E-002C 38:1 002C0E6]
  Top Ring HMD VAR Data	[E-002C 38:2 002C0E7]
  Top Ring HMD Over RNG	[E-002C 38:3 002C0E8]
  Top Ring HMD Skip	[E-002C 38:4 002C0E9]
  Top Ring HMD Up LIM	[E-002C 39:0 002C0EA]
  Top Ring HMD DN LIM	[E-002C 39:1 002C0EB]
  Top Ring HMD VAR Up LIM	[E-002C 39:2 002C0EC]
  Top Ring HMD VAR DN LIM	[E-002C 39:3 002C0ED]
  Top Ring HMD CHNG RT Up	[E-002C 39:4 002C0EE]
  Top Ring HMD CHNG RT DN	[E-002C 39:5 002C0EF]
  M3Frame HMD Alarm Data	[E-002C 40:0 002C0F1]
  M3Frame HMD NORM Data	[E-002C 40:1 002C0F2]
  M3Frame HMD VAR Data	[E-002C 40:2 002C0F3]
  M3Frame HMD Over RNG	[E-002C 40:3 002C0F4]
  M3Frame HMD Skip	[E-002C 40:4 002C0F5]
  M3Frame HMD Up LIM	[E-002C 41:0 002C0F6]
  M3Frame HMD DN LIM	[E-002C 41:1 002C0F7]
  M3Frame HMD VAR Up LIM	[E-002C 41:2 002C0F8]
  M3Frame HMD VAR DN LIM	[E-002C 41:3 002C0F9]
  M3Frame HMD CHNG RT Up	[E-002C 41:4 002C0FA]
  M3Frame HMD CHNG RT DN	[E-002C 41:5 002C0FB]
  AZBR HMD Alarm Data	[E-002C 42:0 002C0FD]
  AZBR HMD NORM Data	[E-002C 42:1 002C0FE]
  AZBR HMD VAR Data	[E-002C 42:2 002C0FF]
  AZBR HMD Over RNG	[E-002C 42:3 002C100]
  AZBR HMD Skip	[E-002C 42:4 002C101]
  AZBR HMD Up LIM	[E-002C 43:0 002C102]
  AZBR HMD DN LIM	[E-002C 43:1 002C103]
  AZBR HMD VAR Up LIM	[E-002C 43:2 002C104]
  AZBR HMD VAR DN LIM	[E-002C 43:3 002C105]
  AZBR HMD CHNG RT Up	[E-002C 43:4 002C106]
  AZBR HMD CHNG RT DN	[E-002C 43:5 002C107]
  NsOpt(R) HMD Alarm Data	[E-002C 44:0 002C109]
  NsOpt(R) HMD NORM Data	[E-002C 44:1 002C10A]
  NsOpt(R) HMD VAR Data	[E-002C 44:2 002C10B]
  NsOpt(R) HMD Over RNG	[E-002C 44:3 002C10C]
  NsOpt(R) HMD Skip	[E-002C 44:4 002C10D]
  NsOpt(R) HMD Up LIM	[E-002C 45:0 002C10E]
  NsOpt(R) HMD DN LIM	[E-002C 45:1 002C10F]
  NsOpt(R) HMD VAR Up LIM	[E-002C 45:2 002C110]
  NsOpt(R) HMD VAR DN LIM	[E-002C 45:3 002C111]
  NsOpt(R) HMD CHNG RT Up	[E-002C 45:4 002C112]
  NsOpt(R) HMD CHNG RT DN	[E-002C 45:5 002C113]
  NsOpt(F) HMD Alarm Data	[E-002C 46:0 002C115]
  NsOpt(F) HMD NORM Data	[E-002C 46:1 002C116]
  NsOpt(F) HMD VAR Data	[E-002C 46:2 002C117]
  NsOpt(F) HMD Over RNG	[E-002C 46:3 002C118]
  NsOpt(F) HMD Skip	[E-002C 46:4 002C119]
  NsOpt(F) HMD Up LIM	[E-002C 47:0 002C11A]
  NsOpt(F) HMD DN LIM	[E-002C 47:1 002C11B]
  NsOpt(F) HMD VAR Up LIM	[E-002C 47:2 002C11C]
  NsOpt(F) HMD VAR DN LIM	[E-002C 47:3 002C11D]
  NsOpt(F) HMD CHNG RT Up	[E-002C 47:4 002C11E]
  NsOpt(F) HMD CHNG RT DN	[E-002C 47:5 002C11F]
  NsIR HMD Alarm Data	[E-002C 48:0 002C121]
  NsIR HMD NORM Data	[E-002C 48:1 002C122]
  NsIR HMD VAR Data	[E-002C 48:2 002C123]
  NsIR HMD Over RNG	[E-002C 48:3 002C124]
  NsIR HMD Skip	[E-002C 48:4 002C125]
  NsIR HMD Up LIM	[E-002C 49:0 002C126]
  NsIR HMD DN LIM	[E-002C 49:1 002C127]
  NsIR HMD VAR Up LIM	[E-002C 49:2 002C128]
  NsIR HMD VAR DN LIM	[E-002C 49:3 002C129]
  NsIR HMD CHNG RT Up	[E-002C 49:4 002C12A]
  NsIR HMD CHNG RT DN	[E-002C 49:5 002C12B]
  Cell(R) HMD Alarm Data	[E-002C 50:0 002C12D]
  Cell(R) HMD NORM Data	[E-002C 50:1 002C12E]
  Cell(R) HMD VAR Data	[E-002C 50:2 002C12F]
  Cell(R) HMD Over RNG	[E-002C 50:3 002C130]
  Cell(R) HMD Skip	[E-002C 50:4 002C131]
  Cell(R) HMD Up LIM	[E-002C 51:0 002C132]
  Cell(R) HMD DN LIM	[E-002C 51:1 002C133]
  Cell(R) HMD VAR Up LIM	[E-002C 51:2 002C134]
  Cell(R) HMD VAR DN LIM	[E-002C 51:3 002C135]
  Cell(R) HMD CHNG RT Up	[E-002C 51:4 002C136]
  Cell(R) HMD CHNG RT DN	[E-002C 51:5 002C137]
  Cell(Opt) HMD Alarm Data	[E-002C 52:0 002C139]
  Cell(Opt) HMD NORM Data	[E-002C 52:1 002C13A]
  Cell(Opt) HMD VAR Data	[E-002C 52:2 002C13B]
  Cell(Opt) HMD Over RNG	[E-002C 52:3 002C13C]
  Cell(Opt) HMD Skip	[E-002C 52:4 002C13D]
  Cell(Opt) HMD Up LIM	[E-002C 53:0 002C13E]
  Cell(Opt) HMD DN LIM	[E-002C 53:1 002C13F]
  Cell(Opt) HMD VAR Up LIM	[E-002C 53:2 002C140]
  Cell(Opt) HMD VAR DN LIM	[E-002C 53:3 002C141]
  Cell(Opt) HMD CHNG RT Up	[E-002C 53:4 002C142]
  Cell(Opt) HMD CHNG RT DN	[E-002C 53:5 002C143]
  Cell(F) HMD Alarm Data	[E-002C 54:0 002C145]
  Cell(F) HMD NORM Data	[E-002C 54:1 002C146]
  Cell(F) HMD VAR Data	[E-002C 54:2 002C147]
  Cell(F) HMD Over RNG	[E-002C 54:3 002C148]
  Cell(F) HMD Skip	[E-002C 54:4 002C149]
  Cell(F) HMD Up LIM	[E-002C 55:0 002C14A]
  Cell(F) HMD DN LIM	[E-002C 55:1 002C14B]
  Cell(F) HMD VAR Up LIM	[E-002C 55:2 002C14C]
  Cell(F) HMD VAR DN LIM	[E-002C 55:3 002C14D]
  Cell(F) HMD CHNG RT Up	[E-002C 55:4 002C14E]
  Cell(F) HMD CHNG RT DN	[E-002C 55:5 002C14F]
  Cell(IR) HMD Alarm Data	[E-002C 56:0 002C151]
  Cell(IR) HMD NORM Data	[E-002C 56:1 002C152]
  Cell(IR) HMD VAR Data	[E-002C 56:2 002C153]
  Cell(IR) HMD Over RNG	[E-002C 56:3 002C154]
  Cell(IR) HMD Skip	[E-002C 56:4 002C155]
  Cell(IR) HMD Up LIM	[E-002C 57:0 002C156]
  Cell(IR) HMD DN LIM	[E-002C 57:1 002C157]
  Cell(IR) HMD VAR Up LIM	[E-002C 57:2 002C158]
  Cell(IR) HMD VAR DN LIM	[E-002C 57:3 002C159]
  Cell(IR) HMD CHNG RT Up	[E-002C 57:4 002C15A]
  Cell(IR) HMD CHNG RT DN	[E-002C 57:5 002C15B]
  Cell(CNTR) HMD Alarm Data	[E-002C 58:0 002C15D]
  Cell(CNTR) HMD NORM Data	[E-002C 58:1 002C15E]
  Cell(CNTR) HMD VAR Data	[E-002C 58:2 002C15F]
  Cell(CNTR) HMD Over RNG	[E-002C 58:3 002C160]
  Cell(CNTR) HMD Skip	[E-002C 58:4 002C161]
  Cell(CNTR) HMD Up LIM	[E-002C 59:0 002C162]
  Cell(CNTR) HMD DN LIM	[E-002C 59:1 002C163]
  Cell(CNTR) HMD VAR Up LIM	[E-002C 59:2 002C164]
  Cell(CNTR) HMD VAR DN LIM	[E-002C 59:3 002C165]
  Cell(CNTR) HMD CHNG RT Up	[E-002C 59:4 002C166]
  Cell(CNTR) HMD CHNG RT DN	[E-002C 59:5 002C167]
  Top Ring(R) WVEL Alarm Data	[E-002C 60:0 002C169]
  Top Ring(R) WVEL NORM Data	[E-002C 60:1 002C16A]
  Top Ring(R) WVEL VAR Data	[E-002C 60:2 002C16B]
  Top Ring(R) WVEL Over RNG	[E-002C 60:3 002C16C]
  Top Ring(R) WVEL Skip	[E-002C 60:4 002C16D]
  Top Ring(R) WVEL Up LIM	[E-002C 61:0 002C16E]
  Top Ring(R) WVEL DN LIM	[E-002C 61:1 002C16F]
  Top Ring(R) WVEL VAR Up LIM	[E-002C 61:2 002C170]
  Top Ring(R) WVEL VAR DN LIM	[E-002C 61:3 002C171]
  Top Ring(R) WVEL CHNG RT Up	[E-002C 61:4 002C172]
  Top Ring(R) WVEL CHNG RT DN	[E-002C 61:5 002C173]
  Top Ring(F) WVEL Alarm Data	[E-002C 62:0 002C175]
  Top Ring(F) WVEL NORM Data	[E-002C 62:1 002C176]
  Top Ring(F) WVEL VAR Data	[E-002C 62:2 002C177]
  Top Ring(F) WVEL Over RNG	[E-002C 62:3 002C178]
  Top Ring(F) WVEL Skip	[E-002C 62:4 002C179]
  Top Ring(F) WVEL Up LIM	[E-002C 63:0 002C17A]
  Top Ring(F) WVEL DN LIM	[E-002C 63:1 002C17B]
  Top Ring(F) WVEL VAR Up LIM	[E-002C 63:2 002C17C]
  Top Ring(F) WVEL VAR DN LIM	[E-002C 63:3 002C17D]
  Top Ring(F) WVEL CHNG RT Up	[E-002C 63:4 002C17E]
  Top Ring(F) WVEL CHNG RT DN	[E-002C 63:5 002C17F]
  U TRS(R) WVEL Alarm Data	[E-002C 64:0 002C181]
  U TRS(R) WVEL NORM Data	[E-002C 64:1 002C182]
  U TRS(R) WVEL VAR Data	[E-002C 64:2 002C183]
  U TRS(R) WVEL Over RNG	[E-002C 64:3 002C184]
  U TRS(R) WVEL Skip	[E-002C 64:4 002C185]
  U TRS(R) WVEL Up LIM	[E-002C 65:0 002C186]
  U TRS(R) WVEL DN LIM	[E-002C 65:1 002C187]
  U TRS(R) WVEL VAR Up LIM	[E-002C 65:2 002C188]
  U TRS(R) WVEL VAR DN LIM	[E-002C 65:3 002C189]
  U TRS(R) WVEL CHNG RT Up	[E-002C 65:4 002C18A]
  U TRS(R) WVEL CHNG RT DN	[E-002C 65:5 002C18B]
  U TRS(F) WVEL Alarm Data	[E-002C 66:0 002C18D]
  U TRS(F) WVEL NORM Data	[E-002C 66:1 002C18E]
  U TRS(F) WVEL VAR Data	[E-002C 66:2 002C18F]
  U TRS(F) WVEL Over RNG	[E-002C 66:3 002C190]
  U TRS(F) WVEL Skip	[E-002C 66:4 002C191]
  U TRS(F) WVEL Up LIM	[E-002C 67:0 002C192]
  U TRS(F) WVEL DN LIM	[E-002C 67:1 002C193]
  U TRS(F) WVEL VAR Up LIM	[E-002C 67:2 002C194]
  U TRS(F) WVEL VAR DN LIM	[E-002C 67:3 002C195]
  U TRS(F) WVEL CHNG RT Up	[E-002C 67:4 002C196]
  U TRS(F) WVEL CHNG RT DN	[E-002C 67:5 002C197]
  CSCT(F) WVEL(X) Alarm Data	[E-002C 68:0 002C199]
  CSCT(F) WVEL(X) NORM Data	[E-002C 68:1 002C19A]
  CSCT(F) WVEL(X) VAR Data	[E-002C 68:2 002C19B]
  CSCT(F) WVEL(X) Over RNG	[E-002C 68:3 002C19C]
  CSCT(F) WVEL(X) Skip	[E-002C 68:4 002C19D]
  CSCT(F) WVEL(X) Up LIM	[E-002C 69:0 002C19E]
  CSCT(F) WVEL(X) DN LIM	[E-002C 69:1 002C19F]
  CSCT(F) WVEL(X) VAR Up LIM	[E-002C 69:2 002C1A0]
  CSCT(F) WVEL(X) VAR DN LIM	[E-002C 69:3 002C1A1]
  CSCT(F) WVEL(X) CHNG RT Up	[E-002C 69:4 002C1A2]
  CSCT(F) WVEL(X) CHNG RT DN	[E-002C 69:5 002C1A3]
  CSCT(F) WVEL(Y) Alarm Data	[E-002C 70:0 002C1A5]
  CSCT(F) WVEL(Y) NORM Data	[E-002C 70:1 002C1A6]
  CSCT(F) WVEL(Y) VAR Data	[E-002C 70:2 002C1A7]
  CSCT(F) WVEL(Y) Over RNG	[E-002C 70:3 002C1A8]
  CSCT(F) WVEL(Y) Skip	[E-002C 70:4 002C1A9]
  CSCT(F) WVEL(Y) Up LIM	[E-002C 71:0 002C1AA]
  CSCT(F) WVEL(Y) DN LIM	[E-002C 71:1 002C1AB]
  CSCT(F) WVEL(Y) VAR Up LIM	[E-002C 71:2 002C1AC]
  CSCT(F) WVEL(Y) VAR DN LIM	[E-002C 71:3 002C1AD]
  CSCT(F) WVEL(Y) CHNG RT Up	[E-002C 71:4 002C1AE]
  CSCT(F) WVEL(Y) CHNG RT DN	[E-002C 71:5 002C1AF]
  CSCT(F) WVEL(Z) Alarm Data	[E-002C 72:0 002C1B1]
  CSCT(F) WVEL(Z) NORM Data	[E-002C 72:1 002C1B2]
  CSCT(F) WVEL(Z) VAR Data	[E-002C 72:2 002C1B3]
  CSCT(F) WVEL(Z) Over RNG	[E-002C 72:3 002C1B4]
  CSCT(F) WVEL(Z) Skip	[E-002C 72:4 002C1B5]
  CSCT(F) WVEL(Z) Up LIM	[E-002C 73:0 002C1B6]
  CSCT(F) WVEL(Z) DN LIM	[E-002C 73:1 002C1B7]
  CSCT(F) WVEL(Z) VAR Up LIM	[E-002C 73:2 002C1B8]
  CSCT(F) WVEL(Z) VAR DN LIM	[E-002C 73:3 002C1B9]
  CSCT(F) WVEL(Z) CHNG RT Up	[E-002C 73:4 002C1BA]
  CSCT(F) WVEL(Z) CHNG RT DN	[E-002C 73:5 002C1BB]
  CSCT(R) WVEL(X) Alarm Data	[E-002C 74:0 002C1BD]
  CSCT(R) WVEL(X) NORM Data	[E-002C 74:1 002C1BE]
  CSCT(R) WVEL(X) VAR Data	[E-002C 74:2 002C1BF]
  CSCT(R) WVEL(X) Over RNG	[E-002C 74:3 002C1C0]
  CSCT(R) WVEL(X) Skip	[E-002C 74:4 002C1C1]
  CSCT(R) WVEL(X) Up LIM	[E-002C 75:0 002C1C2]
  CSCT(R) WVEL(X) DN LIM	[E-002C 75:1 002C1C3]
  CSCT(R) WVEL(X) VAR Up LIM	[E-002C 75:2 002C1C4]
  CSCT(R) WVEL(X) VAR DN LIM	[E-002C 75:3 002C1C5]
  CSCT(R) WVEL(X) CHNG RT Up	[E-002C 75:4 002C1C6]
  CSCT(R) WVEL(X) CHNG RT DN	[E-002C 75:5 002C1C7]
  CSCT(R) WVEL(Y) Alarm Data	[E-002C 76:0 002C1C9]
  CSCT(R) WVEL(Y) NORM Data	[E-002C 76:1 002C1CA]
  CSCT(R) WVEL(Y) VAR Data	[E-002C 76:2 002C1CB]
  CSCT(R) WVEL(Y) Over RNG	[E-002C 76:3 002C1CC]
  CSCT(R) WVEL(Y) Skip	[E-002C 76:4 002C1CD]
  CSCT(R) WVEL(Y) Up LIM	[E-002C 77:0 002C1CE]
  CSCT(R) WVEL(Y) DN LIM	[E-002C 77:1 002C1CF]
  CSCT(R) WVEL(Y) VAR Up LIM	[E-002C 77:2 002C1D0]
  CSCT(R) WVEL(Y) VAR DN LIM	[E-002C 77:3 002C1D1]
  CSCT(R) WVEL(Y) CHNG RT Up	[E-002C 77:4 002C1D2]
  CSCT(R) WVEL(Y) CHNG RT DN	[E-002C 77:5 002C1D3]
  CSCT(R) WVEL(Z) Alarm Data	[E-002C 78:0 002C1D5]
  CSCT(R) WVEL(Z) NORM Data	[E-002C 78:1 002C1D6]
  CSCT(R) WVEL(Z) VAR Data	[E-002C 78:2 002C1D7]
  CSCT(R) WVEL(Z) Over RNG	[E-002C 78:3 002C1D8]
  CSCT(R) WVEL(Z) Skip	[E-002C 78:4 002C1D9]
  CSCT(R) WVEL(Z) Up LIM	[E-002C 79:0 002C1DA]
  CSCT(R) WVEL(Z) DN LIM	[E-002C 79:1 002C1DB]
  CSCT(R) WVEL(Z) VAR Up LIM	[E-002C 79:2 002C1DC]
  CSCT(R) WVEL(Z) VAR DN LIM	[E-002C 79:3 002C1DD]
  CSCT(R) WVEL(Z) CHNG RT Up	[E-002C 79:4 002C1DE]
  CSCT(R) WVEL(Z) CHNG RT DN	[E-002C 79:5 002C1DF]
  TLSCP Fuse1 Alarm Data	[E-002C 80:0 002C1E1]
  TLSCP Fuse1 NORM Data	[E-002C 80:1 002C1E2]
  TLSCP Fuse1 VAR Data	[E-002C 80:2 002C1E3]
  TLSCP Fuse1 Over RNG	[E-002C 80:3 002C1E4]
  TLSCP Fuse1 Skip	[E-002C 80:4 002C1E5]
  TLSCP Fuse1 Up LIM	[E-002C 81:0 002C1E6]
  TLSCP Fuse1 DN LIM	[E-002C 81:1 002C1E7]
  TLSCP Fuse1 VAR Up LIM	[E-002C 81:2 002C1E8]
  TLSCP Fuse1 VAR DN LIM	[E-002C 81:3 002C1E9]
  TLSCP Fuse1 CHNG RT Up	[E-002C 81:4 002C1EA]
  TLSCP Fuse1 CHNG RT DN	[E-002C 81:5 002C1EB]
  TLSCP Fuse2 Alarm Data	[E-002C 82:0 002C1ED]
  TLSCP Fuse2 NORM Data	[E-002C 82:1 002C1EE]
  TLSCP Fuse2 VAR Data	[E-002C 82:2 002C1EF]
  TLSCP Fuse2 Over RNG	[E-002C 82:3 002C1F0]
  TLSCP Fuse2 Skip	[E-002C 82:4 002C1F1]
  TLSCP Fuse2 Up LIM	[E-002C 83:0 002C1F2]
  TLSCP Fuse2 DN LIM	[E-002C 83:1 002C1F3]
  TLSCP Fuse2 VAR Up LIM	[E-002C 83:2 002C1F4]
  TLSCP Fuse2 VAR DN LIM	[E-002C 83:3 002C1F5]
  TLSCP Fuse2 CHNG RT Up	[E-002C 83:4 002C1F6]
  TLSCP Fuse2 CHNG RT DN	[E-002C 83:5 002C1F7]
  TLSCP FL Temp1 Alarm Data	[E-002C 84:0 002C1F9]
  TLSCP FL Temp1 NORM Data	[E-002C 84:1 002C1FA]
  TLSCP FL Temp1 VAR Data	[E-002C 84:2 002C1FB]
  TLSCP FL Temp1 Over RNG	[E-002C 84:3 002C1FC]
  TLSCP FL Temp1 Skip	[E-002C 84:4 002C1FD]
  TLSCP FL Temp1 Up LIM	[E-002C 85:0 002C1FE]
  TLSCP FL Temp1 DN LIM	[E-002C 85:1 002C1FF]
  TLSCP FL Temp1 VAR Up LIM	[E-002C 85:2 002C200]
  TLSCP FL Temp1 VAR DN LIM	[E-002C 85:3 002C201]
  TLSCP FL Temp1 CHNG RT Up	[E-002C 85:4 002C202]
  TLSCP FL Temp1 CHNG RT DN	[E-002C 85:5 002C203]
  TLSCP FL Temp2 Alarm Data	[E-002C 86:0 002C205]
  TLSCP FL Temp2 NORM Data	[E-002C 86:1 002C206]
  TLSCP FL Temp2 VAR Data	[E-002C 86:2 002C207]
  TLSCP FL Temp2 Over RNG	[E-002C 86:3 002C208]
  TLSCP FL Temp2 Skip	[E-002C 86:4 002C209]
  TLSCP FL Temp2 Up LIM	[E-002C 87:0 002C20A]
  TLSCP FL Temp2 DN LIM	[E-002C 87:1 002C20B]
  TLSCP FL Temp2 VAR Up LIM	[E-002C 87:2 002C20C]
  TLSCP FL Temp2 VAR DN LIM	[E-002C 87:3 002C20D]
  TLSCP FL Temp2 CHNG RT Up	[E-002C 87:4 002C20E]
  TLSCP FL Temp2 CHNG RT DN	[E-002C 87:5 002C20F]
  YORK(Opt) Temp1 Alarm Data	[E-002C 88:0 002C211]
  YORK(Opt) Temp1 NORM Data	[E-002C 88:1 002C212]
  YORK(Opt) Temp1 VAR Data	[E-002C 88:2 002C213]
  YORK(Opt) Temp1 Over RNG	[E-002C 88:3 002C214]
  YORK(Opt) Temp1 Skip	[E-002C 88:4 002C215]
  YORK(Opt) Temp1 Up LIM	[E-002C 89:0 002C216]
  YORK(Opt) Temp1 DN LIM	[E-002C 89:1 002C217]
  YORK(Opt) Temp1 VAR Up LIM	[E-002C 89:2 002C218]
  YORK(Opt) Temp1 VAR DN LIM	[E-002C 89:3 002C219]
  YORK(Opt) Temp1 CHNG RT Up	[E-002C 89:4 002C21A]
  YORK(Opt) Temp1 CHNG RT DN	[E-002C 89:5 002C21B]
  YORK(Opt) Temp2 Alarm Data	[E-002C 90:0 002C21D]
  YORK(Opt) Temp2 NORM Data	[E-002C 90:1 002C21E]
  YORK(Opt) Temp2 VAR Data	[E-002C 90:2 002C21F]
  YORK(Opt) Temp2 Over RNG	[E-002C 90:3 002C220]
  YORK(Opt) Temp2 Skip	[E-002C 90:4 002C221]
  YORK(Opt) Temp2 Up LIM	[E-002C 91:0 002C222]
  YORK(Opt) Temp2 DN LIM	[E-002C 91:1 002C223]
  YORK(Opt) Temp2 VAR Up LIM	[E-002C 91:2 002C224]
  YORK(Opt) Temp2 VAR DN LIM	[E-002C 91:3 002C225]
  YORK(Opt) Temp2 CHNG RT Up	[E-002C 91:4 002C226]
  YORK(Opt) Temp2 CHNG RT DN	[E-002C 91:5 002C227]
  YORK(Opt) Temp3 Alarm Data	[E-002C 92:0 002C229]
  YORK(Opt) Temp3 NORM Data	[E-002C 92:1 002C22A]
  YORK(Opt) Temp3 VAR Data	[E-002C 92:2 002C22B]
  YORK(Opt) Temp3 Over RNG	[E-002C 92:3 002C22C]
  YORK(Opt) Temp3 Skip	[E-002C 92:4 002C22D]
  YORK(Opt) Temp3 Up LIM	[E-002C 93:0 002C22E]
  YORK(Opt) Temp3 DN LIM	[E-002C 93:1 002C22F]
  YORK(Opt) Temp3 VAR Up LIM	[E-002C 93:2 002C230]
  YORK(Opt) Temp3 VAR DN LIM	[E-002C 93:3 002C231]
  YORK(Opt) Temp3 CHNG RT Up	[E-002C 93:4 002C232]
  YORK(Opt) Temp3 CHNG RT DN	[E-002C 93:5 002C233]
  YORK(Opt) Temp4 Alarm Data	[E-002C 94:0 002C235]
  YORK(Opt) Temp4 NORM Data	[E-002C 94:1 002C236]
  YORK(Opt) Temp4 VAR Data	[E-002C 94:2 002C237]
  YORK(Opt) Temp4 Over RNG	[E-002C 94:3 002C238]
  YORK(Opt) Temp4 Skip	[E-002C 94:4 002C239]
  YORK(Opt) Temp4 Up LIM	[E-002C 95:0 002C23A]
  YORK(Opt) Temp4 DN LIM	[E-002C 95:1 002C23B]
  YORK(Opt) Temp4 VAR Up LIM	[E-002C 95:2 002C23C]
  YORK(Opt) Temp4 VAR DN LIM	[E-002C 95:3 002C23D]
  YORK(Opt) Temp4 CHNG RT Up	[E-002C 95:4 002C23E]
  YORK(Opt) Temp4 CHNG RT DN	[E-002C 95:5 002C23F]
  YORK(IR) Temp4 Alarm Data	[E-002C 96:0 002C241]
  YORK(IR) Temp4 NORM Data	[E-002C 96:1 002C242]
  YORK(IR) Temp4 VAR Data	[E-002C 96:2 002C243]
  YORK(IR) Temp4 Over RNG	[E-002C 96:3 002C244]
  YORK(IR) Temp4 Skip	[E-002C 96:4 002C245]
  YORK(IR) Temp4 Up LIM	[E-002C 97:0 002C246]
  YORK(IR) Temp4 DN LIM	[E-002C 97:1 002C247]
  YORK(IR) Temp4 VAR Up LIM	[E-002C 97:2 002C248]
  YORK(IR) Temp4 VAR DN LIM	[E-002C 97:3 002C249]
  YORK(IR) Temp4 CHNG RT Up	[E-002C 97:4 002C24A]
  YORK(IR) Temp4 CHNG RT DN	[E-002C 97:5 002C24B]
  YORK(IR) Temp3 Alarm Data	[E-002C 98:0 002C24D]
  YORK(IR) Temp3 NORM Data	[E-002C 98:1 002C24E]
  YORK(IR) Temp3 VAR Data	[E-002C 98:2 002C24F]
  YORK(IR) Temp3 Over RNG	[E-002C 98:3 002C250]
  YORK(IR) Temp3 Skip	[E-002C 98:4 002C251]
  YORK(IR) Temp3 Up LIM	[E-002C 99:0 002C252]
  YORK(IR) Temp3 DN LIM	[E-002C 99:1 002C253]
  YORK(IR) Temp3 VAR Up LIM	[E-002C 99:2 002C254]
  YORK(IR) Temp3 VAR DN LIM	[E-002C 99:3 002C255]
  YORK(IR) Temp3 CHNG RT Up	[E-002C 99:4 002C256]
  YORK(IR) Temp3 CHNG RT DN	[E-002C 99:5 002C257]
  YORK(IR) Temp2 Alarm Data	[E-002C 100:0 002C259]
  YORK(IR) Temp2 NORM Data	[E-002C 100:1 002C25A]
  YORK(IR) Temp2 VAR Data	[E-002C 100:2 002C25B]
  YORK(IR) Temp2 Over RNG	[E-002C 100:3 002C25C]
  YORK(IR) Temp2 Skip	[E-002C 100:4 002C25D]
  YORK(IR) Temp2 Up LIM	[E-002C 101:0 002C25E]
  YORK(IR) Temp2 DN LIM	[E-002C 101:1 002C25F]
  YORK(IR) Temp2 VAR Up LIM	[E-002C 101:2 002C260]
  YORK(IR) Temp2 VAR DN LIM	[E-002C 101:3 002C261]
  YORK(IR) Temp2 CHNG RT Up	[E-002C 101:4 002C262]
  YORK(IR) Temp2 CHNG RT DN	[E-002C 101:5 002C263]
  YORK(IR) Temp1 Alarm Data	[E-002C 102:0 002C265]
  YORK(IR) Temp1 NORM Data	[E-002C 102:1 002C266]
  YORK(IR) Temp1 VAR Data	[E-002C 102:2 002C267]
  YORK(IR) Temp1 Over RNG	[E-002C 102:3 002C268]
  YORK(IR) Temp1 Skip	[E-002C 102:4 002C269]
  YORK(IR) Temp1 Up LIM	[E-002C 103:0 002C26A]
  YORK(IR) Temp1 DN LIM	[E-002C 103:1 002C26B]
  YORK(IR) Temp1 VAR Up LIM	[E-002C 103:2 002C26C]
  YORK(IR) Temp1 VAR DN LIM	[E-002C 103:3 002C26D]
  YORK(IR) Temp1 CHNG RT Up	[E-002C 103:4 002C26E]
  YORK(IR) Temp1 CHNG RT DN	[E-002C 103:5 002C26F]
  M1(R-S) Temp Alarm Data	[E-002C 104:0 002C271]
  M1(R-S) Temp NORM Data	[E-002C 104:1 002C272]
  M1(R-S) Temp VAR Data	[E-002C 104:2 002C273]
  M1(R-S) Temp Over RNG	[E-002C 104:3 002C274]
  M1(R-S) Temp Skip	[E-002C 104:4 002C275]
  M1(R-S) Temp Up LIM	[E-002C 105:0 002C276]
  M1(R-S) Temp DN LIM	[E-002C 105:1 002C277]
  M1(R-S) Temp VAR Up LIM	[E-002C 105:2 002C278]
  M1(R-S) Temp VAR DN LIM	[E-002C 105:3 002C279]
  M1(R-S) Temp CHNG RT Up	[E-002C 105:4 002C27A]
  M1(R-S) Temp CHNG RT DN	[E-002C 105:5 002C27B]
  M1(R-B) Temp Alarm Data	[E-002C 106:0 002C27D]
  M1(R-B) Temp NORM Data	[E-002C 106:1 002C27E]
  M1(R-B) Temp VAR Data	[E-002C 106:2 002C27F]
  M1(R-B) Temp Over RNG	[E-002C 106:3 002C280]
  M1(R-B) Temp Skip	[E-002C 106:4 002C281]
  M1(R-B) Temp Up LIM	[E-002C 107:0 002C282]
  M1(R-B) Temp DN LIM	[E-002C 107:1 002C283]
  M1(R-B) Temp VAR Up LIM	[E-002C 107:2 002C284]
  M1(R-B) Temp VAR DN LIM	[E-002C 107:3 002C285]
  M1(R-B) Temp CHNG RT Up	[E-002C 107:4 002C286]
  M1(R-B) Temp CHNG RT DN	[E-002C 107:5 002C287]
  M1(Opt-S) Temp Alarm Data	[E-002C 108:0 002C289]
  M1(Opt-S) Temp NORM Data	[E-002C 108:1 002C28A]
  M1(Opt-S) Temp VAR Data	[E-002C 108:2 002C28B]
  M1(Opt-S) Temp Over RNG	[E-002C 108:3 002C28C]
  M1(Opt-S) Temp Skip	[E-002C 108:4 002C28D]
  M1(Opt-S) Temp Up LIM	[E-002C 109:0 002C28E]
  M1(Opt-S) Temp DN LIM	[E-002C 109:1 002C28F]
  M1(Opt-S) Temp VAR Up LIM	[E-002C 109:2 002C290]
  M1(Opt-S) Temp VAR DN LIM	[E-002C 109:3 002C291]
  M1(Opt-S) Temp CHNG RT Up	[E-002C 109:4 002C292]
  M1(Opt-S) Temp CHNG RT DN	[E-002C 109:5 002C293]
  M1(Opt-B) Temp Alarm Data	[E-002C 110:0 002C295]
  M1(Opt-B) Temp NORM Data	[E-002C 110:1 002C296]
  M1(Opt-B) Temp VAR Data	[E-002C 110:2 002C297]
  M1(Opt-B) Temp Over RNG	[E-002C 110:3 002C298]
  M1(Opt-B) Temp Skip	[E-002C 110:4 002C299]
  M1(Opt-B) Temp Up LIM	[E-002C 111:0 002C29A]
  M1(Opt-B) Temp DN LIM	[E-002C 111:1 002C29B]
  M1(Opt-B) Temp VAR Up LIM	[E-002C 111:2 002C29C]
  M1(Opt-B) Temp VAR DN LIM	[E-002C 111:3 002C29D]
  M1(Opt-B) Temp CHNG RT Up	[E-002C 111:4 002C29E]
  M1(Opt-B) Temp CHNG RT DN	[E-002C 111:5 002C29F]
  M1(F-S) Temp Alarm Data	[E-002C 112:0 002C2A1]
  M1(F-S) Temp NORM Data	[E-002C 112:1 002C2A2]
  M1(F-S) Temp VAR Data	[E-002C 112:2 002C2A3]
  M1(F-S) Temp Over RNG	[E-002C 112:3 002C2A4]
  M1(F-S) Temp Skip	[E-002C 112:4 002C2A5]
  M1(F-S) Temp Up LIM	[E-002C 113:0 002C2A6]
  M1(F-S) Temp DN LIM	[E-002C 113:1 002C2A7]
  M1(F-S) Temp VAR Up LIM	[E-002C 113:2 002C2A8]
  M1(F-S) Temp VAR DN LIM	[E-002C 113:3 002C2A9]
  M1(F-S) Temp CHNG RT Up	[E-002C 113:4 002C2AA]
  M1(F-S) Temp CHNG RT DN	[E-002C 113:5 002C2AB]
  M1(F-B) Temp Alarm Data	[E-002C 114:0 002C2AD]
  M1(F-B) Temp NORM Data	[E-002C 114:1 002C2AE]
  M1(F-B) Temp VAR Data	[E-002C 114:2 002C2AF]
  M1(F-B) Temp Over RNG	[E-002C 114:3 002C2B0]
  M1(F-B) Temp Skip	[E-002C 114:4 002C2B1]
  M1(F-B) Temp Up LIM	[E-002C 115:0 002C2B2]
  M1(F-B) Temp DN LIM	[E-002C 115:1 002C2B3]
  M1(F-B) Temp VAR Up LIM	[E-002C 115:2 002C2B4]
  M1(F-B) Temp VAR DN LIM	[E-002C 115:3 002C2B5]
  M1(F-B) Temp CHNG RT Up	[E-002C 115:4 002C2B6]
  M1(F-B) Temp CHNG RT DN	[E-002C 115:5 002C2B7]
  M1(IR-S) Temp Alarm Data	[E-002C 116:0 002C2B9]
  M1(IR-S) Temp NORM Data	[E-002C 116:1 002C2BA]
  M1(IR-S) Temp VAR Data	[E-002C 116:2 002C2BB]
  M1(IR-S) Temp Over RNG	[E-002C 116:3 002C2BC]
  M1(IR-S) Temp Skip	[E-002C 116:4 002C2BD]
  M1(IR-S) Temp Up LIM	[E-002C 117:0 002C2BE]
  M1(IR-S) Temp DN LIM	[E-002C 117:1 002C2BF]
  M1(IR-S) Temp VAR Up LIM	[E-002C 117:2 002C2C0]
  M1(IR-S) Temp VAR DN LIM	[E-002C 117:3 002C2C1]
  M1(IR-S) Temp CHNG RT Up	[E-002C 117:4 002C2C2]
  M1(IR-S) Temp CHNG RT DN	[E-002C 117:5 002C2C3]
  M1(IR-B) Temp Alarm Data	[E-002C 118:0 002C2C5]
  M1(IR-B) Temp NORM Data	[E-002C 118:1 002C2C6]
  M1(IR-B) Temp VAR Data	[E-002C 118:2 002C2C7]
  M1(IR-B) Temp Over RNG	[E-002C 118:3 002C2C8]
  M1(IR-B) Temp Skip	[E-002C 118:4 002C2C9]
  M1(IR-B) Temp Up LIM	[E-002C 119:0 002C2CA]
  M1(IR-B) Temp DN LIM	[E-002C 119:1 002C2CB]
  M1(IR-B) Temp VAR Up LIM	[E-002C 119:2 002C2CC]
  M1(IR-B) Temp VAR DN LIM	[E-002C 119:3 002C2CD]
  M1(IR-B) Temp CHNG RT Up	[E-002C 119:4 002C2CE]
  M1(IR-B) Temp CHNG RT DN	[E-002C 119:5 002C2CF]
  Cell(8-61) Temp Alarm Data	[E-002C 120:0 002C2D1]
  Cell(8-61) Temp NORM Data	[E-002C 120:1 002C2D2]
  Cell(8-61) Temp VAR Data	[E-002C 120:2 002C2D3]
  Cell(8-61) Temp Over RNG	[E-002C 120:3 002C2D4]
  Cell(8-61) Temp Skip	[E-002C 120:4 002C2D5]
  Cell(8-61) Temp Up LIM	[E-002C 121:0 002C2D6]
  Cell(8-61) Temp DN LIM	[E-002C 121:1 002C2D7]
  Cell(8-61) Temp VAR Up LIM	[E-002C 121:2 002C2D8]
  Cell(8-61) Temp VAR DN LIM	[E-002C 121:3 002C2D9]
  Cell(8-61) Temp CHNG RT Up	[E-002C 121:4 002C2DA]
  Cell(8-61) Temp CHNG RT DN	[E-002C 121:5 002C2DB]
  Cell(8-62) Temp Alarm Data	[E-002C 122:0 002C2DD]
  Cell(8-62) Temp NORM Data	[E-002C 122:1 002C2DE]
  Cell(8-62) Temp VAR Data	[E-002C 122:2 002C2DF]
  Cell(8-62) Temp Over RNG	[E-002C 122:3 002C2E0]
  Cell(8-62) Temp Skip	[E-002C 122:4 002C2E1]
  Cell(8-62) Temp Up LIM	[E-002C 123:0 002C2E2]
  Cell(8-62) Temp DN LIM	[E-002C 123:1 002C2E3]
  Cell(8-62) Temp VAR Up LIM	[E-002C 123:2 002C2E4]
  Cell(8-62) Temp VAR DN LIM	[E-002C 123:3 002C2E5]
  Cell(8-62) Temp CHNG RT Up	[E-002C 123:4 002C2E6]
  Cell(8-62) Temp CHNG RT DN	[E-002C 123:5 002C2E7]
  Cell(8-63) Temp Alarm Data	[E-002C 124:0 002C2E9]
  Cell(8-63) Temp NORM Data	[E-002C 124:1 002C2EA]
  Cell(8-63) Temp VAR Data	[E-002C 124:2 002C2EB]
  Cell(8-63) Temp Over RNG	[E-002C 124:3 002C2EC]
  Cell(8-63) Temp Skip	[E-002C 124:4 002C2ED]
  Cell(8-63) Temp Up LIM	[E-002C 125:0 002C2EE]
  Cell(8-63) Temp DN LIM	[E-002C 125:1 002C2EF]
  Cell(8-63) Temp VAR Up LIM	[E-002C 125:2 002C2F0]
  Cell(8-63) Temp VAR DN LIM	[E-002C 125:3 002C2F1]
  Cell(8-63) Temp CHNG RT Up	[E-002C 125:4 002C2F2]
  Cell(8-63) Temp CHNG RT DN	[E-002C 125:5 002C2F3]
  U TRS(R) Temp1 Alarm Data	[E-002C 126:0 002C2F5]
  U TRS(R) Temp1 NORM Data	[E-002C 126:1 002C2F6]
  U TRS(R) Temp1 VAR Data	[E-002C 126:2 002C2F7]
  U TRS(R) Temp1 Over RNG	[E-002C 126:3 002C2F8]
  U TRS(R) Temp1 Skip	[E-002C 126:4 002C2F9]
  U TRS(R) Temp1 Up LIM	[E-002C 127:0 002C2FA]
  U TRS(R) Temp1 DN LIM	[E-002C 127:1 002C2FB]
  U TRS(R) Temp1 VAR Up LIM	[E-002C 127:2 002C2FC]
  U TRS(R) Temp1 VAR DN LIM	[E-002C 127:3 002C2FD]
  U TRS(R) Temp1 CHNG RT Up	[E-002C 127:4 002C2FE]
  U TRS(R) Temp1 CHNG RT DN	[E-002C 127:5 002C2FF]
  U TRS(Opt) Temp1 Alarm Data	[E-002C 128:0 002C301]
  U TRS(Opt) Temp1 NORM Data	[E-002C 128:1 002C302]
  U TRS(Opt) Temp1 VAR Data	[E-002C 128:2 002C303]
  U TRS(Opt) Temp1 Over RNG	[E-002C 128:3 002C304]
  U TRS(Opt) Temp1 Skip	[E-002C 128:4 002C305]
  U TRS(Opt) Temp1 Up LIM	[E-002C 129:0 002C306]
  U TRS(Opt) Temp1 DN LIM	[E-002C 129:1 002C307]
  U TRS(Opt) Temp1 VAR Up LIM	[E-002C 129:2 002C308]
  U TRS(Opt) Temp1 VAR DN LIM	[E-002C 129:3 002C309]
  U TRS(Opt) Temp1 CHNG RT Up	[E-002C 129:4 002C30A]
  U TRS(Opt) Temp1 CHNG RT DN	[E-002C 129:5 002C30B]
  U TRS(Opt) Temp2 Alarm Data	[E-002C 130:0 002C30D]
  U TRS(Opt) Temp2 NORM Data	[E-002C 130:1 002C30E]
  U TRS(Opt) Temp2 VAR Data	[E-002C 130:2 002C30F]
  U TRS(Opt) Temp2 Over RNG	[E-002C 130:3 002C310]
  U TRS(Opt) Temp2 Skip	[E-002C 130:4 002C311]
  U TRS(Opt) Temp2 Up LIM	[E-002C 131:0 002C312]
  U TRS(Opt) Temp2 DN LIM	[E-002C 131:1 002C313]
  U TRS(Opt) Temp2 VAR Up LIM	[E-002C 131:2 002C314]
  U TRS(Opt) Temp2 VAR DN LIM	[E-002C 131:3 002C315]
  U TRS(Opt) Temp2 CHNG RT Up	[E-002C 131:4 002C316]
  U TRS(Opt) Temp2 CHNG RT DN	[E-002C 131:5 002C317]
  U TRS(F) Temp1 Alarm Data	[E-002C 132:0 002C319]
  U TRS(F) Temp1 NORM Data	[E-002C 132:1 002C31A]
  U TRS(F) Temp1 VAR Data	[E-002C 132:2 002C31B]
  U TRS(F) Temp1 Over RNG	[E-002C 132:3 002C31C]
  U TRS(F) Temp1 Skip	[E-002C 132:4 002C31D]
  U TRS(F) Temp1 Up LIM	[E-002C 133:0 002C31E]
  U TRS(F) Temp1 DN LIM	[E-002C 133:1 002C31F]
  U TRS(F) Temp1 VAR Up LIM	[E-002C 133:2 002C320]
  U TRS(F) Temp1 VAR DN LIM	[E-002C 133:3 002C321]
  U TRS(F) Temp1 CHNG RT Up	[E-002C 133:4 002C322]
  U TRS(F) Temp1 CHNG RT DN	[E-002C 133:5 002C323]
  U TRS(F) Temp2 Alarm Data	[E-002C 134:0 002C325]
  U TRS(F) Temp2 NORM Data	[E-002C 134:1 002C326]
  U TRS(F) Temp2 VAR Data	[E-002C 134:2 002C327]
  U TRS(F) Temp2 Over RNG	[E-002C 134:3 002C328]
  U TRS(F) Temp2 Skip	[E-002C 134:4 002C329]
  U TRS(F) Temp2 Up LIM	[E-002C 135:0 002C32A]
  U TRS(F) Temp2 DN LIM	[E-002C 135:1 002C32B]
  U TRS(F) Temp2 VAR Up LIM	[E-002C 135:2 002C32C]
  U TRS(F) Temp2 VAR DN LIM	[E-002C 135:3 002C32D]
  U TRS(F) Temp2 CHNG RT Up	[E-002C 135:4 002C32E]
  U TRS(F) Temp2 CHNG RT DN	[E-002C 135:5 002C32F]
  U TRS(IR) Temp2 Alarm Data	[E-002C 136:0 002C331]
  U TRS(IR) Temp2 NORM Data	[E-002C 136:1 002C332]
  U TRS(IR) Temp2 VAR Data	[E-002C 136:2 002C333]
  U TRS(IR) Temp2 Over RNG	[E-002C 136:3 002C334]
  U TRS(IR) Temp2 Skip	[E-002C 136:4 002C335]
  U TRS(IR) Temp2 Up LIM	[E-002C 137:0 002C336]
  U TRS(IR) Temp2 DN LIM	[E-002C 137:1 002C337]
  U TRS(IR) Temp2 VAR Up LIM	[E-002C 137:2 002C338]
  U TRS(IR) Temp2 VAR DN LIM	[E-002C 137:3 002C339]
  U TRS(IR) Temp2 CHNG RT Up	[E-002C 137:4 002C33A]
  U TRS(IR) Temp2 CHNG RT DN	[E-002C 137:5 002C33B]
  U TRS(IR) Temp1 Alarm Data	[E-002C 138:0 002C33D]
  U TRS(IR) Temp1 NORM Data	[E-002C 138:1 002C33E]
  U TRS(IR) Temp1 VAR Data	[E-002C 138:2 002C33F]
  U TRS(IR) Temp1 Over RNG	[E-002C 138:3 002C340]
  U TRS(IR) Temp1 Skip	[E-002C 138:4 002C341]
  U TRS(IR) Temp1 Up LIM	[E-002C 139:0 002C342]
  U TRS(IR) Temp1 DN LIM	[E-002C 139:1 002C343]
  U TRS(IR) Temp1 VAR Up LIM	[E-002C 139:2 002C344]
  U TRS(IR) Temp1 VAR DN LIM	[E-002C 139:3 002C345]
  U TRS(IR) Temp1 CHNG RT Up	[E-002C 139:4 002C346]
  U TRS(IR) Temp1 CHNG RT DN	[E-002C 139:5 002C347]
  U TRS(R) Temp2 Alarm Data	[E-002C 140:0 002C349]
  U TRS(R) Temp2 NORM Data	[E-002C 140:1 002C34A]
  U TRS(R) Temp2 VAR Data	[E-002C 140:2 002C34B]
  U TRS(R) Temp2 Over RNG	[E-002C 140:3 002C34C]
  U TRS(R) Temp2 Skip	[E-002C 140:4 002C34D]
  U TRS(R) Temp2 Up LIM	[E-002C 141:0 002C34E]
  U TRS(R) Temp2 DN LIM	[E-002C 141:1 002C34F]
  U TRS(R) Temp2 VAR Up LIM	[E-002C 141:2 002C350]
  U TRS(R) Temp2 VAR DN LIM	[E-002C 141:3 002C351]
  U TRS(R) Temp2 CHNG RT Up	[E-002C 141:4 002C352]
  U TRS(R) Temp2 CHNG RT DN	[E-002C 141:5 002C353]
  CSCT(R) Temp Alarm Data	[E-002C 142:0 002C355]
  CSCT(R) Temp NORM Data	[E-002C 142:1 002C356]
  CSCT(R) Temp VAR Data	[E-002C 142:2 002C357]
  CSCT(R) Temp Over RNG	[E-002C 142:3 002C358]
  CSCT(R) Temp Skip	[E-002C 142:4 002C359]
  CSCT(R) Temp Up LIM	[E-002C 143:0 002C35A]
  CSCT(R) Temp DN LIM	[E-002C 143:1 002C35B]
  CSCT(R) Temp VAR Up LIM	[E-002C 143:2 002C35C]
  CSCT(R) Temp VAR DN LIM	[E-002C 143:3 002C35D]
  CSCT(R) Temp CHNG RT Up	[E-002C 143:4 002C35E]
  CSCT(R) Temp CHNG RT DN	[E-002C 143:5 002C35F]
  CSCT(Opt-U) Temp Alarm Data	[E-002C 144:0 002C361]
  CSCT(Opt-U) Temp NORM Data	[E-002C 144:1 002C362]
  CSCT(Opt-U) Temp VAR Data	[E-002C 144:2 002C363]
  CSCT(Opt-U) Temp Over RNG	[E-002C 144:3 002C364]
  CSCT(Opt-U) Temp Skip	[E-002C 144:4 002C365]
  CSCT(Opt-U) Temp Up LIM	[E-002C 145:0 002C366]
  CSCT(Opt-U) Temp DN LIM	[E-002C 145:1 002C367]
  CSCT(Opt-U) Temp VAR Up LIM	[E-002C 145:2 002C368]
  CSCT(Opt-U) Temp VAR DN LIM	[E-002C 145:3 002C369]
  CSCT(Opt-U) Temp CHNG RT Up	[E-002C 145:4 002C36A]
  CSCT(Opt-U) Temp CHNG RT DN	[E-002C 145:5 002C36B]
  CSCT(Opt-L) Temp Alarm Data	[E-002C 146:0 002C36D]
  CSCT(Opt-L) Temp NORM Data	[E-002C 146:1 002C36E]
  CSCT(Opt-L) Temp VAR Data	[E-002C 146:2 002C36F]
  CSCT(Opt-L) Temp Over RNG	[E-002C 146:3 002C370]
  CSCT(Opt-L) Temp Skip	[E-002C 146:4 002C371]
  CSCT(Opt-L) Temp Up LIM	[E-002C 147:0 002C372]
  CSCT(Opt-L) Temp DN LIM	[E-002C 147:1 002C373]
  CSCT(Opt-L) Temp VAR Up LIM	[E-002C 147:2 002C374]
  CSCT(Opt-L) Temp VAR DN LIM	[E-002C 147:3 002C375]
  CSCT(Opt-L) Temp CHNG RT Up	[E-002C 147:4 002C376]
  CSCT(Opt-L) Temp CHNG RT DN	[E-002C 147:5 002C377]
  CSCT(F) Temp Alarm Data	[E-002C 148:0 002C379]
  CSCT(F) Temp NORM Data	[E-002C 148:1 002C37A]
  CSCT(F) Temp VAR Data	[E-002C 148:2 002C37B]
  CSCT(F) Temp Over RNG	[E-002C 148:3 002C37C]
  CSCT(F) Temp Skip	[E-002C 148:4 002C37D]
  CSCT(F) Temp Up LIM	[E-002C 149:0 002C37E]
  CSCT(F) Temp DN LIM	[E-002C 149:1 002C37F]
  CSCT(F) Temp VAR Up LIM	[E-002C 149:2 002C380]
  CSCT(F) Temp VAR DN LIM	[E-002C 149:3 002C381]
  CSCT(F) Temp CHNG RT Up	[E-002C 149:4 002C382]
  CSCT(F) Temp CHNG RT DN	[E-002C 149:5 002C383]
  CSCT(IR-U) Temp1 Alarm Data	[E-002C 150:0 002C385]
  CSCT(IR-U) Temp1 NORM Data	[E-002C 150:1 002C386]
  CSCT(IR-U) Temp1 VAR Data	[E-002C 150:2 002C387]
  CSCT(IR-U) Temp1 Over RNG	[E-002C 150:3 002C388]
  CSCT(IR-U) Temp1 Skip	[E-002C 150:4 002C389]
  CSCT(IR-U) Temp Up LIM	[E-002C 151:0 002C38A]
  CSCT(IR-U) Temp DN LIM	[E-002C 151:1 002C38B]
  CSCT(IR-U) Temp VAR Up LIM	[E-002C 151:2 002C38C]
  CSCT(IR-U) Temp VAR DN LIM	[E-002C 151:3 002C38D]
  CSCT(IR-U) Temp CHNG RT Up	[E-002C 151:4 002C38E]
  CSCT(IR-U) Temp CHNG RT DN	[E-002C 151:5 002C38F]
  CSCT(IR-L) Temp Alarm Data	[E-002C 152:0 002C391]
  CSCT(IR-L) Temp NORM Data	[E-002C 152:1 002C392]
  CSCT(IR-L) Temp VAR Data	[E-002C 152:2 002C393]
  CSCT(IR-L) Temp Over RNG	[E-002C 152:3 002C394]
  CSCT(IR-L) Temp Skip	[E-002C 152:4 002C395]
  CSCT(IR-L) Temp Up LIM	[E-002C 153:0 002C396]
  CSCT(IR-L) Temp DN LIM	[E-002C 153:1 002C397]
  CSCT(IR-L) Temp VAR Up LIM	[E-002C 153:2 002C398]
  CSCT(IR-L) Temp VAR DN LIM	[E-002C 153:3 002C399]
  CSCT(IR-L) Temp CHNG RT Up	[E-002C 153:4 002C39A]
  CSCT(IR-L) Temp CHNG RT DN	[E-002C 153:5 002C39B]
  L TRS(R) Temp1 Alarm Data	[E-002C 154:0 002C39D]
  L TRS(R) Temp1 NORM Data	[E-002C 154:1 002C39E]
  L TRS(R) Temp1 VAR Data	[E-002C 154:2 002C39F]
  L TRS(R) Temp1 Over RNG	[E-002C 154:3 002C3A0]
  L TRS(R) Temp1 Skip	[E-002C 154:4 002C3A1]
  L TRS(R) Temp1 Up LIM	[E-002C 155:0 002C3A2]
  L TRS(R) Temp1 DN LIM	[E-002C 155:1 002C3A3]
  L TRS(R) Temp1 VAR Up LIM	[E-002C 155:2 002C3A4]
  L TRS(R) Temp1 VAR DN LIM	[E-002C 155:3 002C3A5]
  L TRS(R) Temp1 CHNG RT Up	[E-002C 155:4 002C3A6]
  L TRS(R) Temp1 CHNG RT DN	[E-002C 155:5 002C3A7]
  L TRS(Opt) Temp1 Alarm Data	[E-002C 156:0 002C3A9]
  L TRS(Opt) Temp1 NORM Data	[E-002C 156:1 002C3AA]
  L TRS(Opt) Temp1 VAR Data	[E-002C 156:2 002C3AB]
  L TRS(Opt) Temp1 Over RNG	[E-002C 156:3 002C3AC]
  L TRS(Opt) Temp1 Skip	[E-002C 156:4 002C3AD]
  L TRS(Opt) Temp1 Up LIM	[E-002C 157:0 002C3AE]
  L TRS(Opt) Temp1 DN LIM	[E-002C 157:1 002C3AF]
  L TRS(Opt) Temp1 VAR Up LIM	[E-002C 157:2 002C3B0]
  L TRS(Opt) Temp1 VAR DN LIM	[E-002C 157:3 002C3B1]
  L TRS(Opt) Temp1 CHNG RT Up	[E-002C 157:4 002C3B2]
  L TRS(Opt) Temp1 CHNG RT DN	[E-002C 157:5 002C3B3]
  L TRS(Opt) Temp2 Alarm Data	[E-002C 158:0 002C3B5]
  L TRS(Opt) Temp2 NORM Data	[E-002C 158:1 002C3B6]
  L TRS(Opt) Temp2 VAR Data	[E-002C 158:2 002C3B7]
  L TRS(Opt) Temp2 Over RNG	[E-002C 158:3 002C3B8]
  L TRS(Opt) Temp2 Skip	[E-002C 158:4 002C3B9]
  L TRS(Opt) Temp2 Up LIM	[E-002C 159:0 002C3BA]
  L TRS(Opt) Temp2 DN LIM	[E-002C 159:1 002C3BB]
  L TRS(Opt) Temp2 VAR Up LIM	[E-002C 159:2 002C3BC]
  L TRS(Opt) Temp2 VAR DN LIM	[E-002C 159:3 002C3BD]
  L TRS(Opt) Temp2 CHNG RT Up	[E-002C 159:4 002C3BE]
  L TRS(Opt) Temp2 CHNG RT DN	[E-002C 159:5 002C3BF]
  L TRS(Opt) Temp3 Alarm Data	[E-002C 160:0 002C3C1]
  L TRS(Opt) Temp3 NORM Data	[E-002C 160:1 002C3C2]
  L TRS(Opt) Temp3 VAR Data	[E-002C 160:2 002C3C3]
  L TRS(Opt) Temp3 Over RNG	[E-002C 160:3 002C3C4]
  L TRS(Opt) Temp3 Skip	[E-002C 160:4 002C3C5]
  L TRS(Opt) Temp3 Up LIM	[E-002C 161:0 002C3C6]
  L TRS(Opt) Temp3 DN LIM	[E-002C 161:1 002C3C7]
  L TRS(Opt) Temp3 VAR Up LIM	[E-002C 161:2 002C3C8]
  L TRS(Opt) Temp3 VAR DN LIM	[E-002C 161:3 002C3C9]
  L TRS(Opt) Temp3 CHNG RT Up	[E-002C 161:4 002C3CA]
  L TRS(Opt) Temp3 CHNG RT DN	[E-002C 161:5 002C3CB]
  L TRS(Opt) Temp4 Alarm Data	[E-002C 162:0 002C3CD]
  L TRS(Opt) Temp4 NORM Data	[E-002C 162:1 002C3CE]
  L TRS(Opt) Temp4 VAR Data	[E-002C 162:2 002C3CF]
  L TRS(Opt) Temp4 Over RNG	[E-002C 162:3 002C3D0]
  L TRS(Opt) Temp4 Skip	[E-002C 162:4 002C3D1]
  L TRS(Opt) Temp4 Up LIM	[E-002C 163:0 002C3D2]
  L TRS(Opt) Temp4 DN LIM	[E-002C 163:1 002C3D3]
  L TRS(Opt) Temp4 VAR Up LIM	[E-002C 163:2 002C3D4]
  L TRS(Opt) Temp4 VAR DN LIM	[E-002C 163:3 002C3D5]
  L TRS(Opt) Temp4 CHNG RT Up	[E-002C 163:4 002C3D6]
  L TRS(Opt) Temp4 CHNG RT DN	[E-002C 163:5 002C3D7]
  L TRS(F) Temp1 Alarm Data	[E-002C 164:0 002C3D9]
  L TRS(F) Temp1 NORM Data	[E-002C 164:1 002C3DA]
  L TRS(F) Temp1 VAR Data	[E-002C 164:2 002C3DB]
  L TRS(F) Temp1 Over RNG	[E-002C 164:3 002C3DC]
  L TRS(F) Temp1 Skip	[E-002C 164:4 002C3DD]
  L TRS(F) Temp1 Up LIM	[E-002C 165:0 002C3DE]
  L TRS(F) Temp1 DN LIM	[E-002C 165:1 002C3DF]
  L TRS(F) Temp1 VAR Up LIM	[E-002C 165:2 002C3E0]
  L TRS(F) Temp1 VAR DN LIM	[E-002C 165:3 002C3E1]
  L TRS(F) Temp1 CHNG RT Up	[E-002C 165:4 002C3E2]
  L TRS(F) Temp1 CHNG RT DN	[E-002C 165:5 002C3E3]
  L TRS(F) Temp2 Alarm Data	[E-002C 166:0 002C3E5]
  L TRS(F) Temp2 NORM Data	[E-002C 166:1 002C3E6]
  L TRS(F) Temp2 VAR Data	[E-002C 166:2 002C3E7]
  L TRS(F) Temp2 Over RNG	[E-002C 166:3 002C3E8]
  L TRS(F) Temp2 Skip	[E-002C 166:4 002C3E9]
  L TRS(F) Temp2 Up LIM	[E-002C 167:0 002C3EA]
  L TRS(F) Temp2 DN LIM	[E-002C 167:1 002C3EB]
  L TRS(F) Temp2 VAR Up LIM	[E-002C 167:2 002C3EC]
  L TRS(F) Temp2 VAR DN LIM	[E-002C 167:3 002C3ED]
  L TRS(F) Temp2 CHNG RT Up	[E-002C 167:4 002C3EE]
  L TRS(F) Temp2 CHNG RT DN	[E-002C 167:5 002C3EF]
  L TRS(IR) Temp4 Alarm Data	[E-002C 168:0 002C3F1]
  L TRS(IR) Temp4 NORM Data	[E-002C 168:1 002C3F2]
  L TRS(IR) Temp4 VAR Data	[E-002C 168:2 002C3F3]
  L TRS(IR) Temp4 Over RNG	[E-002C 168:3 002C3F4]
  L TRS(IR) Temp4 Skip	[E-002C 168:4 002C3F5]
  L TRS(IR) Temp4 Up LIM	[E-002C 169:0 002C3F6]
  L TRS(IR) Temp4 DN LIM	[E-002C 169:1 002C3F7]
  L TRS(IR) Temp4 VAR Up LIM	[E-002C 169:2 002C3F8]
  L TRS(IR) Temp4 VAR DN LIM	[E-002C 169:3 002C3F9]
  L TRS(IR) Temp4 CHNG RT Up	[E-002C 169:4 002C3FA]
  L TRS(IR) Temp4 CHNG RT DN	[E-002C 169:5 002C3FB]
  L TRS(IR) Temp3 Alarm Data	[E-002C 170:0 002C3FD]
  L TRS(IR) Temp3 NORM Data	[E-002C 170:1 002C3FE]
  L TRS(IR) Temp3 VAR Data	[E-002C 170:2 002C3FF]
  L TRS(IR) Temp3 Over RNG	[E-002C 170:3 002C400]
  L TRS(IR) Temp3 Skip	[E-002C 170:4 002C401]
  L TRS(IR) Temp3 Up LIM	[E-002C 171:0 002C402]
  L TRS(IR) Temp3 DN LIM	[E-002C 171:1 002C403]
  L TRS(IR) Temp3 VAR Up LIM	[E-002C 171:2 002C404]
  L TRS(IR) Temp3 VAR DN LIM	[E-002C 171:3 002C405]
  L TRS(IR) Temp3 CHNG RT Up	[E-002C 171:4 002C406]
  L TRS(IR) Temp3 CHNG RT DN	[E-002C 171:5 002C407]
  L TRS(IR) Temp2 Alarm Data	[E-002C 172:0 002C409]
  L TRS(IR) Temp2 NORM Data	[E-002C 172:1 002C40A]
  L TRS(IR) Temp2 VAR Data	[E-002C 172:2 002C40B]
  L TRS(IR) Temp2 Over RNG	[E-002C 172:3 002C40C]
  L TRS(IR) Temp2 Skip	[E-002C 172:4 002C40D]
  L TRS(IR) Temp2 Up LIM	[E-002C 173:0 002C40E]
  L TRS(IR) Temp2 DN LIM	[E-002C 173:1 002C40F]
  L TRS(IR) Temp2 VAR Up LIM	[E-002C 173:2 002C410]
  L TRS(IR) Temp2 VAR DN LIM	[E-002C 173:3 002C411]
  L TRS(IR) Temp2 CHNG RT Up	[E-002C 173:4 002C412]
  L TRS(IR) Temp2 CHNG RT DN	[E-002C 173:5 002C413]
  L TRS(IR) Temp1 Alarm Data	[E-002C 174:0 002C415]
  L TRS(IR) Temp1 NORM Data	[E-002C 174:1 002C416]
  L TRS(IR) Temp1 VAR Data	[E-002C 174:2 002C417]
  L TRS(IR) Temp1 Over RNG	[E-002C 174:3 002C418]
  L TRS(IR) Temp1 Skip	[E-002C 174:4 002C419]
  L TRS(IR) Temp1 Up LIM	[E-002C 175:0 002C41A]
  L TRS(IR) Temp1 DN LIM	[E-002C 175:1 002C41B]
  L TRS(IR) Temp1 VAR Up LIM	[E-002C 175:2 002C41C]
  L TRS(IR) Temp1 VAR DN LIM	[E-002C 175:3 002C41D]
  L TRS(IR) Temp1 CHNG RT Up	[E-002C 175:4 002C41E]
  L TRS(IR) Temp1 CHNG RT DN	[E-002C 175:5 002C41F]
  L TRS(R) Temp2 Alarm Data	[E-002C 176:0 002C421]
  L TRS(R) Temp2 NORM Data	[E-002C 176:1 002C422]
  L TRS(R) Temp2 VAR Data	[E-002C 176:2 002C423]
  L TRS(R) Temp2 Over RNG	[E-002C 176:3 002C424]
  L TRS(R) Temp2 Skip	[E-002C 176:4 002C425]
  L TRS(R) Temp2 Up LIM	[E-002C 177:0 002C426]
  L TRS(R) Temp2 DN LIM	[E-002C 177:1 002C427]
  L TRS(R) Temp2 VAR Up LIM	[E-002C 177:2 002C428]
  L TRS(R) Temp2 VAR DN LIM	[E-002C 177:3 002C429]
  L TRS(R) Temp2 CHNG RT Up	[E-002C 177:4 002C42A]
  L TRS(R) Temp2 CHNG RT DN	[E-002C 177:5 002C42B]
  TLSCP ENVIR Alarm Data	[E-002C 178:0 002C42D]
  TLSCP ENVIR NORM Data	[E-002C 178:1 002C42E]
  TLSCP ENVIR VAR Data	[E-002C 178:2 002C42F]
  TLSCP ENVIR Over RNG	[E-002C 178:3 002C430]
  TLSCP ENVIR Skip	[E-002C 178:4 002C431]
  TLSCP ENVIR Up LIM	[E-002C 179:0 002C432]
  TLSCP ENVIR DN LIM	[E-002C 179:1 002C433]
  TLSCP ENVIR VAR Up LIM	[E-002C 179:2 002C434]
  TLSCP ENVIR VAR DN LIM	[E-002C 179:3 002C435]
  TLSCP ENVIR CHNG RT Up	[E-002C 179:4 002C436]
  TLSCP ENVIR CHNG RT DN	[E-002C 179:5 002C437]
  Top Ring(R) Temp(Air) Data	[L-002C 0 002C00C BCD6]
  Top Ring(F) Temp(Air) Data	[L-002C 6 002C018 BCD6]
  U TRS(R) Temp(Air) Data	[L-002C 12 002C024 BCD6]
  U TRS(F) Temp(Air) Data	[L-002C 18 002C030 BCD6]
  CSCT(R) Temp(Air) Data	[L-002C 24 002C03C BCD6]
  CSCT(F) Temp(Air) Data	[L-002C 30 002C048 BCD6]
  AZBR Temp(Air) Data	[L-002C 36 002C054 BCD6]
  NsOpt Temp(Air)1 Data	[L-002C 42 002C060 BCD6]
  NsOpt Temp(Air)2 Data	[L-002C 48 002C06C BCD6]
  NsOpt Temp(Air)3 Data	[L-002C 54 002C078 BCD6]
  NsOpt Temp(Air)4 Data	[L-002C 60 002C084 BCD6]
  NsIR Temp(Air) Data	[L-002C 66 002C090 BCD6]
  Duct(IR) Temp(Air) Data	[L-002C 72 002C09C BCD6]
  Duct(Opt) Temp(Air) Data	[L-002C 78 002C0A8 BCD6]
  Cell(R) Temp(Air) Data	[L-002C 84 002C0B4 BCD6]
  Cell(Opt) Temp(Air) Data	[L-002C 90 002C0C0 BCD6]
  Cell(F) Temp(Air) Data	[L-002C 96 002C0CC BCD6]
  Cell(IR) Temp(Air) Data	[L-002C 102 002C0D8 BCD6]
  Cell(CNTR) Temp(Air) Data	[L-002C 108 002C0E4 BCD6]
  Top Ring HMD Data	[L-002C 114 002C0F0 BCD6]
  M3Frame HMD Data	[L-002C 120 002C0FC BCD6]
  AZBR HMD Data	[L-002C 126 002C108 BCD6]
  NsOpt(R) HMD Data	[L-002C 132 002C114 BCD6]
  NsOpt(F) HMD Data	[L-002C 138 002C120 BCD6]
  NsIR HMD Data	[L-002C 144 002C12C BCD6]
  Cell(R) HMD Data	[L-002C 150 002C138 BCD6]
  Cell(Opt) HMD Data	[L-002C 156 002C144 BCD6]
  Cell(F) HMD Data	[L-002C 162 002C150 BCD6]
  Cell(IR) HMD Data	[L-002C 168 002C15C BCD6]
  Cell(CNTR) HMD Data	[L-002C 174 002C168 BCD6]
  Top Ring(R) WVEL Data	[L-002C 180 002C174 BCD6]
  Top Ring(F) WVEL Data	[L-002C 186 002C180 BCD6]
  U TRS(R) WVEL Data	[L-002C 192 002C18C BCD6]
  U TRS(F) WVEL Data	[L-002C 198 002C198 BCD6]
  CSCT(F) WVEL(X) Data	[L-002C 204 002C1A4 BCD6]
  CSCT(F) WVEL(Y) Data	[L-002C 210 002C1B0 BCD6]
  CSCT(F) WVEL(Z) Data	[L-002C 216 002C1BC BCD6]
  CSCT(R) WVEL(X) Data	[L-002C 222 002C1C8 BCD6]
  CSCT(R) WVEL(Y) Data	[L-002C 228 002C1D4 BCD6]
  CSCT(R) WVEL(Z) Data	[L-002C 234 002C1E0 BCD6]
  TLSCP Fuse1 Data	[L-002C 240 002C1EC BCD6]
  TLSCP Fuse2 Data	[L-002C 246 002C1F8 BCD6]
  TLSCP FL Temp1 Data	[L-002C 252 002C204 BCD6]
  TLSCP FL Temp2 Data	[L-002C 258 002C210 BCD6]
  YORK(Opt) Temp1 Data	[L-002C 264 002C21C BCD6]
  YORK(Opt) Temp2 Data	[L-002C 270 002C228 BCD6]
  YORK(Opt) Temp3 Data	[L-002C 276 002C234 BCD6]
  YORK(Opt) Temp4 Data	[L-002C 282 002C240 BCD6]
  YORK(IR) Temp4 Data	[L-002C 288 002C24C BCD6]
  YORK(IR) Temp3 Data	[L-002C 294 002C258 BCD6]
  YORK(IR) Temp2 Data	[L-002C 300 002C264 BCD6]
  YORK(IR) Temp1 Data	[L-002C 306 002C270 BCD6]
  M1(R-S) Temp Data	[L-002C 312 002C27C BCD6]
  M1(R-B) Temp Data	[L-002C 318 002C288 BCD6]
  M1(Opt-S) Temp Data	[L-002C 324 002C294 BCD6]
  M1(Opt-B) Temp Data	[L-002C 330 002C2A0 BCD6]
  M1(F-S) Temp Data	[L-002C 336 002C2AC BCD6]
  M1(F-B) Temp Data	[L-002C 342 002C2B8 BCD6]
  M1(IR-S) Temp Data	[L-002C 348 002C2C4 BCD6]
  M1(IR-B) Temp Data	[L-002C 354 002C2D0 BCD6]
  Cell(8-61) Temp Data	[L-002C 360 002C2DC BCD6]
  Cell(8-62) Temp Data	[L-002C 366 002C2E8 BCD6]
  Cell(8-63) Temp Data	[L-002C 372 002C2F4 BCD6]
  U TRS(R) Temp1 Data	[L-002C 378 002C300 BCD6]
  U TRS(Opt) Temp1 Data	[L-002C 384 002C30C BCD6]
  U TRS(Opt) Temp2 Data	[L-002C 390 002C318 BCD6]
  U TRS(F) Temp1 Data	[L-002C 396 002C324 BCD6]
  U TRS(F) Temp2 Data	[L-002C 402 002C330 BCD6]
  U TRS(IR) Temp2 Data	[L-002C 408 002C33C BCD6]
  U TRS(IR) Temp1 Data	[L-002C 414 002C348 BCD6]
  U TRS(R) Temp2 Data	[L-002C 420 002C354 BCD6]
  CSCT(R) Temp Data	[L-002C 426 002C360 BCD6]
  CSCT(Opt-U) Temp Data	[L-002C 432 002C36C BCD6]
  CSCT(Opt-L) Temp Data	[L-002C 438 002C378 BCD6]
  CSCT(F) Temp Data	[L-002C 444 002C384 BCD6]
  CSCT(IR-U) Temp Data	[L-002C 450 002C390 BCD6]
  CSCT(IR-L) Temp Data	[L-002C 456 002C39C BCD6]
  L TRS(R) Temp1 Data	[L-002C 462 002C3A8 BCD6]
  L TRS(Opt) Temp1 Data	[L-002C 468 002C3B4 BCD6]
  L TRS(Opt) Temp2 Data	[L-002C 474 002C3C0 BCD6]
  L TRS(Opt) Temp3 Data	[L-002C 480 002C3CC BCD6]
  L TRS(Opt) Temp4 Data	[L-002C 486 002C3D8 BCD6]
  L TRS(F) Temp1 Data	[L-002C 492 002C3E4 BCD6]
  L TRS(F) Temp2 Data	[L-002C 498 002C3F0 BCD6]
  L TRS(IR) Temp4 Data	[L-002C 504 002C3FC BCD6]
  L TRS(IR) Temp3 Data	[L-002C 510 002C408 BCD6]
  L TRS(IR) Temp2 Data	[L-002C 516 002C414 BCD6]
  L TRS(IR) Temp1 Data	[L-002C 522 002C420 BCD6]
  L TRS(R) Temp2 Data	[L-002C 528 002C42C BCD6]
  TLSCP ENVIR Data	[L-002C 534 002C438 BCD6]
  Top Ring(R) CT2 Alarm Data CH1	[E-002D 0:0 002D001]
  Top Ring(R) CT2 NORM Data CH1	[E-002D 0:1 002D002]
  Top Ring(R) CT2 VAR Data CH1	[E-002D 0:2 002D003]
  Top Ring(R) CT2 OVER RNG CH1	[E-002D 0:3 002D004]
  Top Ring(R) CT2 Skip CH1	[E-002D 0:4 002D005]
  Top Ring(R) CT2 Up LIM CH1	[E-002D 1:0 002D006]
  Top Ring(R) CT2 DN LIM CH1	[E-002D 1:1 002D007]
  Top Ring(R) CT2 VAR Up LIM CH1	[E-002D 1:2 002D008]
  Top Ring(R) CT2 VAR DN LIM CH1	[E-002D 1:3 002D009]
  Top Ring(R) CT2 CHNG RT Up CH1	[E-002D 1:4 002D00A]
  Top Ring(R) CT2 CHNG RT DN CH1	[E-002D 1:5 002D00B]
  Top Ring(Opt) CT2 Alarm Data CH2	[E-002D 2:0 002D00D]
  Top Ring(Opt) CT2 NORM Data CH2	[E-002D 2:1 002D00E]
  Top Ring(Opt) CT2 VAR Data CH2	[E-002D 2:2 002D00F]
  Top Ring(Opt) CT2 OVER RNG CH2	[E-002D 2:3 002D010]
  Top Ring(Opt) CT2 Skip CH2	[E-002D 2:4 002D011]
  Top Ring(Opt) CT2 Up LIM CH2	[E-002D 3:0 002D012]
  Top Ring(Opt) CT2 DN LIM CH2	[E-002D 3:1 002D013]
  Top Ring(Opt) CT2 VAR Up LIM CH2	[E-002D 3:2 002D014]
  Top Ring(Opt) CT2 VAR DN LIM CH2	[E-002D 3:3 002D015]
  Top Ring(Opt) CT2 CHNG RT Up CH2	[E-002D 3:4 002D016]
  Top Ring(Opt) CT2 CHNG RT DN CH2	[E-002D 3:5 002D017]
  Top Ring(R) CT2 Alarm Data CH3	[E-002D 4:0 002D019]
  Top Ring(R) CT2 NORM Data CH3	[E-002D 4:1 002D01A]
  Top Ring(R) CT2 VAR Data CH3	[E-002D 4:2 002D01B]
  Top Ring(R) CT2 OVER RNG CH3	[E-002D 4:3 002D01C]
  Top Ring(R) CT2 Skip CH3	[E-002D 4:4 002D01D]
  Top Ring(R) CT2 Up LIM CH3	[E-002D 5:0 002D01E]
  Top Ring(R) CT2 DN LIM CH3	[E-002D 5:1 002D01F]
  Top Ring(R) CT2 VAR Up LIM CH3	[E-002D 5:2 002D020]
  Top Ring(R) CT2 VAR DN LIM CH3	[E-002D 5:3 002D021]
  Top Ring(R) CT2 CHNG RT Up CH3	[E-002D 5:4 002D022]
  Top Ring(R) CT2 CHNG RT DN CH3	[E-002D 5:5 002D023]
  Top Ring(Opt) CT2 Alarm Data CH4	[E-002D 6:0 002D025]
  Top Ring(Opt) CT2 NORM Data CH4	[E-002D 6:1 002D026]
  Top Ring(Opt) CT2 VAR Data CH4	[E-002D 6:2 002D027]
  Top Ring(Opt) CT2 OVER RNG CH4	[E-002D 6:3 002D028]
  Top Ring(Opt) CT2 Skip CH4	[E-002D 6:4 002D029]
  Top Ring(Opt) CT2 Up LIM CH4	[E-002D 7:0 002D02A]
  Top Ring(Opt) CT2 DN LIM CH4	[E-002D 7:1 002D02B]
  Top Ring(Opt) CT2 VAR Up LIM CH4	[E-002D 7:2 002D02C]
  Top Ring(Opt) CT2 VAR DN LIM CH4	[E-002D 7:3 002D02D]
  Top Ring(Opt) CT2 CHNG RT Up CH4	[E-002D 7:4 002D02E]
  Top Ring(Opt) CT2 CHNG RT DN CH4	[E-002D 7:5 002D02F]
  Top Ring(F) CT2 Alarm Data CH11	[E-002D 8:0 002D031]
  Top Ring(F) CT2 NORM Data CH11	[E-002D 8:1 002D032]
  Top Ring(F) CT2 VAR Data CH11	[E-002D 8:2 002D033]
  Top Ring(F) CT2 OVER RNG CH11	[E-002D 8:3 002D034]
  Top Ring(F) CT2 Skip CH11	[E-002D 8:4 002D035]
  Top Ring(F) CT2 Up LIM CH11	[E-002D 9:0 002D036]
  Top Ring(F) CT2 DN LIM CH11	[E-002D 9:1 002D037]
  Top Ring(F) CT2 VAR Up LIM CH11	[E-002D 9:2 002D038]
  Top Ring(F) CT2 VAR DN LIM CH11	[E-002D 9:3 002D039]
  Top Ring(F) CT2 CHNG RT Up CH11	[E-002D 9:4 002D03A]
  Top Ring(F) CT2 CHNG RT DN CH11	[E-002D 9:5 002D03B]
  Top Ring(IR) CT2 Alarm Data CH12	[E-002D 10:0 002D03D]
  Top Ring(IR) CT2 NORM Data CH12	[E-002D 10:1 002D03E]
  Top Ring(IR) CT2 VAR Data CH12	[E-002D 10:2 002D03F]
  Top Ring(IR) CT2 OVER RNG CH12	[E-002D 10:3 002D040]
  Top Ring(IR) CT2 Skip CH12	[E-002D 10:4 002D041]
  Top Ring(IR) CT2 Up LIM CH12	[E-002D 11:0 002D042]
  Top Ring(IR) CT2 DN LIM CH12	[E-002D 11:1 002D043]
  Top Ring(IR) CT2 VAR Up LIM CH12	[E-002D 11:2 002D044]
  Top Ring(IR) CT2 VAR DN LIM CH12	[E-002D 11:3 002D045]
  Top Ring(IR) CT2 CHNG RT Up CH12	[E-002D 11:4 002D046]
  Top Ring(IR) CT2 CHNG RT DN CH12	[E-002D 11:5 002D047]
  Top Ring(F) CT2 Alarm Data CH13	[E-002D 12:0 002D049]
  Top Ring(F) CT2 NORM Data CH13	[E-002D 12:1 002D04A]
  Top Ring(F) CT2 VAR Data CH13	[E-002D 12:2 002D04B]
  Top Ring(F) CT2 OVER RNG CH13	[E-002D 12:3 002D04C]
  Top Ring(F) CT2 Skip CH13	[E-002D 12:4 002D04D]
  Top Ring(F) CT2 Up LIM CH13	[E-002D 13:0 002D04E]
  Top Ring(F) CT2 DN LIM CH13	[E-002D 13:1 002D04F]
  Top Ring(F) CT2 VAR Up LIM CH13	[E-002D 13:2 002D050]
  Top Ring(F) CT2 VAR DN LIM CH13	[E-002D 13:3 002D051]
  Top Ring(F) CT2 CHNG RT Up CH13	[E-002D 13:4 002D052]
  Top Ring(F) CT2 CHNG RT DN CH13	[E-002D 13:5 002D053]
  Top Ring(IR) CT2 Alarm Data CH14	[E-002D 14:0 002D055]
  Top Ring(IR) CT2 NORM Data CH14	[E-002D 14:1 002D056]
  Top Ring(IR) CT2 VAR Data CH14	[E-002D 14:2 002D057]
  Top Ring(IR) CT2 OVER RNG CH14	[E-002D 14:3 002D058]
  Top Ring(IR) CT2 Skip CH14	[E-002D 14:4 002D059]
  Top Ring(IR) CT2 Up LIM CH14	[E-002D 15:0 002D05A]
  Top Ring(IR) CT2 DN LIM CH14	[E-002D 15:1 002D05B]
  Top Ring(IR) CT2 VAR Up LIM CH14	[E-002D 15:2 002D05C]
  Top Ring(IR) CT2 VAR DN LIM CH14	[E-002D 15:3 002D05D]
  Top Ring(IR) CT2 CHNG RT Up CH14	[E-002D 15:4 002D05E]
  Top Ring(IR) CT2 CHNG RT DN CH14	[E-002D 15:5 002D05F]
  TRS(R-Opt) CT2 Alarm Data CH21	[E-002D 16:0 002D061]
  TRS(R-Opt) CT2 NORM Data CH21	[E-002D 16:1 002D062]
  TRS(R-Opt) CT2 VAR Data CH21	[E-002D 16:2 002D063]
  TRS(R-Opt) CT2 OVER RNG CH21	[E-002D 16:3 002D064]
  TRS(R-Opt) CT2 Skip CH21	[E-002D 16:4 002D065]
  TRS(R-Opt) CT2 Up LIM CH21	[E-002D 17:0 002D066]
  TRS(R-Opt) CT2 DN LIM CH21	[E-002D 17:1 002D067]
  TRS(R-Opt) CT2 VAR Up LIM CH21	[E-002D 17:2 002D068]
  TRS(R-Opt) CT2 VAR DN LIM CH21	[E-002D 17:3 002D069]
  TRS(R-Opt) CT2 CHNG RT Up CH21	[E-002D 17:4 002D06A]
  TRS(R-Opt) CT2 CHNG RT DN CH21	[E-002D 17:5 002D06B]
  TRS(F-Opt) CT2 Alarm Data CH22	[E-002D 18:0 002D06D]
  TRS(F-Opt) CT2 NORM Data CH22	[E-002D 18:1 002D06E]
  TRS(F-Opt) CT2 VAR Data CH22	[E-002D 18:2 002D06F]
  TRS(F-Opt) CT2 OVER RNG CH22	[E-002D 18:3 002D070]
  TRS(F-Opt) CT2 Skip CH22	[E-002D 18:4 002D071]
  TRS(F-Opt) CT2 Up LIM CH22	[E-002D 19:0 002D072]
  TRS(F-Opt) CT2 DN LIM CH22	[E-002D 19:1 002D073]
  TRS(F-Opt) CT2 VAR Up LIM CH22	[E-002D 19:2 002D074]
  TRS(F-Opt) CT2 VAR DN LIM CH22	[E-002D 19:3 002D075]
  TRS(F-Opt) CT2 CHNG RT Up CH22	[E-002D 19:4 002D076]
  TRS(F-Opt) CT2 CHNG RT DN CH22	[E-002D 19:5 002D077]
  CSCT(R-IR) CT2 Alarm Data CH23	[E-002D 20:0 002D079]
  CSCT(R-IR) CT2 NORM Data CH23	[E-002D 20:1 002D07A]
  CSCT(R-IR) CT2 VAR Data CH23	[E-002D 20:2 002D07B]
  CSCT(R-IR) CT2 OVER RNG CH23	[E-002D 20:3 002D07C]
  CSCT(R-IR) CT2 Skip CH23	[E-002D 20:4 002D07D]
  CSCT(R-IR) CT2 Up LIM CH23	[E-002D 21:0 002D07E]
  CSCT(R-IR) CT2 DN LIM CH23	[E-002D 21:1 002D07F]
  CSCT(R-IR) CT2 VAR Up LIM CH23	[E-002D 21:2 002D080]
  CSCT(R-IR) CT2 VAR DN LIM CH23	[E-002D 21:3 002D081]
  CSCT(R-IR) CT2 CHNG RT Up CH23	[E-002D 21:4 002D082]
  CSCT(R-IR) CT2 CHNG RT DN CH23	[E-002D 21:5 002D083]
  CSCT(R-Opt) CT2 Alarm Data CH24	[E-002D 22:0 002D085]
  CSCT(R-Opt) CT2 NORM Data CH24	[E-002D 22:1 002D086]
  CSCT(R-Opt) CT2 VAR Data CH24	[E-002D 22:2 002D087]
  CSCT(R-Opt) CT2 OVER RNG CH24	[E-002D 22:3 002D088]
  CSCT(R-Opt) CT2 Skip CH24	[E-002D 22:4 002D089]
  CSCT(R-Opt) CT2 Up LIM CH24	[E-002D 23:0 002D08A]
  CSCT(R-Opt) CT2 DN LIM CH24	[E-002D 23:1 002D08B]
  CSCT(R-Opt) CT2 VAR Up LIM CH24	[E-002D 23:2 002D08C]
  CSCT(R-Opt) CT2 VAR DN LIM CH24	[E-002D 23:3 002D08D]
  CSCT(R-Opt) CT2 CHNG RT Up CH24	[E-002D 23:4 002D08E]
  CSCT(R-Opt) CT2 CHNG RT DN CH24	[E-002D 23:5 002D08F]
  TRS(F-IR) CT2 Alarm Data CH31	[E-002D 24:0 002D091]
  TRS(F-IR) CT2 NORM Data CH31	[E-002D 24:1 002D092]
  TRS(F-IR) CT2 VAR Data CH31	[E-002D 24:2 002D093]
  TRS(F-IR) CT2 OVER RNG CH31	[E-002D 24:3 002D094]
  TRS(F-IR) CT2 Skip CH31	[E-002D 24:4 002D095]
  TRS(F-IR) CT2 Up LIM CH31	[E-002D 25:0 002D096]
  TRS(F-IR) CT2 DN LIM CH31	[E-002D 25:1 002D097]
  TRS(F-IR) CT2 VAR Up LIM CH31	[E-002D 25:2 002D098]
  TRS(F-IR) CT2 VAR DN LIM CH31	[E-002D 25:3 002D099]
  TRS(F-IR) CT2 CHNG RT Up CH31	[E-002D 25:4 002D09A]
  TRS(F-IR) CT2 CHNG RT DN CH31	[E-002D 25:5 002D09B]
  TRS(R-IR) CT2 Alarm Data CH32	[E-002D 26:0 002D09D]
  TRS(R-IR) CT2 NORM Data CH32	[E-002D 26:1 002D09E]
  TRS(R-IR) CT2 VAR Data CH32	[E-002D 26:2 002D09F]
  TRS(R-IR) CT2 OVER RNG CH32	[E-002D 26:3 002D0A0]
  TRS(R-IR) CT2 Skip CH32	[E-002D 26:4 002D0A1]
  TRS(R-IR) CT2 Up LIM CH32	[E-002D 27:0 002D0A2]
  TRS(R-IR) CT2 DN LIM CH32	[E-002D 27:1 002D0A3]
  TRS(R-IR) CT2 VAR Up LIM CH32	[E-002D 27:2 002D0A4]
  TRS(R-IR) CT2 VAR DN LIM CH32	[E-002D 27:3 002D0A5]
  TRS(R-IR) CT2 CHNG RT Up CH32	[E-002D 27:4 002D0A6]
  TRS(R-IR) CT2 CHNG RT DN CH32	[E-002D 27:5 002D0A7]
  CSCT(R-IR) CT2 Alarm Data CH33	[E-002D 28:0 002D0A9]
  CSCT(R-IR) CT2 NORM Data CH33	[E-002D 28:1 002D0AA]
  CSCT(R-IR) CT2 VAR Data CH33	[E-002D 28:2 002D0AB]
  CSCT(R-IR) CT2 OVER RNG CH33	[E-002D 28:3 002D0AC]
  CSCT(R-IR) CT2 Skip CH33	[E-002D 28:4 002D0AD]
  CSCT(R-IR) CT2 Up LIM CH33	[E-002D 29:0 002D0AE]
  CSCT(R-IR) CT2 DN LIM CH33	[E-002D 29:1 002D0AF]
  CSCT(R-IR) CT2 VAR Up LIM CH33	[E-002D 29:2 002D0B0]
  CSCT(R-IR) CT2 VAR DN LIM CH33	[E-002D 29:3 002D0B1]
  CSCT(R-IR) CT2 CHNG RT Up CH33	[E-002D 29:4 002D0B2]
  CSCT(R-IR) CT2 CHNG RT DN CH33	[E-002D 29:5 002D0B3]
  CSCT(R-Opt) CT2 Alarm Data CH34	[E-002D 30:0 002D0B5]
  CSCT(R-Opt) CT2 NORM Data CH34	[E-002D 30:1 002D0B6]
  CSCT(R-Opt) CT2 VAR Data CH34	[E-002D 30:2 002D0B7]
  CSCT(R-Opt) CT2 OVER RNG CH34	[E-002D 30:3 002D0B8]
  CSCT(R-Opt) CT2 Skip CH34	[E-002D 30:4 002D0B9]
  CSCT(R-Opt) CT2 Up LIM CH34	[E-002D 31:0 002D0BA]
  CSCT(R-Opt) CT2 DN LIM CH34	[E-002D 31:1 002D0BB]
  CSCT(R-Opt) CT2 VAR Up LIM CH34	[E-002D 31:2 002D0BC]
  CSCT(R-Opt) CT2 VAR DN LIM CH34	[E-002D 31:3 002D0BD]
  CSCT(R-Opt) CT2 CHNG RT Up CH34	[E-002D 31:4 002D0BE]
  CSCT(R-Opt) CT2 CHNG RT DN CH34	[E-002D 31:5 002D0BF]
  CSCT(R-IR) CT2 Alarm Data CH41	[E-002D 32:0 002D0C1]
  CSCT(R-IR) CT2 NORM Data CH41	[E-002D 32:1 002D0C2]
  CSCT(R-IR) CT2 VAR Data CH41	[E-002D 32:2 002D0C3]
  CSCT(R-IR) CT2 OVER RNG CH41	[E-002D 32:3 002D0C4]
  CSCT(R-IR) CT2 Skip CH41	[E-002D 32:4 002D0C5]
  CSCT(R-IR) CT2 Up LIM CH41	[E-002D 33:0 002D0C6]
  CSCT(R-IR) CT2 DN LIM CH41	[E-002D 33:1 002D0C7]
  CSCT(R-IR) CT2 VAR Up LIM CH41	[E-002D 33:2 002D0C8]
  CSCT(R-IR) CT2 VAR DN LIM CH41	[E-002D 33:3 002D0C9]
  CSCT(R-IR) CT2 CHNG RT Up CH41	[E-002D 33:4 002D0CA]
  CSCT(R-IR) CT2 CHNG RT DN CH41	[E-002D 33:5 002D0CB]
  CSCT(R-Opt) CT2 Alarm Data CH42	[E-002D 34:0 002D0CD]
  CSCT(R-Opt) CT2 NORM Data CH42	[E-002D 34:1 002D0CE]
  CSCT(R-Opt) CT2 VAR Data CH42	[E-002D 34:2 002D0CF]
  CSCT(R-Opt) CT2 OVER RNG CH42	[E-002D 34:3 002D0D0]
  CSCT(R-Opt) CT2 Skip CH42	[E-002D 34:4 002D0D1]
  CSCT(R-Opt) CT2 Up LIM CH42	[E-002D 35:0 002D0D2]
  CSCT(R-Opt) CT2 DN LIM CH42	[E-002D 35:1 002D0D3]
  CSCT(R-Opt) CT2 VAR Up LIM CH42	[E-002D 35:2 002D0D4]
  CSCT(R-Opt) CT2 VAR DN LIM CH42	[E-002D 35:3 002D0D5]
  CSCT(R-Opt) CT2 CHNG RT Up CH42	[E-002D 35:4 002D0D6]
  CSCT(R-Opt) CT2 CHNG RT DN CH42	[E-002D 35:5 002D0D7]
  TLSCP CT2 CH43 Alarm Data CH43	[E-002D 36:0 002D0D9]
  TLSCP CT2 CH43 NORM Data CH43	[E-002D 36:1 002D0DA]
  TLSCP CT2 CH43 VAR Data CH43	[E-002D 36:2 002D0DB]
  TLSCP CT2 CH43 OVER RNG CH43	[E-002D 36:3 002D0DC]
  TLSCP CT2 CH43 Skip CH43	[E-002D 36:4 002D0DD]
  TLSCP CT2 CH43 Up LIM CH43	[E-002D 37:0 002D0DE]
  TLSCP CT2 CH43 DN LIM CH43	[E-002D 37:1 002D0DF]
  TLSCP CT2 CH43 VAR Up LIM CH43	[E-002D 37:2 002D0E0]
  TLSCP CT2 CH43 VAR DN LIM CH43	[E-002D 37:3 002D0E1]
  TLSCP CT2 CH43 CHNG RT Up CH43	[E-002D 37:4 002D0E2]
  TLSCP CT2 CH43 CHNG RT DN CH43	[E-002D 37:5 002D0E3]
  TLSCP CT2 CH44 Alarm Data CH44	[E-002D 38:0 002D0E5]
  TLSCP CT2 CH44 NORM Data CH44	[E-002D 38:1 002D0E6]
  TLSCP CT2 CH44 VAR Data CH44	[E-002D 38:2 002D0E7]
  TLSCP CT2 CH44 OVER RNG CH44	[E-002D 38:3 002D0E8]
  TLSCP CT2 CH44 Skip CH44	[E-002D 38:4 002D0E9]
  TLSCP CT2 CH44 Up LIM CH44	[E-002D 39:0 002D0EA]
  TLSCP CT2 CH44 DN LIM CH44	[E-002D 39:1 002D0EB]
  TLSCP CT2 CH44 VAR Up LIM CH44	[E-002D 39:2 002D0EC]
  TLSCP CT2 CH44 VAR DN LIM CH44	[E-002D 39:3 002D0ED]
  TLSCP CT2 CH44 CHNG RT Up CH44	[E-002D 39:4 002D0EE]
  TLSCP CT2 CH44 CHNG RT DN CH44	[E-002D 39:5 002D0EF]
  CSCT(F-Opt) CT2 Alarm Data CH51	[E-002D 40:0 002D0F1]
  CSCT(F-Opt) CT2 NORM Data CH51	[E-002D 40:1 002D0F2]
  CSCT(F-Opt) CT2 VAR Data CH51	[E-002D 40:2 002D0F3]
  CSCT(F-Opt) CT2 OVER RNG CH51	[E-002D 40:3 002D0F4]
  CSCT(F-Opt) CT2 Skip CH51	[E-002D 40:4 002D0F5]
  CSCT(F-Opt) CT2 Up LIM CH51	[E-002D 41:0 002D0F6]
  CSCT(F-Opt) CT2 DN LIM CH51	[E-002D 41:1 002D0F7]
  CSCT(F-Opt) CT2 VAR Up LIM CH51	[E-002D 41:2 002D0F8]
  CSCT(F-Opt) CT2 VAR DN LIM CH51	[E-002D 41:3 002D0F9]
  CSCT(F-Opt) CT2 CHNG RT Up CH51	[E-002D 41:4 002D0FA]
  CSCT(F-Opt) CT2 CHNG RT DN CH51	[E-002D 41:5 002D0FB]
  CSCT(F-IR) CT2 Alarm Data CH52	[E-002D 42:0 002D0FD]
  CSCT(F-IR) CT2 NORM Data CH52	[E-002D 42:1 002D0FE]
  CSCT(F-IR) CT2 VAR Data CH52	[E-002D 42:2 002D0FF]
  CSCT(F-IR) CT2 OVER RNG CH52	[E-002D 42:3 002D100]
  CSCT(F-IR) CT2 Skip CH52	[E-002D 42:4 002D101]
  CSCT(F-IR) CT2 Up LIM CH52	[E-002D 43:0 002D102]
  CSCT(F-IR) CT2 DN LIM CH52	[E-002D 43:1 002D103]
  CSCT(F-IR) CT2 VAR Up LIM CH52	[E-002D 43:2 002D104]
  CSCT(F-IR) CT2 VAR DN LIM CH52	[E-002D 43:3 002D105]
  CSCT(F-IR) CT2 CHNG RT Up CH52	[E-002D 43:4 002D106]
  CSCT(F-IR) CT2 CHNG RT DN CH52	[E-002D 43:5 002D107]
  Top Ring(R) CT2 Data CH1	[L-002D 0 002D00C BCD6]
  Top Ring(Opt) CT2 Data CH2	[L-002D 6 002D018 BCD6]
  Top Ring(R) CT2 Data CH3	[L-002D 12 002D024 BCD6]
  Top Ring(Opt) CT2 Data CH4	[L-002D 18 002D030 BCD6]
  Top Ring(F) CT2 Data CH11	[L-002D 24 002D03C BCD6]
  Top Ring(IR) CT2 Data CH12	[L-002D 30 002D048 BCD6]
  Top Ring(F) CT2 Data CH13	[L-002D 36 002D054 BCD6]
  Top Ring(IR) CT2 Data CH14	[L-002D 42 002D060 BCD6]
  TRS(R-Opt) CT2 Data CH21	[L-002D 48 002D06C BCD6]
  TRS(F-Opt) CT2 Data CH22	[L-002D 54 002D078 BCD6]
  CSCT(R-IR) CT2 Data CH23	[L-002D 60 002D084 BCD6]
  CSCT(R-Opt) CT2 Data CH24	[L-002D 66 002D090 BCD6]
  TRS(F-IR) CT2 Data CH31	[L-002D 72 002D09C BCD6]
  TRS(R-IR) CT2 Data CH32	[L-002D 78 002D0A8 BCD6]
  CSCT(R-IR) CT2 Data CH33	[L-002D 84 002D0B4 BCD6]
  CSCT(R-Opt) CT2 Data CH34	[L-002D 90 002D0C0 BCD6]
  CSCT(R-IR) CT2 Data CH41	[L-002D 96 002D0CC BCD6]
  CSCT(R-Opt) CT2 Data CH42	[L-002D 102 002D0D8 BCD6]
  TLSCP CT2 CH43 Data CH43	[L-002D 108 002D0E4 BCD6]
  TLSCP CT2 CH44 Data CH44	[L-002D 114 002D0F0 BCD6]
  CSCT(F-Opt) CT2 Data CH51	[L-002D 120 002D0FC BCD6]
  CSCT(F-IR) CT2 Data CH52	[L-002D 126 002D108 BCD6]
  Time GEN STBY	[E-002E 0:4 002E003]
  Time GEN Input Data Alarm on CLOCK	[E-002E 0:5 002E004]
  Time GEN Data Over Range	[E-002E 0:6 002E005]
  Time GEN Time	[L-002E 0 002E001 TIME6]
  Time GEN Freq S.D.	[L-002E 6 002E002 BINARY4_0p000000000001]
  IR Shutter PWR Supply Alarm	[E-0030 0:0 003001C]
  IR Shutter AMP 1X Alarm	[E-0030 0:1 003001D]
  IR Shutter AMP 1Y Alarm	[E-0030 0:2 003001E]
  LDP1-CP1 I/F Alarm	[E-0030 0:3 003016C]
  Shutter Open ANS	[E-0030 0:4 0030019]
  Shutter Close ANS	[E-0030 0:5 003001A]
  Shutter Stop ANS	[E-0030 0:6 003001B]
  CP1 Shutter Power On ANS	[E-0030 1:0 0030022]
  CP1 Shutter Power Off ANS	[E-0030 1:1 0030023]
  Opt Shutter PWR Supply Alarm	[E-0030 1:4 003001F]
  Opt Shutter AMP 2X Alarm	[E-0030 1:5 0030020]
  Opt Shutter AMP 2Y Alarm	[E-0030 1:6 0030021]
  LDP2-CP1 I/F Alarm	[E-0030 1:7 003016D]
  CP1 Shutter CP3 Selected	[E-0030 2:0 0030028]
  CP1 Shutter Local Selected	[E-0030 2:1 0030029]
  CP1 Shutter Off Selected	[E-0030 2:2 003002A]
  CP1 Shutter Remote Selected	[E-0030 2:3 003002B]
  Shutter IR Selected	[E-0030 2:4 0030024]
  Shutter Both Selected	[E-0030 2:5 0030025]
  Shutter Opt Selected	[E-0030 2:6 0030026]
  Shutter Drive Ready	[E-0030 2:7 0030027]
  IR Shutter Open Limit	[E-0030 3:0 0030030]
  IR Shutter Close Limit	[E-0030 3:1 0030031]
  Opt Shutter Open Limit	[E-0030 3:2 0030032]
  Opt Shutter Close Limit	[E-0030 3:3 0030033]
  IR Shutter Full Open	[E-0030 3:4 003002C]
  IR Shutter Full Close	[E-0030 3:5 003002D]
  Opt Shutter Full Open	[E-0030 3:6 003002E]
  Opt Shutter Full Close	[E-0030 3:7 003002F]
  LDP1 Local Selected	[E-0030 4:0 0030036]
  LDP1 Off Selected	[E-0030 4:1 0030037]
  LDP1 CP1 Selected	[E-0030 4:2 0030038]
  LDP1 Fault Reset	[E-0030 4:3 0030039]
  CP3 Shutter Radio Selected	[E-0030 4:4 0030034]
  CP3 Shutter Remote Selected	[E-0030 4:5 0030035]
  LDP2 Local Selected	[E-0030 5:0 003003D]
  LDP2 Off Selected	[E-0030 5:1 003003E]
  LDP2 CP1 Selected	[E-0030 5:2 003003F]
  LDP2 Fault Reset	[E-0030 5:3 0030040]
  LDP1 Top-X Selected	[E-0030 5:4 003003A]
  LDP1 Both Selected	[E-0030 5:5 003003B]
  LDP1 LEG-Y Selected	[E-0030 5:6 003003C]
  CP1 Wind Screen Power On	[E-0030 6:0 0030044]
  CP1 Wind Screen Power Off	[E-0030 6:1 0030045]
  Wind Screen Drive On	[E-0030 6:2 0030046]
  Wind Screen Drive Off	[E-0030 6:3 0030047]
  LDP2 Top-X Selected	[E-0030 6:4 0030041]
  LDP2 Both Selected	[E-0030 6:5 0030042]
  LDP2 LEG-Y Selected	[E-0030 6:6 0030043]
  CP1 Wind Screen Drive On Ready	[E-0030 7:0 003004C]
  CP1 Wind Screen Local Selected	[E-0030 7:1 003004D]
  CP1 Wind Screen Off Selected	[E-0030 7:2 003004E]
  CP1 Wind Screen Remote Selected	[E-0030 7:3 003004F]
  Wind Screen ENC Alarm	[E-0030 7:4 0030048]
  Wind Screen PWR Supply Alarm	[E-0030 7:5 0030049]
  Wind Screen AMP X Alarm	[E-0030 7:6 003004A]
  Wind Screen AMP Y Alarm	[E-0030 7:7 003004B]
  LDP4 Local Selected	[E-0030 8:0 0030054]
  LDP4 Off Selected	[E-0030 8:1 0030055]
  LDP4 CP1 Selected	[E-0030 8:2 0030056]
  LDP4 Fault Reset	[E-0030 8:3 0030057]
  Wind Screen Full Up	[E-0030 8:4 0030050]
  Wind Screen Full Down	[E-0030 8:5 0030051]
  Wind Screen Limit Up	[E-0030 8:6 0030052]
  Wind Screen Limit Down	[E-0030 8:7 0030053]
  Top Screen(F) ENC Alarm	[E-0030 9:0 003005C]
  Top Screen(R) ENC Alarm	[E-0030 9:1 003005D]
  Top Screen PWR Supply Alarm	[E-0030 9:2 003005E]
  CP1 Top Screen Power On	[E-0030 9:4 0030058]
  CP1 Top Screen Power Off	[E-0030 9:5 0030059]
  Top Screen Drive On	[E-0030 9:6 003005A]
  Top Screen Drive Off	[E-0030 9:7 003005B]
  Top Screen Rear Selected	[E-0030 10:0 0030061]
  Top Screen Both Selected	[E-0030 10:1 0030062]
  Top Screen Front Selected	[E-0030 10:2 0030063]
  Top Screen Drive On Ready	[E-0030 10:3 0030064]
  Top Screen AMP X Alarm	[E-0030 10:4 003005F]
  Top Screen AMP Y Alarm	[E-0030 10:5 0030060]
  Top Screen(F) Full FWD	[E-0030 11:0 0030069]
  Top Screen(F) Full RETR	[E-0030 11:1 003006A]
  Top Screen(R) Full FWD	[E-0030 11:2 003006B]
  Top Screen(R) Full RETR	[E-0030 11:3 003006C]
  CP1 Top Screen CP3 Selected	[E-0030 11:4 0030065]
  CP1 Top Screen Local Selected	[E-0030 11:5 0030066]
  CP1 Top Screen Off Selected	[E-0030 11:6 0030067]
  CP1 Top Screen Remote Selected	[E-0030 11:7 0030068]
  LDP3 Local Selected	[E-0030 12:0 0030071]
  LDP3 Off Selected	[E-0030 12:1 0030072]
  LDP3 CP1 Selected	[E-0030 12:2 0030073]
  LDP3 Fault Reset	[E-0030 12:3 0030074]
  Top Screen(F) Limit FWD	[E-0030 12:4 003006D]
  Top Screen(F) Limit RETR	[E-0030 12:5 003006E]
  Top Screen(R) Limit FWD	[E-0030 12:6 003006F]
  Top Screen(R) Limit RETR	[E-0030 12:7 0030070]
  CP2 Master Ready	[E-0030 13:0 0030078]
  CP2 Light On ANS	[E-0030 13:1 0030079]
  CP2 Light Off ANS	[E-0030 13:2 003007A]
  LDP3 Front-X Selected	[E-0030 13:4 0030075]
  LDP3 Both Selected	[E-0030 13:5 0030076]
  LDP3 Rear-Y Selected	[E-0030 13:6 0030077]
  Front V Full Open	[E-0030 14:0 003007D]
  Front V Full Close	[E-0030 14:1 003007E]
  Front V Ready	[E-0030 14:2 003007F]
  Front V Drive On	[E-0030 14:4 003007B]
  Front V Drive Off	[E-0030 14:5 003007C]
  CP2 Front V Remote Selected	[E-0030 15:2 0030080]
  Side V A1 Full Open	[E-0030 16:0 0030083]
  Side V A1 Full Close	[E-0030 16:1 0030084]
  Side V A1 Ready	[E-0030 16:2 0030085]
  Side V A Drive On	[E-0030 16:4 0030081]
  Side V A Drive Off	[E-0030 16:5 0030082]
  Side V A3 Full Open	[E-0030 17:0 0030089]
  Side V A3 Full Close	[E-0030 17:1 003008A]
  Side V A3 Ready	[E-0030 17:2 003008B]
  Side V A2 Full Open	[E-0030 17:4 0030086]
  Side V A2 Full Close	[E-0030 17:5 0030087]
  Side V A2 Ready	[E-0030 17:6 0030088]
  Side V A4 Full Open	[E-0030 18:0 003008C]
  Side V A4 Full Close	[E-0030 18:1 003008D]
  Side V A4 Ready	[E-0030 18:2 003008E]
  Side V B Drive On	[E-0030 19:0 0030090]
  Side V B Drive Off	[E-0030 19:1 0030091]
  CP2 Side V A Remote Selected	[E-0030 19:6 003008F]
  Side V B2 Full Open	[E-0030 20:0 0030095]
  Side V B2 Full Close	[E-0030 20:1 0030096]
  Side V B2 Ready	[E-0030 20:2 0030097]
  Side V B1 Full Open	[E-0030 20:4 0030092]
  Side V B1 Full Close	[E-0030 20:5 0030093]
  Side V B1 Ready	[E-0030 20:6 0030094]
  Side V B4 Full Open	[E-0030 21:0 003009B]
  Side V B4 Full Close	[E-0030 21:1 003009C]
  Side V B4 Ready	[E-0030 21:2 003009D]
  Side V B3 Full Open	[E-0030 21:4 0030098]
  Side V B3 Full Close	[E-0030 21:5 0030099]
  Side V B3 Ready	[E-0030 21:6 003009A]
  CP2 Side V B Remote Selected	[E-0030 22:2 003009E]
  Side V C1 Full Open	[E-0030 23:0 00300A1]
  Side V C1 Full Close	[E-0030 23:1 00300A2]
  Side V C1 Ready	[E-0030 23:2 00300A3]
  Side V C Drive On	[E-0030 23:4 003009F]
  Side V C Drive Off	[E-0030 23:5 00300A0]
  Side V C3 Full Open	[E-0030 24:0 00300A7]
  Side V C3 Full Close	[E-0030 24:1 00300A8]
  Side V C3 Ready	[E-0030 24:2 00300A9]
  Side V C2 Full Open	[E-0030 24:4 00300A4]
  Side V C2 Full Close	[E-0030 24:5 00300A5]
  Side V C2 Ready	[E-0030 24:6 00300A6]
  Side V C4 Full Open	[E-0030 25:4 00300AA]
  Side V C4 Full Close	[E-0030 25:5 00300AB]
  Side V C4 Ready	[E-0030 25:6 00300AC]
  Side V D Drive On	[E-0030 26:0 00300AE]
  Side V D Drive Off	[E-0030 26:1 00300AF]
  CP2 Side V C Remote Selected	[E-0030 26:6 00300AD]
  Side V D2 Full Open	[E-0030 27:0 00300B3]
  Side V D2 Full Close	[E-0030 27:1 00300B4]
  Side V D2 Ready	[E-0030 27:2 00300B5]
  Side V D1 Full Open	[E-0030 27:4 00300B0]
  Side V D1 Full Close	[E-0030 27:5 00300B1]
  Side V D1 Ready	[E-0030 27:6 00300B2]
  Side V D4 Full Open	[E-0030 28:0 00300B9]
  Side V D4 Full Close	[E-0030 28:1 00300BA]
  Side V D4 Ready	[E-0030 28:2 00300BB]
  Side V D3 Full Open	[E-0030 28:4 00300B6]
  Side V D3 Full Close	[E-0030 28:5 00300B7]
  Side V D3 Ready	[E-0030 28:6 00300B8]
  CP2 Side V D Remote Selected	[E-0030 29:2 00300BC]
  Rear V R1 Full Open	[E-0030 30:0 00300BF]
  Rear V R1 Full Close	[E-0030 30:1 00300C0]
  Rear V R1 Ready	[E-0030 30:2 00300C1]
  Rear V R1 Drive On	[E-0030 30:4 00300BD]
  Rear V R1 Drive Off	[E-0030 30:5 00300BE]
  CP2 Rear V R1 Remote Selected	[E-0030 31:2 00300C2]
  Rear V R2 Full Open	[E-0030 32:0 00300C5]
  Rear V R2 Full Close	[E-0030 32:1 00300C6]
  Rear V R2 Ready	[E-0030 32:2 00300C7]
  Rear V R2 Drive On	[E-0030 32:4 00300C3]
  Rear V R2 Drive Off	[E-0030 32:5 00300C4]
  CP2 Rear V R2 Remote Selected	[E-0030 33:2 00300C8]
  Rear V R3 Full Open	[E-0030 34:0 00300CB]
  Rear V R3 Full Close	[E-0030 34:1 00300CC]
  Rear V R3 Ready	[E-0030 34:2 00300CD]
  Rear V R3 Drive On	[E-0030 34:4 00300C9]
  Rear V R3 Drive Off	[E-0030 34:5 00300CA]
  CP2 Rear V R3 Remote Selected	[E-0030 35:2 00300CE]
  Rear V R4 Full Open	[E-0030 36:0 00300D1]
  Rear V R4 Full Close	[E-0030 36:1 00300D2]
  Rear V R4 Ready	[E-0030 36:2 00300D3]
  Rear V R4 Drive On	[E-0030 36:4 00300CF]
  Rear V R4 Drive Off	[E-0030 36:5 00300D0]
  CP2 Rear V R4 Remote Selected	[E-0030 37:2 00300D4]
  VentSh2 Full Open	[E-0030 38:0 00300D8]
  VentSh2 Full Close	[E-0030 38:1 00300D9]
  VentSh2 Ready	[E-0030 38:2 00300DA]
  VentSh1 Full Open	[E-0030 38:4 00300D5]
  VentSh1 Full Close	[E-0030 38:5 00300D6]
  VentSh1 Ready	[E-0030 38:6 00300D7]
  VentSh4 Full Open	[E-0030 39:0 00300DE]
  VentSh4 Full Close	[E-0030 39:1 00300DF]
  VentSh4 Ready	[E-0030 39:2 00300E0]
  VentSh3 Full Open	[E-0030 39:4 00300DB]
  VentSh3 Full Close	[E-0030 39:5 00300DC]
  VentSh3 Ready	[E-0030 39:6 00300DD]
  VentSh6 Full Open	[E-0030 40:0 00300E4]
  VentSh6 Full Close	[E-0030 40:1 00300E5]
  VentSh6 Ready	[E-0030 40:2 00300E6]
  VentSh5 Full Open	[E-0030 40:4 00300E1]
  VentSh5 Full Close	[E-0030 40:5 00300E2]
  VentSh5 Ready	[E-0030 40:6 00300E3]
  VentSh8 Full Open	[E-0030 41:0 00300EA]
  VentSh8 Full Close	[E-0030 41:1 00300EB]
  VentSh8 Ready	[E-0030 41:2 00300EC]
  VentSh7 Full Open	[E-0030 41:4 00300E7]
  VentSh7 Full Close	[E-0030 41:5 00300E8]
  VentSh7 Ready	[E-0030 41:6 00300E9]
  VentSh10 Full Open	[E-0030 42:0 00300F0]
  VentSh10 Full Close	[E-0030 42:1 00300F1]
  VentSh10 Ready	[E-0030 42:2 00300F2]
  VentSh9 Full Open	[E-0030 42:4 00300ED]
  VentSh9 Full Close	[E-0030 42:5 00300EE]
  VentSh9 Ready	[E-0030 42:6 00300EF]
  VentSh12 Full Open	[E-0030 43:0 00300F6]
  VentSh12 Full Close	[E-0030 43:1 00300F7]
  VentSh12 Ready	[E-0030 43:2 00300F8]
  VentSh11 Full Open	[E-0030 43:4 00300F3]
  VentSh11 Full Close	[E-0030 43:5 00300F4]
  VentSh11 Ready	[E-0030 43:6 00300F5]
  VentSh14 Full Open	[E-0030 44:0 00300FC]
  VentSh14 Full Close	[E-0030 44:1 00300FD]
  VentSh14 Ready	[E-0030 44:2 00300FE]
  VentSh13 Full Open	[E-0030 44:4 00300F9]
  VentSh13 Full Close	[E-0030 44:5 00300FA]
  VentSh13 Ready	[E-0030 44:6 00300FB]
  VentSh16 Full Open	[E-0030 45:0 0030102]
  VentSh16 Full Close	[E-0030 45:1 0030103]
  VentSh16 Ready	[E-0030 45:2 0030104]
  VentSh15 Full Open	[E-0030 45:4 00300FF]
  VentSh15 Full Close	[E-0030 45:5 0030100]
  VentSh15 Ready	[E-0030 45:6 0030101]
  VentSh18 Full Open	[E-0030 46:0 0030108]
  VentSh18 Full Close	[E-0030 46:1 0030109]
  VentSh18 Ready	[E-0030 46:2 003010A]
  VentSh17 Full Open	[E-0030 46:4 0030105]
  VentSh17 Full Close	[E-0030 46:5 0030106]
  VentSh17 Ready	[E-0030 46:6 0030107]
  VentSh20 Full Open	[E-0030 47:0 003010E]
  VentSh20 Full Close	[E-0030 47:1 003010F]
  VentSh20 Ready	[E-0030 47:2 0030110]
  VentSh19 Full Open	[E-0030 47:4 003010B]
  VentSh19 Full Close	[E-0030 47:5 003010C]
  VentSh19 Ready	[E-0030 47:6 003010D]
  Mirror Hatch IR Closed	[E-0030 48:0 0030113]
  Mirror Hatch Opt Closed	[E-0030 48:1 0030114]
  CP2 VentSh 1-10 Remote	[E-0030 48:4 0030111]
  CP2 VentSh 11-20 Remote	[E-0030 48:5 0030112]
  Crane CONT TUE Control Selected	[E-0030 49:0 0030117]
  Bridge CONT 16T Load Selected	[E-0030 49:1 0030118]
  Bridge CONT 40T Load Selected	[E-0030 49:2 0030119]
  Bridge CONT 80T Load Selected	[E-0030 49:3 003011A]
  Mirror Hatch IR Opened	[E-0030 49:4 0030115]
  Mirror Hatch Opt Opened	[E-0030 49:5 0030116]
  Bridge CONT Crane Traverse Position	[E-0030 50:0 003011F]
  Bridge CONT Hoist Local Selected	[E-0030 50:1 0030121]
  Bridge CONT Hoist Off Selected	[E-0030 50:2 0030122]
  Bridge CONT Overload	[E-0030 50:4 003011B]
  Bridge CONT Crane Ready	[E-0030 50:5 003011C]
  80T Lift Ready	[E-0030 50:6 003011D]
  Bridge CONT Crane Not Hook Up	[E-0030 50:7 003011E]
  Bridge CONT Hoist Stored Position	[E-0030 51:0 0030125]
  Crane Local CONT TUE Selected	[E-0030 51:1 0030126]
  Mirror Hatch Open on THRM	[E-0030 51:3 0030127]
  Bridge CONT Hoist Ready	[E-0030 51:5 0030123]
  Bridge CONT Hoist Not Hook Up	[E-0030 51:6 0030124]
  IR Cooling System Local Mode	[E-0030 53:0 0030139]
  IR Cooling System Remote Mode	[E-0030 53:1 003013A]
  Opt Cooling System Local Mode	[E-0030 53:2 003013B]
  Opt Cooling System Remote Mode	[E-0030 53:3 003013C]
  IR Cooling System On ANS	[E-0030 53:4 0030135]
  IR Cooling System Off ANS	[E-0030 53:5 0030136]
  Opt Cooling System On AMS	[E-0030 53:6 0030137]
  Opt Cooling System Off ANS	[E-0030 53:7 0030138]
  IR Cooling AHU Fan Fault	[E-0030 54:0 003013D]
  IR Cooling Pump BP Fault	[E-0030 54:1 003013E]
  IR Cooling Chiller BR Fault	[E-0030 54:2 003013F]
  IR Cooling AHU Damper Alarm	[E-0030 55:0 0030143]
  IR Cooling AHU DEF.Alarm	[E-0030 55:1 0030144]
  IR Cooling System RM Temp.Alarm	[E-0030 55:2 0030145]
  Opt Cooling AHU Fan Fault	[E-0030 55:4 0030140]
  Opt Cooling Pump BP Fault	[E-0030 55:5 0030141]
  Opt Cooling Chiller BR Fault	[E-0030 55:6 0030142]
  Opt Cooling AHU Damper Alarm	[E-0030 56:4 0030146]
  Opt Cooling AHU DEF.Alarm	[E-0030 56:5 0030147]
  Opt Cooling System RM Temp.Alarm	[E-0030 56:6 0030148]
  Nasmyth Floor(IR Side) Light On	[E-0030 57:0 003014D]
  Nasmyth Floor(Opt Side) Light On	[E-0030 57:1 003014E]
  Tertiary Floor(IR Side) Light On	[E-0030 57:2 003014F]
  Tertiary Floor(Opt Side) Light On	[E-0030 57:3 0030150]
  Ventilation Floor Light On	[E-0030 57:4 0030149]
  Telescope Room Light On	[E-0030 57:5 003014A]
  Cassegrain Floor(IR Side) Light On	[E-0030 57:6 003014B]
  Cassegrain Floor(Opt Side) Light On	[E-0030 57:7 003014C]
  Front V Full Open CMD ANS	[E-0030 58:0 0030152]
  Shutter Light On	[E-0030 58:4 0030151]
  Side V A Full Open CMD ANS	[E-0030 59:0 0030157]
  Side V B Full Open CMD ANS	[E-0030 59:1 0030158]
  Side V C Full Open CMD ANS	[E-0030 59:2 0030159]
  Side V D Full Open CMD ANS	[E-0030 59:3 003015A]
  Rear V1 Full Open CMD ANS	[E-0030 59:4 0030153]
  Rear V2 Full Open CMD ANS	[E-0030 59:5 0030154]
  Rear V3 Full Open CMD ANS	[E-0030 59:6 0030155]
  Rear V4 Full Open CMD ANS	[E-0030 59:7 0030156]
  Rear V1 Full Close CMD ANS	[E-0030 60:0 003015C]
  Rear V2 Full Close CMD ANS	[E-0030 60:1 003015D]
  Rear V3 Full Close CMD ANS	[E-0030 60:2 003015E]
  Rear V4 Full Close CMD ANS	[E-0030 60:3 003015F]
  Front V Full Close CMD ANS	[E-0030 60:4 003015B]
  Side V A Full Open ANS	[E-0030 61:0 0030164]
  Side V B Full Open ANS	[E-0030 61:1 0030165]
  Side V C Full Open ANS	[E-0030 61:2 0030166]
  Side V D Full Open ANS	[E-0030 61:3 0030167]
  Side V A Full Close CMD ANS	[E-0030 61:4 0030160]
  Side V B Full Close CMD ANS	[E-0030 61:5 0030161]
  Side V C Full Close CMD ANS	[E-0030 61:6 0030162]
  Side V D Full Close CMD ANS	[E-0030 61:7 0030163]
  Shutter IR Interlock	[E-0030 62:0 003016E]
  Shutter Opt Interlock	[E-0030 62:1 003016F]
  Top Screen(F) Interlock	[E-0030 62:2 0030170]
  Top Screen(R) Interlock	[E-0030 62:3 0030171]
  Side V A Full Close ANS	[E-0030 62:4 0030168]
  Side V B Full Close ANS	[E-0030 62:5 0030169]
  Side V C Full Close ANS	[E-0030 62:6 003016A]
  Side V D Full Close ANS	[E-0030 62:7 003016B]
  Shutter Power On Ready	[E-0030 63:0 0030173]
  Wind Screen Power On Ready	[E-0030 63:1 0030174]
  Top Screen Power On Ready	[E-0030 63:2 0030175]
  Wind Screen Interlock	[E-0030 63:4 0030172]
  Wind Screen Real Position	[L-0030 0 0030001 BCD6]
  Top Screen(F) Real Position	[L-0030 6 0030002 BCD6]
  Top Screen(R) Real Position	[L-0030 12 0030003 BCD6]
  Front V Real Position	[L-0030 18 0030004 BCD6]
  Rear V1 Real Position	[L-0030 24 0030005 BCD6]
  Rear V2 Real Position	[L-0030 30 0030006 BCD6]
  Rear V3 Real Position	[L-0030 36 0030007 BCD6]
  Rear V4 Real Position	[L-0030 42 0030008 BCD6]
  Side V A1 Real Position	[L-0030 48 0030009 BCD6]
  Side V A2 Real Position	[L-0030 54 003000A BCD6]
  Side V A3 Real Position	[L-0030 60 003000B BCD6]
  Side V A4 Real Position	[L-0030 66 003000C BCD6]
  Side V B1 Real Position	[L-0030 72 003000D BCD6]
  Side V B2 Real Position	[L-0030 78 003000E BCD6]
  Side V B3 Real Position	[L-0030 84 003000F BCD6]
  Side V B4 Real Position	[L-0030 90 0030010 BCD6]
  Side V C1 Real Position	[L-0030 96 0030011 BCD6]
  Side V C2 Real Position	[L-0030 102 0030012 BCD6]
  Side V C3 Real Position	[L-0030 108 0030013 BCD6]
  Side V C4 Real Position	[L-0030 114 0030014 BCD6]
  Side V D1 Real Position	[L-0030 120 0030015 BCD6]
  Side V D2 Real Position	[L-0030 126 0030016 BCD6]
  Side V D3 Real Position	[L-0030 132 0030017 BCD6]
  Side V D4 Real Position	[L-0030 138 0030018 BCD6]
  Nasmyth Room (IR Side) Temp	[L-0030 144 0030128 BCD6]
  Mount Room (IR Side) Temp	[L-0030 150 0030129 BCD6]
  Tertiary Floor(IR Side) Temp	[L-0030 156 003012A BCD6]
  Top Unit Floor (IR Side) Temp	[L-0030 162 003012B BCD6]
  Nasmyth Floor (IR Side) Temp	[L-0030 168 003012C BCD6]
  Nasmyth Room (Opt Side) Temp	[L-0030 174 003012D BCD6]
  Mount Room (Opt Side) Temp	[L-0030 180 003012E BCD6]
  Tertiary Floor (Opt Side) Temp	[L-0030 186 003012F BCD6]
  Top Unit Floor (Opt Side) Temp	[L-0030 192 0030130 BCD6]
  Nasmyth Floor (Opt Side) Temp	[L-0030 198 0030131 BCD6]
  Cooling Temp Set-1 ANS	[L-0030 204 0030132 BCD6]
  Cooling Temp Set-2 ANS	[L-0030 210 0030133 BCD6]
  Cooling Temp Set-3 ANS	[L-0030 216 0030134 BCD6]
  Heat Exh Pump Local	[E-0031 0:0 003100B]
  Heat Exh Chiller Pump OPN	[E-0031 0:4 003100C]
  Heat Exh Chiller Pump Stop	[E-0031 0:5 003100D]
  Heat Exh TLSCP Pump OPN	[E-0031 1:0 003100E]
  Heat Exh TLSCP Pump Stop	[E-0031 1:1 003100F]
  Heat Exh Mirror Pump OPN	[E-0031 1:4 0031010]
  Heat Exh Mirror Pump Stop	[E-0031 1:5 0031011]
  Heat Exh Pump Chiller-A OPN	[E-0031 2:0 0031012]
  Heat Exh Pump Chiller-A Stop	[E-0031 2:1 0031013]
  Heat Exh Chiller Alarm	[E-0031 2:4 0031014]
  Heat Exh TLSCP Pump Alarm	[E-0031 3:0 0031015]
  Heat Exh Mirror Pump Alarm	[E-0031 3:4 0031016]
  Heat Exh Chiller-A Alarm	[E-0031 4:0 0031017]
  Heat Exh Tank Level Alarm	[E-0031 4:4 003101A]
  MLP3-Heat Exh(Pump) Alarm	[E-0031 5:0 003101B]
  Heat Exh Total Alarm	[E-0031 5:4 003101C]
  Heat Exh Chiller Out Temp	[L-0031 0 0031001 BCD6]
  Heat Exh Chiller In Temp	[L-0031 6 0031002 BCD6]
  Heat Exh TLSCP Coolant Temp	[L-0031 12 0031003 BCD6]
  Heat Exh TLSCP Coolant-Return Temp	[L-0031 18 0031004 BCD6]
  Heat Exh Mirror Coolant Temp	[L-0031 24 0031005 BCD6]
  Heat Exh Mirror Coolant-Return Temp	[L-0031 30 0031006 BCD6]
  Heat Exh TLSCP Coolant Flow	[L-0031 36 0031007 BCD6]
  Heat Exh Mirror Coolant Flow	[L-0031 42 0031008 BCD6]
  Heat Exh TLSCP Coolant Pressure	[L-0031 48 0031009 BCD6]
  Heat Exh Mirror Coolant Pressure	[L-0031 54 003100A BCD6]
  Heat Exh TLSCP Coolant Temp CMD	[L-0031 60 0031018 BCD6]
  Heat Exh Mirror Coolant Temp CMD on HT EXH	[L-0031 66 0031019 BCD6]
  Cs Bolt Summary Alarm	[E-0032 0:0 0032015]
  Cs Bolt(All) Anchored	[E-0032 1:0 0032016]
  Cs Bolt(All) Stop	[E-0032 1:2 0032018]
  Cs Bolt(All) Drive RDY	[E-0032 1:4 0032019]
  Cs Bolt1 Anchored	[E-0032 2:0 003201B]
  Cs Bolt1 Stop	[E-0032 2:2 003201D]
  Cs Bolt1 RDY	[E-0032 2:3 003208D]
  Cs Bolt2 Anchored	[E-0032 2:4 003201E]
  Cs Bolt2 Stop	[E-0032 2:6 0032020]
  Cs Bolt2 RDY	[E-0032 2:7 003208E]
  Cs Bolt3 Anchored	[E-0032 3:0 0032021]
  Cs Bolt3 Stop	[E-0032 3:2 0032023]
  Cs Bolt3 RDY	[E-0032 3:3 003208F]
  Cs Bolt4 Anchored	[E-0032 3:4 0032024]
  Cs Bolt4 Stop	[E-0032 3:6 0032026]
  Cs Bolt4 RDY	[E-0032 3:7 0032090]
  Cs Bolt5 Anchored	[E-0032 4:0 0032027]
  Cs Bolt5 Stop	[E-0032 4:2 0032029]
  Cs Bolt5 RDY	[E-0032 4:3 0032091]
  Cs Bolt6 Anchored	[E-0032 4:4 003202A]
  Cs Bolt6 Stop	[E-0032 4:6 003202C]
  Cs Bolt6 RDY	[E-0032 4:7 0032092]
  Cs Bolt7 Anchored	[E-0032 5:0 003202D]
  Cs Bolt7 Stop	[E-0032 5:2 003202F]
  Cs Bolt7 RDY	[E-0032 5:3 0032093]
  Cs Bolt8 Anchored	[E-0032 5:4 0032030]
  Cs Bolt8 Stop	[E-0032 5:6 0032032]
  Cs Bolt8 RDY	[E-0032 5:7 0032094]
  Cs Bolt9 Anchored	[E-0032 6:0 0032033]
  Cs Bolt9 Stop	[E-0032 6:2 0032035]
  Cs Bolt9 RDY	[E-0032 6:3 0032095]
  Cs Bolt10 Anchored	[E-0032 6:4 0032036]
  Cs Bolt10 Stop	[E-0032 6:6 0032038]
  Cs Bolt10 RDY	[E-0032 6:7 0032096]
  Cs Bolt11 Anchored	[E-0032 7:0 0032039]
  Cs Bolt11 Stop	[E-0032 7:2 003203B]
  Cs Bolt11 RDY	[E-0032 7:3 0032097]
  Cs Bolt12 Anchored	[E-0032 7:4 003203C]
  Cs Bolt12 Stop	[E-0032 7:6 003203E]
  Cs Bolt12 RDY	[E-0032 7:7 0032098]
  Cs Bolt13 Anchored	[E-0032 8:0 003203F]
  Cs Bolt13 Stop	[E-0032 8:2 0032041]
  Cs Bolt13 RDY	[E-0032 8:3 0032099]
  Cs Bolt14 Anchored	[E-0032 8:4 0032042]
  Cs Bolt14 Stop	[E-0032 8:6 0032044]
  Cs Bolt14 RDY	[E-0032 8:7 003209A]
  Cs Bolt15 Anchored	[E-0032 9:0 0032045]
  Cs Bolt15 Stop	[E-0032 9:2 0032047]
  Cs Bolt15 RDY	[E-0032 9:3 003209B]
  Cs Bolt16 Anchored	[E-0032 9:4 0032048]
  Cs Bolt16 Stop	[E-0032 9:6 003204A]
  Cs Bolt16 RDY	[E-0032 9:7 003209C]
  Cs Bolt1 Alarm	[E-0032 10:0 003204B]
  Cs Bolt1 Up Limit	[E-0032 10:1 003204C]
  Cs Bolt1 Down Limit	[E-0032 10:2 003204D]
  Cs Bolt POSN Unit1 Alarm	[E-0032 10:3 003207D]
  Cs Bolt2 Alarm	[E-0032 10:4 003204E]
  Cs Bolt2 Up Limit	[E-0032 10:5 003204F]
  Cs Bolt2 Down Limit	[E-0032 10:6 0032050]
  Cs Bolt POSN Unit2 Alarm	[E-0032 10:7 003207E]
  Cs Bolt3 Alarm	[E-0032 11:0 0032051]
  Cs Bolt3 Up Limit	[E-0032 11:1 0032052]
  Cs Bolt3 Down Limit	[E-0032 11:2 0032053]
  Cs Bolt POSN Unit3 Alarm	[E-0032 11:3 003207F]
  Cs Bolt4 Alarm	[E-0032 11:4 0032054]
  Cs Bolt4 Up Limit	[E-0032 11:5 0032055]
  Cs Bolt4 Down Limit	[E-0032 11:6 0032056]
  Cs Bolt POSN Unit4 Alarm	[E-0032 11:7 0032080]
  Cs Bolt5 Alarm	[E-0032 12:0 0032057]
  Cs Bolt5 Up Limit	[E-0032 12:1 0032058]
  Cs Bolt5 Down Limit	[E-0032 12:2 0032059]
  Cs Bolt POSN Unit5 Alarm	[E-0032 12:3 0032081]
  Cs Bolt6 Alarm	[E-0032 12:4 003205A]
  Cs Bolt6 Up Limit	[E-0032 12:5 003205B]
  Cs Bolt6 Down Limit	[E-0032 12:6 003205C]
  Cs Bolt POSN Unit6 Alarm	[E-0032 12:7 0032082]
  Cs Bolt7 Alarm	[E-0032 13:0 003205D]
  Cs Bolt7 Up Limit	[E-0032 13:1 003205E]
  Cs Bolt7 Down Limit	[E-0032 13:2 003205F]
  Cs Bolt POSN Unit7 Alarm	[E-0032 13:3 0032083]
  Cs Bolt8 Alarm	[E-0032 13:4 0032060]
  Cs Bolt8 Up Limit	[E-0032 13:5 0032061]
  Cs Bolt8 Down Limit	[E-0032 13:6 0032062]
  Cs Bolt POSN Unit8 Alarm	[E-0032 13:7 0032084]
  Cs Bolt9 Alarm	[E-0032 14:0 0032063]
  Cs Bolt9 Up Limit	[E-0032 14:1 0032064]
  Cs Bolt9 Down Limit	[E-0032 14:2 0032065]
  Cs Bolt POSN Unit9 Alarm	[E-0032 14:3 0032085]
  Cs Bolt10 Alarm	[E-0032 14:4 0032066]
  Cs Bolt10 Up Limit	[E-0032 14:5 0032067]
  Cs Bolt10 Down Limit	[E-0032 14:6 0032068]
  Cs Bolt POSN Unit10 Alarm	[E-0032 14:7 0032086]
  Cs Bolt11 Alarm	[E-0032 15:0 0032069]
  Cs Bolt11 Up Limit	[E-0032 15:1 003206A]
  Cs Bolt11 Down Limit	[E-0032 15:2 003206B]
  Cs Bolt POSN Unit11 Alarm	[E-0032 15:3 0032087]
  Cs Bolt12 Alarm	[E-0032 15:4 003206C]
  Cs Bolt12 Up Limit	[E-0032 15:5 003206D]
  Cs Bolt12 Down Limit	[E-0032 15:6 003206E]
  Cs Bolt POSN Unit12 Alarm	[E-0032 15:7 0032088]
  Cs Bolt13 Alarm	[E-0032 16:0 003206F]
  Cs Bolt13 Up Limit	[E-0032 16:1 0032070]
  Cs Bolt13 Down Limit	[E-0032 16:2 0032071]
  Cs Bolt POSN Unit13 Alarm	[E-0032 16:3 0032089]
  Cs Bolt14 Alarm	[E-0032 16:4 0032072]
  Cs Bolt14 Up Limit	[E-0032 16:5 0032073]
  Cs Bolt14 Down Limit	[E-0032 16:6 0032074]
  Cs Bolt POSN Unit14 Alarm	[E-0032 16:7 003208A]
  Cs Bolt15 Alarm	[E-0032 17:0 0032075]
  Cs Bolt15 Up Limit	[E-0032 17:1 0032076]
  Cs Bolt15 Down Limit	[E-0032 17:2 0032077]
  Cs Bolt POSN Unit15 Alarm	[E-0032 17:3 003208B]
  Cs Bolt16 Alarm	[E-0032 17:4 0032078]
  Cs Bolt16 Up Limit	[E-0032 17:5 0032079]
  Cs Bolt16 Down Limit	[E-0032 17:6 003207A]
  Cs Bolt POSN Unit16 Alarm	[E-0032 17:7 003208C]
  MLP3-Cs Bolt Alarm	[E-0032 18:0 003207B]
  Cs Bolt CONT Local	[E-0032 19:0 003207C]
  Cs Bolt1 Current Limit	[E-0032 20:0 003201C]
  Cs Bolt2 Current Limit	[E-0032 20:1 003201F]
  Cs Bolt3 Current Limit	[E-0032 20:2 0032022]
  Cs Bolt4 Current Limit	[E-0032 20:3 0032025]
  Cs Bolt5 Current Limit	[E-0032 20:4 0032028]
  Cs Bolt6 Current Limit	[E-0032 20:5 003202B]
  Cs Bolt7 Current Limit	[E-0032 20:6 003202E]
  Cs Bolt8 Current Limit	[E-0032 20:7 0032031]
  Cs Bolt9 Current Limit	[E-0032 21:0 0032034]
  Cs Bolt10 Current Limit	[E-0032 21:1 0032037]
  Cs Bolt11 Current Limit	[E-0032 21:2 003203A]
  Cs Bolt12 Current Limit	[E-0032 21:3 003203D]
  Cs Bolt13 Current Limit	[E-0032 21:4 0032040]
  Cs Bolt14 Current Limit	[E-0032 21:5 0032043]
  Cs Bolt15 Current Limit	[E-0032 21:6 0032046]
  Cs Bolt16 Current Limit	[E-0032 21:7 0032049]
  Cs Bolt(ALL) Up Limit	[E-0032 22:1 003209D]
  Cs Bolt(ALL) Down Limit	[E-0032 22:2 003209E]
  Z(IR-Rear) Rotation Position	[L-0032 0 0032001 BCD6]
  Z(Opt-Rear) Rotation Position	[L-0032 6 0032002 BCD6]
  Z(IR-Front) Rotation Position	[L-0032 12 0032003 BCD6]
  Z(Opt-Front) Rotation Position	[L-0032 18 0032004 BCD6]
  Cs Bolt1 Position	[L-0032 24 0032005 BCD6]
  Cs Bolt2 Position	[L-0032 30 0032006 BCD6]
  Cs Bolt3 Position	[L-0032 36 0032007 BCD6]
  Cs Bolt4 Position	[L-0032 42 0032008 BCD6]
  Cs Bolt5 Position	[L-0032 48 0032009 BCD6]
  Cs Bolt6 Position	[L-0032 54 003200A BCD6]
  Cs Bolt7 Position	[L-0032 60 003200B BCD6]
  Cs Bolt8 Position	[L-0032 66 003200C BCD6]
  Cs Bolt9 Position	[L-0032 72 003200D BCD6]
  Cs Bolt10 Position	[L-0032 78 003200E BCD6]
  Cs Bolt11 Position	[L-0032 84 003200F BCD6]
  Cs Bolt12 Position	[L-0032 90 0032010 BCD6]
  Cs Bolt13 Position	[L-0032 96 0032011 BCD6]
  Cs Bolt14 Position	[L-0032 102 0032012 BCD6]
  Cs Bolt15 Position	[L-0032 108 0032013 BCD6]
  Cs Bolt16 Position	[L-0032 114 0032014 BCD6]
  ADU2(AG/SH Probe) Fault	[E-0033 0:0 0033001]
  ADU2(AG/SH Probe) OPN	[E-0033 0:1 0033002]
  ADU2(AG/SH Probe) Fan Alarm	[E-0033 0:2 0033003]
  ADU2(AG/SH Probe) Fan OPN	[E-0033 0:3 0033004]
  ADU2(Rotator/ADC) Fault	[E-0033 1:0 0033005]
  ADU2(Rotator/ADC) OPN	[E-0033 1:1 0033006]
  ADU2(Rotator/ADC) Fan Alarm	[E-0033 1:2 0033007]
  ADU2(Rotator/ADC) Fan OPN	[E-0033 1:3 0033008]
  SPU2 PS Fan Alarm	[E-0033 2:0 0033009]
  Cs NO.1 Rack Power Off	[E-0033 3:0 003300A]
  Cs NO.1 Rack Fault	[E-0033 3:1 003300B]
  Cs NO.1 Temp Alarm	[E-0033 3:2 003300C]
  Cs NO.1 Frost Alarm	[E-0033 3:3 003300D]
  Cs NO.1 Rack Fan Alarm	[E-0033 3:4 003300E]
  Cs NO.2 Rack Power Off	[E-0033 18:0 003300F]
  Cs NO.2 Rack Fault	[E-0033 18:1 0033010]
  Cs NO.2 Temp Alarm	[E-0033 18:2 0033011]
  Cs NO.2 Frost Alarm	[E-0033 18:3 0033012]
  Cs NO.2 Rack Fan Alarm	[E-0033 18:4 0033013]
  P NO.2 Rack Power Off	[E-0033 20:0 0033014]
  P NO.2 Rack Fault	[E-0033 20:1 0033015]
  P NO.2 Temp Alarm	[E-0033 20:2 0033016]
  P NO.2 Frost Alarm	[E-0033 20:3 0033017]
  P NO.2 Rack Fan Alarm	[E-0033 20:4 0033018]
  P NO.1 Rack Power Off	[E-0033 21:0 0033019]
  P NO.1 Rack Fault	[E-0033 21:1 003301A]
  P NO.1 Temp Alarm	[E-0033 21:2 003301B]
  P NO.1 Frost Alarm	[E-0033 21:3 003301C]
  P NO.1 Rack Fan Alarm	[E-0033 21:4 003301D]
  P/Cs PDB2 CB1 Off	[E-0033 23:2 0033020]
  P/Cs PDB2 CB2 Off	[E-0033 23:3 0033021]
  ADU1(SMCU) Fault on SPU4	[E-0033 40:0 0033022]
  ADU1(SMCU) OPN	[E-0033 40:1 0033023]
  ADU1(SMCU) Fan Alarm	[E-0033 40:2 0033024]
  ADU1(SMCU) Fan OPN	[E-0033 40:3 0033025]
  ADU1 (Rotator/ADC) Fault	[E-0033 42:0 003302A]
  ADU1 (Rotator/ADC) OPN	[E-0033 42:1 003302B]
  ADU1 (Rotator/ADC) Fan Alarm	[E-0033 42:2 003302C]
  ADU1 (Rotator/ADC) Fan OPN	[E-0033 42:3 003302D]
  ADU1(AG/SH Probe) Fault	[E-0033 43:0 0033026]
  ADU1(AG/SH Probe) OPN	[E-0033 43:1 0033027]
  ADU1(AG/SH Probe) Fan Alarm	[E-0033 43:2 0033028]
  ADU1(AG/SH Probe) Fan OPN	[E-0033 43:3 0033029]
  ADU3(AG/SH Probe) Fault	[E-0034 0:0 0034001]
  ADU3(AG/SH Probe) OPN	[E-0034 0:1 0034002]
  ADU3(AG/SH Probe) Fan Alarm	[E-0034 0:2 0034003]
  ADU3(AG/SH Probe) Fan OPN	[E-0034 0:3 0034004]
  ADU1(Mount) Fault	[E-0034 1:0 0034005]
  ADU1(Mount) OPN	[E-0034 1:1 0034006]
  ADU1(Mount) Fan Alarm	[E-0034 1:2 0034007]
  ADU1(Mount) Fan OPN	[E-0034 1:3 0034008]
  SPU5 PS Fan Alarm	[E-0034 2:0 0034009]
  NsIR NO.1 Rack Power Off	[E-0034 3:0 003400A]
  NsIR NO.1 Rack Fault	[E-0034 3:1 003400B]
  NsIR NO.1 Temp Alarm	[E-0034 3:2 003400C]
  NsIR NO.1 Frost Alarm	[E-0034 3:3 003400D]
  NsIR NO.1 Rack Fan Alarm	[E-0034 3:4 003400E]
  NsIR NO.3 Rack Power Off	[E-0034 8:0 003400F]
  NsIR NO.3 Rack Fault	[E-0034 8:1 0034010]
  NsIR NO.3 Temp Alarm	[E-0034 8:2 0034011]
  NsIR NO.3 Frost Alarm	[E-0034 8:3 0034012]
  NsIR NO.3 Rack Fan Alarm	[E-0034 8:4 0034013]
  NsIR NO.2 Rack Power Off	[E-0034 9:0 0034014]
  NsIR NO.2 Rack Fault	[E-0034 9:1 0034015]
  NsIR NO.2 Temp Alarm	[E-0034 9:2 0034016]
  NsIR NO.2 Frost Alarm	[E-0034 9:3 0034017]
  NsIR NO.2 Rack Fan Alarm	[E-0034 9:4 0034018]
  NsIR NO.2 CB1 Off	[E-0034 11:0 0034019]
  NsIR NO.2 CB2 Off	[E-0034 11:1 003401A]
  NsIR EXEAZ CB Off	[E-0034 11:2 003401B]
  ADU4(AG/SH Probe) Fault	[E-0035 0:0 0035001]
  ADU4(AG/SH Probe) OPN	[E-0035 0:1 0035002]
  ADU4(AG/SH Probe) Fan Alarm	[E-0035 0:2 0035003]
  ADU4(AG/SH Probe) Fan OPN	[E-0035 0:3 0035004]
  ADU2(Mount) Fault	[E-0035 1:0 0035005]
  ADU2(Mount) OPN	[E-0035 1:1 0035006]
  ADU2(Mount) Fan Alarm	[E-0035 1:2 0035007]
  ADU2(Mount) Fan OPN	[E-0035 1:3 0035008]
  SPU6 PS Fan Alarm	[E-0035 2:0 0035009]
  NsOpt NO.1 Rack Power Off	[E-0035 3:0 003500A]
  NsOpt NO.1 Rack Fault	[E-0035 3:1 003500B]
  NsOpt NO.1 Temp Alarm	[E-0035 3:2 003500C]
  NsOpt NO.1 Frost Alarm	[E-0035 3:3 003500D]
  NsOpt NO.1 Rack Fan Alarm	[E-0035 3:4 003500E]
  NsOpt NO.3 Rack Power Off	[E-0035 8:0 003500F]
  NsOpt NO.3 Rack Fault	[E-0035 8:1 0035010]
  NsOpt NO.3 Temp Alarm	[E-0035 8:2 0035011]
  NsOpt NO.3 Frost Alarm	[E-0035 8:3 0035012]
  NsOpt NO.3 Rack Fan Alarm	[E-0035 8:4 0035013]
  NsOpt NO.2 Rack Power Off	[E-0035 9:0 0035014]
  NsOpt NO.2 Rack Fault	[E-0035 9:1 0035015]
  NsOpt NO.2 Temp Alarm	[E-0035 9:2 0035016]
  NsOpt NO.2 Frost Alarm	[E-0035 9:3 0035017]
  NsOpt NO.2 Rack Fan Alarm	[E-0035 9:4 0035018]
  NsOpt NO.2 CB1 Off	[E-0035 10:0 0035019]
  NsOpt NO.2 CB2 Off	[E-0035 10:1 003501A]
  TWOR CB1 Off	[E-0035 10:4 003501B]
  TWOR CB2 Off	[E-0035 10:5 003501C]
  Data Logger Alarm	[E-0035 10:6 003501D]
  Remote Scan Alarm	[E-0035 10:7 003501E]
  TWOR Rack Power Off	[E-0035 11:0 003501F]
  TWOR Rack Fault	[E-0035 11:1 0035020]
  TWOR Temp Alarm	[E-0035 11:2 0035021]
  TWOR Frost Alarm	[E-0035 11:3 0035022]
  TWOR Rack Fan Alarm	[E-0035 11:4 0035023]
  NsOpt EXEAZ CB Off	[E-0035 14:4 0035024]
  P Rotator/ADC Position(Mount Real SYNC)Mode	[E-0036 0:0 0036020]
  P Rotator/ADC Position Mode	[E-0036 0:1 003601F]
  P Rotator Test Mode	[E-0036 0:2 0036008]
  P Rotator Slew Mode	[E-0036 0:3 0036007]
  P Rotator Limit Reset	[E-0036 0:4 0036014]
  TCFRCU(P) MAINT	[E-0036 0:5 0036015]
  P Rotator 1st Limit +	[E-0036 1:0 003602D]
  P Rotator 1st Limit -	[E-0036 1:1 003602E]
  P Rotator 2nd Limit +	[E-0036 1:2 003602F]
  P Rotator 2nd Limit -	[E-0036 1:3 0036030]
  P Rotator Drive On	[E-0036 3:0 003600B]
  P Rotator Drive Off	[E-0036 3:1 003600C]
  P Rotator Selected	[E-0036 4:0 003600D]
  P Rotator Safety SW	[E-0036 5:0 0036016]
  P Rotator Handle	[E-0036 5:1 0036018]
  TCFRCU(P) Drive Safety	[E-0036 5:6 0036028]
  P Rotator Drive Ready	[E-0036 6:0 003601D]
  FRCU(P) Fault	[E-0036 6:1 003600F]
  TCSPU1/4 (CS) Alarm	[E-0036 6:5 0036021]
  MLP1-FRCU(P) Alarm	[E-0036 7:0 0036010]
  FRCU(P) Total Fan Alarm	[E-0036 7:1 0036011]
  FRCU(P) Local	[E-0036 7:2 0036012]
  TCADU1(FRCU(P)) Fault	[E-0036 7:3 0036013]
  FRCU(P) EXT CLK Alarm	[E-0036 7:4 0036019]
  P Rotator COML PWR Fault	[E-0036 10:0 0036017]
  P Rotator DPA Fault	[E-0036 13:0 0036029]
  TCDPA1(FRCU(P)) Fault	[E-0036 13:3 003602B]
  EMER Stop	[E-0036 14:0 003601E]
  P Rotator ABS ENCDR-1 Alarm	[E-0036 15:0 0036035]
  P Rotator ABS ENCDR-2 Alarm	[E-0036 15:1 0036036]
  P Rotator ABS ENCDR-3 Alarm	[E-0036 15:2 0036037]
  P Rotator ABS ENCDR-4 Alarm	[E-0036 15:3 0036038]
  P Rotator ABS ENCDR-1 Not Used	[E-0036 15:4 0036039]
  P Rotator ABS ENCDR-2 Not Used	[E-0036 15:5 003603A]
  P Rotator ABS ENCDR-3 Not Used	[E-0036 15:6 003603B]
  P Rotator ABS ENCDR-4 Not Used	[E-0036 15:7 003603C]
  P Rotator ABS ENCDR-5 Alarm	[E-0036 16:0 003603D]
  P Rotator ABS ENCDR-6 Alarm	[E-0036 16:1 003603E]
  P Rotator ABS ENCDR-7 Alarm	[E-0036 16:2 003603F]
  P Rotator ABS ENCDR-8 Alarm	[E-0036 16:3 0036040]
  P Rotator ABS ENCDR-5 Not Used	[E-0036 16:4 0036041]
  P Rotator ABS ENCDR-6 Not Used	[E-0036 16:5 0036042]
  P Rotator ABS ENCDR-7 Not Used	[E-0036 16:6 0036043]
  P Rotator ABS ENCDR-8 Not Used	[E-0036 16:7 0036044]
  P ADC 1st Limit +	[E-0036 22:0 003611F]
  P ADC 1st Limit -	[E-0036 22:1 0036120]
  P ADC 2nd Limit +	[E-0036 22:2 0036121]
  P ADC 2nd Limit -	[E-0036 22:3 0036122]
  P ADC Drive On	[E-0036 24:0 003610B]
  P ADC Drive Off	[E-0036 24:1 003610C]
  P ADC Drive Ready	[E-0036 27:0 003611A]
  P ADC Handle SW	[E-0036 30:1 0036115]
  P ADC DPA Fault	[E-0036 32:0 003611D]
  P Rotator ABS ENCDR Not INIT	[E-0036 35:0 0036023]
  P Rotator ABS ENCDR Not Zeroed	[E-0036 35:1 0036024]
  P Rotator ABS ENCDR Zeroing	[E-0036 35:2 0036025]
  P Rotator ABS ENCDR Not COMPEN	[E-0036 35:3 0036026]
  P Rotator ABS ENCDR COMPEN PRC RUN	[E-0036 35:4 0036027]
  P Rotator Test Pattern	[E-0036 38 0036009 BCD1]
  P Rotator Test Resutlt	[E-0036 39 003600A BCD1]
  P Rotator/ADC Test Ready	[E-0036 39:0 0036045]
  P Rotator/ADC TEST	[E-0036 39:1 0036046]
  P Rotator/ADC Test Data Send	[E-0036 39:2 0036047]
  P Rotator/ADC Test Data End	[E-0036 39:3 0036048]
  P Rotator Rate REF	[L-0036 12 0036003 BCD6]
  P Rotator Rate FDBK-A	[L-0036 18 0036004 BCD6]
  P Rotator Current REF-A	[L-0036 24 0036005 BCD6]
  P Rotator Rate FDBK-B	[L-0036 30 003601C BCD6]
  P ADC Real Angle	[L-0036 36 0036101 BCD6]
  P ADC CMD Angle	[L-0036 42 0036102 BCD6]
  P ADC Rate REF	[L-0036 48 0036103 BCD6]
  P ADC Rate FDBK	[L-0036 54 0036104 BCD6]
  P ADC Current REF	[L-0036 60 0036105 BCD6]
  P Rotator Current REF-B	[L-0036 66 0036022 BCD6]
  P Rotator Data SMPLG Time	[L-0036 72 0036006 BCD6]
  P Rotator/ADC Test CMD VEL	[L-0036 78 0036049 BCD6]
  P Rotator/ADC Data SMPLG INTVL	[L-0036 84 003604A BCD6]
  P Rotator Real Angle	[S-0036 0 0036001 BCD6]
  P Rotator CMD ANS	[S-0036 6 0036002 BCD6]
  P AG/SH X Position Drive On	[E-0037 0:0 003700B]
  P AG/SH X Position Drive Off	[E-0037 0:1 003700C]
  P AG/SH Y Position Drive On	[E-0037 0:2 003700D]
  P AG/SH Y Position Drive Off	[E-0037 0:3 003700E]
  P AG/SH Z Position Drive On	[E-0037 0:4 003700F]
  P AG/SH Z Position Drive Off	[E-0037 0:5 0037010]
  P AG/SH X Drive Ready	[E-0037 1:0 0037077]
  P AG/SH Y Drive Ready	[E-0037 1:1 0037078]
  P AG/SH Z Drive Ready	[E-0037 1:2 0037079]
  P AG/SH P Selected	[E-0037 2:0 0037011]
  P AG/SH Position Mode	[E-0037 3:0 003704F]
  P AG/SH Test Mode	[E-0037 3:1 0037014]
  P AG/SH Slew Mode	[E-0037 3:3 0037050]
  P AG/SH Limit Reset	[E-0037 3:4 003707A]
  P AG/SH HOME Mode	[E-0037 3:5 003704E]
  P AG/SH X DPA Fault	[E-0037 7:0 0037030]
  P AG/SH Y DPA Fault	[E-0037 7:1 0037031]
  P AG/SH Z DPA Fault	[E-0037 7:2 0037032]
  P AG/SH Fault	[E-0037 8:0 0037036]
  MLP1-P AG/SH Alarm	[E-0037 8:1 0037037]
  P AG/SH Total Fan Alarm	[E-0037 8:2 0037038]
  P AG/SH Local	[E-0037 8:3 0037039]
  TSC COML PWR Fault on ASCU	[E-0037 8:5 003703A]
  P AG/SH MAINT	[E-0037 8:6 003703B]
  P AG/SH EXT CLK Alarm	[E-0037 8:7 003703C]
  P AG/SH ENCDR Not INIT	[E-0037 9:0 003703D]
  P AG/SH X ENCDR Not Zeroed	[E-0037 9:1 003703E]
  P AG/SH X ENCDR Zeroing	[E-0037 9:2 003703F]
  P AG/SH Y ENCDR Not Zeroed	[E-0037 9:4 0037041]
  P AG/SH Y ENCDR Zeroing	[E-0037 9:5 0037042]
  P AG/SH Z ENCDR Not Zeroed	[E-0037 11:1 0037044]
  P AG/SH Z ENCDR Zeroing	[E-0037 11:2 0037045]
  P AG/SH X ENCDR-1 Alarm	[E-0037 12:0 0037055]
  P AG/SH X ENCDR-2 Alarm	[E-0037 12:1 0037056]
  P AG/SH X ENCDR-1 Not Used	[E-0037 12:2 0037057]
  P AG/SH X ENCDR-2 Not Used	[E-0037 12:3 0037058]
  P AG/SH Y ENCDR Alarm	[E-0037 13:0 0037059]
  P AG/SH Z ENCDR Alarm	[E-0037 14:0 003705D]
  P AG/SH X 1st Limit -	[E-0037 18:4 0037023]
  P AG/SH X 1st Limit +	[E-0037 18:5 0037024]
  P AG/SH Y 1st Limit -	[E-0037 18:6 0037025]
  P AG/SH Y 1st Limit +	[E-0037 18:7 0037026]
  P AG/SH Z 1st Limit -	[E-0037 19:0 0037027]
  P AG/SH Z 1st Limit +	[E-0037 19:1 0037028]
  P AG/SH X 2nd Limit -	[E-0037 19:2 0037029]
  P AG/SH X 2nd Limit +	[E-0037 19:3 003702A]
  P AG/SH Y 2nd Limit -	[E-0037 19:4 003702B]
  P AG/SH Y 2nd Limit +	[E-0037 19:5 003702C]
  P AG/SH Z 2nd Limit -	[E-0037 19:6 003702D]
  P AG/SH Z 2nd Limit +	[E-0037 19:7 003702E]
  P AG/SH DPA2 Fault	[E-0037 20:0 003706D]
  P AG/SH DPA3 Fault	[E-0037 20:1 003706E]
  P TCSPU1/4(CS) Fault	[E-0037 21:0 003706F]
  P TCADU1(ASCU) Fault	[E-0037 21:3 0037071]
  P AG/SH Safety SW	[E-0037 21:6 003702F]
  P AG/SH EMER Stop	[E-0037 21:7 0037074]
  P AG/SH Test Pattern	[E-0037 29 0037015 BCD1]
  P AG/SH Test Result	[E-0037 30 0037016 BCD1]
  P AG/SH Test Ready	[E-0037 30:0 0037051]
  P AG/SH Test	[E-0037 30:1 0037052]
  P AG/SH Test Data Send	[E-0037 30:2 0037053]
  P AG/SH Test Data End	[E-0037 30:3 0037054]
  P AG/SH X Real Position	[L-0037 0 0037001 BCD6]
  P AG/SH Y Real Position	[L-0037 6 0037002 BCD6]
  P AG/SH Z Real Position	[L-0037 12 0037003 BCD6]
  P AG/SH X CMD Position ANS	[L-0037 18 0037004 BCD6]
  P AG/SH Y CMD Position ANS	[L-0037 24 0037005 BCD6]
  P AG/SH Z CMD Position ANS	[L-0037 30 0037006 BCD6]
  P AG/SH X Position Error	[L-0037 36 0037007 BCD6]
  P AG/SH Y Position Error	[L-0037 42 0037008 BCD6]
  P AG/SH Z Position Error	[L-0037 48 0037009 BCD6]
  P AG/SH X Rate REF	[L-0037 60 003705E BCD6]
  P AG/SH Y Rate REF	[L-0037 66 003705F BCD6]
  P AG/SH Z Rate REF	[L-0037 72 0037060 BCD6]
  P AG/SH X Rate FDBK-A	[L-0037 78 0037061 BCD6]
  P AG/SH X Rate FDBK-B	[L-0037 84 0037062 BCD6]
  P AG/SH Y Rate FDBK-A	[L-0037 90 0037063 BCD6]
  P AG/SH Y Rate FDBK-B	[L-0037 96 0037064 BCD6]
  P AG/SH Z Rate FDBK	[L-0037 102 0037065 BCD6]
  P AG/SH X Current REF-A	[L-0037 108 0037066 BCD6]
  P AG/SH X Current REF-B	[L-0037 114 0037067 BCD6]
  P AG/SH Y Current REF-A	[L-0037 120 0037068 BCD6]
  P AG/SH Y Current REF-B	[L-0037 126 0037069 BCD6]
  P AG/SH Z Current REF	[L-0037 132 003706A BCD6]
  P AG/SH Data SMPLG Time	[L-0037 138 003700A BCD6]
  P AG/SH CMD VEL ANS	[L-0037 144 0037075 BCD6]
  P AG/SH Data SMPLG INTVL	[L-0037 150 0037076 BCD6]
  Cryogenics Exh Chiller Pump OPN	[E-0038 0:0 0038007]
  Cryogenics Exh Chiller Pump Stop	[E-0038 0:1 0038008]
  Cryogenics Exh Pump OPN	[E-0038 0:4 0038009]
  Cryogenics Exh Pump Stop	[E-0038 0:5 003800A]
  Cryogenics Exh Chiller-B OPN	[E-0038 1:0 003800B]
  Cryogenics Exh Chiller-B Stop	[E-0038 1:1 003800C]
  Cryogenics Exh Chiler Pump Alarm	[E-0038 1:4 003800D]
  Cryogenics Exh Pump Alarm	[E-0038 2:0 003800E]
  Cryogenics Exh Chiller-B Alarm	[E-0038 2:4 003800F]
  Cryogenics Exh Tank Level Alarm	[E-0038 3:0 0038010]
  MLP3-Cryogenics Exh Alarm	[E-0038 3:4 0038011]
  Cryogenics Exh Total Alarm	[E-0038 4:0 0038012]
  Cryogenics Exh Chiller Out Temp	[L-0038 0 0038001 BCD6]
  Cryogenics Exh Chiller In Temp	[L-0038 6 0038002 BCD6]
  Cryogenics Exh Coolant Temp	[L-0038 12 0038003 BCD6]
  Cryogenics Exh Coolant-Return Temp	[L-0038 18 0038004 BCD6]
  Cryogenics Exh Coolant Flow	[L-0038 24 0038005 BCD6]
  Cryogenics Exh Coolant Pressure	[L-0038 30 0038006 BCD6]
  Rdn Exh Local	[E-0039 0:0 003900E]
  Rdn Exh Chiller Pump OPN	[E-0039 0:4 003900F]
  Rdn Exh Chiller Pump Stop	[E-0039 0:5 0039010]
  Rdn Exh A(TLSCP)/B Pump OPN	[E-0039 1:0 0039011]
  Rdn Exh A(TLSCP)/B Pump Stop	[E-0039 1:1 0039012]
  Rdn Exh A(Mirror)/C Pump OPN	[E-0039 1:4 0039013]
  Rdn Exh A(Mirror)/C Pump Stop	[E-0039 1:5 0039014]
  Rdn Exh Chiller OPN	[E-0039 2:0 0039015]
  Rdn Exh Chiller Stop	[E-0039 2:1 0039016]
  Rdn Exh Man Selected	[E-0039 2:4 0039017]
  Rdn Exh Auto Selected	[E-0039 2:5 0039018]
  Rdn Exh Self Circulation Selected	[E-0039 2:6 0039019]
  Rdn Exh Check Selected	[E-0039 2:7 003901A]
  Rdn Exh A Selected	[E-0039 3:0 003901B]
  Rdn Exh B Selected	[E-0039 3:1 003901C]
  Rdn Exh C Selected	[E-0039 3:2 003901D]
  Rdn Exh Unit-A Backup Auto	[E-0039 3:4 003901E]
  Rdn Exh Unit-A Backup Off	[E-0039 3:5 003901F]
  Rdn Exh Unit-B Backup Auto	[E-0039 4:0 0039020]
  Rdn Exh Unit-B Backup Off	[E-0039 4:1 0039021]
  Rdn Exh Unit-C Backup Auto	[E-0039 4:4 0039022]
  Rdn Exh Unit-C Backup Off	[E-0039 4:5 0039023]
  Rdn Exh XV-1 Open	[E-0039 5:0 0039024]
  Rdn Exh XV-1 Close	[E-0039 5:1 0039025]
  Rdn Exh XV-2 Open	[E-0039 5:2 0039026]
  Rdn Exh XV-2 Close	[E-0039 5:3 0039027]
  Rdn Exh XV-3 Open	[E-0039 5:4 0039028]
  Rdn Exh XV-3 Close	[E-0039 5:5 0039029]
  Rdn Exh XV-4 Open	[E-0039 5:6 003902A]
  Rdn Exh XV-4 Close	[E-0039 5:7 003902B]
  Rdn Exh XV-5 Open	[E-0039 6:0 003902C]
  Rdn Exh XV-5 Close	[E-0039 6:1 003902D]
  Rdn Exh XV-6 Open	[E-0039 6:2 003902E]
  Rdn Exh XV-6 Close	[E-0039 6:3 003902F]
  Rdn Exh XV-7 Open	[E-0039 6:4 0039030]
  Rdn Exh XV-7 Close	[E-0039 6:5 0039031]
  Rdn Exh XV-8 Open	[E-0039 6:6 0039032]
  Rdn Exh XV-8 Close	[E-0039 6:7 0039033]
  Rdn Exh Safety SW	[E-0039 7:0 0039034]
  Rdn Exh Chiller Pump Alarm	[E-0039 7:4 0039035]
  Rdn Exh A(TLSCP)/B Pump Alarm	[E-0039 8:0 0039036]
  Rdn Exh A(Mirror)/C Pump Alarm	[E-0039 8:4 0039037]
  Rdn Exh Chiller Alarm	[E-0039 9:0 0039038]
  Rdn Exh Tank Level Alarm	[E-0039 9:4 0039039]
  MLP3-Rdn Exh Alarm	[E-0039 10:0 003903A]
  Rdn Exh Total Alarm	[E-0039 10:4 003903B]
  Rdn Exh Chiller In Temp	[L-0039 0 0039001 BCD6]
  Rdn Exh Chiller Out Temp	[L-0039 6 0039002 BCD6]
  Rdn Exh A(TLSCP)/B Coolant Temp	[L-0039 12 0039003 BCD6]
  Rdn Exh A(TLSCP)/B Return Temp	[L-0039 18 0039004 BCD6]
  Rdn Exh A(Mirror)/C Coolant Temp	[L-0039 24 0039005 BCD6]
  Rdn Exh A(Mirror)/C Return Temp	[L-0039 30 0039006 BCD6]
  Rdn Exh A(TLSCP)/B Flow	[L-0039 36 0039007 BCD6]
  Rdn Exh A(Mirror)/C Flow	[L-0039 42 0039008 BCD6]
  Rdn Exh A(TLSCP) Pressure	[L-0039 48 0039009 BCD6]
  Rdn Exh A(Mirror) Pressure	[L-0039 54 003900A BCD6]
  Rdn Exh B Pressure	[L-0039 60 003900B BCD6]
  Rdn Exh A(TLSCP) Coolant Temp CMD	[L-0039 66 003900C BCD6]
  Rdn Exh A(Mirror) Coolant Temp CMD	[L-0039 72 003900D BCD6]
  Cart Ready	[E-003A 0:0 003A001]
  Cart Pause	[E-003A 0:1 003A002]
  Cart Emergency Stop	[E-003A 0:2 003A003]
  Cart Auto	[E-003A 0:3 003A004]
  Cart Alarm	[E-003A 0:4 003A005]
  Cart Communication Alarm	[E-003A 0:5 003A006]
  Cart Current Position	[E-003A 1 003A007 BINARY1_1]
  Cart Next Position	[E-003A 2 003A008 BINARY1_1]
  Cart Jack Level	[E-003A 3 003A009 BINARY1_1]
  Cart Install On1	[E-003A 4:0 003A00A]
  Cart Install On2	[E-003A 4:1 003A00B]
  Cart Install On3	[E-003A 4:2 003A00C]
  Cart Install On4	[E-003A 4:3 003A00D]
  Cart Battery Level	[E-003A 5 003A00E BINARY1_1]
  Cart Charge Ready	[E-003A 6:0 003A00F]
  Cart Charge On	[E-003A 6:1 003A010]
  Cart Charge Complete	[E-003A 6:2 003A011]
  Cart Load Cell1	[E-003A 7 003A012 BINARY1_1]
  Cart Load Cell2	[E-003A 8 003A013 BINARY1_1]
  Cart Load Cell3	[E-003A 9 003A014 BINARY1_1]
  Cart Load Cell4	[E-003A 10 003A015 BINARY1_1]
  Cart Jack Ground1	[E-003A 11:0 003A016]
  Cart Jack Ground2	[E-003A 11:1 003A017]
  Cart Jack Ground3	[E-003A 11:2 003A018]
  Cart Jack Ground4	[E-003A 11:3 003A019]
  Cart Run Execute	[E-003A 12:0 003A01F]
  Cart Jack Execute	[E-003A 12:1 003A020]
  Cart Local	[E-003A 12:2 003A15F]
  Opt Stand-by Room Ready	[E-003A 12:4 003A021]
  Opt Stand-by Room Pause	[E-003A 12:5 003A022]
  Opt Stand-by Room Emergency	[E-003A 12:6 003A023]
  Opt Stand-by Room Auto	[E-003A 12:7 003A024]
  Opt Stand-by Room Alarm	[E-003A 13:0 003A025]
  Opt Stand-by Room I/F Alarm	[E-003A 13:1 003A026]
  Opt Stand-by Room Fix Hook	[E-003A 13:4 003A027]
  Opt Stand-by Room Fix UnHook	[E-003A 13:5 003A028]
  Opt Stand-by Room Fix Bolt Up	[E-003A 13:6 003A029]
  Opt Stand-by Room Fix Bolt Down	[E-003A 13:7 003A02A]
  Opt Stand-by Room Fix Install On	[E-003A 14:0 003A02B]
  Opt Stand-by Room Move Hook	[E-003A 14:4 003A02C]
  Opt Stand-by Room Move UnHook	[E-003A 14:5 003A02D]
  Opt Stand-by Room Move Bolt Up	[E-003A 14:6 003A02F]
  Opt Stand-by Room Move Bolt Down	[E-003A 14:7 003A030]
  Opt Stand-by Room Move Install On	[E-003A 15:0 003A031]
  Opt Stand-by Room Rotate Store	[E-003A 15:4 003A032]
  Opt Stand-by Room Rotate Desorb	[E-003A 15:5 003A033]
  Opt Stand-by Room TRANS Forward	[E-003A 15:6 003A034]
  Opt Stand-by Room TRANS Back	[E-003A 15:7 003A035]
  Opt Stand-by Room Charge Forward	[E-003A 16:0 003A036]
  Opt Stand-by Room Charge Back	[E-003A 16:1 003A037]
  Opt Stand-by Room Charge Power	[E-003A 16:2 003A038]
  Opt Stand-by Room Air Press Hi	[E-003A 16:4 003A039]
  Opt Stand-by Room Air Press Low	[E-003A 16:5 003A03A]
  IR Stand-by Room Ready	[E-003A 17:0 003A03B]
  IR Stand-by Room Pause	[E-003A 17:1 003A03C]
  IR Stand-by Room Emergency	[E-003A 17:2 003A03D]
  IR Stand-by Room Auto	[E-003A 17:3 003A03E]
  IR Stand-by Room Alarm	[E-003A 17:4 003A03F]
  IR Stand-by Room I/F Alarm	[E-003A 17:5 003A040]
  IR Stand-by Room Fix Hook	[E-003A 18:0 003A041]
  IR Stand-by Room Fix UnHook	[E-003A 18:1 003A042]
  IR Stand-by Room Fix Bolt Up	[E-003A 18:2 003A043]
  IR Stand-by Room Fix Bolt Down	[E-003A 18:3 003A044]
  IR Stand-by Room Fix Install On	[E-003A 18:4 003A045]
  IR Stand-by Room Move Hook	[E-003A 19:0 003A046]
  IR Stand-by Room Move UnHook	[E-003A 19:1 003A047]
  IR Stand-by Room Move Bolt Up	[E-003A 19:2 003A048]
  IR Stand-by Room Move Bolt Down	[E-003A 19:3 003A049]
  IR Stand-by Room Move Install On	[E-003A 19:4 003A04A]
  IR Stand-by Room Rotate Store	[E-003A 20:0 003A04B]
  IR Stand-by Room Rotate Desorb	[E-003A 20:1 003A04C]
  IR Stand-by Room TRANS Forward	[E-003A 20:2 003A04D]
  IR Stand-by Room TRANS Back	[E-003A 20:3 003A04E]
  IR Stand-by Room Charge Forward	[E-003A 20:4 003A04F]
  IR Stand-by Room Charge Back	[E-003A 20:5 003A050]
  IR Stand-by Room Charge Power	[E-003A 20:6 003A051]
  IR Stand-by Room Air Press Hi	[E-003A 21:0 003A052]
  IR Stand-by Room Air Press Low	[E-003A 21:1 003A053]
  Opt Door Open SW	[E-003A 21:4 003A054]
  Opt Door Close SW	[E-003A 21:5 003A055]
  Opt Door Stop SW	[E-003A 21:6 003A056]
  Opt Move Install Power SW	[E-003A 21:7 003A057]
  Opt Fix Install Power SW	[E-003A 22:0 003A058]
  Opt Move Light SW	[E-003A 22:1 003A059]
  Opt Fix Light SW	[E-003A 22:2 003A05A]
  Opt PC Reset SW	[E-003A 22:3 003A05B]
  Opt Door Open	[E-003A 22:4 003A05C]
  Opt Door Close	[E-003A 22:5 003A05D]
  Opt Move Install Power	[E-003A 22:6 003A05E]
  Opt Fix Install Power	[E-003A 22:7 003A05F]
  Opt Fix Install ID	[E-003A 24 003A060 BINARY1_1]
  Opt Move Install ID	[E-003A 25 003A061 BINARY1_1]
  IR Door Open SW	[E-003A 26:0 003A06A]
  IR Door Close SW	[E-003A 26:1 003A06B]
  IR Door Stop SW	[E-003A 26:2 003A06C]
  IR Move Install Power SW	[E-003A 26:3 003A06D]
  IR Fix Install Power SW	[E-003A 26:4 003A06E]
  IR Move Light SW	[E-003A 26:5 003A06F]
  IR Fix Light SW	[E-003A 26:6 003A070]
  IR PC Reset SW	[E-003A 26:7 003A071]
  IR Door Open	[E-003A 27:0 003A072]
  IR Door Close	[E-003A 27:1 003A073]
  IR Move Install Power	[E-003A 27:2 003A074]
  IR Fix Install Power	[E-003A 27:3 003A075]
  IR Fix Install ID	[E-003A 28 003A076 BINARY1_1]
  IR Move Install ID	[E-003A 29 003A077 BINARY1_1]
  Cs CIAX3 Power	[E-003A 30:0 003A080]
  Cs CIAX3 Emergency Stop	[E-003A 30:1 003A081]
  Cs CCD Power	[E-003A 30:2 003A082]
  Cs LAN Power	[E-003A 30:3 003A083]
  Cs Install Power	[E-003A 30:4 003A084]
  Cs Install ID	[E-003A 31 003A085 BINARY1_1]
  Focas Communication Alarm	[E-003A 32:0 003A086]
  Focas Mount Pin	[E-003A 32:1 003A087]
  Focas Mount Pin1 In	[E-003A 32:4 003A088]
  Focas Mount Pin1 Out	[E-003A 32:5 003A089]
  Focas Mount Pin2 In	[E-003A 32:6 003A08A]
  Focas Mount Pin2 Out	[E-003A 32:7 003A08B]
  Focas Mount Pin3 In	[E-003A 33:0 003A08C]
  Focas Mount Pin3 Out	[E-003A 33:1 003A08D]
  Focas Mount Pin4 In	[E-003A 33:2 003A08E]
  Focas Mount Pin4 Out	[E-003A 33:3 003A08F]
  Focas Mount On 1	[E-003A 33:4 003A090]
  Focas Mount On 2	[E-003A 33:5 003A091]
  Focas Mount On 3	[E-003A 33:6 003A092]
  Focas Mount On 4	[E-003A 33:7 003A093]
  Focas Mount Power SW1	[E-003A 34:0 003A094]
  Focas Mount Power SW2	[E-003A 34:1 003A095]
  Focas Mount Power SW3	[E-003A 34:2 003A096]
  Focas Mount Power SW4	[E-003A 34:3 003A097]
  CIAX3 Remote	[E-003A 35:4 003A098]
  CIAX3 Control Motor Fault	[E-003A 35:5 003A099]
  CIAX3 Angle Not Ready	[E-003A 35:6 003A09A]
  CIAX3 X(A) Motor Ready	[E-003A 36:0 003A09B]
  CIAX3 X(B) Motor Ready	[E-003A 36:1 003A09C]
  CIAX3 X(C) Motor Ready	[E-003A 36:2 003A09D]
  CIAX3 X(A) Motor On	[E-003A 36:4 003A09E]
  CIAX3 X(B) Motor On	[E-003A 36:5 003A09F]
  CIAX3 X(C) Motor On	[E-003A 36:6 003A100]
  CIAX3 X(A) Motor Off	[E-003A 37:0 003A101]
  CIAX3 X(B) Motor Off	[E-003A 37:1 003A102]
  CIAX3 X(C) Motor Off	[E-003A 37:2 003A103]
  CIAX3 Y(A) Motor Ready	[E-003A 37:4 003A104]
  CIAX3 Y(B) Motor Ready	[E-003A 37:5 003A105]
  CIAX3 Y(C) Motor Ready	[E-003A 37:6 003A106]
  CIAX3 Y(A) Motor On	[E-003A 38:0 003A107]
  CIAX3 Y(B) Motor On	[E-003A 38:1 003A108]
  CIAX3 Y(C) Motor On	[E-003A 38:2 003A109]
  CIAX3 Y(A) Motor Off	[E-003A 38:4 003A10A]
  CIAX3 Y(B) Motor Off	[E-003A 38:5 003A10B]
  CIAX3 Y(C) Motor Off	[E-003A 38:6 003A10C]
  CIAX3 Z(A) Motor Ready	[E-003A 39:0 003A10D]
  CIAX3 Z(B) Motor Ready	[E-003A 39:1 003A10E]
  CIAX3 Z(C) Motor Ready	[E-003A 39:2 003A10F]
  CIAX3 Z(A) Motor On	[E-003A 39:4 003A110]
  CIAX3 Z(B) Motor On	[E-003A 39:5 003A111]
  CIAX3 Z(C) Motor On	[E-003A 39:6 003A112]
  CIAX3 Z(A) Motor Off	[E-003A 40:0 003A113]
  CIAX3 Z(B) Motor Off	[E-003A 40:1 003A114]
  CIAX3 Z(C) Motor Off	[E-003A 40:2 003A115]
  CIAX3 OBE Position A	[E-003A 40:4 003A116]
  CIAX3 OBE Position B	[E-003A 40:5 003A117]
  CIAX3 OBE Position C	[E-003A 40:6 003A118]
  CIAX3 Maint Position	[E-003A 41:0 003A119]
  CIAX3 X(A) Motor Fault	[E-003A 41:4 003A11A]
  CIAX3 X(B) Motor Fault	[E-003A 41:5 003A11B]
  CIAX3 X(C) Motor Fault	[E-003A 41:6 003A11C]
  CIAX3 Y(A) Motor Fault	[E-003A 42:0 003A11D]
  CIAX3 Y(B) Motor Fault	[E-003A 42:1 003A11E]
  CIAX3 Y(C) Motor Fault	[E-003A 42:2 003A11F]
  CIAX3 Z(A) Motor Fault	[E-003A 42:4 003A120]
  CIAX3 Z(B) Motor Fault	[E-003A 42:5 003A121]
  CIAX3 Z(C) Motor Fault	[E-003A 42:6 003A122]
  CIAX3 X(A)(R) Limit1	[E-003A 43:0 003A123]
  CIAX3 X(A)(R) Limit2	[E-003A 43:1 003A124]
  CIAX3 X(A)(R) Torque Alarm	[E-003A 43:2 003A125]
  CIAX3 X(A)(L) Limit1	[E-003A 43:4 003A126]
  CIAX3 X(A)(L) Limit2	[E-003A 43:5 003A127]
  CIAX3 X(A)(L) Torque Alarm	[E-003A 43:6 003A128]
  CIAX3 X(B)(R) Limit1	[E-003A 44:0 003A129]
  CIAX3 X(B)(R) Limit2	[E-003A 44:1 003A12A]
  CIAX3 X(B)(R) Torque Alarm	[E-003A 44:2 003A12B]
  CIAX3 X(B)(L) Limit1	[E-003A 44:4 003A12C]
  CIAX3 X(B)(L) Limit2	[E-003A 44:5 003A12D]
  CIAX3 X(B)(L) Torque Alarm	[E-003A 44:6 003A12F]
  CIAX3 X(C)(R) Limit1	[E-003A 45:0 003A130]
  CIAX3 X(C)(R) Limit2	[E-003A 45:1 003A131]
  CIAX3 X(C)(R) Torque Alarm	[E-003A 45:2 003A132]
  CIAX3 X(C)(L) Limit1	[E-003A 45:4 003A133]
  CIAX3 X(C)(L) Limit2	[E-003A 45:5 003A134]
  CIAX3 X(C)(L) Torque Alarm	[E-003A 45:6 003A135]
  CIAX3 Y(A) Forward Limit	[E-003A 46:0 003A136]
  CIAX3 Y(A) Back Limit	[E-003A 46:1 003A137]
  CIAX3 Y(B) Forward Limit	[E-003A 46:2 003A138]
  CIAX3 Y(B) Back Limit	[E-003A 46:3 003A139]
  CIAX3 Y(C) Limit	[E-003A 46:4 003A13A]
  CIAX3 Z(A) Up Limit1	[E-003A 47:0 003A13B]
  CIAX3 Z(A) Down Limit1	[E-003A 47:1 003A13C]
  CIAX3 Z(A) Up Limit2	[E-003A 47:2 003A13D]
  CIAX3 Z(A) Down Limit2	[E-003A 47:3 003A13E]
  CIAX3 Z(B) Up Limit1	[E-003A 47:4 003A13F]
  CIAX3 Z(B) Down Limit1	[E-003A 47:5 003A140]
  CIAX3 Z(B) Up Limit2	[E-003A 47:6 003A141]
  CIAX3 Z(B) Down Limit2	[E-003A 47:7 003A142]
  CIAX3 Z(C) Up Limit1	[E-003A 48:0 003A143]
  CIAX3 Z(C) Down Limit1	[E-003A 48:1 003A144]
  CIAX3 Z(C) Up Limit2	[E-003A 48:2 003A145]
  CIAX3 Z(C) Down Limit2	[E-003A 48:3 003A146]
  Cart Collision Sensor	[L-003A 0 003A01A BINARY4_1]
  Cart Jack Pulse1	[L-003A 4 003A01B BINARY4_1]
  Cart Jack Pulse2	[L-003A 8 003A01C BINARY4_1]
  Cart Jack Pulse3	[L-003A 12 003A01D BINARY4_1]
  Cart Jack Pulse4	[L-003A 16 003A01E BINARY4_1]
  Opt Fix Z1	[L-003A 20 003A062 BINARY1_1]
  Opt Fix Z2	[L-003A 21 003A063 BINARY1_1]
  Opt Fix Z3	[L-003A 22 003A064 BINARY1_1]
  Opt Fix Z4	[L-003A 23 003A065 BINARY1_1]
  Opt Move Z1	[L-003A 24 003A066 BINARY1_1]
  Opt Move Z2	[L-003A 25 003A067 BINARY1_1]
  Opt Move Z3	[L-003A 26 003A068 BINARY1_1]
  Opt Move Z4	[L-003A 27 003A069 BINARY1_1]
  IR Fix Z1	[L-003A 28 003A078 BINARY1_1]
  IR Fix Z2	[L-003A 29 003A079 BINARY1_1]
  IR Fix Z3	[L-003A 30 003A07A BINARY1_1]
  IR Fix Z4	[L-003A 31 003A07B BINARY1_1]
  IR Move Z1	[L-003A 32 003A07C BINARY1_1]
  IR Move Z2	[L-003A 33 003A07D BINARY1_1]
  IR Move Z3	[L-003A 34 003A07E BINARY1_1]
  IR Move Z4	[L-003A 35 003A07F BINARY1_1]
  CIAX3 X(A) Position	[L-003A 36 003A147 BINARY4_0p1]
  CIAX3 X(B) Position	[L-003A 40 003A148 BINARY4_0p1]
  CIAX3 X(C) Position	[L-003A 44 003A149 BINARY4_0p1]
  CIAX3 Y(A) Position	[L-003A 48 003A14A BINARY4_0p1]
  CIAX3 Y(B) Position	[L-003A 52 003A14B BINARY4_0p1]
  CIAX3 Y(C) Position	[L-003A 56 003A14C BINARY4_0p1]
  CIAX3 Z(A) Position1	[L-003A 60 003A14D BINARY4_0p1]
  CIAX3 Z(A) Position2	[L-003A 64 003A14E BINARY4_0p1]
  CIAX3 Z(A) Position3	[L-003A 68 003A14F BINARY4_0p1]
  CIAX3 Z(A) Position4	[L-003A 72 003A150 BINARY4_0p1]
  CIAX3 Z(B) Position1	[L-003A 76 003A151 BINARY4_0p1]
  CIAX3 Z(B) Position2	[L-003A 80 003A152 BINARY4_0p1]
  CIAX3 Z(B) Position3	[L-003A 84 003A153 BINARY4_0p1]
  CIAX3 Z(B) Position4	[L-003A 88 003A154 BINARY4_0p1]
  CIAX3 Z(C) Position1	[L-003A 92 003A155 BINARY4_0p1]
  CIAX3 Z(C) Position2	[L-003A 96 003A156 BINARY4_0p1]
  CIAX3 Z(C) Position3	[L-003A 100 003A157 BINARY4_0p1]
  CIAX3 Z(C) Position4	[L-003A 104 003A158 BINARY4_0p1]
  CIAX3 Z(A) Jack1	[L-003A 108 003A159 BINARY4_0p1]
  CIAX3 Z(A) Jack2	[L-003A 112 003A15A BINARY4_0p1]
  CIAX3 Z(B) Jack1	[L-003A 116 003A15B BINARY4_0p1]
  CIAX3 Z(B) Jack2	[L-003A 120 003A15C BINARY4_0p1]
  CIAX3 Z(C) Jack1	[L-003A 124 003A15D BINARY4_0p1]
  CIAX3 Z(C) Jack2	[L-003A 128 003A15E BINARY4_0p1]
  PIR AG for SH Exposure On	[E-003B 0:0 003B002]
  PIR AG for SH Exposure Off	[E-003B 0:1 003B003]
  PIR AG for SH Star Detect Start	[E-003B 0:2 003B004]
  PIR AG for SH Star Detect Stop	[E-003B 0:3 003B005]
  PIR AG for SH Exposure Time	[E-003B 1 003B001 BINARY4_1]
  PIR AG for SH Lower Limit	[E-003B 5 003B010 BINARY2_1]
  PIR AG for SH Upper Limit	[E-003B 7 003B011 BINARY2_1]
  PIR AG for SH Video Area X	[E-003B 9 003B006 BINARY2_1]
  PIR AG for SH Video Area Y	[E-003B 11 003B007 BINARY2_1]
  PIR AG for SH Video Area Width X	[E-003B 13 003B008 BINARY2_1]
  PIR AG for SH Video Area Width Y	[E-003B 15 003B009 BINARY2_1]
  PIR AG for SH DET Area X	[E-003B 17 003B00A BINARY2_1]
  PIR AG for SH DET Area Y	[E-003B 19 003B00B BINARY2_1]
  PIR AG for SH DET Area Width X	[E-003B 21 003B00C BINARY2_1]
  PIR AG for SH DET Area Width Y	[E-003B 23 003B00D BINARY2_1]
  PIR AG for SH Star Position X	[E-003B 25 003B00E BINARY4_0p01]
  PIR AG for SH Star Position Y	[E-003B 29 003B00F BINARY4_0p01]
  PIR AG for SH Binning Pattern	[E-003B 33 003B012 BINARY1_1]
  PIR AG for SH Image Data Delay Time	[E-003B 34 003B013 BINARY4_1]
  PIR Fibre AG Exposure On	[E-003B 38:0 003B01E]
  PIR Fibre AG Exposure Off	[E-003B 38:1 003B01F]
  PIR Fibre AG Star Detect Start	[E-003B 38:2 003B020]
  PIR Fibre AG Star Detect Stop	[E-003B 38:3 003B021]
  PIR Fibre AG Exposure Time	[E-003B 39 003B01D BINARY4_1]
  PIR Fibre AG Image Data Delay Time	[E-003B 43 003B022 BINARY4_1]
  PIR AG/SH Probe Drive On	[E-003B 47:0 003B02A]
  PIR AG/SH Probe Drive Off	[E-003B 47:1 003B02B]
  PIR AG/SH Probe Drive Ready	[E-003B 47:2 003B02C]
  PIR AG/SH Probe ENCDR Not Zeroed	[E-003B 48:0 003B02D]
  PIR AG/SH Probe ENCDR Zeroing	[E-003B 48:1 003B02E]
  PIR AG Entrance Shutter Open	[E-003B 49:0 003B033]
  PIR AG Entrance Shutter Close	[E-003B 49:1 003B034]
  PIR AG Shutter Init Not Ready	[E-003B 49:2 003B035]
  PIR AG Shutter Init Run	[E-003B 49:3 003B036]
  PIR z Drive On	[E-003B 50:0 003B03D]
  PIR z Drive Off	[E-003B 50:1 003B03E]
  PIR z Drive Ready	[E-003B 50:2 003B03F]
  PIR  z Link Not Zeroed	[E-003B 51:0 003B040]
  PIR z ENCDR Zeroing	[E-003B 51:1 003B041]
  PIR r Drive On	[E-003B 52:0 003B042]
  PIR r Drive Off	[E-003B 52:1 003B043]
  PIR r Drive Ready	[E-003B 52:2 003B044]
  PIR r Link Not Zeroed	[E-003B 53:0 003B045]
  PIR r ENCDR Zeroing	[E-003B 53:1 003B046]
  PIR FAM Motor1 Up Limit	[E-003B 58:0 003B047]
  PIR FAM Motor1 Down Limit	[E-003B 58:1 003B048]
  PIR FAM Motor2 Up Limit	[E-003B 58:2 003B049]
  PIR FAM Motor2 Down Limit	[E-003B 58:3 003B04A]
  PIR FAM Motor3 Up Limit	[E-003B 58:4 003B04B]
  PIR FAM Motor3 Down Limit	[E-003B 58:5 003B04C]
  PIR CMM Motor1 Up Limit	[E-003B 59:0 003B04D]
  PIR CMM Motor1 Down Limit	[E-003B 59:1 003B04E]
  PIR CMM Motor2 Up Limit	[E-003B 59:2 003B04F]
  PIR CMM Motor2 Down Limit	[E-003B 59:3 003B050]
  PIR AG/SH Probe Up Limit	[E-003B 60:0 003B051]
  PIR AG/SH Probe Down Limit	[E-003B 60:1 003B052]
  PIR LMT0-1	[E-003B 61:0 003B053]
  PIR LMT0-2	[E-003B 61:1 003B054]
  PIR LMT0-3	[E-003B 61:2 003B055]
  PIR LMT0-4	[E-003B 61:3 003B056]
  PIR LMT0-5	[E-003B 61:4 003B057]
  PIR LMT0-6	[E-003B 61:5 003B058]
  PIR LMT0-7	[E-003B 61:6 003B059]
  PIR LMT0-8	[E-003B 61:7 003B05A]
  PIR LMT1-1	[E-003B 62:0 003B05B]
  PIR LMT1-2	[E-003B 62:1 003B05C]
  PIR LMT1-3	[E-003B 62:2 003B05D]
  PIR LMT1-4	[E-003B 62:3 003B05E]
  PIR LMT1-5	[E-003B 62:4 003B05F]
  PIR LMT1-6	[E-003B 62:5 003B060]
  PIR AG for SH Camera I/F Alarm	[E-003B 63:0 003B02F]
  PIR Fibre AG Camera I/F Alarm	[E-003B 63:1 003B030]
  PIR AG/SH Probe Fault	[E-003B 63:2 003B031]
  MLP1-OBCP I/F Alarm	[E-003B 63:3 003B032]
  PIR FAM Fault	[E-003B 63:4 003B061]
  PIR CMM Fault	[E-003B 63:5 003B062]
  PIR AG Video Output On(OBS)	[E-003B 64:0 003B063]
  PIR AG Video Output Off(OBS)	[E-003B 64:1 003B064]
  PIR AG Video Output On(TWS1)	[E-003B 65:0 003B065]
  PIR AG Video Output Off(TWS1)	[E-003B 65:1 003B066]
  PIR AG Video Output On(TWS2)	[E-003B 65:2 003B067]
  PIR AG Video Output Off(TWS2)	[E-003B 65:3 003B068]
  PIR AG OBS Output Interval	[E-003B 66 003B069 BINARY1_1]
  PIR AG TWS1 Output Interval	[E-003B 67 003B06A BINARY1_1]
  PIR AG TWS2 Output Interval	[E-003B 68 003B06B BINARY1_1]
  OBCP-VGW I/F Alarm	[E-003B 69:0 003B06C]
  OBCP-TWS1 I/F Alarm	[E-003B 69:1 003B06D]
  OBCP-TWS2 I/F Alarm	[E-003B 69:2 003B06E]
  PIR AG for SH Data Time	[L-003B 0 003B015 TIME8]
  PIR AG for SH Star Posn Error X	[L-003B 8 003B016 BINARY4_0p01]
  PIR AG for SH Star Posn Error Y	[L-003B 12 003B017 BINARY4_0p01]
  PIR AG for SH Star Posn Error AZ	[L-003B 16 003B018 BINARY4_0p001]
  PIR AG for SH Star Posn Error EL	[L-003B 20 003B019 BINARY4_0p001]
  PIR AG for SH Star Gravity Posn X	[L-003B 24 003B01B BINARY4_0p01]
  PIR AG for SH Star Gravity Posn Y	[L-003B 28 003B01C BINARY4_0p01]
  PIR AG for SH Image Size	[L-003B 32 003B014 BINARY4_0p01]
  PIR AG for SH Star Posn Intensity	[L-003B 36 003B01A BINARY2_1]
  PIR Fibre AG Data Time	[L-003B 38 003B023 TIME8]
  PIR Fibre AG Star Posn Error AZ	[L-003B 54 003B026 BINARY4_0p001]
  PIR Fibre AG Star Posn Error EL	[L-003B 58 003B027 BINARY4_0p001]
  PIR Fibre AG Image Size	[L-003B 62 003B037 BINARY4_0p01]
  PIR Fibre AG Star Posn Intensity	[L-003B 66 003B038 BINARY2_1]
  PIR AG/SH Probe Real Position	[L-003B 68 003B028 BCD6]
  PIR AG/SH Probe CMD Position ANS	[L-003B 74 003B029 BCD6]
  PIR z Real Position	[L-003B 84 003B039 BCD6]
  PIR z CMD Position ANS	[L-003B 90 003B03A BCD6]
  PIR r Real Position	[L-003B 96 003B03B BCD6]
  PIR r CMD Position ANS	[L-003B 102 003B03C BCD6]
  HYDRST EXH Chiller Pump Start	[E-003C 0:0 003C001]
  HYDRST EXH Chiller Pump Stop	[E-003C 0:1 003C002]
  HYDRST EXH Chiller Start	[E-003C 1:0 003C003]
  HYDRST EXH Chiller Stop	[E-003C 1:1 003C004]
  HYDRST EXH Chiller Pump Alarm	[E-003C 2:0 003C005]
  HYDRST EXH Chiller Alarm	[E-003C 3:0 003C006]
  HYDRST EXH Tank Level Alarm	[E-003C 4:0 003C007]
  HYDRST EXH Total Alarm	[E-003C 5:0 003C008]
  Zernike Offset Data 01 A11	[E-0040 0 0040001 BINARY2_0p01]
  Zernike Offset Data 02 A1m1	[E-0040 2 0040001 BINARY2_0p01]
  Zernike Offset Data 03 A20	[E-0040 4 0040001 BINARY2_0p01]
  Zernike Offset Data 04 A31	[E-0040 6 0040001 BINARY2_0p01]
  Zernike Offset Data 05 A3m1	[E-0040 8 0040001 BINARY2_0p01]
  Zernike Offset Data 06 A22	[E-0040 10 0040001 BINARY2_0p01]
  Zernike Offset Data 07 A2m2	[E-0040 12 0040001 BINARY2_0p01]
  Zernike Offset Data 08 A33	[E-0040 14 0040001 BINARY2_0p01]
  Zernike Offset Data 09 A3m3	[E-0040 16 0040001 BINARY2_0p01]
  Zernike Offset Data 10 A40	[E-0040 18 0040001 BINARY2_0p01]
  Zernike Offset Data 11 A42	[E-0040 20 0040001 BINARY2_0p01]
  Zernike Offset Data 12 A4m2	[E-0040 22 0040001 BINARY2_0p01]
  Zernike Offset Data 13 A44	[E-0040 24 0040001 BINARY2_0p01]
  Zernike Offset Data 14 A4m4	[E-0040 26 0040001 BINARY2_0p01]
  Zernike Offset Data 15 A51	[E-0040 28 0040001 BINARY2_0p01]
  Zernike Offset Data 16 A5m1	[E-0040 30 0040001 BINARY2_0p01]
  Zernike Offset Data 17 A53	[E-0040 32 0040001 BINARY2_0p01]
  Zernike Offset Data 18 A5m3	[E-0040 34 0040001 BINARY2_0p01]
  Zernike Offset Data 19 A55	[E-0040 36 0040001 BINARY2_0p01]
  Zernike Offset Data 20 A5m5	[E-0040 38 0040001 BINARY2_0p01]
  Zernike Offset Data 21 A60	[E-0040 40 0040001 BINARY2_0p01]
  Zernike Offset Data 22 A62	[E-0040 42 0040001 BINARY2_0p01]
  Zernike Offset Data 23 A6m2	[E-0040 44 0040001 BINARY2_0p01]
  Zernike Offset Data 24 A64	[E-0040 46 0040001 BINARY2_0p01]
  Zernike Offset Data 25 A6m4	[E-0040 48 0040001 BINARY2_0p01]
  Zernike Offset Data 26 A66	[E-0040 50 0040001 BINARY2_0p01]
  Zernike Offset Data 27 A6m6	[E-0040 52 0040001 BINARY2_0p01]
  Zernike Offset Data 28 A71	[E-0040 54 0040001 BINARY2_0p01]
  Zernike Offset Data 29 A7m1	[E-0040 56 0040001 BINARY2_0p01]
  Zernike Offset Data 30 A73	[E-0040 58 0040001 BINARY2_0p01]
  Zernike Offset Data 31 A7m3	[E-0040 60 0040001 BINARY2_0p01]
  Zernike Offset Data 32 A75	[E-0040 62 0040001 BINARY2_0p01]
  Zernike Offset Data 33 A7m5	[E-0040 64 0040001 BINARY2_0p01]
  Zernike Offset Data 34 A77	[E-0040 66 0040001 BINARY2_0p01]
  Zernike Offset Data 35 A7m7	[E-0040 68 0040001 BINARY2_0p01]
  Zernike Offset Data 36 A80	[E-0040 70 0040001 BINARY2_0p01]
  Zernike Offset Data 37 A82	[E-0040 72 0040001 BINARY2_0p01]
  Zernike Offset Data 38 A8m2	[E-0040 74 0040001 BINARY2_0p01]
  Zernike Offset Data 39 A84	[E-0040 76 0040001 BINARY2_0p01]
  Zernike Offset Data 40 A8m4	[E-0040 78 0040001 BINARY2_0p01]
  Zernike Offset Data 41 A86	[E-0040 80 0040001 BINARY2_0p01]
  Zernike Offset Data 42 A8m6	[E-0040 82 0040001 BINARY2_0p01]
  Zernike Offset Data 43 A88	[E-0040 84 0040001 BINARY2_0p01]
  Zernike Offset Data 44 A8m8	[E-0040 86 0040001 BINARY2_0p01]
  Zernike Offset Data 45 A91	[E-0040 88 0040001 BINARY2_0p01]
  Zernike Offset Data 46 A9m1	[E-0040 90 0040001 BINARY2_0p01]
  Zernike Offset Data 47 A93	[E-0040 92 0040001 BINARY2_0p01]
  Zernike Offset Data 48 A9m3	[E-0040 94 0040001 BINARY2_0p01]
  Zernike Offset Data 49 A95	[E-0040 96 0040001 BINARY2_0p01]
  Zernike Offset Data 50 A9m5	[E-0040 98 0040001 BINARY2_0p01]
  Zernike Offset Data 51 A97	[E-0040 100 0040001 BINARY2_0p01]
  Zernike Offset Data 52 A9m7	[E-0040 102 0040001 BINARY2_0p01]
  Zernike Offset Data 53 A99	[E-0040 104 0040001 BINARY2_0p01]
  Zernike Offset Data 54 A9m9	[E-0040 106 0040001 BINARY2_0p01]
  Zernike Offset Data 55 A100	[E-0040 108 0040001 BINARY2_0p01]
  Zernike Offset Data 56 A102	[E-0040 110 0040001 BINARY2_0p01]
  Zernike Offset Data 57 A10m2	[E-0040 112 0040001 BINARY2_0p01]
  Zernike Offset Data 58 A104	[E-0040 114 0040001 BINARY2_0p01]
  Zernike Offset Data 59 A10m4	[E-0040 116 0040001 BINARY2_0p01]
  Zernike Offset Data 60 A106	[E-0040 118 0040001 BINARY2_0p01]
  Zernike Offset Data 61 A10m6	[E-0040 120 0040001 BINARY2_0p01]
  Zernike Offset Data 62 A108	[E-0040 122 0040001 BINARY2_0p01]
  Zernike Offset Data 63 A10m8	[E-0040 124 0040001 BINARY2_0p01]
  Zernike Offset Data 64 A1010	[E-0040 126 0040001 BINARY2_0p01]
  Zernike Offset Data 65 A10m10	[E-0040 128 0040001 BINARY2_0p01]
  Eigen Calculated Time	[E-0040 130 0040002 TIME4]
  Eigen Data q01	[E-0040 142 0040004 REAL8]
  Eigen Data q02	[E-0040 150 0040004 REAL8]
  Eigen Data q03	[E-0040 158 0040004 REAL8]
  Eigen Data q04	[E-0040 166 0040004 REAL8]
  Eigen Data q05	[E-0040 174 0040004 REAL8]
  Eigen Data q06	[E-0040 182 0040004 REAL8]
  Eigen Data q07	[E-0040 190 0040004 REAL8]
  Eigen Data q08	[E-0040 198 0040004 REAL8]
  Eigen Data q09	[E-0040 206 0040004 REAL8]
  Eigen Data q10	[E-0040 214 0040004 REAL8]
  Eigen Data q11	[E-0040 222 0040004 REAL8]
  Eigen Data q12	[E-0040 230 0040004 REAL8]
  Eigen Data q13	[E-0040 238 0040004 REAL8]
  Eigen Data q14	[E-0040 246 0040004 REAL8]
  Eigen Data q15	[E-0040 254 0040004 REAL8]
  Eigen Data q16	[E-0040 262 0040004 REAL8]
  Eigen Data q17	[E-0040 270 0040004 REAL8]
  Eigen Data q18	[E-0040 278 0040004 REAL8]
  Eigen Data q19	[E-0040 286 0040004 REAL8]
  Eigen Data q20	[E-0040 294 0040004 REAL8]
  Eigen Data q21	[E-0040 302 0040004 REAL8]
  Eigen Data q22	[E-0040 310 0040004 REAL8]
  Eigen Data q23	[E-0040 318 0040004 REAL8]
  Eigen Data q24	[E-0040 326 0040004 REAL8]
  Eigen Data q25	[E-0040 334 0040004 REAL8]
  Eigen Data q26	[E-0040 342 0040004 REAL8]
  Eigen Data q27	[E-0040 350 0040004 REAL8]
  Eigen Data q28	[E-0040 358 0040004 REAL8]
  Eigen Data q29	[E-0040 366 0040004 REAL8]
  Eigen Data q30	[E-0040 374 0040004 REAL8]
  Eigen Data q31	[E-0040 382 0040004 REAL8]
  Eigen Data q32	[E-0040 390 0040004 REAL8]
  Actuator Force Of Eigen Data 000	[E-0040 398 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 001	[E-0040 400 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 002	[E-0040 402 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 003	[E-0040 404 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 004	[E-0040 406 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 005	[E-0040 408 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 006	[E-0040 410 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 007	[E-0040 412 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 008	[E-0040 414 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 009	[E-0040 416 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 010	[E-0040 418 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 011	[E-0040 420 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 012	[E-0040 422 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 013	[E-0040 424 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 014	[E-0040 426 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 015	[E-0040 428 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 016	[E-0040 430 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 017	[E-0040 432 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 018	[E-0040 434 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 019	[E-0040 436 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 020	[E-0040 438 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 021	[E-0040 440 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 022	[E-0040 442 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 023	[E-0040 444 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 024	[E-0040 446 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 025	[E-0040 448 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 026	[E-0040 450 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 027	[E-0040 452 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 028	[E-0040 454 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 029	[E-0040 456 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 030	[E-0040 458 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 031	[E-0040 460 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 032	[E-0040 462 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 033	[E-0040 464 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 034	[E-0040 466 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 035	[E-0040 468 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 036	[E-0040 470 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 037	[E-0040 472 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 038	[E-0040 474 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 039	[E-0040 476 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 040	[E-0040 478 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 041	[E-0040 480 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 042	[E-0040 482 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 043	[E-0040 484 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 044	[E-0040 486 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 045	[E-0040 488 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 046	[E-0040 490 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 047	[E-0040 492 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 048	[E-0040 494 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 049	[E-0040 496 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 050	[E-0040 498 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 051	[E-0040 500 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 052	[E-0040 502 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 053	[E-0040 504 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 054	[E-0040 506 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 055	[E-0040 508 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 056	[E-0040 510 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 057	[E-0040 512 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 058	[E-0040 514 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 059	[E-0040 516 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 060	[E-0040 518 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 061	[E-0040 520 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 062	[E-0040 522 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 063	[E-0040 524 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 064	[E-0040 526 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 065	[E-0040 528 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 066	[E-0040 530 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 067	[E-0040 532 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 068	[E-0040 534 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 069	[E-0040 536 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 070	[E-0040 538 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 071	[E-0040 540 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 072	[E-0040 542 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 073	[E-0040 544 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 074	[E-0040 546 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 075	[E-0040 548 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 076	[E-0040 550 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 077	[E-0040 552 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 078	[E-0040 554 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 079	[E-0040 556 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 080	[E-0040 558 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 081	[E-0040 560 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 082	[E-0040 562 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 083	[E-0040 564 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 084	[E-0040 566 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 085	[E-0040 568 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 086	[E-0040 570 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 087	[E-0040 572 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 088	[E-0040 574 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 089	[E-0040 576 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 090	[E-0040 578 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 091	[E-0040 580 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 092	[E-0040 582 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 093	[E-0040 584 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 094	[E-0040 586 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 095	[E-0040 588 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 096	[E-0040 590 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 097	[E-0040 592 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 098	[E-0040 594 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 099	[E-0040 596 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 100	[E-0040 598 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 101	[E-0040 600 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 102	[E-0040 602 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 103	[E-0040 604 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 104	[E-0040 606 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 105	[E-0040 608 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 106	[E-0040 610 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 107	[E-0040 612 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 108	[E-0040 614 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 109	[E-0040 616 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 110	[E-0040 618 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 111	[E-0040 620 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 112	[E-0040 622 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 113	[E-0040 624 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 114	[E-0040 626 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 115	[E-0040 628 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 116	[E-0040 630 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 117	[E-0040 632 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 118	[E-0040 634 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 119	[E-0040 636 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 120	[E-0040 638 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 121	[E-0040 640 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 122	[E-0040 642 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 123	[E-0040 644 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 124	[E-0040 646 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 125	[E-0040 648 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 126	[E-0040 650 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 127	[E-0040 652 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 128	[E-0040 654 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 129	[E-0040 656 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 130	[E-0040 658 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 131	[E-0040 660 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 132	[E-0040 662 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 133	[E-0040 664 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 134	[E-0040 666 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 135	[E-0040 668 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 136	[E-0040 670 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 137	[E-0040 672 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 138	[E-0040 674 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 139	[E-0040 676 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 140	[E-0040 678 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 141	[E-0040 680 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 142	[E-0040 682 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 143	[E-0040 684 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 144	[E-0040 686 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 145	[E-0040 688 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 146	[E-0040 690 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 147	[E-0040 692 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 148	[E-0040 694 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 149	[E-0040 696 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 150	[E-0040 698 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 151	[E-0040 700 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 152	[E-0040 702 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 153	[E-0040 704 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 154	[E-0040 706 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 155	[E-0040 708 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 156	[E-0040 710 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 157	[E-0040 712 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 158	[E-0040 714 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 159	[E-0040 716 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 160	[E-0040 718 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 161	[E-0040 720 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 162	[E-0040 722 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 163	[E-0040 724 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 164	[E-0040 726 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 165	[E-0040 728 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 166	[E-0040 730 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 167	[E-0040 732 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 168	[E-0040 734 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 169	[E-0040 736 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 170	[E-0040 738 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 171	[E-0040 740 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 172	[E-0040 742 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 173	[E-0040 744 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 174	[E-0040 746 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 175	[E-0040 748 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 176	[E-0040 750 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 177	[E-0040 752 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 178	[E-0040 754 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 179	[E-0040 756 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 180	[E-0040 758 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 181	[E-0040 760 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 182	[E-0040 762 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 183	[E-0040 764 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 184	[E-0040 766 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 185	[E-0040 768 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 186	[E-0040 770 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 187	[E-0040 772 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 188	[E-0040 774 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 189	[E-0040 776 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 190	[E-0040 778 0040015 BINARY2_0p01]
  Actuator Force Of Eigen Data 191	[E-0040 780 0040015 BINARY2_0p01]
  U Offset Position Of CC	[E-0040 782 0040005 BCD6]
  V Offset Position Of CC	[E-0040 788 0040006 BCD6]
  Z Offset Position Of CC	[E-0040 794 004001E BCD6]
  X Position Of CC Offset	[E-0040 800 0040007 BCD6]
  Y Position Of CC Offset	[E-0040 806 0040008 BCD6]
  Z Position Of CC Offset	[E-0040 812 0040009 BCD6]
  X Angle Of CC Offset	[E-0040 818 004000A BCD6]
  Y Angle Of CC Offset	[E-0040 824 004000B BCD6]
  U Offset Position Of CF	[E-0040 830 004000C BCD6]
  V Offset Position Of CF	[E-0040 836 004000D BCD6]
  SM X Position Of CC Offset	[E-0040 842 004000E BCD6]
  SM Y Position Of CC Offset	[E-0040 848 004000F BCD6]
  SM Z Position Of CC Offset	[E-0040 854 0040010 BCD6]
  SM X Angle Of CC Offset	[E-0040 860 0040011 BCD6]
  SM Y Angle Of CC Offset	[E-0040 866 0040012 BCD6]
  AZ CORRECT Angle Of CC Offset	[E-0040 872 0040013 BCD6]
  EL CORRECT Angle Of CC Offset	[E-0040 878 0040014 BCD6]
  SM U Position Of Zernike Offset	[E-0040 884 0040016 BCD6]
  SM V Position Of Zernike Offset	[E-0040 890 0040017 BCD6]
  SM Z Position Of Zernike Offset(CC)	[E-0040 896 0040018 BCD6]
  SM X Position Of Zernike Offset	[E-0040 902 0040019 BCD6]
  SM Y Position Of Zernike Offset	[E-0040 908 004001A BCD6]
  SM Z Position Of Zernike Offset(SP)	[E-0040 914 004001B BCD6]
  SM X Angle Of Zernike Offset	[E-0040 920 004001C BCD6]
  SM Y Angle Of Zernike Offset	[E-0040 926 004001D BCD6]
  Zernike Data RMS(without A20)	[E-0040 932 004001F REAL8]
  SH Error RMS	[E-0040 940 0040020 REAL8]
  Dome Flat Power Unit INIT	[E-0061 0:0 0061001]
  Dome Flat Power Unit Not INIT	[E-0061 0:1 0061002]
  Dome Flat Power Unit1 Alarm	[E-0061 1:0 006102E]
  Dome Flat Power Unit1 OVP Alarm	[E-0061 1:1 006102F]
  Dome Flat Power Unit1 UVP Alarm	[E-0061 1:2 0061030]
  Dome Flat Power Unit1 CMD Alarm	[E-0061 1:3 0061031]
  Lamp 1-A 2-A 3-A 4-A 10W	[E-0061 1:4 0061032]
  Lamp 1-A 2-A 3-A 4-A 20W	[E-0061 2:1 0061003]
  Lamp1-B 1000W	[E-0061 2:2 0061004]
  Lamp1-B 600W	[E-0061 2:3 0061005]
  Lamp1-B 250W	[E-0061 2:4 0061006]
  Lamp2-B 1000W	[E-0061 2:5 0061007]
  Lamp2-B 600W	[E-0061 2:6 0061008]
  Lamp2-B 250W	[E-0061 2:7 0061009]
  Lamp3-B 1000W	[E-0061 3:0 006100A]
  Lamp3-B 600W	[E-0061 3:1 006100B]
  Lamp3-B 250W	[E-0061 3:2 006100C]
  Lamp4-B 1000W	[E-0061 3:3 006100D]
  Lamp4-B 600W	[E-0061 3:4 006100E]
  Lamp4-B 250W	[E-0061 3:5 006100F]
  Lamp 1-A 2-A 3-A 4-A Light On	[E-0061 4:0 0061010]
  Lamp 1-A 2-A 3-A 4-A Light Off	[E-0061 4:1 0061011]
  Lamp 1-B Light On	[E-0061 4:2 0061012]
  Lamp 1-B Light Off	[E-0061 4:3 0061013]
  Lamp 2-B Light On	[E-0061 4:4 0061014]
  Lamp 2-B Light Off	[E-0061 4:5 0061015]
  Lamp 3-B Light On	[E-0061 5:0 0061016]
  Lamp 3-B Light Off	[E-0061 5:1 0061017]
  Lamp 4-B Light On	[E-0061 5:2 0061018]
  Lamp 4-B Light Off	[E-0061 5:3 0061019]
  Dome Flat Temp Logger Unit Alarm	[E-0061 6:0 006103F]
  Dome Flat Temp Logger Unit INIT	[E-0061 6:1 0061049]
  Dome Flat Temp Logger Unit Not INIT	[E-0061 6:2 006104A]
  Dome Flat Power Unit1 Not INIT	[E-0061 7:0 0061040]
  Dome Flat Power Unit2 Not INIT	[E-0061 7:1 0061041]
  Dome Flat Power Unit3 NOT INIT	[E-0061 7:2 0061042]
  Dome Flat Power Unit4 Not INIT	[E-0061 7:3 0061043]
  Dome Flat Power Unit5 Not INIT	[E-0061 7:4 0061044]
  Dome Flat Power Unit6 Not INIT	[E-0061 7:5 0061045]
  Dome Flat Power Unit7 Not INIT	[E-0061 7:6 0061046]
  Dome Flat Power Unit8 Not INIT	[E-0061 7:7 0061047]
  Dome Flat Power Unit9 Not INIT	[E-0061 8:0 0061048]
  Dome Flat Power Unit2 Alarm	[E-0061 9:0 006104B]
  Dome Flat Power Unit2 OVP Alarm	[E-0061 9:1 006104C]
  Dome Flat Power Unit2 UVP Alarm	[E-0061 9:2 006104D]
  Dome Flat Power Unit2 CMD Alarm	[E-0061 9:3 006104E]
  Dome Flat Power Unit3 Alarm	[E-0061 9:4 006104F]
  Dome Flat Power Unit3 OVP Alarm	[E-0061 9:5 0061050]
  Dome Flat Power Unit3 UVP Alarm	[E-0061 9:6 0061051]
  Dome Flat Power Unit3 CMD Alarm	[E-0061 9:7 0061052]
  Dome Flat Power Unit4 Alarm	[E-0061 10:0 0061053]
  Dome Flat Power Unit4 OVP Alarm	[E-0061 10:1 0061054]
  Dome Flat Power Unit4 UVP Alarm	[E-0061 10:2 0061055]
  Dome Flat Power Unit4 CMD Alarm	[E-0061 10:3 0061056]
  Dome Flat Power Unit5 Alarm	[E-0061 10:4 0061057]
  Dome Flat Power Unit5 OVP Alarm	[E-0061 10:5 0061058]
  Dome Flat Power Unit5 UVP Alarm	[E-0061 10:6 0061059]
  Dome Flat Power Unit5 CMD Alarm	[E-0061 10:7 006105A]
  Dome Flat Power Unit6 Alarm	[E-0061 11:0 006105B]
  Dome Flat Power Unit6 OVP Alarm	[E-0061 11:1 006105C]
  Dome Flat Power Unit6 UVP Alarm	[E-0061 11:2 006105D]
  Dome Flat Power Unit6 CMD Alarm	[E-0061 11:3 006105E]
  Dome Flat Power Unit7 Alarm	[E-0061 11:4 006105F]
  Dome Flat Power Unit7 OVP Alarm	[E-0061 11:5 0061060]
  Dome Flat Power Unit7 UVP Alarm	[E-0061 11:6 0061061]
  Dome Flat Power Unit7 CMD Alarm	[E-0061 11:7 0061062]
  Dome Flat Power Unit8 Alarm	[E-0061 12:0 0061063]
  Dome Flat Power Unit8 OVP Alarm	[E-0061 12:1 0061064]
  Dome Flat Power Unit8 UVP Alarm	[E-0061 12:2 0061065]
  Dome Flat Power Unit8 CMD Alarm	[E-0061 12:3 0061066]
  Dome Flat Power Unit9 Alarm	[E-0061 12:4 0061067]
  Dome Flat Power Unit9 OVP Alarm	[E-0061 12:5 0061068]
  Dome Flat Power Unit9 UVP Alarm	[E-0061 12:6 0061069]
  Dome Flat Power Unit9 CMD Alarm	[E-0061 12:7 006106A]
  Lamp 1-A 2-A 3-A 4-A Real Current	[L-0061 0 006101A BCD6]
  Lamp 1-A 2-A 3-A 4-A CMD Current	[L-0061 6 006101B BCD6]
  Lamp 1-B Real Current	[L-0061 12 006101C BCD6]
  Lamp 1-B CMD Current	[L-0061 18 006101D BCD6]
  Lamp 2-B Real Current	[L-0061 24 006101E BCD6]
  Lamp 2-B CMD Current	[L-0061 30 006101F BCD6]
  Lamp 3-B Real Current	[L-0061 36 0061020 BCD6]
  Lamp 3-B CMD Current	[L-0061 42 0061021 BCD6]
  Lamp 4-B Real Current	[L-0061 48 0061022 BCD6]
  Lamp 4-B CMD Current	[L-0061 54 0061023 BCD6]
  Lamp 1-A 2-A 3-A 4-A Real Voltage	[L-0061 60 0061024 BCD6]
  Lamp 1-A 2-A 3-A 4-A CMD Voltage	[L-0061 66 0061025 BCD6]
  Lamp 1-B Real Voltage	[L-0061 72 0061026 BCD6]
  Lamp 1-B CMD Voltage	[L-0061 78 0061027 BCD6]
  Lamp 2-B Real Voltage	[L-0061 84 0061028 BCD6]
  Lamp 2-B CMD Voltage	[L-0061 90 0061029 BCD6]
  Lamp 3-B Real Voltage	[L-0061 96 006102A BCD6]
  Lamp 3-B CMD Voltage	[L-0061 102 006102B BCD6]
  Lamp 4-B Real Voltage	[L-0061 108 006102C BCD6]
  Lamp 4-B CMD Voltage	[L-0061 114 006102D BCD6]
  Lamp1 Outside Temp	[L-0061 120 0061033 BCD6]
  Lamp1 Inside Temp	[L-0061 126 0061034 BCD6]
  Lamp1 Holder B Temp	[L-0061 132 0061035 BCD6]
  Lamp2 Outside Temp	[L-0061 138 0061036 BCD6]
  Lamp2 Inside Temp	[L-0061 144 0061037 BCD6]
  Lamp2 Holder B Temp	[L-0061 150 0061038 BCD6]
  Lamp3 Outside Temp	[L-0061 156 0061039 BCD6]
  Lamp3 Inside Temp	[L-0061 162 006103A BCD6]
  Lamp3 Holder B Temp	[L-0061 168 006103B BCD6]
  Lamp4 Outside Temp	[L-0061 174 006103C BCD6]
  Lamp4 Inside Temp	[L-0061 180 006103D BCD6]
  Lamp4 Holder B Temp	[L-0061 186 006103E BCD6]
  TSC Process Login1	[E-00A1 0:0 00A1001]
  TSC Process Login2	[E-00A1 0:1 00A1002]
  TSC Process Login3	[E-00A1 0:2 00A1003]
  TSC Process Login4	[E-00A1 0:3 00A1004]
  TSC Process Login5	[E-00A1 0:4 00A1005]
  TSC Process Login6	[E-00A1 0:5 00A1006]
  TSC Process Login7	[E-00A1 0:6 00A1007]
  TSC Process Login8	[E-00A1 0:7 00A1008]
  TSC Process Login9	[E-00A1 1:0 00A1009]
  TSC Process Login10	[E-00A1 1:1 00A100A]
  TSC Focus POpt Selected	[E-00A1 2:0 00A100B]
  TSC Focus PIR Selected	[E-00A1 2:1 00A100C]
  TSC Focus Cs Selected	[E-00A1 2:2 00A100D]
  TSC Focus NsOpt Selected	[E-00A1 2:3 00A100E]
  TSC Focus NsIR Selected	[E-00A1 2:4 00A100F]
  TSC Focus CsOpt Selected	[E-00A1 2:5 00A137B]
  TSC Focus CsIR Selected	[E-00A1 2:6 00A137C]
  Top Unit IR Selected	[E-00A1 3:0 00A1010]
  Top Unit CsOpt Selected	[E-00A1 3:1 00A1011]
  Top Unit NsOpt Selected	[E-00A1 3:2 00A1012]
  Top Unit P Selected	[E-00A1 3:3 00A1013]
  Top Unit PIR Selected	[E-00A1 3:4 00A13D7]
  TSC  Fault	[E-00A1 4:0 00A1015]
  OBS Fault	[E-00A1 4:1 00A1016]
  TWS1 Fault	[E-00A1 4:2 00A1017]
  TWS2 Fault	[E-00A1 4:3 00A1018]
  TWS3 Fault	[E-00A1 4:4 00A1019]
  DCMOM1 Fault	[E-00A1 4:5 00A101A]
  DCMOM2 Fault	[E-00A1 4:6 00A101B]
  DCMOM3 Fault	[E-00A1 4:7 00A101C]
  MLP1 Fault on TSC	[E-00A1 5:0 00A101D]
  MLP2 Fault on TSC	[E-00A1 5:1 00A101E]
  MLP3 Fault on TSC	[E-00A1 5:2 00A101F]
  CXWS Fault	[E-00A1 5:3 00A1385]
  TWS4 Fault	[E-00A1 5:4 00A13AE]
  TSC Fault IND on TSC	[E-00A1 5:7 00A1020]
  OBS Lock	[E-00A1 6:1 00A1021]
  TWS1 Lock	[E-00A1 6:2 00A1022]
  TWS2 Lock	[E-00A1 6:3 00A1023]
  TWS4 Lock	[E-00A1 6:4 00A13AF]
  DCMOM1 Lock	[E-00A1 6:5 00A1024]
  DCMOM2 Lock	[E-00A1 6:6 00A1025]
  DCMOM3 Lock	[E-00A1 6:7 00A1026]
  OBS PRI	[E-00A1 7:0 00A1027]
  TSC PRI	[E-00A1 7:1 00A1028]
  TSC Only	[E-00A1 7:2 00A1029]
  Operation Request Mode On	[E-00A1 7:6 00A1309]
  Operation Request Mode Off	[E-00A1 7:7 00A130A]
  TSC Schedule On	[E-00A1 8:0 00A102A]
  TSC Schedule Off	[E-00A1 8:1 00A102B]
  Cal SourceFilter Table CHNG	[E-00A1 8:6 00A11C3]
  Cal Source Lamp Table CHNG	[E-00A1 8:7 00A11C4]
  ADC-EL SYNC Mode	[E-00A1 9:2 00A102E]
  ADC-EL ASYNC Mode	[E-00A1 9:3 00A102F]
  Vent SYNC Mode	[E-00A1 9:4 00A1030]
  Vent ASYNC Mode	[E-00A1 9:5 00A1031]
  P ADC SYNC Mode	[E-00A1 9:6 00A1244]
  P ADC ASYNC Mode	[E-00A1 9:7 00A1245]
  Wind Control On	[E-00A1 10:0 00A1032]
  Wind Control Off	[E-00A1 10:1 00A1033]
  Wind Screen High Wind Prot	[E-00A1 10:2 00A1034]
  Vent High Wind Prot	[E-00A1 10:3 00A1035]
  TSC TUE Inhibit	[E-00A1 10:7 00A1036]
  TSC COML PWR DET	[E-00A1 11:0 00A1037]
  TSC Clock Adjustment Skip	[E-00A1 11:1 00A1134]
  Wind Screen - EL SYNC Mode	[E-00A1 12:0 00A1167]
  Wind Screen-EL ASYNC Mode	[E-00A1 12:1 00A1168]
  Top Screen Rear Mode	[E-00A1 12:2 00A1169]
  Top Screen Front Mode	[E-00A1 12:3 00A116A]
  Top Screen-EL ASYNC Mode	[E-00A1 12:4 00A116B]
  Top Screen Front Ready	[E-00A1 12:5 00A116C]
  Wind Alarm	[E-00A1 13:0 00A1038]
  Temperature Alarm	[E-00A1 13:1 00A1039]
  RH Alarm	[E-00A1 13:2 00A103A]
  Atm Pressure Alarm	[E-00A1 13:3 00A103B]
  CT2 Alarm	[E-00A1 13:4 00A103C]
  AG EXPSR Mismath	[E-00A1 14:0 00A103D]
  SH EXPSR Mismath	[E-00A1 14:1 00A103E]
  Sidereal Tracking	[E-00A1 14:2 00A13DE]
  Non-Sidereal Tracking(Bofore)	[E-00A1 14:3 00A13DF]
  Non-Sidereal Tracking	[E-00A1 14:4 00A13E0]
  Non-Sidereal Tracking(Finished)	[E-00A1 14:5 00A13E1]
  EL Drive Enable	[E-00A1 15:0 00A116D]
  AZ Drive Interlock Stop	[E-00A1 15:1 00A118F]
  Mount Equatorial Drive	[E-00A1 16:0 00A1189]
  Mount AZ/EL Drive	[E-00A1 16:1 00A118A]
  Telescope Pointing	[E-00A1 16:4 00A118C]
  Telescope Tracking	[E-00A1 16:5 00A118D]
  Telescope Auto Guiding(AG)	[E-00A1 16:6 00A118E]
  Telescope Auto Guiding(SV)	[E-00A1 16:7 00A13AD]
  Top Unit Check OK	[E-00A1 17:0 00A102C]
  Top Unit Check NG	[E-00A1 17:1 00A102D]
  Telescope Auto Guiding(AGforSH)	[E-00A1 17:2 00A13E2]
  Telescope Auto Guiding(Fibre AG)	[E-00A1 17:3 00A13E3]
  TSC Interlock Release of UG1	[E-00A1 18:0 00A137D]
  TSC Interlock Release of UG2	[E-00A1 18:1 00A137E]
  TSC Interlock Release of UG3	[E-00A1 18:2 00A137F]
  TSC Interlock Release of UG4	[E-00A1 18:3 00A1380]
  TSC Interlock Release of UG5	[E-00A1 18:4 00A1381]
  TSC Interlock Release of UG6	[E-00A1 18:5 00A1382]
  TSC Interlock Release of UG7	[E-00A1 18:6 00A1383]
  TSC Interlock Release of UG8	[E-00A1 18:7 00A1384]
  Observer	[E-00A1 19 00A1041 str]
  Object Name	[E-00A1 39 00A1042 str]
  Object Frequency	[E-00A1 59 00A119E BCD6]
  OBE Kind of Cs	[E-00A1 65 00A1386 str]
  TSC Login1 Computer	[E-00A1 74 00A1045 str]
  TSC Login1 Process Number	[E-00A1 80 00A1046 BCD2]
  TSC Login1 Login Name	[E-00A1 82 00A1047 str]
  TSC Login2 Computer	[E-00A1 104 00A1048 str]
  TSC Login2 Process Number	[E-00A1 110 00A1049 BCD2]
  TSC Login2 Login Name	[E-00A1 112 00A104A str]
  TSC Login3 Computer	[E-00A1 134 00A104B str]
  TSC Login3 Process Number	[E-00A1 140 00A104C BCD2]
  TSC Login3 Login Name	[E-00A1 142 00A104D str]
  TSC Login4 Computer	[E-00A1 164 00A104E str]
  TSC Login4 Process Number	[E-00A1 170 00A104F BCD2]
  TSC Login4 Login Name	[E-00A1 172 00A1050 str]
  TSC Login5 Computer	[E-00A1 194 00A1051 str]
  TSC Login5 Process Number	[E-00A1 200 00A1052 BCD2]
  TSC Login5 Login Name	[E-00A1 202 00A1053 str]
  TSC Login6 Computer	[E-00A1 224 00A1054 str]
  TSC Login6 Process Number	[E-00A1 230 00A1055 BCD2]
  TSC Login6 Login Name	[E-00A1 232 00A1056 str]
  TSC Login7 Computer	[E-00A1 254 00A1057 str]
  TSC Login7 Process Number	[E-00A1 260 00A1058 BCD2]
  TSC Login7 Login Name	[E-00A1 262 00A1059 str]
  TSC Login8 Computer	[E-00A1 284 00A105A str]
  TSC Login8 Process Number	[E-00A1 290 00A105B BCD2]
  TSC Login8 Login Name	[E-00A1 292 00A105C str]
  TSC Login9 Computer	[E-00A1 314 00A105D str]
  TSC Login9 Process Number	[E-00A1 320 00A105E BCD2]
  TSC Login9 Login Name	[E-00A1 322 00A105F str]
  TSC Login10 Computer	[E-00A1 344 00A1060 str]
  TSC Login10 Process Number	[E-00A1 350 00A1061 BCD2]
  TSC Login10 Login Name	[E-00A1 352 00A1062 str]
  Macro Simulate Execute1	[E-00A1 374:0 00A11AF]
  Macro Simulate Execute2	[E-00A1 374:1 00A11B0]
  Macro Simulate Execute3	[E-00A1 374:2 00A11B1]
  Macro Simulate Execute4	[E-00A1 374:3 00A11B2]
  Macro Simulate Execute5	[E-00A1 374:4 00A11B3]
  Macro Simulate Execute6	[E-00A1 374:5 00A11B4]
  Macro Simulate Execute7	[E-00A1 374:6 00A11B5]
  Macro Simulate Execute8	[E-00A1 374:7 00A11B6]
  Macro Simulate Execute9	[E-00A1 375:0 00A11B7]
  Macro Simulate Execute10	[E-00A1 375:1 00A11B8]
  Macro Execute1	[E-00A1 376:0 00A1100]
  Macro Execute2	[E-00A1 376:1 00A1101]
  Macro Execute3	[E-00A1 376:2 00A1102]
  Macro Execute4	[E-00A1 376:3 00A1103]
  Macro Execute5	[E-00A1 376:4 00A1104]
  Macro Execute6	[E-00A1 376:5 00A1105]
  Macro Execute7	[E-00A1 376:6 00A1106]
  Macro Execute8	[E-00A1 376:7 00A1107]
  Macro Execute9	[E-00A1 377:0 00A1108]
  Macro Execute10	[E-00A1 377:1 00A1109]
  Macro1 Computer Name	[E-00A1 378 00A110A str]
  Macro1 Process Number	[E-00A1 384 00A110B BCD2]
  Macro1 Group Number	[E-00A1 386 00A110C BCD1]
  Macro1 Macro Name	[E-00A1 387 00A110D str]
  Macro2 Computer Name	[E-00A1 403 00A110E str]
  Macro2 Process Number	[E-00A1 409 00A110F BCD2]
  Macro2 Group Number	[E-00A1 411 00A1110 BCD1]
  Macro2 Macro Name	[E-00A1 412 00A1111 str]
  Macro3 Computer Name	[E-00A1 428 00A1112 str]
  Macro3 Process Number	[E-00A1 434 00A1113 BCD2]
  Macro3 Group Number	[E-00A1 436 00A1114 BCD1]
  Macro3 Macro Name	[E-00A1 437 00A1115 str]
  Macro4 Computer Name	[E-00A1 453 00A1116 str]
  Macro4 Process Number	[E-00A1 459 00A1117 BCD2]
  Macro4 Group Number	[E-00A1 461 00A1118 BCD1]
  Macro4 Macro Name	[E-00A1 462 00A1119 str]
  Macro5 Computer Name	[E-00A1 478 00A111A str]
  Macro5 Process Number	[E-00A1 484 00A111B BCD2]
  Macro5 Group Number	[E-00A1 486 00A111C BCD1]
  Macro5 Macro Name	[E-00A1 487 00A111D str]
  Macro6 Computer Name	[E-00A1 503 00A111E str]
  Macro6 Process Number	[E-00A1 509 00A111F BCD2]
  Macro6 Group Number	[E-00A1 511 00A1120 BCD1]
  Macro6 Macro Name	[E-00A1 512 00A1121 str]
  Macro7 Computer Name	[E-00A1 528 00A1122 str]
  Macro7 Process Number	[E-00A1 534 00A1123 BCD2]
  Macro7 Group Number	[E-00A1 536 00A1124 BCD1]
  Macro7 Macro Name	[E-00A1 537 00A1125 str]
  Macro8 Computer Name	[E-00A1 553 00A1126 str]
  Macro8 Process Number	[E-00A1 559 00A1127 BCD2]
  Macro8 Group Number	[E-00A1 561 00A1128 BCD1]
  Macro8 Macro Name	[E-00A1 562 00A1129 str]
  Macro9 Computer Name	[E-00A1 578 00A112A str]
  Macro9 Process Number	[E-00A1 584 00A112B BCD2]
  Macro9 Group Number	[E-00A1 586 00A112C BCD1]
  Macro9 Macro Name	[E-00A1 587 00A112D str]
  Macro10 Computer Name	[E-00A1 603 00A112E str]
  Macro10 Process Number	[E-00A1 609 00A112F BCD2]
  Macro10 Group Number	[E-00A1 611 00A1130 BCD1]
  Macro10 Macro Name	[E-00A1 612 00A1131 str]
  OBE Name	[E-00A1 628 00A1132 str]
  Wind Alarm Detect On	[E-00A1 648:0 00A11A5]
  Wind Alarm Detect Off	[E-00A1 648:1 00A11A6]
  Temp Alarm Detect On	[E-00A1 648:2 00A11A7]
  Temp Alarm Detect Off	[E-00A1 648:3 00A11A8]
  Humidity Alarm Detect On	[E-00A1 648:4 00A11A9]
  Humidity Alarm Detect Off	[E-00A1 648:5 00A11AA]
  Atm Pressure Alarm Detect On	[E-00A1 648:6 00A11AB]
  Atm Pressure Alarm Detect Off	[E-00A1 648:7 00A11AC]
  CT2 Alarm Detect On	[E-00A1 649:0 00A11AD]
  CT2 Alarm Detect Off	[E-00A1 649:1 00A11AE]
  Cs Bolt Clamp On	[E-00A1 650:0 00A11B9]
  Cs Bolt Clamp Off	[E-00A1 650:1 00A11BA]
  Cs Bolt Clamp Stop	[E-00A1 650:2 00A11BC]
  CIAX1 Used	[E-00A1 650:3 00A1367]
  CIAX2 Used	[E-00A1 650:4 00A1368]
  CIAX3 Used	[E-00A1 650:5 00A1369]
  Schedule 1 Now Doing	[E-00A1 652:0 00A1135]
  Schedule 2 Now Doing	[E-00A1 652:1 00A1136]
  Schedule 3 Now Doing	[E-00A1 652:2 00A1137]
  Schedule 4 Now Doing	[E-00A1 652:3 00A1138]
  Schedule 5 Now Doing	[E-00A1 652:4 00A1139]
  Schedule 6 Now Doing	[E-00A1 652:5 00A113A]
  Schedule 7 Now Doing	[E-00A1 652:6 00A113B]
  Schedule 8 Now Doing	[E-00A1 652:7 00A113C]
  Schedule 9 Now Doing	[E-00A1 653:0 00A113D]
  Schedule 10 Now Doing	[E-00A1 653:1 00A113E]
  Schedule 11 Now Doing	[E-00A1 653:2 00A113F]
  Schedule 12 Now Doing	[E-00A1 653:3 00A1140]
  Schedule 13 Now Doing	[E-00A1 653:4 00A1141]
  Schedule 14 Now Doing	[E-00A1 653:5 00A1142]
  Schedule 15 Now Doing	[E-00A1 653:6 00A1143]
  Schedule 16 Now Doing	[E-00A1 653:7 00A1144]
  Schedule 17 Now Doing	[E-00A1 654:0 00A1145]
  Schedule 18 Now Doing	[E-00A1 654:1 00A1146]
  Schedule 19 Now Doing	[E-00A1 654:2 00A1147]
  Schedule 20 Now Doing	[E-00A1 654:3 00A1148]
  Schedule 21 Now Doing	[E-00A1 654:4 00A1149]
  Schedule 22 Now Doing	[E-00A1 654:5 00A114A]
  Schedule 23 Now Doing	[E-00A1 654:6 00A114B]
  Schedule 24 Now Doing	[E-00A1 654:7 00A114C]
  Schedule 25 Now Doing	[E-00A1 655:0 00A114D]
  Schedule 26 Now Doing	[E-00A1 655:1 00A114E]
  Schedule 27 Now Doing	[E-00A1 655:2 00A114F]
  Schedule 28 Now Doing	[E-00A1 655:3 00A1150]
  Schedule 29 Now Doing	[E-00A1 655:4 00A1151]
  Schedule 30 Now Doing	[E-00A1 655:5 00A1152]
  Schedule 31 Now Doing	[E-00A1 655:6 00A1153]
  Schedule 32 Now Doing	[E-00A1 655:7 00A1154]
  Schedule 33 Now Doing	[E-00A1 656:0 00A1155]
  Schedule 34 Now Doing	[E-00A1 656:1 00A1156]
  Schedule 35 Now Doing	[E-00A1 656:2 00A1157]
  Schedule 36 Now Doing	[E-00A1 656:3 00A1158]
  Schedule 37 Now Doing	[E-00A1 656:4 00A1159]
  Schedule 38 Now Doing	[E-00A1 656:5 00A115A]
  Schedule 39 Now Doing	[E-00A1 656:6 00A115B]
  Schedule 40 Now Doing	[E-00A1 656:7 00A115C]
  Schedule 41 Now Doing	[E-00A1 657:0 00A115D]
  Schedule 42 Now Doing	[E-00A1 657:1 00A115E]
  Schedule 43 Now Doing	[E-00A1 657:2 00A115F]
  Schedule 44 Now Doing	[E-00A1 657:3 00A1160]
  Schedule 45 Now Doing	[E-00A1 657:4 00A1161]
  Schedule 46 Now Doing	[E-00A1 657:5 00A1162]
  Schedule 47 Now Doing	[E-00A1 657:6 00A1163]
  Schedule 48 Now Doing	[E-00A1 657:7 00A1164]
  Schedule 49 Now Doing	[E-00A1 658:0 00A1165]
  Schedule 50 Now Doing	[E-00A1 658:1 00A1166]
  TSC Schedule File Update TIME	[E-00A1 659 00A1133 TIME6]
  Heat Exh Mirror Temp CONT Mode	[E-00A1 665:0 00A116E]
  Heat Exh Cell Exhaust Mode	[E-00A1 665:1 00A116F]
  Heat Exh Mirror Temp Auto Mode	[E-00A1 665:2 00A1387]
  Heat Exh Mirror Temp Manual Mode	[E-00A1 665:3 00A1388]
  Heat Exh Normal Mode	[E-00A1 666:0 00A1176]
  Heat Exh Test Mode	[E-00A1 666:1 00A1177]
  Heat Exh Test Pattern	[E-00A1 667 00A1178 BCD1]
  Heat Exh Test Result	[E-00A1 668 00A117F BCD1]
  TSC Buzzer On	[E-00A1 669:0 00A1180]
  TWS1 Buzzer On	[E-00A1 669:1 00A1181]
  TWS2 Buzzer On	[E-00A1 669:2 00A1182]
  Room Buzzer On	[E-00A1 669:3 00A1014]
  TWS4 Buzzer On	[E-00A1 669:4 00A13B0]
  Major Alarm	[E-00A1 670:0 00A1183]
  Minor Alarm	[E-00A1 670:1 00A1184]
  Alarm Monitor On	[E-00A1 670:2 00A1187]
  Plural Alarm Detect	[E-00A1 670:3 00A1188]
  Alarm Detected Status ID	[E-00A1 671 00A1185 str]
  Alarm Detected Time	[E-00A1 678 00A1186 ASC15_TIME]
  Offset Right Ascention	[E-00A1 693 00A1192 BCD6_RA]
  Offset Declination	[E-00A1 699 00A1193 BCD6_DEC]
  Object Data Kind	[E-00A1 705 00A103F str]
  AG/SH Object Name	[E-00A1 737 00A1194 str]
  AG/SH Object Data Kind	[E-00A1 757 00A1195 str]
  PA Schedule Mode	[E-00A1 789:0 00A11C5]
  PA Manual Mode	[E-00A1 789:1 00A11C6]
  PA Simulation Mode	[E-00A1 789:2 00A11C7]
  PA Start Time	[E-00A1 790 00A11C8 ASC15_TIME]
  PA Observation Interval	[E-00A1 805 00A11C9 BINARY2_1]
  PA Area	[E-00A1 807 00A11CA str]
  PA Min. V-MAG	[E-00A1 810 00A11CB BINARY2_0p01]
  PA Max. V-MAG	[E-00A1 812 00A11CC BINARY2_0p01]
  PA Target Count	[E-00A1 814 00A11CD BINARY1_1]
  PA OPT Detect AG	[E-00A1 815:0 00A11CE]
  PA Order Up To Down	[E-00A1 816:0 00A11CF]
  PA Order Down To Up	[E-00A1 816:1 00A11D0]
  PA Optical Axis On	[E-00A1 816:2 00A130B]
  PA Optical Axis Off	[E-00A1 816:3 00A130C]
  PA Exposure Time	[E-00A1 817 00A11D1 BINARY4_1]
  PA Exposure Area Width X	[E-00A1 821 00A11D2 BINARY2_1]
  PA Exposure Area Width Y	[E-00A1 823 00A11D3 BINARY2_1]
  PA Guide Area Width X	[E-00A1 825 00A11D4 BINARY2_1]
  PA Guide Area Width Y	[E-00A1 827 00A11D5 BINARY2_1]
  PA Retry Number	[E-00A1 829 00A11D6 BINARY1_1]
  PA Limit AZ/EL Error	[E-00A1 830 00A11D7 BCD6]
  PA Wait Time	[E-00A1 838 00A11D9 BINARY2_1]
  PA Remaining Time	[E-00A1 840 00A11DB BINARY2_1]
  PA All Area Number	[E-00A1 842 00A11DC BINARY2_1]
  PA End Area Number	[E-00A1 844 00A11DD BINARY2_1]
  PA Fault	[E-00A1 846:0 00A11DE]
  PA Run	[E-00A1 847:0 00A11DF]
  PA Pause	[E-00A1 847:1 00A11E0]
  PA Plot1 Pointing Data Selected	[E-00A1 847:3 00A132B]
  PA Plot2 Pointing Data Selected	[E-00A1 847:4 00A132C]
  PA Plot3 Pointing Data Selected	[E-00A1 847:5 00A132D]
  PA Plot4 Pointing Data Selected	[E-00A1 847:6 00A132E]
  PA Plot5 Pointing Data Selected	[E-00A1 847:7 00A132F]
  PA Control Machine	[E-00A1 848 00A11E1 str]
  PA All Ovserv Point	[E-00A1 852 00A11E2 BINARY2_1]
  PA AZ Error Average New	[E-00A1 854 00A11E3 BINARY4_0p001]
  PA EL Error Average New	[E-00A1 858 00A11E5 BINARY4_0p001]
  PA AZ Error Average Old	[E-00A1 862 00A11E7 BINARY4_0p001]
  PA EL Error Average Old	[E-00A1 866 00A11E9 BINARY4_0p001]
  PA Area File Name	[E-00A1 872 00A130D str]
  PA IECPT CsOpt Update	[E-00A1 884:0 00A130E]
  PA IECPT CsOpt ADC Update	[E-00A1 884:1 00A130F]
  PA IECPT CsIR Update	[E-00A1 884:2 00A1310]
  PA IECPT POpt Update	[E-00A1 884:3 00A1311]
  PA IECPT PIR Update	[E-00A1 884:4 00A1312]
  PA IECPT NsOpt Update	[E-00A1 884:5 00A1313]
  PA IECPT NsOpt ADC Update	[E-00A1 884:6 00A1314]
  PA IECPT NsOpt ImR(R) Update	[E-00A1 885:0 00A1315]
  PA IECPT NsOpt ADC ImR(R) Update	[E-00A1 885:1 00A1316]
  PA IECPT NsIR Update	[E-00A1 885:2 00A1317]
  PA IECPT NsIR ImR Update	[E-00A1 885:3 00A1318]
  PA IECPT NsOpt ImR(B) Update	[E-00A1 885:4 00A1373]
  PA IECPT NsOpt ADC ImR(B) Update	[E-00A1 885:5 00A1374]
  PA AZ Zero Offset New	[E-00A1 886 00A11EB BINARY4_0p000001]
  PA EL Zero Offset New	[E-00A1 890 00A11EC BINARY4_0p000001]
  PA Roll Mislevel New	[E-00A1 894 00A11ED BINARY4_0p000001]
  PA Pitch Mislevel New	[E-00A1 898 00A11EE BINARY4_0p000001]
  PA EL Axis Nonortho New	[E-00A1 902 00A11EF BINARY4_0p000001]
  PA Collimation Error New	[E-00A1 906 00A11F0 BINARY4_0p000001]
  PA Tube Gravitational New	[E-00A1 910 00A11F1 BINARY4_0p000001]
  PA AZ Axis Wobble 1 New	[E-00A1 914 00A11F2 BINARY4_0p000001]
  PA AZ Axis Wobble 2 New	[E-00A1 918 00A11F3 BINARY4_0p000001]
  PA AZ Axis Wobble 3 New	[E-00A1 922 00A11F4 BINARY4_0p000001]
  PA AZ Axis Wobble 4 New	[E-00A1 926 00A11F5 BINARY4_0p000001]
  PA AZ Axis Wobble 5 New	[E-00A1 930 00A11F6 BINARY4_0p000001]
  PA AZ Axis Wobble 6 New	[E-00A1 934 00A11F7 BINARY4_0p000001]
  PA AZ Axis Wobble 7 New	[E-00A1 938 00A11F8 BINARY4_0p000001]
  PA AZ Axis Wobble 8 New	[E-00A1 942 00A11F9 BINARY4_0p000001]
  PA AZ Axis Wobble 9 New	[E-00A1 946 00A11FA BINARY4_0p000001]
  PA EL Axis Edge Flexure1 New	[E-00A1 950 00A11FB BINARY4_0p000001]
  PA ADC ESTAB Error 1 New	[E-00A1 954 00A11FC BINARY4_0p000001]
  PA ADC ESTAB Error 2 New	[E-00A1 958 00A11FD BINARY4_0p000001]
  PA OBSERV ESTAB Error 1 New	[E-00A1 962 00A11FE BINARY4_0p000001]
  PA OBSERV ESTAB Error 2 New	[E-00A1 966 00A11FF BINARY4_0p000001]
  PA ImR Mirror GRAVIT  New	[E-00A1 970 00A1200 BINARY4_0p000001]
  PA EL Axis Edge FLEXURE 2 New	[E-00A1 974 00A1201 BINARY4_0p000001]
  PA EL Axis Edge FLEXURE 3 New	[E-00A1 978 00A1202 BINARY4_0p000001]
  PA ImR ESTAB Error 1 New	[E-00A1 982 00A1203 BINARY4_0p000001]
  PA ImR ESTAB Error 2 New	[E-00A1 986 00A1204 BINARY4_0p000001]
  PA ImR ESTAB Error 3 New	[E-00A1 990 00A1205 BINARY4_0p000001]
  PA ImR ESTAB Error 4 New	[E-00A1 994 00A1206 BINARY4_0p000001]
  PA ImR ESTAB Error 5 New	[E-00A1 998 00A1207 BINARY4_0p000001]
  PA AZ Zero Offset Old	[E-00A1 1002 00A1208 BINARY4_0p000001]
  PA EL Zero Offset Old	[E-00A1 1006 00A1209 BINARY4_0p000001]
  PA Roll Mislevel Old	[E-00A1 1010 00A120A BINARY4_0p000001]
  PA Pitch Mislevel Old	[E-00A1 1014 00A120B BINARY4_0p000001]
  PA EL Axis Nonortho Old	[E-00A1 1018 00A120C BINARY4_0p000001]
  PA Collimation Error Old	[E-00A1 1022 00A120D BINARY4_0p000001]
  PA Tube Gravitational Old	[E-00A1 1026 00A120E BINARY4_0p000001]
  PA AZ Axis Wobble 1 Old	[E-00A1 1030 00A120F BINARY4_0p000001]
  PA AZ Axis Wobble 2 Old	[E-00A1 1034 00A1210 BINARY4_0p000001]
  PA AZ Axis Wobble 3 Old	[E-00A1 1038 00A1211 BINARY4_0p000001]
  PA AZ Axis Wobble 4 Old	[E-00A1 1042 00A1212 BINARY4_0p000001]
  PA AZ Axis Wobble 5 Old	[E-00A1 1046 00A1213 BINARY4_0p000001]
  PA AZ Axis Wobble 6 Old	[E-00A1 1050 00A1214 BINARY4_0p000001]
  PA AZ Axis Wobble 7 Old	[E-00A1 1054 00A1215 BINARY4_0p000001]
  PA AZ Axis Wobble 8 Old	[E-00A1 1058 00A1216 BINARY4_0p000001]
  PA AZ Axis Wobble 9 Old	[E-00A1 1062 00A1217 BINARY4_0p000001]
  PA EL Axis Edge Flexure 1  Old	[E-00A1 1066 00A1218 BINARY4_0p000001]
  PA ADC ESTAB Error 1 Old	[E-00A1 1070 00A1219 BINARY4_0p000001]
  PA ADC ESTAB Error 2 Old	[E-00A1 1074 00A121A BINARY4_0p000001]
  PA OBSERV ESTAB Error 1 Old	[E-00A1 1078 00A121B BINARY4_0p000001]
  PA OBSERV ESTAB Error 2 Old	[E-00A1 1082 00A121C BINARY4_0p000001]
  PA ImR Mirror GRAVIT Old	[E-00A1 1086 00A121D BINARY4_0p000001]
  PA EL Axis Edge Flexure 2  Old	[E-00A1 1090 00A121E BINARY4_0p000001]
  PA EL Axis Edge Flexure 3  Old	[E-00A1 1094 00A121F BINARY4_0p000001]
  PA ImR ESTAB Error 1 Old	[E-00A1 1098 00A1220 BINARY4_0p000001]
  PA ImR ESTAB Error 2 Old	[E-00A1 1102 00A1221 BINARY4_0p000001]
  PA ImR ESTAB Error 3 Old	[E-00A1 1106 00A1222 BINARY4_0p000001]
  PA ImR ESTAB Error 4 Old	[E-00A1 1110 00A1223 BINARY4_0p000001]
  PA ImR ESTAB Error 5 Old	[E-00A1 1114 00A1224 BINARY4_0p000001]
  PA AZ Error Average COR New	[E-00A1 1118 00A1225 BINARY4_0p001]
  PA EL Error Average COR New	[E-00A1 1122 00A1227 BINARY4_0p001]
  PA AZ Error Average COR Old	[E-00A1 1126 00A1229 BINARY4_0p001]
  PA EL Error Average COR Old	[E-00A1 1130 00A122B BINARY4_0p001]
  PA AZ RMS Error New	[E-00A1 1134 00A122D BINARY4_0p001]
  PA EL RMS Error  New	[E-00A1 1138 00A122E BINARY4_0p001]
  PA AZ RMS Error Old	[E-00A1 1142 00A122F BINARY4_0p001]
  PA EL RMS Error Old	[E-00A1 1146 00A1230 BINARY4_0p001]
  PA Total RMS Error New	[E-00A1 1150 00A1231 BINARY4_0p001]
  NsOpt(CsOpt)+ImR(R) Selected	[E-00A1 1152:0 00A13EC]
  NsOpt(CsOpt)+ImR(R)+ADC Selected	[E-00A1 1152:1 00A13ED]
  NsIR(CsOpt) Selected	[E-00A1 1152:2 00A13EE]
  NsIR(CsOpt)+ImR Selected	[E-00A1 1152:3 00A13EF]
  NsOpt(NsOpt) Selected	[E-00A1 1152:4 00A13F0]
  NsOpt(NsOpt)+ADC Selected	[E-00A1 1152:5 00A13F1]
  NsOpt(NsOpt)+ImR(B) Selected	[E-00A1 1152:6 00A13F2]
  NsOpt(NsOpt)+ImR(B)+ADC Selected	[E-00A1 1152:7 00A13F3]
  NsOpt(NsOpt)+ImR(R) Selected	[E-00A1 1153:0 00A13F4]
  NsOpt(NsOpt)+ImR(R)+ADC Selected	[E-00A1 1153:1 00A13F5]
  NsIR(NsOpt) Selected	[E-00A1 1153:2 00A13F6]
  NsIR(NsOpt)+ImR Selected	[E-00A1 1153:3 00A13F7]
  CsIR(IR) Selected	[E-00A1 1153:4 00A13F8]
  NsOpt(IR) Selected	[E-00A1 1153:5 00A13F9]
  NsOpt(IR)+ADC Selected	[E-00A1 1153:6 00A13FA]
  NsOpt(IR)+ImR(B) Selected	[E-00A1 1153:7 00A13FB]
  PA Total RMS Error Old	[E-00A1 1154 00A1232 BINARY4_0p001]
  NsOpt(IR)+ImR(B)+ADC Selected	[E-00A1 1154:0 00A13FC]
  NsOpt(IR)+ImR(R) Selected	[E-00A1 1154:1 00A13FD]
  NsOpt(IR)+ImR(R)+ADC Selected	[E-00A1 1154:2 00A13FE]
  NsIR(IR) Selected	[E-00A1 1154:3 00A13FF]
  NsIR(IR)+ImR Selected	[E-00A1 1154:4 00A1400]
  TSC Focus Pattern Alarm	[E-00A1 1154:6 00A1401]
  TSC/Rotator/ADC Selected Alarm	[E-00A1 1154:7 00A1402]
  3rd Mirror Driving	[E-00A1 1155:0 00A1403]
  ImR Switching	[E-00A1 1155:1 00A1404]
  ADC Switching	[E-00A1 1155:2 00A1405]
  AG/SH Probe Moving	[E-00A1 1155:3 00A1406]
  PA AZ RMS Error COR New	[E-00A1 1158 00A1233 BINARY4_0p001]
  PA EL RMS Error COR New	[E-00A1 1162 00A1234 BINARY4_0p001]
  PA AZ RMS Error COR Old	[E-00A1 1166 00A1235 BINARY4_0p001]
  PA EL RMS Error COR Old	[E-00A1 1170 00A1236 BINARY4_0p001]
  PA Total RMS Error COR New	[E-00A1 1174 00A1237 BINARY4_0p001]
  PA Total RMS Error COR Old	[E-00A1 1178 00A1238 BINARY4_0p001]
  PA Plot1 AZ RMS Error	[E-00A1 1182 00A1319 BINARY4_0p001]
  PA Plot1 EL RMS Error	[E-00A1 1186 00A131A BINARY4_0p001]
  PA Plot1 CCD RMS Error	[E-00A1 1190 00A131B BINARY4_0p001]
  PA Plot2 AZ RMS Error	[E-00A1 1194 00A131C BINARY4_0p001]
  PA Plot2 EL RMS Error	[E-00A1 1198 00A131D BINARY4_0p001]
  PA Plot2 CCD RMS Error	[E-00A1 1202 00A131E BINARY4_0p001]
  PA Plot3 AZ RMS Error	[E-00A1 1206 00A131F BINARY4_0p001]
  PA Plot3 EL RMS Error	[E-00A1 1210 00A1320 BINARY4_0p001]
  PA Plot3 CCD RMS Error	[E-00A1 1214 00A1321 BINARY4_0p001]
  PA Plot4 AZ RMS Error	[E-00A1 1218 00A1322 BINARY4_0p001]
  PA IECPT CsOpt	[E-00A1 1222:0 00A1239]
  PA IECPT CsOpt ADC	[E-00A1 1222:1 00A123A]
  PA IECPT CsIR	[E-00A1 1222:2 00A123B]
  PA IECPT POpt	[E-00A1 1222:3 00A123C]
  PA IECPT PIR	[E-00A1 1222:4 00A123D]
  PA IECPT NsOpt	[E-00A1 1222:5 00A123E]
  PA IECPT NsOpt ADC	[E-00A1 1222:6 00A123F]
  PA IECPT NsOpt ImR(Red)	[E-00A1 1223:0 00A1240]
  PA IECPT NsOpt ADC ImR(RED)	[E-00A1 1223:1 00A1241]
  PA IECPT NsIR	[E-00A1 1223:2 00A1242]
  PA IECPT NsIR ImR	[E-00A1 1223:3 00A1243]
  PA IECPT NsOpt ImR(Blue)	[E-00A1 1223:4 00A136F]
  PA IECPT NsOpt ADC ImR(Blue)	[E-00A1 1223:5 00A1370]
  MA IECPT CsOpt	[E-00A1 1224:0 00A1246]
  MA IECPT CsOpt ADC	[E-00A1 1224:1 00A1247]
  MA IECPT CsIR	[E-00A1 1224:2 00A1248]
  MA IECPT POpt	[E-00A1 1224:3 00A1249]
  MA IECPT PIR	[E-00A1 1224:4 00A124A]
  MA IECPT NsOpt	[E-00A1 1224:5 00A124B]
  MA IECPT NsOpt ADC	[E-00A1 1224:6 00A124C]
  MA IECPT NsOpt ImR(Red)	[E-00A1 1225:0 00A124D]
  MA IECPT NsOpt ADC ImR(RED)	[E-00A1 1225:1 00A124E]
  MA IECPT NsIR	[E-00A1 1225:2 00A124F]
  MA IECPT NsIR ImR	[E-00A1 1225:3 00A1250]
  MA IECPT NsOpt ImR(Blue)	[E-00A1 1225:4 00A1375]
  MA IECPT NsOpt ADC ImR(Blue)	[E-00A1 1225:5 00A1376]
  Mirror Analysis Process No.	[E-00A1 1226 00A1251 BINARY1_1]
  Current MA Range No.	[E-00A1 1228 00A1252 BINARY1_1]
  Next MA Range No.	[E-00A1 1230 00A1253 BINARY1_1]
  Total Range Counts	[E-00A1 1232 00A1254 BINARY1_1]
  Remain Range Counts	[E-00A1 1234 00A1255 BINARY1_1]
  MA Schedule Mode	[E-00A1 1235:0 00A1256]
  MA Manual Mode	[E-00A1 1235:1 00A1257]
  MA Simulation Mode	[E-00A1 1235:2 00A1258]
  MA Start Time	[E-00A1 1236 00A1259 ASC15_TIME]
  MA Observation Interval	[E-00A1 1251 00A125A BINARY2_1]
  MA SH Test Interval	[E-00A1 1253 00A125B BINARY2_1]
  MA MIN V-MAG	[E-00A1 1256 00A125C BINARY2_0p01]
  MA MAX V-MAG	[E-00A1 1258 00A125D BINARY2_0p01]
  MA Target Count	[E-00A1 1260 00A125E BINARY1_1]
  MA Current EL Angle	[E-00A1 1261 00A125F BCD6]
  MA Threshold File Creation Time	[E-00A1 1267 00A1260 ASC15_TIME]
  MA All OBSERV Point	[E-00A1 1282 00A1261 BINARY2_1]
  SH Test A00 Warning	[E-00A1 1284:0 00A1262]
  SH Test A11 Warning	[E-00A1 1284:1 00A1263]
  SH Test A1-1 Warning	[E-00A1 1284:2 00A1264]
  SH Test A20 Warning	[E-00A1 1284:3 00A1265]
  SH Test A22 Warning	[E-00A1 1284:4 00A1266]
  SH Test A2-2 Warning	[E-00A1 1284:5 00A1267]
  SH Test A31 Warning	[E-00A1 1284:6 00A1268]
  SH Test A3-1 Warning	[E-00A1 1284:7 00A122C]
  SH Test A33 Warning	[E-00A1 1285:0 00A1269]
  SH Test A3-3 Warning	[E-00A1 1285:1 00A126A]
  SH Test A40 Warning	[E-00A1 1285:2 00A126B]
  SH Test A42 Warning	[E-00A1 1285:3 00A126C]
  SH Test A4-2 Warning	[E-00A1 1285:4 00A126D]
  SH Test A44 Warning	[E-00A1 1285:5 00A126E]
  SH Test A4-4 Warning	[E-00A1 1285:6 00A126F]
  SH Test A51 Warning	[E-00A1 1285:7 00A1270]
  SH Test A5-1 Warning	[E-00A1 1286:0 00A1271]
  SH Test A53 Warning	[E-00A1 1286:1 00A1272]
  SH Test A5-3 Warning	[E-00A1 1286:2 00A1273]
  SH Test A55 Warning	[E-00A1 1286:3 00A1274]
  SH Test A5-5 Warning	[E-00A1 1286:4 00A1275]
  SH Test A60 Warning	[E-00A1 1286:5 00A1276]
  SH Test A62 Warning	[E-00A1 1286:6 00A1277]
  SH Test A6-2 Warning	[E-00A1 1286:7 00A1278]
  SH Test A64 Warning	[E-00A1 1287:0 00A1279]
  SH Test A6-4 Warning	[E-00A1 1287:1 00A127A]
  SH Test A66 Warning	[E-00A1 1287:2 00A127B]
  SH Test A6-6 Warning	[E-00A1 1287:3 00A127C]
  SH Test A71 Warning	[E-00A1 1287:4 00A127D]
  SH Test A7-1 Warning	[E-00A1 1287:5 00A127E]
  SH Test A73 Warning	[E-00A1 1287:6 00A127F]
  SH Test A7-3 Warning	[E-00A1 1287:7 00A1280]
  SH Test A75 Warning	[E-00A1 1288:0 00A1281]
  SH Test A7-5 Warning	[E-00A1 1288:1 00A1282]
  SH Test A77 Warning	[E-00A1 1288:2 00A1283]
  SH Test A7-7 Warning	[E-00A1 1288:3 00A1284]
  SH Test A80 Warning	[E-00A1 1288:4 00A1285]
  SH Test A82 Warning	[E-00A1 1288:5 00A1286]
  SH Test A8-2 Warning	[E-00A1 1288:6 00A1287]
  SH Test A84 Warning	[E-00A1 1288:7 00A1288]
  SH Test A8-4 Warning	[E-00A1 1289:0 00A1289]
  SH Test A86 Warning	[E-00A1 1289:1 00A128A]
  SH Test A8-6 Warning	[E-00A1 1289:2 00A128B]
  SH Test A88 Warning	[E-00A1 1289:3 00A128C]
  SH Test A8-8 Warning	[E-00A1 1289:4 00A128D]
  SH Test A91 Warning	[E-00A1 1289:5 00A128E]
  SH Test A9-1 Warning	[E-00A1 1289:6 00A128F]
  SH Test A93 Warning	[E-00A1 1289:7 00A1290]
  SH Test A9-3 Warning	[E-00A1 1290:0 00A1291]
  SH Test A95 Warning	[E-00A1 1290:1 00A1292]
  SH Test A9-5 Warning	[E-00A1 1290:2 00A1293]
  SH Test A97 Warning	[E-00A1 1290:3 00A1294]
  SH Test A9-7 Warning	[E-00A1 1290:4 00A1295]
  SH Test A99 Warning	[E-00A1 1290:5 00A1296]
  SH Test A9-9 Warning	[E-00A1 1290:6 00A1297]
  SH Test A100 Warning	[E-00A1 1290:7 00A1298]
  SH Test A102 Warning	[E-00A1 1291:0 00A1299]
  SH Test A10-2 Warning	[E-00A1 1291:1 00A129A]
  SH Test A104 Warning	[E-00A1 1291:2 00A129B]
  SH Test A10-4 Warning	[E-00A1 1291:3 00A129C]
  SH Test A106 Warning	[E-00A1 1291:4 00A129D]
  SH Test A10-6 Warning	[E-00A1 1291:5 00A129E]
  SH Test A108 Warning	[E-00A1 1291:6 00A129F]
  SH Test A10-8 Warning	[E-00A1 1291:7 00A1300]
  SH Test A1010 Warning	[E-00A1 1292:0 00A1301]
  SH Test A10-10 Warning	[E-00A1 1292:1 00A1302]
  SH Test RMS Warning	[E-00A1 1292:2 00A1303]
  MA Run	[E-00A1 1293:0 00A1305]
  MA Pause	[E-00A1 1293:1 00A1306]
  MA Fault	[E-00A1 1293:2 00A1304]
  MA Next Ready	[E-00A1 1293:3 00A1308]
  TSC Zernike Calculate End	[E-00A1 1293:4 00A135B]
  MA Control Machine	[E-00A1 1294 00A1307 str]
  PA Plot4 EL RMS Error	[E-00A1 1298 00A1323 BINARY4_0p001]
  PA Plot4 CCD RMS Error	[E-00A1 1302 00A1324 BINARY4_0p001]
  PA Plot5 AZ RMS Error	[E-00A1 1306 00A1325 BINARY4_0p001]
  PA Plot5 EL RMS Error	[E-00A1 1310 00A1326 BINARY4_0p001]
  PA Plot5 CCD RMS Error	[E-00A1 1314 00A1327 BINARY4_0p001]
  PA PED AZ RMS Error	[E-00A1 1318 00A1328 BINARY4_0p001]
  PA PED EL RMS Error	[E-00A1 1322 00A1329 BINARY4_0p001]
  PA PED CCD RMS Error	[E-00A1 1326 00A132A BINARY4_0p001]
  PA IECP New OBS Time	[E-00A1 1330 00A1330 ASC15_TIME]
  PA IECP Old OBS Time	[E-00A1 1345 00A1331 ASC15_TIME]
  PA RW IECP Type CsOpt	[E-00A1 1360:0 00A1332]
  PA RW IECP Type CsOpt(ADC)	[E-00A1 1360:1 00A1333]
  PA RW IECP Type CsIR	[E-00A1 1360:2 00A1334]
  PA RW IECP Type POpt	[E-00A1 1360:3 00A1335]
  PA RW IECP Type PIR	[E-00A1 1360:4 00A1336]
  PA RW IECP Type NsOpt	[E-00A1 1360:5 00A1337]
  PA RW IECP Type NsOpt(ADC)	[E-00A1 1360:6 00A1338]
  PA RW IECP Type NsOpt(ImR R)	[E-00A1 1360:7 00A1339]
  PA RW IECP Type NsOpt(ADC+ImR R)	[E-00A1 1361:0 00A133A]
  PA RW IECP Type NsIR	[E-00A1 1361:1 00A133B]
  PA RW IECP Type NsIR(ImR)	[E-00A1 1361:2 00A133C]
  PA RW IECP Type NsOpt(ImR B)	[E-00A1 1361:3 00A1371]
  PA RW IECP Type NsOpt(ADC+ImR B)	[E-00A1 1361:4 00A1372]
  PA Plot1 IECP Data Selected	[E-00A1 1362:0 00A133D]
  PA Plot2 IECP Data Selected	[E-00A1 1362:1 00A133E]
  PA Plot3 IECP Data Selected	[E-00A1 1362:2 00A133F]
  PA Plot4 IECP Data Selected	[E-00A1 1362:3 00A1340]
  PA Plot5 IECP Data Selected	[E-00A1 1362:4 00A1341]
  PA IECP Update On	[E-00A1 1363:0 00A1342]
  PA PEDF New Transport	[E-00A1 1363:1 00A1343]
  PA PEDF Old Transport	[E-00A1 1363:2 00A1344]
  PA CEDF New Transport	[E-00A1 1363:3 00A1345]
  PA CEDF Old Transport	[E-00A1 1363:4 00A1346]
  Estimated SM Offset X	[E-00A1 1364 00A1354 BCD6]
  Estimated SM Offset Y	[E-00A1 1370 00A1355 BCD6]
  Estimated SM Offset Z	[E-00A1 1376 00A1356 BCD6]
  Estimated SM Offset THETA x	[E-00A1 1382 00A1357 BCD6]
  Estimated SM Offset THETA y	[E-00A1 1388 00A1358 BCD6]
  PA Min. Light Intensity	[E-00A1 1394 00A11D8 BINARY4_1]
  PA PED File Name	[E-00A1 1398 00A135C str]
  PA Plot1 IECP CAL File	[E-00A1 1430:0 00A135D]
  PA Plot2 IECP CAL File	[E-00A1 1430:1 00A135E]
  PA Plot3 IECP CAL File	[E-00A1 1430:2 00A135F]
  PA Plot4 IECP CAL File	[E-00A1 1430:3 00A1360]
  PA Plot5 IECP CAL File	[E-00A1 1430:4 00A1361]
  PA PED RMS Error Plot1	[E-00A1 1431:0 00A1362]
  PA PED RMS Error Plot2	[E-00A1 1431:1 00A1363]
  PA PED RMS Error Plot3	[E-00A1 1431:2 00A1364]
  PA PED RMS Error Plot4	[E-00A1 1431:3 00A1365]
  PA PED RMS Error Plot5	[E-00A1 1431:4 00A1366]
  PA EL Axis Wobble 1 New	[E-00A1 1432 00A136B BINARY4_0p000001]
  PA EL Axis Wobble 2 New	[E-00A1 1436 00A136C BINARY4_0p000001]
  PA EL Axis Wobble 1 Old	[E-00A1 1440 00A136D BINARY4_0p000001]
  PA EL Axis Wobble 2 Old	[E-00A1 1444 00A136E BINARY4_0p000001]
  Off-Axis Total Point	[E-00A1 1448 00A1377 BINARY1_1]
  Off-Axis Executing Point	[E-00A1 1449 00A1378 BINARY1_1]
  PA IEC A1 Offset	[E-00A1 1458 00A11E4 BINARY4_0p000001]
  PA IEC A5 Offset	[E-00A1 1462 00A11E6 BINARY4_0p000001]
  PA IECPT NsOpt IR	[E-00A1 1466:0 00A138B]
  PA IECPT NsOpt IR+ADC	[E-00A1 1466:1 00A138C]
  PA IECPT NsOpt IR+ImR(Red)	[E-00A1 1466:2 00A138D]
  PA IECPT NsOpt IR+ADC ImR(Red)	[E-00A1 1466:3 00A138E]
  PA IECPT NsOpt IR+ImR(Blue)	[E-00A1 1466:4 00A138F]
  PA IECPT NsOpt IR+ADC ImR(Blue)	[E-00A1 1466:5 00A1390]
  PA IECPT NsIR OPT	[E-00A1 1466:6 00A1391]
  PA IECPT NsIR OPT+ImR	[E-00A1 1466:7 00A1392]
  PA RW IECP Type NsOpt(IR)	[E-00A1 1467:0 00A1393]
  PA RW IECP Type NsOpt(IR+ADC)	[E-00A1 1467:1 00A1394]
  PA RW IECP Type NsOpt(IR+ImR R)	[E-00A1 1467:2 00A1395]
  PA RW IECP Type NsOpt(IR+ADC+ImR R)	[E-00A1 1467:3 00A1396]
  PA RW IECP Type NsOpt(IR+ImR B)	[E-00A1 1467:4 00A1397]
  PA RW IECP Type NsOpt(IR+ADC+ImR B)	[E-00A1 1467:5 00A1398]
  PA RW IECP Type NsIR(OPT)	[E-00A1 1467:6 00A1399]
  PA RW IECP Type NsIR(OPT+ImR)	[E-00A1 1467:7 00A139A]
  PA IECPT NsOpt IR Update	[E-00A1 1468:0 00A139B]
  PA IECPT NsOpt IR+ADC Update	[E-00A1 1468:1 00A139C]
  PA IECPT NsOpt IR+ImR(R) Update	[E-00A1 1468:2 00A139D]
  PA IECPT NsOpt IR+ADC ImR(R) Update	[E-00A1 1468:3 00A139E]
  PA IECPT NsOpt IR+ImR(B) Update	[E-00A1 1468:4 00A139F]
  PA IECPT NsOpt ADC IR+ImR(B) Update	[E-00A1 1468:5 00A13A0]
  PA IECPT NsIR OPT Update	[E-00A1 1468:6 00A13A1]
  PA IECPT NsIR OPT+ImR Update	[E-00A1 1468:7 00A13A2]
  MA IECPT NsOpt+IR	[E-00A1 1469:0 00A13A3]
  MA IECPT NsOpt+IR+ADC	[E-00A1 1469:1 00A13A4]
  MA IECPT NsOpt+IR+ImR(Red)	[E-00A1 1469:2 00A13A5]
  MA IECPT NsOpt+IR+ADC ImR(Red)	[E-00A1 1469:3 00A13A6]
  MA IECPT NsOptIR+ImR(Blue)	[E-00A1 1469:4 00A13A7]
  MA IECPT NsOpt+IR+ADC ImR(Blue)	[E-00A1 1469:5 00A13A8]
  MA IECPT NsIR+OPT	[E-00A1 1469:6 00A13A9]
  MA IECPT NsIR+OPT+ImR	[E-00A1 1469:7 00A13AA]
  PA Restart On	[E-00A1 1470:0 00A13AB]
  MA Load Result File Name	[E-00A1 1471 00A13AC str]
  PA IECPT NsOpt Cs	[E-00A1 1511:0 00A13B1]
  PA IECPT NsOpt Cs+ADC	[E-00A1 1511:1 00A13B2]
  PA IECPT NsOpt Cs+ImR(Red)	[E-00A1 1511:2 00A13B3]
  PA IECPT NsOpt Cs+ADC ImR(Red)	[E-00A1 1511:3 00A13B4]
  PA IECPT NsOpt Cs+ImR(Blue)	[E-00A1 1511:4 00A13B5]
  PA IECPT NsOpt Cs+ADC ImR(Blue)	[E-00A1 1511:5 00A13B6]
  PA IECPT NsIR Cs	[E-00A1 1511:6 00A13B7]
  PA IECPT NsIR Cs+ImR	[E-00A1 1511:7 00A13B8]
  PA RW IECP Type NsOpt(Cs)	[E-00A1 1512:0 00A13B9]
  PA RW IECP Type NsOpt(Cs+ADC)	[E-00A1 1512:1 00A13BA]
  PA RW IECP Type NsOpt(Cs+ImR R)	[E-00A1 1512:2 00A13BB]
  PA RW IECP Type NsOpt(Cs+ADC+ImR R)	[E-00A1 1512:3 00A13BC]
  PA RW IECP Type NsOpt(Cs+ImR B)	[E-00A1 1512:4 00A13BD]
  PA RW IECP Type NsOpt(Cs+ADC+ImR B)	[E-00A1 1512:5 00A13BE]
  PA RW IECP Type NsIR(Cs)	[E-00A1 1512:6 00A13BF]
  PA RW IECP Type NsIR(Cs+ImR)	[E-00A1 1512:7 00A13C0]
  PA IECPT NsOpt Cs Update	[E-00A1 1513:0 00A13C1]
  PA IECPT NsOpt Cs+ADC Update	[E-00A1 1513:1 00A13C2]
  PA IECPT NsOpt Cs+ImR(R) Update	[E-00A1 1513:2 00A13C3]
  PA IECPT NsOpt Cs+ADC ImR(R) Update	[E-00A1 1513:3 00A13C4]
  PA IECPT NsOpt Cs+ImR(B) Update	[E-00A1 1513:4 00A13C5]
  PA IECPT NsOpt ADC Cs+ImR(B) Update	[E-00A1 1513:5 00A13C6]
  PA IECPT NsIR Cs Update	[E-00A1 1513:6 00A13C7]
  PA IECPT NsIR Cs+ImR Update	[E-00A1 1513:7 00A13C8]
  MA IECPT NsOpt+Cs	[E-00A1 1514:0 00A13C9]
  MA IECPT NsOpt+Cs+ADC	[E-00A1 1514:1 00A13CA]
  MA IECPT NsOpt+Cs+ImR(Red)	[E-00A1 1514:2 00A13CB]
  MA IECPT NsOpt+Cs+ADC ImR(Red)	[E-00A1 1514:3 00A13CC]
  MA IECPT NsOptCs+ImR(Blue)	[E-00A1 1514:4 00A13CD]
  MA IECPT NsOpt+Cs+ADC ImR(Blue)	[E-00A1 1514:5 00A13CE]
  MA IECPT NsIR+Cs	[E-00A1 1514:6 00A13CF]
  MA IECPT NsIR+Cs+ImR	[E-00A1 1514:7 00A13D0]
  AZ CW Limit for Cal	[E-00A1 1515 00A13D8 BCD6]
  AZ CCW Limit for Cal	[E-00A1 1521 00A13D9 BCD6]
  EL Up Limit for Cal	[E-00A1 1527 00A13DA BCD6]
  EL Low Limit for Cal	[E-00A1 1533 00A13DB BCD6]
  Rotator/Probe CW Limit for Cal	[E-00A1 1539 00A13DC BCD6]
  Rotator/Probe CCW Limit for Cal	[E-00A1 1545 00A13DD BCD6]
  POpt Selected	[E-00A1 1551:0 00A13E4]
  PIR Selected	[E-00A1 1551:1 00A13E5]
  CsOpt(CsOpt) Selected	[E-00A1 1551:2 00A13E6]
  CsOpt(CsOpt)+ADC Selected	[E-00A1 1551:3 00A13E7]
  NsOpt(CsOPt) Selected	[E-00A1 1551:4 00A13E8]
  NsOpt(CsOpt)+ADC Selected	[E-00A1 1551:5 00A13E9]
  NsOpt(CsOpt)+ImR(B) Selected	[E-00A1 1551:6 00A13EA]
  NsOpt(CsOpt)+ImR(B)+ADC Selected	[E-00A1 1551:7 00A13EB]
  NsIR AO Used	[E-00A1 1555:4 00A140A]
  NsIR AO Not Used	[E-00A1 1555:5 00A140B]
  NsIR(IR)+AO Selected	[E-00A1 1556:0 00A1407]
  NsIR(CsOpt)+AO Selected	[E-00A1 1556:1 00A1408]
  NsIR(NsOpt)+AO Selected	[E-00A1 1556:2 00A1409]
  TSC Outdoor Wind Velocity	[L-00A1 0 00A1040 BCD6]
  Heat Exh Pump TLSCP Temp CMD	[L-00A1 6 00A1170 BCD6]
  Heat Exh Mirror Temp Real	[L-00A1 12 00A1171 BCD6]
  Heat Exh Mirror Temp CMD	[L-00A1 18 00A1172 BCD6]
  Heat Exh Mirror Ambient Temp CMD	[L-00A1 24 00A1173 BCD6]
  Heat Exh Mirror Ambient Temp Real	[L-00A1 30 00A1174 BCD6]
  Heat Exh Mirror Coolant Temp CMD on TSC	[L-00A1 36 00A1175 BCD6]
  Heat Exh Dew Point(TLSCP)	[L-00A1 42 00A1179 BCD6]
  Heat Exh Open Air Temp(TLSCP)	[L-00A1 48 00A117A BCD6]
  Heat Exh Open Air HMD(TLSCP)	[L-00A1 54 00A117B BCD6]
  Heat Exh Dew Point(Mirror)	[L-00A1 60 00A117C BCD6]
  Heat Exh Open Air Temp(Mirror)	[L-00A1 66 00A117D BCD6]
  Heat Exh Open Air HMD(Mirror)	[L-00A1 72 00A117E BCD6]
  Wind Direction(WSCRN CONT)	[L-00A1 78 00A119F BCD6]
  Wind Velocity(WSCRN CONT)	[L-00A1 84 00A11A0 BCD6]
  Wind Direction(Vent CONT)	[L-00A1 90 00A11A1 BCD6]
  Wind Velocity(Vent CONT)	[L-00A1 96 00A11A2 BCD6]
  WInd Direction(WIND CONT)	[L-00A1 102 00A11A3 BCD6]
  Wind Velocity(WIND CONT)	[L-00A1 108 00A11A4 BCD6]
  Top Screen CMD Position(Front)	[L-00A1 114 00A1347 BCD6]
  Top Screen CMD Position(Rear)	[L-00A1 120 00A1348 BCD6]
  Wind Screen CMD Position	[L-00A1 126 00A1349 BCD6]
  Front V CMD Position	[L-00A1 132 00A134A BCD6]
  Rear V1 CMD Position	[L-00A1 138 00A134B BCD6]
  Rear V2 CMD Position	[L-00A1 144 00A134C BCD6]
  Rear V3 CMD Position	[L-00A1 150 00A134D BCD6]
  Rear V4 CMD Position	[L-00A1 156 00A134E BCD6]
  Side V A CMD Position	[L-00A1 162 00A134F BCD6]
  Side V B CMD Position	[L-00A1 168 00A1350 BCD6]
  Side V C CMD Position	[L-00A1 174 00A1351 BCD6]
  Side V D CMD Position	[L-00A1 180 00A1352 BCD6]
  ADC Offset(SYNC)	[L-00A1 186 00A1353 BCD6]
  AG/SH Right Ascention	[L-00A1 192 00A1359 BCD6_RA]
  AG/SH Declination	[L-00A1 198 00A135A BCD6_DEC]
  AZ Correct Angle Of P Offset	[L-00A1 204 00A1379 BCD6]
  EL Correct Angle Of P Offset	[L-00A1 210 00A137A BCD6]
  Time Limit(EL Low)	[L-00A1 216 00A13D1 BINARY4_1]
  Time Limit(EL Up)	[L-00A1 220 00A13D2 BINARY4_1]
  Time Limit(Az)	[L-00A1 224 00A13D3 BINARY4_1]
  Time Limit(InR/ImR/Probe)	[L-00A1 228 00A13D4 BINARY4_1]
  Focus for Time Limit Calculation	[L-00A1 232 00A13D5 BINARY1_1]
  Result Code at Time Limit Cal	[L-00A1 233 00A13D6 BINARY1_1]
  Right Ascention	[S-00A1 0 00A1043 BCD6_RA]
  Declination	[S-00A1 6 00A1044 BCD6_DEC]
  Epoch	[S-00A1 12 00A118B BCD6_Epoch]
  1000 Right Ascention	[S-00A1 18 00A1196 BCD6]
  1000 Declination	[S-00A1 24 00A1197 BCD6]
  Parallax	[S-00A1 30 00A119A BCD6]
  E Term On	[S-00A1 36:0 00A1198]
  E Term Off	[S-00A1 36:1 00A1199]
  AZ Drive Direction +	[S-00A1 36:4 00A119B]
  AZ Drive Direction -	[S-00A1 36:5 00A119C]
  AZ Drive Direction TSC	[S-00A1 36:6 00A119D]
  Error Right Ascention	[S-00A1 37 00A1190 BCD6_RA]
  Error Declination	[S-00A1 43 00A1191 BCD6_DEC]
  AZ(Instrumental Error Correction)	[S-00A1 49 00A11BF BCD6]
  EL(Instrumental Error Correction)	[S-00A1 55 00A11C0 BCD6]
  AZ Index Error	[S-00A1 61 00A11C1 BCD6]
  EL Index Error	[S-00A1 67 00A11C2 BCD6]
  AZ Offset Angle	[S-00A1 73 00A11BD BCD6]
  EL Offset Angle	[S-00A1 79 00A11BE BCD6]
  AZ CMD Before Rail Correction	[S-00A1 85 00A1FF1 BCD6]
  EL CMD Before Rail Correction	[S-00A1 91 00A1FF2 BCD6]
  LST(TSC Calculate)	[S-00A1 98 00A136A ASC7_TIME]
  Right Ascention CMD	[S-00A1 105 00A1389 BCD6_RA]
  Declination CMD	[S-00A1 111 00A138A BCD6_DEC]
  AZ Rail Correction Value	[S-00A1 117 00A1FF3 BCD6]
  EL Rail Correction Value	[S-00A1 123 00A1FF4 BCD6]
  AZ-Tilt Rail Correction Value	[S-00A1 129 00A1FF5 BCD6]
  AZ CMD After Rail Correction	[S-00A1 135 00A1FF6 BCD6]
  EL CMD After Rail Correction	[S-00A1 141 00A1FF7 BCD6]
  Time GEN Strobe Input Alarm	[E-00B1 0:0 00B1045]
  Time GEN Timing Alarm	[E-00B1 0:1 00B1049]
  Time GEN Input Data Alarm on MLP1	[E-00B1 0:2 00B104D]
  M-LAN I/F Alarm(MLP1 IND)	[E-00B1 0:4 00B101F]
  Time Correction Alarm(MLP1 IND)	[E-00B1 0:5 00B1022]
  1s INT Alarm(MLP1 IND)	[E-00B1 0:6 00B1021]
  100ms INT Alarm(MLP1 IND)	[E-00B1 0:7 00B1020]
  Dome - MLP1 Fault	[E-00B1 1:0 00B1001]
  Mount - MLP1 Fault	[E-00B1 1:1 00B1002]
  AG - MLP1 Fault	[E-00B1 1:2 00B1003]
  Rotator - MLP1 Fault	[E-00B1 1:3 00B1004]
  P Rotator - MLP1 Fault	[E-00B1 1:4 00B1005]
  AG/SH - MLP1 Fault	[E-00B1 1:5 00B1006]
  P AG/SH - MLP1 Fault	[E-00B1 1:6 00B1007]
  OBCP - MLP1 Fault	[E-00B1 1:7 00B10A0]
  Tip-Tilt - MLP1 Fault	[E-00B1 2:0 00B1008]
  Balancer - MLP1 Fault	[E-00B1 2:1 00B1009]
  SV - MLP1 Fault	[E-00B1 2:2 00B100A]
  CP1 - MLP1 Fault	[E-00B1 2:3 00B100B]
  Time GEN I/F Fault	[E-00B1 2:4 00B107C]
  AO/OBE Fault	[E-00B1 2:5 00B1083]
  TSC Fault (MLP1 IND)	[E-00B1 2:7 00B100C]
  Mount/Dome Alarm Stop Reset	[E-00B1 3:0 00B1084]
  Chopping RA/DE Mode	[E-00B1 4:0 00B1099]
  Chopping AZ/EL Mode	[E-00B1 4:1 00B109A]
  InR/ImR SYNC Mode	[E-00B1 5:0 00B1013]
  InR/ImR ASYNC Mode	[E-00B1 5:1 00B1014]
  Rotator CMD Mode	[E-00B1 5:2 00B1034]
  Rotator Real Mode	[E-00B1 5:3 00B1035]
  Dome - AZ Remote(TSC) SYNC	[E-00B1 5:4 00B1066]
  Dome - AZ Remote(TSC) ASYNC	[E-00B1 5:5 00B1067]
  ImR SYNC(EL) Mode	[E-00B1 5:6 00B1126]
  AG/SH Angle Telescope SYNC	[E-00B1 6:0 00B103D]
  AG/SH Angle Telescope ASYNC	[E-00B1 6:1 00B1041]
  AG/SH Angle CMD Mode	[E-00B1 6:2 00B107D]
  AG/SH Angle Real Mode	[E-00B1 6:3 00B107E]
  P Rotator SYNC Mode	[E-00B1 6:4 00B1092]
  P Rotator ASYNC Mode	[E-00B1 6:5 00B1093]
  P Rotator CMD Mode	[E-00B1 6:6 00B1094]
  P Rotator Real Mode	[E-00B1 6:7 00B1095]
  AG1 Guide Ready	[E-00B1 7:0 00B1015]
  AG2 Guide Ready	[E-00B1 7:1 00B1023]
  OBE/AO Guide Ready	[E-00B1 7:2 00B1016]
  Tip-Tilt Fast Guide Signal Ready	[E-00B1 7:3 00B1051]
  Fast Guide Signal Link Alarm	[E-00B1 7:4 00B1096]
  AG1 Auto Guide	[E-00B1 8:0 00B1017]
  AG2 Auto Guide	[E-00B1 8:1 00B1024]
  OBE/AO Auto Guide	[E-00B1 8:2 00B1018]
  Tip-Tilt AG Auto Guide	[E-00B1 8:3 00B1055]
  Tip-Tilt AO/OBE Auto Guide	[E-00B1 8:4 00B1059]
  Auto Guide Alarm	[E-00B1 8:7 00B101E]
  AG Data Time on MLP1	[E-00B1 9 00B1019 TIME8]
  Auto Guide Error X	[E-00B1 17 00B101A BINARY4_0p01]
  Auto Guide Error Y	[E-00B1 21 00B101B BINARY4_0p01]
  Auto Guide Intensity	[E-00B1 25 00B1025 BINARY2_1]
  MLP1 Used Error X	[E-00B1 27 00B101C BINARY4_0p01]
  Auto Guide Used Error Y	[E-00B1 31 00B101D BINARY4_0p01]
  Auto Guide Gravity Position X	[E-00B1 35 00B102B BINARY4_0p01]
  Auto Gravity Position Y	[E-00B1 39 00B102C BINARY4_0p01]
  Auto Guide AZ Real Angle	[E-00B1 43 00B1026 BCD6]
  Auto Guide EL Real Angle	[E-00B1 49 00B1027 BCD6]
  Auto Guide Rotator Real Angle	[E-00B1 55 00B1028 BCD6]
  AGUTO Guide r Real Position	[E-00B1 61 00B1029 BCD6]
  Auto Guide AG Position Real Angle	[E-00B1 67 00B102A BCD6]
  Auto Guide AZ CMD Angle	[E-00B1 73 00B102D BCD6]
  Auto Guide EL CMD Angle	[E-00B1 79 00B102E BCD6]
  Auto Guide AZ Error Correct Angle in E	[E-00B1 85 00B102F BCD6]
  Auto Guide EL Error Correct Angle in E	[E-00B1 91 00B1030 BCD6]
  MLP1 OPN	[E-00B1 97:0 00B1031]
  MLP1 STBY	[E-00B1 97:1 00B1032]
  MLP1 Fault on MLP1	[E-00B1 97:2 00B1033]
  MLP2-MLP1 I/F Fault	[E-00B1 97:6 00B1124]
  MLP3-MLP1 I/F Fault	[E-00B1 97:7 00B1125]
  AZ - Dome Limit(MLP1 IND)	[E-00B1 98:0 00B1036]
  Telescope Limit(MLP1 IND)	[E-00B1 98:1 00B1037]
  Dome S/W Limit(MLP1 IND)	[E-00B1 98:2 00B1038]
  ADC S/W Limit(MLP1 IND)	[E-00B1 98:3 00B1039]
  Time GEN 1SYS TCGT Alarm	[E-00B1 100:4 00B1068]
  Time GEN 0SYS TCGT Alarm	[E-00B1 100:5 00B1069]
  Time GEN GPS TCG Alarm	[E-00B1 100:6 00B106A]
  Time GEN Fault	[E-00B1 100:7 00B106B]
  Time GEN 1SYS Selected	[E-00B1 101:0 00B106C]
  Time GEN 0SYS Selected	[E-00B1 101:1 00B106D]
  Time GEN Local	[E-00B1 101:2 00B106E]
  Time GEN Remote	[E-00B1 101:3 00B106F]
  Time GEN Release	[E-00B1 101:4 00B1070]
  Time GEN Lock	[E-00B1 101:5 00B1071]
  Time GEN Fan Alarm	[E-00B1 101:6 00B1072]
  Time GEN INS ERR	[E-00B1 101:7 00B1073]
  Time GEN 1SYS TMG Alarm	[E-00B1 102:0 00B1074]
  Time GEN 0SYS TMG Alarm	[E-00B1 102:1 00B1075]
  Time GEN PS Alarm	[E-00B1 102:2 00B1076]
  Time GEN 1SYS NTP Alarm	[E-00B1 102:3 00B1077]
  Time GEN 0SYS NTP Alarm	[E-00B1 102:4 00B1078]
  Time GEN FDC Alarm	[E-00B1 102:5 00B1079]
  Time GEN Rb OSC Alarm	[E-00B1 102:6 00B107A]
  Time GEN Lock Off	[E-00B1 102:7 00B107B]
  Fast Guide Signal Data Available	[E-00B1 103:0 00B1086]
  Fast Guide Signal POpt Selected	[E-00B1 104:0 00B1088]
  Fast Guide Signal PIR Selected	[E-00B1 104:1 00B1089]
  Fast Guide Signal Cs Selected	[E-00B1 104:2 00B108A]
  Fast Guide Signal NsOpt Selected	[E-00B1 104:3 00B108B]
  Fast Guide Signal NsIR Selected	[E-00B1 104:4 00B108C]
  Auto Guide Error Detect AZ Angle	[E-00B1 110 00B108D BCD6]
  Auto Guide Error Detect EL Angle	[E-00B1 116 00B108E BCD6]
  Fast Guide Signal Error X	[E-00B1 122 00B105D BINARY4_0p01]
  Fast Guide Signal Error Y	[E-00B1 126 00B1061 BINARY4_0p01]
  Fast Guide Signal Intensity	[E-00B1 130 00B1065 BINARY2_1]
  Fast Guide Signal Image Size	[E-00B1 132 00B1087 BINARY4_0p01]
  Fast Guide Signal Selected Alarm	[E-00B1 136:0 00B108F]
  Fast Guide Signal AZ	[E-00B1 137 00B1090 BINARY4_0p00001]
  Fast Guide Signal EL	[E-00B1 141 00B1091 BINARY4_0p00001]
  SV1 Guide Ready	[E-00B1 145:0 00B109C]
  SV2 Guide Ready	[E-00B1 145:1 00B109E]
  PIR AG for SH Guide Ready	[E-00B1 145:2 00B10A4]
  PIR Fibre AG Guide Ready	[E-00B1 145:3 00B10A5]
  SV1 Auto Guide	[E-00B1 146:0 00B109D]
  SV2 Auto Guide	[E-00B1 146:1 00B109F]
  PIR AG for SH Guide	[E-00B1 146:2 00B1120]
  PIR Fibre AG Guide	[E-00B1 146:3 00B1121]
  Non-Sidereal AG Reference Mode	[E-00B1 146:4 00B112D]
  Non-Sidereal AG Probe Mode	[E-00B1 146:5 00B112E]
  Normal AG Mode	[E-00B1 146:6 00B112F]
  AG Reference1 dX	[E-00B1 147 00B1127 BINARY4_0p01]
  AG Reference1 dY	[E-00B1 151 00B1128 BINARY4_0p01]
  AG Reference1 X0	[E-00B1 155 00B1129 BINARY4_0p01]
  AG Reference1 Y0	[E-00B1 159 00B112A BINARY4_0p01]
  Non-Sidereal AG Reference Limit	[E-00B1 163:1 00B1137]
  Non-Sidereal AG r Limit	[E-00B1 163:2 00B1138]
  Non-Sidereal AG Angle Limit	[E-00B1 163:3 00B1139]
  Non-Sidereal AG r Speed Limit	[E-00B1 163:4 00B113A]
  Non-Sidereal AG Angle Speed Lim	[E-00B1 163:5 00B113B]
  Dome I/F TX Last Access Time	[L-00B1 0 00B103A TIME3]
  Dome I/F RX Last Access Time	[L-00B1 3 00B103C TIME3]
  Dome I/F Error Code	[L-00B1 6 00B103B str]
  Mount I/F TX Last Access Time on MLP1	[L-00B1 8 00B103E TIME3]
  Mount I/F RX Last Access Time on MLP1	[L-00B1 11 00B1040 TIME3]
  Mount I/F Error Code on MLP1	[L-00B1 14 00B103F str]
  AG I/F TX Last Access Time	[L-00B1 16 00B1042 TIME3]
  AG I/F RX Last Access Time	[L-00B1 19 00B1044 TIME3]
  AG I/F Error Code	[L-00B1 22 00B1043 str]
  Rotator I/F TX Last Access Time	[L-00B1 24 00B1052 TIME3]
  Rotator I/F RX Last Access Time	[L-00B1 27 00B1054 TIME3]
  Rotator I/F Error Code	[L-00B1 30 00B1053 str]
  P Rotator I/F TX Last Access Time	[L-00B1 32 00B1056 TIME3]
  P ROTAOTR I/F RX Last Access Time	[L-00B1 35 00B1058 TIME3]
  P Rotator I/F Error Code	[L-00B1 38 00B1057 str]
  AG/SH I/F TX Last Access Time	[L-00B1 40 00B104A TIME3]
  AG/SH I/F RX Last Access Time	[L-00B1 43 00B104C TIME3]
  AG/SH I/F Error Code	[L-00B1 46 00B104B str]
  P AG/SH I/F TX Last Access Time	[L-00B1 48 00B104E TIME3]
  P AG/SH I/F RX Last Access Time	[L-00B1 51 00B1050 TIME3]
  P AG/SH I/F Error Code	[L-00B1 54 00B104F str]
  Tip-Tilt I/F TX Last Access Time	[L-00B1 56 00B105A TIME3]
  Tip-Tilt I/F RX Last Access Time	[L-00B1 59 00B105C TIME3]
  Tip-Tilt I/F Error Code	[L-00B1 62 00B105B str]
  Balancer I/F TX Last Access Time	[L-00B1 64 00B105E TIME3]
  Balancer I/F RX Last Access Time	[L-00B1 67 00B1060 TIME3]
  Balancer I/F Error Code	[L-00B1 70 00B105F str]
  SV I/F TX Last Access Time	[L-00B1 72 00B1046 TIME3]
  SV I/F RX Last Access Time	[L-00B1 75 00B1048 TIME3]
  SV I/F Error Code	[L-00B1 78 00B1047 str]
  CP1 I/F TX Last Access Time	[L-00B1 80 00B1062 TIME3]
  CP1 I/F RX Last Access Time	[L-00B1 83 00B1064 TIME3]
  CP1 I/F Error Code	[L-00B1 86 00B1063 str]
  Time GEN I/F RX Last Access Time	[L-00B1 88 00B107F TIME3]
  Time GEN I/F Error Code	[L-00B1 91 00B1080 str]
  AO/OBE I/F RX Last Access Time	[L-00B1 93 00B1081 TIME3]
  AO/OBE I/F Error Code	[L-00B1 96 00B1082 str]
  Rotator Offset Angle	[L-00B1 98 00B1085 BCD6]
  AG/SH Angle Offset Angle	[L-00B1 104 00B1097 BCD6]
  P Rotator Offset Angle	[L-00B1 110 00B1098 BCD6]
  Chopping Position Offset Angle	[L-00B1 116 00B109B BCD6]
  OBCP I/F TX Last Access Time	[L-00B1 122 00B10A1 TIME3]
  OBCP I/F RX Last Access Time	[L-00B1 125 00B10A2 TIME3]
  OBCP I/F Error Code	[L-00B1 128 00B10A3 str]
  AG Star Position1 Error X on MLP1	[S-00B1 0 00B1101 BINARY4_0p01]
  AG Star Position1 Error Y on MLP1	[S-00B1 4 00B1102 BINARY4_0p01]
  AG Star1 Image Size	[S-00B1 8 00B1103 BINARY4_0p01]
  AG Star Position1 Intensity on MLP1	[S-00B1 12 00B1104 BINARY2_1]
  AG Star Position2 Error X on MLP1	[S-00B1 14 00B1105 BINARY4_0p01]
  AG Star Position2 Error Y on MLP1	[S-00B1 18 00B1106 BINARY4_0p01]
  AG Star2 Image Size	[S-00B1 22 00B1107 BINARY4_0p01]
  AG Star Position2 Intensity on MLP1	[S-00B1 26 00B1108 BINARY2_1]
  SV Star Position1 Error X on MLP1	[S-00B1 28 00B1109 BINARY4_0p01]
  SV Star Position1 Error Y on MLP1	[S-00B1 32 00B110A BINARY4_0p01]
  SV Star1 Image Size	[S-00B1 36 00B110B BINARY4_0p01]
  SV Star Position1 Intensity on MLP1	[S-00B1 40 00B110C BINARY2_1]
  SV Star Position2 Error X on MLP1	[S-00B1 42 00B110D BINARY4_0p01]
  SV Star Position2 Error Y on MLP1	[S-00B1 46 00B110E BINARY4_0p01]
  SV Star2 Image Size	[S-00B1 50 00B110F BINARY4_0p01]
  SV Star Position2 Intensity on MLP1	[S-00B1 54 00B1110 BINARY2_1]
  AG Star Position1 Detect Start on MLP1	[S-00B1 56:0 00B1111]
  AG Star Position1 Detect Stop on MLP1	[S-00B1 56:1 00B1112]
  AG Star Position2 Detect Start on MLP1	[S-00B1 56:2 00B1113]
  AG Star Position2 Detect Stop on MLP1	[S-00B1 56:3 00B1114]
  SV Star Position1 Detect Start on MLP1	[S-00B1 56:4 00B1115]
  SV Star Position1 Detect Stop on MLP1	[S-00B1 56:5 00B1116]
  SV Star Position2 Detect Start on MLP1	[S-00B1 56:6 00B1117]
  SV Star Position2 Detect Stop on MLP1	[S-00B1 56:7 00B1118]
  Guide Stop	[S-00B1 57:0 00B1119]
  AG1 Guide Start	[S-00B1 57:1 00B111A]
  AG2 Guide Start	[S-00B1 57:2 00B111B]
  SV1 Guide Start	[S-00B1 57:3 00B111C]
  SV2 Guide Start	[S-00B1 57:4 00B111D]
  PIR AG for SH Guide on MLP1	[S-00B1 57:5 00B1122]
  PIR Fibre AG Guide on MLP1	[S-00B1 57:6 00B1123]
  Auto Guide AZ Error Correct Angle in S	[S-00B1 58 00B111E BCD6]
  Auto Guide EL Error Correct Angle in S	[S-00B1 64 00B111F BCD6]
  Non-Sidereal AG Reference X	[S-00B1 70 00B112B BINARY4_0p000001]
  Non-Sidereal AG Reference Y	[S-00B1 74 00B112C BINARY4_0p000001]
  Non-Sidereal AG adj Xf	[S-00B1 78 00B1130 BCD6]
  Non-Sidereal AG adj Yf	[S-00B1 84 00B1131 BCD6]
  Non-Sidereal AG X Ref in 0.1sec	[S-00B1 90 00B1133 BINARY4_0p000001]
  Non-Sidereal AG Y Ref in 0.1sec	[S-00B1 94 00B1134 BINARY4_0p000001]
  Non-Sidereal AG r Speed	[S-00B1 98 00B1135 BCD6]
  Non-Sidereal AG Angle Speed	[S-00B1 104 00B1136 BCD6]
  MLP2 OPN	[E-00B2 0:0 00B2126]
  MLP2 STBY	[E-00B2 0:1 00B2127]
  MLP2 Fault	[E-00B2 0:2 00B2128]
  Actuator Interlock Release	[E-00B2 0:3 00B295F]
  Mirror Support Stop Mode	[E-00B2 1:0 00B210D]
  Mirror Support Normal Mode	[E-00B2 1:1 00B210E]
  Mirror Support Simulation Mode	[E-00B2 1:2 00B210F]
  Actuator Down Load Mode	[E-00B2 1:3 00B2110]
  Actuator Step Test Mode	[E-00B2 1:4 00B2111]
  Actuator Sensing Test Mode	[E-00B2 1:5 00B2112]
  Mirror Analysis Correct On	[E-00B2 2:0 00B211D]
  Mirror Analysis Correct Off	[E-00B2 2:1 00B211E]
  FFB Correct On	[E-00B2 2:2 00B211F]
  FFB Correct Off	[E-00B2 2:3 00B2120]
  A40 Correct On	[E-00B2 2:4 00B2121]
  A40 Correct Off	[E-00B2 2:5 00B2123]
  IEC Correct On	[E-00B2 2:6 00B2124]
  IEC Correct Off	[E-00B2 2:7 00B2125]
  Mirror Support Alarm IND	[E-00B2 3:0 00B2115]
  Mirror Support Correction Limit	[E-00B2 3:1 00B2114]
  Zernike RMS Alarm	[E-00B2 3:2 00B2116]
  All Actuator CMD COMP Alarm	[E-00B2 3:3 00B2113]
  Actuator CMD COMP Alarm(Gradient)	[E-00B2 3:4 00B2117]
  SH Data Illegal	[E-00B2 3:5 00B212D]
  MLP2 MCU ENC Alarm IND	[E-00B2 3:6 00B291E]
  TSC Fault IND	[E-00B2 4:1 00B291C]
  MLP2 M-LAN I/F Alarm	[E-00B2 4:4 00B2118]
  Time Correction Alarm(MLP2 IND)	[E-00B2 4:5 00B211B]
  1s INT Alarm(MLP2 IND)	[E-00B2 4:6 00B211A]
  100ms INT Alarm(MLP2 IND)	[E-00B2 4:7 00B2119]
  SH - MLP2 Fault	[E-00B2 5:0 00B2001]
  2nd Mirror - MLP2 Fault	[E-00B2 5:1 00B2002]
  PFCU - MLP2 Fault	[E-00B2 5:2 00B2003]
  Mount - MLP2 Fault	[E-00B2 5:3 00B2004]
  PMFXS Force Alarm	[E-00B2 6:0 00B2922]
  Actuator CMD-Real Alarm	[E-00B2 6:1 00B2923]
  PMFXS Under/Over Range IND	[E-00B2 6:2 00B292E]
  Actuator Position UNCALC IND	[E-00B2 6:3 00B292F]
  Actuator Fault Number IND	[E-00B2 6:4 00B2930]
  PMPSR ESB PSU Power Off	[E-00B2 7:0 00B2133]
  PMPSR ESB PSU Fault	[E-00B2 7:1 00B2134]
  PMPSR ESB Fan Alarm	[E-00B2 7:6 00B294B]
  PMPSR ESB NFB Trip	[E-00B2 7:7 00B294C]
  Actuator Failure Recovery ModeO	[E-00B2 8:0 00B2130]
  Actuator Failure Recovery Mode1	[E-00B2 8:1 00B2131]
  Actuator Failure Recovery Mode2	[E-00B2 8:2 00B2132]
  PMPSR NsIR PSU Power Off	[E-00B2 9:0 00B2135]
  PMPSR NsIR PSU Fault	[E-00B2 9:1 00B2136]
  PMPSR NsIR Rack Power Off	[E-00B2 9:2 00B2137]
  PMPSR NsIR Rack Alarm	[E-00B2 9:3 00B2138]
  PMPSR NsIR Temp Alarm	[E-00B2 9:4 00B2139]
  PMPSR NsIR Frost Alarm	[E-00B2 9:5 00B294D]
  PMPSR NsIR Fan Alarm	[E-00B2 9:6 00B294E]
  PMPSR NsIR NFB Trip	[E-00B2 9:7 00B294F]
  Actuator Position Correct On	[E-00B2 10:0 00B292B]
  Actuator Position Correct Off	[E-00B2 10:1 00B292C]
  Actuator Down Limit Detection Start	[E-00B2 10:2 00B2924]
  Actuator Down Limit Detection Stop	[E-00B2 10:3 00B2925]
  Actuator Real Sum. With Socket	[E-00B2 10:4 00B2926]
  Actuator Real Sum.	[E-00B2 10:5 00B2927]
  Actuator Real Sum.(Position Mode)	[E-00B2 10:6 00B292D]
  MLP2 DLL/Test Start Time	[E-00B2 11 00B212C TIME3]
  Actuator CMD All Selected	[E-00B2 14:0 00B2931]
  Actuator CMD PM Selected	[E-00B2 14:1 00B2932]
  Actuator CMD Socket Selected	[E-00B2 14:2 00B2933]
  Actuator CMD IEC(EL) Selected	[E-00B2 14:3 00B293F]
  Actuator CMD IEC(Offset) Selected	[E-00B2 14:4 00B2940]
  Actuator CMD A40 Selected	[E-00B2 14:5 00B218D]
  Actuator CMD FFB Selected	[E-00B2 14:6 00B218E]
  Actuator CMD SH Selected	[E-00B2 14:7 00B218F]
  Actuator CMD SH(MA) Selected	[E-00B2 15:0 00B2190]
  Actuator CMD Offset Selected	[E-00B2 15:1 00B2191]
  SM Auto Focus Adjustment On	[E-00B2 16:0 00B2192]
  SM Auto Focus Adjustment Off	[E-00B2 16:1 00B2193]
  PIR Auto Focus Adjustment On	[E-00B2 16:2 00B2960]
  PIR Auto Focus Adjustment Off	[E-00B2 16:3 00B2961]
  2nd Mirror-EL SYNC	[E-00B2 17:0 00B2920]
  2nd Mirror-EL ASYNC	[E-00B2 17:1 00B2921]
  SM SH Correction On	[E-00B2 17:2 00B293D]
  SM SH Correction Off	[E-00B2 17:3 00B293E]
  PIR-EL SYNC	[E-00B2 17:4 00B2962]
  PIR-EL ASYNC	[E-00B2 17:5 00B2963]
  Actuator1-1 Fault	[E-00B2 18:0 00B2005]
  Actuator1-2 Fault	[E-00B2 18:1 00B2006]
  Actuator1-3 Fault	[E-00B2 18:2 00B2007]
  Actuator1-4 Fault	[E-00B2 18:3 00B2008]
  Actuator1-5 Fault	[E-00B2 18:4 00B2009]
  Actuator1-6 Fault	[E-00B2 18:5 00B200A]
  Actuator1-7 Fault	[E-00B2 18:6 00B200B]
  Actuator1-8 Fault	[E-00B2 18:7 00B200C]
  Actuator1-9 Fault	[E-00B2 19:0 00B200D]
  Actuator1-10 Fault	[E-00B2 19:1 00B200E]
  Actuator1-11 Fault	[E-00B2 19:2 00B200F]
  Actuator1-12 Fault	[E-00B2 19:3 00B2010]
  Actuator2-1 Fault	[E-00B2 19:4 00B2011]
  Actuator2-2 Fault	[E-00B2 19:5 00B2012]
  Actuator2-3 Fault	[E-00B2 19:6 00B2013]
  Actuator2-4 Fault	[E-00B2 19:7 00B2014]
  Actuator2-5 Fault	[E-00B2 20:0 00B2015]
  Actuator2-6 Fault	[E-00B2 20:1 00B2016]
  Actuator2-7 Fault	[E-00B2 20:2 00B2017]
  Actuator2-8 Fault	[E-00B2 20:3 00B2018]
  Actuator2-9 Fault	[E-00B2 20:4 00B2019]
  Actuator2-10 Fault	[E-00B2 20:5 00B201A]
  Actuator2-11 Fault	[E-00B2 20:6 00B201B]
  Actuator2-12 Fault	[E-00B2 20:7 00B201C]
  Actuator2-13 Fault	[E-00B2 21:0 00B201D]
  Actuator2-14 Fault	[E-00B2 21:1 00B201E]
  Actuator2-15 Fault	[E-00B2 21:2 00B201F]
  Actuator2-16 Fault	[E-00B2 21:3 00B2020]
  Actuator2-17 Fault	[E-00B2 21:4 00B2021]
  Actuator2-18 Fault	[E-00B2 21:5 00B2022]
  Actuator3-1 Fault	[E-00B2 21:6 00B2023]
  Actuator3-2 Fault	[E-00B2 21:7 00B2024]
  Actuator3-3 Fault	[E-00B2 22:0 00B2025]
  Actuator3-4 Fault	[E-00B2 22:1 00B2026]
  Actuator3-5 Fault	[E-00B2 22:2 00B2027]
  Actuator3-6 Fault	[E-00B2 22:3 00B2028]
  Actuator3-7 Fault	[E-00B2 22:4 00B2029]
  Actuator3-8 Fault	[E-00B2 22:5 00B202A]
  Actuator3-9 Fault	[E-00B2 22:6 00B202B]
  Actuator3-10 Fault	[E-00B2 22:7 00B202C]
  Actuator3-11 Fault	[E-00B2 23:0 00B202D]
  Actuator3-12 Fault	[E-00B2 23:1 00B202E]
  Actuator3-13 Fault	[E-00B2 23:2 00B202F]
  Actuator3-14 Fault	[E-00B2 23:3 00B2030]
  Actuator3-15 Fault	[E-00B2 23:4 00B2031]
  Actuator3-16 Fault	[E-00B2 23:5 00B2032]
  Actuator3-17 Fault	[E-00B2 23:6 00B2033]
  Actuator3-18 Fault	[E-00B2 23:7 00B2034]
  Actuator3-19 Fault	[E-00B2 24:0 00B2035]
  Actuator3-20 Fault	[E-00B2 24:1 00B2036]
  Actuator3-21 Fault	[E-00B2 24:2 00B2037]
  Actuator3-22 Fault	[E-00B2 24:3 00B2038]
  Actuator3-23 Fault	[E-00B2 24:4 00B2039]
  Actuator3-24 Fault	[E-00B2 24:5 00B203A]
  Actuator4-1 Fault	[E-00B2 24:6 00B203B]
  Actuator4-2 Fault	[E-00B2 24:7 00B203C]
  Actuator4-3 Fault	[E-00B2 25:0 00B203D]
  Actuator4-4 Fault	[E-00B2 25:1 00B203E]
  Actuator4-5 Fault	[E-00B2 25:2 00B203F]
  Actuator4-6 Fault	[E-00B2 25:3 00B2040]
  Actuator4-7 Fault	[E-00B2 25:4 00B2041]
  Actuator4-8 Fault	[E-00B2 25:5 00B2042]
  Actuator4-9 Fault	[E-00B2 25:6 00B2043]
  Actuator4-10 Fault	[E-00B2 25:7 00B2044]
  Actuator4-11 Fault	[E-00B2 26:0 00B2045]
  Actuator4-12 Fault	[E-00B2 26:1 00B2046]
  Actuator4-13 Fault	[E-00B2 26:2 00B2047]
  Actuator4-14 Fault	[E-00B2 26:3 00B2048]
  Actuator4-15 Fault	[E-00B2 26:4 00B2049]
  Actuator4-16 Fault	[E-00B2 26:5 00B204A]
  Actuator4-17 Fault	[E-00B2 26:6 00B204B]
  Actuator4-18 Fault	[E-00B2 26:7 00B204C]
  Actuator4-19 Fault	[E-00B2 27:0 00B204D]
  Actuator4-20 Fault	[E-00B2 27:1 00B204E]
  Actuator4-21 Fault	[E-00B2 27:2 00B204F]
  Actuator4-22 Fault	[E-00B2 27:3 00B2050]
  Actuator4-23 Fault	[E-00B2 27:4 00B2051]
  Actuator4-24 Fault	[E-00B2 27:5 00B2052]
  Actuator4-25 Fault	[E-00B2 27:6 00B2053]
  Actuator4-26 Fault	[E-00B2 27:7 00B2054]
  Actuator4-27 Fault	[E-00B2 28:0 00B2055]
  Actuator4-28 Fault	[E-00B2 28:1 00B2056]
  Actuator4-29 Fault	[E-00B2 28:2 00B2057]
  Actuator4-30 Fault	[E-00B2 28:3 00B2058]
  Actuator5-1 Fault	[E-00B2 28:4 00B2059]
  Actuator5-2 Fault	[E-00B2 28:5 00B205A]
  Actuator5-3 Fault	[E-00B2 28:6 00B205B]
  Actuator5-4 Fault	[E-00B2 28:7 00B205C]
  Actuator5-5 Fault	[E-00B2 29:0 00B205D]
  Actuator5-6 Fault	[E-00B2 29:1 00B205E]
  Actuator5-7 Fault	[E-00B2 29:2 00B205F]
  Actuator5-8 Fault	[E-00B2 29:3 00B2060]
  Actuator5-9 Fault	[E-00B2 29:4 00B2061]
  Actuator5-10 Fault	[E-00B2 29:5 00B2062]
  Actuator5-11 Fault	[E-00B2 29:6 00B2063]
  Actuator5-12 Fault	[E-00B2 29:7 00B2064]
  Actuator5-13 Fault	[E-00B2 30:0 00B2065]
  Actuator5-14 Fault	[E-00B2 30:1 00B2066]
  Actuator5-15 Fault	[E-00B2 30:2 00B2067]
  Actuator5-16 Fault	[E-00B2 30:3 00B2068]
  Actuator5-17 Fault	[E-00B2 30:4 00B2069]
  Actuator5-18 Fault	[E-00B2 30:5 00B206A]
  Actuator5-19 Fault	[E-00B2 30:6 00B206B]
  Actuator5-20 Fault	[E-00B2 30:7 00B206C]
  Actuator5-21 Fault	[E-00B2 31:0 00B206D]
  Actuator5-22 Fault	[E-00B2 31:1 00B206E]
  Actuator5-23 Fault	[E-00B2 31:2 00B206F]
  Actuator5-24 Fault	[E-00B2 31:3 00B2070]
  Actuator5-25 Fault	[E-00B2 31:4 00B2071]
  Actuator5-26 Fault	[E-00B2 31:5 00B2072]
  Actuator5-27 Fault	[E-00B2 31:6 00B2073]
  Actuator5-28 Fault	[E-00B2 31:7 00B2074]
  Actuator5-29 Fault	[E-00B2 32:0 00B2075]
  Actuator5-30 Fault	[E-00B2 32:1 00B2076]
  Actuator5-31 Fault	[E-00B2 32:2 00B2077]
  Actuator5-32 Fault	[E-00B2 32:3 00B2078]
  Actuator5-33 Fault	[E-00B2 32:4 00B2079]
  Actuator5-34 Fault	[E-00B2 32:5 00B207A]
  Actuator5-35 Fault	[E-00B2 32:6 00B207B]
  Actuator5-36 Fault	[E-00B2 32:7 00B207C]
  Actuator6-1 Fault	[E-00B2 33:0 00B207D]
  Actuator6-2 Fault	[E-00B2 33:1 00B207E]
  Actuator6-3 Fault	[E-00B2 33:2 00B207F]
  Actuator6-4 Fault	[E-00B2 33:3 00B2080]
  Actuator6-5 Fault	[E-00B2 33:4 00B2081]
  Actuator6-6 Fault	[E-00B2 33:5 00B2082]
  Actuator6-7 Fault	[E-00B2 33:6 00B2083]
  Actuator6-8 Fault	[E-00B2 33:7 00B2084]
  Actuator6-9 Fault	[E-00B2 34:0 00B2085]
  Actuator6-10 Fault	[E-00B2 34:1 00B2086]
  Actuator6-11 Fault	[E-00B2 34:2 00B2087]
  Actuator6-12 Fault	[E-00B2 34:3 00B2088]
  Actuator6-13 Fault	[E-00B2 34:4 00B2089]
  Actuator6-14 Fault	[E-00B2 34:5 00B208A]
  Actuator6-15 Fault	[E-00B2 34:6 00B208B]
  Actuator6-16 Fault	[E-00B2 34:7 00B208C]
  Actuator6-17 Fault	[E-00B2 35:0 00B208D]
  Actuator6-18 Fault	[E-00B2 35:1 00B208E]
  Actuator6-19 Fault	[E-00B2 35:2 00B208F]
  Actuator6-20 Fault	[E-00B2 35:3 00B2090]
  Actuator6-21 Fault	[E-00B2 35:4 00B2091]
  Actuator6-22 Fault	[E-00B2 35:5 00B2092]
  Actuator6-23 Fault	[E-00B2 35:6 00B2093]
  Actuator6-24 Fault	[E-00B2 35:7 00B2094]
  Actuator6-25 Fault	[E-00B2 36:0 00B2095]
  Actuator6-26 Fault	[E-00B2 36:1 00B2096]
  Actuator6-27 Fault	[E-00B2 36:2 00B2097]
  Actuator6-28 Fault	[E-00B2 36:3 00B2098]
  Actuator6-29 Fault	[E-00B2 36:4 00B2099]
  Actuator6-30 Fault	[E-00B2 36:5 00B209A]
  Actuator6-31 Fault	[E-00B2 36:6 00B209B]
  Actuator6-32 Fault	[E-00B2 36:7 00B209C]
  Actuator6-33 Fault	[E-00B2 37:0 00B209D]
  Actuator6-34 Fault	[E-00B2 37:1 00B209E]
  Actuator6-35 Fault	[E-00B2 37:2 00B209F]
  Actuator6-36 Fault	[E-00B2 37:3 00B20A0]
  Actuator6-37 Fault	[E-00B2 37:4 00B20A1]
  Actuator6-38 Fault	[E-00B2 37:5 00B20A2]
  Actuator6-39 Fault	[E-00B2 37:6 00B20A3]
  Actuator6-40 Fault	[E-00B2 37:7 00B20A4]
  Actuator6-41 Fault	[E-00B2 38:0 00B20A5]
  Actuator6-42 Fault	[E-00B2 38:1 00B20A6]
  Actuator7-1 Fault	[E-00B2 38:2 00B20A7]
  Actuator7-2 Fault	[E-00B2 38:3 00B20A8]
  Actuator7-3 Fault	[E-00B2 38:4 00B20A9]
  Actuator7-4 Fault	[E-00B2 38:5 00B20AA]
  Actuator7-5 Fault	[E-00B2 38:6 00B20AB]
  Actuator7-6 Fault	[E-00B2 38:7 00B20AC]
  Actuator7-7 Fault	[E-00B2 39:0 00B20AD]
  Actuator7-8 Fault	[E-00B2 39:1 00B20AE]
  Actuator7-9 Fault	[E-00B2 39:2 00B20AF]
  Actuator7-10 Fault	[E-00B2 39:3 00B20B0]
  Actuator7-11 Fault	[E-00B2 39:4 00B20B1]
  Actuator7-12 Fault	[E-00B2 39:5 00B20B2]
  Actuator7-13 Fault	[E-00B2 39:6 00B20B3]
  Actuator7-14 Fault	[E-00B2 39:7 00B20B4]
  Actuator7-15 Fault	[E-00B2 40:0 00B20B5]
  Actuator7-16 Fault	[E-00B2 40:1 00B20B6]
  Actuator7-17 Fault	[E-00B2 40:2 00B20B7]
  Actuator7-18 Fault	[E-00B2 40:3 00B20B8]
  Actuator7-19 Fault	[E-00B2 40:4 00B20B9]
  Actuator7-20 Fault	[E-00B2 40:5 00B20BA]
  Actuator7-21 Fault	[E-00B2 40:6 00B20BB]
  Actuator7-22 Fault	[E-00B2 40:7 00B20BC]
  Actuator7-23 Fault	[E-00B2 41:0 00B20BD]
  Actuator7-24 Fault	[E-00B2 41:1 00B20BE]
  Actuator7-25 Fault	[E-00B2 41:2 00B20BF]
  Actuator7-26 Fault	[E-00B2 41:3 00B20C0]
  Actuator7-27 Fault	[E-00B2 41:4 00B20C1]
  Actuator7-28 Fault	[E-00B2 41:5 00B20C2]
  Actuator7-29 Fault	[E-00B2 41:6 00B20C3]
  Actuator7-30 Fault	[E-00B2 41:7 00B20C4]
  Actuator7-31 Fault	[E-00B2 42:0 00B20C5]
  Actuator7-32 Fault	[E-00B2 42:1 00B20C6]
  Actuator7-33 Fault	[E-00B2 42:2 00B20C7]
  Actuator7-34 Fault	[E-00B2 42:3 00B20C8]
  Actuator7-35 Fault	[E-00B2 42:4 00B20C9]
  Actuator7-36 Fault	[E-00B2 42:5 00B20CA]
  Actuator7-37 Fault	[E-00B2 42:6 00B20CB]
  Actuator7-38 Fault	[E-00B2 42:7 00B20CC]
  Actuator7-39 Fault	[E-00B2 43:0 00B20CD]
  Actuator7-40 Fault	[E-00B2 43:1 00B20CE]
  Actuator7-41 Fault	[E-00B2 43:2 00B20CF]
  Actuator7-42 Fault	[E-00B2 43:3 00B20D0]
  Actuator7-43 Fault	[E-00B2 43:4 00B20D1]
  Actuator7-44 Fault	[E-00B2 43:5 00B20D2]
  Actuator7-45 Fault	[E-00B2 43:6 00B20D3]
  Actuator7-46 Fault	[E-00B2 43:7 00B20D4]
  Actuator7-47 Fault	[E-00B2 44:0 00B20D5]
  Actuator7-48 Fault	[E-00B2 44:1 00B20D6]
  Actuator8-1 Fault	[E-00B2 44:2 00B20D7]
  Actuator8-2 Fault	[E-00B2 44:3 00B20D8]
  Actuator8-3 Fault	[E-00B2 44:4 00B20D9]
  Actuator8-4 Fault	[E-00B2 44:5 00B20DA]
  Actuator8-5 Fault	[E-00B2 44:6 00B20DB]
  Actuator8-6 Fault	[E-00B2 44:7 00B20DC]
  Actuator8-7 Fault	[E-00B2 45:0 00B20DD]
  Actuator8-8 Fault	[E-00B2 45:1 00B20DE]
  Actuator8-9 Fault	[E-00B2 45:2 00B20DF]
  Actuator8-10 Fault	[E-00B2 45:3 00B20E0]
  Actuator8-11 Fault	[E-00B2 45:4 00B20E1]
  Actuator8-12 Fault	[E-00B2 45:5 00B20E2]
  Actuator8-13 Fault	[E-00B2 45:6 00B20E3]
  Actuator8-14 Fault	[E-00B2 45:7 00B20E4]
  Actuator8-15 Fault	[E-00B2 46:0 00B20E5]
  Actuator8-16 Fault	[E-00B2 46:1 00B20E6]
  Actuator8-17 Fault	[E-00B2 46:2 00B20E7]
  Actuator8-18 Fault	[E-00B2 46:3 00B20E8]
  Actuator8-19 Fault	[E-00B2 46:4 00B20E9]
  Actuator8-20 Fault	[E-00B2 46:5 00B20EA]
  Actuator8-21 Fault	[E-00B2 46:6 00B20EB]
  Actuator8-22 Fault	[E-00B2 46:7 00B20EC]
  Actuator8-23 Fault	[E-00B2 47:0 00B20ED]
  Actuator8-24 Fault	[E-00B2 47:1 00B20EE]
  Actuator8-25 Fault	[E-00B2 47:2 00B20EF]
  Actuator8-26 Fault	[E-00B2 47:3 00B20F0]
  Actuator8-27 Fault	[E-00B2 47:4 00B20F1]
  Actuator8-28 Fault	[E-00B2 47:5 00B20F2]
  Actuator8-29 Fault	[E-00B2 47:6 00B20F3]
  Actuator8-30 Fault	[E-00B2 47:7 00B20F4]
  Actuator8-31 Fault	[E-00B2 48:0 00B20F5]
  Actuator8-32 Fault	[E-00B2 48:1 00B20F6]
  Actuator8-33 Fault	[E-00B2 48:2 00B20F7]
  Actuator8-34 Fault	[E-00B2 48:3 00B20F8]
  Actuator8-35 Fault	[E-00B2 48:4 00B20F9]
  Actuator8-36 Fault	[E-00B2 48:5 00B20FA]
  Actuator8-37 Fault	[E-00B2 48:6 00B20FB]
  Actuator8-38 Fault	[E-00B2 48:7 00B20FC]
  Actuator8-39 Fault	[E-00B2 49:0 00B20FD]
  Actuator8-40 Fault	[E-00B2 49:1 00B20FE]
  Actuator8-41 Fault	[E-00B2 49:2 00B20FF]
  Actuator8-42 Fault	[E-00B2 49:3 00B2100]
  Actuator8-43 Fault	[E-00B2 49:4 00B2101]
  Actuator8-44 Fault	[E-00B2 49:5 00B2102]
  Actuator8-45 Fault	[E-00B2 49:6 00B2103]
  Actuator8-46 Fault	[E-00B2 49:7 00B2104]
  Actuator8-47 Fault	[E-00B2 50:0 00B2105]
  Actuator8-48 Fault	[E-00B2 50:1 00B2106]
  Actuator8-49 Fault	[E-00B2 50:2 00B2107]
  Actuator8-50 Fault	[E-00B2 50:3 00B2108]
  Actuator8-51 Fault	[E-00B2 50:4 00B2109]
  PMFXS8-61 Fault	[E-00B2 50:5 00B210A]
  PMFXS8-62 Fault	[E-00B2 50:6 00B210B]
  PMFXS8-63 Fault	[E-00B2 50:7 00B210C]
  MLP2 Opt Correct1 On	[E-00B2 51:0 00B2160]
  MLP2 Opt Correct1 Off	[E-00B2 51:1 00B2161]
  MLP2 Opt Correct2 On	[E-00B2 51:2 00B2162]
  MLP2 Opt Correct2 Off	[E-00B2 51:3 00B2163]
  MLP2 Opt Correct3 On	[E-00B2 51:4 00B2164]
  MLP2 Opt Correct3 Off	[E-00B2 51:5 00B2165]
  MLP2 Opt Correct4 On	[E-00B2 51:6 00B2166]
  MLP2 Opt Correct4 Off	[E-00B2 51:7 00B2167]
  MLP2 Opt Correct5 On	[E-00B2 52:0 00B2168]
  MLP2 Opt Correct5 Off	[E-00B2 52:1 00B2169]
  MLP2 Opt Correct6 On	[E-00B2 52:2 00B216A]
  MLP2 Opt Correct6 Off	[E-00B2 52:3 00B216B]
  MLP2 Opt Correct7 On	[E-00B2 52:4 00B216C]
  MLP2 Opt Correct7 Off	[E-00B2 52:5 00B216D]
  MLP2 Opt Correct8 On	[E-00B2 52:6 00B216E]
  MLP2 Opt Correct8 Off	[E-00B2 52:7 00B216F]
  MLP2 Opt Correct9 On	[E-00B2 53:0 00B2170]
  MLP2 Opt Correct9 Off	[E-00B2 53:1 00B2171]
  MLP2 Opt Correct10 On	[E-00B2 53:2 00B2172]
  MLP2 Opt Correct10 Off	[E-00B2 53:3 00B2173]
  MLP2 Opt Correct11 On	[E-00B2 53:4 00B2174]
  MLP2 Opt Correct11 Off	[E-00B2 53:5 00B2175]
  MLP2 Opt Correct12 On	[E-00B2 53:6 00B2176]
  MLP2 Opt Correct12 Off	[E-00B2 53:7 00B2177]
  MLP2 Opt Correct13 On	[E-00B2 54:0 00B2178]
  MLP2 Opt Correct13 Off	[E-00B2 54:1 00B2179]
  MLP2 Opt Correct14 On	[E-00B2 54:2 00B217A]
  MLP2 Opt Correct14 Off	[E-00B2 54:3 00B217B]
  MLP2 Opt Correct15 On	[E-00B2 54:4 00B217C]
  MLP2 Opt Correct15 Off	[E-00B2 54:5 00B217D]
  MLP2 Opt Correct16 On	[E-00B2 54:6 00B217E]
  MLP2 Opt Correct16 Off	[E-00B2 54:7 00B217F]
  MLP2 Opt Correct17 On	[E-00B2 55:0 00B2180]
  MLP2 Opt Correct17 Off	[E-00B2 55:1 00B2181]
  MLP2 Opt Correct18 On	[E-00B2 55:2 00B2182]
  MLP2 Opt Correct18 Off	[E-00B2 55:3 00B2183]
  MLP2 Opt Correct19 On	[E-00B2 55:4 00B2184]
  MLP2 Opt Correct19 Off	[E-00B2 55:5 00B2185]
  MLP2 Opt Correct20 On	[E-00B2 55:6 00B2186]
  MLP2 Opt Correct20 Off	[E-00B2 55:7 00B2187]
  SH Test Count	[E-00B2 56 00B291F BINARY2_1]
  Actuator1-1 DLL/Test	[E-00B2 58:0 00B2200]
  Actuator1-2 DLL/Test	[E-00B2 58:1 00B2201]
  Actuator1-3 DLL/Test	[E-00B2 58:2 00B2202]
  Actuator1-4 DLL/Test	[E-00B2 58:3 00B2203]
  Actuator1-5 DLL/Test	[E-00B2 58:4 00B2204]
  Actuator1-6 DLL/Test	[E-00B2 58:5 00B2205]
  Actuator1-7 DLL/Test	[E-00B2 58:6 00B2206]
  Actuator1-8 DLL/Test	[E-00B2 58:7 00B2207]
  Actuator1-9 DLL/Test	[E-00B2 59:0 00B2208]
  Actuator1-10 DLL/Test	[E-00B2 59:1 00B2209]
  Actuator1-11 DLL/Test	[E-00B2 59:2 00B220A]
  Actuator1-12 DLL/Test	[E-00B2 59:3 00B220B]
  Actuator2-1 DLL/Test	[E-00B2 59:4 00B220C]
  Actuator2-2 DLL/Test	[E-00B2 59:5 00B220D]
  Actuator2-3 DLL/Test	[E-00B2 59:6 00B220E]
  Actuator2-4 DLL/Test	[E-00B2 59:7 00B220F]
  Actuator2-5 DLL/Test	[E-00B2 60:0 00B2210]
  Actuator2-6 DLL/Test	[E-00B2 60:1 00B2211]
  Actuator2-7 DLL/Test	[E-00B2 60:2 00B2212]
  Actuator2-8 DLL/Test	[E-00B2 60:3 00B2213]
  Actuator2-9 DLL/Test	[E-00B2 60:4 00B2214]
  Actuator2-10 DLL/Test	[E-00B2 60:5 00B2215]
  Actuator2-11 DLL/Test	[E-00B2 60:6 00B2216]
  Actuator2-12 DLL/Test	[E-00B2 60:7 00B2217]
  Actuator2-13 DLL/Test	[E-00B2 61:0 00B2218]
  Actuator2-14 DLL/Test	[E-00B2 61:1 00B2219]
  Actuator2-15 DLL/Test	[E-00B2 61:2 00B221A]
  Actuator2-16 DLL/Test	[E-00B2 61:3 00B221B]
  Actuator2-17 DLL/Test	[E-00B2 61:4 00B221C]
  Actuator2-18 DLL/Test	[E-00B2 61:5 00B221D]
  Actuator3-1 DLL/Test	[E-00B2 61:6 00B221E]
  Actuator3-2 DLL/Test	[E-00B2 61:7 00B221F]
  Actuator3-3 DLL/Test	[E-00B2 62:0 00B2220]
  Actuator3-4 DLL/Test	[E-00B2 62:1 00B2221]
  Actuator3-5 DLL/Test	[E-00B2 62:2 00B2222]
  Actuator3-6 DLL/Test	[E-00B2 62:3 00B2223]
  Actuator3-7 DLL/Test	[E-00B2 62:4 00B2224]
  Actuator3-8 DLL/Test	[E-00B2 62:5 00B2225]
  Actuator3-9 DLL/Test	[E-00B2 62:6 00B2226]
  Actuator3-10 DLL/Test	[E-00B2 62:7 00B2227]
  Actuator3-11 DLL/Test	[E-00B2 63:0 00B2228]
  Actuator3-12 DLL/Test	[E-00B2 63:1 00B2229]
  Actuator3-13 DLL/Test	[E-00B2 63:2 00B222A]
  Actuator3-14 DLL/Test	[E-00B2 63:3 00B222B]
  Actuator3-15 DLL/Test	[E-00B2 63:4 00B222C]
  Actuator3-16 DLL/Test	[E-00B2 63:5 00B222D]
  Actuator3-17 DLL/Test	[E-00B2 63:6 00B222E]
  Actuator3-18 DLL/Test	[E-00B2 63:7 00B222F]
  Actuator3-19 DLL/Test	[E-00B2 64:0 00B2230]
  Actuator3-20 DLL/Test	[E-00B2 64:1 00B2231]
  Actuator3-21 DLL/Test	[E-00B2 64:2 00B2232]
  Actuator3-22 DLL/Test	[E-00B2 64:3 00B2233]
  Actuator3-23 DLL/Test	[E-00B2 64:4 00B2234]
  Actuator3-24 DLL/Test	[E-00B2 64:5 00B2235]
  Actuator4-1 DLL/Test	[E-00B2 64:6 00B2236]
  Actuator4-2 DLL/Test	[E-00B2 64:7 00B2237]
  Actuator4-3 DLL/Test	[E-00B2 65:0 00B2238]
  Actuator4-4 DLL/Test	[E-00B2 65:1 00B2239]
  Actuator4-5 DLL/Test	[E-00B2 65:2 00B223A]
  Actuator4-6 DLL/Test	[E-00B2 65:3 00B223B]
  Actuator4-7 DLL/Test	[E-00B2 65:4 00B223C]
  Actuator4-8 DLL/Test	[E-00B2 65:5 00B223D]
  Actuator4-9 DLL/Test	[E-00B2 65:6 00B223E]
  Actuator4-10 DLL/Test	[E-00B2 65:7 00B223F]
  Actuator4-11 DLL/Test	[E-00B2 66:0 00B2240]
  Actuator4-12 DLL/Test	[E-00B2 66:1 00B2241]
  Actuator4-13 DLL/Test	[E-00B2 66:2 00B2242]
  Actuator4-14 DLL/Test	[E-00B2 66:3 00B2243]
  Actuator4-15 DLL/Test	[E-00B2 66:4 00B2244]
  Actuator4-16 DLL/Test	[E-00B2 66:5 00B2245]
  Actuator4-17 DLL/Test	[E-00B2 66:6 00B2246]
  Actuator4-18 DLL/Test	[E-00B2 66:7 00B2247]
  Actuator4-19 DLL/Test	[E-00B2 67:0 00B2248]
  Actuator4-20 DLL/Test	[E-00B2 67:1 00B2249]
  Actuator4-21 DLL/Test	[E-00B2 67:2 00B224A]
  Actuator4-22 DLL/Test	[E-00B2 67:3 00B224B]
  Actuator4-23 DLL/Test	[E-00B2 67:4 00B224C]
  Actuator4-24 DLL/Test	[E-00B2 67:5 00B224D]
  Actuator4-25 DLL/Test	[E-00B2 67:6 00B224E]
  Actuator4-26 DLL/Test	[E-00B2 67:7 00B224F]
  Actuator4-27 DLL/Test	[E-00B2 68:0 00B2250]
  Actuator4-28 DLL/Test	[E-00B2 68:1 00B2251]
  Actuator4-29 DLL/Test	[E-00B2 68:2 00B2252]
  Actuator4-30 DLL/Test	[E-00B2 68:3 00B2253]
  Actuator5-1 DLL/Test	[E-00B2 68:4 00B2254]
  Actuator5-2 DLL/Test	[E-00B2 68:5 00B2255]
  Actuator5-3 DLL/Test	[E-00B2 68:6 00B2256]
  Actuator5-4 DLL/Test	[E-00B2 68:7 00B2257]
  Actuator5-5 DLL/Test	[E-00B2 69:0 00B2258]
  Actuator5-6 DLL/Test	[E-00B2 69:1 00B2259]
  Actuator5-7 DLL/Test	[E-00B2 69:2 00B225A]
  Actuator5-8 DLL/Test	[E-00B2 69:3 00B225B]
  Actuator5-9 DLL/Test	[E-00B2 69:4 00B225C]
  Actuator5-10 DLL/Test	[E-00B2 69:5 00B225D]
  Actuator5-11 DLL/Test	[E-00B2 69:6 00B225E]
  Actuator5-12 DLL/Test	[E-00B2 69:7 00B225F]
  Actuator5-13 DLL/Test	[E-00B2 70:0 00B2260]
  Actuator5-14 DLL/Test	[E-00B2 70:1 00B2261]
  Actuator5-15 DLL/Test	[E-00B2 70:2 00B2262]
  Actuator5-16 DLL/Test	[E-00B2 70:3 00B2263]
  Actuator5-17 DLL/Test	[E-00B2 70:4 00B2264]
  Actuator5-18 DLL/Test	[E-00B2 70:5 00B2265]
  Actuator5-19 DLL/Test	[E-00B2 70:6 00B2266]
  Actuator5-20 DLL/Test	[E-00B2 70:7 00B2267]
  Actuator5-21 DLL/Test	[E-00B2 71:0 00B2268]
  Actuator5-22 DLL/Test	[E-00B2 71:1 00B2269]
  Actuator5-23 DLL/Test	[E-00B2 71:2 00B226A]
  Actuator5-24 DLL/Test	[E-00B2 71:3 00B226B]
  Actuator5-25 DLL/Test	[E-00B2 71:4 00B226C]
  Actuator5-26 DLL/Test	[E-00B2 71:5 00B226D]
  Actuator5-27 DLL/Test	[E-00B2 71:6 00B226E]
  Actuator5-28 DLL/Test	[E-00B2 71:7 00B226F]
  Actuator5-29 DLL/Test	[E-00B2 72:0 00B2270]
  Actuator5-30 DLL/Test	[E-00B2 72:1 00B2271]
  Actuator5-31 DLL/Test	[E-00B2 72:2 00B2272]
  Actuator5-32 DLL/Test	[E-00B2 72:3 00B2273]
  Actuator5-33 DLL/Test	[E-00B2 72:4 00B2274]
  Actuator5-34 DLL/Test	[E-00B2 72:5 00B2275]
  Actuator5-35 DLL/Test	[E-00B2 72:6 00B2276]
  Actuator5-36 DLL/Test	[E-00B2 72:7 00B2277]
  Actuator6-1 DLL/Test	[E-00B2 73:0 00B2278]
  Actuator6-2 DLL/Test	[E-00B2 73:1 00B2279]
  Actuator6-3 DLL/Test	[E-00B2 73:2 00B227A]
  Actuator6-4 DLL/Test	[E-00B2 73:3 00B227B]
  Actuator6-5 DLL/Test	[E-00B2 73:4 00B227C]
  Actuator6-6 DLL/Test	[E-00B2 73:5 00B227D]
  Actuator6-7 DLL/Test	[E-00B2 73:6 00B227E]
  Actuator6-8 DLL/Test	[E-00B2 73:7 00B227F]
  Actuator6-9 DLL/Test	[E-00B2 74:0 00B2280]
  Actuator6-10 DLL/Test	[E-00B2 74:1 00B2281]
  Actuator6-11 DLL/Test	[E-00B2 74:2 00B2282]
  Actuator6-12 DLL/Test	[E-00B2 74:3 00B2283]
  Actuator6-13 DLL/Test	[E-00B2 74:4 00B2284]
  Actuator6-14 DLL/Test	[E-00B2 74:5 00B2285]
  Actuator6-15 DLL/Test	[E-00B2 74:6 00B2286]
  Actuator6-16 DLL/Test	[E-00B2 74:7 00B2287]
  Actuator6-17 DLL/Test	[E-00B2 75:0 00B2288]
  Actuator6-18 DLL/Test	[E-00B2 75:1 00B2289]
  Actuator6-19 DLL/Test	[E-00B2 75:2 00B228A]
  Actuator6-20 DLL/Test	[E-00B2 75:3 00B228B]
  Actuator6-21 DLL/Test	[E-00B2 75:4 00B228C]
  Actuator6-22 DLL/Test	[E-00B2 75:5 00B228D]
  Actuator6-23 DLL/Test	[E-00B2 75:6 00B228E]
  Actuator6-24 DLL/Test	[E-00B2 75:7 00B228F]
  Actuator6-25 DLL/Test	[E-00B2 76:0 00B2290]
  Actuator6-26 DLL/Test	[E-00B2 76:1 00B2291]
  Actuator6-27 DLL/Test	[E-00B2 76:2 00B2292]
  Actuator6-28 DLL/Test	[E-00B2 76:3 00B2293]
  Actuator6-29 DLL/Test	[E-00B2 76:4 00B2294]
  Actuator6-30 DLL/Test	[E-00B2 76:5 00B2295]
  Actuator6-31 DLL/Test	[E-00B2 76:6 00B2296]
  Actuator6-32 DLL/Test	[E-00B2 76:7 00B2297]
  Actuator6-33 DLL/Test	[E-00B2 77:0 00B2298]
  Actuator6-34 DLL/Test	[E-00B2 77:1 00B2299]
  Actuator6-35 DLL/Test	[E-00B2 77:2 00B229A]
  Actuator6-36 DLL/Test	[E-00B2 77:3 00B229B]
  Actuator6-37 DLL/Test	[E-00B2 77:4 00B229C]
  Actuator6-38 DLL/Test	[E-00B2 77:5 00B229D]
  Actuator6-39 DLL/Test	[E-00B2 77:6 00B229E]
  Actuator6-40 DLL/Test	[E-00B2 77:7 00B229F]
  Actuator6-41 DLL/Test	[E-00B2 78:0 00B22A0]
  Actuator6-42 DLL/Test	[E-00B2 78:1 00B22A1]
  Actuator7-1 DLL/Test	[E-00B2 78:2 00B22A2]
  Actuator7-2 DLL/Test	[E-00B2 78:3 00B22A3]
  Actuator7-3 DLL/Test	[E-00B2 78:4 00B22A4]
  Actuator7-4 DLL/Test	[E-00B2 78:5 00B22A5]
  Actuator7-5 DLL/Test	[E-00B2 78:6 00B22A6]
  Actuator7-6 DLL/Test	[E-00B2 78:7 00B22A7]
  Actuator7-7 DLL/Test	[E-00B2 79:0 00B22A8]
  Actuator7-8 DLL/Test	[E-00B2 79:1 00B22A9]
  Actuator7-9 DLL/Test	[E-00B2 79:2 00B22AA]
  Actuator7-10 DLL/Test	[E-00B2 79:3 00B22AB]
  Actuator7-11 DLL/Test	[E-00B2 79:4 00B22AC]
  Actuator7-12 DLL/Test	[E-00B2 79:5 00B22AD]
  Actuator7-13 DLL/Test	[E-00B2 79:6 00B22AE]
  Actuator7-14 DLL/Test	[E-00B2 79:7 00B22AF]
  Actuator7-15 DLL/Test	[E-00B2 80:0 00B22B0]
  Actuator7-16 DLL/Test	[E-00B2 80:1 00B22B1]
  Actuator7-17 DLL/Test	[E-00B2 80:2 00B22B2]
  Actuator7-18 DLL/Test	[E-00B2 80:3 00B22B3]
  Actuator7-19 DLL/Test	[E-00B2 80:4 00B22B4]
  Actuator7-20 DLL/Test	[E-00B2 80:5 00B22B5]
  Actuator7-21 DLL/Test	[E-00B2 80:6 00B22B6]
  Actuator7-22 DLL/Test	[E-00B2 80:7 00B22B7]
  Actuator7-23 DLL/Test	[E-00B2 81:0 00B22B8]
  Actuator7-24 DLL/Test	[E-00B2 81:1 00B22B9]
  Actuator7-25 DLL/Test	[E-00B2 81:2 00B22BA]
  Actuator7-26 DLL/Test	[E-00B2 81:3 00B22BB]
  Actuator7-27 DLL/Test	[E-00B2 81:4 00B22BC]
  Actuator7-28 DLL/Test	[E-00B2 81:5 00B22BD]
  Actuator7-29 DLL/Test	[E-00B2 81:6 00B22BE]
  Actuator7-30 DLL/Test	[E-00B2 81:7 00B22BF]
  Actuator7-31 DLL/Test	[E-00B2 82:0 00B22C0]
  Actuator7-32 DLL/Test	[E-00B2 82:1 00B22C1]
  Actuator7-33 DLL/Test	[E-00B2 82:2 00B22C2]
  Actuator7-34 DLL/Test	[E-00B2 82:3 00B22C3]
  Actuator7-35 DLL/Test	[E-00B2 82:4 00B22C4]
  Actuator7-36 DLL/Test	[E-00B2 82:5 00B22C5]
  Actuator7-37 DLL/Test	[E-00B2 82:6 00B22C6]
  Actuator7-38 DLL/Test	[E-00B2 82:7 00B22C7]
  Actuator7-39 DLL/Test	[E-00B2 83:0 00B22C8]
  Actuator7-40 DLL/Test	[E-00B2 83:1 00B22C9]
  Actuator7-41 DLL/Test	[E-00B2 83:2 00B22CA]
  Actuator7-42 DLL/Test	[E-00B2 83:3 00B22CB]
  Actuator7-43 DLL/Test	[E-00B2 83:4 00B22CC]
  Actuator7-44 DLL/Test	[E-00B2 83:5 00B22CD]
  Actuator7-45 DLL/Test	[E-00B2 83:6 00B22CE]
  Actuator7-46 DLL/Test	[E-00B2 83:7 00B22CF]
  Actuator7-47 DLL/Test	[E-00B2 84:0 00B22D0]
  Actuator7-48 DLL/Test	[E-00B2 84:1 00B22D1]
  Actuator8-1 DLL/Test	[E-00B2 84:2 00B22D2]
  Actuator8-2 DLL/Test	[E-00B2 84:3 00B22D3]
  Actuator8-3 DLL/Test	[E-00B2 84:4 00B22D4]
  Actuator8-4 DLL/Test	[E-00B2 84:5 00B22D5]
  Actuator8-5 DLL/Test	[E-00B2 84:6 00B22D6]
  Actuator8-6 DLL/Test	[E-00B2 84:7 00B22D7]
  Actuator8-7 DLL/Test	[E-00B2 85:0 00B22D8]
  Actuator8-8 DLL/Test	[E-00B2 85:1 00B22D9]
  Actuator8-9 DLL/Test	[E-00B2 85:2 00B22DA]
  Actuator8-10 DLL/Test	[E-00B2 85:3 00B22DB]
  Actuator8-11 DLL/Test	[E-00B2 85:4 00B22DC]
  Actuator8-12 DLL/Test	[E-00B2 85:5 00B22DD]
  Actuator8-13 DLL/Test	[E-00B2 85:6 00B22DE]
  Actuator8-14 DLL/Test	[E-00B2 85:7 00B22DF]
  Actuator8-15 DLL/Test	[E-00B2 86:0 00B22E0]
  Actuator8-16 DLL/Test	[E-00B2 86:1 00B22E1]
  Actuator8-17 DLL/Test	[E-00B2 86:2 00B22E2]
  Actuator8-18 DLL/Test	[E-00B2 86:3 00B22E3]
  Actuator8-19 DLL/Test	[E-00B2 86:4 00B22E4]
  Actuator8-20 DLL/Test	[E-00B2 86:5 00B22E5]
  Actuator8-21 DLL/Test	[E-00B2 86:6 00B22E6]
  Actuator8-22 DLL/Test	[E-00B2 86:7 00B22E7]
  Actuator8-23 DLL/Test	[E-00B2 87:0 00B22E8]
  Actuator8-24 DLL/Test	[E-00B2 87:1 00B22E9]
  Actuator8-25 DLL/Test	[E-00B2 87:2 00B22EA]
  Actuator8-26 DLL/Test	[E-00B2 87:3 00B22EB]
  Actuator8-27 DLL/Test	[E-00B2 87:4 00B22EC]
  Actuator8-28 DLL/Test	[E-00B2 87:5 00B22ED]
  Actuator8-29 DLL/Test	[E-00B2 87:6 00B22EE]
  Actuator8-30 DLL/Test	[E-00B2 87:7 00B22EF]
  Actuator8-31 DLL/Test	[E-00B2 88:0 00B22F0]
  Actuator8-32 DLL/Test	[E-00B2 88:1 00B22F1]
  Actuator8-33 DLL/Test	[E-00B2 88:2 00B22F2]
  Actuator8-34 DLL/Test	[E-00B2 88:3 00B22F3]
  Actuator8-35 DLL/Test	[E-00B2 88:4 00B22F4]
  Actuator8-36 DLL/Test	[E-00B2 88:5 00B22F5]
  Actuator8-37 DLL/Test	[E-00B2 88:6 00B22F6]
  Actuator8-38 DLL/Test	[E-00B2 88:7 00B22F7]
  Actuator8-39 DLL/Test	[E-00B2 89:0 00B22F8]
  Actuator8-40 DLL/Test	[E-00B2 89:1 00B22F9]
  Actuator8-41 DLL/Test	[E-00B2 89:2 00B22FA]
  Actuator8-42 DLL/Test	[E-00B2 89:3 00B22FB]
  Actuator8-43 DLL/Test	[E-00B2 89:4 00B22FC]
  Actuator8-44 DLL/Test	[E-00B2 89:5 00B22FD]
  Actuator8-45 DLL/Test	[E-00B2 89:6 00B22FE]
  Actuator8-46 DLL/Test	[E-00B2 89:7 00B22FF]
  Actuator8-47 DLL/Test	[E-00B2 90:0 00B2300]
  Actuator8-48 DLL/Test	[E-00B2 90:1 00B2301]
  Actuator8-49 DLL/Test	[E-00B2 90:2 00B2302]
  Actuator8-50 DLL/Test	[E-00B2 90:3 00B2303]
  Actuator8-51 DLL/Test	[E-00B2 90:4 00B2304]
  PMFXS8-61 DLL/Test	[E-00B2 90:5 00B2305]
  PMFXS8-62 DLL/Test	[E-00B2 90:6 00B2306]
  PMFXS8-63 DLL/Test	[E-00B2 90:7 00B2307]
  PMFXS8-58 Fault	[E-00B2 91:0 00B213A]
  PMFXS8-59 Fault	[E-00B2 91:1 00B213B]
  PMFXS8-60 Fault	[E-00B2 91:2 00B213C]
  PMFXS8-58 DLL/Test	[E-00B2 91:3 00B2309]
  PMFXS8-59 DLL/Test	[E-00B2 91:4 00B230A]
  PMFXS8-60 DLL/Test	[E-00B2 91:5 00B230B]
  Actuator1-1 CMD COMP ALM(Monitor)	[E-00B2 98:0 00B2400]
  Actuator1-2 CMD COMP ALM(Monitor)	[E-00B2 98:1 00B2401]
  Actuator1-3 CMD COMP ALM(Monitor)	[E-00B2 98:2 00B2402]
  Actuator1-4 CMD COMP ALM(Monitor)	[E-00B2 98:3 00B2403]
  Actuator1-5 CMD COMP ALM(Monitor)	[E-00B2 98:4 00B2404]
  Actuator1-6 CMD COMP ALM(Monitor)	[E-00B2 98:5 00B2405]
  Actuator1-7 CMD COMP ALM(Monitor)	[E-00B2 98:6 00B2406]
  Actuator1-8 CMD COMP ALM(Monitor)	[E-00B2 98:7 00B2407]
  Actuator1-9 CMD COMP ALM(Monitor)	[E-00B2 99:0 00B2408]
  Actuator1-10 CMD COMP ALM(Monitor)	[E-00B2 99:1 00B2409]
  Actuator1-11 CMD COMP ALM(Monitor)	[E-00B2 99:2 00B240A]
  Actuator1-12 CMD COMP ALM(Monitor)	[E-00B2 99:3 00B240B]
  Actuator2-1 CMD COMP ALM(Monitor)	[E-00B2 99:4 00B240C]
  Actuator2-2 CMD COMP ALM(Monitor)	[E-00B2 99:5 00B240D]
  Actuator2-3 CMD COMP ALM(Monitor)	[E-00B2 99:6 00B240E]
  Actuator2-4 CMD COMP ALM(Monitor)	[E-00B2 99:7 00B240F]
  Actuator2-5 CMD COMP ALM(Monitor)	[E-00B2 100:0 00B2410]
  Actuator2-6 CMD COMP ALM(Monitor)	[E-00B2 100:1 00B2411]
  Actuator2-7 CMD COMP ALM(Monitor)	[E-00B2 100:2 00B2412]
  Actuator2-8 CMD COMP ALM(Monitor)	[E-00B2 100:3 00B2413]
  Actuator2-9 CMD COMP ALM(Monitor)	[E-00B2 100:4 00B2414]
  Actuator2-10 CMD COMP ALM(Monitor)	[E-00B2 100:5 00B2415]
  Actuator2-11 CMD COMP ALM(Monitor)	[E-00B2 100:6 00B2416]
  Actuator2-12 CMD COMP ALM(Monitor)	[E-00B2 100:7 00B2417]
  Actuator2-13 CMD COMP ALM(Monitor)	[E-00B2 101:0 00B2418]
  Actuator2-14 CMD COMP ALM(Monitor)	[E-00B2 101:1 00B2419]
  Actuator2-15 CMD COMP ALM(Monitor)	[E-00B2 101:2 00B241A]
  Actuator2-16 CMD COMP ALM(Monitor)	[E-00B2 101:3 00B241B]
  Actuator2-17 CMD COMP ALM(Monitor)	[E-00B2 101:4 00B241C]
  Actuator2-18 CMD COMP ALM(Monitor)	[E-00B2 101:5 00B241D]
  Actuator3-1 CMD COMP ALM(Monitor)	[E-00B2 101:6 00B241E]
  Actuator3-2 CMD COMP ALM(Monitor)	[E-00B2 101:7 00B241F]
  Actuator3-3 CMD COMP ALM(Monitor)	[E-00B2 102:0 00B2420]
  Actuator3-4 CMD COMP ALM(Monitor)	[E-00B2 102:1 00B2421]
  Actuator3-5 CMD COMP ALM(Monitor)	[E-00B2 102:2 00B2422]
  Actuator3-6 CMD COMP ALM(Monitor)	[E-00B2 102:3 00B2423]
  Actuator3-7 CMD COMP ALM(Monitor)	[E-00B2 102:4 00B2424]
  Actuator3-8 CMD COMP ALM(Monitor)	[E-00B2 102:5 00B2425]
  Actuator3-9 CMD COMP ALM(Monitor)	[E-00B2 102:6 00B2426]
  Actuator3-10 CMD COMP ALM(Monitor)	[E-00B2 102:7 00B2427]
  Actuator3-11 CMD COMP ALM(Monitor)	[E-00B2 103:0 00B2428]
  Actuator3-12 CMD COMP ALM(Monitor)	[E-00B2 103:1 00B2429]
  Actuator3-13 CMD COMP ALM(Monitor)	[E-00B2 103:2 00B242A]
  Actuator3-14 CMD COMP ALM(Monitor)	[E-00B2 103:3 00B242B]
  Actuator3-15 CMD COMP ALM(Monitor)	[E-00B2 103:4 00B242C]
  Actuator3-16 CMD COMP ALM(Monitor)	[E-00B2 103:5 00B242D]
  Actuator3-17 CMD COMP ALM(Monitor)	[E-00B2 103:6 00B242E]
  Actuator3-18 CMD COMP ALM(Monitor)	[E-00B2 103:7 00B242F]
  Actuator3-19 CMD COMP ALM(Monitor)	[E-00B2 104:0 00B2430]
  Actuator3-20 CMD COMP ALM(Monitor)	[E-00B2 104:1 00B2431]
  Actuator3-21 CMD COMP ALM(Monitor)	[E-00B2 104:2 00B2432]
  Actuator3-22 CMD COMP ALM(Monitor)	[E-00B2 104:3 00B2433]
  Actuator3-23 CMD COMP ALM(Monitor)	[E-00B2 104:4 00B2434]
  Actuator3-24 CMD COMP ALM(Monitor)	[E-00B2 104:5 00B2435]
  Actuator4-1 CMD COMP ALM(Monitor)	[E-00B2 104:6 00B2436]
  Actuator4-2 CMD COMP ALM(Monitor)	[E-00B2 104:7 00B2437]
  Actuator4-3 CMD COMP ALM(Monitor)	[E-00B2 105:0 00B2438]
  Actuator4-4 CMD COMP ALM(Monitor)	[E-00B2 105:1 00B2439]
  Actuator4-5 CMD COMP ALM(Monitor)	[E-00B2 105:2 00B243A]
  Actuator4-6 CMD COMP ALM(Monitor)	[E-00B2 105:3 00B243B]
  Actuator4-7 CMD COMP ALM(Monitor)	[E-00B2 105:4 00B243C]
  Actuator4-8 CMD COMP ALM(Monitor)	[E-00B2 105:5 00B243D]
  Actuator4-9 CMD COMP ALM(Monitor)	[E-00B2 105:6 00B243E]
  Actuator4-10 CMD COMP ALM(Monitor)	[E-00B2 105:7 00B243F]
  Actuator4-11 CMD COMP ALM(Monitor)	[E-00B2 106:0 00B2440]
  Actuator4-12 CMD COMP ALM(Monitor)	[E-00B2 106:1 00B2441]
  Actuator4-13 CMD COMP ALM(Monitor)	[E-00B2 106:2 00B2442]
  Actuator4-14 CMD COMP ALM(Monitor)	[E-00B2 106:3 00B2443]
  Actuator4-15 CMD COMP ALM(Monitor)	[E-00B2 106:4 00B2444]
  Actuator4-16 CMD COMP ALM(Monitor)	[E-00B2 106:5 00B2445]
  Actuator4-17 CMD COMP ALM(Monitor)	[E-00B2 106:6 00B2446]
  Actuator4-18 CMD COMP ALM(Monitor)	[E-00B2 106:7 00B2447]
  Actuator4-19 CMD COMP ALM(Monitor)	[E-00B2 107:0 00B2448]
  Actuator4-20 CMD COMP ALM(Monitor)	[E-00B2 107:1 00B2449]
  Actuator4-21 CMD COMP ALM(Monitor)	[E-00B2 107:2 00B244A]
  Actuator4-22 CMD COMP ALM(Monitor)	[E-00B2 107:3 00B244B]
  Actuator4-23 CMD COMP ALM(Monitor)	[E-00B2 107:4 00B244C]
  Actuator4-24 CMD COMP ALM(Monitor)	[E-00B2 107:5 00B244D]
  Actuator4-25 CMD COMP ALM(Monitor)	[E-00B2 107:6 00B244E]
  Actuator4-26 CMD COMP ALM(Monitor)	[E-00B2 107:7 00B244F]
  Actuator4-27 CMD COMP ALM(Monitor)	[E-00B2 108:0 00B2450]
  Actuator4-28 CMD COMP ALM(Monitor)	[E-00B2 108:1 00B2451]
  Actuator4-29 CMD COMP ALM(Monitor)	[E-00B2 108:2 00B2452]
  Actuator4-30 CMD COMP ALM(Monitor)	[E-00B2 108:3 00B2453]
  Actuator5-1 CMD COMP ALM(Monitor)	[E-00B2 108:4 00B2454]
  Actuator5-2 CMD COMP ALM(Monitor)	[E-00B2 108:5 00B2455]
  Actuator5-3 CMD COMP ALM(Monitor)	[E-00B2 108:6 00B2456]
  Actuator5-4 CMD COMP ALM(Monitor)	[E-00B2 108:7 00B2457]
  Actuator5-5 CMD COMP ALM(Monitor)	[E-00B2 109:0 00B2458]
  Actuator5-6 CMD COMP ALM(Monitor)	[E-00B2 109:1 00B2459]
  Actuator5-7 CMD COMP ALM(Monitor)	[E-00B2 109:2 00B245A]
  Actuator5-8 CMD COMP ALM(Monitor)	[E-00B2 109:3 00B245B]
  Actuator5-9 CMD COMP ALM(Monitor)	[E-00B2 109:4 00B245C]
  Actuator5-10 CMD COMP ALM(Monitor)	[E-00B2 109:5 00B245D]
  Actuator5-11 CMD COMP ALM(Monitor)	[E-00B2 109:6 00B245E]
  Actuator5-12 CMD COMP ALM(Monitor)	[E-00B2 109:7 00B245F]
  Actuator5-13 CMD COMP ALM(Monitor)	[E-00B2 110:0 00B2460]
  Actuator5-14 CMD COMP ALM(Monitor)	[E-00B2 110:1 00B2461]
  Actuator5-15 CMD COMP ALM(Monitor)	[E-00B2 110:2 00B2462]
  Actuator5-16 CMD COMP ALM(Monitor)	[E-00B2 110:3 00B2463]
  Actuator5-17 CMD COMP ALM(Monitor)	[E-00B2 110:4 00B2464]
  Actuator5-18 CMD COMP ALM(Monitor)	[E-00B2 110:5 00B2465]
  Actuator5-19 CMD COMP ALM(Monitor)	[E-00B2 110:6 00B2466]
  Actuator5-20 CMD COMP ALM(Monitor)	[E-00B2 110:7 00B2467]
  Actuator5-21 CMD COMP ALM(Monitor)	[E-00B2 111:0 00B2468]
  Actuator5-22 CMD COMP ALM(Monitor)	[E-00B2 111:1 00B2469]
  Actuator5-23 CMD COMP ALM(Monitor)	[E-00B2 111:2 00B246A]
  Actuator5-24 CMD COMP ALM(Monitor)	[E-00B2 111:3 00B246B]
  Actuator5-25 CMD COMP ALM(Monitor)	[E-00B2 111:4 00B246C]
  Actuator5-26 CMD COMP ALM(Monitor)	[E-00B2 111:5 00B246D]
  Actuator5-27 CMD COMP ALM(Monitor)	[E-00B2 111:6 00B246E]
  Actuator5-28 CMD COMP ALM(Monitor)	[E-00B2 111:7 00B246F]
  Actuator5-29 CMD COMP ALM(Monitor)	[E-00B2 112:0 00B2470]
  Actuator5-30 CMD COMP ALM(Monitor)	[E-00B2 112:1 00B2471]
  Actuator5-31 CMD COMP ALM(Monitor)	[E-00B2 112:2 00B2472]
  Actuator5-32 CMD COMP ALM(Monitor)	[E-00B2 112:3 00B2473]
  Actuator5-33 CMD COMP ALM(Monitor)	[E-00B2 112:4 00B2474]
  Actuator5-34 CMD COMP ALM(Monitor)	[E-00B2 112:5 00B2475]
  Actuator5-35 CMD COMP ALM(Monitor)	[E-00B2 112:6 00B2476]
  Actuator5-36 CMD COMP ALM(Monitor)	[E-00B2 112:7 00B2477]
  Actuator6-1 CMD COMP ALM(Monitor)	[E-00B2 113:0 00B2478]
  Actuator6-2 CMD COMP ALM(Monitor)	[E-00B2 113:1 00B2479]
  Actuator6-3 CMD COMP ALM(Monitor)	[E-00B2 113:2 00B247A]
  Actuator6-4 CMD COMP ALM(Monitor)	[E-00B2 113:3 00B247B]
  Actuator6-5 CMD COMP ALM(Monitor)	[E-00B2 113:4 00B247C]
  Actuator6-6 CMD COMP ALM(Monitor)	[E-00B2 113:5 00B247D]
  Actuator6-7 CMD COMP ALM(Monitor)	[E-00B2 113:6 00B247E]
  Actuator6-8 CMD COMP ALM(Monitor)	[E-00B2 113:7 00B247F]
  Actuator6-9 CMD COMP ALM(Monitor)	[E-00B2 114:0 00B2480]
  Actuator6-10 CMD COMP ALM(Monitor)	[E-00B2 114:1 00B2481]
  Actuator6-11 CMD COMP ALM(Monitor)	[E-00B2 114:2 00B2482]
  Actuator6-12 CMD COMP ALM(Monitor)	[E-00B2 114:3 00B2483]
  Actuator6-13 CMD COMP ALM(Monitor)	[E-00B2 114:4 00B2484]
  Actuator6-14 CMD COMP ALM(Monitor)	[E-00B2 114:5 00B2485]
  Actuator6-15 CMD COMP ALM(Monitor)	[E-00B2 114:6 00B2486]
  Actuator6-16 CMD COMP ALM(Monitor)	[E-00B2 114:7 00B2487]
  Actuator6-17 CMD COMP ALM(Monitor)	[E-00B2 115:0 00B2488]
  Actuator6-18 CMD COMP ALM(Monitor)	[E-00B2 115:1 00B2489]
  Actuator6-19 CMD COMP ALM(Monitor)	[E-00B2 115:2 00B248A]
  Actuator6-20 CMD COMP ALM(Monitor)	[E-00B2 115:3 00B248B]
  Actuator6-21 CMD COMP ALM(Monitor)	[E-00B2 115:4 00B248C]
  Actuator6-22 CMD COMP ALM(Monitor)	[E-00B2 115:5 00B248D]
  Actuator6-23 CMD COMP ALM(Monitor)	[E-00B2 115:6 00B248E]
  Actuator6-24 CMD COMP ALM(Monitor)	[E-00B2 115:7 00B248F]
  Actuator6-25 CMD COMP ALM(Monitor)	[E-00B2 116:0 00B2490]
  Actuator6-26 CMD COMP ALM(Monitor)	[E-00B2 116:1 00B2491]
  Actuator6-27 CMD COMP ALM(Monitor)	[E-00B2 116:2 00B2492]
  Actuator6-28 CMD COMP ALM(Monitor)	[E-00B2 116:3 00B2493]
  Actuator6-29 CMD COMP ALM(Monitor)	[E-00B2 116:4 00B2494]
  Actuator6-30 CMD COMP ALM(Monitor)	[E-00B2 116:5 00B2495]
  Actuator6-31 CMD COMP ALM(Monitor)	[E-00B2 116:6 00B2496]
  Actuator6-32 CMD COMP ALM(Monitor)	[E-00B2 116:7 00B2497]
  Actuator6-33 CMD COMP ALM(Monitor)	[E-00B2 117:0 00B2498]
  Actuator6-34 CMD COMP ALM(Monitor)	[E-00B2 117:1 00B2499]
  Actuator6-35 CMD COMP ALM(Monitor)	[E-00B2 117:2 00B249A]
  Actuator6-36 CMD COMP ALM(Monitor)	[E-00B2 117:3 00B249B]
  Actuator6-37 CMD COMP ALM(Monitor)	[E-00B2 117:4 00B249C]
  Actuator6-38 CMD COMP ALM(Monitor)	[E-00B2 117:5 00B249D]
  Actuator6-39 CMD COMP ALM(Monitor)	[E-00B2 117:6 00B249E]
  Actuator6-40 CMD COMP ALM(Monitor)	[E-00B2 117:7 00B249F]
  Actuator6-41 CMD COMP ALM(Monitor)	[E-00B2 118:0 00B24A0]
  Actuator6-42 CMD COMP ALM(Monitor)	[E-00B2 118:1 00B24A1]
  Actuator7-1 CMD COMP ALM(Monitor)	[E-00B2 118:2 00B24A2]
  Actuator7-2 CMD COMP ALM(Monitor)	[E-00B2 118:3 00B24A3]
  Actuator7-3 CMD COMP ALM(Monitor)	[E-00B2 118:4 00B24A4]
  Actuator7-4 CMD COMP ALM(Monitor)	[E-00B2 118:5 00B24A5]
  Actuator7-5 CMD COMP ALM(Monitor)	[E-00B2 118:6 00B24A6]
  Actuator7-6 CMD COMP ALM(Monitor)	[E-00B2 118:7 00B24A7]
  Actuator7-7 CMD COMP ALM(Monitor)	[E-00B2 119:0 00B24A8]
  Actuator7-8 CMD COMP ALM(Monitor)	[E-00B2 119:1 00B24A9]
  Actuator7-9 CMD COMP ALM(Monitor)	[E-00B2 119:2 00B24AA]
  Actuator7-10 CMD COMP ALM(Monitor)	[E-00B2 119:3 00B24AB]
  Actuator7-11 CMD COMP ALM(Monitor)	[E-00B2 119:4 00B24AC]
  Actuator7-12 CMD COMP ALM(Monitor)	[E-00B2 119:5 00B24AD]
  Actuator7-13 CMD COMP ALM(Monitor)	[E-00B2 119:6 00B24AE]
  Actuator7-14 CMD COMP ALM(Monitor)	[E-00B2 119:7 00B24AF]
  Actuator7-15 CMD COMP ALM(Monitor)	[E-00B2 120:0 00B24B0]
  Actuator7-16 CMD COMP ALM(Monitor)	[E-00B2 120:1 00B24B1]
  Actuator7-17 CMD COMP ALM(Monitor)	[E-00B2 120:2 00B24B2]
  Actuator7-18 CMD COMP ALM(Monitor)	[E-00B2 120:3 00B24B3]
  Actuator7-19 CMD COMP ALM(Monitor)	[E-00B2 120:4 00B24B4]
  Actuator7-20 CMD COMP ALM(Monitor)	[E-00B2 120:5 00B24B5]
  Actuator7-21 CMD COMP ALM(Monitor)	[E-00B2 120:6 00B24B6]
  Actuator7-22 CMD COMP ALM(Monitor)	[E-00B2 120:7 00B24B7]
  Actuator7-23 CMD COMP ALM(Monitor)	[E-00B2 121:0 00B24B8]
  Actuator7-24 CMD COMP ALM(Monitor)	[E-00B2 121:1 00B24B9]
  Actuator7-25 CMD COMP ALM(Monitor)	[E-00B2 121:2 00B24BA]
  Actuator7-26 CMD COMP ALM(Monitor)	[E-00B2 121:3 00B24BB]
  Actuator7-27 CMD COMP ALM(Monitor)	[E-00B2 121:4 00B24BC]
  Actuator7-28 CMD COMP ALM(Monitor)	[E-00B2 121:5 00B24BD]
  Actuator7-29 CMD COMP ALM(Monitor)	[E-00B2 121:6 00B24BE]
  Actuator7-30 CMD COMP ALM(Monitor)	[E-00B2 121:7 00B24BF]
  Actuator7-31 CMD COMP ALM(Monitor)	[E-00B2 122:0 00B24C0]
  Actuator7-32 CMD COMP ALM(Monitor)	[E-00B2 122:1 00B24C1]
  Actuator7-33 CMD COMP ALM(Monitor)	[E-00B2 122:2 00B24C2]
  Actuator7-34 CMD COMP ALM(Monitor)	[E-00B2 122:3 00B24C3]
  Actuator7-35 CMD COMP ALM(Monitor)	[E-00B2 122:4 00B24C4]
  Actuator7-36 CMD COMP ALM(Monitor)	[E-00B2 122:5 00B24C5]
  Actuator7-37 CMD COMP ALM(Monitor)	[E-00B2 122:6 00B24C6]
  Actuator7-38 CMD COMP ALM(Monitor)	[E-00B2 122:7 00B24C7]
  Actuator7-39 CMD COMP ALM(Monitor)	[E-00B2 123:0 00B24C8]
  Actuator7-40 CMD COMP ALM(Monitor)	[E-00B2 123:1 00B24C9]
  Actuator7-41 CMD COMP ALM(Monitor)	[E-00B2 123:2 00B24CA]
  Actuator7-42 CMD COMP ALM(Monitor)	[E-00B2 123:3 00B24CB]
  Actuator7-43 CMD COMP ALM(Monitor)	[E-00B2 123:4 00B24CC]
  Actuator7-44 CMD COMP ALM(Monitor)	[E-00B2 123:5 00B24CD]
  Actuator7-45 CMD COMP ALM(Monitor)	[E-00B2 123:6 00B24CE]
  Actuator7-46 CMD COMP ALM(Monitor)	[E-00B2 123:7 00B24CF]
  Actuator7-47 CMD COMP ALM(Monitor)	[E-00B2 124:0 00B24D0]
  Actuator7-48 CMD COMP ALM(Monitor)	[E-00B2 124:1 00B24D1]
  Actuator8-1 CMD COMP ALM(Monitor)	[E-00B2 124:2 00B24D2]
  Actuator8-2 CMD COMP ALM(Monitor)	[E-00B2 124:3 00B24D3]
  Actuator8-3 CMD COMP ALM(Monitor)	[E-00B2 124:4 00B24D4]
  Actuator8-4 CMD COMP ALM(Monitor)	[E-00B2 124:5 00B24D5]
  Actuator8-5 CMD COMP ALM(Monitor)	[E-00B2 124:6 00B24D6]
  Actuator8-6 CMD COMP ALM(Monitor)	[E-00B2 124:7 00B24D7]
  Actuator8-7 CMD COMP ALM(Monitor)	[E-00B2 125:0 00B24D8]
  Actuator8-8 CMD COMP ALM(Monitor)	[E-00B2 125:1 00B24D9]
  Actuator8-9 CMD COMP ALM(Monitor)	[E-00B2 125:2 00B24DA]
  Actuator8-10 CMD COMP ALM(Monitor)	[E-00B2 125:3 00B24DB]
  Actuator8-11 CMD COMP ALM(Monitor)	[E-00B2 125:4 00B24DC]
  Actuator8-12 CMD COMP ALM(Monitor)	[E-00B2 125:5 00B24DD]
  Actuator8-13 CMD COMP ALM(Monitor)	[E-00B2 125:6 00B24DE]
  Actuator8-14 CMD COMP ALM(Monitor)	[E-00B2 125:7 00B24DF]
  Actuator8-15 CMD COMP ALM(Monitor)	[E-00B2 126:0 00B24E0]
  Actuator8-16 CMD COMP ALM(Monitor)	[E-00B2 126:1 00B24E1]
  Actuator8-17 CMD COMP ALM(Monitor)	[E-00B2 126:2 00B24E2]
  Actuator8-18 CMD COMP ALM(Monitor)	[E-00B2 126:3 00B24E3]
  Actuator8-19 CMD COMP ALM(Monitor)	[E-00B2 126:4 00B24E4]
  Actuator8-20 CMD COMP ALM(Monitor)	[E-00B2 126:5 00B24E5]
  Actuator8-21 CMD COMP ALM(Monitor)	[E-00B2 126:6 00B24E6]
  Actuator8-22 CMD COMP ALM(Monitor)	[E-00B2 126:7 00B24E7]
  Actuator8-23 CMD COMP ALM(Monitor)	[E-00B2 127:0 00B24E8]
  Actuator8-24 CMD COMP ALM(Monitor)	[E-00B2 127:1 00B24E9]
  Actuator8-25 CMD COMP ALM(Monitor)	[E-00B2 127:2 00B24EA]
  Actuator8-26 CMD COMP ALM(Monitor)	[E-00B2 127:3 00B24EB]
  Actuator8-27 CMD COMP ALM(Monitor)	[E-00B2 127:4 00B24EC]
  Actuator8-28 CMD COMP ALM(Monitor)	[E-00B2 127:5 00B24ED]
  Actuator8-29 CMD COMP ALM(Monitor)	[E-00B2 127:6 00B24EE]
  Actuator8-30 CMD COMP ALM(Monitor)	[E-00B2 127:7 00B24EF]
  Actuator8-31 CMD COMP ALM(Monitor)	[E-00B2 128:0 00B24F0]
  Actuator8-32 CMD COMP ALM(Monitor)	[E-00B2 128:1 00B24F1]
  Actuator8-33 CMD COMP ALM(Monitor)	[E-00B2 128:2 00B24F2]
  Actuator8-34 CMD COMP ALM(Monitor)	[E-00B2 128:3 00B24F3]
  Actuator8-35 CMD COMP ALM(Monitor)	[E-00B2 128:4 00B24F4]
  Actuator8-36 CMD COMP ALM(Monitor)	[E-00B2 128:5 00B24F5]
  Actuator8-37 CMD COMP ALM(Monitor)	[E-00B2 128:6 00B24F6]
  Actuator8-38 CMD COMP ALM(Monitor)	[E-00B2 128:7 00B24F7]
  Actuator8-39 CMD COMP ALM(Monitor)	[E-00B2 129:0 00B24F8]
  Actuator8-40 CMD COMP ALM(Monitor)	[E-00B2 129:1 00B24F9]
  Actuator8-41 CMD COMP ALM(Monitor)	[E-00B2 129:2 00B24FA]
  Actuator8-42 CMD COMP ALM(Monitor)	[E-00B2 129:3 00B24FB]
  Actuator8-43 CMD COMP ALM(Monitor)	[E-00B2 129:4 00B24FC]
  Actuator8-44 CMD COMP ALM(Monitor)	[E-00B2 129:5 00B24FD]
  Actuator8-45 CMD COMP ALM(Monitor)	[E-00B2 129:6 00B24FE]
  Actuator8-46 CMD COMP ALM(Monitor)	[E-00B2 129:7 00B24FF]
  Actuator8-47 CMD COMP ALM(Monitor)	[E-00B2 130:0 00B2500]
  Actuator8-48 CMD COMP ALM(Monitor)	[E-00B2 130:1 00B2501]
  Actuator8-49 CMD COMP ALM(Monitor)	[E-00B2 130:2 00B2502]
  Actuator8-50 CMD COMP ALM(Monitor)	[E-00B2 130:3 00B2503]
  Actuator8-51 CMD COMP ALM(Monitor)	[E-00B2 130:4 00B2504]
  MLP2 Zernike Count	[E-00B2 131 00B2188 BINARY1_1]
  MLP2 Zernike Time	[E-00B2 138 00B211C TIME4]
  MLP2 Zernike (TSC)	[E-00B2 145:0 00B2189]
  MLP2 Zernike (SH)	[E-00B2 145:1 00B218A]
  MLP2 Zernike Data 00 A00	[E-00B2 146 00B218B REAL8]
  MLP2 Zernike Data 01 A11	[E-00B2 154 00B218B REAL8]
  MLP2 Zernike Data 02 A1m1	[E-00B2 162 00B218B REAL8]
  MLP2 Zernike Data 03 A20	[E-00B2 170 00B218B REAL8]
  MLP2 Zernike Data 04 A31	[E-00B2 178 00B218B REAL8]
  MLP2 Zernike Data 05 A3m1	[E-00B2 186 00B218B REAL8]
  MLP2 Zernike Data 06 A22	[E-00B2 194 00B218B REAL8]
  MLP2 Zernike Data 07 A2m2	[E-00B2 202 00B218B REAL8]
  MLP2 Zernike Data 08 A33	[E-00B2 210 00B218B REAL8]
  MLP2 Zernike Data 09 A3m3	[E-00B2 218 00B218B REAL8]
  MLP2 Zernike Data 10 A40	[E-00B2 226 00B218B REAL8]
  MLP2 Zernike Data 11 A42	[E-00B2 234 00B218B REAL8]
  MLP2 Zernike Data 12 A4m2	[E-00B2 242 00B218B REAL8]
  MLP2 Zernike Data 13 A44	[E-00B2 250 00B218B REAL8]
  MLP2 Zernike Data 14 A4m4	[E-00B2 258 00B218B REAL8]
  MLP2 Zernike Data 15 A51	[E-00B2 266 00B218B REAL8]
  MLP2 Zernike Data 16 A5m1	[E-00B2 274 00B218B REAL8]
  MLP2 Zernike Data 17 A53	[E-00B2 282 00B218B REAL8]
  MLP2 Zernike Data 18 A5m3	[E-00B2 290 00B218B REAL8]
  MLP2 Zernike Data 19 A55	[E-00B2 298 00B218B REAL8]
  MLP2 Zernike Data 20 A5m5	[E-00B2 306 00B218B REAL8]
  MLP2 Zernike Data 21 A60	[E-00B2 314 00B218B REAL8]
  MLP2 Zernike Data 22 A62	[E-00B2 322 00B218B REAL8]
  MLP2 Zernike Data 23 A6m2	[E-00B2 330 00B218B REAL8]
  MLP2 Zernike Data 24 A64	[E-00B2 338 00B218B REAL8]
  MLP2 Zernike Data 25 A6m4	[E-00B2 346 00B218B REAL8]
  MLP2 Zernike Data 26 A66	[E-00B2 354 00B218B REAL8]
  MLP2 Zernike Data 27 A6m6	[E-00B2 362 00B218B REAL8]
  MLP2 Zernike Data 28 A71	[E-00B2 370 00B218B REAL8]
  MLP2 Zernike Data 29 A7m1	[E-00B2 378 00B218B REAL8]
  MLP2 Zernike Data 30 A73	[E-00B2 386 00B218B REAL8]
  MLP2 Zernike Data 31 A7m3	[E-00B2 394 00B218B REAL8]
  MLP2 Zernike Data 32 A75	[E-00B2 402 00B218B REAL8]
  MLP2 Zernike Data 33 A7m5	[E-00B2 410 00B218B REAL8]
  MLP2 Zernike Data 34 A77	[E-00B2 418 00B218B REAL8]
  MLP2 Zernike Data 35 A7m7	[E-00B2 426 00B218B REAL8]
  MLP2 Zernike Data 36 A80	[E-00B2 434 00B218B REAL8]
  MLP2 Zernike Data 37 A82	[E-00B2 442 00B218B REAL8]
  MLP2 Zernike Data 38 A8m2	[E-00B2 450 00B218B REAL8]
  MLP2 Zernike Data 39 A84	[E-00B2 458 00B218B REAL8]
  MLP2 Zernike Data 40 A8m4	[E-00B2 466 00B218B REAL8]
  MLP2 Zernike Data 41 A86	[E-00B2 474 00B218B REAL8]
  MLP2 Zernike Data 42 A8m6	[E-00B2 482 00B218B REAL8]
  MLP2 Zernike Data 43 A88	[E-00B2 490 00B218B REAL8]
  MLP2 Zernike Data 44 A8m8	[E-00B2 498 00B218B REAL8]
  MLP2 Zernike Data 45 A91	[E-00B2 506 00B218B REAL8]
  MLP2 Zernike Data 46 A9m1	[E-00B2 514 00B218B REAL8]
  MLP2 Zernike Data 47 A93	[E-00B2 522 00B218B REAL8]
  MLP2 Zernike Data 48 A9m3	[E-00B2 530 00B218B REAL8]
  MLP2 Zernike Data 49 A95	[E-00B2 538 00B218B REAL8]
  MLP2 Zernike Data 50 A9m5	[E-00B2 546 00B218B REAL8]
  MLP2 Zernike Data 51 A97	[E-00B2 554 00B218B REAL8]
  MLP2 Zernike Data 52 A9m7	[E-00B2 562 00B218B REAL8]
  MLP2 Zernike Data 53 A99	[E-00B2 570 00B218B REAL8]
  MLP2 Zernike Data 54 A9m9	[E-00B2 578 00B218B REAL8]
  MLP2 Zernike Data 55 A100	[E-00B2 586 00B218B REAL8]
  MLP2 Zernike Data 56 A102	[E-00B2 594 00B218B REAL8]
  MLP2 Zernike Data 57 A10m2	[E-00B2 602 00B218B REAL8]
  MLP2 Zernike Data 58 A104	[E-00B2 610 00B218B REAL8]
  MLP2 Zernike Data 59 A10m4	[E-00B2 618 00B218B REAL8]
  MLP2 Zernike Data 60 A106	[E-00B2 626 00B218B REAL8]
  MLP2 Zernike Data 61 A10m6	[E-00B2 634 00B218B REAL8]
  MLP2 Zernike Data 62 A108	[E-00B2 642 00B218B REAL8]
  MLP2 Zernike Data 63 A10m8	[E-00B2 650 00B218B REAL8]
  MLP2 Zernike Data 64 A1010	[E-00B2 658 00B218B REAL8]
  MLP2 Zernike Data 65 A10m10	[E-00B2 666 00B218B REAL8]
  MLP2 Zernike Data 66	[E-00B2 674 00B218B REAL8]
  MLP2 Zernike Data 67	[E-00B2 682 00B218B REAL8]
  MLP2 Zernike Data 68	[E-00B2 690 00B218B REAL8]
  MLP2 Zernike Data 69	[E-00B2 698 00B218B REAL8]
  Actuator1-1 Position UNCALC Alarm	[E-00B2 718:0 00B2810]
  Actuator1-2 Position UNCALC Alarm	[E-00B2 718:1 00B2811]
  Actuator1-3 Position UNCALC Alarm	[E-00B2 718:2 00B2812]
  Actuator1-4 Position UNCALC Alarm	[E-00B2 718:3 00B2813]
  Actuator1-5 Position UNCALC Alarm	[E-00B2 718:4 00B2814]
  Actuator1-6 Position UNCALC Alarm	[E-00B2 718:5 00B2815]
  Actuator1-7 Position UNCALC Alarm	[E-00B2 718:6 00B2816]
  Actuator1-8 Position UNCALC Alarm	[E-00B2 718:7 00B2817]
  Actuator1-9 Position UNCALC Alarm	[E-00B2 719:0 00B2818]
  Actuator1-10 Position UNCALC Alarm	[E-00B2 719:1 00B2819]
  Actuator1-11 Position UNCALC Alarm	[E-00B2 719:2 00B281A]
  Actuator1-12 Position UNCALC Alarm	[E-00B2 719:3 00B281B]
  Actuator2-1 Position UNCALC Alarm	[E-00B2 719:4 00B281C]
  Actuator2-2 Position UNCALC Alarm	[E-00B2 719:5 00B281D]
  Actuator2-3 Position UNCALC Alarm	[E-00B2 719:6 00B281E]
  Actuator2-4 Position UNCALC Alarm	[E-00B2 719:7 00B281F]
  Actuator2-5 Position UNCALC Alarm	[E-00B2 720:0 00B2820]
  Actuator2-6 Position UNCALC Alarm	[E-00B2 720:1 00B2821]
  Actuator2-7 Position UNCALC Alarm	[E-00B2 720:2 00B2822]
  Actuator2-8 Position UNCALC Alarm	[E-00B2 720:3 00B2823]
  Actuator2-9 Position UNCALC Alarm	[E-00B2 720:4 00B2824]
  Actuator2-10 Position UNCALC Alarm	[E-00B2 720:5 00B2825]
  Actuator2-11 Position UNCALC Alarm	[E-00B2 720:6 00B2826]
  Actuator2-12 Position UNCALC Alarm	[E-00B2 720:7 00B2827]
  Actuator2-13 Position UNCALC Alarm	[E-00B2 721:0 00B2828]
  Actuator2-14 Position UNCALC Alarm	[E-00B2 721:1 00B2829]
  Actuator2-15 Position UNCALC Alarm	[E-00B2 721:2 00B282A]
  Actuator2-16 Position UNCALC Alarm	[E-00B2 721:3 00B282B]
  Actuator2-17 Position UNCALC Alarm	[E-00B2 721:4 00B282C]
  Actuator2-18 Position UNCALC Alarm	[E-00B2 721:5 00B282D]
  Actuator3-1 Position UNCALC Alarm	[E-00B2 721:6 00B282E]
  Actuator3-2 Position UNCALC Alarm	[E-00B2 721:7 00B282F]
  Actuator3-3 Position UNCALC Alarm	[E-00B2 722:0 00B2830]
  Actuator3-4 Position UNCALC Alarm	[E-00B2 722:1 00B2831]
  Actuator3-5 Position UNCALC Alarm	[E-00B2 722:2 00B2832]
  Actuator3-6 Position UNCALC Alarm	[E-00B2 722:3 00B2833]
  Actuator3-7 Position UNCALC Alarm	[E-00B2 722:4 00B2834]
  Actuator3-8 Position UNCALC Alarm	[E-00B2 722:5 00B2835]
  Actuator3-9 Position UNCALC Alarm	[E-00B2 722:6 00B2836]
  Actuator3-10 Position UNCALC Alarm	[E-00B2 722:7 00B2837]
  Actuator3-11 Position UNCALC Alarm	[E-00B2 723:0 00B2838]
  Actuator3-12 Position UNCALC Alarm	[E-00B2 723:1 00B2839]
  Actuator3-13 Position UNCALC Alarm	[E-00B2 723:2 00B283A]
  Actuator3-14 Position UNCALC Alarm	[E-00B2 723:3 00B283B]
  Actuator3-15 Position UNCALC Alarm	[E-00B2 723:4 00B283C]
  Actuator3-16 Position UNCALC Alarm	[E-00B2 723:5 00B283D]
  Actuator3-17 Position UNCALC Alarm	[E-00B2 723:6 00B283E]
  Actuator3-18 Position UNCALC Alarm	[E-00B2 723:7 00B283F]
  Actuator3-19 Position UNCALC Alarm	[E-00B2 724:0 00B2840]
  Actuator3-20 Position UNCALC Alarm	[E-00B2 724:1 00B2841]
  Actuator3-21 Position UNCALC Alarm	[E-00B2 724:2 00B2842]
  Actuator3-22 Position UNCALC Alarm	[E-00B2 724:3 00B2843]
  Actuator3-23 Position UNCALC Alarm	[E-00B2 724:4 00B2844]
  Actuator3-24 Position UNCALC Alarm	[E-00B2 724:5 00B2845]
  Actuator4-1 Position UNCALC Alarm	[E-00B2 724:6 00B2846]
  Actuator4-2 Position UNCALC Alarm	[E-00B2 724:7 00B2847]
  Actuator4-3 Position UNCALC Alarm	[E-00B2 725:0 00B2848]
  Actuator4-4 Position UNCALC Alarm	[E-00B2 725:1 00B2849]
  Actuator4-5 Position UNCALC Alarm	[E-00B2 725:2 00B284A]
  Actuator4-6 Position UNCALC Alarm	[E-00B2 725:3 00B284B]
  Actuator4-7 Position UNCALC Alarm	[E-00B2 725:4 00B284C]
  Actuator4-8 Position UNCALC Alarm	[E-00B2 725:5 00B284D]
  Actuator4-9 Position UNCALC Alarm	[E-00B2 725:6 00B284E]
  Actuator4-10 Position UNCALC Alarm	[E-00B2 725:7 00B284F]
  Actuator4-11 Position UNCALC Alarm	[E-00B2 726:0 00B2850]
  Actuator4-12 Position UNCALC Alarm	[E-00B2 726:1 00B2851]
  Actuator4-13 Position UNCALC Alarm	[E-00B2 726:2 00B2852]
  Actuator4-14 Position UNCALC Alarm	[E-00B2 726:3 00B2853]
  Actuator4-15 Position UNCALC Alarm	[E-00B2 726:4 00B2854]
  Actuator4-16 Position UNCALC Alarm	[E-00B2 726:5 00B2855]
  Actuator4-17 Position UNCALC Alarm	[E-00B2 726:6 00B2856]
  Actuator4-18 Position UNCALC Alarm	[E-00B2 726:7 00B2857]
  Actuator4-19 Position UNCALC Alarm	[E-00B2 727:0 00B2858]
  Actuator4-20 Position UNCALC Alarm	[E-00B2 727:1 00B2859]
  Actuator4-21 Position UNCALC Alarm	[E-00B2 727:2 00B285A]
  Actuator4-22 Position UNCALC Alarm	[E-00B2 727:3 00B285B]
  Actuator4-23 Position UNCALC Alarm	[E-00B2 727:4 00B285C]
  Actuator4-24 Position UNCALC Alarm	[E-00B2 727:5 00B285D]
  Actuator4-25 Position UNCALC Alarm	[E-00B2 727:6 00B285E]
  Actuator4-26 Position UNCALC Alarm	[E-00B2 727:7 00B285F]
  Actuator4-27 Position UNCALC Alarm	[E-00B2 728:0 00B2860]
  Actuator4-28 Position UNCALC Alarm	[E-00B2 728:1 00B2861]
  Actuator4-29 Position UNCALC Alarm	[E-00B2 728:2 00B2862]
  Actuator4-30 Position UNCALC Alarm	[E-00B2 728:3 00B2863]
  Actuator5-1 Position UNCALC Alarm	[E-00B2 728:4 00B2864]
  Actuator5-2 Position UNCALC Alarm	[E-00B2 728:5 00B2865]
  Actuator5-3 Position UNCALC Alarm	[E-00B2 728:6 00B2866]
  Actuator5-4 Position UNCALC Alarm	[E-00B2 728:7 00B2867]
  Actuator5-5 Position UNCALC Alarm	[E-00B2 729:0 00B2868]
  Actuator5-6 Position UNCALC Alarm	[E-00B2 729:1 00B2869]
  Actuator5-7 Position UNCALC Alarm	[E-00B2 729:2 00B286A]
  Actuator5-8 Position UNCALC Alarm	[E-00B2 729:3 00B286B]
  Actuator5-9 Position UNCALC Alarm	[E-00B2 729:4 00B286C]
  Actuator5-10 Position UNCALC Alarm	[E-00B2 729:5 00B286D]
  Actuator5-11 Position UNCALC Alarm	[E-00B2 729:6 00B286E]
  Actuator5-12 Position UNCALC Alarm	[E-00B2 729:7 00B286F]
  Actuator5-13 Position UNCALC Alarm	[E-00B2 730:0 00B2870]
  Actuator5-14 Position UNCALC Alarm	[E-00B2 730:1 00B2871]
  Actuator5-15 Position UNCALC Alarm	[E-00B2 730:2 00B2872]
  Actuator5-16 Position UNCALC Alarm	[E-00B2 730:3 00B2873]
  Actuator5-17 Position UNCALC Alarm	[E-00B2 730:4 00B2874]
  Actuator5-18 Position UNCALC Alarm	[E-00B2 730:5 00B2875]
  Actuator5-19 Position UNCALC Alarm	[E-00B2 730:6 00B2876]
  Actuator5-20 Position UNCALC Alarm	[E-00B2 730:7 00B2877]
  Actuator5-21 Position UNCALC Alarm	[E-00B2 731:0 00B2878]
  Actuator5-22 Position UNCALC Alarm	[E-00B2 731:1 00B2879]
  Actuator5-23 Position UNCALC Alarm	[E-00B2 731:2 00B287A]
  Actuator5-24 Position UNCALC Alarm	[E-00B2 731:3 00B287B]
  Actuator5-25 Position UNCALC Alarm	[E-00B2 731:4 00B287C]
  Actuator5-26 Position UNCALC Alarm	[E-00B2 731:5 00B287D]
  Actuator5-27 Position UNCALC Alarm	[E-00B2 731:6 00B287E]
  Actuator5-28 Position UNCALC Alarm	[E-00B2 731:7 00B287F]
  Actuator5-29 Position UNCALC Alarm	[E-00B2 732:0 00B2880]
  Actuator5-30 Position UNCALC Alarm	[E-00B2 732:1 00B2881]
  Actuator5-31 Position UNCALC Alarm	[E-00B2 732:2 00B2882]
  Actuator5-32 Position UNCALC Alarm	[E-00B2 732:3 00B2883]
  Actuator5-33 Position UNCALC Alarm	[E-00B2 732:4 00B2884]
  Actuator5-34 Position UNCALC Alarm	[E-00B2 732:5 00B2885]
  Actuator5-35 Position UNCALC Alarm	[E-00B2 732:6 00B2886]
  Actuator5-36 Position UNCALC Alarm	[E-00B2 732:7 00B2887]
  Actuator6-1 Position UNCALC Alarm	[E-00B2 733:0 00B2888]
  Actuator6-2 Position UNCALC Alarm	[E-00B2 733:1 00B2889]
  Actuator6-3 Position UNCALC Alarm	[E-00B2 733:2 00B288A]
  Actuator6-4 Position UNCALC Alarm	[E-00B2 733:3 00B288B]
  Actuator6-5 Position UNCALC Alarm	[E-00B2 733:4 00B288C]
  Actuator6-6 Position UNCALC Alarm	[E-00B2 733:5 00B288D]
  Actuator6-7 Position UNCALC Alarm	[E-00B2 733:6 00B288E]
  Actuator6-8 Position UNCALC Alarm	[E-00B2 733:7 00B288F]
  Actuator6-9 Position UNCALC Alarm	[E-00B2 734:0 00B2890]
  Actuator6-10 Position UNCALC Alarm	[E-00B2 734:1 00B2891]
  Actuator6-11 Position UNCALC Alarm	[E-00B2 734:2 00B2892]
  Actuator6-12 Position UNCALC Alarm	[E-00B2 734:3 00B2893]
  Actuator6-13 Position UNCALC Alarm	[E-00B2 734:4 00B2894]
  Actuator6-14 Position UNCALC Alarm	[E-00B2 734:5 00B2895]
  Actuator6-15 Position UNCALC Alarm	[E-00B2 734:6 00B2896]
  Actuator6-16 Position UNCALC Alarm	[E-00B2 734:7 00B2897]
  Actuator6-17 Position UNCALC Alarm	[E-00B2 735:0 00B2898]
  Actuator6-18 Position UNCALC Alarm	[E-00B2 735:1 00B2899]
  Actuator6-19 Position UNCALC Alarm	[E-00B2 735:2 00B289A]
  Actuator6-20 Position UNCALC Alarm	[E-00B2 735:3 00B289B]
  Actuator6-21 Position UNCALC Alarm	[E-00B2 735:4 00B289C]
  Actuator6-22 Position UNCALC Alarm	[E-00B2 735:5 00B289D]
  Actuator6-23 Position UNCALC Alarm	[E-00B2 735:6 00B289E]
  Actuator6-24 Position UNCALC Alarm	[E-00B2 735:7 00B289F]
  Actuator6-25 Position UNCALC Alarm	[E-00B2 736:0 00B28A0]
  Actuator6-26 Position UNCALC Alarm	[E-00B2 736:1 00B28A1]
  Actuator6-27 Position UNCALC Alarm	[E-00B2 736:2 00B28A2]
  Actuator6-28 Position UNCALC Alarm	[E-00B2 736:3 00B28A3]
  Actuator6-29 Position UNCALC Alarm	[E-00B2 736:4 00B28A4]
  Actuator6-30 Position UNCALC Alarm	[E-00B2 736:5 00B28A5]
  Actuator6-31 Position UNCALC Alarm	[E-00B2 736:6 00B28A6]
  Actuator6-32 Position UNCALC Alarm	[E-00B2 736:7 00B28A7]
  Actuator6-33 Position UNCALC Alarm	[E-00B2 737:0 00B28A8]
  Actuator6-34 Position UNCALC Alarm	[E-00B2 737:1 00B28A9]
  Actuator6-35 Position UNCALC Alarm	[E-00B2 737:2 00B28AA]
  Actuator6-36 Position UNCALC Alarm	[E-00B2 737:3 00B28AB]
  Actuator6-37 Position UNCALC Alarm	[E-00B2 737:4 00B28AC]
  Actuator6-38 Position UNCALC Alarm	[E-00B2 737:5 00B28AD]
  Actuator6-39 Position UNCALC Alarm	[E-00B2 737:6 00B28AE]
  Actuator6-40 Position UNCALC Alarm	[E-00B2 737:7 00B28AF]
  Actuator6-41 Position UNCALC Alarm	[E-00B2 738:0 00B28B0]
  Actuator6-42 Position UNCALC Alarm	[E-00B2 738:1 00B28B1]
  Actuator7-1 Position UNCALC Alarm	[E-00B2 738:2 00B28B2]
  Actuator7-2 Position UNCALC Alarm	[E-00B2 738:3 00B28B3]
  Actuator7-3 Position UNCALC Alarm	[E-00B2 738:4 00B28B4]
  Actuator7-4 Position UNCALC Alarm	[E-00B2 738:5 00B28B5]
  Actuator7-5 Position UNCALC Alarm	[E-00B2 738:6 00B28B6]
  Actuator7-6 Position UNCALC Alarm	[E-00B2 738:7 00B28B7]
  Actuator7-7 Position UNCALC Alarm	[E-00B2 739:0 00B28B8]
  Actuator7-8 Position UNCALC Alarm	[E-00B2 739:1 00B28B9]
  Actuator7-9 Position UNCALC Alarm	[E-00B2 739:2 00B28BA]
  Actuator7-10 Position UNCALC Alarm	[E-00B2 739:3 00B28BB]
  Actuator7-11 Position UNCALC Alarm	[E-00B2 739:4 00B28BC]
  Actuator7-12 Position UNCALC Alarm	[E-00B2 739:5 00B28BD]
  Actuator7-13 Position UNCALC Alarm	[E-00B2 739:6 00B28BE]
  Actuator7-14 Position UNCALC Alarm	[E-00B2 739:7 00B28BF]
  Actuator7-15 Position UNCALC Alarm	[E-00B2 740:0 00B28C0]
  Actuator7-16 Position UNCALC Alarm	[E-00B2 740:1 00B28C1]
  Actuator7-17 Position UNCALC Alarm	[E-00B2 740:2 00B28C2]
  Actuator7-18 Position UNCALC Alarm	[E-00B2 740:3 00B28C3]
  Actuator7-19 Position UNCALC Alarm	[E-00B2 740:4 00B28C4]
  Actuator7-20 Position UNCALC Alarm	[E-00B2 740:5 00B28C5]
  Actuator7-21 Position UNCALC Alarm	[E-00B2 740:6 00B28C6]
  Actuator7-22 Position UNCALC Alarm	[E-00B2 740:7 00B28C7]
  Actuator7-23 Position UNCALC Alarm	[E-00B2 741:0 00B28C8]
  Actuator7-24 Position UNCALC Alarm	[E-00B2 741:1 00B28C9]
  Actuator7-25 Position UNCALC Alarm	[E-00B2 741:2 00B28CA]
  Actuator7-26 Position UNCALC Alarm	[E-00B2 741:3 00B28CB]
  Actuator7-27 Position UNCALC Alarm	[E-00B2 741:4 00B28CC]
  Actuator7-28 Position UNCALC Alarm	[E-00B2 741:5 00B28CD]
  Actuator7-29 Position UNCALC Alarm	[E-00B2 741:6 00B28CE]
  Actuator7-30 Position UNCALC Alarm	[E-00B2 741:7 00B28CF]
  Actuator7-31 Position UNCALC Alarm	[E-00B2 742:0 00B28D0]
  Actuator7-32 Position UNCALC Alarm	[E-00B2 742:1 00B28D1]
  Actuator7-33 Position UNCALC Alarm	[E-00B2 742:2 00B28D2]
  Actuator7-34 Position UNCALC Alarm	[E-00B2 742:3 00B28D3]
  Actuator7-35 Position UNCALC Alarm	[E-00B2 742:4 00B28D4]
  Actuator7-36 Position UNCALC Alarm	[E-00B2 742:5 00B28D5]
  Actuator7-37 Position UNCALC Alarm	[E-00B2 742:6 00B28D6]
  Actuator7-38 Position UNCALC Alarm	[E-00B2 742:7 00B28D7]
  Actuator7-39 Position UNCALC Alarm	[E-00B2 743:0 00B28D8]
  Actuator7-40 Position UNCALC Alarm	[E-00B2 743:1 00B28D9]
  Actuator7-41 Position UNCALC Alarm	[E-00B2 743:2 00B28DA]
  Actuator7-42 Position UNCALC Alarm	[E-00B2 743:3 00B28DB]
  Actuator7-43 Position UNCALC Alarm	[E-00B2 743:4 00B28DC]
  Actuator7-44 Position UNCALC Alarm	[E-00B2 743:5 00B28DD]
  Actuator7-45 Position UNCALC Alarm	[E-00B2 743:6 00B28DE]
  Actuator7-46 Position UNCALC Alarm	[E-00B2 743:7 00B28DF]
  Actuator7-47 Position UNCALC Alarm	[E-00B2 744:0 00B28E0]
  Actuator7-48 Position UNCALC Alarm	[E-00B2 744:1 00B28E1]
  Actuator8-1 Position UNCALC Alarm	[E-00B2 744:2 00B28E2]
  Actuator8-2 Position UNCALC Alarm	[E-00B2 744:3 00B28E3]
  Actuator8-3 Position UNCALC Alarm	[E-00B2 744:4 00B28E4]
  Actuator8-4 Position UNCALC Alarm	[E-00B2 744:5 00B28E5]
  Actuator8-5 Position UNCALC Alarm	[E-00B2 744:6 00B28E6]
  Actuator8-6 Position UNCALC Alarm	[E-00B2 744:7 00B28E7]
  Actuator8-7 Position UNCALC Alarm	[E-00B2 745:0 00B28E8]
  Actuator8-8 Position UNCALC Alarm	[E-00B2 745:1 00B28E9]
  Actuator8-9 Position UNCALC Alarm	[E-00B2 745:2 00B28EA]
  Actuator8-10 Position UNCALC Alarm	[E-00B2 745:3 00B28EB]
  Actuator8-11 Position UNCALC Alarm	[E-00B2 745:4 00B28EC]
  Actuator8-12 Position UNCALC Alarm	[E-00B2 745:5 00B28ED]
  Actuator8-13 Position UNCALC Alarm	[E-00B2 745:6 00B28EE]
  Actuator8-14 Position UNCALC Alarm	[E-00B2 745:7 00B28EF]
  Actuator8-15 Position UNCALC Alarm	[E-00B2 746:0 00B28F0]
  Actuator8-16 Position UNCALC Alarm	[E-00B2 746:1 00B28F1]
  Actuator8-17 Position UNCALC Alarm	[E-00B2 746:2 00B28F2]
  Actuator8-18 Position UNCALC Alarm	[E-00B2 746:3 00B28F3]
  Actuator8-19 Position UNCALC Alarm	[E-00B2 746:4 00B28F4]
  Actuator8-20 Position UNCALC Alarm	[E-00B2 746:5 00B28F5]
  Actuator8-21 Position UNCALC Alarm	[E-00B2 746:6 00B28F6]
  Actuator8-22 Position UNCALC Alarm	[E-00B2 746:7 00B28F7]
  Actuator8-23 Position UNCALC Alarm	[E-00B2 747:0 00B28F8]
  Actuator8-24 Position UNCALC Alarm	[E-00B2 747:1 00B28F9]
  Actuator8-25 Position UNCALC Alarm	[E-00B2 747:2 00B28FA]
  Actuator8-26 Position UNCALC Alarm	[E-00B2 747:3 00B28FB]
  Actuator8-27 Position UNCALC Alarm	[E-00B2 747:4 00B28FC]
  Actuator8-28 Position UNCALC Alarm	[E-00B2 747:5 00B28FD]
  Actuator8-29 Position UNCALC Alarm	[E-00B2 747:6 00B28FE]
  Actuator8-30 Position UNCALC Alarm	[E-00B2 747:7 00B28FF]
  Actuator8-31 Position UNCALC Alarm	[E-00B2 748:0 00B2900]
  Actuator8-32 Position UNCALC Alarm	[E-00B2 748:1 00B2901]
  Actuator8-33 Position UNCALC Alarm	[E-00B2 748:2 00B2902]
  Actuator8-34 Position UNCALC Alarm	[E-00B2 748:3 00B2903]
  Actuator8-35 Position UNCALC Alarm	[E-00B2 748:4 00B2904]
  Actuator8-36 Position UNCALC Alarm	[E-00B2 748:5 00B2905]
  Actuator8-37 Position UNCALC Alarm	[E-00B2 748:6 00B2906]
  Actuator8-38 Position UNCALC Alarm	[E-00B2 748:7 00B2907]
  Actuator8-39 Position UNCALC Alarm	[E-00B2 749:0 00B2908]
  Actuator8-40 Position UNCALC Alarm	[E-00B2 749:1 00B2909]
  Actuator8-41 Position UNCALC Alarm	[E-00B2 749:2 00B290A]
  Actuator8-42 Position UNCALC Alarm	[E-00B2 749:3 00B290B]
  Actuator8-43 Position UNCALC Alarm	[E-00B2 749:4 00B290C]
  Actuator8-44 Position UNCALC Alarm	[E-00B2 749:5 00B290D]
  Actuator8-45 Position UNCALC Alarm	[E-00B2 749:6 00B290E]
  Actuator8-46 Position UNCALC Alarm	[E-00B2 749:7 00B290F]
  Actuator8-47 Position UNCALC Alarm	[E-00B2 750:0 00B2910]
  Actuator8-48 Position UNCALC Alarm	[E-00B2 750:1 00B2911]
  Actuator8-49 Position UNCALC Alarm	[E-00B2 750:2 00B2912]
  Actuator8-50 Position UNCALC Alarm	[E-00B2 750:3 00B2913]
  Actuator8-51 Position UNCALC Alarm	[E-00B2 750:4 00B2914]
  2nd Mirror OBE-AG Z Offset	[E-00B2 757 00B2194 BCD6]
  EL Angle(Zernike Calculate)	[E-00B2 763 00B2195 BCD6]
  SM u IEC Value	[E-00B2 769 00B2934 BCD6]
  SM v IEC Value	[E-00B2 775 00B2935 BCD6]
  SM z IEC Value	[E-00B2 781 00B2936 BCD6]
  SM u CorrectIOn Value	[E-00B2 787 00B2937 BCD6]
  SM v CorrectIOn Value	[E-00B2 793 00B2938 BCD6]
  SM z CorrectIOn Value	[E-00B2 799 00B2939 BCD6]
  SM u SH CorrectIOn Value	[E-00B2 805 00B293A BCD6]
  SM v SH CorrectIOn Value	[E-00B2 811 00B293B BCD6]
  SM z SH CorrectIOn Value	[E-00B2 817 00B293C BCD6]
  SM x-axis Offset	[E-00B2 823 00B2941 BCD6]
  SM y-axis Offset	[E-00B2 829 00B2942 BCD6]
  SM z-axis Offset	[E-00B2 835 00B2943 BCD6]
  SM THETA x Offset	[E-00B2 841 00B2944 BCD6]
  SM THETA y Offset	[E-00B2 847 00B2945 BCD6]
  SM x-axis Correction Value	[E-00B2 853 00B2946 BCD6]
  SM y-axis Correction Value	[E-00B2 859 00B2947 BCD6]
  SM z-axis Correction Value	[E-00B2 865 00B2948 BCD6]
  SM THETA x Correction Value	[E-00B2 871 00B2949 BCD6]
  SM THETA y Correction Value	[E-00B2 877 00B294A BCD6]
  SM THETA z Offset	[E-00B2 883 00B2950 BCD6]
  Zernike Data RMS(Total)	[E-00B2 889 00B218C REAL8]
  SM Auto Focus X Offset Position	[E-00B2 897 00B2196 BCD6]
  SM Auto Focus Y Offset Position	[E-00B2 903 00B2197 BCD6]
  SM Auto Focus Z Offset Position	[E-00B2 909 00B2198 BCD6]
  SM Auto Focus X Offset Angle	[E-00B2 915 00B2199 BCD6]
  SM Auto Focus Y Offset Angle	[E-00B2 921 00B219A BCD6]
  AG/SH Pickup Mirror Full	[E-00B2 927:0 00B2951]
  AG/SH Pickup Mirror Half	[E-00B2 927:1 00B2952]
  Total Rotate Point	[E-00B2 928 00B2953 BINARY1_1]
  P Rotator Current Point	[E-00B2 929 00B2954 BINARY1_1]
  SH Test Data Get Status 1	[E-00B2 930:0 00B2955]
  SH Test Data Get Status 2	[E-00B2 930:1 00B2956]
  SH Test Data Get Status 3	[E-00B2 930:2 00B2957]
  SH Test Data Get Status 4	[E-00B2 930:3 00B2958]
  SH Error Acquisition Time 1	[E-00B2 931 00B2959 TIME4]
  SH Error Acquisition Time 2	[E-00B2 935 00B295A TIME4]
  SH Error Acquisition Time 3	[E-00B2 939 00B295B TIME4]
  SH Error Acquisition Time 4	[E-00B2 943 00B295C TIME4]
  Show SH Error Select	[E-00B2 947 00B295D BINARY1_1]
  PIR z Offset	[E-00B2 948 00B2964 BCD6]
  PIR z Correction Value	[E-00B2 954 00B2965 BCD6]
  PIR Auto Focus z Offset Position	[E-00B2 960 00B2966 BCD6]
  PIR z CMD Value	[E-00B2 966 00B2967 BCD6]
  PIR r Offset(SPARE)	[E-00B2 972 00B2968 BCD6]
  PIR r Correction Value(SPARE)	[E-00B2 978 00B2969 BCD6]
  PIR Auto Focus r Offset Position(SPARE)	[E-00B2 984 00B296A BCD6]
  PIR r CMD Value(SPARE)	[E-00B2 990 00B296B BCD6]
  Actuator1-1 Real Force	[L2-00B2 0 00B2550 BINARY4_0p01]
  Actuator1-1 CMD Force	[L2-00B2 4 00B2700 BINARY4_0p01]
  Actuator1-2 Real Force	[L2-00B2 8 00B2551 BINARY4_0p01]
  Actuator1-2 CMD Force	[L2-00B2 12 00B2701 BINARY4_0p01]
  Actuator1-3 Real Force	[L2-00B2 16 00B2552 BINARY4_0p01]
  Actuator1-3 CMD Force	[L2-00B2 20 00B2702 BINARY4_0p01]
  Actuator1-4 Real Force	[L2-00B2 24 00B2553 BINARY4_0p01]
  Actuator1-4 CMD Force	[L2-00B2 28 00B2703 BINARY4_0p01]
  Actuator1-5 Real Force	[L2-00B2 32 00B2554 BINARY4_0p01]
  Actuator1-5 CMD Force	[L2-00B2 36 00B2704 BINARY4_0p01]
  Actuator1-6 Real Force	[L2-00B2 40 00B2555 BINARY4_0p01]
  Actuator1-6 CMD Force	[L2-00B2 44 00B2705 BINARY4_0p01]
  Actuator1-7 Real Force	[L2-00B2 48 00B2556 BINARY4_0p01]
  Actuator1-7 CMD Force	[L2-00B2 52 00B2706 BINARY4_0p01]
  Actuator1-8 Real Force	[L2-00B2 56 00B2557 BINARY4_0p01]
  Actuator1-8 CMD Force	[L2-00B2 60 00B2707 BINARY4_0p01]
  Actuator1-9 Real Force	[L2-00B2 64 00B2558 BINARY4_0p01]
  Actuator1-9 CMD Force	[L2-00B2 68 00B2708 BINARY4_0p01]
  Actuator1-10 Real Force	[L2-00B2 72 00B2559 BINARY4_0p01]
  Actuator1-10 CMD Force	[L2-00B2 76 00B2709 BINARY4_0p01]
  Actuator1-11 Real Force	[L2-00B2 80 00B255A BINARY4_0p01]
  Actuator1-11 CMD Force	[L2-00B2 84 00B270A BINARY4_0p01]
  Actuator1-12 Real Force	[L2-00B2 88 00B255B BINARY4_0p01]
  Actuator1-12 CMD Force	[L2-00B2 92 00B270B BINARY4_0p01]
  Actuator2-1 Real Force	[L2-00B2 96 00B255C BINARY4_0p01]
  Actuator2-1 CMD Force	[L2-00B2 100 00B270C BINARY4_0p01]
  Actuator2-2 Real Force	[L2-00B2 104 00B255D BINARY4_0p01]
  Actuator2-2 CMD Force	[L2-00B2 108 00B270D BINARY4_0p01]
  Actuator2-3 Real Force	[L2-00B2 112 00B255E BINARY4_0p01]
  Actuator2-3 CMD Force	[L2-00B2 116 00B270E BINARY4_0p01]
  Actuator2-4 Real Force	[L2-00B2 120 00B255F BINARY4_0p01]
  Actuator2-4 CMD Force	[L2-00B2 124 00B270F BINARY4_0p01]
  Actuator2-5 Real Force	[L2-00B2 128 00B2560 BINARY4_0p01]
  Actuator2-5 CMD Force	[L2-00B2 132 00B2710 BINARY4_0p01]
  Actuator2-6 Real Force	[L2-00B2 136 00B2561 BINARY4_0p01]
  Actuator2-6 CMD Force	[L2-00B2 140 00B2711 BINARY4_0p01]
  Actuator2-7 Real Force	[L2-00B2 144 00B2562 BINARY4_0p01]
  Actuator2-7 CMD Force	[L2-00B2 148 00B2712 BINARY4_0p01]
  Actuator2-8 Real Force	[L2-00B2 152 00B2563 BINARY4_0p01]
  Actuator2-8 CMD Force	[L2-00B2 156 00B2713 BINARY4_0p01]
  Actuator2-9 Real Force	[L2-00B2 160 00B2564 BINARY4_0p01]
  Actuator2-9 CMD Force	[L2-00B2 164 00B2714 BINARY4_0p01]
  Actuator2-10 Real Force	[L2-00B2 168 00B2565 BINARY4_0p01]
  Actuator2-10 CMD Force	[L2-00B2 172 00B2715 BINARY4_0p01]
  Actuator2-11 Real Force	[L2-00B2 176 00B2566 BINARY4_0p01]
  Actuator2-11 CMD Force	[L2-00B2 180 00B2716 BINARY4_0p01]
  Actuator2-12 Real Force	[L2-00B2 184 00B2567 BINARY4_0p01]
  Actuator2-12 CMD Force	[L2-00B2 188 00B2717 BINARY4_0p01]
  Actuator2-13 Real Force	[L2-00B2 192 00B2568 BINARY4_0p01]
  Actuator2-13 CMD Force	[L2-00B2 196 00B2718 BINARY4_0p01]
  Actuator2-14 Real Force	[L2-00B2 200 00B2569 BINARY4_0p01]
  Actuator2-14 CMD Force	[L2-00B2 204 00B2719 BINARY4_0p01]
  Actuator2-15 Real Force	[L2-00B2 208 00B256A BINARY4_0p01]
  Actuator2-15 CMD Force	[L2-00B2 212 00B271A BINARY4_0p01]
  Actuator2-16 Real Force	[L2-00B2 216 00B256B BINARY4_0p01]
  Actuator2-16 CMD Force	[L2-00B2 220 00B271B BINARY4_0p01]
  Actuator2-17 Real Force	[L2-00B2 224 00B256C BINARY4_0p01]
  Actuator2-17 CMD Force	[L2-00B2 228 00B271C BINARY4_0p01]
  Actuator2-18 Real Force	[L2-00B2 232 00B256D BINARY4_0p01]
  Actuator2-18 CMD Force	[L2-00B2 236 00B271D BINARY4_0p01]
  Actuator3-1 Real Force	[L2-00B2 240 00B256E BINARY4_0p01]
  Actuator3-1 CMD Force	[L2-00B2 244 00B271E BINARY4_0p01]
  Actuator3-2 Real Force	[L2-00B2 248 00B256F BINARY4_0p01]
  Actuator3-2 CMD Force	[L2-00B2 252 00B271F BINARY4_0p01]
  Actuator3-3 Real Force	[L2-00B2 256 00B2570 BINARY4_0p01]
  Actuator3-3 CMD Force	[L2-00B2 260 00B2720 BINARY4_0p01]
  Actuator3-4 Real Force	[L2-00B2 264 00B2571 BINARY4_0p01]
  Actuator3-4 CMD Force	[L2-00B2 268 00B2721 BINARY4_0p01]
  Actuator3-5 Real Force	[L2-00B2 272 00B2572 BINARY4_0p01]
  Actuator3-5 CMD Force	[L2-00B2 276 00B2722 BINARY4_0p01]
  Actuator3-6 Real Force	[L2-00B2 280 00B2573 BINARY4_0p01]
  Actuator3-6 CMD Force	[L2-00B2 284 00B2723 BINARY4_0p01]
  Actuator3-7 Real Force	[L2-00B2 288 00B2574 BINARY4_0p01]
  Actuator3-7 CMD Force	[L2-00B2 292 00B2724 BINARY4_0p01]
  Actuator3-8 Real Force	[L2-00B2 296 00B2575 BINARY4_0p01]
  Actuator3-8 CMD Force	[L2-00B2 300 00B2725 BINARY4_0p01]
  Actuator3-9 Real Force	[L2-00B2 304 00B2576 BINARY4_0p01]
  Actuator3-9 CMD Force	[L2-00B2 308 00B2726 BINARY4_0p01]
  Actuator3-10 Real Force	[L2-00B2 312 00B2577 BINARY4_0p01]
  Actuator3-10 CMD Force	[L2-00B2 316 00B2727 BINARY4_0p01]
  Actuator3-11 Real Force	[L2-00B2 320 00B2578 BINARY4_0p01]
  Actuator3-11 CMD Force	[L2-00B2 324 00B2728 BINARY4_0p01]
  Actuator3-12 Real Force	[L2-00B2 328 00B2579 BINARY4_0p01]
  Actuator3-12 CMD Force	[L2-00B2 332 00B2729 BINARY4_0p01]
  Actuator3-13 Real Force	[L2-00B2 336 00B257A BINARY4_0p01]
  Actuator3-13 CMD Force	[L2-00B2 340 00B272A BINARY4_0p01]
  Actuator3-14 Real Force	[L2-00B2 344 00B257B BINARY4_0p01]
  Actuator3-14 CMD Force	[L2-00B2 348 00B272B BINARY4_0p01]
  Actuator3-15 Real Force	[L2-00B2 352 00B257C BINARY4_0p01]
  Actuator3-15 CMD Force	[L2-00B2 356 00B272C BINARY4_0p01]
  Actuator3-16 Real Force	[L2-00B2 360 00B257D BINARY4_0p01]
  Actuator3-16 CMD Force	[L2-00B2 364 00B272D BINARY4_0p01]
  Actuator3-17 Real Force	[L2-00B2 368 00B257E BINARY4_0p01]
  Actuator3-17 CMD Force	[L2-00B2 372 00B272E BINARY4_0p01]
  Actuator3-18 Real Force	[L2-00B2 376 00B257F BINARY4_0p01]
  Actuator3-18 CMD Force	[L2-00B2 380 00B272F BINARY4_0p01]
  Actuator3-19 Real Force	[L2-00B2 384 00B2580 BINARY4_0p01]
  Actuator3-19 CMD Force	[L2-00B2 388 00B2730 BINARY4_0p01]
  Actuator3-20 Real Force	[L2-00B2 392 00B2581 BINARY4_0p01]
  Actuator3-20 CMD Force	[L2-00B2 396 00B2731 BINARY4_0p01]
  Actuator3-21 Real Force	[L2-00B2 400 00B2582 BINARY4_0p01]
  Actuator3-21 CMD Force	[L2-00B2 404 00B2732 BINARY4_0p01]
  Actuator3-22 Real Force	[L2-00B2 408 00B2583 BINARY4_0p01]
  Actuator3-22 CMD Force	[L2-00B2 412 00B2733 BINARY4_0p01]
  Actuator3-23 Real Force	[L2-00B2 416 00B2584 BINARY4_0p01]
  Actuator3-23 CMD Force	[L2-00B2 420 00B2734 BINARY4_0p01]
  Actuator3-24 Real Force	[L2-00B2 424 00B2585 BINARY4_0p01]
  Actuator3-24 CMD Force	[L2-00B2 428 00B2735 BINARY4_0p01]
  Actuator4-1 Real Force	[L2-00B2 432 00B2586 BINARY4_0p01]
  Actuator4-1 CMD Force	[L2-00B2 436 00B2736 BINARY4_0p01]
  Actuator4-2 Real Force	[L2-00B2 440 00B2587 BINARY4_0p01]
  Actuator4-2 CMD Force	[L2-00B2 444 00B2737 BINARY4_0p01]
  Actuator4-3 Real Force	[L2-00B2 448 00B2588 BINARY4_0p01]
  Actuator4-3 CMD Force	[L2-00B2 452 00B2738 BINARY4_0p01]
  Actuator4-4 Real Force	[L2-00B2 456 00B2589 BINARY4_0p01]
  Actuator4-4 CMD Force	[L2-00B2 460 00B2739 BINARY4_0p01]
  Actuator4-5 Real Force	[L2-00B2 464 00B258A BINARY4_0p01]
  Actuator4-5 CMD Force	[L2-00B2 468 00B273A BINARY4_0p01]
  Actuator4-6 Real Force	[L2-00B2 472 00B258B BINARY4_0p01]
  Actuator4-6 CMD Force	[L2-00B2 476 00B273B BINARY4_0p01]
  Actuator4-7 Real Force	[L2-00B2 480 00B258C BINARY4_0p01]
  Actuator4-7 CMD Force	[L2-00B2 484 00B273C BINARY4_0p01]
  Actuator4-8 Real Force	[L2-00B2 488 00B258D BINARY4_0p01]
  Actuator4-8 CMD Force	[L2-00B2 492 00B273D BINARY4_0p01]
  Actuator4-9 Real Force	[L2-00B2 496 00B258E BINARY4_0p01]
  Actuator4-9 CMD Force	[L2-00B2 500 00B273E BINARY4_0p01]
  Actuator4-10 Real Force	[L2-00B2 504 00B258F BINARY4_0p01]
  Actuator4-10 CMD Force	[L2-00B2 508 00B273F BINARY4_0p01]
  Actuator4-11 Real Force	[L2-00B2 512 00B2590 BINARY4_0p01]
  Actuator4-11 CMD Force	[L2-00B2 516 00B2740 BINARY4_0p01]
  Actuator4-12 Real Force	[L2-00B2 520 00B2591 BINARY4_0p01]
  Actuator4-12 CMD Force	[L2-00B2 524 00B2741 BINARY4_0p01]
  Actuator4-13 Real Force	[L2-00B2 528 00B2592 BINARY4_0p01]
  Actuator4-13 CMD Force	[L2-00B2 532 00B2742 BINARY4_0p01]
  Actuator4-14 Real Force	[L2-00B2 536 00B2593 BINARY4_0p01]
  Actuator4-14 CMD Force	[L2-00B2 540 00B2743 BINARY4_0p01]
  Actuator4-15 Real Force	[L2-00B2 544 00B2594 BINARY4_0p01]
  Actuator4-15 CMD Force	[L2-00B2 548 00B2744 BINARY4_0p01]
  Actuator4-16 Real Force	[L2-00B2 552 00B2595 BINARY4_0p01]
  Actuator4-16 CMD Force	[L2-00B2 556 00B2745 BINARY4_0p01]
  Actuator4-17 Real Force	[L2-00B2 560 00B2596 BINARY4_0p01]
  Actuator4-17 CMD Force	[L2-00B2 564 00B2746 BINARY4_0p01]
  Actuator4-18 Real Force	[L2-00B2 568 00B2597 BINARY4_0p01]
  Actuator4-18 CMD Force	[L2-00B2 572 00B2747 BINARY4_0p01]
  Actuator4-19 Real Force	[L2-00B2 576 00B2598 BINARY4_0p01]
  Actuator4-19 CMD Force	[L2-00B2 580 00B2748 BINARY4_0p01]
  Actuator4-20 Real Force	[L2-00B2 584 00B2599 BINARY4_0p01]
  Actuator4-20 CMD Force	[L2-00B2 588 00B2749 BINARY4_0p01]
  Actuator4-21 Real Force	[L2-00B2 592 00B259A BINARY4_0p01]
  Actuator4-21 CMD Force	[L2-00B2 596 00B274A BINARY4_0p01]
  Actuator4-22 Real Force	[L2-00B2 600 00B259B BINARY4_0p01]
  Actuator4-22 CMD Force	[L2-00B2 604 00B274B BINARY4_0p01]
  Actuator4-23 Real Force	[L2-00B2 608 00B259C BINARY4_0p01]
  Actuator4-23 CMD Force	[L2-00B2 612 00B274C BINARY4_0p01]
  Actuator4-24 Real Force	[L2-00B2 616 00B259D BINARY4_0p01]
  Actuator4-24 CMD Force	[L2-00B2 620 00B274D BINARY4_0p01]
  Actuator4-25 Real Force	[L2-00B2 624 00B259E BINARY4_0p01]
  Actuator4-25 CMD Force	[L2-00B2 628 00B274E BINARY4_0p01]
  Actuator4-26 Real Force	[L2-00B2 632 00B259F BINARY4_0p01]
  Actuator4-26 CMD Force	[L2-00B2 636 00B274F BINARY4_0p01]
  Actuator4-27 Real Force	[L2-00B2 640 00B25A0 BINARY4_0p01]
  Actuator4-27 CMD Force	[L2-00B2 644 00B2750 BINARY4_0p01]
  Actuator4-28 Real Force	[L2-00B2 648 00B25A1 BINARY4_0p01]
  Actuator4-28 CMD Force	[L2-00B2 652 00B2751 BINARY4_0p01]
  Actuator4-29 Real Force	[L2-00B2 656 00B25A2 BINARY4_0p01]
  Actuator4-29 CMD Force	[L2-00B2 660 00B2752 BINARY4_0p01]
  Actuator4-30 Real Force	[L2-00B2 664 00B25A3 BINARY4_0p01]
  Actuator4-30 CMD Force	[L2-00B2 668 00B2753 BINARY4_0p01]
  Actuator5-1 Real Force	[L2-00B2 672 00B25A4 BINARY4_0p01]
  Actuator5-1 CMD Force	[L2-00B2 676 00B2754 BINARY4_0p01]
  Actuator5-2 Real Force	[L2-00B2 680 00B25A5 BINARY4_0p01]
  Actuator5-2 CMD Force	[L2-00B2 684 00B2755 BINARY4_0p01]
  Actuator5-3 Real Force	[L2-00B2 688 00B25A6 BINARY4_0p01]
  Actuator5-3 CMD Force	[L2-00B2 692 00B2756 BINARY4_0p01]
  Actuator5-4 Real Force	[L2-00B2 696 00B25A7 BINARY4_0p01]
  Actuator5-4 CMD Force	[L2-00B2 700 00B2757 BINARY4_0p01]
  Actuator5-5 Real Force	[L2-00B2 704 00B25A8 BINARY4_0p01]
  Actuator5-5 CMD Force	[L2-00B2 708 00B2758 BINARY4_0p01]
  Actuator5-6 Real Force	[L2-00B2 712 00B25A9 BINARY4_0p01]
  Actuator5-6 CMD Force	[L2-00B2 716 00B2759 BINARY4_0p01]
  Actuator5-7 Real Force	[L2-00B2 720 00B25AA BINARY4_0p01]
  Actuator5-7 CMD Force	[L2-00B2 724 00B275A BINARY4_0p01]
  Actuator5-8 Real Force	[L2-00B2 728 00B25AB BINARY4_0p01]
  Actuator5-8 CMD Force	[L2-00B2 732 00B275B BINARY4_0p01]
  Actuator5-9 Real Force	[L2-00B2 736 00B25AC BINARY4_0p01]
  Actuator5-9 CMD Force	[L2-00B2 740 00B275C BINARY4_0p01]
  Actuator5-10 Real Force	[L2-00B2 744 00B25AD BINARY4_0p01]
  Actuator5-10 CMD Force	[L2-00B2 748 00B275D BINARY4_0p01]
  Actuator5-11 Real Force	[L2-00B2 752 00B25AE BINARY4_0p01]
  Actuator5-11 CMD Force	[L2-00B2 756 00B275E BINARY4_0p01]
  Actuator5-12 Real Force	[L2-00B2 760 00B25AF BINARY4_0p01]
  Actuator5-12 CMD Force	[L2-00B2 764 00B275F BINARY4_0p01]
  Actuator5-13 Real Force	[L2-00B2 768 00B25B0 BINARY4_0p01]
  Actuator5-13 CMD Force	[L2-00B2 772 00B2760 BINARY4_0p01]
  Actuator5-14 Real Force	[L2-00B2 776 00B25B1 BINARY4_0p01]
  Actuator5-14 CMD Force	[L2-00B2 780 00B2761 BINARY4_0p01]
  Actuator5-15 Real Force	[L2-00B2 784 00B25B2 BINARY4_0p01]
  Actuator5-15 CMD Force	[L2-00B2 788 00B2762 BINARY4_0p01]
  Actuator5-16 Real Force	[L2-00B2 792 00B25B3 BINARY4_0p01]
  Actuator5-16 CMD Force	[L2-00B2 796 00B2763 BINARY4_0p01]
  Actuator5-17 Real Force	[L2-00B2 800 00B25B4 BINARY4_0p01]
  Actuator5-17 CMD Force	[L2-00B2 804 00B2764 BINARY4_0p01]
  Actuator5-18 Real Force	[L2-00B2 808 00B25B5 BINARY4_0p01]
  Actuator5-18 CMD Force	[L2-00B2 812 00B2765 BINARY4_0p01]
  Actuator5-19 Real Force	[L2-00B2 816 00B25B6 BINARY4_0p01]
  Actuator5-19 CMD Force	[L2-00B2 820 00B2766 BINARY4_0p01]
  Actuator5-20 Real Force	[L2-00B2 824 00B25B7 BINARY4_0p01]
  Actuator5-20 CMD Force	[L2-00B2 828 00B2767 BINARY4_0p01]
  Actuator5-21 Real Force	[L2-00B2 832 00B25B8 BINARY4_0p01]
  Actuator5-21 CMD Force	[L2-00B2 836 00B2768 BINARY4_0p01]
  Actuator5-22 Real Force	[L2-00B2 840 00B25B9 BINARY4_0p01]
  Actuator5-22 CMD Force	[L2-00B2 844 00B2769 BINARY4_0p01]
  Actuator5-23 Real Force	[L2-00B2 848 00B25BA BINARY4_0p01]
  Actuator5-23 CMD Force	[L2-00B2 852 00B276A BINARY4_0p01]
  Actuator5-24 Real Force	[L2-00B2 856 00B25BB BINARY4_0p01]
  Actuator5-24 CMD Force	[L2-00B2 860 00B276B BINARY4_0p01]
  Actuator5-25 Real Force	[L2-00B2 864 00B25BC BINARY4_0p01]
  Actuator5-25 CMD Force	[L2-00B2 868 00B276C BINARY4_0p01]
  Actuator5-26 Real Force	[L2-00B2 872 00B25BD BINARY4_0p01]
  Actuator5-26 CMD Force	[L2-00B2 876 00B276D BINARY4_0p01]
  Actuator5-27 Real Force	[L2-00B2 880 00B25BE BINARY4_0p01]
  Actuator5-27 CMD Force	[L2-00B2 884 00B276E BINARY4_0p01]
  Actuator5-28 Real Force	[L2-00B2 888 00B25BF BINARY4_0p01]
  Actuator5-28 CMD Force	[L2-00B2 892 00B276F BINARY4_0p01]
  Actuator5-29 Real Force	[L2-00B2 896 00B25C0 BINARY4_0p01]
  Actuator5-29 CMD Force	[L2-00B2 900 00B2770 BINARY4_0p01]
  Actuator5-30 Real Force	[L2-00B2 904 00B25C1 BINARY4_0p01]
  Actuator5-30 CMD Force	[L2-00B2 908 00B2771 BINARY4_0p01]
  Actuator5-31 Real Force	[L2-00B2 912 00B25C2 BINARY4_0p01]
  Actuator5-31 CMD Force	[L2-00B2 916 00B2772 BINARY4_0p01]
  Actuator5-32 Real Force	[L2-00B2 920 00B25C3 BINARY4_0p01]
  Actuator5-32 CMD Force	[L2-00B2 924 00B2773 BINARY4_0p01]
  Actuator5-33 Real Force	[L2-00B2 928 00B25C4 BINARY4_0p01]
  Actuator5-33 CMD Force	[L2-00B2 932 00B2774 BINARY4_0p01]
  Actuator5-34 Real Force	[L2-00B2 936 00B25C5 BINARY4_0p01]
  Actuator5-34 CMD Force	[L2-00B2 940 00B2775 BINARY4_0p01]
  Actuator5-35 Real Force	[L2-00B2 944 00B25C6 BINARY4_0p01]
  Actuator5-35 CMD Force	[L2-00B2 948 00B2776 BINARY4_0p01]
  Actuator5-36 Real Force	[L2-00B2 952 00B25C7 BINARY4_0p01]
  Actuator5-36 CMD Force	[L2-00B2 956 00B2777 BINARY4_0p01]
  Actuator6-1 Real Force	[L2-00B2 960 00B25C8 BINARY4_0p01]
  Actuator6-1 CMD Force	[L2-00B2 964 00B2778 BINARY4_0p01]
  Actuator6-2 Real Force	[L2-00B2 968 00B25C9 BINARY4_0p01]
  Actuator6-2 CMD Force	[L2-00B2 972 00B2779 BINARY4_0p01]
  Actuator6-3 Real Force	[L2-00B2 976 00B25CA BINARY4_0p01]
  Actuator6-3 CMD Force	[L2-00B2 980 00B277A BINARY4_0p01]
  Actuator6-4 Real Force	[L2-00B2 984 00B25CB BINARY4_0p01]
  Actuator6-4 CMD Force	[L2-00B2 988 00B277B BINARY4_0p01]
  Actuator6-5 Real Force	[L2-00B2 992 00B25CC BINARY4_0p01]
  Actuator6-5 CMD Force	[L2-00B2 996 00B277C BINARY4_0p01]
  Actuator6-6 Real Force	[L2-00B2 1000 00B25CD BINARY4_0p01]
  Actuator6-6 CMD Force	[L2-00B2 1004 00B277D BINARY4_0p01]
  Actuator6-7 Real Force	[L2-00B2 1008 00B25CE BINARY4_0p01]
  Actuator6-7 CMD Force	[L2-00B2 1012 00B277E BINARY4_0p01]
  Actuator6-8 Real Force	[L2-00B2 1016 00B25CF BINARY4_0p01]
  Actuator6-8 CMD Force	[L2-00B2 1020 00B277F BINARY4_0p01]
  Actuator6-9 Real Force	[L2-00B2 1024 00B25D0 BINARY4_0p01]
  Actuator6-9 CMD Force	[L2-00B2 1028 00B2780 BINARY4_0p01]
  Actuator6-10 Real Force	[L2-00B2 1032 00B25D1 BINARY4_0p01]
  Actuator6-10 CMD Force	[L2-00B2 1036 00B2781 BINARY4_0p01]
  Actuator6-11 Real Force	[L2-00B2 1040 00B25D2 BINARY4_0p01]
  Actuator6-11 CMD Force	[L2-00B2 1044 00B2782 BINARY4_0p01]
  Actuator6-12 Real Force	[L2-00B2 1048 00B25D3 BINARY4_0p01]
  Actuator6-12 CMD Force	[L2-00B2 1052 00B2783 BINARY4_0p01]
  Actuator6-13 Real Force	[L2-00B2 1056 00B25D4 BINARY4_0p01]
  Actuator6-13 CMD Force	[L2-00B2 1060 00B2784 BINARY4_0p01]
  Actuator6-14 Real Force	[L2-00B2 1064 00B25D5 BINARY4_0p01]
  Actuator6-14 CMD Force	[L2-00B2 1068 00B2785 BINARY4_0p01]
  Actuator6-15 Real Force	[L2-00B2 1072 00B25D6 BINARY4_0p01]
  Actuator6-15 CMD Force	[L2-00B2 1076 00B2786 BINARY4_0p01]
  Actuator6-16 Real Force	[L2-00B2 1080 00B25D7 BINARY4_0p01]
  Actuator6-16 CMD Force	[L2-00B2 1084 00B2787 BINARY4_0p01]
  Actuator6-17 Real Force	[L2-00B2 1088 00B25D8 BINARY4_0p01]
  Actuator6-17 CMD Force	[L2-00B2 1092 00B2788 BINARY4_0p01]
  Actuator6-18 Real Force	[L2-00B2 1096 00B25D9 BINARY4_0p01]
  Actuator6-18 CMD Force	[L2-00B2 1100 00B2789 BINARY4_0p01]
  Actuator6-19 Real Force	[L2-00B2 1104 00B25DA BINARY4_0p01]
  Actuator6-19 CMD Force	[L2-00B2 1108 00B278A BINARY4_0p01]
  Actuator6-20 Real Force	[L2-00B2 1112 00B25DB BINARY4_0p01]
  Actuator6-20 CMD Force	[L2-00B2 1116 00B278B BINARY4_0p01]
  Actuator6-21 Real Force	[L2-00B2 1120 00B25DC BINARY4_0p01]
  Actuator6-21 CMD Force	[L2-00B2 1124 00B278C BINARY4_0p01]
  Actuator6-22 Real Force	[L2-00B2 1128 00B25DD BINARY4_0p01]
  Actuator6-22 CMD Force	[L2-00B2 1132 00B278D BINARY4_0p01]
  Actuator6-23 Real Force	[L2-00B2 1136 00B25DE BINARY4_0p01]
  Actuator6-23 CMD Force	[L2-00B2 1140 00B278E BINARY4_0p01]
  Actuator6-24 Real Force	[L2-00B2 1144 00B25DF BINARY4_0p01]
  Actuator6-24 CMD Force	[L2-00B2 1148 00B278F BINARY4_0p01]
  Actuator6-25 Real Force	[L2-00B2 1152 00B25E0 BINARY4_0p01]
  Actuator6-25 CMD Force	[L2-00B2 1156 00B2790 BINARY4_0p01]
  Actuator6-26 Real Force	[L3-00B2 0 00B25E1 BINARY4_0p01]
  Actuator6-26 CMD Force	[L3-00B2 4 00B2791 BINARY4_0p01]
  Actuator6-27 Real Force	[L3-00B2 8 00B25E2 BINARY4_0p01]
  Actuator6-27 CMD Force	[L3-00B2 12 00B2792 BINARY4_0p01]
  Actuator6-28 Real Force	[L3-00B2 16 00B25E3 BINARY4_0p01]
  Actuator6-28 CMD Force	[L3-00B2 20 00B2793 BINARY4_0p01]
  Actuator6-29 Real Force	[L3-00B2 24 00B25E4 BINARY4_0p01]
  Actuator6-29 CMD Force	[L3-00B2 28 00B2794 BINARY4_0p01]
  Actuator6-30 Real Force	[L3-00B2 32 00B25E5 BINARY4_0p01]
  Actuator6-30 CMD Force	[L3-00B2 36 00B2795 BINARY4_0p01]
  Actuator6-31 Real Force	[L3-00B2 40 00B25E6 BINARY4_0p01]
  Actuator6-31 CMD Force	[L3-00B2 44 00B2796 BINARY4_0p01]
  Actuator6-32 Real Force	[L3-00B2 48 00B25E7 BINARY4_0p01]
  Actuator6-32 CMD Force	[L3-00B2 52 00B2797 BINARY4_0p01]
  Actuator6-33 Real Force	[L3-00B2 56 00B25E8 BINARY4_0p01]
  Actuator6-33 CMD Force	[L3-00B2 60 00B2798 BINARY4_0p01]
  Actuator6-34 Real Force	[L3-00B2 64 00B25E9 BINARY4_0p01]
  Actuator6-34 CMD Force	[L3-00B2 68 00B2799 BINARY4_0p01]
  Actuator6-35 Real Force	[L3-00B2 72 00B25EA BINARY4_0p01]
  Actuator6-35 CMD Force	[L3-00B2 76 00B279A BINARY4_0p01]
  Actuator6-36 Real Force	[L3-00B2 80 00B25EB BINARY4_0p01]
  Actuator6-36 CMD Force	[L3-00B2 84 00B279B BINARY4_0p01]
  Actuator6-37 Real Force	[L3-00B2 88 00B25EC BINARY4_0p01]
  Actuator6-37 CMD Force	[L3-00B2 92 00B279C BINARY4_0p01]
  Actuator6-38 Real Force	[L3-00B2 96 00B25ED BINARY4_0p01]
  Actuator6-38 CMD Force	[L3-00B2 100 00B279D BINARY4_0p01]
  Actuator6-39 Real Force	[L3-00B2 104 00B25EE BINARY4_0p01]
  Actuator6-39 CMD Force	[L3-00B2 108 00B279E BINARY4_0p01]
  Actuator6-40 Real Force	[L3-00B2 112 00B25EF BINARY4_0p01]
  Actuator6-40 CMD Force	[L3-00B2 116 00B279F BINARY4_0p01]
  Actuator6-41 Real Force	[L3-00B2 120 00B25F0 BINARY4_0p01]
  Actuator6-41 CMD Force	[L3-00B2 124 00B27A0 BINARY4_0p01]
  Actuator6-42 Real Force	[L3-00B2 128 00B25F1 BINARY4_0p01]
  Actuator6-42 CMD Force	[L3-00B2 132 00B27A1 BINARY4_0p01]
  Actuator7-1 Real Force	[L3-00B2 136 00B25F2 BINARY4_0p01]
  Actuator7-1 CMD Force	[L3-00B2 140 00B27A2 BINARY4_0p01]
  Actuator7-2 Real Force	[L3-00B2 144 00B25F3 BINARY4_0p01]
  Actuator7-2 CMD Force	[L3-00B2 148 00B27A3 BINARY4_0p01]
  Actuator7-3 Real Force	[L3-00B2 152 00B25F4 BINARY4_0p01]
  Actuator7-3 CMD Force	[L3-00B2 156 00B27A4 BINARY4_0p01]
  Actuator7-4 Real Force	[L3-00B2 160 00B25F5 BINARY4_0p01]
  Actuator7-4 CMD Force	[L3-00B2 164 00B27A5 BINARY4_0p01]
  Actuator7-5 Real Force	[L3-00B2 168 00B25F6 BINARY4_0p01]
  Actuator7-5 CMD Force	[L3-00B2 172 00B27A6 BINARY4_0p01]
  Actuator7-6 Real Force	[L3-00B2 176 00B25F7 BINARY4_0p01]
  Actuator7-6 CMD Force	[L3-00B2 180 00B27A7 BINARY4_0p01]
  Actuator7-7 Real Force	[L3-00B2 184 00B25F8 BINARY4_0p01]
  Actuator7-7 CMD Force	[L3-00B2 188 00B27A8 BINARY4_0p01]
  Actuator7-8 Real Force	[L3-00B2 192 00B25F9 BINARY4_0p01]
  Actuator7-8 CMD Force	[L3-00B2 196 00B27A9 BINARY4_0p01]
  Actuator7-9 Real Force	[L3-00B2 200 00B25FA BINARY4_0p01]
  Actuator7-9 CMD Force	[L3-00B2 204 00B27AA BINARY4_0p01]
  Actuator7-10 Real Force	[L3-00B2 208 00B25FB BINARY4_0p01]
  Actuator7-10 CMD Force	[L3-00B2 212 00B27AB BINARY4_0p01]
  Actuator7-11 Real Force	[L3-00B2 216 00B25FC BINARY4_0p01]
  Actuator7-11 CMD Force	[L3-00B2 220 00B27AC BINARY4_0p01]
  Actuator7-12 Real Force	[L3-00B2 224 00B25FD BINARY4_0p01]
  Actuator7-12 CMD Force	[L3-00B2 228 00B27AD BINARY4_0p01]
  Actuator7-13 Real Force	[L3-00B2 232 00B25FE BINARY4_0p01]
  Actuator7-13 CMD Force	[L3-00B2 236 00B27AE BINARY4_0p01]
  Actuator7-14 Real Force	[L3-00B2 240 00B25FF BINARY4_0p01]
  Actuator7-14 CMD Force	[L3-00B2 244 00B27AF BINARY4_0p01]
  Actuator7-15 Real Force	[L3-00B2 248 00B2600 BINARY4_0p01]
  Actuator7-15 CMD Force	[L3-00B2 252 00B27B0 BINARY4_0p01]
  Actuator7-16 Real Force	[L3-00B2 256 00B2601 BINARY4_0p01]
  Actuator7-16 CMD Force	[L3-00B2 260 00B27B1 BINARY4_0p01]
  Actuator7-17 Real Force	[L3-00B2 264 00B2602 BINARY4_0p01]
  Actuator7-17 CMD Force	[L3-00B2 268 00B27B2 BINARY4_0p01]
  Actuator7-18 Real Force	[L3-00B2 272 00B2603 BINARY4_0p01]
  Actuator7-18 CMD Force	[L3-00B2 276 00B27B3 BINARY4_0p01]
  Actuator7-19 Real Force	[L3-00B2 280 00B2604 BINARY4_0p01]
  Actuator7-19 CMD Force	[L3-00B2 284 00B27B4 BINARY4_0p01]
  Actuator7-20 Real Force	[L3-00B2 288 00B2605 BINARY4_0p01]
  Actuator7-20 CMD Force	[L3-00B2 292 00B27B5 BINARY4_0p01]
  Actuator7-21 Real Force	[L3-00B2 296 00B2606 BINARY4_0p01]
  Actuator7-21 CMD Force	[L3-00B2 300 00B27B6 BINARY4_0p01]
  Actuator7-22 Real Force	[L3-00B2 304 00B2607 BINARY4_0p01]
  Actuator7-22 CMD Force	[L3-00B2 308 00B27B7 BINARY4_0p01]
  Actuator7-23 Real Force	[L3-00B2 312 00B2608 BINARY4_0p01]
  Actuator7-23 CMD Force	[L3-00B2 316 00B27B8 BINARY4_0p01]
  Actuator7-24 Real Force	[L3-00B2 320 00B2609 BINARY4_0p01]
  Actuator7-24 CMD Force	[L3-00B2 324 00B27B9 BINARY4_0p01]
  Actuator7-25 Real Force	[L3-00B2 328 00B260A BINARY4_0p01]
  Actuator7-25 CMD Force	[L3-00B2 332 00B27BA BINARY4_0p01]
  Actuator7-26 Real Force	[L3-00B2 336 00B260B BINARY4_0p01]
  Actuator7-26 CMD Force	[L3-00B2 340 00B27BB BINARY4_0p01]
  Actuator7-27 Real Force	[L3-00B2 344 00B260C BINARY4_0p01]
  Actuator7-27 CMD Force	[L3-00B2 348 00B27BC BINARY4_0p01]
  Actuator7-28 Real Force	[L3-00B2 352 00B260D BINARY4_0p01]
  Actuator7-28 CMD Force	[L3-00B2 356 00B27BD BINARY4_0p01]
  Actuator7-29 Real Force	[L3-00B2 360 00B260E BINARY4_0p01]
  Actuator7-29 CMD Force	[L3-00B2 364 00B27BE BINARY4_0p01]
  Actuator7-30 Real Force	[L3-00B2 368 00B260F BINARY4_0p01]
  Actuator7-30 CMD Force	[L3-00B2 372 00B27BF BINARY4_0p01]
  Actuator7-31 Real Force	[L3-00B2 376 00B2610 BINARY4_0p01]
  Actuator7-31 CMD Force	[L3-00B2 380 00B27C0 BINARY4_0p01]
  Actuator7-32 Real Force	[L3-00B2 384 00B2611 BINARY4_0p01]
  Actuator7-32 CMD Force	[L3-00B2 388 00B27C1 BINARY4_0p01]
  Actuator7-33 Real Force	[L3-00B2 392 00B2612 BINARY4_0p01]
  Actuator7-33 CMD Force	[L3-00B2 396 00B27C2 BINARY4_0p01]
  Actuator7-34 Real Force	[L3-00B2 400 00B2613 BINARY4_0p01]
  Actuator7-34 CMD Force	[L3-00B2 404 00B27C3 BINARY4_0p01]
  Actuator7-35 Real Force	[L3-00B2 408 00B2614 BINARY4_0p01]
  Actuator7-35 CMD Force	[L3-00B2 412 00B27C4 BINARY4_0p01]
  Actuator7-36 Real Force	[L3-00B2 416 00B2615 BINARY4_0p01]
  Actuator7-36 CMD Force	[L3-00B2 420 00B27C5 BINARY4_0p01]
  Actuator7-37 Real Force	[L3-00B2 424 00B2616 BINARY4_0p01]
  Actuator7-37 CMD Force	[L3-00B2 428 00B27C6 BINARY4_0p01]
  Actuator7-38 Real Force	[L3-00B2 432 00B2617 BINARY4_0p01]
  Actuator7-38 CMD Force	[L3-00B2 436 00B27C7 BINARY4_0p01]
  Actuator7-39 Real Force	[L3-00B2 440 00B2618 BINARY4_0p01]
  Actuator7-39 CMD Force	[L3-00B2 444 00B27C8 BINARY4_0p01]
  Actuator7-40 Real Force	[L3-00B2 448 00B2619 BINARY4_0p01]
  Actuator7-40 CMD Force	[L3-00B2 452 00B27C9 BINARY4_0p01]
  Actuator7-41 Real Force	[L3-00B2 456 00B261A BINARY4_0p01]
  Actuator7-41 CMD Force	[L3-00B2 460 00B27CA BINARY4_0p01]
  Actuator7-42 Real Force	[L3-00B2 464 00B261B BINARY4_0p01]
  Actuator7-42 CMD Force	[L3-00B2 468 00B27CB BINARY4_0p01]
  Actuator7-43 Real Force	[L3-00B2 472 00B261C BINARY4_0p01]
  Actuator7-43 CMD Force	[L3-00B2 476 00B27CC BINARY4_0p01]
  Actuator7-44 Real Force	[L3-00B2 480 00B261D BINARY4_0p01]
  Actuator7-44 CMD Force	[L3-00B2 484 00B27CD BINARY4_0p01]
  Actuator7-45 Real Force	[L3-00B2 488 00B261E BINARY4_0p01]
  Actuator7-45 CMD Force	[L3-00B2 492 00B27CE BINARY4_0p01]
  Actuator7-46 Real Force	[L3-00B2 496 00B261F BINARY4_0p01]
  Actuator7-46 CMD Force	[L3-00B2 500 00B27CF BINARY4_0p01]
  Actuator7-47 Real Force	[L3-00B2 504 00B2620 BINARY4_0p01]
  Actuator7-47 CMD Force	[L3-00B2 508 00B27D0 BINARY4_0p01]
  Actuator7-48 Real Force	[L3-00B2 512 00B2621 BINARY4_0p01]
  Actuator7-48 CMD Force	[L3-00B2 516 00B27D1 BINARY4_0p01]
  Actuator8-1 Real Force	[L3-00B2 520 00B2622 BINARY4_0p01]
  Actuator8-1 CMD Force	[L3-00B2 524 00B27D2 BINARY4_0p01]
  Actuator8-2 Real Force	[L3-00B2 528 00B2623 BINARY4_0p01]
  Actuator8-2 CMD Force	[L3-00B2 532 00B27D3 BINARY4_0p01]
  Actuator8-3 Real Force	[L3-00B2 536 00B2624 BINARY4_0p01]
  Actuator8-3 CMD Force	[L3-00B2 540 00B27D4 BINARY4_0p01]
  Actuator8-4 Real Force	[L3-00B2 544 00B2625 BINARY4_0p01]
  Actuator8-4 CMD Force	[L3-00B2 548 00B27D5 BINARY4_0p01]
  Actuator8-5 Real Force	[L3-00B2 552 00B2626 BINARY4_0p01]
  Actuator8-5 CMD Force	[L3-00B2 556 00B27D6 BINARY4_0p01]
  Actuator8-6 Real Force	[L3-00B2 560 00B2627 BINARY4_0p01]
  Actuator8-6 CMD Force	[L3-00B2 564 00B27D7 BINARY4_0p01]
  Actuator8-7 Real Force	[L3-00B2 568 00B2628 BINARY4_0p01]
  Actuator8-7 CMD Force	[L3-00B2 572 00B27D8 BINARY4_0p01]
  Actuator8-8 Real Force	[L3-00B2 576 00B2629 BINARY4_0p01]
  Actuator8-8 CMD Force	[L3-00B2 580 00B27D9 BINARY4_0p01]
  Actuator8-9 Real Force	[L3-00B2 584 00B262A BINARY4_0p01]
  Actuator8-9 CMD Force	[L3-00B2 588 00B27DA BINARY4_0p01]
  Actuator8-10 Real Force	[L3-00B2 592 00B262B BINARY4_0p01]
  Actuator8-10 CMD Force	[L3-00B2 596 00B27DB BINARY4_0p01]
  Actuator8-11 Real Force	[L3-00B2 600 00B262C BINARY4_0p01]
  Actuator8-11 CMD Force	[L3-00B2 604 00B27DC BINARY4_0p01]
  Actuator8-12 Real Force	[L3-00B2 608 00B262D BINARY4_0p01]
  Actuator8-12 CMD Force	[L3-00B2 612 00B27DD BINARY4_0p01]
  Actuator8-13 Real Force	[L3-00B2 616 00B262E BINARY4_0p01]
  Actuator8-13 CMD Force	[L3-00B2 620 00B27DE BINARY4_0p01]
  Actuator8-14 Real Force	[L3-00B2 624 00B262F BINARY4_0p01]
  Actuator8-14 CMD Force	[L3-00B2 628 00B27DF BINARY4_0p01]
  Actuator8-15 Real Force	[L3-00B2 632 00B2630 BINARY4_0p01]
  Actuator8-15 CMD Force	[L3-00B2 636 00B27E0 BINARY4_0p01]
  Actuator8-16 Real Force	[L3-00B2 640 00B2631 BINARY4_0p01]
  Actuator8-16 CMD Force	[L3-00B2 644 00B27E1 BINARY4_0p01]
  Actuator8-17 Real Force	[L3-00B2 648 00B2632 BINARY4_0p01]
  Actuator8-17 CMD Force	[L3-00B2 652 00B27E2 BINARY4_0p01]
  Actuator8-18 Real Force	[L3-00B2 656 00B2633 BINARY4_0p01]
  Actuator8-18 CMD Force	[L3-00B2 660 00B27E3 BINARY4_0p01]
  Actuator8-19 Real Force	[L3-00B2 664 00B2634 BINARY4_0p01]
  Actuator8-19 CMD Force	[L3-00B2 668 00B27E4 BINARY4_0p01]
  Actuator8-20 Real Force	[L3-00B2 672 00B2635 BINARY4_0p01]
  Actuator8-20 CMD Force	[L3-00B2 676 00B27E5 BINARY4_0p01]
  Actuator8-21 Real Force	[L3-00B2 680 00B2636 BINARY4_0p01]
  Actuator8-21 CMD Force	[L3-00B2 684 00B27E6 BINARY4_0p01]
  Actuator8-22 Real Force	[L3-00B2 688 00B2637 BINARY4_0p01]
  Actuator8-22 CMD Force	[L3-00B2 692 00B27E7 BINARY4_0p01]
  Actuator8-23 Real Force	[L3-00B2 696 00B2638 BINARY4_0p01]
  Actuator8-23 CMD Force	[L3-00B2 700 00B27E8 BINARY4_0p01]
  Actuator8-24 Real Force	[L3-00B2 704 00B2639 BINARY4_0p01]
  Actuator8-24 CMD Force	[L3-00B2 708 00B27E9 BINARY4_0p01]
  Actuator8-25 Real Force	[L3-00B2 712 00B263A BINARY4_0p01]
  Actuator8-25 CMD Force	[L3-00B2 716 00B27EA BINARY4_0p01]
  Actuator8-26 Real Force	[L3-00B2 720 00B263B BINARY4_0p01]
  Actuator8-26 CMD Force	[L3-00B2 724 00B27EB BINARY4_0p01]
  Actuator8-27 Real Force	[L3-00B2 728 00B263C BINARY4_0p01]
  Actuator8-27 CMD Force	[L3-00B2 732 00B27EC BINARY4_0p01]
  Actuator8-28 Real Force	[L3-00B2 736 00B263D BINARY4_0p01]
  Actuator8-28 CMD Force	[L3-00B2 740 00B27ED BINARY4_0p01]
  Actuator8-29 Real Force	[L3-00B2 744 00B263E BINARY4_0p01]
  Actuator8-29 CMD Force	[L3-00B2 748 00B27EE BINARY4_0p01]
  Actuator8-30 Real Force	[L3-00B2 752 00B263F BINARY4_0p01]
  Actuator8-30 CMD Force	[L3-00B2 756 00B27EF BINARY4_0p01]
  Actuator8-31 Real Force	[L3-00B2 760 00B2640 BINARY4_0p01]
  Actuator8-31 CMD Force	[L3-00B2 764 00B27F0 BINARY4_0p01]
  Actuator8-32 Real Force	[L3-00B2 768 00B2641 BINARY4_0p01]
  Actuator8-32 CMD Force	[L3-00B2 772 00B27F1 BINARY4_0p01]
  Actuator8-33 Real Force	[L3-00B2 776 00B2642 BINARY4_0p01]
  Actuator8-33 CMD Force	[L3-00B2 780 00B27F2 BINARY4_0p01]
  Actuator8-34 Real Force	[L3-00B2 784 00B2643 BINARY4_0p01]
  Actuator8-34 CMD Force	[L3-00B2 788 00B27F3 BINARY4_0p01]
  Actuator8-35 Real Force	[L3-00B2 792 00B2644 BINARY4_0p01]
  Actuator8-35 CMD Force	[L3-00B2 796 00B27F4 BINARY4_0p01]
  Actuator8-36 Real Force	[L3-00B2 800 00B2645 BINARY4_0p01]
  Actuator8-36 CMD Force	[L3-00B2 804 00B27F5 BINARY4_0p01]
  Actuator8-37 Real Force	[L3-00B2 808 00B2646 BINARY4_0p01]
  Actuator8-37 CMD Force	[L3-00B2 812 00B27F6 BINARY4_0p01]
  Actuator8-38 Real Force	[L3-00B2 816 00B2647 BINARY4_0p01]
  Actuator8-38 CMD Force	[L3-00B2 820 00B27F7 BINARY4_0p01]
  Actuator8-39 Real Force	[L3-00B2 824 00B2648 BINARY4_0p01]
  Actuator8-39 CMD Force	[L3-00B2 828 00B27F8 BINARY4_0p01]
  Actuator8-40 Real Force	[L3-00B2 832 00B2649 BINARY4_0p01]
  Actuator8-40 CMD Force	[L3-00B2 836 00B27F9 BINARY4_0p01]
  Actuator8-41 Real Force	[L3-00B2 840 00B264A BINARY4_0p01]
  Actuator8-41 CMD Force	[L3-00B2 844 00B27FA BINARY4_0p01]
  Actuator8-42 Real Force	[L3-00B2 848 00B264B BINARY4_0p01]
  Actuator8-42 CMD Force	[L3-00B2 852 00B27FB BINARY4_0p01]
  Actuator8-43 Real Force	[L3-00B2 856 00B264C BINARY4_0p01]
  Actuator8-43 CMD Force	[L3-00B2 860 00B27FC BINARY4_0p01]
  Actuator8-44 Real Force	[L3-00B2 864 00B264D BINARY4_0p01]
  Actuator8-44 CMD Force	[L3-00B2 868 00B27FD BINARY4_0p01]
  Actuator8-45 Real Force	[L3-00B2 872 00B264E BINARY4_0p01]
  Actuator8-45 CMD Force	[L3-00B2 876 00B27FE BINARY4_0p01]
  Actuator8-46 Real Force	[L3-00B2 880 00B264F BINARY4_0p01]
  Actuator8-46 CMD Force	[L3-00B2 884 00B27FF BINARY4_0p01]
  Actuator8-47 Real Force	[L3-00B2 888 00B2650 BINARY4_0p01]
  Actuator8-47 CMD Force	[L3-00B2 892 00B2800 BINARY4_0p01]
  Actuator8-48 Real Force	[L3-00B2 896 00B2651 BINARY4_0p01]
  Actuator8-48 CMD Force	[L3-00B2 900 00B2801 BINARY4_0p01]
  Actuator8-49 Real Force	[L3-00B2 904 00B2652 BINARY4_0p01]
  Actuator8-49 CMD Force	[L3-00B2 908 00B2802 BINARY4_0p01]
  Actuator8-50 Real Force	[L3-00B2 912 00B2653 BINARY4_0p01]
  Actuator8-50 CMD Force	[L3-00B2 916 00B2803 BINARY4_0p01]
  Actuator8-51 Real Force	[L3-00B2 920 00B2654 BINARY4_0p01]
  Actuator8-51 CMD Force	[L3-00B2 924 00B2804 BINARY4_0p01]
  PMFXS8-61 Real Force	[L3-00B2 928 00B2655 BINARY4_0p01]
  PMFXS8-62 Real Force	[L3-00B2 932 00B2656 BINARY4_0p01]
  PMFXS8-63 Real Force	[L3-00B2 936 00B2657 BINARY4_0p01]
  PMFXS8-58 Temp MON1 Data	[L3-00B2 940 00B2660 BINARY2_0p1]
  PMFXS8-58 Temp MON2 Data	[L3-00B2 942 00B2661 BINARY2_0p1]
  PMFXS8-58 Temp MON3 Data	[L3-00B2 944 00B2662 BINARY2_0p1]
  PMFXS8-58 Temp MON4 Data	[L3-00B2 946 00B2663 BINARY2_0p1]
  PMFXS8-58 Temp MON5 Data	[L3-00B2 948 00B2664 BINARY2_0p1]
  PMFXS8-58 Temp MON6 Data	[L3-00B2 950 00B2665 BINARY2_0p1]
  PMFXS8-59 Temp MON1 Data	[L3-00B2 952 00B2666 BINARY2_0p1]
  PMFXS8-59 Temp MON2 Data	[L3-00B2 954 00B2667 BINARY2_0p1]
  PMFXS8-59 Temp MON3 Data	[L3-00B2 956 00B2668 BINARY2_0p1]
  PMFXS8-59 Temp MON4 Data	[L3-00B2 958 00B2669 BINARY2_0p1]
  PMFXS8-59 Temp MON5 Data	[L3-00B2 960 00B266A BINARY2_0p1]
  PMFXS8-59 Temp MON6 Data	[L3-00B2 962 00B266B BINARY2_0p1]
  PMFXS8-60 Temp MON1 Data	[L3-00B2 964 00B266C BINARY2_0p1]
  PMFXS8-60 Temp MON2 Data	[L3-00B2 966 00B266D BINARY2_0p1]
  PMFXS8-60 Temp MON3 Data	[L3-00B2 968 00B266E BINARY2_0p1]
  PMFXS8-60 Temp MON4 Data	[L3-00B2 970 00B266F BINARY2_0p1]
  PMFXS8-60 Temp MON5 Data	[L3-00B2 972 00B2670 BINARY2_0p1]
  PMFXS8-60 Temp MON6 Data	[L3-00B2 974 00B2671 BINARY2_0p1]
  SH I/F TX Last Access TIME	[L3-00B2 976 00B2140 TIME3]
  SH I/F RX Last Access TIME	[L3-00B2 979 00B2142 TIME3]
  SH I/F Error Code	[L3-00B2 982 00B2141 str]
  PMA/MFXS I/F TX Last Access Time	[L3-00B2 984 00B2144 TIME3]
  PMA/PMFXS I/F RX Last Access Time	[L3-00B2 987 00B2146 TIME3]
  Actuator/PMFXS I/F Error Code	[L3-00B2 990 00B2145 str]
  2nd Mirror I/F TX Last Access Time	[L3-00B2 992 00B2148 TIME3]
  2nd Mirror I/F RX Last Access Time	[L3-00B2 995 00B214A TIME3]
  2nd Mirror I/F Error Code	[L3-00B2 998 00B2149 str]
  PFCU I/F TX Last Access Time	[L3-00B2 1000 00B214C TIME3]
  PFCU I/F RX Last Access Time	[L3-00B2 1003 00B214E TIME3]
  PFCU I/F Error Code	[L3-00B2 1006 00B214D str]
  Mount I/F TX Last Access Time	[L3-00B2 1008 00B2150 TIME3]
  Mount I/F RX Last Access Time	[L3-00B2 1011 00B2152 TIME3]
  Mount I/F Error Code	[L3-00B2 1014 00B2151 str]
  PMFXS8-61 Real Force(Temp)	[L3-00B2 1016 00B2915 BINARY4_0p01]
  PMFXS8-62 Real Force(Temp)	[L3-00B2 1020 00B2916 BINARY4_0p01]
  PMFXS8-63 Real Force(Temp)	[L3-00B2 1024 00B2917 BINARY4_0p01]
  Actuator CMD Sum.	[L3-00B2 1028 00B2918 BINARY4_0p01]
  PMFXS8-61 FFB CMD	[L3-00B2 1032 00B2919 BINARY4_0p01]
  PMFXS8-62 FFB CMD	[L3-00B2 1036 00B291A BINARY4_0p01]
  PMFXS8-63 FFB CMD	[L3-00B2 1040 00B291B BINARY4_0p01]
  EL Real Angle(From MLP2)	[L3-00B2 1044 00B291D BCD6]
  Actuator Real Force Sum.	[L3-00B2 1050 00B2928 BINARY4_0p01]
  PMFXS Real Force Sum.	[L3-00B2 1054 00B2929 BINARY4_0p01]
  Actuator/PMFXS Real Force Sum.	[L3-00B2 1058 00B292A BINARY4_0p01]
  MLP3 OPN	[E-00B3 0:0 00B3001]
  MLP3 STBY	[E-00B3 0:1 00B3002]
  MLP3 Fault on MLP3	[E-00B3 0:2 00B3003]
  M-LAN I/F Alarm	[E-00B3 1:0 00B3004]
  TSC Fault IND on MLP3	[E-00B3 1:1 00B3005]
  Time Correction Alarm(MLP3 IND)	[E-00B3 1:5 00B3025]
  1s INT Alarm(MLP3 IND)	[E-00B3 1:6 00B3044]
  100ms INT Alarm(MLP3 IND)	[E-00B3 1:7 00B3045]
  3rd Mirror-MLP3 Fault	[E-00B3 2:0 00B3006]
  Cover-MLP3 Fault	[E-00B3 2:1 00B3007]
  MCP2-MLP3 Fault	[E-00B3 2:2 00B3008]
  Weather-MLP3 Fault	[E-00B3 2:3 00B3009]
  Cal Source - MLP3 Fault	[E-00B3 2:4 00B300A]
  SPU4-MLP3 Fault	[E-00B3 2:5 00B300C]
  SPU5-MLP3 Fault	[E-00B3 2:6 00B305C]
  Dome CT2-MLP3 Fault	[E-00B3 2:7 00B300D]
  TLSCP CT2-MLP3 Fault	[E-00B3 3:0 00B300E]
  Dome ENVIR-MLP3 Fault	[E-00B3 3:1 00B300F]
  TLSCP ENVIR-MLP3 Fault	[E-00B3 3:2 00B3010]
  MCP1-MLP3 Fault	[E-00B3 3:3 00B3011]
  Heat Exh(Mirror)-MLP3 Fault	[E-00B3 3:4 00B3012]
  Heat Exh(PUMP) Fault	[E-00B3 3:5 00B30A2]
  Cs Bolt - MLP3 Fault	[E-00B3 3:6 00B300B]
  SPU6-MLP3 Fault	[E-00B3 3:7 00B305D]
  MLP3 CMPL IND	[E-00B3 4:0 00B3013]
  Dome Flat(Power)-MLP3 Fault	[E-00B3 4:1 00B317F]
  Dome Flat(Temp)-MLP3 Fault	[E-00B3 4:2 00B3180]
  Chiller-B - MLP3 Fault	[E-00B3 4:3 00B318C]
  CXWS - MLP3 Fault	[E-00B3 4:4 00B318D]
  Heat Exh(RDN) - MLP3 I/F Fault	[E-00B3 4:5 00B3192]
  Dome WIND VEL&DIR CONV PS Fault	[E-00B3 19:0 00B30A6]
  Dome WIND VEL&DIR CONV ADJ	[E-00B3 19:1 00B30A7]
  Dome WIND VEL CONV PS Fault	[E-00B3 19:2 00B30A8]
  Dome WIND VEL CONV ADJ	[E-00B3 19:3 00B30A9]
  Dome HMD CONV PS Fault	[E-00B3 19:4 00B30AA]
  Dome HMD CONV ADJ	[E-00B3 19:5 00B30AB]
  TLSCP HMD CONV1 PS Fault	[E-00B3 20:0 00B30AC]
  TLSCP HMD CONV2 PS Fault	[E-00B3 20:1 00B30AD]
  Panel AP MCB Alarm	[E-00B3 21:0 00B3115]
  ESB ELEV 3F Lobby Door Lock Open	[E-00B3 21:1 00B30D7]
  ESB Small Vertical Door Full Open	[E-00B3 21:2 00B30CF]
  ESB Small Vertical Door Full Close	[E-00B3 21:3 00B30D0]
  ESB Large Vertical Door Full Open	[E-00B3 21:4 00B30D1]
  ESB Large Vertical Door Full Close	[E-00B3 21:5 00B30D2]
  ESB ELEV 3F Lobby Right Door Open	[E-00B3 21:6 00B30B5]
  ESB ELEV 3F Lobby Left Door Open	[E-00B3 21:7 00B30B7]
  ESB 1F ELEV Lobby Side Door Open	[E-00B3 22:0 00B30D3]
  ESB Aluminizing Side Door Open	[E-00B3 22:1 00B30D5]
  ESB Large Vertical Side Door Open	[E-00B3 22:2 00B30AF]
  10M Hatch Opt Full Open	[E-00B3 22:3 00B30D9]
  10M Hatch Opt Full Close	[E-00B3 22:4 00B30DA]
  10M Hatch IR Full Open	[E-00B3 22:5 00B30DB]
  10M Hatch IR Full Close	[E-00B3 22:6 00B30DC]
  ESB MCB-1 Alarm	[E-00B3 22:7 00B30B3]
  ESB MCB-3 Alarm	[E-00B3 23:1 00B30BB]
  ESB MCB-2 Alarm	[E-00B3 23:2 00B30BD]
  ESB Exh/Supply Fan1 On	[E-00B3 23:3 00B3112]
  ESB Exh/Supply Fan2 On	[E-00B3 23:4 00B3114]
  ESB Supply Fan3 On	[E-00B3 23:5 00B3116]
  ESB P101A Main MCB Alarm	[E-00B3 23:6 00B3032]
  P101A MCB Branch PU1 Alarm	[E-00B3 23:7 00B3117]
  P101A MCB Exh Fan1 Alarm	[E-00B3 24:0 00B3104]
  ESB ELEV 2F Lobby Right Door Open	[E-00B3 24:1 00B3177]
  ESB ELEV 2F Lobby Left Door Open	[E-00B3 24:2 00B3178]
  UPS Dome-1 New Alarm	[E-00B3 24:3 00B3197]
  UPS Dome-1 Summary Alarm	[E-00B3 24:4 00B3198]
  UPS Dome-1 Load On Bypass Alarm	[E-00B3 24:5 00B3199]
  UPS Dome-1 Low Battery RVS Alarm	[E-00B3 24:6 00B319A]
  UPS Dome-1 On Battery Alarm	[E-00B3 24:7 00B319B]
  P101A MCB Supply Fan1 Alarm	[E-00B3 25:0 00B3105]
  P101A MCB Exh Fan2 Alarm	[E-00B3 25:1 00B3106]
  P101A MCB Supply Fan2 Alarm	[E-00B3 25:2 00B3107]
  P101A MCB Supply Fan3 Alarm	[E-00B3 25:3 00B3108]
  P101A MCB 3Ton CRANE Alarm	[E-00B3 25:4 00B3109]
  ESB Power BD L101A MCB Alarm	[E-00B3 25:5 00B30C2]
  ESB Power BD L101B MCB Alarm	[E-00B3 25:6 00B30C3]
  ESB Power BD L101E MCB Alarm	[E-00B3 25:7 00B30C4]
  ESB Power BD L101F MCB Alarm	[E-00B3 26:0 00B30C5]
  ESB P101B Main MCB Alarm	[E-00B3 26:1 00B30C6]
  P101B MCB LGE/SM VERT/10M H Alarm	[E-00B3 26:2 00B30B1]
  PDB71 Telescope Cont Shutdown	[E-00B3 26:3 00B3196]
  ESB Door SW-Basement Storage Open	[E-00B3 26:4 00B30CB]
  ESB ELEV MECH Room Door Open	[E-00B3 26:5 00B30C9]
  ESB Cable Room Door Open	[E-00B3 26:6 00B30C7]
  ESB Door SW-Basement Stairwell Open	[E-00B3 26:7 00B30CD]
  CONT BLDG Power DISTR BD P2032 ALM	[E-00B3 27:0 00B3035]
  CONT BLDG Power DISTR BD P2031 ALM	[E-00B3 27:1 00B3034]
  CONT BLDG Power BD L2032 Alarm	[E-00B3 27:2 00B3031]
  CONT BLDG Power BD L2031A Alarm	[E-00B3 27:3 00B302D]
  CONT BLDG Power BD L2031B Alarm	[E-00B3 27:4 00B302E]
  CONT BLDG Power BD L2031C Alarm	[E-00B3 27:5 00B302F]
  CONT BLDG Power BD L2031D Alarm	[E-00B3 27:6 00B3030]
  CONT BLDG 3F Stair Door Open	[E-00B3 27:7 00B30BE]
  CONT BLDG 3F CONN CORR Door Open	[E-00B3 28:0 00B30C0]
  CONT BLDG PAC-1 On	[E-00B3 28:1 00B3179]
  CONT BLDG PAC-1 Alarm	[E-00B3 28:2 00B317A]
  CONT BLDG PAC-2 On	[E-00B3 28:3 00B317B]
  CONT BLDG PAC-2 Alarm	[E-00B3 28:4 00B317C]
  CONT BLDG PAC-3 On	[E-00B3 28:5 00B317D]
  CONT BLDG PAC-3 Alarm	[E-00B3 28:6 00B317E]
  CONT BLDG Power BD L2011A Alarm	[E-00B3 29:0 00B3026]
  CONT BLDG Power BD L2011B Alarm	[E-00B3 29:1 00B3027]
  CONT BLDG Power BD L2011C Alarm	[E-00B3 29:2 00B3028]
  CONT BLDG 1F Stair Door Open	[E-00B3 29:3 00B30AE]
  CONT BLDG 1F MECH Room Door Open	[E-00B3 29:4 00B30B0]
  CONT BLDG 1F MECH Room Door(E) Open	[E-00B3 29:5 00B30B2]
  CONT BLDG 1F GEN Room Door Open	[E-00B3 29:6 00B30B4]
  CONT BLDG 2F ELEV Hall Door Open	[E-00B3 29:7 00B30B6]
  CONT BLDG 2F Stair Door Open	[E-00B3 30:0 00B30B8]
  CONT BLDG 2F MECH WKS Door Open	[E-00B3 30:1 00B30BA]
  CONT BLDG 2F CMPTR Room Door Open	[E-00B3 30:2 00B30BC]
  CONT BLDG Power DISTR BD P2022 ALM	[E-00B3 30:3 00B3033]
  CONT BLDG P2021B MCB Alarm	[E-00B3 30:4 00B30BF]
  CONT BLDG Power BD P2021A Alarm	[E-00B3 30:5 00B3103]
  CONT BLDG Power BD L2021D Alarm	[E-00B3 30:6 00B302C]
  CONT BLDG Power BD L2021C Alarm	[E-00B3 30:7 00B302B]
  CONT BLDG Power BD L2021B Alarm	[E-00B3 31:0 00B302A]
  CONT BLDG Power BD L2021A Alarm	[E-00B3 31:1 00B3029]
  CONT BLDG Power BD P2011A Alarm	[E-00B3 31:2 00B3014]
  CONT BLDG Power BD P2011B Alarm	[E-00B3 31:3 00B3015]
  CONT BLDG Supply Fan1 On	[E-00B3 31:4 00B30ED]
  CONT BLDG Exh Fan1 On	[E-00B3 31:5 00B30EF]
  CONT BLDG Exh Fan3 On	[E-00B3 31:6 00B30F1]
  CONT BLDG Exh Fan2 On	[E-00B3 31:7 00B30F3]
  CONT BLDG HU1 On	[E-00B3 32:0 00B30EB]
  CONT BLDG AIR ELEC Heat1 On	[E-00B3 32:1 00B30F5]
  P2011B MCB Supply Fan1 Alarm	[E-00B3 32:2 00B30F7]
  P2011B MCB Exh Fan1 Alarm	[E-00B3 32:3 00B30F8]
  P2011B MCB Exh Fan3 Alarm	[E-00B3 32:4 00B30F9]
  P2011B MCB Exh Fan2 Alarm	[E-00B3 32:5 00B30FA]
  P2011B MCB HU1 Alarm	[E-00B3 32:6 00B30FB]
  P2011B MCB AIR ELEC Heat1 Alarm	[E-00B3 32:7 00B30FC]
  CONT BLDG Heat Fan4 On	[E-00B3 33:0 00B30E3]
  CONT BLDG Heat Fan5 On	[E-00B3 33:1 00B30E5]
  CONT BLDG Supply Fan2 On	[E-00B3 33:2 00B30E7]
  CONT BLDG Supply Fan3 On	[E-00B3 33:3 00B30E9]
  CONT BLDG Exh Heat Fan1 On	[E-00B3 33:4 00B30DF]
  CONT BLDG Exh Heat Fan2 On	[E-00B3 33:5 00B30E1]
  P2011A MCB PAC1 EVAP/CPRSR Alarm	[E-00B3 33:6 00B310C]
  P2011A MCB PAC1 COND Alarm	[E-00B3 33:7 00B310D]
  P2011A MCB PAC2 EVAP/CPRSR Alarm	[E-00B3 34:0 00B310E]
  P2011A MCB PAC2 COND Alarm	[E-00B3 34:1 00B310F]
  P2011A MCB PAC3 EVAP/CPRSR Alarm	[E-00B3 34:2 00B3110]
  P2011A MCB PAC3 COND Alarm	[E-00B3 34:3 00B3111]
  P2011A MCB Exh Fan4 Alarm	[E-00B3 34:4 00B30FD]
  P2011A MCB Exh Fan5 Alarm	[E-00B3 34:5 00B30FE]
  P2011A MCB Supply Fan2 Alarm	[E-00B3 34:6 00B30FF]
  P2011A MCB Supply Fan3 Alarm	[E-00B3 34:7 00B3100]
  MLP Rack PDB NFB1 Alarm	[E-00B3 35:0 00B30C1]
  MLP Rack PBD NFB2 Alarm	[E-00B3 35:1 00B30C8]
  MLP Rack Fan Alarm	[E-00B3 35:2 00B30CA]
  MLP2 Fan1 Alarm	[E-00B3 35:3 00B30E2]
  MLP2 Fan2 Alarm	[E-00B3 35:4 00B30E4]
  MLP2 Fan3 Alarm	[E-00B3 35:5 00B30E6]
  MLP2 Fan4 Alarm	[E-00B3 35:6 00B30E8]
  MLP2 Fan5 Alarm	[E-00B3 35:7 00B30EA]
  MLP2 Fan6 Alarm	[E-00B3 36:0 00B30EC]
  MLP1 Fan1 Alarm	[E-00B3 36:1 00B30CC]
  MLP1 Fan2 Alarm	[E-00B3 36:2 00B30CE]
  MLP1 Fan3 Alarm	[E-00B3 36:3 00B30D4]
  MLP1 Fan4 Alarm	[E-00B3 36:4 00B30D6]
  MLP1 Fan5 Alarm	[E-00B3 36:5 00B30D8]
  MLP1 Fan6 Alarm	[E-00B3 36:6 00B30E0]
  MLP3 Fan1 Alarm	[E-00B3 37:0 00B30EE]
  MLP3 Fan2 Alarm	[E-00B3 37:1 00B30F0]
  MLP3 Fan3 Alarm	[E-00B3 37:2 00B30F2]
  MLP3 Fan4 Alarm	[E-00B3 37:3 00B30F4]
  MLP3 Fan5 Alarm	[E-00B3 37:4 00B30F6]
  MLP3 Fan6 Alarm	[E-00B3 37:5 00B3113]
  Z(Opt-Rear) OBE Sensed Position	[E-00B3 38:0 00B313D]
  Z(IR-Rear) OBE Sensed Position	[E-00B3 38:1 00B313C]
  Z(Opt-Front) OBE Sensed Position	[E-00B3 38:2 00B313B]
  Z(IR-Front) OBE Sensed Position	[E-00B3 38:3 00B313A]
  InR Cs Bolt Clamping Position(0)	[E-00B3 38:4 00B313F]
  InR Cs Bolt Clearance Position(-4)	[E-00B3 38:5 00B313E]
  Cs Bolt MCB Off	[E-00B3 38:6 00B3141]
  Cs Bolt Power On	[E-00B3 38:7 00B3140]
  P2011A MCB Exh Fan1 Alarm	[E-00B3 39:0 00B3101]
  P2011A MCB Exh Fan2 Alarm	[E-00B3 39:1 00B3102]
  CONT BLDG MECH Room Temp High Alarm	[E-00B3 39:2 00B310A]
  CONT BLDG MECH Room Temp Low Alarm	[E-00B3 39:3 00B310B]
  CONT BLDG CMPTR Room Temp High ALM	[E-00B3 39:4 00B303A]
  CONT BLDG CMPTR Room Temp Low Alarm	[E-00B3 39:5 00B303B]
  CONT BLDG CONT Room Temp High Alarm	[E-00B3 39:6 00B303C]
  CONT BLDG CONT Room Temp Low Alarm	[E-00B3 39:7 00B303D]
  CONT BLDG OBS Room Temp High Alarm	[E-00B3 40:0 00B30DD]
  CONT BLDG OBS Room Temp Low Alarm	[E-00B3 40:1 00B30DE]
  CONT BLDG Oil Tank High Alarm	[E-00B3 40:2 00B3038]
  CONT BLDG Oil Tank Low Alarm	[E-00B3 40:3 00B3039]
  CONT BLDG Water Tank High Alarm	[E-00B3 40:4 00B3036]
  CONT BLDG Water Tank Low Alarm	[E-00B3 40:5 00B3037]
  UPS-1 ATS SW On Select	[E-00B3 40:6 00B3187]
  UPS-1 ATS SW MDB-2 Power Supply	[E-00B3 40:7 00B3188]
  MDB-1 MCB UPS-3 Alarm 2	[E-00B3 41:0 00B314C]
  MDB-1 MCB UPS-3 Alarm 1	[E-00B3 41:1 00B314D]
  MDB-1 MCB L101B Alarm	[E-00B3 41:5 00B3151]
  MDB-1 MCB P2021B Alarm	[E-00B3 41:6 00B3152]
  MDB-1 MCB MCC P101A Alarm	[E-00B3 41:7 00B3153]
  ATS UTIL Power Fail	[E-00B3 42:0 00B3046]
  ATS UTIL Power OPN	[E-00B3 42:1 00B3047]
  ATS EMER Power On	[E-00B3 42:2 00B3048]
  ATS Auto Selected	[E-00B3 42:3 00B3049]
  ATS Man Selected	[E-00B3 42:4 00B304A]
  ATS ENG-GEN Run	[E-00B3 42:5 00B304B]
  MDB-1 MCB MCC P2011A Alarm	[E-00B3 42:6 00B314A]
  MDB-1 MCB MCC P2012A Alarm	[E-00B3 42:7 00B314B]
  FM-200(Fight a Fire) Start	[E-00B3 43:0 00B304E]
  CONT BLDG MCC P2012A Main MCB Alarm	[E-00B3 43:1 00B304F]
  P2012A MCB PAC-4 Unit/Fan Alarm	[E-00B3 43:2 00B3050]
  P2012A MCB PAC-5 Unit/Fan Alarm	[E-00B3 43:3 00B3051]
  P2012A MCB PAC-6 Unit/Fan Alarm	[E-00B3 43:4 00B3052]
  P2012A MCB HU-4 Alarm	[E-00B3 43:5 00B3053]
  CONT BLDG CMPTR Room UND FL HW ALM	[E-00B3 43:6 00B3054]
  CONT BLDG PAC-4 On	[E-00B3 44:0 00B3056]
  CONT BLDG PAC-4 Alarm	[E-00B3 44:1 00B3057]
  CONT BLDG PAC-5 On	[E-00B3 44:2 00B3058]
  CONT BLDG PAC-5 Alarm	[E-00B3 44:3 00B3059]
  CONT BLDG PAC-6 On	[E-00B3 44:4 00B305A]
  CONT BLDG PAC-6 Alarm	[E-00B3 44:5 00B305B]
  MDB-1 MCB MDB-2 Alarm	[E-00B3 44:6 00B3149]
  MDB-1 Main MCB Alarm	[E-00B3 44:7 00B3148]
  MDB-1 MCB L2011/21/31A Alarm	[E-00B3 45:0 00B3154]
  UPS-1 Power D/G Manual Select	[E-00B3 45:1 00B3189]
  MDB-1 MCB MCC-51 Alarm	[E-00B3 45:2 00B3156]
  MDB-1 MCB UPS XFMR BD-1 Alarm 2	[E-00B3 45:3 00B3157]
  MDB-1 MCB UPS XFMR BD-1 Alarm 1	[E-00B3 45:4 00B3158]
  MDB-1 MCB Panel AP Alarm	[E-00B3 45:5 00B3159]
  MDB-1 MCB TR-1 Alarm	[E-00B3 45:6 00B315A]
  MDB-1 TR-1 MCB L2021D/31D Alarm	[E-00B3 45:7 00B315B]
  TCSPU(Cs) Fan Alarm	[E-00B3 46:0 00B3142]
  TCSPU(NsIR) Fan Alarm	[E-00B3 46:1 00B3143]
  TCSPU(NsOpt) Fan Alarm	[E-00B3 46:2 00B3144]
  TCOEU Fan Alarm	[E-00B3 46:3 00B3145]
  TCSGIF CB1 Off	[E-00B3 46:4 00B3146]
  TCSGIF Fan Alarm	[E-00B3 46:5 00B3147]
  MCC-21 Telescope Drive Shutdown	[E-00B3 46:6 00B318A]
  PDB72 Telescope Cont Shutdown	[E-00B3 46:7 00B318B]
  CONT BLDG 1F MCC-11 MCB Alarm	[E-00B3 47:0 00B3021]
  CONT BLDG 2F MCC-21 MCB Alarm	[E-00B3 47:1 00B3022]
  CONT BLDG 3F MCC-31 MCB Alarm	[E-00B3 47:2 00B3023]
  ESB MCC-41 MCB Alarm	[E-00B3 47:3 00B3024]
  ESB MCC-51 MCB Alarm	[E-00B3 47:4 00B3075]
  ESB PDB-61 MCB Alarm	[E-00B3 47:5 00B3076]
  ESB PDB-71 MCB Alarm	[E-00B3 47:6 00B3077]
  ESB PDB-72 MCB Alarm	[E-00B3 47:7 00B3078]
  MDB-1 TR-1 MCB P2021A/22/31A/32 ALM	[E-00B3 48:0 00B315C]
  MDB-2 TR-2 MCB L2011C Alarm	[E-00B3 48:1 00B315D]
  MDB-1 TR-1 MCB L101A Alarm	[E-00B3 48:2 00B315E]
  MDB-1 TR-1 MCB MCC-11 Alarm	[E-00B3 48:3 00B315F]
  MDB-1 TR-1 MCB L2032 Alarm	[E-00B3 48:4 00B3160]
  MDB-2 Main MCB Alarm	[E-00B3 48:5 00B3161]
  MDB-2 MCB MCB-3 Alarm	[E-00B3 48:6 00B3162]
  MDB-2 MCB UPS XFMR BD-1 Alarm 1	[E-00B3 48:7 00B3163]
  Demand CONT Load1 Alarm	[E-00B3 49:0 00B3118]
  Demand CONT Load2 Alarm	[E-00B3 49:1 00B3119]
  Demand CONT Load3 Alarm	[E-00B3 49:2 00B311A]
  Demand CONT Load4 Alarm	[E-00B3 49:3 00B311B]
  Demand CONT Load5 Alarm	[E-00B3 49:4 00B311C]
  Demand CONT Load6 Alarm	[E-00B3 49:5 00B311D]
  Demand CONT Load7 Alarm	[E-00B3 49:6 00B311E]
  Demand CONT Load8 Alarm	[E-00B3 49:7 00B311F]
  Demand CONT Load9 Alarm	[E-00B3 50:0 00B3120]
  Demand CONT Load10 Alarm	[E-00B3 50:1 00B3121]
  Demand CONT Power Alarm	[E-00B3 50:2 00B3122]
  Demand CONT Power Normal	[E-00B3 50:3 00B3123]
  Demand CONT Possible	[E-00B3 50:4 00B3124]
  Demand CONT Impossible	[E-00B3 50:5 00B3125]
  CVCF(UPS1) Converter Operation	[E-00B3 51:0 00B3132]
  CVCF(UPS1) Inverter Operation	[E-00B3 51:1 00B3133]
  CVCF(UPS1) Battery Operation	[E-00B3 51:2 00B3134]
  CVCF(UPS1) Load On Inverter	[E-00B3 51:3 00B3135]
  CVCF(UPS1) Load On Bypass	[E-00B3 51:4 00B3062]
  CVCF(UPS1) Battery Reset(10min)	[E-00B3 51:5 00B3063]
  CVCF(UPS1) Minor Fault	[E-00B3 51:6 00B3064]
  CVCF(UPS1) Major Fault	[E-00B3 51:7 00B3065]
  CVCF(UPS1) XFMR MCB Alarm	[E-00B3 52:0 00B3066]
  CVCF(UPS1) Output BD1 MCB Alarm	[E-00B3 52:1 00B3067]
  CVCF(UPS1) Output BD1 V Alarm	[E-00B3 52:2 00B3068]
  CVCF(UPS2) Converter Operation	[E-00B3 52:4 00B3127]
  CVCF(UPS2) Inverter Operation	[E-00B3 52:5 00B3128]
  CVCF(UPS2) Battery Operation	[E-00B3 52:6 00B3129]
  CVCF(UPS2) Load On Inverter	[E-00B3 52:7 00B312A]
  CVCF(UPS2) Load On Bypass	[E-00B3 53:0 00B312B]
  CVCF(UPS2) Battery Reset(10min)	[E-00B3 53:1 00B312C]
  CVCF(UPS2) Minor Fault	[E-00B3 53:2 00B312D]
  CVCF(UPS2) Major Fault	[E-00B3 53:3 00B312E]
  CVCF(UPS2) XFMR MCB Alarm	[E-00B3 53:4 00B312F]
  CVCF(UPS2) Output BD2 MCB Alarm	[E-00B3 53:5 00B3130]
  CVCF(UPS2) Output BD2 V Alarm	[E-00B3 53:6 00B3131]
  D/G GEN Set Alarm	[E-00B3 54:0 00B306F]
  D/G EN Alarm	[E-00B3 54:1 00B3070]
  D/G Battery CHNG Alarm	[E-00B3 54:2 00B3071]
  D/G Day Tank Level Alarm	[E-00B3 54:3 00B3072]
  MDB-2 MCB UPS CVCF-2 Alarm	[E-00B3 54:4 00B3164]
  MDB-2 MCB Low Temp REFR Alarm	[E-00B3 54:6 00B3166]
  MDB-2 MCB MCC P2011B Alarm	[E-00B3 54:7 00B3167]
  MDB-2 MCB ENCL ELEV Alarm	[E-00B3 55:0 00B3168]
  MDB-2 MCB TR-2 Alarm	[E-00B3 55:1 00B3169]
  MDB-2 MCB CONT BLDG ELEV Alarm	[E-00B3 55:2 00B316A]
  MDB-2 MCB ENCL ELEV Door CONT Alarm	[E-00B3 55:3 00B316B]
  MDB-2 MCB P101B Alarm	[E-00B3 55:4 00B316C]
  MDB-2 MCB L101E Alarm	[E-00B3 55:5 00B316D]
  MDB-2 MCB L2011/21/31B Alarm	[E-00B3 55:6 00B316E]
  MDB-2 MCB MCC-51 Alarm	[E-00B3 55:7 00B316F]
  MDB-2 MCB MCB-1 Alarm	[E-00B3 56:0 00B3170]
  MDB-2 MCB UPS XFMR BD-1 Alarm 2	[E-00B3 56:1 00B3171]
  MDB-2 MCB UPS XMFR BD-2 Alarm	[E-00B3 56:2 00B3172]
  MDB-2 MCB MCC-11 Alarm	[E-00B3 56:3 00B3173]
  MDB-2 TR-2 MCB MCC-51 Alarm	[E-00B3 56:4 00B3174]
  MDB-2 TR-2 MCB L101F Alarm	[E-00B3 56:5 00B3175]
  MDB-2 TR-2 MCB L2021/31C Alarm	[E-00B3 56:6 00B3176]
  MDB-2 MCB PDB HE-4 ALM	[E-00B3 56:7 00B319C]
  Chiller-C - MLP3 Fault	[E-00B3 57:0 00B319F]
  3rd Mirror I/F TX Last Access Time	[L-00B3 0 00B307B TIME3]
  3rd Mirror I/F RX Last Access Time	[L-00B3 3 00B307C TIME3]
  3rd Mirror I/F Error Code	[L-00B3 6 00B307D str]
  Cover I/F TX Last Access Time	[L-00B3 8 00B307E TIME3]
  Cover I/F RX Last Access Time	[L-00B3 11 00B307F TIME3]
  Cover I/F Error Code	[L-00B3 14 00B3080 str]
  MCP2 I/F TX Last Access Time	[L-00B3 16 00B3081 TIME3]
  MCP2 I/F RX Last Access Time	[L-00B3 19 00B3082 TIME3]
  MCP2 I/F Error Code	[L-00B3 22 00B3083 str]
  Weather I/F TX Last Access Time	[L-00B3 24 00B3084 TIME3]
  Weather I/F RX Last Access Time	[L-00B3 27 00B3085 TIME3]
  Weather I/F Error Code	[L-00B3 30 00B3086 str]
  Cal Source I/F TX Last Access Time	[L-00B3 32 00B3087 TIME3]
  Cal Source I/F RX Last Access Time	[L-00B3 35 00B3088 TIME3]
  Cal Source I/F Error Code	[L-00B3 38 00B3089 str]
  Cs Bolt I/F TX Last Access Time	[L-00B3 40 00B308A TIME3]
  Cs Bolt I/F RX Last Access Time	[L-00B3 43 00B308B TIME3]
  Cs Bolt I/F Error Code	[L-00B3 46 00B308C str]
  SPU4 I/F TX Last Access Time	[L-00B3 48 00B308D TIME3]
  SPU4 I/F RX Last Access Time	[L-00B3 51 00B308E TIME3]
  SPU4 I/F Error Code	[L-00B3 54 00B308F str]
  Dome CT2 I/F TX Last Access Time	[L-00B3 56 00B3090 TIME3]
  Dome CT2 I/F RX Last Access Time	[L-00B3 59 00B3091 TIME3]
  Dome CT2 I/F Error Code	[L-00B3 62 00B3092 str]
  TLSCP CT2 I/F TX Last Access Time	[L-00B3 64 00B3093 TIME3]
  TLSCP CT2 I/F RX Last Access Time	[L-00B3 67 00B3094 TIME3]
  TLSCP CT2 I/F Error Code	[L-00B3 70 00B3095 str]
  Dome ENVIR I/F TX Last Access Time	[L-00B3 72 00B3096 TIME3]
  Dome ENVIR I/F RX Last Access Time	[L-00B3 75 00B3097 TIME3]
  Dome ENVIR I/F Error Code	[L-00B3 78 00B3098 str]
  TLSCP ENVIR I/F TX Last Access Time	[L-00B3 80 00B3099 TIME3]
  TLSCP ENVIR I/F RX Last Access Time	[L-00B3 83 00B309A TIME3]
  TLSCP ENVIR I/F Error Code	[L-00B3 86 00B309B str]
  MCP1 I/F TX Last Access Time	[L-00B3 88 00B309C TIME3]
  MCP1 I/F RX Last Access Time	[L-00B3 91 00B309D TIME3]
  MCP1 I/F Error Code	[L-00B3 94 00B309E str]
  Heat Exh(MIR) I/F TX Last ACS Time	[L-00B3 96 00B309F TIME3]
  Heat Exh(MIR) I/F RX Last ACS Time	[L-00B3 99 00B30A0 TIME3]
  Heat Exh(MIR) I/F Error Code	[L-00B3 102 00B30A1 str]
  Heat Exh(Pump) I/F TX Last ACS Time	[L-00B3 104 00B30A3 TIME3]
  Heat Exh(Pump) I/F RX Last ACS Time	[L-00B3 107 00B30A4 TIME3]
  Heat Exh(Pump) I/F Error Code	[L-00B3 110 00B30A5 str]
  MDB1 480V PS Voltage	[L-00B3 112 00B305F BINARY2_1]
  MDB1 480V PS Current	[L-00B3 114 00B3061 BINARY2_1]
  MDB1 208V PS Voltage	[L-00B3 116 00B3060 BINARY2_1]
  MDB-1 208V Current	[L-00B3 118 00B3020 BINARY2_1]
  MDB1 Power Factor	[L-00B3 120 00B3016 BINARY2_1]
  MDB1 Frequency	[L-00B3 122 00B3017 BINARY2_1]
  MDB1 Watt-Hour	[L-00B3 124 00B3018 BINARY2_1]
  MDB2 480V PS Voltage	[L-00B3 126 00B3019 BINARY2_1]
  MDB2 480V PS Current	[L-00B3 128 00B301A BINARY2_1]
  MDB2 208V PS Voltage	[L-00B3 130 00B301B BINARY2_1]
  MDB2 208V PS Current	[L-00B3 132 00B301C BINARY2_1]
  MDB2 Power Factor	[L-00B3 134 00B301D BINARY2_1]
  MDB2 Frequency	[L-00B3 136 00B301E BINARY2_1]
  MDB2 Watt-Hour	[L-00B3 138 00B301F BINARY2_1]
  SPU5 I/F TX Last Access Time	[L-00B3 140 00B3069 TIME3]
  SPU5 I/F RX Last Access Time	[L-00B3 143 00B306A TIME3]
  SPU5 I/F Error Code	[L-00B3 146 00B306B str]
  Chiller-C I/F RX Last Access Time	[L-00B3 148 00B319D TIME3]
  SPU6 I/F RX Last Access Time	[L-00B3 151 00B306D TIME3]
  SPU6 I/F Error Code	[L-00B3 154 00B306E str]
  Power Unit I/F TX Last Access Time	[L-00B3 156 00B3181 TIME3]
  Power Unit I/F RX Last Access Time	[L-00B3 159 00B3182 TIME3]
  Power Unit I/F Error Code	[L-00B3 162 00B3183 str]
  Temp Unit I/F TX Last Access Time	[L-00B3 164 00B3184 TIME3]
  Temp Unit I/F RX Last Access Time	[L-00B3 167 00B3185 TIME3]
  Temp Unit I/F Error Code	[L-00B3 170 00B3186 str]
  Chiller-B I/F RX Last Access Time	[L-00B3 172 00B318E TIME3]
  Chiller-B I/F Error Code	[L-00B3 175 00B318F str]
  CXWS I/F RX Last Access Time	[L-00B3 177 00B3190 TIME3]
  CXWS I/F Error Code	[L-00B3 180 00B3191 str]
  Rdh Exh I/F TX Last Access Time	[L-00B3 182 00B3193 TIME3]
  Rdn Exh I/F RX Last Access Time	[L-00B3 185 00B3194 TIME3]
  Rdn Exh I/F Error Code	[L-00B3 188 00B3195 str]
  Chiller-C I/F Error Code	[L-00B3 190 00B319E str]
  Actuator1-00 MON PARA	[E-0100 0:0 0100009]
  Actuator1-00 MON HYB	[E-0100 0:1 0100008]
  Actuator1-00 MON Position	[E-0100 0:2 0100007]
  Actuator1-00 MON Force	[E-0100 0:3 0100006]
  Actuator1-00 Drive Off	[E-0100 0:4 0100005]
  Actuator1-00 Drive On	[E-0100 0:5 0100004]
  Actuator1-00 CONT Position	[E-0100 0:6 0100003]
  Actuator1-00 CONT Force	[E-0100 0:7 0100002]
  Actuator1-00 Alarm Reset	[E-0100 1:1 0100020]
  Actuator1-00 Limit Release	[E-0100 1:2 010001F]
  Actuator1-00 Selected Step	[E-0100 1:3 010000E]
  Actuator1-00 Selected Load	[E-0100 1:4 010000D]
  Actuator1-00 Selected Drive	[E-0100 1:5 010000C]
  Actuator1-00 Maunakea	[E-0100 1:6 010000B]
  Actuator1-00 Sea Level	[E-0100 1:7 010000A]
  Actuator1-00 Up Limit	[E-0100 2:0 0100016]
  Actuator1-00 Driver Alarm	[E-0100 2:1 0100015]
  Actuator1-00 Error Alarm	[E-0100 2:2 0100014]
  Actuator1-00 Over Current	[E-0100 2:3 0100013]
  Actuator1-00 Over Speed	[E-0100 2:4 0100012]
  Actuator1-00 Over Load	[E-0100 2:5 0100011]
  Actuator1-00 PS Alarm	[E-0100 2:6 0100010]
  Actuator1-00 ENC Alarm	[E-0100 2:7 010000F]
  Actuator1-00 CPU Alarm	[E-0100 3:0 010001E]
  Actuator1-00 UART Alarm	[E-0100 3:1 010001D]
  Actuator1-00 HDLC Alarm	[E-0100 3:2 010001C]
  Actuator1-00 Force Card Fault	[E-0100 3:3 010001B]
  Actuator1-00 Force Sensor Fault	[E-0100 3:4 010001A]
  Actuator1-00 Under Range	[E-0100 3:5 0100019]
  Actuator1-00 Over Range	[E-0100 3:6 0100018]
  Actuator1-00 Down Limit	[E-0100 3:7 0100017]
  Actuator1-01 MON PARA	[E-0101 0:0 0101009]
  Actuator1-01 MON HYB	[E-0101 0:1 0101008]
  Actuator1-01 MON Position	[E-0101 0:2 0101007]
  Actuator1-01 MON Force	[E-0101 0:3 0101006]
  Actuator1-01 Drive Off	[E-0101 0:4 0101005]
  Actuator1-01 Drive On	[E-0101 0:5 0101004]
  Actuator1-01 CONT Position	[E-0101 0:6 0101003]
  Actuator1-01 CONT Force	[E-0101 0:7 0101002]
  Actuator1-01 Alarm Reset	[E-0101 1:1 0101020]
  Actuator1-01 Limit Release	[E-0101 1:2 010101F]
  Actuator1-01 Selected Step	[E-0101 1:3 010100E]
  Actuator1-01 Selected Load	[E-0101 1:4 010100D]
  Actuator1-01 Selected Drive	[E-0101 1:5 010100C]
  Actuator1-01 Maunakea	[E-0101 1:6 010100B]
  Actuator1-01 Sea Level	[E-0101 1:7 010100A]
  Actuator1-01 Up Limit	[E-0101 2:0 0101016]
  Actuator1-01 Driver Alarm	[E-0101 2:1 0101015]
  Actuator1-01 Error Alarm	[E-0101 2:2 0101014]
  Actuator1-01 Over Current	[E-0101 2:3 0101013]
  Actuator1-01 Over Speed	[E-0101 2:4 0101012]
  Actuator1-01 Over Load	[E-0101 2:5 0101011]
  Actuator1-01 PS Alarm	[E-0101 2:6 0101010]
  Actuator1-01 ENC Alarm	[E-0101 2:7 010100F]
  Actuator1-01 CPU Alarm	[E-0101 3:0 010101E]
  Actuator1-01 UART Alarm	[E-0101 3:1 010101D]
  Actuator1-01 HDLC Alarm	[E-0101 3:2 010101C]
  Actuator1-01 Force Card Fault	[E-0101 3:3 010101B]
  Actuator1-01 Force Sensor Fault	[E-0101 3:4 010101A]
  Actuator1-01 Under Range	[E-0101 3:5 0101019]
  Actuator1-01 Over Range	[E-0101 3:6 0101018]
  Actuator1-01 Down Limit	[E-0101 3:7 0101017]
  Actuator1-02 MON PARA	[E-0102 0:0 0102009]
  Actuator1-02 MON HYB	[E-0102 0:1 0102008]
  Actuator1-02 MON Position	[E-0102 0:2 0102007]
  Actuator1-02 MON Force	[E-0102 0:3 0102006]
  Actuator1-02 Drive Off	[E-0102 0:4 0102005]
  Actuator1-02 Drive On	[E-0102 0:5 0102004]
  Actuator1-02 CONT Position	[E-0102 0:6 0102003]
  Actuator1-02 CONT Force	[E-0102 0:7 0102002]
  Actuator1-02 Alarm Reset	[E-0102 1:1 0102020]
  Actuator1-02 Limit Release	[E-0102 1:2 010201F]
  Actuator1-02 Selected Step	[E-0102 1:3 010200E]
  Actuator1-02 Selected Load	[E-0102 1:4 010200D]
  Actuator1-02 Selected Drive	[E-0102 1:5 010200C]
  Actuator1-02 Maunakea	[E-0102 1:6 010200B]
  Actuator1-02 Sea Level	[E-0102 1:7 010200A]
  Actuator1-02 Up Limit	[E-0102 2:0 0102016]
  Actuator1-02 Driver Alarm	[E-0102 2:1 0102015]
  Actuator1-02 Error Alarm	[E-0102 2:2 0102014]
  Actuator1-02 Over Current	[E-0102 2:3 0102013]
  Actuator1-02 Over Speed	[E-0102 2:4 0102012]
  Actuator1-02 Over Load	[E-0102 2:5 0102011]
  Actuator1-02 PS Alarm	[E-0102 2:6 0102010]
  Actuator1-02 ENC Alarm	[E-0102 2:7 010200F]
  Actuator1-02 CPU Alarm	[E-0102 3:0 010201E]
  Actuator1-02 UART Alarm	[E-0102 3:1 010201D]
  Actuator1-02 HDLC Alarm	[E-0102 3:2 010201C]
  Actuator1-02 Force Card Fault	[E-0102 3:3 010201B]
  Actuator1-02 Force Sensor Fault	[E-0102 3:4 010201A]
  Actuator1-02 Under Range	[E-0102 3:5 0102019]
  Actuator1-02 Over Range	[E-0102 3:6 0102018]
  Actuator1-02 Down Limit	[E-0102 3:7 0102017]
  Actuator1-03 MON PARA	[E-0103 0:0 0103009]
  Actuator1-03 MON HYB	[E-0103 0:1 0103008]
  Actuator1-03 MON Position	[E-0103 0:2 0103007]
  Actuator1-03 MON Force	[E-0103 0:3 0103006]
  Actuator1-03 Drive Off	[E-0103 0:4 0103005]
  Actuator1-03 Drive On	[E-0103 0:5 0103004]
  Actuator1-03 CONT Position	[E-0103 0:6 0103003]
  Actuator1-03 CONT Force	[E-0103 0:7 0103002]
  Actuator1-03 Alarm Reset	[E-0103 1:1 0103020]
  Actuator1-03 Limit Release	[E-0103 1:2 010301F]
  Actuator1-03 Selected Step	[E-0103 1:3 010300E]
  Actuator1-03 Selected Load	[E-0103 1:4 010300D]
  Actuator1-03 Selected Drive	[E-0103 1:5 010300C]
  Actuator1-03 Maunakea	[E-0103 1:6 010300B]
  Actuator1-03 Sea Level	[E-0103 1:7 010300A]
  Actuator1-03 Up Limit	[E-0103 2:0 0103016]
  Actuator1-03 Driver Alarm	[E-0103 2:1 0103015]
  Actuator1-03 Error Alarm	[E-0103 2:2 0103014]
  Actuator1-03 Over Current	[E-0103 2:3 0103013]
  Actuator1-03 Over Speed	[E-0103 2:4 0103012]
  Actuator1-03 Over Load	[E-0103 2:5 0103011]
  Actuator1-03 PS Alarm	[E-0103 2:6 0103010]
  Actuator1-03 ENC Alarm	[E-0103 2:7 010300F]
  Actuator1-03 CPU Alarm	[E-0103 3:0 010301E]
  Actuator1-03 UART Alarm	[E-0103 3:1 010301D]
  Actuator1-03 HDLC Alarm	[E-0103 3:2 010301C]
  Actuator1-03 Force Card Fault	[E-0103 3:3 010301B]
  Actuator1-03 Force Sensor Fault	[E-0103 3:4 010301A]
  Actuator1-03 Under Range	[E-0103 3:5 0103019]
  Actuator1-03 Over Range	[E-0103 3:6 0103018]
  Actuator1-03 Down Limit	[E-0103 3:7 0103017]
  Actuator1-04 MON PARA	[E-0104 0:0 0104009]
  Actuator1-04 MON HYB	[E-0104 0:1 0104008]
  Actuator1-04 MON Position	[E-0104 0:2 0104007]
  Actuator1-04 MON Force	[E-0104 0:3 0104006]
  Actuator1-04 Drive Off	[E-0104 0:4 0104005]
  Actuator1-04 Drive On	[E-0104 0:5 0104004]
  Actuator1-04 CONT Position	[E-0104 0:6 0104003]
  Actuator1-04 CONT Force	[E-0104 0:7 0104002]
  Actuator1-04 Alarm Reset	[E-0104 1:1 0104020]
  Actuator1-04 Limit Release	[E-0104 1:2 010401F]
  Actuator1-04 Selected Step	[E-0104 1:3 010400E]
  Actuator1-04 Selected Load	[E-0104 1:4 010400D]
  Actuator1-04 Selected Drive	[E-0104 1:5 010400C]
  Actuator1-04 Maunakea	[E-0104 1:6 010400B]
  Actuator1-04 Sea Level	[E-0104 1:7 010400A]
  Actuator1-04 Up Limit	[E-0104 2:0 0104016]
  Actuator1-04 Driver Alarm	[E-0104 2:1 0104015]
  Actuator1-04 Error Alarm	[E-0104 2:2 0104014]
  Actuator1-04 Over Current	[E-0104 2:3 0104013]
  Actuator1-04 Over Speed	[E-0104 2:4 0104012]
  Actuator1-04 Over Load	[E-0104 2:5 0104011]
  Actuator1-04 PS Alarm	[E-0104 2:6 0104010]
  Actuator1-04 ENC Alarm	[E-0104 2:7 010400F]
  Actuator1-04 CPU Alarm	[E-0104 3:0 010401E]
  Actuator1-04 UART Alarm	[E-0104 3:1 010401D]
  Actuator1-04 HDLC Alarm	[E-0104 3:2 010401C]
  Actuator1-04 Force Card Fault	[E-0104 3:3 010401B]
  Actuator1-04 Force Sensor Fault	[E-0104 3:4 010401A]
  Actuator1-04 Under Range	[E-0104 3:5 0104019]
  Actuator1-04 Over Range	[E-0104 3:6 0104018]
  Actuator1-04 Down Limit	[E-0104 3:7 0104017]
  Actuator1-05 MON PARA	[E-0105 0:0 0105009]
  Actuator1-05 MON HYB	[E-0105 0:1 0105008]
  Actuator1-05 MON Position	[E-0105 0:2 0105007]
  Actuator1-05 MON Force	[E-0105 0:3 0105006]
  Actuator1-05 Drive Off	[E-0105 0:4 0105005]
  Actuator1-05 Drive On	[E-0105 0:5 0105004]
  Actuator1-05 CONT Position	[E-0105 0:6 0105003]
  Actuator1-05 CONT Force	[E-0105 0:7 0105002]
  Actuator1-05 Alarm Reset	[E-0105 1:1 0105020]
  Actuator1-05 Limit Release	[E-0105 1:2 010501F]
  Actuator1-05 Selected Step	[E-0105 1:3 010500E]
  Actuator1-05 Selected Load	[E-0105 1:4 010500D]
  Actuator1-05 Selected Drive	[E-0105 1:5 010500C]
  Actuator1-05 Maunakea	[E-0105 1:6 010500B]
  Actuator1-05 Sea Level	[E-0105 1:7 010500A]
  Actuator1-05 Up Limit	[E-0105 2:0 0105016]
  Actuator1-05 Driver Alarm	[E-0105 2:1 0105015]
  Actuator1-05 Error Alarm	[E-0105 2:2 0105014]
  Actuator1-05 Over Current	[E-0105 2:3 0105013]
  Actuator1-05 Over Speed	[E-0105 2:4 0105012]
  Actuator1-05 Over Load	[E-0105 2:5 0105011]
  Actuator1-05 PS Alarm	[E-0105 2:6 0105010]
  Actuator1-05 ENC Alarm	[E-0105 2:7 010500F]
  Actuator1-05 CPU Alarm	[E-0105 3:0 010501E]
  Actuator1-05 UART Alarm	[E-0105 3:1 010501D]
  Actuator1-05 HDLC Alarm	[E-0105 3:2 010501C]
  Actuator1-05 Force Card Fault	[E-0105 3:3 010501B]
  Actuator1-05 Force Sensor Fault	[E-0105 3:4 010501A]
  Actuator1-05 Under Range	[E-0105 3:5 0105019]
  Actuator1-05 Over Range	[E-0105 3:6 0105018]
  Actuator1-05 Down Limit	[E-0105 3:7 0105017]
  Actuator1-06 MON PARA	[E-0106 0:0 0106009]
  Actuator1-06 MON HYB	[E-0106 0:1 0106008]
  Actuator1-06 MON Position	[E-0106 0:2 0106007]
  Actuator1-06 MON Force	[E-0106 0:3 0106006]
  Actuator1-06 Drive Off	[E-0106 0:4 0106005]
  Actuator1-06 Drive On	[E-0106 0:5 0106004]
  Actuator1-06 CONT Position	[E-0106 0:6 0106003]
  Actuator1-06 CONT Force	[E-0106 0:7 0106002]
  Actuator1-06 Alarm Reset	[E-0106 1:1 0106020]
  Actuator1-06 Limit Release	[E-0106 1:2 010601F]
  Actuator1-06 Selected Step	[E-0106 1:3 010600E]
  Actuator1-06 Selected Load	[E-0106 1:4 010600D]
  Actuator1-06 Selected Drive	[E-0106 1:5 010600C]
  Actuator1-06 Maunakea	[E-0106 1:6 010600B]
  Actuator1-06 Sea Level	[E-0106 1:7 010600A]
  Actuator1-06 Up Limit	[E-0106 2:0 0106016]
  Actuator1-06 Driver Alarm	[E-0106 2:1 0106015]
  Actuator1-06 Error Alarm	[E-0106 2:2 0106014]
  Actuator1-06 Over Current	[E-0106 2:3 0106013]
  Actuator1-06 Over Speed	[E-0106 2:4 0106012]
  Actuator1-06 Over Load	[E-0106 2:5 0106011]
  Actuator1-06 PS Alarm	[E-0106 2:6 0106010]
  Actuator1-06 ENC Alarm	[E-0106 2:7 010600F]
  Actuator1-06 CPU Alarm	[E-0106 3:0 010601E]
  Actuator1-06 UART Alarm	[E-0106 3:1 010601D]
  Actuator1-06 HDLC Alarm	[E-0106 3:2 010601C]
  Actuator1-06 Force Card Fault	[E-0106 3:3 010601B]
  Actuator1-06 Force Sensor Fault	[E-0106 3:4 010601A]
  Actuator1-06 Under Range	[E-0106 3:5 0106019]
  Actuator1-06 Over Range	[E-0106 3:6 0106018]
  Actuator1-06 Down Limit	[E-0106 3:7 0106017]
  Actuator1-07 MON PARA	[E-0107 0:0 0107009]
  Actuator1-07 MON HYB	[E-0107 0:1 0107008]
  Actuator1-07 MON Position	[E-0107 0:2 0107007]
  Actuator1-07 MON Force	[E-0107 0:3 0107006]
  Actuator1-07 Drive Off	[E-0107 0:4 0107005]
  Actuator1-07 Drive On	[E-0107 0:5 0107004]
  Actuator1-07 CONT Position	[E-0107 0:6 0107003]
  Actuator1-07 CONT Force	[E-0107 0:7 0107002]
  Actuator1-07 Alarm Reset	[E-0107 1:1 0107020]
  Actuator1-07 Limit Release	[E-0107 1:2 010701F]
  Actuator1-07 Selected Step	[E-0107 1:3 010700E]
  Actuator1-07 Selected Load	[E-0107 1:4 010700D]
  Actuator1-07 Selected Drive	[E-0107 1:5 010700C]
  Actuator1-07 Maunakea	[E-0107 1:6 010700B]
  Actuator1-07 Sea Level	[E-0107 1:7 010700A]
  Actuator1-07 Up Limit	[E-0107 2:0 0107016]
  Actuator1-07 Driver Alarm	[E-0107 2:1 0107015]
  Actuator1-07 Error Alarm	[E-0107 2:2 0107014]
  Actuator1-07 Over Current	[E-0107 2:3 0107013]
  Actuator1-07 Over Speed	[E-0107 2:4 0107012]
  Actuator1-07 Over Load	[E-0107 2:5 0107011]
  Actuator1-07 PS Alarm	[E-0107 2:6 0107010]
  Actuator1-07 ENC Alarm	[E-0107 2:7 010700F]
  Actuator1-07 CPU Alarm	[E-0107 3:0 010701E]
  Actuator1-07 UART Alarm	[E-0107 3:1 010701D]
  Actuator1-07 HDLC Alarm	[E-0107 3:2 010701C]
  Actuator1-07 Force Card Fault	[E-0107 3:3 010701B]
  Actuator1-07 Force Sensor Fault	[E-0107 3:4 010701A]
  Actuator1-07 Under Range	[E-0107 3:5 0107019]
  Actuator1-07 Over Range	[E-0107 3:6 0107018]
  Actuator1-07 Down Limit	[E-0107 3:7 0107017]
  Actuator1-08 MON PARA	[E-0108 0:0 0108009]
  Actuator1-08 MON HYB	[E-0108 0:1 0108008]
  Actuator1-08 MON Position	[E-0108 0:2 0108007]
  Actuator1-08 MON Force	[E-0108 0:3 0108006]
  Actuator1-08 Drive Off	[E-0108 0:4 0108005]
  Actuator1-08 Drive On	[E-0108 0:5 0108004]
  Actuator1-08 CONT Position	[E-0108 0:6 0108003]
  Actuator1-08 CONT Force	[E-0108 0:7 0108002]
  Actuator1-08 Alarm Reset	[E-0108 1:1 0108020]
  Actuator1-08 Limit Release	[E-0108 1:2 010801F]
  Actuator1-08 Selected Step	[E-0108 1:3 010800E]
  Actuator1-08 Selected Load	[E-0108 1:4 010800D]
  Actuator1-08 Selected Drive	[E-0108 1:5 010800C]
  Actuator1-08 Maunakea	[E-0108 1:6 010800B]
  Actuator1-08 Sea Level	[E-0108 1:7 010800A]
  Actuator1-08 Up Limit	[E-0108 2:0 0108016]
  Actuator1-08 Driver Alarm	[E-0108 2:1 0108015]
  Actuator1-08 Error Alarm	[E-0108 2:2 0108014]
  Actuator1-08 Over Current	[E-0108 2:3 0108013]
  Actuator1-08 Over Speed	[E-0108 2:4 0108012]
  Actuator1-08 Over Load	[E-0108 2:5 0108011]
  Actuator1-08 PS Alarm	[E-0108 2:6 0108010]
  Actuator1-08 ENC Alarm	[E-0108 2:7 010800F]
  Actuator1-08 CPU Alarm	[E-0108 3:0 010801E]
  Actuator1-08 UART Alarm	[E-0108 3:1 010801D]
  Actuator1-08 HDLC Alarm	[E-0108 3:2 010801C]
  Actuator1-08 Force Card Fault	[E-0108 3:3 010801B]
  Actuator1-08 Force Sensor Fault	[E-0108 3:4 010801A]
  Actuator1-08 Under Range	[E-0108 3:5 0108019]
  Actuator1-08 Over Range	[E-0108 3:6 0108018]
  Actuator1-08 Down Limit	[E-0108 3:7 0108017]
  Actuator1-09 MON PARA	[E-0109 0:0 0109009]
  Actuator1-09 MON HYB	[E-0109 0:1 0109008]
  Actuator1-09 MON Position	[E-0109 0:2 0109007]
  Actuator1-09 MON Force	[E-0109 0:3 0109006]
  Actuator1-09 Drive Off	[E-0109 0:4 0109005]
  Actuator1-09 Drive On	[E-0109 0:5 0109004]
  Actuator1-09 CONT Position	[E-0109 0:6 0109003]
  Actuator1-09 CONT Force	[E-0109 0:7 0109002]
  Actuator1-09 Alarm Reset	[E-0109 1:1 0109020]
  Actuator1-09 Limit Release	[E-0109 1:2 010901F]
  Actuator1-09 Selected Step	[E-0109 1:3 010900E]
  Actuator1-09 Selected Load	[E-0109 1:4 010900D]
  Actuator1-09 Selected Drive	[E-0109 1:5 010900C]
  Actuator1-09 Maunakea	[E-0109 1:6 010900B]
  Actuator1-09 Sea Level	[E-0109 1:7 010900A]
  Actuator1-09 Up Limit	[E-0109 2:0 0109016]
  Actuator1-09 Driver Alarm	[E-0109 2:1 0109015]
  Actuator1-09 Error Alarm	[E-0109 2:2 0109014]
  Actuator1-09 Over Current	[E-0109 2:3 0109013]
  Actuator1-09 Over Speed	[E-0109 2:4 0109012]
  Actuator1-09 Over Load	[E-0109 2:5 0109011]
  Actuator1-09 PS Alarm	[E-0109 2:6 0109010]
  Actuator1-09 ENC Alarm	[E-0109 2:7 010900F]
  Actuator1-09 CPU Alarm	[E-0109 3:0 010901E]
  Actuator1-09 UART Alarm	[E-0109 3:1 010901D]
  Actuator1-09 HDLC Alarm	[E-0109 3:2 010901C]
  Actuator1-09 Force Card Fault	[E-0109 3:3 010901B]
  Actuator1-09 Force Sensor Fault	[E-0109 3:4 010901A]
  Actuator1-09 Under Range	[E-0109 3:5 0109019]
  Actuator1-09 Over Range	[E-0109 3:6 0109018]
  Actuator1-09 Down Limit	[E-0109 3:7 0109017]
  Actuator1-10 MON PARA	[E-0110 0:0 0110009]
  Actuator1-10 MON HYB	[E-0110 0:1 0110008]
  Actuator1-10 MON Position	[E-0110 0:2 0110007]
  Actuator1-10 MON Force	[E-0110 0:3 0110006]
  Actuator1-10 Drive Off	[E-0110 0:4 0110005]
  Actuator1-10 Drive On	[E-0110 0:5 0110004]
  Actuator1-10 CONT Position	[E-0110 0:6 0110003]
  Actuator1-10 CONT Force	[E-0110 0:7 0110002]
  Actuator1-10 Alarm Reset	[E-0110 1:1 0110020]
  Actuator1-10 Limit Release	[E-0110 1:2 011001F]
  Actuator1-10 Selected Step	[E-0110 1:3 011000E]
  Actuator1-10 Selected Load	[E-0110 1:4 011000D]
  Actuator1-10 Selected Drive	[E-0110 1:5 011000C]
  Actuator1-10 Maunakea	[E-0110 1:6 011000B]
  Actuator1-10 Sea Level	[E-0110 1:7 011000A]
  Actuator1-10 Up Limit	[E-0110 2:0 0110016]
  Actuator1-10 Driver Alarm	[E-0110 2:1 0110015]
  Actuator1-10 Error Alarm	[E-0110 2:2 0110014]
  Actuator1-10 Over Current	[E-0110 2:3 0110013]
  Actuator1-10 Over Speed	[E-0110 2:4 0110012]
  Actuator1-10 Over Load	[E-0110 2:5 0110011]
  Actuator1-10 PS Alarm	[E-0110 2:6 0110010]
  Actuator1-10 ENC Alarm	[E-0110 2:7 011000F]
  Actuator1-10 CPU Alarm	[E-0110 3:0 011001E]
  Actuator1-10 UART Alarm	[E-0110 3:1 011001D]
  Actuator1-10 HDLC Alarm	[E-0110 3:2 011001C]
  Actuator1-10 Force Card Fault	[E-0110 3:3 011001B]
  Actuator1-10 Force Sensor Fault	[E-0110 3:4 011001A]
  Actuator1-10 Under Range	[E-0110 3:5 0110019]
  Actuator1-10 Over Range	[E-0110 3:6 0110018]
  Actuator1-10 Down Limit	[E-0110 3:7 0110017]
  Actuator1-11 MON PARA	[E-0111 0:0 0111009]
  Actuator1-11 MON HYB	[E-0111 0:1 0111008]
  Actuator1-11 MON Position	[E-0111 0:2 0111007]
  Actuator1-11 MON Force	[E-0111 0:3 0111006]
  Actuator1-11 Drive Off	[E-0111 0:4 0111005]
  Actuator1-11 Drive On	[E-0111 0:5 0111004]
  Actuator1-11 CONT Position	[E-0111 0:6 0111003]
  Actuator1-11 CONT Force	[E-0111 0:7 0111002]
  Actuator1-11 Alarm Reset	[E-0111 1:1 0111020]
  Actuator1-11 Limit Release	[E-0111 1:2 011101F]
  Actuator1-11 Selected Step	[E-0111 1:3 011100E]
  Actuator1-11 Selected Load	[E-0111 1:4 011100D]
  Actuator1-11 Selected Drive	[E-0111 1:5 011100C]
  Actuator1-11 Maunakea	[E-0111 1:6 011100B]
  Actuator1-11 Sea Level	[E-0111 1:7 011100A]
  Actuator1-11 Up Limit	[E-0111 2:0 0111016]
  Actuator1-11 Driver Alarm	[E-0111 2:1 0111015]
  Actuator1-11 Error Alarm	[E-0111 2:2 0111014]
  Actuator1-11 Over Current	[E-0111 2:3 0111013]
  Actuator1-11 Over Speed	[E-0111 2:4 0111012]
  Actuator1-11 Over Load	[E-0111 2:5 0111011]
  Actuator1-11 PS Alarm	[E-0111 2:6 0111010]
  Actuator1-11 ENC Alarm	[E-0111 2:7 011100F]
  Actuator1-11 CPU Alarm	[E-0111 3:0 011101E]
  Actuator1-11 UART Alarm	[E-0111 3:1 011101D]
  Actuator1-11 HDLC Alarm	[E-0111 3:2 011101C]
  Actuator1-11 Force Card Fault	[E-0111 3:3 011101B]
  Actuator1-11 Force Sensor Fault	[E-0111 3:4 011101A]
  Actuator1-11 Under Range	[E-0111 3:5 0111019]
  Actuator1-11 Over Range	[E-0111 3:6 0111018]
  Actuator1-11 Down Limit	[E-0111 3:7 0111017]
  Actuator1-12 MON PARA	[E-0112 0:0 0112009]
  Actuator1-12 MON HYB	[E-0112 0:1 0112008]
  Actuator1-12 MON Position	[E-0112 0:2 0112007]
  Actuator1-12 MON Force	[E-0112 0:3 0112006]
  Actuator1-12 Drive Off	[E-0112 0:4 0112005]
  Actuator1-12 Drive On	[E-0112 0:5 0112004]
  Actuator1-12 CONT Position	[E-0112 0:6 0112003]
  Actuator1-12 CONT Force	[E-0112 0:7 0112002]
  Actuator1-12 Alarm Reset	[E-0112 1:1 0112020]
  Actuator1-12 Limit Release	[E-0112 1:2 011201F]
  Actuator1-12 Selected Step	[E-0112 1:3 011200E]
  Actuator1-12 Selected Load	[E-0112 1:4 011200D]
  Actuator1-12 Selected Drive	[E-0112 1:5 011200C]
  Actuator1-12 Maunakea	[E-0112 1:6 011200B]
  Actuator1-12 Sea Level	[E-0112 1:7 011200A]
  Actuator1-12 Up Limit	[E-0112 2:0 0112016]
  Actuator1-12 Driver Alarm	[E-0112 2:1 0112015]
  Actuator1-12 Error Alarm	[E-0112 2:2 0112014]
  Actuator1-12 Over Current	[E-0112 2:3 0112013]
  Actuator1-12 Over Speed	[E-0112 2:4 0112012]
  Actuator1-12 Over Load	[E-0112 2:5 0112011]
  Actuator1-12 PS Alarm	[E-0112 2:6 0112010]
  Actuator1-12 ENC Alarm	[E-0112 2:7 011200F]
  Actuator1-12 CPU Alarm	[E-0112 3:0 011201E]
  Actuator1-12 UART Alarm	[E-0112 3:1 011201D]
  Actuator1-12 HDLC Alarm	[E-0112 3:2 011201C]
  Actuator1-12 Force Card Fault	[E-0112 3:3 011201B]
  Actuator1-12 Force Sensor Fault	[E-0112 3:4 011201A]
  Actuator1-12 Under Range	[E-0112 3:5 0112019]
  Actuator1-12 Over Range	[E-0112 3:6 0112018]
  Actuator1-12 Down Limit	[E-0112 3:7 0112017]
  Actuator1-13 MON PARA	[E-0113 0:0 0113009]
  Actuator1-13 MON HYB	[E-0113 0:1 0113008]
  Actuator1-13 MON Position	[E-0113 0:2 0113007]
  Actuator1-13 MON Force	[E-0113 0:3 0113006]
  Actuator1-13 Drive Off	[E-0113 0:4 0113005]
  Actuator1-13 Drive On	[E-0113 0:5 0113004]
  Actuator1-13 CONT Position	[E-0113 0:6 0113003]
  Actuator1-13 CONT Force	[E-0113 0:7 0113002]
  Actuator1-13 Alarm Reset	[E-0113 1:1 0113020]
  Actuator1-13 Limit Release	[E-0113 1:2 011301F]
  Actuator1-13 Selected Step	[E-0113 1:3 011300E]
  Actuator1-13 Selected Load	[E-0113 1:4 011300D]
  Actuator1-13 Selected Drive	[E-0113 1:5 011300C]
  Actuator1-13 Maunakea	[E-0113 1:6 011300B]
  Actuator1-13 Sea Level	[E-0113 1:7 011300A]
  Actuator1-13 Up Limit	[E-0113 2:0 0113016]
  Actuator1-13 Driver Alarm	[E-0113 2:1 0113015]
  Actuator1-13 Error Alarm	[E-0113 2:2 0113014]
  Actuator1-13 Over Current	[E-0113 2:3 0113013]
  Actuator1-13 Over Speed	[E-0113 2:4 0113012]
  Actuator1-13 Over Load	[E-0113 2:5 0113011]
  Actuator1-13 PS Alarm	[E-0113 2:6 0113010]
  Actuator1-13 ENC Alarm	[E-0113 2:7 011300F]
  Actuator1-13 CPU Alarm	[E-0113 3:0 011301E]
  Actuator1-13 UART Alarm	[E-0113 3:1 011301D]
  Actuator1-13 HDLC Alarm	[E-0113 3:2 011301C]
  Actuator1-13 Force Card Fault	[E-0113 3:3 011301B]
  Actuator1-13 Force Sensor Fault	[E-0113 3:4 011301A]
  Actuator1-13 Under Range	[E-0113 3:5 0113019]
  Actuator1-13 Over Range	[E-0113 3:6 0113018]
  Actuator1-13 Down Limit	[E-0113 3:7 0113017]
  Actuator1-14 MON PARA	[E-0114 0:0 0114009]
  Actuator1-14 MON HYB	[E-0114 0:1 0114008]
  Actuator1-14 MON Position	[E-0114 0:2 0114007]
  Actuator1-14 MON Force	[E-0114 0:3 0114006]
  Actuator1-14 Drive Off	[E-0114 0:4 0114005]
  Actuator1-14 Drive On	[E-0114 0:5 0114004]
  Actuator1-14 CONT Position	[E-0114 0:6 0114003]
  Actuator1-14 CONT Force	[E-0114 0:7 0114002]
  Actuator1-14 Alarm Reset	[E-0114 1:1 0114020]
  Actuator1-14 Limit Release	[E-0114 1:2 011401F]
  Actuator1-14 Selected Step	[E-0114 1:3 011400E]
  Actuator1-14 Selected Load	[E-0114 1:4 011400D]
  Actuator1-14 Selected Drive	[E-0114 1:5 011400C]
  Actuator1-14 Maunakea	[E-0114 1:6 011400B]
  Actuator1-14 Sea Level	[E-0114 1:7 011400A]
  Actuator1-14 Up Limit	[E-0114 2:0 0114016]
  Actuator1-14 Driver Alarm	[E-0114 2:1 0114015]
  Actuator1-14 Error Alarm	[E-0114 2:2 0114014]
  Actuator1-14 Over Current	[E-0114 2:3 0114013]
  Actuator1-14 Over Speed	[E-0114 2:4 0114012]
  Actuator1-14 Over Load	[E-0114 2:5 0114011]
  Actuator1-14 PS Alarm	[E-0114 2:6 0114010]
  Actuator1-14 ENC Alarm	[E-0114 2:7 011400F]
  Actuator1-14 CPU Alarm	[E-0114 3:0 011401E]
  Actuator1-14 UART Alarm	[E-0114 3:1 011401D]
  Actuator1-14 HDLC Alarm	[E-0114 3:2 011401C]
  Actuator1-14 Force Card Fault	[E-0114 3:3 011401B]
  Actuator1-14 Force Sensor Fault	[E-0114 3:4 011401A]
  Actuator1-14 Under Range	[E-0114 3:5 0114019]
  Actuator1-14 Over Range	[E-0114 3:6 0114018]
  Actuator1-14 Down Limit	[E-0114 3:7 0114017]
  Actuator1-15 MON PARA	[E-0115 0:0 0115009]
  Actuator1-15 MON HYB	[E-0115 0:1 0115008]
  Actuator1-15 MON Position	[E-0115 0:2 0115007]
  Actuator1-15 MON Force	[E-0115 0:3 0115006]
  Actuator1-15 Drive Off	[E-0115 0:4 0115005]
  Actuator1-15 Drive On	[E-0115 0:5 0115004]
  Actuator1-15 CONT Position	[E-0115 0:6 0115003]
  Actuator1-15 CONT Force	[E-0115 0:7 0115002]
  Actuator1-15 Alarm Reset	[E-0115 1:1 0115020]
  Actuator1-15 Limit Release	[E-0115 1:2 011501F]
  Actuator1-15 Selected Step	[E-0115 1:3 011500E]
  Actuator1-15 Selected Load	[E-0115 1:4 011500D]
  Actuator1-15 Selected Drive	[E-0115 1:5 011500C]
  Actuator1-15 Maunakea	[E-0115 1:6 011500B]
  Actuator1-15 Sea Level	[E-0115 1:7 011500A]
  Actuator1-15 Up Limit	[E-0115 2:0 0115016]
  Actuator1-15 Driver Alarm	[E-0115 2:1 0115015]
  Actuator1-15 Error Alarm	[E-0115 2:2 0115014]
  Actuator1-15 Over Current	[E-0115 2:3 0115013]
  Actuator1-15 Over Speed	[E-0115 2:4 0115012]
  Actuator1-15 Over Load	[E-0115 2:5 0115011]
  Actuator1-15 PS Alarm	[E-0115 2:6 0115010]
  Actuator1-15 ENC Alarm	[E-0115 2:7 011500F]
  Actuator1-15 CPU Alarm	[E-0115 3:0 011501E]
  Actuator1-15 UART Alarm	[E-0115 3:1 011501D]
  Actuator1-15 HDLC Alarm	[E-0115 3:2 011501C]
  Actuator1-15 Force Card Fault	[E-0115 3:3 011501B]
  Actuator1-15 Force Sensor Fault	[E-0115 3:4 011501A]
  Actuator1-15 Under Range	[E-0115 3:5 0115019]
  Actuator1-15 Over Range	[E-0115 3:6 0115018]
  Actuator1-15 Down Limit	[E-0115 3:7 0115017]
  Actuator1-16 MON PARA	[E-0116 0:0 0116009]
  Actuator1-16 MON HYB	[E-0116 0:1 0116008]
  Actuator1-16 MON Position	[E-0116 0:2 0116007]
  Actuator1-16 MON Force	[E-0116 0:3 0116006]
  Actuator1-16 Drive Off	[E-0116 0:4 0116005]
  Actuator1-16 Drive On	[E-0116 0:5 0116004]
  Actuator1-16 CONT Position	[E-0116 0:6 0116003]
  Actuator1-16 CONT Force	[E-0116 0:7 0116002]
  Actuator1-16 Alarm Reset	[E-0116 1:1 0116020]
  Actuator1-16 Limit Release	[E-0116 1:2 011601F]
  Actuator1-16 Selected Step	[E-0116 1:3 011600E]
  Actuator1-16 Selected Load	[E-0116 1:4 011600D]
  Actuator1-16 Selected Drive	[E-0116 1:5 011600C]
  Actuator1-16 Maunakea	[E-0116 1:6 011600B]
  Actuator1-16 Sea Level	[E-0116 1:7 011600A]
  Actuator1-16 Up Limit	[E-0116 2:0 0116016]
  Actuator1-16 Driver Alarm	[E-0116 2:1 0116015]
  Actuator1-16 Error Alarm	[E-0116 2:2 0116014]
  Actuator1-16 Over Current	[E-0116 2:3 0116013]
  Actuator1-16 Over Speed	[E-0116 2:4 0116012]
  Actuator1-16 Over Load	[E-0116 2:5 0116011]
  Actuator1-16 PS Alarm	[E-0116 2:6 0116010]
  Actuator1-16 ENC Alarm	[E-0116 2:7 011600F]
  Actuator1-16 CPU Alarm	[E-0116 3:0 011601E]
  Actuator1-16 UART Alarm	[E-0116 3:1 011601D]
  Actuator1-16 HDLC Alarm	[E-0116 3:2 011601C]
  Actuator1-16 Force Card Fault	[E-0116 3:3 011601B]
  Actuator1-16 Force Sensor Fault	[E-0116 3:4 011601A]
  Actuator1-16 Under Range	[E-0116 3:5 0116019]
  Actuator1-16 Over Range	[E-0116 3:6 0116018]
  Actuator1-16 Down Limit	[E-0116 3:7 0116017]
  Actuator1-17 MON PARA	[E-0117 0:0 0117009]
  Actuator1-17 MON HYB	[E-0117 0:1 0117008]
  Actuator1-17 MON Position	[E-0117 0:2 0117007]
  Actuator1-17 MON Force	[E-0117 0:3 0117006]
  Actuator1-17 Drive Off	[E-0117 0:4 0117005]
  Actuator1-17 Drive On	[E-0117 0:5 0117004]
  Actuator1-17 CONT Position	[E-0117 0:6 0117003]
  Actuator1-17 CONT Force	[E-0117 0:7 0117002]
  Actuator1-17 Alarm Reset	[E-0117 1:1 0117020]
  Actuator1-17 Limit Release	[E-0117 1:2 011701F]
  Actuator1-17 Selected Step	[E-0117 1:3 011700E]
  Actuator1-17 Selected Load	[E-0117 1:4 011700D]
  Actuator1-17 Selected Drive	[E-0117 1:5 011700C]
  Actuator1-17 Maunakea	[E-0117 1:6 011700B]
  Actuator1-17 Sea Level	[E-0117 1:7 011700A]
  Actuator1-17 Up Limit	[E-0117 2:0 0117016]
  Actuator1-17 Driver Alarm	[E-0117 2:1 0117015]
  Actuator1-17 Error Alarm	[E-0117 2:2 0117014]
  Actuator1-17 Over Current	[E-0117 2:3 0117013]
  Actuator1-17 Over Speed	[E-0117 2:4 0117012]
  Actuator1-17 Over Load	[E-0117 2:5 0117011]
  Actuator1-17 PS Alarm	[E-0117 2:6 0117010]
  Actuator1-17 ENC Alarm	[E-0117 2:7 011700F]
  Actuator1-17 CPU Alarm	[E-0117 3:0 011701E]
  Actuator1-17 UART Alarm	[E-0117 3:1 011701D]
  Actuator1-17 HDLC Alarm	[E-0117 3:2 011701C]
  Actuator1-17 Force Card Fault	[E-0117 3:3 011701B]
  Actuator1-17 Force Sensor Fault	[E-0117 3:4 011701A]
  Actuator1-17 Under Range	[E-0117 3:5 0117019]
  Actuator1-17 Over Range	[E-0117 3:6 0117018]
  Actuator1-17 Down Limit	[E-0117 3:7 0117017]
  Actuator1-18 MON PARA	[E-0118 0:0 0118009]
  Actuator1-18 MON HYB	[E-0118 0:1 0118008]
  Actuator1-18 MON Position	[E-0118 0:2 0118007]
  Actuator1-18 MON Force	[E-0118 0:3 0118006]
  Actuator1-18 Drive Off	[E-0118 0:4 0118005]
  Actuator1-18 Drive On	[E-0118 0:5 0118004]
  Actuator1-18 CONT Position	[E-0118 0:6 0118003]
  Actuator1-18 CONT Force	[E-0118 0:7 0118002]
  Actuator1-18 Alarm Reset	[E-0118 1:1 0118020]
  Actuator1-18 Limit Release	[E-0118 1:2 011801F]
  Actuator1-18 Selected Step	[E-0118 1:3 011800E]
  Actuator1-18 Selected Load	[E-0118 1:4 011800D]
  Actuator1-18 Selected Drive	[E-0118 1:5 011800C]
  Actuator1-18 Maunakea	[E-0118 1:6 011800B]
  Actuator1-18 Sea Level	[E-0118 1:7 011800A]
  Actuator1-18 Up Limit	[E-0118 2:0 0118016]
  Actuator1-18 Driver Alarm	[E-0118 2:1 0118015]
  Actuator1-18 Error Alarm	[E-0118 2:2 0118014]
  Actuator1-18 Over Current	[E-0118 2:3 0118013]
  Actuator1-18 Over Speed	[E-0118 2:4 0118012]
  Actuator1-18 Over Load	[E-0118 2:5 0118011]
  Actuator1-18 PS Alarm	[E-0118 2:6 0118010]
  Actuator1-18 ENC Alarm	[E-0118 2:7 011800F]
  Actuator1-18 CPU Alarm	[E-0118 3:0 011801E]
  Actuator1-18 UART Alarm	[E-0118 3:1 011801D]
  Actuator1-18 HDLC Alarm	[E-0118 3:2 011801C]
  Actuator1-18 Force Card Fault	[E-0118 3:3 011801B]
  Actuator1-18 Force Sensor Fault	[E-0118 3:4 011801A]
  Actuator1-18 Under Range	[E-0118 3:5 0118019]
  Actuator1-18 Over Range	[E-0118 3:6 0118018]
  Actuator1-18 Down Limit	[E-0118 3:7 0118017]
  Actuator1-19 MON PARA	[E-0119 0:0 0119009]
  Actuator1-19 MON HYB	[E-0119 0:1 0119008]
  Actuator1-19 MON Position	[E-0119 0:2 0119007]
  Actuator1-19 MON Force	[E-0119 0:3 0119006]
  Actuator1-19 Drive Off	[E-0119 0:4 0119005]
  Actuator1-19 Drive On	[E-0119 0:5 0119004]
  Actuator1-19 CONT Position	[E-0119 0:6 0119003]
  Actuator1-19 CONT Force	[E-0119 0:7 0119002]
  Actuator1-19 Alarm Reset	[E-0119 1:1 0119020]
  Actuator1-19 Limit Release	[E-0119 1:2 011901F]
  Actuator1-19 Selected Step	[E-0119 1:3 011900E]
  Actuator1-19 Selected Load	[E-0119 1:4 011900D]
  Actuator1-19 Selected Drive	[E-0119 1:5 011900C]
  Actuator1-19 Maunakea	[E-0119 1:6 011900B]
  Actuator1-19 Sea Level	[E-0119 1:7 011900A]
  Actuator1-19 Up Limit	[E-0119 2:0 0119016]
  Actuator1-19 Driver Alarm	[E-0119 2:1 0119015]
  Actuator1-19 Error Alarm	[E-0119 2:2 0119014]
  Actuator1-19 Over Current	[E-0119 2:3 0119013]
  Actuator1-19 Over Speed	[E-0119 2:4 0119012]
  Actuator1-19 Over Load	[E-0119 2:5 0119011]
  Actuator1-19 PS Alarm	[E-0119 2:6 0119010]
  Actuator1-19 ENC Alarm	[E-0119 2:7 011900F]
  Actuator1-19 CPU Alarm	[E-0119 3:0 011901E]
  Actuator1-19 UART Alarm	[E-0119 3:1 011901D]
  Actuator1-19 HDLC Alarm	[E-0119 3:2 011901C]
  Actuator1-19 Force Card Fault	[E-0119 3:3 011901B]
  Actuator1-19 Force Sensor Fault	[E-0119 3:4 011901A]
  Actuator1-19 Under Range	[E-0119 3:5 0119019]
  Actuator1-19 Over Range	[E-0119 3:6 0119018]
  Actuator1-19 Down Limit	[E-0119 3:7 0119017]
  Actuator1-20 MON PARA	[E-0120 0:0 0120009]
  Actuator1-20 MON HYB	[E-0120 0:1 0120008]
  Actuator1-20 MON Position	[E-0120 0:2 0120007]
  Actuator1-20 MON Force	[E-0120 0:3 0120006]
  Actuator1-20 Drive Off	[E-0120 0:4 0120005]
  Actuator1-20 Drive On	[E-0120 0:5 0120004]
  Actuator1-20 CONT Position	[E-0120 0:6 0120003]
  Actuator1-20 CONT Force	[E-0120 0:7 0120002]
  Actuator1-20 Alarm Reset	[E-0120 1:1 0120020]
  Actuator1-20 Limit Release	[E-0120 1:2 012001F]
  Actuator1-20 Selected Step	[E-0120 1:3 012000E]
  Actuator1-20 Selected Load	[E-0120 1:4 012000D]
  Actuator1-20 Selected Drive	[E-0120 1:5 012000C]
  Actuator1-20 Maunakea	[E-0120 1:6 012000B]
  Actuator1-20 Sea Level	[E-0120 1:7 012000A]
  Actuator1-20 Up Limit	[E-0120 2:0 0120016]
  Actuator1-20 Driver Alarm	[E-0120 2:1 0120015]
  Actuator1-20 Error Alarm	[E-0120 2:2 0120014]
  Actuator1-20 Over Current	[E-0120 2:3 0120013]
  Actuator1-20 Over Speed	[E-0120 2:4 0120012]
  Actuator1-20 Over Load	[E-0120 2:5 0120011]
  Actuator1-20 PS Alarm	[E-0120 2:6 0120010]
  Actuator1-20 ENC Alarm	[E-0120 2:7 012000F]
  Actuator1-20 CPU Alarm	[E-0120 3:0 012001E]
  Actuator1-20 UART Alarm	[E-0120 3:1 012001D]
  Actuator1-20 HDLC Alarm	[E-0120 3:2 012001C]
  Actuator1-20 Force Card Fault	[E-0120 3:3 012001B]
  Actuator1-20 Force Sensor Fault	[E-0120 3:4 012001A]
  Actuator1-20 Under Range	[E-0120 3:5 0120019]
  Actuator1-20 Over Range	[E-0120 3:6 0120018]
  Actuator1-20 Down Limit	[E-0120 3:7 0120017]
  Actuator1-21 MON PARA	[E-0121 0:0 0121009]
  Actuator1-21 MON HYB	[E-0121 0:1 0121008]
  Actuator1-21 MON Position	[E-0121 0:2 0121007]
  Actuator1-21 MON Force	[E-0121 0:3 0121006]
  Actuator1-21 Drive Off	[E-0121 0:4 0121005]
  Actuator1-21 Drive On	[E-0121 0:5 0121004]
  Actuator1-21 CONT Position	[E-0121 0:6 0121003]
  Actuator1-21 CONT Force	[E-0121 0:7 0121002]
  Actuator1-21 Alarm Reset	[E-0121 1:1 0121020]
  Actuator1-21 Limit Release	[E-0121 1:2 012101F]
  Actuator1-21 Selected Step	[E-0121 1:3 012100E]
  Actuator1-21 Selected Load	[E-0121 1:4 012100D]
  Actuator1-21 Selected Drive	[E-0121 1:5 012100C]
  Actuator1-21 Maunakea	[E-0121 1:6 012100B]
  Actuator1-21 Sea Level	[E-0121 1:7 012100A]
  Actuator1-21 Up Limit	[E-0121 2:0 0121016]
  Actuator1-21 Driver Alarm	[E-0121 2:1 0121015]
  Actuator1-21 Error Alarm	[E-0121 2:2 0121014]
  Actuator1-21 Over Current	[E-0121 2:3 0121013]
  Actuator1-21 Over Speed	[E-0121 2:4 0121012]
  Actuator1-21 Over Load	[E-0121 2:5 0121011]
  Actuator1-21 PS Alarm	[E-0121 2:6 0121010]
  Actuator1-21 ENC Alarm	[E-0121 2:7 012100F]
  Actuator1-21 CPU Alarm	[E-0121 3:0 012101E]
  Actuator1-21 UART Alarm	[E-0121 3:1 012101D]
  Actuator1-21 HDLC Alarm	[E-0121 3:2 012101C]
  Actuator1-21 Force Card Fault	[E-0121 3:3 012101B]
  Actuator1-21 Force Sensor Fault	[E-0121 3:4 012101A]
  Actuator1-21 Under Range	[E-0121 3:5 0121019]
  Actuator1-21 Over Range	[E-0121 3:6 0121018]
  Actuator1-21 Down Limit	[E-0121 3:7 0121017]
  Actuator1-22 MON PARA	[E-0122 0:0 0122009]
  Actuator1-22 MON HYB	[E-0122 0:1 0122008]
  Actuator1-22 MON Position	[E-0122 0:2 0122007]
  Actuator1-22 MON Force	[E-0122 0:3 0122006]
  Actuator1-22 Drive Off	[E-0122 0:4 0122005]
  Actuator1-22 Drive On	[E-0122 0:5 0122004]
  Actuator1-22 CONT Position	[E-0122 0:6 0122003]
  Actuator1-22 CONT Force	[E-0122 0:7 0122002]
  Actuator1-22 Alarm Reset	[E-0122 1:1 0122020]
  Actuator1-22 Limit Release	[E-0122 1:2 012201F]
  Actuator1-22 Selected Step	[E-0122 1:3 012200E]
  Actuator1-22 Selected Load	[E-0122 1:4 012200D]
  Actuator1-22 Selected Drive	[E-0122 1:5 012200C]
  Actuator1-22 Maunakea	[E-0122 1:6 012200B]
  Actuator1-22 Sea Level	[E-0122 1:7 012200A]
  Actuator1-22 Up Limit	[E-0122 2:0 0122016]
  Actuator1-22 Driver Alarm	[E-0122 2:1 0122015]
  Actuator1-22 Error Alarm	[E-0122 2:2 0122014]
  Actuator1-22 Over Current	[E-0122 2:3 0122013]
  Actuator1-22 Over Speed	[E-0122 2:4 0122012]
  Actuator1-22 Over Load	[E-0122 2:5 0122011]
  Actuator1-22 PS Alarm	[E-0122 2:6 0122010]
  Actuator1-22 ENC Alarm	[E-0122 2:7 012200F]
  Actuator1-22 CPU Alarm	[E-0122 3:0 012201E]
  Actuator1-22 UART Alarm	[E-0122 3:1 012201D]
  Actuator1-22 HDLC Alarm	[E-0122 3:2 012201C]
  Actuator1-22 Force Card Fault	[E-0122 3:3 012201B]
  Actuator1-22 Force Sensor Fault	[E-0122 3:4 012201A]
  Actuator1-22 Under Range	[E-0122 3:5 0122019]
  Actuator1-22 Over Range	[E-0122 3:6 0122018]
  Actuator1-22 Down Limit	[E-0122 3:7 0122017]
  Actuator1-23 MON PARA	[E-0123 0:0 0123009]
  Actuator1-23 MON HYB	[E-0123 0:1 0123008]
  Actuator1-23 MON Position	[E-0123 0:2 0123007]
  Actuator1-23 MON Force	[E-0123 0:3 0123006]
  Actuator1-23 Drive Off	[E-0123 0:4 0123005]
  Actuator1-23 Drive On	[E-0123 0:5 0123004]
  Actuator1-23 CONT Position	[E-0123 0:6 0123003]
  Actuator1-23 CONT Force	[E-0123 0:7 0123002]
  Actuator1-23 Alarm Reset	[E-0123 1:1 0123020]
  Actuator1-23 Limit Release	[E-0123 1:2 012301F]
  Actuator1-23 Selected Step	[E-0123 1:3 012300E]
  Actuator1-23 Selected Load	[E-0123 1:4 012300D]
  Actuator1-23 Selected Drive	[E-0123 1:5 012300C]
  Actuator1-23 Maunakea	[E-0123 1:6 012300B]
  Actuator1-23 Sea Level	[E-0123 1:7 012300A]
  Actuator1-23 Up Limit	[E-0123 2:0 0123016]
  Actuator1-23 Driver Alarm	[E-0123 2:1 0123015]
  Actuator1-23 Error Alarm	[E-0123 2:2 0123014]
  Actuator1-23 Over Current	[E-0123 2:3 0123013]
  Actuator1-23 Over Speed	[E-0123 2:4 0123012]
  Actuator1-23 Over Load	[E-0123 2:5 0123011]
  Actuator1-23 PS Alarm	[E-0123 2:6 0123010]
  Actuator1-23 ENC Alarm	[E-0123 2:7 012300F]
  Actuator1-23 CPU Alarm	[E-0123 3:0 012301E]
  Actuator1-23 UART Alarm	[E-0123 3:1 012301D]
  Actuator1-23 HDLC Alarm	[E-0123 3:2 012301C]
  Actuator1-23 Force Card Fault	[E-0123 3:3 012301B]
  Actuator1-23 Force Sensor Fault	[E-0123 3:4 012301A]
  Actuator1-23 Under Range	[E-0123 3:5 0123019]
  Actuator1-23 Over Range	[E-0123 3:6 0123018]
  Actuator1-23 Down Limit	[E-0123 3:7 0123017]
  Actuator1-24 MON PARA	[E-0124 0:0 0124009]
  Actuator1-24 MON HYB	[E-0124 0:1 0124008]
  Actuator1-24 MON Position	[E-0124 0:2 0124007]
  Actuator1-24 MON Force	[E-0124 0:3 0124006]
  Actuator1-24 Drive Off	[E-0124 0:4 0124005]
  Actuator1-24 Drive On	[E-0124 0:5 0124004]
  Actuator1-24 CONT Position	[E-0124 0:6 0124003]
  Actuator1-24 CONT Force	[E-0124 0:7 0124002]
  Actuator1-24 Alarm Reset	[E-0124 1:1 0124020]
  Actuator1-24 Limit Release	[E-0124 1:2 012401F]
  Actuator1-24 Selected Step	[E-0124 1:3 012400E]
  Actuator1-24 Selected Load	[E-0124 1:4 012400D]
  Actuator1-24 Selected Drive	[E-0124 1:5 012400C]
  Actuator1-24 Maunakea	[E-0124 1:6 012400B]
  Actuator1-24 Sea Level	[E-0124 1:7 012400A]
  Actuator1-24 Up Limit	[E-0124 2:0 0124016]
  Actuator1-24 Driver Alarm	[E-0124 2:1 0124015]
  Actuator1-24 Error Alarm	[E-0124 2:2 0124014]
  Actuator1-24 Over Current	[E-0124 2:3 0124013]
  Actuator1-24 Over Speed	[E-0124 2:4 0124012]
  Actuator1-24 Over Load	[E-0124 2:5 0124011]
  Actuator1-24 PS Alarm	[E-0124 2:6 0124010]
  Actuator1-24 ENC Alarm	[E-0124 2:7 012400F]
  Actuator1-24 CPU Alarm	[E-0124 3:0 012401E]
  Actuator1-24 UART Alarm	[E-0124 3:1 012401D]
  Actuator1-24 HDLC Alarm	[E-0124 3:2 012401C]
  Actuator1-24 Force Card Fault	[E-0124 3:3 012401B]
  Actuator1-24 Force Sensor Fault	[E-0124 3:4 012401A]
  Actuator1-24 Under Range	[E-0124 3:5 0124019]
  Actuator1-24 Over Range	[E-0124 3:6 0124018]
  Actuator1-24 Down Limit	[E-0124 3:7 0124017]
  Actuator1-25 MON PARA	[E-0125 0:0 0125009]
  Actuator1-25 MON HYB	[E-0125 0:1 0125008]
  Actuator1-25 MON Position	[E-0125 0:2 0125007]
  Actuator1-25 MON Force	[E-0125 0:3 0125006]
  Actuator1-25 Drive Off	[E-0125 0:4 0125005]
  Actuator1-25 Drive On	[E-0125 0:5 0125004]
  Actuator1-25 CONT Position	[E-0125 0:6 0125003]
  Actuator1-25 CONT Force	[E-0125 0:7 0125002]
  Actuator1-25 Alarm Reset	[E-0125 1:1 0125020]
  Actuator1-25 Limit Release	[E-0125 1:2 012501F]
  Actuator1-25 Selected Step	[E-0125 1:3 012500E]
  Actuator1-25 Selected Load	[E-0125 1:4 012500D]
  Actuator1-25 Selected Drive	[E-0125 1:5 012500C]
  Actuator1-25 Maunakea	[E-0125 1:6 012500B]
  Actuator1-25 Sea Level	[E-0125 1:7 012500A]
  Actuator1-25 Up Limit	[E-0125 2:0 0125016]
  Actuator1-25 Driver Alarm	[E-0125 2:1 0125015]
  Actuator1-25 Error Alarm	[E-0125 2:2 0125014]
  Actuator1-25 Over Current	[E-0125 2:3 0125013]
  Actuator1-25 Over Speed	[E-0125 2:4 0125012]
  Actuator1-25 Over Load	[E-0125 2:5 0125011]
  Actuator1-25 PS Alarm	[E-0125 2:6 0125010]
  Actuator1-25 ENC Alarm	[E-0125 2:7 012500F]
  Actuator1-25 CPU Alarm	[E-0125 3:0 012501E]
  Actuator1-25 UART Alarm	[E-0125 3:1 012501D]
  Actuator1-25 HDLC Alarm	[E-0125 3:2 012501C]
  Actuator1-25 Force Card Fault	[E-0125 3:3 012501B]
  Actuator1-25 Force Sensor Fault	[E-0125 3:4 012501A]
  Actuator1-25 Under Range	[E-0125 3:5 0125019]
  Actuator1-25 Over Range	[E-0125 3:6 0125018]
  Actuator1-25 Down Limit	[E-0125 3:7 0125017]
  Actuator1-26 MON PARA	[E-0126 0:0 0126009]
  Actuator1-26 MON HYB	[E-0126 0:1 0126008]
  Actuator1-26 MON Position	[E-0126 0:2 0126007]
  Actuator1-26 MON Force	[E-0126 0:3 0126006]
  Actuator1-26 Drive Off	[E-0126 0:4 0126005]
  Actuator1-26 Drive On	[E-0126 0:5 0126004]
  Actuator1-26 CONT Position	[E-0126 0:6 0126003]
  Actuator1-26 CONT Force	[E-0126 0:7 0126002]
  Actuator1-26 Alarm Reset	[E-0126 1:1 0126020]
  Actuator1-26 Limit Release	[E-0126 1:2 012601F]
  Actuator1-26 Selected Step	[E-0126 1:3 012600E]
  Actuator1-26 Selected Load	[E-0126 1:4 012600D]
  Actuator1-26 Selected Drive	[E-0126 1:5 012600C]
  Actuator1-26 Maunakea	[E-0126 1:6 012600B]
  Actuator1-26 Sea Level	[E-0126 1:7 012600A]
  Actuator1-26 Up Limit	[E-0126 2:0 0126016]
  Actuator1-26 Driver Alarm	[E-0126 2:1 0126015]
  Actuator1-26 Error Alarm	[E-0126 2:2 0126014]
  Actuator1-26 Over Current	[E-0126 2:3 0126013]
  Actuator1-26 Over Speed	[E-0126 2:4 0126012]
  Actuator1-26 Over Load	[E-0126 2:5 0126011]
  Actuator1-26 PS Alarm	[E-0126 2:6 0126010]
  Actuator1-26 ENC Alarm	[E-0126 2:7 012600F]
  Actuator1-26 CPU Alarm	[E-0126 3:0 012601E]
  Actuator1-26 UART Alarm	[E-0126 3:1 012601D]
  Actuator1-26 HDLC Alarm	[E-0126 3:2 012601C]
  Actuator1-26 Force Card Fault	[E-0126 3:3 012601B]
  Actuator1-26 Force Sensor Fault	[E-0126 3:4 012601A]
  Actuator1-26 Under Range	[E-0126 3:5 0126019]
  Actuator1-26 Over Range	[E-0126 3:6 0126018]
  Actuator1-26 Down Limit	[E-0126 3:7 0126017]
  Actuator1-27 MON PARA	[E-0127 0:0 0127009]
  Actuator1-27 MON HYB	[E-0127 0:1 0127008]
  Actuator1-27 MON Position	[E-0127 0:2 0127007]
  Actuator1-27 MON Force	[E-0127 0:3 0127006]
  Actuator1-27 Drive Off	[E-0127 0:4 0127005]
  Actuator1-27 Drive On	[E-0127 0:5 0127004]
  Actuator1-27 CONT Position	[E-0127 0:6 0127003]
  Actuator1-27 CONT Force	[E-0127 0:7 0127002]
  Actuator1-27 Alarm Reset	[E-0127 1:1 0127020]
  Actuator1-27 Limit Release	[E-0127 1:2 012701F]
  Actuator1-27 Selected Step	[E-0127 1:3 012700E]
  Actuator1-27 Selected Load	[E-0127 1:4 012700D]
  Actuator1-27 Selected Drive	[E-0127 1:5 012700C]
  Actuator1-27 Maunakea	[E-0127 1:6 012700B]
  Actuator1-27 Sea Level	[E-0127 1:7 012700A]
  Actuator1-27 Up Limit	[E-0127 2:0 0127016]
  Actuator1-27 Driver Alarm	[E-0127 2:1 0127015]
  Actuator1-27 Error Alarm	[E-0127 2:2 0127014]
  Actuator1-27 Over Current	[E-0127 2:3 0127013]
  Actuator1-27 Over Speed	[E-0127 2:4 0127012]
  Actuator1-27 Over Load	[E-0127 2:5 0127011]
  Actuator1-27 PS Alarm	[E-0127 2:6 0127010]
  Actuator1-27 ENC Alarm	[E-0127 2:7 012700F]
  Actuator1-27 CPU Alarm	[E-0127 3:0 012701E]
  Actuator1-27 UART Alarm	[E-0127 3:1 012701D]
  Actuator1-27 HDLC Alarm	[E-0127 3:2 012701C]
  Actuator1-27 Force Card Fault	[E-0127 3:3 012701B]
  Actuator1-27 Force Sensor Fault	[E-0127 3:4 012701A]
  Actuator1-27 Under Range	[E-0127 3:5 0127019]
  Actuator1-27 Over Range	[E-0127 3:6 0127018]
  Actuator1-27 Down Limit	[E-0127 3:7 0127017]
  Actuator1-28 MON PARA	[E-0128 0:0 0128009]
  Actuator1-28 MON HYB	[E-0128 0:1 0128008]
  Actuator1-28 MON Position	[E-0128 0:2 0128007]
  Actuator1-28 MON Force	[E-0128 0:3 0128006]
  Actuator1-28 Drive Off	[E-0128 0:4 0128005]
  Actuator1-28 Drive On	[E-0128 0:5 0128004]
  Actuator1-28 CONT Position	[E-0128 0:6 0128003]
  Actuator1-28 CONT Force	[E-0128 0:7 0128002]
  Actuator1-28 Alarm Reset	[E-0128 1:1 0128020]
  Actuator1-28 Limit Release	[E-0128 1:2 012801F]
  Actuator1-28 Selected Step	[E-0128 1:3 012800E]
  Actuator1-28 Selected Load	[E-0128 1:4 012800D]
  Actuator1-28 Selected Drive	[E-0128 1:5 012800C]
  Actuator1-28 Maunakea	[E-0128 1:6 012800B]
  Actuator1-28 Sea Level	[E-0128 1:7 012800A]
  Actuator1-28 Up Limit	[E-0128 2:0 0128016]
  Actuator1-28 Driver Alarm	[E-0128 2:1 0128015]
  Actuator1-28 Error Alarm	[E-0128 2:2 0128014]
  Actuator1-28 Over Current	[E-0128 2:3 0128013]
  Actuator1-28 Over Speed	[E-0128 2:4 0128012]
  Actuator1-28 Over Load	[E-0128 2:5 0128011]
  Actuator1-28 PS Alarm	[E-0128 2:6 0128010]
  Actuator1-28 ENC Alarm	[E-0128 2:7 012800F]
  Actuator1-28 CPU Alarm	[E-0128 3:0 012801E]
  Actuator1-28 UART Alarm	[E-0128 3:1 012801D]
  Actuator1-28 HDLC Alarm	[E-0128 3:2 012801C]
  Actuator1-28 Force Card Fault	[E-0128 3:3 012801B]
  Actuator1-28 Force Sensor Fault	[E-0128 3:4 012801A]
  Actuator1-28 Under Range	[E-0128 3:5 0128019]
  Actuator1-28 Over Range	[E-0128 3:6 0128018]
  Actuator1-28 Down Limit	[E-0128 3:7 0128017]
  Actuator1-29 MON PARA	[E-0129 0:0 0129009]
  Actuator1-29 MON HYB	[E-0129 0:1 0129008]
  Actuator1-29 MON Position	[E-0129 0:2 0129007]
  Actuator1-29 MON Force	[E-0129 0:3 0129006]
  Actuator1-29 Drive Off	[E-0129 0:4 0129005]
  Actuator1-29 Drive On	[E-0129 0:5 0129004]
  Actuator1-29 CONT Position	[E-0129 0:6 0129003]
  Actuator1-29 CONT Force	[E-0129 0:7 0129002]
  Actuator1-29 Alarm Reset	[E-0129 1:1 0129020]
  Actuator1-29 Limit Release	[E-0129 1:2 012901F]
  Actuator1-29 Selected Step	[E-0129 1:3 012900E]
  Actuator1-29 Selected Load	[E-0129 1:4 012900D]
  Actuator1-29 Selected Drive	[E-0129 1:5 012900C]
  Actuator1-29 Maunakea	[E-0129 1:6 012900B]
  Actuator1-29 Sea Level	[E-0129 1:7 012900A]
  Actuator1-29 Up Limit	[E-0129 2:0 0129016]
  Actuator1-29 Driver Alarm	[E-0129 2:1 0129015]
  Actuator1-29 Error Alarm	[E-0129 2:2 0129014]
  Actuator1-29 Over Current	[E-0129 2:3 0129013]
  Actuator1-29 Over Speed	[E-0129 2:4 0129012]
  Actuator1-29 Over Load	[E-0129 2:5 0129011]
  Actuator1-29 PS Alarm	[E-0129 2:6 0129010]
  Actuator1-29 ENC Alarm	[E-0129 2:7 012900F]
  Actuator1-29 CPU Alarm	[E-0129 3:0 012901E]
  Actuator1-29 UART Alarm	[E-0129 3:1 012901D]
  Actuator1-29 HDLC Alarm	[E-0129 3:2 012901C]
  Actuator1-29 Force Card Fault	[E-0129 3:3 012901B]
  Actuator1-29 Force Sensor Fault	[E-0129 3:4 012901A]
  Actuator1-29 Under Range	[E-0129 3:5 0129019]
  Actuator1-29 Over Range	[E-0129 3:6 0129018]
  Actuator1-29 Down Limit	[E-0129 3:7 0129017]
  Actuator1-30 MON PARA	[E-0130 0:0 0130009]
  Actuator1-30 MON HYB	[E-0130 0:1 0130008]
  Actuator1-30 MON Position	[E-0130 0:2 0130007]
  Actuator1-30 MON Force	[E-0130 0:3 0130006]
  Actuator1-30 Drive Off	[E-0130 0:4 0130005]
  Actuator1-30 Drive On	[E-0130 0:5 0130004]
  Actuator1-30 CONT Position	[E-0130 0:6 0130003]
  Actuator1-30 CONT Force	[E-0130 0:7 0130002]
  Actuator1-30 Alarm Reset	[E-0130 1:1 0130020]
  Actuator1-30 Limit Release	[E-0130 1:2 013001F]
  Actuator1-30 Selected Step	[E-0130 1:3 013000E]
  Actuator1-30 Selected Load	[E-0130 1:4 013000D]
  Actuator1-30 Selected Drive	[E-0130 1:5 013000C]
  Actuator1-30 Maunakea	[E-0130 1:6 013000B]
  Actuator1-30 Sea Level	[E-0130 1:7 013000A]
  Actuator1-30 Up Limit	[E-0130 2:0 0130016]
  Actuator1-30 Driver Alarm	[E-0130 2:1 0130015]
  Actuator1-30 Error Alarm	[E-0130 2:2 0130014]
  Actuator1-30 Over Current	[E-0130 2:3 0130013]
  Actuator1-30 Over Speed	[E-0130 2:4 0130012]
  Actuator1-30 Over Load	[E-0130 2:5 0130011]
  Actuator1-30 PS Alarm	[E-0130 2:6 0130010]
  Actuator1-30 ENC Alarm	[E-0130 2:7 013000F]
  Actuator1-30 CPU Alarm	[E-0130 3:0 013001E]
  Actuator1-30 UART Alarm	[E-0130 3:1 013001D]
  Actuator1-30 HDLC Alarm	[E-0130 3:2 013001C]
  Actuator1-30 Force Card Fault	[E-0130 3:3 013001B]
  Actuator1-30 Force Sensor Fault	[E-0130 3:4 013001A]
  Actuator1-30 Under Range	[E-0130 3:5 0130019]
  Actuator1-30 Over Range	[E-0130 3:6 0130018]
  Actuator1-30 Down Limit	[E-0130 3:7 0130017]
  Actuator1-31 MON PARA	[E-0131 0:0 0131009]
  Actuator1-31 MON HYB	[E-0131 0:1 0131008]
  Actuator1-31 MON Position	[E-0131 0:2 0131007]
  Actuator1-31 MON Force	[E-0131 0:3 0131006]
  Actuator1-31 Drive Off	[E-0131 0:4 0131005]
  Actuator1-31 Drive On	[E-0131 0:5 0131004]
  Actuator1-31 CONT Position	[E-0131 0:6 0131003]
  Actuator1-31 CONT Force	[E-0131 0:7 0131002]
  Actuator1-31 Alarm Reset	[E-0131 1:1 0131020]
  Actuator1-31 Limit Release	[E-0131 1:2 013101F]
  Actuator1-31 Selected Step	[E-0131 1:3 013100E]
  Actuator1-31 Selected Load	[E-0131 1:4 013100D]
  Actuator1-31 Selected Drive	[E-0131 1:5 013100C]
  Actuator1-31 Maunakea	[E-0131 1:6 013100B]
  Actuator1-31 Sea Level	[E-0131 1:7 013100A]
  Actuator1-31 Up Limit	[E-0131 2:0 0131016]
  Actuator1-31 Driver Alarm	[E-0131 2:1 0131015]
  Actuator1-31 Error Alarm	[E-0131 2:2 0131014]
  Actuator1-31 Over Current	[E-0131 2:3 0131013]
  Actuator1-31 Over Speed	[E-0131 2:4 0131012]
  Actuator1-31 Over Load	[E-0131 2:5 0131011]
  Actuator1-31 PS Alarm	[E-0131 2:6 0131010]
  Actuator1-31 ENC Alarm	[E-0131 2:7 013100F]
  Actuator1-31 CPU Alarm	[E-0131 3:0 013101E]
  Actuator1-31 UART Alarm	[E-0131 3:1 013101D]
  Actuator1-31 HDLC Alarm	[E-0131 3:2 013101C]
  Actuator1-31 Force Card Fault	[E-0131 3:3 013101B]
  Actuator1-31 Force Sensor Fault	[E-0131 3:4 013101A]
  Actuator1-31 Under Range	[E-0131 3:5 0131019]
  Actuator1-31 Over Range	[E-0131 3:6 0131018]
  Actuator1-31 Down Limit	[E-0131 3:7 0131017]
  Actuator1-32 MON PARA	[E-0132 0:0 0132009]
  Actuator1-32 MON HYB	[E-0132 0:1 0132008]
  Actuator1-32 MON Position	[E-0132 0:2 0132007]
  Actuator1-32 MON Force	[E-0132 0:3 0132006]
  Actuator1-32 Drive Off	[E-0132 0:4 0132005]
  Actuator1-32 Drive On	[E-0132 0:5 0132004]
  Actuator1-32 CONT Position	[E-0132 0:6 0132003]
  Actuator1-32 CONT Force	[E-0132 0:7 0132002]
  Actuator1-32 Alarm Reset	[E-0132 1:1 0132020]
  Actuator1-32 Limit Release	[E-0132 1:2 013201F]
  Actuator1-32 Selected Step	[E-0132 1:3 013200E]
  Actuator1-32 Selected Load	[E-0132 1:4 013200D]
  Actuator1-32 Selected Drive	[E-0132 1:5 013200C]
  Actuator1-32 Maunakea	[E-0132 1:6 013200B]
  Actuator1-32 Sea Level	[E-0132 1:7 013200A]
  Actuator1-32 Up Limit	[E-0132 2:0 0132016]
  Actuator1-32 Driver Alarm	[E-0132 2:1 0132015]
  Actuator1-32 Error Alarm	[E-0132 2:2 0132014]
  Actuator1-32 Over Current	[E-0132 2:3 0132013]
  Actuator1-32 Over Speed	[E-0132 2:4 0132012]
  Actuator1-32 Over Load	[E-0132 2:5 0132011]
  Actuator1-32 PS Alarm	[E-0132 2:6 0132010]
  Actuator1-32 ENC Alarm	[E-0132 2:7 013200F]
  Actuator1-32 CPU Alarm	[E-0132 3:0 013201E]
  Actuator1-32 UART Alarm	[E-0132 3:1 013201D]
  Actuator1-32 HDLC Alarm	[E-0132 3:2 013201C]
  Actuator1-32 Force Card Fault	[E-0132 3:3 013201B]
  Actuator1-32 Force Sensor Fault	[E-0132 3:4 013201A]
  Actuator1-32 Under Range	[E-0132 3:5 0132019]
  Actuator1-32 Over Range	[E-0132 3:6 0132018]
  Actuator1-32 Down Limit	[E-0132 3:7 0132017]
  Actuator1-33 MON PARA	[E-0133 0:0 0133009]
  Actuator1-33 MON HYB	[E-0133 0:1 0133008]
  Actuator1-33 MON Position	[E-0133 0:2 0133007]
  Actuator1-33 MON Force	[E-0133 0:3 0133006]
  Actuator1-33 Drive Off	[E-0133 0:4 0133005]
  Actuator1-33 Drive On	[E-0133 0:5 0133004]
  Actuator1-33 CONT Position	[E-0133 0:6 0133003]
  Actuator1-33 CONT Force	[E-0133 0:7 0133002]
  Actuator1-33 Alarm Reset	[E-0133 1:1 0133020]
  Actuator1-33 Limit Release	[E-0133 1:2 013301F]
  Actuator1-33 Selected Step	[E-0133 1:3 013300E]
  Actuator1-33 Selected Load	[E-0133 1:4 013300D]
  Actuator1-33 Selected Drive	[E-0133 1:5 013300C]
  Actuator1-33 Maunakea	[E-0133 1:6 013300B]
  Actuator1-33 Sea Level	[E-0133 1:7 013300A]
  Actuator1-33 Up Limit	[E-0133 2:0 0133016]
  Actuator1-33 Driver Alarm	[E-0133 2:1 0133015]
  Actuator1-33 Error Alarm	[E-0133 2:2 0133014]
  Actuator1-33 Over Current	[E-0133 2:3 0133013]
  Actuator1-33 Over Speed	[E-0133 2:4 0133012]
  Actuator1-33 Over Load	[E-0133 2:5 0133011]
  Actuator1-33 PS Alarm	[E-0133 2:6 0133010]
  Actuator1-33 ENC Alarm	[E-0133 2:7 013300F]
  Actuator1-33 CPU Alarm	[E-0133 3:0 013301E]
  Actuator1-33 UART Alarm	[E-0133 3:1 013301D]
  Actuator1-33 HDLC Alarm	[E-0133 3:2 013301C]
  Actuator1-33 Force Card Fault	[E-0133 3:3 013301B]
  Actuator1-33 Force Sensor Fault	[E-0133 3:4 013301A]
  Actuator1-33 Under Range	[E-0133 3:5 0133019]
  Actuator1-33 Over Range	[E-0133 3:6 0133018]
  Actuator1-33 Down Limit	[E-0133 3:7 0133017]
  Actuator1-34 MON PARA	[E-0134 0:0 0134009]
  Actuator1-34 MON HYB	[E-0134 0:1 0134008]
  Actuator1-34 MON Position	[E-0134 0:2 0134007]
  Actuator1-34 MON Force	[E-0134 0:3 0134006]
  Actuator1-34 Drive Off	[E-0134 0:4 0134005]
  Actuator1-34 Drive On	[E-0134 0:5 0134004]
  Actuator1-34 CONT Position	[E-0134 0:6 0134003]
  Actuator1-34 CONT Force	[E-0134 0:7 0134002]
  Actuator1-34 Alarm Reset	[E-0134 1:1 0134020]
  Actuator1-34 Limit Release	[E-0134 1:2 013401F]
  Actuator1-34 Selected Step	[E-0134 1:3 013400E]
  Actuator1-34 Selected Load	[E-0134 1:4 013400D]
  Actuator1-34 Selected Drive	[E-0134 1:5 013400C]
  Actuator1-34 Maunakea	[E-0134 1:6 013400B]
  Actuator1-34 Sea Level	[E-0134 1:7 013400A]
  Actuator1-34 Up Limit	[E-0134 2:0 0134016]
  Actuator1-34 Driver Alarm	[E-0134 2:1 0134015]
  Actuator1-34 Error Alarm	[E-0134 2:2 0134014]
  Actuator1-34 Over Current	[E-0134 2:3 0134013]
  Actuator1-34 Over Speed	[E-0134 2:4 0134012]
  Actuator1-34 Over Load	[E-0134 2:5 0134011]
  Actuator1-34 PS Alarm	[E-0134 2:6 0134010]
  Actuator1-34 ENC Alarm	[E-0134 2:7 013400F]
  Actuator1-34 CPU Alarm	[E-0134 3:0 013401E]
  Actuator1-34 UART Alarm	[E-0134 3:1 013401D]
  Actuator1-34 HDLC Alarm	[E-0134 3:2 013401C]
  Actuator1-34 Force Card Fault	[E-0134 3:3 013401B]
  Actuator1-34 Force Sensor Fault	[E-0134 3:4 013401A]
  Actuator1-34 Under Range	[E-0134 3:5 0134019]
  Actuator1-34 Over Range	[E-0134 3:6 0134018]
  Actuator1-34 Down Limit	[E-0134 3:7 0134017]
  Actuator1-35 MON PARA	[E-0135 0:0 0135009]
  Actuator1-35 MON HYB	[E-0135 0:1 0135008]
  Actuator1-35 MON Position	[E-0135 0:2 0135007]
  Actuator1-35 MON Force	[E-0135 0:3 0135006]
  Actuator1-35 Drive Off	[E-0135 0:4 0135005]
  Actuator1-35 Drive On	[E-0135 0:5 0135004]
  Actuator1-35 CONT Position	[E-0135 0:6 0135003]
  Actuator1-35 CONT Force	[E-0135 0:7 0135002]
  Actuator1-35 Alarm Reset	[E-0135 1:1 0135020]
  Actuator1-35 Limit Release	[E-0135 1:2 013501F]
  Actuator1-35 Selected Step	[E-0135 1:3 013500E]
  Actuator1-35 Selected Load	[E-0135 1:4 013500D]
  Actuator1-35 Selected Drive	[E-0135 1:5 013500C]
  Actuator1-35 Maunakea	[E-0135 1:6 013500B]
  Actuator1-35 Sea Level	[E-0135 1:7 013500A]
  Actuator1-35 Up Limit	[E-0135 2:0 0135016]
  Actuator1-35 Driver Alarm	[E-0135 2:1 0135015]
  Actuator1-35 Error Alarm	[E-0135 2:2 0135014]
  Actuator1-35 Over Current	[E-0135 2:3 0135013]
  Actuator1-35 Over Speed	[E-0135 2:4 0135012]
  Actuator1-35 Over Load	[E-0135 2:5 0135011]
  Actuator1-35 PS Alarm	[E-0135 2:6 0135010]
  Actuator1-35 ENC Alarm	[E-0135 2:7 013500F]
  Actuator1-35 CPU Alarm	[E-0135 3:0 013501E]
  Actuator1-35 UART Alarm	[E-0135 3:1 013501D]
  Actuator1-35 HDLC Alarm	[E-0135 3:2 013501C]
  Actuator1-35 Force Card Fault	[E-0135 3:3 013501B]
  Actuator1-35 Force Sensor Fault	[E-0135 3:4 013501A]
  Actuator1-35 Under Range	[E-0135 3:5 0135019]
  Actuator1-35 Over Range	[E-0135 3:6 0135018]
  Actuator1-35 Down Limit	[E-0135 3:7 0135017]
  Actuator1-36 MON PARA	[E-0136 0:0 0136009]
  Actuator1-36 MON HYB	[E-0136 0:1 0136008]
  Actuator1-36 MON Position	[E-0136 0:2 0136007]
  Actuator1-36 MON Force	[E-0136 0:3 0136006]
  Actuator1-36 Drive Off	[E-0136 0:4 0136005]
  Actuator1-36 Drive On	[E-0136 0:5 0136004]
  Actuator1-36 CONT Position	[E-0136 0:6 0136003]
  Actuator1-36 CONT Force	[E-0136 0:7 0136002]
  Actuator1-36 Alarm Reset	[E-0136 1:1 0136020]
  Actuator1-36 Limit Release	[E-0136 1:2 013601F]
  Actuator1-36 Selected Step	[E-0136 1:3 013600E]
  Actuator1-36 Selected Load	[E-0136 1:4 013600D]
  Actuator1-36 Selected Drive	[E-0136 1:5 013600C]
  Actuator1-36 Maunakea	[E-0136 1:6 013600B]
  Actuator1-36 Sea Level	[E-0136 1:7 013600A]
  Actuator1-36 Up Limit	[E-0136 2:0 0136016]
  Actuator1-36 Driver Alarm	[E-0136 2:1 0136015]
  Actuator1-36 Error Alarm	[E-0136 2:2 0136014]
  Actuator1-36 Over Current	[E-0136 2:3 0136013]
  Actuator1-36 Over Speed	[E-0136 2:4 0136012]
  Actuator1-36 Over Load	[E-0136 2:5 0136011]
  Actuator1-36 PS Alarm	[E-0136 2:6 0136010]
  Actuator1-36 ENC Alarm	[E-0136 2:7 013600F]
  Actuator1-36 CPU Alarm	[E-0136 3:0 013601E]
  Actuator1-36 UART Alarm	[E-0136 3:1 013601D]
  Actuator1-36 HDLC Alarm	[E-0136 3:2 013601C]
  Actuator1-36 Force Card Fault	[E-0136 3:3 013601B]
  Actuator1-36 Force Sensor Fault	[E-0136 3:4 013601A]
  Actuator1-36 Under Range	[E-0136 3:5 0136019]
  Actuator1-36 Over Range	[E-0136 3:6 0136018]
  Actuator1-36 Down Limit	[E-0136 3:7 0136017]
  Actuator1-37 MON PARA	[E-0137 0:0 0137009]
  Actuator1-37 MON HYB	[E-0137 0:1 0137008]
  Actuator1-37 MON Position	[E-0137 0:2 0137007]
  Actuator1-37 MON Force	[E-0137 0:3 0137006]
  Actuator1-37 Drive Off	[E-0137 0:4 0137005]
  Actuator1-37 Drive On	[E-0137 0:5 0137004]
  Actuator1-37 CONT Position	[E-0137 0:6 0137003]
  Actuator1-37 CONT Force	[E-0137 0:7 0137002]
  Actuator1-37 Alarm Reset	[E-0137 1:1 0137020]
  Actuator1-37 Limit Release	[E-0137 1:2 013701F]
  Actuator1-37 Selected Step	[E-0137 1:3 013700E]
  Actuator1-37 Selected Load	[E-0137 1:4 013700D]
  Actuator1-37 Selected Drive	[E-0137 1:5 013700C]
  Actuator1-37 Maunakea	[E-0137 1:6 013700B]
  Actuator1-37 Sea Level	[E-0137 1:7 013700A]
  Actuator1-37 Up Limit	[E-0137 2:0 0137016]
  Actuator1-37 Driver Alarm	[E-0137 2:1 0137015]
  Actuator1-37 Error Alarm	[E-0137 2:2 0137014]
  Actuator1-37 Over Current	[E-0137 2:3 0137013]
  Actuator1-37 Over Speed	[E-0137 2:4 0137012]
  Actuator1-37 Over Load	[E-0137 2:5 0137011]
  Actuator1-37 PS Alarm	[E-0137 2:6 0137010]
  Actuator1-37 ENC Alarm	[E-0137 2:7 013700F]
  Actuator1-37 CPU Alarm	[E-0137 3:0 013701E]
  Actuator1-37 UART Alarm	[E-0137 3:1 013701D]
  Actuator1-37 HDLC Alarm	[E-0137 3:2 013701C]
  Actuator1-37 Force Card Fault	[E-0137 3:3 013701B]
  Actuator1-37 Force Sensor Fault	[E-0137 3:4 013701A]
  Actuator1-37 Under Range	[E-0137 3:5 0137019]
  Actuator1-37 Over Range	[E-0137 3:6 0137018]
  Actuator1-37 Down Limit	[E-0137 3:7 0137017]
  Actuator1-38 MON PARA	[E-0138 0:0 0138009]
  Actuator1-38 MON HYB	[E-0138 0:1 0138008]
  Actuator1-38 MON Position	[E-0138 0:2 0138007]
  Actuator1-38 MON Force	[E-0138 0:3 0138006]
  Actuator1-38 Drive Off	[E-0138 0:4 0138005]
  Actuator1-38 Drive On	[E-0138 0:5 0138004]
  Actuator1-38 CONT Position	[E-0138 0:6 0138003]
  Actuator1-38 CONT Force	[E-0138 0:7 0138002]
  Actuator1-38 Alarm Reset	[E-0138 1:1 0138020]
  Actuator1-38 Limit Release	[E-0138 1:2 013801F]
  Actuator1-38 Selected Step	[E-0138 1:3 013800E]
  Actuator1-38 Selected Load	[E-0138 1:4 013800D]
  Actuator1-38 Selected Drive	[E-0138 1:5 013800C]
  Actuator1-38 Maunakea	[E-0138 1:6 013800B]
  Actuator1-38 Sea Level	[E-0138 1:7 013800A]
  Actuator1-38 Up Limit	[E-0138 2:0 0138016]
  Actuator1-38 Driver Alarm	[E-0138 2:1 0138015]
  Actuator1-38 Error Alarm	[E-0138 2:2 0138014]
  Actuator1-38 Over Current	[E-0138 2:3 0138013]
  Actuator1-38 Over Speed	[E-0138 2:4 0138012]
  Actuator1-38 Over Load	[E-0138 2:5 0138011]
  Actuator1-38 PS Alarm	[E-0138 2:6 0138010]
  Actuator1-38 ENC Alarm	[E-0138 2:7 013800F]
  Actuator1-38 CPU Alarm	[E-0138 3:0 013801E]
  Actuator1-38 UART Alarm	[E-0138 3:1 013801D]
  Actuator1-38 HDLC Alarm	[E-0138 3:2 013801C]
  Actuator1-38 Force Card Fault	[E-0138 3:3 013801B]
  Actuator1-38 Force Sensor Fault	[E-0138 3:4 013801A]
  Actuator1-38 Under Range	[E-0138 3:5 0138019]
  Actuator1-38 Over Range	[E-0138 3:6 0138018]
  Actuator1-38 Down Limit	[E-0138 3:7 0138017]
  Actuator1-39 MON PARA	[E-0139 0:0 0139009]
  Actuator1-39 MON HYB	[E-0139 0:1 0139008]
  Actuator1-39 MON Position	[E-0139 0:2 0139007]
  Actuator1-39 MON Force	[E-0139 0:3 0139006]
  Actuator1-39 Drive Off	[E-0139 0:4 0139005]
  Actuator1-39 Drive On	[E-0139 0:5 0139004]
  Actuator1-39 CONT Position	[E-0139 0:6 0139003]
  Actuator1-39 CONT Force	[E-0139 0:7 0139002]
  Actuator1-39 Alarm Reset	[E-0139 1:1 0139020]
  Actuator1-39 Limit Release	[E-0139 1:2 013901F]
  Actuator1-39 Selected Step	[E-0139 1:3 013900E]
  Actuator1-39 Selected Load	[E-0139 1:4 013900D]
  Actuator1-39 Selected Drive	[E-0139 1:5 013900C]
  Actuator1-39 Maunakea	[E-0139 1:6 013900B]
  Actuator1-39 Sea Level	[E-0139 1:7 013900A]
  Actuator1-39 Up Limit	[E-0139 2:0 0139016]
  Actuator1-39 Driver Alarm	[E-0139 2:1 0139015]
  Actuator1-39 Error Alarm	[E-0139 2:2 0139014]
  Actuator1-39 Over Current	[E-0139 2:3 0139013]
  Actuator1-39 Over Speed	[E-0139 2:4 0139012]
  Actuator1-39 Over Load	[E-0139 2:5 0139011]
  Actuator1-39 PS Alarm	[E-0139 2:6 0139010]
  Actuator1-39 ENC Alarm	[E-0139 2:7 013900F]
  Actuator1-39 CPU Alarm	[E-0139 3:0 013901E]
  Actuator1-39 UART Alarm	[E-0139 3:1 013901D]
  Actuator1-39 HDLC Alarm	[E-0139 3:2 013901C]
  Actuator1-39 Force Card Fault	[E-0139 3:3 013901B]
  Actuator1-39 Force Sensor Fault	[E-0139 3:4 013901A]
  Actuator1-39 Under Range	[E-0139 3:5 0139019]
  Actuator1-39 Over Range	[E-0139 3:6 0139018]
  Actuator1-39 Down Limit	[E-0139 3:7 0139017]
  Actuator1-40 MON PARA	[E-0140 0:0 0140009]
  Actuator1-40 MON HYB	[E-0140 0:1 0140008]
  Actuator1-40 MON Position	[E-0140 0:2 0140007]
  Actuator1-40 MON Force	[E-0140 0:3 0140006]
  Actuator1-40 Drive Off	[E-0140 0:4 0140005]
  Actuator1-40 Drive On	[E-0140 0:5 0140004]
  Actuator1-40 CONT Position	[E-0140 0:6 0140003]
  Actuator1-40 CONT Force	[E-0140 0:7 0140002]
  Actuator1-40 Alarm Reset	[E-0140 1:1 0140020]
  Actuator1-40 Limit Release	[E-0140 1:2 014001F]
  Actuator1-40 Selected Step	[E-0140 1:3 014000E]
  Actuator1-40 Selected Load	[E-0140 1:4 014000D]
  Actuator1-40 Selected Drive	[E-0140 1:5 014000C]
  Actuator1-40 Maunakea	[E-0140 1:6 014000B]
  Actuator1-40 Sea Level	[E-0140 1:7 014000A]
  Actuator1-40 Up Limit	[E-0140 2:0 0140016]
  Actuator1-40 Driver Alarm	[E-0140 2:1 0140015]
  Actuator1-40 Error Alarm	[E-0140 2:2 0140014]
  Actuator1-40 Over Current	[E-0140 2:3 0140013]
  Actuator1-40 Over Speed	[E-0140 2:4 0140012]
  Actuator1-40 Over Load	[E-0140 2:5 0140011]
  Actuator1-40 PS Alarm	[E-0140 2:6 0140010]
  Actuator1-40 ENC Alarm	[E-0140 2:7 014000F]
  Actuator1-40 CPU Alarm	[E-0140 3:0 014001E]
  Actuator1-40 UART Alarm	[E-0140 3:1 014001D]
  Actuator1-40 HDLC Alarm	[E-0140 3:2 014001C]
  Actuator1-40 Force Card Fault	[E-0140 3:3 014001B]
  Actuator1-40 Force Sensor Fault	[E-0140 3:4 014001A]
  Actuator1-40 Under Range	[E-0140 3:5 0140019]
  Actuator1-40 Over Range	[E-0140 3:6 0140018]
  Actuator1-40 Down Limit	[E-0140 3:7 0140017]
  Actuator1-41 MON PARA	[E-0141 0:0 0141009]
  Actuator1-41 MON HYB	[E-0141 0:1 0141008]
  Actuator1-41 MON Position	[E-0141 0:2 0141007]
  Actuator1-41 MON Force	[E-0141 0:3 0141006]
  Actuator1-41 Drive Off	[E-0141 0:4 0141005]
  Actuator1-41 Drive On	[E-0141 0:5 0141004]
  Actuator1-41 CONT Position	[E-0141 0:6 0141003]
  Actuator1-41 CONT Force	[E-0141 0:7 0141002]
  Actuator1-41 Alarm Reset	[E-0141 1:1 0141020]
  Actuator1-41 Limit Release	[E-0141 1:2 014101F]
  Actuator1-41 Selected Step	[E-0141 1:3 014100E]
  Actuator1-41 Selected Load	[E-0141 1:4 014100D]
  Actuator1-41 Selected Drive	[E-0141 1:5 014100C]
  Actuator1-41 Maunakea	[E-0141 1:6 014100B]
  Actuator1-41 Sea Level	[E-0141 1:7 014100A]
  Actuator1-41 Up Limit	[E-0141 2:0 0141016]
  Actuator1-41 Driver Alarm	[E-0141 2:1 0141015]
  Actuator1-41 Error Alarm	[E-0141 2:2 0141014]
  Actuator1-41 Over Current	[E-0141 2:3 0141013]
  Actuator1-41 Over Speed	[E-0141 2:4 0141012]
  Actuator1-41 Over Load	[E-0141 2:5 0141011]
  Actuator1-41 PS Alarm	[E-0141 2:6 0141010]
  Actuator1-41 ENC Alarm	[E-0141 2:7 014100F]
  Actuator1-41 CPU Alarm	[E-0141 3:0 014101E]
  Actuator1-41 UART Alarm	[E-0141 3:1 014101D]
  Actuator1-41 HDLC Alarm	[E-0141 3:2 014101C]
  Actuator1-41 Force Card Fault	[E-0141 3:3 014101B]
  Actuator1-41 Force Sensor Fault	[E-0141 3:4 014101A]
  Actuator1-41 Under Range	[E-0141 3:5 0141019]
  Actuator1-41 Over Range	[E-0141 3:6 0141018]
  Actuator1-41 Down Limit	[E-0141 3:7 0141017]
  Actuator1-42 MON PARA	[E-0142 0:0 0142009]
  Actuator1-42 MON HYB	[E-0142 0:1 0142008]
  Actuator1-42 MON Position	[E-0142 0:2 0142007]
  Actuator1-42 MON Force	[E-0142 0:3 0142006]
  Actuator1-42 Drive Off	[E-0142 0:4 0142005]
  Actuator1-42 Drive On	[E-0142 0:5 0142004]
  Actuator1-42 CONT Position	[E-0142 0:6 0142003]
  Actuator1-42 CONT Force	[E-0142 0:7 0142002]
  Actuator1-42 Alarm Reset	[E-0142 1:1 0142020]
  Actuator1-42 Limit Release	[E-0142 1:2 014201F]
  Actuator1-42 Selected Step	[E-0142 1:3 014200E]
  Actuator1-42 Selected Load	[E-0142 1:4 014200D]
  Actuator1-42 Selected Drive	[E-0142 1:5 014200C]
  Actuator1-42 Maunakea	[E-0142 1:6 014200B]
  Actuator1-42 Sea Level	[E-0142 1:7 014200A]
  Actuator1-42 Up Limit	[E-0142 2:0 0142016]
  Actuator1-42 Driver Alarm	[E-0142 2:1 0142015]
  Actuator1-42 Error Alarm	[E-0142 2:2 0142014]
  Actuator1-42 Over Current	[E-0142 2:3 0142013]
  Actuator1-42 Over Speed	[E-0142 2:4 0142012]
  Actuator1-42 Over Load	[E-0142 2:5 0142011]
  Actuator1-42 PS Alarm	[E-0142 2:6 0142010]
  Actuator1-42 ENC Alarm	[E-0142 2:7 014200F]
  Actuator1-42 CPU Alarm	[E-0142 3:0 014201E]
  Actuator1-42 UART Alarm	[E-0142 3:1 014201D]
  Actuator1-42 HDLC Alarm	[E-0142 3:2 014201C]
  Actuator1-42 Force Card Fault	[E-0142 3:3 014201B]
  Actuator1-42 Force Sensor Fault	[E-0142 3:4 014201A]
  Actuator1-42 Under Range	[E-0142 3:5 0142019]
  Actuator1-42 Over Range	[E-0142 3:6 0142018]
  Actuator1-42 Down Limit	[E-0142 3:7 0142017]
  Actuator1-43 MON PARA	[E-0143 0:0 0143009]
  Actuator1-43 MON HYB	[E-0143 0:1 0143008]
  Actuator1-43 MON Position	[E-0143 0:2 0143007]
  Actuator1-43 MON Force	[E-0143 0:3 0143006]
  Actuator1-43 Drive Off	[E-0143 0:4 0143005]
  Actuator1-43 Drive On	[E-0143 0:5 0143004]
  Actuator1-43 CONT Position	[E-0143 0:6 0143003]
  Actuator1-43 CONT Force	[E-0143 0:7 0143002]
  Actuator1-43 Alarm Reset	[E-0143 1:1 0143020]
  Actuator1-43 Limit Release	[E-0143 1:2 014301F]
  Actuator1-43 Selected Step	[E-0143 1:3 014300E]
  Actuator1-43 Selected Load	[E-0143 1:4 014300D]
  Actuator1-43 Selected Drive	[E-0143 1:5 014300C]
  Actuator1-43 Maunakea	[E-0143 1:6 014300B]
  Actuator1-43 Sea Level	[E-0143 1:7 014300A]
  Actuator1-43 Up Limit	[E-0143 2:0 0143016]
  Actuator1-43 Driver Alarm	[E-0143 2:1 0143015]
  Actuator1-43 Error Alarm	[E-0143 2:2 0143014]
  Actuator1-43 Over Current	[E-0143 2:3 0143013]
  Actuator1-43 Over Speed	[E-0143 2:4 0143012]
  Actuator1-43 Over Load	[E-0143 2:5 0143011]
  Actuator1-43 PS Alarm	[E-0143 2:6 0143010]
  Actuator1-43 ENC Alarm	[E-0143 2:7 014300F]
  Actuator1-43 CPU Alarm	[E-0143 3:0 014301E]
  Actuator1-43 UART Alarm	[E-0143 3:1 014301D]
  Actuator1-43 HDLC Alarm	[E-0143 3:2 014301C]
  Actuator1-43 Force Card Fault	[E-0143 3:3 014301B]
  Actuator1-43 Force Sensor Fault	[E-0143 3:4 014301A]
  Actuator1-43 Under Range	[E-0143 3:5 0143019]
  Actuator1-43 Over Range	[E-0143 3:6 0143018]
  Actuator1-43 Down Limit	[E-0143 3:7 0143017]
  Actuator1-44 MON PARA	[E-0144 0:0 0144009]
  Actuator1-44 MON HYB	[E-0144 0:1 0144008]
  Actuator1-44 MON Position	[E-0144 0:2 0144007]
  Actuator1-44 MON Force	[E-0144 0:3 0144006]
  Actuator1-44 Drive Off	[E-0144 0:4 0144005]
  Actuator1-44 Drive On	[E-0144 0:5 0144004]
  Actuator1-44 CONT Position	[E-0144 0:6 0144003]
  Actuator1-44 CONT Force	[E-0144 0:7 0144002]
  Actuator1-44 Alarm Reset	[E-0144 1:1 0144020]
  Actuator1-44 Limit Release	[E-0144 1:2 014401F]
  Actuator1-44 Selected Step	[E-0144 1:3 014400E]
  Actuator1-44 Selected Load	[E-0144 1:4 014400D]
  Actuator1-44 Selected Drive	[E-0144 1:5 014400C]
  Actuator1-44 Maunakea	[E-0144 1:6 014400B]
  Actuator1-44 Sea Level	[E-0144 1:7 014400A]
  Actuator1-44 Up Limit	[E-0144 2:0 0144016]
  Actuator1-44 Driver Alarm	[E-0144 2:1 0144015]
  Actuator1-44 Error Alarm	[E-0144 2:2 0144014]
  Actuator1-44 Over Current	[E-0144 2:3 0144013]
  Actuator1-44 Over Speed	[E-0144 2:4 0144012]
  Actuator1-44 Over Load	[E-0144 2:5 0144011]
  Actuator1-44 PS Alarm	[E-0144 2:6 0144010]
  Actuator1-44 ENC Alarm	[E-0144 2:7 014400F]
  Actuator1-44 CPU Alarm	[E-0144 3:0 014401E]
  Actuator1-44 UART Alarm	[E-0144 3:1 014401D]
  Actuator1-44 HDLC Alarm	[E-0144 3:2 014401C]
  Actuator1-44 Force Card Fault	[E-0144 3:3 014401B]
  Actuator1-44 Force Sensor Fault	[E-0144 3:4 014401A]
  Actuator1-44 Under Range	[E-0144 3:5 0144019]
  Actuator1-44 Over Range	[E-0144 3:6 0144018]
  Actuator1-44 Down Limit	[E-0144 3:7 0144017]
  Actuator1-45 MON PARA	[E-0145 0:0 0145009]
  Actuator1-45 MON HYB	[E-0145 0:1 0145008]
  Actuator1-45 MON Position	[E-0145 0:2 0145007]
  Actuator1-45 MON Force	[E-0145 0:3 0145006]
  Actuator1-45 Drive Off	[E-0145 0:4 0145005]
  Actuator1-45 Drive On	[E-0145 0:5 0145004]
  Actuator1-45 CONT Position	[E-0145 0:6 0145003]
  Actuator1-45 CONT Force	[E-0145 0:7 0145002]
  Actuator1-45 Alarm Reset	[E-0145 1:1 0145020]
  Actuator1-45 Limit Release	[E-0145 1:2 014501F]
  Actuator1-45 Selected Step	[E-0145 1:3 014500E]
  Actuator1-45 Selected Load	[E-0145 1:4 014500D]
  Actuator1-45 Selected Drive	[E-0145 1:5 014500C]
  Actuator1-45 Maunakea	[E-0145 1:6 014500B]
  Actuator1-45 Sea Level	[E-0145 1:7 014500A]
  Actuator1-45 Up Limit	[E-0145 2:0 0145016]
  Actuator1-45 Driver Alarm	[E-0145 2:1 0145015]
  Actuator1-45 Error Alarm	[E-0145 2:2 0145014]
  Actuator1-45 Over Current	[E-0145 2:3 0145013]
  Actuator1-45 Over Speed	[E-0145 2:4 0145012]
  Actuator1-45 Over Load	[E-0145 2:5 0145011]
  Actuator1-45 PS Alarm	[E-0145 2:6 0145010]
  Actuator1-45 ENC Alarm	[E-0145 2:7 014500F]
  Actuator1-45 CPU Alarm	[E-0145 3:0 014501E]
  Actuator1-45 UART Alarm	[E-0145 3:1 014501D]
  Actuator1-45 HDLC Alarm	[E-0145 3:2 014501C]
  Actuator1-45 Force Card Fault	[E-0145 3:3 014501B]
  Actuator1-45 Force Sensor Fault	[E-0145 3:4 014501A]
  Actuator1-45 Under Range	[E-0145 3:5 0145019]
  Actuator1-45 Over Range	[E-0145 3:6 0145018]
  Actuator1-45 Down Limit	[E-0145 3:7 0145017]
  Actuator1-46 MON PARA	[E-0146 0:0 0146009]
  Actuator1-46 MON HYB	[E-0146 0:1 0146008]
  Actuator1-46 MON Position	[E-0146 0:2 0146007]
  Actuator1-46 MON Force	[E-0146 0:3 0146006]
  Actuator1-46 Drive Off	[E-0146 0:4 0146005]
  Actuator1-46 Drive On	[E-0146 0:5 0146004]
  Actuator1-46 CONT Position	[E-0146 0:6 0146003]
  Actuator1-46 CONT Force	[E-0146 0:7 0146002]
  Actuator1-46 Alarm Reset	[E-0146 1:1 0146020]
  Actuator1-46 Limit Release	[E-0146 1:2 014601F]
  Actuator1-46 Selected Step	[E-0146 1:3 014600E]
  Actuator1-46 Selected Load	[E-0146 1:4 014600D]
  Actuator1-46 Selected Drive	[E-0146 1:5 014600C]
  Actuator1-46 Maunakea	[E-0146 1:6 014600B]
  Actuator1-46 Sea Level	[E-0146 1:7 014600A]
  Actuator1-46 Up Limit	[E-0146 2:0 0146016]
  Actuator1-46 Driver Alarm	[E-0146 2:1 0146015]
  Actuator1-46 Error Alarm	[E-0146 2:2 0146014]
  Actuator1-46 Over Current	[E-0146 2:3 0146013]
  Actuator1-46 Over Speed	[E-0146 2:4 0146012]
  Actuator1-46 Over Load	[E-0146 2:5 0146011]
  Actuator1-46 PS Alarm	[E-0146 2:6 0146010]
  Actuator1-46 ENC Alarm	[E-0146 2:7 014600F]
  Actuator1-46 CPU Alarm	[E-0146 3:0 014601E]
  Actuator1-46 UART Alarm	[E-0146 3:1 014601D]
  Actuator1-46 HDLC Alarm	[E-0146 3:2 014601C]
  Actuator1-46 Force Card Fault	[E-0146 3:3 014601B]
  Actuator1-46 Force Sensor Fault	[E-0146 3:4 014601A]
  Actuator1-46 Under Range	[E-0146 3:5 0146019]
  Actuator1-46 Over Range	[E-0146 3:6 0146018]
  Actuator1-46 Down Limit	[E-0146 3:7 0146017]
  Actuator1-47 MON PARA	[E-0147 0:0 0147009]
  Actuator1-47 MON HYB	[E-0147 0:1 0147008]
  Actuator1-47 MON Position	[E-0147 0:2 0147007]
  Actuator1-47 MON Force	[E-0147 0:3 0147006]
  Actuator1-47 Drive Off	[E-0147 0:4 0147005]
  Actuator1-47 Drive On	[E-0147 0:5 0147004]
  Actuator1-47 CONT Position	[E-0147 0:6 0147003]
  Actuator1-47 CONT Force	[E-0147 0:7 0147002]
  Actuator1-47 Alarm Reset	[E-0147 1:1 0147020]
  Actuator1-47 Limit Release	[E-0147 1:2 014701F]
  Actuator1-47 Selected Step	[E-0147 1:3 014700E]
  Actuator1-47 Selected Load	[E-0147 1:4 014700D]
  Actuator1-47 Selected Drive	[E-0147 1:5 014700C]
  Actuator1-47 Maunakea	[E-0147 1:6 014700B]
  Actuator1-47 Sea Level	[E-0147 1:7 014700A]
  Actuator1-47 Up Limit	[E-0147 2:0 0147016]
  Actuator1-47 Driver Alarm	[E-0147 2:1 0147015]
  Actuator1-47 Error Alarm	[E-0147 2:2 0147014]
  Actuator1-47 Over Current	[E-0147 2:3 0147013]
  Actuator1-47 Over Speed	[E-0147 2:4 0147012]
  Actuator1-47 Over Load	[E-0147 2:5 0147011]
  Actuator1-47 PS Alarm	[E-0147 2:6 0147010]
  Actuator1-47 ENC Alarm	[E-0147 2:7 014700F]
  Actuator1-47 CPU Alarm	[E-0147 3:0 014701E]
  Actuator1-47 UART Alarm	[E-0147 3:1 014701D]
  Actuator1-47 HDLC Alarm	[E-0147 3:2 014701C]
  Actuator1-47 Force Card Fault	[E-0147 3:3 014701B]
  Actuator1-47 Force Sensor Fault	[E-0147 3:4 014701A]
  Actuator1-47 Under Range	[E-0147 3:5 0147019]
  Actuator1-47 Over Range	[E-0147 3:6 0147018]
  Actuator1-47 Down Limit	[E-0147 3:7 0147017]
  Actuator1-48 MON PARA	[E-0148 0:0 0148009]
  Actuator1-48 MON HYB	[E-0148 0:1 0148008]
  Actuator1-48 MON Position	[E-0148 0:2 0148007]
  Actuator1-48 MON Force	[E-0148 0:3 0148006]
  Actuator1-48 Drive Off	[E-0148 0:4 0148005]
  Actuator1-48 Drive On	[E-0148 0:5 0148004]
  Actuator1-48 CONT Position	[E-0148 0:6 0148003]
  Actuator1-48 CONT Force	[E-0148 0:7 0148002]
  Actuator1-48 Alarm Reset	[E-0148 1:1 0148020]
  Actuator1-48 Limit Release	[E-0148 1:2 014801F]
  Actuator1-48 Selected Step	[E-0148 1:3 014800E]
  Actuator1-48 Selected Load	[E-0148 1:4 014800D]
  Actuator1-48 Selected Drive	[E-0148 1:5 014800C]
  Actuator1-48 Maunakea	[E-0148 1:6 014800B]
  Actuator1-48 Sea Level	[E-0148 1:7 014800A]
  Actuator1-48 Up Limit	[E-0148 2:0 0148016]
  Actuator1-48 Driver Alarm	[E-0148 2:1 0148015]
  Actuator1-48 Error Alarm	[E-0148 2:2 0148014]
  Actuator1-48 Over Current	[E-0148 2:3 0148013]
  Actuator1-48 Over Speed	[E-0148 2:4 0148012]
  Actuator1-48 Over Load	[E-0148 2:5 0148011]
  Actuator1-48 PS Alarm	[E-0148 2:6 0148010]
  Actuator1-48 ENC Alarm	[E-0148 2:7 014800F]
  Actuator1-48 CPU Alarm	[E-0148 3:0 014801E]
  Actuator1-48 UART Alarm	[E-0148 3:1 014801D]
  Actuator1-48 HDLC Alarm	[E-0148 3:2 014801C]
  Actuator1-48 Force Card Fault	[E-0148 3:3 014801B]
  Actuator1-48 Force Sensor Fault	[E-0148 3:4 014801A]
  Actuator1-48 Under Range	[E-0148 3:5 0148019]
  Actuator1-48 Over Range	[E-0148 3:6 0148018]
  Actuator1-48 Down Limit	[E-0148 3:7 0148017]
  Actuator1-49 MON PARA	[E-0149 0:0 0149009]
  Actuator1-49 MON HYB	[E-0149 0:1 0149008]
  Actuator1-49 MON Position	[E-0149 0:2 0149007]
  Actuator1-49 MON Force	[E-0149 0:3 0149006]
  Actuator1-49 Drive Off	[E-0149 0:4 0149005]
  Actuator1-49 Drive On	[E-0149 0:5 0149004]
  Actuator1-49 CONT Position	[E-0149 0:6 0149003]
  Actuator1-49 CONT Force	[E-0149 0:7 0149002]
  Actuator1-49 Alarm Reset	[E-0149 1:1 0149020]
  Actuator1-49 Limit Release	[E-0149 1:2 014901F]
  Actuator1-49 Selected Step	[E-0149 1:3 014900E]
  Actuator1-49 Selected Load	[E-0149 1:4 014900D]
  Actuator1-49 Selected Drive	[E-0149 1:5 014900C]
  Actuator1-49 Maunakea	[E-0149 1:6 014900B]
  Actuator1-49 Sea Level	[E-0149 1:7 014900A]
  Actuator1-49 Up Limit	[E-0149 2:0 0149016]
  Actuator1-49 Driver Alarm	[E-0149 2:1 0149015]
  Actuator1-49 Error Alarm	[E-0149 2:2 0149014]
  Actuator1-49 Over Current	[E-0149 2:3 0149013]
  Actuator1-49 Over Speed	[E-0149 2:4 0149012]
  Actuator1-49 Over Load	[E-0149 2:5 0149011]
  Actuator1-49 PS Alarm	[E-0149 2:6 0149010]
  Actuator1-49 ENC Alarm	[E-0149 2:7 014900F]
  Actuator1-49 CPU Alarm	[E-0149 3:0 014901E]
  Actuator1-49 UART Alarm	[E-0149 3:1 014901D]
  Actuator1-49 HDLC Alarm	[E-0149 3:2 014901C]
  Actuator1-49 Force Card Fault	[E-0149 3:3 014901B]
  Actuator1-49 Force Sensor Fault	[E-0149 3:4 014901A]
  Actuator1-49 Under Range	[E-0149 3:5 0149019]
  Actuator1-49 Over Range	[E-0149 3:6 0149018]
  Actuator1-49 Down Limit	[E-0149 3:7 0149017]
  Actuator1-50 MON PARA	[E-0150 0:0 0150009]
  Actuator1-50 MON HYB	[E-0150 0:1 0150008]
  Actuator1-50 MON Position	[E-0150 0:2 0150007]
  Actuator1-50 MON Force	[E-0150 0:3 0150006]
  Actuator1-50 Drive Off	[E-0150 0:4 0150005]
  Actuator1-50 Drive On	[E-0150 0:5 0150004]
  Actuator1-50 CONT Position	[E-0150 0:6 0150003]
  Actuator1-50 CONT Force	[E-0150 0:7 0150002]
  Actuator1-50 Alarm Reset	[E-0150 1:1 0150020]
  Actuator1-50 Limit Release	[E-0150 1:2 015001F]
  Actuator1-50 Selected Step	[E-0150 1:3 015000E]
  Actuator1-50 Selected Load	[E-0150 1:4 015000D]
  Actuator1-50 Selected Drive	[E-0150 1:5 015000C]
  Actuator1-50 Maunakea	[E-0150 1:6 015000B]
  Actuator1-50 Sea Level	[E-0150 1:7 015000A]
  Actuator1-50 Up Limit	[E-0150 2:0 0150016]
  Actuator1-50 Driver Alarm	[E-0150 2:1 0150015]
  Actuator1-50 Error Alarm	[E-0150 2:2 0150014]
  Actuator1-50 Over Current	[E-0150 2:3 0150013]
  Actuator1-50 Over Speed	[E-0150 2:4 0150012]
  Actuator1-50 Over Load	[E-0150 2:5 0150011]
  Actuator1-50 PS Alarm	[E-0150 2:6 0150010]
  Actuator1-50 ENC Alarm	[E-0150 2:7 015000F]
  Actuator1-50 CPU Alarm	[E-0150 3:0 015001E]
  Actuator1-50 UART Alarm	[E-0150 3:1 015001D]
  Actuator1-50 HDLC Alarm	[E-0150 3:2 015001C]
  Actuator1-50 Force Card Fault	[E-0150 3:3 015001B]
  Actuator1-50 Force Sensor Fault	[E-0150 3:4 015001A]
  Actuator1-50 Under Range	[E-0150 3:5 0150019]
  Actuator1-50 Over Range	[E-0150 3:6 0150018]
  Actuator1-50 Down Limit	[E-0150 3:7 0150017]
  Actuator1-51 MON PARA	[E-0151 0:0 0151009]
  Actuator1-51 MON HYB	[E-0151 0:1 0151008]
  Actuator1-51 MON Position	[E-0151 0:2 0151007]
  Actuator1-51 MON Force	[E-0151 0:3 0151006]
  Actuator1-51 Drive Off	[E-0151 0:4 0151005]
  Actuator1-51 Drive On	[E-0151 0:5 0151004]
  Actuator1-51 CONT Position	[E-0151 0:6 0151003]
  Actuator1-51 CONT Force	[E-0151 0:7 0151002]
  Actuator1-51 Alarm Reset	[E-0151 1:1 0151020]
  Actuator1-51 Limit Release	[E-0151 1:2 015101F]
  Actuator1-51 Selected Step	[E-0151 1:3 015100E]
  Actuator1-51 Selected Load	[E-0151 1:4 015100D]
  Actuator1-51 Selected Drive	[E-0151 1:5 015100C]
  Actuator1-51 Maunakea	[E-0151 1:6 015100B]
  Actuator1-51 Sea Level	[E-0151 1:7 015100A]
  Actuator1-51 Up Limit	[E-0151 2:0 0151016]
  Actuator1-51 Driver Alarm	[E-0151 2:1 0151015]
  Actuator1-51 Error Alarm	[E-0151 2:2 0151014]
  Actuator1-51 Over Current	[E-0151 2:3 0151013]
  Actuator1-51 Over Speed	[E-0151 2:4 0151012]
  Actuator1-51 Over Load	[E-0151 2:5 0151011]
  Actuator1-51 PS Alarm	[E-0151 2:6 0151010]
  Actuator1-51 ENC Alarm	[E-0151 2:7 015100F]
  Actuator1-51 CPU Alarm	[E-0151 3:0 015101E]
  Actuator1-51 UART Alarm	[E-0151 3:1 015101D]
  Actuator1-51 HDLC Alarm	[E-0151 3:2 015101C]
  Actuator1-51 Force Card Fault	[E-0151 3:3 015101B]
  Actuator1-51 Force Sensor Fault	[E-0151 3:4 015101A]
  Actuator1-51 Under Range	[E-0151 3:5 0151019]
  Actuator1-51 Over Range	[E-0151 3:6 0151018]
  Actuator1-51 Down Limit	[E-0151 3:7 0151017]
  Actuator1-52 MON PARA	[E-0152 0:0 0152009]
  Actuator1-52 MON HYB	[E-0152 0:1 0152008]
  Actuator1-52 MON Position	[E-0152 0:2 0152007]
  Actuator1-52 MON Force	[E-0152 0:3 0152006]
  Actuator1-52 Drive Off	[E-0152 0:4 0152005]
  Actuator1-52 Drive On	[E-0152 0:5 0152004]
  Actuator1-52 CONT Position	[E-0152 0:6 0152003]
  Actuator1-52 CONT Force	[E-0152 0:7 0152002]
  Actuator1-52 Alarm Reset	[E-0152 1:1 0152020]
  Actuator1-52 Limit Release	[E-0152 1:2 015201F]
  Actuator1-52 Selected Step	[E-0152 1:3 015200E]
  Actuator1-52 Selected Load	[E-0152 1:4 015200D]
  Actuator1-52 Selected Drive	[E-0152 1:5 015200C]
  Actuator1-52 Maunakea	[E-0152 1:6 015200B]
  Actuator1-52 Sea Level	[E-0152 1:7 015200A]
  Actuator1-52 Up Limit	[E-0152 2:0 0152016]
  Actuator1-52 Driver Alarm	[E-0152 2:1 0152015]
  Actuator1-52 Error Alarm	[E-0152 2:2 0152014]
  Actuator1-52 Over Current	[E-0152 2:3 0152013]
  Actuator1-52 Over Speed	[E-0152 2:4 0152012]
  Actuator1-52 Over Load	[E-0152 2:5 0152011]
  Actuator1-52 PS Alarm	[E-0152 2:6 0152010]
  Actuator1-52 ENC Alarm	[E-0152 2:7 015200F]
  Actuator1-52 CPU Alarm	[E-0152 3:0 015201E]
  Actuator1-52 UART Alarm	[E-0152 3:1 015201D]
  Actuator1-52 HDLC Alarm	[E-0152 3:2 015201C]
  Actuator1-52 Force Card Fault	[E-0152 3:3 015201B]
  Actuator1-52 Force Sensor Fault	[E-0152 3:4 015201A]
  Actuator1-52 Under Range	[E-0152 3:5 0152019]
  Actuator1-52 Over Range	[E-0152 3:6 0152018]
  Actuator1-52 Down Limit	[E-0152 3:7 0152017]
  Actuator1-53 MON PARA	[E-0153 0:0 0153009]
  Actuator1-53 MON HYB	[E-0153 0:1 0153008]
  Actuator1-53 MON Position	[E-0153 0:2 0153007]
  Actuator1-53 MON Force	[E-0153 0:3 0153006]
  Actuator1-53 Drive Off	[E-0153 0:4 0153005]
  Actuator1-53 Drive On	[E-0153 0:5 0153004]
  Actuator1-53 CONT Position	[E-0153 0:6 0153003]
  Actuator1-53 CONT Force	[E-0153 0:7 0153002]
  Actuator1-53 Alarm Reset	[E-0153 1:1 0153020]
  Actuator1-53 Limit Release	[E-0153 1:2 015301F]
  Actuator1-53 Selected Step	[E-0153 1:3 015300E]
  Actuator1-53 Selected Load	[E-0153 1:4 015300D]
  Actuator1-53 Selected Drive	[E-0153 1:5 015300C]
  Actuator1-53 Maunakea	[E-0153 1:6 015300B]
  Actuator1-53 Sea Level	[E-0153 1:7 015300A]
  Actuator1-53 Up Limit	[E-0153 2:0 0153016]
  Actuator1-53 Driver Alarm	[E-0153 2:1 0153015]
  Actuator1-53 Error Alarm	[E-0153 2:2 0153014]
  Actuator1-53 Over Current	[E-0153 2:3 0153013]
  Actuator1-53 Over Speed	[E-0153 2:4 0153012]
  Actuator1-53 Over Load	[E-0153 2:5 0153011]
  Actuator1-53 PS Alarm	[E-0153 2:6 0153010]
  Actuator1-53 ENC Alarm	[E-0153 2:7 015300F]
  Actuator1-53 CPU Alarm	[E-0153 3:0 015301E]
  Actuator1-53 UART Alarm	[E-0153 3:1 015301D]
  Actuator1-53 HDLC Alarm	[E-0153 3:2 015301C]
  Actuator1-53 Force Card Fault	[E-0153 3:3 015301B]
  Actuator1-53 Force Sensor Fault	[E-0153 3:4 015301A]
  Actuator1-53 Under Range	[E-0153 3:5 0153019]
  Actuator1-53 Over Range	[E-0153 3:6 0153018]
  Actuator1-53 Down Limit	[E-0153 3:7 0153017]
  Actuator1-54 MON PARA	[E-0154 0:0 0154009]
  Actuator1-54 MON HYB	[E-0154 0:1 0154008]
  Actuator1-54 MON Position	[E-0154 0:2 0154007]
  Actuator1-54 MON Force	[E-0154 0:3 0154006]
  Actuator1-54 Drive Off	[E-0154 0:4 0154005]
  Actuator1-54 Drive On	[E-0154 0:5 0154004]
  Actuator1-54 CONT Position	[E-0154 0:6 0154003]
  Actuator1-54 CONT Force	[E-0154 0:7 0154002]
  Actuator1-54 Alarm Reset	[E-0154 1:1 0154020]
  Actuator1-54 Limit Release	[E-0154 1:2 015401F]
  Actuator1-54 Selected Step	[E-0154 1:3 015400E]
  Actuator1-54 Selected Load	[E-0154 1:4 015400D]
  Actuator1-54 Selected Drive	[E-0154 1:5 015400C]
  Actuator1-54 Maunakea	[E-0154 1:6 015400B]
  Actuator1-54 Sea Level	[E-0154 1:7 015400A]
  Actuator1-54 Up Limit	[E-0154 2:0 0154016]
  Actuator1-54 Driver Alarm	[E-0154 2:1 0154015]
  Actuator1-54 Error Alarm	[E-0154 2:2 0154014]
  Actuator1-54 Over Current	[E-0154 2:3 0154013]
  Actuator1-54 Over Speed	[E-0154 2:4 0154012]
  Actuator1-54 Over Load	[E-0154 2:5 0154011]
  Actuator1-54 PS Alarm	[E-0154 2:6 0154010]
  Actuator1-54 ENC Alarm	[E-0154 2:7 015400F]
  Actuator1-54 CPU Alarm	[E-0154 3:0 015401E]
  Actuator1-54 UART Alarm	[E-0154 3:1 015401D]
  Actuator1-54 HDLC Alarm	[E-0154 3:2 015401C]
  Actuator1-54 Force Card Fault	[E-0154 3:3 015401B]
  Actuator1-54 Force Sensor Fault	[E-0154 3:4 015401A]
  Actuator1-54 Under Range	[E-0154 3:5 0154019]
  Actuator1-54 Over Range	[E-0154 3:6 0154018]
  Actuator1-54 Down Limit	[E-0154 3:7 0154017]
  Actuator1-55 MON PARA	[E-0155 0:0 0155009]
  Actuator1-55 MON HYB	[E-0155 0:1 0155008]
  Actuator1-55 MON Position	[E-0155 0:2 0155007]
  Actuator1-55 MON Force	[E-0155 0:3 0155006]
  Actuator1-55 Drive Off	[E-0155 0:4 0155005]
  Actuator1-55 Drive On	[E-0155 0:5 0155004]
  Actuator1-55 CONT Position	[E-0155 0:6 0155003]
  Actuator1-55 CONT Force	[E-0155 0:7 0155002]
  Actuator1-55 Alarm Reset	[E-0155 1:1 0155020]
  Actuator1-55 Limit Release	[E-0155 1:2 015501F]
  Actuator1-55 Selected Step	[E-0155 1:3 015500E]
  Actuator1-55 Selected Load	[E-0155 1:4 015500D]
  Actuator1-55 Selected Drive	[E-0155 1:5 015500C]
  Actuator1-55 Maunakea	[E-0155 1:6 015500B]
  Actuator1-55 Sea Level	[E-0155 1:7 015500A]
  Actuator1-55 Up Limit	[E-0155 2:0 0155016]
  Actuator1-55 Driver Alarm	[E-0155 2:1 0155015]
  Actuator1-55 Error Alarm	[E-0155 2:2 0155014]
  Actuator1-55 Over Current	[E-0155 2:3 0155013]
  Actuator1-55 Over Speed	[E-0155 2:4 0155012]
  Actuator1-55 Over Load	[E-0155 2:5 0155011]
  Actuator1-55 PS Alarm	[E-0155 2:6 0155010]
  Actuator1-55 ENC Alarm	[E-0155 2:7 015500F]
  Actuator1-55 CPU Alarm	[E-0155 3:0 015501E]
  Actuator1-55 UART Alarm	[E-0155 3:1 015501D]
  Actuator1-55 HDLC Alarm	[E-0155 3:2 015501C]
  Actuator1-55 Force Card Fault	[E-0155 3:3 015501B]
  Actuator1-55 Force Sensor Fault	[E-0155 3:4 015501A]
  Actuator1-55 Under Range	[E-0155 3:5 0155019]
  Actuator1-55 Over Range	[E-0155 3:6 0155018]
  Actuator1-55 Down Limit	[E-0155 3:7 0155017]
  Actuator1-56 MON PARA	[E-0156 0:0 0156009]
  Actuator1-56 MON HYB	[E-0156 0:1 0156008]
  Actuator1-56 MON Position	[E-0156 0:2 0156007]
  Actuator1-56 MON Force	[E-0156 0:3 0156006]
  Actuator1-56 Drive Off	[E-0156 0:4 0156005]
  Actuator1-56 Drive On	[E-0156 0:5 0156004]
  Actuator1-56 CONT Position	[E-0156 0:6 0156003]
  Actuator1-56 CONT Force	[E-0156 0:7 0156002]
  Actuator1-56 Alarm Reset	[E-0156 1:1 0156020]
  Actuator1-56 Limit Release	[E-0156 1:2 015601F]
  Actuator1-56 Selected Step	[E-0156 1:3 015600E]
  Actuator1-56 Selected Load	[E-0156 1:4 015600D]
  Actuator1-56 Selected Drive	[E-0156 1:5 015600C]
  Actuator1-56 Maunakea	[E-0156 1:6 015600B]
  Actuator1-56 Sea Level	[E-0156 1:7 015600A]
  Actuator1-56 Up Limit	[E-0156 2:0 0156016]
  Actuator1-56 Driver Alarm	[E-0156 2:1 0156015]
  Actuator1-56 Error Alarm	[E-0156 2:2 0156014]
  Actuator1-56 Over Current	[E-0156 2:3 0156013]
  Actuator1-56 Over Speed	[E-0156 2:4 0156012]
  Actuator1-56 Over Load	[E-0156 2:5 0156011]
  Actuator1-56 PS Alarm	[E-0156 2:6 0156010]
  Actuator1-56 ENC Alarm	[E-0156 2:7 015600F]
  Actuator1-56 CPU Alarm	[E-0156 3:0 015601E]
  Actuator1-56 UART Alarm	[E-0156 3:1 015601D]
  Actuator1-56 HDLC Alarm	[E-0156 3:2 015601C]
  Actuator1-56 Force Card Fault	[E-0156 3:3 015601B]
  Actuator1-56 Force Sensor Fault	[E-0156 3:4 015601A]
  Actuator1-56 Under Range	[E-0156 3:5 0156019]
  Actuator1-56 Over Range	[E-0156 3:6 0156018]
  Actuator1-56 Down Limit	[E-0156 3:7 0156017]
  Actuator1-57 MON PARA	[E-0157 0:0 0157009]
  Actuator1-57 MON HYB	[E-0157 0:1 0157008]
  Actuator1-57 MON Position	[E-0157 0:2 0157007]
  Actuator1-57 MON Force	[E-0157 0:3 0157006]
  Actuator1-57 Drive Off	[E-0157 0:4 0157005]
  Actuator1-57 Drive On	[E-0157 0:5 0157004]
  Actuator1-57 CONT Position	[E-0157 0:6 0157003]
  Actuator1-57 CONT Force	[E-0157 0:7 0157002]
  Actuator1-57 Alarm Reset	[E-0157 1:1 0157020]
  Actuator1-57 Limit Release	[E-0157 1:2 015701F]
  Actuator1-57 Selected Step	[E-0157 1:3 015700E]
  Actuator1-57 Selected Load	[E-0157 1:4 015700D]
  Actuator1-57 Selected Drive	[E-0157 1:5 015700C]
  Actuator1-57 Maunakea	[E-0157 1:6 015700B]
  Actuator1-57 Sea Level	[E-0157 1:7 015700A]
  Actuator1-57 Up Limit	[E-0157 2:0 0157016]
  Actuator1-57 Driver Alarm	[E-0157 2:1 0157015]
  Actuator1-57 Error Alarm	[E-0157 2:2 0157014]
  Actuator1-57 Over Current	[E-0157 2:3 0157013]
  Actuator1-57 Over Speed	[E-0157 2:4 0157012]
  Actuator1-57 Over Load	[E-0157 2:5 0157011]
  Actuator1-57 PS Alarm	[E-0157 2:6 0157010]
  Actuator1-57 ENC Alarm	[E-0157 2:7 015700F]
  Actuator1-57 CPU Alarm	[E-0157 3:0 015701E]
  Actuator1-57 UART Alarm	[E-0157 3:1 015701D]
  Actuator1-57 HDLC Alarm	[E-0157 3:2 015701C]
  Actuator1-57 Force Card Fault	[E-0157 3:3 015701B]
  Actuator1-57 Force Sensor Fault	[E-0157 3:4 015701A]
  Actuator1-57 Under Range	[E-0157 3:5 0157019]
  Actuator1-57 Over Range	[E-0157 3:6 0157018]
  Actuator1-57 Down Limit	[E-0157 3:7 0157017]
  Actuator1-58 MON PARA	[E-0158 0:0 0158009]
  Actuator1-58 MON HYB	[E-0158 0:1 0158008]
  Actuator1-58 MON Position	[E-0158 0:2 0158007]
  Actuator1-58 MON Force	[E-0158 0:3 0158006]
  Actuator1-58 Drive Off	[E-0158 0:4 0158005]
  Actuator1-58 Drive On	[E-0158 0:5 0158004]
  Actuator1-58 CONT Position	[E-0158 0:6 0158003]
  Actuator1-58 CONT Force	[E-0158 0:7 0158002]
  Actuator1-58 Alarm Reset	[E-0158 1:1 0158020]
  Actuator1-58 Limit Release	[E-0158 1:2 015801F]
  Actuator1-58 Selected Step	[E-0158 1:3 015800E]
  Actuator1-58 Selected Load	[E-0158 1:4 015800D]
  Actuator1-58 Selected Drive	[E-0158 1:5 015800C]
  Actuator1-58 Maunakea	[E-0158 1:6 015800B]
  Actuator1-58 Sea Level	[E-0158 1:7 015800A]
  Actuator1-58 Up Limit	[E-0158 2:0 0158016]
  Actuator1-58 Driver Alarm	[E-0158 2:1 0158015]
  Actuator1-58 Error Alarm	[E-0158 2:2 0158014]
  Actuator1-58 Over Current	[E-0158 2:3 0158013]
  Actuator1-58 Over Speed	[E-0158 2:4 0158012]
  Actuator1-58 Over Load	[E-0158 2:5 0158011]
  Actuator1-58 PS Alarm	[E-0158 2:6 0158010]
  Actuator1-58 ENC Alarm	[E-0158 2:7 015800F]
  Actuator1-58 CPU Alarm	[E-0158 3:0 015801E]
  Actuator1-58 UART Alarm	[E-0158 3:1 015801D]
  Actuator1-58 HDLC Alarm	[E-0158 3:2 015801C]
  Actuator1-58 Force Card Fault	[E-0158 3:3 015801B]
  Actuator1-58 Force Sensor Fault	[E-0158 3:4 015801A]
  Actuator1-58 Under Range	[E-0158 3:5 0158019]
  Actuator1-58 Over Range	[E-0158 3:6 0158018]
  Actuator1-58 Down Limit	[E-0158 3:7 0158017]
  Actuator1-59 MON PARA	[E-0159 0:0 0159009]
  Actuator1-59 MON HYB	[E-0159 0:1 0159008]
  Actuator1-59 MON Position	[E-0159 0:2 0159007]
  Actuator1-59 MON Force	[E-0159 0:3 0159006]
  Actuator1-59 Drive Off	[E-0159 0:4 0159005]
  Actuator1-59 Drive On	[E-0159 0:5 0159004]
  Actuator1-59 CONT Position	[E-0159 0:6 0159003]
  Actuator1-59 CONT Force	[E-0159 0:7 0159002]
  Actuator1-59 Alarm Reset	[E-0159 1:1 0159020]
  Actuator1-59 Limit Release	[E-0159 1:2 015901F]
  Actuator1-59 Selected Step	[E-0159 1:3 015900E]
  Actuator1-59 Selected Load	[E-0159 1:4 015900D]
  Actuator1-59 Selected Drive	[E-0159 1:5 015900C]
  Actuator1-59 Maunakea	[E-0159 1:6 015900B]
  Actuator1-59 Sea Level	[E-0159 1:7 015900A]
  Actuator1-59 Up Limit	[E-0159 2:0 0159016]
  Actuator1-59 Driver Alarm	[E-0159 2:1 0159015]
  Actuator1-59 Error Alarm	[E-0159 2:2 0159014]
  Actuator1-59 Over Current	[E-0159 2:3 0159013]
  Actuator1-59 Over Speed	[E-0159 2:4 0159012]
  Actuator1-59 Over Load	[E-0159 2:5 0159011]
  Actuator1-59 PS Alarm	[E-0159 2:6 0159010]
  Actuator1-59 ENC Alarm	[E-0159 2:7 015900F]
  Actuator1-59 CPU Alarm	[E-0159 3:0 015901E]
  Actuator1-59 UART Alarm	[E-0159 3:1 015901D]
  Actuator1-59 HDLC Alarm	[E-0159 3:2 015901C]
  Actuator1-59 Force Card Fault	[E-0159 3:3 015901B]
  Actuator1-59 Force Sensor Fault	[E-0159 3:4 015901A]
  Actuator1-59 Under Range	[E-0159 3:5 0159019]
  Actuator1-59 Over Range	[E-0159 3:6 0159018]
  Actuator1-59 Down Limit	[E-0159 3:7 0159017]
  Actuator1-60 MON PARA	[E-0160 0:0 0160009]
  Actuator1-60 MON HYB	[E-0160 0:1 0160008]
  Actuator1-60 MON Position	[E-0160 0:2 0160007]
  Actuator1-60 MON Force	[E-0160 0:3 0160006]
  Actuator1-60 Drive Off	[E-0160 0:4 0160005]
  Actuator1-60 Drive On	[E-0160 0:5 0160004]
  Actuator1-60 CONT Position	[E-0160 0:6 0160003]
  Actuator1-60 CONT Force	[E-0160 0:7 0160002]
  Actuator1-60 Alarm Reset	[E-0160 1:1 0160020]
  Actuator1-60 Limit Release	[E-0160 1:2 016001F]
  Actuator1-60 Selected Step	[E-0160 1:3 016000E]
  Actuator1-60 Selected Load	[E-0160 1:4 016000D]
  Actuator1-60 Selected Drive	[E-0160 1:5 016000C]
  Actuator1-60 Maunakea	[E-0160 1:6 016000B]
  Actuator1-60 Sea Level	[E-0160 1:7 016000A]
  Actuator1-60 Up Limit	[E-0160 2:0 0160016]
  Actuator1-60 Driver Alarm	[E-0160 2:1 0160015]
  Actuator1-60 Error Alarm	[E-0160 2:2 0160014]
  Actuator1-60 Over Current	[E-0160 2:3 0160013]
  Actuator1-60 Over Speed	[E-0160 2:4 0160012]
  Actuator1-60 Over Load	[E-0160 2:5 0160011]
  Actuator1-60 PS Alarm	[E-0160 2:6 0160010]
  Actuator1-60 ENC Alarm	[E-0160 2:7 016000F]
  Actuator1-60 CPU Alarm	[E-0160 3:0 016001E]
  Actuator1-60 UART Alarm	[E-0160 3:1 016001D]
  Actuator1-60 HDLC Alarm	[E-0160 3:2 016001C]
  Actuator1-60 Force Card Fault	[E-0160 3:3 016001B]
  Actuator1-60 Force Sensor Fault	[E-0160 3:4 016001A]
  Actuator1-60 Under Range	[E-0160 3:5 0160019]
  Actuator1-60 Over Range	[E-0160 3:6 0160018]
  Actuator1-60 Down Limit	[E-0160 3:7 0160017]
  Actuator1-61 MON PARA	[E-0161 0:0 0161009]
  Actuator1-61 MON HYB	[E-0161 0:1 0161008]
  Actuator1-61 MON Position	[E-0161 0:2 0161007]
  Actuator1-61 MON Force	[E-0161 0:3 0161006]
  Actuator1-61 Drive Off	[E-0161 0:4 0161005]
  Actuator1-61 Drive On	[E-0161 0:5 0161004]
  Actuator1-61 CONT Position	[E-0161 0:6 0161003]
  Actuator1-61 CONT Force	[E-0161 0:7 0161002]
  Actuator1-61 Alarm Reset	[E-0161 1:1 0161020]
  Actuator1-61 Limit Release	[E-0161 1:2 016101F]
  Actuator1-61 Selected Step	[E-0161 1:3 016100E]
  Actuator1-61 Selected Load	[E-0161 1:4 016100D]
  Actuator1-61 Selected Drive	[E-0161 1:5 016100C]
  Actuator1-61 Maunakea	[E-0161 1:6 016100B]
  Actuator1-61 Sea Level	[E-0161 1:7 016100A]
  Actuator1-61 Up Limit	[E-0161 2:0 0161016]
  Actuator1-61 Driver Alarm	[E-0161 2:1 0161015]
  Actuator1-61 Error Alarm	[E-0161 2:2 0161014]
  Actuator1-61 Over Current	[E-0161 2:3 0161013]
  Actuator1-61 Over Speed	[E-0161 2:4 0161012]
  Actuator1-61 Over Load	[E-0161 2:5 0161011]
  Actuator1-61 PS Alarm	[E-0161 2:6 0161010]
  Actuator1-61 ENC Alarm	[E-0161 2:7 016100F]
  Actuator1-61 CPU Alarm	[E-0161 3:0 016101E]
  Actuator1-61 UART Alarm	[E-0161 3:1 016101D]
  Actuator1-61 HDLC Alarm	[E-0161 3:2 016101C]
  Actuator1-61 Force Card Fault	[E-0161 3:3 016101B]
  Actuator1-61 Force Sensor Fault	[E-0161 3:4 016101A]
  Actuator1-61 Under Range	[E-0161 3:5 0161019]
  Actuator1-61 Over Range	[E-0161 3:6 0161018]
  Actuator1-61 Down Limit	[E-0161 3:7 0161017]
  Actuator1-62 MON PARA	[E-0162 0:0 0162009]
  Actuator1-62 MON HYB	[E-0162 0:1 0162008]
  Actuator1-62 MON Position	[E-0162 0:2 0162007]
  Actuator1-62 MON Force	[E-0162 0:3 0162006]
  Actuator1-62 Drive Off	[E-0162 0:4 0162005]
  Actuator1-62 Drive On	[E-0162 0:5 0162004]
  Actuator1-62 CONT Position	[E-0162 0:6 0162003]
  Actuator1-62 CONT Force	[E-0162 0:7 0162002]
  Actuator1-62 Alarm Reset	[E-0162 1:1 0162020]
  Actuator1-62 Limit Release	[E-0162 1:2 016201F]
  Actuator1-62 Selected Step	[E-0162 1:3 016200E]
  Actuator1-62 Selected Load	[E-0162 1:4 016200D]
  Actuator1-62 Selected Drive	[E-0162 1:5 016200C]
  Actuator1-62 Maunakea	[E-0162 1:6 016200B]
  Actuator1-62 Sea Level	[E-0162 1:7 016200A]
  Actuator1-62 Up Limit	[E-0162 2:0 0162016]
  Actuator1-62 Driver Alarm	[E-0162 2:1 0162015]
  Actuator1-62 Error Alarm	[E-0162 2:2 0162014]
  Actuator1-62 Over Current	[E-0162 2:3 0162013]
  Actuator1-62 Over Speed	[E-0162 2:4 0162012]
  Actuator1-62 Over Load	[E-0162 2:5 0162011]
  Actuator1-62 PS Alarm	[E-0162 2:6 0162010]
  Actuator1-62 ENC Alarm	[E-0162 2:7 016200F]
  Actuator1-62 CPU Alarm	[E-0162 3:0 016201E]
  Actuator1-62 UART Alarm	[E-0162 3:1 016201D]
  Actuator1-62 HDLC Alarm	[E-0162 3:2 016201C]
  Actuator1-62 Force Card Fault	[E-0162 3:3 016201B]
  Actuator1-62 Force Sensor Fault	[E-0162 3:4 016201A]
  Actuator1-62 Under Range	[E-0162 3:5 0162019]
  Actuator1-62 Over Range	[E-0162 3:6 0162018]
  Actuator1-62 Down Limit	[E-0162 3:7 0162017]
  Actuator1-63 MON PARA	[E-0163 0:0 0163009]
  Actuator1-63 MON HYB	[E-0163 0:1 0163008]
  Actuator1-63 MON Position	[E-0163 0:2 0163007]
  Actuator1-63 MON Force	[E-0163 0:3 0163006]
  Actuator1-63 Drive Off	[E-0163 0:4 0163005]
  Actuator1-63 Drive On	[E-0163 0:5 0163004]
  Actuator1-63 CONT Position	[E-0163 0:6 0163003]
  Actuator1-63 CONT Force	[E-0163 0:7 0163002]
  Actuator1-63 Alarm Reset	[E-0163 1:1 0163020]
  Actuator1-63 Limit Release	[E-0163 1:2 016301F]
  Actuator1-63 Selected Step	[E-0163 1:3 016300E]
  Actuator1-63 Selected Load	[E-0163 1:4 016300D]
  Actuator1-63 Selected Drive	[E-0163 1:5 016300C]
  Actuator1-63 Maunakea	[E-0163 1:6 016300B]
  Actuator1-63 Sea Level	[E-0163 1:7 016300A]
  Actuator1-63 Up Limit	[E-0163 2:0 0163016]
  Actuator1-63 Driver Alarm	[E-0163 2:1 0163015]
  Actuator1-63 Error Alarm	[E-0163 2:2 0163014]
  Actuator1-63 Over Current	[E-0163 2:3 0163013]
  Actuator1-63 Over Speed	[E-0163 2:4 0163012]
  Actuator1-63 Over Load	[E-0163 2:5 0163011]
  Actuator1-63 PS Alarm	[E-0163 2:6 0163010]
  Actuator1-63 ENC Alarm	[E-0163 2:7 016300F]
  Actuator1-63 CPU Alarm	[E-0163 3:0 016301E]
  Actuator1-63 UART Alarm	[E-0163 3:1 016301D]
  Actuator1-63 HDLC Alarm	[E-0163 3:2 016301C]
  Actuator1-63 Force Card Fault	[E-0163 3:3 016301B]
  Actuator1-63 Force Sensor Fault	[E-0163 3:4 016301A]
  Actuator1-63 Under Range	[E-0163 3:5 0163019]
  Actuator1-63 Over Range	[E-0163 3:6 0163018]
  Actuator1-63 Down Limit	[E-0163 3:7 0163017]
  Actuator1-64 MON PARA	[E-0164 0:0 0164009]
  Actuator1-64 MON HYB	[E-0164 0:1 0164008]
  Actuator1-64 MON Position	[E-0164 0:2 0164007]
  Actuator1-64 MON Force	[E-0164 0:3 0164006]
  Actuator1-64 Drive Off	[E-0164 0:4 0164005]
  Actuator1-64 Drive On	[E-0164 0:5 0164004]
  Actuator1-64 CONT Position	[E-0164 0:6 0164003]
  Actuator1-64 CONT Force	[E-0164 0:7 0164002]
  Actuator1-64 Alarm Reset	[E-0164 1:1 0164020]
  Actuator1-64 Limit Release	[E-0164 1:2 016401F]
  Actuator1-64 Selected Step	[E-0164 1:3 016400E]
  Actuator1-64 Selected Load	[E-0164 1:4 016400D]
  Actuator1-64 Selected Drive	[E-0164 1:5 016400C]
  Actuator1-64 Maunakea	[E-0164 1:6 016400B]
  Actuator1-64 Sea Level	[E-0164 1:7 016400A]
  Actuator1-64 Up Limit	[E-0164 2:0 0164016]
  Actuator1-64 Driver Alarm	[E-0164 2:1 0164015]
  Actuator1-64 Error Alarm	[E-0164 2:2 0164014]
  Actuator1-64 Over Current	[E-0164 2:3 0164013]
  Actuator1-64 Over Speed	[E-0164 2:4 0164012]
  Actuator1-64 Over Load	[E-0164 2:5 0164011]
  Actuator1-64 PS Alarm	[E-0164 2:6 0164010]
  Actuator1-64 ENC Alarm	[E-0164 2:7 016400F]
  Actuator1-64 CPU Alarm	[E-0164 3:0 016401E]
  Actuator1-64 UART Alarm	[E-0164 3:1 016401D]
  Actuator1-64 HDLC Alarm	[E-0164 3:2 016401C]
  Actuator1-64 Force Card Fault	[E-0164 3:3 016401B]
  Actuator1-64 Force Sensor Fault	[E-0164 3:4 016401A]
  Actuator1-64 Under Range	[E-0164 3:5 0164019]
  Actuator1-64 Over Range	[E-0164 3:6 0164018]
  Actuator1-64 Down Limit	[E-0164 3:7 0164017]
  Actuator1-65 MON PARA	[E-0165 0:0 0165009]
  Actuator1-65 MON HYB	[E-0165 0:1 0165008]
  Actuator1-65 MON Position	[E-0165 0:2 0165007]
  Actuator1-65 MON Force	[E-0165 0:3 0165006]
  Actuator1-65 Drive Off	[E-0165 0:4 0165005]
  Actuator1-65 Drive On	[E-0165 0:5 0165004]
  Actuator1-65 CONT Position	[E-0165 0:6 0165003]
  Actuator1-65 CONT Force	[E-0165 0:7 0165002]
  Actuator1-65 Alarm Reset	[E-0165 1:1 0165020]
  Actuator1-65 Limit Release	[E-0165 1:2 016501F]
  Actuator1-65 Selected Step	[E-0165 1:3 016500E]
  Actuator1-65 Selected Load	[E-0165 1:4 016500D]
  Actuator1-65 Selected Drive	[E-0165 1:5 016500C]
  Actuator1-65 Maunakea	[E-0165 1:6 016500B]
  Actuator1-65 Sea Level	[E-0165 1:7 016500A]
  Actuator1-65 Up Limit	[E-0165 2:0 0165016]
  Actuator1-65 Driver Alarm	[E-0165 2:1 0165015]
  Actuator1-65 Error Alarm	[E-0165 2:2 0165014]
  Actuator1-65 Over Current	[E-0165 2:3 0165013]
  Actuator1-65 Over Speed	[E-0165 2:4 0165012]
  Actuator1-65 Over Load	[E-0165 2:5 0165011]
  Actuator1-65 PS Alarm	[E-0165 2:6 0165010]
  Actuator1-65 ENC Alarm	[E-0165 2:7 016500F]
  Actuator1-65 CPU Alarm	[E-0165 3:0 016501E]
  Actuator1-65 UART Alarm	[E-0165 3:1 016501D]
  Actuator1-65 HDLC Alarm	[E-0165 3:2 016501C]
  Actuator1-65 Force Card Fault	[E-0165 3:3 016501B]
  Actuator1-65 Force Sensor Fault	[E-0165 3:4 016501A]
  Actuator1-65 Under Range	[E-0165 3:5 0165019]
  Actuator1-65 Over Range	[E-0165 3:6 0165018]
  Actuator1-65 Down Limit	[E-0165 3:7 0165017]
  Actuator1-66 MON PARA	[E-0166 0:0 0166009]
  Actuator1-66 MON HYB	[E-0166 0:1 0166008]
  Actuator1-66 MON Position	[E-0166 0:2 0166007]
  Actuator1-66 MON Force	[E-0166 0:3 0166006]
  Actuator1-66 Drive Off	[E-0166 0:4 0166005]
  Actuator1-66 Drive On	[E-0166 0:5 0166004]
  Actuator1-66 CONT Position	[E-0166 0:6 0166003]
  Actuator1-66 CONT Force	[E-0166 0:7 0166002]
  Actuator1-66 Alarm Reset	[E-0166 1:1 0166020]
  Actuator1-66 Limit Release	[E-0166 1:2 016601F]
  Actuator1-66 Selected Step	[E-0166 1:3 016600E]
  Actuator1-66 Selected Load	[E-0166 1:4 016600D]
  Actuator1-66 Selected Drive	[E-0166 1:5 016600C]
  Actuator1-66 Maunakea	[E-0166 1:6 016600B]
  Actuator1-66 Sea Level	[E-0166 1:7 016600A]
  Actuator1-66 Up Limit	[E-0166 2:0 0166016]
  Actuator1-66 Driver Alarm	[E-0166 2:1 0166015]
  Actuator1-66 Error Alarm	[E-0166 2:2 0166014]
  Actuator1-66 Over Current	[E-0166 2:3 0166013]
  Actuator1-66 Over Speed	[E-0166 2:4 0166012]
  Actuator1-66 Over Load	[E-0166 2:5 0166011]
  Actuator1-66 PS Alarm	[E-0166 2:6 0166010]
  Actuator1-66 ENC Alarm	[E-0166 2:7 016600F]
  Actuator1-66 CPU Alarm	[E-0166 3:0 016601E]
  Actuator1-66 UART Alarm	[E-0166 3:1 016601D]
  Actuator1-66 HDLC Alarm	[E-0166 3:2 016601C]
  Actuator1-66 Force Card Fault	[E-0166 3:3 016601B]
  Actuator1-66 Force Sensor Fault	[E-0166 3:4 016601A]
  Actuator1-66 Under Range	[E-0166 3:5 0166019]
  Actuator1-66 Over Range	[E-0166 3:6 0166018]
  Actuator1-66 Down Limit	[E-0166 3:7 0166017]
  Actuator1-67 MON PARA	[E-0167 0:0 0167009]
  Actuator1-67 MON HYB	[E-0167 0:1 0167008]
  Actuator1-67 MON Position	[E-0167 0:2 0167007]
  Actuator1-67 MON Force	[E-0167 0:3 0167006]
  Actuator1-67 Drive Off	[E-0167 0:4 0167005]
  Actuator1-67 Drive On	[E-0167 0:5 0167004]
  Actuator1-67 CONT Position	[E-0167 0:6 0167003]
  Actuator1-67 CONT Force	[E-0167 0:7 0167002]
  Actuator1-67 Alarm Reset	[E-0167 1:1 0167020]
  Actuator1-67 Limit Release	[E-0167 1:2 016701F]
  Actuator1-67 Selected Step	[E-0167 1:3 016700E]
  Actuator1-67 Selected Load	[E-0167 1:4 016700D]
  Actuator1-67 Selected Drive	[E-0167 1:5 016700C]
  Actuator1-67 Maunakea	[E-0167 1:6 016700B]
  Actuator1-67 Sea Level	[E-0167 1:7 016700A]
  Actuator1-67 Up Limit	[E-0167 2:0 0167016]
  Actuator1-67 Driver Alarm	[E-0167 2:1 0167015]
  Actuator1-67 Error Alarm	[E-0167 2:2 0167014]
  Actuator1-67 Over Current	[E-0167 2:3 0167013]
  Actuator1-67 Over Speed	[E-0167 2:4 0167012]
  Actuator1-67 Over Load	[E-0167 2:5 0167011]
  Actuator1-67 PS Alarm	[E-0167 2:6 0167010]
  Actuator1-67 ENC Alarm	[E-0167 2:7 016700F]
  Actuator1-67 CPU Alarm	[E-0167 3:0 016701E]
  Actuator1-67 UART Alarm	[E-0167 3:1 016701D]
  Actuator1-67 HDLC Alarm	[E-0167 3:2 016701C]
  Actuator1-67 Force Card Fault	[E-0167 3:3 016701B]
  Actuator1-67 Force Sensor Fault	[E-0167 3:4 016701A]
  Actuator1-67 Under Range	[E-0167 3:5 0167019]
  Actuator1-67 Over Range	[E-0167 3:6 0167018]
  Actuator1-67 Down Limit	[E-0167 3:7 0167017]
  Actuator1-68 MON PARA	[E-0168 0:0 0168009]
  Actuator1-68 MON HYB	[E-0168 0:1 0168008]
  Actuator1-68 MON Position	[E-0168 0:2 0168007]
  Actuator1-68 MON Force	[E-0168 0:3 0168006]
  Actuator1-68 Drive Off	[E-0168 0:4 0168005]
  Actuator1-68 Drive On	[E-0168 0:5 0168004]
  Actuator1-68 CONT Position	[E-0168 0:6 0168003]
  Actuator1-68 CONT Force	[E-0168 0:7 0168002]
  Actuator1-68 Alarm Reset	[E-0168 1:1 0168020]
  Actuator1-68 Limit Release	[E-0168 1:2 016801F]
  Actuator1-68 Selected Step	[E-0168 1:3 016800E]
  Actuator1-68 Selected Load	[E-0168 1:4 016800D]
  Actuator1-68 Selected Drive	[E-0168 1:5 016800C]
  Actuator1-68 Maunakea	[E-0168 1:6 016800B]
  Actuator1-68 Sea Level	[E-0168 1:7 016800A]
  Actuator1-68 Up Limit	[E-0168 2:0 0168016]
  Actuator1-68 Driver Alarm	[E-0168 2:1 0168015]
  Actuator1-68 Error Alarm	[E-0168 2:2 0168014]
  Actuator1-68 Over Current	[E-0168 2:3 0168013]
  Actuator1-68 Over Speed	[E-0168 2:4 0168012]
  Actuator1-68 Over Load	[E-0168 2:5 0168011]
  Actuator1-68 PS Alarm	[E-0168 2:6 0168010]
  Actuator1-68 ENC Alarm	[E-0168 2:7 016800F]
  Actuator1-68 CPU Alarm	[E-0168 3:0 016801E]
  Actuator1-68 UART Alarm	[E-0168 3:1 016801D]
  Actuator1-68 HDLC Alarm	[E-0168 3:2 016801C]
  Actuator1-68 Force Card Fault	[E-0168 3:3 016801B]
  Actuator1-68 Force Sensor Fault	[E-0168 3:4 016801A]
  Actuator1-68 Under Range	[E-0168 3:5 0168019]
  Actuator1-68 Over Range	[E-0168 3:6 0168018]
  Actuator1-68 Down Limit	[E-0168 3:7 0168017]
  Actuator1-69 MON PARA	[E-0169 0:0 0169009]
  Actuator1-69 MON HYB	[E-0169 0:1 0169008]
  Actuator1-69 MON Position	[E-0169 0:2 0169007]
  Actuator1-69 MON Force	[E-0169 0:3 0169006]
  Actuator1-69 Drive Off	[E-0169 0:4 0169005]
  Actuator1-69 Drive On	[E-0169 0:5 0169004]
  Actuator1-69 CONT Position	[E-0169 0:6 0169003]
  Actuator1-69 CONT Force	[E-0169 0:7 0169002]
  Actuator1-69 Alarm Reset	[E-0169 1:1 0169020]
  Actuator1-69 Limit Release	[E-0169 1:2 016901F]
  Actuator1-69 Selected Step	[E-0169 1:3 016900E]
  Actuator1-69 Selected Load	[E-0169 1:4 016900D]
  Actuator1-69 Selected Drive	[E-0169 1:5 016900C]
  Actuator1-69 Maunakea	[E-0169 1:6 016900B]
  Actuator1-69 Sea Level	[E-0169 1:7 016900A]
  Actuator1-69 Up Limit	[E-0169 2:0 0169016]
  Actuator1-69 Driver Alarm	[E-0169 2:1 0169015]
  Actuator1-69 Error Alarm	[E-0169 2:2 0169014]
  Actuator1-69 Over Current	[E-0169 2:3 0169013]
  Actuator1-69 Over Speed	[E-0169 2:4 0169012]
  Actuator1-69 Over Load	[E-0169 2:5 0169011]
  Actuator1-69 PS Alarm	[E-0169 2:6 0169010]
  Actuator1-69 ENC Alarm	[E-0169 2:7 016900F]
  Actuator1-69 CPU Alarm	[E-0169 3:0 016901E]
  Actuator1-69 UART Alarm	[E-0169 3:1 016901D]
  Actuator1-69 HDLC Alarm	[E-0169 3:2 016901C]
  Actuator1-69 Force Card Fault	[E-0169 3:3 016901B]
  Actuator1-69 Force Sensor Fault	[E-0169 3:4 016901A]
  Actuator1-69 Under Range	[E-0169 3:5 0169019]
  Actuator1-69 Over Range	[E-0169 3:6 0169018]
  Actuator1-69 Down Limit	[E-0169 3:7 0169017]
  Actuator2-00 MON PARA	[E-0200 0:0 0200009]
  Actuator2-00 MON HYB	[E-0200 0:1 0200008]
  Actuator2-00 MON Position	[E-0200 0:2 0200007]
  Actuator2-00 MON Force	[E-0200 0:3 0200006]
  Actuator2-00 Drive Off	[E-0200 0:4 0200005]
  Actuator2-00 Drive On	[E-0200 0:5 0200004]
  Actuator2-00 CONT Position	[E-0200 0:6 0200003]
  Actuator2-00 CONT Force	[E-0200 0:7 0200002]
  Actuator2-00 Alarm Reset	[E-0200 1:1 0200020]
  Actuator2-00 Limit Release	[E-0200 1:2 020001F]
  Actuator2-00 Selected Step	[E-0200 1:3 020000E]
  Actuator2-00 Selected Load	[E-0200 1:4 020000D]
  Actuator2-00 Selected Drive	[E-0200 1:5 020000C]
  Actuator2-00 Maunakea	[E-0200 1:6 020000B]
  Actuator2-00 Sea Level	[E-0200 1:7 020000A]
  Actuator2-00 Up Limit	[E-0200 2:0 0200016]
  Actuator2-00 Driver Alarm	[E-0200 2:1 0200015]
  Actuator2-00 Error Alarm	[E-0200 2:2 0200014]
  Actuator2-00 Over Current	[E-0200 2:3 0200013]
  Actuator2-00 Over Speed	[E-0200 2:4 0200012]
  Actuator2-00 Over Load	[E-0200 2:5 0200011]
  Actuator2-00 PS Alarm	[E-0200 2:6 0200010]
  Actuator2-00 ENC Alarm	[E-0200 2:7 020000F]
  Actuator2-00 CPU Alarm	[E-0200 3:0 020001E]
  Actuator2-00 UART Alarm	[E-0200 3:1 020001D]
  Actuator2-00 HDLC Alarm	[E-0200 3:2 020001C]
  Actuator2-00 Force Card Fault	[E-0200 3:3 020001B]
  Actuator2-00 Force Sensor Fault	[E-0200 3:4 020001A]
  Actuator2-00 Under Range	[E-0200 3:5 0200019]
  Actuator2-00 Over Range	[E-0200 3:6 0200018]
  Actuator2-00 Down Limit	[E-0200 3:7 0200017]
  Actuator2-01 MON PARA	[E-0201 0:0 0201009]
  Actuator2-01 MON HYB	[E-0201 0:1 0201008]
  Actuator2-01 MON Position	[E-0201 0:2 0201007]
  Actuator2-01 MON Force	[E-0201 0:3 0201006]
  Actuator2-01 Drive Off	[E-0201 0:4 0201005]
  Actuator2-01 Drive On	[E-0201 0:5 0201004]
  Actuator2-01 CONT Position	[E-0201 0:6 0201003]
  Actuator2-01 CONT Force	[E-0201 0:7 0201002]
  Actuator2-01 Alarm Reset	[E-0201 1:1 0201020]
  Actuator2-01 Limit Release	[E-0201 1:2 020101F]
  Actuator2-01 Selected Step	[E-0201 1:3 020100E]
  Actuator2-01 Selected Load	[E-0201 1:4 020100D]
  Actuator2-01 Selected Drive	[E-0201 1:5 020100C]
  Actuator2-01 Maunakea	[E-0201 1:6 020100B]
  Actuator2-01 Sea Level	[E-0201 1:7 020100A]
  Actuator2-01 Up Limit	[E-0201 2:0 0201016]
  Actuator2-01 Driver Alarm	[E-0201 2:1 0201015]
  Actuator2-01 Error Alarm	[E-0201 2:2 0201014]
  Actuator2-01 Over Current	[E-0201 2:3 0201013]
  Actuator2-01 Over Speed	[E-0201 2:4 0201012]
  Actuator2-01 Over Load	[E-0201 2:5 0201011]
  Actuator2-01 PS Alarm	[E-0201 2:6 0201010]
  Actuator2-01 ENC Alarm	[E-0201 2:7 020100F]
  Actuator2-01 CPU Alarm	[E-0201 3:0 020101E]
  Actuator2-01 UART Alarm	[E-0201 3:1 020101D]
  Actuator2-01 HDLC Alarm	[E-0201 3:2 020101C]
  Actuator2-01 Force Card Fault	[E-0201 3:3 020101B]
  Actuator2-01 Force Sensor Fault	[E-0201 3:4 020101A]
  Actuator2-01 Under Range	[E-0201 3:5 0201019]
  Actuator2-01 Over Range	[E-0201 3:6 0201018]
  Actuator2-01 Down Limit	[E-0201 3:7 0201017]
  Actuator2-02 MON PARA	[E-0202 0:0 0202009]
  Actuator2-02 MON HYB	[E-0202 0:1 0202008]
  Actuator2-02 MON Position	[E-0202 0:2 0202007]
  Actuator2-02 MON Force	[E-0202 0:3 0202006]
  Actuator2-02 Drive Off	[E-0202 0:4 0202005]
  Actuator2-02 Drive On	[E-0202 0:5 0202004]
  Actuator2-02 CONT Position	[E-0202 0:6 0202003]
  Actuator2-02 CONT Force	[E-0202 0:7 0202002]
  Actuator2-02 Alarm Reset	[E-0202 1:1 0202020]
  Actuator2-02 Limit Release	[E-0202 1:2 020201F]
  Actuator2-02 Selected Step	[E-0202 1:3 020200E]
  Actuator2-02 Selected Load	[E-0202 1:4 020200D]
  Actuator2-02 Selected Drive	[E-0202 1:5 020200C]
  Actuator2-02 Maunakea	[E-0202 1:6 020200B]
  Actuator2-02 Sea Level	[E-0202 1:7 020200A]
  Actuator2-02 Up Limit	[E-0202 2:0 0202016]
  Actuator2-02 Driver Alarm	[E-0202 2:1 0202015]
  Actuator2-02 Error Alarm	[E-0202 2:2 0202014]
  Actuator2-02 Over Current	[E-0202 2:3 0202013]
  Actuator2-02 Over Speed	[E-0202 2:4 0202012]
  Actuator2-02 Over Load	[E-0202 2:5 0202011]
  Actuator2-02 PS Alarm	[E-0202 2:6 0202010]
  Actuator2-02 ENC Alarm	[E-0202 2:7 020200F]
  Actuator2-02 CPU Alarm	[E-0202 3:0 020201E]
  Actuator2-02 UART Alarm	[E-0202 3:1 020201D]
  Actuator2-02 HDLC Alarm	[E-0202 3:2 020201C]
  Actuator2-02 Force Card Fault	[E-0202 3:3 020201B]
  Actuator2-02 Force Sensor Fault	[E-0202 3:4 020201A]
  Actuator2-02 Under Range	[E-0202 3:5 0202019]
  Actuator2-02 Over Range	[E-0202 3:6 0202018]
  Actuator2-02 Down Limit	[E-0202 3:7 0202017]
  Actuator2-03 MON PARA	[E-0203 0:0 0203009]
  Actuator2-03 MON HYB	[E-0203 0:1 0203008]
  Actuator2-03 MON Position	[E-0203 0:2 0203007]
  Actuator2-03 MON Force	[E-0203 0:3 0203006]
  Actuator2-03 Drive Off	[E-0203 0:4 0203005]
  Actuator2-03 Drive On	[E-0203 0:5 0203004]
  Actuator2-03 CONT Position	[E-0203 0:6 0203003]
  Actuator2-03 CONT Force	[E-0203 0:7 0203002]
  Actuator2-03 Alarm Reset	[E-0203 1:1 0203020]
  Actuator2-03 Limit Release	[E-0203 1:2 020301F]
  Actuator2-03 Selected Step	[E-0203 1:3 020300E]
  Actuator2-03 Selected Load	[E-0203 1:4 020300D]
  Actuator2-03 Selected Drive	[E-0203 1:5 020300C]
  Actuator2-03 Maunakea	[E-0203 1:6 020300B]
  Actuator2-03 Sea Level	[E-0203 1:7 020300A]
  Actuator2-03 Up Limit	[E-0203 2:0 0203016]
  Actuator2-03 Driver Alarm	[E-0203 2:1 0203015]
  Actuator2-03 Error Alarm	[E-0203 2:2 0203014]
  Actuator2-03 Over Current	[E-0203 2:3 0203013]
  Actuator2-03 Over Speed	[E-0203 2:4 0203012]
  Actuator2-03 Over Load	[E-0203 2:5 0203011]
  Actuator2-03 PS Alarm	[E-0203 2:6 0203010]
  Actuator2-03 ENC Alarm	[E-0203 2:7 020300F]
  Actuator2-03 CPU Alarm	[E-0203 3:0 020301E]
  Actuator2-03 UART Alarm	[E-0203 3:1 020301D]
  Actuator2-03 HDLC Alarm	[E-0203 3:2 020301C]
  Actuator2-03 Force Card Fault	[E-0203 3:3 020301B]
  Actuator2-03 Force Sensor Fault	[E-0203 3:4 020301A]
  Actuator2-03 Under Range	[E-0203 3:5 0203019]
  Actuator2-03 Over Range	[E-0203 3:6 0203018]
  Actuator2-03 Down Limit	[E-0203 3:7 0203017]
  Actuator2-04 MON PARA	[E-0204 0:0 0204009]
  Actuator2-04 MON HYB	[E-0204 0:1 0204008]
  Actuator2-04 MON Position	[E-0204 0:2 0204007]
  Actuator2-04 MON Force	[E-0204 0:3 0204006]
  Actuator2-04 Drive Off	[E-0204 0:4 0204005]
  Actuator2-04 Drive On	[E-0204 0:5 0204004]
  Actuator2-04 CONT Position	[E-0204 0:6 0204003]
  Actuator2-04 CONT Force	[E-0204 0:7 0204002]
  Actuator2-04 Alarm Reset	[E-0204 1:1 0204020]
  Actuator2-04 Limit Release	[E-0204 1:2 020401F]
  Actuator2-04 Selected Step	[E-0204 1:3 020400E]
  Actuator2-04 Selected Load	[E-0204 1:4 020400D]
  Actuator2-04 Selected Drive	[E-0204 1:5 020400C]
  Actuator2-04 Maunakea	[E-0204 1:6 020400B]
  Actuator2-04 Sea Level	[E-0204 1:7 020400A]
  Actuator2-04 Up Limit	[E-0204 2:0 0204016]
  Actuator2-04 Driver Alarm	[E-0204 2:1 0204015]
  Actuator2-04 Error Alarm	[E-0204 2:2 0204014]
  Actuator2-04 Over Current	[E-0204 2:3 0204013]
  Actuator2-04 Over Speed	[E-0204 2:4 0204012]
  Actuator2-04 Over Load	[E-0204 2:5 0204011]
  Actuator2-04 PS Alarm	[E-0204 2:6 0204010]
  Actuator2-04 ENC Alarm	[E-0204 2:7 020400F]
  Actuator2-04 CPU Alarm	[E-0204 3:0 020401E]
  Actuator2-04 UART Alarm	[E-0204 3:1 020401D]
  Actuator2-04 HDLC Alarm	[E-0204 3:2 020401C]
  Actuator2-04 Force Card Fault	[E-0204 3:3 020401B]
  Actuator2-04 Force Sensor Fault	[E-0204 3:4 020401A]
  Actuator2-04 Under Range	[E-0204 3:5 0204019]
  Actuator2-04 Over Range	[E-0204 3:6 0204018]
  Actuator2-04 Down Limit	[E-0204 3:7 0204017]
  Actuator2-05 MON PARA	[E-0205 0:0 0205009]
  Actuator2-05 MON HYB	[E-0205 0:1 0205008]
  Actuator2-05 MON Position	[E-0205 0:2 0205007]
  Actuator2-05 MON Force	[E-0205 0:3 0205006]
  Actuator2-05 Drive Off	[E-0205 0:4 0205005]
  Actuator2-05 Drive On	[E-0205 0:5 0205004]
  Actuator2-05 CONT Position	[E-0205 0:6 0205003]
  Actuator2-05 CONT Force	[E-0205 0:7 0205002]
  Actuator2-05 Alarm Reset	[E-0205 1:1 0205020]
  Actuator2-05 Limit Release	[E-0205 1:2 020501F]
  Actuator2-05 Selected Step	[E-0205 1:3 020500E]
  Actuator2-05 Selected Load	[E-0205 1:4 020500D]
  Actuator2-05 Selected Drive	[E-0205 1:5 020500C]
  Actuator2-05 Maunakea	[E-0205 1:6 020500B]
  Actuator2-05 Sea Level	[E-0205 1:7 020500A]
  Actuator2-05 Up Limit	[E-0205 2:0 0205016]
  Actuator2-05 Driver Alarm	[E-0205 2:1 0205015]
  Actuator2-05 Error Alarm	[E-0205 2:2 0205014]
  Actuator2-05 Over Current	[E-0205 2:3 0205013]
  Actuator2-05 Over Speed	[E-0205 2:4 0205012]
  Actuator2-05 Over Load	[E-0205 2:5 0205011]
  Actuator2-05 PS Alarm	[E-0205 2:6 0205010]
  Actuator2-05 ENC Alarm	[E-0205 2:7 020500F]
  Actuator2-05 CPU Alarm	[E-0205 3:0 020501E]
  Actuator2-05 UART Alarm	[E-0205 3:1 020501D]
  Actuator2-05 HDLC Alarm	[E-0205 3:2 020501C]
  Actuator2-05 Force Card Fault	[E-0205 3:3 020501B]
  Actuator2-05 Force Sensor Fault	[E-0205 3:4 020501A]
  Actuator2-05 Under Range	[E-0205 3:5 0205019]
  Actuator2-05 Over Range	[E-0205 3:6 0205018]
  Actuator2-05 Down Limit	[E-0205 3:7 0205017]
  Actuator2-06 MON PARA	[E-0206 0:0 0206009]
  Actuator2-06 MON HYB	[E-0206 0:1 0206008]
  Actuator2-06 MON Position	[E-0206 0:2 0206007]
  Actuator2-06 MON Force	[E-0206 0:3 0206006]
  Actuator2-06 Drive Off	[E-0206 0:4 0206005]
  Actuator2-06 Drive On	[E-0206 0:5 0206004]
  Actuator2-06 CONT Position	[E-0206 0:6 0206003]
  Actuator2-06 CONT Force	[E-0206 0:7 0206002]
  Actuator2-06 Alarm Reset	[E-0206 1:1 0206020]
  Actuator2-06 Limit Release	[E-0206 1:2 020601F]
  Actuator2-06 Selected Step	[E-0206 1:3 020600E]
  Actuator2-06 Selected Load	[E-0206 1:4 020600D]
  Actuator2-06 Selected Drive	[E-0206 1:5 020600C]
  Actuator2-06 Maunakea	[E-0206 1:6 020600B]
  Actuator2-06 Sea Level	[E-0206 1:7 020600A]
  Actuator2-06 Up Limit	[E-0206 2:0 0206016]
  Actuator2-06 Driver Alarm	[E-0206 2:1 0206015]
  Actuator2-06 Error Alarm	[E-0206 2:2 0206014]
  Actuator2-06 Over Current	[E-0206 2:3 0206013]
  Actuator2-06 Over Speed	[E-0206 2:4 0206012]
  Actuator2-06 Over Load	[E-0206 2:5 0206011]
  Actuator2-06 PS Alarm	[E-0206 2:6 0206010]
  Actuator2-06 ENC Alarm	[E-0206 2:7 020600F]
  Actuator2-06 CPU Alarm	[E-0206 3:0 020601E]
  Actuator2-06 UART Alarm	[E-0206 3:1 020601D]
  Actuator2-06 HDLC Alarm	[E-0206 3:2 020601C]
  Actuator2-06 Force Card Fault	[E-0206 3:3 020601B]
  Actuator2-06 Force Sensor Fault	[E-0206 3:4 020601A]
  Actuator2-06 Under Range	[E-0206 3:5 0206019]
  Actuator2-06 Over Range	[E-0206 3:6 0206018]
  Actuator2-06 Down Limit	[E-0206 3:7 0206017]
  Actuator2-07 MON PARA	[E-0207 0:0 0207009]
  Actuator2-07 MON HYB	[E-0207 0:1 0207008]
  Actuator2-07 MON Position	[E-0207 0:2 0207007]
  Actuator2-07 MON Force	[E-0207 0:3 0207006]
  Actuator2-07 Drive Off	[E-0207 0:4 0207005]
  Actuator2-07 Drive On	[E-0207 0:5 0207004]
  Actuator2-07 CONT Position	[E-0207 0:6 0207003]
  Actuator2-07 CONT Force	[E-0207 0:7 0207002]
  Actuator2-07 Alarm Reset	[E-0207 1:1 0207020]
  Actuator2-07 Limit Release	[E-0207 1:2 020701F]
  Actuator2-07 Selected Step	[E-0207 1:3 020700E]
  Actuator2-07 Selected Load	[E-0207 1:4 020700D]
  Actuator2-07 Selected Drive	[E-0207 1:5 020700C]
  Actuator2-07 Maunakea	[E-0207 1:6 020700B]
  Actuator2-07 Sea Level	[E-0207 1:7 020700A]
  Actuator2-07 Up Limit	[E-0207 2:0 0207016]
  Actuator2-07 Driver Alarm	[E-0207 2:1 0207015]
  Actuator2-07 Error Alarm	[E-0207 2:2 0207014]
  Actuator2-07 Over Current	[E-0207 2:3 0207013]
  Actuator2-07 Over Speed	[E-0207 2:4 0207012]
  Actuator2-07 Over Load	[E-0207 2:5 0207011]
  Actuator2-07 PS Alarm	[E-0207 2:6 0207010]
  Actuator2-07 ENC Alarm	[E-0207 2:7 020700F]
  Actuator2-07 CPU Alarm	[E-0207 3:0 020701E]
  Actuator2-07 UART Alarm	[E-0207 3:1 020701D]
  Actuator2-07 HDLC Alarm	[E-0207 3:2 020701C]
  Actuator2-07 Force Card Fault	[E-0207 3:3 020701B]
  Actuator2-07 Force Sensor Fault	[E-0207 3:4 020701A]
  Actuator2-07 Under Range	[E-0207 3:5 0207019]
  Actuator2-07 Over Range	[E-0207 3:6 0207018]
  Actuator2-07 Down Limit	[E-0207 3:7 0207017]
  Actuator2-08 MON PARA	[E-0208 0:0 0208009]
  Actuator2-08 MON HYB	[E-0208 0:1 0208008]
  Actuator2-08 MON Position	[E-0208 0:2 0208007]
  Actuator2-08 MON Force	[E-0208 0:3 0208006]
  Actuator2-08 Drive Off	[E-0208 0:4 0208005]
  Actuator2-08 Drive On	[E-0208 0:5 0208004]
  Actuator2-08 CONT Position	[E-0208 0:6 0208003]
  Actuator2-08 CONT Force	[E-0208 0:7 0208002]
  Actuator2-08 Alarm Reset	[E-0208 1:1 0208020]
  Actuator2-08 Limit Release	[E-0208 1:2 020801F]
  Actuator2-08 Selected Step	[E-0208 1:3 020800E]
  Actuator2-08 Selected Load	[E-0208 1:4 020800D]
  Actuator2-08 Selected Drive	[E-0208 1:5 020800C]
  Actuator2-08 Maunakea	[E-0208 1:6 020800B]
  Actuator2-08 Sea Level	[E-0208 1:7 020800A]
  Actuator2-08 Up Limit	[E-0208 2:0 0208016]
  Actuator2-08 Driver Alarm	[E-0208 2:1 0208015]
  Actuator2-08 Error Alarm	[E-0208 2:2 0208014]
  Actuator2-08 Over Current	[E-0208 2:3 0208013]
  Actuator2-08 Over Speed	[E-0208 2:4 0208012]
  Actuator2-08 Over Load	[E-0208 2:5 0208011]
  Actuator2-08 PS Alarm	[E-0208 2:6 0208010]
  Actuator2-08 ENC Alarm	[E-0208 2:7 020800F]
  Actuator2-08 CPU Alarm	[E-0208 3:0 020801E]
  Actuator2-08 UART Alarm	[E-0208 3:1 020801D]
  Actuator2-08 HDLC Alarm	[E-0208 3:2 020801C]
  Actuator2-08 Force Card Fault	[E-0208 3:3 020801B]
  Actuator2-08 Force Sensor Fault	[E-0208 3:4 020801A]
  Actuator2-08 Under Range	[E-0208 3:5 0208019]
  Actuator2-08 Over Range	[E-0208 3:6 0208018]
  Actuator2-08 Down Limit	[E-0208 3:7 0208017]
  Actuator2-09 MON PARA	[E-0209 0:0 0209009]
  Actuator2-09 MON HYB	[E-0209 0:1 0209008]
  Actuator2-09 MON Position	[E-0209 0:2 0209007]
  Actuator2-09 MON Force	[E-0209 0:3 0209006]
  Actuator2-09 Drive Off	[E-0209 0:4 0209005]
  Actuator2-09 Drive On	[E-0209 0:5 0209004]
  Actuator2-09 CONT Position	[E-0209 0:6 0209003]
  Actuator2-09 CONT Force	[E-0209 0:7 0209002]
  Actuator2-09 Alarm Reset	[E-0209 1:1 0209020]
  Actuator2-09 Limit Release	[E-0209 1:2 020901F]
  Actuator2-09 Selected Step	[E-0209 1:3 020900E]
  Actuator2-09 Selected Load	[E-0209 1:4 020900D]
  Actuator2-09 Selected Drive	[E-0209 1:5 020900C]
  Actuator2-09 Maunakea	[E-0209 1:6 020900B]
  Actuator2-09 Sea Level	[E-0209 1:7 020900A]
  Actuator2-09 Up Limit	[E-0209 2:0 0209016]
  Actuator2-09 Driver Alarm	[E-0209 2:1 0209015]
  Actuator2-09 Error Alarm	[E-0209 2:2 0209014]
  Actuator2-09 Over Current	[E-0209 2:3 0209013]
  Actuator2-09 Over Speed	[E-0209 2:4 0209012]
  Actuator2-09 Over Load	[E-0209 2:5 0209011]
  Actuator2-09 PS Alarm	[E-0209 2:6 0209010]
  Actuator2-09 ENC Alarm	[E-0209 2:7 020900F]
  Actuator2-09 CPU Alarm	[E-0209 3:0 020901E]
  Actuator2-09 UART Alarm	[E-0209 3:1 020901D]
  Actuator2-09 HDLC Alarm	[E-0209 3:2 020901C]
  Actuator2-09 Force Card Fault	[E-0209 3:3 020901B]
  Actuator2-09 Force Sensor Fault	[E-0209 3:4 020901A]
  Actuator2-09 Under Range	[E-0209 3:5 0209019]
  Actuator2-09 Over Range	[E-0209 3:6 0209018]
  Actuator2-09 Down Limit	[E-0209 3:7 0209017]
  Actuator2-10 MON PARA	[E-0210 0:0 0210009]
  Actuator2-10 MON HYB	[E-0210 0:1 0210008]
  Actuator2-10 MON Position	[E-0210 0:2 0210007]
  Actuator2-10 MON Force	[E-0210 0:3 0210006]
  Actuator2-10 Drive Off	[E-0210 0:4 0210005]
  Actuator2-10 Drive On	[E-0210 0:5 0210004]
  Actuator2-10 CONT Position	[E-0210 0:6 0210003]
  Actuator2-10 CONT Force	[E-0210 0:7 0210002]
  Actuator2-10 Alarm Reset	[E-0210 1:1 0210020]
  Actuator2-10 Limit Release	[E-0210 1:2 021001F]
  Actuator2-10 Selected Step	[E-0210 1:3 021000E]
  Actuator2-10 Selected Load	[E-0210 1:4 021000D]
  Actuator2-10 Selected Drive	[E-0210 1:5 021000C]
  Actuator2-10 Maunakea	[E-0210 1:6 021000B]
  Actuator2-10 Sea Level	[E-0210 1:7 021000A]
  Actuator2-10 Up Limit	[E-0210 2:0 0210016]
  Actuator2-10 Driver Alarm	[E-0210 2:1 0210015]
  Actuator2-10 Error Alarm	[E-0210 2:2 0210014]
  Actuator2-10 Over Current	[E-0210 2:3 0210013]
  Actuator2-10 Over Speed	[E-0210 2:4 0210012]
  Actuator2-10 Over Load	[E-0210 2:5 0210011]
  Actuator2-10 PS Alarm	[E-0210 2:6 0210010]
  Actuator2-10 ENC Alarm	[E-0210 2:7 021000F]
  Actuator2-10 CPU Alarm	[E-0210 3:0 021001E]
  Actuator2-10 UART Alarm	[E-0210 3:1 021001D]
  Actuator2-10 HDLC Alarm	[E-0210 3:2 021001C]
  Actuator2-10 Force Card Fault	[E-0210 3:3 021001B]
  Actuator2-10 Force Sensor Fault	[E-0210 3:4 021001A]
  Actuator2-10 Under Range	[E-0210 3:5 0210019]
  Actuator2-10 Over Range	[E-0210 3:6 0210018]
  Actuator2-10 Down Limit	[E-0210 3:7 0210017]
  Actuator2-11 MON PARA	[E-0211 0:0 0211009]
  Actuator2-11 MON HYB	[E-0211 0:1 0211008]
  Actuator2-11 MON Position	[E-0211 0:2 0211007]
  Actuator2-11 MON Force	[E-0211 0:3 0211006]
  Actuator2-11 Drive Off	[E-0211 0:4 0211005]
  Actuator2-11 Drive On	[E-0211 0:5 0211004]
  Actuator2-11 CONT Position	[E-0211 0:6 0211003]
  Actuator2-11 CONT Force	[E-0211 0:7 0211002]
  Actuator2-11 Alarm Reset	[E-0211 1:1 0211020]
  Actuator2-11 Limit Release	[E-0211 1:2 021101F]
  Actuator2-11 Selected Step	[E-0211 1:3 021100E]
  Actuator2-11 Selected Load	[E-0211 1:4 021100D]
  Actuator2-11 Selected Drive	[E-0211 1:5 021100C]
  Actuator2-11 Maunakea	[E-0211 1:6 021100B]
  Actuator2-11 Sea Level	[E-0211 1:7 021100A]
  Actuator2-11 Up Limit	[E-0211 2:0 0211016]
  Actuator2-11 Driver Alarm	[E-0211 2:1 0211015]
  Actuator2-11 Error Alarm	[E-0211 2:2 0211014]
  Actuator2-11 Over Current	[E-0211 2:3 0211013]
  Actuator2-11 Over Speed	[E-0211 2:4 0211012]
  Actuator2-11 Over Load	[E-0211 2:5 0211011]
  Actuator2-11 PS Alarm	[E-0211 2:6 0211010]
  Actuator2-11 ENC Alarm	[E-0211 2:7 021100F]
  Actuator2-11 CPU Alarm	[E-0211 3:0 021101E]
  Actuator2-11 UART Alarm	[E-0211 3:1 021101D]
  Actuator2-11 HDLC Alarm	[E-0211 3:2 021101C]
  Actuator2-11 Force Card Fault	[E-0211 3:3 021101B]
  Actuator2-11 Force Sensor Fault	[E-0211 3:4 021101A]
  Actuator2-11 Under Range	[E-0211 3:5 0211019]
  Actuator2-11 Over Range	[E-0211 3:6 0211018]
  Actuator2-11 Down Limit	[E-0211 3:7 0211017]
  Actuator2-12 MON PARA	[E-0212 0:0 0212009]
  Actuator2-12 MON HYB	[E-0212 0:1 0212008]
  Actuator2-12 MON Position	[E-0212 0:2 0212007]
  Actuator2-12 MON Force	[E-0212 0:3 0212006]
  Actuator2-12 Drive Off	[E-0212 0:4 0212005]
  Actuator2-12 Drive On	[E-0212 0:5 0212004]
  Actuator2-12 CONT Position	[E-0212 0:6 0212003]
  Actuator2-12 CONT Force	[E-0212 0:7 0212002]
  Actuator2-12 Alarm Reset	[E-0212 1:1 0212020]
  Actuator2-12 Limit Release	[E-0212 1:2 021201F]
  Actuator2-12 Selected Step	[E-0212 1:3 021200E]
  Actuator2-12 Selected Load	[E-0212 1:4 021200D]
  Actuator2-12 Selected Drive	[E-0212 1:5 021200C]
  Actuator2-12 Maunakea	[E-0212 1:6 021200B]
  Actuator2-12 Sea Level	[E-0212 1:7 021200A]
  Actuator2-12 Up Limit	[E-0212 2:0 0212016]
  Actuator2-12 Driver Alarm	[E-0212 2:1 0212015]
  Actuator2-12 Error Alarm	[E-0212 2:2 0212014]
  Actuator2-12 Over Current	[E-0212 2:3 0212013]
  Actuator2-12 Over Speed	[E-0212 2:4 0212012]
  Actuator2-12 Over Load	[E-0212 2:5 0212011]
  Actuator2-12 PS Alarm	[E-0212 2:6 0212010]
  Actuator2-12 ENC Alarm	[E-0212 2:7 021200F]
  Actuator2-12 CPU Alarm	[E-0212 3:0 021201E]
  Actuator2-12 UART Alarm	[E-0212 3:1 021201D]
  Actuator2-12 HDLC Alarm	[E-0212 3:2 021201C]
  Actuator2-12 Force Card Fault	[E-0212 3:3 021201B]
  Actuator2-12 Force Sensor Fault	[E-0212 3:4 021201A]
  Actuator2-12 Under Range	[E-0212 3:5 0212019]
  Actuator2-12 Over Range	[E-0212 3:6 0212018]
  Actuator2-12 Down Limit	[E-0212 3:7 0212017]
  Actuator2-13 MON PARA	[E-0213 0:0 0213009]
  Actuator2-13 MON HYB	[E-0213 0:1 0213008]
  Actuator2-13 MON Position	[E-0213 0:2 0213007]
  Actuator2-13 MON Force	[E-0213 0:3 0213006]
  Actuator2-13 Drive Off	[E-0213 0:4 0213005]
  Actuator2-13 Drive On	[E-0213 0:5 0213004]
  Actuator2-13 CONT Position	[E-0213 0:6 0213003]
  Actuator2-13 CONT Force	[E-0213 0:7 0213002]
  Actuator2-13 Alarm Reset	[E-0213 1:1 0213020]
  Actuator2-13 Limit Release	[E-0213 1:2 021301F]
  Actuator2-13 Selected Step	[E-0213 1:3 021300E]
  Actuator2-13 Selected Load	[E-0213 1:4 021300D]
  Actuator2-13 Selected Drive	[E-0213 1:5 021300C]
  Actuator2-13 Maunakea	[E-0213 1:6 021300B]
  Actuator2-13 Sea Level	[E-0213 1:7 021300A]
  Actuator2-13 Up Limit	[E-0213 2:0 0213016]
  Actuator2-13 Driver Alarm	[E-0213 2:1 0213015]
  Actuator2-13 Error Alarm	[E-0213 2:2 0213014]
  Actuator2-13 Over Current	[E-0213 2:3 0213013]
  Actuator2-13 Over Speed	[E-0213 2:4 0213012]
  Actuator2-13 Over Load	[E-0213 2:5 0213011]
  Actuator2-13 PS Alarm	[E-0213 2:6 0213010]
  Actuator2-13 ENC Alarm	[E-0213 2:7 021300F]
  Actuator2-13 CPU Alarm	[E-0213 3:0 021301E]
  Actuator2-13 UART Alarm	[E-0213 3:1 021301D]
  Actuator2-13 HDLC Alarm	[E-0213 3:2 021301C]
  Actuator2-13 Force Card Fault	[E-0213 3:3 021301B]
  Actuator2-13 Force Sensor Fault	[E-0213 3:4 021301A]
  Actuator2-13 Under Range	[E-0213 3:5 0213019]
  Actuator2-13 Over Range	[E-0213 3:6 0213018]
  Actuator2-13 Down Limit	[E-0213 3:7 0213017]
  Actuator2-14 MON PARA	[E-0214 0:0 0214009]
  Actuator2-14 MON HYB	[E-0214 0:1 0214008]
  Actuator2-14 MON Position	[E-0214 0:2 0214007]
  Actuator2-14 MON Force	[E-0214 0:3 0214006]
  Actuator2-14 Drive Off	[E-0214 0:4 0214005]
  Actuator2-14 Drive On	[E-0214 0:5 0214004]
  Actuator2-14 CONT Position	[E-0214 0:6 0214003]
  Actuator2-14 CONT Force	[E-0214 0:7 0214002]
  Actuator2-14 Alarm Reset	[E-0214 1:1 0214020]
  Actuator2-14 Limit Release	[E-0214 1:2 021401F]
  Actuator2-14 Selected Step	[E-0214 1:3 021400E]
  Actuator2-14 Selected Load	[E-0214 1:4 021400D]
  Actuator2-14 Selected Drive	[E-0214 1:5 021400C]
  Actuator2-14 Maunakea	[E-0214 1:6 021400B]
  Actuator2-14 Sea Level	[E-0214 1:7 021400A]
  Actuator2-14 Up Limit	[E-0214 2:0 0214016]
  Actuator2-14 Driver Alarm	[E-0214 2:1 0214015]
  Actuator2-14 Error Alarm	[E-0214 2:2 0214014]
  Actuator2-14 Over Current	[E-0214 2:3 0214013]
  Actuator2-14 Over Speed	[E-0214 2:4 0214012]
  Actuator2-14 Over Load	[E-0214 2:5 0214011]
  Actuator2-14 PS Alarm	[E-0214 2:6 0214010]
  Actuator2-14 ENC Alarm	[E-0214 2:7 021400F]
  Actuator2-14 CPU Alarm	[E-0214 3:0 021401E]
  Actuator2-14 UART Alarm	[E-0214 3:1 021401D]
  Actuator2-14 HDLC Alarm	[E-0214 3:2 021401C]
  Actuator2-14 Force Card Fault	[E-0214 3:3 021401B]
  Actuator2-14 Force Sensor Fault	[E-0214 3:4 021401A]
  Actuator2-14 Under Range	[E-0214 3:5 0214019]
  Actuator2-14 Over Range	[E-0214 3:6 0214018]
  Actuator2-14 Down Limit	[E-0214 3:7 0214017]
  Actuator2-15 MON PARA	[E-0215 0:0 0215009]
  Actuator2-15 MON HYB	[E-0215 0:1 0215008]
  Actuator2-15 MON Position	[E-0215 0:2 0215007]
  Actuator2-15 MON Force	[E-0215 0:3 0215006]
  Actuator2-15 Drive Off	[E-0215 0:4 0215005]
  Actuator2-15 Drive On	[E-0215 0:5 0215004]
  Actuator2-15 CONT Position	[E-0215 0:6 0215003]
  Actuator2-15 CONT Force	[E-0215 0:7 0215002]
  Actuator2-15 Alarm Reset	[E-0215 1:1 0215020]
  Actuator2-15 Limit Release	[E-0215 1:2 021501F]
  Actuator2-15 Selected Step	[E-0215 1:3 021500E]
  Actuator2-15 Selected Load	[E-0215 1:4 021500D]
  Actuator2-15 Selected Drive	[E-0215 1:5 021500C]
  Actuator2-15 Maunakea	[E-0215 1:6 021500B]
  Actuator2-15 Sea Level	[E-0215 1:7 021500A]
  Actuator2-15 Up Limit	[E-0215 2:0 0215016]
  Actuator2-15 Driver Alarm	[E-0215 2:1 0215015]
  Actuator2-15 Error Alarm	[E-0215 2:2 0215014]
  Actuator2-15 Over Current	[E-0215 2:3 0215013]
  Actuator2-15 Over Speed	[E-0215 2:4 0215012]
  Actuator2-15 Over Load	[E-0215 2:5 0215011]
  Actuator2-15 PS Alarm	[E-0215 2:6 0215010]
  Actuator2-15 ENC Alarm	[E-0215 2:7 021500F]
  Actuator2-15 CPU Alarm	[E-0215 3:0 021501E]
  Actuator2-15 UART Alarm	[E-0215 3:1 021501D]
  Actuator2-15 HDLC Alarm	[E-0215 3:2 021501C]
  Actuator2-15 Force Card Fault	[E-0215 3:3 021501B]
  Actuator2-15 Force Sensor Fault	[E-0215 3:4 021501A]
  Actuator2-15 Under Range	[E-0215 3:5 0215019]
  Actuator2-15 Over Range	[E-0215 3:6 0215018]
  Actuator2-15 Down Limit	[E-0215 3:7 0215017]
  Actuator2-16 MON PARA	[E-0216 0:0 0216009]
  Actuator2-16 MON HYB	[E-0216 0:1 0216008]
  Actuator2-16 MON Position	[E-0216 0:2 0216007]
  Actuator2-16 MON Force	[E-0216 0:3 0216006]
  Actuator2-16 Drive Off	[E-0216 0:4 0216005]
  Actuator2-16 Drive On	[E-0216 0:5 0216004]
  Actuator2-16 CONT Position	[E-0216 0:6 0216003]
  Actuator2-16 CONT Force	[E-0216 0:7 0216002]
  Actuator2-16 Alarm Reset	[E-0216 1:1 0216020]
  Actuator2-16 Limit Release	[E-0216 1:2 021601F]
  Actuator2-16 Selected Step	[E-0216 1:3 021600E]
  Actuator2-16 Selected Load	[E-0216 1:4 021600D]
  Actuator2-16 Selected Drive	[E-0216 1:5 021600C]
  Actuator2-16 Maunakea	[E-0216 1:6 021600B]
  Actuator2-16 Sea Level	[E-0216 1:7 021600A]
  Actuator2-16 Up Limit	[E-0216 2:0 0216016]
  Actuator2-16 Driver Alarm	[E-0216 2:1 0216015]
  Actuator2-16 Error Alarm	[E-0216 2:2 0216014]
  Actuator2-16 Over Current	[E-0216 2:3 0216013]
  Actuator2-16 Over Speed	[E-0216 2:4 0216012]
  Actuator2-16 Over Load	[E-0216 2:5 0216011]
  Actuator2-16 PS Alarm	[E-0216 2:6 0216010]
  Actuator2-16 ENC Alarm	[E-0216 2:7 021600F]
  Actuator2-16 CPU Alarm	[E-0216 3:0 021601E]
  Actuator2-16 UART Alarm	[E-0216 3:1 021601D]
  Actuator2-16 HDLC Alarm	[E-0216 3:2 021601C]
  Actuator2-16 Force Card Fault	[E-0216 3:3 021601B]
  Actuator2-16 Force Sensor Fault	[E-0216 3:4 021601A]
  Actuator2-16 Under Range	[E-0216 3:5 0216019]
  Actuator2-16 Over Range	[E-0216 3:6 0216018]
  Actuator2-16 Down Limit	[E-0216 3:7 0216017]
  Actuator2-17 MON PARA	[E-0217 0:0 0217009]
  Actuator2-17 MON HYB	[E-0217 0:1 0217008]
  Actuator2-17 MON Position	[E-0217 0:2 0217007]
  Actuator2-17 MON Force	[E-0217 0:3 0217006]
  Actuator2-17 Drive Off	[E-0217 0:4 0217005]
  Actuator2-17 Drive On	[E-0217 0:5 0217004]
  Actuator2-17 CONT Position	[E-0217 0:6 0217003]
  Actuator2-17 CONT Force	[E-0217 0:7 0217002]
  Actuator2-17 Alarm Reset	[E-0217 1:1 0217020]
  Actuator2-17 Limit Release	[E-0217 1:2 021701F]
  Actuator2-17 Selected Step	[E-0217 1:3 021700E]
  Actuator2-17 Selected Load	[E-0217 1:4 021700D]
  Actuator2-17 Selected Drive	[E-0217 1:5 021700C]
  Actuator2-17 Maunakea	[E-0217 1:6 021700B]
  Actuator2-17 Sea Level	[E-0217 1:7 021700A]
  Actuator2-17 Up Limit	[E-0217 2:0 0217016]
  Actuator2-17 Driver Alarm	[E-0217 2:1 0217015]
  Actuator2-17 Error Alarm	[E-0217 2:2 0217014]
  Actuator2-17 Over Current	[E-0217 2:3 0217013]
  Actuator2-17 Over Speed	[E-0217 2:4 0217012]
  Actuator2-17 Over Load	[E-0217 2:5 0217011]
  Actuator2-17 PS Alarm	[E-0217 2:6 0217010]
  Actuator2-17 ENC Alarm	[E-0217 2:7 021700F]
  Actuator2-17 CPU Alarm	[E-0217 3:0 021701E]
  Actuator2-17 UART Alarm	[E-0217 3:1 021701D]
  Actuator2-17 HDLC Alarm	[E-0217 3:2 021701C]
  Actuator2-17 Force Card Fault	[E-0217 3:3 021701B]
  Actuator2-17 Force Sensor Fault	[E-0217 3:4 021701A]
  Actuator2-17 Under Range	[E-0217 3:5 0217019]
  Actuator2-17 Over Range	[E-0217 3:6 0217018]
  Actuator2-17 Down Limit	[E-0217 3:7 0217017]
  Actuator2-18 MON PARA	[E-0218 0:0 0218009]
  Actuator2-18 MON HYB	[E-0218 0:1 0218008]
  Actuator2-18 MON Position	[E-0218 0:2 0218007]
  Actuator2-18 MON Force	[E-0218 0:3 0218006]
  Actuator2-18 Drive Off	[E-0218 0:4 0218005]
  Actuator2-18 Drive On	[E-0218 0:5 0218004]
  Actuator2-18 CONT Position	[E-0218 0:6 0218003]
  Actuator2-18 CONT Force	[E-0218 0:7 0218002]
  Actuator2-18 Alarm Reset	[E-0218 1:1 0218020]
  Actuator2-18 Limit Release	[E-0218 1:2 021801F]
  Actuator2-18 Selected Step	[E-0218 1:3 021800E]
  Actuator2-18 Selected Load	[E-0218 1:4 021800D]
  Actuator2-18 Selected Drive	[E-0218 1:5 021800C]
  Actuator2-18 Maunakea	[E-0218 1:6 021800B]
  Actuator2-18 Sea Level	[E-0218 1:7 021800A]
  Actuator2-18 Up Limit	[E-0218 2:0 0218016]
  Actuator2-18 Driver Alarm	[E-0218 2:1 0218015]
  Actuator2-18 Error Alarm	[E-0218 2:2 0218014]
  Actuator2-18 Over Current	[E-0218 2:3 0218013]
  Actuator2-18 Over Speed	[E-0218 2:4 0218012]
  Actuator2-18 Over Load	[E-0218 2:5 0218011]
  Actuator2-18 PS Alarm	[E-0218 2:6 0218010]
  Actuator2-18 ENC Alarm	[E-0218 2:7 021800F]
  Actuator2-18 CPU Alarm	[E-0218 3:0 021801E]
  Actuator2-18 UART Alarm	[E-0218 3:1 021801D]
  Actuator2-18 HDLC Alarm	[E-0218 3:2 021801C]
  Actuator2-18 Force Card Fault	[E-0218 3:3 021801B]
  Actuator2-18 Force Sensor Fault	[E-0218 3:4 021801A]
  Actuator2-18 Under Range	[E-0218 3:5 0218019]
  Actuator2-18 Over Range	[E-0218 3:6 0218018]
  Actuator2-18 Down Limit	[E-0218 3:7 0218017]
  Actuator2-19 MON PARA	[E-0219 0:0 0219009]
  Actuator2-19 MON HYB	[E-0219 0:1 0219008]
  Actuator2-19 MON Position	[E-0219 0:2 0219007]
  Actuator2-19 MON Force	[E-0219 0:3 0219006]
  Actuator2-19 Drive Off	[E-0219 0:4 0219005]
  Actuator2-19 Drive On	[E-0219 0:5 0219004]
  Actuator2-19 CONT Position	[E-0219 0:6 0219003]
  Actuator2-19 CONT Force	[E-0219 0:7 0219002]
  Actuator2-19 Alarm Reset	[E-0219 1:1 0219020]
  Actuator2-19 Limit Release	[E-0219 1:2 021901F]
  Actuator2-19 Selected Step	[E-0219 1:3 021900E]
  Actuator2-19 Selected Load	[E-0219 1:4 021900D]
  Actuator2-19 Selected Drive	[E-0219 1:5 021900C]
  Actuator2-19 Maunakea	[E-0219 1:6 021900B]
  Actuator2-19 Sea Level	[E-0219 1:7 021900A]
  Actuator2-19 Up Limit	[E-0219 2:0 0219016]
  Actuator2-19 Driver Alarm	[E-0219 2:1 0219015]
  Actuator2-19 Error Alarm	[E-0219 2:2 0219014]
  Actuator2-19 Over Current	[E-0219 2:3 0219013]
  Actuator2-19 Over Speed	[E-0219 2:4 0219012]
  Actuator2-19 Over Load	[E-0219 2:5 0219011]
  Actuator2-19 PS Alarm	[E-0219 2:6 0219010]
  Actuator2-19 ENC Alarm	[E-0219 2:7 021900F]
  Actuator2-19 CPU Alarm	[E-0219 3:0 021901E]
  Actuator2-19 UART Alarm	[E-0219 3:1 021901D]
  Actuator2-19 HDLC Alarm	[E-0219 3:2 021901C]
  Actuator2-19 Force Card Fault	[E-0219 3:3 021901B]
  Actuator2-19 Force Sensor Fault	[E-0219 3:4 021901A]
  Actuator2-19 Under Range	[E-0219 3:5 0219019]
  Actuator2-19 Over Range	[E-0219 3:6 0219018]
  Actuator2-19 Down Limit	[E-0219 3:7 0219017]
  Actuator2-20 MON PARA	[E-0220 0:0 0220009]
  Actuator2-20 MON HYB	[E-0220 0:1 0220008]
  Actuator2-20 MON Position	[E-0220 0:2 0220007]
  Actuator2-20 MON Force	[E-0220 0:3 0220006]
  Actuator2-20 Drive Off	[E-0220 0:4 0220005]
  Actuator2-20 Drive On	[E-0220 0:5 0220004]
  Actuator2-20 CONT Position	[E-0220 0:6 0220003]
  Actuator2-20 CONT Force	[E-0220 0:7 0220002]
  Actuator2-20 Alarm Reset	[E-0220 1:1 0220020]
  Actuator2-20 Limit Release	[E-0220 1:2 022001F]
  Actuator2-20 Selected Step	[E-0220 1:3 022000E]
  Actuator2-20 Selected Load	[E-0220 1:4 022000D]
  Actuator2-20 Selected Drive	[E-0220 1:5 022000C]
  Actuator2-20 Maunakea	[E-0220 1:6 022000B]
  Actuator2-20 Sea Level	[E-0220 1:7 022000A]
  Actuator2-20 Up Limit	[E-0220 2:0 0220016]
  Actuator2-20 Driver Alarm	[E-0220 2:1 0220015]
  Actuator2-20 Error Alarm	[E-0220 2:2 0220014]
  Actuator2-20 Over Current	[E-0220 2:3 0220013]
  Actuator2-20 Over Speed	[E-0220 2:4 0220012]
  Actuator2-20 Over Load	[E-0220 2:5 0220011]
  Actuator2-20 PS Alarm	[E-0220 2:6 0220010]
  Actuator2-20 ENC Alarm	[E-0220 2:7 022000F]
  Actuator2-20 CPU Alarm	[E-0220 3:0 022001E]
  Actuator2-20 UART Alarm	[E-0220 3:1 022001D]
  Actuator2-20 HDLC Alarm	[E-0220 3:2 022001C]
  Actuator2-20 Force Card Fault	[E-0220 3:3 022001B]
  Actuator2-20 Force Sensor Fault	[E-0220 3:4 022001A]
  Actuator2-20 Under Range	[E-0220 3:5 0220019]
  Actuator2-20 Over Range	[E-0220 3:6 0220018]
  Actuator2-20 Down Limit	[E-0220 3:7 0220017]
  Actuator2-21 MON PARA	[E-0221 0:0 0221009]
  Actuator2-21 MON HYB	[E-0221 0:1 0221008]
  Actuator2-21 MON Position	[E-0221 0:2 0221007]
  Actuator2-21 MON Force	[E-0221 0:3 0221006]
  Actuator2-21 Drive Off	[E-0221 0:4 0221005]
  Actuator2-21 Drive On	[E-0221 0:5 0221004]
  Actuator2-21 CONT Position	[E-0221 0:6 0221003]
  Actuator2-21 CONT Force	[E-0221 0:7 0221002]
  Actuator2-21 Alarm Reset	[E-0221 1:1 0221020]
  Actuator2-21 Limit Release	[E-0221 1:2 022101F]
  Actuator2-21 Selected Step	[E-0221 1:3 022100E]
  Actuator2-21 Selected Load	[E-0221 1:4 022100D]
  Actuator2-21 Selected Drive	[E-0221 1:5 022100C]
  Actuator2-21 Maunakea	[E-0221 1:6 022100B]
  Actuator2-21 Sea Level	[E-0221 1:7 022100A]
  Actuator2-21 Up Limit	[E-0221 2:0 0221016]
  Actuator2-21 Driver Alarm	[E-0221 2:1 0221015]
  Actuator2-21 Error Alarm	[E-0221 2:2 0221014]
  Actuator2-21 Over Current	[E-0221 2:3 0221013]
  Actuator2-21 Over Speed	[E-0221 2:4 0221012]
  Actuator2-21 Over Load	[E-0221 2:5 0221011]
  Actuator2-21 PS Alarm	[E-0221 2:6 0221010]
  Actuator2-21 ENC Alarm	[E-0221 2:7 022100F]
  Actuator2-21 CPU Alarm	[E-0221 3:0 022101E]
  Actuator2-21 UART Alarm	[E-0221 3:1 022101D]
  Actuator2-21 HDLC Alarm	[E-0221 3:2 022101C]
  Actuator2-21 Force Card Fault	[E-0221 3:3 022101B]
  Actuator2-21 Force Sensor Fault	[E-0221 3:4 022101A]
  Actuator2-21 Under Range	[E-0221 3:5 0221019]
  Actuator2-21 Over Range	[E-0221 3:6 0221018]
  Actuator2-21 Down Limit	[E-0221 3:7 0221017]
  Actuator2-22 MON PARA	[E-0222 0:0 0222009]
  Actuator2-22 MON HYB	[E-0222 0:1 0222008]
  Actuator2-22 MON Position	[E-0222 0:2 0222007]
  Actuator2-22 MON Force	[E-0222 0:3 0222006]
  Actuator2-22 Drive Off	[E-0222 0:4 0222005]
  Actuator2-22 Drive On	[E-0222 0:5 0222004]
  Actuator2-22 CONT Position	[E-0222 0:6 0222003]
  Actuator2-22 CONT Force	[E-0222 0:7 0222002]
  Actuator2-22 Alarm Reset	[E-0222 1:1 0222020]
  Actuator2-22 Limit Release	[E-0222 1:2 022201F]
  Actuator2-22 Selected Step	[E-0222 1:3 022200E]
  Actuator2-22 Selected Load	[E-0222 1:4 022200D]
  Actuator2-22 Selected Drive	[E-0222 1:5 022200C]
  Actuator2-22 Maunakea	[E-0222 1:6 022200B]
  Actuator2-22 Sea Level	[E-0222 1:7 022200A]
  Actuator2-22 Up Limit	[E-0222 2:0 0222016]
  Actuator2-22 Driver Alarm	[E-0222 2:1 0222015]
  Actuator2-22 Error Alarm	[E-0222 2:2 0222014]
  Actuator2-22 Over Current	[E-0222 2:3 0222013]
  Actuator2-22 Over Speed	[E-0222 2:4 0222012]
  Actuator2-22 Over Load	[E-0222 2:5 0222011]
  Actuator2-22 PS Alarm	[E-0222 2:6 0222010]
  Actuator2-22 ENC Alarm	[E-0222 2:7 022200F]
  Actuator2-22 CPU Alarm	[E-0222 3:0 022201E]
  Actuator2-22 UART Alarm	[E-0222 3:1 022201D]
  Actuator2-22 HDLC Alarm	[E-0222 3:2 022201C]
  Actuator2-22 Force Card Fault	[E-0222 3:3 022201B]
  Actuator2-22 Force Sensor Fault	[E-0222 3:4 022201A]
  Actuator2-22 Under Range	[E-0222 3:5 0222019]
  Actuator2-22 Over Range	[E-0222 3:6 0222018]
  Actuator2-22 Down Limit	[E-0222 3:7 0222017]
  Actuator2-23 MON PARA	[E-0223 0:0 0223009]
  Actuator2-23 MON HYB	[E-0223 0:1 0223008]
  Actuator2-23 MON Position	[E-0223 0:2 0223007]
  Actuator2-23 MON Force	[E-0223 0:3 0223006]
  Actuator2-23 Drive Off	[E-0223 0:4 0223005]
  Actuator2-23 Drive On	[E-0223 0:5 0223004]
  Actuator2-23 CONT Position	[E-0223 0:6 0223003]
  Actuator2-23 CONT Force	[E-0223 0:7 0223002]
  Actuator2-23 Alarm Reset	[E-0223 1:1 0223020]
  Actuator2-23 Limit Release	[E-0223 1:2 022301F]
  Actuator2-23 Selected Step	[E-0223 1:3 022300E]
  Actuator2-23 Selected Load	[E-0223 1:4 022300D]
  Actuator2-23 Selected Drive	[E-0223 1:5 022300C]
  Actuator2-23 Maunakea	[E-0223 1:6 022300B]
  Actuator2-23 Sea Level	[E-0223 1:7 022300A]
  Actuator2-23 Up Limit	[E-0223 2:0 0223016]
  Actuator2-23 Driver Alarm	[E-0223 2:1 0223015]
  Actuator2-23 Error Alarm	[E-0223 2:2 0223014]
  Actuator2-23 Over Current	[E-0223 2:3 0223013]
  Actuator2-23 Over Speed	[E-0223 2:4 0223012]
  Actuator2-23 Over Load	[E-0223 2:5 0223011]
  Actuator2-23 PS Alarm	[E-0223 2:6 0223010]
  Actuator2-23 ENC Alarm	[E-0223 2:7 022300F]
  Actuator2-23 CPU Alarm	[E-0223 3:0 022301E]
  Actuator2-23 UART Alarm	[E-0223 3:1 022301D]
  Actuator2-23 HDLC Alarm	[E-0223 3:2 022301C]
  Actuator2-23 Force Card Fault	[E-0223 3:3 022301B]
  Actuator2-23 Force Sensor Fault	[E-0223 3:4 022301A]
  Actuator2-23 Under Range	[E-0223 3:5 0223019]
  Actuator2-23 Over Range	[E-0223 3:6 0223018]
  Actuator2-23 Down Limit	[E-0223 3:7 0223017]
  Actuator2-24 MON PARA	[E-0224 0:0 0224009]
  Actuator2-24 MON HYB	[E-0224 0:1 0224008]
  Actuator2-24 MON Position	[E-0224 0:2 0224007]
  Actuator2-24 MON Force	[E-0224 0:3 0224006]
  Actuator2-24 Drive Off	[E-0224 0:4 0224005]
  Actuator2-24 Drive On	[E-0224 0:5 0224004]
  Actuator2-24 CONT Position	[E-0224 0:6 0224003]
  Actuator2-24 CONT Force	[E-0224 0:7 0224002]
  Actuator2-24 Alarm Reset	[E-0224 1:1 0224020]
  Actuator2-24 Limit Release	[E-0224 1:2 022401F]
  Actuator2-24 Selected Step	[E-0224 1:3 022400E]
  Actuator2-24 Selected Load	[E-0224 1:4 022400D]
  Actuator2-24 Selected Drive	[E-0224 1:5 022400C]
  Actuator2-24 Maunakea	[E-0224 1:6 022400B]
  Actuator2-24 Sea Level	[E-0224 1:7 022400A]
  Actuator2-24 Up Limit	[E-0224 2:0 0224016]
  Actuator2-24 Driver Alarm	[E-0224 2:1 0224015]
  Actuator2-24 Error Alarm	[E-0224 2:2 0224014]
  Actuator2-24 Over Current	[E-0224 2:3 0224013]
  Actuator2-24 Over Speed	[E-0224 2:4 0224012]
  Actuator2-24 Over Load	[E-0224 2:5 0224011]
  Actuator2-24 PS Alarm	[E-0224 2:6 0224010]
  Actuator2-24 ENC Alarm	[E-0224 2:7 022400F]
  Actuator2-24 CPU Alarm	[E-0224 3:0 022401E]
  Actuator2-24 UART Alarm	[E-0224 3:1 022401D]
  Actuator2-24 HDLC Alarm	[E-0224 3:2 022401C]
  Actuator2-24 Force Card Fault	[E-0224 3:3 022401B]
  Actuator2-24 Force Sensor Fault	[E-0224 3:4 022401A]
  Actuator2-24 Under Range	[E-0224 3:5 0224019]
  Actuator2-24 Over Range	[E-0224 3:6 0224018]
  Actuator2-24 Down Limit	[E-0224 3:7 0224017]
  Actuator2-25 MON PARA	[E-0225 0:0 0225009]
  Actuator2-25 MON HYB	[E-0225 0:1 0225008]
  Actuator2-25 MON Position	[E-0225 0:2 0225007]
  Actuator2-25 MON Force	[E-0225 0:3 0225006]
  Actuator2-25 Drive Off	[E-0225 0:4 0225005]
  Actuator2-25 Drive On	[E-0225 0:5 0225004]
  Actuator2-25 CONT Position	[E-0225 0:6 0225003]
  Actuator2-25 CONT Force	[E-0225 0:7 0225002]
  Actuator2-25 Alarm Reset	[E-0225 1:1 0225020]
  Actuator2-25 Limit Release	[E-0225 1:2 022501F]
  Actuator2-25 Selected Step	[E-0225 1:3 022500E]
  Actuator2-25 Selected Load	[E-0225 1:4 022500D]
  Actuator2-25 Selected Drive	[E-0225 1:5 022500C]
  Actuator2-25 Maunakea	[E-0225 1:6 022500B]
  Actuator2-25 Sea Level	[E-0225 1:7 022500A]
  Actuator2-25 Up Limit	[E-0225 2:0 0225016]
  Actuator2-25 Driver Alarm	[E-0225 2:1 0225015]
  Actuator2-25 Error Alarm	[E-0225 2:2 0225014]
  Actuator2-25 Over Current	[E-0225 2:3 0225013]
  Actuator2-25 Over Speed	[E-0225 2:4 0225012]
  Actuator2-25 Over Load	[E-0225 2:5 0225011]
  Actuator2-25 PS Alarm	[E-0225 2:6 0225010]
  Actuator2-25 ENC Alarm	[E-0225 2:7 022500F]
  Actuator2-25 CPU Alarm	[E-0225 3:0 022501E]
  Actuator2-25 UART Alarm	[E-0225 3:1 022501D]
  Actuator2-25 HDLC Alarm	[E-0225 3:2 022501C]
  Actuator2-25 Force Card Fault	[E-0225 3:3 022501B]
  Actuator2-25 Force Sensor Fault	[E-0225 3:4 022501A]
  Actuator2-25 Under Range	[E-0225 3:5 0225019]
  Actuator2-25 Over Range	[E-0225 3:6 0225018]
  Actuator2-25 Down Limit	[E-0225 3:7 0225017]
  Actuator2-26 MON PARA	[E-0226 0:0 0226009]
  Actuator2-26 MON HYB	[E-0226 0:1 0226008]
  Actuator2-26 MON Position	[E-0226 0:2 0226007]
  Actuator2-26 MON Force	[E-0226 0:3 0226006]
  Actuator2-26 Drive Off	[E-0226 0:4 0226005]
  Actuator2-26 Drive On	[E-0226 0:5 0226004]
  Actuator2-26 CONT Position	[E-0226 0:6 0226003]
  Actuator2-26 CONT Force	[E-0226 0:7 0226002]
  Actuator2-26 Alarm Reset	[E-0226 1:1 0226020]
  Actuator2-26 Limit Release	[E-0226 1:2 022601F]
  Actuator2-26 Selected Step	[E-0226 1:3 022600E]
  Actuator2-26 Selected Load	[E-0226 1:4 022600D]
  Actuator2-26 Selected Drive	[E-0226 1:5 022600C]
  Actuator2-26 Maunakea	[E-0226 1:6 022600B]
  Actuator2-26 Sea Level	[E-0226 1:7 022600A]
  Actuator2-26 Up Limit	[E-0226 2:0 0226016]
  Actuator2-26 Driver Alarm	[E-0226 2:1 0226015]
  Actuator2-26 Error Alarm	[E-0226 2:2 0226014]
  Actuator2-26 Over Current	[E-0226 2:3 0226013]
  Actuator2-26 Over Speed	[E-0226 2:4 0226012]
  Actuator2-26 Over Load	[E-0226 2:5 0226011]
  Actuator2-26 PS Alarm	[E-0226 2:6 0226010]
  Actuator2-26 ENC Alarm	[E-0226 2:7 022600F]
  Actuator2-26 CPU Alarm	[E-0226 3:0 022601E]
  Actuator2-26 UART Alarm	[E-0226 3:1 022601D]
  Actuator2-26 HDLC Alarm	[E-0226 3:2 022601C]
  Actuator2-26 Force Card Fault	[E-0226 3:3 022601B]
  Actuator2-26 Force Sensor Fault	[E-0226 3:4 022601A]
  Actuator2-26 Under Range	[E-0226 3:5 0226019]
  Actuator2-26 Over Range	[E-0226 3:6 0226018]
  Actuator2-26 Down Limit	[E-0226 3:7 0226017]
  Actuator2-27 MON PARA	[E-0227 0:0 0227009]
  Actuator2-27 MON HYB	[E-0227 0:1 0227008]
  Actuator2-27 MON Position	[E-0227 0:2 0227007]
  Actuator2-27 MON Force	[E-0227 0:3 0227006]
  Actuator2-27 Drive Off	[E-0227 0:4 0227005]
  Actuator2-27 Drive On	[E-0227 0:5 0227004]
  Actuator2-27 CONT Position	[E-0227 0:6 0227003]
  Actuator2-27 CONT Force	[E-0227 0:7 0227002]
  Actuator2-27 Alarm Reset	[E-0227 1:1 0227020]
  Actuator2-27 Limit Release	[E-0227 1:2 022701F]
  Actuator2-27 Selected Step	[E-0227 1:3 022700E]
  Actuator2-27 Selected Load	[E-0227 1:4 022700D]
  Actuator2-27 Selected Drive	[E-0227 1:5 022700C]
  Actuator2-27 Maunakea	[E-0227 1:6 022700B]
  Actuator2-27 Sea Level	[E-0227 1:7 022700A]
  Actuator2-27 Up Limit	[E-0227 2:0 0227016]
  Actuator2-27 Driver Alarm	[E-0227 2:1 0227015]
  Actuator2-27 Error Alarm	[E-0227 2:2 0227014]
  Actuator2-27 Over Current	[E-0227 2:3 0227013]
  Actuator2-27 Over Speed	[E-0227 2:4 0227012]
  Actuator2-27 Over Load	[E-0227 2:5 0227011]
  Actuator2-27 PS Alarm	[E-0227 2:6 0227010]
  Actuator2-27 ENC Alarm	[E-0227 2:7 022700F]
  Actuator2-27 CPU Alarm	[E-0227 3:0 022701E]
  Actuator2-27 UART Alarm	[E-0227 3:1 022701D]
  Actuator2-27 HDLC Alarm	[E-0227 3:2 022701C]
  Actuator2-27 Force Card Fault	[E-0227 3:3 022701B]
  Actuator2-27 Force Sensor Fault	[E-0227 3:4 022701A]
  Actuator2-27 Under Range	[E-0227 3:5 0227019]
  Actuator2-27 Over Range	[E-0227 3:6 0227018]
  Actuator2-27 Down Limit	[E-0227 3:7 0227017]
  Actuator2-28 MON PARA	[E-0228 0:0 0228009]
  Actuator2-28 MON HYB	[E-0228 0:1 0228008]
  Actuator2-28 MON Position	[E-0228 0:2 0228007]
  Actuator2-28 MON Force	[E-0228 0:3 0228006]
  Actuator2-28 Drive Off	[E-0228 0:4 0228005]
  Actuator2-28 Drive On	[E-0228 0:5 0228004]
  Actuator2-28 CONT Position	[E-0228 0:6 0228003]
  Actuator2-28 CONT Force	[E-0228 0:7 0228002]
  Actuator2-28 Alarm Reset	[E-0228 1:1 0228020]
  Actuator2-28 Limit Release	[E-0228 1:2 022801F]
  Actuator2-28 Selected Step	[E-0228 1:3 022800E]
  Actuator2-28 Selected Load	[E-0228 1:4 022800D]
  Actuator2-28 Selected Drive	[E-0228 1:5 022800C]
  Actuator2-28 Maunakea	[E-0228 1:6 022800B]
  Actuator2-28 Sea Level	[E-0228 1:7 022800A]
  Actuator2-28 Up Limit	[E-0228 2:0 0228016]
  Actuator2-28 Driver Alarm	[E-0228 2:1 0228015]
  Actuator2-28 Error Alarm	[E-0228 2:2 0228014]
  Actuator2-28 Over Current	[E-0228 2:3 0228013]
  Actuator2-28 Over Speed	[E-0228 2:4 0228012]
  Actuator2-28 Over Load	[E-0228 2:5 0228011]
  Actuator2-28 PS Alarm	[E-0228 2:6 0228010]
  Actuator2-28 ENC Alarm	[E-0228 2:7 022800F]
  Actuator2-28 CPU Alarm	[E-0228 3:0 022801E]
  Actuator2-28 UART Alarm	[E-0228 3:1 022801D]
  Actuator2-28 HDLC Alarm	[E-0228 3:2 022801C]
  Actuator2-28 Force Card Fault	[E-0228 3:3 022801B]
  Actuator2-28 Force Sensor Fault	[E-0228 3:4 022801A]
  Actuator2-28 Under Range	[E-0228 3:5 0228019]
  Actuator2-28 Over Range	[E-0228 3:6 0228018]
  Actuator2-28 Down Limit	[E-0228 3:7 0228017]
  Actuator2-29 MON PARA	[E-0229 0:0 0229009]
  Actuator2-29 MON HYB	[E-0229 0:1 0229008]
  Actuator2-29 MON Position	[E-0229 0:2 0229007]
  Actuator2-29 MON Force	[E-0229 0:3 0229006]
  Actuator2-29 Drive Off	[E-0229 0:4 0229005]
  Actuator2-29 Drive On	[E-0229 0:5 0229004]
  Actuator2-29 CONT Position	[E-0229 0:6 0229003]
  Actuator2-29 CONT Force	[E-0229 0:7 0229002]
  Actuator2-29 Alarm Reset	[E-0229 1:1 0229020]
  Actuator2-29 Limit Release	[E-0229 1:2 022901F]
  Actuator2-29 Selected Step	[E-0229 1:3 022900E]
  Actuator2-29 Selected Load	[E-0229 1:4 022900D]
  Actuator2-29 Selected Drive	[E-0229 1:5 022900C]
  Actuator2-29 Maunakea	[E-0229 1:6 022900B]
  Actuator2-29 Sea Level	[E-0229 1:7 022900A]
  Actuator2-29 Up Limit	[E-0229 2:0 0229016]
  Actuator2-29 Driver Alarm	[E-0229 2:1 0229015]
  Actuator2-29 Error Alarm	[E-0229 2:2 0229014]
  Actuator2-29 Over Current	[E-0229 2:3 0229013]
  Actuator2-29 Over Speed	[E-0229 2:4 0229012]
  Actuator2-29 Over Load	[E-0229 2:5 0229011]
  Actuator2-29 PS Alarm	[E-0229 2:6 0229010]
  Actuator2-29 ENC Alarm	[E-0229 2:7 022900F]
  Actuator2-29 CPU Alarm	[E-0229 3:0 022901E]
  Actuator2-29 UART Alarm	[E-0229 3:1 022901D]
  Actuator2-29 HDLC Alarm	[E-0229 3:2 022901C]
  Actuator2-29 Force Card Fault	[E-0229 3:3 022901B]
  Actuator2-29 Force Sensor Fault	[E-0229 3:4 022901A]
  Actuator2-29 Under Range	[E-0229 3:5 0229019]
  Actuator2-29 Over Range	[E-0229 3:6 0229018]
  Actuator2-29 Down Limit	[E-0229 3:7 0229017]
  Actuator2-30 MON PARA	[E-0230 0:0 0230009]
  Actuator2-30 MON HYB	[E-0230 0:1 0230008]
  Actuator2-30 MON Position	[E-0230 0:2 0230007]
  Actuator2-30 MON Force	[E-0230 0:3 0230006]
  Actuator2-30 Drive Off	[E-0230 0:4 0230005]
  Actuator2-30 Drive On	[E-0230 0:5 0230004]
  Actuator2-30 CONT Position	[E-0230 0:6 0230003]
  Actuator2-30 CONT Force	[E-0230 0:7 0230002]
  Actuator2-30 Alarm Reset	[E-0230 1:1 0230020]
  Actuator2-30 Limit Release	[E-0230 1:2 023001F]
  Actuator2-30 Selected Step	[E-0230 1:3 023000E]
  Actuator2-30 Selected Load	[E-0230 1:4 023000D]
  Actuator2-30 Selected Drive	[E-0230 1:5 023000C]
  Actuator2-30 Maunakea	[E-0230 1:6 023000B]
  Actuator2-30 Sea Level	[E-0230 1:7 023000A]
  Actuator2-30 Up Limit	[E-0230 2:0 0230016]
  Actuator2-30 Driver Alarm	[E-0230 2:1 0230015]
  Actuator2-30 Error Alarm	[E-0230 2:2 0230014]
  Actuator2-30 Over Current	[E-0230 2:3 0230013]
  Actuator2-30 Over Speed	[E-0230 2:4 0230012]
  Actuator2-30 Over Load	[E-0230 2:5 0230011]
  Actuator2-30 PS Alarm	[E-0230 2:6 0230010]
  Actuator2-30 ENC Alarm	[E-0230 2:7 023000F]
  Actuator2-30 CPU Alarm	[E-0230 3:0 023001E]
  Actuator2-30 UART Alarm	[E-0230 3:1 023001D]
  Actuator2-30 HDLC Alarm	[E-0230 3:2 023001C]
  Actuator2-30 Force Card Fault	[E-0230 3:3 023001B]
  Actuator2-30 Force Sensor Fault	[E-0230 3:4 023001A]
  Actuator2-30 Under Range	[E-0230 3:5 0230019]
  Actuator2-30 Over Range	[E-0230 3:6 0230018]
  Actuator2-30 Down Limit	[E-0230 3:7 0230017]
  Actuator2-31 MON PARA	[E-0231 0:0 0231009]
  Actuator2-31 MON HYB	[E-0231 0:1 0231008]
  Actuator2-31 MON Position	[E-0231 0:2 0231007]
  Actuator2-31 MON Force	[E-0231 0:3 0231006]
  Actuator2-31 Drive Off	[E-0231 0:4 0231005]
  Actuator2-31 Drive On	[E-0231 0:5 0231004]
  Actuator2-31 CONT Position	[E-0231 0:6 0231003]
  Actuator2-31 CONT Force	[E-0231 0:7 0231002]
  Actuator2-31 Alarm Reset	[E-0231 1:1 0231020]
  Actuator2-31 Limit Release	[E-0231 1:2 023101F]
  Actuator2-31 Selected Step	[E-0231 1:3 023100E]
  Actuator2-31 Selected Load	[E-0231 1:4 023100D]
  Actuator2-31 Selected Drive	[E-0231 1:5 023100C]
  Actuator2-31 Maunakea	[E-0231 1:6 023100B]
  Actuator2-31 Sea Level	[E-0231 1:7 023100A]
  Actuator2-31 Up Limit	[E-0231 2:0 0231016]
  Actuator2-31 Driver Alarm	[E-0231 2:1 0231015]
  Actuator2-31 Error Alarm	[E-0231 2:2 0231014]
  Actuator2-31 Over Current	[E-0231 2:3 0231013]
  Actuator2-31 Over Speed	[E-0231 2:4 0231012]
  Actuator2-31 Over Load	[E-0231 2:5 0231011]
  Actuator2-31 PS Alarm	[E-0231 2:6 0231010]
  Actuator2-31 ENC Alarm	[E-0231 2:7 023100F]
  Actuator2-31 CPU Alarm	[E-0231 3:0 023101E]
  Actuator2-31 UART Alarm	[E-0231 3:1 023101D]
  Actuator2-31 HDLC Alarm	[E-0231 3:2 023101C]
  Actuator2-31 Force Card Fault	[E-0231 3:3 023101B]
  Actuator2-31 Force Sensor Fault	[E-0231 3:4 023101A]
  Actuator2-31 Under Range	[E-0231 3:5 0231019]
  Actuator2-31 Over Range	[E-0231 3:6 0231018]
  Actuator2-31 Down Limit	[E-0231 3:7 0231017]
  Actuator2-32 MON PARA	[E-0232 0:0 0232009]
  Actuator2-32 MON HYB	[E-0232 0:1 0232008]
  Actuator2-32 MON Position	[E-0232 0:2 0232007]
  Actuator2-32 MON Force	[E-0232 0:3 0232006]
  Actuator2-32 Drive Off	[E-0232 0:4 0232005]
  Actuator2-32 Drive On	[E-0232 0:5 0232004]
  Actuator2-32 CONT Position	[E-0232 0:6 0232003]
  Actuator2-32 CONT Force	[E-0232 0:7 0232002]
  Actuator2-32 Alarm Reset	[E-0232 1:1 0232020]
  Actuator2-32 Limit Release	[E-0232 1:2 023201F]
  Actuator2-32 Selected Step	[E-0232 1:3 023200E]
  Actuator2-32 Selected Load	[E-0232 1:4 023200D]
  Actuator2-32 Selected Drive	[E-0232 1:5 023200C]
  Actuator2-32 Maunakea	[E-0232 1:6 023200B]
  Actuator2-32 Sea Level	[E-0232 1:7 023200A]
  Actuator2-32 Up Limit	[E-0232 2:0 0232016]
  Actuator2-32 Driver Alarm	[E-0232 2:1 0232015]
  Actuator2-32 Error Alarm	[E-0232 2:2 0232014]
  Actuator2-32 Over Current	[E-0232 2:3 0232013]
  Actuator2-32 Over Speed	[E-0232 2:4 0232012]
  Actuator2-32 Over Load	[E-0232 2:5 0232011]
  Actuator2-32 PS Alarm	[E-0232 2:6 0232010]
  Actuator2-32 ENC Alarm	[E-0232 2:7 023200F]
  Actuator2-32 CPU Alarm	[E-0232 3:0 023201E]
  Actuator2-32 UART Alarm	[E-0232 3:1 023201D]
  Actuator2-32 HDLC Alarm	[E-0232 3:2 023201C]
  Actuator2-32 Force Card Fault	[E-0232 3:3 023201B]
  Actuator2-32 Force Sensor Fault	[E-0232 3:4 023201A]
  Actuator2-32 Under Range	[E-0232 3:5 0232019]
  Actuator2-32 Over Range	[E-0232 3:6 0232018]
  Actuator2-32 Down Limit	[E-0232 3:7 0232017]
  Actuator2-33 MON PARA	[E-0233 0:0 0233009]
  Actuator2-33 MON HYB	[E-0233 0:1 0233008]
  Actuator2-33 MON Position	[E-0233 0:2 0233007]
  Actuator2-33 MON Force	[E-0233 0:3 0233006]
  Actuator2-33 Drive Off	[E-0233 0:4 0233005]
  Actuator2-33 Drive On	[E-0233 0:5 0233004]
  Actuator2-33 CONT Position	[E-0233 0:6 0233003]
  Actuator2-33 CONT Force	[E-0233 0:7 0233002]
  Actuator2-33 Alarm Reset	[E-0233 1:1 0233020]
  Actuator2-33 Limit Release	[E-0233 1:2 023301F]
  Actuator2-33 Selected Step	[E-0233 1:3 023300E]
  Actuator2-33 Selected Load	[E-0233 1:4 023300D]
  Actuator2-33 Selected Drive	[E-0233 1:5 023300C]
  Actuator2-33 Maunakea	[E-0233 1:6 023300B]
  Actuator2-33 Sea Level	[E-0233 1:7 023300A]
  Actuator2-33 Up Limit	[E-0233 2:0 0233016]
  Actuator2-33 Driver Alarm	[E-0233 2:1 0233015]
  Actuator2-33 Error Alarm	[E-0233 2:2 0233014]
  Actuator2-33 Over Current	[E-0233 2:3 0233013]
  Actuator2-33 Over Speed	[E-0233 2:4 0233012]
  Actuator2-33 Over Load	[E-0233 2:5 0233011]
  Actuator2-33 PS Alarm	[E-0233 2:6 0233010]
  Actuator2-33 ENC Alarm	[E-0233 2:7 023300F]
  Actuator2-33 CPU Alarm	[E-0233 3:0 023301E]
  Actuator2-33 UART Alarm	[E-0233 3:1 023301D]
  Actuator2-33 HDLC Alarm	[E-0233 3:2 023301C]
  Actuator2-33 Force Card Fault	[E-0233 3:3 023301B]
  Actuator2-33 Force Sensor Fault	[E-0233 3:4 023301A]
  Actuator2-33 Under Range	[E-0233 3:5 0233019]
  Actuator2-33 Over Range	[E-0233 3:6 0233018]
  Actuator2-33 Down Limit	[E-0233 3:7 0233017]
  Actuator2-34 MON PARA	[E-0234 0:0 0234009]
  Actuator2-34 MON HYB	[E-0234 0:1 0234008]
  Actuator2-34 MON Position	[E-0234 0:2 0234007]
  Actuator2-34 MON Force	[E-0234 0:3 0234006]
  Actuator2-34 Drive Off	[E-0234 0:4 0234005]
  Actuator2-34 Drive On	[E-0234 0:5 0234004]
  Actuator2-34 CONT Position	[E-0234 0:6 0234003]
  Actuator2-34 CONT Force	[E-0234 0:7 0234002]
  Actuator2-34 Alarm Reset	[E-0234 1:1 0234020]
  Actuator2-34 Limit Release	[E-0234 1:2 023401F]
  Actuator2-34 Selected Step	[E-0234 1:3 023400E]
  Actuator2-34 Selected Load	[E-0234 1:4 023400D]
  Actuator2-34 Selected Drive	[E-0234 1:5 023400C]
  Actuator2-34 Maunakea	[E-0234 1:6 023400B]
  Actuator2-34 Sea Level	[E-0234 1:7 023400A]
  Actuator2-34 Up Limit	[E-0234 2:0 0234016]
  Actuator2-34 Driver Alarm	[E-0234 2:1 0234015]
  Actuator2-34 Error Alarm	[E-0234 2:2 0234014]
  Actuator2-34 Over Current	[E-0234 2:3 0234013]
  Actuator2-34 Over Speed	[E-0234 2:4 0234012]
  Actuator2-34 Over Load	[E-0234 2:5 0234011]
  Actuator2-34 PS Alarm	[E-0234 2:6 0234010]
  Actuator2-34 ENC Alarm	[E-0234 2:7 023400F]
  Actuator2-34 CPU Alarm	[E-0234 3:0 023401E]
  Actuator2-34 UART Alarm	[E-0234 3:1 023401D]
  Actuator2-34 HDLC Alarm	[E-0234 3:2 023401C]
  Actuator2-34 Force Card Fault	[E-0234 3:3 023401B]
  Actuator2-34 Force Sensor Fault	[E-0234 3:4 023401A]
  Actuator2-34 Under Range	[E-0234 3:5 0234019]
  Actuator2-34 Over Range	[E-0234 3:6 0234018]
  Actuator2-34 Down Limit	[E-0234 3:7 0234017]
  Actuator2-35 MON PARA	[E-0235 0:0 0235009]
  Actuator2-35 MON HYB	[E-0235 0:1 0235008]
  Actuator2-35 MON Position	[E-0235 0:2 0235007]
  Actuator2-35 MON Force	[E-0235 0:3 0235006]
  Actuator2-35 Drive Off	[E-0235 0:4 0235005]
  Actuator2-35 Drive On	[E-0235 0:5 0235004]
  Actuator2-35 CONT Position	[E-0235 0:6 0235003]
  Actuator2-35 CONT Force	[E-0235 0:7 0235002]
  Actuator2-35 Alarm Reset	[E-0235 1:1 0235020]
  Actuator2-35 Limit Release	[E-0235 1:2 023501F]
  Actuator2-35 Selected Step	[E-0235 1:3 023500E]
  Actuator2-35 Selected Load	[E-0235 1:4 023500D]
  Actuator2-35 Selected Drive	[E-0235 1:5 023500C]
  Actuator2-35 Maunakea	[E-0235 1:6 023500B]
  Actuator2-35 Sea Level	[E-0235 1:7 023500A]
  Actuator2-35 Up Limit	[E-0235 2:0 0235016]
  Actuator2-35 Driver Alarm	[E-0235 2:1 0235015]
  Actuator2-35 Error Alarm	[E-0235 2:2 0235014]
  Actuator2-35 Over Current	[E-0235 2:3 0235013]
  Actuator2-35 Over Speed	[E-0235 2:4 0235012]
  Actuator2-35 Over Load	[E-0235 2:5 0235011]
  Actuator2-35 PS Alarm	[E-0235 2:6 0235010]
  Actuator2-35 ENC Alarm	[E-0235 2:7 023500F]
  Actuator2-35 CPU Alarm	[E-0235 3:0 023501E]
  Actuator2-35 UART Alarm	[E-0235 3:1 023501D]
  Actuator2-35 HDLC Alarm	[E-0235 3:2 023501C]
  Actuator2-35 Force Card Fault	[E-0235 3:3 023501B]
  Actuator2-35 Force Sensor Fault	[E-0235 3:4 023501A]
  Actuator2-35 Under Range	[E-0235 3:5 0235019]
  Actuator2-35 Over Range	[E-0235 3:6 0235018]
  Actuator2-35 Down Limit	[E-0235 3:7 0235017]
  Actuator2-36 MON PARA	[E-0236 0:0 0236009]
  Actuator2-36 MON HYB	[E-0236 0:1 0236008]
  Actuator2-36 MON Position	[E-0236 0:2 0236007]
  Actuator2-36 MON Force	[E-0236 0:3 0236006]
  Actuator2-36 Drive Off	[E-0236 0:4 0236005]
  Actuator2-36 Drive On	[E-0236 0:5 0236004]
  Actuator2-36 CONT Position	[E-0236 0:6 0236003]
  Actuator2-36 CONT Force	[E-0236 0:7 0236002]
  Actuator2-36 Alarm Reset	[E-0236 1:1 0236020]
  Actuator2-36 Limit Release	[E-0236 1:2 023601F]
  Actuator2-36 Selected Step	[E-0236 1:3 023600E]
  Actuator2-36 Selected Load	[E-0236 1:4 023600D]
  Actuator2-36 Selected Drive	[E-0236 1:5 023600C]
  Actuator2-36 Maunakea	[E-0236 1:6 023600B]
  Actuator2-36 Sea Level	[E-0236 1:7 023600A]
  Actuator2-36 Up Limit	[E-0236 2:0 0236016]
  Actuator2-36 Driver Alarm	[E-0236 2:1 0236015]
  Actuator2-36 Error Alarm	[E-0236 2:2 0236014]
  Actuator2-36 Over Current	[E-0236 2:3 0236013]
  Actuator2-36 Over Speed	[E-0236 2:4 0236012]
  Actuator2-36 Over Load	[E-0236 2:5 0236011]
  Actuator2-36 PS Alarm	[E-0236 2:6 0236010]
  Actuator2-36 ENC Alarm	[E-0236 2:7 023600F]
  Actuator2-36 CPU Alarm	[E-0236 3:0 023601E]
  Actuator2-36 UART Alarm	[E-0236 3:1 023601D]
  Actuator2-36 HDLC Alarm	[E-0236 3:2 023601C]
  Actuator2-36 Force Card Fault	[E-0236 3:3 023601B]
  Actuator2-36 Force Sensor Fault	[E-0236 3:4 023601A]
  Actuator2-36 Under Range	[E-0236 3:5 0236019]
  Actuator2-36 Over Range	[E-0236 3:6 0236018]
  Actuator2-36 Down Limit	[E-0236 3:7 0236017]
  Actuator2-37 MON PARA	[E-0237 0:0 0237009]
  Actuator2-37 MON HYB	[E-0237 0:1 0237008]
  Actuator2-37 MON Position	[E-0237 0:2 0237007]
  Actuator2-37 MON Force	[E-0237 0:3 0237006]
  Actuator2-37 Drive Off	[E-0237 0:4 0237005]
  Actuator2-37 Drive On	[E-0237 0:5 0237004]
  Actuator2-37 CONT Position	[E-0237 0:6 0237003]
  Actuator2-37 CONT Force	[E-0237 0:7 0237002]
  Actuator2-37 Alarm Reset	[E-0237 1:1 0237020]
  Actuator2-37 Limit Release	[E-0237 1:2 023701F]
  Actuator2-37 Selected Step	[E-0237 1:3 023700E]
  Actuator2-37 Selected Load	[E-0237 1:4 023700D]
  Actuator2-37 Selected Drive	[E-0237 1:5 023700C]
  Actuator2-37 Maunakea	[E-0237 1:6 023700B]
  Actuator2-37 Sea Level	[E-0237 1:7 023700A]
  Actuator2-37 Up Limit	[E-0237 2:0 0237016]
  Actuator2-37 Driver Alarm	[E-0237 2:1 0237015]
  Actuator2-37 Error Alarm	[E-0237 2:2 0237014]
  Actuator2-37 Over Current	[E-0237 2:3 0237013]
  Actuator2-37 Over Speed	[E-0237 2:4 0237012]
  Actuator2-37 Over Load	[E-0237 2:5 0237011]
  Actuator2-37 PS Alarm	[E-0237 2:6 0237010]
  Actuator2-37 ENC Alarm	[E-0237 2:7 023700F]
  Actuator2-37 CPU Alarm	[E-0237 3:0 023701E]
  Actuator2-37 UART Alarm	[E-0237 3:1 023701D]
  Actuator2-37 HDLC Alarm	[E-0237 3:2 023701C]
  Actuator2-37 Force Card Fault	[E-0237 3:3 023701B]
  Actuator2-37 Force Sensor Fault	[E-0237 3:4 023701A]
  Actuator2-37 Under Range	[E-0237 3:5 0237019]
  Actuator2-37 Over Range	[E-0237 3:6 0237018]
  Actuator2-37 Down Limit	[E-0237 3:7 0237017]
  Actuator2-38 MON PARA	[E-0238 0:0 0238009]
  Actuator2-38 MON HYB	[E-0238 0:1 0238008]
  Actuator2-38 MON Position	[E-0238 0:2 0238007]
  Actuator2-38 MON Force	[E-0238 0:3 0238006]
  Actuator2-38 Drive Off	[E-0238 0:4 0238005]
  Actuator2-38 Drive On	[E-0238 0:5 0238004]
  Actuator2-38 CONT Position	[E-0238 0:6 0238003]
  Actuator2-38 CONT Force	[E-0238 0:7 0238002]
  Actuator2-38 Alarm Reset	[E-0238 1:1 0238020]
  Actuator2-38 Limit Release	[E-0238 1:2 023801F]
  Actuator2-38 Selected Step	[E-0238 1:3 023800E]
  Actuator2-38 Selected Load	[E-0238 1:4 023800D]
  Actuator2-38 Selected Drive	[E-0238 1:5 023800C]
  Actuator2-38 Maunakea	[E-0238 1:6 023800B]
  Actuator2-38 Sea Level	[E-0238 1:7 023800A]
  Actuator2-38 Up Limit	[E-0238 2:0 0238016]
  Actuator2-38 Driver Alarm	[E-0238 2:1 0238015]
  Actuator2-38 Error Alarm	[E-0238 2:2 0238014]
  Actuator2-38 Over Current	[E-0238 2:3 0238013]
  Actuator2-38 Over Speed	[E-0238 2:4 0238012]
  Actuator2-38 Over Load	[E-0238 2:5 0238011]
  Actuator2-38 PS Alarm	[E-0238 2:6 0238010]
  Actuator2-38 ENC Alarm	[E-0238 2:7 023800F]
  Actuator2-38 CPU Alarm	[E-0238 3:0 023801E]
  Actuator2-38 UART Alarm	[E-0238 3:1 023801D]
  Actuator2-38 HDLC Alarm	[E-0238 3:2 023801C]
  Actuator2-38 Force Card Fault	[E-0238 3:3 023801B]
  Actuator2-38 Force Sensor Fault	[E-0238 3:4 023801A]
  Actuator2-38 Under Range	[E-0238 3:5 0238019]
  Actuator2-38 Over Range	[E-0238 3:6 0238018]
  Actuator2-38 Down Limit	[E-0238 3:7 0238017]
  Actuator2-39 MON PARA	[E-0239 0:0 0239009]
  Actuator2-39 MON HYB	[E-0239 0:1 0239008]
  Actuator2-39 MON Position	[E-0239 0:2 0239007]
  Actuator2-39 MON Force	[E-0239 0:3 0239006]
  Actuator2-39 Drive Off	[E-0239 0:4 0239005]
  Actuator2-39 Drive On	[E-0239 0:5 0239004]
  Actuator2-39 CONT Position	[E-0239 0:6 0239003]
  Actuator2-39 CONT Force	[E-0239 0:7 0239002]
  Actuator2-39 Alarm Reset	[E-0239 1:1 0239020]
  Actuator2-39 Limit Release	[E-0239 1:2 023901F]
  Actuator2-39 Selected Step	[E-0239 1:3 023900E]
  Actuator2-39 Selected Load	[E-0239 1:4 023900D]
  Actuator2-39 Selected Drive	[E-0239 1:5 023900C]
  Actuator2-39 Maunakea	[E-0239 1:6 023900B]
  Actuator2-39 Sea Level	[E-0239 1:7 023900A]
  Actuator2-39 Up Limit	[E-0239 2:0 0239016]
  Actuator2-39 Driver Alarm	[E-0239 2:1 0239015]
  Actuator2-39 Error Alarm	[E-0239 2:2 0239014]
  Actuator2-39 Over Current	[E-0239 2:3 0239013]
  Actuator2-39 Over Speed	[E-0239 2:4 0239012]
  Actuator2-39 Over Load	[E-0239 2:5 0239011]
  Actuator2-39 PS Alarm	[E-0239 2:6 0239010]
  Actuator2-39 ENC Alarm	[E-0239 2:7 023900F]
  Actuator2-39 CPU Alarm	[E-0239 3:0 023901E]
  Actuator2-39 UART Alarm	[E-0239 3:1 023901D]
  Actuator2-39 HDLC Alarm	[E-0239 3:2 023901C]
  Actuator2-39 Force Card Fault	[E-0239 3:3 023901B]
  Actuator2-39 Force Sensor Fault	[E-0239 3:4 023901A]
  Actuator2-39 Under Range	[E-0239 3:5 0239019]
  Actuator2-39 Over Range	[E-0239 3:6 0239018]
  Actuator2-39 Down Limit	[E-0239 3:7 0239017]
  Actuator2-40 MON PARA	[E-0240 0:0 0240009]
  Actuator2-40 MON HYB	[E-0240 0:1 0240008]
  Actuator2-40 MON Position	[E-0240 0:2 0240007]
  Actuator2-40 MON Force	[E-0240 0:3 0240006]
  Actuator2-40 Drive Off	[E-0240 0:4 0240005]
  Actuator2-40 Drive On	[E-0240 0:5 0240004]
  Actuator2-40 CONT Position	[E-0240 0:6 0240003]
  Actuator2-40 CONT Force	[E-0240 0:7 0240002]
  Actuator2-40 Alarm Reset	[E-0240 1:1 0240020]
  Actuator2-40 Limit Release	[E-0240 1:2 024001F]
  Actuator2-40 Selected Step	[E-0240 1:3 024000E]
  Actuator2-40 Selected Load	[E-0240 1:4 024000D]
  Actuator2-40 Selected Drive	[E-0240 1:5 024000C]
  Actuator2-40 Maunakea	[E-0240 1:6 024000B]
  Actuator2-40 Sea Level	[E-0240 1:7 024000A]
  Actuator2-40 Up Limit	[E-0240 2:0 0240016]
  Actuator2-40 Driver Alarm	[E-0240 2:1 0240015]
  Actuator2-40 Error Alarm	[E-0240 2:2 0240014]
  Actuator2-40 Over Current	[E-0240 2:3 0240013]
  Actuator2-40 Over Speed	[E-0240 2:4 0240012]
  Actuator2-40 Over Load	[E-0240 2:5 0240011]
  Actuator2-40 PS Alarm	[E-0240 2:6 0240010]
  Actuator2-40 ENC Alarm	[E-0240 2:7 024000F]
  Actuator2-40 CPU Alarm	[E-0240 3:0 024001E]
  Actuator2-40 UART Alarm	[E-0240 3:1 024001D]
  Actuator2-40 HDLC Alarm	[E-0240 3:2 024001C]
  Actuator2-40 Force Card Fault	[E-0240 3:3 024001B]
  Actuator2-40 Force Sensor Fault	[E-0240 3:4 024001A]
  Actuator2-40 Under Range	[E-0240 3:5 0240019]
  Actuator2-40 Over Range	[E-0240 3:6 0240018]
  Actuator2-40 Down Limit	[E-0240 3:7 0240017]
  Actuator2-41 MON PARA	[E-0241 0:0 0241009]
  Actuator2-41 MON HYB	[E-0241 0:1 0241008]
  Actuator2-41 MON Position	[E-0241 0:2 0241007]
  Actuator2-41 MON Force	[E-0241 0:3 0241006]
  Actuator2-41 Drive Off	[E-0241 0:4 0241005]
  Actuator2-41 Drive On	[E-0241 0:5 0241004]
  Actuator2-41 CONT Position	[E-0241 0:6 0241003]
  Actuator2-41 CONT Force	[E-0241 0:7 0241002]
  Actuator2-41 Alarm Reset	[E-0241 1:1 0241020]
  Actuator2-41 Limit Release	[E-0241 1:2 024101F]
  Actuator2-41 Selected Step	[E-0241 1:3 024100E]
  Actuator2-41 Selected Load	[E-0241 1:4 024100D]
  Actuator2-41 Selected Drive	[E-0241 1:5 024100C]
  Actuator2-41 Maunakea	[E-0241 1:6 024100B]
  Actuator2-41 Sea Level	[E-0241 1:7 024100A]
  Actuator2-41 Up Limit	[E-0241 2:0 0241016]
  Actuator2-41 Driver Alarm	[E-0241 2:1 0241015]
  Actuator2-41 Error Alarm	[E-0241 2:2 0241014]
  Actuator2-41 Over Current	[E-0241 2:3 0241013]
  Actuator2-41 Over Speed	[E-0241 2:4 0241012]
  Actuator2-41 Over Load	[E-0241 2:5 0241011]
  Actuator2-41 PS Alarm	[E-0241 2:6 0241010]
  Actuator2-41 ENC Alarm	[E-0241 2:7 024100F]
  Actuator2-41 CPU Alarm	[E-0241 3:0 024101E]
  Actuator2-41 UART Alarm	[E-0241 3:1 024101D]
  Actuator2-41 HDLC Alarm	[E-0241 3:2 024101C]
  Actuator2-41 Force Card Fault	[E-0241 3:3 024101B]
  Actuator2-41 Force Sensor Fault	[E-0241 3:4 024101A]
  Actuator2-41 Under Range	[E-0241 3:5 0241019]
  Actuator2-41 Over Range	[E-0241 3:6 0241018]
  Actuator2-41 Down Limit	[E-0241 3:7 0241017]
  Actuator2-42 MON PARA	[E-0242 0:0 0242009]
  Actuator2-42 MON HYB	[E-0242 0:1 0242008]
  Actuator2-42 MON Position	[E-0242 0:2 0242007]
  Actuator2-42 MON Force	[E-0242 0:3 0242006]
  Actuator2-42 Drive Off	[E-0242 0:4 0242005]
  Actuator2-42 Drive On	[E-0242 0:5 0242004]
  Actuator2-42 CONT Position	[E-0242 0:6 0242003]
  Actuator2-42 CONT Force	[E-0242 0:7 0242002]
  Actuator2-42 Alarm Reset	[E-0242 1:1 0242020]
  Actuator2-42 Limit Release	[E-0242 1:2 024201F]
  Actuator2-42 Selected Step	[E-0242 1:3 024200E]
  Actuator2-42 Selected Load	[E-0242 1:4 024200D]
  Actuator2-42 Selected Drive	[E-0242 1:5 024200C]
  Actuator2-42 Maunakea	[E-0242 1:6 024200B]
  Actuator2-42 Sea Level	[E-0242 1:7 024200A]
  Actuator2-42 Up Limit	[E-0242 2:0 0242016]
  Actuator2-42 Driver Alarm	[E-0242 2:1 0242015]
  Actuator2-42 Error Alarm	[E-0242 2:2 0242014]
  Actuator2-42 Over Current	[E-0242 2:3 0242013]
  Actuator2-42 Over Speed	[E-0242 2:4 0242012]
  Actuator2-42 Over Load	[E-0242 2:5 0242011]
  Actuator2-42 PS Alarm	[E-0242 2:6 0242010]
  Actuator2-42 ENC Alarm	[E-0242 2:7 024200F]
  Actuator2-42 CPU Alarm	[E-0242 3:0 024201E]
  Actuator2-42 UART Alarm	[E-0242 3:1 024201D]
  Actuator2-42 HDLC Alarm	[E-0242 3:2 024201C]
  Actuator2-42 Force Card Fault	[E-0242 3:3 024201B]
  Actuator2-42 Force Sensor Fault	[E-0242 3:4 024201A]
  Actuator2-42 Under Range	[E-0242 3:5 0242019]
  Actuator2-42 Over Range	[E-0242 3:6 0242018]
  Actuator2-42 Down Limit	[E-0242 3:7 0242017]
  Actuator2-43 MON PARA	[E-0243 0:0 0243009]
  Actuator2-43 MON HYB	[E-0243 0:1 0243008]
  Actuator2-43 MON Position	[E-0243 0:2 0243007]
  Actuator2-43 MON Force	[E-0243 0:3 0243006]
  Actuator2-43 Drive Off	[E-0243 0:4 0243005]
  Actuator2-43 Drive On	[E-0243 0:5 0243004]
  Actuator2-43 CONT Position	[E-0243 0:6 0243003]
  Actuator2-43 CONT Force	[E-0243 0:7 0243002]
  Actuator2-43 Alarm Reset	[E-0243 1:1 0243020]
  Actuator2-43 Limit Release	[E-0243 1:2 024301F]
  Actuator2-43 Selected Step	[E-0243 1:3 024300E]
  Actuator2-43 Selected Load	[E-0243 1:4 024300D]
  Actuator2-43 Selected Drive	[E-0243 1:5 024300C]
  Actuator2-43 Maunakea	[E-0243 1:6 024300B]
  Actuator2-43 Sea Level	[E-0243 1:7 024300A]
  Actuator2-43 Up Limit	[E-0243 2:0 0243016]
  Actuator2-43 Driver Alarm	[E-0243 2:1 0243015]
  Actuator2-43 Error Alarm	[E-0243 2:2 0243014]
  Actuator2-43 Over Current	[E-0243 2:3 0243013]
  Actuator2-43 Over Speed	[E-0243 2:4 0243012]
  Actuator2-43 Over Load	[E-0243 2:5 0243011]
  Actuator2-43 PS Alarm	[E-0243 2:6 0243010]
  Actuator2-43 ENC Alarm	[E-0243 2:7 024300F]
  Actuator2-43 CPU Alarm	[E-0243 3:0 024301E]
  Actuator2-43 UART Alarm	[E-0243 3:1 024301D]
  Actuator2-43 HDLC Alarm	[E-0243 3:2 024301C]
  Actuator2-43 Force Card Fault	[E-0243 3:3 024301B]
  Actuator2-43 Force Sensor Fault	[E-0243 3:4 024301A]
  Actuator2-43 Under Range	[E-0243 3:5 0243019]
  Actuator2-43 Over Range	[E-0243 3:6 0243018]
  Actuator2-43 Down Limit	[E-0243 3:7 0243017]
  Actuator2-44 MON PARA	[E-0244 0:0 0244009]
  Actuator2-44 MON HYB	[E-0244 0:1 0244008]
  Actuator2-44 MON Position	[E-0244 0:2 0244007]
  Actuator2-44 MON Force	[E-0244 0:3 0244006]
  Actuator2-44 Drive Off	[E-0244 0:4 0244005]
  Actuator2-44 Drive On	[E-0244 0:5 0244004]
  Actuator2-44 CONT Position	[E-0244 0:6 0244003]
  Actuator2-44 CONT Force	[E-0244 0:7 0244002]
  Actuator2-44 Alarm Reset	[E-0244 1:1 0244020]
  Actuator2-44 Limit Release	[E-0244 1:2 024401F]
  Actuator2-44 Selected Step	[E-0244 1:3 024400E]
  Actuator2-44 Selected Load	[E-0244 1:4 024400D]
  Actuator2-44 Selected Drive	[E-0244 1:5 024400C]
  Actuator2-44 Maunakea	[E-0244 1:6 024400B]
  Actuator2-44 Sea Level	[E-0244 1:7 024400A]
  Actuator2-44 Up Limit	[E-0244 2:0 0244016]
  Actuator2-44 Driver Alarm	[E-0244 2:1 0244015]
  Actuator2-44 Error Alarm	[E-0244 2:2 0244014]
  Actuator2-44 Over Current	[E-0244 2:3 0244013]
  Actuator2-44 Over Speed	[E-0244 2:4 0244012]
  Actuator2-44 Over Load	[E-0244 2:5 0244011]
  Actuator2-44 PS Alarm	[E-0244 2:6 0244010]
  Actuator2-44 ENC Alarm	[E-0244 2:7 024400F]
  Actuator2-44 CPU Alarm	[E-0244 3:0 024401E]
  Actuator2-44 UART Alarm	[E-0244 3:1 024401D]
  Actuator2-44 HDLC Alarm	[E-0244 3:2 024401C]
  Actuator2-44 Force Card Fault	[E-0244 3:3 024401B]
  Actuator2-44 Force Sensor Fault	[E-0244 3:4 024401A]
  Actuator2-44 Under Range	[E-0244 3:5 0244019]
  Actuator2-44 Over Range	[E-0244 3:6 0244018]
  Actuator2-44 Down Limit	[E-0244 3:7 0244017]
  Actuator2-45 MON PARA	[E-0245 0:0 0245009]
  Actuator2-45 MON HYB	[E-0245 0:1 0245008]
  Actuator2-45 MON Position	[E-0245 0:2 0245007]
  Actuator2-45 MON Force	[E-0245 0:3 0245006]
  Actuator2-45 Drive Off	[E-0245 0:4 0245005]
  Actuator2-45 Drive On	[E-0245 0:5 0245004]
  Actuator2-45 CONT Position	[E-0245 0:6 0245003]
  Actuator2-45 CONT Force	[E-0245 0:7 0245002]
  Actuator2-45 Alarm Reset	[E-0245 1:1 0245020]
  Actuator2-45 Limit Release	[E-0245 1:2 024501F]
  Actuator2-45 Selected Step	[E-0245 1:3 024500E]
  Actuator2-45 Selected Load	[E-0245 1:4 024500D]
  Actuator2-45 Selected Drive	[E-0245 1:5 024500C]
  Actuator2-45 Maunakea	[E-0245 1:6 024500B]
  Actuator2-45 Sea Level	[E-0245 1:7 024500A]
  Actuator2-45 Up Limit	[E-0245 2:0 0245016]
  Actuator2-45 Driver Alarm	[E-0245 2:1 0245015]
  Actuator2-45 Error Alarm	[E-0245 2:2 0245014]
  Actuator2-45 Over Current	[E-0245 2:3 0245013]
  Actuator2-45 Over Speed	[E-0245 2:4 0245012]
  Actuator2-45 Over Load	[E-0245 2:5 0245011]
  Actuator2-45 PS Alarm	[E-0245 2:6 0245010]
  Actuator2-45 ENC Alarm	[E-0245 2:7 024500F]
  Actuator2-45 CPU Alarm	[E-0245 3:0 024501E]
  Actuator2-45 UART Alarm	[E-0245 3:1 024501D]
  Actuator2-45 HDLC Alarm	[E-0245 3:2 024501C]
  Actuator2-45 Force Card Fault	[E-0245 3:3 024501B]
  Actuator2-45 Force Sensor Fault	[E-0245 3:4 024501A]
  Actuator2-45 Under Range	[E-0245 3:5 0245019]
  Actuator2-45 Over Range	[E-0245 3:6 0245018]
  Actuator2-45 Down Limit	[E-0245 3:7 0245017]
  Actuator2-46 MON PARA	[E-0246 0:0 0246009]
  Actuator2-46 MON HYB	[E-0246 0:1 0246008]
  Actuator2-46 MON Position	[E-0246 0:2 0246007]
  Actuator2-46 MON Force	[E-0246 0:3 0246006]
  Actuator2-46 Drive Off	[E-0246 0:4 0246005]
  Actuator2-46 Drive On	[E-0246 0:5 0246004]
  Actuator2-46 CONT Position	[E-0246 0:6 0246003]
  Actuator2-46 CONT Force	[E-0246 0:7 0246002]
  Actuator2-46 Alarm Reset	[E-0246 1:1 0246020]
  Actuator2-46 Limit Release	[E-0246 1:2 024601F]
  Actuator2-46 Selected Step	[E-0246 1:3 024600E]
  Actuator2-46 Selected Load	[E-0246 1:4 024600D]
  Actuator2-46 Selected Drive	[E-0246 1:5 024600C]
  Actuator2-46 Maunakea	[E-0246 1:6 024600B]
  Actuator2-46 Sea Level	[E-0246 1:7 024600A]
  Actuator2-46 Up Limit	[E-0246 2:0 0246016]
  Actuator2-46 Driver Alarm	[E-0246 2:1 0246015]
  Actuator2-46 Error Alarm	[E-0246 2:2 0246014]
  Actuator2-46 Over Current	[E-0246 2:3 0246013]
  Actuator2-46 Over Speed	[E-0246 2:4 0246012]
  Actuator2-46 Over Load	[E-0246 2:5 0246011]
  Actuator2-46 PS Alarm	[E-0246 2:6 0246010]
  Actuator2-46 ENC Alarm	[E-0246 2:7 024600F]
  Actuator2-46 CPU Alarm	[E-0246 3:0 024601E]
  Actuator2-46 UART Alarm	[E-0246 3:1 024601D]
  Actuator2-46 HDLC Alarm	[E-0246 3:2 024601C]
  Actuator2-46 Force Card Fault	[E-0246 3:3 024601B]
  Actuator2-46 Force Sensor Fault	[E-0246 3:4 024601A]
  Actuator2-46 Under Range	[E-0246 3:5 0246019]
  Actuator2-46 Over Range	[E-0246 3:6 0246018]
  Actuator2-46 Down Limit	[E-0246 3:7 0246017]
  Actuator2-47 MON PARA	[E-0247 0:0 0247009]
  Actuator2-47 MON HYB	[E-0247 0:1 0247008]
  Actuator2-47 MON Position	[E-0247 0:2 0247007]
  Actuator2-47 MON Force	[E-0247 0:3 0247006]
  Actuator2-47 Drive Off	[E-0247 0:4 0247005]
  Actuator2-47 Drive On	[E-0247 0:5 0247004]
  Actuator2-47 CONT Position	[E-0247 0:6 0247003]
  Actuator2-47 CONT Force	[E-0247 0:7 0247002]
  Actuator2-47 Alarm Reset	[E-0247 1:1 0247020]
  Actuator2-47 Limit Release	[E-0247 1:2 024701F]
  Actuator2-47 Selected Step	[E-0247 1:3 024700E]
  Actuator2-47 Selected Load	[E-0247 1:4 024700D]
  Actuator2-47 Selected Drive	[E-0247 1:5 024700C]
  Actuator2-47 Maunakea	[E-0247 1:6 024700B]
  Actuator2-47 Sea Level	[E-0247 1:7 024700A]
  Actuator2-47 Up Limit	[E-0247 2:0 0247016]
  Actuator2-47 Driver Alarm	[E-0247 2:1 0247015]
  Actuator2-47 Error Alarm	[E-0247 2:2 0247014]
  Actuator2-47 Over Current	[E-0247 2:3 0247013]
  Actuator2-47 Over Speed	[E-0247 2:4 0247012]
  Actuator2-47 Over Load	[E-0247 2:5 0247011]
  Actuator2-47 PS Alarm	[E-0247 2:6 0247010]
  Actuator2-47 ENC Alarm	[E-0247 2:7 024700F]
  Actuator2-47 CPU Alarm	[E-0247 3:0 024701E]
  Actuator2-47 UART Alarm	[E-0247 3:1 024701D]
  Actuator2-47 HDLC Alarm	[E-0247 3:2 024701C]
  Actuator2-47 Force Card Fault	[E-0247 3:3 024701B]
  Actuator2-47 Force Sensor Fault	[E-0247 3:4 024701A]
  Actuator2-47 Under Range	[E-0247 3:5 0247019]
  Actuator2-47 Over Range	[E-0247 3:6 0247018]
  Actuator2-47 Down Limit	[E-0247 3:7 0247017]
  Actuator2-48 MON PARA	[E-0248 0:0 0248009]
  Actuator2-48 MON HYB	[E-0248 0:1 0248008]
  Actuator2-48 MON Position	[E-0248 0:2 0248007]
  Actuator2-48 MON Force	[E-0248 0:3 0248006]
  Actuator2-48 Drive Off	[E-0248 0:4 0248005]
  Actuator2-48 Drive On	[E-0248 0:5 0248004]
  Actuator2-48 CONT Position	[E-0248 0:6 0248003]
  Actuator2-48 CONT Force	[E-0248 0:7 0248002]
  Actuator2-48 Alarm Reset	[E-0248 1:1 0248020]
  Actuator2-48 Limit Release	[E-0248 1:2 024801F]
  Actuator2-48 Selected Step	[E-0248 1:3 024800E]
  Actuator2-48 Selected Load	[E-0248 1:4 024800D]
  Actuator2-48 Selected Drive	[E-0248 1:5 024800C]
  Actuator2-48 Maunakea	[E-0248 1:6 024800B]
  Actuator2-48 Sea Level	[E-0248 1:7 024800A]
  Actuator2-48 Up Limit	[E-0248 2:0 0248016]
  Actuator2-48 Driver Alarm	[E-0248 2:1 0248015]
  Actuator2-48 Error Alarm	[E-0248 2:2 0248014]
  Actuator2-48 Over Current	[E-0248 2:3 0248013]
  Actuator2-48 Over Speed	[E-0248 2:4 0248012]
  Actuator2-48 Over Load	[E-0248 2:5 0248011]
  Actuator2-48 PS Alarm	[E-0248 2:6 0248010]
  Actuator2-48 ENC Alarm	[E-0248 2:7 024800F]
  Actuator2-48 CPU Alarm	[E-0248 3:0 024801E]
  Actuator2-48 UART Alarm	[E-0248 3:1 024801D]
  Actuator2-48 HDLC Alarm	[E-0248 3:2 024801C]
  Actuator2-48 Force Card Fault	[E-0248 3:3 024801B]
  Actuator2-48 Force Sensor Fault	[E-0248 3:4 024801A]
  Actuator2-48 Under Range	[E-0248 3:5 0248019]
  Actuator2-48 Over Range	[E-0248 3:6 0248018]
  Actuator2-48 Down Limit	[E-0248 3:7 0248017]
  Actuator2-49 MON PARA	[E-0249 0:0 0249009]
  Actuator2-49 MON HYB	[E-0249 0:1 0249008]
  Actuator2-49 MON Position	[E-0249 0:2 0249007]
  Actuator2-49 MON Force	[E-0249 0:3 0249006]
  Actuator2-49 Drive Off	[E-0249 0:4 0249005]
  Actuator2-49 Drive On	[E-0249 0:5 0249004]
  Actuator2-49 CONT Position	[E-0249 0:6 0249003]
  Actuator2-49 CONT Force	[E-0249 0:7 0249002]
  Actuator2-49 Alarm Reset	[E-0249 1:1 0249020]
  Actuator2-49 Limit Release	[E-0249 1:2 024901F]
  Actuator2-49 Selected Step	[E-0249 1:3 024900E]
  Actuator2-49 Selected Load	[E-0249 1:4 024900D]
  Actuator2-49 Selected Drive	[E-0249 1:5 024900C]
  Actuator2-49 Maunakea	[E-0249 1:6 024900B]
  Actuator2-49 Sea Level	[E-0249 1:7 024900A]
  Actuator2-49 Up Limit	[E-0249 2:0 0249016]
  Actuator2-49 Driver Alarm	[E-0249 2:1 0249015]
  Actuator2-49 Error Alarm	[E-0249 2:2 0249014]
  Actuator2-49 Over Current	[E-0249 2:3 0249013]
  Actuator2-49 Over Speed	[E-0249 2:4 0249012]
  Actuator2-49 Over Load	[E-0249 2:5 0249011]
  Actuator2-49 PS Alarm	[E-0249 2:6 0249010]
  Actuator2-49 ENC Alarm	[E-0249 2:7 024900F]
  Actuator2-49 CPU Alarm	[E-0249 3:0 024901E]
  Actuator2-49 UART Alarm	[E-0249 3:1 024901D]
  Actuator2-49 HDLC Alarm	[E-0249 3:2 024901C]
  Actuator2-49 Force Card Fault	[E-0249 3:3 024901B]
  Actuator2-49 Force Sensor Fault	[E-0249 3:4 024901A]
  Actuator2-49 Under Range	[E-0249 3:5 0249019]
  Actuator2-49 Over Range	[E-0249 3:6 0249018]
  Actuator2-49 Down Limit	[E-0249 3:7 0249017]
  Actuator2-50 MON PARA	[E-0250 0:0 0250009]
  Actuator2-50 MON HYB	[E-0250 0:1 0250008]
  Actuator2-50 MON Position	[E-0250 0:2 0250007]
  Actuator2-50 MON Force	[E-0250 0:3 0250006]
  Actuator2-50 Drive Off	[E-0250 0:4 0250005]
  Actuator2-50 Drive On	[E-0250 0:5 0250004]
  Actuator2-50 CONT Position	[E-0250 0:6 0250003]
  Actuator2-50 CONT Force	[E-0250 0:7 0250002]
  Actuator2-50 Alarm Reset	[E-0250 1:1 0250020]
  Actuator2-50 Limit Release	[E-0250 1:2 025001F]
  Actuator2-50 Selected Step	[E-0250 1:3 025000E]
  Actuator2-50 Selected Load	[E-0250 1:4 025000D]
  Actuator2-50 Selected Drive	[E-0250 1:5 025000C]
  Actuator2-50 Maunakea	[E-0250 1:6 025000B]
  Actuator2-50 Sea Level	[E-0250 1:7 025000A]
  Actuator2-50 Up Limit	[E-0250 2:0 0250016]
  Actuator2-50 Driver Alarm	[E-0250 2:1 0250015]
  Actuator2-50 Error Alarm	[E-0250 2:2 0250014]
  Actuator2-50 Over Current	[E-0250 2:3 0250013]
  Actuator2-50 Over Speed	[E-0250 2:4 0250012]
  Actuator2-50 Over Load	[E-0250 2:5 0250011]
  Actuator2-50 PS Alarm	[E-0250 2:6 0250010]
  Actuator2-50 ENC Alarm	[E-0250 2:7 025000F]
  Actuator2-50 CPU Alarm	[E-0250 3:0 025001E]
  Actuator2-50 UART Alarm	[E-0250 3:1 025001D]
  Actuator2-50 HDLC Alarm	[E-0250 3:2 025001C]
  Actuator2-50 Force Card Fault	[E-0250 3:3 025001B]
  Actuator2-50 Force Sensor Fault	[E-0250 3:4 025001A]
  Actuator2-50 Under Range	[E-0250 3:5 0250019]
  Actuator2-50 Over Range	[E-0250 3:6 0250018]
  Actuator2-50 Down Limit	[E-0250 3:7 0250017]
  Actuator2-51 MON PARA	[E-0251 0:0 0251009]
  Actuator2-51 MON HYB	[E-0251 0:1 0251008]
  Actuator2-51 MON Position	[E-0251 0:2 0251007]
  Actuator2-51 MON Force	[E-0251 0:3 0251006]
  Actuator2-51 Drive Off	[E-0251 0:4 0251005]
  Actuator2-51 Drive On	[E-0251 0:5 0251004]
  Actuator2-51 CONT Position	[E-0251 0:6 0251003]
  Actuator2-51 CONT Force	[E-0251 0:7 0251002]
  Actuator2-51 Alarm Reset	[E-0251 1:1 0251020]
  Actuator2-51 Limit Release	[E-0251 1:2 025101F]
  Actuator2-51 Selected Step	[E-0251 1:3 025100E]
  Actuator2-51 Selected Load	[E-0251 1:4 025100D]
  Actuator2-51 Selected Drive	[E-0251 1:5 025100C]
  Actuator2-51 Maunakea	[E-0251 1:6 025100B]
  Actuator2-51 Sea Level	[E-0251 1:7 025100A]
  Actuator2-51 Up Limit	[E-0251 2:0 0251016]
  Actuator2-51 Driver Alarm	[E-0251 2:1 0251015]
  Actuator2-51 Error Alarm	[E-0251 2:2 0251014]
  Actuator2-51 Over Current	[E-0251 2:3 0251013]
  Actuator2-51 Over Speed	[E-0251 2:4 0251012]
  Actuator2-51 Over Load	[E-0251 2:5 0251011]
  Actuator2-51 PS Alarm	[E-0251 2:6 0251010]
  Actuator2-51 ENC Alarm	[E-0251 2:7 025100F]
  Actuator2-51 CPU Alarm	[E-0251 3:0 025101E]
  Actuator2-51 UART Alarm	[E-0251 3:1 025101D]
  Actuator2-51 HDLC Alarm	[E-0251 3:2 025101C]
  Actuator2-51 Force Card Fault	[E-0251 3:3 025101B]
  Actuator2-51 Force Sensor Fault	[E-0251 3:4 025101A]
  Actuator2-51 Under Range	[E-0251 3:5 0251019]
  Actuator2-51 Over Range	[E-0251 3:6 0251018]
  Actuator2-51 Down Limit	[E-0251 3:7 0251017]
  Actuator2-52 MON PARA	[E-0252 0:0 0252009]
  Actuator2-52 MON HYB	[E-0252 0:1 0252008]
  Actuator2-52 MON Position	[E-0252 0:2 0252007]
  Actuator2-52 MON Force	[E-0252 0:3 0252006]
  Actuator2-52 Drive Off	[E-0252 0:4 0252005]
  Actuator2-52 Drive On	[E-0252 0:5 0252004]
  Actuator2-52 CONT Position	[E-0252 0:6 0252003]
  Actuator2-52 CONT Force	[E-0252 0:7 0252002]
  Actuator2-52 Alarm Reset	[E-0252 1:1 0252020]
  Actuator2-52 Limit Release	[E-0252 1:2 025201F]
  Actuator2-52 Selected Step	[E-0252 1:3 025200E]
  Actuator2-52 Selected Load	[E-0252 1:4 025200D]
  Actuator2-52 Selected Drive	[E-0252 1:5 025200C]
  Actuator2-52 Maunakea	[E-0252 1:6 025200B]
  Actuator2-52 Sea Level	[E-0252 1:7 025200A]
  Actuator2-52 Up Limit	[E-0252 2:0 0252016]
  Actuator2-52 Driver Alarm	[E-0252 2:1 0252015]
  Actuator2-52 Error Alarm	[E-0252 2:2 0252014]
  Actuator2-52 Over Current	[E-0252 2:3 0252013]
  Actuator2-52 Over Speed	[E-0252 2:4 0252012]
  Actuator2-52 Over Load	[E-0252 2:5 0252011]
  Actuator2-52 PS Alarm	[E-0252 2:6 0252010]
  Actuator2-52 ENC Alarm	[E-0252 2:7 025200F]
  Actuator2-52 CPU Alarm	[E-0252 3:0 025201E]
  Actuator2-52 UART Alarm	[E-0252 3:1 025201D]
  Actuator2-52 HDLC Alarm	[E-0252 3:2 025201C]
  Actuator2-52 Force Card Fault	[E-0252 3:3 025201B]
  Actuator2-52 Force Sensor Fault	[E-0252 3:4 025201A]
  Actuator2-52 Under Range	[E-0252 3:5 0252019]
  Actuator2-52 Over Range	[E-0252 3:6 0252018]
  Actuator2-52 Down Limit	[E-0252 3:7 0252017]
  Actuator2-53 MON PARA	[E-0253 0:0 0253009]
  Actuator2-53 MON HYB	[E-0253 0:1 0253008]
  Actuator2-53 MON Position	[E-0253 0:2 0253007]
  Actuator2-53 MON Force	[E-0253 0:3 0253006]
  Actuator2-53 Drive Off	[E-0253 0:4 0253005]
  Actuator2-53 Drive On	[E-0253 0:5 0253004]
  Actuator2-53 CONT Position	[E-0253 0:6 0253003]
  Actuator2-53 CONT Force	[E-0253 0:7 0253002]
  Actuator2-53 Alarm Reset	[E-0253 1:1 0253020]
  Actuator2-53 Limit Release	[E-0253 1:2 025301F]
  Actuator2-53 Selected Step	[E-0253 1:3 025300E]
  Actuator2-53 Selected Load	[E-0253 1:4 025300D]
  Actuator2-53 Selected Drive	[E-0253 1:5 025300C]
  Actuator2-53 Maunakea	[E-0253 1:6 025300B]
  Actuator2-53 Sea Level	[E-0253 1:7 025300A]
  Actuator2-53 Up Limit	[E-0253 2:0 0253016]
  Actuator2-53 Driver Alarm	[E-0253 2:1 0253015]
  Actuator2-53 Error Alarm	[E-0253 2:2 0253014]
  Actuator2-53 Over Current	[E-0253 2:3 0253013]
  Actuator2-53 Over Speed	[E-0253 2:4 0253012]
  Actuator2-53 Over Load	[E-0253 2:5 0253011]
  Actuator2-53 PS Alarm	[E-0253 2:6 0253010]
  Actuator2-53 ENC Alarm	[E-0253 2:7 025300F]
  Actuator2-53 CPU Alarm	[E-0253 3:0 025301E]
  Actuator2-53 UART Alarm	[E-0253 3:1 025301D]
  Actuator2-53 HDLC Alarm	[E-0253 3:2 025301C]
  Actuator2-53 Force Card Fault	[E-0253 3:3 025301B]
  Actuator2-53 Force Sensor Fault	[E-0253 3:4 025301A]
  Actuator2-53 Under Range	[E-0253 3:5 0253019]
  Actuator2-53 Over Range	[E-0253 3:6 0253018]
  Actuator2-53 Down Limit	[E-0253 3:7 0253017]
  Actuator2-54 MON PARA	[E-0254 0:0 0254009]
  Actuator2-54 MON HYB	[E-0254 0:1 0254008]
  Actuator2-54 MON Position	[E-0254 0:2 0254007]
  Actuator2-54 MON Force	[E-0254 0:3 0254006]
  Actuator2-54 Drive Off	[E-0254 0:4 0254005]
  Actuator2-54 Drive On	[E-0254 0:5 0254004]
  Actuator2-54 CONT Position	[E-0254 0:6 0254003]
  Actuator2-54 CONT Force	[E-0254 0:7 0254002]
  Actuator2-54 Alarm Reset	[E-0254 1:1 0254020]
  Actuator2-54 Limit Release	[E-0254 1:2 025401F]
  Actuator2-54 Selected Step	[E-0254 1:3 025400E]
  Actuator2-54 Selected Load	[E-0254 1:4 025400D]
  Actuator2-54 Selected Drive	[E-0254 1:5 025400C]
  Actuator2-54 Maunakea	[E-0254 1:6 025400B]
  Actuator2-54 Sea Level	[E-0254 1:7 025400A]
  Actuator2-54 Up Limit	[E-0254 2:0 0254016]
  Actuator2-54 Driver Alarm	[E-0254 2:1 0254015]
  Actuator2-54 Error Alarm	[E-0254 2:2 0254014]
  Actuator2-54 Over Current	[E-0254 2:3 0254013]
  Actuator2-54 Over Speed	[E-0254 2:4 0254012]
  Actuator2-54 Over Load	[E-0254 2:5 0254011]
  Actuator2-54 PS Alarm	[E-0254 2:6 0254010]
  Actuator2-54 ENC Alarm	[E-0254 2:7 025400F]
  Actuator2-54 CPU Alarm	[E-0254 3:0 025401E]
  Actuator2-54 UART Alarm	[E-0254 3:1 025401D]
  Actuator2-54 HDLC Alarm	[E-0254 3:2 025401C]
  Actuator2-54 Force Card Fault	[E-0254 3:3 025401B]
  Actuator2-54 Force Sensor Fault	[E-0254 3:4 025401A]
  Actuator2-54 Under Range	[E-0254 3:5 0254019]
  Actuator2-54 Over Range	[E-0254 3:6 0254018]
  Actuator2-54 Down Limit	[E-0254 3:7 0254017]
  Actuator2-55 MON PARA	[E-0255 0:0 0255009]
  Actuator2-55 MON HYB	[E-0255 0:1 0255008]
  Actuator2-55 MON Position	[E-0255 0:2 0255007]
  Actuator2-55 MON Force	[E-0255 0:3 0255006]
  Actuator2-55 Drive Off	[E-0255 0:4 0255005]
  Actuator2-55 Drive On	[E-0255 0:5 0255004]
  Actuator2-55 CONT Position	[E-0255 0:6 0255003]
  Actuator2-55 CONT Force	[E-0255 0:7 0255002]
  Actuator2-55 Alarm Reset	[E-0255 1:1 0255020]
  Actuator2-55 Limit Release	[E-0255 1:2 025501F]
  Actuator2-55 Selected Step	[E-0255 1:3 025500E]
  Actuator2-55 Selected Load	[E-0255 1:4 025500D]
  Actuator2-55 Selected Drive	[E-0255 1:5 025500C]
  Actuator2-55 Maunakea	[E-0255 1:6 025500B]
  Actuator2-55 Sea Level	[E-0255 1:7 025500A]
  Actuator2-55 Up Limit	[E-0255 2:0 0255016]
  Actuator2-55 Driver Alarm	[E-0255 2:1 0255015]
  Actuator2-55 Error Alarm	[E-0255 2:2 0255014]
  Actuator2-55 Over Current	[E-0255 2:3 0255013]
  Actuator2-55 Over Speed	[E-0255 2:4 0255012]
  Actuator2-55 Over Load	[E-0255 2:5 0255011]
  Actuator2-55 PS Alarm	[E-0255 2:6 0255010]
  Actuator2-55 ENC Alarm	[E-0255 2:7 025500F]
  Actuator2-55 CPU Alarm	[E-0255 3:0 025501E]
  Actuator2-55 UART Alarm	[E-0255 3:1 025501D]
  Actuator2-55 HDLC Alarm	[E-0255 3:2 025501C]
  Actuator2-55 Force Card Fault	[E-0255 3:3 025501B]
  Actuator2-55 Force Sensor Fault	[E-0255 3:4 025501A]
  Actuator2-55 Under Range	[E-0255 3:5 0255019]
  Actuator2-55 Over Range	[E-0255 3:6 0255018]
  Actuator2-55 Down Limit	[E-0255 3:7 0255017]
  Actuator2-56 MON PARA	[E-0256 0:0 0256009]
  Actuator2-56 MON HYB	[E-0256 0:1 0256008]
  Actuator2-56 MON Position	[E-0256 0:2 0256007]
  Actuator2-56 MON Force	[E-0256 0:3 0256006]
  Actuator2-56 Drive Off	[E-0256 0:4 0256005]
  Actuator2-56 Drive On	[E-0256 0:5 0256004]
  Actuator2-56 CONT Position	[E-0256 0:6 0256003]
  Actuator2-56 CONT Force	[E-0256 0:7 0256002]
  Actuator2-56 Alarm Reset	[E-0256 1:1 0256020]
  Actuator2-56 Limit Release	[E-0256 1:2 025601F]
  Actuator2-56 Selected Step	[E-0256 1:3 025600E]
  Actuator2-56 Selected Load	[E-0256 1:4 025600D]
  Actuator2-56 Selected Drive	[E-0256 1:5 025600C]
  Actuator2-56 Maunakea	[E-0256 1:6 025600B]
  Actuator2-56 Sea Level	[E-0256 1:7 025600A]
  Actuator2-56 Up Limit	[E-0256 2:0 0256016]
  Actuator2-56 Driver Alarm	[E-0256 2:1 0256015]
  Actuator2-56 Error Alarm	[E-0256 2:2 0256014]
  Actuator2-56 Over Current	[E-0256 2:3 0256013]
  Actuator2-56 Over Speed	[E-0256 2:4 0256012]
  Actuator2-56 Over Load	[E-0256 2:5 0256011]
  Actuator2-56 PS Alarm	[E-0256 2:6 0256010]
  Actuator2-56 ENC Alarm	[E-0256 2:7 025600F]
  Actuator2-56 CPU Alarm	[E-0256 3:0 025601E]
  Actuator2-56 UART Alarm	[E-0256 3:1 025601D]
  Actuator2-56 HDLC Alarm	[E-0256 3:2 025601C]
  Actuator2-56 Force Card Fault	[E-0256 3:3 025601B]
  Actuator2-56 Force Sensor Fault	[E-0256 3:4 025601A]
  Actuator2-56 Under Range	[E-0256 3:5 0256019]
  Actuator2-56 Over Range	[E-0256 3:6 0256018]
  Actuator2-56 Down Limit	[E-0256 3:7 0256017]
  Actuator2-57 MON PARA	[E-0257 0:0 0257009]
  Actuator2-57 MON HYB	[E-0257 0:1 0257008]
  Actuator2-57 MON Position	[E-0257 0:2 0257007]
  Actuator2-57 MON Force	[E-0257 0:3 0257006]
  Actuator2-57 Drive Off	[E-0257 0:4 0257005]
  Actuator2-57 Drive On	[E-0257 0:5 0257004]
  Actuator2-57 CONT Position	[E-0257 0:6 0257003]
  Actuator2-57 CONT Force	[E-0257 0:7 0257002]
  Actuator2-57 Alarm Reset	[E-0257 1:1 0257020]
  Actuator2-57 Limit Release	[E-0257 1:2 025701F]
  Actuator2-57 Selected Step	[E-0257 1:3 025700E]
  Actuator2-57 Selected Load	[E-0257 1:4 025700D]
  Actuator2-57 Selected Drive	[E-0257 1:5 025700C]
  Actuator2-57 Maunakea	[E-0257 1:6 025700B]
  Actuator2-57 Sea Level	[E-0257 1:7 025700A]
  Actuator2-57 Up Limit	[E-0257 2:0 0257016]
  Actuator2-57 Driver Alarm	[E-0257 2:1 0257015]
  Actuator2-57 Error Alarm	[E-0257 2:2 0257014]
  Actuator2-57 Over Current	[E-0257 2:3 0257013]
  Actuator2-57 Over Speed	[E-0257 2:4 0257012]
  Actuator2-57 Over Load	[E-0257 2:5 0257011]
  Actuator2-57 PS Alarm	[E-0257 2:6 0257010]
  Actuator2-57 ENC Alarm	[E-0257 2:7 025700F]
  Actuator2-57 CPU Alarm	[E-0257 3:0 025701E]
  Actuator2-57 UART Alarm	[E-0257 3:1 025701D]
  Actuator2-57 HDLC Alarm	[E-0257 3:2 025701C]
  Actuator2-57 Force Card Fault	[E-0257 3:3 025701B]
  Actuator2-57 Force Sensor Fault	[E-0257 3:4 025701A]
  Actuator2-57 Under Range	[E-0257 3:5 0257019]
  Actuator2-57 Over Range	[E-0257 3:6 0257018]
  Actuator2-57 Down Limit	[E-0257 3:7 0257017]
  Actuator2-58 MON PARA	[E-0258 0:0 0258009]
  Actuator2-58 MON HYB	[E-0258 0:1 0258008]
  Actuator2-58 MON Position	[E-0258 0:2 0258007]
  Actuator2-58 MON Force	[E-0258 0:3 0258006]
  Actuator2-58 Drive Off	[E-0258 0:4 0258005]
  Actuator2-58 Drive On	[E-0258 0:5 0258004]
  Actuator2-58 CONT Position	[E-0258 0:6 0258003]
  Actuator2-58 CONT Force	[E-0258 0:7 0258002]
  Actuator2-58 Alarm Reset	[E-0258 1:1 0258020]
  Actuator2-58 Limit Release	[E-0258 1:2 025801F]
  Actuator2-58 Selected Step	[E-0258 1:3 025800E]
  Actuator2-58 Selected Load	[E-0258 1:4 025800D]
  Actuator2-58 Selected Drive	[E-0258 1:5 025800C]
  Actuator2-58 Maunakea	[E-0258 1:6 025800B]
  Actuator2-58 Sea Level	[E-0258 1:7 025800A]
  Actuator2-58 Up Limit	[E-0258 2:0 0258016]
  Actuator2-58 Driver Alarm	[E-0258 2:1 0258015]
  Actuator2-58 Error Alarm	[E-0258 2:2 0258014]
  Actuator2-58 Over Current	[E-0258 2:3 0258013]
  Actuator2-58 Over Speed	[E-0258 2:4 0258012]
  Actuator2-58 Over Load	[E-0258 2:5 0258011]
  Actuator2-58 PS Alarm	[E-0258 2:6 0258010]
  Actuator2-58 ENC Alarm	[E-0258 2:7 025800F]
  Actuator2-58 CPU Alarm	[E-0258 3:0 025801E]
  Actuator2-58 UART Alarm	[E-0258 3:1 025801D]
  Actuator2-58 HDLC Alarm	[E-0258 3:2 025801C]
  Actuator2-58 Force Card Fault	[E-0258 3:3 025801B]
  Actuator2-58 Force Sensor Fault	[E-0258 3:4 025801A]
  Actuator2-58 Under Range	[E-0258 3:5 0258019]
  Actuator2-58 Over Range	[E-0258 3:6 0258018]
  Actuator2-58 Down Limit	[E-0258 3:7 0258017]
  Actuator2-59 MON PARA	[E-0259 0:0 0259009]
  Actuator2-59 MON HYB	[E-0259 0:1 0259008]
  Actuator2-59 MON Position	[E-0259 0:2 0259007]
  Actuator2-59 MON Force	[E-0259 0:3 0259006]
  Actuator2-59 Drive Off	[E-0259 0:4 0259005]
  Actuator2-59 Drive On	[E-0259 0:5 0259004]
  Actuator2-59 CONT Position	[E-0259 0:6 0259003]
  Actuator2-59 CONT Force	[E-0259 0:7 0259002]
  Actuator2-59 Alarm Reset	[E-0259 1:1 0259020]
  Actuator2-59 Limit Release	[E-0259 1:2 025901F]
  Actuator2-59 Selected Step	[E-0259 1:3 025900E]
  Actuator2-59 Selected Load	[E-0259 1:4 025900D]
  Actuator2-59 Selected Drive	[E-0259 1:5 025900C]
  Actuator2-59 Maunakea	[E-0259 1:6 025900B]
  Actuator2-59 Sea Level	[E-0259 1:7 025900A]
  Actuator2-59 Up Limit	[E-0259 2:0 0259016]
  Actuator2-59 Driver Alarm	[E-0259 2:1 0259015]
  Actuator2-59 Error Alarm	[E-0259 2:2 0259014]
  Actuator2-59 Over Current	[E-0259 2:3 0259013]
  Actuator2-59 Over Speed	[E-0259 2:4 0259012]
  Actuator2-59 Over Load	[E-0259 2:5 0259011]
  Actuator2-59 PS Alarm	[E-0259 2:6 0259010]
  Actuator2-59 ENC Alarm	[E-0259 2:7 025900F]
  Actuator2-59 CPU Alarm	[E-0259 3:0 025901E]
  Actuator2-59 UART Alarm	[E-0259 3:1 025901D]
  Actuator2-59 HDLC Alarm	[E-0259 3:2 025901C]
  Actuator2-59 Force Card Fault	[E-0259 3:3 025901B]
  Actuator2-59 Force Sensor Fault	[E-0259 3:4 025901A]
  Actuator2-59 Under Range	[E-0259 3:5 0259019]
  Actuator2-59 Over Range	[E-0259 3:6 0259018]
  Actuator2-59 Down Limit	[E-0259 3:7 0259017]
  Actuator2-60 MON PARA	[E-0260 0:0 0260009]
  Actuator2-60 MON HYB	[E-0260 0:1 0260008]
  Actuator2-60 MON Position	[E-0260 0:2 0260007]
  Actuator2-60 MON Force	[E-0260 0:3 0260006]
  Actuator2-60 Drive Off	[E-0260 0:4 0260005]
  Actuator2-60 Drive On	[E-0260 0:5 0260004]
  Actuator2-60 CONT Position	[E-0260 0:6 0260003]
  Actuator2-60 CONT Force	[E-0260 0:7 0260002]
  Actuator2-60 Alarm Reset	[E-0260 1:1 0260020]
  Actuator2-60 Limit Release	[E-0260 1:2 026001F]
  Actuator2-60 Selected Step	[E-0260 1:3 026000E]
  Actuator2-60 Selected Load	[E-0260 1:4 026000D]
  Actuator2-60 Selected Drive	[E-0260 1:5 026000C]
  Actuator2-60 Maunakea	[E-0260 1:6 026000B]
  Actuator2-60 Sea Level	[E-0260 1:7 026000A]
  Actuator2-60 Up Limit	[E-0260 2:0 0260016]
  Actuator2-60 Driver Alarm	[E-0260 2:1 0260015]
  Actuator2-60 Error Alarm	[E-0260 2:2 0260014]
  Actuator2-60 Over Current	[E-0260 2:3 0260013]
  Actuator2-60 Over Speed	[E-0260 2:4 0260012]
  Actuator2-60 Over Load	[E-0260 2:5 0260011]
  Actuator2-60 PS Alarm	[E-0260 2:6 0260010]
  Actuator2-60 ENC Alarm	[E-0260 2:7 026000F]
  Actuator2-60 CPU Alarm	[E-0260 3:0 026001E]
  Actuator2-60 UART Alarm	[E-0260 3:1 026001D]
  Actuator2-60 HDLC Alarm	[E-0260 3:2 026001C]
  Actuator2-60 Force Card Fault	[E-0260 3:3 026001B]
  Actuator2-60 Force Sensor Fault	[E-0260 3:4 026001A]
  Actuator2-60 Under Range	[E-0260 3:5 0260019]
  Actuator2-60 Over Range	[E-0260 3:6 0260018]
  Actuator2-60 Down Limit	[E-0260 3:7 0260017]
  Actuator2-61 MON PARA	[E-0261 0:0 0261009]
  Actuator2-61 MON HYB	[E-0261 0:1 0261008]
  Actuator2-61 MON Position	[E-0261 0:2 0261007]
  Actuator2-61 MON Force	[E-0261 0:3 0261006]
  Actuator2-61 Drive Off	[E-0261 0:4 0261005]
  Actuator2-61 Drive On	[E-0261 0:5 0261004]
  Actuator2-61 CONT Position	[E-0261 0:6 0261003]
  Actuator2-61 CONT Force	[E-0261 0:7 0261002]
  Actuator2-61 Alarm Reset	[E-0261 1:1 0261020]
  Actuator2-61 Limit Release	[E-0261 1:2 026101F]
  Actuator2-61 Selected Step	[E-0261 1:3 026100E]
  Actuator2-61 Selected Load	[E-0261 1:4 026100D]
  Actuator2-61 Selected Drive	[E-0261 1:5 026100C]
  Actuator2-61 Maunakea	[E-0261 1:6 026100B]
  Actuator2-61 Sea Level	[E-0261 1:7 026100A]
  Actuator2-61 Up Limit	[E-0261 2:0 0261016]
  Actuator2-61 Driver Alarm	[E-0261 2:1 0261015]
  Actuator2-61 Error Alarm	[E-0261 2:2 0261014]
  Actuator2-61 Over Current	[E-0261 2:3 0261013]
  Actuator2-61 Over Speed	[E-0261 2:4 0261012]
  Actuator2-61 Over Load	[E-0261 2:5 0261011]
  Actuator2-61 PS Alarm	[E-0261 2:6 0261010]
  Actuator2-61 ENC Alarm	[E-0261 2:7 026100F]
  Actuator2-61 CPU Alarm	[E-0261 3:0 026101E]
  Actuator2-61 UART Alarm	[E-0261 3:1 026101D]
  Actuator2-61 HDLC Alarm	[E-0261 3:2 026101C]
  Actuator2-61 Force Card Fault	[E-0261 3:3 026101B]
  Actuator2-61 Force Sensor Fault	[E-0261 3:4 026101A]
  Actuator2-61 Under Range	[E-0261 3:5 0261019]
  Actuator2-61 Over Range	[E-0261 3:6 0261018]
  Actuator2-61 Down Limit	[E-0261 3:7 0261017]
  Actuator2-62 MON PARA	[E-0262 0:0 0262009]
  Actuator2-62 MON HYB	[E-0262 0:1 0262008]
  Actuator2-62 MON Position	[E-0262 0:2 0262007]
  Actuator2-62 MON Force	[E-0262 0:3 0262006]
  Actuator2-62 Drive Off	[E-0262 0:4 0262005]
  Actuator2-62 Drive On	[E-0262 0:5 0262004]
  Actuator2-62 CONT Position	[E-0262 0:6 0262003]
  Actuator2-62 CONT Force	[E-0262 0:7 0262002]
  Actuator2-62 Alarm Reset	[E-0262 1:1 0262020]
  Actuator2-62 Limit Release	[E-0262 1:2 026201F]
  Actuator2-62 Selected Step	[E-0262 1:3 026200E]
  Actuator2-62 Selected Load	[E-0262 1:4 026200D]
  Actuator2-62 Selected Drive	[E-0262 1:5 026200C]
  Actuator2-62 Maunakea	[E-0262 1:6 026200B]
  Actuator2-62 Sea Level	[E-0262 1:7 026200A]
  Actuator2-62 Up Limit	[E-0262 2:0 0262016]
  Actuator2-62 Driver Alarm	[E-0262 2:1 0262015]
  Actuator2-62 Error Alarm	[E-0262 2:2 0262014]
  Actuator2-62 Over Current	[E-0262 2:3 0262013]
  Actuator2-62 Over Speed	[E-0262 2:4 0262012]
  Actuator2-62 Over Load	[E-0262 2:5 0262011]
  Actuator2-62 PS Alarm	[E-0262 2:6 0262010]
  Actuator2-62 ENC Alarm	[E-0262 2:7 026200F]
  Actuator2-62 CPU Alarm	[E-0262 3:0 026201E]
  Actuator2-62 UART Alarm	[E-0262 3:1 026201D]
  Actuator2-62 HDLC Alarm	[E-0262 3:2 026201C]
  Actuator2-62 Force Card Fault	[E-0262 3:3 026201B]
  Actuator2-62 Force Sensor Fault	[E-0262 3:4 026201A]
  Actuator2-62 Under Range	[E-0262 3:5 0262019]
  Actuator2-62 Over Range	[E-0262 3:6 0262018]
  Actuator2-62 Down Limit	[E-0262 3:7 0262017]
  Actuator2-63 MON PARA	[E-0263 0:0 0263009]
  Actuator2-63 MON HYB	[E-0263 0:1 0263008]
  Actuator2-63 MON Position	[E-0263 0:2 0263007]
  Actuator2-63 MON Force	[E-0263 0:3 0263006]
  Actuator2-63 Drive Off	[E-0263 0:4 0263005]
  Actuator2-63 Drive On	[E-0263 0:5 0263004]
  Actuator2-63 CONT Position	[E-0263 0:6 0263003]
  Actuator2-63 CONT Force	[E-0263 0:7 0263002]
  Actuator2-63 Alarm Reset	[E-0263 1:1 0263020]
  Actuator2-63 Limit Release	[E-0263 1:2 026301F]
  Actuator2-63 Selected Step	[E-0263 1:3 026300E]
  Actuator2-63 Selected Load	[E-0263 1:4 026300D]
  Actuator2-63 Selected Drive	[E-0263 1:5 026300C]
  Actuator2-63 Maunakea	[E-0263 1:6 026300B]
  Actuator2-63 Sea Level	[E-0263 1:7 026300A]
  Actuator2-63 Up Limit	[E-0263 2:0 0263016]
  Actuator2-63 Driver Alarm	[E-0263 2:1 0263015]
  Actuator2-63 Error Alarm	[E-0263 2:2 0263014]
  Actuator2-63 Over Current	[E-0263 2:3 0263013]
  Actuator2-63 Over Speed	[E-0263 2:4 0263012]
  Actuator2-63 Over Load	[E-0263 2:5 0263011]
  Actuator2-63 PS Alarm	[E-0263 2:6 0263010]
  Actuator2-63 ENC Alarm	[E-0263 2:7 026300F]
  Actuator2-63 CPU Alarm	[E-0263 3:0 026301E]
  Actuator2-63 UART Alarm	[E-0263 3:1 026301D]
  Actuator2-63 HDLC Alarm	[E-0263 3:2 026301C]
  Actuator2-63 Force Card Fault	[E-0263 3:3 026301B]
  Actuator2-63 Force Sensor Fault	[E-0263 3:4 026301A]
  Actuator2-63 Under Range	[E-0263 3:5 0263019]
  Actuator2-63 Over Range	[E-0263 3:6 0263018]
  Actuator2-63 Down Limit	[E-0263 3:7 0263017]
  Actuator2-64 MON PARA	[E-0264 0:0 0264009]
  Actuator2-64 MON HYB	[E-0264 0:1 0264008]
  Actuator2-64 MON Position	[E-0264 0:2 0264007]
  Actuator2-64 MON Force	[E-0264 0:3 0264006]
  Actuator2-64 Drive Off	[E-0264 0:4 0264005]
  Actuator2-64 Drive On	[E-0264 0:5 0264004]
  Actuator2-64 CONT Position	[E-0264 0:6 0264003]
  Actuator2-64 CONT Force	[E-0264 0:7 0264002]
  Actuator2-64 Alarm Reset	[E-0264 1:1 0264020]
  Actuator2-64 Limit Release	[E-0264 1:2 026401F]
  Actuator2-64 Selected Step	[E-0264 1:3 026400E]
  Actuator2-64 Selected Load	[E-0264 1:4 026400D]
  Actuator2-64 Selected Drive	[E-0264 1:5 026400C]
  Actuator2-64 Maunakea	[E-0264 1:6 026400B]
  Actuator2-64 Sea Level	[E-0264 1:7 026400A]
  Actuator2-64 Up Limit	[E-0264 2:0 0264016]
  Actuator2-64 Driver Alarm	[E-0264 2:1 0264015]
  Actuator2-64 Error Alarm	[E-0264 2:2 0264014]
  Actuator2-64 Over Current	[E-0264 2:3 0264013]
  Actuator2-64 Over Speed	[E-0264 2:4 0264012]
  Actuator2-64 Over Load	[E-0264 2:5 0264011]
  Actuator2-64 PS Alarm	[E-0264 2:6 0264010]
  Actuator2-64 ENC Alarm	[E-0264 2:7 026400F]
  Actuator2-64 CPU Alarm	[E-0264 3:0 026401E]
  Actuator2-64 UART Alarm	[E-0264 3:1 026401D]
  Actuator2-64 HDLC Alarm	[E-0264 3:2 026401C]
  Actuator2-64 Force Card Fault	[E-0264 3:3 026401B]
  Actuator2-64 Force Sensor Fault	[E-0264 3:4 026401A]
  Actuator2-64 Under Range	[E-0264 3:5 0264019]
  Actuator2-64 Over Range	[E-0264 3:6 0264018]
  Actuator2-64 Down Limit	[E-0264 3:7 0264017]
  Actuator2-65 MON PARA	[E-0265 0:0 0265009]
  Actuator2-65 MON HYB	[E-0265 0:1 0265008]
  Actuator2-65 MON Position	[E-0265 0:2 0265007]
  Actuator2-65 MON Force	[E-0265 0:3 0265006]
  Actuator2-65 Drive Off	[E-0265 0:4 0265005]
  Actuator2-65 Drive On	[E-0265 0:5 0265004]
  Actuator2-65 CONT Position	[E-0265 0:6 0265003]
  Actuator2-65 CONT Force	[E-0265 0:7 0265002]
  Actuator2-65 Alarm Reset	[E-0265 1:1 0265020]
  Actuator2-65 Limit Release	[E-0265 1:2 026501F]
  Actuator2-65 Selected Step	[E-0265 1:3 026500E]
  Actuator2-65 Selected Load	[E-0265 1:4 026500D]
  Actuator2-65 Selected Drive	[E-0265 1:5 026500C]
  Actuator2-65 Maunakea	[E-0265 1:6 026500B]
  Actuator2-65 Sea Level	[E-0265 1:7 026500A]
  Actuator2-65 Up Limit	[E-0265 2:0 0265016]
  Actuator2-65 Driver Alarm	[E-0265 2:1 0265015]
  Actuator2-65 Error Alarm	[E-0265 2:2 0265014]
  Actuator2-65 Over Current	[E-0265 2:3 0265013]
  Actuator2-65 Over Speed	[E-0265 2:4 0265012]
  Actuator2-65 Over Load	[E-0265 2:5 0265011]
  Actuator2-65 PS Alarm	[E-0265 2:6 0265010]
  Actuator2-65 ENC Alarm	[E-0265 2:7 026500F]
  Actuator2-65 CPU Alarm	[E-0265 3:0 026501E]
  Actuator2-65 UART Alarm	[E-0265 3:1 026501D]
  Actuator2-65 HDLC Alarm	[E-0265 3:2 026501C]
  Actuator2-65 Force Card Fault	[E-0265 3:3 026501B]
  Actuator2-65 Force Sensor Fault	[E-0265 3:4 026501A]
  Actuator2-65 Under Range	[E-0265 3:5 0265019]
  Actuator2-65 Over Range	[E-0265 3:6 0265018]
  Actuator2-65 Down Limit	[E-0265 3:7 0265017]
  Actuator2-66 MON PARA	[E-0266 0:0 0266009]
  Actuator2-66 MON HYB	[E-0266 0:1 0266008]
  Actuator2-66 MON Position	[E-0266 0:2 0266007]
  Actuator2-66 MON Force	[E-0266 0:3 0266006]
  Actuator2-66 Drive Off	[E-0266 0:4 0266005]
  Actuator2-66 Drive On	[E-0266 0:5 0266004]
  Actuator2-66 CONT Position	[E-0266 0:6 0266003]
  Actuator2-66 CONT Force	[E-0266 0:7 0266002]
  Actuator2-66 Alarm Reset	[E-0266 1:1 0266020]
  Actuator2-66 Limit Release	[E-0266 1:2 026601F]
  Actuator2-66 Selected Step	[E-0266 1:3 026600E]
  Actuator2-66 Selected Load	[E-0266 1:4 026600D]
  Actuator2-66 Selected Drive	[E-0266 1:5 026600C]
  Actuator2-66 Maunakea	[E-0266 1:6 026600B]
  Actuator2-66 Sea Level	[E-0266 1:7 026600A]
  Actuator2-66 Up Limit	[E-0266 2:0 0266016]
  Actuator2-66 Driver Alarm	[E-0266 2:1 0266015]
  Actuator2-66 Error Alarm	[E-0266 2:2 0266014]
  Actuator2-66 Over Current	[E-0266 2:3 0266013]
  Actuator2-66 Over Speed	[E-0266 2:4 0266012]
  Actuator2-66 Over Load	[E-0266 2:5 0266011]
  Actuator2-66 PS Alarm	[E-0266 2:6 0266010]
  Actuator2-66 ENC Alarm	[E-0266 2:7 026600F]
  Actuator2-66 CPU Alarm	[E-0266 3:0 026601E]
  Actuator2-66 UART Alarm	[E-0266 3:1 026601D]
  Actuator2-66 HDLC Alarm	[E-0266 3:2 026601C]
  Actuator2-66 Force Card Fault	[E-0266 3:3 026601B]
  Actuator2-66 Force Sensor Fault	[E-0266 3:4 026601A]
  Actuator2-66 Under Range	[E-0266 3:5 0266019]
  Actuator2-66 Over Range	[E-0266 3:6 0266018]
  Actuator2-66 Down Limit	[E-0266 3:7 0266017]
  Actuator2-67 MON PARA	[E-0267 0:0 0267009]
  Actuator2-67 MON HYB	[E-0267 0:1 0267008]
  Actuator2-67 MON Position	[E-0267 0:2 0267007]
  Actuator2-67 MON Force	[E-0267 0:3 0267006]
  Actuator2-67 Drive Off	[E-0267 0:4 0267005]
  Actuator2-67 Drive On	[E-0267 0:5 0267004]
  Actuator2-67 CONT Position	[E-0267 0:6 0267003]
  Actuator2-67 CONT Force	[E-0267 0:7 0267002]
  Actuator2-67 Alarm Reset	[E-0267 1:1 0267020]
  Actuator2-67 Limit Release	[E-0267 1:2 026701F]
  Actuator2-67 Selected Step	[E-0267 1:3 026700E]
  Actuator2-67 Selected Load	[E-0267 1:4 026700D]
  Actuator2-67 Selected Drive	[E-0267 1:5 026700C]
  Actuator2-67 Maunakea	[E-0267 1:6 026700B]
  Actuator2-67 Sea Level	[E-0267 1:7 026700A]
  Actuator2-67 Up Limit	[E-0267 2:0 0267016]
  Actuator2-67 Driver Alarm	[E-0267 2:1 0267015]
  Actuator2-67 Error Alarm	[E-0267 2:2 0267014]
  Actuator2-67 Over Current	[E-0267 2:3 0267013]
  Actuator2-67 Over Speed	[E-0267 2:4 0267012]
  Actuator2-67 Over Load	[E-0267 2:5 0267011]
  Actuator2-67 PS Alarm	[E-0267 2:6 0267010]
  Actuator2-67 ENC Alarm	[E-0267 2:7 026700F]
  Actuator2-67 CPU Alarm	[E-0267 3:0 026701E]
  Actuator2-67 UART Alarm	[E-0267 3:1 026701D]
  Actuator2-67 HDLC Alarm	[E-0267 3:2 026701C]
  Actuator2-67 Force Card Fault	[E-0267 3:3 026701B]
  Actuator2-67 Force Sensor Fault	[E-0267 3:4 026701A]
  Actuator2-67 Under Range	[E-0267 3:5 0267019]
  Actuator2-67 Over Range	[E-0267 3:6 0267018]
  Actuator2-67 Down Limit	[E-0267 3:7 0267017]
  Actuator2-68 MON PARA	[E-0268 0:0 0268009]
  Actuator2-68 MON HYB	[E-0268 0:1 0268008]
  Actuator2-68 MON Position	[E-0268 0:2 0268007]
  Actuator2-68 MON Force	[E-0268 0:3 0268006]
  Actuator2-68 Drive Off	[E-0268 0:4 0268005]
  Actuator2-68 Drive On	[E-0268 0:5 0268004]
  Actuator2-68 CONT Position	[E-0268 0:6 0268003]
  Actuator2-68 CONT Force	[E-0268 0:7 0268002]
  Actuator2-68 Alarm Reset	[E-0268 1:1 0268020]
  Actuator2-68 Limit Release	[E-0268 1:2 026801F]
  Actuator2-68 Selected Step	[E-0268 1:3 026800E]
  Actuator2-68 Selected Load	[E-0268 1:4 026800D]
  Actuator2-68 Selected Drive	[E-0268 1:5 026800C]
  Actuator2-68 Maunakea	[E-0268 1:6 026800B]
  Actuator2-68 Sea Level	[E-0268 1:7 026800A]
  Actuator2-68 Up Limit	[E-0268 2:0 0268016]
  Actuator2-68 Driver Alarm	[E-0268 2:1 0268015]
  Actuator2-68 Error Alarm	[E-0268 2:2 0268014]
  Actuator2-68 Over Current	[E-0268 2:3 0268013]
  Actuator2-68 Over Speed	[E-0268 2:4 0268012]
  Actuator2-68 Over Load	[E-0268 2:5 0268011]
  Actuator2-68 PS Alarm	[E-0268 2:6 0268010]
  Actuator2-68 ENC Alarm	[E-0268 2:7 026800F]
  Actuator2-68 CPU Alarm	[E-0268 3:0 026801E]
  Actuator2-68 UART Alarm	[E-0268 3:1 026801D]
  Actuator2-68 HDLC Alarm	[E-0268 3:2 026801C]
  Actuator2-68 Force Card Fault	[E-0268 3:3 026801B]
  Actuator2-68 Force Sensor Fault	[E-0268 3:4 026801A]
  Actuator2-68 Under Range	[E-0268 3:5 0268019]
  Actuator2-68 Over Range	[E-0268 3:6 0268018]
  Actuator2-68 Down Limit	[E-0268 3:7 0268017]
  Actuator2-69 MON PARA	[E-0269 0:0 0269009]
  Actuator2-69 MON HYB	[E-0269 0:1 0269008]
  Actuator2-69 MON Position	[E-0269 0:2 0269007]
  Actuator2-69 MON Force	[E-0269 0:3 0269006]
  Actuator2-69 Drive Off	[E-0269 0:4 0269005]
  Actuator2-69 Drive On	[E-0269 0:5 0269004]
  Actuator2-69 CONT Position	[E-0269 0:6 0269003]
  Actuator2-69 CONT Force	[E-0269 0:7 0269002]
  Actuator2-69 Alarm Reset	[E-0269 1:1 0269020]
  Actuator2-69 Limit Release	[E-0269 1:2 026901F]
  Actuator2-69 Selected Step	[E-0269 1:3 026900E]
  Actuator2-69 Selected Load	[E-0269 1:4 026900D]
  Actuator2-69 Selected Drive	[E-0269 1:5 026900C]
  Actuator2-69 Maunakea	[E-0269 1:6 026900B]
  Actuator2-69 Sea Level	[E-0269 1:7 026900A]
  Actuator2-69 Up Limit	[E-0269 2:0 0269016]
  Actuator2-69 Driver Alarm	[E-0269 2:1 0269015]
  Actuator2-69 Error Alarm	[E-0269 2:2 0269014]
  Actuator2-69 Over Current	[E-0269 2:3 0269013]
  Actuator2-69 Over Speed	[E-0269 2:4 0269012]
  Actuator2-69 Over Load	[E-0269 2:5 0269011]
  Actuator2-69 PS Alarm	[E-0269 2:6 0269010]
  Actuator2-69 ENC Alarm	[E-0269 2:7 026900F]
  Actuator2-69 CPU Alarm	[E-0269 3:0 026901E]
  Actuator2-69 UART Alarm	[E-0269 3:1 026901D]
  Actuator2-69 HDLC Alarm	[E-0269 3:2 026901C]
  Actuator2-69 Force Card Fault	[E-0269 3:3 026901B]
  Actuator2-69 Force Sensor Fault	[E-0269 3:4 026901A]
  Actuator2-69 Under Range	[E-0269 3:5 0269019]
  Actuator2-69 Over Range	[E-0269 3:6 0269018]
  Actuator2-69 Down Limit	[E-0269 3:7 0269017]
  Actuator3-00 MON PARA	[E-0300 0:0 0300009]
  Actuator3-00 MON HYB	[E-0300 0:1 0300008]
  Actuator3-00 MON Position	[E-0300 0:2 0300007]
  Actuator3-00 MON Force	[E-0300 0:3 0300006]
  Actuator3-00 Drive Off	[E-0300 0:4 0300005]
  Actuator3-00 Drive On	[E-0300 0:5 0300004]
  Actuator3-00 CONT Position	[E-0300 0:6 0300003]
  Actuator3-00 CONT Force	[E-0300 0:7 0300002]
  Actuator3-00 Alarm Reset	[E-0300 1:1 0300020]
  Actuator3-00 Limit Release	[E-0300 1:2 030001F]
  Actuator3-00 Selected Step	[E-0300 1:3 030000E]
  Actuator3-00 Selected Load	[E-0300 1:4 030000D]
  Actuator3-00 Selected Drive	[E-0300 1:5 030000C]
  Actuator3-00 Maunakea	[E-0300 1:6 030000B]
  Actuator3-00 Sea Level	[E-0300 1:7 030000A]
  Actuator3-00 Up Limit	[E-0300 2:0 0300016]
  Actuator3-00 Driver Alarm	[E-0300 2:1 0300015]
  Actuator3-00 Error Alarm	[E-0300 2:2 0300014]
  Actuator3-00 Over Current	[E-0300 2:3 0300013]
  Actuator3-00 Over Speed	[E-0300 2:4 0300012]
  Actuator3-00 Over Load	[E-0300 2:5 0300011]
  Actuator3-00 PS Alarm	[E-0300 2:6 0300010]
  Actuator3-00 ENC Alarm	[E-0300 2:7 030000F]
  Actuator3-00 CPU Alarm	[E-0300 3:0 030001E]
  Actuator3-00 UART Alarm	[E-0300 3:1 030001D]
  Actuator3-00 HDLC Alarm	[E-0300 3:2 030001C]
  Actuator3-00 Force Card Fault	[E-0300 3:3 030001B]
  Actuator3-00 Force Sensor Fault	[E-0300 3:4 030001A]
  Actuator3-00 Under Range	[E-0300 3:5 0300019]
  Actuator3-00 Over Range	[E-0300 3:6 0300018]
  Actuator3-00 Down Limit	[E-0300 3:7 0300017]
  Actuator3-01 MON PARA	[E-0301 0:0 0301009]
  Actuator3-01 MON HYB	[E-0301 0:1 0301008]
  Actuator3-01 MON Position	[E-0301 0:2 0301007]
  Actuator3-01 MON Force	[E-0301 0:3 0301006]
  Actuator3-01 Drive Off	[E-0301 0:4 0301005]
  Actuator3-01 Drive On	[E-0301 0:5 0301004]
  Actuator3-01 CONT Position	[E-0301 0:6 0301003]
  Actuator3-01 CONT Force	[E-0301 0:7 0301002]
  Actuator3-01 Alarm Reset	[E-0301 1:1 0301020]
  Actuator3-01 Limit Release	[E-0301 1:2 030101F]
  Actuator3-01 Selected Step	[E-0301 1:3 030100E]
  Actuator3-01 Selected Load	[E-0301 1:4 030100D]
  Actuator3-01 Selected Drive	[E-0301 1:5 030100C]
  Actuator3-01 Maunakea	[E-0301 1:6 030100B]
  Actuator3-01 Sea Level	[E-0301 1:7 030100A]
  Actuator3-01 Up Limit	[E-0301 2:0 0301016]
  Actuator3-01 Driver Alarm	[E-0301 2:1 0301015]
  Actuator3-01 Error Alarm	[E-0301 2:2 0301014]
  Actuator3-01 Over Current	[E-0301 2:3 0301013]
  Actuator3-01 Over Speed	[E-0301 2:4 0301012]
  Actuator3-01 Over Load	[E-0301 2:5 0301011]
  Actuator3-01 PS Alarm	[E-0301 2:6 0301010]
  Actuator3-01 ENC Alarm	[E-0301 2:7 030100F]
  Actuator3-01 CPU Alarm	[E-0301 3:0 030101E]
  Actuator3-01 UART Alarm	[E-0301 3:1 030101D]
  Actuator3-01 HDLC Alarm	[E-0301 3:2 030101C]
  Actuator3-01 Force Card Fault	[E-0301 3:3 030101B]
  Actuator3-01 Force Sensor Fault	[E-0301 3:4 030101A]
  Actuator3-01 Under Range	[E-0301 3:5 0301019]
  Actuator3-01 Over Range	[E-0301 3:6 0301018]
  Actuator3-01 Down Limit	[E-0301 3:7 0301017]
  Actuator3-02 MON PARA	[E-0302 0:0 0302009]
  Actuator3-02 MON HYB	[E-0302 0:1 0302008]
  Actuator3-02 MON Position	[E-0302 0:2 0302007]
  Actuator3-02 MON Force	[E-0302 0:3 0302006]
  Actuator3-02 Drive Off	[E-0302 0:4 0302005]
  Actuator3-02 Drive On	[E-0302 0:5 0302004]
  Actuator3-02 CONT Position	[E-0302 0:6 0302003]
  Actuator3-02 CONT Force	[E-0302 0:7 0302002]
  Actuator3-02 Alarm Reset	[E-0302 1:1 0302020]
  Actuator3-02 Limit Release	[E-0302 1:2 030201F]
  Actuator3-02 Selected Step	[E-0302 1:3 030200E]
  Actuator3-02 Selected Load	[E-0302 1:4 030200D]
  Actuator3-02 Selected Drive	[E-0302 1:5 030200C]
  Actuator3-02 Maunakea	[E-0302 1:6 030200B]
  Actuator3-02 Sea Level	[E-0302 1:7 030200A]
  Actuator3-02 Up Limit	[E-0302 2:0 0302016]
  Actuator3-02 Driver Alarm	[E-0302 2:1 0302015]
  Actuator3-02 Error Alarm	[E-0302 2:2 0302014]
  Actuator3-02 Over Current	[E-0302 2:3 0302013]
  Actuator3-02 Over Speed	[E-0302 2:4 0302012]
  Actuator3-02 Over Load	[E-0302 2:5 0302011]
  Actuator3-02 PS Alarm	[E-0302 2:6 0302010]
  Actuator3-02 ENC Alarm	[E-0302 2:7 030200F]
  Actuator3-02 CPU Alarm	[E-0302 3:0 030201E]
  Actuator3-02 UART Alarm	[E-0302 3:1 030201D]
  Actuator3-02 HDLC Alarm	[E-0302 3:2 030201C]
  Actuator3-02 Force Card Fault	[E-0302 3:3 030201B]
  Actuator3-02 Force Sensor Fault	[E-0302 3:4 030201A]
  Actuator3-02 Under Range	[E-0302 3:5 0302019]
  Actuator3-02 Over Range	[E-0302 3:6 0302018]
  Actuator3-02 Down Limit	[E-0302 3:7 0302017]
  Actuator3-03 MON PARA	[E-0303 0:0 0303009]
  Actuator3-03 MON HYB	[E-0303 0:1 0303008]
  Actuator3-03 MON Position	[E-0303 0:2 0303007]
  Actuator3-03 MON Force	[E-0303 0:3 0303006]
  Actuator3-03 Drive Off	[E-0303 0:4 0303005]
  Actuator3-03 Drive On	[E-0303 0:5 0303004]
  Actuator3-03 CONT Position	[E-0303 0:6 0303003]
  Actuator3-03 CONT Force	[E-0303 0:7 0303002]
  Actuator3-03 Alarm Reset	[E-0303 1:1 0303020]
  Actuator3-03 Limit Release	[E-0303 1:2 030301F]
  Actuator3-03 Selected Step	[E-0303 1:3 030300E]
  Actuator3-03 Selected Load	[E-0303 1:4 030300D]
  Actuator3-03 Selected Drive	[E-0303 1:5 030300C]
  Actuator3-03 Maunakea	[E-0303 1:6 030300B]
  Actuator3-03 Sea Level	[E-0303 1:7 030300A]
  Actuator3-03 Up Limit	[E-0303 2:0 0303016]
  Actuator3-03 Driver Alarm	[E-0303 2:1 0303015]
  Actuator3-03 Error Alarm	[E-0303 2:2 0303014]
  Actuator3-03 Over Current	[E-0303 2:3 0303013]
  Actuator3-03 Over Speed	[E-0303 2:4 0303012]
  Actuator3-03 Over Load	[E-0303 2:5 0303011]
  Actuator3-03 PS Alarm	[E-0303 2:6 0303010]
  Actuator3-03 ENC Alarm	[E-0303 2:7 030300F]
  Actuator3-03 CPU Alarm	[E-0303 3:0 030301E]
  Actuator3-03 UART Alarm	[E-0303 3:1 030301D]
  Actuator3-03 HDLC Alarm	[E-0303 3:2 030301C]
  Actuator3-03 Force Card Fault	[E-0303 3:3 030301B]
  Actuator3-03 Force Sensor Fault	[E-0303 3:4 030301A]
  Actuator3-03 Under Range	[E-0303 3:5 0303019]
  Actuator3-03 Over Range	[E-0303 3:6 0303018]
  Actuator3-03 Down Limit	[E-0303 3:7 0303017]
  Actuator3-04 MON PARA	[E-0304 0:0 0304009]
  Actuator3-04 MON HYB	[E-0304 0:1 0304008]
  Actuator3-04 MON Position	[E-0304 0:2 0304007]
  Actuator3-04 MON Force	[E-0304 0:3 0304006]
  Actuator3-04 Drive Off	[E-0304 0:4 0304005]
  Actuator3-04 Drive On	[E-0304 0:5 0304004]
  Actuator3-04 CONT Position	[E-0304 0:6 0304003]
  Actuator3-04 CONT Force	[E-0304 0:7 0304002]
  Actuator3-04 Alarm Reset	[E-0304 1:1 0304020]
  Actuator3-04 Limit Release	[E-0304 1:2 030401F]
  Actuator3-04 Selected Step	[E-0304 1:3 030400E]
  Actuator3-04 Selected Load	[E-0304 1:4 030400D]
  Actuator3-04 Selected Drive	[E-0304 1:5 030400C]
  Actuator3-04 Maunakea	[E-0304 1:6 030400B]
  Actuator3-04 Sea Level	[E-0304 1:7 030400A]
  Actuator3-04 Up Limit	[E-0304 2:0 0304016]
  Actuator3-04 Driver Alarm	[E-0304 2:1 0304015]
  Actuator3-04 Error Alarm	[E-0304 2:2 0304014]
  Actuator3-04 Over Current	[E-0304 2:3 0304013]
  Actuator3-04 Over Speed	[E-0304 2:4 0304012]
  Actuator3-04 Over Load	[E-0304 2:5 0304011]
  Actuator3-04 PS Alarm	[E-0304 2:6 0304010]
  Actuator3-04 ENC Alarm	[E-0304 2:7 030400F]
  Actuator3-04 CPU Alarm	[E-0304 3:0 030401E]
  Actuator3-04 UART Alarm	[E-0304 3:1 030401D]
  Actuator3-04 HDLC Alarm	[E-0304 3:2 030401C]
  Actuator3-04 Force Card Fault	[E-0304 3:3 030401B]
  Actuator3-04 Force Sensor Fault	[E-0304 3:4 030401A]
  Actuator3-04 Under Range	[E-0304 3:5 0304019]
  Actuator3-04 Over Range	[E-0304 3:6 0304018]
  Actuator3-04 Down Limit	[E-0304 3:7 0304017]
  Actuator3-05 MON PARA	[E-0305 0:0 0305009]
  Actuator3-05 MON HYB	[E-0305 0:1 0305008]
  Actuator3-05 MON Position	[E-0305 0:2 0305007]
  Actuator3-05 MON Force	[E-0305 0:3 0305006]
  Actuator3-05 Drive Off	[E-0305 0:4 0305005]
  Actuator3-05 Drive On	[E-0305 0:5 0305004]
  Actuator3-05 CONT Position	[E-0305 0:6 0305003]
  Actuator3-05 CONT Force	[E-0305 0:7 0305002]
  Actuator3-05 Alarm Reset	[E-0305 1:1 0305020]
  Actuator3-05 Limit Release	[E-0305 1:2 030501F]
  Actuator3-05 Selected Step	[E-0305 1:3 030500E]
  Actuator3-05 Selected Load	[E-0305 1:4 030500D]
  Actuator3-05 Selected Drive	[E-0305 1:5 030500C]
  Actuator3-05 Maunakea	[E-0305 1:6 030500B]
  Actuator3-05 Sea Level	[E-0305 1:7 030500A]
  Actuator3-05 Up Limit	[E-0305 2:0 0305016]
  Actuator3-05 Driver Alarm	[E-0305 2:1 0305015]
  Actuator3-05 Error Alarm	[E-0305 2:2 0305014]
  Actuator3-05 Over Current	[E-0305 2:3 0305013]
  Actuator3-05 Over Speed	[E-0305 2:4 0305012]
  Actuator3-05 Over Load	[E-0305 2:5 0305011]
  Actuator3-05 PS Alarm	[E-0305 2:6 0305010]
  Actuator3-05 ENC Alarm	[E-0305 2:7 030500F]
  Actuator3-05 CPU Alarm	[E-0305 3:0 030501E]
  Actuator3-05 UART Alarm	[E-0305 3:1 030501D]
  Actuator3-05 HDLC Alarm	[E-0305 3:2 030501C]
  Actuator3-05 Force Card Fault	[E-0305 3:3 030501B]
  Actuator3-05 Force Sensor Fault	[E-0305 3:4 030501A]
  Actuator3-05 Under Range	[E-0305 3:5 0305019]
  Actuator3-05 Over Range	[E-0305 3:6 0305018]
  Actuator3-05 Down Limit	[E-0305 3:7 0305017]
  Actuator3-06 MON PARA	[E-0306 0:0 0306009]
  Actuator3-06 MON HYB	[E-0306 0:1 0306008]
  Actuator3-06 MON Position	[E-0306 0:2 0306007]
  Actuator3-06 MON Force	[E-0306 0:3 0306006]
  Actuator3-06 Drive Off	[E-0306 0:4 0306005]
  Actuator3-06 Drive On	[E-0306 0:5 0306004]
  Actuator3-06 CONT Position	[E-0306 0:6 0306003]
  Actuator3-06 CONT Force	[E-0306 0:7 0306002]
  Actuator3-06 Alarm Reset	[E-0306 1:1 0306020]
  Actuator3-06 Limit Release	[E-0306 1:2 030601F]
  Actuator3-06 Selected Step	[E-0306 1:3 030600E]
  Actuator3-06 Selected Load	[E-0306 1:4 030600D]
  Actuator3-06 Selected Drive	[E-0306 1:5 030600C]
  Actuator3-06 Maunakea	[E-0306 1:6 030600B]
  Actuator3-06 Sea Level	[E-0306 1:7 030600A]
  Actuator3-06 Up Limit	[E-0306 2:0 0306016]
  Actuator3-06 Driver Alarm	[E-0306 2:1 0306015]
  Actuator3-06 Error Alarm	[E-0306 2:2 0306014]
  Actuator3-06 Over Current	[E-0306 2:3 0306013]
  Actuator3-06 Over Speed	[E-0306 2:4 0306012]
  Actuator3-06 Over Load	[E-0306 2:5 0306011]
  Actuator3-06 PS Alarm	[E-0306 2:6 0306010]
  Actuator3-06 ENC Alarm	[E-0306 2:7 030600F]
  Actuator3-06 CPU Alarm	[E-0306 3:0 030601E]
  Actuator3-06 UART Alarm	[E-0306 3:1 030601D]
  Actuator3-06 HDLC Alarm	[E-0306 3:2 030601C]
  Actuator3-06 Force Card Fault	[E-0306 3:3 030601B]
  Actuator3-06 Force Sensor Fault	[E-0306 3:4 030601A]
  Actuator3-06 Under Range	[E-0306 3:5 0306019]
  Actuator3-06 Over Range	[E-0306 3:6 0306018]
  Actuator3-06 Down Limit	[E-0306 3:7 0306017]
  Actuator3-07 MON PARA	[E-0307 0:0 0307009]
  Actuator3-07 MON HYB	[E-0307 0:1 0307008]
  Actuator3-07 MON Position	[E-0307 0:2 0307007]
  Actuator3-07 MON Force	[E-0307 0:3 0307006]
  Actuator3-07 Drive Off	[E-0307 0:4 0307005]
  Actuator3-07 Drive On	[E-0307 0:5 0307004]
  Actuator3-07 CONT Position	[E-0307 0:6 0307003]
  Actuator3-07 CONT Force	[E-0307 0:7 0307002]
  Actuator3-07 Alarm Reset	[E-0307 1:1 0307020]
  Actuator3-07 Limit Release	[E-0307 1:2 030701F]
  Actuator3-07 Selected Step	[E-0307 1:3 030700E]
  Actuator3-07 Selected Load	[E-0307 1:4 030700D]
  Actuator3-07 Selected Drive	[E-0307 1:5 030700C]
  Actuator3-07 Maunakea	[E-0307 1:6 030700B]
  Actuator3-07 Sea Level	[E-0307 1:7 030700A]
  Actuator3-07 Up Limit	[E-0307 2:0 0307016]
  Actuator3-07 Driver Alarm	[E-0307 2:1 0307015]
  Actuator3-07 Error Alarm	[E-0307 2:2 0307014]
  Actuator3-07 Over Current	[E-0307 2:3 0307013]
  Actuator3-07 Over Speed	[E-0307 2:4 0307012]
  Actuator3-07 Over Load	[E-0307 2:5 0307011]
  Actuator3-07 PS Alarm	[E-0307 2:6 0307010]
  Actuator3-07 ENC Alarm	[E-0307 2:7 030700F]
  Actuator3-07 CPU Alarm	[E-0307 3:0 030701E]
  Actuator3-07 UART Alarm	[E-0307 3:1 030701D]
  Actuator3-07 HDLC Alarm	[E-0307 3:2 030701C]
  Actuator3-07 Force Card Fault	[E-0307 3:3 030701B]
  Actuator3-07 Force Sensor Fault	[E-0307 3:4 030701A]
  Actuator3-07 Under Range	[E-0307 3:5 0307019]
  Actuator3-07 Over Range	[E-0307 3:6 0307018]
  Actuator3-07 Down Limit	[E-0307 3:7 0307017]
  Actuator3-08 MON PARA	[E-0308 0:0 0308009]
  Actuator3-08 MON HYB	[E-0308 0:1 0308008]
  Actuator3-08 MON Position	[E-0308 0:2 0308007]
  Actuator3-08 MON Force	[E-0308 0:3 0308006]
  Actuator3-08 Drive Off	[E-0308 0:4 0308005]
  Actuator3-08 Drive On	[E-0308 0:5 0308004]
  Actuator3-08 CONT Position	[E-0308 0:6 0308003]
  Actuator3-08 CONT Force	[E-0308 0:7 0308002]
  Actuator3-08 Alarm Reset	[E-0308 1:1 0308020]
  Actuator3-08 Limit Release	[E-0308 1:2 030801F]
  Actuator3-08 Selected Step	[E-0308 1:3 030800E]
  Actuator3-08 Selected Load	[E-0308 1:4 030800D]
  Actuator3-08 Selected Drive	[E-0308 1:5 030800C]
  Actuator3-08 Maunakea	[E-0308 1:6 030800B]
  Actuator3-08 Sea Level	[E-0308 1:7 030800A]
  Actuator3-08 Up Limit	[E-0308 2:0 0308016]
  Actuator3-08 Driver Alarm	[E-0308 2:1 0308015]
  Actuator3-08 Error Alarm	[E-0308 2:2 0308014]
  Actuator3-08 Over Current	[E-0308 2:3 0308013]
  Actuator3-08 Over Speed	[E-0308 2:4 0308012]
  Actuator3-08 Over Load	[E-0308 2:5 0308011]
  Actuator3-08 PS Alarm	[E-0308 2:6 0308010]
  Actuator3-08 ENC Alarm	[E-0308 2:7 030800F]
  Actuator3-08 CPU Alarm	[E-0308 3:0 030801E]
  Actuator3-08 UART Alarm	[E-0308 3:1 030801D]
  Actuator3-08 HDLC Alarm	[E-0308 3:2 030801C]
  Actuator3-08 Force Card Fault	[E-0308 3:3 030801B]
  Actuator3-08 Force Sensor Fault	[E-0308 3:4 030801A]
  Actuator3-08 Under Range	[E-0308 3:5 0308019]
  Actuator3-08 Over Range	[E-0308 3:6 0308018]
  Actuator3-08 Down Limit	[E-0308 3:7 0308017]
  Actuator3-09 MON PARA	[E-0309 0:0 0309009]
  Actuator3-09 MON HYB	[E-0309 0:1 0309008]
  Actuator3-09 MON Position	[E-0309 0:2 0309007]
  Actuator3-09 MON Force	[E-0309 0:3 0309006]
  Actuator3-09 Drive Off	[E-0309 0:4 0309005]
  Actuator3-09 Drive On	[E-0309 0:5 0309004]
  Actuator3-09 CONT Position	[E-0309 0:6 0309003]
  Actuator3-09 CONT Force	[E-0309 0:7 0309002]
  Actuator3-09 Alarm Reset	[E-0309 1:1 0309020]
  Actuator3-09 Limit Release	[E-0309 1:2 030901F]
  Actuator3-09 Selected Step	[E-0309 1:3 030900E]
  Actuator3-09 Selected Load	[E-0309 1:4 030900D]
  Actuator3-09 Selected Drive	[E-0309 1:5 030900C]
  Actuator3-09 Maunakea	[E-0309 1:6 030900B]
  Actuator3-09 Sea Level	[E-0309 1:7 030900A]
  Actuator3-09 Up Limit	[E-0309 2:0 0309016]
  Actuator3-09 Driver Alarm	[E-0309 2:1 0309015]
  Actuator3-09 Error Alarm	[E-0309 2:2 0309014]
  Actuator3-09 Over Current	[E-0309 2:3 0309013]
  Actuator3-09 Over Speed	[E-0309 2:4 0309012]
  Actuator3-09 Over Load	[E-0309 2:5 0309011]
  Actuator3-09 PS Alarm	[E-0309 2:6 0309010]
  Actuator3-09 ENC Alarm	[E-0309 2:7 030900F]
  Actuator3-09 CPU Alarm	[E-0309 3:0 030901E]
  Actuator3-09 UART Alarm	[E-0309 3:1 030901D]
  Actuator3-09 HDLC Alarm	[E-0309 3:2 030901C]
  Actuator3-09 Force Card Fault	[E-0309 3:3 030901B]
  Actuator3-09 Force Sensor Fault	[E-0309 3:4 030901A]
  Actuator3-09 Under Range	[E-0309 3:5 0309019]
  Actuator3-09 Over Range	[E-0309 3:6 0309018]
  Actuator3-09 Down Limit	[E-0309 3:7 0309017]
  Actuator3-10 MON PARA	[E-0310 0:0 0310009]
  Actuator3-10 MON HYB	[E-0310 0:1 0310008]
  Actuator3-10 MON Position	[E-0310 0:2 0310007]
  Actuator3-10 MON Force	[E-0310 0:3 0310006]
  Actuator3-10 Drive Off	[E-0310 0:4 0310005]
  Actuator3-10 Drive On	[E-0310 0:5 0310004]
  Actuator3-10 CONT Position	[E-0310 0:6 0310003]
  Actuator3-10 CONT Force	[E-0310 0:7 0310002]
  Actuator3-10 Alarm Reset	[E-0310 1:1 0310020]
  Actuator3-10 Limit Release	[E-0310 1:2 031001F]
  Actuator3-10 Selected Step	[E-0310 1:3 031000E]
  Actuator3-10 Selected Load	[E-0310 1:4 031000D]
  Actuator3-10 Selected Drive	[E-0310 1:5 031000C]
  Actuator3-10 Maunakea	[E-0310 1:6 031000B]
  Actuator3-10 Sea Level	[E-0310 1:7 031000A]
  Actuator3-10 Up Limit	[E-0310 2:0 0310016]
  Actuator3-10 Driver Alarm	[E-0310 2:1 0310015]
  Actuator3-10 Error Alarm	[E-0310 2:2 0310014]
  Actuator3-10 Over Current	[E-0310 2:3 0310013]
  Actuator3-10 Over Speed	[E-0310 2:4 0310012]
  Actuator3-10 Over Load	[E-0310 2:5 0310011]
  Actuator3-10 PS Alarm	[E-0310 2:6 0310010]
  Actuator3-10 ENC Alarm	[E-0310 2:7 031000F]
  Actuator3-10 CPU Alarm	[E-0310 3:0 031001E]
  Actuator3-10 UART Alarm	[E-0310 3:1 031001D]
  Actuator3-10 HDLC Alarm	[E-0310 3:2 031001C]
  Actuator3-10 Force Card Fault	[E-0310 3:3 031001B]
  Actuator3-10 Force Sensor Fault	[E-0310 3:4 031001A]
  Actuator3-10 Under Range	[E-0310 3:5 0310019]
  Actuator3-10 Over Range	[E-0310 3:6 0310018]
  Actuator3-10 Down Limit	[E-0310 3:7 0310017]
  Actuator3-11 MON PARA	[E-0311 0:0 0311009]
  Actuator3-11 MON HYB	[E-0311 0:1 0311008]
  Actuator3-11 MON Position	[E-0311 0:2 0311007]
  Actuator3-11 MON Force	[E-0311 0:3 0311006]
  Actuator3-11 Drive Off	[E-0311 0:4 0311005]
  Actuator3-11 Drive On	[E-0311 0:5 0311004]
  Actuator3-11 CONT Position	[E-0311 0:6 0311003]
  Actuator3-11 CONT Force	[E-0311 0:7 0311002]
  Actuator3-11 Alarm Reset	[E-0311 1:1 0311020]
  Actuator3-11 Limit Release	[E-0311 1:2 031101F]
  Actuator3-11 Selected Step	[E-0311 1:3 031100E]
  Actuator3-11 Selected Load	[E-0311 1:4 031100D]
  Actuator3-11 Selected Drive	[E-0311 1:5 031100C]
  Actuator3-11 Maunakea	[E-0311 1:6 031100B]
  Actuator3-11 Sea Level	[E-0311 1:7 031100A]
  Actuator3-11 Up Limit	[E-0311 2:0 0311016]
  Actuator3-11 Driver Alarm	[E-0311 2:1 0311015]
  Actuator3-11 Error Alarm	[E-0311 2:2 0311014]
  Actuator3-11 Over Current	[E-0311 2:3 0311013]
  Actuator3-11 Over Speed	[E-0311 2:4 0311012]
  Actuator3-11 Over Load	[E-0311 2:5 0311011]
  Actuator3-11 PS Alarm	[E-0311 2:6 0311010]
  Actuator3-11 ENC Alarm	[E-0311 2:7 031100F]
  Actuator3-11 CPU Alarm	[E-0311 3:0 031101E]
  Actuator3-11 UART Alarm	[E-0311 3:1 031101D]
  Actuator3-11 HDLC Alarm	[E-0311 3:2 031101C]
  Actuator3-11 Force Card Fault	[E-0311 3:3 031101B]
  Actuator3-11 Force Sensor Fault	[E-0311 3:4 031101A]
  Actuator3-11 Under Range	[E-0311 3:5 0311019]
  Actuator3-11 Over Range	[E-0311 3:6 0311018]
  Actuator3-11 Down Limit	[E-0311 3:7 0311017]
  Actuator3-12 MON PARA	[E-0312 0:0 0312009]
  Actuator3-12 MON HYB	[E-0312 0:1 0312008]
  Actuator3-12 MON Position	[E-0312 0:2 0312007]
  Actuator3-12 MON Force	[E-0312 0:3 0312006]
  Actuator3-12 Drive Off	[E-0312 0:4 0312005]
  Actuator3-12 Drive On	[E-0312 0:5 0312004]
  Actuator3-12 CONT Position	[E-0312 0:6 0312003]
  Actuator3-12 CONT Force	[E-0312 0:7 0312002]
  Actuator3-12 Alarm Reset	[E-0312 1:1 0312020]
  Actuator3-12 Limit Release	[E-0312 1:2 031201F]
  Actuator3-12 Selected Step	[E-0312 1:3 031200E]
  Actuator3-12 Selected Load	[E-0312 1:4 031200D]
  Actuator3-12 Selected Drive	[E-0312 1:5 031200C]
  Actuator3-12 Maunakea	[E-0312 1:6 031200B]
  Actuator3-12 Sea Level	[E-0312 1:7 031200A]
  Actuator3-12 Up Limit	[E-0312 2:0 0312016]
  Actuator3-12 Driver Alarm	[E-0312 2:1 0312015]
  Actuator3-12 Error Alarm	[E-0312 2:2 0312014]
  Actuator3-12 Over Current	[E-0312 2:3 0312013]
  Actuator3-12 Over Speed	[E-0312 2:4 0312012]
  Actuator3-12 Over Load	[E-0312 2:5 0312011]
  Actuator3-12 PS Alarm	[E-0312 2:6 0312010]
  Actuator3-12 ENC Alarm	[E-0312 2:7 031200F]
  Actuator3-12 CPU Alarm	[E-0312 3:0 031201E]
  Actuator3-12 UART Alarm	[E-0312 3:1 031201D]
  Actuator3-12 HDLC Alarm	[E-0312 3:2 031201C]
  Actuator3-12 Force Card Fault	[E-0312 3:3 031201B]
  Actuator3-12 Force Sensor Fault	[E-0312 3:4 031201A]
  Actuator3-12 Under Range	[E-0312 3:5 0312019]
  Actuator3-12 Over Range	[E-0312 3:6 0312018]
  Actuator3-12 Down Limit	[E-0312 3:7 0312017]
  Actuator3-13 MON PARA	[E-0313 0:0 0313009]
  Actuator3-13 MON HYB	[E-0313 0:1 0313008]
  Actuator3-13 MON Position	[E-0313 0:2 0313007]
  Actuator3-13 MON Force	[E-0313 0:3 0313006]
  Actuator3-13 Drive Off	[E-0313 0:4 0313005]
  Actuator3-13 Drive On	[E-0313 0:5 0313004]
  Actuator3-13 CONT Position	[E-0313 0:6 0313003]
  Actuator3-13 CONT Force	[E-0313 0:7 0313002]
  Actuator3-13 Alarm Reset	[E-0313 1:1 0313020]
  Actuator3-13 Limit Release	[E-0313 1:2 031301F]
  Actuator3-13 Selected Step	[E-0313 1:3 031300E]
  Actuator3-13 Selected Load	[E-0313 1:4 031300D]
  Actuator3-13 Selected Drive	[E-0313 1:5 031300C]
  Actuator3-13 Maunakea	[E-0313 1:6 031300B]
  Actuator3-13 Sea Level	[E-0313 1:7 031300A]
  Actuator3-13 Up Limit	[E-0313 2:0 0313016]
  Actuator3-13 Driver Alarm	[E-0313 2:1 0313015]
  Actuator3-13 Error Alarm	[E-0313 2:2 0313014]
  Actuator3-13 Over Current	[E-0313 2:3 0313013]
  Actuator3-13 Over Speed	[E-0313 2:4 0313012]
  Actuator3-13 Over Load	[E-0313 2:5 0313011]
  Actuator3-13 PS Alarm	[E-0313 2:6 0313010]
  Actuator3-13 ENC Alarm	[E-0313 2:7 031300F]
  Actuator3-13 CPU Alarm	[E-0313 3:0 031301E]
  Actuator3-13 UART Alarm	[E-0313 3:1 031301D]
  Actuator3-13 HDLC Alarm	[E-0313 3:2 031301C]
  Actuator3-13 Force Card Fault	[E-0313 3:3 031301B]
  Actuator3-13 Force Sensor Fault	[E-0313 3:4 031301A]
  Actuator3-13 Under Range	[E-0313 3:5 0313019]
  Actuator3-13 Over Range	[E-0313 3:6 0313018]
  Actuator3-13 Down Limit	[E-0313 3:7 0313017]
  Actuator3-14 MON PARA	[E-0314 0:0 0314009]
  Actuator3-14 MON HYB	[E-0314 0:1 0314008]
  Actuator3-14 MON Position	[E-0314 0:2 0314007]
  Actuator3-14 MON Force	[E-0314 0:3 0314006]
  Actuator3-14 Drive Off	[E-0314 0:4 0314005]
  Actuator3-14 Drive On	[E-0314 0:5 0314004]
  Actuator3-14 CONT Position	[E-0314 0:6 0314003]
  Actuator3-14 CONT Force	[E-0314 0:7 0314002]
  Actuator3-14 Alarm Reset	[E-0314 1:1 0314020]
  Actuator3-14 Limit Release	[E-0314 1:2 031401F]
  Actuator3-14 Selected Step	[E-0314 1:3 031400E]
  Actuator3-14 Selected Load	[E-0314 1:4 031400D]
  Actuator3-14 Selected Drive	[E-0314 1:5 031400C]
  Actuator3-14 Maunakea	[E-0314 1:6 031400B]
  Actuator3-14 Sea Level	[E-0314 1:7 031400A]
  Actuator3-14 Up Limit	[E-0314 2:0 0314016]
  Actuator3-14 Driver Alarm	[E-0314 2:1 0314015]
  Actuator3-14 Error Alarm	[E-0314 2:2 0314014]
  Actuator3-14 Over Current	[E-0314 2:3 0314013]
  Actuator3-14 Over Speed	[E-0314 2:4 0314012]
  Actuator3-14 Over Load	[E-0314 2:5 0314011]
  Actuator3-14 PS Alarm	[E-0314 2:6 0314010]
  Actuator3-14 ENC Alarm	[E-0314 2:7 031400F]
  Actuator3-14 CPU Alarm	[E-0314 3:0 031401E]
  Actuator3-14 UART Alarm	[E-0314 3:1 031401D]
  Actuator3-14 HDLC Alarm	[E-0314 3:2 031401C]
  Actuator3-14 Force Card Fault	[E-0314 3:3 031401B]
  Actuator3-14 Force Sensor Fault	[E-0314 3:4 031401A]
  Actuator3-14 Under Range	[E-0314 3:5 0314019]
  Actuator3-14 Over Range	[E-0314 3:6 0314018]
  Actuator3-14 Down Limit	[E-0314 3:7 0314017]
  Actuator3-15 MON PARA	[E-0315 0:0 0315009]
  Actuator3-15 MON HYB	[E-0315 0:1 0315008]
  Actuator3-15 MON Position	[E-0315 0:2 0315007]
  Actuator3-15 MON Force	[E-0315 0:3 0315006]
  Actuator3-15 Drive Off	[E-0315 0:4 0315005]
  Actuator3-15 Drive On	[E-0315 0:5 0315004]
  Actuator3-15 CONT Position	[E-0315 0:6 0315003]
  Actuator3-15 CONT Force	[E-0315 0:7 0315002]
  Actuator3-15 Alarm Reset	[E-0315 1:1 0315020]
  Actuator3-15 Limit Release	[E-0315 1:2 031501F]
  Actuator3-15 Selected Step	[E-0315 1:3 031500E]
  Actuator3-15 Selected Load	[E-0315 1:4 031500D]
  Actuator3-15 Selected Drive	[E-0315 1:5 031500C]
  Actuator3-15 Maunakea	[E-0315 1:6 031500B]
  Actuator3-15 Sea Level	[E-0315 1:7 031500A]
  Actuator3-15 Up Limit	[E-0315 2:0 0315016]
  Actuator3-15 Driver Alarm	[E-0315 2:1 0315015]
  Actuator3-15 Error Alarm	[E-0315 2:2 0315014]
  Actuator3-15 Over Current	[E-0315 2:3 0315013]
  Actuator3-15 Over Speed	[E-0315 2:4 0315012]
  Actuator3-15 Over Load	[E-0315 2:5 0315011]
  Actuator3-15 PS Alarm	[E-0315 2:6 0315010]
  Actuator3-15 ENC Alarm	[E-0315 2:7 031500F]
  Actuator3-15 CPU Alarm	[E-0315 3:0 031501E]
  Actuator3-15 UART Alarm	[E-0315 3:1 031501D]
  Actuator3-15 HDLC Alarm	[E-0315 3:2 031501C]
  Actuator3-15 Force Card Fault	[E-0315 3:3 031501B]
  Actuator3-15 Force Sensor Fault	[E-0315 3:4 031501A]
  Actuator3-15 Under Range	[E-0315 3:5 0315019]
  Actuator3-15 Over Range	[E-0315 3:6 0315018]
  Actuator3-15 Down Limit	[E-0315 3:7 0315017]
  Actuator3-16 MON PARA	[E-0316 0:0 0316009]
  Actuator3-16 MON HYB	[E-0316 0:1 0316008]
  Actuator3-16 MON Position	[E-0316 0:2 0316007]
  Actuator3-16 MON Force	[E-0316 0:3 0316006]
  Actuator3-16 Drive Off	[E-0316 0:4 0316005]
  Actuator3-16 Drive On	[E-0316 0:5 0316004]
  Actuator3-16 CONT Position	[E-0316 0:6 0316003]
  Actuator3-16 CONT Force	[E-0316 0:7 0316002]
  Actuator3-16 Alarm Reset	[E-0316 1:1 0316020]
  Actuator3-16 Limit Release	[E-0316 1:2 031601F]
  Actuator3-16 Selected Step	[E-0316 1:3 031600E]
  Actuator3-16 Selected Load	[E-0316 1:4 031600D]
  Actuator3-16 Selected Drive	[E-0316 1:5 031600C]
  Actuator3-16 Maunakea	[E-0316 1:6 031600B]
  Actuator3-16 Sea Level	[E-0316 1:7 031600A]
  Actuator3-16 Up Limit	[E-0316 2:0 0316016]
  Actuator3-16 Driver Alarm	[E-0316 2:1 0316015]
  Actuator3-16 Error Alarm	[E-0316 2:2 0316014]
  Actuator3-16 Over Current	[E-0316 2:3 0316013]
  Actuator3-16 Over Speed	[E-0316 2:4 0316012]
  Actuator3-16 Over Load	[E-0316 2:5 0316011]
  Actuator3-16 PS Alarm	[E-0316 2:6 0316010]
  Actuator3-16 ENC Alarm	[E-0316 2:7 031600F]
  Actuator3-16 CPU Alarm	[E-0316 3:0 031601E]
  Actuator3-16 UART Alarm	[E-0316 3:1 031601D]
  Actuator3-16 HDLC Alarm	[E-0316 3:2 031601C]
  Actuator3-16 Force Card Fault	[E-0316 3:3 031601B]
  Actuator3-16 Force Sensor Fault	[E-0316 3:4 031601A]
  Actuator3-16 Under Range	[E-0316 3:5 0316019]
  Actuator3-16 Over Range	[E-0316 3:6 0316018]
  Actuator3-16 Down Limit	[E-0316 3:7 0316017]
  Actuator3-17 MON PARA	[E-0317 0:0 0317009]
  Actuator3-17 MON HYB	[E-0317 0:1 0317008]
  Actuator3-17 MON Position	[E-0317 0:2 0317007]
  Actuator3-17 MON Force	[E-0317 0:3 0317006]
  Actuator3-17 Drive Off	[E-0317 0:4 0317005]
  Actuator3-17 Drive On	[E-0317 0:5 0317004]
  Actuator3-17 CONT Position	[E-0317 0:6 0317003]
  Actuator3-17 CONT Force	[E-0317 0:7 0317002]
  Actuator3-17 Alarm Reset	[E-0317 1:1 0317020]
  Actuator3-17 Limit Release	[E-0317 1:2 031701F]
  Actuator3-17 Selected Step	[E-0317 1:3 031700E]
  Actuator3-17 Selected Load	[E-0317 1:4 031700D]
  Actuator3-17 Selected Drive	[E-0317 1:5 031700C]
  Actuator3-17 Maunakea	[E-0317 1:6 031700B]
  Actuator3-17 Sea Level	[E-0317 1:7 031700A]
  Actuator3-17 Up Limit	[E-0317 2:0 0317016]
  Actuator3-17 Driver Alarm	[E-0317 2:1 0317015]
  Actuator3-17 Error Alarm	[E-0317 2:2 0317014]
  Actuator3-17 Over Current	[E-0317 2:3 0317013]
  Actuator3-17 Over Speed	[E-0317 2:4 0317012]
  Actuator3-17 Over Load	[E-0317 2:5 0317011]
  Actuator3-17 PS Alarm	[E-0317 2:6 0317010]
  Actuator3-17 ENC Alarm	[E-0317 2:7 031700F]
  Actuator3-17 CPU Alarm	[E-0317 3:0 031701E]
  Actuator3-17 UART Alarm	[E-0317 3:1 031701D]
  Actuator3-17 HDLC Alarm	[E-0317 3:2 031701C]
  Actuator3-17 Force Card Fault	[E-0317 3:3 031701B]
  Actuator3-17 Force Sensor Fault	[E-0317 3:4 031701A]
  Actuator3-17 Under Range	[E-0317 3:5 0317019]
  Actuator3-17 Over Range	[E-0317 3:6 0317018]
  Actuator3-17 Down Limit	[E-0317 3:7 0317017]
  Actuator3-18 MON PARA	[E-0318 0:0 0318009]
  Actuator3-18 MON HYB	[E-0318 0:1 0318008]
  Actuator3-18 MON Position	[E-0318 0:2 0318007]
  Actuator3-18 MON Force	[E-0318 0:3 0318006]
  Actuator3-18 Drive Off	[E-0318 0:4 0318005]
  Actuator3-18 Drive On	[E-0318 0:5 0318004]
  Actuator3-18 CONT Position	[E-0318 0:6 0318003]
  Actuator3-18 CONT Force	[E-0318 0:7 0318002]
  Actuator3-18 Alarm Reset	[E-0318 1:1 0318020]
  Actuator3-18 Limit Release	[E-0318 1:2 031801F]
  Actuator3-18 Selected Step	[E-0318 1:3 031800E]
  Actuator3-18 Selected Load	[E-0318 1:4 031800D]
  Actuator3-18 Selected Drive	[E-0318 1:5 031800C]
  Actuator3-18 Maunakea	[E-0318 1:6 031800B]
  Actuator3-18 Sea Level	[E-0318 1:7 031800A]
  Actuator3-18 Up Limit	[E-0318 2:0 0318016]
  Actuator3-18 Driver Alarm	[E-0318 2:1 0318015]
  Actuator3-18 Error Alarm	[E-0318 2:2 0318014]
  Actuator3-18 Over Current	[E-0318 2:3 0318013]
  Actuator3-18 Over Speed	[E-0318 2:4 0318012]
  Actuator3-18 Over Load	[E-0318 2:5 0318011]
  Actuator3-18 PS Alarm	[E-0318 2:6 0318010]
  Actuator3-18 ENC Alarm	[E-0318 2:7 031800F]
  Actuator3-18 CPU Alarm	[E-0318 3:0 031801E]
  Actuator3-18 UART Alarm	[E-0318 3:1 031801D]
  Actuator3-18 HDLC Alarm	[E-0318 3:2 031801C]
  Actuator3-18 Force Card Fault	[E-0318 3:3 031801B]
  Actuator3-18 Force Sensor Fault	[E-0318 3:4 031801A]
  Actuator3-18 Under Range	[E-0318 3:5 0318019]
  Actuator3-18 Over Range	[E-0318 3:6 0318018]
  Actuator3-18 Down Limit	[E-0318 3:7 0318017]
  Actuator3-19 MON PARA	[E-0319 0:0 0319009]
  Actuator3-19 MON HYB	[E-0319 0:1 0319008]
  Actuator3-19 MON Position	[E-0319 0:2 0319007]
  Actuator3-19 MON Force	[E-0319 0:3 0319006]
  Actuator3-19 Drive Off	[E-0319 0:4 0319005]
  Actuator3-19 Drive On	[E-0319 0:5 0319004]
  Actuator3-19 CONT Position	[E-0319 0:6 0319003]
  Actuator3-19 CONT Force	[E-0319 0:7 0319002]
  Actuator3-19 Alarm Reset	[E-0319 1:1 0319020]
  Actuator3-19 Limit Release	[E-0319 1:2 031901F]
  Actuator3-19 Selected Step	[E-0319 1:3 031900E]
  Actuator3-19 Selected Load	[E-0319 1:4 031900D]
  Actuator3-19 Selected Drive	[E-0319 1:5 031900C]
  Actuator3-19 Maunakea	[E-0319 1:6 031900B]
  Actuator3-19 Sea Level	[E-0319 1:7 031900A]
  Actuator3-19 Up Limit	[E-0319 2:0 0319016]
  Actuator3-19 Driver Alarm	[E-0319 2:1 0319015]
  Actuator3-19 Error Alarm	[E-0319 2:2 0319014]
  Actuator3-19 Over Current	[E-0319 2:3 0319013]
  Actuator3-19 Over Speed	[E-0319 2:4 0319012]
  Actuator3-19 Over Load	[E-0319 2:5 0319011]
  Actuator3-19 PS Alarm	[E-0319 2:6 0319010]
  Actuator3-19 ENC Alarm	[E-0319 2:7 031900F]
  Actuator3-19 CPU Alarm	[E-0319 3:0 031901E]
  Actuator3-19 UART Alarm	[E-0319 3:1 031901D]
  Actuator3-19 HDLC Alarm	[E-0319 3:2 031901C]
  Actuator3-19 Force Card Fault	[E-0319 3:3 031901B]
  Actuator3-19 Force Sensor Fault	[E-0319 3:4 031901A]
  Actuator3-19 Under Range	[E-0319 3:5 0319019]
  Actuator3-19 Over Range	[E-0319 3:6 0319018]
  Actuator3-19 Down Limit	[E-0319 3:7 0319017]
  Actuator3-20 MON PARA	[E-0320 0:0 0320009]
  Actuator3-20 MON HYB	[E-0320 0:1 0320008]
  Actuator3-20 MON Position	[E-0320 0:2 0320007]
  Actuator3-20 MON Force	[E-0320 0:3 0320006]
  Actuator3-20 Drive Off	[E-0320 0:4 0320005]
  Actuator3-20 Drive On	[E-0320 0:5 0320004]
  Actuator3-20 CONT Position	[E-0320 0:6 0320003]
  Actuator3-20 CONT Force	[E-0320 0:7 0320002]
  Actuator3-20 Alarm Reset	[E-0320 1:1 0320020]
  Actuator3-20 Limit Release	[E-0320 1:2 032001F]
  Actuator3-20 Selected Step	[E-0320 1:3 032000E]
  Actuator3-20 Selected Load	[E-0320 1:4 032000D]
  Actuator3-20 Selected Drive	[E-0320 1:5 032000C]
  Actuator3-20 Maunakea	[E-0320 1:6 032000B]
  Actuator3-20 Sea Level	[E-0320 1:7 032000A]
  Actuator3-20 Up Limit	[E-0320 2:0 0320016]
  Actuator3-20 Driver Alarm	[E-0320 2:1 0320015]
  Actuator3-20 Error Alarm	[E-0320 2:2 0320014]
  Actuator3-20 Over Current	[E-0320 2:3 0320013]
  Actuator3-20 Over Speed	[E-0320 2:4 0320012]
  Actuator3-20 Over Load	[E-0320 2:5 0320011]
  Actuator3-20 PS Alarm	[E-0320 2:6 0320010]
  Actuator3-20 ENC Alarm	[E-0320 2:7 032000F]
  Actuator3-20 CPU Alarm	[E-0320 3:0 032001E]
  Actuator3-20 UART Alarm	[E-0320 3:1 032001D]
  Actuator3-20 HDLC Alarm	[E-0320 3:2 032001C]
  Actuator3-20 Force Card Fault	[E-0320 3:3 032001B]
  Actuator3-20 Force Sensor Fault	[E-0320 3:4 032001A]
  Actuator3-20 Under Range	[E-0320 3:5 0320019]
  Actuator3-20 Over Range	[E-0320 3:6 0320018]
  Actuator3-20 Down Limit	[E-0320 3:7 0320017]
  Actuator3-21 MON PARA	[E-0321 0:0 0321009]
  Actuator3-21 MON HYB	[E-0321 0:1 0321008]
  Actuator3-21 MON Position	[E-0321 0:2 0321007]
  Actuator3-21 MON Force	[E-0321 0:3 0321006]
  Actuator3-21 Drive Off	[E-0321 0:4 0321005]
  Actuator3-21 Drive On	[E-0321 0:5 0321004]
  Actuator3-21 CONT Position	[E-0321 0:6 0321003]
  Actuator3-21 CONT Force	[E-0321 0:7 0321002]
  Actuator3-21 Alarm Reset	[E-0321 1:1 0321020]
  Actuator3-21 Limit Release	[E-0321 1:2 032101F]
  Actuator3-21 Selected Step	[E-0321 1:3 032100E]
  Actuator3-21 Selected Load	[E-0321 1:4 032100D]
  Actuator3-21 Selected Drive	[E-0321 1:5 032100C]
  Actuator3-21 Maunakea	[E-0321 1:6 032100B]
  Actuator3-21 Sea Level	[E-0321 1:7 032100A]
  Actuator3-21 Up Limit	[E-0321 2:0 0321016]
  Actuator3-21 Driver Alarm	[E-0321 2:1 0321015]
  Actuator3-21 Error Alarm	[E-0321 2:2 0321014]
  Actuator3-21 Over Current	[E-0321 2:3 0321013]
  Actuator3-21 Over Speed	[E-0321 2:4 0321012]
  Actuator3-21 Over Load	[E-0321 2:5 0321011]
  Actuator3-21 PS Alarm	[E-0321 2:6 0321010]
  Actuator3-21 ENC Alarm	[E-0321 2:7 032100F]
  Actuator3-21 CPU Alarm	[E-0321 3:0 032101E]
  Actuator3-21 UART Alarm	[E-0321 3:1 032101D]
  Actuator3-21 HDLC Alarm	[E-0321 3:2 032101C]
  Actuator3-21 Force Card Fault	[E-0321 3:3 032101B]
  Actuator3-21 Force Sensor Fault	[E-0321 3:4 032101A]
  Actuator3-21 Under Range	[E-0321 3:5 0321019]
  Actuator3-21 Over Range	[E-0321 3:6 0321018]
  Actuator3-21 Down Limit	[E-0321 3:7 0321017]
  Actuator3-22 MON PARA	[E-0322 0:0 0322009]
  Actuator3-22 MON HYB	[E-0322 0:1 0322008]
  Actuator3-22 MON Position	[E-0322 0:2 0322007]
  Actuator3-22 MON Force	[E-0322 0:3 0322006]
  Actuator3-22 Drive Off	[E-0322 0:4 0322005]
  Actuator3-22 Drive On	[E-0322 0:5 0322004]
  Actuator3-22 CONT Position	[E-0322 0:6 0322003]
  Actuator3-22 CONT Force	[E-0322 0:7 0322002]
  Actuator3-22 Alarm Reset	[E-0322 1:1 0322020]
  Actuator3-22 Limit Release	[E-0322 1:2 032201F]
  Actuator3-22 Selected Step	[E-0322 1:3 032200E]
  Actuator3-22 Selected Load	[E-0322 1:4 032200D]
  Actuator3-22 Selected Drive	[E-0322 1:5 032200C]
  Actuator3-22 Maunakea	[E-0322 1:6 032200B]
  Actuator3-22 Sea Level	[E-0322 1:7 032200A]
  Actuator3-22 Up Limit	[E-0322 2:0 0322016]
  Actuator3-22 Driver Alarm	[E-0322 2:1 0322015]
  Actuator3-22 Error Alarm	[E-0322 2:2 0322014]
  Actuator3-22 Over Current	[E-0322 2:3 0322013]
  Actuator3-22 Over Speed	[E-0322 2:4 0322012]
  Actuator3-22 Over Load	[E-0322 2:5 0322011]
  Actuator3-22 PS Alarm	[E-0322 2:6 0322010]
  Actuator3-22 ENC Alarm	[E-0322 2:7 032200F]
  Actuator3-22 CPU Alarm	[E-0322 3:0 032201E]
  Actuator3-22 UART Alarm	[E-0322 3:1 032201D]
  Actuator3-22 HDLC Alarm	[E-0322 3:2 032201C]
  Actuator3-22 Force Card Fault	[E-0322 3:3 032201B]
  Actuator3-22 Force Sensor Fault	[E-0322 3:4 032201A]
  Actuator3-22 Under Range	[E-0322 3:5 0322019]
  Actuator3-22 Over Range	[E-0322 3:6 0322018]
  Actuator3-22 Down Limit	[E-0322 3:7 0322017]
  Actuator3-23 MON PARA	[E-0323 0:0 0323009]
  Actuator3-23 MON HYB	[E-0323 0:1 0323008]
  Actuator3-23 MON Position	[E-0323 0:2 0323007]
  Actuator3-23 MON Force	[E-0323 0:3 0323006]
  Actuator3-23 Drive Off	[E-0323 0:4 0323005]
  Actuator3-23 Drive On	[E-0323 0:5 0323004]
  Actuator3-23 CONT Position	[E-0323 0:6 0323003]
  Actuator3-23 CONT Force	[E-0323 0:7 0323002]
  Actuator3-23 Alarm Reset	[E-0323 1:1 0323020]
  Actuator3-23 Limit Release	[E-0323 1:2 032301F]
  Actuator3-23 Selected Step	[E-0323 1:3 032300E]
  Actuator3-23 Selected Load	[E-0323 1:4 032300D]
  Actuator3-23 Selected Drive	[E-0323 1:5 032300C]
  Actuator3-23 Maunakea	[E-0323 1:6 032300B]
  Actuator3-23 Sea Level	[E-0323 1:7 032300A]
  Actuator3-23 Up Limit	[E-0323 2:0 0323016]
  Actuator3-23 Driver Alarm	[E-0323 2:1 0323015]
  Actuator3-23 Error Alarm	[E-0323 2:2 0323014]
  Actuator3-23 Over Current	[E-0323 2:3 0323013]
  Actuator3-23 Over Speed	[E-0323 2:4 0323012]
  Actuator3-23 Over Load	[E-0323 2:5 0323011]
  Actuator3-23 PS Alarm	[E-0323 2:6 0323010]
  Actuator3-23 ENC Alarm	[E-0323 2:7 032300F]
  Actuator3-23 CPU Alarm	[E-0323 3:0 032301E]
  Actuator3-23 UART Alarm	[E-0323 3:1 032301D]
  Actuator3-23 HDLC Alarm	[E-0323 3:2 032301C]
  Actuator3-23 Force Card Fault	[E-0323 3:3 032301B]
  Actuator3-23 Force Sensor Fault	[E-0323 3:4 032301A]
  Actuator3-23 Under Range	[E-0323 3:5 0323019]
  Actuator3-23 Over Range	[E-0323 3:6 0323018]
  Actuator3-23 Down Limit	[E-0323 3:7 0323017]
  Actuator3-24 MON PARA	[E-0324 0:0 0324009]
  Actuator3-24 MON HYB	[E-0324 0:1 0324008]
  Actuator3-24 MON Position	[E-0324 0:2 0324007]
  Actuator3-24 MON Force	[E-0324 0:3 0324006]
  Actuator3-24 Drive Off	[E-0324 0:4 0324005]
  Actuator3-24 Drive On	[E-0324 0:5 0324004]
  Actuator3-24 CONT Position	[E-0324 0:6 0324003]
  Actuator3-24 CONT Force	[E-0324 0:7 0324002]
  Actuator3-24 Alarm Reset	[E-0324 1:1 0324020]
  Actuator3-24 Limit Release	[E-0324 1:2 032401F]
  Actuator3-24 Selected Step	[E-0324 1:3 032400E]
  Actuator3-24 Selected Load	[E-0324 1:4 032400D]
  Actuator3-24 Selected Drive	[E-0324 1:5 032400C]
  Actuator3-24 Maunakea	[E-0324 1:6 032400B]
  Actuator3-24 Sea Level	[E-0324 1:7 032400A]
  Actuator3-24 Up Limit	[E-0324 2:0 0324016]
  Actuator3-24 Driver Alarm	[E-0324 2:1 0324015]
  Actuator3-24 Error Alarm	[E-0324 2:2 0324014]
  Actuator3-24 Over Current	[E-0324 2:3 0324013]
  Actuator3-24 Over Speed	[E-0324 2:4 0324012]
  Actuator3-24 Over Load	[E-0324 2:5 0324011]
  Actuator3-24 PS Alarm	[E-0324 2:6 0324010]
  Actuator3-24 ENC Alarm	[E-0324 2:7 032400F]
  Actuator3-24 CPU Alarm	[E-0324 3:0 032401E]
  Actuator3-24 UART Alarm	[E-0324 3:1 032401D]
  Actuator3-24 HDLC Alarm	[E-0324 3:2 032401C]
  Actuator3-24 Force Card Fault	[E-0324 3:3 032401B]
  Actuator3-24 Force Sensor Fault	[E-0324 3:4 032401A]
  Actuator3-24 Under Range	[E-0324 3:5 0324019]
  Actuator3-24 Over Range	[E-0324 3:6 0324018]
  Actuator3-24 Down Limit	[E-0324 3:7 0324017]
  Actuator3-25 MON PARA	[E-0325 0:0 0325009]
  Actuator3-25 MON HYB	[E-0325 0:1 0325008]
  Actuator3-25 MON Position	[E-0325 0:2 0325007]
  Actuator3-25 MON Force	[E-0325 0:3 0325006]
  Actuator3-25 Drive Off	[E-0325 0:4 0325005]
  Actuator3-25 Drive On	[E-0325 0:5 0325004]
  Actuator3-25 CONT Position	[E-0325 0:6 0325003]
  Actuator3-25 CONT Force	[E-0325 0:7 0325002]
  Actuator3-25 Alarm Reset	[E-0325 1:1 0325020]
  Actuator3-25 Limit Release	[E-0325 1:2 032501F]
  Actuator3-25 Selected Step	[E-0325 1:3 032500E]
  Actuator3-25 Selected Load	[E-0325 1:4 032500D]
  Actuator3-25 Selected Drive	[E-0325 1:5 032500C]
  Actuator3-25 Maunakea	[E-0325 1:6 032500B]
  Actuator3-25 Sea Level	[E-0325 1:7 032500A]
  Actuator3-25 Up Limit	[E-0325 2:0 0325016]
  Actuator3-25 Driver Alarm	[E-0325 2:1 0325015]
  Actuator3-25 Error Alarm	[E-0325 2:2 0325014]
  Actuator3-25 Over Current	[E-0325 2:3 0325013]
  Actuator3-25 Over Speed	[E-0325 2:4 0325012]
  Actuator3-25 Over Load	[E-0325 2:5 0325011]
  Actuator3-25 PS Alarm	[E-0325 2:6 0325010]
  Actuator3-25 ENC Alarm	[E-0325 2:7 032500F]
  Actuator3-25 CPU Alarm	[E-0325 3:0 032501E]
  Actuator3-25 UART Alarm	[E-0325 3:1 032501D]
  Actuator3-25 HDLC Alarm	[E-0325 3:2 032501C]
  Actuator3-25 Force Card Fault	[E-0325 3:3 032501B]
  Actuator3-25 Force Sensor Fault	[E-0325 3:4 032501A]
  Actuator3-25 Under Range	[E-0325 3:5 0325019]
  Actuator3-25 Over Range	[E-0325 3:6 0325018]
  Actuator3-25 Down Limit	[E-0325 3:7 0325017]
  Actuator3-26 MON PARA	[E-0326 0:0 0326009]
  Actuator3-26 MON HYB	[E-0326 0:1 0326008]
  Actuator3-26 MON Position	[E-0326 0:2 0326007]
  Actuator3-26 MON Force	[E-0326 0:3 0326006]
  Actuator3-26 Drive Off	[E-0326 0:4 0326005]
  Actuator3-26 Drive On	[E-0326 0:5 0326004]
  Actuator3-26 CONT Position	[E-0326 0:6 0326003]
  Actuator3-26 CONT Force	[E-0326 0:7 0326002]
  Actuator3-26 Alarm Reset	[E-0326 1:1 0326020]
  Actuator3-26 Limit Release	[E-0326 1:2 032601F]
  Actuator3-26 Selected Step	[E-0326 1:3 032600E]
  Actuator3-26 Selected Load	[E-0326 1:4 032600D]
  Actuator3-26 Selected Drive	[E-0326 1:5 032600C]
  Actuator3-26 Maunakea	[E-0326 1:6 032600B]
  Actuator3-26 Sea Level	[E-0326 1:7 032600A]
  Actuator3-26 Up Limit	[E-0326 2:0 0326016]
  Actuator3-26 Driver Alarm	[E-0326 2:1 0326015]
  Actuator3-26 Error Alarm	[E-0326 2:2 0326014]
  Actuator3-26 Over Current	[E-0326 2:3 0326013]
  Actuator3-26 Over Speed	[E-0326 2:4 0326012]
  Actuator3-26 Over Load	[E-0326 2:5 0326011]
  Actuator3-26 PS Alarm	[E-0326 2:6 0326010]
  Actuator3-26 ENC Alarm	[E-0326 2:7 032600F]
  Actuator3-26 CPU Alarm	[E-0326 3:0 032601E]
  Actuator3-26 UART Alarm	[E-0326 3:1 032601D]
  Actuator3-26 HDLC Alarm	[E-0326 3:2 032601C]
  Actuator3-26 Force Card Fault	[E-0326 3:3 032601B]
  Actuator3-26 Force Sensor Fault	[E-0326 3:4 032601A]
  Actuator3-26 Under Range	[E-0326 3:5 0326019]
  Actuator3-26 Over Range	[E-0326 3:6 0326018]
  Actuator3-26 Down Limit	[E-0326 3:7 0326017]
  Actuator3-27 MON PARA	[E-0327 0:0 0327009]
  Actuator3-27 MON HYB	[E-0327 0:1 0327008]
  Actuator3-27 MON Position	[E-0327 0:2 0327007]
  Actuator3-27 MON Force	[E-0327 0:3 0327006]
  Actuator3-27 Drive Off	[E-0327 0:4 0327005]
  Actuator3-27 Drive On	[E-0327 0:5 0327004]
  Actuator3-27 CONT Position	[E-0327 0:6 0327003]
  Actuator3-27 CONT Force	[E-0327 0:7 0327002]
  Actuator3-27 Alarm Reset	[E-0327 1:1 0327020]
  Actuator3-27 Limit Release	[E-0327 1:2 032701F]
  Actuator3-27 Selected Step	[E-0327 1:3 032700E]
  Actuator3-27 Selected Load	[E-0327 1:4 032700D]
  Actuator3-27 Selected Drive	[E-0327 1:5 032700C]
  Actuator3-27 Maunakea	[E-0327 1:6 032700B]
  Actuator3-27 Sea Level	[E-0327 1:7 032700A]
  Actuator3-27 Up Limit	[E-0327 2:0 0327016]
  Actuator3-27 Driver Alarm	[E-0327 2:1 0327015]
  Actuator3-27 Error Alarm	[E-0327 2:2 0327014]
  Actuator3-27 Over Current	[E-0327 2:3 0327013]
  Actuator3-27 Over Speed	[E-0327 2:4 0327012]
  Actuator3-27 Over Load	[E-0327 2:5 0327011]
  Actuator3-27 PS Alarm	[E-0327 2:6 0327010]
  Actuator3-27 ENC Alarm	[E-0327 2:7 032700F]
  Actuator3-27 CPU Alarm	[E-0327 3:0 032701E]
  Actuator3-27 UART Alarm	[E-0327 3:1 032701D]
  Actuator3-27 HDLC Alarm	[E-0327 3:2 032701C]
  Actuator3-27 Force Card Fault	[E-0327 3:3 032701B]
  Actuator3-27 Force Sensor Fault	[E-0327 3:4 032701A]
  Actuator3-27 Under Range	[E-0327 3:5 0327019]
  Actuator3-27 Over Range	[E-0327 3:6 0327018]
  Actuator3-27 Down Limit	[E-0327 3:7 0327017]
  Actuator3-28 MON PARA	[E-0328 0:0 0328009]
  Actuator3-28 MON HYB	[E-0328 0:1 0328008]
  Actuator3-28 MON Position	[E-0328 0:2 0328007]
  Actuator3-28 MON Force	[E-0328 0:3 0328006]
  Actuator3-28 Drive Off	[E-0328 0:4 0328005]
  Actuator3-28 Drive On	[E-0328 0:5 0328004]
  Actuator3-28 CONT Position	[E-0328 0:6 0328003]
  Actuator3-28 CONT Force	[E-0328 0:7 0328002]
  Actuator3-28 Alarm Reset	[E-0328 1:1 0328020]
  Actuator3-28 Limit Release	[E-0328 1:2 032801F]
  Actuator3-28 Selected Step	[E-0328 1:3 032800E]
  Actuator3-28 Selected Load	[E-0328 1:4 032800D]
  Actuator3-28 Selected Drive	[E-0328 1:5 032800C]
  Actuator3-28 Maunakea	[E-0328 1:6 032800B]
  Actuator3-28 Sea Level	[E-0328 1:7 032800A]
  Actuator3-28 Up Limit	[E-0328 2:0 0328016]
  Actuator3-28 Driver Alarm	[E-0328 2:1 0328015]
  Actuator3-28 Error Alarm	[E-0328 2:2 0328014]
  Actuator3-28 Over Current	[E-0328 2:3 0328013]
  Actuator3-28 Over Speed	[E-0328 2:4 0328012]
  Actuator3-28 Over Load	[E-0328 2:5 0328011]
  Actuator3-28 PS Alarm	[E-0328 2:6 0328010]
  Actuator3-28 ENC Alarm	[E-0328 2:7 032800F]
  Actuator3-28 CPU Alarm	[E-0328 3:0 032801E]
  Actuator3-28 UART Alarm	[E-0328 3:1 032801D]
  Actuator3-28 HDLC Alarm	[E-0328 3:2 032801C]
  Actuator3-28 Force Card Fault	[E-0328 3:3 032801B]
  Actuator3-28 Force Sensor Fault	[E-0328 3:4 032801A]
  Actuator3-28 Under Range	[E-0328 3:5 0328019]
  Actuator3-28 Over Range	[E-0328 3:6 0328018]
  Actuator3-28 Down Limit	[E-0328 3:7 0328017]
  Actuator3-29 MON PARA	[E-0329 0:0 0329009]
  Actuator3-29 MON HYB	[E-0329 0:1 0329008]
  Actuator3-29 MON Position	[E-0329 0:2 0329007]
  Actuator3-29 MON Force	[E-0329 0:3 0329006]
  Actuator3-29 Drive Off	[E-0329 0:4 0329005]
  Actuator3-29 Drive On	[E-0329 0:5 0329004]
  Actuator3-29 CONT Position	[E-0329 0:6 0329003]
  Actuator3-29 CONT Force	[E-0329 0:7 0329002]
  Actuator3-29 Alarm Reset	[E-0329 1:1 0329020]
  Actuator3-29 Limit Release	[E-0329 1:2 032901F]
  Actuator3-29 Selected Step	[E-0329 1:3 032900E]
  Actuator3-29 Selected Load	[E-0329 1:4 032900D]
  Actuator3-29 Selected Drive	[E-0329 1:5 032900C]
  Actuator3-29 Maunakea	[E-0329 1:6 032900B]
  Actuator3-29 Sea Level	[E-0329 1:7 032900A]
  Actuator3-29 Up Limit	[E-0329 2:0 0329016]
  Actuator3-29 Driver Alarm	[E-0329 2:1 0329015]
  Actuator3-29 Error Alarm	[E-0329 2:2 0329014]
  Actuator3-29 Over Current	[E-0329 2:3 0329013]
  Actuator3-29 Over Speed	[E-0329 2:4 0329012]
  Actuator3-29 Over Load	[E-0329 2:5 0329011]
  Actuator3-29 PS Alarm	[E-0329 2:6 0329010]
  Actuator3-29 ENC Alarm	[E-0329 2:7 032900F]
  Actuator3-29 CPU Alarm	[E-0329 3:0 032901E]
  Actuator3-29 UART Alarm	[E-0329 3:1 032901D]
  Actuator3-29 HDLC Alarm	[E-0329 3:2 032901C]
  Actuator3-29 Force Card Fault	[E-0329 3:3 032901B]
  Actuator3-29 Force Sensor Fault	[E-0329 3:4 032901A]
  Actuator3-29 Under Range	[E-0329 3:5 0329019]
  Actuator3-29 Over Range	[E-0329 3:6 0329018]
  Actuator3-29 Down Limit	[E-0329 3:7 0329017]
  Actuator3-30 MON PARA	[E-0330 0:0 0330009]
  Actuator3-30 MON HYB	[E-0330 0:1 0330008]
  Actuator3-30 MON Position	[E-0330 0:2 0330007]
  Actuator3-30 MON Force	[E-0330 0:3 0330006]
  Actuator3-30 Drive Off	[E-0330 0:4 0330005]
  Actuator3-30 Drive On	[E-0330 0:5 0330004]
  Actuator3-30 CONT Position	[E-0330 0:6 0330003]
  Actuator3-30 CONT Force	[E-0330 0:7 0330002]
  Actuator3-30 Alarm Reset	[E-0330 1:1 0330020]
  Actuator3-30 Limit Release	[E-0330 1:2 033001F]
  Actuator3-30 Selected Step	[E-0330 1:3 033000E]
  Actuator3-30 Selected Load	[E-0330 1:4 033000D]
  Actuator3-30 Selected Drive	[E-0330 1:5 033000C]
  Actuator3-30 Maunakea	[E-0330 1:6 033000B]
  Actuator3-30 Sea Level	[E-0330 1:7 033000A]
  Actuator3-30 Up Limit	[E-0330 2:0 0330016]
  Actuator3-30 Driver Alarm	[E-0330 2:1 0330015]
  Actuator3-30 Error Alarm	[E-0330 2:2 0330014]
  Actuator3-30 Over Current	[E-0330 2:3 0330013]
  Actuator3-30 Over Speed	[E-0330 2:4 0330012]
  Actuator3-30 Over Load	[E-0330 2:5 0330011]
  Actuator3-30 PS Alarm	[E-0330 2:6 0330010]
  Actuator3-30 ENC Alarm	[E-0330 2:7 033000F]
  Actuator3-30 CPU Alarm	[E-0330 3:0 033001E]
  Actuator3-30 UART Alarm	[E-0330 3:1 033001D]
  Actuator3-30 HDLC Alarm	[E-0330 3:2 033001C]
  Actuator3-30 Force Card Fault	[E-0330 3:3 033001B]
  Actuator3-30 Force Sensor Fault	[E-0330 3:4 033001A]
  Actuator3-30 Under Range	[E-0330 3:5 0330019]
  Actuator3-30 Over Range	[E-0330 3:6 0330018]
  Actuator3-30 Down Limit	[E-0330 3:7 0330017]
  Actuator3-31 MON PARA	[E-0331 0:0 0331009]
  Actuator3-31 MON HYB	[E-0331 0:1 0331008]
  Actuator3-31 MON Position	[E-0331 0:2 0331007]
  Actuator3-31 MON Force	[E-0331 0:3 0331006]
  Actuator3-31 Drive Off	[E-0331 0:4 0331005]
  Actuator3-31 Drive On	[E-0331 0:5 0331004]
  Actuator3-31 CONT Position	[E-0331 0:6 0331003]
  Actuator3-31 CONT Force	[E-0331 0:7 0331002]
  Actuator3-31 Alarm Reset	[E-0331 1:1 0331020]
  Actuator3-31 Limit Release	[E-0331 1:2 033101F]
  Actuator3-31 Selected Step	[E-0331 1:3 033100E]
  Actuator3-31 Selected Load	[E-0331 1:4 033100D]
  Actuator3-31 Selected Drive	[E-0331 1:5 033100C]
  Actuator3-31 Maunakea	[E-0331 1:6 033100B]
  Actuator3-31 Sea Level	[E-0331 1:7 033100A]
  Actuator3-31 Up Limit	[E-0331 2:0 0331016]
  Actuator3-31 Driver Alarm	[E-0331 2:1 0331015]
  Actuator3-31 Error Alarm	[E-0331 2:2 0331014]
  Actuator3-31 Over Current	[E-0331 2:3 0331013]
  Actuator3-31 Over Speed	[E-0331 2:4 0331012]
  Actuator3-31 Over Load	[E-0331 2:5 0331011]
  Actuator3-31 PS Alarm	[E-0331 2:6 0331010]
  Actuator3-31 ENC Alarm	[E-0331 2:7 033100F]
  Actuator3-31 CPU Alarm	[E-0331 3:0 033101E]
  Actuator3-31 UART Alarm	[E-0331 3:1 033101D]
  Actuator3-31 HDLC Alarm	[E-0331 3:2 033101C]
  Actuator3-31 Force Card Fault	[E-0331 3:3 033101B]
  Actuator3-31 Force Sensor Fault	[E-0331 3:4 033101A]
  Actuator3-31 Under Range	[E-0331 3:5 0331019]
  Actuator3-31 Over Range	[E-0331 3:6 0331018]
  Actuator3-31 Down Limit	[E-0331 3:7 0331017]
  Actuator3-32 MON PARA	[E-0332 0:0 0332009]
  Actuator3-32 MON HYB	[E-0332 0:1 0332008]
  Actuator3-32 MON Position	[E-0332 0:2 0332007]
  Actuator3-32 MON Force	[E-0332 0:3 0332006]
  Actuator3-32 Drive Off	[E-0332 0:4 0332005]
  Actuator3-32 Drive On	[E-0332 0:5 0332004]
  Actuator3-32 CONT Position	[E-0332 0:6 0332003]
  Actuator3-32 CONT Force	[E-0332 0:7 0332002]
  Actuator3-32 Alarm Reset	[E-0332 1:1 0332020]
  Actuator3-32 Limit Release	[E-0332 1:2 033201F]
  Actuator3-32 Selected Step	[E-0332 1:3 033200E]
  Actuator3-32 Selected Load	[E-0332 1:4 033200D]
  Actuator3-32 Selected Drive	[E-0332 1:5 033200C]
  Actuator3-32 Maunakea	[E-0332 1:6 033200B]
  Actuator3-32 Sea Level	[E-0332 1:7 033200A]
  Actuator3-32 Up Limit	[E-0332 2:0 0332016]
  Actuator3-32 Driver Alarm	[E-0332 2:1 0332015]
  Actuator3-32 Error Alarm	[E-0332 2:2 0332014]
  Actuator3-32 Over Current	[E-0332 2:3 0332013]
  Actuator3-32 Over Speed	[E-0332 2:4 0332012]
  Actuator3-32 Over Load	[E-0332 2:5 0332011]
  Actuator3-32 PS Alarm	[E-0332 2:6 0332010]
  Actuator3-32 ENC Alarm	[E-0332 2:7 033200F]
  Actuator3-32 CPU Alarm	[E-0332 3:0 033201E]
  Actuator3-32 UART Alarm	[E-0332 3:1 033201D]
  Actuator3-32 HDLC Alarm	[E-0332 3:2 033201C]
  Actuator3-32 Force Card Fault	[E-0332 3:3 033201B]
  Actuator3-32 Force Sensor Fault	[E-0332 3:4 033201A]
  Actuator3-32 Under Range	[E-0332 3:5 0332019]
  Actuator3-32 Over Range	[E-0332 3:6 0332018]
  Actuator3-32 Down Limit	[E-0332 3:7 0332017]
  Actuator3-33 MON PARA	[E-0333 0:0 0333009]
  Actuator3-33 MON HYB	[E-0333 0:1 0333008]
  Actuator3-33 MON Position	[E-0333 0:2 0333007]
  Actuator3-33 MON Force	[E-0333 0:3 0333006]
  Actuator3-33 Drive Off	[E-0333 0:4 0333005]
  Actuator3-33 Drive On	[E-0333 0:5 0333004]
  Actuator3-33 CONT Position	[E-0333 0:6 0333003]
  Actuator3-33 CONT Force	[E-0333 0:7 0333002]
  Actuator3-33 Alarm Reset	[E-0333 1:1 0333020]
  Actuator3-33 Limit Release	[E-0333 1:2 033301F]
  Actuator3-33 Selected Step	[E-0333 1:3 033300E]
  Actuator3-33 Selected Load	[E-0333 1:4 033300D]
  Actuator3-33 Selected Drive	[E-0333 1:5 033300C]
  Actuator3-33 Maunakea	[E-0333 1:6 033300B]
  Actuator3-33 Sea Level	[E-0333 1:7 033300A]
  Actuator3-33 Up Limit	[E-0333 2:0 0333016]
  Actuator3-33 Driver Alarm	[E-0333 2:1 0333015]
  Actuator3-33 Error Alarm	[E-0333 2:2 0333014]
  Actuator3-33 Over Current	[E-0333 2:3 0333013]
  Actuator3-33 Over Speed	[E-0333 2:4 0333012]
  Actuator3-33 Over Load	[E-0333 2:5 0333011]
  Actuator3-33 PS Alarm	[E-0333 2:6 0333010]
  Actuator3-33 ENC Alarm	[E-0333 2:7 033300F]
  Actuator3-33 CPU Alarm	[E-0333 3:0 033301E]
  Actuator3-33 UART Alarm	[E-0333 3:1 033301D]
  Actuator3-33 HDLC Alarm	[E-0333 3:2 033301C]
  Actuator3-33 Force Card Fault	[E-0333 3:3 033301B]
  Actuator3-33 Force Sensor Fault	[E-0333 3:4 033301A]
  Actuator3-33 Under Range	[E-0333 3:5 0333019]
  Actuator3-33 Over Range	[E-0333 3:6 0333018]
  Actuator3-33 Down Limit	[E-0333 3:7 0333017]
  Actuator3-34 MON PARA	[E-0334 0:0 0334009]
  Actuator3-34 MON HYB	[E-0334 0:1 0334008]
  Actuator3-34 MON Position	[E-0334 0:2 0334007]
  Actuator3-34 MON Force	[E-0334 0:3 0334006]
  Actuator3-34 Drive Off	[E-0334 0:4 0334005]
  Actuator3-34 Drive On	[E-0334 0:5 0334004]
  Actuator3-34 CONT Position	[E-0334 0:6 0334003]
  Actuator3-34 CONT Force	[E-0334 0:7 0334002]
  Actuator3-34 Alarm Reset	[E-0334 1:1 0334020]
  Actuator3-34 Limit Release	[E-0334 1:2 033401F]
  Actuator3-34 Selected Step	[E-0334 1:3 033400E]
  Actuator3-34 Selected Load	[E-0334 1:4 033400D]
  Actuator3-34 Selected Drive	[E-0334 1:5 033400C]
  Actuator3-34 Maunakea	[E-0334 1:6 033400B]
  Actuator3-34 Sea Level	[E-0334 1:7 033400A]
  Actuator3-34 Up Limit	[E-0334 2:0 0334016]
  Actuator3-34 Driver Alarm	[E-0334 2:1 0334015]
  Actuator3-34 Error Alarm	[E-0334 2:2 0334014]
  Actuator3-34 Over Current	[E-0334 2:3 0334013]
  Actuator3-34 Over Speed	[E-0334 2:4 0334012]
  Actuator3-34 Over Load	[E-0334 2:5 0334011]
  Actuator3-34 PS Alarm	[E-0334 2:6 0334010]
  Actuator3-34 ENC Alarm	[E-0334 2:7 033400F]
  Actuator3-34 CPU Alarm	[E-0334 3:0 033401E]
  Actuator3-34 UART Alarm	[E-0334 3:1 033401D]
  Actuator3-34 HDLC Alarm	[E-0334 3:2 033401C]
  Actuator3-34 Force Card Fault	[E-0334 3:3 033401B]
  Actuator3-34 Force Sensor Fault	[E-0334 3:4 033401A]
  Actuator3-34 Under Range	[E-0334 3:5 0334019]
  Actuator3-34 Over Range	[E-0334 3:6 0334018]
  Actuator3-34 Down Limit	[E-0334 3:7 0334017]
  Actuator3-35 MON PARA	[E-0335 0:0 0335009]
  Actuator3-35 MON HYB	[E-0335 0:1 0335008]
  Actuator3-35 MON Position	[E-0335 0:2 0335007]
  Actuator3-35 MON Force	[E-0335 0:3 0335006]
  Actuator3-35 Drive Off	[E-0335 0:4 0335005]
  Actuator3-35 Drive On	[E-0335 0:5 0335004]
  Actuator3-35 CONT Position	[E-0335 0:6 0335003]
  Actuator3-35 CONT Force	[E-0335 0:7 0335002]
  Actuator3-35 Alarm Reset	[E-0335 1:1 0335020]
  Actuator3-35 Limit Release	[E-0335 1:2 033501F]
  Actuator3-35 Selected Step	[E-0335 1:3 033500E]
  Actuator3-35 Selected Load	[E-0335 1:4 033500D]
  Actuator3-35 Selected Drive	[E-0335 1:5 033500C]
  Actuator3-35 Maunakea	[E-0335 1:6 033500B]
  Actuator3-35 Sea Level	[E-0335 1:7 033500A]
  Actuator3-35 Up Limit	[E-0335 2:0 0335016]
  Actuator3-35 Driver Alarm	[E-0335 2:1 0335015]
  Actuator3-35 Error Alarm	[E-0335 2:2 0335014]
  Actuator3-35 Over Current	[E-0335 2:3 0335013]
  Actuator3-35 Over Speed	[E-0335 2:4 0335012]
  Actuator3-35 Over Load	[E-0335 2:5 0335011]
  Actuator3-35 PS Alarm	[E-0335 2:6 0335010]
  Actuator3-35 ENC Alarm	[E-0335 2:7 033500F]
  Actuator3-35 CPU Alarm	[E-0335 3:0 033501E]
  Actuator3-35 UART Alarm	[E-0335 3:1 033501D]
  Actuator3-35 HDLC Alarm	[E-0335 3:2 033501C]
  Actuator3-35 Force Card Fault	[E-0335 3:3 033501B]
  Actuator3-35 Force Sensor Fault	[E-0335 3:4 033501A]
  Actuator3-35 Under Range	[E-0335 3:5 0335019]
  Actuator3-35 Over Range	[E-0335 3:6 0335018]
  Actuator3-35 Down Limit	[E-0335 3:7 0335017]
  Actuator3-36 MON PARA	[E-0336 0:0 0336009]
  Actuator3-36 MON HYB	[E-0336 0:1 0336008]
  Actuator3-36 MON Position	[E-0336 0:2 0336007]
  Actuator3-36 MON Force	[E-0336 0:3 0336006]
  Actuator3-36 Drive Off	[E-0336 0:4 0336005]
  Actuator3-36 Drive On	[E-0336 0:5 0336004]
  Actuator3-36 CONT Position	[E-0336 0:6 0336003]
  Actuator3-36 CONT Force	[E-0336 0:7 0336002]
  Actuator3-36 Alarm Reset	[E-0336 1:1 0336020]
  Actuator3-36 Limit Release	[E-0336 1:2 033601F]
  Actuator3-36 Selected Step	[E-0336 1:3 033600E]
  Actuator3-36 Selected Load	[E-0336 1:4 033600D]
  Actuator3-36 Selected Drive	[E-0336 1:5 033600C]
  Actuator3-36 Maunakea	[E-0336 1:6 033600B]
  Actuator3-36 Sea Level	[E-0336 1:7 033600A]
  Actuator3-36 Up Limit	[E-0336 2:0 0336016]
  Actuator3-36 Driver Alarm	[E-0336 2:1 0336015]
  Actuator3-36 Error Alarm	[E-0336 2:2 0336014]
  Actuator3-36 Over Current	[E-0336 2:3 0336013]
  Actuator3-36 Over Speed	[E-0336 2:4 0336012]
  Actuator3-36 Over Load	[E-0336 2:5 0336011]
  Actuator3-36 PS Alarm	[E-0336 2:6 0336010]
  Actuator3-36 ENC Alarm	[E-0336 2:7 033600F]
  Actuator3-36 CPU Alarm	[E-0336 3:0 033601E]
  Actuator3-36 UART Alarm	[E-0336 3:1 033601D]
  Actuator3-36 HDLC Alarm	[E-0336 3:2 033601C]
  Actuator3-36 Force Card Fault	[E-0336 3:3 033601B]
  Actuator3-36 Force Sensor Fault	[E-0336 3:4 033601A]
  Actuator3-36 Under Range	[E-0336 3:5 0336019]
  Actuator3-36 Over Range	[E-0336 3:6 0336018]
  Actuator3-36 Down Limit	[E-0336 3:7 0336017]
  Actuator3-37 MON PARA	[E-0337 0:0 0337009]
  Actuator3-37 MON HYB	[E-0337 0:1 0337008]
  Actuator3-37 MON Position	[E-0337 0:2 0337007]
  Actuator3-37 MON Force	[E-0337 0:3 0337006]
  Actuator3-37 Drive Off	[E-0337 0:4 0337005]
  Actuator3-37 Drive On	[E-0337 0:5 0337004]
  Actuator3-37 CONT Position	[E-0337 0:6 0337003]
  Actuator3-37 CONT Force	[E-0337 0:7 0337002]
  Actuator3-37 Alarm Reset	[E-0337 1:1 0337020]
  Actuator3-37 Limit Release	[E-0337 1:2 033701F]
  Actuator3-37 Selected Step	[E-0337 1:3 033700E]
  Actuator3-37 Selected Load	[E-0337 1:4 033700D]
  Actuator3-37 Selected Drive	[E-0337 1:5 033700C]
  Actuator3-37 Maunakea	[E-0337 1:6 033700B]
  Actuator3-37 Sea Level	[E-0337 1:7 033700A]
  Actuator3-37 Up Limit	[E-0337 2:0 0337016]
  Actuator3-37 Driver Alarm	[E-0337 2:1 0337015]
  Actuator3-37 Error Alarm	[E-0337 2:2 0337014]
  Actuator3-37 Over Current	[E-0337 2:3 0337013]
  Actuator3-37 Over Speed	[E-0337 2:4 0337012]
  Actuator3-37 Over Load	[E-0337 2:5 0337011]
  Actuator3-37 PS Alarm	[E-0337 2:6 0337010]
  Actuator3-37 ENC Alarm	[E-0337 2:7 033700F]
  Actuator3-37 CPU Alarm	[E-0337 3:0 033701E]
  Actuator3-37 UART Alarm	[E-0337 3:1 033701D]
  Actuator3-37 HDLC Alarm	[E-0337 3:2 033701C]
  Actuator3-37 Force Card Fault	[E-0337 3:3 033701B]
  Actuator3-37 Force Sensor Fault	[E-0337 3:4 033701A]
  Actuator3-37 Under Range	[E-0337 3:5 0337019]
  Actuator3-37 Over Range	[E-0337 3:6 0337018]
  Actuator3-37 Down Limit	[E-0337 3:7 0337017]
  Actuator3-38 MON PARA	[E-0338 0:0 0338009]
  Actuator3-38 MON HYB	[E-0338 0:1 0338008]
  Actuator3-38 MON Position	[E-0338 0:2 0338007]
  Actuator3-38 MON Force	[E-0338 0:3 0338006]
  Actuator3-38 Drive Off	[E-0338 0:4 0338005]
  Actuator3-38 Drive On	[E-0338 0:5 0338004]
  Actuator3-38 CONT Position	[E-0338 0:6 0338003]
  Actuator3-38 CONT Force	[E-0338 0:7 0338002]
  Actuator3-38 Alarm Reset	[E-0338 1:1 0338020]
  Actuator3-38 Limit Release	[E-0338 1:2 033801F]
  Actuator3-38 Selected Step	[E-0338 1:3 033800E]
  Actuator3-38 Selected Load	[E-0338 1:4 033800D]
  Actuator3-38 Selected Drive	[E-0338 1:5 033800C]
  Actuator3-38 Maunakea	[E-0338 1:6 033800B]
  Actuator3-38 Sea Level	[E-0338 1:7 033800A]
  Actuator3-38 Up Limit	[E-0338 2:0 0338016]
  Actuator3-38 Driver Alarm	[E-0338 2:1 0338015]
  Actuator3-38 Error Alarm	[E-0338 2:2 0338014]
  Actuator3-38 Over Current	[E-0338 2:3 0338013]
  Actuator3-38 Over Speed	[E-0338 2:4 0338012]
  Actuator3-38 Over Load	[E-0338 2:5 0338011]
  Actuator3-38 PS Alarm	[E-0338 2:6 0338010]
  Actuator3-38 ENC Alarm	[E-0338 2:7 033800F]
  Actuator3-38 CPU Alarm	[E-0338 3:0 033801E]
  Actuator3-38 UART Alarm	[E-0338 3:1 033801D]
  Actuator3-38 HDLC Alarm	[E-0338 3:2 033801C]
  Actuator3-38 Force Card Fault	[E-0338 3:3 033801B]
  Actuator3-38 Force Sensor Fault	[E-0338 3:4 033801A]
  Actuator3-38 Under Range	[E-0338 3:5 0338019]
  Actuator3-38 Over Range	[E-0338 3:6 0338018]
  Actuator3-38 Down Limit	[E-0338 3:7 0338017]
  Actuator3-39 MON PARA	[E-0339 0:0 0339009]
  Actuator3-39 MON HYB	[E-0339 0:1 0339008]
  Actuator3-39 MON Position	[E-0339 0:2 0339007]
  Actuator3-39 MON Force	[E-0339 0:3 0339006]
  Actuator3-39 Drive Off	[E-0339 0:4 0339005]
  Actuator3-39 Drive On	[E-0339 0:5 0339004]
  Actuator3-39 CONT Position	[E-0339 0:6 0339003]
  Actuator3-39 CONT Force	[E-0339 0:7 0339002]
  Actuator3-39 Alarm Reset	[E-0339 1:1 0339020]
  Actuator3-39 Limit Release	[E-0339 1:2 033901F]
  Actuator3-39 Selected Step	[E-0339 1:3 033900E]
  Actuator3-39 Selected Load	[E-0339 1:4 033900D]
  Actuator3-39 Selected Drive	[E-0339 1:5 033900C]
  Actuator3-39 Maunakea	[E-0339 1:6 033900B]
  Actuator3-39 Sea Level	[E-0339 1:7 033900A]
  Actuator3-39 Up Limit	[E-0339 2:0 0339016]
  Actuator3-39 Driver Alarm	[E-0339 2:1 0339015]
  Actuator3-39 Error Alarm	[E-0339 2:2 0339014]
  Actuator3-39 Over Current	[E-0339 2:3 0339013]
  Actuator3-39 Over Speed	[E-0339 2:4 0339012]
  Actuator3-39 Over Load	[E-0339 2:5 0339011]
  Actuator3-39 PS Alarm	[E-0339 2:6 0339010]
  Actuator3-39 ENC Alarm	[E-0339 2:7 033900F]
  Actuator3-39 CPU Alarm	[E-0339 3:0 033901E]
  Actuator3-39 UART Alarm	[E-0339 3:1 033901D]
  Actuator3-39 HDLC Alarm	[E-0339 3:2 033901C]
  Actuator3-39 Force Card Fault	[E-0339 3:3 033901B]
  Actuator3-39 Force Sensor Fault	[E-0339 3:4 033901A]
  Actuator3-39 Under Range	[E-0339 3:5 0339019]
  Actuator3-39 Over Range	[E-0339 3:6 0339018]
  Actuator3-39 Down Limit	[E-0339 3:7 0339017]
  Actuator3-40 MON PARA	[E-0340 0:0 0340009]
  Actuator3-40 MON HYB	[E-0340 0:1 0340008]
  Actuator3-40 MON Position	[E-0340 0:2 0340007]
  Actuator3-40 MON Force	[E-0340 0:3 0340006]
  Actuator3-40 Drive Off	[E-0340 0:4 0340005]
  Actuator3-40 Drive On	[E-0340 0:5 0340004]
  Actuator3-40 CONT Position	[E-0340 0:6 0340003]
  Actuator3-40 CONT Force	[E-0340 0:7 0340002]
  Actuator3-40 Alarm Reset	[E-0340 1:1 0340020]
  Actuator3-40 Limit Release	[E-0340 1:2 034001F]
  Actuator3-40 Selected Step	[E-0340 1:3 034000E]
  Actuator3-40 Selected Load	[E-0340 1:4 034000D]
  Actuator3-40 Selected Drive	[E-0340 1:5 034000C]
  Actuator3-40 Maunakea	[E-0340 1:6 034000B]
  Actuator3-40 Sea Level	[E-0340 1:7 034000A]
  Actuator3-40 Up Limit	[E-0340 2:0 0340016]
  Actuator3-40 Driver Alarm	[E-0340 2:1 0340015]
  Actuator3-40 Error Alarm	[E-0340 2:2 0340014]
  Actuator3-40 Over Current	[E-0340 2:3 0340013]
  Actuator3-40 Over Speed	[E-0340 2:4 0340012]
  Actuator3-40 Over Load	[E-0340 2:5 0340011]
  Actuator3-40 PS Alarm	[E-0340 2:6 0340010]
  Actuator3-40 ENC Alarm	[E-0340 2:7 034000F]
  Actuator3-40 CPU Alarm	[E-0340 3:0 034001E]
  Actuator3-40 UART Alarm	[E-0340 3:1 034001D]
  Actuator3-40 HDLC Alarm	[E-0340 3:2 034001C]
  Actuator3-40 Force Card Fault	[E-0340 3:3 034001B]
  Actuator3-40 Force Sensor Fault	[E-0340 3:4 034001A]
  Actuator3-40 Under Range	[E-0340 3:5 0340019]
  Actuator3-40 Over Range	[E-0340 3:6 0340018]
  Actuator3-40 Down Limit	[E-0340 3:7 0340017]
  Actuator3-41 MON PARA	[E-0341 0:0 0341009]
  Actuator3-41 MON HYB	[E-0341 0:1 0341008]
  Actuator3-41 MON Position	[E-0341 0:2 0341007]
  Actuator3-41 MON Force	[E-0341 0:3 0341006]
  Actuator3-41 Drive Off	[E-0341 0:4 0341005]
  Actuator3-41 Drive On	[E-0341 0:5 0341004]
  Actuator3-41 CONT Position	[E-0341 0:6 0341003]
  Actuator3-41 CONT Force	[E-0341 0:7 0341002]
  Actuator3-41 Alarm Reset	[E-0341 1:1 0341020]
  Actuator3-41 Limit Release	[E-0341 1:2 034101F]
  Actuator3-41 Selected Step	[E-0341 1:3 034100E]
  Actuator3-41 Selected Load	[E-0341 1:4 034100D]
  Actuator3-41 Selected Drive	[E-0341 1:5 034100C]
  Actuator3-41 Maunakea	[E-0341 1:6 034100B]
  Actuator3-41 Sea Level	[E-0341 1:7 034100A]
  Actuator3-41 Up Limit	[E-0341 2:0 0341016]
  Actuator3-41 Driver Alarm	[E-0341 2:1 0341015]
  Actuator3-41 Error Alarm	[E-0341 2:2 0341014]
  Actuator3-41 Over Current	[E-0341 2:3 0341013]
  Actuator3-41 Over Speed	[E-0341 2:4 0341012]
  Actuator3-41 Over Load	[E-0341 2:5 0341011]
  Actuator3-41 PS Alarm	[E-0341 2:6 0341010]
  Actuator3-41 ENC Alarm	[E-0341 2:7 034100F]
  Actuator3-41 CPU Alarm	[E-0341 3:0 034101E]
  Actuator3-41 UART Alarm	[E-0341 3:1 034101D]
  Actuator3-41 HDLC Alarm	[E-0341 3:2 034101C]
  Actuator3-41 Force Card Fault	[E-0341 3:3 034101B]
  Actuator3-41 Force Sensor Fault	[E-0341 3:4 034101A]
  Actuator3-41 Under Range	[E-0341 3:5 0341019]
  Actuator3-41 Over Range	[E-0341 3:6 0341018]
  Actuator3-41 Down Limit	[E-0341 3:7 0341017]
  Actuator3-42 MON PARA	[E-0342 0:0 0342009]
  Actuator3-42 MON HYB	[E-0342 0:1 0342008]
  Actuator3-42 MON Position	[E-0342 0:2 0342007]
  Actuator3-42 MON Force	[E-0342 0:3 0342006]
  Actuator3-42 Drive Off	[E-0342 0:4 0342005]
  Actuator3-42 Drive On	[E-0342 0:5 0342004]
  Actuator3-42 CONT Position	[E-0342 0:6 0342003]
  Actuator3-42 CONT Force	[E-0342 0:7 0342002]
  Actuator3-42 Alarm Reset	[E-0342 1:1 0342020]
  Actuator3-42 Limit Release	[E-0342 1:2 034201F]
  Actuator3-42 Selected Step	[E-0342 1:3 034200E]
  Actuator3-42 Selected Load	[E-0342 1:4 034200D]
  Actuator3-42 Selected Drive	[E-0342 1:5 034200C]
  Actuator3-42 Maunakea	[E-0342 1:6 034200B]
  Actuator3-42 Sea Level	[E-0342 1:7 034200A]
  Actuator3-42 Up Limit	[E-0342 2:0 0342016]
  Actuator3-42 Driver Alarm	[E-0342 2:1 0342015]
  Actuator3-42 Error Alarm	[E-0342 2:2 0342014]
  Actuator3-42 Over Current	[E-0342 2:3 0342013]
  Actuator3-42 Over Speed	[E-0342 2:4 0342012]
  Actuator3-42 Over Load	[E-0342 2:5 0342011]
  Actuator3-42 PS Alarm	[E-0342 2:6 0342010]
  Actuator3-42 ENC Alarm	[E-0342 2:7 034200F]
  Actuator3-42 CPU Alarm	[E-0342 3:0 034201E]
  Actuator3-42 UART Alarm	[E-0342 3:1 034201D]
  Actuator3-42 HDLC Alarm	[E-0342 3:2 034201C]
  Actuator3-42 Force Card Fault	[E-0342 3:3 034201B]
  Actuator3-42 Force Sensor Fault	[E-0342 3:4 034201A]
  Actuator3-42 Under Range	[E-0342 3:5 0342019]
  Actuator3-42 Over Range	[E-0342 3:6 0342018]
  Actuator3-42 Down Limit	[E-0342 3:7 0342017]
  Actuator3-43 MON PARA	[E-0343 0:0 0343009]
  Actuator3-43 MON HYB	[E-0343 0:1 0343008]
  Actuator3-43 MON Position	[E-0343 0:2 0343007]
  Actuator3-43 MON Force	[E-0343 0:3 0343006]
  Actuator3-43 Drive Off	[E-0343 0:4 0343005]
  Actuator3-43 Drive On	[E-0343 0:5 0343004]
  Actuator3-43 CONT Position	[E-0343 0:6 0343003]
  Actuator3-43 CONT Force	[E-0343 0:7 0343002]
  Actuator3-43 Alarm Reset	[E-0343 1:1 0343020]
  Actuator3-43 Limit Release	[E-0343 1:2 034301F]
  Actuator3-43 Selected Step	[E-0343 1:3 034300E]
  Actuator3-43 Selected Load	[E-0343 1:4 034300D]
  Actuator3-43 Selected Drive	[E-0343 1:5 034300C]
  Actuator3-43 Maunakea	[E-0343 1:6 034300B]
  Actuator3-43 Sea Level	[E-0343 1:7 034300A]
  Actuator3-43 Up Limit	[E-0343 2:0 0343016]
  Actuator3-43 Driver Alarm	[E-0343 2:1 0343015]
  Actuator3-43 Error Alarm	[E-0343 2:2 0343014]
  Actuator3-43 Over Current	[E-0343 2:3 0343013]
  Actuator3-43 Over Speed	[E-0343 2:4 0343012]
  Actuator3-43 Over Load	[E-0343 2:5 0343011]
  Actuator3-43 PS Alarm	[E-0343 2:6 0343010]
  Actuator3-43 ENC Alarm	[E-0343 2:7 034300F]
  Actuator3-43 CPU Alarm	[E-0343 3:0 034301E]
  Actuator3-43 UART Alarm	[E-0343 3:1 034301D]
  Actuator3-43 HDLC Alarm	[E-0343 3:2 034301C]
  Actuator3-43 Force Card Fault	[E-0343 3:3 034301B]
  Actuator3-43 Force Sensor Fault	[E-0343 3:4 034301A]
  Actuator3-43 Under Range	[E-0343 3:5 0343019]
  Actuator3-43 Over Range	[E-0343 3:6 0343018]
  Actuator3-43 Down Limit	[E-0343 3:7 0343017]
  Actuator3-44 MON PARA	[E-0344 0:0 0344009]
  Actuator3-44 MON HYB	[E-0344 0:1 0344008]
  Actuator3-44 MON Position	[E-0344 0:2 0344007]
  Actuator3-44 MON Force	[E-0344 0:3 0344006]
  Actuator3-44 Drive Off	[E-0344 0:4 0344005]
  Actuator3-44 Drive On	[E-0344 0:5 0344004]
  Actuator3-44 CONT Position	[E-0344 0:6 0344003]
  Actuator3-44 CONT Force	[E-0344 0:7 0344002]
  Actuator3-44 Alarm Reset	[E-0344 1:1 0344020]
  Actuator3-44 Limit Release	[E-0344 1:2 034401F]
  Actuator3-44 Selected Step	[E-0344 1:3 034400E]
  Actuator3-44 Selected Load	[E-0344 1:4 034400D]
  Actuator3-44 Selected Drive	[E-0344 1:5 034400C]
  Actuator3-44 Maunakea	[E-0344 1:6 034400B]
  Actuator3-44 Sea Level	[E-0344 1:7 034400A]
  Actuator3-44 Up Limit	[E-0344 2:0 0344016]
  Actuator3-44 Driver Alarm	[E-0344 2:1 0344015]
  Actuator3-44 Error Alarm	[E-0344 2:2 0344014]
  Actuator3-44 Over Current	[E-0344 2:3 0344013]
  Actuator3-44 Over Speed	[E-0344 2:4 0344012]
  Actuator3-44 Over Load	[E-0344 2:5 0344011]
  Actuator3-44 PS Alarm	[E-0344 2:6 0344010]
  Actuator3-44 ENC Alarm	[E-0344 2:7 034400F]
  Actuator3-44 CPU Alarm	[E-0344 3:0 034401E]
  Actuator3-44 UART Alarm	[E-0344 3:1 034401D]
  Actuator3-44 HDLC Alarm	[E-0344 3:2 034401C]
  Actuator3-44 Force Card Fault	[E-0344 3:3 034401B]
  Actuator3-44 Force Sensor Fault	[E-0344 3:4 034401A]
  Actuator3-44 Under Range	[E-0344 3:5 0344019]
  Actuator3-44 Over Range	[E-0344 3:6 0344018]
  Actuator3-44 Down Limit	[E-0344 3:7 0344017]
  Actuator3-45 MON PARA	[E-0345 0:0 0345009]
  Actuator3-45 MON HYB	[E-0345 0:1 0345008]
  Actuator3-45 MON Position	[E-0345 0:2 0345007]
  Actuator3-45 MON Force	[E-0345 0:3 0345006]
  Actuator3-45 Drive Off	[E-0345 0:4 0345005]
  Actuator3-45 Drive On	[E-0345 0:5 0345004]
  Actuator3-45 CONT Position	[E-0345 0:6 0345003]
  Actuator3-45 CONT Force	[E-0345 0:7 0345002]
  Actuator3-45 Alarm Reset	[E-0345 1:1 0345020]
  Actuator3-45 Limit Release	[E-0345 1:2 034501F]
  Actuator3-45 Selected Step	[E-0345 1:3 034500E]
  Actuator3-45 Selected Load	[E-0345 1:4 034500D]
  Actuator3-45 Selected Drive	[E-0345 1:5 034500C]
  Actuator3-45 Maunakea	[E-0345 1:6 034500B]
  Actuator3-45 Sea Level	[E-0345 1:7 034500A]
  Actuator3-45 Up Limit	[E-0345 2:0 0345016]
  Actuator3-45 Driver Alarm	[E-0345 2:1 0345015]
  Actuator3-45 Error Alarm	[E-0345 2:2 0345014]
  Actuator3-45 Over Current	[E-0345 2:3 0345013]
  Actuator3-45 Over Speed	[E-0345 2:4 0345012]
  Actuator3-45 Over Load	[E-0345 2:5 0345011]
  Actuator3-45 PS Alarm	[E-0345 2:6 0345010]
  Actuator3-45 ENC Alarm	[E-0345 2:7 034500F]
  Actuator3-45 CPU Alarm	[E-0345 3:0 034501E]
  Actuator3-45 UART Alarm	[E-0345 3:1 034501D]
  Actuator3-45 HDLC Alarm	[E-0345 3:2 034501C]
  Actuator3-45 Force Card Fault	[E-0345 3:3 034501B]
  Actuator3-45 Force Sensor Fault	[E-0345 3:4 034501A]
  Actuator3-45 Under Range	[E-0345 3:5 0345019]
  Actuator3-45 Over Range	[E-0345 3:6 0345018]
  Actuator3-45 Down Limit	[E-0345 3:7 0345017]
  Actuator3-46 MON PARA	[E-0346 0:0 0346009]
  Actuator3-46 MON HYB	[E-0346 0:1 0346008]
  Actuator3-46 MON Position	[E-0346 0:2 0346007]
  Actuator3-46 MON Force	[E-0346 0:3 0346006]
  Actuator3-46 Drive Off	[E-0346 0:4 0346005]
  Actuator3-46 Drive On	[E-0346 0:5 0346004]
  Actuator3-46 CONT Position	[E-0346 0:6 0346003]
  Actuator3-46 CONT Force	[E-0346 0:7 0346002]
  Actuator3-46 Alarm Reset	[E-0346 1:1 0346020]
  Actuator3-46 Limit Release	[E-0346 1:2 034601F]
  Actuator3-46 Selected Step	[E-0346 1:3 034600E]
  Actuator3-46 Selected Load	[E-0346 1:4 034600D]
  Actuator3-46 Selected Drive	[E-0346 1:5 034600C]
  Actuator3-46 Maunakea	[E-0346 1:6 034600B]
  Actuator3-46 Sea Level	[E-0346 1:7 034600A]
  Actuator3-46 Up Limit	[E-0346 2:0 0346016]
  Actuator3-46 Driver Alarm	[E-0346 2:1 0346015]
  Actuator3-46 Error Alarm	[E-0346 2:2 0346014]
  Actuator3-46 Over Current	[E-0346 2:3 0346013]
  Actuator3-46 Over Speed	[E-0346 2:4 0346012]
  Actuator3-46 Over Load	[E-0346 2:5 0346011]
  Actuator3-46 PS Alarm	[E-0346 2:6 0346010]
  Actuator3-46 ENC Alarm	[E-0346 2:7 034600F]
  Actuator3-46 CPU Alarm	[E-0346 3:0 034601E]
  Actuator3-46 UART Alarm	[E-0346 3:1 034601D]
  Actuator3-46 HDLC Alarm	[E-0346 3:2 034601C]
  Actuator3-46 Force Card Fault	[E-0346 3:3 034601B]
  Actuator3-46 Force Sensor Fault	[E-0346 3:4 034601A]
  Actuator3-46 Under Range	[E-0346 3:5 0346019]
  Actuator3-46 Over Range	[E-0346 3:6 0346018]
  Actuator3-46 Down Limit	[E-0346 3:7 0346017]
  Actuator3-47 MON PARA	[E-0347 0:0 0347009]
  Actuator3-47 MON HYB	[E-0347 0:1 0347008]
  Actuator3-47 MON Position	[E-0347 0:2 0347007]
  Actuator3-47 MON Force	[E-0347 0:3 0347006]
  Actuator3-47 Drive Off	[E-0347 0:4 0347005]
  Actuator3-47 Drive On	[E-0347 0:5 0347004]
  Actuator3-47 CONT Position	[E-0347 0:6 0347003]
  Actuator3-47 CONT Force	[E-0347 0:7 0347002]
  Actuator3-47 Alarm Reset	[E-0347 1:1 0347020]
  Actuator3-47 Limit Release	[E-0347 1:2 034701F]
  Actuator3-47 Selected Step	[E-0347 1:3 034700E]
  Actuator3-47 Selected Load	[E-0347 1:4 034700D]
  Actuator3-47 Selected Drive	[E-0347 1:5 034700C]
  Actuator3-47 Maunakea	[E-0347 1:6 034700B]
  Actuator3-47 Sea Level	[E-0347 1:7 034700A]
  Actuator3-47 Up Limit	[E-0347 2:0 0347016]
  Actuator3-47 Driver Alarm	[E-0347 2:1 0347015]
  Actuator3-47 Error Alarm	[E-0347 2:2 0347014]
  Actuator3-47 Over Current	[E-0347 2:3 0347013]
  Actuator3-47 Over Speed	[E-0347 2:4 0347012]
  Actuator3-47 Over Load	[E-0347 2:5 0347011]
  Actuator3-47 PS Alarm	[E-0347 2:6 0347010]
  Actuator3-47 ENC Alarm	[E-0347 2:7 034700F]
  Actuator3-47 CPU Alarm	[E-0347 3:0 034701E]
  Actuator3-47 UART Alarm	[E-0347 3:1 034701D]
  Actuator3-47 HDLC Alarm	[E-0347 3:2 034701C]
  Actuator3-47 Force Card Fault	[E-0347 3:3 034701B]
  Actuator3-47 Force Sensor Fault	[E-0347 3:4 034701A]
  Actuator3-47 Under Range	[E-0347 3:5 0347019]
  Actuator3-47 Over Range	[E-0347 3:6 0347018]
  Actuator3-47 Down Limit	[E-0347 3:7 0347017]
  Actuator3-48 MON PARA	[E-0348 0:0 0348009]
  Actuator3-48 MON HYB	[E-0348 0:1 0348008]
  Actuator3-48 MON Position	[E-0348 0:2 0348007]
  Actuator3-48 MON Force	[E-0348 0:3 0348006]
  Actuator3-48 Drive Off	[E-0348 0:4 0348005]
  Actuator3-48 Drive On	[E-0348 0:5 0348004]
  Actuator3-48 CONT Position	[E-0348 0:6 0348003]
  Actuator3-48 CONT Force	[E-0348 0:7 0348002]
  Actuator3-48 Alarm Reset	[E-0348 1:1 0348020]
  Actuator3-48 Limit Release	[E-0348 1:2 034801F]
  Actuator3-48 Selected Step	[E-0348 1:3 034800E]
  Actuator3-48 Selected Load	[E-0348 1:4 034800D]
  Actuator3-48 Selected Drive	[E-0348 1:5 034800C]
  Actuator3-48 Maunakea	[E-0348 1:6 034800B]
  Actuator3-48 Sea Level	[E-0348 1:7 034800A]
  Actuator3-48 Up Limit	[E-0348 2:0 0348016]
  Actuator3-48 Driver Alarm	[E-0348 2:1 0348015]
  Actuator3-48 Error Alarm	[E-0348 2:2 0348014]
  Actuator3-48 Over Current	[E-0348 2:3 0348013]
  Actuator3-48 Over Speed	[E-0348 2:4 0348012]
  Actuator3-48 Over Load	[E-0348 2:5 0348011]
  Actuator3-48 PS Alarm	[E-0348 2:6 0348010]
  Actuator3-48 ENC Alarm	[E-0348 2:7 034800F]
  Actuator3-48 CPU Alarm	[E-0348 3:0 034801E]
  Actuator3-48 UART Alarm	[E-0348 3:1 034801D]
  Actuator3-48 HDLC Alarm	[E-0348 3:2 034801C]
  Actuator3-48 Force Card Fault	[E-0348 3:3 034801B]
  Actuator3-48 Force Sensor Fault	[E-0348 3:4 034801A]
  Actuator3-48 Under Range	[E-0348 3:5 0348019]
  Actuator3-48 Over Range	[E-0348 3:6 0348018]
  Actuator3-48 Down Limit	[E-0348 3:7 0348017]
  Actuator3-49 MON PARA	[E-0349 0:0 0349009]
  Actuator3-49 MON HYB	[E-0349 0:1 0349008]
  Actuator3-49 MON Position	[E-0349 0:2 0349007]
  Actuator3-49 MON Force	[E-0349 0:3 0349006]
  Actuator3-49 Drive Off	[E-0349 0:4 0349005]
  Actuator3-49 Drive On	[E-0349 0:5 0349004]
  Actuator3-49 CONT Position	[E-0349 0:6 0349003]
  Actuator3-49 CONT Force	[E-0349 0:7 0349002]
  Actuator3-49 Alarm Reset	[E-0349 1:1 0349020]
  Actuator3-49 Limit Release	[E-0349 1:2 034901F]
  Actuator3-49 Selected Step	[E-0349 1:3 034900E]
  Actuator3-49 Selected Load	[E-0349 1:4 034900D]
  Actuator3-49 Selected Drive	[E-0349 1:5 034900C]
  Actuator3-49 Maunakea	[E-0349 1:6 034900B]
  Actuator3-49 Sea Level	[E-0349 1:7 034900A]
  Actuator3-49 Up Limit	[E-0349 2:0 0349016]
  Actuator3-49 Driver Alarm	[E-0349 2:1 0349015]
  Actuator3-49 Error Alarm	[E-0349 2:2 0349014]
  Actuator3-49 Over Current	[E-0349 2:3 0349013]
  Actuator3-49 Over Speed	[E-0349 2:4 0349012]
  Actuator3-49 Over Load	[E-0349 2:5 0349011]
  Actuator3-49 PS Alarm	[E-0349 2:6 0349010]
  Actuator3-49 ENC Alarm	[E-0349 2:7 034900F]
  Actuator3-49 CPU Alarm	[E-0349 3:0 034901E]
  Actuator3-49 UART Alarm	[E-0349 3:1 034901D]
  Actuator3-49 HDLC Alarm	[E-0349 3:2 034901C]
  Actuator3-49 Force Card Fault	[E-0349 3:3 034901B]
  Actuator3-49 Force Sensor Fault	[E-0349 3:4 034901A]
  Actuator3-49 Under Range	[E-0349 3:5 0349019]
  Actuator3-49 Over Range	[E-0349 3:6 0349018]
  Actuator3-49 Down Limit	[E-0349 3:7 0349017]
  Actuator3-50 MON PARA	[E-0350 0:0 0350009]
  Actuator3-50 MON HYB	[E-0350 0:1 0350008]
  Actuator3-50 MON Position	[E-0350 0:2 0350007]
  Actuator3-50 MON Force	[E-0350 0:3 0350006]
  Actuator3-50 Drive Off	[E-0350 0:4 0350005]
  Actuator3-50 Drive On	[E-0350 0:5 0350004]
  Actuator3-50 CONT Position	[E-0350 0:6 0350003]
  Actuator3-50 CONT Force	[E-0350 0:7 0350002]
  Actuator3-50 Alarm Reset	[E-0350 1:1 0350020]
  Actuator3-50 Limit Release	[E-0350 1:2 035001F]
  Actuator3-50 Selected Step	[E-0350 1:3 035000E]
  Actuator3-50 Selected Load	[E-0350 1:4 035000D]
  Actuator3-50 Selected Drive	[E-0350 1:5 035000C]
  Actuator3-50 Maunakea	[E-0350 1:6 035000B]
  Actuator3-50 Sea Level	[E-0350 1:7 035000A]
  Actuator3-50 Up Limit	[E-0350 2:0 0350016]
  Actuator3-50 Driver Alarm	[E-0350 2:1 0350015]
  Actuator3-50 Error Alarm	[E-0350 2:2 0350014]
  Actuator3-50 Over Current	[E-0350 2:3 0350013]
  Actuator3-50 Over Speed	[E-0350 2:4 0350012]
  Actuator3-50 Over Load	[E-0350 2:5 0350011]
  Actuator3-50 PS Alarm	[E-0350 2:6 0350010]
  Actuator3-50 ENC Alarm	[E-0350 2:7 035000F]
  Actuator3-50 CPU Alarm	[E-0350 3:0 035001E]
  Actuator3-50 UART Alarm	[E-0350 3:1 035001D]
  Actuator3-50 HDLC Alarm	[E-0350 3:2 035001C]
  Actuator3-50 Force Card Fault	[E-0350 3:3 035001B]
  Actuator3-50 Force Sensor Fault	[E-0350 3:4 035001A]
  Actuator3-50 Under Range	[E-0350 3:5 0350019]
  Actuator3-50 Over Range	[E-0350 3:6 0350018]
  Actuator3-50 Down Limit	[E-0350 3:7 0350017]
  Actuator3-51 MON PARA	[E-0351 0:0 0351009]
  Actuator3-51 MON HYB	[E-0351 0:1 0351008]
  Actuator3-51 MON Position	[E-0351 0:2 0351007]
  Actuator3-51 MON Force	[E-0351 0:3 0351006]
  Actuator3-51 Drive Off	[E-0351 0:4 0351005]
  Actuator3-51 Drive On	[E-0351 0:5 0351004]
  Actuator3-51 CONT Position	[E-0351 0:6 0351003]
  Actuator3-51 CONT Force	[E-0351 0:7 0351002]
  Actuator3-51 Alarm Reset	[E-0351 1:1 0351020]
  Actuator3-51 Limit Release	[E-0351 1:2 035101F]
  Actuator3-51 Selected Step	[E-0351 1:3 035100E]
  Actuator3-51 Selected Load	[E-0351 1:4 035100D]
  Actuator3-51 Selected Drive	[E-0351 1:5 035100C]
  Actuator3-51 Maunakea	[E-0351 1:6 035100B]
  Actuator3-51 Sea Level	[E-0351 1:7 035100A]
  Actuator3-51 Up Limit	[E-0351 2:0 0351016]
  Actuator3-51 Driver Alarm	[E-0351 2:1 0351015]
  Actuator3-51 Error Alarm	[E-0351 2:2 0351014]
  Actuator3-51 Over Current	[E-0351 2:3 0351013]
  Actuator3-51 Over Speed	[E-0351 2:4 0351012]
  Actuator3-51 Over Load	[E-0351 2:5 0351011]
  Actuator3-51 PS Alarm	[E-0351 2:6 0351010]
  Actuator3-51 ENC Alarm	[E-0351 2:7 035100F]
  Actuator3-51 CPU Alarm	[E-0351 3:0 035101E]
  Actuator3-51 UART Alarm	[E-0351 3:1 035101D]
  Actuator3-51 HDLC Alarm	[E-0351 3:2 035101C]
  Actuator3-51 Force Card Fault	[E-0351 3:3 035101B]
  Actuator3-51 Force Sensor Fault	[E-0351 3:4 035101A]
  Actuator3-51 Under Range	[E-0351 3:5 0351019]
  Actuator3-51 Over Range	[E-0351 3:6 0351018]
  Actuator3-51 Down Limit	[E-0351 3:7 0351017]
  Actuator3-52 MON PARA	[E-0352 0:0 0352009]
  Actuator3-52 MON HYB	[E-0352 0:1 0352008]
  Actuator3-52 MON Position	[E-0352 0:2 0352007]
  Actuator3-52 MON Force	[E-0352 0:3 0352006]
  Actuator3-52 Drive Off	[E-0352 0:4 0352005]
  Actuator3-52 Drive On	[E-0352 0:5 0352004]
  Actuator3-52 CONT Position	[E-0352 0:6 0352003]
  Actuator3-52 CONT Force	[E-0352 0:7 0352002]
  Actuator3-52 Alarm Reset	[E-0352 1:1 0352020]
  Actuator3-52 Limit Release	[E-0352 1:2 035201F]
  Actuator3-52 Selected Step	[E-0352 1:3 035200E]
  Actuator3-52 Selected Load	[E-0352 1:4 035200D]
  Actuator3-52 Selected Drive	[E-0352 1:5 035200C]
  Actuator3-52 Maunakea	[E-0352 1:6 035200B]
  Actuator3-52 Sea Level	[E-0352 1:7 035200A]
  Actuator3-52 Up Limit	[E-0352 2:0 0352016]
  Actuator3-52 Driver Alarm	[E-0352 2:1 0352015]
  Actuator3-52 Error Alarm	[E-0352 2:2 0352014]
  Actuator3-52 Over Current	[E-0352 2:3 0352013]
  Actuator3-52 Over Speed	[E-0352 2:4 0352012]
  Actuator3-52 Over Load	[E-0352 2:5 0352011]
  Actuator3-52 PS Alarm	[E-0352 2:6 0352010]
  Actuator3-52 ENC Alarm	[E-0352 2:7 035200F]
  Actuator3-52 CPU Alarm	[E-0352 3:0 035201E]
  Actuator3-52 UART Alarm	[E-0352 3:1 035201D]
  Actuator3-52 HDLC Alarm	[E-0352 3:2 035201C]
  Actuator3-52 Force Card Fault	[E-0352 3:3 035201B]
  Actuator3-52 Force Sensor Fault	[E-0352 3:4 035201A]
  Actuator3-52 Under Range	[E-0352 3:5 0352019]
  Actuator3-52 Over Range	[E-0352 3:6 0352018]
  Actuator3-52 Down Limit	[E-0352 3:7 0352017]
  Actuator3-53 MON PARA	[E-0353 0:0 0353009]
  Actuator3-53 MON HYB	[E-0353 0:1 0353008]
  Actuator3-53 MON Position	[E-0353 0:2 0353007]
  Actuator3-53 MON Force	[E-0353 0:3 0353006]
  Actuator3-53 Drive Off	[E-0353 0:4 0353005]
  Actuator3-53 Drive On	[E-0353 0:5 0353004]
  Actuator3-53 CONT Position	[E-0353 0:6 0353003]
  Actuator3-53 CONT Force	[E-0353 0:7 0353002]
  Actuator3-53 Alarm Reset	[E-0353 1:1 0353020]
  Actuator3-53 Limit Release	[E-0353 1:2 035301F]
  Actuator3-53 Selected Step	[E-0353 1:3 035300E]
  Actuator3-53 Selected Load	[E-0353 1:4 035300D]
  Actuator3-53 Selected Drive	[E-0353 1:5 035300C]
  Actuator3-53 Maunakea	[E-0353 1:6 035300B]
  Actuator3-53 Sea Level	[E-0353 1:7 035300A]
  Actuator3-53 Up Limit	[E-0353 2:0 0353016]
  Actuator3-53 Driver Alarm	[E-0353 2:1 0353015]
  Actuator3-53 Error Alarm	[E-0353 2:2 0353014]
  Actuator3-53 Over Current	[E-0353 2:3 0353013]
  Actuator3-53 Over Speed	[E-0353 2:4 0353012]
  Actuator3-53 Over Load	[E-0353 2:5 0353011]
  Actuator3-53 PS Alarm	[E-0353 2:6 0353010]
  Actuator3-53 ENC Alarm	[E-0353 2:7 035300F]
  Actuator3-53 CPU Alarm	[E-0353 3:0 035301E]
  Actuator3-53 UART Alarm	[E-0353 3:1 035301D]
  Actuator3-53 HDLC Alarm	[E-0353 3:2 035301C]
  Actuator3-53 Force Card Fault	[E-0353 3:3 035301B]
  Actuator3-53 Force Sensor Fault	[E-0353 3:4 035301A]
  Actuator3-53 Under Range	[E-0353 3:5 0353019]
  Actuator3-53 Over Range	[E-0353 3:6 0353018]
  Actuator3-53 Down Limit	[E-0353 3:7 0353017]
  Actuator3-54 MON PARA	[E-0354 0:0 0354009]
  Actuator3-54 MON HYB	[E-0354 0:1 0354008]
  Actuator3-54 MON Position	[E-0354 0:2 0354007]
  Actuator3-54 MON Force	[E-0354 0:3 0354006]
  Actuator3-54 Drive Off	[E-0354 0:4 0354005]
  Actuator3-54 Drive On	[E-0354 0:5 0354004]
  Actuator3-54 CONT Position	[E-0354 0:6 0354003]
  Actuator3-54 CONT Force	[E-0354 0:7 0354002]
  Actuator3-54 Alarm Reset	[E-0354 1:1 0354020]
  Actuator3-54 Limit Release	[E-0354 1:2 035401F]
  Actuator3-54 Selected Step	[E-0354 1:3 035400E]
  Actuator3-54 Selected Load	[E-0354 1:4 035400D]
  Actuator3-54 Selected Drive	[E-0354 1:5 035400C]
  Actuator3-54 Maunakea	[E-0354 1:6 035400B]
  Actuator3-54 Sea Level	[E-0354 1:7 035400A]
  Actuator3-54 Up Limit	[E-0354 2:0 0354016]
  Actuator3-54 Driver Alarm	[E-0354 2:1 0354015]
  Actuator3-54 Error Alarm	[E-0354 2:2 0354014]
  Actuator3-54 Over Current	[E-0354 2:3 0354013]
  Actuator3-54 Over Speed	[E-0354 2:4 0354012]
  Actuator3-54 Over Load	[E-0354 2:5 0354011]
  Actuator3-54 PS Alarm	[E-0354 2:6 0354010]
  Actuator3-54 ENC Alarm	[E-0354 2:7 035400F]
  Actuator3-54 CPU Alarm	[E-0354 3:0 035401E]
  Actuator3-54 UART Alarm	[E-0354 3:1 035401D]
  Actuator3-54 HDLC Alarm	[E-0354 3:2 035401C]
  Actuator3-54 Force Card Fault	[E-0354 3:3 035401B]
  Actuator3-54 Force Sensor Fault	[E-0354 3:4 035401A]
  Actuator3-54 Under Range	[E-0354 3:5 0354019]
  Actuator3-54 Over Range	[E-0354 3:6 0354018]
  Actuator3-54 Down Limit	[E-0354 3:7 0354017]
  Actuator3-55 MON PARA	[E-0355 0:0 0355009]
  Actuator3-55 MON HYB	[E-0355 0:1 0355008]
  Actuator3-55 MON Position	[E-0355 0:2 0355007]
  Actuator3-55 MON Force	[E-0355 0:3 0355006]
  Actuator3-55 Drive Off	[E-0355 0:4 0355005]
  Actuator3-55 Drive On	[E-0355 0:5 0355004]
  Actuator3-55 CONT Position	[E-0355 0:6 0355003]
  Actuator3-55 CONT Force	[E-0355 0:7 0355002]
  Actuator3-55 Alarm Reset	[E-0355 1:1 0355020]
  Actuator3-55 Limit Release	[E-0355 1:2 035501F]
  Actuator3-55 Selected Step	[E-0355 1:3 035500E]
  Actuator3-55 Selected Load	[E-0355 1:4 035500D]
  Actuator3-55 Selected Drive	[E-0355 1:5 035500C]
  Actuator3-55 Maunakea	[E-0355 1:6 035500B]
  Actuator3-55 Sea Level	[E-0355 1:7 035500A]
  Actuator3-55 Up Limit	[E-0355 2:0 0355016]
  Actuator3-55 Driver Alarm	[E-0355 2:1 0355015]
  Actuator3-55 Error Alarm	[E-0355 2:2 0355014]
  Actuator3-55 Over Current	[E-0355 2:3 0355013]
  Actuator3-55 Over Speed	[E-0355 2:4 0355012]
  Actuator3-55 Over Load	[E-0355 2:5 0355011]
  Actuator3-55 PS Alarm	[E-0355 2:6 0355010]
  Actuator3-55 ENC Alarm	[E-0355 2:7 035500F]
  Actuator3-55 CPU Alarm	[E-0355 3:0 035501E]
  Actuator3-55 UART Alarm	[E-0355 3:1 035501D]
  Actuator3-55 HDLC Alarm	[E-0355 3:2 035501C]
  Actuator3-55 Force Card Fault	[E-0355 3:3 035501B]
  Actuator3-55 Force Sensor Fault	[E-0355 3:4 035501A]
  Actuator3-55 Under Range	[E-0355 3:5 0355019]
  Actuator3-55 Over Range	[E-0355 3:6 0355018]
  Actuator3-55 Down Limit	[E-0355 3:7 0355017]
  Actuator3-56 MON PARA	[E-0356 0:0 0356009]
  Actuator3-56 MON HYB	[E-0356 0:1 0356008]
  Actuator3-56 MON Position	[E-0356 0:2 0356007]
  Actuator3-56 MON Force	[E-0356 0:3 0356006]
  Actuator3-56 Drive Off	[E-0356 0:4 0356005]
  Actuator3-56 Drive On	[E-0356 0:5 0356004]
  Actuator3-56 CONT Position	[E-0356 0:6 0356003]
  Actuator3-56 CONT Force	[E-0356 0:7 0356002]
  Actuator3-56 Alarm Reset	[E-0356 1:1 0356020]
  Actuator3-56 Limit Release	[E-0356 1:2 035601F]
  Actuator3-56 Selected Step	[E-0356 1:3 035600E]
  Actuator3-56 Selected Load	[E-0356 1:4 035600D]
  Actuator3-56 Selected Drive	[E-0356 1:5 035600C]
  Actuator3-56 Maunakea	[E-0356 1:6 035600B]
  Actuator3-56 Sea Level	[E-0356 1:7 035600A]
  Actuator3-56 Up Limit	[E-0356 2:0 0356016]
  Actuator3-56 Driver Alarm	[E-0356 2:1 0356015]
  Actuator3-56 Error Alarm	[E-0356 2:2 0356014]
  Actuator3-56 Over Current	[E-0356 2:3 0356013]
  Actuator3-56 Over Speed	[E-0356 2:4 0356012]
  Actuator3-56 Over Load	[E-0356 2:5 0356011]
  Actuator3-56 PS Alarm	[E-0356 2:6 0356010]
  Actuator3-56 ENC Alarm	[E-0356 2:7 035600F]
  Actuator3-56 CPU Alarm	[E-0356 3:0 035601E]
  Actuator3-56 UART Alarm	[E-0356 3:1 035601D]
  Actuator3-56 HDLC Alarm	[E-0356 3:2 035601C]
  Actuator3-56 Force Card Fault	[E-0356 3:3 035601B]
  Actuator3-56 Force Sensor Fault	[E-0356 3:4 035601A]
  Actuator3-56 Under Range	[E-0356 3:5 0356019]
  Actuator3-56 Over Range	[E-0356 3:6 0356018]
  Actuator3-56 Down Limit	[E-0356 3:7 0356017]
  Actuator3-57 MON PARA	[E-0357 0:0 0357009]
  Actuator3-57 MON HYB	[E-0357 0:1 0357008]
  Actuator3-57 MON Position	[E-0357 0:2 0357007]
  Actuator3-57 MON Force	[E-0357 0:3 0357006]
  Actuator3-57 Drive Off	[E-0357 0:4 0357005]
  Actuator3-57 Drive On	[E-0357 0:5 0357004]
  Actuator3-57 CONT Position	[E-0357 0:6 0357003]
  Actuator3-57 CONT Force	[E-0357 0:7 0357002]
  Actuator3-57 Alarm Reset	[E-0357 1:1 0357020]
  Actuator3-57 Limit Release	[E-0357 1:2 035701F]
  Actuator3-57 Selected Step	[E-0357 1:3 035700E]
  Actuator3-57 Selected Load	[E-0357 1:4 035700D]
  Actuator3-57 Selected Drive	[E-0357 1:5 035700C]
  Actuator3-57 Maunakea	[E-0357 1:6 035700B]
  Actuator3-57 Sea Level	[E-0357 1:7 035700A]
  Actuator3-57 Up Limit	[E-0357 2:0 0357016]
  Actuator3-57 Driver Alarm	[E-0357 2:1 0357015]
  Actuator3-57 Error Alarm	[E-0357 2:2 0357014]
  Actuator3-57 Over Current	[E-0357 2:3 0357013]
  Actuator3-57 Over Speed	[E-0357 2:4 0357012]
  Actuator3-57 Over Load	[E-0357 2:5 0357011]
  Actuator3-57 PS Alarm	[E-0357 2:6 0357010]
  Actuator3-57 ENC Alarm	[E-0357 2:7 035700F]
  Actuator3-57 CPU Alarm	[E-0357 3:0 035701E]
  Actuator3-57 UART Alarm	[E-0357 3:1 035701D]
  Actuator3-57 HDLC Alarm	[E-0357 3:2 035701C]
  Actuator3-57 Force Card Fault	[E-0357 3:3 035701B]
  Actuator3-57 Force Sensor Fault	[E-0357 3:4 035701A]
  Actuator3-57 Under Range	[E-0357 3:5 0357019]
  Actuator3-57 Over Range	[E-0357 3:6 0357018]
  Actuator3-57 Down Limit	[E-0357 3:7 0357017]
  Actuator3-58 MON PARA	[E-0358 0:0 0358009]
  Actuator3-58 MON HYB	[E-0358 0:1 0358008]
  Actuator3-58 MON Position	[E-0358 0:2 0358007]
  Actuator3-58 MON Force	[E-0358 0:3 0358006]
  Actuator3-58 Drive Off	[E-0358 0:4 0358005]
  Actuator3-58 Drive On	[E-0358 0:5 0358004]
  Actuator3-58 CONT Position	[E-0358 0:6 0358003]
  Actuator3-58 CONT Force	[E-0358 0:7 0358002]
  Actuator3-58 Alarm Reset	[E-0358 1:1 0358020]
  Actuator3-58 Limit Release	[E-0358 1:2 035801F]
  Actuator3-58 Selected Step	[E-0358 1:3 035800E]
  Actuator3-58 Selected Load	[E-0358 1:4 035800D]
  Actuator3-58 Selected Drive	[E-0358 1:5 035800C]
  Actuator3-58 Maunakea	[E-0358 1:6 035800B]
  Actuator3-58 Sea Level	[E-0358 1:7 035800A]
  Actuator3-58 Up Limit	[E-0358 2:0 0358016]
  Actuator3-58 Driver Alarm	[E-0358 2:1 0358015]
  Actuator3-58 Error Alarm	[E-0358 2:2 0358014]
  Actuator3-58 Over Current	[E-0358 2:3 0358013]
  Actuator3-58 Over Speed	[E-0358 2:4 0358012]
  Actuator3-58 Over Load	[E-0358 2:5 0358011]
  Actuator3-58 PS Alarm	[E-0358 2:6 0358010]
  Actuator3-58 ENC Alarm	[E-0358 2:7 035800F]
  Actuator3-58 CPU Alarm	[E-0358 3:0 035801E]
  Actuator3-58 UART Alarm	[E-0358 3:1 035801D]
  Actuator3-58 HDLC Alarm	[E-0358 3:2 035801C]
  Actuator3-58 Force Card Fault	[E-0358 3:3 035801B]
  Actuator3-58 Force Sensor Fault	[E-0358 3:4 035801A]
  Actuator3-58 Under Range	[E-0358 3:5 0358019]
  Actuator3-58 Over Range	[E-0358 3:6 0358018]
  Actuator3-58 Down Limit	[E-0358 3:7 0358017]
  Actuator3-59 MON PARA	[E-0359 0:0 0359009]
  Actuator3-59 MON HYB	[E-0359 0:1 0359008]
  Actuator3-59 MON Position	[E-0359 0:2 0359007]
  Actuator3-59 MON Force	[E-0359 0:3 0359006]
  Actuator3-59 Drive Off	[E-0359 0:4 0359005]
  Actuator3-59 Drive On	[E-0359 0:5 0359004]
  Actuator3-59 CONT Position	[E-0359 0:6 0359003]
  Actuator3-59 CONT Force	[E-0359 0:7 0359002]
  Actuator3-59 Alarm Reset	[E-0359 1:1 0359020]
  Actuator3-59 Limit Release	[E-0359 1:2 035901F]
  Actuator3-59 Selected Step	[E-0359 1:3 035900E]
  Actuator3-59 Selected Load	[E-0359 1:4 035900D]
  Actuator3-59 Selected Drive	[E-0359 1:5 035900C]
  Actuator3-59 Maunakea	[E-0359 1:6 035900B]
  Actuator3-59 Sea Level	[E-0359 1:7 035900A]
  Actuator3-59 Up Limit	[E-0359 2:0 0359016]
  Actuator3-59 Driver Alarm	[E-0359 2:1 0359015]
  Actuator3-59 Error Alarm	[E-0359 2:2 0359014]
  Actuator3-59 Over Current	[E-0359 2:3 0359013]
  Actuator3-59 Over Speed	[E-0359 2:4 0359012]
  Actuator3-59 Over Load	[E-0359 2:5 0359011]
  Actuator3-59 PS Alarm	[E-0359 2:6 0359010]
  Actuator3-59 ENC Alarm	[E-0359 2:7 035900F]
  Actuator3-59 CPU Alarm	[E-0359 3:0 035901E]
  Actuator3-59 UART Alarm	[E-0359 3:1 035901D]
  Actuator3-59 HDLC Alarm	[E-0359 3:2 035901C]
  Actuator3-59 Force Card Fault	[E-0359 3:3 035901B]
  Actuator3-59 Force Sensor Fault	[E-0359 3:4 035901A]
  Actuator3-59 Under Range	[E-0359 3:5 0359019]
  Actuator3-59 Over Range	[E-0359 3:6 0359018]
  Actuator3-59 Down Limit	[E-0359 3:7 0359017]
  Actuator3-60 MON PARA	[E-0360 0:0 0360009]
  Actuator3-60 MON HYB	[E-0360 0:1 0360008]
  Actuator3-60 MON Position	[E-0360 0:2 0360007]
  Actuator3-60 MON Force	[E-0360 0:3 0360006]
  Actuator3-60 Drive Off	[E-0360 0:4 0360005]
  Actuator3-60 Drive On	[E-0360 0:5 0360004]
  Actuator3-60 CONT Position	[E-0360 0:6 0360003]
  Actuator3-60 CONT Force	[E-0360 0:7 0360002]
  Actuator3-60 Alarm Reset	[E-0360 1:1 0360020]
  Actuator3-60 Limit Release	[E-0360 1:2 036001F]
  Actuator3-60 Selected Step	[E-0360 1:3 036000E]
  Actuator3-60 Selected Load	[E-0360 1:4 036000D]
  Actuator3-60 Selected Drive	[E-0360 1:5 036000C]
  Actuator3-60 Maunakea	[E-0360 1:6 036000B]
  Actuator3-60 Sea Level	[E-0360 1:7 036000A]
  Actuator3-60 Up Limit	[E-0360 2:0 0360016]
  Actuator3-60 Driver Alarm	[E-0360 2:1 0360015]
  Actuator3-60 Error Alarm	[E-0360 2:2 0360014]
  Actuator3-60 Over Current	[E-0360 2:3 0360013]
  Actuator3-60 Over Speed	[E-0360 2:4 0360012]
  Actuator3-60 Over Load	[E-0360 2:5 0360011]
  Actuator3-60 PS Alarm	[E-0360 2:6 0360010]
  Actuator3-60 ENC Alarm	[E-0360 2:7 036000F]
  Actuator3-60 CPU Alarm	[E-0360 3:0 036001E]
  Actuator3-60 UART Alarm	[E-0360 3:1 036001D]
  Actuator3-60 HDLC Alarm	[E-0360 3:2 036001C]
  Actuator3-60 Force Card Fault	[E-0360 3:3 036001B]
  Actuator3-60 Force Sensor Fault	[E-0360 3:4 036001A]
  Actuator3-60 Under Range	[E-0360 3:5 0360019]
  Actuator3-60 Over Range	[E-0360 3:6 0360018]
  Actuator3-60 Down Limit	[E-0360 3:7 0360017]
  Actuator3-61 MON PARA	[E-0361 0:0 0361009]
  Actuator3-61 MON HYB	[E-0361 0:1 0361008]
  Actuator3-61 MON Position	[E-0361 0:2 0361007]
  Actuator3-61 MON Force	[E-0361 0:3 0361006]
  Actuator3-61 Drive Off	[E-0361 0:4 0361005]
  Actuator3-61 Drive On	[E-0361 0:5 0361004]
  Actuator3-61 CONT Position	[E-0361 0:6 0361003]
  Actuator3-61 CONT Force	[E-0361 0:7 0361002]
  Actuator3-61 Alarm Reset	[E-0361 1:1 0361020]
  Actuator3-61 Limit Release	[E-0361 1:2 036101F]
  Actuator3-61 Selected Step	[E-0361 1:3 036100E]
  Actuator3-61 Selected Load	[E-0361 1:4 036100D]
  Actuator3-61 Selected Drive	[E-0361 1:5 036100C]
  Actuator3-61 Maunakea	[E-0361 1:6 036100B]
  Actuator3-61 Sea Level	[E-0361 1:7 036100A]
  Actuator3-61 Up Limit	[E-0361 2:0 0361016]
  Actuator3-61 Driver Alarm	[E-0361 2:1 0361015]
  Actuator3-61 Error Alarm	[E-0361 2:2 0361014]
  Actuator3-61 Over Current	[E-0361 2:3 0361013]
  Actuator3-61 Over Speed	[E-0361 2:4 0361012]
  Actuator3-61 Over Load	[E-0361 2:5 0361011]
  Actuator3-61 PS Alarm	[E-0361 2:6 0361010]
  Actuator3-61 ENC Alarm	[E-0361 2:7 036100F]
  Actuator3-61 CPU Alarm	[E-0361 3:0 036101E]
  Actuator3-61 UART Alarm	[E-0361 3:1 036101D]
  Actuator3-61 HDLC Alarm	[E-0361 3:2 036101C]
  Actuator3-61 Force Card Fault	[E-0361 3:3 036101B]
  Actuator3-61 Force Sensor Fault	[E-0361 3:4 036101A]
  Actuator3-61 Under Range	[E-0361 3:5 0361019]
  Actuator3-61 Over Range	[E-0361 3:6 0361018]
  Actuator3-61 Down Limit	[E-0361 3:7 0361017]
  Actuator3-62 MON PARA	[E-0362 0:0 0362009]
  Actuator3-62 MON HYB	[E-0362 0:1 0362008]
  Actuator3-62 MON Position	[E-0362 0:2 0362007]
  Actuator3-62 MON Force	[E-0362 0:3 0362006]
  Actuator3-62 Drive Off	[E-0362 0:4 0362005]
  Actuator3-62 Drive On	[E-0362 0:5 0362004]
  Actuator3-62 CONT Position	[E-0362 0:6 0362003]
  Actuator3-62 CONT Force	[E-0362 0:7 0362002]
  Actuator3-62 Alarm Reset	[E-0362 1:1 0362020]
  Actuator3-62 Limit Release	[E-0362 1:2 036201F]
  Actuator3-62 Selected Step	[E-0362 1:3 036200E]
  Actuator3-62 Selected Load	[E-0362 1:4 036200D]
  Actuator3-62 Selected Drive	[E-0362 1:5 036200C]
  Actuator3-62 Maunakea	[E-0362 1:6 036200B]
  Actuator3-62 Sea Level	[E-0362 1:7 036200A]
  Actuator3-62 Up Limit	[E-0362 2:0 0362016]
  Actuator3-62 Driver Alarm	[E-0362 2:1 0362015]
  Actuator3-62 Error Alarm	[E-0362 2:2 0362014]
  Actuator3-62 Over Current	[E-0362 2:3 0362013]
  Actuator3-62 Over Speed	[E-0362 2:4 0362012]
  Actuator3-62 Over Load	[E-0362 2:5 0362011]
  Actuator3-62 PS Alarm	[E-0362 2:6 0362010]
  Actuator3-62 ENC Alarm	[E-0362 2:7 036200F]
  Actuator3-62 CPU Alarm	[E-0362 3:0 036201E]
  Actuator3-62 UART Alarm	[E-0362 3:1 036201D]
  Actuator3-62 HDLC Alarm	[E-0362 3:2 036201C]
  Actuator3-62 Force Card Fault	[E-0362 3:3 036201B]
  Actuator3-62 Force Sensor Fault	[E-0362 3:4 036201A]
  Actuator3-62 Under Range	[E-0362 3:5 0362019]
  Actuator3-62 Over Range	[E-0362 3:6 0362018]
  Actuator3-62 Down Limit	[E-0362 3:7 0362017]
  Actuator3-63 MON PARA	[E-0363 0:0 0363009]
  Actuator3-63 MON HYB	[E-0363 0:1 0363008]
  Actuator3-63 MON Position	[E-0363 0:2 0363007]
  Actuator3-63 MON Force	[E-0363 0:3 0363006]
  Actuator3-63 Drive Off	[E-0363 0:4 0363005]
  Actuator3-63 Drive On	[E-0363 0:5 0363004]
  Actuator3-63 CONT Position	[E-0363 0:6 0363003]
  Actuator3-63 CONT Force	[E-0363 0:7 0363002]
  Actuator3-63 Alarm Reset	[E-0363 1:1 0363020]
  Actuator3-63 Limit Release	[E-0363 1:2 036301F]
  Actuator3-63 Selected Step	[E-0363 1:3 036300E]
  Actuator3-63 Selected Load	[E-0363 1:4 036300D]
  Actuator3-63 Selected Drive	[E-0363 1:5 036300C]
  Actuator3-63 Maunakea	[E-0363 1:6 036300B]
  Actuator3-63 Sea Level	[E-0363 1:7 036300A]
  Actuator3-63 Up Limit	[E-0363 2:0 0363016]
  Actuator3-63 Driver Alarm	[E-0363 2:1 0363015]
  Actuator3-63 Error Alarm	[E-0363 2:2 0363014]
  Actuator3-63 Over Current	[E-0363 2:3 0363013]
  Actuator3-63 Over Speed	[E-0363 2:4 0363012]
  Actuator3-63 Over Load	[E-0363 2:5 0363011]
  Actuator3-63 PS Alarm	[E-0363 2:6 0363010]
  Actuator3-63 ENC Alarm	[E-0363 2:7 036300F]
  Actuator3-63 CPU Alarm	[E-0363 3:0 036301E]
  Actuator3-63 UART Alarm	[E-0363 3:1 036301D]
  Actuator3-63 HDLC Alarm	[E-0363 3:2 036301C]
  Actuator3-63 Force Card Fault	[E-0363 3:3 036301B]
  Actuator3-63 Force Sensor Fault	[E-0363 3:4 036301A]
  Actuator3-63 Under Range	[E-0363 3:5 0363019]
  Actuator3-63 Over Range	[E-0363 3:6 0363018]
  Actuator3-63 Down Limit	[E-0363 3:7 0363017]
  Actuator3-64 MON PARA	[E-0364 0:0 0364009]
  Actuator3-64 MON HYB	[E-0364 0:1 0364008]
  Actuator3-64 MON Position	[E-0364 0:2 0364007]
  Actuator3-64 MON Force	[E-0364 0:3 0364006]
  Actuator3-64 Drive Off	[E-0364 0:4 0364005]
  Actuator3-64 Drive On	[E-0364 0:5 0364004]
  Actuator3-64 CONT Position	[E-0364 0:6 0364003]
  Actuator3-64 CONT Force	[E-0364 0:7 0364002]
  Actuator3-64 Alarm Reset	[E-0364 1:1 0364020]
  Actuator3-64 Limit Release	[E-0364 1:2 036401F]
  Actuator3-64 Selected Step	[E-0364 1:3 036400E]
  Actuator3-64 Selected Load	[E-0364 1:4 036400D]
  Actuator3-64 Selected Drive	[E-0364 1:5 036400C]
  Actuator3-64 Maunakea	[E-0364 1:6 036400B]
  Actuator3-64 Sea Level	[E-0364 1:7 036400A]
  Actuator3-64 Up Limit	[E-0364 2:0 0364016]
  Actuator3-64 Driver Alarm	[E-0364 2:1 0364015]
  Actuator3-64 Error Alarm	[E-0364 2:2 0364014]
  Actuator3-64 Over Current	[E-0364 2:3 0364013]
  Actuator3-64 Over Speed	[E-0364 2:4 0364012]
  Actuator3-64 Over Load	[E-0364 2:5 0364011]
  Actuator3-64 PS Alarm	[E-0364 2:6 0364010]
  Actuator3-64 ENC Alarm	[E-0364 2:7 036400F]
  Actuator3-64 CPU Alarm	[E-0364 3:0 036401E]
  Actuator3-64 UART Alarm	[E-0364 3:1 036401D]
  Actuator3-64 HDLC Alarm	[E-0364 3:2 036401C]
  Actuator3-64 Force Card Fault	[E-0364 3:3 036401B]
  Actuator3-64 Force Sensor Fault	[E-0364 3:4 036401A]
  Actuator3-64 Under Range	[E-0364 3:5 0364019]
  Actuator3-64 Over Range	[E-0364 3:6 0364018]
  Actuator3-64 Down Limit	[E-0364 3:7 0364017]
  Actuator3-65 MON PARA	[E-0365 0:0 0365009]
  Actuator3-65 MON HYB	[E-0365 0:1 0365008]
  Actuator3-65 MON Position	[E-0365 0:2 0365007]
  Actuator3-65 MON Force	[E-0365 0:3 0365006]
  Actuator3-65 Drive Off	[E-0365 0:4 0365005]
  Actuator3-65 Drive On	[E-0365 0:5 0365004]
  Actuator3-65 CONT Position	[E-0365 0:6 0365003]
  Actuator3-65 CONT Force	[E-0365 0:7 0365002]
  Actuator3-65 Alarm Reset	[E-0365 1:1 0365020]
  Actuator3-65 Limit Release	[E-0365 1:2 036501F]
  Actuator3-65 Selected Step	[E-0365 1:3 036500E]
  Actuator3-65 Selected Load	[E-0365 1:4 036500D]
  Actuator3-65 Selected Drive	[E-0365 1:5 036500C]
  Actuator3-65 Maunakea	[E-0365 1:6 036500B]
  Actuator3-65 Sea Level	[E-0365 1:7 036500A]
  Actuator3-65 Up Limit	[E-0365 2:0 0365016]
  Actuator3-65 Driver Alarm	[E-0365 2:1 0365015]
  Actuator3-65 Error Alarm	[E-0365 2:2 0365014]
  Actuator3-65 Over Current	[E-0365 2:3 0365013]
  Actuator3-65 Over Speed	[E-0365 2:4 0365012]
  Actuator3-65 Over Load	[E-0365 2:5 0365011]
  Actuator3-65 PS Alarm	[E-0365 2:6 0365010]
  Actuator3-65 ENC Alarm	[E-0365 2:7 036500F]
  Actuator3-65 CPU Alarm	[E-0365 3:0 036501E]
  Actuator3-65 UART Alarm	[E-0365 3:1 036501D]
  Actuator3-65 HDLC Alarm	[E-0365 3:2 036501C]
  Actuator3-65 Force Card Fault	[E-0365 3:3 036501B]
  Actuator3-65 Force Sensor Fault	[E-0365 3:4 036501A]
  Actuator3-65 Under Range	[E-0365 3:5 0365019]
  Actuator3-65 Over Range	[E-0365 3:6 0365018]
  Actuator3-65 Down Limit	[E-0365 3:7 0365017]
  Actuator3-66 MON PARA	[E-0366 0:0 0366009]
  Actuator3-66 MON HYB	[E-0366 0:1 0366008]
  Actuator3-66 MON Position	[E-0366 0:2 0366007]
  Actuator3-66 MON Force	[E-0366 0:3 0366006]
  Actuator3-66 Drive Off	[E-0366 0:4 0366005]
  Actuator3-66 Drive On	[E-0366 0:5 0366004]
  Actuator3-66 CONT Position	[E-0366 0:6 0366003]
  Actuator3-66 CONT Force	[E-0366 0:7 0366002]
  Actuator3-66 Alarm Reset	[E-0366 1:1 0366020]
  Actuator3-66 Limit Release	[E-0366 1:2 036601F]
  Actuator3-66 Selected Step	[E-0366 1:3 036600E]
  Actuator3-66 Selected Load	[E-0366 1:4 036600D]
  Actuator3-66 Selected Drive	[E-0366 1:5 036600C]
  Actuator3-66 Maunakea	[E-0366 1:6 036600B]
  Actuator3-66 Sea Level	[E-0366 1:7 036600A]
  Actuator3-66 Up Limit	[E-0366 2:0 0366016]
  Actuator3-66 Driver Alarm	[E-0366 2:1 0366015]
  Actuator3-66 Error Alarm	[E-0366 2:2 0366014]
  Actuator3-66 Over Current	[E-0366 2:3 0366013]
  Actuator3-66 Over Speed	[E-0366 2:4 0366012]
  Actuator3-66 Over Load	[E-0366 2:5 0366011]
  Actuator3-66 PS Alarm	[E-0366 2:6 0366010]
  Actuator3-66 ENC Alarm	[E-0366 2:7 036600F]
  Actuator3-66 CPU Alarm	[E-0366 3:0 036601E]
  Actuator3-66 UART Alarm	[E-0366 3:1 036601D]
  Actuator3-66 HDLC Alarm	[E-0366 3:2 036601C]
  Actuator3-66 Force Card Fault	[E-0366 3:3 036601B]
  Actuator3-66 Force Sensor Fault	[E-0366 3:4 036601A]
  Actuator3-66 Under Range	[E-0366 3:5 0366019]
  Actuator3-66 Over Range	[E-0366 3:6 0366018]
  Actuator3-66 Down Limit	[E-0366 3:7 0366017]
  Actuator3-67 MON PARA	[E-0367 0:0 0367009]
  Actuator3-67 MON HYB	[E-0367 0:1 0367008]
  Actuator3-67 MON Position	[E-0367 0:2 0367007]
  Actuator3-67 MON Force	[E-0367 0:3 0367006]
  Actuator3-67 Drive Off	[E-0367 0:4 0367005]
  Actuator3-67 Drive On	[E-0367 0:5 0367004]
  Actuator3-67 CONT Position	[E-0367 0:6 0367003]
  Actuator3-67 CONT Force	[E-0367 0:7 0367002]
  Actuator3-67 Alarm Reset	[E-0367 1:1 0367020]
  Actuator3-67 Limit Release	[E-0367 1:2 036701F]
  Actuator3-67 Selected Step	[E-0367 1:3 036700E]
  Actuator3-67 Selected Load	[E-0367 1:4 036700D]
  Actuator3-67 Selected Drive	[E-0367 1:5 036700C]
  Actuator3-67 Maunakea	[E-0367 1:6 036700B]
  Actuator3-67 Sea Level	[E-0367 1:7 036700A]
  Actuator3-67 Up Limit	[E-0367 2:0 0367016]
  Actuator3-67 Driver Alarm	[E-0367 2:1 0367015]
  Actuator3-67 Error Alarm	[E-0367 2:2 0367014]
  Actuator3-67 Over Current	[E-0367 2:3 0367013]
  Actuator3-67 Over Speed	[E-0367 2:4 0367012]
  Actuator3-67 Over Load	[E-0367 2:5 0367011]
  Actuator3-67 PS Alarm	[E-0367 2:6 0367010]
  Actuator3-67 ENC Alarm	[E-0367 2:7 036700F]
  Actuator3-67 CPU Alarm	[E-0367 3:0 036701E]
  Actuator3-67 UART Alarm	[E-0367 3:1 036701D]
  Actuator3-67 HDLC Alarm	[E-0367 3:2 036701C]
  Actuator3-67 Force Card Fault	[E-0367 3:3 036701B]
  Actuator3-67 Force Sensor Fault	[E-0367 3:4 036701A]
  Actuator3-67 Under Range	[E-0367 3:5 0367019]
  Actuator3-67 Over Range	[E-0367 3:6 0367018]
  Actuator3-67 Down Limit	[E-0367 3:7 0367017]
  Actuator3-68 MON PARA	[E-0368 0:0 0368009]
  Actuator3-68 MON HYB	[E-0368 0:1 0368008]
  Actuator3-68 MON Position	[E-0368 0:2 0368007]
  Actuator3-68 MON Force	[E-0368 0:3 0368006]
  Actuator3-68 Drive Off	[E-0368 0:4 0368005]
  Actuator3-68 Drive On	[E-0368 0:5 0368004]
  Actuator3-68 CONT Position	[E-0368 0:6 0368003]
  Actuator3-68 CONT Force	[E-0368 0:7 0368002]
  Actuator3-68 Alarm Reset	[E-0368 1:1 0368020]
  Actuator3-68 Limit Release	[E-0368 1:2 036801F]
  Actuator3-68 Selected Step	[E-0368 1:3 036800E]
  Actuator3-68 Selected Load	[E-0368 1:4 036800D]
  Actuator3-68 Selected Drive	[E-0368 1:5 036800C]
  Actuator3-68 Maunakea	[E-0368 1:6 036800B]
  Actuator3-68 Sea Level	[E-0368 1:7 036800A]
  Actuator3-68 Up Limit	[E-0368 2:0 0368016]
  Actuator3-68 Driver Alarm	[E-0368 2:1 0368015]
  Actuator3-68 Error Alarm	[E-0368 2:2 0368014]
  Actuator3-68 Over Current	[E-0368 2:3 0368013]
  Actuator3-68 Over Speed	[E-0368 2:4 0368012]
  Actuator3-68 Over Load	[E-0368 2:5 0368011]
  Actuator3-68 PS Alarm	[E-0368 2:6 0368010]
  Actuator3-68 ENC Alarm	[E-0368 2:7 036800F]
  Actuator3-68 CPU Alarm	[E-0368 3:0 036801E]
  Actuator3-68 UART Alarm	[E-0368 3:1 036801D]
  Actuator3-68 HDLC Alarm	[E-0368 3:2 036801C]
  Actuator3-68 Force Card Fault	[E-0368 3:3 036801B]
  Actuator3-68 Force Sensor Fault	[E-0368 3:4 036801A]
  Actuator3-68 Under Range	[E-0368 3:5 0368019]
  Actuator3-68 Over Range	[E-0368 3:6 0368018]
  Actuator3-68 Down Limit	[E-0368 3:7 0368017]
  Actuator3-69 MON PARA	[E-0369 0:0 0369009]
  Actuator3-69 MON HYB	[E-0369 0:1 0369008]
  Actuator3-69 MON Position	[E-0369 0:2 0369007]
  Actuator3-69 MON Force	[E-0369 0:3 0369006]
  Actuator3-69 Drive Off	[E-0369 0:4 0369005]
  Actuator3-69 Drive On	[E-0369 0:5 0369004]
  Actuator3-69 CONT Position	[E-0369 0:6 0369003]
  Actuator3-69 CONT Force	[E-0369 0:7 0369002]
  Actuator3-69 Alarm Reset	[E-0369 1:1 0369020]
  Actuator3-69 Limit Release	[E-0369 1:2 036901F]
  Actuator3-69 Selected Step	[E-0369 1:3 036900E]
  Actuator3-69 Selected Load	[E-0369 1:4 036900D]
  Actuator3-69 Selected Drive	[E-0369 1:5 036900C]
  Actuator3-69 Maunakea	[E-0369 1:6 036900B]
  Actuator3-69 Sea Level	[E-0369 1:7 036900A]
  Actuator3-69 Up Limit	[E-0369 2:0 0369016]
  Actuator3-69 Driver Alarm	[E-0369 2:1 0369015]
  Actuator3-69 Error Alarm	[E-0369 2:2 0369014]
  Actuator3-69 Over Current	[E-0369 2:3 0369013]
  Actuator3-69 Over Speed	[E-0369 2:4 0369012]
  Actuator3-69 Over Load	[E-0369 2:5 0369011]
  Actuator3-69 PS Alarm	[E-0369 2:6 0369010]
  Actuator3-69 ENC Alarm	[E-0369 2:7 036900F]
  Actuator3-69 CPU Alarm	[E-0369 3:0 036901E]
  Actuator3-69 UART Alarm	[E-0369 3:1 036901D]
  Actuator3-69 HDLC Alarm	[E-0369 3:2 036901C]
  Actuator3-69 Force Card Fault	[E-0369 3:3 036901B]
  Actuator3-69 Force Sensor Fault	[E-0369 3:4 036901A]
  Actuator3-69 Under Range	[E-0369 3:5 0369019]
  Actuator3-69 Over Range	[E-0369 3:6 0369018]
  Actuator3-69 Down Limit	[E-0369 3:7 0369017]
  Actuator4-00 MON PARA	[E-0400 0:0 0400009]
  Actuator4-00 MON HYB	[E-0400 0:1 0400008]
  Actuator4-00 MON Position	[E-0400 0:2 0400007]
  Actuator4-00 MON Force	[E-0400 0:3 0400006]
  Actuator4-00 Drive Off	[E-0400 0:4 0400005]
  Actuator4-00 Drive On	[E-0400 0:5 0400004]
  Actuator4-00 CONT Position	[E-0400 0:6 0400003]
  Actuator4-00 CONT Force	[E-0400 0:7 0400002]
  Actuator4-00 Alarm Reset	[E-0400 1:1 0400020]
  Actuator4-00 Limit Release	[E-0400 1:2 040001F]
  Actuator4-00 Selected Step	[E-0400 1:3 040000E]
  Actuator4-00 Selected Load	[E-0400 1:4 040000D]
  Actuator4-00 Selected Drive	[E-0400 1:5 040000C]
  Actuator4-00 Maunakea	[E-0400 1:6 040000B]
  Actuator4-00 Sea Level	[E-0400 1:7 040000A]
  Actuator4-00 Up Limit	[E-0400 2:0 0400016]
  Actuator4-00 Driver Alarm	[E-0400 2:1 0400015]
  Actuator4-00 Error Alarm	[E-0400 2:2 0400014]
  Actuator4-00 Over Current	[E-0400 2:3 0400013]
  Actuator4-00 Over Speed	[E-0400 2:4 0400012]
  Actuator4-00 Over Load	[E-0400 2:5 0400011]
  Actuator4-00 PS Alarm	[E-0400 2:6 0400010]
  Actuator4-00 ENC Alarm	[E-0400 2:7 040000F]
  Actuator4-00 CPU Alarm	[E-0400 3:0 040001E]
  Actuator4-00 UART Alarm	[E-0400 3:1 040001D]
  Actuator4-00 HDLC Alarm	[E-0400 3:2 040001C]
  Actuator4-00 Force Card Fault	[E-0400 3:3 040001B]
  Actuator4-00 Force Sensor Fault	[E-0400 3:4 040001A]
  Actuator4-00 Under Range	[E-0400 3:5 0400019]
  Actuator4-00 Over Range	[E-0400 3:6 0400018]
  Actuator4-00 Down Limit	[E-0400 3:7 0400017]
  Actuator4-01 MON PARA	[E-0401 0:0 0401009]
  Actuator4-01 MON HYB	[E-0401 0:1 0401008]
  Actuator4-01 MON Position	[E-0401 0:2 0401007]
  Actuator4-01 MON Force	[E-0401 0:3 0401006]
  Actuator4-01 Drive Off	[E-0401 0:4 0401005]
  Actuator4-01 Drive On	[E-0401 0:5 0401004]
  Actuator4-01 CONT Position	[E-0401 0:6 0401003]
  Actuator4-01 CONT Force	[E-0401 0:7 0401002]
  Actuator4-01 Alarm Reset	[E-0401 1:1 0401020]
  Actuator4-01 Limit Release	[E-0401 1:2 040101F]
  Actuator4-01 Selected Step	[E-0401 1:3 040100E]
  Actuator4-01 Selected Load	[E-0401 1:4 040100D]
  Actuator4-01 Selected Drive	[E-0401 1:5 040100C]
  Actuator4-01 Maunakea	[E-0401 1:6 040100B]
  Actuator4-01 Sea Level	[E-0401 1:7 040100A]
  Actuator4-01 Up Limit	[E-0401 2:0 0401016]
  Actuator4-01 Driver Alarm	[E-0401 2:1 0401015]
  Actuator4-01 Error Alarm	[E-0401 2:2 0401014]
  Actuator4-01 Over Current	[E-0401 2:3 0401013]
  Actuator4-01 Over Speed	[E-0401 2:4 0401012]
  Actuator4-01 Over Load	[E-0401 2:5 0401011]
  Actuator4-01 PS Alarm	[E-0401 2:6 0401010]
  Actuator4-01 ENC Alarm	[E-0401 2:7 040100F]
  Actuator4-01 CPU Alarm	[E-0401 3:0 040101E]
  Actuator4-01 UART Alarm	[E-0401 3:1 040101D]
  Actuator4-01 HDLC Alarm	[E-0401 3:2 040101C]
  Actuator4-01 Force Card Fault	[E-0401 3:3 040101B]
  Actuator4-01 Force Sensor Fault	[E-0401 3:4 040101A]
  Actuator4-01 Under Range	[E-0401 3:5 0401019]
  Actuator4-01 Over Range	[E-0401 3:6 0401018]
  Actuator4-01 Down Limit	[E-0401 3:7 0401017]
  Actuator4-02 MON PARA	[E-0402 0:0 0402009]
  Actuator4-02 MON HYB	[E-0402 0:1 0402008]
  Actuator4-02 MON Position	[E-0402 0:2 0402007]
  Actuator4-02 MON Force	[E-0402 0:3 0402006]
  Actuator4-02 Drive Off	[E-0402 0:4 0402005]
  Actuator4-02 Drive On	[E-0402 0:5 0402004]
  Actuator4-02 CONT Position	[E-0402 0:6 0402003]
  Actuator4-02 CONT Force	[E-0402 0:7 0402002]
  Actuator4-02 Alarm Reset	[E-0402 1:1 0402020]
  Actuator4-02 Limit Release	[E-0402 1:2 040201F]
  Actuator4-02 Selected Step	[E-0402 1:3 040200E]
  Actuator4-02 Selected Load	[E-0402 1:4 040200D]
  Actuator4-02 Selected Drive	[E-0402 1:5 040200C]
  Actuator4-02 Maunakea	[E-0402 1:6 040200B]
  Actuator4-02 Sea Level	[E-0402 1:7 040200A]
  Actuator4-02 Up Limit	[E-0402 2:0 0402016]
  Actuator4-02 Driver Alarm	[E-0402 2:1 0402015]
  Actuator4-02 Error Alarm	[E-0402 2:2 0402014]
  Actuator4-02 Over Current	[E-0402 2:3 0402013]
  Actuator4-02 Over Speed	[E-0402 2:4 0402012]
  Actuator4-02 Over Load	[E-0402 2:5 0402011]
  Actuator4-02 PS Alarm	[E-0402 2:6 0402010]
  Actuator4-02 ENC Alarm	[E-0402 2:7 040200F]
  Actuator4-02 CPU Alarm	[E-0402 3:0 040201E]
  Actuator4-02 UART Alarm	[E-0402 3:1 040201D]
  Actuator4-02 HDLC Alarm	[E-0402 3:2 040201C]
  Actuator4-02 Force Card Fault	[E-0402 3:3 040201B]
  Actuator4-02 Force Sensor Fault	[E-0402 3:4 040201A]
  Actuator4-02 Under Range	[E-0402 3:5 0402019]
  Actuator4-02 Over Range	[E-0402 3:6 0402018]
  Actuator4-02 Down Limit	[E-0402 3:7 0402017]
  Actuator4-03 MON PARA	[E-0403 0:0 0403009]
  Actuator4-03 MON HYB	[E-0403 0:1 0403008]
  Actuator4-03 MON Position	[E-0403 0:2 0403007]
  Actuator4-03 MON Force	[E-0403 0:3 0403006]
  Actuator4-03 Drive Off	[E-0403 0:4 0403005]
  Actuator4-03 Drive On	[E-0403 0:5 0403004]
  Actuator4-03 CONT Position	[E-0403 0:6 0403003]
  Actuator4-03 CONT Force	[E-0403 0:7 0403002]
  Actuator4-03 Alarm Reset	[E-0403 1:1 0403020]
  Actuator4-03 Limit Release	[E-0403 1:2 040301F]
  Actuator4-03 Selected Step	[E-0403 1:3 040300E]
  Actuator4-03 Selected Load	[E-0403 1:4 040300D]
  Actuator4-03 Selected Drive	[E-0403 1:5 040300C]
  Actuator4-03 Maunakea	[E-0403 1:6 040300B]
  Actuator4-03 Sea Level	[E-0403 1:7 040300A]
  Actuator4-03 Up Limit	[E-0403 2:0 0403016]
  Actuator4-03 Driver Alarm	[E-0403 2:1 0403015]
  Actuator4-03 Error Alarm	[E-0403 2:2 0403014]
  Actuator4-03 Over Current	[E-0403 2:3 0403013]
  Actuator4-03 Over Speed	[E-0403 2:4 0403012]
  Actuator4-03 Over Load	[E-0403 2:5 0403011]
  Actuator4-03 PS Alarm	[E-0403 2:6 0403010]
  Actuator4-03 ENC Alarm	[E-0403 2:7 040300F]
  Actuator4-03 CPU Alarm	[E-0403 3:0 040301E]
  Actuator4-03 UART Alarm	[E-0403 3:1 040301D]
  Actuator4-03 HDLC Alarm	[E-0403 3:2 040301C]
  Actuator4-03 Force Card Fault	[E-0403 3:3 040301B]
  Actuator4-03 Force Sensor Fault	[E-0403 3:4 040301A]
  Actuator4-03 Under Range	[E-0403 3:5 0403019]
  Actuator4-03 Over Range	[E-0403 3:6 0403018]
  Actuator4-03 Down Limit	[E-0403 3:7 0403017]
  Actuator4-04 MON PARA	[E-0404 0:0 0404009]
  Actuator4-04 MON HYB	[E-0404 0:1 0404008]
  Actuator4-04 MON Position	[E-0404 0:2 0404007]
  Actuator4-04 MON Force	[E-0404 0:3 0404006]
  Actuator4-04 Drive Off	[E-0404 0:4 0404005]
  Actuator4-04 Drive On	[E-0404 0:5 0404004]
  Actuator4-04 CONT Position	[E-0404 0:6 0404003]
  Actuator4-04 CONT Force	[E-0404 0:7 0404002]
  Actuator4-04 Alarm Reset	[E-0404 1:1 0404020]
  Actuator4-04 Limit Release	[E-0404 1:2 040401F]
  Actuator4-04 Selected Step	[E-0404 1:3 040400E]
  Actuator4-04 Selected Load	[E-0404 1:4 040400D]
  Actuator4-04 Selected Drive	[E-0404 1:5 040400C]
  Actuator4-04 Maunakea	[E-0404 1:6 040400B]
  Actuator4-04 Sea Level	[E-0404 1:7 040400A]
  Actuator4-04 Up Limit	[E-0404 2:0 0404016]
  Actuator4-04 Driver Alarm	[E-0404 2:1 0404015]
  Actuator4-04 Error Alarm	[E-0404 2:2 0404014]
  Actuator4-04 Over Current	[E-0404 2:3 0404013]
  Actuator4-04 Over Speed	[E-0404 2:4 0404012]
  Actuator4-04 Over Load	[E-0404 2:5 0404011]
  Actuator4-04 PS Alarm	[E-0404 2:6 0404010]
  Actuator4-04 ENC Alarm	[E-0404 2:7 040400F]
  Actuator4-04 CPU Alarm	[E-0404 3:0 040401E]
  Actuator4-04 UART Alarm	[E-0404 3:1 040401D]
  Actuator4-04 HDLC Alarm	[E-0404 3:2 040401C]
  Actuator4-04 Force Card Fault	[E-0404 3:3 040401B]
  Actuator4-04 Force Sensor Fault	[E-0404 3:4 040401A]
  Actuator4-04 Under Range	[E-0404 3:5 0404019]
  Actuator4-04 Over Range	[E-0404 3:6 0404018]
  Actuator4-04 Down Limit	[E-0404 3:7 0404017]
  Actuator4-05 MON PARA	[E-0405 0:0 0405009]
  Actuator4-05 MON HYB	[E-0405 0:1 0405008]
  Actuator4-05 MON Position	[E-0405 0:2 0405007]
  Actuator4-05 MON Force	[E-0405 0:3 0405006]
  Actuator4-05 Drive Off	[E-0405 0:4 0405005]
  Actuator4-05 Drive On	[E-0405 0:5 0405004]
  Actuator4-05 CONT Position	[E-0405 0:6 0405003]
  Actuator4-05 CONT Force	[E-0405 0:7 0405002]
  Actuator4-05 Alarm Reset	[E-0405 1:1 0405020]
  Actuator4-05 Limit Release	[E-0405 1:2 040501F]
  Actuator4-05 Selected Step	[E-0405 1:3 040500E]
  Actuator4-05 Selected Load	[E-0405 1:4 040500D]
  Actuator4-05 Selected Drive	[E-0405 1:5 040500C]
  Actuator4-05 Maunakea	[E-0405 1:6 040500B]
  Actuator4-05 Sea Level	[E-0405 1:7 040500A]
  Actuator4-05 Up Limit	[E-0405 2:0 0405016]
  Actuator4-05 Driver Alarm	[E-0405 2:1 0405015]
  Actuator4-05 Error Alarm	[E-0405 2:2 0405014]
  Actuator4-05 Over Current	[E-0405 2:3 0405013]
  Actuator4-05 Over Speed	[E-0405 2:4 0405012]
  Actuator4-05 Over Load	[E-0405 2:5 0405011]
  Actuator4-05 PS Alarm	[E-0405 2:6 0405010]
  Actuator4-05 ENC Alarm	[E-0405 2:7 040500F]
  Actuator4-05 CPU Alarm	[E-0405 3:0 040501E]
  Actuator4-05 UART Alarm	[E-0405 3:1 040501D]
  Actuator4-05 HDLC Alarm	[E-0405 3:2 040501C]
  Actuator4-05 Force Card Fault	[E-0405 3:3 040501B]
  Actuator4-05 Force Sensor Fault	[E-0405 3:4 040501A]
  Actuator4-05 Under Range	[E-0405 3:5 0405019]
  Actuator4-05 Over Range	[E-0405 3:6 0405018]
  Actuator4-05 Down Limit	[E-0405 3:7 0405017]
  Actuator4-06 MON PARA	[E-0406 0:0 0406009]
  Actuator4-06 MON HYB	[E-0406 0:1 0406008]
  Actuator4-06 MON Position	[E-0406 0:2 0406007]
  Actuator4-06 MON Force	[E-0406 0:3 0406006]
  Actuator4-06 Drive Off	[E-0406 0:4 0406005]
  Actuator4-06 Drive On	[E-0406 0:5 0406004]
  Actuator4-06 CONT Position	[E-0406 0:6 0406003]
  Actuator4-06 CONT Force	[E-0406 0:7 0406002]
  Actuator4-06 Alarm Reset	[E-0406 1:1 0406020]
  Actuator4-06 Limit Release	[E-0406 1:2 040601F]
  Actuator4-06 Selected Step	[E-0406 1:3 040600E]
  Actuator4-06 Selected Load	[E-0406 1:4 040600D]
  Actuator4-06 Selected Drive	[E-0406 1:5 040600C]
  Actuator4-06 Maunakea	[E-0406 1:6 040600B]
  Actuator4-06 Sea Level	[E-0406 1:7 040600A]
  Actuator4-06 Up Limit	[E-0406 2:0 0406016]
  Actuator4-06 Driver Alarm	[E-0406 2:1 0406015]
  Actuator4-06 Error Alarm	[E-0406 2:2 0406014]
  Actuator4-06 Over Current	[E-0406 2:3 0406013]
  Actuator4-06 Over Speed	[E-0406 2:4 0406012]
  Actuator4-06 Over Load	[E-0406 2:5 0406011]
  Actuator4-06 PS Alarm	[E-0406 2:6 0406010]
  Actuator4-06 ENC Alarm	[E-0406 2:7 040600F]
  Actuator4-06 CPU Alarm	[E-0406 3:0 040601E]
  Actuator4-06 UART Alarm	[E-0406 3:1 040601D]
  Actuator4-06 HDLC Alarm	[E-0406 3:2 040601C]
  Actuator4-06 Force Card Fault	[E-0406 3:3 040601B]
  Actuator4-06 Force Sensor Fault	[E-0406 3:4 040601A]
  Actuator4-06 Under Range	[E-0406 3:5 0406019]
  Actuator4-06 Over Range	[E-0406 3:6 0406018]
  Actuator4-06 Down Limit	[E-0406 3:7 0406017]
  Actuator4-07 MON PARA	[E-0407 0:0 0407009]
  Actuator4-07 MON HYB	[E-0407 0:1 0407008]
  Actuator4-07 MON Position	[E-0407 0:2 0407007]
  Actuator4-07 MON Force	[E-0407 0:3 0407006]
  Actuator4-07 Drive Off	[E-0407 0:4 0407005]
  Actuator4-07 Drive On	[E-0407 0:5 0407004]
  Actuator4-07 CONT Position	[E-0407 0:6 0407003]
  Actuator4-07 CONT Force	[E-0407 0:7 0407002]
  Actuator4-07 Alarm Reset	[E-0407 1:1 0407020]
  Actuator4-07 Limit Release	[E-0407 1:2 040701F]
  Actuator4-07 Selected Step	[E-0407 1:3 040700E]
  Actuator4-07 Selected Load	[E-0407 1:4 040700D]
  Actuator4-07 Selected Drive	[E-0407 1:5 040700C]
  Actuator4-07 Maunakea	[E-0407 1:6 040700B]
  Actuator4-07 Sea Level	[E-0407 1:7 040700A]
  Actuator4-07 Up Limit	[E-0407 2:0 0407016]
  Actuator4-07 Driver Alarm	[E-0407 2:1 0407015]
  Actuator4-07 Error Alarm	[E-0407 2:2 0407014]
  Actuator4-07 Over Current	[E-0407 2:3 0407013]
  Actuator4-07 Over Speed	[E-0407 2:4 0407012]
  Actuator4-07 Over Load	[E-0407 2:5 0407011]
  Actuator4-07 PS Alarm	[E-0407 2:6 0407010]
  Actuator4-07 ENC Alarm	[E-0407 2:7 040700F]
  Actuator4-07 CPU Alarm	[E-0407 3:0 040701E]
  Actuator4-07 UART Alarm	[E-0407 3:1 040701D]
  Actuator4-07 HDLC Alarm	[E-0407 3:2 040701C]
  Actuator4-07 Force Card Fault	[E-0407 3:3 040701B]
  Actuator4-07 Force Sensor Fault	[E-0407 3:4 040701A]
  Actuator4-07 Under Range	[E-0407 3:5 0407019]
  Actuator4-07 Over Range	[E-0407 3:6 0407018]
  Actuator4-07 Down Limit	[E-0407 3:7 0407017]
  Actuator4-08 MON PARA	[E-0408 0:0 0408009]
  Actuator4-08 MON HYB	[E-0408 0:1 0408008]
  Actuator4-08 MON Position	[E-0408 0:2 0408007]
  Actuator4-08 MON Force	[E-0408 0:3 0408006]
  Actuator4-08 Drive Off	[E-0408 0:4 0408005]
  Actuator4-08 Drive On	[E-0408 0:5 0408004]
  Actuator4-08 CONT Position	[E-0408 0:6 0408003]
  Actuator4-08 CONT Force	[E-0408 0:7 0408002]
  Actuator4-08 Alarm Reset	[E-0408 1:1 0408020]
  Actuator4-08 Limit Release	[E-0408 1:2 040801F]
  Actuator4-08 Selected Step	[E-0408 1:3 040800E]
  Actuator4-08 Selected Load	[E-0408 1:4 040800D]
  Actuator4-08 Selected Drive	[E-0408 1:5 040800C]
  Actuator4-08 Maunakea	[E-0408 1:6 040800B]
  Actuator4-08 Sea Level	[E-0408 1:7 040800A]
  Actuator4-08 Up Limit	[E-0408 2:0 0408016]
  Actuator4-08 Driver Alarm	[E-0408 2:1 0408015]
  Actuator4-08 Error Alarm	[E-0408 2:2 0408014]
  Actuator4-08 Over Current	[E-0408 2:3 0408013]
  Actuator4-08 Over Speed	[E-0408 2:4 0408012]
  Actuator4-08 Over Load	[E-0408 2:5 0408011]
  Actuator4-08 PS Alarm	[E-0408 2:6 0408010]
  Actuator4-08 ENC Alarm	[E-0408 2:7 040800F]
  Actuator4-08 CPU Alarm	[E-0408 3:0 040801E]
  Actuator4-08 UART Alarm	[E-0408 3:1 040801D]
  Actuator4-08 HDLC Alarm	[E-0408 3:2 040801C]
  Actuator4-08 Force Card Fault	[E-0408 3:3 040801B]
  Actuator4-08 Force Sensor Fault	[E-0408 3:4 040801A]
  Actuator4-08 Under Range	[E-0408 3:5 0408019]
  Actuator4-08 Over Range	[E-0408 3:6 0408018]
  Actuator4-08 Down Limit	[E-0408 3:7 0408017]
  Actuator4-09 MON PARA	[E-0409 0:0 0409009]
  Actuator4-09 MON HYB	[E-0409 0:1 0409008]
  Actuator4-09 MON Position	[E-0409 0:2 0409007]
  Actuator4-09 MON Force	[E-0409 0:3 0409006]
  Actuator4-09 Drive Off	[E-0409 0:4 0409005]
  Actuator4-09 Drive On	[E-0409 0:5 0409004]
  Actuator4-09 CONT Position	[E-0409 0:6 0409003]
  Actuator4-09 CONT Force	[E-0409 0:7 0409002]
  Actuator4-09 Alarm Reset	[E-0409 1:1 0409020]
  Actuator4-09 Limit Release	[E-0409 1:2 040901F]
  Actuator4-09 Selected Step	[E-0409 1:3 040900E]
  Actuator4-09 Selected Load	[E-0409 1:4 040900D]
  Actuator4-09 Selected Drive	[E-0409 1:5 040900C]
  Actuator4-09 Maunakea	[E-0409 1:6 040900B]
  Actuator4-09 Sea Level	[E-0409 1:7 040900A]
  Actuator4-09 Up Limit	[E-0409 2:0 0409016]
  Actuator4-09 Driver Alarm	[E-0409 2:1 0409015]
  Actuator4-09 Error Alarm	[E-0409 2:2 0409014]
  Actuator4-09 Over Current	[E-0409 2:3 0409013]
  Actuator4-09 Over Speed	[E-0409 2:4 0409012]
  Actuator4-09 Over Load	[E-0409 2:5 0409011]
  Actuator4-09 PS Alarm	[E-0409 2:6 0409010]
  Actuator4-09 ENC Alarm	[E-0409 2:7 040900F]
  Actuator4-09 CPU Alarm	[E-0409 3:0 040901E]
  Actuator4-09 UART Alarm	[E-0409 3:1 040901D]
  Actuator4-09 HDLC Alarm	[E-0409 3:2 040901C]
  Actuator4-09 Force Card Fault	[E-0409 3:3 040901B]
  Actuator4-09 Force Sensor Fault	[E-0409 3:4 040901A]
  Actuator4-09 Under Range	[E-0409 3:5 0409019]
  Actuator4-09 Over Range	[E-0409 3:6 0409018]
  Actuator4-09 Down Limit	[E-0409 3:7 0409017]
  Actuator4-10 MON PARA	[E-0410 0:0 0410009]
  Actuator4-10 MON HYB	[E-0410 0:1 0410008]
  Actuator4-10 MON Position	[E-0410 0:2 0410007]
  Actuator4-10 MON Force	[E-0410 0:3 0410006]
  Actuator4-10 Drive Off	[E-0410 0:4 0410005]
  Actuator4-10 Drive On	[E-0410 0:5 0410004]
  Actuator4-10 CONT Position	[E-0410 0:6 0410003]
  Actuator4-10 CONT Force	[E-0410 0:7 0410002]
  Actuator4-10 Alarm Reset	[E-0410 1:1 0410020]
  Actuator4-10 Limit Release	[E-0410 1:2 041001F]
  Actuator4-10 Selected Step	[E-0410 1:3 041000E]
  Actuator4-10 Selected Load	[E-0410 1:4 041000D]
  Actuator4-10 Selected Drive	[E-0410 1:5 041000C]
  Actuator4-10 Maunakea	[E-0410 1:6 041000B]
  Actuator4-10 Sea Level	[E-0410 1:7 041000A]
  Actuator4-10 Up Limit	[E-0410 2:0 0410016]
  Actuator4-10 Driver Alarm	[E-0410 2:1 0410015]
  Actuator4-10 Error Alarm	[E-0410 2:2 0410014]
  Actuator4-10 Over Current	[E-0410 2:3 0410013]
  Actuator4-10 Over Speed	[E-0410 2:4 0410012]
  Actuator4-10 Over Load	[E-0410 2:5 0410011]
  Actuator4-10 PS Alarm	[E-0410 2:6 0410010]
  Actuator4-10 ENC Alarm	[E-0410 2:7 041000F]
  Actuator4-10 CPU Alarm	[E-0410 3:0 041001E]
  Actuator4-10 UART Alarm	[E-0410 3:1 041001D]
  Actuator4-10 HDLC Alarm	[E-0410 3:2 041001C]
  Actuator4-10 Force Card Fault	[E-0410 3:3 041001B]
  Actuator4-10 Force Sensor Fault	[E-0410 3:4 041001A]
  Actuator4-10 Under Range	[E-0410 3:5 0410019]
  Actuator4-10 Over Range	[E-0410 3:6 0410018]
  Actuator4-10 Down Limit	[E-0410 3:7 0410017]
  Actuator4-11 MON PARA	[E-0411 0:0 0411009]
  Actuator4-11 MON HYB	[E-0411 0:1 0411008]
  Actuator4-11 MON Position	[E-0411 0:2 0411007]
  Actuator4-11 MON Force	[E-0411 0:3 0411006]
  Actuator4-11 Drive Off	[E-0411 0:4 0411005]
  Actuator4-11 Drive On	[E-0411 0:5 0411004]
  Actuator4-11 CONT Position	[E-0411 0:6 0411003]
  Actuator4-11 CONT Force	[E-0411 0:7 0411002]
  Actuator4-11 Alarm Reset	[E-0411 1:1 0411020]
  Actuator4-11 Limit Release	[E-0411 1:2 041101F]
  Actuator4-11 Selected Step	[E-0411 1:3 041100E]
  Actuator4-11 Selected Load	[E-0411 1:4 041100D]
  Actuator4-11 Selected Drive	[E-0411 1:5 041100C]
  Actuator4-11 Maunakea	[E-0411 1:6 041100B]
  Actuator4-11 Sea Level	[E-0411 1:7 041100A]
  Actuator4-11 Up Limit	[E-0411 2:0 0411016]
  Actuator4-11 Driver Alarm	[E-0411 2:1 0411015]
  Actuator4-11 Error Alarm	[E-0411 2:2 0411014]
  Actuator4-11 Over Current	[E-0411 2:3 0411013]
  Actuator4-11 Over Speed	[E-0411 2:4 0411012]
  Actuator4-11 Over Load	[E-0411 2:5 0411011]
  Actuator4-11 PS Alarm	[E-0411 2:6 0411010]
  Actuator4-11 ENC Alarm	[E-0411 2:7 041100F]
  Actuator4-11 CPU Alarm	[E-0411 3:0 041101E]
  Actuator4-11 UART Alarm	[E-0411 3:1 041101D]
  Actuator4-11 HDLC Alarm	[E-0411 3:2 041101C]
  Actuator4-11 Force Card Fault	[E-0411 3:3 041101B]
  Actuator4-11 Force Sensor Fault	[E-0411 3:4 041101A]
  Actuator4-11 Under Range	[E-0411 3:5 0411019]
  Actuator4-11 Over Range	[E-0411 3:6 0411018]
  Actuator4-11 Down Limit	[E-0411 3:7 0411017]
  Actuator4-12 MON PARA	[E-0412 0:0 0412009]
  Actuator4-12 MON HYB	[E-0412 0:1 0412008]
  Actuator4-12 MON Position	[E-0412 0:2 0412007]
  Actuator4-12 MON Force	[E-0412 0:3 0412006]
  Actuator4-12 Drive Off	[E-0412 0:4 0412005]
  Actuator4-12 Drive On	[E-0412 0:5 0412004]
  Actuator4-12 CONT Position	[E-0412 0:6 0412003]
  Actuator4-12 CONT Force	[E-0412 0:7 0412002]
  Actuator4-12 Alarm Reset	[E-0412 1:1 0412020]
  Actuator4-12 Limit Release	[E-0412 1:2 041201F]
  Actuator4-12 Selected Step	[E-0412 1:3 041200E]
  Actuator4-12 Selected Load	[E-0412 1:4 041200D]
  Actuator4-12 Selected Drive	[E-0412 1:5 041200C]
  Actuator4-12 Maunakea	[E-0412 1:6 041200B]
  Actuator4-12 Sea Level	[E-0412 1:7 041200A]
  Actuator4-12 Up Limit	[E-0412 2:0 0412016]
  Actuator4-12 Driver Alarm	[E-0412 2:1 0412015]
  Actuator4-12 Error Alarm	[E-0412 2:2 0412014]
  Actuator4-12 Over Current	[E-0412 2:3 0412013]
  Actuator4-12 Over Speed	[E-0412 2:4 0412012]
  Actuator4-12 Over Load	[E-0412 2:5 0412011]
  Actuator4-12 PS Alarm	[E-0412 2:6 0412010]
  Actuator4-12 ENC Alarm	[E-0412 2:7 041200F]
  Actuator4-12 CPU Alarm	[E-0412 3:0 041201E]
  Actuator4-12 UART Alarm	[E-0412 3:1 041201D]
  Actuator4-12 HDLC Alarm	[E-0412 3:2 041201C]
  Actuator4-12 Force Card Fault	[E-0412 3:3 041201B]
  Actuator4-12 Force Sensor Fault	[E-0412 3:4 041201A]
  Actuator4-12 Under Range	[E-0412 3:5 0412019]
  Actuator4-12 Over Range	[E-0412 3:6 0412018]
  Actuator4-12 Down Limit	[E-0412 3:7 0412017]
  Actuator4-13 MON PARA	[E-0413 0:0 0413009]
  Actuator4-13 MON HYB	[E-0413 0:1 0413008]
  Actuator4-13 MON Position	[E-0413 0:2 0413007]
  Actuator4-13 MON Force	[E-0413 0:3 0413006]
  Actuator4-13 Drive Off	[E-0413 0:4 0413005]
  Actuator4-13 Drive On	[E-0413 0:5 0413004]
  Actuator4-13 CONT Position	[E-0413 0:6 0413003]
  Actuator4-13 CONT Force	[E-0413 0:7 0413002]
  Actuator4-13 Alarm Reset	[E-0413 1:1 0413020]
  Actuator4-13 Limit Release	[E-0413 1:2 041301F]
  Actuator4-13 Selected Step	[E-0413 1:3 041300E]
  Actuator4-13 Selected Load	[E-0413 1:4 041300D]
  Actuator4-13 Selected Drive	[E-0413 1:5 041300C]
  Actuator4-13 Maunakea	[E-0413 1:6 041300B]
  Actuator4-13 Sea Level	[E-0413 1:7 041300A]
  Actuator4-13 Up Limit	[E-0413 2:0 0413016]
  Actuator4-13 Driver Alarm	[E-0413 2:1 0413015]
  Actuator4-13 Error Alarm	[E-0413 2:2 0413014]
  Actuator4-13 Over Current	[E-0413 2:3 0413013]
  Actuator4-13 Over Speed	[E-0413 2:4 0413012]
  Actuator4-13 Over Load	[E-0413 2:5 0413011]
  Actuator4-13 PS Alarm	[E-0413 2:6 0413010]
  Actuator4-13 ENC Alarm	[E-0413 2:7 041300F]
  Actuator4-13 CPU Alarm	[E-0413 3:0 041301E]
  Actuator4-13 UART Alarm	[E-0413 3:1 041301D]
  Actuator4-13 HDLC Alarm	[E-0413 3:2 041301C]
  Actuator4-13 Force Card Fault	[E-0413 3:3 041301B]
  Actuator4-13 Force Sensor Fault	[E-0413 3:4 041301A]
  Actuator4-13 Under Range	[E-0413 3:5 0413019]
  Actuator4-13 Over Range	[E-0413 3:6 0413018]
  Actuator4-13 Down Limit	[E-0413 3:7 0413017]
  Actuator4-14 MON PARA	[E-0414 0:0 0414009]
  Actuator4-14 MON HYB	[E-0414 0:1 0414008]
  Actuator4-14 MON Position	[E-0414 0:2 0414007]
  Actuator4-14 MON Force	[E-0414 0:3 0414006]
  Actuator4-14 Drive Off	[E-0414 0:4 0414005]
  Actuator4-14 Drive On	[E-0414 0:5 0414004]
  Actuator4-14 CONT Position	[E-0414 0:6 0414003]
  Actuator4-14 CONT Force	[E-0414 0:7 0414002]
  Actuator4-14 Alarm Reset	[E-0414 1:1 0414020]
  Actuator4-14 Limit Release	[E-0414 1:2 041401F]
  Actuator4-14 Selected Step	[E-0414 1:3 041400E]
  Actuator4-14 Selected Load	[E-0414 1:4 041400D]
  Actuator4-14 Selected Drive	[E-0414 1:5 041400C]
  Actuator4-14 Maunakea	[E-0414 1:6 041400B]
  Actuator4-14 Sea Level	[E-0414 1:7 041400A]
  Actuator4-14 Up Limit	[E-0414 2:0 0414016]
  Actuator4-14 Driver Alarm	[E-0414 2:1 0414015]
  Actuator4-14 Error Alarm	[E-0414 2:2 0414014]
  Actuator4-14 Over Current	[E-0414 2:3 0414013]
  Actuator4-14 Over Speed	[E-0414 2:4 0414012]
  Actuator4-14 Over Load	[E-0414 2:5 0414011]
  Actuator4-14 PS Alarm	[E-0414 2:6 0414010]
  Actuator4-14 ENC Alarm	[E-0414 2:7 041400F]
  Actuator4-14 CPU Alarm	[E-0414 3:0 041401E]
  Actuator4-14 UART Alarm	[E-0414 3:1 041401D]
  Actuator4-14 HDLC Alarm	[E-0414 3:2 041401C]
  Actuator4-14 Force Card Fault	[E-0414 3:3 041401B]
  Actuator4-14 Force Sensor Fault	[E-0414 3:4 041401A]
  Actuator4-14 Under Range	[E-0414 3:5 0414019]
  Actuator4-14 Over Range	[E-0414 3:6 0414018]
  Actuator4-14 Down Limit	[E-0414 3:7 0414017]
  Actuator4-15 MON PARA	[E-0415 0:0 0415009]
  Actuator4-15 MON HYB	[E-0415 0:1 0415008]
  Actuator4-15 MON Position	[E-0415 0:2 0415007]
  Actuator4-15 MON Force	[E-0415 0:3 0415006]
  Actuator4-15 Drive Off	[E-0415 0:4 0415005]
  Actuator4-15 Drive On	[E-0415 0:5 0415004]
  Actuator4-15 CONT Position	[E-0415 0:6 0415003]
  Actuator4-15 CONT Force	[E-0415 0:7 0415002]
  Actuator4-15 Alarm Reset	[E-0415 1:1 0415020]
  Actuator4-15 Limit Release	[E-0415 1:2 041501F]
  Actuator4-15 Selected Step	[E-0415 1:3 041500E]
  Actuator4-15 Selected Load	[E-0415 1:4 041500D]
  Actuator4-15 Selected Drive	[E-0415 1:5 041500C]
  Actuator4-15 Maunakea	[E-0415 1:6 041500B]
  Actuator4-15 Sea Level	[E-0415 1:7 041500A]
  Actuator4-15 Up Limit	[E-0415 2:0 0415016]
  Actuator4-15 Driver Alarm	[E-0415 2:1 0415015]
  Actuator4-15 Error Alarm	[E-0415 2:2 0415014]
  Actuator4-15 Over Current	[E-0415 2:3 0415013]
  Actuator4-15 Over Speed	[E-0415 2:4 0415012]
  Actuator4-15 Over Load	[E-0415 2:5 0415011]
  Actuator4-15 PS Alarm	[E-0415 2:6 0415010]
  Actuator4-15 ENC Alarm	[E-0415 2:7 041500F]
  Actuator4-15 CPU Alarm	[E-0415 3:0 041501E]
  Actuator4-15 UART Alarm	[E-0415 3:1 041501D]
  Actuator4-15 HDLC Alarm	[E-0415 3:2 041501C]
  Actuator4-15 Force Card Fault	[E-0415 3:3 041501B]
  Actuator4-15 Force Sensor Fault	[E-0415 3:4 041501A]
  Actuator4-15 Under Range	[E-0415 3:5 0415019]
  Actuator4-15 Over Range	[E-0415 3:6 0415018]
  Actuator4-15 Down Limit	[E-0415 3:7 0415017]
  Actuator4-16 MON PARA	[E-0416 0:0 0416009]
  Actuator4-16 MON HYB	[E-0416 0:1 0416008]
  Actuator4-16 MON Position	[E-0416 0:2 0416007]
  Actuator4-16 MON Force	[E-0416 0:3 0416006]
  Actuator4-16 Drive Off	[E-0416 0:4 0416005]
  Actuator4-16 Drive On	[E-0416 0:5 0416004]
  Actuator4-16 CONT Position	[E-0416 0:6 0416003]
  Actuator4-16 CONT Force	[E-0416 0:7 0416002]
  Actuator4-16 Alarm Reset	[E-0416 1:1 0416020]
  Actuator4-16 Limit Release	[E-0416 1:2 041601F]
  Actuator4-16 Selected Step	[E-0416 1:3 041600E]
  Actuator4-16 Selected Load	[E-0416 1:4 041600D]
  Actuator4-16 Selected Drive	[E-0416 1:5 041600C]
  Actuator4-16 Maunakea	[E-0416 1:6 041600B]
  Actuator4-16 Sea Level	[E-0416 1:7 041600A]
  Actuator4-16 Up Limit	[E-0416 2:0 0416016]
  Actuator4-16 Driver Alarm	[E-0416 2:1 0416015]
  Actuator4-16 Error Alarm	[E-0416 2:2 0416014]
  Actuator4-16 Over Current	[E-0416 2:3 0416013]
  Actuator4-16 Over Speed	[E-0416 2:4 0416012]
  Actuator4-16 Over Load	[E-0416 2:5 0416011]
  Actuator4-16 PS Alarm	[E-0416 2:6 0416010]
  Actuator4-16 ENC Alarm	[E-0416 2:7 041600F]
  Actuator4-16 CPU Alarm	[E-0416 3:0 041601E]
  Actuator4-16 UART Alarm	[E-0416 3:1 041601D]
  Actuator4-16 HDLC Alarm	[E-0416 3:2 041601C]
  Actuator4-16 Force Card Fault	[E-0416 3:3 041601B]
  Actuator4-16 Force Sensor Fault	[E-0416 3:4 041601A]
  Actuator4-16 Under Range	[E-0416 3:5 0416019]
  Actuator4-16 Over Range	[E-0416 3:6 0416018]
  Actuator4-16 Down Limit	[E-0416 3:7 0416017]
  Actuator4-17 MON PARA	[E-0417 0:0 0417009]
  Actuator4-17 MON HYB	[E-0417 0:1 0417008]
  Actuator4-17 MON Position	[E-0417 0:2 0417007]
  Actuator4-17 MON Force	[E-0417 0:3 0417006]
  Actuator4-17 Drive Off	[E-0417 0:4 0417005]
  Actuator4-17 Drive On	[E-0417 0:5 0417004]
  Actuator4-17 CONT Position	[E-0417 0:6 0417003]
  Actuator4-17 CONT Force	[E-0417 0:7 0417002]
  Actuator4-17 Alarm Reset	[E-0417 1:1 0417020]
  Actuator4-17 Limit Release	[E-0417 1:2 041701F]
  Actuator4-17 Selected Step	[E-0417 1:3 041700E]
  Actuator4-17 Selected Load	[E-0417 1:4 041700D]
  Actuator4-17 Selected Drive	[E-0417 1:5 041700C]
  Actuator4-17 Maunakea	[E-0417 1:6 041700B]
  Actuator4-17 Sea Level	[E-0417 1:7 041700A]
  Actuator4-17 Up Limit	[E-0417 2:0 0417016]
  Actuator4-17 Driver Alarm	[E-0417 2:1 0417015]
  Actuator4-17 Error Alarm	[E-0417 2:2 0417014]
  Actuator4-17 Over Current	[E-0417 2:3 0417013]
  Actuator4-17 Over Speed	[E-0417 2:4 0417012]
  Actuator4-17 Over Load	[E-0417 2:5 0417011]
  Actuator4-17 PS Alarm	[E-0417 2:6 0417010]
  Actuator4-17 ENC Alarm	[E-0417 2:7 041700F]
  Actuator4-17 CPU Alarm	[E-0417 3:0 041701E]
  Actuator4-17 UART Alarm	[E-0417 3:1 041701D]
  Actuator4-17 HDLC Alarm	[E-0417 3:2 041701C]
  Actuator4-17 Force Card Fault	[E-0417 3:3 041701B]
  Actuator4-17 Force Sensor Fault	[E-0417 3:4 041701A]
  Actuator4-17 Under Range	[E-0417 3:5 0417019]
  Actuator4-17 Over Range	[E-0417 3:6 0417018]
  Actuator4-17 Down Limit	[E-0417 3:7 0417017]
  Actuator4-18 MON PARA	[E-0418 0:0 0418009]
  Actuator4-18 MON HYB	[E-0418 0:1 0418008]
  Actuator4-18 MON Position	[E-0418 0:2 0418007]
  Actuator4-18 MON Force	[E-0418 0:3 0418006]
  Actuator4-18 Drive Off	[E-0418 0:4 0418005]
  Actuator4-18 Drive On	[E-0418 0:5 0418004]
  Actuator4-18 CONT Position	[E-0418 0:6 0418003]
  Actuator4-18 CONT Force	[E-0418 0:7 0418002]
  Actuator4-18 Alarm Reset	[E-0418 1:1 0418020]
  Actuator4-18 Limit Release	[E-0418 1:2 041801F]
  Actuator4-18 Selected Step	[E-0418 1:3 041800E]
  Actuator4-18 Selected Load	[E-0418 1:4 041800D]
  Actuator4-18 Selected Drive	[E-0418 1:5 041800C]
  Actuator4-18 Maunakea	[E-0418 1:6 041800B]
  Actuator4-18 Sea Level	[E-0418 1:7 041800A]
  Actuator4-18 Up Limit	[E-0418 2:0 0418016]
  Actuator4-18 Driver Alarm	[E-0418 2:1 0418015]
  Actuator4-18 Error Alarm	[E-0418 2:2 0418014]
  Actuator4-18 Over Current	[E-0418 2:3 0418013]
  Actuator4-18 Over Speed	[E-0418 2:4 0418012]
  Actuator4-18 Over Load	[E-0418 2:5 0418011]
  Actuator4-18 PS Alarm	[E-0418 2:6 0418010]
  Actuator4-18 ENC Alarm	[E-0418 2:7 041800F]
  Actuator4-18 CPU Alarm	[E-0418 3:0 041801E]
  Actuator4-18 UART Alarm	[E-0418 3:1 041801D]
  Actuator4-18 HDLC Alarm	[E-0418 3:2 041801C]
  Actuator4-18 Force Card Fault	[E-0418 3:3 041801B]
  Actuator4-18 Force Sensor Fault	[E-0418 3:4 041801A]
  Actuator4-18 Under Range	[E-0418 3:5 0418019]
  Actuator4-18 Over Range	[E-0418 3:6 0418018]
  Actuator4-18 Down Limit	[E-0418 3:7 0418017]
  Actuator4-19 MON PARA	[E-0419 0:0 0419009]
  Actuator4-19 MON HYB	[E-0419 0:1 0419008]
  Actuator4-19 MON Position	[E-0419 0:2 0419007]
  Actuator4-19 MON Force	[E-0419 0:3 0419006]
  Actuator4-19 Drive Off	[E-0419 0:4 0419005]
  Actuator4-19 Drive On	[E-0419 0:5 0419004]
  Actuator4-19 CONT Position	[E-0419 0:6 0419003]
  Actuator4-19 CONT Force	[E-0419 0:7 0419002]
  Actuator4-19 Alarm Reset	[E-0419 1:1 0419020]
  Actuator4-19 Limit Release	[E-0419 1:2 041901F]
  Actuator4-19 Selected Step	[E-0419 1:3 041900E]
  Actuator4-19 Selected Load	[E-0419 1:4 041900D]
  Actuator4-19 Selected Drive	[E-0419 1:5 041900C]
  Actuator4-19 Maunakea	[E-0419 1:6 041900B]
  Actuator4-19 Sea Level	[E-0419 1:7 041900A]
  Actuator4-19 Up Limit	[E-0419 2:0 0419016]
  Actuator4-19 Driver Alarm	[E-0419 2:1 0419015]
  Actuator4-19 Error Alarm	[E-0419 2:2 0419014]
  Actuator4-19 Over Current	[E-0419 2:3 0419013]
  Actuator4-19 Over Speed	[E-0419 2:4 0419012]
  Actuator4-19 Over Load	[E-0419 2:5 0419011]
  Actuator4-19 PS Alarm	[E-0419 2:6 0419010]
  Actuator4-19 ENC Alarm	[E-0419 2:7 041900F]
  Actuator4-19 CPU Alarm	[E-0419 3:0 041901E]
  Actuator4-19 UART Alarm	[E-0419 3:1 041901D]
  Actuator4-19 HDLC Alarm	[E-0419 3:2 041901C]
  Actuator4-19 Force Card Fault	[E-0419 3:3 041901B]
  Actuator4-19 Force Sensor Fault	[E-0419 3:4 041901A]
  Actuator4-19 Under Range	[E-0419 3:5 0419019]
  Actuator4-19 Over Range	[E-0419 3:6 0419018]
  Actuator4-19 Down Limit	[E-0419 3:7 0419017]
  Actuator4-20 MON PARA	[E-0420 0:0 0420009]
  Actuator4-20 MON HYB	[E-0420 0:1 0420008]
  Actuator4-20 MON Position	[E-0420 0:2 0420007]
  Actuator4-20 MON Force	[E-0420 0:3 0420006]
  Actuator4-20 Drive Off	[E-0420 0:4 0420005]
  Actuator4-20 Drive On	[E-0420 0:5 0420004]
  Actuator4-20 CONT Position	[E-0420 0:6 0420003]
  Actuator4-20 CONT Force	[E-0420 0:7 0420002]
  Actuator4-20 Alarm Reset	[E-0420 1:1 0420020]
  Actuator4-20 Limit Release	[E-0420 1:2 042001F]
  Actuator4-20 Selected Step	[E-0420 1:3 042000E]
  Actuator4-20 Selected Load	[E-0420 1:4 042000D]
  Actuator4-20 Selected Drive	[E-0420 1:5 042000C]
  Actuator4-20 Maunakea	[E-0420 1:6 042000B]
  Actuator4-20 Sea Level	[E-0420 1:7 042000A]
  Actuator4-20 Up Limit	[E-0420 2:0 0420016]
  Actuator4-20 Driver Alarm	[E-0420 2:1 0420015]
  Actuator4-20 Error Alarm	[E-0420 2:2 0420014]
  Actuator4-20 Over Current	[E-0420 2:3 0420013]
  Actuator4-20 Over Speed	[E-0420 2:4 0420012]
  Actuator4-20 Over Load	[E-0420 2:5 0420011]
  Actuator4-20 PS Alarm	[E-0420 2:6 0420010]
  Actuator4-20 ENC Alarm	[E-0420 2:7 042000F]
  Actuator4-20 CPU Alarm	[E-0420 3:0 042001E]
  Actuator4-20 UART Alarm	[E-0420 3:1 042001D]
  Actuator4-20 HDLC Alarm	[E-0420 3:2 042001C]
  Actuator4-20 Force Card Fault	[E-0420 3:3 042001B]
  Actuator4-20 Force Sensor Fault	[E-0420 3:4 042001A]
  Actuator4-20 Under Range	[E-0420 3:5 0420019]
  Actuator4-20 Over Range	[E-0420 3:6 0420018]
  Actuator4-20 Down Limit	[E-0420 3:7 0420017]
  Actuator4-21 MON PARA	[E-0421 0:0 0421009]
  Actuator4-21 MON HYB	[E-0421 0:1 0421008]
  Actuator4-21 MON Position	[E-0421 0:2 0421007]
  Actuator4-21 MON Force	[E-0421 0:3 0421006]
  Actuator4-21 Drive Off	[E-0421 0:4 0421005]
  Actuator4-21 Drive On	[E-0421 0:5 0421004]
  Actuator4-21 CONT Position	[E-0421 0:6 0421003]
  Actuator4-21 CONT Force	[E-0421 0:7 0421002]
  Actuator4-21 Alarm Reset	[E-0421 1:1 0421020]
  Actuator4-21 Limit Release	[E-0421 1:2 042101F]
  Actuator4-21 Selected Step	[E-0421 1:3 042100E]
  Actuator4-21 Selected Load	[E-0421 1:4 042100D]
  Actuator4-21 Selected Drive	[E-0421 1:5 042100C]
  Actuator4-21 Maunakea	[E-0421 1:6 042100B]
  Actuator4-21 Sea Level	[E-0421 1:7 042100A]
  Actuator4-21 Up Limit	[E-0421 2:0 0421016]
  Actuator4-21 Driver Alarm	[E-0421 2:1 0421015]
  Actuator4-21 Error Alarm	[E-0421 2:2 0421014]
  Actuator4-21 Over Current	[E-0421 2:3 0421013]
  Actuator4-21 Over Speed	[E-0421 2:4 0421012]
  Actuator4-21 Over Load	[E-0421 2:5 0421011]
  Actuator4-21 PS Alarm	[E-0421 2:6 0421010]
  Actuator4-21 ENC Alarm	[E-0421 2:7 042100F]
  Actuator4-21 CPU Alarm	[E-0421 3:0 042101E]
  Actuator4-21 UART Alarm	[E-0421 3:1 042101D]
  Actuator4-21 HDLC Alarm	[E-0421 3:2 042101C]
  Actuator4-21 Force Card Fault	[E-0421 3:3 042101B]
  Actuator4-21 Force Sensor Fault	[E-0421 3:4 042101A]
  Actuator4-21 Under Range	[E-0421 3:5 0421019]
  Actuator4-21 Over Range	[E-0421 3:6 0421018]
  Actuator4-21 Down Limit	[E-0421 3:7 0421017]
  Actuator4-22 MON PARA	[E-0422 0:0 0422009]
  Actuator4-22 MON HYB	[E-0422 0:1 0422008]
  Actuator4-22 MON Position	[E-0422 0:2 0422007]
  Actuator4-22 MON Force	[E-0422 0:3 0422006]
  Actuator4-22 Drive Off	[E-0422 0:4 0422005]
  Actuator4-22 Drive On	[E-0422 0:5 0422004]
  Actuator4-22 CONT Position	[E-0422 0:6 0422003]
  Actuator4-22 CONT Force	[E-0422 0:7 0422002]
  Actuator4-22 Alarm Reset	[E-0422 1:1 0422020]
  Actuator4-22 Limit Release	[E-0422 1:2 042201F]
  Actuator4-22 Selected Step	[E-0422 1:3 042200E]
  Actuator4-22 Selected Load	[E-0422 1:4 042200D]
  Actuator4-22 Selected Drive	[E-0422 1:5 042200C]
  Actuator4-22 Maunakea	[E-0422 1:6 042200B]
  Actuator4-22 Sea Level	[E-0422 1:7 042200A]
  Actuator4-22 Up Limit	[E-0422 2:0 0422016]
  Actuator4-22 Driver Alarm	[E-0422 2:1 0422015]
  Actuator4-22 Error Alarm	[E-0422 2:2 0422014]
  Actuator4-22 Over Current	[E-0422 2:3 0422013]
  Actuator4-22 Over Speed	[E-0422 2:4 0422012]
  Actuator4-22 Over Load	[E-0422 2:5 0422011]
  Actuator4-22 PS Alarm	[E-0422 2:6 0422010]
  Actuator4-22 ENC Alarm	[E-0422 2:7 042200F]
  Actuator4-22 CPU Alarm	[E-0422 3:0 042201E]
  Actuator4-22 UART Alarm	[E-0422 3:1 042201D]
  Actuator4-22 HDLC Alarm	[E-0422 3:2 042201C]
  Actuator4-22 Force Card Fault	[E-0422 3:3 042201B]
  Actuator4-22 Force Sensor Fault	[E-0422 3:4 042201A]
  Actuator4-22 Under Range	[E-0422 3:5 0422019]
  Actuator4-22 Over Range	[E-0422 3:6 0422018]
  Actuator4-22 Down Limit	[E-0422 3:7 0422017]
  Actuator4-23 MON PARA	[E-0423 0:0 0423009]
  Actuator4-23 MON HYB	[E-0423 0:1 0423008]
  Actuator4-23 MON Position	[E-0423 0:2 0423007]
  Actuator4-23 MON Force	[E-0423 0:3 0423006]
  Actuator4-23 Drive Off	[E-0423 0:4 0423005]
  Actuator4-23 Drive On	[E-0423 0:5 0423004]
  Actuator4-23 CONT Position	[E-0423 0:6 0423003]
  Actuator4-23 CONT Force	[E-0423 0:7 0423002]
  Actuator4-23 Alarm Reset	[E-0423 1:1 0423020]
  Actuator4-23 Limit Release	[E-0423 1:2 042301F]
  Actuator4-23 Selected Step	[E-0423 1:3 042300E]
  Actuator4-23 Selected Load	[E-0423 1:4 042300D]
  Actuator4-23 Selected Drive	[E-0423 1:5 042300C]
  Actuator4-23 Maunakea	[E-0423 1:6 042300B]
  Actuator4-23 Sea Level	[E-0423 1:7 042300A]
  Actuator4-23 Up Limit	[E-0423 2:0 0423016]
  Actuator4-23 Driver Alarm	[E-0423 2:1 0423015]
  Actuator4-23 Error Alarm	[E-0423 2:2 0423014]
  Actuator4-23 Over Current	[E-0423 2:3 0423013]
  Actuator4-23 Over Speed	[E-0423 2:4 0423012]
  Actuator4-23 Over Load	[E-0423 2:5 0423011]
  Actuator4-23 PS Alarm	[E-0423 2:6 0423010]
  Actuator4-23 ENC Alarm	[E-0423 2:7 042300F]
  Actuator4-23 CPU Alarm	[E-0423 3:0 042301E]
  Actuator4-23 UART Alarm	[E-0423 3:1 042301D]
  Actuator4-23 HDLC Alarm	[E-0423 3:2 042301C]
  Actuator4-23 Force Card Fault	[E-0423 3:3 042301B]
  Actuator4-23 Force Sensor Fault	[E-0423 3:4 042301A]
  Actuator4-23 Under Range	[E-0423 3:5 0423019]
  Actuator4-23 Over Range	[E-0423 3:6 0423018]
  Actuator4-23 Down Limit	[E-0423 3:7 0423017]
  Actuator4-24 MON PARA	[E-0424 0:0 0424009]
  Actuator4-24 MON HYB	[E-0424 0:1 0424008]
  Actuator4-24 MON Position	[E-0424 0:2 0424007]
  Actuator4-24 MON Force	[E-0424 0:3 0424006]
  Actuator4-24 Drive Off	[E-0424 0:4 0424005]
  Actuator4-24 Drive On	[E-0424 0:5 0424004]
  Actuator4-24 CONT Position	[E-0424 0:6 0424003]
  Actuator4-24 CONT Force	[E-0424 0:7 0424002]
  Actuator4-24 Alarm Reset	[E-0424 1:1 0424020]
  Actuator4-24 Limit Release	[E-0424 1:2 042401F]
  Actuator4-24 Selected Step	[E-0424 1:3 042400E]
  Actuator4-24 Selected Load	[E-0424 1:4 042400D]
  Actuator4-24 Selected Drive	[E-0424 1:5 042400C]
  Actuator4-24 Maunakea	[E-0424 1:6 042400B]
  Actuator4-24 Sea Level	[E-0424 1:7 042400A]
  Actuator4-24 Up Limit	[E-0424 2:0 0424016]
  Actuator4-24 Driver Alarm	[E-0424 2:1 0424015]
  Actuator4-24 Error Alarm	[E-0424 2:2 0424014]
  Actuator4-24 Over Current	[E-0424 2:3 0424013]
  Actuator4-24 Over Speed	[E-0424 2:4 0424012]
  Actuator4-24 Over Load	[E-0424 2:5 0424011]
  Actuator4-24 PS Alarm	[E-0424 2:6 0424010]
  Actuator4-24 ENC Alarm	[E-0424 2:7 042400F]
  Actuator4-24 CPU Alarm	[E-0424 3:0 042401E]
  Actuator4-24 UART Alarm	[E-0424 3:1 042401D]
  Actuator4-24 HDLC Alarm	[E-0424 3:2 042401C]
  Actuator4-24 Force Card Fault	[E-0424 3:3 042401B]
  Actuator4-24 Force Sensor Fault	[E-0424 3:4 042401A]
  Actuator4-24 Under Range	[E-0424 3:5 0424019]
  Actuator4-24 Over Range	[E-0424 3:6 0424018]
  Actuator4-24 Down Limit	[E-0424 3:7 0424017]
  Actuator4-25 MON PARA	[E-0425 0:0 0425009]
  Actuator4-25 MON HYB	[E-0425 0:1 0425008]
  Actuator4-25 MON Position	[E-0425 0:2 0425007]
  Actuator4-25 MON Force	[E-0425 0:3 0425006]
  Actuator4-25 Drive Off	[E-0425 0:4 0425005]
  Actuator4-25 Drive On	[E-0425 0:5 0425004]
  Actuator4-25 CONT Position	[E-0425 0:6 0425003]
  Actuator4-25 CONT Force	[E-0425 0:7 0425002]
  Actuator4-25 Alarm Reset	[E-0425 1:1 0425020]
  Actuator4-25 Limit Release	[E-0425 1:2 042501F]
  Actuator4-25 Selected Step	[E-0425 1:3 042500E]
  Actuator4-25 Selected Load	[E-0425 1:4 042500D]
  Actuator4-25 Selected Drive	[E-0425 1:5 042500C]
  Actuator4-25 Maunakea	[E-0425 1:6 042500B]
  Actuator4-25 Sea Level	[E-0425 1:7 042500A]
  Actuator4-25 Up Limit	[E-0425 2:0 0425016]
  Actuator4-25 Driver Alarm	[E-0425 2:1 0425015]
  Actuator4-25 Error Alarm	[E-0425 2:2 0425014]
  Actuator4-25 Over Current	[E-0425 2:3 0425013]
  Actuator4-25 Over Speed	[E-0425 2:4 0425012]
  Actuator4-25 Over Load	[E-0425 2:5 0425011]
  Actuator4-25 PS Alarm	[E-0425 2:6 0425010]
  Actuator4-25 ENC Alarm	[E-0425 2:7 042500F]
  Actuator4-25 CPU Alarm	[E-0425 3:0 042501E]
  Actuator4-25 UART Alarm	[E-0425 3:1 042501D]
  Actuator4-25 HDLC Alarm	[E-0425 3:2 042501C]
  Actuator4-25 Force Card Fault	[E-0425 3:3 042501B]
  Actuator4-25 Force Sensor Fault	[E-0425 3:4 042501A]
  Actuator4-25 Under Range	[E-0425 3:5 0425019]
  Actuator4-25 Over Range	[E-0425 3:6 0425018]
  Actuator4-25 Down Limit	[E-0425 3:7 0425017]
  Actuator4-26 MON PARA	[E-0426 0:0 0426009]
  Actuator4-26 MON HYB	[E-0426 0:1 0426008]
  Actuator4-26 MON Position	[E-0426 0:2 0426007]
  Actuator4-26 MON Force	[E-0426 0:3 0426006]
  Actuator4-26 Drive Off	[E-0426 0:4 0426005]
  Actuator4-26 Drive On	[E-0426 0:5 0426004]
  Actuator4-26 CONT Position	[E-0426 0:6 0426003]
  Actuator4-26 CONT Force	[E-0426 0:7 0426002]
  Actuator4-26 Alarm Reset	[E-0426 1:1 0426020]
  Actuator4-26 Limit Release	[E-0426 1:2 042601F]
  Actuator4-26 Selected Step	[E-0426 1:3 042600E]
  Actuator4-26 Selected Load	[E-0426 1:4 042600D]
  Actuator4-26 Selected Drive	[E-0426 1:5 042600C]
  Actuator4-26 Maunakea	[E-0426 1:6 042600B]
  Actuator4-26 Sea Level	[E-0426 1:7 042600A]
  Actuator4-26 Up Limit	[E-0426 2:0 0426016]
  Actuator4-26 Driver Alarm	[E-0426 2:1 0426015]
  Actuator4-26 Error Alarm	[E-0426 2:2 0426014]
  Actuator4-26 Over Current	[E-0426 2:3 0426013]
  Actuator4-26 Over Speed	[E-0426 2:4 0426012]
  Actuator4-26 Over Load	[E-0426 2:5 0426011]
  Actuator4-26 PS Alarm	[E-0426 2:6 0426010]
  Actuator4-26 ENC Alarm	[E-0426 2:7 042600F]
  Actuator4-26 CPU Alarm	[E-0426 3:0 042601E]
  Actuator4-26 UART Alarm	[E-0426 3:1 042601D]
  Actuator4-26 HDLC Alarm	[E-0426 3:2 042601C]
  Actuator4-26 Force Card Fault	[E-0426 3:3 042601B]
  Actuator4-26 Force Sensor Fault	[E-0426 3:4 042601A]
  Actuator4-26 Under Range	[E-0426 3:5 0426019]
  Actuator4-26 Over Range	[E-0426 3:6 0426018]
  Actuator4-26 Down Limit	[E-0426 3:7 0426017]
  Actuator4-27 MON PARA	[E-0427 0:0 0427009]
  Actuator4-27 MON HYB	[E-0427 0:1 0427008]
  Actuator4-27 MON Position	[E-0427 0:2 0427007]
  Actuator4-27 MON Force	[E-0427 0:3 0427006]
  Actuator4-27 Drive Off	[E-0427 0:4 0427005]
  Actuator4-27 Drive On	[E-0427 0:5 0427004]
  Actuator4-27 CONT Position	[E-0427 0:6 0427003]
  Actuator4-27 CONT Force	[E-0427 0:7 0427002]
  Actuator4-27 Alarm Reset	[E-0427 1:1 0427020]
  Actuator4-27 Limit Release	[E-0427 1:2 042701F]
  Actuator4-27 Selected Step	[E-0427 1:3 042700E]
  Actuator4-27 Selected Load	[E-0427 1:4 042700D]
  Actuator4-27 Selected Drive	[E-0427 1:5 042700C]
  Actuator4-27 Maunakea	[E-0427 1:6 042700B]
  Actuator4-27 Sea Level	[E-0427 1:7 042700A]
  Actuator4-27 Up Limit	[E-0427 2:0 0427016]
  Actuator4-27 Driver Alarm	[E-0427 2:1 0427015]
  Actuator4-27 Error Alarm	[E-0427 2:2 0427014]
  Actuator4-27 Over Current	[E-0427 2:3 0427013]
  Actuator4-27 Over Speed	[E-0427 2:4 0427012]
  Actuator4-27 Over Load	[E-0427 2:5 0427011]
  Actuator4-27 PS Alarm	[E-0427 2:6 0427010]
  Actuator4-27 ENC Alarm	[E-0427 2:7 042700F]
  Actuator4-27 CPU Alarm	[E-0427 3:0 042701E]
  Actuator4-27 UART Alarm	[E-0427 3:1 042701D]
  Actuator4-27 HDLC Alarm	[E-0427 3:2 042701C]
  Actuator4-27 Force Card Fault	[E-0427 3:3 042701B]
  Actuator4-27 Force Sensor Fault	[E-0427 3:4 042701A]
  Actuator4-27 Under Range	[E-0427 3:5 0427019]
  Actuator4-27 Over Range	[E-0427 3:6 0427018]
  Actuator4-27 Down Limit	[E-0427 3:7 0427017]
  Actuator4-28 MON PARA	[E-0428 0:0 0428009]
  Actuator4-28 MON HYB	[E-0428 0:1 0428008]
  Actuator4-28 MON Position	[E-0428 0:2 0428007]
  Actuator4-28 MON Force	[E-0428 0:3 0428006]
  Actuator4-28 Drive Off	[E-0428 0:4 0428005]
  Actuator4-28 Drive On	[E-0428 0:5 0428004]
  Actuator4-28 CONT Position	[E-0428 0:6 0428003]
  Actuator4-28 CONT Force	[E-0428 0:7 0428002]
  Actuator4-28 Alarm Reset	[E-0428 1:1 0428020]
  Actuator4-28 Limit Release	[E-0428 1:2 042801F]
  Actuator4-28 Selected Step	[E-0428 1:3 042800E]
  Actuator4-28 Selected Load	[E-0428 1:4 042800D]
  Actuator4-28 Selected Drive	[E-0428 1:5 042800C]
  Actuator4-28 Maunakea	[E-0428 1:6 042800B]
  Actuator4-28 Sea Level	[E-0428 1:7 042800A]
  Actuator4-28 Up Limit	[E-0428 2:0 0428016]
  Actuator4-28 Driver Alarm	[E-0428 2:1 0428015]
  Actuator4-28 Error Alarm	[E-0428 2:2 0428014]
  Actuator4-28 Over Current	[E-0428 2:3 0428013]
  Actuator4-28 Over Speed	[E-0428 2:4 0428012]
  Actuator4-28 Over Load	[E-0428 2:5 0428011]
  Actuator4-28 PS Alarm	[E-0428 2:6 0428010]
  Actuator4-28 ENC Alarm	[E-0428 2:7 042800F]
  Actuator4-28 CPU Alarm	[E-0428 3:0 042801E]
  Actuator4-28 UART Alarm	[E-0428 3:1 042801D]
  Actuator4-28 HDLC Alarm	[E-0428 3:2 042801C]
  Actuator4-28 Force Card Fault	[E-0428 3:3 042801B]
  Actuator4-28 Force Sensor Fault	[E-0428 3:4 042801A]
  Actuator4-28 Under Range	[E-0428 3:5 0428019]
  Actuator4-28 Over Range	[E-0428 3:6 0428018]
  Actuator4-28 Down Limit	[E-0428 3:7 0428017]
  Actuator4-29 MON PARA	[E-0429 0:0 0429009]
  Actuator4-29 MON HYB	[E-0429 0:1 0429008]
  Actuator4-29 MON Position	[E-0429 0:2 0429007]
  Actuator4-29 MON Force	[E-0429 0:3 0429006]
  Actuator4-29 Drive Off	[E-0429 0:4 0429005]
  Actuator4-29 Drive On	[E-0429 0:5 0429004]
  Actuator4-29 CONT Position	[E-0429 0:6 0429003]
  Actuator4-29 CONT Force	[E-0429 0:7 0429002]
  Actuator4-29 Alarm Reset	[E-0429 1:1 0429020]
  Actuator4-29 Limit Release	[E-0429 1:2 042901F]
  Actuator4-29 Selected Step	[E-0429 1:3 042900E]
  Actuator4-29 Selected Load	[E-0429 1:4 042900D]
  Actuator4-29 Selected Drive	[E-0429 1:5 042900C]
  Actuator4-29 Maunakea	[E-0429 1:6 042900B]
  Actuator4-29 Sea Level	[E-0429 1:7 042900A]
  Actuator4-29 Up Limit	[E-0429 2:0 0429016]
  Actuator4-29 Driver Alarm	[E-0429 2:1 0429015]
  Actuator4-29 Error Alarm	[E-0429 2:2 0429014]
  Actuator4-29 Over Current	[E-0429 2:3 0429013]
  Actuator4-29 Over Speed	[E-0429 2:4 0429012]
  Actuator4-29 Over Load	[E-0429 2:5 0429011]
  Actuator4-29 PS Alarm	[E-0429 2:6 0429010]
  Actuator4-29 ENC Alarm	[E-0429 2:7 042900F]
  Actuator4-29 CPU Alarm	[E-0429 3:0 042901E]
  Actuator4-29 UART Alarm	[E-0429 3:1 042901D]
  Actuator4-29 HDLC Alarm	[E-0429 3:2 042901C]
  Actuator4-29 Force Card Fault	[E-0429 3:3 042901B]
  Actuator4-29 Force Sensor Fault	[E-0429 3:4 042901A]
  Actuator4-29 Under Range	[E-0429 3:5 0429019]
  Actuator4-29 Over Range	[E-0429 3:6 0429018]
  Actuator4-29 Down Limit	[E-0429 3:7 0429017]
  Actuator4-30 MON PARA	[E-0430 0:0 0430009]
  Actuator4-30 MON HYB	[E-0430 0:1 0430008]
  Actuator4-30 MON Position	[E-0430 0:2 0430007]
  Actuator4-30 MON Force	[E-0430 0:3 0430006]
  Actuator4-30 Drive Off	[E-0430 0:4 0430005]
  Actuator4-30 Drive On	[E-0430 0:5 0430004]
  Actuator4-30 CONT Position	[E-0430 0:6 0430003]
  Actuator4-30 CONT Force	[E-0430 0:7 0430002]
  Actuator4-30 Alarm Reset	[E-0430 1:1 0430020]
  Actuator4-30 Limit Release	[E-0430 1:2 043001F]
  Actuator4-30 Selected Step	[E-0430 1:3 043000E]
  Actuator4-30 Selected Load	[E-0430 1:4 043000D]
  Actuator4-30 Selected Drive	[E-0430 1:5 043000C]
  Actuator4-30 Maunakea	[E-0430 1:6 043000B]
  Actuator4-30 Sea Level	[E-0430 1:7 043000A]
  Actuator4-30 Up Limit	[E-0430 2:0 0430016]
  Actuator4-30 Driver Alarm	[E-0430 2:1 0430015]
  Actuator4-30 Error Alarm	[E-0430 2:2 0430014]
  Actuator4-30 Over Current	[E-0430 2:3 0430013]
  Actuator4-30 Over Speed	[E-0430 2:4 0430012]
  Actuator4-30 Over Load	[E-0430 2:5 0430011]
  Actuator4-30 PS Alarm	[E-0430 2:6 0430010]
  Actuator4-30 ENC Alarm	[E-0430 2:7 043000F]
  Actuator4-30 CPU Alarm	[E-0430 3:0 043001E]
  Actuator4-30 UART Alarm	[E-0430 3:1 043001D]
  Actuator4-30 HDLC Alarm	[E-0430 3:2 043001C]
  Actuator4-30 Force Card Fault	[E-0430 3:3 043001B]
  Actuator4-30 Force Sensor Fault	[E-0430 3:4 043001A]
  Actuator4-30 Under Range	[E-0430 3:5 0430019]
  Actuator4-30 Over Range	[E-0430 3:6 0430018]
  Actuator4-30 Down Limit	[E-0430 3:7 0430017]
  Actuator4-31 MON PARA	[E-0431 0:0 0431009]
  Actuator4-31 MON HYB	[E-0431 0:1 0431008]
  Actuator4-31 MON Position	[E-0431 0:2 0431007]
  Actuator4-31 MON Force	[E-0431 0:3 0431006]
  Actuator4-31 Drive Off	[E-0431 0:4 0431005]
  Actuator4-31 Drive On	[E-0431 0:5 0431004]
  Actuator4-31 CONT Position	[E-0431 0:6 0431003]
  Actuator4-31 CONT Force	[E-0431 0:7 0431002]
  Actuator4-31 Alarm Reset	[E-0431 1:1 0431020]
  Actuator4-31 Limit Release	[E-0431 1:2 043101F]
  Actuator4-31 Selected Step	[E-0431 1:3 043100E]
  Actuator4-31 Selected Load	[E-0431 1:4 043100D]
  Actuator4-31 Selected Drive	[E-0431 1:5 043100C]
  Actuator4-31 Maunakea	[E-0431 1:6 043100B]
  Actuator4-31 Sea Level	[E-0431 1:7 043100A]
  Actuator4-31 Up Limit	[E-0431 2:0 0431016]
  Actuator4-31 Driver Alarm	[E-0431 2:1 0431015]
  Actuator4-31 Error Alarm	[E-0431 2:2 0431014]
  Actuator4-31 Over Current	[E-0431 2:3 0431013]
  Actuator4-31 Over Speed	[E-0431 2:4 0431012]
  Actuator4-31 Over Load	[E-0431 2:5 0431011]
  Actuator4-31 PS Alarm	[E-0431 2:6 0431010]
  Actuator4-31 ENC Alarm	[E-0431 2:7 043100F]
  Actuator4-31 CPU Alarm	[E-0431 3:0 043101E]
  Actuator4-31 UART Alarm	[E-0431 3:1 043101D]
  Actuator4-31 HDLC Alarm	[E-0431 3:2 043101C]
  Actuator4-31 Force Card Fault	[E-0431 3:3 043101B]
  Actuator4-31 Force Sensor Fault	[E-0431 3:4 043101A]
  Actuator4-31 Under Range	[E-0431 3:5 0431019]
  Actuator4-31 Over Range	[E-0431 3:6 0431018]
  Actuator4-31 Down Limit	[E-0431 3:7 0431017]
  Actuator4-32 MON PARA	[E-0432 0:0 0432009]
  Actuator4-32 MON HYB	[E-0432 0:1 0432008]
  Actuator4-32 MON Position	[E-0432 0:2 0432007]
  Actuator4-32 MON Force	[E-0432 0:3 0432006]
  Actuator4-32 Drive Off	[E-0432 0:4 0432005]
  Actuator4-32 Drive On	[E-0432 0:5 0432004]
  Actuator4-32 CONT Position	[E-0432 0:6 0432003]
  Actuator4-32 CONT Force	[E-0432 0:7 0432002]
  Actuator4-32 Alarm Reset	[E-0432 1:1 0432020]
  Actuator4-32 Limit Release	[E-0432 1:2 043201F]
  Actuator4-32 Selected Step	[E-0432 1:3 043200E]
  Actuator4-32 Selected Load	[E-0432 1:4 043200D]
  Actuator4-32 Selected Drive	[E-0432 1:5 043200C]
  Actuator4-32 Maunakea	[E-0432 1:6 043200B]
  Actuator4-32 Sea Level	[E-0432 1:7 043200A]
  Actuator4-32 Up Limit	[E-0432 2:0 0432016]
  Actuator4-32 Driver Alarm	[E-0432 2:1 0432015]
  Actuator4-32 Error Alarm	[E-0432 2:2 0432014]
  Actuator4-32 Over Current	[E-0432 2:3 0432013]
  Actuator4-32 Over Speed	[E-0432 2:4 0432012]
  Actuator4-32 Over Load	[E-0432 2:5 0432011]
  Actuator4-32 PS Alarm	[E-0432 2:6 0432010]
  Actuator4-32 ENC Alarm	[E-0432 2:7 043200F]
  Actuator4-32 CPU Alarm	[E-0432 3:0 043201E]
  Actuator4-32 UART Alarm	[E-0432 3:1 043201D]
  Actuator4-32 HDLC Alarm	[E-0432 3:2 043201C]
  Actuator4-32 Force Card Fault	[E-0432 3:3 043201B]
  Actuator4-32 Force Sensor Fault	[E-0432 3:4 043201A]
  Actuator4-32 Under Range	[E-0432 3:5 0432019]
  Actuator4-32 Over Range	[E-0432 3:6 0432018]
  Actuator4-32 Down Limit	[E-0432 3:7 0432017]
  Actuator4-33 MON PARA	[E-0433 0:0 0433009]
  Actuator4-33 MON HYB	[E-0433 0:1 0433008]
  Actuator4-33 MON Position	[E-0433 0:2 0433007]
  Actuator4-33 MON Force	[E-0433 0:3 0433006]
  Actuator4-33 Drive Off	[E-0433 0:4 0433005]
  Actuator4-33 Drive On	[E-0433 0:5 0433004]
  Actuator4-33 CONT Position	[E-0433 0:6 0433003]
  Actuator4-33 CONT Force	[E-0433 0:7 0433002]
  Actuator4-33 Alarm Reset	[E-0433 1:1 0433020]
  Actuator4-33 Limit Release	[E-0433 1:2 043301F]
  Actuator4-33 Selected Step	[E-0433 1:3 043300E]
  Actuator4-33 Selected Load	[E-0433 1:4 043300D]
  Actuator4-33 Selected Drive	[E-0433 1:5 043300C]
  Actuator4-33 Maunakea	[E-0433 1:6 043300B]
  Actuator4-33 Sea Level	[E-0433 1:7 043300A]
  Actuator4-33 Up Limit	[E-0433 2:0 0433016]
  Actuator4-33 Driver Alarm	[E-0433 2:1 0433015]
  Actuator4-33 Error Alarm	[E-0433 2:2 0433014]
  Actuator4-33 Over Current	[E-0433 2:3 0433013]
  Actuator4-33 Over Speed	[E-0433 2:4 0433012]
  Actuator4-33 Over Load	[E-0433 2:5 0433011]
  Actuator4-33 PS Alarm	[E-0433 2:6 0433010]
  Actuator4-33 ENC Alarm	[E-0433 2:7 043300F]
  Actuator4-33 CPU Alarm	[E-0433 3:0 043301E]
  Actuator4-33 UART Alarm	[E-0433 3:1 043301D]
  Actuator4-33 HDLC Alarm	[E-0433 3:2 043301C]
  Actuator4-33 Force Card Fault	[E-0433 3:3 043301B]
  Actuator4-33 Force Sensor Fault	[E-0433 3:4 043301A]
  Actuator4-33 Under Range	[E-0433 3:5 0433019]
  Actuator4-33 Over Range	[E-0433 3:6 0433018]
  Actuator4-33 Down Limit	[E-0433 3:7 0433017]
  Actuator4-34 MON PARA	[E-0434 0:0 0434009]
  Actuator4-34 MON HYB	[E-0434 0:1 0434008]
  Actuator4-34 MON Position	[E-0434 0:2 0434007]
  Actuator4-34 MON Force	[E-0434 0:3 0434006]
  Actuator4-34 Drive Off	[E-0434 0:4 0434005]
  Actuator4-34 Drive On	[E-0434 0:5 0434004]
  Actuator4-34 CONT Position	[E-0434 0:6 0434003]
  Actuator4-34 CONT Force	[E-0434 0:7 0434002]
  Actuator4-34 Alarm Reset	[E-0434 1:1 0434020]
  Actuator4-34 Limit Release	[E-0434 1:2 043401F]
  Actuator4-34 Selected Step	[E-0434 1:3 043400E]
  Actuator4-34 Selected Load	[E-0434 1:4 043400D]
  Actuator4-34 Selected Drive	[E-0434 1:5 043400C]
  Actuator4-34 Maunakea	[E-0434 1:6 043400B]
  Actuator4-34 Sea Level	[E-0434 1:7 043400A]
  Actuator4-34 Up Limit	[E-0434 2:0 0434016]
  Actuator4-34 Driver Alarm	[E-0434 2:1 0434015]
  Actuator4-34 Error Alarm	[E-0434 2:2 0434014]
  Actuator4-34 Over Current	[E-0434 2:3 0434013]
  Actuator4-34 Over Speed	[E-0434 2:4 0434012]
  Actuator4-34 Over Load	[E-0434 2:5 0434011]
  Actuator4-34 PS Alarm	[E-0434 2:6 0434010]
  Actuator4-34 ENC Alarm	[E-0434 2:7 043400F]
  Actuator4-34 CPU Alarm	[E-0434 3:0 043401E]
  Actuator4-34 UART Alarm	[E-0434 3:1 043401D]
  Actuator4-34 HDLC Alarm	[E-0434 3:2 043401C]
  Actuator4-34 Force Card Fault	[E-0434 3:3 043401B]
  Actuator4-34 Force Sensor Fault	[E-0434 3:4 043401A]
  Actuator4-34 Under Range	[E-0434 3:5 0434019]
  Actuator4-34 Over Range	[E-0434 3:6 0434018]
  Actuator4-34 Down Limit	[E-0434 3:7 0434017]
  Actuator4-35 MON PARA	[E-0435 0:0 0435009]
  Actuator4-35 MON HYB	[E-0435 0:1 0435008]
  Actuator4-35 MON Position	[E-0435 0:2 0435007]
  Actuator4-35 MON Force	[E-0435 0:3 0435006]
  Actuator4-35 Drive Off	[E-0435 0:4 0435005]
  Actuator4-35 Drive On	[E-0435 0:5 0435004]
  Actuator4-35 CONT Position	[E-0435 0:6 0435003]
  Actuator4-35 CONT Force	[E-0435 0:7 0435002]
  Actuator4-35 Alarm Reset	[E-0435 1:1 0435020]
  Actuator4-35 Limit Release	[E-0435 1:2 043501F]
  Actuator4-35 Selected Step	[E-0435 1:3 043500E]
  Actuator4-35 Selected Load	[E-0435 1:4 043500D]
  Actuator4-35 Selected Drive	[E-0435 1:5 043500C]
  Actuator4-35 Maunakea	[E-0435 1:6 043500B]
  Actuator4-35 Sea Level	[E-0435 1:7 043500A]
  Actuator4-35 Up Limit	[E-0435 2:0 0435016]
  Actuator4-35 Driver Alarm	[E-0435 2:1 0435015]
  Actuator4-35 Error Alarm	[E-0435 2:2 0435014]
  Actuator4-35 Over Current	[E-0435 2:3 0435013]
  Actuator4-35 Over Speed	[E-0435 2:4 0435012]
  Actuator4-35 Over Load	[E-0435 2:5 0435011]
  Actuator4-35 PS Alarm	[E-0435 2:6 0435010]
  Actuator4-35 ENC Alarm	[E-0435 2:7 043500F]
  Actuator4-35 CPU Alarm	[E-0435 3:0 043501E]
  Actuator4-35 UART Alarm	[E-0435 3:1 043501D]
  Actuator4-35 HDLC Alarm	[E-0435 3:2 043501C]
  Actuator4-35 Force Card Fault	[E-0435 3:3 043501B]
  Actuator4-35 Force Sensor Fault	[E-0435 3:4 043501A]
  Actuator4-35 Under Range	[E-0435 3:5 0435019]
  Actuator4-35 Over Range	[E-0435 3:6 0435018]
  Actuator4-35 Down Limit	[E-0435 3:7 0435017]
  Actuator4-36 MON PARA	[E-0436 0:0 0436009]
  Actuator4-36 MON HYB	[E-0436 0:1 0436008]
  Actuator4-36 MON Position	[E-0436 0:2 0436007]
  Actuator4-36 MON Force	[E-0436 0:3 0436006]
  Actuator4-36 Drive Off	[E-0436 0:4 0436005]
  Actuator4-36 Drive On	[E-0436 0:5 0436004]
  Actuator4-36 CONT Position	[E-0436 0:6 0436003]
  Actuator4-36 CONT Force	[E-0436 0:7 0436002]
  Actuator4-36 Alarm Reset	[E-0436 1:1 0436020]
  Actuator4-36 Limit Release	[E-0436 1:2 043601F]
  Actuator4-36 Selected Step	[E-0436 1:3 043600E]
  Actuator4-36 Selected Load	[E-0436 1:4 043600D]
  Actuator4-36 Selected Drive	[E-0436 1:5 043600C]
  Actuator4-36 Maunakea	[E-0436 1:6 043600B]
  Actuator4-36 Sea Level	[E-0436 1:7 043600A]
  Actuator4-36 Up Limit	[E-0436 2:0 0436016]
  Actuator4-36 Driver Alarm	[E-0436 2:1 0436015]
  Actuator4-36 Error Alarm	[E-0436 2:2 0436014]
  Actuator4-36 Over Current	[E-0436 2:3 0436013]
  Actuator4-36 Over Speed	[E-0436 2:4 0436012]
  Actuator4-36 Over Load	[E-0436 2:5 0436011]
  Actuator4-36 PS Alarm	[E-0436 2:6 0436010]
  Actuator4-36 ENC Alarm	[E-0436 2:7 043600F]
  Actuator4-36 CPU Alarm	[E-0436 3:0 043601E]
  Actuator4-36 UART Alarm	[E-0436 3:1 043601D]
  Actuator4-36 HDLC Alarm	[E-0436 3:2 043601C]
  Actuator4-36 Force Card Fault	[E-0436 3:3 043601B]
  Actuator4-36 Force Sensor Fault	[E-0436 3:4 043601A]
  Actuator4-36 Under Range	[E-0436 3:5 0436019]
  Actuator4-36 Over Range	[E-0436 3:6 0436018]
  Actuator4-36 Down Limit	[E-0436 3:7 0436017]
  Actuator4-37 MON PARA	[E-0437 0:0 0437009]
  Actuator4-37 MON HYB	[E-0437 0:1 0437008]
  Actuator4-37 MON Position	[E-0437 0:2 0437007]
  Actuator4-37 MON Force	[E-0437 0:3 0437006]
  Actuator4-37 Drive Off	[E-0437 0:4 0437005]
  Actuator4-37 Drive On	[E-0437 0:5 0437004]
  Actuator4-37 CONT Position	[E-0437 0:6 0437003]
  Actuator4-37 CONT Force	[E-0437 0:7 0437002]
  Actuator4-37 Alarm Reset	[E-0437 1:1 0437020]
  Actuator4-37 Limit Release	[E-0437 1:2 043701F]
  Actuator4-37 Selected Step	[E-0437 1:3 043700E]
  Actuator4-37 Selected Load	[E-0437 1:4 043700D]
  Actuator4-37 Selected Drive	[E-0437 1:5 043700C]
  Actuator4-37 Maunakea	[E-0437 1:6 043700B]
  Actuator4-37 Sea Level	[E-0437 1:7 043700A]
  Actuator4-37 Up Limit	[E-0437 2:0 0437016]
  Actuator4-37 Driver Alarm	[E-0437 2:1 0437015]
  Actuator4-37 Error Alarm	[E-0437 2:2 0437014]
  Actuator4-37 Over Current	[E-0437 2:3 0437013]
  Actuator4-37 Over Speed	[E-0437 2:4 0437012]
  Actuator4-37 Over Load	[E-0437 2:5 0437011]
  Actuator4-37 PS Alarm	[E-0437 2:6 0437010]
  Actuator4-37 ENC Alarm	[E-0437 2:7 043700F]
  Actuator4-37 CPU Alarm	[E-0437 3:0 043701E]
  Actuator4-37 UART Alarm	[E-0437 3:1 043701D]
  Actuator4-37 HDLC Alarm	[E-0437 3:2 043701C]
  Actuator4-37 Force Card Fault	[E-0437 3:3 043701B]
  Actuator4-37 Force Sensor Fault	[E-0437 3:4 043701A]
  Actuator4-37 Under Range	[E-0437 3:5 0437019]
  Actuator4-37 Over Range	[E-0437 3:6 0437018]
  Actuator4-37 Down Limit	[E-0437 3:7 0437017]
  Actuator4-38 MON PARA	[E-0438 0:0 0438009]
  Actuator4-38 MON HYB	[E-0438 0:1 0438008]
  Actuator4-38 MON Position	[E-0438 0:2 0438007]
  Actuator4-38 MON Force	[E-0438 0:3 0438006]
  Actuator4-38 Drive Off	[E-0438 0:4 0438005]
  Actuator4-38 Drive On	[E-0438 0:5 0438004]
  Actuator4-38 CONT Position	[E-0438 0:6 0438003]
  Actuator4-38 CONT Force	[E-0438 0:7 0438002]
  Actuator4-38 Alarm Reset	[E-0438 1:1 0438020]
  Actuator4-38 Limit Release	[E-0438 1:2 043801F]
  Actuator4-38 Selected Step	[E-0438 1:3 043800E]
  Actuator4-38 Selected Load	[E-0438 1:4 043800D]
  Actuator4-38 Selected Drive	[E-0438 1:5 043800C]
  Actuator4-38 Maunakea	[E-0438 1:6 043800B]
  Actuator4-38 Sea Level	[E-0438 1:7 043800A]
  Actuator4-38 Up Limit	[E-0438 2:0 0438016]
  Actuator4-38 Driver Alarm	[E-0438 2:1 0438015]
  Actuator4-38 Error Alarm	[E-0438 2:2 0438014]
  Actuator4-38 Over Current	[E-0438 2:3 0438013]
  Actuator4-38 Over Speed	[E-0438 2:4 0438012]
  Actuator4-38 Over Load	[E-0438 2:5 0438011]
  Actuator4-38 PS Alarm	[E-0438 2:6 0438010]
  Actuator4-38 ENC Alarm	[E-0438 2:7 043800F]
  Actuator4-38 CPU Alarm	[E-0438 3:0 043801E]
  Actuator4-38 UART Alarm	[E-0438 3:1 043801D]
  Actuator4-38 HDLC Alarm	[E-0438 3:2 043801C]
  Actuator4-38 Force Card Fault	[E-0438 3:3 043801B]
  Actuator4-38 Force Sensor Fault	[E-0438 3:4 043801A]
  Actuator4-38 Under Range	[E-0438 3:5 0438019]
  Actuator4-38 Over Range	[E-0438 3:6 0438018]
  Actuator4-38 Down Limit	[E-0438 3:7 0438017]
  Actuator4-39 MON PARA	[E-0439 0:0 0439009]
  Actuator4-39 MON HYB	[E-0439 0:1 0439008]
  Actuator4-39 MON Position	[E-0439 0:2 0439007]
  Actuator4-39 MON Force	[E-0439 0:3 0439006]
  Actuator4-39 Drive Off	[E-0439 0:4 0439005]
  Actuator4-39 Drive On	[E-0439 0:5 0439004]
  Actuator4-39 CONT Position	[E-0439 0:6 0439003]
  Actuator4-39 CONT Force	[E-0439 0:7 0439002]
  Actuator4-39 Alarm Reset	[E-0439 1:1 0439020]
  Actuator4-39 Limit Release	[E-0439 1:2 043901F]
  Actuator4-39 Selected Step	[E-0439 1:3 043900E]
  Actuator4-39 Selected Load	[E-0439 1:4 043900D]
  Actuator4-39 Selected Drive	[E-0439 1:5 043900C]
  Actuator4-39 Maunakea	[E-0439 1:6 043900B]
  Actuator4-39 Sea Level	[E-0439 1:7 043900A]
  Actuator4-39 Up Limit	[E-0439 2:0 0439016]
  Actuator4-39 Driver Alarm	[E-0439 2:1 0439015]
  Actuator4-39 Error Alarm	[E-0439 2:2 0439014]
  Actuator4-39 Over Current	[E-0439 2:3 0439013]
  Actuator4-39 Over Speed	[E-0439 2:4 0439012]
  Actuator4-39 Over Load	[E-0439 2:5 0439011]
  Actuator4-39 PS Alarm	[E-0439 2:6 0439010]
  Actuator4-39 ENC Alarm	[E-0439 2:7 043900F]
  Actuator4-39 CPU Alarm	[E-0439 3:0 043901E]
  Actuator4-39 UART Alarm	[E-0439 3:1 043901D]
  Actuator4-39 HDLC Alarm	[E-0439 3:2 043901C]
  Actuator4-39 Force Card Fault	[E-0439 3:3 043901B]
  Actuator4-39 Force Sensor Fault	[E-0439 3:4 043901A]
  Actuator4-39 Under Range	[E-0439 3:5 0439019]
  Actuator4-39 Over Range	[E-0439 3:6 0439018]
  Actuator4-39 Down Limit	[E-0439 3:7 0439017]
  Actuator4-40 MON PARA	[E-0440 0:0 0440009]
  Actuator4-40 MON HYB	[E-0440 0:1 0440008]
  Actuator4-40 MON Position	[E-0440 0:2 0440007]
  Actuator4-40 MON Force	[E-0440 0:3 0440006]
  Actuator4-40 Drive Off	[E-0440 0:4 0440005]
  Actuator4-40 Drive On	[E-0440 0:5 0440004]
  Actuator4-40 CONT Position	[E-0440 0:6 0440003]
  Actuator4-40 CONT Force	[E-0440 0:7 0440002]
  Actuator4-40 Alarm Reset	[E-0440 1:1 0440020]
  Actuator4-40 Limit Release	[E-0440 1:2 044001F]
  Actuator4-40 Selected Step	[E-0440 1:3 044000E]
  Actuator4-40 Selected Load	[E-0440 1:4 044000D]
  Actuator4-40 Selected Drive	[E-0440 1:5 044000C]
  Actuator4-40 Maunakea	[E-0440 1:6 044000B]
  Actuator4-40 Sea Level	[E-0440 1:7 044000A]
  Actuator4-40 Up Limit	[E-0440 2:0 0440016]
  Actuator4-40 Driver Alarm	[E-0440 2:1 0440015]
  Actuator4-40 Error Alarm	[E-0440 2:2 0440014]
  Actuator4-40 Over Current	[E-0440 2:3 0440013]
  Actuator4-40 Over Speed	[E-0440 2:4 0440012]
  Actuator4-40 Over Load	[E-0440 2:5 0440011]
  Actuator4-40 PS Alarm	[E-0440 2:6 0440010]
  Actuator4-40 ENC Alarm	[E-0440 2:7 044000F]
  Actuator4-40 CPU Alarm	[E-0440 3:0 044001E]
  Actuator4-40 UART Alarm	[E-0440 3:1 044001D]
  Actuator4-40 HDLC Alarm	[E-0440 3:2 044001C]
  Actuator4-40 Force Card Fault	[E-0440 3:3 044001B]
  Actuator4-40 Force Sensor Fault	[E-0440 3:4 044001A]
  Actuator4-40 Under Range	[E-0440 3:5 0440019]
  Actuator4-40 Over Range	[E-0440 3:6 0440018]
  Actuator4-40 Down Limit	[E-0440 3:7 0440017]
  Actuator4-41 MON PARA	[E-0441 0:0 0441009]
  Actuator4-41 MON HYB	[E-0441 0:1 0441008]
  Actuator4-41 MON Position	[E-0441 0:2 0441007]
  Actuator4-41 MON Force	[E-0441 0:3 0441006]
  Actuator4-41 Drive Off	[E-0441 0:4 0441005]
  Actuator4-41 Drive On	[E-0441 0:5 0441004]
  Actuator4-41 CONT Position	[E-0441 0:6 0441003]
  Actuator4-41 CONT Force	[E-0441 0:7 0441002]
  Actuator4-41 Alarm Reset	[E-0441 1:1 0441020]
  Actuator4-41 Limit Release	[E-0441 1:2 044101F]
  Actuator4-41 Selected Step	[E-0441 1:3 044100E]
  Actuator4-41 Selected Load	[E-0441 1:4 044100D]
  Actuator4-41 Selected Drive	[E-0441 1:5 044100C]
  Actuator4-41 Maunakea	[E-0441 1:6 044100B]
  Actuator4-41 Sea Level	[E-0441 1:7 044100A]
  Actuator4-41 Up Limit	[E-0441 2:0 0441016]
  Actuator4-41 Driver Alarm	[E-0441 2:1 0441015]
  Actuator4-41 Error Alarm	[E-0441 2:2 0441014]
  Actuator4-41 Over Current	[E-0441 2:3 0441013]
  Actuator4-41 Over Speed	[E-0441 2:4 0441012]
  Actuator4-41 Over Load	[E-0441 2:5 0441011]
  Actuator4-41 PS Alarm	[E-0441 2:6 0441010]
  Actuator4-41 ENC Alarm	[E-0441 2:7 044100F]
  Actuator4-41 CPU Alarm	[E-0441 3:0 044101E]
  Actuator4-41 UART Alarm	[E-0441 3:1 044101D]
  Actuator4-41 HDLC Alarm	[E-0441 3:2 044101C]
  Actuator4-41 Force Card Fault	[E-0441 3:3 044101B]
  Actuator4-41 Force Sensor Fault	[E-0441 3:4 044101A]
  Actuator4-41 Under Range	[E-0441 3:5 0441019]
  Actuator4-41 Over Range	[E-0441 3:6 0441018]
  Actuator4-41 Down Limit	[E-0441 3:7 0441017]
  Actuator4-42 MON PARA	[E-0442 0:0 0442009]
  Actuator4-42 MON HYB	[E-0442 0:1 0442008]
  Actuator4-42 MON Position	[E-0442 0:2 0442007]
  Actuator4-42 MON Force	[E-0442 0:3 0442006]
  Actuator4-42 Drive Off	[E-0442 0:4 0442005]
  Actuator4-42 Drive On	[E-0442 0:5 0442004]
  Actuator4-42 CONT Position	[E-0442 0:6 0442003]
  Actuator4-42 CONT Force	[E-0442 0:7 0442002]
  Actuator4-42 Alarm Reset	[E-0442 1:1 0442020]
  Actuator4-42 Limit Release	[E-0442 1:2 044201F]
  Actuator4-42 Selected Step	[E-0442 1:3 044200E]
  Actuator4-42 Selected Load	[E-0442 1:4 044200D]
  Actuator4-42 Selected Drive	[E-0442 1:5 044200C]
  Actuator4-42 Maunakea	[E-0442 1:6 044200B]
  Actuator4-42 Sea Level	[E-0442 1:7 044200A]
  Actuator4-42 Up Limit	[E-0442 2:0 0442016]
  Actuator4-42 Driver Alarm	[E-0442 2:1 0442015]
  Actuator4-42 Error Alarm	[E-0442 2:2 0442014]
  Actuator4-42 Over Current	[E-0442 2:3 0442013]
  Actuator4-42 Over Speed	[E-0442 2:4 0442012]
  Actuator4-42 Over Load	[E-0442 2:5 0442011]
  Actuator4-42 PS Alarm	[E-0442 2:6 0442010]
  Actuator4-42 ENC Alarm	[E-0442 2:7 044200F]
  Actuator4-42 CPU Alarm	[E-0442 3:0 044201E]
  Actuator4-42 UART Alarm	[E-0442 3:1 044201D]
  Actuator4-42 HDLC Alarm	[E-0442 3:2 044201C]
  Actuator4-42 Force Card Fault	[E-0442 3:3 044201B]
  Actuator4-42 Force Sensor Fault	[E-0442 3:4 044201A]
  Actuator4-42 Under Range	[E-0442 3:5 0442019]
  Actuator4-42 Over Range	[E-0442 3:6 0442018]
  Actuator4-42 Down Limit	[E-0442 3:7 0442017]
  Actuator4-43 MON PARA	[E-0443 0:0 0443009]
  Actuator4-43 MON HYB	[E-0443 0:1 0443008]
  Actuator4-43 MON Position	[E-0443 0:2 0443007]
  Actuator4-43 MON Force	[E-0443 0:3 0443006]
  Actuator4-43 Drive Off	[E-0443 0:4 0443005]
  Actuator4-43 Drive On	[E-0443 0:5 0443004]
  Actuator4-43 CONT Position	[E-0443 0:6 0443003]
  Actuator4-43 CONT Force	[E-0443 0:7 0443002]
  Actuator4-43 Alarm Reset	[E-0443 1:1 0443020]
  Actuator4-43 Limit Release	[E-0443 1:2 044301F]
  Actuator4-43 Selected Step	[E-0443 1:3 044300E]
  Actuator4-43 Selected Load	[E-0443 1:4 044300D]
  Actuator4-43 Selected Drive	[E-0443 1:5 044300C]
  Actuator4-43 Maunakea	[E-0443 1:6 044300B]
  Actuator4-43 Sea Level	[E-0443 1:7 044300A]
  Actuator4-43 Up Limit	[E-0443 2:0 0443016]
  Actuator4-43 Driver Alarm	[E-0443 2:1 0443015]
  Actuator4-43 Error Alarm	[E-0443 2:2 0443014]
  Actuator4-43 Over Current	[E-0443 2:3 0443013]
  Actuator4-43 Over Speed	[E-0443 2:4 0443012]
  Actuator4-43 Over Load	[E-0443 2:5 0443011]
  Actuator4-43 PS Alarm	[E-0443 2:6 0443010]
  Actuator4-43 ENC Alarm	[E-0443 2:7 044300F]
  Actuator4-43 CPU Alarm	[E-0443 3:0 044301E]
  Actuator4-43 UART Alarm	[E-0443 3:1 044301D]
  Actuator4-43 HDLC Alarm	[E-0443 3:2 044301C]
  Actuator4-43 Force Card Fault	[E-0443 3:3 044301B]
  Actuator4-43 Force Sensor Fault	[E-0443 3:4 044301A]
  Actuator4-43 Under Range	[E-0443 3:5 0443019]
  Actuator4-43 Over Range	[E-0443 3:6 0443018]
  Actuator4-43 Down Limit	[E-0443 3:7 0443017]
  Actuator4-44 MON PARA	[E-0444 0:0 0444009]
  Actuator4-44 MON HYB	[E-0444 0:1 0444008]
  Actuator4-44 MON Position	[E-0444 0:2 0444007]
  Actuator4-44 MON Force	[E-0444 0:3 0444006]
  Actuator4-44 Drive Off	[E-0444 0:4 0444005]
  Actuator4-44 Drive On	[E-0444 0:5 0444004]
  Actuator4-44 CONT Position	[E-0444 0:6 0444003]
  Actuator4-44 CONT Force	[E-0444 0:7 0444002]
  Actuator4-44 Alarm Reset	[E-0444 1:1 0444020]
  Actuator4-44 Limit Release	[E-0444 1:2 044401F]
  Actuator4-44 Selected Step	[E-0444 1:3 044400E]
  Actuator4-44 Selected Load	[E-0444 1:4 044400D]
  Actuator4-44 Selected Drive	[E-0444 1:5 044400C]
  Actuator4-44 Maunakea	[E-0444 1:6 044400B]
  Actuator4-44 Sea Level	[E-0444 1:7 044400A]
  Actuator4-44 Up Limit	[E-0444 2:0 0444016]
  Actuator4-44 Driver Alarm	[E-0444 2:1 0444015]
  Actuator4-44 Error Alarm	[E-0444 2:2 0444014]
  Actuator4-44 Over Current	[E-0444 2:3 0444013]
  Actuator4-44 Over Speed	[E-0444 2:4 0444012]
  Actuator4-44 Over Load	[E-0444 2:5 0444011]
  Actuator4-44 PS Alarm	[E-0444 2:6 0444010]
  Actuator4-44 ENC Alarm	[E-0444 2:7 044400F]
  Actuator4-44 CPU Alarm	[E-0444 3:0 044401E]
  Actuator4-44 UART Alarm	[E-0444 3:1 044401D]
  Actuator4-44 HDLC Alarm	[E-0444 3:2 044401C]
  Actuator4-44 Force Card Fault	[E-0444 3:3 044401B]
  Actuator4-44 Force Sensor Fault	[E-0444 3:4 044401A]
  Actuator4-44 Under Range	[E-0444 3:5 0444019]
  Actuator4-44 Over Range	[E-0444 3:6 0444018]
  Actuator4-44 Down Limit	[E-0444 3:7 0444017]
  Actuator4-45 MON PARA	[E-0445 0:0 0445009]
  Actuator4-45 MON HYB	[E-0445 0:1 0445008]
  Actuator4-45 MON Position	[E-0445 0:2 0445007]
  Actuator4-45 MON Force	[E-0445 0:3 0445006]
  Actuator4-45 Drive Off	[E-0445 0:4 0445005]
  Actuator4-45 Drive On	[E-0445 0:5 0445004]
  Actuator4-45 CONT Position	[E-0445 0:6 0445003]
  Actuator4-45 CONT Force	[E-0445 0:7 0445002]
  Actuator4-45 Alarm Reset	[E-0445 1:1 0445020]
  Actuator4-45 Limit Release	[E-0445 1:2 044501F]
  Actuator4-45 Selected Step	[E-0445 1:3 044500E]
  Actuator4-45 Selected Load	[E-0445 1:4 044500D]
  Actuator4-45 Selected Drive	[E-0445 1:5 044500C]
  Actuator4-45 Maunakea	[E-0445 1:6 044500B]
  Actuator4-45 Sea Level	[E-0445 1:7 044500A]
  Actuator4-45 Up Limit	[E-0445 2:0 0445016]
  Actuator4-45 Driver Alarm	[E-0445 2:1 0445015]
  Actuator4-45 Error Alarm	[E-0445 2:2 0445014]
  Actuator4-45 Over Current	[E-0445 2:3 0445013]
  Actuator4-45 Over Speed	[E-0445 2:4 0445012]
  Actuator4-45 Over Load	[E-0445 2:5 0445011]
  Actuator4-45 PS Alarm	[E-0445 2:6 0445010]
  Actuator4-45 ENC Alarm	[E-0445 2:7 044500F]
  Actuator4-45 CPU Alarm	[E-0445 3:0 044501E]
  Actuator4-45 UART Alarm	[E-0445 3:1 044501D]
  Actuator4-45 HDLC Alarm	[E-0445 3:2 044501C]
  Actuator4-45 Force Card Fault	[E-0445 3:3 044501B]
  Actuator4-45 Force Sensor Fault	[E-0445 3:4 044501A]
  Actuator4-45 Under Range	[E-0445 3:5 0445019]
  Actuator4-45 Over Range	[E-0445 3:6 0445018]
  Actuator4-45 Down Limit	[E-0445 3:7 0445017]
  Actuator4-46 MON PARA	[E-0446 0:0 0446009]
  Actuator4-46 MON HYB	[E-0446 0:1 0446008]
  Actuator4-46 MON Position	[E-0446 0:2 0446007]
  Actuator4-46 MON Force	[E-0446 0:3 0446006]
  Actuator4-46 Drive Off	[E-0446 0:4 0446005]
  Actuator4-46 Drive On	[E-0446 0:5 0446004]
  Actuator4-46 CONT Position	[E-0446 0:6 0446003]
  Actuator4-46 CONT Force	[E-0446 0:7 0446002]
  Actuator4-46 Alarm Reset	[E-0446 1:1 0446020]
  Actuator4-46 Limit Release	[E-0446 1:2 044601F]
  Actuator4-46 Selected Step	[E-0446 1:3 044600E]
  Actuator4-46 Selected Load	[E-0446 1:4 044600D]
  Actuator4-46 Selected Drive	[E-0446 1:5 044600C]
  Actuator4-46 Maunakea	[E-0446 1:6 044600B]
  Actuator4-46 Sea Level	[E-0446 1:7 044600A]
  Actuator4-46 Up Limit	[E-0446 2:0 0446016]
  Actuator4-46 Driver Alarm	[E-0446 2:1 0446015]
  Actuator4-46 Error Alarm	[E-0446 2:2 0446014]
  Actuator4-46 Over Current	[E-0446 2:3 0446013]
  Actuator4-46 Over Speed	[E-0446 2:4 0446012]
  Actuator4-46 Over Load	[E-0446 2:5 0446011]
  Actuator4-46 PS Alarm	[E-0446 2:6 0446010]
  Actuator4-46 ENC Alarm	[E-0446 2:7 044600F]
  Actuator4-46 CPU Alarm	[E-0446 3:0 044601E]
  Actuator4-46 UART Alarm	[E-0446 3:1 044601D]
  Actuator4-46 HDLC Alarm	[E-0446 3:2 044601C]
  Actuator4-46 Force Card Fault	[E-0446 3:3 044601B]
  Actuator4-46 Force Sensor Fault	[E-0446 3:4 044601A]
  Actuator4-46 Under Range	[E-0446 3:5 0446019]
  Actuator4-46 Over Range	[E-0446 3:6 0446018]
  Actuator4-46 Down Limit	[E-0446 3:7 0446017]
  Actuator4-47 MON PARA	[E-0447 0:0 0447009]
  Actuator4-47 MON HYB	[E-0447 0:1 0447008]
  Actuator4-47 MON Position	[E-0447 0:2 0447007]
  Actuator4-47 MON Force	[E-0447 0:3 0447006]
  Actuator4-47 Drive Off	[E-0447 0:4 0447005]
  Actuator4-47 Drive On	[E-0447 0:5 0447004]
  Actuator4-47 CONT Position	[E-0447 0:6 0447003]
  Actuator4-47 CONT Force	[E-0447 0:7 0447002]
  Actuator4-47 Alarm Reset	[E-0447 1:1 0447020]
  Actuator4-47 Limit Release	[E-0447 1:2 044701F]
  Actuator4-47 Selected Step	[E-0447 1:3 044700E]
  Actuator4-47 Selected Load	[E-0447 1:4 044700D]
  Actuator4-47 Selected Drive	[E-0447 1:5 044700C]
  Actuator4-47 Maunakea	[E-0447 1:6 044700B]
  Actuator4-47 Sea Level	[E-0447 1:7 044700A]
  Actuator4-47 Up Limit	[E-0447 2:0 0447016]
  Actuator4-47 Driver Alarm	[E-0447 2:1 0447015]
  Actuator4-47 Error Alarm	[E-0447 2:2 0447014]
  Actuator4-47 Over Current	[E-0447 2:3 0447013]
  Actuator4-47 Over Speed	[E-0447 2:4 0447012]
  Actuator4-47 Over Load	[E-0447 2:5 0447011]
  Actuator4-47 PS Alarm	[E-0447 2:6 0447010]
  Actuator4-47 ENC Alarm	[E-0447 2:7 044700F]
  Actuator4-47 CPU Alarm	[E-0447 3:0 044701E]
  Actuator4-47 UART Alarm	[E-0447 3:1 044701D]
  Actuator4-47 HDLC Alarm	[E-0447 3:2 044701C]
  Actuator4-47 Force Card Fault	[E-0447 3:3 044701B]
  Actuator4-47 Force Sensor Fault	[E-0447 3:4 044701A]
  Actuator4-47 Under Range	[E-0447 3:5 0447019]
  Actuator4-47 Over Range	[E-0447 3:6 0447018]
  Actuator4-47 Down Limit	[E-0447 3:7 0447017]
  Actuator4-48 MON PARA	[E-0448 0:0 0448009]
  Actuator4-48 MON HYB	[E-0448 0:1 0448008]
  Actuator4-48 MON Position	[E-0448 0:2 0448007]
  Actuator4-48 MON Force	[E-0448 0:3 0448006]
  Actuator4-48 Drive Off	[E-0448 0:4 0448005]
  Actuator4-48 Drive On	[E-0448 0:5 0448004]
  Actuator4-48 CONT Position	[E-0448 0:6 0448003]
  Actuator4-48 CONT Force	[E-0448 0:7 0448002]
  Actuator4-48 Alarm Reset	[E-0448 1:1 0448020]
  Actuator4-48 Limit Release	[E-0448 1:2 044801F]
  Actuator4-48 Selected Step	[E-0448 1:3 044800E]
  Actuator4-48 Selected Load	[E-0448 1:4 044800D]
  Actuator4-48 Selected Drive	[E-0448 1:5 044800C]
  Actuator4-48 Maunakea	[E-0448 1:6 044800B]
  Actuator4-48 Sea Level	[E-0448 1:7 044800A]
  Actuator4-48 Up Limit	[E-0448 2:0 0448016]
  Actuator4-48 Driver Alarm	[E-0448 2:1 0448015]
  Actuator4-48 Error Alarm	[E-0448 2:2 0448014]
  Actuator4-48 Over Current	[E-0448 2:3 0448013]
  Actuator4-48 Over Speed	[E-0448 2:4 0448012]
  Actuator4-48 Over Load	[E-0448 2:5 0448011]
  Actuator4-48 PS Alarm	[E-0448 2:6 0448010]
  Actuator4-48 ENC Alarm	[E-0448 2:7 044800F]
  Actuator4-48 CPU Alarm	[E-0448 3:0 044801E]
  Actuator4-48 UART Alarm	[E-0448 3:1 044801D]
  Actuator4-48 HDLC Alarm	[E-0448 3:2 044801C]
  Actuator4-48 Force Card Fault	[E-0448 3:3 044801B]
  Actuator4-48 Force Sensor Fault	[E-0448 3:4 044801A]
  Actuator4-48 Under Range	[E-0448 3:5 0448019]
  Actuator4-48 Over Range	[E-0448 3:6 0448018]
  Actuator4-48 Down Limit	[E-0448 3:7 0448017]
  Actuator4-49 MON PARA	[E-0449 0:0 0449009]
  Actuator4-49 MON HYB	[E-0449 0:1 0449008]
  Actuator4-49 MON Position	[E-0449 0:2 0449007]
  Actuator4-49 MON Force	[E-0449 0:3 0449006]
  Actuator4-49 Drive Off	[E-0449 0:4 0449005]
  Actuator4-49 Drive On	[E-0449 0:5 0449004]
  Actuator4-49 CONT Position	[E-0449 0:6 0449003]
  Actuator4-49 CONT Force	[E-0449 0:7 0449002]
  Actuator4-49 Alarm Reset	[E-0449 1:1 0449020]
  Actuator4-49 Limit Release	[E-0449 1:2 044901F]
  Actuator4-49 Selected Step	[E-0449 1:3 044900E]
  Actuator4-49 Selected Load	[E-0449 1:4 044900D]
  Actuator4-49 Selected Drive	[E-0449 1:5 044900C]
  Actuator4-49 Maunakea	[E-0449 1:6 044900B]
  Actuator4-49 Sea Level	[E-0449 1:7 044900A]
  Actuator4-49 Up Limit	[E-0449 2:0 0449016]
  Actuator4-49 Driver Alarm	[E-0449 2:1 0449015]
  Actuator4-49 Error Alarm	[E-0449 2:2 0449014]
  Actuator4-49 Over Current	[E-0449 2:3 0449013]
  Actuator4-49 Over Speed	[E-0449 2:4 0449012]
  Actuator4-49 Over Load	[E-0449 2:5 0449011]
  Actuator4-49 PS Alarm	[E-0449 2:6 0449010]
  Actuator4-49 ENC Alarm	[E-0449 2:7 044900F]
  Actuator4-49 CPU Alarm	[E-0449 3:0 044901E]
  Actuator4-49 UART Alarm	[E-0449 3:1 044901D]
  Actuator4-49 HDLC Alarm	[E-0449 3:2 044901C]
  Actuator4-49 Force Card Fault	[E-0449 3:3 044901B]
  Actuator4-49 Force Sensor Fault	[E-0449 3:4 044901A]
  Actuator4-49 Under Range	[E-0449 3:5 0449019]
  Actuator4-49 Over Range	[E-0449 3:6 0449018]
  Actuator4-49 Down Limit	[E-0449 3:7 0449017]
  Actuator4-50 MON PARA	[E-0450 0:0 0450009]
  Actuator4-50 MON HYB	[E-0450 0:1 0450008]
  Actuator4-50 MON Position	[E-0450 0:2 0450007]
  Actuator4-50 MON Force	[E-0450 0:3 0450006]
  Actuator4-50 Drive Off	[E-0450 0:4 0450005]
  Actuator4-50 Drive On	[E-0450 0:5 0450004]
  Actuator4-50 CONT Position	[E-0450 0:6 0450003]
  Actuator4-50 CONT Force	[E-0450 0:7 0450002]
  Actuator4-50 Alarm Reset	[E-0450 1:1 0450020]
  Actuator4-50 Limit Release	[E-0450 1:2 045001F]
  Actuator4-50 Selected Step	[E-0450 1:3 045000E]
  Actuator4-50 Selected Load	[E-0450 1:4 045000D]
  Actuator4-50 Selected Drive	[E-0450 1:5 045000C]
  Actuator4-50 Maunakea	[E-0450 1:6 045000B]
  Actuator4-50 Sea Level	[E-0450 1:7 045000A]
  Actuator4-50 Up Limit	[E-0450 2:0 0450016]
  Actuator4-50 Driver Alarm	[E-0450 2:1 0450015]
  Actuator4-50 Error Alarm	[E-0450 2:2 0450014]
  Actuator4-50 Over Current	[E-0450 2:3 0450013]
  Actuator4-50 Over Speed	[E-0450 2:4 0450012]
  Actuator4-50 Over Load	[E-0450 2:5 0450011]
  Actuator4-50 PS Alarm	[E-0450 2:6 0450010]
  Actuator4-50 ENC Alarm	[E-0450 2:7 045000F]
  Actuator4-50 CPU Alarm	[E-0450 3:0 045001E]
  Actuator4-50 UART Alarm	[E-0450 3:1 045001D]
  Actuator4-50 HDLC Alarm	[E-0450 3:2 045001C]
  Actuator4-50 Force Card Fault	[E-0450 3:3 045001B]
  Actuator4-50 Force Sensor Fault	[E-0450 3:4 045001A]
  Actuator4-50 Under Range	[E-0450 3:5 0450019]
  Actuator4-50 Over Range	[E-0450 3:6 0450018]
  Actuator4-50 Down Limit	[E-0450 3:7 0450017]
  Actuator4-51 MON PARA	[E-0451 0:0 0451009]
  Actuator4-51 MON HYB	[E-0451 0:1 0451008]
  Actuator4-51 MON Position	[E-0451 0:2 0451007]
  Actuator4-51 MON Force	[E-0451 0:3 0451006]
  Actuator4-51 Drive Off	[E-0451 0:4 0451005]
  Actuator4-51 Drive On	[E-0451 0:5 0451004]
  Actuator4-51 CONT Position	[E-0451 0:6 0451003]
  Actuator4-51 CONT Force	[E-0451 0:7 0451002]
  Actuator4-51 Alarm Reset	[E-0451 1:1 0451020]
  Actuator4-51 Limit Release	[E-0451 1:2 045101F]
  Actuator4-51 Selected Step	[E-0451 1:3 045100E]
  Actuator4-51 Selected Load	[E-0451 1:4 045100D]
  Actuator4-51 Selected Drive	[E-0451 1:5 045100C]
  Actuator4-51 Maunakea	[E-0451 1:6 045100B]
  Actuator4-51 Sea Level	[E-0451 1:7 045100A]
  Actuator4-51 Up Limit	[E-0451 2:0 0451016]
  Actuator4-51 Driver Alarm	[E-0451 2:1 0451015]
  Actuator4-51 Error Alarm	[E-0451 2:2 0451014]
  Actuator4-51 Over Current	[E-0451 2:3 0451013]
  Actuator4-51 Over Speed	[E-0451 2:4 0451012]
  Actuator4-51 Over Load	[E-0451 2:5 0451011]
  Actuator4-51 PS Alarm	[E-0451 2:6 0451010]
  Actuator4-51 ENC Alarm	[E-0451 2:7 045100F]
  Actuator4-51 CPU Alarm	[E-0451 3:0 045101E]
  Actuator4-51 UART Alarm	[E-0451 3:1 045101D]
  Actuator4-51 HDLC Alarm	[E-0451 3:2 045101C]
  Actuator4-51 Force Card Fault	[E-0451 3:3 045101B]
  Actuator4-51 Force Sensor Fault	[E-0451 3:4 045101A]
  Actuator4-51 Under Range	[E-0451 3:5 0451019]
  Actuator4-51 Over Range	[E-0451 3:6 0451018]
  Actuator4-51 Down Limit	[E-0451 3:7 0451017]
  Actuator4-52 MON PARA	[E-0452 0:0 0452009]
  Actuator4-52 MON HYB	[E-0452 0:1 0452008]
  Actuator4-52 MON Position	[E-0452 0:2 0452007]
  Actuator4-52 MON Force	[E-0452 0:3 0452006]
  Actuator4-52 Drive Off	[E-0452 0:4 0452005]
  Actuator4-52 Drive On	[E-0452 0:5 0452004]
  Actuator4-52 CONT Position	[E-0452 0:6 0452003]
  Actuator4-52 CONT Force	[E-0452 0:7 0452002]
  Actuator4-52 Alarm Reset	[E-0452 1:1 0452020]
  Actuator4-52 Limit Release	[E-0452 1:2 045201F]
  Actuator4-52 Selected Step	[E-0452 1:3 045200E]
  Actuator4-52 Selected Load	[E-0452 1:4 045200D]
  Actuator4-52 Selected Drive	[E-0452 1:5 045200C]
  Actuator4-52 Maunakea	[E-0452 1:6 045200B]
  Actuator4-52 Sea Level	[E-0452 1:7 045200A]
  Actuator4-52 Up Limit	[E-0452 2:0 0452016]
  Actuator4-52 Driver Alarm	[E-0452 2:1 0452015]
  Actuator4-52 Error Alarm	[E-0452 2:2 0452014]
  Actuator4-52 Over Current	[E-0452 2:3 0452013]
  Actuator4-52 Over Speed	[E-0452 2:4 0452012]
  Actuator4-52 Over Load	[E-0452 2:5 0452011]
  Actuator4-52 PS Alarm	[E-0452 2:6 0452010]
  Actuator4-52 ENC Alarm	[E-0452 2:7 045200F]
  Actuator4-52 CPU Alarm	[E-0452 3:0 045201E]
  Actuator4-52 UART Alarm	[E-0452 3:1 045201D]
  Actuator4-52 HDLC Alarm	[E-0452 3:2 045201C]
  Actuator4-52 Force Card Fault	[E-0452 3:3 045201B]
  Actuator4-52 Force Sensor Fault	[E-0452 3:4 045201A]
  Actuator4-52 Under Range	[E-0452 3:5 0452019]
  Actuator4-52 Over Range	[E-0452 3:6 0452018]
  Actuator4-52 Down Limit	[E-0452 3:7 0452017]
  Actuator4-53 MON PARA	[E-0453 0:0 0453009]
  Actuator4-53 MON HYB	[E-0453 0:1 0453008]
  Actuator4-53 MON Position	[E-0453 0:2 0453007]
  Actuator4-53 MON Force	[E-0453 0:3 0453006]
  Actuator4-53 Drive Off	[E-0453 0:4 0453005]
  Actuator4-53 Drive On	[E-0453 0:5 0453004]
  Actuator4-53 CONT Position	[E-0453 0:6 0453003]
  Actuator4-53 CONT Force	[E-0453 0:7 0453002]
  Actuator4-53 Alarm Reset	[E-0453 1:1 0453020]
  Actuator4-53 Limit Release	[E-0453 1:2 045301F]
  Actuator4-53 Selected Step	[E-0453 1:3 045300E]
  Actuator4-53 Selected Load	[E-0453 1:4 045300D]
  Actuator4-53 Selected Drive	[E-0453 1:5 045300C]
  Actuator4-53 Maunakea	[E-0453 1:6 045300B]
  Actuator4-53 Sea Level	[E-0453 1:7 045300A]
  Actuator4-53 Up Limit	[E-0453 2:0 0453016]
  Actuator4-53 Driver Alarm	[E-0453 2:1 0453015]
  Actuator4-53 Error Alarm	[E-0453 2:2 0453014]
  Actuator4-53 Over Current	[E-0453 2:3 0453013]
  Actuator4-53 Over Speed	[E-0453 2:4 0453012]
  Actuator4-53 Over Load	[E-0453 2:5 0453011]
  Actuator4-53 PS Alarm	[E-0453 2:6 0453010]
  Actuator4-53 ENC Alarm	[E-0453 2:7 045300F]
  Actuator4-53 CPU Alarm	[E-0453 3:0 045301E]
  Actuator4-53 UART Alarm	[E-0453 3:1 045301D]
  Actuator4-53 HDLC Alarm	[E-0453 3:2 045301C]
  Actuator4-53 Force Card Fault	[E-0453 3:3 045301B]
  Actuator4-53 Force Sensor Fault	[E-0453 3:4 045301A]
  Actuator4-53 Under Range	[E-0453 3:5 0453019]
  Actuator4-53 Over Range	[E-0453 3:6 0453018]
  Actuator4-53 Down Limit	[E-0453 3:7 0453017]
  Actuator4-54 MON PARA	[E-0454 0:0 0454009]
  Actuator4-54 MON HYB	[E-0454 0:1 0454008]
  Actuator4-54 MON Position	[E-0454 0:2 0454007]
  Actuator4-54 MON Force	[E-0454 0:3 0454006]
  Actuator4-54 Drive Off	[E-0454 0:4 0454005]
  Actuator4-54 Drive On	[E-0454 0:5 0454004]
  Actuator4-54 CONT Position	[E-0454 0:6 0454003]
  Actuator4-54 CONT Force	[E-0454 0:7 0454002]
  Actuator4-54 Alarm Reset	[E-0454 1:1 0454020]
  Actuator4-54 Limit Release	[E-0454 1:2 045401F]
  Actuator4-54 Selected Step	[E-0454 1:3 045400E]
  Actuator4-54 Selected Load	[E-0454 1:4 045400D]
  Actuator4-54 Selected Drive	[E-0454 1:5 045400C]
  Actuator4-54 Maunakea	[E-0454 1:6 045400B]
  Actuator4-54 Sea Level	[E-0454 1:7 045400A]
  Actuator4-54 Up Limit	[E-0454 2:0 0454016]
  Actuator4-54 Driver Alarm	[E-0454 2:1 0454015]
  Actuator4-54 Error Alarm	[E-0454 2:2 0454014]
  Actuator4-54 Over Current	[E-0454 2:3 0454013]
  Actuator4-54 Over Speed	[E-0454 2:4 0454012]
  Actuator4-54 Over Load	[E-0454 2:5 0454011]
  Actuator4-54 PS Alarm	[E-0454 2:6 0454010]
  Actuator4-54 ENC Alarm	[E-0454 2:7 045400F]
  Actuator4-54 CPU Alarm	[E-0454 3:0 045401E]
  Actuator4-54 UART Alarm	[E-0454 3:1 045401D]
  Actuator4-54 HDLC Alarm	[E-0454 3:2 045401C]
  Actuator4-54 Force Card Fault	[E-0454 3:3 045401B]
  Actuator4-54 Force Sensor Fault	[E-0454 3:4 045401A]
  Actuator4-54 Under Range	[E-0454 3:5 0454019]
  Actuator4-54 Over Range	[E-0454 3:6 0454018]
  Actuator4-54 Down Limit	[E-0454 3:7 0454017]
  Actuator4-55 MON PARA	[E-0455 0:0 0455009]
  Actuator4-55 MON HYB	[E-0455 0:1 0455008]
  Actuator4-55 MON Position	[E-0455 0:2 0455007]
  Actuator4-55 MON Force	[E-0455 0:3 0455006]
  Actuator4-55 Drive Off	[E-0455 0:4 0455005]
  Actuator4-55 Drive On	[E-0455 0:5 0455004]
  Actuator4-55 CONT Position	[E-0455 0:6 0455003]
  Actuator4-55 CONT Force	[E-0455 0:7 0455002]
  Actuator4-55 Alarm Reset	[E-0455 1:1 0455020]
  Actuator4-55 Limit Release	[E-0455 1:2 045501F]
  Actuator4-55 Selected Step	[E-0455 1:3 045500E]
  Actuator4-55 Selected Load	[E-0455 1:4 045500D]
  Actuator4-55 Selected Drive	[E-0455 1:5 045500C]
  Actuator4-55 Maunakea	[E-0455 1:6 045500B]
  Actuator4-55 Sea Level	[E-0455 1:7 045500A]
  Actuator4-55 Up Limit	[E-0455 2:0 0455016]
  Actuator4-55 Driver Alarm	[E-0455 2:1 0455015]
  Actuator4-55 Error Alarm	[E-0455 2:2 0455014]
  Actuator4-55 Over Current	[E-0455 2:3 0455013]
  Actuator4-55 Over Speed	[E-0455 2:4 0455012]
  Actuator4-55 Over Load	[E-0455 2:5 0455011]
  Actuator4-55 PS Alarm	[E-0455 2:6 0455010]
  Actuator4-55 ENC Alarm	[E-0455 2:7 045500F]
  Actuator4-55 CPU Alarm	[E-0455 3:0 045501E]
  Actuator4-55 UART Alarm	[E-0455 3:1 045501D]
  Actuator4-55 HDLC Alarm	[E-0455 3:2 045501C]
  Actuator4-55 Force Card Fault	[E-0455 3:3 045501B]
  Actuator4-55 Force Sensor Fault	[E-0455 3:4 045501A]
  Actuator4-55 Under Range	[E-0455 3:5 0455019]
  Actuator4-55 Over Range	[E-0455 3:6 0455018]
  Actuator4-55 Down Limit	[E-0455 3:7 0455017]
  Actuator4-56 MON PARA	[E-0456 0:0 0456009]
  Actuator4-56 MON HYB	[E-0456 0:1 0456008]
  Actuator4-56 MON Position	[E-0456 0:2 0456007]
  Actuator4-56 MON Force	[E-0456 0:3 0456006]
  Actuator4-56 Drive Off	[E-0456 0:4 0456005]
  Actuator4-56 Drive On	[E-0456 0:5 0456004]
  Actuator4-56 CONT Position	[E-0456 0:6 0456003]
  Actuator4-56 CONT Force	[E-0456 0:7 0456002]
  Actuator4-56 Alarm Reset	[E-0456 1:1 0456020]
  Actuator4-56 Limit Release	[E-0456 1:2 045601F]
  Actuator4-56 Selected Step	[E-0456 1:3 045600E]
  Actuator4-56 Selected Load	[E-0456 1:4 045600D]
  Actuator4-56 Selected Drive	[E-0456 1:5 045600C]
  Actuator4-56 Maunakea	[E-0456 1:6 045600B]
  Actuator4-56 Sea Level	[E-0456 1:7 045600A]
  Actuator4-56 Up Limit	[E-0456 2:0 0456016]
  Actuator4-56 Driver Alarm	[E-0456 2:1 0456015]
  Actuator4-56 Error Alarm	[E-0456 2:2 0456014]
  Actuator4-56 Over Current	[E-0456 2:3 0456013]
  Actuator4-56 Over Speed	[E-0456 2:4 0456012]
  Actuator4-56 Over Load	[E-0456 2:5 0456011]
  Actuator4-56 PS Alarm	[E-0456 2:6 0456010]
  Actuator4-56 ENC Alarm	[E-0456 2:7 045600F]
  Actuator4-56 CPU Alarm	[E-0456 3:0 045601E]
  Actuator4-56 UART Alarm	[E-0456 3:1 045601D]
  Actuator4-56 HDLC Alarm	[E-0456 3:2 045601C]
  Actuator4-56 Force Card Fault	[E-0456 3:3 045601B]
  Actuator4-56 Force Sensor Fault	[E-0456 3:4 045601A]
  Actuator4-56 Under Range	[E-0456 3:5 0456019]
  Actuator4-56 Over Range	[E-0456 3:6 0456018]
  Actuator4-56 Down Limit	[E-0456 3:7 0456017]
  Actuator4-57 MON PARA	[E-0457 0:0 0457009]
  Actuator4-57 MON HYB	[E-0457 0:1 0457008]
  Actuator4-57 MON Position	[E-0457 0:2 0457007]
  Actuator4-57 MON Force	[E-0457 0:3 0457006]
  Actuator4-57 Drive Off	[E-0457 0:4 0457005]
  Actuator4-57 Drive On	[E-0457 0:5 0457004]
  Actuator4-57 CONT Position	[E-0457 0:6 0457003]
  Actuator4-57 CONT Force	[E-0457 0:7 0457002]
  Actuator4-57 Alarm Reset	[E-0457 1:1 0457020]
  Actuator4-57 Limit Release	[E-0457 1:2 045701F]
  Actuator4-57 Selected Step	[E-0457 1:3 045700E]
  Actuator4-57 Selected Load	[E-0457 1:4 045700D]
  Actuator4-57 Selected Drive	[E-0457 1:5 045700C]
  Actuator4-57 Maunakea	[E-0457 1:6 045700B]
  Actuator4-57 Sea Level	[E-0457 1:7 045700A]
  Actuator4-57 Up Limit	[E-0457 2:0 0457016]
  Actuator4-57 Driver Alarm	[E-0457 2:1 0457015]
  Actuator4-57 Error Alarm	[E-0457 2:2 0457014]
  Actuator4-57 Over Current	[E-0457 2:3 0457013]
  Actuator4-57 Over Speed	[E-0457 2:4 0457012]
  Actuator4-57 Over Load	[E-0457 2:5 0457011]
  Actuator4-57 PS Alarm	[E-0457 2:6 0457010]
  Actuator4-57 ENC Alarm	[E-0457 2:7 045700F]
  Actuator4-57 CPU Alarm	[E-0457 3:0 045701E]
  Actuator4-57 UART Alarm	[E-0457 3:1 045701D]
  Actuator4-57 HDLC Alarm	[E-0457 3:2 045701C]
  Actuator4-57 Force Card Fault	[E-0457 3:3 045701B]
  Actuator4-57 Force Sensor Fault	[E-0457 3:4 045701A]
  Actuator4-57 Under Range	[E-0457 3:5 0457019]
  Actuator4-57 Over Range	[E-0457 3:6 0457018]
  Actuator4-57 Down Limit	[E-0457 3:7 0457017]
  Actuator4-58 MON PARA	[E-0458 0:0 0458009]
  Actuator4-58 MON HYB	[E-0458 0:1 0458008]
  Actuator4-58 MON Position	[E-0458 0:2 0458007]
  Actuator4-58 MON Force	[E-0458 0:3 0458006]
  Actuator4-58 Drive Off	[E-0458 0:4 0458005]
  Actuator4-58 Drive On	[E-0458 0:5 0458004]
  Actuator4-58 CONT Position	[E-0458 0:6 0458003]
  Actuator4-58 CONT Force	[E-0458 0:7 0458002]
  Actuator4-58 Alarm Reset	[E-0458 1:1 0458020]
  Actuator4-58 Limit Release	[E-0458 1:2 045801F]
  Actuator4-58 Selected Step	[E-0458 1:3 045800E]
  Actuator4-58 Selected Load	[E-0458 1:4 045800D]
  Actuator4-58 Selected Drive	[E-0458 1:5 045800C]
  Actuator4-58 Maunakea	[E-0458 1:6 045800B]
  Actuator4-58 Sea Level	[E-0458 1:7 045800A]
  Actuator4-58 Up Limit	[E-0458 2:0 0458016]
  Actuator4-58 Driver Alarm	[E-0458 2:1 0458015]
  Actuator4-58 Error Alarm	[E-0458 2:2 0458014]
  Actuator4-58 Over Current	[E-0458 2:3 0458013]
  Actuator4-58 Over Speed	[E-0458 2:4 0458012]
  Actuator4-58 Over Load	[E-0458 2:5 0458011]
  Actuator4-58 PS Alarm	[E-0458 2:6 0458010]
  Actuator4-58 ENC Alarm	[E-0458 2:7 045800F]
  Actuator4-58 CPU Alarm	[E-0458 3:0 045801E]
  Actuator4-58 UART Alarm	[E-0458 3:1 045801D]
  Actuator4-58 HDLC Alarm	[E-0458 3:2 045801C]
  Actuator4-58 Force Card Fault	[E-0458 3:3 045801B]
  Actuator4-58 Force Sensor Fault	[E-0458 3:4 045801A]
  Actuator4-58 Under Range	[E-0458 3:5 0458019]
  Actuator4-58 Over Range	[E-0458 3:6 0458018]
  Actuator4-58 Down Limit	[E-0458 3:7 0458017]
  Actuator4-59 MON PARA	[E-0459 0:0 0459009]
  Actuator4-59 MON HYB	[E-0459 0:1 0459008]
  Actuator4-59 MON Position	[E-0459 0:2 0459007]
  Actuator4-59 MON Force	[E-0459 0:3 0459006]
  Actuator4-59 Drive Off	[E-0459 0:4 0459005]
  Actuator4-59 Drive On	[E-0459 0:5 0459004]
  Actuator4-59 CONT Position	[E-0459 0:6 0459003]
  Actuator4-59 CONT Force	[E-0459 0:7 0459002]
  Actuator4-59 Alarm Reset	[E-0459 1:1 0459020]
  Actuator4-59 Limit Release	[E-0459 1:2 045901F]
  Actuator4-59 Selected Step	[E-0459 1:3 045900E]
  Actuator4-59 Selected Load	[E-0459 1:4 045900D]
  Actuator4-59 Selected Drive	[E-0459 1:5 045900C]
  Actuator4-59 Maunakea	[E-0459 1:6 045900B]
  Actuator4-59 Sea Level	[E-0459 1:7 045900A]
  Actuator4-59 Up Limit	[E-0459 2:0 0459016]
  Actuator4-59 Driver Alarm	[E-0459 2:1 0459015]
  Actuator4-59 Error Alarm	[E-0459 2:2 0459014]
  Actuator4-59 Over Current	[E-0459 2:3 0459013]
  Actuator4-59 Over Speed	[E-0459 2:4 0459012]
  Actuator4-59 Over Load	[E-0459 2:5 0459011]
  Actuator4-59 PS Alarm	[E-0459 2:6 0459010]
  Actuator4-59 ENC Alarm	[E-0459 2:7 045900F]
  Actuator4-59 CPU Alarm	[E-0459 3:0 045901E]
  Actuator4-59 UART Alarm	[E-0459 3:1 045901D]
  Actuator4-59 HDLC Alarm	[E-0459 3:2 045901C]
  Actuator4-59 Force Card Fault	[E-0459 3:3 045901B]
  Actuator4-59 Force Sensor Fault	[E-0459 3:4 045901A]
  Actuator4-59 Under Range	[E-0459 3:5 0459019]
  Actuator4-59 Over Range	[E-0459 3:6 0459018]
  Actuator4-59 Down Limit	[E-0459 3:7 0459017]
  Actuator4-60 MON PARA	[E-0460 0:0 0460009]
  Actuator4-60 MON HYB	[E-0460 0:1 0460008]
  Actuator4-60 MON Position	[E-0460 0:2 0460007]
  Actuator4-60 MON Force	[E-0460 0:3 0460006]
  Actuator4-60 Drive Off	[E-0460 0:4 0460005]
  Actuator4-60 Drive On	[E-0460 0:5 0460004]
  Actuator4-60 CONT Position	[E-0460 0:6 0460003]
  Actuator4-60 CONT Force	[E-0460 0:7 0460002]
  Actuator4-60 Alarm Reset	[E-0460 1:1 0460020]
  Actuator4-60 Limit Release	[E-0460 1:2 046001F]
  Actuator4-60 Selected Step	[E-0460 1:3 046000E]
  Actuator4-60 Selected Load	[E-0460 1:4 046000D]
  Actuator4-60 Selected Drive	[E-0460 1:5 046000C]
  Actuator4-60 Maunakea	[E-0460 1:6 046000B]
  Actuator4-60 Sea Level	[E-0460 1:7 046000A]
  Actuator4-60 Up Limit	[E-0460 2:0 0460016]
  Actuator4-60 Driver Alarm	[E-0460 2:1 0460015]
  Actuator4-60 Error Alarm	[E-0460 2:2 0460014]
  Actuator4-60 Over Current	[E-0460 2:3 0460013]
  Actuator4-60 Over Speed	[E-0460 2:4 0460012]
  Actuator4-60 Over Load	[E-0460 2:5 0460011]
  Actuator4-60 PS Alarm	[E-0460 2:6 0460010]
  Actuator4-60 ENC Alarm	[E-0460 2:7 046000F]
  Actuator4-60 CPU Alarm	[E-0460 3:0 046001E]
  Actuator4-60 UART Alarm	[E-0460 3:1 046001D]
  Actuator4-60 HDLC Alarm	[E-0460 3:2 046001C]
  Actuator4-60 Force Card Fault	[E-0460 3:3 046001B]
  Actuator4-60 Force Sensor Fault	[E-0460 3:4 046001A]
  Actuator4-60 Under Range	[E-0460 3:5 0460019]
  Actuator4-60 Over Range	[E-0460 3:6 0460018]
  Actuator4-60 Down Limit	[E-0460 3:7 0460017]
  Actuator4-61 MON PARA	[E-0461 0:0 0461009]
  Actuator4-61 MON HYB	[E-0461 0:1 0461008]
  Actuator4-61 MON Position	[E-0461 0:2 0461007]
  Actuator4-61 MON Force	[E-0461 0:3 0461006]
  Actuator4-61 Drive Off	[E-0461 0:4 0461005]
  Actuator4-61 Drive On	[E-0461 0:5 0461004]
  Actuator4-61 CONT Position	[E-0461 0:6 0461003]
  Actuator4-61 CONT Force	[E-0461 0:7 0461002]
  Actuator4-61 Alarm Reset	[E-0461 1:1 0461020]
  Actuator4-61 Limit Release	[E-0461 1:2 046101F]
  Actuator4-61 Selected Step	[E-0461 1:3 046100E]
  Actuator4-61 Selected Load	[E-0461 1:4 046100D]
  Actuator4-61 Selected Drive	[E-0461 1:5 046100C]
  Actuator4-61 Maunakea	[E-0461 1:6 046100B]
  Actuator4-61 Sea Level	[E-0461 1:7 046100A]
  Actuator4-61 Up Limit	[E-0461 2:0 0461016]
  Actuator4-61 Driver Alarm	[E-0461 2:1 0461015]
  Actuator4-61 Error Alarm	[E-0461 2:2 0461014]
  Actuator4-61 Over Current	[E-0461 2:3 0461013]
  Actuator4-61 Over Speed	[E-0461 2:4 0461012]
  Actuator4-61 Over Load	[E-0461 2:5 0461011]
  Actuator4-61 PS Alarm	[E-0461 2:6 0461010]
  Actuator4-61 ENC Alarm	[E-0461 2:7 046100F]
  Actuator4-61 CPU Alarm	[E-0461 3:0 046101E]
  Actuator4-61 UART Alarm	[E-0461 3:1 046101D]
  Actuator4-61 HDLC Alarm	[E-0461 3:2 046101C]
  Actuator4-61 Force Card Fault	[E-0461 3:3 046101B]
  Actuator4-61 Force Sensor Fault	[E-0461 3:4 046101A]
  Actuator4-61 Under Range	[E-0461 3:5 0461019]
  Actuator4-61 Over Range	[E-0461 3:6 0461018]
  Actuator4-61 Down Limit	[E-0461 3:7 0461017]
  Actuator4-62 MON PARA	[E-0462 0:0 0462009]
  Actuator4-62 MON HYB	[E-0462 0:1 0462008]
  Actuator4-62 MON Position	[E-0462 0:2 0462007]
  Actuator4-62 MON Force	[E-0462 0:3 0462006]
  Actuator4-62 Drive Off	[E-0462 0:4 0462005]
  Actuator4-62 Drive On	[E-0462 0:5 0462004]
  Actuator4-62 CONT Position	[E-0462 0:6 0462003]
  Actuator4-62 CONT Force	[E-0462 0:7 0462002]
  Actuator4-62 Alarm Reset	[E-0462 1:1 0462020]
  Actuator4-62 Limit Release	[E-0462 1:2 046201F]
  Actuator4-62 Selected Step	[E-0462 1:3 046200E]
  Actuator4-62 Selected Load	[E-0462 1:4 046200D]
  Actuator4-62 Selected Drive	[E-0462 1:5 046200C]
  Actuator4-62 Maunakea	[E-0462 1:6 046200B]
  Actuator4-62 Sea Level	[E-0462 1:7 046200A]
  Actuator4-62 Up Limit	[E-0462 2:0 0462016]
  Actuator4-62 Driver Alarm	[E-0462 2:1 0462015]
  Actuator4-62 Error Alarm	[E-0462 2:2 0462014]
  Actuator4-62 Over Current	[E-0462 2:3 0462013]
  Actuator4-62 Over Speed	[E-0462 2:4 0462012]
  Actuator4-62 Over Load	[E-0462 2:5 0462011]
  Actuator4-62 PS Alarm	[E-0462 2:6 0462010]
  Actuator4-62 ENC Alarm	[E-0462 2:7 046200F]
  Actuator4-62 CPU Alarm	[E-0462 3:0 046201E]
  Actuator4-62 UART Alarm	[E-0462 3:1 046201D]
  Actuator4-62 HDLC Alarm	[E-0462 3:2 046201C]
  Actuator4-62 Force Card Fault	[E-0462 3:3 046201B]
  Actuator4-62 Force Sensor Fault	[E-0462 3:4 046201A]
  Actuator4-62 Under Range	[E-0462 3:5 0462019]
  Actuator4-62 Over Range	[E-0462 3:6 0462018]
  Actuator4-62 Down Limit	[E-0462 3:7 0462017]
  Actuator4-63 MON PARA	[E-0463 0:0 0463009]
  Actuator4-63 MON HYB	[E-0463 0:1 0463008]
  Actuator4-63 MON Position	[E-0463 0:2 0463007]
  Actuator4-63 MON Force	[E-0463 0:3 0463006]
  Actuator4-63 Drive Off	[E-0463 0:4 0463005]
  Actuator4-63 Drive On	[E-0463 0:5 0463004]
  Actuator4-63 CONT Position	[E-0463 0:6 0463003]
  Actuator4-63 CONT Force	[E-0463 0:7 0463002]
  Actuator4-63 Alarm Reset	[E-0463 1:1 0463020]
  Actuator4-63 Limit Release	[E-0463 1:2 046301F]
  Actuator4-63 Selected Step	[E-0463 1:3 046300E]
  Actuator4-63 Selected Load	[E-0463 1:4 046300D]
  Actuator4-63 Selected Drive	[E-0463 1:5 046300C]
  Actuator4-63 Maunakea	[E-0463 1:6 046300B]
  Actuator4-63 Sea Level	[E-0463 1:7 046300A]
  Actuator4-63 Up Limit	[E-0463 2:0 0463016]
  Actuator4-63 Driver Alarm	[E-0463 2:1 0463015]
  Actuator4-63 Error Alarm	[E-0463 2:2 0463014]
  Actuator4-63 Over Current	[E-0463 2:3 0463013]
  Actuator4-63 Over Speed	[E-0463 2:4 0463012]
  Actuator4-63 Over Load	[E-0463 2:5 0463011]
  Actuator4-63 PS Alarm	[E-0463 2:6 0463010]
  Actuator4-63 ENC Alarm	[E-0463 2:7 046300F]
  Actuator4-63 CPU Alarm	[E-0463 3:0 046301E]
  Actuator4-63 UART Alarm	[E-0463 3:1 046301D]
  Actuator4-63 HDLC Alarm	[E-0463 3:2 046301C]
  Actuator4-63 Force Card Fault	[E-0463 3:3 046301B]
  Actuator4-63 Force Sensor Fault	[E-0463 3:4 046301A]
  Actuator4-63 Under Range	[E-0463 3:5 0463019]
  Actuator4-63 Over Range	[E-0463 3:6 0463018]
  Actuator4-63 Down Limit	[E-0463 3:7 0463017]
  Actuator4-64 MON PARA	[E-0464 0:0 0464009]
  Actuator4-64 MON HYB	[E-0464 0:1 0464008]
  Actuator4-64 MON Position	[E-0464 0:2 0464007]
  Actuator4-64 MON Force	[E-0464 0:3 0464006]
  Actuator4-64 Drive Off	[E-0464 0:4 0464005]
  Actuator4-64 Drive On	[E-0464 0:5 0464004]
  Actuator4-64 CONT Position	[E-0464 0:6 0464003]
  Actuator4-64 CONT Force	[E-0464 0:7 0464002]
  Actuator4-64 Alarm Reset	[E-0464 1:1 0464020]
  Actuator4-64 Limit Release	[E-0464 1:2 046401F]
  Actuator4-64 Selected Step	[E-0464 1:3 046400E]
  Actuator4-64 Selected Load	[E-0464 1:4 046400D]
  Actuator4-64 Selected Drive	[E-0464 1:5 046400C]
  Actuator4-64 Maunakea	[E-0464 1:6 046400B]
  Actuator4-64 Sea Level	[E-0464 1:7 046400A]
  Actuator4-64 Up Limit	[E-0464 2:0 0464016]
  Actuator4-64 Driver Alarm	[E-0464 2:1 0464015]
  Actuator4-64 Error Alarm	[E-0464 2:2 0464014]
  Actuator4-64 Over Current	[E-0464 2:3 0464013]
  Actuator4-64 Over Speed	[E-0464 2:4 0464012]
  Actuator4-64 Over Load	[E-0464 2:5 0464011]
  Actuator4-64 PS Alarm	[E-0464 2:6 0464010]
  Actuator4-64 ENC Alarm	[E-0464 2:7 046400F]
  Actuator4-64 CPU Alarm	[E-0464 3:0 046401E]
  Actuator4-64 UART Alarm	[E-0464 3:1 046401D]
  Actuator4-64 HDLC Alarm	[E-0464 3:2 046401C]
  Actuator4-64 Force Card Fault	[E-0464 3:3 046401B]
  Actuator4-64 Force Sensor Fault	[E-0464 3:4 046401A]
  Actuator4-64 Under Range	[E-0464 3:5 0464019]
  Actuator4-64 Over Range	[E-0464 3:6 0464018]
  Actuator4-64 Down Limit	[E-0464 3:7 0464017]
  Actuator4-65 MON PARA	[E-0465 0:0 0465009]
  Actuator4-65 MON HYB	[E-0465 0:1 0465008]
  Actuator4-65 MON Position	[E-0465 0:2 0465007]
  Actuator4-65 MON Force	[E-0465 0:3 0465006]
  Actuator4-65 Drive Off	[E-0465 0:4 0465005]
  Actuator4-65 Drive On	[E-0465 0:5 0465004]
  Actuator4-65 CONT Position	[E-0465 0:6 0465003]
  Actuator4-65 CONT Force	[E-0465 0:7 0465002]
  Actuator4-65 Alarm Reset	[E-0465 1:1 0465020]
  Actuator4-65 Limit Release	[E-0465 1:2 046501F]
  Actuator4-65 Selected Step	[E-0465 1:3 046500E]
  Actuator4-65 Selected Load	[E-0465 1:4 046500D]
  Actuator4-65 Selected Drive	[E-0465 1:5 046500C]
  Actuator4-65 Maunakea	[E-0465 1:6 046500B]
  Actuator4-65 Sea Level	[E-0465 1:7 046500A]
  Actuator4-65 Up Limit	[E-0465 2:0 0465016]
  Actuator4-65 Driver Alarm	[E-0465 2:1 0465015]
  Actuator4-65 Error Alarm	[E-0465 2:2 0465014]
  Actuator4-65 Over Current	[E-0465 2:3 0465013]
  Actuator4-65 Over Speed	[E-0465 2:4 0465012]
  Actuator4-65 Over Load	[E-0465 2:5 0465011]
  Actuator4-65 PS Alarm	[E-0465 2:6 0465010]
  Actuator4-65 ENC Alarm	[E-0465 2:7 046500F]
  Actuator4-65 CPU Alarm	[E-0465 3:0 046501E]
  Actuator4-65 UART Alarm	[E-0465 3:1 046501D]
  Actuator4-65 HDLC Alarm	[E-0465 3:2 046501C]
  Actuator4-65 Force Card Fault	[E-0465 3:3 046501B]
  Actuator4-65 Force Sensor Fault	[E-0465 3:4 046501A]
  Actuator4-65 Under Range	[E-0465 3:5 0465019]
  Actuator4-65 Over Range	[E-0465 3:6 0465018]
  Actuator4-65 Down Limit	[E-0465 3:7 0465017]
  Actuator4-66 MON PARA	[E-0466 0:0 0466009]
  Actuator4-66 MON HYB	[E-0466 0:1 0466008]
  Actuator4-66 MON Position	[E-0466 0:2 0466007]
  Actuator4-66 MON Force	[E-0466 0:3 0466006]
  Actuator4-66 Drive Off	[E-0466 0:4 0466005]
  Actuator4-66 Drive On	[E-0466 0:5 0466004]
  Actuator4-66 CONT Position	[E-0466 0:6 0466003]
  Actuator4-66 CONT Force	[E-0466 0:7 0466002]
  Actuator4-66 Alarm Reset	[E-0466 1:1 0466020]
  Actuator4-66 Limit Release	[E-0466 1:2 046601F]
  Actuator4-66 Selected Step	[E-0466 1:3 046600E]
  Actuator4-66 Selected Load	[E-0466 1:4 046600D]
  Actuator4-66 Selected Drive	[E-0466 1:5 046600C]
  Actuator4-66 Maunakea	[E-0466 1:6 046600B]
  Actuator4-66 Sea Level	[E-0466 1:7 046600A]
  Actuator4-66 Up Limit	[E-0466 2:0 0466016]
  Actuator4-66 Driver Alarm	[E-0466 2:1 0466015]
  Actuator4-66 Error Alarm	[E-0466 2:2 0466014]
  Actuator4-66 Over Current	[E-0466 2:3 0466013]
  Actuator4-66 Over Speed	[E-0466 2:4 0466012]
  Actuator4-66 Over Load	[E-0466 2:5 0466011]
  Actuator4-66 PS Alarm	[E-0466 2:6 0466010]
  Actuator4-66 ENC Alarm	[E-0466 2:7 046600F]
  Actuator4-66 CPU Alarm	[E-0466 3:0 046601E]
  Actuator4-66 UART Alarm	[E-0466 3:1 046601D]
  Actuator4-66 HDLC Alarm	[E-0466 3:2 046601C]
  Actuator4-66 Force Card Fault	[E-0466 3:3 046601B]
  Actuator4-66 Force Sensor Fault	[E-0466 3:4 046601A]
  Actuator4-66 Under Range	[E-0466 3:5 0466019]
  Actuator4-66 Over Range	[E-0466 3:6 0466018]
  Actuator4-66 Down Limit	[E-0466 3:7 0466017]
  Actuator4-67 MON PARA	[E-0467 0:0 0467009]
  Actuator4-67 MON HYB	[E-0467 0:1 0467008]
  Actuator4-67 MON Position	[E-0467 0:2 0467007]
  Actuator4-67 MON Force	[E-0467 0:3 0467006]
  Actuator4-67 Drive Off	[E-0467 0:4 0467005]
  Actuator4-67 Drive On	[E-0467 0:5 0467004]
  Actuator4-67 CONT Position	[E-0467 0:6 0467003]
  Actuator4-67 CONT Force	[E-0467 0:7 0467002]
  Actuator4-67 Alarm Reset	[E-0467 1:1 0467020]
  Actuator4-67 Limit Release	[E-0467 1:2 046701F]
  Actuator4-67 Selected Step	[E-0467 1:3 046700E]
  Actuator4-67 Selected Load	[E-0467 1:4 046700D]
  Actuator4-67 Selected Drive	[E-0467 1:5 046700C]
  Actuator4-67 Maunakea	[E-0467 1:6 046700B]
  Actuator4-67 Sea Level	[E-0467 1:7 046700A]
  Actuator4-67 Up Limit	[E-0467 2:0 0467016]
  Actuator4-67 Driver Alarm	[E-0467 2:1 0467015]
  Actuator4-67 Error Alarm	[E-0467 2:2 0467014]
  Actuator4-67 Over Current	[E-0467 2:3 0467013]
  Actuator4-67 Over Speed	[E-0467 2:4 0467012]
  Actuator4-67 Over Load	[E-0467 2:5 0467011]
  Actuator4-67 PS Alarm	[E-0467 2:6 0467010]
  Actuator4-67 ENC Alarm	[E-0467 2:7 046700F]
  Actuator4-67 CPU Alarm	[E-0467 3:0 046701E]
  Actuator4-67 UART Alarm	[E-0467 3:1 046701D]
  Actuator4-67 HDLC Alarm	[E-0467 3:2 046701C]
  Actuator4-67 Force Card Fault	[E-0467 3:3 046701B]
  Actuator4-67 Force Sensor Fault	[E-0467 3:4 046701A]
  Actuator4-67 Under Range	[E-0467 3:5 0467019]
  Actuator4-67 Over Range	[E-0467 3:6 0467018]
  Actuator4-67 Down Limit	[E-0467 3:7 0467017]
  Actuator4-68 MON PARA	[E-0468 0:0 0468009]
  Actuator4-68 MON HYB	[E-0468 0:1 0468008]
  Actuator4-68 MON Position	[E-0468 0:2 0468007]
  Actuator4-68 MON Force	[E-0468 0:3 0468006]
  Actuator4-68 Drive Off	[E-0468 0:4 0468005]
  Actuator4-68 Drive On	[E-0468 0:5 0468004]
  Actuator4-68 CONT Position	[E-0468 0:6 0468003]
  Actuator4-68 CONT Force	[E-0468 0:7 0468002]
  Actuator4-68 Alarm Reset	[E-0468 1:1 0468020]
  Actuator4-68 Limit Release	[E-0468 1:2 046801F]
  Actuator4-68 Selected Step	[E-0468 1:3 046800E]
  Actuator4-68 Selected Load	[E-0468 1:4 046800D]
  Actuator4-68 Selected Drive	[E-0468 1:5 046800C]
  Actuator4-68 Maunakea	[E-0468 1:6 046800B]
  Actuator4-68 Sea Level	[E-0468 1:7 046800A]
  Actuator4-68 Up Limit	[E-0468 2:0 0468016]
  Actuator4-68 Driver Alarm	[E-0468 2:1 0468015]
  Actuator4-68 Error Alarm	[E-0468 2:2 0468014]
  Actuator4-68 Over Current	[E-0468 2:3 0468013]
  Actuator4-68 Over Speed	[E-0468 2:4 0468012]
  Actuator4-68 Over Load	[E-0468 2:5 0468011]
  Actuator4-68 PS Alarm	[E-0468 2:6 0468010]
  Actuator4-68 ENC Alarm	[E-0468 2:7 046800F]
  Actuator4-68 CPU Alarm	[E-0468 3:0 046801E]
  Actuator4-68 UART Alarm	[E-0468 3:1 046801D]
  Actuator4-68 HDLC Alarm	[E-0468 3:2 046801C]
  Actuator4-68 Force Card Fault	[E-0468 3:3 046801B]
  Actuator4-68 Force Sensor Fault	[E-0468 3:4 046801A]
  Actuator4-68 Under Range	[E-0468 3:5 0468019]
  Actuator4-68 Over Range	[E-0468 3:6 0468018]
  Actuator4-68 Down Limit	[E-0468 3:7 0468017]
  Actuator4-69 MON PARA	[E-0469 0:0 0469009]
  Actuator4-69 MON HYB	[E-0469 0:1 0469008]
  Actuator4-69 MON Position	[E-0469 0:2 0469007]
  Actuator4-69 MON Force	[E-0469 0:3 0469006]
  Actuator4-69 Drive Off	[E-0469 0:4 0469005]
  Actuator4-69 Drive On	[E-0469 0:5 0469004]
  Actuator4-69 CONT Position	[E-0469 0:6 0469003]
  Actuator4-69 CONT Force	[E-0469 0:7 0469002]
  Actuator4-69 Alarm Reset	[E-0469 1:1 0469020]
  Actuator4-69 Limit Release	[E-0469 1:2 046901F]
  Actuator4-69 Selected Step	[E-0469 1:3 046900E]
  Actuator4-69 Selected Load	[E-0469 1:4 046900D]
  Actuator4-69 Selected Drive	[E-0469 1:5 046900C]
  Actuator4-69 Maunakea	[E-0469 1:6 046900B]
  Actuator4-69 Sea Level	[E-0469 1:7 046900A]
  Actuator4-69 Up Limit	[E-0469 2:0 0469016]
  Actuator4-69 Driver Alarm	[E-0469 2:1 0469015]
  Actuator4-69 Error Alarm	[E-0469 2:2 0469014]
  Actuator4-69 Over Current	[E-0469 2:3 0469013]
  Actuator4-69 Over Speed	[E-0469 2:4 0469012]
  Actuator4-69 Over Load	[E-0469 2:5 0469011]
  Actuator4-69 PS Alarm	[E-0469 2:6 0469010]
  Actuator4-69 ENC Alarm	[E-0469 2:7 046900F]
  Actuator4-69 CPU Alarm	[E-0469 3:0 046901E]
  Actuator4-69 UART Alarm	[E-0469 3:1 046901D]
  Actuator4-69 HDLC Alarm	[E-0469 3:2 046901C]
  Actuator4-69 Force Card Fault	[E-0469 3:3 046901B]
  Actuator4-69 Force Sensor Fault	[E-0469 3:4 046901A]
  Actuator4-69 Under Range	[E-0469 3:5 0469019]
  Actuator4-69 Over Range	[E-0469 3:6 0469018]
  Actuator4-69 Down Limit	[E-0469 3:7 0469017]
  Actuator5-00 MON PARA	[E-0500 0:0 0500009]
  Actuator5-00 MON HYB	[E-0500 0:1 0500008]
  Actuator5-00 MON Position	[E-0500 0:2 0500007]
  Actuator5-00 MON Force	[E-0500 0:3 0500006]
  Actuator5-00 Drive Off	[E-0500 0:4 0500005]
  Actuator5-00 Drive On	[E-0500 0:5 0500004]
  Actuator5-00 CONT Position	[E-0500 0:6 0500003]
  Actuator5-00 CONT Force	[E-0500 0:7 0500002]
  Actuator5-00 Alarm Reset	[E-0500 1:1 0500020]
  Actuator5-00 Limit Release	[E-0500 1:2 050001F]
  Actuator5-00 Selected Step	[E-0500 1:3 050000E]
  Actuator5-00 Selected Load	[E-0500 1:4 050000D]
  Actuator5-00 Selected Drive	[E-0500 1:5 050000C]
  Actuator5-00 Maunakea	[E-0500 1:6 050000B]
  Actuator5-00 Sea Level	[E-0500 1:7 050000A]
  Actuator5-00 Up Limit	[E-0500 2:0 0500016]
  Actuator5-00 Driver Alarm	[E-0500 2:1 0500015]
  Actuator5-00 Error Alarm	[E-0500 2:2 0500014]
  Actuator5-00 Over Current	[E-0500 2:3 0500013]
  Actuator5-00 Over Speed	[E-0500 2:4 0500012]
  Actuator5-00 Over Load	[E-0500 2:5 0500011]
  Actuator5-00 PS Alarm	[E-0500 2:6 0500010]
  Actuator5-00 ENC Alarm	[E-0500 2:7 050000F]
  Actuator5-00 CPU Alarm	[E-0500 3:0 050001E]
  Actuator5-00 UART Alarm	[E-0500 3:1 050001D]
  Actuator5-00 HDLC Alarm	[E-0500 3:2 050001C]
  Actuator5-00 Force Card Fault	[E-0500 3:3 050001B]
  Actuator5-00 Force Sensor Fault	[E-0500 3:4 050001A]
  Actuator5-00 Under Range	[E-0500 3:5 0500019]
  Actuator5-00 Over Range	[E-0500 3:6 0500018]
  Actuator5-00 Down Limit	[E-0500 3:7 0500017]
  Actuator5-01 MON PARA	[E-0501 0:0 0501009]
  Actuator5-01 MON HYB	[E-0501 0:1 0501008]
  Actuator5-01 MON Position	[E-0501 0:2 0501007]
  Actuator5-01 MON Force	[E-0501 0:3 0501006]
  Actuator5-01 Drive Off	[E-0501 0:4 0501005]
  Actuator5-01 Drive On	[E-0501 0:5 0501004]
  Actuator5-01 CONT Position	[E-0501 0:6 0501003]
  Actuator5-01 CONT Force	[E-0501 0:7 0501002]
  Actuator5-01 Alarm Reset	[E-0501 1:1 0501020]
  Actuator5-01 Limit Release	[E-0501 1:2 050101F]
  Actuator5-01 Selected Step	[E-0501 1:3 050100E]
  Actuator5-01 Selected Load	[E-0501 1:4 050100D]
  Actuator5-01 Selected Drive	[E-0501 1:5 050100C]
  Actuator5-01 Maunakea	[E-0501 1:6 050100B]
  Actuator5-01 Sea Level	[E-0501 1:7 050100A]
  Actuator5-01 Up Limit	[E-0501 2:0 0501016]
  Actuator5-01 Driver Alarm	[E-0501 2:1 0501015]
  Actuator5-01 Error Alarm	[E-0501 2:2 0501014]
  Actuator5-01 Over Current	[E-0501 2:3 0501013]
  Actuator5-01 Over Speed	[E-0501 2:4 0501012]
  Actuator5-01 Over Load	[E-0501 2:5 0501011]
  Actuator5-01 PS Alarm	[E-0501 2:6 0501010]
  Actuator5-01 ENC Alarm	[E-0501 2:7 050100F]
  Actuator5-01 CPU Alarm	[E-0501 3:0 050101E]
  Actuator5-01 UART Alarm	[E-0501 3:1 050101D]
  Actuator5-01 HDLC Alarm	[E-0501 3:2 050101C]
  Actuator5-01 Force Card Fault	[E-0501 3:3 050101B]
  Actuator5-01 Force Sensor Fault	[E-0501 3:4 050101A]
  Actuator5-01 Under Range	[E-0501 3:5 0501019]
  Actuator5-01 Over Range	[E-0501 3:6 0501018]
  Actuator5-01 Down Limit	[E-0501 3:7 0501017]
  Actuator5-02 MON PARA	[E-0502 0:0 0502009]
  Actuator5-02 MON HYB	[E-0502 0:1 0502008]
  Actuator5-02 MON Position	[E-0502 0:2 0502007]
  Actuator5-02 MON Force	[E-0502 0:3 0502006]
  Actuator5-02 Drive Off	[E-0502 0:4 0502005]
  Actuator5-02 Drive On	[E-0502 0:5 0502004]
  Actuator5-02 CONT Position	[E-0502 0:6 0502003]
  Actuator5-02 CONT Force	[E-0502 0:7 0502002]
  Actuator5-02 Alarm Reset	[E-0502 1:1 0502020]
  Actuator5-02 Limit Release	[E-0502 1:2 050201F]
  Actuator5-02 Selected Step	[E-0502 1:3 050200E]
  Actuator5-02 Selected Load	[E-0502 1:4 050200D]
  Actuator5-02 Selected Drive	[E-0502 1:5 050200C]
  Actuator5-02 Maunakea	[E-0502 1:6 050200B]
  Actuator5-02 Sea Level	[E-0502 1:7 050200A]
  Actuator5-02 Up Limit	[E-0502 2:0 0502016]
  Actuator5-02 Driver Alarm	[E-0502 2:1 0502015]
  Actuator5-02 Error Alarm	[E-0502 2:2 0502014]
  Actuator5-02 Over Current	[E-0502 2:3 0502013]
  Actuator5-02 Over Speed	[E-0502 2:4 0502012]
  Actuator5-02 Over Load	[E-0502 2:5 0502011]
  Actuator5-02 PS Alarm	[E-0502 2:6 0502010]
  Actuator5-02 ENC Alarm	[E-0502 2:7 050200F]
  Actuator5-02 CPU Alarm	[E-0502 3:0 050201E]
  Actuator5-02 UART Alarm	[E-0502 3:1 050201D]
  Actuator5-02 HDLC Alarm	[E-0502 3:2 050201C]
  Actuator5-02 Force Card Fault	[E-0502 3:3 050201B]
  Actuator5-02 Force Sensor Fault	[E-0502 3:4 050201A]
  Actuator5-02 Under Range	[E-0502 3:5 0502019]
  Actuator5-02 Over Range	[E-0502 3:6 0502018]
  Actuator5-02 Down Limit	[E-0502 3:7 0502017]
  Actuator5-03 MON PARA	[E-0503 0:0 0503009]
  Actuator5-03 MON HYB	[E-0503 0:1 0503008]
  Actuator5-03 MON Position	[E-0503 0:2 0503007]
  Actuator5-03 MON Force	[E-0503 0:3 0503006]
  Actuator5-03 Drive Off	[E-0503 0:4 0503005]
  Actuator5-03 Drive On	[E-0503 0:5 0503004]
  Actuator5-03 CONT Position	[E-0503 0:6 0503003]
  Actuator5-03 CONT Force	[E-0503 0:7 0503002]
  Actuator5-03 Alarm Reset	[E-0503 1:1 0503020]
  Actuator5-03 Limit Release	[E-0503 1:2 050301F]
  Actuator5-03 Selected Step	[E-0503 1:3 050300E]
  Actuator5-03 Selected Load	[E-0503 1:4 050300D]
  Actuator5-03 Selected Drive	[E-0503 1:5 050300C]
  Actuator5-03 Maunakea	[E-0503 1:6 050300B]
  Actuator5-03 Sea Level	[E-0503 1:7 050300A]
  Actuator5-03 Up Limit	[E-0503 2:0 0503016]
  Actuator5-03 Driver Alarm	[E-0503 2:1 0503015]
  Actuator5-03 Error Alarm	[E-0503 2:2 0503014]
  Actuator5-03 Over Current	[E-0503 2:3 0503013]
  Actuator5-03 Over Speed	[E-0503 2:4 0503012]
  Actuator5-03 Over Load	[E-0503 2:5 0503011]
  Actuator5-03 PS Alarm	[E-0503 2:6 0503010]
  Actuator5-03 ENC Alarm	[E-0503 2:7 050300F]
  Actuator5-03 CPU Alarm	[E-0503 3:0 050301E]
  Actuator5-03 UART Alarm	[E-0503 3:1 050301D]
  Actuator5-03 HDLC Alarm	[E-0503 3:2 050301C]
  Actuator5-03 Force Card Fault	[E-0503 3:3 050301B]
  Actuator5-03 Force Sensor Fault	[E-0503 3:4 050301A]
  Actuator5-03 Under Range	[E-0503 3:5 0503019]
  Actuator5-03 Over Range	[E-0503 3:6 0503018]
  Actuator5-03 Down Limit	[E-0503 3:7 0503017]
  Actuator5-04 MON PARA	[E-0504 0:0 0504009]
  Actuator5-04 MON HYB	[E-0504 0:1 0504008]
  Actuator5-04 MON Position	[E-0504 0:2 0504007]
  Actuator5-04 MON Force	[E-0504 0:3 0504006]
  Actuator5-04 Drive Off	[E-0504 0:4 0504005]
  Actuator5-04 Drive On	[E-0504 0:5 0504004]
  Actuator5-04 CONT Position	[E-0504 0:6 0504003]
  Actuator5-04 CONT Force	[E-0504 0:7 0504002]
  Actuator5-04 Alarm Reset	[E-0504 1:1 0504020]
  Actuator5-04 Limit Release	[E-0504 1:2 050401F]
  Actuator5-04 Selected Step	[E-0504 1:3 050400E]
  Actuator5-04 Selected Load	[E-0504 1:4 050400D]
  Actuator5-04 Selected Drive	[E-0504 1:5 050400C]
  Actuator5-04 Maunakea	[E-0504 1:6 050400B]
  Actuator5-04 Sea Level	[E-0504 1:7 050400A]
  Actuator5-04 Up Limit	[E-0504 2:0 0504016]
  Actuator5-04 Driver Alarm	[E-0504 2:1 0504015]
  Actuator5-04 Error Alarm	[E-0504 2:2 0504014]
  Actuator5-04 Over Current	[E-0504 2:3 0504013]
  Actuator5-04 Over Speed	[E-0504 2:4 0504012]
  Actuator5-04 Over Load	[E-0504 2:5 0504011]
  Actuator5-04 PS Alarm	[E-0504 2:6 0504010]
  Actuator5-04 ENC Alarm	[E-0504 2:7 050400F]
  Actuator5-04 CPU Alarm	[E-0504 3:0 050401E]
  Actuator5-04 UART Alarm	[E-0504 3:1 050401D]
  Actuator5-04 HDLC Alarm	[E-0504 3:2 050401C]
  Actuator5-04 Force Card Fault	[E-0504 3:3 050401B]
  Actuator5-04 Force Sensor Fault	[E-0504 3:4 050401A]
  Actuator5-04 Under Range	[E-0504 3:5 0504019]
  Actuator5-04 Over Range	[E-0504 3:6 0504018]
  Actuator5-04 Down Limit	[E-0504 3:7 0504017]
  Actuator5-05 MON PARA	[E-0505 0:0 0505009]
  Actuator5-05 MON HYB	[E-0505 0:1 0505008]
  Actuator5-05 MON Position	[E-0505 0:2 0505007]
  Actuator5-05 MON Force	[E-0505 0:3 0505006]
  Actuator5-05 Drive Off	[E-0505 0:4 0505005]
  Actuator5-05 Drive On	[E-0505 0:5 0505004]
  Actuator5-05 CONT Position	[E-0505 0:6 0505003]
  Actuator5-05 CONT Force	[E-0505 0:7 0505002]
  Actuator5-05 Alarm Reset	[E-0505 1:1 0505020]
  Actuator5-05 Limit Release	[E-0505 1:2 050501F]
  Actuator5-05 Selected Step	[E-0505 1:3 050500E]
  Actuator5-05 Selected Load	[E-0505 1:4 050500D]
  Actuator5-05 Selected Drive	[E-0505 1:5 050500C]
  Actuator5-05 Maunakea	[E-0505 1:6 050500B]
  Actuator5-05 Sea Level	[E-0505 1:7 050500A]
  Actuator5-05 Up Limit	[E-0505 2:0 0505016]
  Actuator5-05 Driver Alarm	[E-0505 2:1 0505015]
  Actuator5-05 Error Alarm	[E-0505 2:2 0505014]
  Actuator5-05 Over Current	[E-0505 2:3 0505013]
  Actuator5-05 Over Speed	[E-0505 2:4 0505012]
  Actuator5-05 Over Load	[E-0505 2:5 0505011]
  Actuator5-05 PS Alarm	[E-0505 2:6 0505010]
  Actuator5-05 ENC Alarm	[E-0505 2:7 050500F]
  Actuator5-05 CPU Alarm	[E-0505 3:0 050501E]
  Actuator5-05 UART Alarm	[E-0505 3:1 050501D]
  Actuator5-05 HDLC Alarm	[E-0505 3:2 050501C]
  Actuator5-05 Force Card Fault	[E-0505 3:3 050501B]
  Actuator5-05 Force Sensor Fault	[E-0505 3:4 050501A]
  Actuator5-05 Under Range	[E-0505 3:5 0505019]
  Actuator5-05 Over Range	[E-0505 3:6 0505018]
  Actuator5-05 Down Limit	[E-0505 3:7 0505017]
  Actuator5-06 MON PARA	[E-0506 0:0 0506009]
  Actuator5-06 MON HYB	[E-0506 0:1 0506008]
  Actuator5-06 MON Position	[E-0506 0:2 0506007]
  Actuator5-06 MON Force	[E-0506 0:3 0506006]
  Actuator5-06 Drive Off	[E-0506 0:4 0506005]
  Actuator5-06 Drive On	[E-0506 0:5 0506004]
  Actuator5-06 CONT Position	[E-0506 0:6 0506003]
  Actuator5-06 CONT Force	[E-0506 0:7 0506002]
  Actuator5-06 Alarm Reset	[E-0506 1:1 0506020]
  Actuator5-06 Limit Release	[E-0506 1:2 050601F]
  Actuator5-06 Selected Step	[E-0506 1:3 050600E]
  Actuator5-06 Selected Load	[E-0506 1:4 050600D]
  Actuator5-06 Selected Drive	[E-0506 1:5 050600C]
  Actuator5-06 Maunakea	[E-0506 1:6 050600B]
  Actuator5-06 Sea Level	[E-0506 1:7 050600A]
  Actuator5-06 Up Limit	[E-0506 2:0 0506016]
  Actuator5-06 Driver Alarm	[E-0506 2:1 0506015]
  Actuator5-06 Error Alarm	[E-0506 2:2 0506014]
  Actuator5-06 Over Current	[E-0506 2:3 0506013]
  Actuator5-06 Over Speed	[E-0506 2:4 0506012]
  Actuator5-06 Over Load	[E-0506 2:5 0506011]
  Actuator5-06 PS Alarm	[E-0506 2:6 0506010]
  Actuator5-06 ENC Alarm	[E-0506 2:7 050600F]
  Actuator5-06 CPU Alarm	[E-0506 3:0 050601E]
  Actuator5-06 UART Alarm	[E-0506 3:1 050601D]
  Actuator5-06 HDLC Alarm	[E-0506 3:2 050601C]
  Actuator5-06 Force Card Fault	[E-0506 3:3 050601B]
  Actuator5-06 Force Sensor Fault	[E-0506 3:4 050601A]
  Actuator5-06 Under Range	[E-0506 3:5 0506019]
  Actuator5-06 Over Range	[E-0506 3:6 0506018]
  Actuator5-06 Down Limit	[E-0506 3:7 0506017]
  Actuator5-07 MON PARA	[E-0507 0:0 0507009]
  Actuator5-07 MON HYB	[E-0507 0:1 0507008]
  Actuator5-07 MON Position	[E-0507 0:2 0507007]
  Actuator5-07 MON Force	[E-0507 0:3 0507006]
  Actuator5-07 Drive Off	[E-0507 0:4 0507005]
  Actuator5-07 Drive On	[E-0507 0:5 0507004]
  Actuator5-07 CONT Position	[E-0507 0:6 0507003]
  Actuator5-07 CONT Force	[E-0507 0:7 0507002]
  Actuator5-07 Alarm Reset	[E-0507 1:1 0507020]
  Actuator5-07 Limit Release	[E-0507 1:2 050701F]
  Actuator5-07 Selected Step	[E-0507 1:3 050700E]
  Actuator5-07 Selected Load	[E-0507 1:4 050700D]
  Actuator5-07 Selected Drive	[E-0507 1:5 050700C]
  Actuator5-07 Maunakea	[E-0507 1:6 050700B]
  Actuator5-07 Sea Level	[E-0507 1:7 050700A]
  Actuator5-07 Up Limit	[E-0507 2:0 0507016]
  Actuator5-07 Driver Alarm	[E-0507 2:1 0507015]
  Actuator5-07 Error Alarm	[E-0507 2:2 0507014]
  Actuator5-07 Over Current	[E-0507 2:3 0507013]
  Actuator5-07 Over Speed	[E-0507 2:4 0507012]
  Actuator5-07 Over Load	[E-0507 2:5 0507011]
  Actuator5-07 PS Alarm	[E-0507 2:6 0507010]
  Actuator5-07 ENC Alarm	[E-0507 2:7 050700F]
  Actuator5-07 CPU Alarm	[E-0507 3:0 050701E]
  Actuator5-07 UART Alarm	[E-0507 3:1 050701D]
  Actuator5-07 HDLC Alarm	[E-0507 3:2 050701C]
  Actuator5-07 Force Card Fault	[E-0507 3:3 050701B]
  Actuator5-07 Force Sensor Fault	[E-0507 3:4 050701A]
  Actuator5-07 Under Range	[E-0507 3:5 0507019]
  Actuator5-07 Over Range	[E-0507 3:6 0507018]
  Actuator5-07 Down Limit	[E-0507 3:7 0507017]
  Actuator5-08 MON PARA	[E-0508 0:0 0508009]
  Actuator5-08 MON HYB	[E-0508 0:1 0508008]
  Actuator5-08 MON Position	[E-0508 0:2 0508007]
  Actuator5-08 MON Force	[E-0508 0:3 0508006]
  Actuator5-08 Drive Off	[E-0508 0:4 0508005]
  Actuator5-08 Drive On	[E-0508 0:5 0508004]
  Actuator5-08 CONT Position	[E-0508 0:6 0508003]
  Actuator5-08 CONT Force	[E-0508 0:7 0508002]
  Actuator5-08 Alarm Reset	[E-0508 1:1 0508020]
  Actuator5-08 Limit Release	[E-0508 1:2 050801F]
  Actuator5-08 Selected Step	[E-0508 1:3 050800E]
  Actuator5-08 Selected Load	[E-0508 1:4 050800D]
  Actuator5-08 Selected Drive	[E-0508 1:5 050800C]
  Actuator5-08 Maunakea	[E-0508 1:6 050800B]
  Actuator5-08 Sea Level	[E-0508 1:7 050800A]
  Actuator5-08 Up Limit	[E-0508 2:0 0508016]
  Actuator5-08 Driver Alarm	[E-0508 2:1 0508015]
  Actuator5-08 Error Alarm	[E-0508 2:2 0508014]
  Actuator5-08 Over Current	[E-0508 2:3 0508013]
  Actuator5-08 Over Speed	[E-0508 2:4 0508012]
  Actuator5-08 Over Load	[E-0508 2:5 0508011]
  Actuator5-08 PS Alarm	[E-0508 2:6 0508010]
  Actuator5-08 ENC Alarm	[E-0508 2:7 050800F]
  Actuator5-08 CPU Alarm	[E-0508 3:0 050801E]
  Actuator5-08 UART Alarm	[E-0508 3:1 050801D]
  Actuator5-08 HDLC Alarm	[E-0508 3:2 050801C]
  Actuator5-08 Force Card Fault	[E-0508 3:3 050801B]
  Actuator5-08 Force Sensor Fault	[E-0508 3:4 050801A]
  Actuator5-08 Under Range	[E-0508 3:5 0508019]
  Actuator5-08 Over Range	[E-0508 3:6 0508018]
  Actuator5-08 Down Limit	[E-0508 3:7 0508017]
  Actuator5-09 MON PARA	[E-0509 0:0 0509009]
  Actuator5-09 MON HYB	[E-0509 0:1 0509008]
  Actuator5-09 MON Position	[E-0509 0:2 0509007]
  Actuator5-09 MON Force	[E-0509 0:3 0509006]
  Actuator5-09 Drive Off	[E-0509 0:4 0509005]
  Actuator5-09 Drive On	[E-0509 0:5 0509004]
  Actuator5-09 CONT Position	[E-0509 0:6 0509003]
  Actuator5-09 CONT Force	[E-0509 0:7 0509002]
  Actuator5-09 Alarm Reset	[E-0509 1:1 0509020]
  Actuator5-09 Limit Release	[E-0509 1:2 050901F]
  Actuator5-09 Selected Step	[E-0509 1:3 050900E]
  Actuator5-09 Selected Load	[E-0509 1:4 050900D]
  Actuator5-09 Selected Drive	[E-0509 1:5 050900C]
  Actuator5-09 Maunakea	[E-0509 1:6 050900B]
  Actuator5-09 Sea Level	[E-0509 1:7 050900A]
  Actuator5-09 Up Limit	[E-0509 2:0 0509016]
  Actuator5-09 Driver Alarm	[E-0509 2:1 0509015]
  Actuator5-09 Error Alarm	[E-0509 2:2 0509014]
  Actuator5-09 Over Current	[E-0509 2:3 0509013]
  Actuator5-09 Over Speed	[E-0509 2:4 0509012]
  Actuator5-09 Over Load	[E-0509 2:5 0509011]
  Actuator5-09 PS Alarm	[E-0509 2:6 0509010]
  Actuator5-09 ENC Alarm	[E-0509 2:7 050900F]
  Actuator5-09 CPU Alarm	[E-0509 3:0 050901E]
  Actuator5-09 UART Alarm	[E-0509 3:1 050901D]
  Actuator5-09 HDLC Alarm	[E-0509 3:2 050901C]
  Actuator5-09 Force Card Fault	[E-0509 3:3 050901B]
  Actuator5-09 Force Sensor Fault	[E-0509 3:4 050901A]
  Actuator5-09 Under Range	[E-0509 3:5 0509019]
  Actuator5-09 Over Range	[E-0509 3:6 0509018]
  Actuator5-09 Down Limit	[E-0509 3:7 0509017]
  Actuator5-10 MON PARA	[E-0510 0:0 0510009]
  Actuator5-10 MON HYB	[E-0510 0:1 0510008]
  Actuator5-10 MON Position	[E-0510 0:2 0510007]
  Actuator5-10 MON Force	[E-0510 0:3 0510006]
  Actuator5-10 Drive Off	[E-0510 0:4 0510005]
  Actuator5-10 Drive On	[E-0510 0:5 0510004]
  Actuator5-10 CONT Position	[E-0510 0:6 0510003]
  Actuator5-10 CONT Force	[E-0510 0:7 0510002]
  Actuator5-10 Alarm Reset	[E-0510 1:1 0510020]
  Actuator5-10 Limit Release	[E-0510 1:2 051001F]
  Actuator5-10 Selected Step	[E-0510 1:3 051000E]
  Actuator5-10 Selected Load	[E-0510 1:4 051000D]
  Actuator5-10 Selected Drive	[E-0510 1:5 051000C]
  Actuator5-10 Maunakea	[E-0510 1:6 051000B]
  Actuator5-10 Sea Level	[E-0510 1:7 051000A]
  Actuator5-10 Up Limit	[E-0510 2:0 0510016]
  Actuator5-10 Driver Alarm	[E-0510 2:1 0510015]
  Actuator5-10 Error Alarm	[E-0510 2:2 0510014]
  Actuator5-10 Over Current	[E-0510 2:3 0510013]
  Actuator5-10 Over Speed	[E-0510 2:4 0510012]
  Actuator5-10 Over Load	[E-0510 2:5 0510011]
  Actuator5-10 PS Alarm	[E-0510 2:6 0510010]
  Actuator5-10 ENC Alarm	[E-0510 2:7 051000F]
  Actuator5-10 CPU Alarm	[E-0510 3:0 051001E]
  Actuator5-10 UART Alarm	[E-0510 3:1 051001D]
  Actuator5-10 HDLC Alarm	[E-0510 3:2 051001C]
  Actuator5-10 Force Card Fault	[E-0510 3:3 051001B]
  Actuator5-10 Force Sensor Fault	[E-0510 3:4 051001A]
  Actuator5-10 Under Range	[E-0510 3:5 0510019]
  Actuator5-10 Over Range	[E-0510 3:6 0510018]
  Actuator5-10 Down Limit	[E-0510 3:7 0510017]
  Actuator5-11 MON PARA	[E-0511 0:0 0511009]
  Actuator5-11 MON HYB	[E-0511 0:1 0511008]
  Actuator5-11 MON Position	[E-0511 0:2 0511007]
  Actuator5-11 MON Force	[E-0511 0:3 0511006]
  Actuator5-11 Drive Off	[E-0511 0:4 0511005]
  Actuator5-11 Drive On	[E-0511 0:5 0511004]
  Actuator5-11 CONT Position	[E-0511 0:6 0511003]
  Actuator5-11 CONT Force	[E-0511 0:7 0511002]
  Actuator5-11 Alarm Reset	[E-0511 1:1 0511020]
  Actuator5-11 Limit Release	[E-0511 1:2 051101F]
  Actuator5-11 Selected Step	[E-0511 1:3 051100E]
  Actuator5-11 Selected Load	[E-0511 1:4 051100D]
  Actuator5-11 Selected Drive	[E-0511 1:5 051100C]
  Actuator5-11 Maunakea	[E-0511 1:6 051100B]
  Actuator5-11 Sea Level	[E-0511 1:7 051100A]
  Actuator5-11 Up Limit	[E-0511 2:0 0511016]
  Actuator5-11 Driver Alarm	[E-0511 2:1 0511015]
  Actuator5-11 Error Alarm	[E-0511 2:2 0511014]
  Actuator5-11 Over Current	[E-0511 2:3 0511013]
  Actuator5-11 Over Speed	[E-0511 2:4 0511012]
  Actuator5-11 Over Load	[E-0511 2:5 0511011]
  Actuator5-11 PS Alarm	[E-0511 2:6 0511010]
  Actuator5-11 ENC Alarm	[E-0511 2:7 051100F]
  Actuator5-11 CPU Alarm	[E-0511 3:0 051101E]
  Actuator5-11 UART Alarm	[E-0511 3:1 051101D]
  Actuator5-11 HDLC Alarm	[E-0511 3:2 051101C]
  Actuator5-11 Force Card Fault	[E-0511 3:3 051101B]
  Actuator5-11 Force Sensor Fault	[E-0511 3:4 051101A]
  Actuator5-11 Under Range	[E-0511 3:5 0511019]
  Actuator5-11 Over Range	[E-0511 3:6 0511018]
  Actuator5-11 Down Limit	[E-0511 3:7 0511017]
  Actuator5-12 MON PARA	[E-0512 0:0 0512009]
  Actuator5-12 MON HYB	[E-0512 0:1 0512008]
  Actuator5-12 MON Position	[E-0512 0:2 0512007]
  Actuator5-12 MON Force	[E-0512 0:3 0512006]
  Actuator5-12 Drive Off	[E-0512 0:4 0512005]
  Actuator5-12 Drive On	[E-0512 0:5 0512004]
  Actuator5-12 CONT Position	[E-0512 0:6 0512003]
  Actuator5-12 CONT Force	[E-0512 0:7 0512002]
  Actuator5-12 Alarm Reset	[E-0512 1:1 0512020]
  Actuator5-12 Limit Release	[E-0512 1:2 051201F]
  Actuator5-12 Selected Step	[E-0512 1:3 051200E]
  Actuator5-12 Selected Load	[E-0512 1:4 051200D]
  Actuator5-12 Selected Drive	[E-0512 1:5 051200C]
  Actuator5-12 Maunakea	[E-0512 1:6 051200B]
  Actuator5-12 Sea Level	[E-0512 1:7 051200A]
  Actuator5-12 Up Limit	[E-0512 2:0 0512016]
  Actuator5-12 Driver Alarm	[E-0512 2:1 0512015]
  Actuator5-12 Error Alarm	[E-0512 2:2 0512014]
  Actuator5-12 Over Current	[E-0512 2:3 0512013]
  Actuator5-12 Over Speed	[E-0512 2:4 0512012]
  Actuator5-12 Over Load	[E-0512 2:5 0512011]
  Actuator5-12 PS Alarm	[E-0512 2:6 0512010]
  Actuator5-12 ENC Alarm	[E-0512 2:7 051200F]
  Actuator5-12 CPU Alarm	[E-0512 3:0 051201E]
  Actuator5-12 UART Alarm	[E-0512 3:1 051201D]
  Actuator5-12 HDLC Alarm	[E-0512 3:2 051201C]
  Actuator5-12 Force Card Fault	[E-0512 3:3 051201B]
  Actuator5-12 Force Sensor Fault	[E-0512 3:4 051201A]
  Actuator5-12 Under Range	[E-0512 3:5 0512019]
  Actuator5-12 Over Range	[E-0512 3:6 0512018]
  Actuator5-12 Down Limit	[E-0512 3:7 0512017]
  Actuator5-13 MON PARA	[E-0513 0:0 0513009]
  Actuator5-13 MON HYB	[E-0513 0:1 0513008]
  Actuator5-13 MON Position	[E-0513 0:2 0513007]
  Actuator5-13 MON Force	[E-0513 0:3 0513006]
  Actuator5-13 Drive Off	[E-0513 0:4 0513005]
  Actuator5-13 Drive On	[E-0513 0:5 0513004]
  Actuator5-13 CONT Position	[E-0513 0:6 0513003]
  Actuator5-13 CONT Force	[E-0513 0:7 0513002]
  Actuator5-13 Alarm Reset	[E-0513 1:1 0513020]
  Actuator5-13 Limit Release	[E-0513 1:2 051301F]
  Actuator5-13 Selected Step	[E-0513 1:3 051300E]
  Actuator5-13 Selected Load	[E-0513 1:4 051300D]
  Actuator5-13 Selected Drive	[E-0513 1:5 051300C]
  Actuator5-13 Maunakea	[E-0513 1:6 051300B]
  Actuator5-13 Sea Level	[E-0513 1:7 051300A]
  Actuator5-13 Up Limit	[E-0513 2:0 0513016]
  Actuator5-13 Driver Alarm	[E-0513 2:1 0513015]
  Actuator5-13 Error Alarm	[E-0513 2:2 0513014]
  Actuator5-13 Over Current	[E-0513 2:3 0513013]
  Actuator5-13 Over Speed	[E-0513 2:4 0513012]
  Actuator5-13 Over Load	[E-0513 2:5 0513011]
  Actuator5-13 PS Alarm	[E-0513 2:6 0513010]
  Actuator5-13 ENC Alarm	[E-0513 2:7 051300F]
  Actuator5-13 CPU Alarm	[E-0513 3:0 051301E]
  Actuator5-13 UART Alarm	[E-0513 3:1 051301D]
  Actuator5-13 HDLC Alarm	[E-0513 3:2 051301C]
  Actuator5-13 Force Card Fault	[E-0513 3:3 051301B]
  Actuator5-13 Force Sensor Fault	[E-0513 3:4 051301A]
  Actuator5-13 Under Range	[E-0513 3:5 0513019]
  Actuator5-13 Over Range	[E-0513 3:6 0513018]
  Actuator5-13 Down Limit	[E-0513 3:7 0513017]
  Actuator5-14 MON PARA	[E-0514 0:0 0514009]
  Actuator5-14 MON HYB	[E-0514 0:1 0514008]
  Actuator5-14 MON Position	[E-0514 0:2 0514007]
  Actuator5-14 MON Force	[E-0514 0:3 0514006]
  Actuator5-14 Drive Off	[E-0514 0:4 0514005]
  Actuator5-14 Drive On	[E-0514 0:5 0514004]
  Actuator5-14 CONT Position	[E-0514 0:6 0514003]
  Actuator5-14 CONT Force	[E-0514 0:7 0514002]
  Actuator5-14 Alarm Reset	[E-0514 1:1 0514020]
  Actuator5-14 Limit Release	[E-0514 1:2 051401F]
  Actuator5-14 Selected Step	[E-0514 1:3 051400E]
  Actuator5-14 Selected Load	[E-0514 1:4 051400D]
  Actuator5-14 Selected Drive	[E-0514 1:5 051400C]
  Actuator5-14 Maunakea	[E-0514 1:6 051400B]
  Actuator5-14 Sea Level	[E-0514 1:7 051400A]
  Actuator5-14 Up Limit	[E-0514 2:0 0514016]
  Actuator5-14 Driver Alarm	[E-0514 2:1 0514015]
  Actuator5-14 Error Alarm	[E-0514 2:2 0514014]
  Actuator5-14 Over Current	[E-0514 2:3 0514013]
  Actuator5-14 Over Speed	[E-0514 2:4 0514012]
  Actuator5-14 Over Load	[E-0514 2:5 0514011]
  Actuator5-14 PS Alarm	[E-0514 2:6 0514010]
  Actuator5-14 ENC Alarm	[E-0514 2:7 051400F]
  Actuator5-14 CPU Alarm	[E-0514 3:0 051401E]
  Actuator5-14 UART Alarm	[E-0514 3:1 051401D]
  Actuator5-14 HDLC Alarm	[E-0514 3:2 051401C]
  Actuator5-14 Force Card Fault	[E-0514 3:3 051401B]
  Actuator5-14 Force Sensor Fault	[E-0514 3:4 051401A]
  Actuator5-14 Under Range	[E-0514 3:5 0514019]
  Actuator5-14 Over Range	[E-0514 3:6 0514018]
  Actuator5-14 Down Limit	[E-0514 3:7 0514017]
  Actuator5-15 MON PARA	[E-0515 0:0 0515009]
  Actuator5-15 MON HYB	[E-0515 0:1 0515008]
  Actuator5-15 MON Position	[E-0515 0:2 0515007]
  Actuator5-15 MON Force	[E-0515 0:3 0515006]
  Actuator5-15 Drive Off	[E-0515 0:4 0515005]
  Actuator5-15 Drive On	[E-0515 0:5 0515004]
  Actuator5-15 CONT Position	[E-0515 0:6 0515003]
  Actuator5-15 CONT Force	[E-0515 0:7 0515002]
  Actuator5-15 Alarm Reset	[E-0515 1:1 0515020]
  Actuator5-15 Limit Release	[E-0515 1:2 051501F]
  Actuator5-15 Selected Step	[E-0515 1:3 051500E]
  Actuator5-15 Selected Load	[E-0515 1:4 051500D]
  Actuator5-15 Selected Drive	[E-0515 1:5 051500C]
  Actuator5-15 Maunakea	[E-0515 1:6 051500B]
  Actuator5-15 Sea Level	[E-0515 1:7 051500A]
  Actuator5-15 Up Limit	[E-0515 2:0 0515016]
  Actuator5-15 Driver Alarm	[E-0515 2:1 0515015]
  Actuator5-15 Error Alarm	[E-0515 2:2 0515014]
  Actuator5-15 Over Current	[E-0515 2:3 0515013]
  Actuator5-15 Over Speed	[E-0515 2:4 0515012]
  Actuator5-15 Over Load	[E-0515 2:5 0515011]
  Actuator5-15 PS Alarm	[E-0515 2:6 0515010]
  Actuator5-15 ENC Alarm	[E-0515 2:7 051500F]
  Actuator5-15 CPU Alarm	[E-0515 3:0 051501E]
  Actuator5-15 UART Alarm	[E-0515 3:1 051501D]
  Actuator5-15 HDLC Alarm	[E-0515 3:2 051501C]
  Actuator5-15 Force Card Fault	[E-0515 3:3 051501B]
  Actuator5-15 Force Sensor Fault	[E-0515 3:4 051501A]
  Actuator5-15 Under Range	[E-0515 3:5 0515019]
  Actuator5-15 Over Range	[E-0515 3:6 0515018]
  Actuator5-15 Down Limit	[E-0515 3:7 0515017]
  Actuator5-16 MON PARA	[E-0516 0:0 0516009]
  Actuator5-16 MON HYB	[E-0516 0:1 0516008]
  Actuator5-16 MON Position	[E-0516 0:2 0516007]
  Actuator5-16 MON Force	[E-0516 0:3 0516006]
  Actuator5-16 Drive Off	[E-0516 0:4 0516005]
  Actuator5-16 Drive On	[E-0516 0:5 0516004]
  Actuator5-16 CONT Position	[E-0516 0:6 0516003]
  Actuator5-16 CONT Force	[E-0516 0:7 0516002]
  Actuator5-16 Alarm Reset	[E-0516 1:1 0516020]
  Actuator5-16 Limit Release	[E-0516 1:2 051601F]
  Actuator5-16 Selected Step	[E-0516 1:3 051600E]
  Actuator5-16 Selected Load	[E-0516 1:4 051600D]
  Actuator5-16 Selected Drive	[E-0516 1:5 051600C]
  Actuator5-16 Maunakea	[E-0516 1:6 051600B]
  Actuator5-16 Sea Level	[E-0516 1:7 051600A]
  Actuator5-16 Up Limit	[E-0516 2:0 0516016]
  Actuator5-16 Driver Alarm	[E-0516 2:1 0516015]
  Actuator5-16 Error Alarm	[E-0516 2:2 0516014]
  Actuator5-16 Over Current	[E-0516 2:3 0516013]
  Actuator5-16 Over Speed	[E-0516 2:4 0516012]
  Actuator5-16 Over Load	[E-0516 2:5 0516011]
  Actuator5-16 PS Alarm	[E-0516 2:6 0516010]
  Actuator5-16 ENC Alarm	[E-0516 2:7 051600F]
  Actuator5-16 CPU Alarm	[E-0516 3:0 051601E]
  Actuator5-16 UART Alarm	[E-0516 3:1 051601D]
  Actuator5-16 HDLC Alarm	[E-0516 3:2 051601C]
  Actuator5-16 Force Card Fault	[E-0516 3:3 051601B]
  Actuator5-16 Force Sensor Fault	[E-0516 3:4 051601A]
  Actuator5-16 Under Range	[E-0516 3:5 0516019]
  Actuator5-16 Over Range	[E-0516 3:6 0516018]
  Actuator5-16 Down Limit	[E-0516 3:7 0516017]
  Actuator5-17 MON PARA	[E-0517 0:0 0517009]
  Actuator5-17 MON HYB	[E-0517 0:1 0517008]
  Actuator5-17 MON Position	[E-0517 0:2 0517007]
  Actuator5-17 MON Force	[E-0517 0:3 0517006]
  Actuator5-17 Drive Off	[E-0517 0:4 0517005]
  Actuator5-17 Drive On	[E-0517 0:5 0517004]
  Actuator5-17 CONT Position	[E-0517 0:6 0517003]
  Actuator5-17 CONT Force	[E-0517 0:7 0517002]
  Actuator5-17 Alarm Reset	[E-0517 1:1 0517020]
  Actuator5-17 Limit Release	[E-0517 1:2 051701F]
  Actuator5-17 Selected Step	[E-0517 1:3 051700E]
  Actuator5-17 Selected Load	[E-0517 1:4 051700D]
  Actuator5-17 Selected Drive	[E-0517 1:5 051700C]
  Actuator5-17 Maunakea	[E-0517 1:6 051700B]
  Actuator5-17 Sea Level	[E-0517 1:7 051700A]
  Actuator5-17 Up Limit	[E-0517 2:0 0517016]
  Actuator5-17 Driver Alarm	[E-0517 2:1 0517015]
  Actuator5-17 Error Alarm	[E-0517 2:2 0517014]
  Actuator5-17 Over Current	[E-0517 2:3 0517013]
  Actuator5-17 Over Speed	[E-0517 2:4 0517012]
  Actuator5-17 Over Load	[E-0517 2:5 0517011]
  Actuator5-17 PS Alarm	[E-0517 2:6 0517010]
  Actuator5-17 ENC Alarm	[E-0517 2:7 051700F]
  Actuator5-17 CPU Alarm	[E-0517 3:0 051701E]
  Actuator5-17 UART Alarm	[E-0517 3:1 051701D]
  Actuator5-17 HDLC Alarm	[E-0517 3:2 051701C]
  Actuator5-17 Force Card Fault	[E-0517 3:3 051701B]
  Actuator5-17 Force Sensor Fault	[E-0517 3:4 051701A]
  Actuator5-17 Under Range	[E-0517 3:5 0517019]
  Actuator5-17 Over Range	[E-0517 3:6 0517018]
  Actuator5-17 Down Limit	[E-0517 3:7 0517017]
  Actuator5-18 MON PARA	[E-0518 0:0 0518009]
  Actuator5-18 MON HYB	[E-0518 0:1 0518008]
  Actuator5-18 MON Position	[E-0518 0:2 0518007]
  Actuator5-18 MON Force	[E-0518 0:3 0518006]
  Actuator5-18 Drive Off	[E-0518 0:4 0518005]
  Actuator5-18 Drive On	[E-0518 0:5 0518004]
  Actuator5-18 CONT Position	[E-0518 0:6 0518003]
  Actuator5-18 CONT Force	[E-0518 0:7 0518002]
  Actuator5-18 Alarm Reset	[E-0518 1:1 0518020]
  Actuator5-18 Limit Release	[E-0518 1:2 051801F]
  Actuator5-18 Selected Step	[E-0518 1:3 051800E]
  Actuator5-18 Selected Load	[E-0518 1:4 051800D]
  Actuator5-18 Selected Drive	[E-0518 1:5 051800C]
  Actuator5-18 Maunakea	[E-0518 1:6 051800B]
  Actuator5-18 Sea Level	[E-0518 1:7 051800A]
  Actuator5-18 Up Limit	[E-0518 2:0 0518016]
  Actuator5-18 Driver Alarm	[E-0518 2:1 0518015]
  Actuator5-18 Error Alarm	[E-0518 2:2 0518014]
  Actuator5-18 Over Current	[E-0518 2:3 0518013]
  Actuator5-18 Over Speed	[E-0518 2:4 0518012]
  Actuator5-18 Over Load	[E-0518 2:5 0518011]
  Actuator5-18 PS Alarm	[E-0518 2:6 0518010]
  Actuator5-18 ENC Alarm	[E-0518 2:7 051800F]
  Actuator5-18 CPU Alarm	[E-0518 3:0 051801E]
  Actuator5-18 UART Alarm	[E-0518 3:1 051801D]
  Actuator5-18 HDLC Alarm	[E-0518 3:2 051801C]
  Actuator5-18 Force Card Fault	[E-0518 3:3 051801B]
  Actuator5-18 Force Sensor Fault	[E-0518 3:4 051801A]
  Actuator5-18 Under Range	[E-0518 3:5 0518019]
  Actuator5-18 Over Range	[E-0518 3:6 0518018]
  Actuator5-18 Down Limit	[E-0518 3:7 0518017]
  Actuator5-19 MON PARA	[E-0519 0:0 0519009]
  Actuator5-19 MON HYB	[E-0519 0:1 0519008]
  Actuator5-19 MON Position	[E-0519 0:2 0519007]
  Actuator5-19 MON Force	[E-0519 0:3 0519006]
  Actuator5-19 Drive Off	[E-0519 0:4 0519005]
  Actuator5-19 Drive On	[E-0519 0:5 0519004]
  Actuator5-19 CONT Position	[E-0519 0:6 0519003]
  Actuator5-19 CONT Force	[E-0519 0:7 0519002]
  Actuator5-19 Alarm Reset	[E-0519 1:1 0519020]
  Actuator5-19 Limit Release	[E-0519 1:2 051901F]
  Actuator5-19 Selected Step	[E-0519 1:3 051900E]
  Actuator5-19 Selected Load	[E-0519 1:4 051900D]
  Actuator5-19 Selected Drive	[E-0519 1:5 051900C]
  Actuator5-19 Maunakea	[E-0519 1:6 051900B]
  Actuator5-19 Sea Level	[E-0519 1:7 051900A]
  Actuator5-19 Up Limit	[E-0519 2:0 0519016]
  Actuator5-19 Driver Alarm	[E-0519 2:1 0519015]
  Actuator5-19 Error Alarm	[E-0519 2:2 0519014]
  Actuator5-19 Over Current	[E-0519 2:3 0519013]
  Actuator5-19 Over Speed	[E-0519 2:4 0519012]
  Actuator5-19 Over Load	[E-0519 2:5 0519011]
  Actuator5-19 PS Alarm	[E-0519 2:6 0519010]
  Actuator5-19 ENC Alarm	[E-0519 2:7 051900F]
  Actuator5-19 CPU Alarm	[E-0519 3:0 051901E]
  Actuator5-19 UART Alarm	[E-0519 3:1 051901D]
  Actuator5-19 HDLC Alarm	[E-0519 3:2 051901C]
  Actuator5-19 Force Card Fault	[E-0519 3:3 051901B]
  Actuator5-19 Force Sensor Fault	[E-0519 3:4 051901A]
  Actuator5-19 Under Range	[E-0519 3:5 0519019]
  Actuator5-19 Over Range	[E-0519 3:6 0519018]
  Actuator5-19 Down Limit	[E-0519 3:7 0519017]
  Actuator5-20 MON PARA	[E-0520 0:0 0520009]
  Actuator5-20 MON HYB	[E-0520 0:1 0520008]
  Actuator5-20 MON Position	[E-0520 0:2 0520007]
  Actuator5-20 MON Force	[E-0520 0:3 0520006]
  Actuator5-20 Drive Off	[E-0520 0:4 0520005]
  Actuator5-20 Drive On	[E-0520 0:5 0520004]
  Actuator5-20 CONT Position	[E-0520 0:6 0520003]
  Actuator5-20 CONT Force	[E-0520 0:7 0520002]
  Actuator5-20 Alarm Reset	[E-0520 1:1 0520020]
  Actuator5-20 Limit Release	[E-0520 1:2 052001F]
  Actuator5-20 Selected Step	[E-0520 1:3 052000E]
  Actuator5-20 Selected Load	[E-0520 1:4 052000D]
  Actuator5-20 Selected Drive	[E-0520 1:5 052000C]
  Actuator5-20 Maunakea	[E-0520 1:6 052000B]
  Actuator5-20 Sea Level	[E-0520 1:7 052000A]
  Actuator5-20 Up Limit	[E-0520 2:0 0520016]
  Actuator5-20 Driver Alarm	[E-0520 2:1 0520015]
  Actuator5-20 Error Alarm	[E-0520 2:2 0520014]
  Actuator5-20 Over Current	[E-0520 2:3 0520013]
  Actuator5-20 Over Speed	[E-0520 2:4 0520012]
  Actuator5-20 Over Load	[E-0520 2:5 0520011]
  Actuator5-20 PS Alarm	[E-0520 2:6 0520010]
  Actuator5-20 ENC Alarm	[E-0520 2:7 052000F]
  Actuator5-20 CPU Alarm	[E-0520 3:0 052001E]
  Actuator5-20 UART Alarm	[E-0520 3:1 052001D]
  Actuator5-20 HDLC Alarm	[E-0520 3:2 052001C]
  Actuator5-20 Force Card Fault	[E-0520 3:3 052001B]
  Actuator5-20 Force Sensor Fault	[E-0520 3:4 052001A]
  Actuator5-20 Under Range	[E-0520 3:5 0520019]
  Actuator5-20 Over Range	[E-0520 3:6 0520018]
  Actuator5-20 Down Limit	[E-0520 3:7 0520017]
  Actuator5-21 MON PARA	[E-0521 0:0 0521009]
  Actuator5-21 MON HYB	[E-0521 0:1 0521008]
  Actuator5-21 MON Position	[E-0521 0:2 0521007]
  Actuator5-21 MON Force	[E-0521 0:3 0521006]
  Actuator5-21 Drive Off	[E-0521 0:4 0521005]
  Actuator5-21 Drive On	[E-0521 0:5 0521004]
  Actuator5-21 CONT Position	[E-0521 0:6 0521003]
  Actuator5-21 CONT Force	[E-0521 0:7 0521002]
  Actuator5-21 Alarm Reset	[E-0521 1:1 0521020]
  Actuator5-21 Limit Release	[E-0521 1:2 052101F]
  Actuator5-21 Selected Step	[E-0521 1:3 052100E]
  Actuator5-21 Selected Load	[E-0521 1:4 052100D]
  Actuator5-21 Selected Drive	[E-0521 1:5 052100C]
  Actuator5-21 Maunakea	[E-0521 1:6 052100B]
  Actuator5-21 Sea Level	[E-0521 1:7 052100A]
  Actuator5-21 Up Limit	[E-0521 2:0 0521016]
  Actuator5-21 Driver Alarm	[E-0521 2:1 0521015]
  Actuator5-21 Error Alarm	[E-0521 2:2 0521014]
  Actuator5-21 Over Current	[E-0521 2:3 0521013]
  Actuator5-21 Over Speed	[E-0521 2:4 0521012]
  Actuator5-21 Over Load	[E-0521 2:5 0521011]
  Actuator5-21 PS Alarm	[E-0521 2:6 0521010]
  Actuator5-21 ENC Alarm	[E-0521 2:7 052100F]
  Actuator5-21 CPU Alarm	[E-0521 3:0 052101E]
  Actuator5-21 UART Alarm	[E-0521 3:1 052101D]
  Actuator5-21 HDLC Alarm	[E-0521 3:2 052101C]
  Actuator5-21 Force Card Fault	[E-0521 3:3 052101B]
  Actuator5-21 Force Sensor Fault	[E-0521 3:4 052101A]
  Actuator5-21 Under Range	[E-0521 3:5 0521019]
  Actuator5-21 Over Range	[E-0521 3:6 0521018]
  Actuator5-21 Down Limit	[E-0521 3:7 0521017]
  Actuator5-22 MON PARA	[E-0522 0:0 0522009]
  Actuator5-22 MON HYB	[E-0522 0:1 0522008]
  Actuator5-22 MON Position	[E-0522 0:2 0522007]
  Actuator5-22 MON Force	[E-0522 0:3 0522006]
  Actuator5-22 Drive Off	[E-0522 0:4 0522005]
  Actuator5-22 Drive On	[E-0522 0:5 0522004]
  Actuator5-22 CONT Position	[E-0522 0:6 0522003]
  Actuator5-22 CONT Force	[E-0522 0:7 0522002]
  Actuator5-22 Alarm Reset	[E-0522 1:1 0522020]
  Actuator5-22 Limit Release	[E-0522 1:2 052201F]
  Actuator5-22 Selected Step	[E-0522 1:3 052200E]
  Actuator5-22 Selected Load	[E-0522 1:4 052200D]
  Actuator5-22 Selected Drive	[E-0522 1:5 052200C]
  Actuator5-22 Maunakea	[E-0522 1:6 052200B]
  Actuator5-22 Sea Level	[E-0522 1:7 052200A]
  Actuator5-22 Up Limit	[E-0522 2:0 0522016]
  Actuator5-22 Driver Alarm	[E-0522 2:1 0522015]
  Actuator5-22 Error Alarm	[E-0522 2:2 0522014]
  Actuator5-22 Over Current	[E-0522 2:3 0522013]
  Actuator5-22 Over Speed	[E-0522 2:4 0522012]
  Actuator5-22 Over Load	[E-0522 2:5 0522011]
  Actuator5-22 PS Alarm	[E-0522 2:6 0522010]
  Actuator5-22 ENC Alarm	[E-0522 2:7 052200F]
  Actuator5-22 CPU Alarm	[E-0522 3:0 052201E]
  Actuator5-22 UART Alarm	[E-0522 3:1 052201D]
  Actuator5-22 HDLC Alarm	[E-0522 3:2 052201C]
  Actuator5-22 Force Card Fault	[E-0522 3:3 052201B]
  Actuator5-22 Force Sensor Fault	[E-0522 3:4 052201A]
  Actuator5-22 Under Range	[E-0522 3:5 0522019]
  Actuator5-22 Over Range	[E-0522 3:6 0522018]
  Actuator5-22 Down Limit	[E-0522 3:7 0522017]
  Actuator5-23 MON PARA	[E-0523 0:0 0523009]
  Actuator5-23 MON HYB	[E-0523 0:1 0523008]
  Actuator5-23 MON Position	[E-0523 0:2 0523007]
  Actuator5-23 MON Force	[E-0523 0:3 0523006]
  Actuator5-23 Drive Off	[E-0523 0:4 0523005]
  Actuator5-23 Drive On	[E-0523 0:5 0523004]
  Actuator5-23 CONT Position	[E-0523 0:6 0523003]
  Actuator5-23 CONT Force	[E-0523 0:7 0523002]
  Actuator5-23 Alarm Reset	[E-0523 1:1 0523020]
  Actuator5-23 Limit Release	[E-0523 1:2 052301F]
  Actuator5-23 Selected Step	[E-0523 1:3 052300E]
  Actuator5-23 Selected Load	[E-0523 1:4 052300D]
  Actuator5-23 Selected Drive	[E-0523 1:5 052300C]
  Actuator5-23 Maunakea	[E-0523 1:6 052300B]
  Actuator5-23 Sea Level	[E-0523 1:7 052300A]
  Actuator5-23 Up Limit	[E-0523 2:0 0523016]
  Actuator5-23 Driver Alarm	[E-0523 2:1 0523015]
  Actuator5-23 Error Alarm	[E-0523 2:2 0523014]
  Actuator5-23 Over Current	[E-0523 2:3 0523013]
  Actuator5-23 Over Speed	[E-0523 2:4 0523012]
  Actuator5-23 Over Load	[E-0523 2:5 0523011]
  Actuator5-23 PS Alarm	[E-0523 2:6 0523010]
  Actuator5-23 ENC Alarm	[E-0523 2:7 052300F]
  Actuator5-23 CPU Alarm	[E-0523 3:0 052301E]
  Actuator5-23 UART Alarm	[E-0523 3:1 052301D]
  Actuator5-23 HDLC Alarm	[E-0523 3:2 052301C]
  Actuator5-23 Force Card Fault	[E-0523 3:3 052301B]
  Actuator5-23 Force Sensor Fault	[E-0523 3:4 052301A]
  Actuator5-23 Under Range	[E-0523 3:5 0523019]
  Actuator5-23 Over Range	[E-0523 3:6 0523018]
  Actuator5-23 Down Limit	[E-0523 3:7 0523017]
  Actuator5-24 MON PARA	[E-0524 0:0 0524009]
  Actuator5-24 MON HYB	[E-0524 0:1 0524008]
  Actuator5-24 MON Position	[E-0524 0:2 0524007]
  Actuator5-24 MON Force	[E-0524 0:3 0524006]
  Actuator5-24 Drive Off	[E-0524 0:4 0524005]
  Actuator5-24 Drive On	[E-0524 0:5 0524004]
  Actuator5-24 CONT Position	[E-0524 0:6 0524003]
  Actuator5-24 CONT Force	[E-0524 0:7 0524002]
  Actuator5-24 Alarm Reset	[E-0524 1:1 0524020]
  Actuator5-24 Limit Release	[E-0524 1:2 052401F]
  Actuator5-24 Selected Step	[E-0524 1:3 052400E]
  Actuator5-24 Selected Load	[E-0524 1:4 052400D]
  Actuator5-24 Selected Drive	[E-0524 1:5 052400C]
  Actuator5-24 Maunakea	[E-0524 1:6 052400B]
  Actuator5-24 Sea Level	[E-0524 1:7 052400A]
  Actuator5-24 Up Limit	[E-0524 2:0 0524016]
  Actuator5-24 Driver Alarm	[E-0524 2:1 0524015]
  Actuator5-24 Error Alarm	[E-0524 2:2 0524014]
  Actuator5-24 Over Current	[E-0524 2:3 0524013]
  Actuator5-24 Over Speed	[E-0524 2:4 0524012]
  Actuator5-24 Over Load	[E-0524 2:5 0524011]
  Actuator5-24 PS Alarm	[E-0524 2:6 0524010]
  Actuator5-24 ENC Alarm	[E-0524 2:7 052400F]
  Actuator5-24 CPU Alarm	[E-0524 3:0 052401E]
  Actuator5-24 UART Alarm	[E-0524 3:1 052401D]
  Actuator5-24 HDLC Alarm	[E-0524 3:2 052401C]
  Actuator5-24 Force Card Fault	[E-0524 3:3 052401B]
  Actuator5-24 Force Sensor Fault	[E-0524 3:4 052401A]
  Actuator5-24 Under Range	[E-0524 3:5 0524019]
  Actuator5-24 Over Range	[E-0524 3:6 0524018]
  Actuator5-24 Down Limit	[E-0524 3:7 0524017]
  Actuator5-25 MON PARA	[E-0525 0:0 0525009]
  Actuator5-25 MON HYB	[E-0525 0:1 0525008]
  Actuator5-25 MON Position	[E-0525 0:2 0525007]
  Actuator5-25 MON Force	[E-0525 0:3 0525006]
  Actuator5-25 Drive Off	[E-0525 0:4 0525005]
  Actuator5-25 Drive On	[E-0525 0:5 0525004]
  Actuator5-25 CONT Position	[E-0525 0:6 0525003]
  Actuator5-25 CONT Force	[E-0525 0:7 0525002]
  Actuator5-25 Alarm Reset	[E-0525 1:1 0525020]
  Actuator5-25 Limit Release	[E-0525 1:2 052501F]
  Actuator5-25 Selected Step	[E-0525 1:3 052500E]
  Actuator5-25 Selected Load	[E-0525 1:4 052500D]
  Actuator5-25 Selected Drive	[E-0525 1:5 052500C]
  Actuator5-25 Maunakea	[E-0525 1:6 052500B]
  Actuator5-25 Sea Level	[E-0525 1:7 052500A]
  Actuator5-25 Up Limit	[E-0525 2:0 0525016]
  Actuator5-25 Driver Alarm	[E-0525 2:1 0525015]
  Actuator5-25 Error Alarm	[E-0525 2:2 0525014]
  Actuator5-25 Over Current	[E-0525 2:3 0525013]
  Actuator5-25 Over Speed	[E-0525 2:4 0525012]
  Actuator5-25 Over Load	[E-0525 2:5 0525011]
  Actuator5-25 PS Alarm	[E-0525 2:6 0525010]
  Actuator5-25 ENC Alarm	[E-0525 2:7 052500F]
  Actuator5-25 CPU Alarm	[E-0525 3:0 052501E]
  Actuator5-25 UART Alarm	[E-0525 3:1 052501D]
  Actuator5-25 HDLC Alarm	[E-0525 3:2 052501C]
  Actuator5-25 Force Card Fault	[E-0525 3:3 052501B]
  Actuator5-25 Force Sensor Fault	[E-0525 3:4 052501A]
  Actuator5-25 Under Range	[E-0525 3:5 0525019]
  Actuator5-25 Over Range	[E-0525 3:6 0525018]
  Actuator5-25 Down Limit	[E-0525 3:7 0525017]
  Actuator5-26 MON PARA	[E-0526 0:0 0526009]
  Actuator5-26 MON HYB	[E-0526 0:1 0526008]
  Actuator5-26 MON Position	[E-0526 0:2 0526007]
  Actuator5-26 MON Force	[E-0526 0:3 0526006]
  Actuator5-26 Drive Off	[E-0526 0:4 0526005]
  Actuator5-26 Drive On	[E-0526 0:5 0526004]
  Actuator5-26 CONT Position	[E-0526 0:6 0526003]
  Actuator5-26 CONT Force	[E-0526 0:7 0526002]
  Actuator5-26 Alarm Reset	[E-0526 1:1 0526020]
  Actuator5-26 Limit Release	[E-0526 1:2 052601F]
  Actuator5-26 Selected Step	[E-0526 1:3 052600E]
  Actuator5-26 Selected Load	[E-0526 1:4 052600D]
  Actuator5-26 Selected Drive	[E-0526 1:5 052600C]
  Actuator5-26 Maunakea	[E-0526 1:6 052600B]
  Actuator5-26 Sea Level	[E-0526 1:7 052600A]
  Actuator5-26 Up Limit	[E-0526 2:0 0526016]
  Actuator5-26 Driver Alarm	[E-0526 2:1 0526015]
  Actuator5-26 Error Alarm	[E-0526 2:2 0526014]
  Actuator5-26 Over Current	[E-0526 2:3 0526013]
  Actuator5-26 Over Speed	[E-0526 2:4 0526012]
  Actuator5-26 Over Load	[E-0526 2:5 0526011]
  Actuator5-26 PS Alarm	[E-0526 2:6 0526010]
  Actuator5-26 ENC Alarm	[E-0526 2:7 052600F]
  Actuator5-26 CPU Alarm	[E-0526 3:0 052601E]
  Actuator5-26 UART Alarm	[E-0526 3:1 052601D]
  Actuator5-26 HDLC Alarm	[E-0526 3:2 052601C]
  Actuator5-26 Force Card Fault	[E-0526 3:3 052601B]
  Actuator5-26 Force Sensor Fault	[E-0526 3:4 052601A]
  Actuator5-26 Under Range	[E-0526 3:5 0526019]
  Actuator5-26 Over Range	[E-0526 3:6 0526018]
  Actuator5-26 Down Limit	[E-0526 3:7 0526017]
  Actuator5-27 MON PARA	[E-0527 0:0 0527009]
  Actuator5-27 MON HYB	[E-0527 0:1 0527008]
  Actuator5-27 MON Position	[E-0527 0:2 0527007]
  Actuator5-27 MON Force	[E-0527 0:3 0527006]
  Actuator5-27 Drive Off	[E-0527 0:4 0527005]
  Actuator5-27 Drive On	[E-0527 0:5 0527004]
  Actuator5-27 CONT Position	[E-0527 0:6 0527003]
  Actuator5-27 CONT Force	[E-0527 0:7 0527002]
  Actuator5-27 Alarm Reset	[E-0527 1:1 0527020]
  Actuator5-27 Limit Release	[E-0527 1:2 052701F]
  Actuator5-27 Selected Step	[E-0527 1:3 052700E]
  Actuator5-27 Selected Load	[E-0527 1:4 052700D]
  Actuator5-27 Selected Drive	[E-0527 1:5 052700C]
  Actuator5-27 Maunakea	[E-0527 1:6 052700B]
  Actuator5-27 Sea Level	[E-0527 1:7 052700A]
  Actuator5-27 Up Limit	[E-0527 2:0 0527016]
  Actuator5-27 Driver Alarm	[E-0527 2:1 0527015]
  Actuator5-27 Error Alarm	[E-0527 2:2 0527014]
  Actuator5-27 Over Current	[E-0527 2:3 0527013]
  Actuator5-27 Over Speed	[E-0527 2:4 0527012]
  Actuator5-27 Over Load	[E-0527 2:5 0527011]
  Actuator5-27 PS Alarm	[E-0527 2:6 0527010]
  Actuator5-27 ENC Alarm	[E-0527 2:7 052700F]
  Actuator5-27 CPU Alarm	[E-0527 3:0 052701E]
  Actuator5-27 UART Alarm	[E-0527 3:1 052701D]
  Actuator5-27 HDLC Alarm	[E-0527 3:2 052701C]
  Actuator5-27 Force Card Fault	[E-0527 3:3 052701B]
  Actuator5-27 Force Sensor Fault	[E-0527 3:4 052701A]
  Actuator5-27 Under Range	[E-0527 3:5 0527019]
  Actuator5-27 Over Range	[E-0527 3:6 0527018]
  Actuator5-27 Down Limit	[E-0527 3:7 0527017]
  Actuator5-28 MON PARA	[E-0528 0:0 0528009]
  Actuator5-28 MON HYB	[E-0528 0:1 0528008]
  Actuator5-28 MON Position	[E-0528 0:2 0528007]
  Actuator5-28 MON Force	[E-0528 0:3 0528006]
  Actuator5-28 Drive Off	[E-0528 0:4 0528005]
  Actuator5-28 Drive On	[E-0528 0:5 0528004]
  Actuator5-28 CONT Position	[E-0528 0:6 0528003]
  Actuator5-28 CONT Force	[E-0528 0:7 0528002]
  Actuator5-28 Alarm Reset	[E-0528 1:1 0528020]
  Actuator5-28 Limit Release	[E-0528 1:2 052801F]
  Actuator5-28 Selected Step	[E-0528 1:3 052800E]
  Actuator5-28 Selected Load	[E-0528 1:4 052800D]
  Actuator5-28 Selected Drive	[E-0528 1:5 052800C]
  Actuator5-28 Maunakea	[E-0528 1:6 052800B]
  Actuator5-28 Sea Level	[E-0528 1:7 052800A]
  Actuator5-28 Up Limit	[E-0528 2:0 0528016]
  Actuator5-28 Driver Alarm	[E-0528 2:1 0528015]
  Actuator5-28 Error Alarm	[E-0528 2:2 0528014]
  Actuator5-28 Over Current	[E-0528 2:3 0528013]
  Actuator5-28 Over Speed	[E-0528 2:4 0528012]
  Actuator5-28 Over Load	[E-0528 2:5 0528011]
  Actuator5-28 PS Alarm	[E-0528 2:6 0528010]
  Actuator5-28 ENC Alarm	[E-0528 2:7 052800F]
  Actuator5-28 CPU Alarm	[E-0528 3:0 052801E]
  Actuator5-28 UART Alarm	[E-0528 3:1 052801D]
  Actuator5-28 HDLC Alarm	[E-0528 3:2 052801C]
  Actuator5-28 Force Card Fault	[E-0528 3:3 052801B]
  Actuator5-28 Force Sensor Fault	[E-0528 3:4 052801A]
  Actuator5-28 Under Range	[E-0528 3:5 0528019]
  Actuator5-28 Over Range	[E-0528 3:6 0528018]
  Actuator5-28 Down Limit	[E-0528 3:7 0528017]
  Actuator5-29 MON PARA	[E-0529 0:0 0529009]
  Actuator5-29 MON HYB	[E-0529 0:1 0529008]
  Actuator5-29 MON Position	[E-0529 0:2 0529007]
  Actuator5-29 MON Force	[E-0529 0:3 0529006]
  Actuator5-29 Drive Off	[E-0529 0:4 0529005]
  Actuator5-29 Drive On	[E-0529 0:5 0529004]
  Actuator5-29 CONT Position	[E-0529 0:6 0529003]
  Actuator5-29 CONT Force	[E-0529 0:7 0529002]
  Actuator5-29 Alarm Reset	[E-0529 1:1 0529020]
  Actuator5-29 Limit Release	[E-0529 1:2 052901F]
  Actuator5-29 Selected Step	[E-0529 1:3 052900E]
  Actuator5-29 Selected Load	[E-0529 1:4 052900D]
  Actuator5-29 Selected Drive	[E-0529 1:5 052900C]
  Actuator5-29 Maunakea	[E-0529 1:6 052900B]
  Actuator5-29 Sea Level	[E-0529 1:7 052900A]
  Actuator5-29 Up Limit	[E-0529 2:0 0529016]
  Actuator5-29 Driver Alarm	[E-0529 2:1 0529015]
  Actuator5-29 Error Alarm	[E-0529 2:2 0529014]
  Actuator5-29 Over Current	[E-0529 2:3 0529013]
  Actuator5-29 Over Speed	[E-0529 2:4 0529012]
  Actuator5-29 Over Load	[E-0529 2:5 0529011]
  Actuator5-29 PS Alarm	[E-0529 2:6 0529010]
  Actuator5-29 ENC Alarm	[E-0529 2:7 052900F]
  Actuator5-29 CPU Alarm	[E-0529 3:0 052901E]
  Actuator5-29 UART Alarm	[E-0529 3:1 052901D]
  Actuator5-29 HDLC Alarm	[E-0529 3:2 052901C]
  Actuator5-29 Force Card Fault	[E-0529 3:3 052901B]
  Actuator5-29 Force Sensor Fault	[E-0529 3:4 052901A]
  Actuator5-29 Under Range	[E-0529 3:5 0529019]
  Actuator5-29 Over Range	[E-0529 3:6 0529018]
  Actuator5-29 Down Limit	[E-0529 3:7 0529017]
  Actuator5-30 MON PARA	[E-0530 0:0 0530009]
  Actuator5-30 MON HYB	[E-0530 0:1 0530008]
  Actuator5-30 MON Position	[E-0530 0:2 0530007]
  Actuator5-30 MON Force	[E-0530 0:3 0530006]
  Actuator5-30 Drive Off	[E-0530 0:4 0530005]
  Actuator5-30 Drive On	[E-0530 0:5 0530004]
  Actuator5-30 CONT Position	[E-0530 0:6 0530003]
  Actuator5-30 CONT Force	[E-0530 0:7 0530002]
  Actuator5-30 Alarm Reset	[E-0530 1:1 0530020]
  Actuator5-30 Limit Release	[E-0530 1:2 053001F]
  Actuator5-30 Selected Step	[E-0530 1:3 053000E]
  Actuator5-30 Selected Load	[E-0530 1:4 053000D]
  Actuator5-30 Selected Drive	[E-0530 1:5 053000C]
  Actuator5-30 Maunakea	[E-0530 1:6 053000B]
  Actuator5-30 Sea Level	[E-0530 1:7 053000A]
  Actuator5-30 Up Limit	[E-0530 2:0 0530016]
  Actuator5-30 Driver Alarm	[E-0530 2:1 0530015]
  Actuator5-30 Error Alarm	[E-0530 2:2 0530014]
  Actuator5-30 Over Current	[E-0530 2:3 0530013]
  Actuator5-30 Over Speed	[E-0530 2:4 0530012]
  Actuator5-30 Over Load	[E-0530 2:5 0530011]
  Actuator5-30 PS Alarm	[E-0530 2:6 0530010]
  Actuator5-30 ENC Alarm	[E-0530 2:7 053000F]
  Actuator5-30 CPU Alarm	[E-0530 3:0 053001E]
  Actuator5-30 UART Alarm	[E-0530 3:1 053001D]
  Actuator5-30 HDLC Alarm	[E-0530 3:2 053001C]
  Actuator5-30 Force Card Fault	[E-0530 3:3 053001B]
  Actuator5-30 Force Sensor Fault	[E-0530 3:4 053001A]
  Actuator5-30 Under Range	[E-0530 3:5 0530019]
  Actuator5-30 Over Range	[E-0530 3:6 0530018]
  Actuator5-30 Down Limit	[E-0530 3:7 0530017]
  Actuator5-31 MON PARA	[E-0531 0:0 0531009]
  Actuator5-31 MON HYB	[E-0531 0:1 0531008]
  Actuator5-31 MON Position	[E-0531 0:2 0531007]
  Actuator5-31 MON Force	[E-0531 0:3 0531006]
  Actuator5-31 Drive Off	[E-0531 0:4 0531005]
  Actuator5-31 Drive On	[E-0531 0:5 0531004]
  Actuator5-31 CONT Position	[E-0531 0:6 0531003]
  Actuator5-31 CONT Force	[E-0531 0:7 0531002]
  Actuator5-31 Alarm Reset	[E-0531 1:1 0531020]
  Actuator5-31 Limit Release	[E-0531 1:2 053101F]
  Actuator5-31 Selected Step	[E-0531 1:3 053100E]
  Actuator5-31 Selected Load	[E-0531 1:4 053100D]
  Actuator5-31 Selected Drive	[E-0531 1:5 053100C]
  Actuator5-31 Maunakea	[E-0531 1:6 053100B]
  Actuator5-31 Sea Level	[E-0531 1:7 053100A]
  Actuator5-31 Up Limit	[E-0531 2:0 0531016]
  Actuator5-31 Driver Alarm	[E-0531 2:1 0531015]
  Actuator5-31 Error Alarm	[E-0531 2:2 0531014]
  Actuator5-31 Over Current	[E-0531 2:3 0531013]
  Actuator5-31 Over Speed	[E-0531 2:4 0531012]
  Actuator5-31 Over Load	[E-0531 2:5 0531011]
  Actuator5-31 PS Alarm	[E-0531 2:6 0531010]
  Actuator5-31 ENC Alarm	[E-0531 2:7 053100F]
  Actuator5-31 CPU Alarm	[E-0531 3:0 053101E]
  Actuator5-31 UART Alarm	[E-0531 3:1 053101D]
  Actuator5-31 HDLC Alarm	[E-0531 3:2 053101C]
  Actuator5-31 Force Card Fault	[E-0531 3:3 053101B]
  Actuator5-31 Force Sensor Fault	[E-0531 3:4 053101A]
  Actuator5-31 Under Range	[E-0531 3:5 0531019]
  Actuator5-31 Over Range	[E-0531 3:6 0531018]
  Actuator5-31 Down Limit	[E-0531 3:7 0531017]
  Actuator5-32 MON PARA	[E-0532 0:0 0532009]
  Actuator5-32 MON HYB	[E-0532 0:1 0532008]
  Actuator5-32 MON Position	[E-0532 0:2 0532007]
  Actuator5-32 MON Force	[E-0532 0:3 0532006]
  Actuator5-32 Drive Off	[E-0532 0:4 0532005]
  Actuator5-32 Drive On	[E-0532 0:5 0532004]
  Actuator5-32 CONT Position	[E-0532 0:6 0532003]
  Actuator5-32 CONT Force	[E-0532 0:7 0532002]
  Actuator5-32 Alarm Reset	[E-0532 1:1 0532020]
  Actuator5-32 Limit Release	[E-0532 1:2 053201F]
  Actuator5-32 Selected Step	[E-0532 1:3 053200E]
  Actuator5-32 Selected Load	[E-0532 1:4 053200D]
  Actuator5-32 Selected Drive	[E-0532 1:5 053200C]
  Actuator5-32 Maunakea	[E-0532 1:6 053200B]
  Actuator5-32 Sea Level	[E-0532 1:7 053200A]
  Actuator5-32 Up Limit	[E-0532 2:0 0532016]
  Actuator5-32 Driver Alarm	[E-0532 2:1 0532015]
  Actuator5-32 Error Alarm	[E-0532 2:2 0532014]
  Actuator5-32 Over Current	[E-0532 2:3 0532013]
  Actuator5-32 Over Speed	[E-0532 2:4 0532012]
  Actuator5-32 Over Load	[E-0532 2:5 0532011]
  Actuator5-32 PS Alarm	[E-0532 2:6 0532010]
  Actuator5-32 ENC Alarm	[E-0532 2:7 053200F]
  Actuator5-32 CPU Alarm	[E-0532 3:0 053201E]
  Actuator5-32 UART Alarm	[E-0532 3:1 053201D]
  Actuator5-32 HDLC Alarm	[E-0532 3:2 053201C]
  Actuator5-32 Force Card Fault	[E-0532 3:3 053201B]
  Actuator5-32 Force Sensor Fault	[E-0532 3:4 053201A]
  Actuator5-32 Under Range	[E-0532 3:5 0532019]
  Actuator5-32 Over Range	[E-0532 3:6 0532018]
  Actuator5-32 Down Limit	[E-0532 3:7 0532017]
  Actuator5-33 MON PARA	[E-0533 0:0 0533009]
  Actuator5-33 MON HYB	[E-0533 0:1 0533008]
  Actuator5-33 MON Position	[E-0533 0:2 0533007]
  Actuator5-33 MON Force	[E-0533 0:3 0533006]
  Actuator5-33 Drive Off	[E-0533 0:4 0533005]
  Actuator5-33 Drive On	[E-0533 0:5 0533004]
  Actuator5-33 CONT Position	[E-0533 0:6 0533003]
  Actuator5-33 CONT Force	[E-0533 0:7 0533002]
  Actuator5-33 Alarm Reset	[E-0533 1:1 0533020]
  Actuator5-33 Limit Release	[E-0533 1:2 053301F]
  Actuator5-33 Selected Step	[E-0533 1:3 053300E]
  Actuator5-33 Selected Load	[E-0533 1:4 053300D]
  Actuator5-33 Selected Drive	[E-0533 1:5 053300C]
  Actuator5-33 Maunakea	[E-0533 1:6 053300B]
  Actuator5-33 Sea Level	[E-0533 1:7 053300A]
  Actuator5-33 Up Limit	[E-0533 2:0 0533016]
  Actuator5-33 Driver Alarm	[E-0533 2:1 0533015]
  Actuator5-33 Error Alarm	[E-0533 2:2 0533014]
  Actuator5-33 Over Current	[E-0533 2:3 0533013]
  Actuator5-33 Over Speed	[E-0533 2:4 0533012]
  Actuator5-33 Over Load	[E-0533 2:5 0533011]
  Actuator5-33 PS Alarm	[E-0533 2:6 0533010]
  Actuator5-33 ENC Alarm	[E-0533 2:7 053300F]
  Actuator5-33 CPU Alarm	[E-0533 3:0 053301E]
  Actuator5-33 UART Alarm	[E-0533 3:1 053301D]
  Actuator5-33 HDLC Alarm	[E-0533 3:2 053301C]
  Actuator5-33 Force Card Fault	[E-0533 3:3 053301B]
  Actuator5-33 Force Sensor Fault	[E-0533 3:4 053301A]
  Actuator5-33 Under Range	[E-0533 3:5 0533019]
  Actuator5-33 Over Range	[E-0533 3:6 0533018]
  Actuator5-33 Down Limit	[E-0533 3:7 0533017]
  Actuator5-34 MON PARA	[E-0534 0:0 0534009]
  Actuator5-34 MON HYB	[E-0534 0:1 0534008]
  Actuator5-34 MON Position	[E-0534 0:2 0534007]
  Actuator5-34 MON Force	[E-0534 0:3 0534006]
  Actuator5-34 Drive Off	[E-0534 0:4 0534005]
  Actuator5-34 Drive On	[E-0534 0:5 0534004]
  Actuator5-34 CONT Position	[E-0534 0:6 0534003]
  Actuator5-34 CONT Force	[E-0534 0:7 0534002]
  Actuator5-34 Alarm Reset	[E-0534 1:1 0534020]
  Actuator5-34 Limit Release	[E-0534 1:2 053401F]
  Actuator5-34 Selected Step	[E-0534 1:3 053400E]
  Actuator5-34 Selected Load	[E-0534 1:4 053400D]
  Actuator5-34 Selected Drive	[E-0534 1:5 053400C]
  Actuator5-34 Maunakea	[E-0534 1:6 053400B]
  Actuator5-34 Sea Level	[E-0534 1:7 053400A]
  Actuator5-34 Up Limit	[E-0534 2:0 0534016]
  Actuator5-34 Driver Alarm	[E-0534 2:1 0534015]
  Actuator5-34 Error Alarm	[E-0534 2:2 0534014]
  Actuator5-34 Over Current	[E-0534 2:3 0534013]
  Actuator5-34 Over Speed	[E-0534 2:4 0534012]
  Actuator5-34 Over Load	[E-0534 2:5 0534011]
  Actuator5-34 PS Alarm	[E-0534 2:6 0534010]
  Actuator5-34 ENC Alarm	[E-0534 2:7 053400F]
  Actuator5-34 CPU Alarm	[E-0534 3:0 053401E]
  Actuator5-34 UART Alarm	[E-0534 3:1 053401D]
  Actuator5-34 HDLC Alarm	[E-0534 3:2 053401C]
  Actuator5-34 Force Card Fault	[E-0534 3:3 053401B]
  Actuator5-34 Force Sensor Fault	[E-0534 3:4 053401A]
  Actuator5-34 Under Range	[E-0534 3:5 0534019]
  Actuator5-34 Over Range	[E-0534 3:6 0534018]
  Actuator5-34 Down Limit	[E-0534 3:7 0534017]
  Actuator5-35 MON PARA	[E-0535 0:0 0535009]
  Actuator5-35 MON HYB	[E-0535 0:1 0535008]
  Actuator5-35 MON Position	[E-0535 0:2 0535007]
  Actuator5-35 MON Force	[E-0535 0:3 0535006]
  Actuator5-35 Drive Off	[E-0535 0:4 0535005]
  Actuator5-35 Drive On	[E-0535 0:5 0535004]
  Actuator5-35 CONT Position	[E-0535 0:6 0535003]
  Actuator5-35 CONT Force	[E-0535 0:7 0535002]
  Actuator5-35 Alarm Reset	[E-0535 1:1 0535020]
  Actuator5-35 Limit Release	[E-0535 1:2 053501F]
  Actuator5-35 Selected Step	[E-0535 1:3 053500E]
  Actuator5-35 Selected Load	[E-0535 1:4 053500D]
  Actuator5-35 Selected Drive	[E-0535 1:5 053500C]
  Actuator5-35 Maunakea	[E-0535 1:6 053500B]
  Actuator5-35 Sea Level	[E-0535 1:7 053500A]
  Actuator5-35 Up Limit	[E-0535 2:0 0535016]
  Actuator5-35 Driver Alarm	[E-0535 2:1 0535015]
  Actuator5-35 Error Alarm	[E-0535 2:2 0535014]
  Actuator5-35 Over Current	[E-0535 2:3 0535013]
  Actuator5-35 Over Speed	[E-0535 2:4 0535012]
  Actuator5-35 Over Load	[E-0535 2:5 0535011]
  Actuator5-35 PS Alarm	[E-0535 2:6 0535010]
  Actuator5-35 ENC Alarm	[E-0535 2:7 053500F]
  Actuator5-35 CPU Alarm	[E-0535 3:0 053501E]
  Actuator5-35 UART Alarm	[E-0535 3:1 053501D]
  Actuator5-35 HDLC Alarm	[E-0535 3:2 053501C]
  Actuator5-35 Force Card Fault	[E-0535 3:3 053501B]
  Actuator5-35 Force Sensor Fault	[E-0535 3:4 053501A]
  Actuator5-35 Under Range	[E-0535 3:5 0535019]
  Actuator5-35 Over Range	[E-0535 3:6 0535018]
  Actuator5-35 Down Limit	[E-0535 3:7 0535017]
  Actuator5-36 MON PARA	[E-0536 0:0 0536009]
  Actuator5-36 MON HYB	[E-0536 0:1 0536008]
  Actuator5-36 MON Position	[E-0536 0:2 0536007]
  Actuator5-36 MON Force	[E-0536 0:3 0536006]
  Actuator5-36 Drive Off	[E-0536 0:4 0536005]
  Actuator5-36 Drive On	[E-0536 0:5 0536004]
  Actuator5-36 CONT Position	[E-0536 0:6 0536003]
  Actuator5-36 CONT Force	[E-0536 0:7 0536002]
  Actuator5-36 Alarm Reset	[E-0536 1:1 0536020]
  Actuator5-36 Limit Release	[E-0536 1:2 053601F]
  Actuator5-36 Selected Step	[E-0536 1:3 053600E]
  Actuator5-36 Selected Load	[E-0536 1:4 053600D]
  Actuator5-36 Selected Drive	[E-0536 1:5 053600C]
  Actuator5-36 Maunakea	[E-0536 1:6 053600B]
  Actuator5-36 Sea Level	[E-0536 1:7 053600A]
  Actuator5-36 Up Limit	[E-0536 2:0 0536016]
  Actuator5-36 Driver Alarm	[E-0536 2:1 0536015]
  Actuator5-36 Error Alarm	[E-0536 2:2 0536014]
  Actuator5-36 Over Current	[E-0536 2:3 0536013]
  Actuator5-36 Over Speed	[E-0536 2:4 0536012]
  Actuator5-36 Over Load	[E-0536 2:5 0536011]
  Actuator5-36 PS Alarm	[E-0536 2:6 0536010]
  Actuator5-36 ENC Alarm	[E-0536 2:7 053600F]
  Actuator5-36 CPU Alarm	[E-0536 3:0 053601E]
  Actuator5-36 UART Alarm	[E-0536 3:1 053601D]
  Actuator5-36 HDLC Alarm	[E-0536 3:2 053601C]
  Actuator5-36 Force Card Fault	[E-0536 3:3 053601B]
  Actuator5-36 Force Sensor Fault	[E-0536 3:4 053601A]
  Actuator5-36 Under Range	[E-0536 3:5 0536019]
  Actuator5-36 Over Range	[E-0536 3:6 0536018]
  Actuator5-36 Down Limit	[E-0536 3:7 0536017]
  Actuator5-37 MON PARA	[E-0537 0:0 0537009]
  Actuator5-37 MON HYB	[E-0537 0:1 0537008]
  Actuator5-37 MON Position	[E-0537 0:2 0537007]
  Actuator5-37 MON Force	[E-0537 0:3 0537006]
  Actuator5-37 Drive Off	[E-0537 0:4 0537005]
  Actuator5-37 Drive On	[E-0537 0:5 0537004]
  Actuator5-37 CONT Position	[E-0537 0:6 0537003]
  Actuator5-37 CONT Force	[E-0537 0:7 0537002]
  Actuator5-37 Alarm Reset	[E-0537 1:1 0537020]
  Actuator5-37 Limit Release	[E-0537 1:2 053701F]
  Actuator5-37 Selected Step	[E-0537 1:3 053700E]
  Actuator5-37 Selected Load	[E-0537 1:4 053700D]
  Actuator5-37 Selected Drive	[E-0537 1:5 053700C]
  Actuator5-37 Maunakea	[E-0537 1:6 053700B]
  Actuator5-37 Sea Level	[E-0537 1:7 053700A]
  Actuator5-37 Up Limit	[E-0537 2:0 0537016]
  Actuator5-37 Driver Alarm	[E-0537 2:1 0537015]
  Actuator5-37 Error Alarm	[E-0537 2:2 0537014]
  Actuator5-37 Over Current	[E-0537 2:3 0537013]
  Actuator5-37 Over Speed	[E-0537 2:4 0537012]
  Actuator5-37 Over Load	[E-0537 2:5 0537011]
  Actuator5-37 PS Alarm	[E-0537 2:6 0537010]
  Actuator5-37 ENC Alarm	[E-0537 2:7 053700F]
  Actuator5-37 CPU Alarm	[E-0537 3:0 053701E]
  Actuator5-37 UART Alarm	[E-0537 3:1 053701D]
  Actuator5-37 HDLC Alarm	[E-0537 3:2 053701C]
  Actuator5-37 Force Card Fault	[E-0537 3:3 053701B]
  Actuator5-37 Force Sensor Fault	[E-0537 3:4 053701A]
  Actuator5-37 Under Range	[E-0537 3:5 0537019]
  Actuator5-37 Over Range	[E-0537 3:6 0537018]
  Actuator5-37 Down Limit	[E-0537 3:7 0537017]
  Actuator5-38 MON PARA	[E-0538 0:0 0538009]
  Actuator5-38 MON HYB	[E-0538 0:1 0538008]
  Actuator5-38 MON Position	[E-0538 0:2 0538007]
  Actuator5-38 MON Force	[E-0538 0:3 0538006]
  Actuator5-38 Drive Off	[E-0538 0:4 0538005]
  Actuator5-38 Drive On	[E-0538 0:5 0538004]
  Actuator5-38 CONT Position	[E-0538 0:6 0538003]
  Actuator5-38 CONT Force	[E-0538 0:7 0538002]
  Actuator5-38 Alarm Reset	[E-0538 1:1 0538020]
  Actuator5-38 Limit Release	[E-0538 1:2 053801F]
  Actuator5-38 Selected Step	[E-0538 1:3 053800E]
  Actuator5-38 Selected Load	[E-0538 1:4 053800D]
  Actuator5-38 Selected Drive	[E-0538 1:5 053800C]
  Actuator5-38 Maunakea	[E-0538 1:6 053800B]
  Actuator5-38 Sea Level	[E-0538 1:7 053800A]
  Actuator5-38 Up Limit	[E-0538 2:0 0538016]
  Actuator5-38 Driver Alarm	[E-0538 2:1 0538015]
  Actuator5-38 Error Alarm	[E-0538 2:2 0538014]
  Actuator5-38 Over Current	[E-0538 2:3 0538013]
  Actuator5-38 Over Speed	[E-0538 2:4 0538012]
  Actuator5-38 Over Load	[E-0538 2:5 0538011]
  Actuator5-38 PS Alarm	[E-0538 2:6 0538010]
  Actuator5-38 ENC Alarm	[E-0538 2:7 053800F]
  Actuator5-38 CPU Alarm	[E-0538 3:0 053801E]
  Actuator5-38 UART Alarm	[E-0538 3:1 053801D]
  Actuator5-38 HDLC Alarm	[E-0538 3:2 053801C]
  Actuator5-38 Force Card Fault	[E-0538 3:3 053801B]
  Actuator5-38 Force Sensor Fault	[E-0538 3:4 053801A]
  Actuator5-38 Under Range	[E-0538 3:5 0538019]
  Actuator5-38 Over Range	[E-0538 3:6 0538018]
  Actuator5-38 Down Limit	[E-0538 3:7 0538017]
  Actuator5-39 MON PARA	[E-0539 0:0 0539009]
  Actuator5-39 MON HYB	[E-0539 0:1 0539008]
  Actuator5-39 MON Position	[E-0539 0:2 0539007]
  Actuator5-39 MON Force	[E-0539 0:3 0539006]
  Actuator5-39 Drive Off	[E-0539 0:4 0539005]
  Actuator5-39 Drive On	[E-0539 0:5 0539004]
  Actuator5-39 CONT Position	[E-0539 0:6 0539003]
  Actuator5-39 CONT Force	[E-0539 0:7 0539002]
  Actuator5-39 Alarm Reset	[E-0539 1:1 0539020]
  Actuator5-39 Limit Release	[E-0539 1:2 053901F]
  Actuator5-39 Selected Step	[E-0539 1:3 053900E]
  Actuator5-39 Selected Load	[E-0539 1:4 053900D]
  Actuator5-39 Selected Drive	[E-0539 1:5 053900C]
  Actuator5-39 Maunakea	[E-0539 1:6 053900B]
  Actuator5-39 Sea Level	[E-0539 1:7 053900A]
  Actuator5-39 Up Limit	[E-0539 2:0 0539016]
  Actuator5-39 Driver Alarm	[E-0539 2:1 0539015]
  Actuator5-39 Error Alarm	[E-0539 2:2 0539014]
  Actuator5-39 Over Current	[E-0539 2:3 0539013]
  Actuator5-39 Over Speed	[E-0539 2:4 0539012]
  Actuator5-39 Over Load	[E-0539 2:5 0539011]
  Actuator5-39 PS Alarm	[E-0539 2:6 0539010]
  Actuator5-39 ENC Alarm	[E-0539 2:7 053900F]
  Actuator5-39 CPU Alarm	[E-0539 3:0 053901E]
  Actuator5-39 UART Alarm	[E-0539 3:1 053901D]
  Actuator5-39 HDLC Alarm	[E-0539 3:2 053901C]
  Actuator5-39 Force Card Fault	[E-0539 3:3 053901B]
  Actuator5-39 Force Sensor Fault	[E-0539 3:4 053901A]
  Actuator5-39 Under Range	[E-0539 3:5 0539019]
  Actuator5-39 Over Range	[E-0539 3:6 0539018]
  Actuator5-39 Down Limit	[E-0539 3:7 0539017]
  Actuator5-40 MON PARA	[E-0540 0:0 0540009]
  Actuator5-40 MON HYB	[E-0540 0:1 0540008]
  Actuator5-40 MON Position	[E-0540 0:2 0540007]
  Actuator5-40 MON Force	[E-0540 0:3 0540006]
  Actuator5-40 Drive Off	[E-0540 0:4 0540005]
  Actuator5-40 Drive On	[E-0540 0:5 0540004]
  Actuator5-40 CONT Position	[E-0540 0:6 0540003]
  Actuator5-40 CONT Force	[E-0540 0:7 0540002]
  Actuator5-40 Alarm Reset	[E-0540 1:1 0540020]
  Actuator5-40 Limit Release	[E-0540 1:2 054001F]
  Actuator5-40 Selected Step	[E-0540 1:3 054000E]
  Actuator5-40 Selected Load	[E-0540 1:4 054000D]
  Actuator5-40 Selected Drive	[E-0540 1:5 054000C]
  Actuator5-40 Maunakea	[E-0540 1:6 054000B]
  Actuator5-40 Sea Level	[E-0540 1:7 054000A]
  Actuator5-40 Up Limit	[E-0540 2:0 0540016]
  Actuator5-40 Driver Alarm	[E-0540 2:1 0540015]
  Actuator5-40 Error Alarm	[E-0540 2:2 0540014]
  Actuator5-40 Over Current	[E-0540 2:3 0540013]
  Actuator5-40 Over Speed	[E-0540 2:4 0540012]
  Actuator5-40 Over Load	[E-0540 2:5 0540011]
  Actuator5-40 PS Alarm	[E-0540 2:6 0540010]
  Actuator5-40 ENC Alarm	[E-0540 2:7 054000F]
  Actuator5-40 CPU Alarm	[E-0540 3:0 054001E]
  Actuator5-40 UART Alarm	[E-0540 3:1 054001D]
  Actuator5-40 HDLC Alarm	[E-0540 3:2 054001C]
  Actuator5-40 Force Card Fault	[E-0540 3:3 054001B]
  Actuator5-40 Force Sensor Fault	[E-0540 3:4 054001A]
  Actuator5-40 Under Range	[E-0540 3:5 0540019]
  Actuator5-40 Over Range	[E-0540 3:6 0540018]
  Actuator5-40 Down Limit	[E-0540 3:7 0540017]
  Actuator5-41 MON PARA	[E-0541 0:0 0541009]
  Actuator5-41 MON HYB	[E-0541 0:1 0541008]
  Actuator5-41 MON Position	[E-0541 0:2 0541007]
  Actuator5-41 MON Force	[E-0541 0:3 0541006]
  Actuator5-41 Drive Off	[E-0541 0:4 0541005]
  Actuator5-41 Drive On	[E-0541 0:5 0541004]
  Actuator5-41 CONT Position	[E-0541 0:6 0541003]
  Actuator5-41 CONT Force	[E-0541 0:7 0541002]
  Actuator5-41 Alarm Reset	[E-0541 1:1 0541020]
  Actuator5-41 Limit Release	[E-0541 1:2 054101F]
  Actuator5-41 Selected Step	[E-0541 1:3 054100E]
  Actuator5-41 Selected Load	[E-0541 1:4 054100D]
  Actuator5-41 Selected Drive	[E-0541 1:5 054100C]
  Actuator5-41 Maunakea	[E-0541 1:6 054100B]
  Actuator5-41 Sea Level	[E-0541 1:7 054100A]
  Actuator5-41 Up Limit	[E-0541 2:0 0541016]
  Actuator5-41 Driver Alarm	[E-0541 2:1 0541015]
  Actuator5-41 Error Alarm	[E-0541 2:2 0541014]
  Actuator5-41 Over Current	[E-0541 2:3 0541013]
  Actuator5-41 Over Speed	[E-0541 2:4 0541012]
  Actuator5-41 Over Load	[E-0541 2:5 0541011]
  Actuator5-41 PS Alarm	[E-0541 2:6 0541010]
  Actuator5-41 ENC Alarm	[E-0541 2:7 054100F]
  Actuator5-41 CPU Alarm	[E-0541 3:0 054101E]
  Actuator5-41 UART Alarm	[E-0541 3:1 054101D]
  Actuator5-41 HDLC Alarm	[E-0541 3:2 054101C]
  Actuator5-41 Force Card Fault	[E-0541 3:3 054101B]
  Actuator5-41 Force Sensor Fault	[E-0541 3:4 054101A]
  Actuator5-41 Under Range	[E-0541 3:5 0541019]
  Actuator5-41 Over Range	[E-0541 3:6 0541018]
  Actuator5-41 Down Limit	[E-0541 3:7 0541017]
  Actuator5-42 MON PARA	[E-0542 0:0 0542009]
  Actuator5-42 MON HYB	[E-0542 0:1 0542008]
  Actuator5-42 MON Position	[E-0542 0:2 0542007]
  Actuator5-42 MON Force	[E-0542 0:3 0542006]
  Actuator5-42 Drive Off	[E-0542 0:4 0542005]
  Actuator5-42 Drive On	[E-0542 0:5 0542004]
  Actuator5-42 CONT Position	[E-0542 0:6 0542003]
  Actuator5-42 CONT Force	[E-0542 0:7 0542002]
  Actuator5-42 Alarm Reset	[E-0542 1:1 0542020]
  Actuator5-42 Limit Release	[E-0542 1:2 054201F]
  Actuator5-42 Selected Step	[E-0542 1:3 054200E]
  Actuator5-42 Selected Load	[E-0542 1:4 054200D]
  Actuator5-42 Selected Drive	[E-0542 1:5 054200C]
  Actuator5-42 Maunakea	[E-0542 1:6 054200B]
  Actuator5-42 Sea Level	[E-0542 1:7 054200A]
  Actuator5-42 Up Limit	[E-0542 2:0 0542016]
  Actuator5-42 Driver Alarm	[E-0542 2:1 0542015]
  Actuator5-42 Error Alarm	[E-0542 2:2 0542014]
  Actuator5-42 Over Current	[E-0542 2:3 0542013]
  Actuator5-42 Over Speed	[E-0542 2:4 0542012]
  Actuator5-42 Over Load	[E-0542 2:5 0542011]
  Actuator5-42 PS Alarm	[E-0542 2:6 0542010]
  Actuator5-42 ENC Alarm	[E-0542 2:7 054200F]
  Actuator5-42 CPU Alarm	[E-0542 3:0 054201E]
  Actuator5-42 UART Alarm	[E-0542 3:1 054201D]
  Actuator5-42 HDLC Alarm	[E-0542 3:2 054201C]
  Actuator5-42 Force Card Fault	[E-0542 3:3 054201B]
  Actuator5-42 Force Sensor Fault	[E-0542 3:4 054201A]
  Actuator5-42 Under Range	[E-0542 3:5 0542019]
  Actuator5-42 Over Range	[E-0542 3:6 0542018]
  Actuator5-42 Down Limit	[E-0542 3:7 0542017]
  Actuator5-43 MON PARA	[E-0543 0:0 0543009]
  Actuator5-43 MON HYB	[E-0543 0:1 0543008]
  Actuator5-43 MON Position	[E-0543 0:2 0543007]
  Actuator5-43 MON Force	[E-0543 0:3 0543006]
  Actuator5-43 Drive Off	[E-0543 0:4 0543005]
  Actuator5-43 Drive On	[E-0543 0:5 0543004]
  Actuator5-43 CONT Position	[E-0543 0:6 0543003]
  Actuator5-43 CONT Force	[E-0543 0:7 0543002]
  Actuator5-43 Alarm Reset	[E-0543 1:1 0543020]
  Actuator5-43 Limit Release	[E-0543 1:2 054301F]
  Actuator5-43 Selected Step	[E-0543 1:3 054300E]
  Actuator5-43 Selected Load	[E-0543 1:4 054300D]
  Actuator5-43 Selected Drive	[E-0543 1:5 054300C]
  Actuator5-43 Maunakea	[E-0543 1:6 054300B]
  Actuator5-43 Sea Level	[E-0543 1:7 054300A]
  Actuator5-43 Up Limit	[E-0543 2:0 0543016]
  Actuator5-43 Driver Alarm	[E-0543 2:1 0543015]
  Actuator5-43 Error Alarm	[E-0543 2:2 0543014]
  Actuator5-43 Over Current	[E-0543 2:3 0543013]
  Actuator5-43 Over Speed	[E-0543 2:4 0543012]
  Actuator5-43 Over Load	[E-0543 2:5 0543011]
  Actuator5-43 PS Alarm	[E-0543 2:6 0543010]
  Actuator5-43 ENC Alarm	[E-0543 2:7 054300F]
  Actuator5-43 CPU Alarm	[E-0543 3:0 054301E]
  Actuator5-43 UART Alarm	[E-0543 3:1 054301D]
  Actuator5-43 HDLC Alarm	[E-0543 3:2 054301C]
  Actuator5-43 Force Card Fault	[E-0543 3:3 054301B]
  Actuator5-43 Force Sensor Fault	[E-0543 3:4 054301A]
  Actuator5-43 Under Range	[E-0543 3:5 0543019]
  Actuator5-43 Over Range	[E-0543 3:6 0543018]
  Actuator5-43 Down Limit	[E-0543 3:7 0543017]
  Actuator5-44 MON PARA	[E-0544 0:0 0544009]
  Actuator5-44 MON HYB	[E-0544 0:1 0544008]
  Actuator5-44 MON Position	[E-0544 0:2 0544007]
  Actuator5-44 MON Force	[E-0544 0:3 0544006]
  Actuator5-44 Drive Off	[E-0544 0:4 0544005]
  Actuator5-44 Drive On	[E-0544 0:5 0544004]
  Actuator5-44 CONT Position	[E-0544 0:6 0544003]
  Actuator5-44 CONT Force	[E-0544 0:7 0544002]
  Actuator5-44 Alarm Reset	[E-0544 1:1 0544020]
  Actuator5-44 Limit Release	[E-0544 1:2 054401F]
  Actuator5-44 Selected Step	[E-0544 1:3 054400E]
  Actuator5-44 Selected Load	[E-0544 1:4 054400D]
  Actuator5-44 Selected Drive	[E-0544 1:5 054400C]
  Actuator5-44 Maunakea	[E-0544 1:6 054400B]
  Actuator5-44 Sea Level	[E-0544 1:7 054400A]
  Actuator5-44 Up Limit	[E-0544 2:0 0544016]
  Actuator5-44 Driver Alarm	[E-0544 2:1 0544015]
  Actuator5-44 Error Alarm	[E-0544 2:2 0544014]
  Actuator5-44 Over Current	[E-0544 2:3 0544013]
  Actuator5-44 Over Speed	[E-0544 2:4 0544012]
  Actuator5-44 Over Load	[E-0544 2:5 0544011]
  Actuator5-44 PS Alarm	[E-0544 2:6 0544010]
  Actuator5-44 ENC Alarm	[E-0544 2:7 054400F]
  Actuator5-44 CPU Alarm	[E-0544 3:0 054401E]
  Actuator5-44 UART Alarm	[E-0544 3:1 054401D]
  Actuator5-44 HDLC Alarm	[E-0544 3:2 054401C]
  Actuator5-44 Force Card Fault	[E-0544 3:3 054401B]
  Actuator5-44 Force Sensor Fault	[E-0544 3:4 054401A]
  Actuator5-44 Under Range	[E-0544 3:5 0544019]
  Actuator5-44 Over Range	[E-0544 3:6 0544018]
  Actuator5-44 Down Limit	[E-0544 3:7 0544017]
  Actuator5-45 MON PARA	[E-0545 0:0 0545009]
  Actuator5-45 MON HYB	[E-0545 0:1 0545008]
  Actuator5-45 MON Position	[E-0545 0:2 0545007]
  Actuator5-45 MON Force	[E-0545 0:3 0545006]
  Actuator5-45 Drive Off	[E-0545 0:4 0545005]
  Actuator5-45 Drive On	[E-0545 0:5 0545004]
  Actuator5-45 CONT Position	[E-0545 0:6 0545003]
  Actuator5-45 CONT Force	[E-0545 0:7 0545002]
  Actuator5-45 Alarm Reset	[E-0545 1:1 0545020]
  Actuator5-45 Limit Release	[E-0545 1:2 054501F]
  Actuator5-45 Selected Step	[E-0545 1:3 054500E]
  Actuator5-45 Selected Load	[E-0545 1:4 054500D]
  Actuator5-45 Selected Drive	[E-0545 1:5 054500C]
  Actuator5-45 Maunakea	[E-0545 1:6 054500B]
  Actuator5-45 Sea Level	[E-0545 1:7 054500A]
  Actuator5-45 Up Limit	[E-0545 2:0 0545016]
  Actuator5-45 Driver Alarm	[E-0545 2:1 0545015]
  Actuator5-45 Error Alarm	[E-0545 2:2 0545014]
  Actuator5-45 Over Current	[E-0545 2:3 0545013]
  Actuator5-45 Over Speed	[E-0545 2:4 0545012]
  Actuator5-45 Over Load	[E-0545 2:5 0545011]
  Actuator5-45 PS Alarm	[E-0545 2:6 0545010]
  Actuator5-45 ENC Alarm	[E-0545 2:7 054500F]
  Actuator5-45 CPU Alarm	[E-0545 3:0 054501E]
  Actuator5-45 UART Alarm	[E-0545 3:1 054501D]
  Actuator5-45 HDLC Alarm	[E-0545 3:2 054501C]
  Actuator5-45 Force Card Fault	[E-0545 3:3 054501B]
  Actuator5-45 Force Sensor Fault	[E-0545 3:4 054501A]
  Actuator5-45 Under Range	[E-0545 3:5 0545019]
  Actuator5-45 Over Range	[E-0545 3:6 0545018]
  Actuator5-45 Down Limit	[E-0545 3:7 0545017]
  Actuator5-46 MON PARA	[E-0546 0:0 0546009]
  Actuator5-46 MON HYB	[E-0546 0:1 0546008]
  Actuator5-46 MON Position	[E-0546 0:2 0546007]
  Actuator5-46 MON Force	[E-0546 0:3 0546006]
  Actuator5-46 Drive Off	[E-0546 0:4 0546005]
  Actuator5-46 Drive On	[E-0546 0:5 0546004]
  Actuator5-46 CONT Position	[E-0546 0:6 0546003]
  Actuator5-46 CONT Force	[E-0546 0:7 0546002]
  Actuator5-46 Alarm Reset	[E-0546 1:1 0546020]
  Actuator5-46 Limit Release	[E-0546 1:2 054601F]
  Actuator5-46 Selected Step	[E-0546 1:3 054600E]
  Actuator5-46 Selected Load	[E-0546 1:4 054600D]
  Actuator5-46 Selected Drive	[E-0546 1:5 054600C]
  Actuator5-46 Maunakea	[E-0546 1:6 054600B]
  Actuator5-46 Sea Level	[E-0546 1:7 054600A]
  Actuator5-46 Up Limit	[E-0546 2:0 0546016]
  Actuator5-46 Driver Alarm	[E-0546 2:1 0546015]
  Actuator5-46 Error Alarm	[E-0546 2:2 0546014]
  Actuator5-46 Over Current	[E-0546 2:3 0546013]
  Actuator5-46 Over Speed	[E-0546 2:4 0546012]
  Actuator5-46 Over Load	[E-0546 2:5 0546011]
  Actuator5-46 PS Alarm	[E-0546 2:6 0546010]
  Actuator5-46 ENC Alarm	[E-0546 2:7 054600F]
  Actuator5-46 CPU Alarm	[E-0546 3:0 054601E]
  Actuator5-46 UART Alarm	[E-0546 3:1 054601D]
  Actuator5-46 HDLC Alarm	[E-0546 3:2 054601C]
  Actuator5-46 Force Card Fault	[E-0546 3:3 054601B]
  Actuator5-46 Force Sensor Fault	[E-0546 3:4 054601A]
  Actuator5-46 Under Range	[E-0546 3:5 0546019]
  Actuator5-46 Over Range	[E-0546 3:6 0546018]
  Actuator5-46 Down Limit	[E-0546 3:7 0546017]
  Actuator5-47 MON PARA	[E-0547 0:0 0547009]
  Actuator5-47 MON HYB	[E-0547 0:1 0547008]
  Actuator5-47 MON Position	[E-0547 0:2 0547007]
  Actuator5-47 MON Force	[E-0547 0:3 0547006]
  Actuator5-47 Drive Off	[E-0547 0:4 0547005]
  Actuator5-47 Drive On	[E-0547 0:5 0547004]
  Actuator5-47 CONT Position	[E-0547 0:6 0547003]
  Actuator5-47 CONT Force	[E-0547 0:7 0547002]
  Actuator5-47 Alarm Reset	[E-0547 1:1 0547020]
  Actuator5-47 Limit Release	[E-0547 1:2 054701F]
  Actuator5-47 Selected Step	[E-0547 1:3 054700E]
  Actuator5-47 Selected Load	[E-0547 1:4 054700D]
  Actuator5-47 Selected Drive	[E-0547 1:5 054700C]
  Actuator5-47 Maunakea	[E-0547 1:6 054700B]
  Actuator5-47 Sea Level	[E-0547 1:7 054700A]
  Actuator5-47 Up Limit	[E-0547 2:0 0547016]
  Actuator5-47 Driver Alarm	[E-0547 2:1 0547015]
  Actuator5-47 Error Alarm	[E-0547 2:2 0547014]
  Actuator5-47 Over Current	[E-0547 2:3 0547013]
  Actuator5-47 Over Speed	[E-0547 2:4 0547012]
  Actuator5-47 Over Load	[E-0547 2:5 0547011]
  Actuator5-47 PS Alarm	[E-0547 2:6 0547010]
  Actuator5-47 ENC Alarm	[E-0547 2:7 054700F]
  Actuator5-47 CPU Alarm	[E-0547 3:0 054701E]
  Actuator5-47 UART Alarm	[E-0547 3:1 054701D]
  Actuator5-47 HDLC Alarm	[E-0547 3:2 054701C]
  Actuator5-47 Force Card Fault	[E-0547 3:3 054701B]
  Actuator5-47 Force Sensor Fault	[E-0547 3:4 054701A]
  Actuator5-47 Under Range	[E-0547 3:5 0547019]
  Actuator5-47 Over Range	[E-0547 3:6 0547018]
  Actuator5-47 Down Limit	[E-0547 3:7 0547017]
  Actuator5-48 MON PARA	[E-0548 0:0 0548009]
  Actuator5-48 MON HYB	[E-0548 0:1 0548008]
  Actuator5-48 MON Position	[E-0548 0:2 0548007]
  Actuator5-48 MON Force	[E-0548 0:3 0548006]
  Actuator5-48 Drive Off	[E-0548 0:4 0548005]
  Actuator5-48 Drive On	[E-0548 0:5 0548004]
  Actuator5-48 CONT Position	[E-0548 0:6 0548003]
  Actuator5-48 CONT Force	[E-0548 0:7 0548002]
  Actuator5-48 Alarm Reset	[E-0548 1:1 0548020]
  Actuator5-48 Limit Release	[E-0548 1:2 054801F]
  Actuator5-48 Selected Step	[E-0548 1:3 054800E]
  Actuator5-48 Selected Load	[E-0548 1:4 054800D]
  Actuator5-48 Selected Drive	[E-0548 1:5 054800C]
  Actuator5-48 Maunakea	[E-0548 1:6 054800B]
  Actuator5-48 Sea Level	[E-0548 1:7 054800A]
  Actuator5-48 Up Limit	[E-0548 2:0 0548016]
  Actuator5-48 Driver Alarm	[E-0548 2:1 0548015]
  Actuator5-48 Error Alarm	[E-0548 2:2 0548014]
  Actuator5-48 Over Current	[E-0548 2:3 0548013]
  Actuator5-48 Over Speed	[E-0548 2:4 0548012]
  Actuator5-48 Over Load	[E-0548 2:5 0548011]
  Actuator5-48 PS Alarm	[E-0548 2:6 0548010]
  Actuator5-48 ENC Alarm	[E-0548 2:7 054800F]
  Actuator5-48 CPU Alarm	[E-0548 3:0 054801E]
  Actuator5-48 UART Alarm	[E-0548 3:1 054801D]
  Actuator5-48 HDLC Alarm	[E-0548 3:2 054801C]
  Actuator5-48 Force Card Fault	[E-0548 3:3 054801B]
  Actuator5-48 Force Sensor Fault	[E-0548 3:4 054801A]
  Actuator5-48 Under Range	[E-0548 3:5 0548019]
  Actuator5-48 Over Range	[E-0548 3:6 0548018]
  Actuator5-48 Down Limit	[E-0548 3:7 0548017]
  Actuator5-49 MON PARA	[E-0549 0:0 0549009]
  Actuator5-49 MON HYB	[E-0549 0:1 0549008]
  Actuator5-49 MON Position	[E-0549 0:2 0549007]
  Actuator5-49 MON Force	[E-0549 0:3 0549006]
  Actuator5-49 Drive Off	[E-0549 0:4 0549005]
  Actuator5-49 Drive On	[E-0549 0:5 0549004]
  Actuator5-49 CONT Position	[E-0549 0:6 0549003]
  Actuator5-49 CONT Force	[E-0549 0:7 0549002]
  Actuator5-49 Alarm Reset	[E-0549 1:1 0549020]
  Actuator5-49 Limit Release	[E-0549 1:2 054901F]
  Actuator5-49 Selected Step	[E-0549 1:3 054900E]
  Actuator5-49 Selected Load	[E-0549 1:4 054900D]
  Actuator5-49 Selected Drive	[E-0549 1:5 054900C]
  Actuator5-49 Maunakea	[E-0549 1:6 054900B]
  Actuator5-49 Sea Level	[E-0549 1:7 054900A]
  Actuator5-49 Up Limit	[E-0549 2:0 0549016]
  Actuator5-49 Driver Alarm	[E-0549 2:1 0549015]
  Actuator5-49 Error Alarm	[E-0549 2:2 0549014]
  Actuator5-49 Over Current	[E-0549 2:3 0549013]
  Actuator5-49 Over Speed	[E-0549 2:4 0549012]
  Actuator5-49 Over Load	[E-0549 2:5 0549011]
  Actuator5-49 PS Alarm	[E-0549 2:6 0549010]
  Actuator5-49 ENC Alarm	[E-0549 2:7 054900F]
  Actuator5-49 CPU Alarm	[E-0549 3:0 054901E]
  Actuator5-49 UART Alarm	[E-0549 3:1 054901D]
  Actuator5-49 HDLC Alarm	[E-0549 3:2 054901C]
  Actuator5-49 Force Card Fault	[E-0549 3:3 054901B]
  Actuator5-49 Force Sensor Fault	[E-0549 3:4 054901A]
  Actuator5-49 Under Range	[E-0549 3:5 0549019]
  Actuator5-49 Over Range	[E-0549 3:6 0549018]
  Actuator5-49 Down Limit	[E-0549 3:7 0549017]
  Actuator5-50 MON PARA	[E-0550 0:0 0550009]
  Actuator5-50 MON HYB	[E-0550 0:1 0550008]
  Actuator5-50 MON Position	[E-0550 0:2 0550007]
  Actuator5-50 MON Force	[E-0550 0:3 0550006]
  Actuator5-50 Drive Off	[E-0550 0:4 0550005]
  Actuator5-50 Drive On	[E-0550 0:5 0550004]
  Actuator5-50 CONT Position	[E-0550 0:6 0550003]
  Actuator5-50 CONT Force	[E-0550 0:7 0550002]
  Actuator5-50 Alarm Reset	[E-0550 1:1 0550020]
  Actuator5-50 Limit Release	[E-0550 1:2 055001F]
  Actuator5-50 Selected Step	[E-0550 1:3 055000E]
  Actuator5-50 Selected Load	[E-0550 1:4 055000D]
  Actuator5-50 Selected Drive	[E-0550 1:5 055000C]
  Actuator5-50 Maunakea	[E-0550 1:6 055000B]
  Actuator5-50 Sea Level	[E-0550 1:7 055000A]
  Actuator5-50 Up Limit	[E-0550 2:0 0550016]
  Actuator5-50 Driver Alarm	[E-0550 2:1 0550015]
  Actuator5-50 Error Alarm	[E-0550 2:2 0550014]
  Actuator5-50 Over Current	[E-0550 2:3 0550013]
  Actuator5-50 Over Speed	[E-0550 2:4 0550012]
  Actuator5-50 Over Load	[E-0550 2:5 0550011]
  Actuator5-50 PS Alarm	[E-0550 2:6 0550010]
  Actuator5-50 ENC Alarm	[E-0550 2:7 055000F]
  Actuator5-50 CPU Alarm	[E-0550 3:0 055001E]
  Actuator5-50 UART Alarm	[E-0550 3:1 055001D]
  Actuator5-50 HDLC Alarm	[E-0550 3:2 055001C]
  Actuator5-50 Force Card Fault	[E-0550 3:3 055001B]
  Actuator5-50 Force Sensor Fault	[E-0550 3:4 055001A]
  Actuator5-50 Under Range	[E-0550 3:5 0550019]
  Actuator5-50 Over Range	[E-0550 3:6 0550018]
  Actuator5-50 Down Limit	[E-0550 3:7 0550017]
  Actuator5-51 MON PARA	[E-0551 0:0 0551009]
  Actuator5-51 MON HYB	[E-0551 0:1 0551008]
  Actuator5-51 MON Position	[E-0551 0:2 0551007]
  Actuator5-51 MON Force	[E-0551 0:3 0551006]
  Actuator5-51 Drive Off	[E-0551 0:4 0551005]
  Actuator5-51 Drive On	[E-0551 0:5 0551004]
  Actuator5-51 CONT Position	[E-0551 0:6 0551003]
  Actuator5-51 CONT Force	[E-0551 0:7 0551002]
  Actuator5-51 Alarm Reset	[E-0551 1:1 0551020]
  Actuator5-51 Limit Release	[E-0551 1:2 055101F]
  Actuator5-51 Selected Step	[E-0551 1:3 055100E]
  Actuator5-51 Selected Load	[E-0551 1:4 055100D]
  Actuator5-51 Selected Drive	[E-0551 1:5 055100C]
  Actuator5-51 Maunakea	[E-0551 1:6 055100B]
  Actuator5-51 Sea Level	[E-0551 1:7 055100A]
  Actuator5-51 Up Limit	[E-0551 2:0 0551016]
  Actuator5-51 Driver Alarm	[E-0551 2:1 0551015]
  Actuator5-51 Error Alarm	[E-0551 2:2 0551014]
  Actuator5-51 Over Current	[E-0551 2:3 0551013]
  Actuator5-51 Over Speed	[E-0551 2:4 0551012]
  Actuator5-51 Over Load	[E-0551 2:5 0551011]
  Actuator5-51 PS Alarm	[E-0551 2:6 0551010]
  Actuator5-51 ENC Alarm	[E-0551 2:7 055100F]
  Actuator5-51 CPU Alarm	[E-0551 3:0 055101E]
  Actuator5-51 UART Alarm	[E-0551 3:1 055101D]
  Actuator5-51 HDLC Alarm	[E-0551 3:2 055101C]
  Actuator5-51 Force Card Fault	[E-0551 3:3 055101B]
  Actuator5-51 Force Sensor Fault	[E-0551 3:4 055101A]
  Actuator5-51 Under Range	[E-0551 3:5 0551019]
  Actuator5-51 Over Range	[E-0551 3:6 0551018]
  Actuator5-51 Down Limit	[E-0551 3:7 0551017]
  Actuator5-52 MON PARA	[E-0552 0:0 0552009]
  Actuator5-52 MON HYB	[E-0552 0:1 0552008]
  Actuator5-52 MON Position	[E-0552 0:2 0552007]
  Actuator5-52 MON Force	[E-0552 0:3 0552006]
  Actuator5-52 Drive Off	[E-0552 0:4 0552005]
  Actuator5-52 Drive On	[E-0552 0:5 0552004]
  Actuator5-52 CONT Position	[E-0552 0:6 0552003]
  Actuator5-52 CONT Force	[E-0552 0:7 0552002]
  Actuator5-52 Alarm Reset	[E-0552 1:1 0552020]
  Actuator5-52 Limit Release	[E-0552 1:2 055201F]
  Actuator5-52 Selected Step	[E-0552 1:3 055200E]
  Actuator5-52 Selected Load	[E-0552 1:4 055200D]
  Actuator5-52 Selected Drive	[E-0552 1:5 055200C]
  Actuator5-52 Maunakea	[E-0552 1:6 055200B]
  Actuator5-52 Sea Level	[E-0552 1:7 055200A]
  Actuator5-52 Up Limit	[E-0552 2:0 0552016]
  Actuator5-52 Driver Alarm	[E-0552 2:1 0552015]
  Actuator5-52 Error Alarm	[E-0552 2:2 0552014]
  Actuator5-52 Over Current	[E-0552 2:3 0552013]
  Actuator5-52 Over Speed	[E-0552 2:4 0552012]
  Actuator5-52 Over Load	[E-0552 2:5 0552011]
  Actu