/* shm-interface.h: I/F between POSIX shared memories, as well as regular files, and InstrumentStatus */
/*

Copyright (C) 2005 by Daigo Tomono <tomono at subaru.naoj.org>

Permission is granted for use, copying, modification, distribution,
and distribution of modified versions of this work under the terms of
GPL version 2 or later.

*/

#ifndef SHM_INTERFACE_H
#define SHM_INTERFACE_H
#include <melco/tsc-message.h>

/* name of the POSIX shared memory object: e.g. `/00A1E' */
/* size of dst has to be >= MELCO_TREE_MAX_WORD_LENGTH + 2 */
char *instrumentstatus_shm_name(char *dst, const char *type, const unsigned int shortid);

/* unlink the shared memory object, returns 0 if error, 1 if success */
int instrumentstatus_shm_unlink(const char *type, const unsigned int shortid);
/* returns number of segments destroyed or -1 for an error */
int instrumentstatus_shm_unlink_all(void);
int instrumentstatus_file_unlink_all(const char *rootdir);

/* write to the shared memory, returns mapped addr or NULL if error */
InstrumentStatus* InstrumentStatus_to_shm(InstrumentStatus *self);

/* scan through the message and register inst statuses to shared memories */
/* returns -1 for an error, number of statuses othewise */
int MonitorDataMessage_scan_to_shm(MonitorDataMessage* self, scan_option_t opt);
int MonitorDataMessage_scan_to_file(MonitorDataMessage* self, scan_option_t opt, const char *rootdir);

/* read from the shared memory, returns dst or NULL if error */
InstrumentStatus* shm_get_instrument(const char *type, const unsigned int shortid);
StatusEntry* shm_get_status_entry(const char *keyword);
StatusEntry* file_get_status_entry(const char *keyword, const char *rootdir);

/* unmap the shared memories, returns number of segments unmapped */
int instrumentstatus_shm_unmap_all(void);
int instrumentstatus_file_unmap_all(const char *rootdir);

#endif	/* SHM_INTERFACE_H */
