#!/usr/bin/env python
# vim: set ts=2 sw=2 ai noet:
#
# usage: maketranslation.py legacy-dir predefined-solver csv-files
#
# Copyright (C) 2005 by Daigo Tomono <tomono at subaru.naoj.org>
#
# Permission is granted for use, copying, modification, distribution,
# and distribution of modified versions of this work under the terms of
# GPL version 2 or later.
#

import sys
import glob

import statusentry
import readlegacy

# main
if __name__ == "__main__":
	legacydir = sys.argv[1]
	predefined_solver = sys.argv[2]
	csvfiles = sys.argv[3:]
	dict = {}

	# legacy keywords
	sys.stderr.write('reading legacy headers...\n')
	legacy = []
	types = {
		'L':glob.glob( legacydir + '/*long*.h' )[0],
		'S':glob.glob( legacydir + '/*short*.h' )[0],
		'E':glob.glob( legacydir + '/*vstat*.h' )[0]
	}
	for type in types.keys():
		path = types[type]
		for shortid, data in readlegacy.SwigHeader(type, path).shortids():
			for entry in data.entries():
				legacy.append(entry)
#				if entry.shortid.find('00B2') == 0:
#					sys.stderr.write("legacy %s:%s:%s:%s:%s\n" % (entry.name, entry.type, entry.shortid, entry.byteoffset, entry.bitoffset))

	# current keywords
	sys.stderr.write('reading CSV files...\n')
	current = statusentry.TelStatusEntries()
	for csvfile in csvfiles:
		for e in statusentry.TelStatusCsv(csvfile).parse():
			if 'E' == e.type and e.shortid.find('00B2') == 0:
				e.shortid = '00B2'	# why?
			current.append(e)
	current.append_dummy('L', '0051')
	current.namespace.read_predefined(predefined_solver)
	current.namespace.solve_collisions()
#	for entry in current.to_a():
#		if entry.shortid.find('002A') == 0:
#			sys.stderr.write("current %s:%s:%s:%s:%s\n" % (entry.name, entry.type, entry.shortid, entry.byteoffset, entry.bitoffset))

	# match the entries
	sys.stderr.write('checking matches...\n')
	for old in legacy:
		if old.bitoffset < 0:
			if current.has_normaldata(old.type, old.shortid, old.byteoffset):
				dict[old.name] = (old, current.entry_at(old.type, old.shortid, old.byteoffset)['normaldata'])
			else:
				dict[old.name] = (old, None)
		else:
			if current.has_bitfield(old.type, old.shortid, old.byteoffset, old.bitoffset):
				dict[old.name] = (old, current.entry_at(old.type, old.shortid, old.byteoffset)[old.bitoffset])
			else:
				sys.stderr.write("%s:%s:%s:%s:%s not found in current entries!\n" % (old.name, old.type, old.shortid, old.byteoffset, old.bitoffset))

	# output
	print "#legacy_name\tcurrent name"
	old_names = dict.keys()
	old_names.sort()
	for old_name in old_names:
		if dict[old_name][1]:
			try:
				name = dict[old_name][1].name_wo_collision
			except AttributeError:
				name = dict[old_name][1].name
		else:
			name = '-NA-'
		print "%s\t%s" % (old_name, name)
